<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "Consultainfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$Consulta_list = NULL; // Initialize page object first

class cConsulta_list extends cConsulta {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{612F4CEC-277D-477B-ABAC-2B8738F52202}";

	// Table name
	var $TableName = 'Consulta';

	// Page object name
	var $PageObjName = 'Consulta_list';

	// Grid form hidden field names
	var $FormName = 'fConsultalist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (Consulta)
		if (!isset($GLOBALS["Consulta"]) || get_class($GLOBALS["Consulta"]) == "cConsulta") {
			$GLOBALS["Consulta"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Consulta"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "Consultaadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "Consultadelete.php";
		$this->MultiUpdateUrl = "Consultaupdate.php";

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'Consulta', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fConsultalistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $Consulta;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($Consulta);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Restore filter list
			$this->RestoreFilterList();

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Num_factura->AdvancedSearch->ToJSON(), ","); // Field Num_factura
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_prestador->AdvancedSearch->ToJSON(), ","); // Field Codigo_prestador
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_id_usuario->AdvancedSearch->ToJSON(), ","); // Field Tipo_id_usuario
		$sFilterList = ew_Concat($sFilterList, $this->Numero_id_usuario->AdvancedSearch->ToJSON(), ","); // Field Numero_id_usuario
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_consulta->AdvancedSearch->ToJSON(), ","); // Field Fecha_consulta
		$sFilterList = ew_Concat($sFilterList, $this->Numero_autorizacion->AdvancedSearch->ToJSON(), ","); // Field Numero_autorizacion
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_consulta->AdvancedSearch->ToJSON(), ","); // Field Codigo_consulta
		$sFilterList = ew_Concat($sFilterList, $this->Finalidad_consulta->AdvancedSearch->ToJSON(), ","); // Field Finalidad_consulta
		$sFilterList = ew_Concat($sFilterList, $this->Causa_externa->AdvancedSearch->ToJSON(), ","); // Field Causa_externa
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_diagnostico->AdvancedSearch->ToJSON(), ","); // Field Codigo_diagnostico
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_diagnostico_rel1->AdvancedSearch->ToJSON(), ","); // Field Codigo_diagnostico_rel1
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_diagnostico_rel2->AdvancedSearch->ToJSON(), ","); // Field Codigo_diagnostico_rel2
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_diagnostico_rel3->AdvancedSearch->ToJSON(), ","); // Field Codigo_diagnostico_rel3
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_diagnostico_principal->AdvancedSearch->ToJSON(), ","); // Field Tipo_diagnostico_principal
		$sFilterList = ew_Concat($sFilterList, $this->Valor_consulta->AdvancedSearch->ToJSON(), ","); // Field Valor_consulta
		$sFilterList = ew_Concat($sFilterList, $this->Valor_cuota_mod->AdvancedSearch->ToJSON(), ","); // Field Valor_cuota_mod
		$sFilterList = ew_Concat($sFilterList, $this->Valor_neto->AdvancedSearch->ToJSON(), ","); // Field Valor_neto
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Num_factura
		$this->Num_factura->AdvancedSearch->SearchValue = @$filter["x_Num_factura"];
		$this->Num_factura->AdvancedSearch->SearchOperator = @$filter["z_Num_factura"];
		$this->Num_factura->AdvancedSearch->SearchCondition = @$filter["v_Num_factura"];
		$this->Num_factura->AdvancedSearch->SearchValue2 = @$filter["y_Num_factura"];
		$this->Num_factura->AdvancedSearch->SearchOperator2 = @$filter["w_Num_factura"];
		$this->Num_factura->AdvancedSearch->Save();

		// Field Codigo_prestador
		$this->Codigo_prestador->AdvancedSearch->SearchValue = @$filter["x_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchOperator = @$filter["z_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchCondition = @$filter["v_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->Save();

		// Field Tipo_id_usuario
		$this->Tipo_id_usuario->AdvancedSearch->SearchValue = @$filter["x_Tipo_id_usuario"];
		$this->Tipo_id_usuario->AdvancedSearch->SearchOperator = @$filter["z_Tipo_id_usuario"];
		$this->Tipo_id_usuario->AdvancedSearch->SearchCondition = @$filter["v_Tipo_id_usuario"];
		$this->Tipo_id_usuario->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_id_usuario"];
		$this->Tipo_id_usuario->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_id_usuario"];
		$this->Tipo_id_usuario->AdvancedSearch->Save();

		// Field Numero_id_usuario
		$this->Numero_id_usuario->AdvancedSearch->SearchValue = @$filter["x_Numero_id_usuario"];
		$this->Numero_id_usuario->AdvancedSearch->SearchOperator = @$filter["z_Numero_id_usuario"];
		$this->Numero_id_usuario->AdvancedSearch->SearchCondition = @$filter["v_Numero_id_usuario"];
		$this->Numero_id_usuario->AdvancedSearch->SearchValue2 = @$filter["y_Numero_id_usuario"];
		$this->Numero_id_usuario->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_id_usuario"];
		$this->Numero_id_usuario->AdvancedSearch->Save();

		// Field Fecha_consulta
		$this->Fecha_consulta->AdvancedSearch->SearchValue = @$filter["x_Fecha_consulta"];
		$this->Fecha_consulta->AdvancedSearch->SearchOperator = @$filter["z_Fecha_consulta"];
		$this->Fecha_consulta->AdvancedSearch->SearchCondition = @$filter["v_Fecha_consulta"];
		$this->Fecha_consulta->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_consulta"];
		$this->Fecha_consulta->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_consulta"];
		$this->Fecha_consulta->AdvancedSearch->Save();

		// Field Numero_autorizacion
		$this->Numero_autorizacion->AdvancedSearch->SearchValue = @$filter["x_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchOperator = @$filter["z_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchCondition = @$filter["v_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchValue2 = @$filter["y_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->Save();

		// Field Codigo_consulta
		$this->Codigo_consulta->AdvancedSearch->SearchValue = @$filter["x_Codigo_consulta"];
		$this->Codigo_consulta->AdvancedSearch->SearchOperator = @$filter["z_Codigo_consulta"];
		$this->Codigo_consulta->AdvancedSearch->SearchCondition = @$filter["v_Codigo_consulta"];
		$this->Codigo_consulta->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_consulta"];
		$this->Codigo_consulta->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_consulta"];
		$this->Codigo_consulta->AdvancedSearch->Save();

		// Field Finalidad_consulta
		$this->Finalidad_consulta->AdvancedSearch->SearchValue = @$filter["x_Finalidad_consulta"];
		$this->Finalidad_consulta->AdvancedSearch->SearchOperator = @$filter["z_Finalidad_consulta"];
		$this->Finalidad_consulta->AdvancedSearch->SearchCondition = @$filter["v_Finalidad_consulta"];
		$this->Finalidad_consulta->AdvancedSearch->SearchValue2 = @$filter["y_Finalidad_consulta"];
		$this->Finalidad_consulta->AdvancedSearch->SearchOperator2 = @$filter["w_Finalidad_consulta"];
		$this->Finalidad_consulta->AdvancedSearch->Save();

		// Field Causa_externa
		$this->Causa_externa->AdvancedSearch->SearchValue = @$filter["x_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchOperator = @$filter["z_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchCondition = @$filter["v_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchValue2 = @$filter["y_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchOperator2 = @$filter["w_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->Save();

		// Field Codigo_diagnostico
		$this->Codigo_diagnostico->AdvancedSearch->SearchValue = @$filter["x_Codigo_diagnostico"];
		$this->Codigo_diagnostico->AdvancedSearch->SearchOperator = @$filter["z_Codigo_diagnostico"];
		$this->Codigo_diagnostico->AdvancedSearch->SearchCondition = @$filter["v_Codigo_diagnostico"];
		$this->Codigo_diagnostico->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_diagnostico"];
		$this->Codigo_diagnostico->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_diagnostico"];
		$this->Codigo_diagnostico->AdvancedSearch->Save();

		// Field Codigo_diagnostico_rel1
		$this->Codigo_diagnostico_rel1->AdvancedSearch->SearchValue = @$filter["x_Codigo_diagnostico_rel1"];
		$this->Codigo_diagnostico_rel1->AdvancedSearch->SearchOperator = @$filter["z_Codigo_diagnostico_rel1"];
		$this->Codigo_diagnostico_rel1->AdvancedSearch->SearchCondition = @$filter["v_Codigo_diagnostico_rel1"];
		$this->Codigo_diagnostico_rel1->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_diagnostico_rel1"];
		$this->Codigo_diagnostico_rel1->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_diagnostico_rel1"];
		$this->Codigo_diagnostico_rel1->AdvancedSearch->Save();

		// Field Codigo_diagnostico_rel2
		$this->Codigo_diagnostico_rel2->AdvancedSearch->SearchValue = @$filter["x_Codigo_diagnostico_rel2"];
		$this->Codigo_diagnostico_rel2->AdvancedSearch->SearchOperator = @$filter["z_Codigo_diagnostico_rel2"];
		$this->Codigo_diagnostico_rel2->AdvancedSearch->SearchCondition = @$filter["v_Codigo_diagnostico_rel2"];
		$this->Codigo_diagnostico_rel2->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_diagnostico_rel2"];
		$this->Codigo_diagnostico_rel2->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_diagnostico_rel2"];
		$this->Codigo_diagnostico_rel2->AdvancedSearch->Save();

		// Field Codigo_diagnostico_rel3
		$this->Codigo_diagnostico_rel3->AdvancedSearch->SearchValue = @$filter["x_Codigo_diagnostico_rel3"];
		$this->Codigo_diagnostico_rel3->AdvancedSearch->SearchOperator = @$filter["z_Codigo_diagnostico_rel3"];
		$this->Codigo_diagnostico_rel3->AdvancedSearch->SearchCondition = @$filter["v_Codigo_diagnostico_rel3"];
		$this->Codigo_diagnostico_rel3->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_diagnostico_rel3"];
		$this->Codigo_diagnostico_rel3->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_diagnostico_rel3"];
		$this->Codigo_diagnostico_rel3->AdvancedSearch->Save();

		// Field Tipo_diagnostico_principal
		$this->Tipo_diagnostico_principal->AdvancedSearch->SearchValue = @$filter["x_Tipo_diagnostico_principal"];
		$this->Tipo_diagnostico_principal->AdvancedSearch->SearchOperator = @$filter["z_Tipo_diagnostico_principal"];
		$this->Tipo_diagnostico_principal->AdvancedSearch->SearchCondition = @$filter["v_Tipo_diagnostico_principal"];
		$this->Tipo_diagnostico_principal->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_diagnostico_principal"];
		$this->Tipo_diagnostico_principal->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_diagnostico_principal"];
		$this->Tipo_diagnostico_principal->AdvancedSearch->Save();

		// Field Valor_consulta
		$this->Valor_consulta->AdvancedSearch->SearchValue = @$filter["x_Valor_consulta"];
		$this->Valor_consulta->AdvancedSearch->SearchOperator = @$filter["z_Valor_consulta"];
		$this->Valor_consulta->AdvancedSearch->SearchCondition = @$filter["v_Valor_consulta"];
		$this->Valor_consulta->AdvancedSearch->SearchValue2 = @$filter["y_Valor_consulta"];
		$this->Valor_consulta->AdvancedSearch->SearchOperator2 = @$filter["w_Valor_consulta"];
		$this->Valor_consulta->AdvancedSearch->Save();

		// Field Valor_cuota_mod
		$this->Valor_cuota_mod->AdvancedSearch->SearchValue = @$filter["x_Valor_cuota_mod"];
		$this->Valor_cuota_mod->AdvancedSearch->SearchOperator = @$filter["z_Valor_cuota_mod"];
		$this->Valor_cuota_mod->AdvancedSearch->SearchCondition = @$filter["v_Valor_cuota_mod"];
		$this->Valor_cuota_mod->AdvancedSearch->SearchValue2 = @$filter["y_Valor_cuota_mod"];
		$this->Valor_cuota_mod->AdvancedSearch->SearchOperator2 = @$filter["w_Valor_cuota_mod"];
		$this->Valor_cuota_mod->AdvancedSearch->Save();

		// Field Valor_neto
		$this->Valor_neto->AdvancedSearch->SearchValue = @$filter["x_Valor_neto"];
		$this->Valor_neto->AdvancedSearch->SearchOperator = @$filter["z_Valor_neto"];
		$this->Valor_neto->AdvancedSearch->SearchCondition = @$filter["v_Valor_neto"];
		$this->Valor_neto->AdvancedSearch->SearchValue2 = @$filter["y_Valor_neto"];
		$this->Valor_neto->AdvancedSearch->SearchOperator2 = @$filter["w_Valor_neto"];
		$this->Valor_neto->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Num_factura, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_prestador, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Tipo_id_usuario, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_id_usuario, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Fecha_consulta, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_diagnostico, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_diagnostico_rel1, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_diagnostico_rel2, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_diagnostico_rel3, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Valor_consulta, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Valor_cuota_mod, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Valor_neto, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Num_factura); // Num_factura
			$this->UpdateSort($this->Codigo_prestador); // Codigo_prestador
			$this->UpdateSort($this->Tipo_id_usuario); // Tipo_id_usuario
			$this->UpdateSort($this->Numero_id_usuario); // Numero_id_usuario
			$this->UpdateSort($this->Fecha_consulta); // Fecha_consulta
			$this->UpdateSort($this->Numero_autorizacion); // Numero_autorizacion
			$this->UpdateSort($this->Codigo_consulta); // Codigo_consulta
			$this->UpdateSort($this->Finalidad_consulta); // Finalidad_consulta
			$this->UpdateSort($this->Causa_externa); // Causa_externa
			$this->UpdateSort($this->Codigo_diagnostico); // Codigo_diagnostico
			$this->UpdateSort($this->Codigo_diagnostico_rel1); // Codigo_diagnostico_rel1
			$this->UpdateSort($this->Codigo_diagnostico_rel2); // Codigo_diagnostico_rel2
			$this->UpdateSort($this->Codigo_diagnostico_rel3); // Codigo_diagnostico_rel3
			$this->UpdateSort($this->Tipo_diagnostico_principal); // Tipo_diagnostico_principal
			$this->UpdateSort($this->Valor_consulta); // Valor_consulta
			$this->UpdateSort($this->Valor_cuota_mod); // Valor_cuota_mod
			$this->UpdateSort($this->Valor_neto); // Valor_neto
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Num_factura->setSort("");
				$this->Codigo_prestador->setSort("");
				$this->Tipo_id_usuario->setSort("");
				$this->Numero_id_usuario->setSort("");
				$this->Fecha_consulta->setSort("");
				$this->Numero_autorizacion->setSort("");
				$this->Codigo_consulta->setSort("");
				$this->Finalidad_consulta->setSort("");
				$this->Causa_externa->setSort("");
				$this->Codigo_diagnostico->setSort("");
				$this->Codigo_diagnostico_rel1->setSort("");
				$this->Codigo_diagnostico_rel2->setSort("");
				$this->Codigo_diagnostico_rel3->setSort("");
				$this->Tipo_diagnostico_principal->setSort("");
				$this->Valor_consulta->setSort("");
				$this->Valor_cuota_mod->setSort("");
				$this->Valor_neto->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fConsultalistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fConsultalistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fConsultalist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fConsultalistsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Num_factura->setDbValue($rs->fields('Num_factura'));
		$this->Codigo_prestador->setDbValue($rs->fields('Codigo_prestador'));
		$this->Tipo_id_usuario->setDbValue($rs->fields('Tipo_id_usuario'));
		$this->Numero_id_usuario->setDbValue($rs->fields('Numero_id_usuario'));
		$this->Fecha_consulta->setDbValue($rs->fields('Fecha_consulta'));
		$this->Numero_autorizacion->setDbValue($rs->fields('Numero_autorizacion'));
		$this->Codigo_consulta->setDbValue($rs->fields('Codigo_consulta'));
		$this->Finalidad_consulta->setDbValue($rs->fields('Finalidad_consulta'));
		$this->Causa_externa->setDbValue($rs->fields('Causa_externa'));
		$this->Codigo_diagnostico->setDbValue($rs->fields('Codigo_diagnostico'));
		$this->Codigo_diagnostico_rel1->setDbValue($rs->fields('Codigo_diagnostico_rel1'));
		$this->Codigo_diagnostico_rel2->setDbValue($rs->fields('Codigo_diagnostico_rel2'));
		$this->Codigo_diagnostico_rel3->setDbValue($rs->fields('Codigo_diagnostico_rel3'));
		$this->Tipo_diagnostico_principal->setDbValue($rs->fields('Tipo_diagnostico_principal'));
		$this->Valor_consulta->setDbValue($rs->fields('Valor_consulta'));
		$this->Valor_cuota_mod->setDbValue($rs->fields('Valor_cuota_mod'));
		$this->Valor_neto->setDbValue($rs->fields('Valor_neto'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Num_factura->DbValue = $row['Num_factura'];
		$this->Codigo_prestador->DbValue = $row['Codigo_prestador'];
		$this->Tipo_id_usuario->DbValue = $row['Tipo_id_usuario'];
		$this->Numero_id_usuario->DbValue = $row['Numero_id_usuario'];
		$this->Fecha_consulta->DbValue = $row['Fecha_consulta'];
		$this->Numero_autorizacion->DbValue = $row['Numero_autorizacion'];
		$this->Codigo_consulta->DbValue = $row['Codigo_consulta'];
		$this->Finalidad_consulta->DbValue = $row['Finalidad_consulta'];
		$this->Causa_externa->DbValue = $row['Causa_externa'];
		$this->Codigo_diagnostico->DbValue = $row['Codigo_diagnostico'];
		$this->Codigo_diagnostico_rel1->DbValue = $row['Codigo_diagnostico_rel1'];
		$this->Codigo_diagnostico_rel2->DbValue = $row['Codigo_diagnostico_rel2'];
		$this->Codigo_diagnostico_rel3->DbValue = $row['Codigo_diagnostico_rel3'];
		$this->Tipo_diagnostico_principal->DbValue = $row['Tipo_diagnostico_principal'];
		$this->Valor_consulta->DbValue = $row['Valor_consulta'];
		$this->Valor_cuota_mod->DbValue = $row['Valor_cuota_mod'];
		$this->Valor_neto->DbValue = $row['Valor_neto'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Num_factura
		// Codigo_prestador
		// Tipo_id_usuario
		// Numero_id_usuario
		// Fecha_consulta
		// Numero_autorizacion
		// Codigo_consulta
		// Finalidad_consulta
		// Causa_externa
		// Codigo_diagnostico
		// Codigo_diagnostico_rel1
		// Codigo_diagnostico_rel2
		// Codigo_diagnostico_rel3
		// Tipo_diagnostico_principal
		// Valor_consulta
		// Valor_cuota_mod
		// Valor_neto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Num_factura
		$this->Num_factura->ViewValue = $this->Num_factura->CurrentValue;
		$this->Num_factura->ViewCustomAttributes = "";

		// Codigo_prestador
		$this->Codigo_prestador->ViewValue = $this->Codigo_prestador->CurrentValue;
		$this->Codigo_prestador->ViewCustomAttributes = "";

		// Tipo_id_usuario
		$this->Tipo_id_usuario->ViewValue = $this->Tipo_id_usuario->CurrentValue;
		$this->Tipo_id_usuario->ViewCustomAttributes = "";

		// Numero_id_usuario
		$this->Numero_id_usuario->ViewValue = $this->Numero_id_usuario->CurrentValue;
		$this->Numero_id_usuario->ViewCustomAttributes = "";

		// Fecha_consulta
		$this->Fecha_consulta->ViewValue = $this->Fecha_consulta->CurrentValue;
		$this->Fecha_consulta->ViewCustomAttributes = "";

		// Numero_autorizacion
		$this->Numero_autorizacion->ViewValue = $this->Numero_autorizacion->CurrentValue;
		$this->Numero_autorizacion->ViewCustomAttributes = "";

		// Codigo_consulta
		$this->Codigo_consulta->ViewValue = $this->Codigo_consulta->CurrentValue;
		$this->Codigo_consulta->ViewCustomAttributes = "";

		// Finalidad_consulta
		$this->Finalidad_consulta->ViewValue = $this->Finalidad_consulta->CurrentValue;
		$this->Finalidad_consulta->ViewCustomAttributes = "";

		// Causa_externa
		$this->Causa_externa->ViewValue = $this->Causa_externa->CurrentValue;
		$this->Causa_externa->ViewCustomAttributes = "";

		// Codigo_diagnostico
		$this->Codigo_diagnostico->ViewValue = $this->Codigo_diagnostico->CurrentValue;
		$this->Codigo_diagnostico->ViewCustomAttributes = "";

		// Codigo_diagnostico_rel1
		$this->Codigo_diagnostico_rel1->ViewValue = $this->Codigo_diagnostico_rel1->CurrentValue;
		$this->Codigo_diagnostico_rel1->ViewCustomAttributes = "";

		// Codigo_diagnostico_rel2
		$this->Codigo_diagnostico_rel2->ViewValue = $this->Codigo_diagnostico_rel2->CurrentValue;
		$this->Codigo_diagnostico_rel2->ViewCustomAttributes = "";

		// Codigo_diagnostico_rel3
		$this->Codigo_diagnostico_rel3->ViewValue = $this->Codigo_diagnostico_rel3->CurrentValue;
		$this->Codigo_diagnostico_rel3->ViewCustomAttributes = "";

		// Tipo_diagnostico_principal
		$this->Tipo_diagnostico_principal->ViewValue = $this->Tipo_diagnostico_principal->CurrentValue;
		$this->Tipo_diagnostico_principal->ViewCustomAttributes = "";

		// Valor_consulta
		$this->Valor_consulta->ViewValue = $this->Valor_consulta->CurrentValue;
		$this->Valor_consulta->ViewCustomAttributes = "";

		// Valor_cuota_mod
		$this->Valor_cuota_mod->ViewValue = $this->Valor_cuota_mod->CurrentValue;
		$this->Valor_cuota_mod->ViewCustomAttributes = "";

		// Valor_neto
		$this->Valor_neto->ViewValue = $this->Valor_neto->CurrentValue;
		$this->Valor_neto->ViewCustomAttributes = "";

			// Num_factura
			$this->Num_factura->LinkCustomAttributes = "";
			$this->Num_factura->HrefValue = "";
			$this->Num_factura->TooltipValue = "";

			// Codigo_prestador
			$this->Codigo_prestador->LinkCustomAttributes = "";
			$this->Codigo_prestador->HrefValue = "";
			$this->Codigo_prestador->TooltipValue = "";

			// Tipo_id_usuario
			$this->Tipo_id_usuario->LinkCustomAttributes = "";
			$this->Tipo_id_usuario->HrefValue = "";
			$this->Tipo_id_usuario->TooltipValue = "";

			// Numero_id_usuario
			$this->Numero_id_usuario->LinkCustomAttributes = "";
			$this->Numero_id_usuario->HrefValue = "";
			$this->Numero_id_usuario->TooltipValue = "";

			// Fecha_consulta
			$this->Fecha_consulta->LinkCustomAttributes = "";
			$this->Fecha_consulta->HrefValue = "";
			$this->Fecha_consulta->TooltipValue = "";

			// Numero_autorizacion
			$this->Numero_autorizacion->LinkCustomAttributes = "";
			$this->Numero_autorizacion->HrefValue = "";
			$this->Numero_autorizacion->TooltipValue = "";

			// Codigo_consulta
			$this->Codigo_consulta->LinkCustomAttributes = "";
			$this->Codigo_consulta->HrefValue = "";
			$this->Codigo_consulta->TooltipValue = "";

			// Finalidad_consulta
			$this->Finalidad_consulta->LinkCustomAttributes = "";
			$this->Finalidad_consulta->HrefValue = "";
			$this->Finalidad_consulta->TooltipValue = "";

			// Causa_externa
			$this->Causa_externa->LinkCustomAttributes = "";
			$this->Causa_externa->HrefValue = "";
			$this->Causa_externa->TooltipValue = "";

			// Codigo_diagnostico
			$this->Codigo_diagnostico->LinkCustomAttributes = "";
			$this->Codigo_diagnostico->HrefValue = "";
			$this->Codigo_diagnostico->TooltipValue = "";

			// Codigo_diagnostico_rel1
			$this->Codigo_diagnostico_rel1->LinkCustomAttributes = "";
			$this->Codigo_diagnostico_rel1->HrefValue = "";
			$this->Codigo_diagnostico_rel1->TooltipValue = "";

			// Codigo_diagnostico_rel2
			$this->Codigo_diagnostico_rel2->LinkCustomAttributes = "";
			$this->Codigo_diagnostico_rel2->HrefValue = "";
			$this->Codigo_diagnostico_rel2->TooltipValue = "";

			// Codigo_diagnostico_rel3
			$this->Codigo_diagnostico_rel3->LinkCustomAttributes = "";
			$this->Codigo_diagnostico_rel3->HrefValue = "";
			$this->Codigo_diagnostico_rel3->TooltipValue = "";

			// Tipo_diagnostico_principal
			$this->Tipo_diagnostico_principal->LinkCustomAttributes = "";
			$this->Tipo_diagnostico_principal->HrefValue = "";
			$this->Tipo_diagnostico_principal->TooltipValue = "";

			// Valor_consulta
			$this->Valor_consulta->LinkCustomAttributes = "";
			$this->Valor_consulta->HrefValue = "";
			$this->Valor_consulta->TooltipValue = "";

			// Valor_cuota_mod
			$this->Valor_cuota_mod->LinkCustomAttributes = "";
			$this->Valor_cuota_mod->HrefValue = "";
			$this->Valor_cuota_mod->TooltipValue = "";

			// Valor_neto
			$this->Valor_neto->LinkCustomAttributes = "";
			$this->Valor_neto->HrefValue = "";
			$this->Valor_neto->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($Consulta_list)) $Consulta_list = new cConsulta_list();

// Page init
$Consulta_list->Page_Init();

// Page main
$Consulta_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Consulta_list->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fConsultalist = new ew_Form("fConsultalist", "list");
fConsultalist.FormKeyCountName = '<?php echo $Consulta_list->FormKeyCountName ?>';

// Form_CustomValidate event
fConsultalist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fConsultalist.ValidateRequired = true;
<?php } else { ?>
fConsultalist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

var CurrentSearchForm = fConsultalistsrch = new ew_Form("fConsultalistsrch");
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php if ($Consulta_list->TotalRecs > 0 && $Consulta_list->ExportOptions->Visible()) { ?>
<?php $Consulta_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($Consulta_list->SearchOptions->Visible()) { ?>
<?php $Consulta_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($Consulta_list->FilterOptions->Visible()) { ?>
<?php $Consulta_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php
	$bSelectLimit = $Consulta_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($Consulta_list->TotalRecs <= 0)
			$Consulta_list->TotalRecs = $Consulta->SelectRecordCount();
	} else {
		if (!$Consulta_list->Recordset && ($Consulta_list->Recordset = $Consulta_list->LoadRecordset()))
			$Consulta_list->TotalRecs = $Consulta_list->Recordset->RecordCount();
	}
	$Consulta_list->StartRec = 1;
	if ($Consulta_list->DisplayRecs <= 0 || ($Consulta->Export <> "" && $Consulta->ExportAll)) // Display all records
		$Consulta_list->DisplayRecs = $Consulta_list->TotalRecs;
	if (!($Consulta->Export <> "" && $Consulta->ExportAll))
		$Consulta_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$Consulta_list->Recordset = $Consulta_list->LoadRecordset($Consulta_list->StartRec-1, $Consulta_list->DisplayRecs);

	// Set no record found message
	if ($Consulta->CurrentAction == "" && $Consulta_list->TotalRecs == 0) {
		if ($Consulta_list->SearchWhere == "0=101")
			$Consulta_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$Consulta_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$Consulta_list->RenderOtherOptions();
?>
<?php if ($Consulta->Export == "" && $Consulta->CurrentAction == "") { ?>
<form name="fConsultalistsrch" id="fConsultalistsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($Consulta_list->SearchWhere <> "") ? " in" : " in"; ?>
<div id="fConsultalistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="Consulta">
	<div class="ewBasicSearch">
<div id="xsr_1" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($Consulta_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($Consulta_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $Consulta_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($Consulta_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($Consulta_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($Consulta_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($Consulta_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php $Consulta_list->ShowPageHeader(); ?>
<?php
$Consulta_list->ShowMessage();
?>
<?php if ($Consulta_list->TotalRecs > 0 || $Consulta->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<form name="fConsultalist" id="fConsultalist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($Consulta_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $Consulta_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="Consulta">
<div id="gmp_Consulta" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($Consulta_list->TotalRecs > 0) { ?>
<table id="tbl_Consultalist" class="table ewTable">
<?php echo $Consulta->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$Consulta_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$Consulta_list->RenderListOptions();

// Render list options (header, left)
$Consulta_list->ListOptions->Render("header", "left");
?>
<?php if ($Consulta->Num_factura->Visible) { // Num_factura ?>
	<?php if ($Consulta->SortUrl($Consulta->Num_factura) == "") { ?>
		<th data-name="Num_factura"><div id="elh_Consulta_Num_factura" class="Consulta_Num_factura"><div class="ewTableHeaderCaption"><?php echo $Consulta->Num_factura->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Num_factura"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Num_factura) ?>',1);"><div id="elh_Consulta_Num_factura" class="Consulta_Num_factura">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Num_factura->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Num_factura->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Num_factura->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Codigo_prestador->Visible) { // Codigo_prestador ?>
	<?php if ($Consulta->SortUrl($Consulta->Codigo_prestador) == "") { ?>
		<th data-name="Codigo_prestador"><div id="elh_Consulta_Codigo_prestador" class="Consulta_Codigo_prestador"><div class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_prestador->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_prestador"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Codigo_prestador) ?>',1);"><div id="elh_Consulta_Codigo_prestador" class="Consulta_Codigo_prestador">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_prestador->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Codigo_prestador->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Codigo_prestador->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Tipo_id_usuario->Visible) { // Tipo_id_usuario ?>
	<?php if ($Consulta->SortUrl($Consulta->Tipo_id_usuario) == "") { ?>
		<th data-name="Tipo_id_usuario"><div id="elh_Consulta_Tipo_id_usuario" class="Consulta_Tipo_id_usuario"><div class="ewTableHeaderCaption"><?php echo $Consulta->Tipo_id_usuario->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tipo_id_usuario"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Tipo_id_usuario) ?>',1);"><div id="elh_Consulta_Tipo_id_usuario" class="Consulta_Tipo_id_usuario">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Tipo_id_usuario->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Tipo_id_usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Tipo_id_usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Numero_id_usuario->Visible) { // Numero_id_usuario ?>
	<?php if ($Consulta->SortUrl($Consulta->Numero_id_usuario) == "") { ?>
		<th data-name="Numero_id_usuario"><div id="elh_Consulta_Numero_id_usuario" class="Consulta_Numero_id_usuario"><div class="ewTableHeaderCaption"><?php echo $Consulta->Numero_id_usuario->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_id_usuario"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Numero_id_usuario) ?>',1);"><div id="elh_Consulta_Numero_id_usuario" class="Consulta_Numero_id_usuario">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Numero_id_usuario->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Numero_id_usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Numero_id_usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Fecha_consulta->Visible) { // Fecha_consulta ?>
	<?php if ($Consulta->SortUrl($Consulta->Fecha_consulta) == "") { ?>
		<th data-name="Fecha_consulta"><div id="elh_Consulta_Fecha_consulta" class="Consulta_Fecha_consulta"><div class="ewTableHeaderCaption"><?php echo $Consulta->Fecha_consulta->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_consulta"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Fecha_consulta) ?>',1);"><div id="elh_Consulta_Fecha_consulta" class="Consulta_Fecha_consulta">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Fecha_consulta->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Fecha_consulta->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Fecha_consulta->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Numero_autorizacion->Visible) { // Numero_autorizacion ?>
	<?php if ($Consulta->SortUrl($Consulta->Numero_autorizacion) == "") { ?>
		<th data-name="Numero_autorizacion"><div id="elh_Consulta_Numero_autorizacion" class="Consulta_Numero_autorizacion"><div class="ewTableHeaderCaption"><?php echo $Consulta->Numero_autorizacion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_autorizacion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Numero_autorizacion) ?>',1);"><div id="elh_Consulta_Numero_autorizacion" class="Consulta_Numero_autorizacion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Numero_autorizacion->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Numero_autorizacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Numero_autorizacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Codigo_consulta->Visible) { // Codigo_consulta ?>
	<?php if ($Consulta->SortUrl($Consulta->Codigo_consulta) == "") { ?>
		<th data-name="Codigo_consulta"><div id="elh_Consulta_Codigo_consulta" class="Consulta_Codigo_consulta"><div class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_consulta->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_consulta"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Codigo_consulta) ?>',1);"><div id="elh_Consulta_Codigo_consulta" class="Consulta_Codigo_consulta">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_consulta->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Codigo_consulta->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Codigo_consulta->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Finalidad_consulta->Visible) { // Finalidad_consulta ?>
	<?php if ($Consulta->SortUrl($Consulta->Finalidad_consulta) == "") { ?>
		<th data-name="Finalidad_consulta"><div id="elh_Consulta_Finalidad_consulta" class="Consulta_Finalidad_consulta"><div class="ewTableHeaderCaption"><?php echo $Consulta->Finalidad_consulta->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Finalidad_consulta"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Finalidad_consulta) ?>',1);"><div id="elh_Consulta_Finalidad_consulta" class="Consulta_Finalidad_consulta">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Finalidad_consulta->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Finalidad_consulta->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Finalidad_consulta->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Causa_externa->Visible) { // Causa_externa ?>
	<?php if ($Consulta->SortUrl($Consulta->Causa_externa) == "") { ?>
		<th data-name="Causa_externa"><div id="elh_Consulta_Causa_externa" class="Consulta_Causa_externa"><div class="ewTableHeaderCaption"><?php echo $Consulta->Causa_externa->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Causa_externa"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Causa_externa) ?>',1);"><div id="elh_Consulta_Causa_externa" class="Consulta_Causa_externa">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Causa_externa->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Causa_externa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Causa_externa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Codigo_diagnostico->Visible) { // Codigo_diagnostico ?>
	<?php if ($Consulta->SortUrl($Consulta->Codigo_diagnostico) == "") { ?>
		<th data-name="Codigo_diagnostico"><div id="elh_Consulta_Codigo_diagnostico" class="Consulta_Codigo_diagnostico"><div class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_diagnostico"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Codigo_diagnostico) ?>',1);"><div id="elh_Consulta_Codigo_diagnostico" class="Consulta_Codigo_diagnostico">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Codigo_diagnostico->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Codigo_diagnostico->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Codigo_diagnostico_rel1->Visible) { // Codigo_diagnostico_rel1 ?>
	<?php if ($Consulta->SortUrl($Consulta->Codigo_diagnostico_rel1) == "") { ?>
		<th data-name="Codigo_diagnostico_rel1"><div id="elh_Consulta_Codigo_diagnostico_rel1" class="Consulta_Codigo_diagnostico_rel1"><div class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico_rel1->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_diagnostico_rel1"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Codigo_diagnostico_rel1) ?>',1);"><div id="elh_Consulta_Codigo_diagnostico_rel1" class="Consulta_Codigo_diagnostico_rel1">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico_rel1->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Codigo_diagnostico_rel1->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Codigo_diagnostico_rel1->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Codigo_diagnostico_rel2->Visible) { // Codigo_diagnostico_rel2 ?>
	<?php if ($Consulta->SortUrl($Consulta->Codigo_diagnostico_rel2) == "") { ?>
		<th data-name="Codigo_diagnostico_rel2"><div id="elh_Consulta_Codigo_diagnostico_rel2" class="Consulta_Codigo_diagnostico_rel2"><div class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico_rel2->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_diagnostico_rel2"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Codigo_diagnostico_rel2) ?>',1);"><div id="elh_Consulta_Codigo_diagnostico_rel2" class="Consulta_Codigo_diagnostico_rel2">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico_rel2->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Codigo_diagnostico_rel2->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Codigo_diagnostico_rel2->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Codigo_diagnostico_rel3->Visible) { // Codigo_diagnostico_rel3 ?>
	<?php if ($Consulta->SortUrl($Consulta->Codigo_diagnostico_rel3) == "") { ?>
		<th data-name="Codigo_diagnostico_rel3"><div id="elh_Consulta_Codigo_diagnostico_rel3" class="Consulta_Codigo_diagnostico_rel3"><div class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico_rel3->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_diagnostico_rel3"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Codigo_diagnostico_rel3) ?>',1);"><div id="elh_Consulta_Codigo_diagnostico_rel3" class="Consulta_Codigo_diagnostico_rel3">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Codigo_diagnostico_rel3->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Codigo_diagnostico_rel3->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Codigo_diagnostico_rel3->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Tipo_diagnostico_principal->Visible) { // Tipo_diagnostico_principal ?>
	<?php if ($Consulta->SortUrl($Consulta->Tipo_diagnostico_principal) == "") { ?>
		<th data-name="Tipo_diagnostico_principal"><div id="elh_Consulta_Tipo_diagnostico_principal" class="Consulta_Tipo_diagnostico_principal"><div class="ewTableHeaderCaption"><?php echo $Consulta->Tipo_diagnostico_principal->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tipo_diagnostico_principal"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Tipo_diagnostico_principal) ?>',1);"><div id="elh_Consulta_Tipo_diagnostico_principal" class="Consulta_Tipo_diagnostico_principal">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Tipo_diagnostico_principal->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Tipo_diagnostico_principal->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Tipo_diagnostico_principal->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Valor_consulta->Visible) { // Valor_consulta ?>
	<?php if ($Consulta->SortUrl($Consulta->Valor_consulta) == "") { ?>
		<th data-name="Valor_consulta"><div id="elh_Consulta_Valor_consulta" class="Consulta_Valor_consulta"><div class="ewTableHeaderCaption"><?php echo $Consulta->Valor_consulta->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Valor_consulta"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Valor_consulta) ?>',1);"><div id="elh_Consulta_Valor_consulta" class="Consulta_Valor_consulta">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Valor_consulta->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Valor_consulta->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Valor_consulta->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Valor_cuota_mod->Visible) { // Valor_cuota_mod ?>
	<?php if ($Consulta->SortUrl($Consulta->Valor_cuota_mod) == "") { ?>
		<th data-name="Valor_cuota_mod"><div id="elh_Consulta_Valor_cuota_mod" class="Consulta_Valor_cuota_mod"><div class="ewTableHeaderCaption"><?php echo $Consulta->Valor_cuota_mod->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Valor_cuota_mod"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Valor_cuota_mod) ?>',1);"><div id="elh_Consulta_Valor_cuota_mod" class="Consulta_Valor_cuota_mod">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Valor_cuota_mod->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Valor_cuota_mod->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Valor_cuota_mod->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Consulta->Valor_neto->Visible) { // Valor_neto ?>
	<?php if ($Consulta->SortUrl($Consulta->Valor_neto) == "") { ?>
		<th data-name="Valor_neto"><div id="elh_Consulta_Valor_neto" class="Consulta_Valor_neto"><div class="ewTableHeaderCaption"><?php echo $Consulta->Valor_neto->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Valor_neto"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Consulta->SortUrl($Consulta->Valor_neto) ?>',1);"><div id="elh_Consulta_Valor_neto" class="Consulta_Valor_neto">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Consulta->Valor_neto->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Consulta->Valor_neto->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Consulta->Valor_neto->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$Consulta_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($Consulta->ExportAll && $Consulta->Export <> "") {
	$Consulta_list->StopRec = $Consulta_list->TotalRecs;
} else {

	// Set the last record to display
	if ($Consulta_list->TotalRecs > $Consulta_list->StartRec + $Consulta_list->DisplayRecs - 1)
		$Consulta_list->StopRec = $Consulta_list->StartRec + $Consulta_list->DisplayRecs - 1;
	else
		$Consulta_list->StopRec = $Consulta_list->TotalRecs;
}
$Consulta_list->RecCnt = $Consulta_list->StartRec - 1;
if ($Consulta_list->Recordset && !$Consulta_list->Recordset->EOF) {
	$Consulta_list->Recordset->MoveFirst();
	$bSelectLimit = $Consulta_list->UseSelectLimit;
	if (!$bSelectLimit && $Consulta_list->StartRec > 1)
		$Consulta_list->Recordset->Move($Consulta_list->StartRec - 1);
} elseif (!$Consulta->AllowAddDeleteRow && $Consulta_list->StopRec == 0) {
	$Consulta_list->StopRec = $Consulta->GridAddRowCount;
}

// Initialize aggregate
$Consulta->RowType = EW_ROWTYPE_AGGREGATEINIT;
$Consulta->ResetAttrs();
$Consulta_list->RenderRow();
while ($Consulta_list->RecCnt < $Consulta_list->StopRec) {
	$Consulta_list->RecCnt++;
	if (intval($Consulta_list->RecCnt) >= intval($Consulta_list->StartRec)) {
		$Consulta_list->RowCnt++;

		// Set up key count
		$Consulta_list->KeyCount = $Consulta_list->RowIndex;

		// Init row class and style
		$Consulta->ResetAttrs();
		$Consulta->CssClass = "";
		if ($Consulta->CurrentAction == "gridadd") {
		} else {
			$Consulta_list->LoadRowValues($Consulta_list->Recordset); // Load row values
		}
		$Consulta->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$Consulta->RowAttrs = array_merge($Consulta->RowAttrs, array('data-rowindex'=>$Consulta_list->RowCnt, 'id'=>'r' . $Consulta_list->RowCnt . '_Consulta', 'data-rowtype'=>$Consulta->RowType));

		// Render row
		$Consulta_list->RenderRow();

		// Render list options
		$Consulta_list->RenderListOptions();
?>
	<tr<?php echo $Consulta->RowAttributes() ?>>
<?php

// Render list options (body, left)
$Consulta_list->ListOptions->Render("body", "left", $Consulta_list->RowCnt);
?>
	<?php if ($Consulta->Num_factura->Visible) { // Num_factura ?>
		<td data-name="Num_factura"<?php echo $Consulta->Num_factura->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Num_factura" class="Consulta_Num_factura">
<span<?php echo $Consulta->Num_factura->ViewAttributes() ?>>
<?php echo $Consulta->Num_factura->ListViewValue() ?></span>
</span>
<a id="<?php echo $Consulta_list->PageObjName . "_row_" . $Consulta_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($Consulta->Codigo_prestador->Visible) { // Codigo_prestador ?>
		<td data-name="Codigo_prestador"<?php echo $Consulta->Codigo_prestador->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Codigo_prestador" class="Consulta_Codigo_prestador">
<span<?php echo $Consulta->Codigo_prestador->ViewAttributes() ?>>
<?php echo $Consulta->Codigo_prestador->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Tipo_id_usuario->Visible) { // Tipo_id_usuario ?>
		<td data-name="Tipo_id_usuario"<?php echo $Consulta->Tipo_id_usuario->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Tipo_id_usuario" class="Consulta_Tipo_id_usuario">
<span<?php echo $Consulta->Tipo_id_usuario->ViewAttributes() ?>>
<?php echo $Consulta->Tipo_id_usuario->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Numero_id_usuario->Visible) { // Numero_id_usuario ?>
		<td data-name="Numero_id_usuario"<?php echo $Consulta->Numero_id_usuario->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Numero_id_usuario" class="Consulta_Numero_id_usuario">
<span<?php echo $Consulta->Numero_id_usuario->ViewAttributes() ?>>
<?php echo $Consulta->Numero_id_usuario->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Fecha_consulta->Visible) { // Fecha_consulta ?>
		<td data-name="Fecha_consulta"<?php echo $Consulta->Fecha_consulta->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Fecha_consulta" class="Consulta_Fecha_consulta">
<span<?php echo $Consulta->Fecha_consulta->ViewAttributes() ?>>
<?php echo $Consulta->Fecha_consulta->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Numero_autorizacion->Visible) { // Numero_autorizacion ?>
		<td data-name="Numero_autorizacion"<?php echo $Consulta->Numero_autorizacion->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Numero_autorizacion" class="Consulta_Numero_autorizacion">
<span<?php echo $Consulta->Numero_autorizacion->ViewAttributes() ?>>
<?php echo $Consulta->Numero_autorizacion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Codigo_consulta->Visible) { // Codigo_consulta ?>
		<td data-name="Codigo_consulta"<?php echo $Consulta->Codigo_consulta->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Codigo_consulta" class="Consulta_Codigo_consulta">
<span<?php echo $Consulta->Codigo_consulta->ViewAttributes() ?>>
<?php echo $Consulta->Codigo_consulta->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Finalidad_consulta->Visible) { // Finalidad_consulta ?>
		<td data-name="Finalidad_consulta"<?php echo $Consulta->Finalidad_consulta->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Finalidad_consulta" class="Consulta_Finalidad_consulta">
<span<?php echo $Consulta->Finalidad_consulta->ViewAttributes() ?>>
<?php echo $Consulta->Finalidad_consulta->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Causa_externa->Visible) { // Causa_externa ?>
		<td data-name="Causa_externa"<?php echo $Consulta->Causa_externa->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Causa_externa" class="Consulta_Causa_externa">
<span<?php echo $Consulta->Causa_externa->ViewAttributes() ?>>
<?php echo $Consulta->Causa_externa->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Codigo_diagnostico->Visible) { // Codigo_diagnostico ?>
		<td data-name="Codigo_diagnostico"<?php echo $Consulta->Codigo_diagnostico->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Codigo_diagnostico" class="Consulta_Codigo_diagnostico">
<span<?php echo $Consulta->Codigo_diagnostico->ViewAttributes() ?>>
<?php echo $Consulta->Codigo_diagnostico->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Codigo_diagnostico_rel1->Visible) { // Codigo_diagnostico_rel1 ?>
		<td data-name="Codigo_diagnostico_rel1"<?php echo $Consulta->Codigo_diagnostico_rel1->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Codigo_diagnostico_rel1" class="Consulta_Codigo_diagnostico_rel1">
<span<?php echo $Consulta->Codigo_diagnostico_rel1->ViewAttributes() ?>>
<?php echo $Consulta->Codigo_diagnostico_rel1->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Codigo_diagnostico_rel2->Visible) { // Codigo_diagnostico_rel2 ?>
		<td data-name="Codigo_diagnostico_rel2"<?php echo $Consulta->Codigo_diagnostico_rel2->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Codigo_diagnostico_rel2" class="Consulta_Codigo_diagnostico_rel2">
<span<?php echo $Consulta->Codigo_diagnostico_rel2->ViewAttributes() ?>>
<?php echo $Consulta->Codigo_diagnostico_rel2->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Codigo_diagnostico_rel3->Visible) { // Codigo_diagnostico_rel3 ?>
		<td data-name="Codigo_diagnostico_rel3"<?php echo $Consulta->Codigo_diagnostico_rel3->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Codigo_diagnostico_rel3" class="Consulta_Codigo_diagnostico_rel3">
<span<?php echo $Consulta->Codigo_diagnostico_rel3->ViewAttributes() ?>>
<?php echo $Consulta->Codigo_diagnostico_rel3->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Tipo_diagnostico_principal->Visible) { // Tipo_diagnostico_principal ?>
		<td data-name="Tipo_diagnostico_principal"<?php echo $Consulta->Tipo_diagnostico_principal->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Tipo_diagnostico_principal" class="Consulta_Tipo_diagnostico_principal">
<span<?php echo $Consulta->Tipo_diagnostico_principal->ViewAttributes() ?>>
<?php echo $Consulta->Tipo_diagnostico_principal->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Valor_consulta->Visible) { // Valor_consulta ?>
		<td data-name="Valor_consulta"<?php echo $Consulta->Valor_consulta->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Valor_consulta" class="Consulta_Valor_consulta">
<span<?php echo $Consulta->Valor_consulta->ViewAttributes() ?>>
<?php echo $Consulta->Valor_consulta->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Valor_cuota_mod->Visible) { // Valor_cuota_mod ?>
		<td data-name="Valor_cuota_mod"<?php echo $Consulta->Valor_cuota_mod->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Valor_cuota_mod" class="Consulta_Valor_cuota_mod">
<span<?php echo $Consulta->Valor_cuota_mod->ViewAttributes() ?>>
<?php echo $Consulta->Valor_cuota_mod->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Consulta->Valor_neto->Visible) { // Valor_neto ?>
		<td data-name="Valor_neto"<?php echo $Consulta->Valor_neto->CellAttributes() ?>>
<span id="el<?php echo $Consulta_list->RowCnt ?>_Consulta_Valor_neto" class="Consulta_Valor_neto">
<span<?php echo $Consulta->Valor_neto->ViewAttributes() ?>>
<?php echo $Consulta->Valor_neto->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$Consulta_list->ListOptions->Render("body", "right", $Consulta_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($Consulta->CurrentAction <> "gridadd")
		$Consulta_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($Consulta->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($Consulta_list->Recordset)
	$Consulta_list->Recordset->Close();
?>
<div class="panel-footer ewGridLowerPanel">
<?php if ($Consulta->CurrentAction <> "gridadd" && $Consulta->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($Consulta_list->Pager)) $Consulta_list->Pager = new cPrevNextPager($Consulta_list->StartRec, $Consulta_list->DisplayRecs, $Consulta_list->TotalRecs) ?>
<?php if ($Consulta_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($Consulta_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $Consulta_list->PageUrl() ?>start=<?php echo $Consulta_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($Consulta_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $Consulta_list->PageUrl() ?>start=<?php echo $Consulta_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $Consulta_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($Consulta_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $Consulta_list->PageUrl() ?>start=<?php echo $Consulta_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($Consulta_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $Consulta_list->PageUrl() ?>start=<?php echo $Consulta_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $Consulta_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $Consulta_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $Consulta_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $Consulta_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($Consulta_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
</div>
<?php } ?>
<?php if ($Consulta_list->TotalRecs == 0 && $Consulta->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($Consulta_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<script type="text/javascript">
fConsultalistsrch.Init();
fConsultalistsrch.FilterList = <?php echo $Consulta_list->GetFilterList() ?>;
fConsultalist.Init();
</script>
<?php
$Consulta_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$Consulta_list->Page_Terminate();
?>
