<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "Hospitalizacioninfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$Hospitalizacion_list = NULL; // Initialize page object first

class cHospitalizacion_list extends cHospitalizacion {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{612F4CEC-277D-477B-ABAC-2B8738F52202}";

	// Table name
	var $TableName = 'Hospitalizacion';

	// Page object name
	var $PageObjName = 'Hospitalizacion_list';

	// Grid form hidden field names
	var $FormName = 'fHospitalizacionlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (Hospitalizacion)
		if (!isset($GLOBALS["Hospitalizacion"]) || get_class($GLOBALS["Hospitalizacion"]) == "cHospitalizacion") {
			$GLOBALS["Hospitalizacion"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Hospitalizacion"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "Hospitalizacionadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "Hospitalizaciondelete.php";
		$this->MultiUpdateUrl = "Hospitalizacionupdate.php";

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'Hospitalizacion', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fHospitalizacionlistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $Hospitalizacion;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($Hospitalizacion);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Restore filter list
			$this->RestoreFilterList();

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Numero_factura->AdvancedSearch->ToJSON(), ","); // Field Numero_factura
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_prestador->AdvancedSearch->ToJSON(), ","); // Field Codigo_prestador
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_id->AdvancedSearch->ToJSON(), ","); // Field Tipo_id
		$sFilterList = ew_Concat($sFilterList, $this->Numero_id->AdvancedSearch->ToJSON(), ","); // Field Numero_id
		$sFilterList = ew_Concat($sFilterList, $this->Via_ingreso_ins->AdvancedSearch->ToJSON(), ","); // Field Via_ingreso_ins
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_ingreso_usuario->AdvancedSearch->ToJSON(), ","); // Field Fecha_ingreso_usuario
		$sFilterList = ew_Concat($sFilterList, $this->Hora_ingreso->AdvancedSearch->ToJSON(), ","); // Field Hora_ingreso
		$sFilterList = ew_Concat($sFilterList, $this->Numero_autorizacion->AdvancedSearch->ToJSON(), ","); // Field Numero_autorizacion
		$sFilterList = ew_Concat($sFilterList, $this->Causa_externa->AdvancedSearch->ToJSON(), ","); // Field Causa_externa
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_principal_ingreso->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_principal_ingreso
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_principal_egreso->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_principal_egreso
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_rel_1->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_rel_1
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_rel_2->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_rel_2
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_rel_3->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_rel_3
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_complicacion->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_complicacion
		$sFilterList = ew_Concat($sFilterList, $this->Estado_salida->AdvancedSearch->ToJSON(), ","); // Field Estado_salida
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_causa_muerte->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_causa_muerte
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_egreso->AdvancedSearch->ToJSON(), ","); // Field Fecha_egreso
		$sFilterList = ew_Concat($sFilterList, $this->Hora__egreso->AdvancedSearch->ToJSON(), ","); // Field Hora _egreso
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Numero_factura
		$this->Numero_factura->AdvancedSearch->SearchValue = @$filter["x_Numero_factura"];
		$this->Numero_factura->AdvancedSearch->SearchOperator = @$filter["z_Numero_factura"];
		$this->Numero_factura->AdvancedSearch->SearchCondition = @$filter["v_Numero_factura"];
		$this->Numero_factura->AdvancedSearch->SearchValue2 = @$filter["y_Numero_factura"];
		$this->Numero_factura->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_factura"];
		$this->Numero_factura->AdvancedSearch->Save();

		// Field Codigo_prestador
		$this->Codigo_prestador->AdvancedSearch->SearchValue = @$filter["x_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchOperator = @$filter["z_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchCondition = @$filter["v_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->Save();

		// Field Tipo_id
		$this->Tipo_id->AdvancedSearch->SearchValue = @$filter["x_Tipo_id"];
		$this->Tipo_id->AdvancedSearch->SearchOperator = @$filter["z_Tipo_id"];
		$this->Tipo_id->AdvancedSearch->SearchCondition = @$filter["v_Tipo_id"];
		$this->Tipo_id->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_id"];
		$this->Tipo_id->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_id"];
		$this->Tipo_id->AdvancedSearch->Save();

		// Field Numero_id
		$this->Numero_id->AdvancedSearch->SearchValue = @$filter["x_Numero_id"];
		$this->Numero_id->AdvancedSearch->SearchOperator = @$filter["z_Numero_id"];
		$this->Numero_id->AdvancedSearch->SearchCondition = @$filter["v_Numero_id"];
		$this->Numero_id->AdvancedSearch->SearchValue2 = @$filter["y_Numero_id"];
		$this->Numero_id->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_id"];
		$this->Numero_id->AdvancedSearch->Save();

		// Field Via_ingreso_ins
		$this->Via_ingreso_ins->AdvancedSearch->SearchValue = @$filter["x_Via_ingreso_ins"];
		$this->Via_ingreso_ins->AdvancedSearch->SearchOperator = @$filter["z_Via_ingreso_ins"];
		$this->Via_ingreso_ins->AdvancedSearch->SearchCondition = @$filter["v_Via_ingreso_ins"];
		$this->Via_ingreso_ins->AdvancedSearch->SearchValue2 = @$filter["y_Via_ingreso_ins"];
		$this->Via_ingreso_ins->AdvancedSearch->SearchOperator2 = @$filter["w_Via_ingreso_ins"];
		$this->Via_ingreso_ins->AdvancedSearch->Save();

		// Field Fecha_ingreso_usuario
		$this->Fecha_ingreso_usuario->AdvancedSearch->SearchValue = @$filter["x_Fecha_ingreso_usuario"];
		$this->Fecha_ingreso_usuario->AdvancedSearch->SearchOperator = @$filter["z_Fecha_ingreso_usuario"];
		$this->Fecha_ingreso_usuario->AdvancedSearch->SearchCondition = @$filter["v_Fecha_ingreso_usuario"];
		$this->Fecha_ingreso_usuario->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_ingreso_usuario"];
		$this->Fecha_ingreso_usuario->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_ingreso_usuario"];
		$this->Fecha_ingreso_usuario->AdvancedSearch->Save();

		// Field Hora_ingreso
		$this->Hora_ingreso->AdvancedSearch->SearchValue = @$filter["x_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchOperator = @$filter["z_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchCondition = @$filter["v_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchValue2 = @$filter["y_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchOperator2 = @$filter["w_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->Save();

		// Field Numero_autorizacion
		$this->Numero_autorizacion->AdvancedSearch->SearchValue = @$filter["x_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchOperator = @$filter["z_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchCondition = @$filter["v_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchValue2 = @$filter["y_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_autorizacion"];
		$this->Numero_autorizacion->AdvancedSearch->Save();

		// Field Causa_externa
		$this->Causa_externa->AdvancedSearch->SearchValue = @$filter["x_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchOperator = @$filter["z_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchCondition = @$filter["v_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchValue2 = @$filter["y_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchOperator2 = @$filter["w_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->Save();

		// Field Diagnostico_principal_ingreso
		$this->Diagnostico_principal_ingreso->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_principal_ingreso"];
		$this->Diagnostico_principal_ingreso->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_principal_ingreso"];
		$this->Diagnostico_principal_ingreso->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_principal_ingreso"];
		$this->Diagnostico_principal_ingreso->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_principal_ingreso"];
		$this->Diagnostico_principal_ingreso->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_principal_ingreso"];
		$this->Diagnostico_principal_ingreso->AdvancedSearch->Save();

		// Field Diagnostico_principal_egreso
		$this->Diagnostico_principal_egreso->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_principal_egreso"];
		$this->Diagnostico_principal_egreso->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_principal_egreso"];
		$this->Diagnostico_principal_egreso->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_principal_egreso"];
		$this->Diagnostico_principal_egreso->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_principal_egreso"];
		$this->Diagnostico_principal_egreso->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_principal_egreso"];
		$this->Diagnostico_principal_egreso->AdvancedSearch->Save();

		// Field Diagnostico_rel_1
		$this->Diagnostico_rel_1->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_rel_1"];
		$this->Diagnostico_rel_1->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_rel_1"];
		$this->Diagnostico_rel_1->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_rel_1"];
		$this->Diagnostico_rel_1->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_rel_1"];
		$this->Diagnostico_rel_1->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_rel_1"];
		$this->Diagnostico_rel_1->AdvancedSearch->Save();

		// Field Diagnostico_rel_2
		$this->Diagnostico_rel_2->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_rel_2"];
		$this->Diagnostico_rel_2->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_rel_2"];
		$this->Diagnostico_rel_2->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_rel_2"];
		$this->Diagnostico_rel_2->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_rel_2"];
		$this->Diagnostico_rel_2->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_rel_2"];
		$this->Diagnostico_rel_2->AdvancedSearch->Save();

		// Field Diagnostico_rel_3
		$this->Diagnostico_rel_3->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_rel_3"];
		$this->Diagnostico_rel_3->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_rel_3"];
		$this->Diagnostico_rel_3->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_rel_3"];
		$this->Diagnostico_rel_3->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_rel_3"];
		$this->Diagnostico_rel_3->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_rel_3"];
		$this->Diagnostico_rel_3->AdvancedSearch->Save();

		// Field Diagnostico_complicacion
		$this->Diagnostico_complicacion->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_complicacion"];
		$this->Diagnostico_complicacion->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_complicacion"];
		$this->Diagnostico_complicacion->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_complicacion"];
		$this->Diagnostico_complicacion->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_complicacion"];
		$this->Diagnostico_complicacion->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_complicacion"];
		$this->Diagnostico_complicacion->AdvancedSearch->Save();

		// Field Estado_salida
		$this->Estado_salida->AdvancedSearch->SearchValue = @$filter["x_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchOperator = @$filter["z_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchCondition = @$filter["v_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchValue2 = @$filter["y_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchOperator2 = @$filter["w_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->Save();

		// Field Diagnostico_causa_muerte
		$this->Diagnostico_causa_muerte->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_causa_muerte"];
		$this->Diagnostico_causa_muerte->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_causa_muerte"];
		$this->Diagnostico_causa_muerte->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_causa_muerte"];
		$this->Diagnostico_causa_muerte->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_causa_muerte"];
		$this->Diagnostico_causa_muerte->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_causa_muerte"];
		$this->Diagnostico_causa_muerte->AdvancedSearch->Save();

		// Field Fecha_egreso
		$this->Fecha_egreso->AdvancedSearch->SearchValue = @$filter["x_Fecha_egreso"];
		$this->Fecha_egreso->AdvancedSearch->SearchOperator = @$filter["z_Fecha_egreso"];
		$this->Fecha_egreso->AdvancedSearch->SearchCondition = @$filter["v_Fecha_egreso"];
		$this->Fecha_egreso->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_egreso"];
		$this->Fecha_egreso->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_egreso"];
		$this->Fecha_egreso->AdvancedSearch->Save();

		// Field Hora _egreso
		$this->Hora__egreso->AdvancedSearch->SearchValue = @$filter["x_Hora__egreso"];
		$this->Hora__egreso->AdvancedSearch->SearchOperator = @$filter["z_Hora__egreso"];
		$this->Hora__egreso->AdvancedSearch->SearchCondition = @$filter["v_Hora__egreso"];
		$this->Hora__egreso->AdvancedSearch->SearchValue2 = @$filter["y_Hora__egreso"];
		$this->Hora__egreso->AdvancedSearch->SearchOperator2 = @$filter["w_Hora__egreso"];
		$this->Hora__egreso->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_factura, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_prestador, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Tipo_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Fecha_ingreso_usuario, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Hora_ingreso, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_autorizacion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_principal_ingreso, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_principal_egreso, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_rel_1, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_rel_2, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_rel_3, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_complicacion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_causa_muerte, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Fecha_egreso, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Hora__egreso, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Numero_factura); // Numero_factura
			$this->UpdateSort($this->Codigo_prestador); // Codigo_prestador
			$this->UpdateSort($this->Tipo_id); // Tipo_id
			$this->UpdateSort($this->Numero_id); // Numero_id
			$this->UpdateSort($this->Via_ingreso_ins); // Via_ingreso_ins
			$this->UpdateSort($this->Fecha_ingreso_usuario); // Fecha_ingreso_usuario
			$this->UpdateSort($this->Hora_ingreso); // Hora_ingreso
			$this->UpdateSort($this->Numero_autorizacion); // Numero_autorizacion
			$this->UpdateSort($this->Causa_externa); // Causa_externa
			$this->UpdateSort($this->Diagnostico_principal_ingreso); // Diagnostico_principal_ingreso
			$this->UpdateSort($this->Diagnostico_principal_egreso); // Diagnostico_principal_egreso
			$this->UpdateSort($this->Diagnostico_rel_1); // Diagnostico_rel_1
			$this->UpdateSort($this->Diagnostico_rel_2); // Diagnostico_rel_2
			$this->UpdateSort($this->Diagnostico_rel_3); // Diagnostico_rel_3
			$this->UpdateSort($this->Diagnostico_complicacion); // Diagnostico_complicacion
			$this->UpdateSort($this->Estado_salida); // Estado_salida
			$this->UpdateSort($this->Diagnostico_causa_muerte); // Diagnostico_causa_muerte
			$this->UpdateSort($this->Fecha_egreso); // Fecha_egreso
			$this->UpdateSort($this->Hora__egreso); // Hora _egreso
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Numero_factura->setSort("");
				$this->Codigo_prestador->setSort("");
				$this->Tipo_id->setSort("");
				$this->Numero_id->setSort("");
				$this->Via_ingreso_ins->setSort("");
				$this->Fecha_ingreso_usuario->setSort("");
				$this->Hora_ingreso->setSort("");
				$this->Numero_autorizacion->setSort("");
				$this->Causa_externa->setSort("");
				$this->Diagnostico_principal_ingreso->setSort("");
				$this->Diagnostico_principal_egreso->setSort("");
				$this->Diagnostico_rel_1->setSort("");
				$this->Diagnostico_rel_2->setSort("");
				$this->Diagnostico_rel_3->setSort("");
				$this->Diagnostico_complicacion->setSort("");
				$this->Estado_salida->setSort("");
				$this->Diagnostico_causa_muerte->setSort("");
				$this->Fecha_egreso->setSort("");
				$this->Hora__egreso->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fHospitalizacionlistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fHospitalizacionlistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fHospitalizacionlist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fHospitalizacionlistsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Numero_factura->setDbValue($rs->fields('Numero_factura'));
		$this->Codigo_prestador->setDbValue($rs->fields('Codigo_prestador'));
		$this->Tipo_id->setDbValue($rs->fields('Tipo_id'));
		$this->Numero_id->setDbValue($rs->fields('Numero_id'));
		$this->Via_ingreso_ins->setDbValue($rs->fields('Via_ingreso_ins'));
		$this->Fecha_ingreso_usuario->setDbValue($rs->fields('Fecha_ingreso_usuario'));
		$this->Hora_ingreso->setDbValue($rs->fields('Hora_ingreso'));
		$this->Numero_autorizacion->setDbValue($rs->fields('Numero_autorizacion'));
		$this->Causa_externa->setDbValue($rs->fields('Causa_externa'));
		$this->Diagnostico_principal_ingreso->setDbValue($rs->fields('Diagnostico_principal_ingreso'));
		$this->Diagnostico_principal_egreso->setDbValue($rs->fields('Diagnostico_principal_egreso'));
		$this->Diagnostico_rel_1->setDbValue($rs->fields('Diagnostico_rel_1'));
		$this->Diagnostico_rel_2->setDbValue($rs->fields('Diagnostico_rel_2'));
		$this->Diagnostico_rel_3->setDbValue($rs->fields('Diagnostico_rel_3'));
		$this->Diagnostico_complicacion->setDbValue($rs->fields('Diagnostico_complicacion'));
		$this->Estado_salida->setDbValue($rs->fields('Estado_salida'));
		$this->Diagnostico_causa_muerte->setDbValue($rs->fields('Diagnostico_causa_muerte'));
		$this->Fecha_egreso->setDbValue($rs->fields('Fecha_egreso'));
		$this->Hora__egreso->setDbValue($rs->fields('Hora _egreso'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Numero_factura->DbValue = $row['Numero_factura'];
		$this->Codigo_prestador->DbValue = $row['Codigo_prestador'];
		$this->Tipo_id->DbValue = $row['Tipo_id'];
		$this->Numero_id->DbValue = $row['Numero_id'];
		$this->Via_ingreso_ins->DbValue = $row['Via_ingreso_ins'];
		$this->Fecha_ingreso_usuario->DbValue = $row['Fecha_ingreso_usuario'];
		$this->Hora_ingreso->DbValue = $row['Hora_ingreso'];
		$this->Numero_autorizacion->DbValue = $row['Numero_autorizacion'];
		$this->Causa_externa->DbValue = $row['Causa_externa'];
		$this->Diagnostico_principal_ingreso->DbValue = $row['Diagnostico_principal_ingreso'];
		$this->Diagnostico_principal_egreso->DbValue = $row['Diagnostico_principal_egreso'];
		$this->Diagnostico_rel_1->DbValue = $row['Diagnostico_rel_1'];
		$this->Diagnostico_rel_2->DbValue = $row['Diagnostico_rel_2'];
		$this->Diagnostico_rel_3->DbValue = $row['Diagnostico_rel_3'];
		$this->Diagnostico_complicacion->DbValue = $row['Diagnostico_complicacion'];
		$this->Estado_salida->DbValue = $row['Estado_salida'];
		$this->Diagnostico_causa_muerte->DbValue = $row['Diagnostico_causa_muerte'];
		$this->Fecha_egreso->DbValue = $row['Fecha_egreso'];
		$this->Hora__egreso->DbValue = $row['Hora _egreso'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Numero_factura
		// Codigo_prestador
		// Tipo_id
		// Numero_id
		// Via_ingreso_ins
		// Fecha_ingreso_usuario
		// Hora_ingreso
		// Numero_autorizacion
		// Causa_externa
		// Diagnostico_principal_ingreso
		// Diagnostico_principal_egreso
		// Diagnostico_rel_1
		// Diagnostico_rel_2
		// Diagnostico_rel_3
		// Diagnostico_complicacion
		// Estado_salida
		// Diagnostico_causa_muerte
		// Fecha_egreso
		// Hora _egreso

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Numero_factura
		$this->Numero_factura->ViewValue = $this->Numero_factura->CurrentValue;
		$this->Numero_factura->ViewCustomAttributes = "";

		// Codigo_prestador
		$this->Codigo_prestador->ViewValue = $this->Codigo_prestador->CurrentValue;
		$this->Codigo_prestador->ViewCustomAttributes = "";

		// Tipo_id
		$this->Tipo_id->ViewValue = $this->Tipo_id->CurrentValue;
		$this->Tipo_id->ViewCustomAttributes = "";

		// Numero_id
		$this->Numero_id->ViewValue = $this->Numero_id->CurrentValue;
		$this->Numero_id->ViewCustomAttributes = "";

		// Via_ingreso_ins
		$this->Via_ingreso_ins->ViewValue = $this->Via_ingreso_ins->CurrentValue;
		$this->Via_ingreso_ins->ViewCustomAttributes = "";

		// Fecha_ingreso_usuario
		$this->Fecha_ingreso_usuario->ViewValue = $this->Fecha_ingreso_usuario->CurrentValue;
		$this->Fecha_ingreso_usuario->ViewCustomAttributes = "";

		// Hora_ingreso
		$this->Hora_ingreso->ViewValue = $this->Hora_ingreso->CurrentValue;
		$this->Hora_ingreso->ViewCustomAttributes = "";

		// Numero_autorizacion
		$this->Numero_autorizacion->ViewValue = $this->Numero_autorizacion->CurrentValue;
		$this->Numero_autorizacion->ViewCustomAttributes = "";

		// Causa_externa
		$this->Causa_externa->ViewValue = $this->Causa_externa->CurrentValue;
		$this->Causa_externa->ViewCustomAttributes = "";

		// Diagnostico_principal_ingreso
		$this->Diagnostico_principal_ingreso->ViewValue = $this->Diagnostico_principal_ingreso->CurrentValue;
		$this->Diagnostico_principal_ingreso->ViewCustomAttributes = "";

		// Diagnostico_principal_egreso
		$this->Diagnostico_principal_egreso->ViewValue = $this->Diagnostico_principal_egreso->CurrentValue;
		$this->Diagnostico_principal_egreso->ViewCustomAttributes = "";

		// Diagnostico_rel_1
		$this->Diagnostico_rel_1->ViewValue = $this->Diagnostico_rel_1->CurrentValue;
		$this->Diagnostico_rel_1->ViewCustomAttributes = "";

		// Diagnostico_rel_2
		$this->Diagnostico_rel_2->ViewValue = $this->Diagnostico_rel_2->CurrentValue;
		$this->Diagnostico_rel_2->ViewCustomAttributes = "";

		// Diagnostico_rel_3
		$this->Diagnostico_rel_3->ViewValue = $this->Diagnostico_rel_3->CurrentValue;
		$this->Diagnostico_rel_3->ViewCustomAttributes = "";

		// Diagnostico_complicacion
		$this->Diagnostico_complicacion->ViewValue = $this->Diagnostico_complicacion->CurrentValue;
		$this->Diagnostico_complicacion->ViewCustomAttributes = "";

		// Estado_salida
		$this->Estado_salida->ViewValue = $this->Estado_salida->CurrentValue;
		$this->Estado_salida->ViewCustomAttributes = "";

		// Diagnostico_causa_muerte
		$this->Diagnostico_causa_muerte->ViewValue = $this->Diagnostico_causa_muerte->CurrentValue;
		$this->Diagnostico_causa_muerte->ViewCustomAttributes = "";

		// Fecha_egreso
		$this->Fecha_egreso->ViewValue = $this->Fecha_egreso->CurrentValue;
		$this->Fecha_egreso->ViewCustomAttributes = "";

		// Hora _egreso
		$this->Hora__egreso->ViewValue = $this->Hora__egreso->CurrentValue;
		$this->Hora__egreso->ViewCustomAttributes = "";

			// Numero_factura
			$this->Numero_factura->LinkCustomAttributes = "";
			$this->Numero_factura->HrefValue = "";
			$this->Numero_factura->TooltipValue = "";

			// Codigo_prestador
			$this->Codigo_prestador->LinkCustomAttributes = "";
			$this->Codigo_prestador->HrefValue = "";
			$this->Codigo_prestador->TooltipValue = "";

			// Tipo_id
			$this->Tipo_id->LinkCustomAttributes = "";
			$this->Tipo_id->HrefValue = "";
			$this->Tipo_id->TooltipValue = "";

			// Numero_id
			$this->Numero_id->LinkCustomAttributes = "";
			$this->Numero_id->HrefValue = "";
			$this->Numero_id->TooltipValue = "";

			// Via_ingreso_ins
			$this->Via_ingreso_ins->LinkCustomAttributes = "";
			$this->Via_ingreso_ins->HrefValue = "";
			$this->Via_ingreso_ins->TooltipValue = "";

			// Fecha_ingreso_usuario
			$this->Fecha_ingreso_usuario->LinkCustomAttributes = "";
			$this->Fecha_ingreso_usuario->HrefValue = "";
			$this->Fecha_ingreso_usuario->TooltipValue = "";

			// Hora_ingreso
			$this->Hora_ingreso->LinkCustomAttributes = "";
			$this->Hora_ingreso->HrefValue = "";
			$this->Hora_ingreso->TooltipValue = "";

			// Numero_autorizacion
			$this->Numero_autorizacion->LinkCustomAttributes = "";
			$this->Numero_autorizacion->HrefValue = "";
			$this->Numero_autorizacion->TooltipValue = "";

			// Causa_externa
			$this->Causa_externa->LinkCustomAttributes = "";
			$this->Causa_externa->HrefValue = "";
			$this->Causa_externa->TooltipValue = "";

			// Diagnostico_principal_ingreso
			$this->Diagnostico_principal_ingreso->LinkCustomAttributes = "";
			$this->Diagnostico_principal_ingreso->HrefValue = "";
			$this->Diagnostico_principal_ingreso->TooltipValue = "";

			// Diagnostico_principal_egreso
			$this->Diagnostico_principal_egreso->LinkCustomAttributes = "";
			$this->Diagnostico_principal_egreso->HrefValue = "";
			$this->Diagnostico_principal_egreso->TooltipValue = "";

			// Diagnostico_rel_1
			$this->Diagnostico_rel_1->LinkCustomAttributes = "";
			$this->Diagnostico_rel_1->HrefValue = "";
			$this->Diagnostico_rel_1->TooltipValue = "";

			// Diagnostico_rel_2
			$this->Diagnostico_rel_2->LinkCustomAttributes = "";
			$this->Diagnostico_rel_2->HrefValue = "";
			$this->Diagnostico_rel_2->TooltipValue = "";

			// Diagnostico_rel_3
			$this->Diagnostico_rel_3->LinkCustomAttributes = "";
			$this->Diagnostico_rel_3->HrefValue = "";
			$this->Diagnostico_rel_3->TooltipValue = "";

			// Diagnostico_complicacion
			$this->Diagnostico_complicacion->LinkCustomAttributes = "";
			$this->Diagnostico_complicacion->HrefValue = "";
			$this->Diagnostico_complicacion->TooltipValue = "";

			// Estado_salida
			$this->Estado_salida->LinkCustomAttributes = "";
			$this->Estado_salida->HrefValue = "";
			$this->Estado_salida->TooltipValue = "";

			// Diagnostico_causa_muerte
			$this->Diagnostico_causa_muerte->LinkCustomAttributes = "";
			$this->Diagnostico_causa_muerte->HrefValue = "";
			$this->Diagnostico_causa_muerte->TooltipValue = "";

			// Fecha_egreso
			$this->Fecha_egreso->LinkCustomAttributes = "";
			$this->Fecha_egreso->HrefValue = "";
			$this->Fecha_egreso->TooltipValue = "";

			// Hora _egreso
			$this->Hora__egreso->LinkCustomAttributes = "";
			$this->Hora__egreso->HrefValue = "";
			$this->Hora__egreso->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($Hospitalizacion_list)) $Hospitalizacion_list = new cHospitalizacion_list();

// Page init
$Hospitalizacion_list->Page_Init();

// Page main
$Hospitalizacion_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Hospitalizacion_list->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fHospitalizacionlist = new ew_Form("fHospitalizacionlist", "list");
fHospitalizacionlist.FormKeyCountName = '<?php echo $Hospitalizacion_list->FormKeyCountName ?>';

// Form_CustomValidate event
fHospitalizacionlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fHospitalizacionlist.ValidateRequired = true;
<?php } else { ?>
fHospitalizacionlist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

var CurrentSearchForm = fHospitalizacionlistsrch = new ew_Form("fHospitalizacionlistsrch");
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php if ($Hospitalizacion_list->TotalRecs > 0 && $Hospitalizacion_list->ExportOptions->Visible()) { ?>
<?php $Hospitalizacion_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($Hospitalizacion_list->SearchOptions->Visible()) { ?>
<?php $Hospitalizacion_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($Hospitalizacion_list->FilterOptions->Visible()) { ?>
<?php $Hospitalizacion_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php
	$bSelectLimit = $Hospitalizacion_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($Hospitalizacion_list->TotalRecs <= 0)
			$Hospitalizacion_list->TotalRecs = $Hospitalizacion->SelectRecordCount();
	} else {
		if (!$Hospitalizacion_list->Recordset && ($Hospitalizacion_list->Recordset = $Hospitalizacion_list->LoadRecordset()))
			$Hospitalizacion_list->TotalRecs = $Hospitalizacion_list->Recordset->RecordCount();
	}
	$Hospitalizacion_list->StartRec = 1;
	if ($Hospitalizacion_list->DisplayRecs <= 0 || ($Hospitalizacion->Export <> "" && $Hospitalizacion->ExportAll)) // Display all records
		$Hospitalizacion_list->DisplayRecs = $Hospitalizacion_list->TotalRecs;
	if (!($Hospitalizacion->Export <> "" && $Hospitalizacion->ExportAll))
		$Hospitalizacion_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$Hospitalizacion_list->Recordset = $Hospitalizacion_list->LoadRecordset($Hospitalizacion_list->StartRec-1, $Hospitalizacion_list->DisplayRecs);

	// Set no record found message
	if ($Hospitalizacion->CurrentAction == "" && $Hospitalizacion_list->TotalRecs == 0) {
		if ($Hospitalizacion_list->SearchWhere == "0=101")
			$Hospitalizacion_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$Hospitalizacion_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$Hospitalizacion_list->RenderOtherOptions();
?>
<?php if ($Hospitalizacion->Export == "" && $Hospitalizacion->CurrentAction == "") { ?>
<form name="fHospitalizacionlistsrch" id="fHospitalizacionlistsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($Hospitalizacion_list->SearchWhere <> "") ? " in" : " in"; ?>
<div id="fHospitalizacionlistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="Hospitalizacion">
	<div class="ewBasicSearch">
<div id="xsr_1" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($Hospitalizacion_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($Hospitalizacion_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $Hospitalizacion_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($Hospitalizacion_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($Hospitalizacion_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($Hospitalizacion_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($Hospitalizacion_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php $Hospitalizacion_list->ShowPageHeader(); ?>
<?php
$Hospitalizacion_list->ShowMessage();
?>
<?php if ($Hospitalizacion_list->TotalRecs > 0 || $Hospitalizacion->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<form name="fHospitalizacionlist" id="fHospitalizacionlist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($Hospitalizacion_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $Hospitalizacion_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="Hospitalizacion">
<div id="gmp_Hospitalizacion" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($Hospitalizacion_list->TotalRecs > 0) { ?>
<table id="tbl_Hospitalizacionlist" class="table ewTable">
<?php echo $Hospitalizacion->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$Hospitalizacion_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$Hospitalizacion_list->RenderListOptions();

// Render list options (header, left)
$Hospitalizacion_list->ListOptions->Render("header", "left");
?>
<?php if ($Hospitalizacion->Numero_factura->Visible) { // Numero_factura ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Numero_factura) == "") { ?>
		<th data-name="Numero_factura"><div id="elh_Hospitalizacion_Numero_factura" class="Hospitalizacion_Numero_factura"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Numero_factura->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_factura"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Numero_factura) ?>',1);"><div id="elh_Hospitalizacion_Numero_factura" class="Hospitalizacion_Numero_factura">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Numero_factura->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Numero_factura->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Numero_factura->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Codigo_prestador->Visible) { // Codigo_prestador ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Codigo_prestador) == "") { ?>
		<th data-name="Codigo_prestador"><div id="elh_Hospitalizacion_Codigo_prestador" class="Hospitalizacion_Codigo_prestador"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Codigo_prestador->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_prestador"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Codigo_prestador) ?>',1);"><div id="elh_Hospitalizacion_Codigo_prestador" class="Hospitalizacion_Codigo_prestador">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Codigo_prestador->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Codigo_prestador->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Codigo_prestador->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Tipo_id->Visible) { // Tipo_id ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Tipo_id) == "") { ?>
		<th data-name="Tipo_id"><div id="elh_Hospitalizacion_Tipo_id" class="Hospitalizacion_Tipo_id"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Tipo_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tipo_id"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Tipo_id) ?>',1);"><div id="elh_Hospitalizacion_Tipo_id" class="Hospitalizacion_Tipo_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Tipo_id->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Tipo_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Tipo_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Numero_id->Visible) { // Numero_id ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Numero_id) == "") { ?>
		<th data-name="Numero_id"><div id="elh_Hospitalizacion_Numero_id" class="Hospitalizacion_Numero_id"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Numero_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_id"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Numero_id) ?>',1);"><div id="elh_Hospitalizacion_Numero_id" class="Hospitalizacion_Numero_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Numero_id->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Numero_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Numero_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Via_ingreso_ins->Visible) { // Via_ingreso_ins ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Via_ingreso_ins) == "") { ?>
		<th data-name="Via_ingreso_ins"><div id="elh_Hospitalizacion_Via_ingreso_ins" class="Hospitalizacion_Via_ingreso_ins"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Via_ingreso_ins->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Via_ingreso_ins"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Via_ingreso_ins) ?>',1);"><div id="elh_Hospitalizacion_Via_ingreso_ins" class="Hospitalizacion_Via_ingreso_ins">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Via_ingreso_ins->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Via_ingreso_ins->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Via_ingreso_ins->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Fecha_ingreso_usuario->Visible) { // Fecha_ingreso_usuario ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Fecha_ingreso_usuario) == "") { ?>
		<th data-name="Fecha_ingreso_usuario"><div id="elh_Hospitalizacion_Fecha_ingreso_usuario" class="Hospitalizacion_Fecha_ingreso_usuario"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Fecha_ingreso_usuario->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_ingreso_usuario"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Fecha_ingreso_usuario) ?>',1);"><div id="elh_Hospitalizacion_Fecha_ingreso_usuario" class="Hospitalizacion_Fecha_ingreso_usuario">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Fecha_ingreso_usuario->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Fecha_ingreso_usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Fecha_ingreso_usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Hora_ingreso->Visible) { // Hora_ingreso ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Hora_ingreso) == "") { ?>
		<th data-name="Hora_ingreso"><div id="elh_Hospitalizacion_Hora_ingreso" class="Hospitalizacion_Hora_ingreso"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Hora_ingreso->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hora_ingreso"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Hora_ingreso) ?>',1);"><div id="elh_Hospitalizacion_Hora_ingreso" class="Hospitalizacion_Hora_ingreso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Hora_ingreso->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Hora_ingreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Hora_ingreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Numero_autorizacion->Visible) { // Numero_autorizacion ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Numero_autorizacion) == "") { ?>
		<th data-name="Numero_autorizacion"><div id="elh_Hospitalizacion_Numero_autorizacion" class="Hospitalizacion_Numero_autorizacion"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Numero_autorizacion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_autorizacion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Numero_autorizacion) ?>',1);"><div id="elh_Hospitalizacion_Numero_autorizacion" class="Hospitalizacion_Numero_autorizacion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Numero_autorizacion->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Numero_autorizacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Numero_autorizacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Causa_externa->Visible) { // Causa_externa ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Causa_externa) == "") { ?>
		<th data-name="Causa_externa"><div id="elh_Hospitalizacion_Causa_externa" class="Hospitalizacion_Causa_externa"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Causa_externa->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Causa_externa"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Causa_externa) ?>',1);"><div id="elh_Hospitalizacion_Causa_externa" class="Hospitalizacion_Causa_externa">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Causa_externa->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Causa_externa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Causa_externa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Diagnostico_principal_ingreso->Visible) { // Diagnostico_principal_ingreso ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_principal_ingreso) == "") { ?>
		<th data-name="Diagnostico_principal_ingreso"><div id="elh_Hospitalizacion_Diagnostico_principal_ingreso" class="Hospitalizacion_Diagnostico_principal_ingreso"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_principal_ingreso->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_principal_ingreso"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_principal_ingreso) ?>',1);"><div id="elh_Hospitalizacion_Diagnostico_principal_ingreso" class="Hospitalizacion_Diagnostico_principal_ingreso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_principal_ingreso->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Diagnostico_principal_ingreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Diagnostico_principal_ingreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Diagnostico_principal_egreso->Visible) { // Diagnostico_principal_egreso ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_principal_egreso) == "") { ?>
		<th data-name="Diagnostico_principal_egreso"><div id="elh_Hospitalizacion_Diagnostico_principal_egreso" class="Hospitalizacion_Diagnostico_principal_egreso"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_principal_egreso->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_principal_egreso"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_principal_egreso) ?>',1);"><div id="elh_Hospitalizacion_Diagnostico_principal_egreso" class="Hospitalizacion_Diagnostico_principal_egreso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_principal_egreso->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Diagnostico_principal_egreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Diagnostico_principal_egreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Diagnostico_rel_1->Visible) { // Diagnostico_rel_1 ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_rel_1) == "") { ?>
		<th data-name="Diagnostico_rel_1"><div id="elh_Hospitalizacion_Diagnostico_rel_1" class="Hospitalizacion_Diagnostico_rel_1"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_rel_1->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_rel_1"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_rel_1) ?>',1);"><div id="elh_Hospitalizacion_Diagnostico_rel_1" class="Hospitalizacion_Diagnostico_rel_1">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_rel_1->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Diagnostico_rel_1->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Diagnostico_rel_1->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Diagnostico_rel_2->Visible) { // Diagnostico_rel_2 ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_rel_2) == "") { ?>
		<th data-name="Diagnostico_rel_2"><div id="elh_Hospitalizacion_Diagnostico_rel_2" class="Hospitalizacion_Diagnostico_rel_2"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_rel_2->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_rel_2"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_rel_2) ?>',1);"><div id="elh_Hospitalizacion_Diagnostico_rel_2" class="Hospitalizacion_Diagnostico_rel_2">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_rel_2->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Diagnostico_rel_2->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Diagnostico_rel_2->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Diagnostico_rel_3->Visible) { // Diagnostico_rel_3 ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_rel_3) == "") { ?>
		<th data-name="Diagnostico_rel_3"><div id="elh_Hospitalizacion_Diagnostico_rel_3" class="Hospitalizacion_Diagnostico_rel_3"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_rel_3->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_rel_3"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_rel_3) ?>',1);"><div id="elh_Hospitalizacion_Diagnostico_rel_3" class="Hospitalizacion_Diagnostico_rel_3">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_rel_3->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Diagnostico_rel_3->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Diagnostico_rel_3->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Diagnostico_complicacion->Visible) { // Diagnostico_complicacion ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_complicacion) == "") { ?>
		<th data-name="Diagnostico_complicacion"><div id="elh_Hospitalizacion_Diagnostico_complicacion" class="Hospitalizacion_Diagnostico_complicacion"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_complicacion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_complicacion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_complicacion) ?>',1);"><div id="elh_Hospitalizacion_Diagnostico_complicacion" class="Hospitalizacion_Diagnostico_complicacion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_complicacion->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Diagnostico_complicacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Diagnostico_complicacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Estado_salida->Visible) { // Estado_salida ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Estado_salida) == "") { ?>
		<th data-name="Estado_salida"><div id="elh_Hospitalizacion_Estado_salida" class="Hospitalizacion_Estado_salida"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Estado_salida->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Estado_salida"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Estado_salida) ?>',1);"><div id="elh_Hospitalizacion_Estado_salida" class="Hospitalizacion_Estado_salida">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Estado_salida->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Estado_salida->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Estado_salida->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Diagnostico_causa_muerte->Visible) { // Diagnostico_causa_muerte ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_causa_muerte) == "") { ?>
		<th data-name="Diagnostico_causa_muerte"><div id="elh_Hospitalizacion_Diagnostico_causa_muerte" class="Hospitalizacion_Diagnostico_causa_muerte"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_causa_muerte->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_causa_muerte"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Diagnostico_causa_muerte) ?>',1);"><div id="elh_Hospitalizacion_Diagnostico_causa_muerte" class="Hospitalizacion_Diagnostico_causa_muerte">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Diagnostico_causa_muerte->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Diagnostico_causa_muerte->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Diagnostico_causa_muerte->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Fecha_egreso->Visible) { // Fecha_egreso ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Fecha_egreso) == "") { ?>
		<th data-name="Fecha_egreso"><div id="elh_Hospitalizacion_Fecha_egreso" class="Hospitalizacion_Fecha_egreso"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Fecha_egreso->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_egreso"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Fecha_egreso) ?>',1);"><div id="elh_Hospitalizacion_Fecha_egreso" class="Hospitalizacion_Fecha_egreso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Fecha_egreso->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Fecha_egreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Fecha_egreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Hospitalizacion->Hora__egreso->Visible) { // Hora _egreso ?>
	<?php if ($Hospitalizacion->SortUrl($Hospitalizacion->Hora__egreso) == "") { ?>
		<th data-name="Hora__egreso"><div id="elh_Hospitalizacion_Hora__egreso" class="Hospitalizacion_Hora__egreso"><div class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Hora__egreso->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hora__egreso"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Hospitalizacion->SortUrl($Hospitalizacion->Hora__egreso) ?>',1);"><div id="elh_Hospitalizacion_Hora__egreso" class="Hospitalizacion_Hora__egreso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Hospitalizacion->Hora__egreso->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Hospitalizacion->Hora__egreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Hospitalizacion->Hora__egreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$Hospitalizacion_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($Hospitalizacion->ExportAll && $Hospitalizacion->Export <> "") {
	$Hospitalizacion_list->StopRec = $Hospitalizacion_list->TotalRecs;
} else {

	// Set the last record to display
	if ($Hospitalizacion_list->TotalRecs > $Hospitalizacion_list->StartRec + $Hospitalizacion_list->DisplayRecs - 1)
		$Hospitalizacion_list->StopRec = $Hospitalizacion_list->StartRec + $Hospitalizacion_list->DisplayRecs - 1;
	else
		$Hospitalizacion_list->StopRec = $Hospitalizacion_list->TotalRecs;
}
$Hospitalizacion_list->RecCnt = $Hospitalizacion_list->StartRec - 1;
if ($Hospitalizacion_list->Recordset && !$Hospitalizacion_list->Recordset->EOF) {
	$Hospitalizacion_list->Recordset->MoveFirst();
	$bSelectLimit = $Hospitalizacion_list->UseSelectLimit;
	if (!$bSelectLimit && $Hospitalizacion_list->StartRec > 1)
		$Hospitalizacion_list->Recordset->Move($Hospitalizacion_list->StartRec - 1);
} elseif (!$Hospitalizacion->AllowAddDeleteRow && $Hospitalizacion_list->StopRec == 0) {
	$Hospitalizacion_list->StopRec = $Hospitalizacion->GridAddRowCount;
}

// Initialize aggregate
$Hospitalizacion->RowType = EW_ROWTYPE_AGGREGATEINIT;
$Hospitalizacion->ResetAttrs();
$Hospitalizacion_list->RenderRow();
while ($Hospitalizacion_list->RecCnt < $Hospitalizacion_list->StopRec) {
	$Hospitalizacion_list->RecCnt++;
	if (intval($Hospitalizacion_list->RecCnt) >= intval($Hospitalizacion_list->StartRec)) {
		$Hospitalizacion_list->RowCnt++;

		// Set up key count
		$Hospitalizacion_list->KeyCount = $Hospitalizacion_list->RowIndex;

		// Init row class and style
		$Hospitalizacion->ResetAttrs();
		$Hospitalizacion->CssClass = "";
		if ($Hospitalizacion->CurrentAction == "gridadd") {
		} else {
			$Hospitalizacion_list->LoadRowValues($Hospitalizacion_list->Recordset); // Load row values
		}
		$Hospitalizacion->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$Hospitalizacion->RowAttrs = array_merge($Hospitalizacion->RowAttrs, array('data-rowindex'=>$Hospitalizacion_list->RowCnt, 'id'=>'r' . $Hospitalizacion_list->RowCnt . '_Hospitalizacion', 'data-rowtype'=>$Hospitalizacion->RowType));

		// Render row
		$Hospitalizacion_list->RenderRow();

		// Render list options
		$Hospitalizacion_list->RenderListOptions();
?>
	<tr<?php echo $Hospitalizacion->RowAttributes() ?>>
<?php

// Render list options (body, left)
$Hospitalizacion_list->ListOptions->Render("body", "left", $Hospitalizacion_list->RowCnt);
?>
	<?php if ($Hospitalizacion->Numero_factura->Visible) { // Numero_factura ?>
		<td data-name="Numero_factura"<?php echo $Hospitalizacion->Numero_factura->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Numero_factura" class="Hospitalizacion_Numero_factura">
<span<?php echo $Hospitalizacion->Numero_factura->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Numero_factura->ListViewValue() ?></span>
</span>
<a id="<?php echo $Hospitalizacion_list->PageObjName . "_row_" . $Hospitalizacion_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($Hospitalizacion->Codigo_prestador->Visible) { // Codigo_prestador ?>
		<td data-name="Codigo_prestador"<?php echo $Hospitalizacion->Codigo_prestador->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Codigo_prestador" class="Hospitalizacion_Codigo_prestador">
<span<?php echo $Hospitalizacion->Codigo_prestador->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Codigo_prestador->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Tipo_id->Visible) { // Tipo_id ?>
		<td data-name="Tipo_id"<?php echo $Hospitalizacion->Tipo_id->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Tipo_id" class="Hospitalizacion_Tipo_id">
<span<?php echo $Hospitalizacion->Tipo_id->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Tipo_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Numero_id->Visible) { // Numero_id ?>
		<td data-name="Numero_id"<?php echo $Hospitalizacion->Numero_id->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Numero_id" class="Hospitalizacion_Numero_id">
<span<?php echo $Hospitalizacion->Numero_id->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Numero_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Via_ingreso_ins->Visible) { // Via_ingreso_ins ?>
		<td data-name="Via_ingreso_ins"<?php echo $Hospitalizacion->Via_ingreso_ins->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Via_ingreso_ins" class="Hospitalizacion_Via_ingreso_ins">
<span<?php echo $Hospitalizacion->Via_ingreso_ins->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Via_ingreso_ins->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Fecha_ingreso_usuario->Visible) { // Fecha_ingreso_usuario ?>
		<td data-name="Fecha_ingreso_usuario"<?php echo $Hospitalizacion->Fecha_ingreso_usuario->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Fecha_ingreso_usuario" class="Hospitalizacion_Fecha_ingreso_usuario">
<span<?php echo $Hospitalizacion->Fecha_ingreso_usuario->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Fecha_ingreso_usuario->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Hora_ingreso->Visible) { // Hora_ingreso ?>
		<td data-name="Hora_ingreso"<?php echo $Hospitalizacion->Hora_ingreso->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Hora_ingreso" class="Hospitalizacion_Hora_ingreso">
<span<?php echo $Hospitalizacion->Hora_ingreso->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Hora_ingreso->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Numero_autorizacion->Visible) { // Numero_autorizacion ?>
		<td data-name="Numero_autorizacion"<?php echo $Hospitalizacion->Numero_autorizacion->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Numero_autorizacion" class="Hospitalizacion_Numero_autorizacion">
<span<?php echo $Hospitalizacion->Numero_autorizacion->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Numero_autorizacion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Causa_externa->Visible) { // Causa_externa ?>
		<td data-name="Causa_externa"<?php echo $Hospitalizacion->Causa_externa->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Causa_externa" class="Hospitalizacion_Causa_externa">
<span<?php echo $Hospitalizacion->Causa_externa->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Causa_externa->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Diagnostico_principal_ingreso->Visible) { // Diagnostico_principal_ingreso ?>
		<td data-name="Diagnostico_principal_ingreso"<?php echo $Hospitalizacion->Diagnostico_principal_ingreso->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Diagnostico_principal_ingreso" class="Hospitalizacion_Diagnostico_principal_ingreso">
<span<?php echo $Hospitalizacion->Diagnostico_principal_ingreso->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Diagnostico_principal_ingreso->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Diagnostico_principal_egreso->Visible) { // Diagnostico_principal_egreso ?>
		<td data-name="Diagnostico_principal_egreso"<?php echo $Hospitalizacion->Diagnostico_principal_egreso->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Diagnostico_principal_egreso" class="Hospitalizacion_Diagnostico_principal_egreso">
<span<?php echo $Hospitalizacion->Diagnostico_principal_egreso->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Diagnostico_principal_egreso->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Diagnostico_rel_1->Visible) { // Diagnostico_rel_1 ?>
		<td data-name="Diagnostico_rel_1"<?php echo $Hospitalizacion->Diagnostico_rel_1->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Diagnostico_rel_1" class="Hospitalizacion_Diagnostico_rel_1">
<span<?php echo $Hospitalizacion->Diagnostico_rel_1->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Diagnostico_rel_1->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Diagnostico_rel_2->Visible) { // Diagnostico_rel_2 ?>
		<td data-name="Diagnostico_rel_2"<?php echo $Hospitalizacion->Diagnostico_rel_2->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Diagnostico_rel_2" class="Hospitalizacion_Diagnostico_rel_2">
<span<?php echo $Hospitalizacion->Diagnostico_rel_2->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Diagnostico_rel_2->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Diagnostico_rel_3->Visible) { // Diagnostico_rel_3 ?>
		<td data-name="Diagnostico_rel_3"<?php echo $Hospitalizacion->Diagnostico_rel_3->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Diagnostico_rel_3" class="Hospitalizacion_Diagnostico_rel_3">
<span<?php echo $Hospitalizacion->Diagnostico_rel_3->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Diagnostico_rel_3->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Diagnostico_complicacion->Visible) { // Diagnostico_complicacion ?>
		<td data-name="Diagnostico_complicacion"<?php echo $Hospitalizacion->Diagnostico_complicacion->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Diagnostico_complicacion" class="Hospitalizacion_Diagnostico_complicacion">
<span<?php echo $Hospitalizacion->Diagnostico_complicacion->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Diagnostico_complicacion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Estado_salida->Visible) { // Estado_salida ?>
		<td data-name="Estado_salida"<?php echo $Hospitalizacion->Estado_salida->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Estado_salida" class="Hospitalizacion_Estado_salida">
<span<?php echo $Hospitalizacion->Estado_salida->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Estado_salida->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Diagnostico_causa_muerte->Visible) { // Diagnostico_causa_muerte ?>
		<td data-name="Diagnostico_causa_muerte"<?php echo $Hospitalizacion->Diagnostico_causa_muerte->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Diagnostico_causa_muerte" class="Hospitalizacion_Diagnostico_causa_muerte">
<span<?php echo $Hospitalizacion->Diagnostico_causa_muerte->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Diagnostico_causa_muerte->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Fecha_egreso->Visible) { // Fecha_egreso ?>
		<td data-name="Fecha_egreso"<?php echo $Hospitalizacion->Fecha_egreso->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Fecha_egreso" class="Hospitalizacion_Fecha_egreso">
<span<?php echo $Hospitalizacion->Fecha_egreso->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Fecha_egreso->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Hospitalizacion->Hora__egreso->Visible) { // Hora _egreso ?>
		<td data-name="Hora__egreso"<?php echo $Hospitalizacion->Hora__egreso->CellAttributes() ?>>
<span id="el<?php echo $Hospitalizacion_list->RowCnt ?>_Hospitalizacion_Hora__egreso" class="Hospitalizacion_Hora__egreso">
<span<?php echo $Hospitalizacion->Hora__egreso->ViewAttributes() ?>>
<?php echo $Hospitalizacion->Hora__egreso->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$Hospitalizacion_list->ListOptions->Render("body", "right", $Hospitalizacion_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($Hospitalizacion->CurrentAction <> "gridadd")
		$Hospitalizacion_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($Hospitalizacion->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($Hospitalizacion_list->Recordset)
	$Hospitalizacion_list->Recordset->Close();
?>
<div class="panel-footer ewGridLowerPanel">
<?php if ($Hospitalizacion->CurrentAction <> "gridadd" && $Hospitalizacion->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($Hospitalizacion_list->Pager)) $Hospitalizacion_list->Pager = new cPrevNextPager($Hospitalizacion_list->StartRec, $Hospitalizacion_list->DisplayRecs, $Hospitalizacion_list->TotalRecs) ?>
<?php if ($Hospitalizacion_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($Hospitalizacion_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $Hospitalizacion_list->PageUrl() ?>start=<?php echo $Hospitalizacion_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($Hospitalizacion_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $Hospitalizacion_list->PageUrl() ?>start=<?php echo $Hospitalizacion_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $Hospitalizacion_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($Hospitalizacion_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $Hospitalizacion_list->PageUrl() ?>start=<?php echo $Hospitalizacion_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($Hospitalizacion_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $Hospitalizacion_list->PageUrl() ?>start=<?php echo $Hospitalizacion_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $Hospitalizacion_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $Hospitalizacion_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $Hospitalizacion_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $Hospitalizacion_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($Hospitalizacion_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
</div>
<?php } ?>
<?php if ($Hospitalizacion_list->TotalRecs == 0 && $Hospitalizacion->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($Hospitalizacion_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<script type="text/javascript">
fHospitalizacionlistsrch.Init();
fHospitalizacionlistsrch.FilterList = <?php echo $Hospitalizacion_list->GetFilterList() ?>;
fHospitalizacionlist.Init();
</script>
<?php
$Hospitalizacion_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$Hospitalizacion_list->Page_Terminate();
?>
