<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "Urgenciasinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$Urgencias_list = NULL; // Initialize page object first

class cUrgencias_list extends cUrgencias {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{612F4CEC-277D-477B-ABAC-2B8738F52202}";

	// Table name
	var $TableName = 'Urgencias';

	// Page object name
	var $PageObjName = 'Urgencias_list';

	// Grid form hidden field names
	var $FormName = 'fUrgenciaslist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (Urgencias)
		if (!isset($GLOBALS["Urgencias"]) || get_class($GLOBALS["Urgencias"]) == "cUrgencias") {
			$GLOBALS["Urgencias"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Urgencias"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "Urgenciasadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "Urgenciasdelete.php";
		$this->MultiUpdateUrl = "Urgenciasupdate.php";

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'Urgencias', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fUrgenciaslistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $Urgencias;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($Urgencias);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Restore filter list
			$this->RestoreFilterList();

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Numero_Factura->AdvancedSearch->ToJSON(), ","); // Field Numero_Factura
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_prestador->AdvancedSearch->ToJSON(), ","); // Field Codigo_prestador
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_identificacion_us->AdvancedSearch->ToJSON(), ","); // Field Tipo_identificacion_us
		$sFilterList = ew_Concat($sFilterList, $this->Numero_identificacion_us->AdvancedSearch->ToJSON(), ","); // Field Numero_identificacion_us
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_ingreso->AdvancedSearch->ToJSON(), ","); // Field Fecha_ingreso
		$sFilterList = ew_Concat($sFilterList, $this->Hora_ingreso->AdvancedSearch->ToJSON(), ","); // Field Hora_ingreso
		$sFilterList = ew_Concat($sFilterList, $this->Numero_Autorizacion->AdvancedSearch->ToJSON(), ","); // Field Numero_Autorizacion
		$sFilterList = ew_Concat($sFilterList, $this->Causa_externa->AdvancedSearch->ToJSON(), ","); // Field Causa_externa
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_salida->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_salida
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_rel1->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_rel1
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_rel2->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_rel2
		$sFilterList = ew_Concat($sFilterList, $this->Diagnostico_rel3->AdvancedSearch->ToJSON(), ","); // Field Diagnostico_rel3
		$sFilterList = ew_Concat($sFilterList, $this->Destino_usuario->AdvancedSearch->ToJSON(), ","); // Field Destino_usuario
		$sFilterList = ew_Concat($sFilterList, $this->Estado_salida->AdvancedSearch->ToJSON(), ","); // Field Estado_salida
		$sFilterList = ew_Concat($sFilterList, $this->Causa_basica_muerte->AdvancedSearch->ToJSON(), ","); // Field Causa_basica_muerte
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_salida_usuar->AdvancedSearch->ToJSON(), ","); // Field Fecha_salida_usuar
		$sFilterList = ew_Concat($sFilterList, $this->Hora_salida->AdvancedSearch->ToJSON(), ","); // Field Hora_salida
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_tres->AdvancedSearch->ToJSON(), ","); // Field Codigo_tres
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Numero_Factura
		$this->Numero_Factura->AdvancedSearch->SearchValue = @$filter["x_Numero_Factura"];
		$this->Numero_Factura->AdvancedSearch->SearchOperator = @$filter["z_Numero_Factura"];
		$this->Numero_Factura->AdvancedSearch->SearchCondition = @$filter["v_Numero_Factura"];
		$this->Numero_Factura->AdvancedSearch->SearchValue2 = @$filter["y_Numero_Factura"];
		$this->Numero_Factura->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_Factura"];
		$this->Numero_Factura->AdvancedSearch->Save();

		// Field Codigo_prestador
		$this->Codigo_prestador->AdvancedSearch->SearchValue = @$filter["x_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchOperator = @$filter["z_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchCondition = @$filter["v_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_prestador"];
		$this->Codigo_prestador->AdvancedSearch->Save();

		// Field Tipo_identificacion_us
		$this->Tipo_identificacion_us->AdvancedSearch->SearchValue = @$filter["x_Tipo_identificacion_us"];
		$this->Tipo_identificacion_us->AdvancedSearch->SearchOperator = @$filter["z_Tipo_identificacion_us"];
		$this->Tipo_identificacion_us->AdvancedSearch->SearchCondition = @$filter["v_Tipo_identificacion_us"];
		$this->Tipo_identificacion_us->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_identificacion_us"];
		$this->Tipo_identificacion_us->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_identificacion_us"];
		$this->Tipo_identificacion_us->AdvancedSearch->Save();

		// Field Numero_identificacion_us
		$this->Numero_identificacion_us->AdvancedSearch->SearchValue = @$filter["x_Numero_identificacion_us"];
		$this->Numero_identificacion_us->AdvancedSearch->SearchOperator = @$filter["z_Numero_identificacion_us"];
		$this->Numero_identificacion_us->AdvancedSearch->SearchCondition = @$filter["v_Numero_identificacion_us"];
		$this->Numero_identificacion_us->AdvancedSearch->SearchValue2 = @$filter["y_Numero_identificacion_us"];
		$this->Numero_identificacion_us->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_identificacion_us"];
		$this->Numero_identificacion_us->AdvancedSearch->Save();

		// Field Fecha_ingreso
		$this->Fecha_ingreso->AdvancedSearch->SearchValue = @$filter["x_Fecha_ingreso"];
		$this->Fecha_ingreso->AdvancedSearch->SearchOperator = @$filter["z_Fecha_ingreso"];
		$this->Fecha_ingreso->AdvancedSearch->SearchCondition = @$filter["v_Fecha_ingreso"];
		$this->Fecha_ingreso->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_ingreso"];
		$this->Fecha_ingreso->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_ingreso"];
		$this->Fecha_ingreso->AdvancedSearch->Save();

		// Field Hora_ingreso
		$this->Hora_ingreso->AdvancedSearch->SearchValue = @$filter["x_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchOperator = @$filter["z_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchCondition = @$filter["v_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchValue2 = @$filter["y_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->SearchOperator2 = @$filter["w_Hora_ingreso"];
		$this->Hora_ingreso->AdvancedSearch->Save();

		// Field Numero_Autorizacion
		$this->Numero_Autorizacion->AdvancedSearch->SearchValue = @$filter["x_Numero_Autorizacion"];
		$this->Numero_Autorizacion->AdvancedSearch->SearchOperator = @$filter["z_Numero_Autorizacion"];
		$this->Numero_Autorizacion->AdvancedSearch->SearchCondition = @$filter["v_Numero_Autorizacion"];
		$this->Numero_Autorizacion->AdvancedSearch->SearchValue2 = @$filter["y_Numero_Autorizacion"];
		$this->Numero_Autorizacion->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_Autorizacion"];
		$this->Numero_Autorizacion->AdvancedSearch->Save();

		// Field Causa_externa
		$this->Causa_externa->AdvancedSearch->SearchValue = @$filter["x_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchOperator = @$filter["z_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchCondition = @$filter["v_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchValue2 = @$filter["y_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->SearchOperator2 = @$filter["w_Causa_externa"];
		$this->Causa_externa->AdvancedSearch->Save();

		// Field Diagnostico_salida
		$this->Diagnostico_salida->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_salida"];
		$this->Diagnostico_salida->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_salida"];
		$this->Diagnostico_salida->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_salida"];
		$this->Diagnostico_salida->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_salida"];
		$this->Diagnostico_salida->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_salida"];
		$this->Diagnostico_salida->AdvancedSearch->Save();

		// Field Diagnostico_rel1
		$this->Diagnostico_rel1->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_rel1"];
		$this->Diagnostico_rel1->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_rel1"];
		$this->Diagnostico_rel1->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_rel1"];
		$this->Diagnostico_rel1->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_rel1"];
		$this->Diagnostico_rel1->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_rel1"];
		$this->Diagnostico_rel1->AdvancedSearch->Save();

		// Field Diagnostico_rel2
		$this->Diagnostico_rel2->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_rel2"];
		$this->Diagnostico_rel2->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_rel2"];
		$this->Diagnostico_rel2->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_rel2"];
		$this->Diagnostico_rel2->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_rel2"];
		$this->Diagnostico_rel2->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_rel2"];
		$this->Diagnostico_rel2->AdvancedSearch->Save();

		// Field Diagnostico_rel3
		$this->Diagnostico_rel3->AdvancedSearch->SearchValue = @$filter["x_Diagnostico_rel3"];
		$this->Diagnostico_rel3->AdvancedSearch->SearchOperator = @$filter["z_Diagnostico_rel3"];
		$this->Diagnostico_rel3->AdvancedSearch->SearchCondition = @$filter["v_Diagnostico_rel3"];
		$this->Diagnostico_rel3->AdvancedSearch->SearchValue2 = @$filter["y_Diagnostico_rel3"];
		$this->Diagnostico_rel3->AdvancedSearch->SearchOperator2 = @$filter["w_Diagnostico_rel3"];
		$this->Diagnostico_rel3->AdvancedSearch->Save();

		// Field Destino_usuario
		$this->Destino_usuario->AdvancedSearch->SearchValue = @$filter["x_Destino_usuario"];
		$this->Destino_usuario->AdvancedSearch->SearchOperator = @$filter["z_Destino_usuario"];
		$this->Destino_usuario->AdvancedSearch->SearchCondition = @$filter["v_Destino_usuario"];
		$this->Destino_usuario->AdvancedSearch->SearchValue2 = @$filter["y_Destino_usuario"];
		$this->Destino_usuario->AdvancedSearch->SearchOperator2 = @$filter["w_Destino_usuario"];
		$this->Destino_usuario->AdvancedSearch->Save();

		// Field Estado_salida
		$this->Estado_salida->AdvancedSearch->SearchValue = @$filter["x_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchOperator = @$filter["z_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchCondition = @$filter["v_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchValue2 = @$filter["y_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->SearchOperator2 = @$filter["w_Estado_salida"];
		$this->Estado_salida->AdvancedSearch->Save();

		// Field Causa_basica_muerte
		$this->Causa_basica_muerte->AdvancedSearch->SearchValue = @$filter["x_Causa_basica_muerte"];
		$this->Causa_basica_muerte->AdvancedSearch->SearchOperator = @$filter["z_Causa_basica_muerte"];
		$this->Causa_basica_muerte->AdvancedSearch->SearchCondition = @$filter["v_Causa_basica_muerte"];
		$this->Causa_basica_muerte->AdvancedSearch->SearchValue2 = @$filter["y_Causa_basica_muerte"];
		$this->Causa_basica_muerte->AdvancedSearch->SearchOperator2 = @$filter["w_Causa_basica_muerte"];
		$this->Causa_basica_muerte->AdvancedSearch->Save();

		// Field Fecha_salida_usuar
		$this->Fecha_salida_usuar->AdvancedSearch->SearchValue = @$filter["x_Fecha_salida_usuar"];
		$this->Fecha_salida_usuar->AdvancedSearch->SearchOperator = @$filter["z_Fecha_salida_usuar"];
		$this->Fecha_salida_usuar->AdvancedSearch->SearchCondition = @$filter["v_Fecha_salida_usuar"];
		$this->Fecha_salida_usuar->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_salida_usuar"];
		$this->Fecha_salida_usuar->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_salida_usuar"];
		$this->Fecha_salida_usuar->AdvancedSearch->Save();

		// Field Hora_salida
		$this->Hora_salida->AdvancedSearch->SearchValue = @$filter["x_Hora_salida"];
		$this->Hora_salida->AdvancedSearch->SearchOperator = @$filter["z_Hora_salida"];
		$this->Hora_salida->AdvancedSearch->SearchCondition = @$filter["v_Hora_salida"];
		$this->Hora_salida->AdvancedSearch->SearchValue2 = @$filter["y_Hora_salida"];
		$this->Hora_salida->AdvancedSearch->SearchOperator2 = @$filter["w_Hora_salida"];
		$this->Hora_salida->AdvancedSearch->Save();

		// Field Codigo_tres
		$this->Codigo_tres->AdvancedSearch->SearchValue = @$filter["x_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchOperator = @$filter["z_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchCondition = @$filter["v_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_Factura, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_prestador, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Tipo_identificacion_us, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_identificacion_us, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Fecha_ingreso, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Hora_ingreso, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_Autorizacion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_salida, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_rel1, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_rel2, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Diagnostico_rel3, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Causa_basica_muerte, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Fecha_salida_usuar, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Hora_salida, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_tres, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Numero_Factura); // Numero_Factura
			$this->UpdateSort($this->Codigo_prestador); // Codigo_prestador
			$this->UpdateSort($this->Tipo_identificacion_us); // Tipo_identificacion_us
			$this->UpdateSort($this->Numero_identificacion_us); // Numero_identificacion_us
			$this->UpdateSort($this->Fecha_ingreso); // Fecha_ingreso
			$this->UpdateSort($this->Hora_ingreso); // Hora_ingreso
			$this->UpdateSort($this->Numero_Autorizacion); // Numero_Autorizacion
			$this->UpdateSort($this->Causa_externa); // Causa_externa
			$this->UpdateSort($this->Diagnostico_salida); // Diagnostico_salida
			$this->UpdateSort($this->Diagnostico_rel1); // Diagnostico_rel1
			$this->UpdateSort($this->Diagnostico_rel2); // Diagnostico_rel2
			$this->UpdateSort($this->Diagnostico_rel3); // Diagnostico_rel3
			$this->UpdateSort($this->Destino_usuario); // Destino_usuario
			$this->UpdateSort($this->Estado_salida); // Estado_salida
			$this->UpdateSort($this->Causa_basica_muerte); // Causa_basica_muerte
			$this->UpdateSort($this->Fecha_salida_usuar); // Fecha_salida_usuar
			$this->UpdateSort($this->Hora_salida); // Hora_salida
			$this->UpdateSort($this->Codigo_tres); // Codigo_tres
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Numero_Factura->setSort("");
				$this->Codigo_prestador->setSort("");
				$this->Tipo_identificacion_us->setSort("");
				$this->Numero_identificacion_us->setSort("");
				$this->Fecha_ingreso->setSort("");
				$this->Hora_ingreso->setSort("");
				$this->Numero_Autorizacion->setSort("");
				$this->Causa_externa->setSort("");
				$this->Diagnostico_salida->setSort("");
				$this->Diagnostico_rel1->setSort("");
				$this->Diagnostico_rel2->setSort("");
				$this->Diagnostico_rel3->setSort("");
				$this->Destino_usuario->setSort("");
				$this->Estado_salida->setSort("");
				$this->Causa_basica_muerte->setSort("");
				$this->Fecha_salida_usuar->setSort("");
				$this->Hora_salida->setSort("");
				$this->Codigo_tres->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fUrgenciaslistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fUrgenciaslistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fUrgenciaslist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fUrgenciaslistsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Numero_Factura->setDbValue($rs->fields('Numero_Factura'));
		$this->Codigo_prestador->setDbValue($rs->fields('Codigo_prestador'));
		$this->Tipo_identificacion_us->setDbValue($rs->fields('Tipo_identificacion_us'));
		$this->Numero_identificacion_us->setDbValue($rs->fields('Numero_identificacion_us'));
		$this->Fecha_ingreso->setDbValue($rs->fields('Fecha_ingreso'));
		$this->Hora_ingreso->setDbValue($rs->fields('Hora_ingreso'));
		$this->Numero_Autorizacion->setDbValue($rs->fields('Numero_Autorizacion'));
		$this->Causa_externa->setDbValue($rs->fields('Causa_externa'));
		$this->Diagnostico_salida->setDbValue($rs->fields('Diagnostico_salida'));
		$this->Diagnostico_rel1->setDbValue($rs->fields('Diagnostico_rel1'));
		$this->Diagnostico_rel2->setDbValue($rs->fields('Diagnostico_rel2'));
		$this->Diagnostico_rel3->setDbValue($rs->fields('Diagnostico_rel3'));
		$this->Destino_usuario->setDbValue($rs->fields('Destino_usuario'));
		$this->Estado_salida->setDbValue($rs->fields('Estado_salida'));
		$this->Causa_basica_muerte->setDbValue($rs->fields('Causa_basica_muerte'));
		$this->Fecha_salida_usuar->setDbValue($rs->fields('Fecha_salida_usuar'));
		$this->Hora_salida->setDbValue($rs->fields('Hora_salida'));
		$this->Codigo_tres->setDbValue($rs->fields('Codigo_tres'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Numero_Factura->DbValue = $row['Numero_Factura'];
		$this->Codigo_prestador->DbValue = $row['Codigo_prestador'];
		$this->Tipo_identificacion_us->DbValue = $row['Tipo_identificacion_us'];
		$this->Numero_identificacion_us->DbValue = $row['Numero_identificacion_us'];
		$this->Fecha_ingreso->DbValue = $row['Fecha_ingreso'];
		$this->Hora_ingreso->DbValue = $row['Hora_ingreso'];
		$this->Numero_Autorizacion->DbValue = $row['Numero_Autorizacion'];
		$this->Causa_externa->DbValue = $row['Causa_externa'];
		$this->Diagnostico_salida->DbValue = $row['Diagnostico_salida'];
		$this->Diagnostico_rel1->DbValue = $row['Diagnostico_rel1'];
		$this->Diagnostico_rel2->DbValue = $row['Diagnostico_rel2'];
		$this->Diagnostico_rel3->DbValue = $row['Diagnostico_rel3'];
		$this->Destino_usuario->DbValue = $row['Destino_usuario'];
		$this->Estado_salida->DbValue = $row['Estado_salida'];
		$this->Causa_basica_muerte->DbValue = $row['Causa_basica_muerte'];
		$this->Fecha_salida_usuar->DbValue = $row['Fecha_salida_usuar'];
		$this->Hora_salida->DbValue = $row['Hora_salida'];
		$this->Codigo_tres->DbValue = $row['Codigo_tres'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Numero_Factura
		// Codigo_prestador
		// Tipo_identificacion_us
		// Numero_identificacion_us
		// Fecha_ingreso
		// Hora_ingreso
		// Numero_Autorizacion
		// Causa_externa
		// Diagnostico_salida
		// Diagnostico_rel1
		// Diagnostico_rel2
		// Diagnostico_rel3
		// Destino_usuario
		// Estado_salida
		// Causa_basica_muerte
		// Fecha_salida_usuar
		// Hora_salida
		// Codigo_tres

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Numero_Factura
		$this->Numero_Factura->ViewValue = $this->Numero_Factura->CurrentValue;
		$this->Numero_Factura->ViewCustomAttributes = "";

		// Codigo_prestador
		$this->Codigo_prestador->ViewValue = $this->Codigo_prestador->CurrentValue;
		$this->Codigo_prestador->ViewCustomAttributes = "";

		// Tipo_identificacion_us
		$this->Tipo_identificacion_us->ViewValue = $this->Tipo_identificacion_us->CurrentValue;
		$this->Tipo_identificacion_us->ViewCustomAttributes = "";

		// Numero_identificacion_us
		$this->Numero_identificacion_us->ViewValue = $this->Numero_identificacion_us->CurrentValue;
		$this->Numero_identificacion_us->ViewCustomAttributes = "";

		// Fecha_ingreso
		$this->Fecha_ingreso->ViewValue = $this->Fecha_ingreso->CurrentValue;
		$this->Fecha_ingreso->ViewCustomAttributes = "";

		// Hora_ingreso
		$this->Hora_ingreso->ViewValue = $this->Hora_ingreso->CurrentValue;
		$this->Hora_ingreso->ViewCustomAttributes = "";

		// Numero_Autorizacion
		$this->Numero_Autorizacion->ViewValue = $this->Numero_Autorizacion->CurrentValue;
		$this->Numero_Autorizacion->ViewCustomAttributes = "";

		// Causa_externa
		$this->Causa_externa->ViewValue = $this->Causa_externa->CurrentValue;
		$this->Causa_externa->ViewCustomAttributes = "";

		// Diagnostico_salida
		$this->Diagnostico_salida->ViewValue = $this->Diagnostico_salida->CurrentValue;
		$this->Diagnostico_salida->ViewCustomAttributes = "";

		// Diagnostico_rel1
		$this->Diagnostico_rel1->ViewValue = $this->Diagnostico_rel1->CurrentValue;
		$this->Diagnostico_rel1->ViewCustomAttributes = "";

		// Diagnostico_rel2
		$this->Diagnostico_rel2->ViewValue = $this->Diagnostico_rel2->CurrentValue;
		$this->Diagnostico_rel2->ViewCustomAttributes = "";

		// Diagnostico_rel3
		$this->Diagnostico_rel3->ViewValue = $this->Diagnostico_rel3->CurrentValue;
		$this->Diagnostico_rel3->ViewCustomAttributes = "";

		// Destino_usuario
		$this->Destino_usuario->ViewValue = $this->Destino_usuario->CurrentValue;
		$this->Destino_usuario->ViewCustomAttributes = "";

		// Estado_salida
		$this->Estado_salida->ViewValue = $this->Estado_salida->CurrentValue;
		$this->Estado_salida->ViewCustomAttributes = "";

		// Causa_basica_muerte
		$this->Causa_basica_muerte->ViewValue = $this->Causa_basica_muerte->CurrentValue;
		$this->Causa_basica_muerte->ViewCustomAttributes = "";

		// Fecha_salida_usuar
		$this->Fecha_salida_usuar->ViewValue = $this->Fecha_salida_usuar->CurrentValue;
		$this->Fecha_salida_usuar->ViewCustomAttributes = "";

		// Hora_salida
		$this->Hora_salida->ViewValue = $this->Hora_salida->CurrentValue;
		$this->Hora_salida->ViewCustomAttributes = "";

		// Codigo_tres
		$this->Codigo_tres->ViewValue = $this->Codigo_tres->CurrentValue;
		$this->Codigo_tres->ViewCustomAttributes = "";

			// Numero_Factura
			$this->Numero_Factura->LinkCustomAttributes = "";
			$this->Numero_Factura->HrefValue = "";
			$this->Numero_Factura->TooltipValue = "";

			// Codigo_prestador
			$this->Codigo_prestador->LinkCustomAttributes = "";
			$this->Codigo_prestador->HrefValue = "";
			$this->Codigo_prestador->TooltipValue = "";

			// Tipo_identificacion_us
			$this->Tipo_identificacion_us->LinkCustomAttributes = "";
			$this->Tipo_identificacion_us->HrefValue = "";
			$this->Tipo_identificacion_us->TooltipValue = "";

			// Numero_identificacion_us
			$this->Numero_identificacion_us->LinkCustomAttributes = "";
			$this->Numero_identificacion_us->HrefValue = "";
			$this->Numero_identificacion_us->TooltipValue = "";

			// Fecha_ingreso
			$this->Fecha_ingreso->LinkCustomAttributes = "";
			$this->Fecha_ingreso->HrefValue = "";
			$this->Fecha_ingreso->TooltipValue = "";

			// Hora_ingreso
			$this->Hora_ingreso->LinkCustomAttributes = "";
			$this->Hora_ingreso->HrefValue = "";
			$this->Hora_ingreso->TooltipValue = "";

			// Numero_Autorizacion
			$this->Numero_Autorizacion->LinkCustomAttributes = "";
			$this->Numero_Autorizacion->HrefValue = "";
			$this->Numero_Autorizacion->TooltipValue = "";

			// Causa_externa
			$this->Causa_externa->LinkCustomAttributes = "";
			$this->Causa_externa->HrefValue = "";
			$this->Causa_externa->TooltipValue = "";

			// Diagnostico_salida
			$this->Diagnostico_salida->LinkCustomAttributes = "";
			$this->Diagnostico_salida->HrefValue = "";
			$this->Diagnostico_salida->TooltipValue = "";

			// Diagnostico_rel1
			$this->Diagnostico_rel1->LinkCustomAttributes = "";
			$this->Diagnostico_rel1->HrefValue = "";
			$this->Diagnostico_rel1->TooltipValue = "";

			// Diagnostico_rel2
			$this->Diagnostico_rel2->LinkCustomAttributes = "";
			$this->Diagnostico_rel2->HrefValue = "";
			$this->Diagnostico_rel2->TooltipValue = "";

			// Diagnostico_rel3
			$this->Diagnostico_rel3->LinkCustomAttributes = "";
			$this->Diagnostico_rel3->HrefValue = "";
			$this->Diagnostico_rel3->TooltipValue = "";

			// Destino_usuario
			$this->Destino_usuario->LinkCustomAttributes = "";
			$this->Destino_usuario->HrefValue = "";
			$this->Destino_usuario->TooltipValue = "";

			// Estado_salida
			$this->Estado_salida->LinkCustomAttributes = "";
			$this->Estado_salida->HrefValue = "";
			$this->Estado_salida->TooltipValue = "";

			// Causa_basica_muerte
			$this->Causa_basica_muerte->LinkCustomAttributes = "";
			$this->Causa_basica_muerte->HrefValue = "";
			$this->Causa_basica_muerte->TooltipValue = "";

			// Fecha_salida_usuar
			$this->Fecha_salida_usuar->LinkCustomAttributes = "";
			$this->Fecha_salida_usuar->HrefValue = "";
			$this->Fecha_salida_usuar->TooltipValue = "";

			// Hora_salida
			$this->Hora_salida->LinkCustomAttributes = "";
			$this->Hora_salida->HrefValue = "";
			$this->Hora_salida->TooltipValue = "";

			// Codigo_tres
			$this->Codigo_tres->LinkCustomAttributes = "";
			$this->Codigo_tres->HrefValue = "";
			$this->Codigo_tres->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($Urgencias_list)) $Urgencias_list = new cUrgencias_list();

// Page init
$Urgencias_list->Page_Init();

// Page main
$Urgencias_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Urgencias_list->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fUrgenciaslist = new ew_Form("fUrgenciaslist", "list");
fUrgenciaslist.FormKeyCountName = '<?php echo $Urgencias_list->FormKeyCountName ?>';

// Form_CustomValidate event
fUrgenciaslist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fUrgenciaslist.ValidateRequired = true;
<?php } else { ?>
fUrgenciaslist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

var CurrentSearchForm = fUrgenciaslistsrch = new ew_Form("fUrgenciaslistsrch");
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php if ($Urgencias_list->TotalRecs > 0 && $Urgencias_list->ExportOptions->Visible()) { ?>
<?php $Urgencias_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($Urgencias_list->SearchOptions->Visible()) { ?>
<?php $Urgencias_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($Urgencias_list->FilterOptions->Visible()) { ?>
<?php $Urgencias_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php
	$bSelectLimit = $Urgencias_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($Urgencias_list->TotalRecs <= 0)
			$Urgencias_list->TotalRecs = $Urgencias->SelectRecordCount();
	} else {
		if (!$Urgencias_list->Recordset && ($Urgencias_list->Recordset = $Urgencias_list->LoadRecordset()))
			$Urgencias_list->TotalRecs = $Urgencias_list->Recordset->RecordCount();
	}
	$Urgencias_list->StartRec = 1;
	if ($Urgencias_list->DisplayRecs <= 0 || ($Urgencias->Export <> "" && $Urgencias->ExportAll)) // Display all records
		$Urgencias_list->DisplayRecs = $Urgencias_list->TotalRecs;
	if (!($Urgencias->Export <> "" && $Urgencias->ExportAll))
		$Urgencias_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$Urgencias_list->Recordset = $Urgencias_list->LoadRecordset($Urgencias_list->StartRec-1, $Urgencias_list->DisplayRecs);

	// Set no record found message
	if ($Urgencias->CurrentAction == "" && $Urgencias_list->TotalRecs == 0) {
		if ($Urgencias_list->SearchWhere == "0=101")
			$Urgencias_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$Urgencias_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$Urgencias_list->RenderOtherOptions();
?>
<?php if ($Urgencias->Export == "" && $Urgencias->CurrentAction == "") { ?>
<form name="fUrgenciaslistsrch" id="fUrgenciaslistsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($Urgencias_list->SearchWhere <> "") ? " in" : " in"; ?>
<div id="fUrgenciaslistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="Urgencias">
	<div class="ewBasicSearch">
<div id="xsr_1" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($Urgencias_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($Urgencias_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $Urgencias_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($Urgencias_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($Urgencias_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($Urgencias_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($Urgencias_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php $Urgencias_list->ShowPageHeader(); ?>
<?php
$Urgencias_list->ShowMessage();
?>
<?php if ($Urgencias_list->TotalRecs > 0 || $Urgencias->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<form name="fUrgenciaslist" id="fUrgenciaslist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($Urgencias_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $Urgencias_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="Urgencias">
<div id="gmp_Urgencias" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($Urgencias_list->TotalRecs > 0) { ?>
<table id="tbl_Urgenciaslist" class="table ewTable">
<?php echo $Urgencias->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$Urgencias_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$Urgencias_list->RenderListOptions();

// Render list options (header, left)
$Urgencias_list->ListOptions->Render("header", "left");
?>
<?php if ($Urgencias->Numero_Factura->Visible) { // Numero_Factura ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Numero_Factura) == "") { ?>
		<th data-name="Numero_Factura"><div id="elh_Urgencias_Numero_Factura" class="Urgencias_Numero_Factura"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Numero_Factura->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_Factura"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Numero_Factura) ?>',1);"><div id="elh_Urgencias_Numero_Factura" class="Urgencias_Numero_Factura">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Numero_Factura->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Numero_Factura->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Numero_Factura->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Codigo_prestador->Visible) { // Codigo_prestador ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Codigo_prestador) == "") { ?>
		<th data-name="Codigo_prestador"><div id="elh_Urgencias_Codigo_prestador" class="Urgencias_Codigo_prestador"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Codigo_prestador->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_prestador"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Codigo_prestador) ?>',1);"><div id="elh_Urgencias_Codigo_prestador" class="Urgencias_Codigo_prestador">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Codigo_prestador->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Codigo_prestador->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Codigo_prestador->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Tipo_identificacion_us->Visible) { // Tipo_identificacion_us ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Tipo_identificacion_us) == "") { ?>
		<th data-name="Tipo_identificacion_us"><div id="elh_Urgencias_Tipo_identificacion_us" class="Urgencias_Tipo_identificacion_us"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Tipo_identificacion_us->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tipo_identificacion_us"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Tipo_identificacion_us) ?>',1);"><div id="elh_Urgencias_Tipo_identificacion_us" class="Urgencias_Tipo_identificacion_us">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Tipo_identificacion_us->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Tipo_identificacion_us->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Tipo_identificacion_us->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Numero_identificacion_us->Visible) { // Numero_identificacion_us ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Numero_identificacion_us) == "") { ?>
		<th data-name="Numero_identificacion_us"><div id="elh_Urgencias_Numero_identificacion_us" class="Urgencias_Numero_identificacion_us"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Numero_identificacion_us->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_identificacion_us"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Numero_identificacion_us) ?>',1);"><div id="elh_Urgencias_Numero_identificacion_us" class="Urgencias_Numero_identificacion_us">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Numero_identificacion_us->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Numero_identificacion_us->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Numero_identificacion_us->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Fecha_ingreso->Visible) { // Fecha_ingreso ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Fecha_ingreso) == "") { ?>
		<th data-name="Fecha_ingreso"><div id="elh_Urgencias_Fecha_ingreso" class="Urgencias_Fecha_ingreso"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Fecha_ingreso->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_ingreso"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Fecha_ingreso) ?>',1);"><div id="elh_Urgencias_Fecha_ingreso" class="Urgencias_Fecha_ingreso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Fecha_ingreso->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Fecha_ingreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Fecha_ingreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Hora_ingreso->Visible) { // Hora_ingreso ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Hora_ingreso) == "") { ?>
		<th data-name="Hora_ingreso"><div id="elh_Urgencias_Hora_ingreso" class="Urgencias_Hora_ingreso"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Hora_ingreso->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hora_ingreso"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Hora_ingreso) ?>',1);"><div id="elh_Urgencias_Hora_ingreso" class="Urgencias_Hora_ingreso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Hora_ingreso->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Hora_ingreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Hora_ingreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Numero_Autorizacion->Visible) { // Numero_Autorizacion ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Numero_Autorizacion) == "") { ?>
		<th data-name="Numero_Autorizacion"><div id="elh_Urgencias_Numero_Autorizacion" class="Urgencias_Numero_Autorizacion"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Numero_Autorizacion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_Autorizacion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Numero_Autorizacion) ?>',1);"><div id="elh_Urgencias_Numero_Autorizacion" class="Urgencias_Numero_Autorizacion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Numero_Autorizacion->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Numero_Autorizacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Numero_Autorizacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Causa_externa->Visible) { // Causa_externa ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Causa_externa) == "") { ?>
		<th data-name="Causa_externa"><div id="elh_Urgencias_Causa_externa" class="Urgencias_Causa_externa"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Causa_externa->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Causa_externa"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Causa_externa) ?>',1);"><div id="elh_Urgencias_Causa_externa" class="Urgencias_Causa_externa">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Causa_externa->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Causa_externa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Causa_externa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Diagnostico_salida->Visible) { // Diagnostico_salida ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Diagnostico_salida) == "") { ?>
		<th data-name="Diagnostico_salida"><div id="elh_Urgencias_Diagnostico_salida" class="Urgencias_Diagnostico_salida"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_salida->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_salida"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Diagnostico_salida) ?>',1);"><div id="elh_Urgencias_Diagnostico_salida" class="Urgencias_Diagnostico_salida">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_salida->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Diagnostico_salida->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Diagnostico_salida->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Diagnostico_rel1->Visible) { // Diagnostico_rel1 ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Diagnostico_rel1) == "") { ?>
		<th data-name="Diagnostico_rel1"><div id="elh_Urgencias_Diagnostico_rel1" class="Urgencias_Diagnostico_rel1"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_rel1->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_rel1"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Diagnostico_rel1) ?>',1);"><div id="elh_Urgencias_Diagnostico_rel1" class="Urgencias_Diagnostico_rel1">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_rel1->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Diagnostico_rel1->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Diagnostico_rel1->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Diagnostico_rel2->Visible) { // Diagnostico_rel2 ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Diagnostico_rel2) == "") { ?>
		<th data-name="Diagnostico_rel2"><div id="elh_Urgencias_Diagnostico_rel2" class="Urgencias_Diagnostico_rel2"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_rel2->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_rel2"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Diagnostico_rel2) ?>',1);"><div id="elh_Urgencias_Diagnostico_rel2" class="Urgencias_Diagnostico_rel2">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_rel2->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Diagnostico_rel2->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Diagnostico_rel2->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Diagnostico_rel3->Visible) { // Diagnostico_rel3 ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Diagnostico_rel3) == "") { ?>
		<th data-name="Diagnostico_rel3"><div id="elh_Urgencias_Diagnostico_rel3" class="Urgencias_Diagnostico_rel3"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_rel3->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Diagnostico_rel3"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Diagnostico_rel3) ?>',1);"><div id="elh_Urgencias_Diagnostico_rel3" class="Urgencias_Diagnostico_rel3">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Diagnostico_rel3->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Diagnostico_rel3->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Diagnostico_rel3->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Destino_usuario->Visible) { // Destino_usuario ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Destino_usuario) == "") { ?>
		<th data-name="Destino_usuario"><div id="elh_Urgencias_Destino_usuario" class="Urgencias_Destino_usuario"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Destino_usuario->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Destino_usuario"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Destino_usuario) ?>',1);"><div id="elh_Urgencias_Destino_usuario" class="Urgencias_Destino_usuario">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Destino_usuario->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Destino_usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Destino_usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Estado_salida->Visible) { // Estado_salida ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Estado_salida) == "") { ?>
		<th data-name="Estado_salida"><div id="elh_Urgencias_Estado_salida" class="Urgencias_Estado_salida"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Estado_salida->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Estado_salida"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Estado_salida) ?>',1);"><div id="elh_Urgencias_Estado_salida" class="Urgencias_Estado_salida">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Estado_salida->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Estado_salida->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Estado_salida->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Causa_basica_muerte->Visible) { // Causa_basica_muerte ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Causa_basica_muerte) == "") { ?>
		<th data-name="Causa_basica_muerte"><div id="elh_Urgencias_Causa_basica_muerte" class="Urgencias_Causa_basica_muerte"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Causa_basica_muerte->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Causa_basica_muerte"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Causa_basica_muerte) ?>',1);"><div id="elh_Urgencias_Causa_basica_muerte" class="Urgencias_Causa_basica_muerte">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Causa_basica_muerte->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Causa_basica_muerte->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Causa_basica_muerte->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Fecha_salida_usuar->Visible) { // Fecha_salida_usuar ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Fecha_salida_usuar) == "") { ?>
		<th data-name="Fecha_salida_usuar"><div id="elh_Urgencias_Fecha_salida_usuar" class="Urgencias_Fecha_salida_usuar"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Fecha_salida_usuar->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_salida_usuar"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Fecha_salida_usuar) ?>',1);"><div id="elh_Urgencias_Fecha_salida_usuar" class="Urgencias_Fecha_salida_usuar">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Fecha_salida_usuar->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Fecha_salida_usuar->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Fecha_salida_usuar->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Hora_salida->Visible) { // Hora_salida ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Hora_salida) == "") { ?>
		<th data-name="Hora_salida"><div id="elh_Urgencias_Hora_salida" class="Urgencias_Hora_salida"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Hora_salida->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hora_salida"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Hora_salida) ?>',1);"><div id="elh_Urgencias_Hora_salida" class="Urgencias_Hora_salida">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Hora_salida->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Hora_salida->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Hora_salida->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($Urgencias->Codigo_tres->Visible) { // Codigo_tres ?>
	<?php if ($Urgencias->SortUrl($Urgencias->Codigo_tres) == "") { ?>
		<th data-name="Codigo_tres"><div id="elh_Urgencias_Codigo_tres" class="Urgencias_Codigo_tres"><div class="ewTableHeaderCaption"><?php echo $Urgencias->Codigo_tres->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_tres"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $Urgencias->SortUrl($Urgencias->Codigo_tres) ?>',1);"><div id="elh_Urgencias_Codigo_tres" class="Urgencias_Codigo_tres">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $Urgencias->Codigo_tres->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($Urgencias->Codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Urgencias->Codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$Urgencias_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($Urgencias->ExportAll && $Urgencias->Export <> "") {
	$Urgencias_list->StopRec = $Urgencias_list->TotalRecs;
} else {

	// Set the last record to display
	if ($Urgencias_list->TotalRecs > $Urgencias_list->StartRec + $Urgencias_list->DisplayRecs - 1)
		$Urgencias_list->StopRec = $Urgencias_list->StartRec + $Urgencias_list->DisplayRecs - 1;
	else
		$Urgencias_list->StopRec = $Urgencias_list->TotalRecs;
}
$Urgencias_list->RecCnt = $Urgencias_list->StartRec - 1;
if ($Urgencias_list->Recordset && !$Urgencias_list->Recordset->EOF) {
	$Urgencias_list->Recordset->MoveFirst();
	$bSelectLimit = $Urgencias_list->UseSelectLimit;
	if (!$bSelectLimit && $Urgencias_list->StartRec > 1)
		$Urgencias_list->Recordset->Move($Urgencias_list->StartRec - 1);
} elseif (!$Urgencias->AllowAddDeleteRow && $Urgencias_list->StopRec == 0) {
	$Urgencias_list->StopRec = $Urgencias->GridAddRowCount;
}

// Initialize aggregate
$Urgencias->RowType = EW_ROWTYPE_AGGREGATEINIT;
$Urgencias->ResetAttrs();
$Urgencias_list->RenderRow();
while ($Urgencias_list->RecCnt < $Urgencias_list->StopRec) {
	$Urgencias_list->RecCnt++;
	if (intval($Urgencias_list->RecCnt) >= intval($Urgencias_list->StartRec)) {
		$Urgencias_list->RowCnt++;

		// Set up key count
		$Urgencias_list->KeyCount = $Urgencias_list->RowIndex;

		// Init row class and style
		$Urgencias->ResetAttrs();
		$Urgencias->CssClass = "";
		if ($Urgencias->CurrentAction == "gridadd") {
		} else {
			$Urgencias_list->LoadRowValues($Urgencias_list->Recordset); // Load row values
		}
		$Urgencias->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$Urgencias->RowAttrs = array_merge($Urgencias->RowAttrs, array('data-rowindex'=>$Urgencias_list->RowCnt, 'id'=>'r' . $Urgencias_list->RowCnt . '_Urgencias', 'data-rowtype'=>$Urgencias->RowType));

		// Render row
		$Urgencias_list->RenderRow();

		// Render list options
		$Urgencias_list->RenderListOptions();
?>
	<tr<?php echo $Urgencias->RowAttributes() ?>>
<?php

// Render list options (body, left)
$Urgencias_list->ListOptions->Render("body", "left", $Urgencias_list->RowCnt);
?>
	<?php if ($Urgencias->Numero_Factura->Visible) { // Numero_Factura ?>
		<td data-name="Numero_Factura"<?php echo $Urgencias->Numero_Factura->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Numero_Factura" class="Urgencias_Numero_Factura">
<span<?php echo $Urgencias->Numero_Factura->ViewAttributes() ?>>
<?php echo $Urgencias->Numero_Factura->ListViewValue() ?></span>
</span>
<a id="<?php echo $Urgencias_list->PageObjName . "_row_" . $Urgencias_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($Urgencias->Codigo_prestador->Visible) { // Codigo_prestador ?>
		<td data-name="Codigo_prestador"<?php echo $Urgencias->Codigo_prestador->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Codigo_prestador" class="Urgencias_Codigo_prestador">
<span<?php echo $Urgencias->Codigo_prestador->ViewAttributes() ?>>
<?php echo $Urgencias->Codigo_prestador->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Tipo_identificacion_us->Visible) { // Tipo_identificacion_us ?>
		<td data-name="Tipo_identificacion_us"<?php echo $Urgencias->Tipo_identificacion_us->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Tipo_identificacion_us" class="Urgencias_Tipo_identificacion_us">
<span<?php echo $Urgencias->Tipo_identificacion_us->ViewAttributes() ?>>
<?php echo $Urgencias->Tipo_identificacion_us->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Numero_identificacion_us->Visible) { // Numero_identificacion_us ?>
		<td data-name="Numero_identificacion_us"<?php echo $Urgencias->Numero_identificacion_us->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Numero_identificacion_us" class="Urgencias_Numero_identificacion_us">
<span<?php echo $Urgencias->Numero_identificacion_us->ViewAttributes() ?>>
<?php echo $Urgencias->Numero_identificacion_us->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Fecha_ingreso->Visible) { // Fecha_ingreso ?>
		<td data-name="Fecha_ingreso"<?php echo $Urgencias->Fecha_ingreso->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Fecha_ingreso" class="Urgencias_Fecha_ingreso">
<span<?php echo $Urgencias->Fecha_ingreso->ViewAttributes() ?>>
<?php echo $Urgencias->Fecha_ingreso->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Hora_ingreso->Visible) { // Hora_ingreso ?>
		<td data-name="Hora_ingreso"<?php echo $Urgencias->Hora_ingreso->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Hora_ingreso" class="Urgencias_Hora_ingreso">
<span<?php echo $Urgencias->Hora_ingreso->ViewAttributes() ?>>
<?php echo $Urgencias->Hora_ingreso->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Numero_Autorizacion->Visible) { // Numero_Autorizacion ?>
		<td data-name="Numero_Autorizacion"<?php echo $Urgencias->Numero_Autorizacion->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Numero_Autorizacion" class="Urgencias_Numero_Autorizacion">
<span<?php echo $Urgencias->Numero_Autorizacion->ViewAttributes() ?>>
<?php echo $Urgencias->Numero_Autorizacion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Causa_externa->Visible) { // Causa_externa ?>
		<td data-name="Causa_externa"<?php echo $Urgencias->Causa_externa->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Causa_externa" class="Urgencias_Causa_externa">
<span<?php echo $Urgencias->Causa_externa->ViewAttributes() ?>>
<?php echo $Urgencias->Causa_externa->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Diagnostico_salida->Visible) { // Diagnostico_salida ?>
		<td data-name="Diagnostico_salida"<?php echo $Urgencias->Diagnostico_salida->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Diagnostico_salida" class="Urgencias_Diagnostico_salida">
<span<?php echo $Urgencias->Diagnostico_salida->ViewAttributes() ?>>
<?php echo $Urgencias->Diagnostico_salida->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Diagnostico_rel1->Visible) { // Diagnostico_rel1 ?>
		<td data-name="Diagnostico_rel1"<?php echo $Urgencias->Diagnostico_rel1->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Diagnostico_rel1" class="Urgencias_Diagnostico_rel1">
<span<?php echo $Urgencias->Diagnostico_rel1->ViewAttributes() ?>>
<?php echo $Urgencias->Diagnostico_rel1->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Diagnostico_rel2->Visible) { // Diagnostico_rel2 ?>
		<td data-name="Diagnostico_rel2"<?php echo $Urgencias->Diagnostico_rel2->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Diagnostico_rel2" class="Urgencias_Diagnostico_rel2">
<span<?php echo $Urgencias->Diagnostico_rel2->ViewAttributes() ?>>
<?php echo $Urgencias->Diagnostico_rel2->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Diagnostico_rel3->Visible) { // Diagnostico_rel3 ?>
		<td data-name="Diagnostico_rel3"<?php echo $Urgencias->Diagnostico_rel3->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Diagnostico_rel3" class="Urgencias_Diagnostico_rel3">
<span<?php echo $Urgencias->Diagnostico_rel3->ViewAttributes() ?>>
<?php echo $Urgencias->Diagnostico_rel3->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Destino_usuario->Visible) { // Destino_usuario ?>
		<td data-name="Destino_usuario"<?php echo $Urgencias->Destino_usuario->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Destino_usuario" class="Urgencias_Destino_usuario">
<span<?php echo $Urgencias->Destino_usuario->ViewAttributes() ?>>
<?php echo $Urgencias->Destino_usuario->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Estado_salida->Visible) { // Estado_salida ?>
		<td data-name="Estado_salida"<?php echo $Urgencias->Estado_salida->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Estado_salida" class="Urgencias_Estado_salida">
<span<?php echo $Urgencias->Estado_salida->ViewAttributes() ?>>
<?php echo $Urgencias->Estado_salida->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Causa_basica_muerte->Visible) { // Causa_basica_muerte ?>
		<td data-name="Causa_basica_muerte"<?php echo $Urgencias->Causa_basica_muerte->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Causa_basica_muerte" class="Urgencias_Causa_basica_muerte">
<span<?php echo $Urgencias->Causa_basica_muerte->ViewAttributes() ?>>
<?php echo $Urgencias->Causa_basica_muerte->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Fecha_salida_usuar->Visible) { // Fecha_salida_usuar ?>
		<td data-name="Fecha_salida_usuar"<?php echo $Urgencias->Fecha_salida_usuar->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Fecha_salida_usuar" class="Urgencias_Fecha_salida_usuar">
<span<?php echo $Urgencias->Fecha_salida_usuar->ViewAttributes() ?>>
<?php echo $Urgencias->Fecha_salida_usuar->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Hora_salida->Visible) { // Hora_salida ?>
		<td data-name="Hora_salida"<?php echo $Urgencias->Hora_salida->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Hora_salida" class="Urgencias_Hora_salida">
<span<?php echo $Urgencias->Hora_salida->ViewAttributes() ?>>
<?php echo $Urgencias->Hora_salida->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($Urgencias->Codigo_tres->Visible) { // Codigo_tres ?>
		<td data-name="Codigo_tres"<?php echo $Urgencias->Codigo_tres->CellAttributes() ?>>
<span id="el<?php echo $Urgencias_list->RowCnt ?>_Urgencias_Codigo_tres" class="Urgencias_Codigo_tres">
<span<?php echo $Urgencias->Codigo_tres->ViewAttributes() ?>>
<?php echo $Urgencias->Codigo_tres->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$Urgencias_list->ListOptions->Render("body", "right", $Urgencias_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($Urgencias->CurrentAction <> "gridadd")
		$Urgencias_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($Urgencias->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($Urgencias_list->Recordset)
	$Urgencias_list->Recordset->Close();
?>
<div class="panel-footer ewGridLowerPanel">
<?php if ($Urgencias->CurrentAction <> "gridadd" && $Urgencias->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($Urgencias_list->Pager)) $Urgencias_list->Pager = new cPrevNextPager($Urgencias_list->StartRec, $Urgencias_list->DisplayRecs, $Urgencias_list->TotalRecs) ?>
<?php if ($Urgencias_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($Urgencias_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $Urgencias_list->PageUrl() ?>start=<?php echo $Urgencias_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($Urgencias_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $Urgencias_list->PageUrl() ?>start=<?php echo $Urgencias_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $Urgencias_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($Urgencias_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $Urgencias_list->PageUrl() ?>start=<?php echo $Urgencias_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($Urgencias_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $Urgencias_list->PageUrl() ?>start=<?php echo $Urgencias_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $Urgencias_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $Urgencias_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $Urgencias_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $Urgencias_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($Urgencias_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
</div>
<?php } ?>
<?php if ($Urgencias_list->TotalRecs == 0 && $Urgencias->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($Urgencias_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<script type="text/javascript">
fUrgenciaslistsrch.Init();
fUrgenciaslistsrch.FilterList = <?php echo $Urgencias_list->GetFilterList() ?>;
fUrgenciaslist.Init();
</script>
<?php
$Urgencias_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$Urgencias_list->Page_Terminate();
?>
