<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "consulta_general_2021info.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$consulta_general_2021_list = NULL; // Initialize page object first

class cconsulta_general_2021_list extends cconsulta_general_2021 {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{034B1A10-E944-4CA3-9700-945506084CBC}";

	// Table name
	var $TableName = 'consulta general 2021';

	// Page object name
	var $PageObjName = 'consulta_general_2021_list';

	// Grid form hidden field names
	var $FormName = 'fconsulta_general_2021list';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (consulta_general_2021)
		if (!isset($GLOBALS["consulta_general_2021"]) || get_class($GLOBALS["consulta_general_2021"]) == "cconsulta_general_2021") {
			$GLOBALS["consulta_general_2021"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["consulta_general_2021"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "consulta_general_2021add.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "consulta_general_2021delete.php";
		$this->MultiUpdateUrl = "consulta_general_2021update.php";

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'consulta general 2021', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fconsulta_general_2021listsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();
		$this->Count_Contador->Visible = !$this->IsAddOrEdit();
		$this->cuadro->Visible = !$this->IsAddOrEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $consulta_general_2021;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($consulta_general_2021);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Restore filter list
			$this->RestoreFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Count_Contador->AdvancedSearch->ToJSON(), ","); // Field Count_Contador
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_tres->AdvancedSearch->ToJSON(), ","); // Field Codigo_tres
		$sFilterList = ew_Concat($sFilterList, $this->Titulo_codigo_tres->AdvancedSearch->ToJSON(), ","); // Field Titulo_codigo_tres
		$sFilterList = ew_Concat($sFilterList, $this->Sexo->AdvancedSearch->ToJSON(), ","); // Field Sexo
		$sFilterList = ew_Concat($sFilterList, $this->Unidad_edad->AdvancedSearch->ToJSON(), ","); // Field Unidad_edad
		$sFilterList = ew_Concat($sFilterList, $this->Edad->AdvancedSearch->ToJSON(), ","); // Field Edad
		$sFilterList = ew_Concat($sFilterList, $this->cuadro->AdvancedSearch->ToJSON(), ","); // Field cuadro
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Count_Contador
		$this->Count_Contador->AdvancedSearch->SearchValue = @$filter["x_Count_Contador"];
		$this->Count_Contador->AdvancedSearch->SearchOperator = @$filter["z_Count_Contador"];
		$this->Count_Contador->AdvancedSearch->SearchCondition = @$filter["v_Count_Contador"];
		$this->Count_Contador->AdvancedSearch->SearchValue2 = @$filter["y_Count_Contador"];
		$this->Count_Contador->AdvancedSearch->SearchOperator2 = @$filter["w_Count_Contador"];
		$this->Count_Contador->AdvancedSearch->Save();

		// Field Codigo_tres
		$this->Codigo_tres->AdvancedSearch->SearchValue = @$filter["x_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchOperator = @$filter["z_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchCondition = @$filter["v_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->Save();

		// Field Titulo_codigo_tres
		$this->Titulo_codigo_tres->AdvancedSearch->SearchValue = @$filter["x_Titulo_codigo_tres"];
		$this->Titulo_codigo_tres->AdvancedSearch->SearchOperator = @$filter["z_Titulo_codigo_tres"];
		$this->Titulo_codigo_tres->AdvancedSearch->SearchCondition = @$filter["v_Titulo_codigo_tres"];
		$this->Titulo_codigo_tres->AdvancedSearch->SearchValue2 = @$filter["y_Titulo_codigo_tres"];
		$this->Titulo_codigo_tres->AdvancedSearch->SearchOperator2 = @$filter["w_Titulo_codigo_tres"];
		$this->Titulo_codigo_tres->AdvancedSearch->Save();

		// Field Sexo
		$this->Sexo->AdvancedSearch->SearchValue = @$filter["x_Sexo"];
		$this->Sexo->AdvancedSearch->SearchOperator = @$filter["z_Sexo"];
		$this->Sexo->AdvancedSearch->SearchCondition = @$filter["v_Sexo"];
		$this->Sexo->AdvancedSearch->SearchValue2 = @$filter["y_Sexo"];
		$this->Sexo->AdvancedSearch->SearchOperator2 = @$filter["w_Sexo"];
		$this->Sexo->AdvancedSearch->Save();

		// Field Unidad_edad
		$this->Unidad_edad->AdvancedSearch->SearchValue = @$filter["x_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchOperator = @$filter["z_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchCondition = @$filter["v_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchValue2 = @$filter["y_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchOperator2 = @$filter["w_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->Save();

		// Field Edad
		$this->Edad->AdvancedSearch->SearchValue = @$filter["x_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator = @$filter["z_Edad"];
		$this->Edad->AdvancedSearch->SearchCondition = @$filter["v_Edad"];
		$this->Edad->AdvancedSearch->SearchValue2 = @$filter["y_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator2 = @$filter["w_Edad"];
		$this->Edad->AdvancedSearch->Save();

		// Field cuadro
		$this->cuadro->AdvancedSearch->SearchValue = @$filter["x_cuadro"];
		$this->cuadro->AdvancedSearch->SearchOperator = @$filter["z_cuadro"];
		$this->cuadro->AdvancedSearch->SearchCondition = @$filter["v_cuadro"];
		$this->cuadro->AdvancedSearch->SearchValue2 = @$filter["y_cuadro"];
		$this->cuadro->AdvancedSearch->SearchOperator2 = @$filter["w_cuadro"];
		$this->cuadro->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		$this->BuildSearchSql($sWhere, $this->Count_Contador, $Default, FALSE); // Count_Contador
		$this->BuildSearchSql($sWhere, $this->Codigo_tres, $Default, FALSE); // Codigo_tres
		$this->BuildSearchSql($sWhere, $this->Titulo_codigo_tres, $Default, FALSE); // Titulo_codigo_tres
		$this->BuildSearchSql($sWhere, $this->Sexo, $Default, TRUE); // Sexo
		$this->BuildSearchSql($sWhere, $this->Unidad_edad, $Default, FALSE); // Unidad_edad
		$this->BuildSearchSql($sWhere, $this->Edad, $Default, FALSE); // Edad
		$this->BuildSearchSql($sWhere, $this->cuadro, $Default, TRUE); // cuadro

		// Set up search parm
		if (!$Default && $sWhere <> "") {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->Count_Contador->AdvancedSearch->Save(); // Count_Contador
			$this->Codigo_tres->AdvancedSearch->Save(); // Codigo_tres
			$this->Titulo_codigo_tres->AdvancedSearch->Save(); // Titulo_codigo_tres
			$this->Sexo->AdvancedSearch->Save(); // Sexo
			$this->Unidad_edad->AdvancedSearch->Save(); // Unidad_edad
			$this->Edad->AdvancedSearch->Save(); // Edad
			$this->cuadro->AdvancedSearch->Save(); // cuadro
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = substr($Fld->FldVar, 2);
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";

		//$FldVal = ew_StripSlashes($FldVal);
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);

		//$FldVal2 = ew_StripSlashes($FldVal2);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1 || $FldOpr <> "LIKE" ||
			($FldOpr2 <> "LIKE" && $FldVal2 <> ""))
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_tres, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Titulo_codigo_tres, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Sexo, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Unidad_edad, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Edad, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->Count_Contador->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Codigo_tres->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Titulo_codigo_tres->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Sexo->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Unidad_edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->cuadro->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->Count_Contador->AdvancedSearch->UnsetSession();
		$this->Codigo_tres->AdvancedSearch->UnsetSession();
		$this->Titulo_codigo_tres->AdvancedSearch->UnsetSession();
		$this->Sexo->AdvancedSearch->UnsetSession();
		$this->Unidad_edad->AdvancedSearch->UnsetSession();
		$this->Edad->AdvancedSearch->UnsetSession();
		$this->cuadro->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->Count_Contador->AdvancedSearch->Load();
		$this->Codigo_tres->AdvancedSearch->Load();
		$this->Titulo_codigo_tres->AdvancedSearch->Load();
		$this->Sexo->AdvancedSearch->Load();
		$this->Unidad_edad->AdvancedSearch->Load();
		$this->Edad->AdvancedSearch->Load();
		$this->cuadro->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Count_Contador); // Count_Contador
			$this->UpdateSort($this->Codigo_tres); // Codigo_tres
			$this->UpdateSort($this->Titulo_codigo_tres); // Titulo_codigo_tres
			$this->UpdateSort($this->Sexo); // Sexo
			$this->UpdateSort($this->Unidad_edad); // Unidad_edad
			$this->UpdateSort($this->Edad); // Edad
			$this->UpdateSort($this->cuadro); // cuadro
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Count_Contador->setSort("");
				$this->Codigo_tres->setSort("");
				$this->Titulo_codigo_tres->setSort("");
				$this->Sexo->setSort("");
				$this->Unidad_edad->setSort("");
				$this->Edad->setSort("");
				$this->cuadro->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fconsulta_general_2021listsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fconsulta_general_2021listsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fconsulta_general_2021list}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fconsulta_general_2021listsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// Count_Contador

		$this->Count_Contador->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Count_Contador"]);
		if ($this->Count_Contador->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Count_Contador->AdvancedSearch->SearchOperator = @$_GET["z_Count_Contador"];

		// Codigo_tres
		$this->Codigo_tres->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Codigo_tres"]);
		if ($this->Codigo_tres->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Codigo_tres->AdvancedSearch->SearchOperator = @$_GET["z_Codigo_tres"];

		// Titulo_codigo_tres
		$this->Titulo_codigo_tres->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Titulo_codigo_tres"]);
		if ($this->Titulo_codigo_tres->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Titulo_codigo_tres->AdvancedSearch->SearchOperator = @$_GET["z_Titulo_codigo_tres"];

		// Sexo
		$this->Sexo->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Sexo"]);
		if ($this->Sexo->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Sexo->AdvancedSearch->SearchOperator = @$_GET["z_Sexo"];
		if (is_array($this->Sexo->AdvancedSearch->SearchValue)) $this->Sexo->AdvancedSearch->SearchValue = implode(",", $this->Sexo->AdvancedSearch->SearchValue);
		if (is_array($this->Sexo->AdvancedSearch->SearchValue2)) $this->Sexo->AdvancedSearch->SearchValue2 = implode(",", $this->Sexo->AdvancedSearch->SearchValue2);

		// Unidad_edad
		$this->Unidad_edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Unidad_edad"]);
		if ($this->Unidad_edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Unidad_edad->AdvancedSearch->SearchOperator = @$_GET["z_Unidad_edad"];
		if (is_array($this->Unidad_edad->AdvancedSearch->SearchValue)) $this->Unidad_edad->AdvancedSearch->SearchValue = implode(",", $this->Unidad_edad->AdvancedSearch->SearchValue);
		if (is_array($this->Unidad_edad->AdvancedSearch->SearchValue2)) $this->Unidad_edad->AdvancedSearch->SearchValue2 = implode(",", $this->Unidad_edad->AdvancedSearch->SearchValue2);

		// Edad
		$this->Edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Edad"]);
		if ($this->Edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Edad->AdvancedSearch->SearchOperator = @$_GET["z_Edad"];
		$this->Edad->AdvancedSearch->SearchCondition = @$_GET["v_Edad"];
		$this->Edad->AdvancedSearch->SearchValue2 = ew_StripSlashes(@$_GET["y_Edad"]);
		if ($this->Edad->AdvancedSearch->SearchValue2 <> "") $this->Command = "search";
		$this->Edad->AdvancedSearch->SearchOperator2 = @$_GET["w_Edad"];

		// cuadro
		$this->cuadro->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_cuadro"]);
		if ($this->cuadro->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->cuadro->AdvancedSearch->SearchOperator = @$_GET["z_cuadro"];
		if (is_array($this->cuadro->AdvancedSearch->SearchValue)) $this->cuadro->AdvancedSearch->SearchValue = implode(",", $this->cuadro->AdvancedSearch->SearchValue);
		if (is_array($this->cuadro->AdvancedSearch->SearchValue2)) $this->cuadro->AdvancedSearch->SearchValue2 = implode(",", $this->cuadro->AdvancedSearch->SearchValue2);
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Count_Contador->setDbValue($rs->fields('Count_Contador'));
		$this->Codigo_tres->setDbValue($rs->fields('Codigo_tres'));
		$this->Titulo_codigo_tres->setDbValue($rs->fields('Titulo_codigo_tres'));
		$this->Sexo->setDbValue($rs->fields('Sexo'));
		$this->Unidad_edad->setDbValue($rs->fields('Unidad_edad'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->cuadro->setDbValue($rs->fields('cuadro'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Count_Contador->DbValue = $row['Count_Contador'];
		$this->Codigo_tres->DbValue = $row['Codigo_tres'];
		$this->Titulo_codigo_tres->DbValue = $row['Titulo_codigo_tres'];
		$this->Sexo->DbValue = $row['Sexo'];
		$this->Unidad_edad->DbValue = $row['Unidad_edad'];
		$this->Edad->DbValue = $row['Edad'];
		$this->cuadro->DbValue = $row['cuadro'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Count_Contador
		// Codigo_tres
		// Titulo_codigo_tres
		// Sexo
		// Unidad_edad
		// Edad
		// cuadro

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Count_Contador
		$this->Count_Contador->ViewValue = $this->Count_Contador->CurrentValue;
		$this->Count_Contador->ViewCustomAttributes = "";

		// Codigo_tres
		$this->Codigo_tres->ViewValue = $this->Codigo_tres->CurrentValue;
		$this->Codigo_tres->ViewCustomAttributes = "";

		// Titulo_codigo_tres
		$this->Titulo_codigo_tres->ViewValue = $this->Titulo_codigo_tres->CurrentValue;
		$this->Titulo_codigo_tres->ViewCustomAttributes = "";

		// Sexo
		if (strval($this->Sexo->CurrentValue) <> "") {
			$arwrk = explode(",", $this->Sexo->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`Sexo`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_STRING, "");
			}
		$sSqlWrk = "SELECT `Sexo`, `Sexo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `Sexo`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sexo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Sexo->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->Sexo->ViewValue .= $this->Sexo->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->Sexo->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
			}
		} else {
			$this->Sexo->ViewValue = NULL;
		}
		$this->Sexo->ViewCustomAttributes = "";

		// Unidad_edad
		if (strval($this->Unidad_edad->CurrentValue) <> "") {
			$arwrk = explode(",", $this->Unidad_edad->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`Unidad_medida`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `Unidad_medida`, `Unidad_medida` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `Unidad_medida`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Unidad_edad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Unidad_edad->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->Unidad_edad->ViewValue .= $this->Unidad_edad->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->Unidad_edad->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->Unidad_edad->ViewValue = $this->Unidad_edad->CurrentValue;
			}
		} else {
			$this->Unidad_edad->ViewValue = NULL;
		}
		$this->Unidad_edad->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// cuadro
		$this->cuadro->ViewCustomAttributes = "";

			// Count_Contador
			$this->Count_Contador->LinkCustomAttributes = "";
			$this->Count_Contador->HrefValue = "";
			$this->Count_Contador->TooltipValue = "";

			// Codigo_tres
			$this->Codigo_tres->LinkCustomAttributes = "";
			$this->Codigo_tres->HrefValue = "";
			$this->Codigo_tres->TooltipValue = "";

			// Titulo_codigo_tres
			$this->Titulo_codigo_tres->LinkCustomAttributes = "";
			$this->Titulo_codigo_tres->HrefValue = "";
			$this->Titulo_codigo_tres->TooltipValue = "";

			// Sexo
			$this->Sexo->LinkCustomAttributes = "";
			$this->Sexo->HrefValue = "";
			$this->Sexo->TooltipValue = "";

			// Unidad_edad
			$this->Unidad_edad->LinkCustomAttributes = "";
			$this->Unidad_edad->HrefValue = "";
			$this->Unidad_edad->TooltipValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";
			$this->Edad->TooltipValue = "";

			// cuadro
			$this->cuadro->LinkCustomAttributes = "";
			$this->cuadro->HrefValue = "";
			$this->cuadro->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// Count_Contador
			$this->Count_Contador->EditAttrs["class"] = "form-control";
			$this->Count_Contador->EditCustomAttributes = "";
			$this->Count_Contador->EditValue = ew_HtmlEncode($this->Count_Contador->AdvancedSearch->SearchValue);
			$this->Count_Contador->PlaceHolder = ew_RemoveHtml($this->Count_Contador->FldCaption());

			// Codigo_tres
			$this->Codigo_tres->EditAttrs["class"] = "form-control";
			$this->Codigo_tres->EditCustomAttributes = "";
			$this->Codigo_tres->EditValue = ew_HtmlEncode($this->Codigo_tres->AdvancedSearch->SearchValue);
			$this->Codigo_tres->PlaceHolder = ew_RemoveHtml($this->Codigo_tres->FldCaption());

			// Titulo_codigo_tres
			$this->Titulo_codigo_tres->EditAttrs["class"] = "form-control";
			$this->Titulo_codigo_tres->EditCustomAttributes = "";
			$this->Titulo_codigo_tres->EditValue = ew_HtmlEncode($this->Titulo_codigo_tres->AdvancedSearch->SearchValue);
			$this->Titulo_codigo_tres->PlaceHolder = ew_RemoveHtml($this->Titulo_codigo_tres->FldCaption());

			// Sexo
			$this->Sexo->EditCustomAttributes = "";
			if (trim(strval($this->Sexo->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$arwrk = explode(",", $this->Sexo->AdvancedSearch->SearchValue);
				$sFilterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
					$sFilterWrk .= "`Sexo`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_STRING, "");
				}
			}
			$sSqlWrk = "SELECT `Sexo`, `Sexo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `Sexo`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Sexo, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Sexo->EditValue = $arwrk;

			// Unidad_edad
			$this->Unidad_edad->EditCustomAttributes = "";
			if (trim(strval($this->Unidad_edad->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$arwrk = explode(",", $this->Unidad_edad->AdvancedSearch->SearchValue);
				$sFilterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
					$sFilterWrk .= "`Unidad_medida`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
				}
			}
			$sSqlWrk = "SELECT `Unidad_medida`, `Unidad_medida` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `Unidad_medida`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Unidad_edad, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Unidad_edad->EditValue = $arwrk;

			// Edad
			$this->Edad->EditAttrs["class"] = "form-control";
			$this->Edad->EditCustomAttributes = "";
			$this->Edad->EditValue = ew_HtmlEncode($this->Edad->AdvancedSearch->SearchValue);
			$this->Edad->PlaceHolder = ew_RemoveHtml($this->Edad->FldCaption());
			$this->Edad->EditAttrs["class"] = "form-control";
			$this->Edad->EditCustomAttributes = "";
			$this->Edad->EditValue2 = ew_HtmlEncode($this->Edad->AdvancedSearch->SearchValue2);
			$this->Edad->PlaceHolder = ew_RemoveHtml($this->Edad->FldCaption());

			// cuadro
			$this->cuadro->EditCustomAttributes = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->Count_Contador->AdvancedSearch->Load();
		$this->Codigo_tres->AdvancedSearch->Load();
		$this->Titulo_codigo_tres->AdvancedSearch->Load();
		$this->Sexo->AdvancedSearch->Load();
		$this->Unidad_edad->AdvancedSearch->Load();
		$this->Edad->AdvancedSearch->Load();
		$this->cuadro->AdvancedSearch->Load();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($consulta_general_2021_list)) $consulta_general_2021_list = new cconsulta_general_2021_list();

// Page init
$consulta_general_2021_list->Page_Init();

// Page main
$consulta_general_2021_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$consulta_general_2021_list->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fconsulta_general_2021list = new ew_Form("fconsulta_general_2021list", "list");
fconsulta_general_2021list.FormKeyCountName = '<?php echo $consulta_general_2021_list->FormKeyCountName ?>';

// Form_CustomValidate event
fconsulta_general_2021list.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fconsulta_general_2021list.ValidateRequired = true;
<?php } else { ?>
fconsulta_general_2021list.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fconsulta_general_2021list.Lists["x_Sexo[]"] = {"LinkField":"x_Sexo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Sexo","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fconsulta_general_2021list.Lists["x_Unidad_edad[]"] = {"LinkField":"x_Unidad_medida","Ajax":true,"AutoFill":false,"DisplayFields":["x_Unidad_medida","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
var CurrentSearchForm = fconsulta_general_2021listsrch = new ew_Form("fconsulta_general_2021listsrch");

// Validate function for search
fconsulta_general_2021listsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fconsulta_general_2021listsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fconsulta_general_2021listsrch.ValidateRequired = true; // Use JavaScript validation
<?php } else { ?>
fconsulta_general_2021listsrch.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Dynamic selection lists
fconsulta_general_2021listsrch.Lists["x_Sexo[]"] = {"LinkField":"x_Sexo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Sexo","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fconsulta_general_2021listsrch.Lists["x_Unidad_edad[]"] = {"LinkField":"x_Unidad_medida","Ajax":true,"AutoFill":false,"DisplayFields":["x_Unidad_medida","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php if ($consulta_general_2021_list->TotalRecs > 0 && $consulta_general_2021_list->ExportOptions->Visible()) { ?>
<?php $consulta_general_2021_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($consulta_general_2021_list->SearchOptions->Visible()) { ?>
<?php $consulta_general_2021_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($consulta_general_2021_list->FilterOptions->Visible()) { ?>
<?php $consulta_general_2021_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php
	$bSelectLimit = $consulta_general_2021_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($consulta_general_2021_list->TotalRecs <= 0)
			$consulta_general_2021_list->TotalRecs = $consulta_general_2021->SelectRecordCount();
	} else {
		if (!$consulta_general_2021_list->Recordset && ($consulta_general_2021_list->Recordset = $consulta_general_2021_list->LoadRecordset()))
			$consulta_general_2021_list->TotalRecs = $consulta_general_2021_list->Recordset->RecordCount();
	}
	$consulta_general_2021_list->StartRec = 1;
	if ($consulta_general_2021_list->DisplayRecs <= 0 || ($consulta_general_2021->Export <> "" && $consulta_general_2021->ExportAll)) // Display all records
		$consulta_general_2021_list->DisplayRecs = $consulta_general_2021_list->TotalRecs;
	if (!($consulta_general_2021->Export <> "" && $consulta_general_2021->ExportAll))
		$consulta_general_2021_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$consulta_general_2021_list->Recordset = $consulta_general_2021_list->LoadRecordset($consulta_general_2021_list->StartRec-1, $consulta_general_2021_list->DisplayRecs);

	// Set no record found message
	if ($consulta_general_2021->CurrentAction == "" && $consulta_general_2021_list->TotalRecs == 0) {
		if ($consulta_general_2021_list->SearchWhere == "0=101")
			$consulta_general_2021_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$consulta_general_2021_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$consulta_general_2021_list->RenderOtherOptions();
?>
<?php if ($consulta_general_2021->Export == "" && $consulta_general_2021->CurrentAction == "") { ?>
<form name="fconsulta_general_2021listsrch" id="fconsulta_general_2021listsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($consulta_general_2021_list->SearchWhere <> "") ? " in" : " in"; ?>
<div id="fconsulta_general_2021listsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="consulta_general_2021">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$consulta_general_2021_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$consulta_general_2021->RowType = EW_ROWTYPE_SEARCH;

// Render row
$consulta_general_2021->ResetAttrs();
$consulta_general_2021_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($consulta_general_2021->Codigo_tres->Visible) { // Codigo_tres ?>
	<div id="xsc_Codigo_tres" class="ewCell form-group">
		<label for="x_Codigo_tres" class="ewSearchCaption ewLabel"><?php echo $consulta_general_2021->Codigo_tres->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Codigo_tres" id="z_Codigo_tres" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="consulta_general_2021" data-field="x_Codigo_tres" name="x_Codigo_tres" id="x_Codigo_tres" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($consulta_general_2021->Codigo_tres->getPlaceHolder()) ?>" value="<?php echo $consulta_general_2021->Codigo_tres->EditValue ?>"<?php echo $consulta_general_2021->Codigo_tres->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($consulta_general_2021->Sexo->Visible) { // Sexo ?>
	<div id="xsc_Sexo" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $consulta_general_2021->Sexo->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Sexo" id="z_Sexo" value="LIKE"></span>
		<span class="ewSearchField">
<div id="tp_x_Sexo" class="ewTemplate"><input type="checkbox" data-table="consulta_general_2021" data-field="x_Sexo" data-value-separator="<?php echo ew_HtmlEncode(is_array($consulta_general_2021->Sexo->DisplayValueSeparator) ? json_encode($consulta_general_2021->Sexo->DisplayValueSeparator) : $consulta_general_2021->Sexo->DisplayValueSeparator) ?>" name="x_Sexo[]" id="x_Sexo[]" value="{value}"<?php echo $consulta_general_2021->Sexo->EditAttributes() ?>></div>
<div id="dsl_x_Sexo" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $consulta_general_2021->Sexo->EditValue;
if (is_array($arwrk)) {
	$armultiwrk = (strval($consulta_general_2021->Sexo->AdvancedSearch->SearchValue) <> "") ? explode(",", strval($consulta_general_2021->Sexo->AdvancedSearch->SearchValue)) : array();
	$cnt = count($armultiwrk);
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = "";
		for ($ari = 0; $ari < $cnt; $ari++) {
			if (ew_SameStr($arwrk[$rowcntwrk][0], $armultiwrk[$ari]) && !is_null($armultiwrk[$ari])) {
				$armultiwrk[$ari] = NULL; // Marked for removal
				$selwrk = " checked";
				if ($selwrk <> "") $emptywrk = FALSE;
				break;
			}
		}
		if ($selwrk <> "") {
?>
<label class="checkbox-inline"><input type="checkbox" data-table="consulta_general_2021" data-field="x_Sexo" name="x_Sexo[]" id="x_Sexo_<?php echo $rowcntwrk ?>[]" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $consulta_general_2021->Sexo->EditAttributes() ?>><?php echo $consulta_general_2021->Sexo->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	for ($ari = 0; $ari < $cnt; $ari++) {
		if (!is_null($armultiwrk[$ari])) {
?>
<label class="checkbox-inline"><input type="checkbox" data-table="consulta_general_2021" data-field="x_Sexo" name="x_Sexo[]" value="<?php echo ew_HtmlEncode($armultiwrk[$ari]) ?>" checked<?php echo $consulta_general_2021->Sexo->EditAttributes() ?>><?php echo $armultiwrk[$ari] ?></label>
<?php
		}
	}
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Sexo`, `Sexo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `Sexo`";
$sWhereWrk = "";
$consulta_general_2021->Sexo->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$consulta_general_2021->Sexo->LookupFilters += array("f0" => "`Sexo` = {filter_value}", "t0" => "200", "fn0" => "");
$sSqlWrk = "";
$consulta_general_2021->Lookup_Selecting($consulta_general_2021->Sexo, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $consulta_general_2021->Sexo->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Sexo" id="s_x_Sexo" value="<?php echo $consulta_general_2021->Sexo->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($consulta_general_2021->Unidad_edad->Visible) { // Unidad_edad ?>
	<div id="xsc_Unidad_edad" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $consulta_general_2021->Unidad_edad->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Unidad_edad" id="z_Unidad_edad" value="LIKE"></span>
		<span class="ewSearchField">
<div id="tp_x_Unidad_edad" class="ewTemplate"><input type="checkbox" data-table="consulta_general_2021" data-field="x_Unidad_edad" data-value-separator="<?php echo ew_HtmlEncode(is_array($consulta_general_2021->Unidad_edad->DisplayValueSeparator) ? json_encode($consulta_general_2021->Unidad_edad->DisplayValueSeparator) : $consulta_general_2021->Unidad_edad->DisplayValueSeparator) ?>" name="x_Unidad_edad[]" id="x_Unidad_edad[]" value="{value}"<?php echo $consulta_general_2021->Unidad_edad->EditAttributes() ?>></div>
<div id="dsl_x_Unidad_edad" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $consulta_general_2021->Unidad_edad->EditValue;
if (is_array($arwrk)) {
	$armultiwrk = (strval($consulta_general_2021->Unidad_edad->AdvancedSearch->SearchValue) <> "") ? explode(",", strval($consulta_general_2021->Unidad_edad->AdvancedSearch->SearchValue)) : array();
	$cnt = count($armultiwrk);
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = "";
		for ($ari = 0; $ari < $cnt; $ari++) {
			if (ew_SameStr($arwrk[$rowcntwrk][0], $armultiwrk[$ari]) && !is_null($armultiwrk[$ari])) {
				$armultiwrk[$ari] = NULL; // Marked for removal
				$selwrk = " checked";
				if ($selwrk <> "") $emptywrk = FALSE;
				break;
			}
		}
		if ($selwrk <> "") {
?>
<label class="checkbox-inline"><input type="checkbox" data-table="consulta_general_2021" data-field="x_Unidad_edad" name="x_Unidad_edad[]" id="x_Unidad_edad_<?php echo $rowcntwrk ?>[]" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $consulta_general_2021->Unidad_edad->EditAttributes() ?>><?php echo $consulta_general_2021->Unidad_edad->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	for ($ari = 0; $ari < $cnt; $ari++) {
		if (!is_null($armultiwrk[$ari])) {
?>
<label class="checkbox-inline"><input type="checkbox" data-table="consulta_general_2021" data-field="x_Unidad_edad" name="x_Unidad_edad[]" value="<?php echo ew_HtmlEncode($armultiwrk[$ari]) ?>" checked<?php echo $consulta_general_2021->Unidad_edad->EditAttributes() ?>><?php echo $armultiwrk[$ari] ?></label>
<?php
		}
	}
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Unidad_medida`, `Unidad_medida` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `Unidad_medida`";
$sWhereWrk = "";
$consulta_general_2021->Unidad_edad->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$consulta_general_2021->Unidad_edad->LookupFilters += array("f0" => "`Unidad_medida` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$consulta_general_2021->Lookup_Selecting($consulta_general_2021->Unidad_edad, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $consulta_general_2021->Unidad_edad->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Unidad_edad" id="s_x_Unidad_edad" value="<?php echo $consulta_general_2021->Unidad_edad->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($consulta_general_2021->Edad->Visible) { // Edad ?>
	<div id="xsc_Edad" class="ewCell form-group">
		<label for="x_Edad" class="ewSearchCaption ewLabel"><?php echo $consulta_general_2021->Edad->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("BETWEEN") ?><input type="hidden" name="z_Edad" id="z_Edad" value="BETWEEN"></span>
		<span class="ewSearchField">
<input type="text" data-table="consulta_general_2021" data-field="x_Edad" name="x_Edad" id="x_Edad" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($consulta_general_2021->Edad->getPlaceHolder()) ?>" value="<?php echo $consulta_general_2021->Edad->EditValue ?>"<?php echo $consulta_general_2021->Edad->EditAttributes() ?>>
</span>
		<span class="ewSearchCond btw1_Edad">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_Edad">
<input type="text" data-table="consulta_general_2021" data-field="x_Edad" name="y_Edad" id="y_Edad" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($consulta_general_2021->Edad->getPlaceHolder()) ?>" value="<?php echo $consulta_general_2021->Edad->EditValue2 ?>"<?php echo $consulta_general_2021->Edad->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($consulta_general_2021->cuadro->Visible) { // cuadro ?>
	<div id="xsc_cuadro" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $consulta_general_2021->cuadro->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_cuadro" id="z_cuadro" value="="></span>
		<span class="ewSearchField">
<div id="tp_x_cuadro" class="ewTemplate"><input type="checkbox" data-table="consulta_general_2021" data-field="x_cuadro" data-value-separator="<?php echo ew_HtmlEncode(is_array($consulta_general_2021->cuadro->DisplayValueSeparator) ? json_encode($consulta_general_2021->cuadro->DisplayValueSeparator) : $consulta_general_2021->cuadro->DisplayValueSeparator) ?>" name="x_cuadro[]" id="x_cuadro[]" value="{value}"<?php echo $consulta_general_2021->cuadro->EditAttributes() ?>></div>
<div id="dsl_x_cuadro" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $consulta_general_2021->cuadro->EditValue;
if (is_array($arwrk)) {
	$armultiwrk = (strval($consulta_general_2021->cuadro->AdvancedSearch->SearchValue) <> "") ? explode(",", strval($consulta_general_2021->cuadro->AdvancedSearch->SearchValue)) : array();
	$cnt = count($armultiwrk);
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = "";
		for ($ari = 0; $ari < $cnt; $ari++) {
			if (ew_SameStr($arwrk[$rowcntwrk][0], $armultiwrk[$ari]) && !is_null($armultiwrk[$ari])) {
				$armultiwrk[$ari] = NULL; // Marked for removal
				$selwrk = " checked";
				if ($selwrk <> "") $emptywrk = FALSE;
				break;
			}
		}
?>
<label class="checkbox-inline"><input type="checkbox" data-table="consulta_general_2021" data-field="x_cuadro" name="x_cuadro[]" id="x_cuadro_<?php echo $rowcntwrk ?>[]" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $consulta_general_2021->cuadro->EditAttributes() ?>><?php echo $consulta_general_2021->cuadro->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
	}
	for ($ari = 0; $ari < $cnt; $ari++) {
		if (!is_null($armultiwrk[$ari])) {
?>
<label class="checkbox-inline"><input type="checkbox" data-table="consulta_general_2021" data-field="x_cuadro" name="x_cuadro[]" value="<?php echo ew_HtmlEncode($armultiwrk[$ari]) ?>" checked<?php echo $consulta_general_2021->cuadro->EditAttributes() ?>><?php echo $armultiwrk[$ari] ?></label>
<?php
		}
	}
}
?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($consulta_general_2021_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($consulta_general_2021_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $consulta_general_2021_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($consulta_general_2021_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($consulta_general_2021_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($consulta_general_2021_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($consulta_general_2021_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php $consulta_general_2021_list->ShowPageHeader(); ?>
<?php
$consulta_general_2021_list->ShowMessage();
?>
<?php if ($consulta_general_2021_list->TotalRecs > 0 || $consulta_general_2021->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<form name="fconsulta_general_2021list" id="fconsulta_general_2021list" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($consulta_general_2021_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $consulta_general_2021_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="consulta_general_2021">
<div id="gmp_consulta_general_2021" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($consulta_general_2021_list->TotalRecs > 0) { ?>
<table id="tbl_consulta_general_2021list" class="table ewTable">
<?php echo $consulta_general_2021->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$consulta_general_2021_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$consulta_general_2021_list->RenderListOptions();

// Render list options (header, left)
$consulta_general_2021_list->ListOptions->Render("header", "left");
?>
<?php if ($consulta_general_2021->Count_Contador->Visible) { // Count_Contador ?>
	<?php if ($consulta_general_2021->SortUrl($consulta_general_2021->Count_Contador) == "") { ?>
		<th data-name="Count_Contador"><div id="elh_consulta_general_2021_Count_Contador" class="consulta_general_2021_Count_Contador"><div class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Count_Contador->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Count_Contador"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $consulta_general_2021->SortUrl($consulta_general_2021->Count_Contador) ?>',1);"><div id="elh_consulta_general_2021_Count_Contador" class="consulta_general_2021_Count_Contador">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Count_Contador->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($consulta_general_2021->Count_Contador->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($consulta_general_2021->Count_Contador->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($consulta_general_2021->Codigo_tres->Visible) { // Codigo_tres ?>
	<?php if ($consulta_general_2021->SortUrl($consulta_general_2021->Codigo_tres) == "") { ?>
		<th data-name="Codigo_tres"><div id="elh_consulta_general_2021_Codigo_tres" class="consulta_general_2021_Codigo_tres"><div class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Codigo_tres->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_tres"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $consulta_general_2021->SortUrl($consulta_general_2021->Codigo_tres) ?>',1);"><div id="elh_consulta_general_2021_Codigo_tres" class="consulta_general_2021_Codigo_tres">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Codigo_tres->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($consulta_general_2021->Codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($consulta_general_2021->Codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($consulta_general_2021->Titulo_codigo_tres->Visible) { // Titulo_codigo_tres ?>
	<?php if ($consulta_general_2021->SortUrl($consulta_general_2021->Titulo_codigo_tres) == "") { ?>
		<th data-name="Titulo_codigo_tres"><div id="elh_consulta_general_2021_Titulo_codigo_tres" class="consulta_general_2021_Titulo_codigo_tres"><div class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Titulo_codigo_tres->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Titulo_codigo_tres"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $consulta_general_2021->SortUrl($consulta_general_2021->Titulo_codigo_tres) ?>',1);"><div id="elh_consulta_general_2021_Titulo_codigo_tres" class="consulta_general_2021_Titulo_codigo_tres">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Titulo_codigo_tres->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($consulta_general_2021->Titulo_codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($consulta_general_2021->Titulo_codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($consulta_general_2021->Sexo->Visible) { // Sexo ?>
	<?php if ($consulta_general_2021->SortUrl($consulta_general_2021->Sexo) == "") { ?>
		<th data-name="Sexo"><div id="elh_consulta_general_2021_Sexo" class="consulta_general_2021_Sexo"><div class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Sexo->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Sexo"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $consulta_general_2021->SortUrl($consulta_general_2021->Sexo) ?>',1);"><div id="elh_consulta_general_2021_Sexo" class="consulta_general_2021_Sexo">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Sexo->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($consulta_general_2021->Sexo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($consulta_general_2021->Sexo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($consulta_general_2021->Unidad_edad->Visible) { // Unidad_edad ?>
	<?php if ($consulta_general_2021->SortUrl($consulta_general_2021->Unidad_edad) == "") { ?>
		<th data-name="Unidad_edad"><div id="elh_consulta_general_2021_Unidad_edad" class="consulta_general_2021_Unidad_edad"><div class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Unidad_edad->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Unidad_edad"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $consulta_general_2021->SortUrl($consulta_general_2021->Unidad_edad) ?>',1);"><div id="elh_consulta_general_2021_Unidad_edad" class="consulta_general_2021_Unidad_edad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Unidad_edad->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($consulta_general_2021->Unidad_edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($consulta_general_2021->Unidad_edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($consulta_general_2021->Edad->Visible) { // Edad ?>
	<?php if ($consulta_general_2021->SortUrl($consulta_general_2021->Edad) == "") { ?>
		<th data-name="Edad"><div id="elh_consulta_general_2021_Edad" class="consulta_general_2021_Edad"><div class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Edad->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Edad"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $consulta_general_2021->SortUrl($consulta_general_2021->Edad) ?>',1);"><div id="elh_consulta_general_2021_Edad" class="consulta_general_2021_Edad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $consulta_general_2021->Edad->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($consulta_general_2021->Edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($consulta_general_2021->Edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($consulta_general_2021->cuadro->Visible) { // cuadro ?>
	<?php if ($consulta_general_2021->SortUrl($consulta_general_2021->cuadro) == "") { ?>
		<th data-name="cuadro"><div id="elh_consulta_general_2021_cuadro" class="consulta_general_2021_cuadro"><div class="ewTableHeaderCaption"><?php echo $consulta_general_2021->cuadro->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cuadro"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $consulta_general_2021->SortUrl($consulta_general_2021->cuadro) ?>',1);"><div id="elh_consulta_general_2021_cuadro" class="consulta_general_2021_cuadro">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $consulta_general_2021->cuadro->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($consulta_general_2021->cuadro->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($consulta_general_2021->cuadro->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$consulta_general_2021_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($consulta_general_2021->ExportAll && $consulta_general_2021->Export <> "") {
	$consulta_general_2021_list->StopRec = $consulta_general_2021_list->TotalRecs;
} else {

	// Set the last record to display
	if ($consulta_general_2021_list->TotalRecs > $consulta_general_2021_list->StartRec + $consulta_general_2021_list->DisplayRecs - 1)
		$consulta_general_2021_list->StopRec = $consulta_general_2021_list->StartRec + $consulta_general_2021_list->DisplayRecs - 1;
	else
		$consulta_general_2021_list->StopRec = $consulta_general_2021_list->TotalRecs;
}
$consulta_general_2021_list->RecCnt = $consulta_general_2021_list->StartRec - 1;
if ($consulta_general_2021_list->Recordset && !$consulta_general_2021_list->Recordset->EOF) {
	$consulta_general_2021_list->Recordset->MoveFirst();
	$bSelectLimit = $consulta_general_2021_list->UseSelectLimit;
	if (!$bSelectLimit && $consulta_general_2021_list->StartRec > 1)
		$consulta_general_2021_list->Recordset->Move($consulta_general_2021_list->StartRec - 1);
} elseif (!$consulta_general_2021->AllowAddDeleteRow && $consulta_general_2021_list->StopRec == 0) {
	$consulta_general_2021_list->StopRec = $consulta_general_2021->GridAddRowCount;
}

// Initialize aggregate
$consulta_general_2021->RowType = EW_ROWTYPE_AGGREGATEINIT;
$consulta_general_2021->ResetAttrs();
$consulta_general_2021_list->RenderRow();
while ($consulta_general_2021_list->RecCnt < $consulta_general_2021_list->StopRec) {
	$consulta_general_2021_list->RecCnt++;
	if (intval($consulta_general_2021_list->RecCnt) >= intval($consulta_general_2021_list->StartRec)) {
		$consulta_general_2021_list->RowCnt++;

		// Set up key count
		$consulta_general_2021_list->KeyCount = $consulta_general_2021_list->RowIndex;

		// Init row class and style
		$consulta_general_2021->ResetAttrs();
		$consulta_general_2021->CssClass = "";
		if ($consulta_general_2021->CurrentAction == "gridadd") {
		} else {
			$consulta_general_2021_list->LoadRowValues($consulta_general_2021_list->Recordset); // Load row values
		}
		$consulta_general_2021->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$consulta_general_2021->RowAttrs = array_merge($consulta_general_2021->RowAttrs, array('data-rowindex'=>$consulta_general_2021_list->RowCnt, 'id'=>'r' . $consulta_general_2021_list->RowCnt . '_consulta_general_2021', 'data-rowtype'=>$consulta_general_2021->RowType));

		// Render row
		$consulta_general_2021_list->RenderRow();

		// Render list options
		$consulta_general_2021_list->RenderListOptions();
?>
	<tr<?php echo $consulta_general_2021->RowAttributes() ?>>
<?php

// Render list options (body, left)
$consulta_general_2021_list->ListOptions->Render("body", "left", $consulta_general_2021_list->RowCnt);
?>
	<?php if ($consulta_general_2021->Count_Contador->Visible) { // Count_Contador ?>
		<td data-name="Count_Contador"<?php echo $consulta_general_2021->Count_Contador->CellAttributes() ?>>
<span id="el<?php echo $consulta_general_2021_list->RowCnt ?>_consulta_general_2021_Count_Contador" class="consulta_general_2021_Count_Contador">
<span<?php echo $consulta_general_2021->Count_Contador->ViewAttributes() ?>>
<?php echo $consulta_general_2021->Count_Contador->ListViewValue() ?></span>
</span>
<a id="<?php echo $consulta_general_2021_list->PageObjName . "_row_" . $consulta_general_2021_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($consulta_general_2021->Codigo_tres->Visible) { // Codigo_tres ?>
		<td data-name="Codigo_tres"<?php echo $consulta_general_2021->Codigo_tres->CellAttributes() ?>>
<span id="el<?php echo $consulta_general_2021_list->RowCnt ?>_consulta_general_2021_Codigo_tres" class="consulta_general_2021_Codigo_tres">
<span<?php echo $consulta_general_2021->Codigo_tres->ViewAttributes() ?>>
<?php echo $consulta_general_2021->Codigo_tres->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($consulta_general_2021->Titulo_codigo_tres->Visible) { // Titulo_codigo_tres ?>
		<td data-name="Titulo_codigo_tres"<?php echo $consulta_general_2021->Titulo_codigo_tres->CellAttributes() ?>>
<span id="el<?php echo $consulta_general_2021_list->RowCnt ?>_consulta_general_2021_Titulo_codigo_tres" class="consulta_general_2021_Titulo_codigo_tres">
<span<?php echo $consulta_general_2021->Titulo_codigo_tres->ViewAttributes() ?>>
<?php echo $consulta_general_2021->Titulo_codigo_tres->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($consulta_general_2021->Sexo->Visible) { // Sexo ?>
		<td data-name="Sexo"<?php echo $consulta_general_2021->Sexo->CellAttributes() ?>>
<span id="el<?php echo $consulta_general_2021_list->RowCnt ?>_consulta_general_2021_Sexo" class="consulta_general_2021_Sexo">
<span<?php echo $consulta_general_2021->Sexo->ViewAttributes() ?>>
<?php echo $consulta_general_2021->Sexo->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($consulta_general_2021->Unidad_edad->Visible) { // Unidad_edad ?>
		<td data-name="Unidad_edad"<?php echo $consulta_general_2021->Unidad_edad->CellAttributes() ?>>
<span id="el<?php echo $consulta_general_2021_list->RowCnt ?>_consulta_general_2021_Unidad_edad" class="consulta_general_2021_Unidad_edad">
<span<?php echo $consulta_general_2021->Unidad_edad->ViewAttributes() ?>>
<?php echo $consulta_general_2021->Unidad_edad->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($consulta_general_2021->Edad->Visible) { // Edad ?>
		<td data-name="Edad"<?php echo $consulta_general_2021->Edad->CellAttributes() ?>>
<span id="el<?php echo $consulta_general_2021_list->RowCnt ?>_consulta_general_2021_Edad" class="consulta_general_2021_Edad">
<span<?php echo $consulta_general_2021->Edad->ViewAttributes() ?>>
<?php echo $consulta_general_2021->Edad->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($consulta_general_2021->cuadro->Visible) { // cuadro ?>
		<td data-name="cuadro"<?php echo $consulta_general_2021->cuadro->CellAttributes() ?>>
<span id="el<?php echo $consulta_general_2021_list->RowCnt ?>_consulta_general_2021_cuadro" class="consulta_general_2021_cuadro">
<span<?php echo $consulta_general_2021->cuadro->ViewAttributes() ?>>
<?php echo $consulta_general_2021->cuadro->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$consulta_general_2021_list->ListOptions->Render("body", "right", $consulta_general_2021_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($consulta_general_2021->CurrentAction <> "gridadd")
		$consulta_general_2021_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($consulta_general_2021->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($consulta_general_2021_list->Recordset)
	$consulta_general_2021_list->Recordset->Close();
?>
<div class="panel-footer ewGridLowerPanel">
<?php if ($consulta_general_2021->CurrentAction <> "gridadd" && $consulta_general_2021->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($consulta_general_2021_list->Pager)) $consulta_general_2021_list->Pager = new cPrevNextPager($consulta_general_2021_list->StartRec, $consulta_general_2021_list->DisplayRecs, $consulta_general_2021_list->TotalRecs) ?>
<?php if ($consulta_general_2021_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($consulta_general_2021_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $consulta_general_2021_list->PageUrl() ?>start=<?php echo $consulta_general_2021_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($consulta_general_2021_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $consulta_general_2021_list->PageUrl() ?>start=<?php echo $consulta_general_2021_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $consulta_general_2021_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($consulta_general_2021_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $consulta_general_2021_list->PageUrl() ?>start=<?php echo $consulta_general_2021_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($consulta_general_2021_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $consulta_general_2021_list->PageUrl() ?>start=<?php echo $consulta_general_2021_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $consulta_general_2021_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $consulta_general_2021_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $consulta_general_2021_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $consulta_general_2021_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($consulta_general_2021_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
</div>
<?php } ?>
<?php if ($consulta_general_2021_list->TotalRecs == 0 && $consulta_general_2021->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($consulta_general_2021_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<script type="text/javascript">
fconsulta_general_2021listsrch.Init();
fconsulta_general_2021listsrch.FilterList = <?php echo $consulta_general_2021_list->GetFilterList() ?>;
fconsulta_general_2021list.Init();
</script>
<?php
$consulta_general_2021_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$consulta_general_2021_list->Page_Terminate();
?>
