<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "usuario_2020info.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$usuario_2020_list = NULL; // Initialize page object first

class cusuario_2020_list extends cusuario_2020 {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{612F4CEC-277D-477B-ABAC-2B8738F52202}";

	// Table name
	var $TableName = 'usuario_2020';

	// Page object name
	var $PageObjName = 'usuario_2020_list';

	// Grid form hidden field names
	var $FormName = 'fusuario_2020list';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (usuario_2020)
		if (!isset($GLOBALS["usuario_2020"]) || get_class($GLOBALS["usuario_2020"]) == "cusuario_2020") {
			$GLOBALS["usuario_2020"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["usuario_2020"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "usuario_2020add.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "usuario_2020delete.php";
		$this->MultiUpdateUrl = "usuario_2020update.php";

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'usuario_2020', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fusuario_2020listsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $usuario_2020;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($usuario_2020);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Restore filter list
			$this->RestoreFilterList();

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 0) {
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_doc->AdvancedSearch->ToJSON(), ","); // Field Tipo_doc
		$sFilterList = ew_Concat($sFilterList, $this->Documento->AdvancedSearch->ToJSON(), ","); // Field Documento
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_eps->AdvancedSearch->ToJSON(), ","); // Field Codigo_eps
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_Usuario->AdvancedSearch->ToJSON(), ","); // Field Tipo_Usuario
		$sFilterList = ew_Concat($sFilterList, $this->Primer_ap->AdvancedSearch->ToJSON(), ","); // Field Primer_ap
		$sFilterList = ew_Concat($sFilterList, $this->Segundo_ap->AdvancedSearch->ToJSON(), ","); // Field Segundo_ap
		$sFilterList = ew_Concat($sFilterList, $this->Primer_nom->AdvancedSearch->ToJSON(), ","); // Field Primer_nom
		$sFilterList = ew_Concat($sFilterList, $this->Segundo_nom->AdvancedSearch->ToJSON(), ","); // Field Segundo_nom
		$sFilterList = ew_Concat($sFilterList, $this->Edad->AdvancedSearch->ToJSON(), ","); // Field Edad
		$sFilterList = ew_Concat($sFilterList, $this->Unidad_edad->AdvancedSearch->ToJSON(), ","); // Field Unidad_edad
		$sFilterList = ew_Concat($sFilterList, $this->Sexo->AdvancedSearch->ToJSON(), ","); // Field Sexo
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_dpto->AdvancedSearch->ToJSON(), ","); // Field Codigo_dpto
		$sFilterList = ew_Concat($sFilterList, $this->Cod_municipio->AdvancedSearch->ToJSON(), ","); // Field Cod_municipio
		$sFilterList = ew_Concat($sFilterList, $this->Zona_residencia->AdvancedSearch->ToJSON(), ","); // Field Zona_residencia
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Tipo_doc
		$this->Tipo_doc->AdvancedSearch->SearchValue = @$filter["x_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchOperator = @$filter["z_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchCondition = @$filter["v_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->Save();

		// Field Documento
		$this->Documento->AdvancedSearch->SearchValue = @$filter["x_Documento"];
		$this->Documento->AdvancedSearch->SearchOperator = @$filter["z_Documento"];
		$this->Documento->AdvancedSearch->SearchCondition = @$filter["v_Documento"];
		$this->Documento->AdvancedSearch->SearchValue2 = @$filter["y_Documento"];
		$this->Documento->AdvancedSearch->SearchOperator2 = @$filter["w_Documento"];
		$this->Documento->AdvancedSearch->Save();

		// Field Codigo_eps
		$this->Codigo_eps->AdvancedSearch->SearchValue = @$filter["x_Codigo_eps"];
		$this->Codigo_eps->AdvancedSearch->SearchOperator = @$filter["z_Codigo_eps"];
		$this->Codigo_eps->AdvancedSearch->SearchCondition = @$filter["v_Codigo_eps"];
		$this->Codigo_eps->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_eps"];
		$this->Codigo_eps->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_eps"];
		$this->Codigo_eps->AdvancedSearch->Save();

		// Field Tipo_Usuario
		$this->Tipo_Usuario->AdvancedSearch->SearchValue = @$filter["x_Tipo_Usuario"];
		$this->Tipo_Usuario->AdvancedSearch->SearchOperator = @$filter["z_Tipo_Usuario"];
		$this->Tipo_Usuario->AdvancedSearch->SearchCondition = @$filter["v_Tipo_Usuario"];
		$this->Tipo_Usuario->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_Usuario"];
		$this->Tipo_Usuario->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_Usuario"];
		$this->Tipo_Usuario->AdvancedSearch->Save();

		// Field Primer_ap
		$this->Primer_ap->AdvancedSearch->SearchValue = @$filter["x_Primer_ap"];
		$this->Primer_ap->AdvancedSearch->SearchOperator = @$filter["z_Primer_ap"];
		$this->Primer_ap->AdvancedSearch->SearchCondition = @$filter["v_Primer_ap"];
		$this->Primer_ap->AdvancedSearch->SearchValue2 = @$filter["y_Primer_ap"];
		$this->Primer_ap->AdvancedSearch->SearchOperator2 = @$filter["w_Primer_ap"];
		$this->Primer_ap->AdvancedSearch->Save();

		// Field Segundo_ap
		$this->Segundo_ap->AdvancedSearch->SearchValue = @$filter["x_Segundo_ap"];
		$this->Segundo_ap->AdvancedSearch->SearchOperator = @$filter["z_Segundo_ap"];
		$this->Segundo_ap->AdvancedSearch->SearchCondition = @$filter["v_Segundo_ap"];
		$this->Segundo_ap->AdvancedSearch->SearchValue2 = @$filter["y_Segundo_ap"];
		$this->Segundo_ap->AdvancedSearch->SearchOperator2 = @$filter["w_Segundo_ap"];
		$this->Segundo_ap->AdvancedSearch->Save();

		// Field Primer_nom
		$this->Primer_nom->AdvancedSearch->SearchValue = @$filter["x_Primer_nom"];
		$this->Primer_nom->AdvancedSearch->SearchOperator = @$filter["z_Primer_nom"];
		$this->Primer_nom->AdvancedSearch->SearchCondition = @$filter["v_Primer_nom"];
		$this->Primer_nom->AdvancedSearch->SearchValue2 = @$filter["y_Primer_nom"];
		$this->Primer_nom->AdvancedSearch->SearchOperator2 = @$filter["w_Primer_nom"];
		$this->Primer_nom->AdvancedSearch->Save();

		// Field Segundo_nom
		$this->Segundo_nom->AdvancedSearch->SearchValue = @$filter["x_Segundo_nom"];
		$this->Segundo_nom->AdvancedSearch->SearchOperator = @$filter["z_Segundo_nom"];
		$this->Segundo_nom->AdvancedSearch->SearchCondition = @$filter["v_Segundo_nom"];
		$this->Segundo_nom->AdvancedSearch->SearchValue2 = @$filter["y_Segundo_nom"];
		$this->Segundo_nom->AdvancedSearch->SearchOperator2 = @$filter["w_Segundo_nom"];
		$this->Segundo_nom->AdvancedSearch->Save();

		// Field Edad
		$this->Edad->AdvancedSearch->SearchValue = @$filter["x_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator = @$filter["z_Edad"];
		$this->Edad->AdvancedSearch->SearchCondition = @$filter["v_Edad"];
		$this->Edad->AdvancedSearch->SearchValue2 = @$filter["y_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator2 = @$filter["w_Edad"];
		$this->Edad->AdvancedSearch->Save();

		// Field Unidad_edad
		$this->Unidad_edad->AdvancedSearch->SearchValue = @$filter["x_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchOperator = @$filter["z_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchCondition = @$filter["v_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchValue2 = @$filter["y_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->SearchOperator2 = @$filter["w_Unidad_edad"];
		$this->Unidad_edad->AdvancedSearch->Save();

		// Field Sexo
		$this->Sexo->AdvancedSearch->SearchValue = @$filter["x_Sexo"];
		$this->Sexo->AdvancedSearch->SearchOperator = @$filter["z_Sexo"];
		$this->Sexo->AdvancedSearch->SearchCondition = @$filter["v_Sexo"];
		$this->Sexo->AdvancedSearch->SearchValue2 = @$filter["y_Sexo"];
		$this->Sexo->AdvancedSearch->SearchOperator2 = @$filter["w_Sexo"];
		$this->Sexo->AdvancedSearch->Save();

		// Field Codigo_dpto
		$this->Codigo_dpto->AdvancedSearch->SearchValue = @$filter["x_Codigo_dpto"];
		$this->Codigo_dpto->AdvancedSearch->SearchOperator = @$filter["z_Codigo_dpto"];
		$this->Codigo_dpto->AdvancedSearch->SearchCondition = @$filter["v_Codigo_dpto"];
		$this->Codigo_dpto->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_dpto"];
		$this->Codigo_dpto->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_dpto"];
		$this->Codigo_dpto->AdvancedSearch->Save();

		// Field Cod_municipio
		$this->Cod_municipio->AdvancedSearch->SearchValue = @$filter["x_Cod_municipio"];
		$this->Cod_municipio->AdvancedSearch->SearchOperator = @$filter["z_Cod_municipio"];
		$this->Cod_municipio->AdvancedSearch->SearchCondition = @$filter["v_Cod_municipio"];
		$this->Cod_municipio->AdvancedSearch->SearchValue2 = @$filter["y_Cod_municipio"];
		$this->Cod_municipio->AdvancedSearch->SearchOperator2 = @$filter["w_Cod_municipio"];
		$this->Cod_municipio->AdvancedSearch->Save();

		// Field Zona_residencia
		$this->Zona_residencia->AdvancedSearch->SearchValue = @$filter["x_Zona_residencia"];
		$this->Zona_residencia->AdvancedSearch->SearchOperator = @$filter["z_Zona_residencia"];
		$this->Zona_residencia->AdvancedSearch->SearchCondition = @$filter["v_Zona_residencia"];
		$this->Zona_residencia->AdvancedSearch->SearchValue2 = @$filter["y_Zona_residencia"];
		$this->Zona_residencia->AdvancedSearch->SearchOperator2 = @$filter["w_Zona_residencia"];
		$this->Zona_residencia->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Tipo_doc, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Documento, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_eps, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Primer_ap, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Segundo_ap, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Primer_nom, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Segundo_nom, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Sexo, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Zona_residencia, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Tipo_doc); // Tipo_doc
			$this->UpdateSort($this->Documento); // Documento
			$this->UpdateSort($this->Codigo_eps); // Codigo_eps
			$this->UpdateSort($this->Tipo_Usuario); // Tipo_Usuario
			$this->UpdateSort($this->Primer_ap); // Primer_ap
			$this->UpdateSort($this->Segundo_ap); // Segundo_ap
			$this->UpdateSort($this->Primer_nom); // Primer_nom
			$this->UpdateSort($this->Segundo_nom); // Segundo_nom
			$this->UpdateSort($this->Edad); // Edad
			$this->UpdateSort($this->Unidad_edad); // Unidad_edad
			$this->UpdateSort($this->Sexo); // Sexo
			$this->UpdateSort($this->Codigo_dpto); // Codigo_dpto
			$this->UpdateSort($this->Cod_municipio); // Cod_municipio
			$this->UpdateSort($this->Zona_residencia); // Zona_residencia
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Tipo_doc->setSort("");
				$this->Documento->setSort("");
				$this->Codigo_eps->setSort("");
				$this->Tipo_Usuario->setSort("");
				$this->Primer_ap->setSort("");
				$this->Segundo_ap->setSort("");
				$this->Primer_nom->setSort("");
				$this->Segundo_nom->setSort("");
				$this->Edad->setSort("");
				$this->Unidad_edad->setSort("");
				$this->Sexo->setSort("");
				$this->Codigo_dpto->setSort("");
				$this->Cod_municipio->setSort("");
				$this->Zona_residencia->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fusuario_2020listsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fusuario_2020listsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fusuario_2020list}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fusuario_2020listsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Tipo_doc->setDbValue($rs->fields('Tipo_doc'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Codigo_eps->setDbValue($rs->fields('Codigo_eps'));
		$this->Tipo_Usuario->setDbValue($rs->fields('Tipo_Usuario'));
		$this->Primer_ap->setDbValue($rs->fields('Primer_ap'));
		$this->Segundo_ap->setDbValue($rs->fields('Segundo_ap'));
		$this->Primer_nom->setDbValue($rs->fields('Primer_nom'));
		$this->Segundo_nom->setDbValue($rs->fields('Segundo_nom'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Unidad_edad->setDbValue($rs->fields('Unidad_edad'));
		$this->Sexo->setDbValue($rs->fields('Sexo'));
		$this->Codigo_dpto->setDbValue($rs->fields('Codigo_dpto'));
		$this->Cod_municipio->setDbValue($rs->fields('Cod_municipio'));
		$this->Zona_residencia->setDbValue($rs->fields('Zona_residencia'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Tipo_doc->DbValue = $row['Tipo_doc'];
		$this->Documento->DbValue = $row['Documento'];
		$this->Codigo_eps->DbValue = $row['Codigo_eps'];
		$this->Tipo_Usuario->DbValue = $row['Tipo_Usuario'];
		$this->Primer_ap->DbValue = $row['Primer_ap'];
		$this->Segundo_ap->DbValue = $row['Segundo_ap'];
		$this->Primer_nom->DbValue = $row['Primer_nom'];
		$this->Segundo_nom->DbValue = $row['Segundo_nom'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Unidad_edad->DbValue = $row['Unidad_edad'];
		$this->Sexo->DbValue = $row['Sexo'];
		$this->Codigo_dpto->DbValue = $row['Codigo_dpto'];
		$this->Cod_municipio->DbValue = $row['Cod_municipio'];
		$this->Zona_residencia->DbValue = $row['Zona_residencia'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Tipo_doc
		// Documento
		// Codigo_eps
		// Tipo_Usuario
		// Primer_ap
		// Segundo_ap
		// Primer_nom
		// Segundo_nom
		// Edad
		// Unidad_edad
		// Sexo
		// Codigo_dpto
		// Cod_municipio
		// Zona_residencia

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Tipo_doc
		$this->Tipo_doc->ViewValue = $this->Tipo_doc->CurrentValue;
		$this->Tipo_doc->ViewCustomAttributes = "";

		// Documento
		$this->Documento->ViewValue = $this->Documento->CurrentValue;
		$this->Documento->ViewCustomAttributes = "";

		// Codigo_eps
		$this->Codigo_eps->ViewValue = $this->Codigo_eps->CurrentValue;
		$this->Codigo_eps->ViewCustomAttributes = "";

		// Tipo_Usuario
		$this->Tipo_Usuario->ViewValue = $this->Tipo_Usuario->CurrentValue;
		$this->Tipo_Usuario->ViewCustomAttributes = "";

		// Primer_ap
		$this->Primer_ap->ViewValue = $this->Primer_ap->CurrentValue;
		$this->Primer_ap->ViewCustomAttributes = "";

		// Segundo_ap
		$this->Segundo_ap->ViewValue = $this->Segundo_ap->CurrentValue;
		$this->Segundo_ap->ViewCustomAttributes = "";

		// Primer_nom
		$this->Primer_nom->ViewValue = $this->Primer_nom->CurrentValue;
		$this->Primer_nom->ViewCustomAttributes = "";

		// Segundo_nom
		$this->Segundo_nom->ViewValue = $this->Segundo_nom->CurrentValue;
		$this->Segundo_nom->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Unidad_edad
		$this->Unidad_edad->ViewValue = $this->Unidad_edad->CurrentValue;
		$this->Unidad_edad->ViewCustomAttributes = "";

		// Sexo
		$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
		$this->Sexo->ViewCustomAttributes = "";

		// Codigo_dpto
		$this->Codigo_dpto->ViewValue = $this->Codigo_dpto->CurrentValue;
		$this->Codigo_dpto->ViewCustomAttributes = "";

		// Cod_municipio
		$this->Cod_municipio->ViewValue = $this->Cod_municipio->CurrentValue;
		$this->Cod_municipio->ViewCustomAttributes = "";

		// Zona_residencia
		$this->Zona_residencia->ViewValue = $this->Zona_residencia->CurrentValue;
		$this->Zona_residencia->ViewCustomAttributes = "";

			// Tipo_doc
			$this->Tipo_doc->LinkCustomAttributes = "";
			$this->Tipo_doc->HrefValue = "";
			$this->Tipo_doc->TooltipValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";
			$this->Documento->TooltipValue = "";

			// Codigo_eps
			$this->Codigo_eps->LinkCustomAttributes = "";
			$this->Codigo_eps->HrefValue = "";
			$this->Codigo_eps->TooltipValue = "";

			// Tipo_Usuario
			$this->Tipo_Usuario->LinkCustomAttributes = "";
			$this->Tipo_Usuario->HrefValue = "";
			$this->Tipo_Usuario->TooltipValue = "";

			// Primer_ap
			$this->Primer_ap->LinkCustomAttributes = "";
			$this->Primer_ap->HrefValue = "";
			$this->Primer_ap->TooltipValue = "";

			// Segundo_ap
			$this->Segundo_ap->LinkCustomAttributes = "";
			$this->Segundo_ap->HrefValue = "";
			$this->Segundo_ap->TooltipValue = "";

			// Primer_nom
			$this->Primer_nom->LinkCustomAttributes = "";
			$this->Primer_nom->HrefValue = "";
			$this->Primer_nom->TooltipValue = "";

			// Segundo_nom
			$this->Segundo_nom->LinkCustomAttributes = "";
			$this->Segundo_nom->HrefValue = "";
			$this->Segundo_nom->TooltipValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";
			$this->Edad->TooltipValue = "";

			// Unidad_edad
			$this->Unidad_edad->LinkCustomAttributes = "";
			$this->Unidad_edad->HrefValue = "";
			$this->Unidad_edad->TooltipValue = "";

			// Sexo
			$this->Sexo->LinkCustomAttributes = "";
			$this->Sexo->HrefValue = "";
			$this->Sexo->TooltipValue = "";

			// Codigo_dpto
			$this->Codigo_dpto->LinkCustomAttributes = "";
			$this->Codigo_dpto->HrefValue = "";
			$this->Codigo_dpto->TooltipValue = "";

			// Cod_municipio
			$this->Cod_municipio->LinkCustomAttributes = "";
			$this->Cod_municipio->HrefValue = "";
			$this->Cod_municipio->TooltipValue = "";

			// Zona_residencia
			$this->Zona_residencia->LinkCustomAttributes = "";
			$this->Zona_residencia->HrefValue = "";
			$this->Zona_residencia->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($usuario_2020_list)) $usuario_2020_list = new cusuario_2020_list();

// Page init
$usuario_2020_list->Page_Init();

// Page main
$usuario_2020_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$usuario_2020_list->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fusuario_2020list = new ew_Form("fusuario_2020list", "list");
fusuario_2020list.FormKeyCountName = '<?php echo $usuario_2020_list->FormKeyCountName ?>';

// Form_CustomValidate event
fusuario_2020list.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fusuario_2020list.ValidateRequired = true;
<?php } else { ?>
fusuario_2020list.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

var CurrentSearchForm = fusuario_2020listsrch = new ew_Form("fusuario_2020listsrch");
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php if ($usuario_2020_list->TotalRecs > 0 && $usuario_2020_list->ExportOptions->Visible()) { ?>
<?php $usuario_2020_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($usuario_2020_list->SearchOptions->Visible()) { ?>
<?php $usuario_2020_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($usuario_2020_list->FilterOptions->Visible()) { ?>
<?php $usuario_2020_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php
	$bSelectLimit = $usuario_2020_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($usuario_2020_list->TotalRecs <= 0)
			$usuario_2020_list->TotalRecs = $usuario_2020->SelectRecordCount();
	} else {
		if (!$usuario_2020_list->Recordset && ($usuario_2020_list->Recordset = $usuario_2020_list->LoadRecordset()))
			$usuario_2020_list->TotalRecs = $usuario_2020_list->Recordset->RecordCount();
	}
	$usuario_2020_list->StartRec = 1;
	if ($usuario_2020_list->DisplayRecs <= 0 || ($usuario_2020->Export <> "" && $usuario_2020->ExportAll)) // Display all records
		$usuario_2020_list->DisplayRecs = $usuario_2020_list->TotalRecs;
	if (!($usuario_2020->Export <> "" && $usuario_2020->ExportAll))
		$usuario_2020_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$usuario_2020_list->Recordset = $usuario_2020_list->LoadRecordset($usuario_2020_list->StartRec-1, $usuario_2020_list->DisplayRecs);

	// Set no record found message
	if ($usuario_2020->CurrentAction == "" && $usuario_2020_list->TotalRecs == 0) {
		if ($usuario_2020_list->SearchWhere == "0=101")
			$usuario_2020_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$usuario_2020_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$usuario_2020_list->RenderOtherOptions();
?>
<?php if ($usuario_2020->Export == "" && $usuario_2020->CurrentAction == "") { ?>
<form name="fusuario_2020listsrch" id="fusuario_2020listsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($usuario_2020_list->SearchWhere <> "") ? " in" : " in"; ?>
<div id="fusuario_2020listsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="usuario_2020">
	<div class="ewBasicSearch">
<div id="xsr_1" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($usuario_2020_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($usuario_2020_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $usuario_2020_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($usuario_2020_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($usuario_2020_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($usuario_2020_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($usuario_2020_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php $usuario_2020_list->ShowPageHeader(); ?>
<?php
$usuario_2020_list->ShowMessage();
?>
<?php if ($usuario_2020_list->TotalRecs > 0 || $usuario_2020->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<form name="fusuario_2020list" id="fusuario_2020list" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($usuario_2020_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $usuario_2020_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="usuario_2020">
<div id="gmp_usuario_2020" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($usuario_2020_list->TotalRecs > 0) { ?>
<table id="tbl_usuario_2020list" class="table ewTable">
<?php echo $usuario_2020->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$usuario_2020_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$usuario_2020_list->RenderListOptions();

// Render list options (header, left)
$usuario_2020_list->ListOptions->Render("header", "left");
?>
<?php if ($usuario_2020->Tipo_doc->Visible) { // Tipo_doc ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Tipo_doc) == "") { ?>
		<th data-name="Tipo_doc"><div id="elh_usuario_2020_Tipo_doc" class="usuario_2020_Tipo_doc"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Tipo_doc->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tipo_doc"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Tipo_doc) ?>',1);"><div id="elh_usuario_2020_Tipo_doc" class="usuario_2020_Tipo_doc">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Tipo_doc->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Tipo_doc->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Tipo_doc->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Documento->Visible) { // Documento ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Documento) == "") { ?>
		<th data-name="Documento"><div id="elh_usuario_2020_Documento" class="usuario_2020_Documento"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Documento->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Documento"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Documento) ?>',1);"><div id="elh_usuario_2020_Documento" class="usuario_2020_Documento">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Documento->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Documento->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Documento->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Codigo_eps->Visible) { // Codigo_eps ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Codigo_eps) == "") { ?>
		<th data-name="Codigo_eps"><div id="elh_usuario_2020_Codigo_eps" class="usuario_2020_Codigo_eps"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Codigo_eps->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_eps"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Codigo_eps) ?>',1);"><div id="elh_usuario_2020_Codigo_eps" class="usuario_2020_Codigo_eps">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Codigo_eps->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Codigo_eps->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Codigo_eps->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Tipo_Usuario->Visible) { // Tipo_Usuario ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Tipo_Usuario) == "") { ?>
		<th data-name="Tipo_Usuario"><div id="elh_usuario_2020_Tipo_Usuario" class="usuario_2020_Tipo_Usuario"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Tipo_Usuario->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tipo_Usuario"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Tipo_Usuario) ?>',1);"><div id="elh_usuario_2020_Tipo_Usuario" class="usuario_2020_Tipo_Usuario">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Tipo_Usuario->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Tipo_Usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Tipo_Usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Primer_ap->Visible) { // Primer_ap ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Primer_ap) == "") { ?>
		<th data-name="Primer_ap"><div id="elh_usuario_2020_Primer_ap" class="usuario_2020_Primer_ap"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Primer_ap->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primer_ap"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Primer_ap) ?>',1);"><div id="elh_usuario_2020_Primer_ap" class="usuario_2020_Primer_ap">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Primer_ap->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Primer_ap->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Primer_ap->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Segundo_ap->Visible) { // Segundo_ap ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Segundo_ap) == "") { ?>
		<th data-name="Segundo_ap"><div id="elh_usuario_2020_Segundo_ap" class="usuario_2020_Segundo_ap"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Segundo_ap->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Segundo_ap"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Segundo_ap) ?>',1);"><div id="elh_usuario_2020_Segundo_ap" class="usuario_2020_Segundo_ap">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Segundo_ap->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Segundo_ap->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Segundo_ap->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Primer_nom->Visible) { // Primer_nom ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Primer_nom) == "") { ?>
		<th data-name="Primer_nom"><div id="elh_usuario_2020_Primer_nom" class="usuario_2020_Primer_nom"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Primer_nom->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primer_nom"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Primer_nom) ?>',1);"><div id="elh_usuario_2020_Primer_nom" class="usuario_2020_Primer_nom">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Primer_nom->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Primer_nom->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Primer_nom->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Segundo_nom->Visible) { // Segundo_nom ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Segundo_nom) == "") { ?>
		<th data-name="Segundo_nom"><div id="elh_usuario_2020_Segundo_nom" class="usuario_2020_Segundo_nom"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Segundo_nom->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Segundo_nom"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Segundo_nom) ?>',1);"><div id="elh_usuario_2020_Segundo_nom" class="usuario_2020_Segundo_nom">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Segundo_nom->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Segundo_nom->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Segundo_nom->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Edad->Visible) { // Edad ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Edad) == "") { ?>
		<th data-name="Edad"><div id="elh_usuario_2020_Edad" class="usuario_2020_Edad"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Edad->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Edad"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Edad) ?>',1);"><div id="elh_usuario_2020_Edad" class="usuario_2020_Edad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Edad->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Unidad_edad->Visible) { // Unidad_edad ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Unidad_edad) == "") { ?>
		<th data-name="Unidad_edad"><div id="elh_usuario_2020_Unidad_edad" class="usuario_2020_Unidad_edad"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Unidad_edad->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Unidad_edad"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Unidad_edad) ?>',1);"><div id="elh_usuario_2020_Unidad_edad" class="usuario_2020_Unidad_edad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Unidad_edad->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Unidad_edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Unidad_edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Sexo->Visible) { // Sexo ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Sexo) == "") { ?>
		<th data-name="Sexo"><div id="elh_usuario_2020_Sexo" class="usuario_2020_Sexo"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Sexo->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Sexo"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Sexo) ?>',1);"><div id="elh_usuario_2020_Sexo" class="usuario_2020_Sexo">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Sexo->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Sexo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Sexo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Codigo_dpto->Visible) { // Codigo_dpto ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Codigo_dpto) == "") { ?>
		<th data-name="Codigo_dpto"><div id="elh_usuario_2020_Codigo_dpto" class="usuario_2020_Codigo_dpto"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Codigo_dpto->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_dpto"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Codigo_dpto) ?>',1);"><div id="elh_usuario_2020_Codigo_dpto" class="usuario_2020_Codigo_dpto">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Codigo_dpto->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Codigo_dpto->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Codigo_dpto->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Cod_municipio->Visible) { // Cod_municipio ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Cod_municipio) == "") { ?>
		<th data-name="Cod_municipio"><div id="elh_usuario_2020_Cod_municipio" class="usuario_2020_Cod_municipio"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Cod_municipio->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Cod_municipio"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Cod_municipio) ?>',1);"><div id="elh_usuario_2020_Cod_municipio" class="usuario_2020_Cod_municipio">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Cod_municipio->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Cod_municipio->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Cod_municipio->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($usuario_2020->Zona_residencia->Visible) { // Zona_residencia ?>
	<?php if ($usuario_2020->SortUrl($usuario_2020->Zona_residencia) == "") { ?>
		<th data-name="Zona_residencia"><div id="elh_usuario_2020_Zona_residencia" class="usuario_2020_Zona_residencia"><div class="ewTableHeaderCaption"><?php echo $usuario_2020->Zona_residencia->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Zona_residencia"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $usuario_2020->SortUrl($usuario_2020->Zona_residencia) ?>',1);"><div id="elh_usuario_2020_Zona_residencia" class="usuario_2020_Zona_residencia">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $usuario_2020->Zona_residencia->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($usuario_2020->Zona_residencia->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($usuario_2020->Zona_residencia->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$usuario_2020_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($usuario_2020->ExportAll && $usuario_2020->Export <> "") {
	$usuario_2020_list->StopRec = $usuario_2020_list->TotalRecs;
} else {

	// Set the last record to display
	if ($usuario_2020_list->TotalRecs > $usuario_2020_list->StartRec + $usuario_2020_list->DisplayRecs - 1)
		$usuario_2020_list->StopRec = $usuario_2020_list->StartRec + $usuario_2020_list->DisplayRecs - 1;
	else
		$usuario_2020_list->StopRec = $usuario_2020_list->TotalRecs;
}
$usuario_2020_list->RecCnt = $usuario_2020_list->StartRec - 1;
if ($usuario_2020_list->Recordset && !$usuario_2020_list->Recordset->EOF) {
	$usuario_2020_list->Recordset->MoveFirst();
	$bSelectLimit = $usuario_2020_list->UseSelectLimit;
	if (!$bSelectLimit && $usuario_2020_list->StartRec > 1)
		$usuario_2020_list->Recordset->Move($usuario_2020_list->StartRec - 1);
} elseif (!$usuario_2020->AllowAddDeleteRow && $usuario_2020_list->StopRec == 0) {
	$usuario_2020_list->StopRec = $usuario_2020->GridAddRowCount;
}

// Initialize aggregate
$usuario_2020->RowType = EW_ROWTYPE_AGGREGATEINIT;
$usuario_2020->ResetAttrs();
$usuario_2020_list->RenderRow();
while ($usuario_2020_list->RecCnt < $usuario_2020_list->StopRec) {
	$usuario_2020_list->RecCnt++;
	if (intval($usuario_2020_list->RecCnt) >= intval($usuario_2020_list->StartRec)) {
		$usuario_2020_list->RowCnt++;

		// Set up key count
		$usuario_2020_list->KeyCount = $usuario_2020_list->RowIndex;

		// Init row class and style
		$usuario_2020->ResetAttrs();
		$usuario_2020->CssClass = "";
		if ($usuario_2020->CurrentAction == "gridadd") {
		} else {
			$usuario_2020_list->LoadRowValues($usuario_2020_list->Recordset); // Load row values
		}
		$usuario_2020->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$usuario_2020->RowAttrs = array_merge($usuario_2020->RowAttrs, array('data-rowindex'=>$usuario_2020_list->RowCnt, 'id'=>'r' . $usuario_2020_list->RowCnt . '_usuario_2020', 'data-rowtype'=>$usuario_2020->RowType));

		// Render row
		$usuario_2020_list->RenderRow();

		// Render list options
		$usuario_2020_list->RenderListOptions();
?>
	<tr<?php echo $usuario_2020->RowAttributes() ?>>
<?php

// Render list options (body, left)
$usuario_2020_list->ListOptions->Render("body", "left", $usuario_2020_list->RowCnt);
?>
	<?php if ($usuario_2020->Tipo_doc->Visible) { // Tipo_doc ?>
		<td data-name="Tipo_doc"<?php echo $usuario_2020->Tipo_doc->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Tipo_doc" class="usuario_2020_Tipo_doc">
<span<?php echo $usuario_2020->Tipo_doc->ViewAttributes() ?>>
<?php echo $usuario_2020->Tipo_doc->ListViewValue() ?></span>
</span>
<a id="<?php echo $usuario_2020_list->PageObjName . "_row_" . $usuario_2020_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($usuario_2020->Documento->Visible) { // Documento ?>
		<td data-name="Documento"<?php echo $usuario_2020->Documento->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Documento" class="usuario_2020_Documento">
<span<?php echo $usuario_2020->Documento->ViewAttributes() ?>>
<?php echo $usuario_2020->Documento->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Codigo_eps->Visible) { // Codigo_eps ?>
		<td data-name="Codigo_eps"<?php echo $usuario_2020->Codigo_eps->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Codigo_eps" class="usuario_2020_Codigo_eps">
<span<?php echo $usuario_2020->Codigo_eps->ViewAttributes() ?>>
<?php echo $usuario_2020->Codigo_eps->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Tipo_Usuario->Visible) { // Tipo_Usuario ?>
		<td data-name="Tipo_Usuario"<?php echo $usuario_2020->Tipo_Usuario->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Tipo_Usuario" class="usuario_2020_Tipo_Usuario">
<span<?php echo $usuario_2020->Tipo_Usuario->ViewAttributes() ?>>
<?php echo $usuario_2020->Tipo_Usuario->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Primer_ap->Visible) { // Primer_ap ?>
		<td data-name="Primer_ap"<?php echo $usuario_2020->Primer_ap->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Primer_ap" class="usuario_2020_Primer_ap">
<span<?php echo $usuario_2020->Primer_ap->ViewAttributes() ?>>
<?php echo $usuario_2020->Primer_ap->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Segundo_ap->Visible) { // Segundo_ap ?>
		<td data-name="Segundo_ap"<?php echo $usuario_2020->Segundo_ap->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Segundo_ap" class="usuario_2020_Segundo_ap">
<span<?php echo $usuario_2020->Segundo_ap->ViewAttributes() ?>>
<?php echo $usuario_2020->Segundo_ap->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Primer_nom->Visible) { // Primer_nom ?>
		<td data-name="Primer_nom"<?php echo $usuario_2020->Primer_nom->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Primer_nom" class="usuario_2020_Primer_nom">
<span<?php echo $usuario_2020->Primer_nom->ViewAttributes() ?>>
<?php echo $usuario_2020->Primer_nom->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Segundo_nom->Visible) { // Segundo_nom ?>
		<td data-name="Segundo_nom"<?php echo $usuario_2020->Segundo_nom->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Segundo_nom" class="usuario_2020_Segundo_nom">
<span<?php echo $usuario_2020->Segundo_nom->ViewAttributes() ?>>
<?php echo $usuario_2020->Segundo_nom->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Edad->Visible) { // Edad ?>
		<td data-name="Edad"<?php echo $usuario_2020->Edad->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Edad" class="usuario_2020_Edad">
<span<?php echo $usuario_2020->Edad->ViewAttributes() ?>>
<?php echo $usuario_2020->Edad->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Unidad_edad->Visible) { // Unidad_edad ?>
		<td data-name="Unidad_edad"<?php echo $usuario_2020->Unidad_edad->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Unidad_edad" class="usuario_2020_Unidad_edad">
<span<?php echo $usuario_2020->Unidad_edad->ViewAttributes() ?>>
<?php echo $usuario_2020->Unidad_edad->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Sexo->Visible) { // Sexo ?>
		<td data-name="Sexo"<?php echo $usuario_2020->Sexo->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Sexo" class="usuario_2020_Sexo">
<span<?php echo $usuario_2020->Sexo->ViewAttributes() ?>>
<?php echo $usuario_2020->Sexo->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Codigo_dpto->Visible) { // Codigo_dpto ?>
		<td data-name="Codigo_dpto"<?php echo $usuario_2020->Codigo_dpto->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Codigo_dpto" class="usuario_2020_Codigo_dpto">
<span<?php echo $usuario_2020->Codigo_dpto->ViewAttributes() ?>>
<?php echo $usuario_2020->Codigo_dpto->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Cod_municipio->Visible) { // Cod_municipio ?>
		<td data-name="Cod_municipio"<?php echo $usuario_2020->Cod_municipio->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Cod_municipio" class="usuario_2020_Cod_municipio">
<span<?php echo $usuario_2020->Cod_municipio->ViewAttributes() ?>>
<?php echo $usuario_2020->Cod_municipio->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($usuario_2020->Zona_residencia->Visible) { // Zona_residencia ?>
		<td data-name="Zona_residencia"<?php echo $usuario_2020->Zona_residencia->CellAttributes() ?>>
<span id="el<?php echo $usuario_2020_list->RowCnt ?>_usuario_2020_Zona_residencia" class="usuario_2020_Zona_residencia">
<span<?php echo $usuario_2020->Zona_residencia->ViewAttributes() ?>>
<?php echo $usuario_2020->Zona_residencia->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$usuario_2020_list->ListOptions->Render("body", "right", $usuario_2020_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($usuario_2020->CurrentAction <> "gridadd")
		$usuario_2020_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($usuario_2020->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($usuario_2020_list->Recordset)
	$usuario_2020_list->Recordset->Close();
?>
<div class="panel-footer ewGridLowerPanel">
<?php if ($usuario_2020->CurrentAction <> "gridadd" && $usuario_2020->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($usuario_2020_list->Pager)) $usuario_2020_list->Pager = new cPrevNextPager($usuario_2020_list->StartRec, $usuario_2020_list->DisplayRecs, $usuario_2020_list->TotalRecs) ?>
<?php if ($usuario_2020_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($usuario_2020_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $usuario_2020_list->PageUrl() ?>start=<?php echo $usuario_2020_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($usuario_2020_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $usuario_2020_list->PageUrl() ?>start=<?php echo $usuario_2020_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $usuario_2020_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($usuario_2020_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $usuario_2020_list->PageUrl() ?>start=<?php echo $usuario_2020_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($usuario_2020_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $usuario_2020_list->PageUrl() ?>start=<?php echo $usuario_2020_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $usuario_2020_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $usuario_2020_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $usuario_2020_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $usuario_2020_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($usuario_2020_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
</div>
<?php } ?>
<?php if ($usuario_2020_list->TotalRecs == 0 && $usuario_2020->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($usuario_2020_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<script type="text/javascript">
fusuario_2020listsrch.Init();
fusuario_2020listsrch.FilterList = <?php echo $usuario_2020_list->GetFilterList() ?>;
fusuario_2020list.Init();
</script>
<?php
$usuario_2020_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$usuario_2020_list->Page_Terminate();
?>
