<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "ficha_usuarioinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$ficha_usuario_edit = NULL; // Initialize page object first

class cficha_usuario_edit extends cficha_usuario {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = "{43FC4B6C-8131-46B1-916C-14DB52B1691D}";

	// Table name
	var $TableName = 'ficha_usuario';

	// Page object name
	var $PageObjName = 'ficha_usuario_edit';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (ficha_usuario)
		if (!isset($GLOBALS["ficha_usuario"]) || get_class($GLOBALS["ficha_usuario"]) == "cficha_usuario") {
			$GLOBALS["ficha_usuario"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ficha_usuario"];
		}

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'ficha_usuario', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (ficha_usuario)
		if (!isset($UserTable)) {
			$UserTable = new cficha_usuario();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("ficha_usuariolist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}
		if ($Security->IsLoggedIn()) {
			$Security->UserID_Loading();
			$Security->LoadUserID();
			$Security->UserID_Loaded();
			if (strval($Security->CurrentUserID()) == "") {
				$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
				$this->Page_Terminate(ew_GetUrl("ficha_usuariolist.php"));
			}
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->Id_Usuario->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $ficha_usuario;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ficha_usuario);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $DbMasterFilter;
	var $DbDetailFilter;
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Load key from QueryString
		if (@$_GET["Id_Usuario"] <> "") {
			$this->Id_Usuario->setQueryStringValue($_GET["Id_Usuario"]);
			$this->RecKey["Id_Usuario"] = $this->Id_Usuario->QueryStringValue;
		} else {
			$bLoadCurrentRecord = TRUE;
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($this->Recordset = $this->LoadRecordset()) // Load records
			$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$this->Page_Terminate("ficha_usuariolist.php"); // Return to list page
		} elseif ($bLoadCurrentRecord) { // Load current record position
			$this->SetUpStartRec(); // Set up start record position

			// Point to current record
			if (intval($this->StartRec) <= intval($this->TotalRecs)) {
				$bMatchRecord = TRUE;
				$this->Recordset->Move($this->StartRec-1);
			}
		} else { // Match key values
			while (!$this->Recordset->EOF) {
				if (strval($this->Id_Usuario->CurrentValue) == strval($this->Recordset->fields('Id_Usuario'))) {
					$this->setStartRecordNumber($this->StartRec); // Save record position
					$bMatchRecord = TRUE;
					break;
				} else {
					$this->StartRec++;
					$this->Recordset->MoveNext();
				}
			}
		}

		// Process form if post back
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			$this->LoadFormValues(); // Get form values
		} else {
			$this->CurrentAction = "I"; // Default action is display
		}

		// Validate form if post back
		if (@$_POST["a_edit"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$bMatchRecord) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
					$this->Page_Terminate("ficha_usuariolist.php"); // Return to list page
				} else {
					$this->LoadRowValues($this->Recordset); // Load row values
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "ficha_usuariolist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to list page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->Id_Usuario->FldIsDetailKey)
			$this->Id_Usuario->setFormValue($objForm->GetValue("x_Id_Usuario"));
		if (!$this->Nombres->FldIsDetailKey) {
			$this->Nombres->setFormValue($objForm->GetValue("x_Nombres"));
		}
		if (!$this->Apellidos->FldIsDetailKey) {
			$this->Apellidos->setFormValue($objForm->GetValue("x_Apellidos"));
		}
		if (!$this->Cedula_Identificacion->FldIsDetailKey) {
			$this->Cedula_Identificacion->setFormValue($objForm->GetValue("x_Cedula_Identificacion"));
		}
		if (!$this->Entidad_EPS->FldIsDetailKey) {
			$this->Entidad_EPS->setFormValue($objForm->GetValue("x_Entidad_EPS"));
		}
		if (!$this->ENTIDAD_IPS->FldIsDetailKey) {
			$this->ENTIDAD_IPS->setFormValue($objForm->GetValue("x_ENTIDAD_IPS"));
		}
		if (!$this->Correo->FldIsDetailKey) {
			$this->Correo->setFormValue($objForm->GetValue("x_Correo"));
		}
		if (!$this->Ingreso->FldIsDetailKey) {
			$this->Ingreso->setFormValue($objForm->GetValue("x_Ingreso"));
		}
		if (!$this->Clave->FldIsDetailKey) {
			$this->Clave->setFormValue($objForm->GetValue("x_Clave"));
		}
		if (!$this->Nivel->FldIsDetailKey) {
			$this->Nivel->setFormValue($objForm->GetValue("x_Nivel"));
		}
		if (!$this->Activo->FldIsDetailKey) {
			$this->Activo->setFormValue($objForm->GetValue("x_Activo"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadRow();
		$this->Id_Usuario->CurrentValue = $this->Id_Usuario->FormValue;
		$this->Nombres->CurrentValue = $this->Nombres->FormValue;
		$this->Apellidos->CurrentValue = $this->Apellidos->FormValue;
		$this->Cedula_Identificacion->CurrentValue = $this->Cedula_Identificacion->FormValue;
		$this->Entidad_EPS->CurrentValue = $this->Entidad_EPS->FormValue;
		$this->ENTIDAD_IPS->CurrentValue = $this->ENTIDAD_IPS->FormValue;
		$this->Correo->CurrentValue = $this->Correo->FormValue;
		$this->Ingreso->CurrentValue = $this->Ingreso->FormValue;
		$this->Clave->CurrentValue = $this->Clave->FormValue;
		$this->Nivel->CurrentValue = $this->Nivel->FormValue;
		$this->Activo->CurrentValue = $this->Activo->FormValue;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}

		// Check if valid user id
		if ($res) {
			$res = $this->ShowOptionLink('edit');
			if (!$res) {
				$sUserIdMsg = ew_DeniedMsg();
				$this->setFailureMessage($sUserIdMsg);
			}
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id_Usuario->setDbValue($rs->fields('Id_Usuario'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Cedula_Identificacion->setDbValue($rs->fields('Cedula_Identificacion'));
		$this->Entidad_EPS->setDbValue($rs->fields('Entidad_EPS'));
		$this->ENTIDAD_IPS->setDbValue($rs->fields('ENTIDAD_IPS'));
		$this->Correo->setDbValue($rs->fields('Correo'));
		$this->Ingreso->setDbValue($rs->fields('Ingreso'));
		$this->Clave->setDbValue($rs->fields('Clave'));
		$this->Nivel->setDbValue($rs->fields('Nivel'));
		$this->Activo->setDbValue($rs->fields('Activo'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id_Usuario->DbValue = $row['Id_Usuario'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Cedula_Identificacion->DbValue = $row['Cedula_Identificacion'];
		$this->Entidad_EPS->DbValue = $row['Entidad_EPS'];
		$this->ENTIDAD_IPS->DbValue = $row['ENTIDAD_IPS'];
		$this->Correo->DbValue = $row['Correo'];
		$this->Ingreso->DbValue = $row['Ingreso'];
		$this->Clave->DbValue = $row['Clave'];
		$this->Nivel->DbValue = $row['Nivel'];
		$this->Activo->DbValue = $row['Activo'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Id_Usuario
		// Nombres
		// Apellidos
		// Cedula_Identificacion
		// Entidad_EPS
		// ENTIDAD_IPS
		// Correo
		// Ingreso
		// Clave
		// Nivel
		// Activo

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Id_Usuario
		$this->Id_Usuario->ViewValue = $this->Id_Usuario->CurrentValue;
		$this->Id_Usuario->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Cedula_Identificacion
		$this->Cedula_Identificacion->ViewValue = $this->Cedula_Identificacion->CurrentValue;
		$this->Cedula_Identificacion->ViewCustomAttributes = "";

		// Entidad_EPS
		$this->Entidad_EPS->ViewValue = $this->Entidad_EPS->CurrentValue;
		if (strval($this->Entidad_EPS->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->Entidad_EPS->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad_EPS, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Entidad_EPS->ViewValue = $this->Entidad_EPS->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad_EPS->ViewValue = $this->Entidad_EPS->CurrentValue;
			}
		} else {
			$this->Entidad_EPS->ViewValue = NULL;
		}
		$this->Entidad_EPS->ViewCustomAttributes = "";

		// ENTIDAD_IPS
		$this->ENTIDAD_IPS->ViewValue = $this->ENTIDAD_IPS->CurrentValue;
		if (strval($this->ENTIDAD_IPS->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->ENTIDAD_IPS->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ENTIDAD_IPS, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->ENTIDAD_IPS->ViewValue = $this->ENTIDAD_IPS->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ENTIDAD_IPS->ViewValue = $this->ENTIDAD_IPS->CurrentValue;
			}
		} else {
			$this->ENTIDAD_IPS->ViewValue = NULL;
		}
		$this->ENTIDAD_IPS->ViewCustomAttributes = "";

		// Correo
		$this->Correo->ViewValue = $this->Correo->CurrentValue;
		$this->Correo->ViewCustomAttributes = "";

		// Ingreso
		$this->Ingreso->ViewValue = $this->Ingreso->CurrentValue;
		$this->Ingreso->ViewCustomAttributes = "";

		// Clave
		$this->Clave->ViewValue = $this->Clave->CurrentValue;
		$this->Clave->ViewCustomAttributes = "";

		// Nivel
		if ($Security->CanAdmin()) { // System admin
		if (strval($this->Nivel->CurrentValue) <> "") {
			$sFilterWrk = "`userlevelid`" . ew_SearchString("=", $this->Nivel->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `userlevelid`, `userlevelname` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `userlevels`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Nivel, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Nivel->ViewValue = $this->Nivel->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Nivel->ViewValue = $this->Nivel->CurrentValue;
			}
		} else {
			$this->Nivel->ViewValue = NULL;
		}
		} else {
			$this->Nivel->ViewValue = $Language->Phrase("PasswordMask");
		}
		$this->Nivel->ViewCustomAttributes = "";

		// Activo
		if (strval($this->Activo->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Activo->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Activo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Activo->ViewValue = $this->Activo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Activo->ViewValue = $this->Activo->CurrentValue;
			}
		} else {
			$this->Activo->ViewValue = NULL;
		}
		$this->Activo->ViewCustomAttributes = "";

			// Id_Usuario
			$this->Id_Usuario->LinkCustomAttributes = "";
			$this->Id_Usuario->HrefValue = "";
			$this->Id_Usuario->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->LinkCustomAttributes = "";
			$this->Cedula_Identificacion->HrefValue = "";
			$this->Cedula_Identificacion->TooltipValue = "";

			// Entidad_EPS
			$this->Entidad_EPS->LinkCustomAttributes = "";
			$this->Entidad_EPS->HrefValue = "";
			$this->Entidad_EPS->TooltipValue = "";

			// ENTIDAD_IPS
			$this->ENTIDAD_IPS->LinkCustomAttributes = "";
			$this->ENTIDAD_IPS->HrefValue = "";
			$this->ENTIDAD_IPS->TooltipValue = "";

			// Correo
			$this->Correo->LinkCustomAttributes = "";
			$this->Correo->HrefValue = "";
			$this->Correo->TooltipValue = "";

			// Ingreso
			$this->Ingreso->LinkCustomAttributes = "";
			$this->Ingreso->HrefValue = "";
			$this->Ingreso->TooltipValue = "";

			// Clave
			$this->Clave->LinkCustomAttributes = "";
			$this->Clave->HrefValue = "";
			$this->Clave->TooltipValue = "";

			// Nivel
			$this->Nivel->LinkCustomAttributes = "";
			$this->Nivel->HrefValue = "";
			$this->Nivel->TooltipValue = "";

			// Activo
			$this->Activo->LinkCustomAttributes = "";
			$this->Activo->HrefValue = "";
			$this->Activo->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// Id_Usuario
			$this->Id_Usuario->EditAttrs["class"] = "form-control";
			$this->Id_Usuario->EditCustomAttributes = "";
			$this->Id_Usuario->EditValue = $this->Id_Usuario->CurrentValue;
			$this->Id_Usuario->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->EditAttrs["class"] = "form-control";
			$this->Nombres->EditCustomAttributes = "";
			$this->Nombres->EditValue = ew_HtmlEncode($this->Nombres->CurrentValue);
			$this->Nombres->PlaceHolder = ew_RemoveHtml($this->Nombres->FldCaption());

			// Apellidos
			$this->Apellidos->EditAttrs["class"] = "form-control";
			$this->Apellidos->EditCustomAttributes = "";
			$this->Apellidos->EditValue = ew_HtmlEncode($this->Apellidos->CurrentValue);
			$this->Apellidos->PlaceHolder = ew_RemoveHtml($this->Apellidos->FldCaption());

			// Cedula_Identificacion
			$this->Cedula_Identificacion->EditAttrs["class"] = "form-control";
			$this->Cedula_Identificacion->EditCustomAttributes = "";
			$this->Cedula_Identificacion->EditValue = ew_HtmlEncode($this->Cedula_Identificacion->CurrentValue);
			$this->Cedula_Identificacion->PlaceHolder = ew_RemoveHtml($this->Cedula_Identificacion->FldCaption());

			// Entidad_EPS
			$this->Entidad_EPS->EditAttrs["class"] = "form-control";
			$this->Entidad_EPS->EditCustomAttributes = "";
			$this->Entidad_EPS->EditValue = ew_HtmlEncode($this->Entidad_EPS->CurrentValue);
			if (strval($this->Entidad_EPS->CurrentValue) <> "") {
				$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->Entidad_EPS->CurrentValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Entidad_EPS, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$arwrk[2] = ew_HtmlEncode($rswrk->fields('Disp2Fld'));
					$this->Entidad_EPS->EditValue = $this->Entidad_EPS->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Entidad_EPS->EditValue = ew_HtmlEncode($this->Entidad_EPS->CurrentValue);
				}
			} else {
				$this->Entidad_EPS->EditValue = NULL;
			}
			$this->Entidad_EPS->PlaceHolder = ew_RemoveHtml($this->Entidad_EPS->FldCaption());

			// ENTIDAD_IPS
			$this->ENTIDAD_IPS->EditAttrs["class"] = "form-control";
			$this->ENTIDAD_IPS->EditCustomAttributes = "";
			if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$this->UserIDAllow("edit")) { // Non system admin
				$this->ENTIDAD_IPS->CurrentValue = CurrentUserID();
			$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->CurrentValue;
			if (strval($this->ENTIDAD_IPS->CurrentValue) <> "") {
				$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->ENTIDAD_IPS->CurrentValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ENTIDAD_IPS, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$arwrk[2] = $rswrk->fields('Disp2Fld');
					$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->CurrentValue;
				}
			} else {
				$this->ENTIDAD_IPS->EditValue = NULL;
			}
			$this->ENTIDAD_IPS->ViewCustomAttributes = "";
			} else {
			$this->ENTIDAD_IPS->EditValue = ew_HtmlEncode($this->ENTIDAD_IPS->CurrentValue);
			if (strval($this->ENTIDAD_IPS->CurrentValue) <> "") {
				$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->ENTIDAD_IPS->CurrentValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ENTIDAD_IPS, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$arwrk[2] = ew_HtmlEncode($rswrk->fields('Disp2Fld'));
					$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ENTIDAD_IPS->EditValue = ew_HtmlEncode($this->ENTIDAD_IPS->CurrentValue);
				}
			} else {
				$this->ENTIDAD_IPS->EditValue = NULL;
			}
			$this->ENTIDAD_IPS->PlaceHolder = ew_RemoveHtml($this->ENTIDAD_IPS->FldCaption());
			}

			// Correo
			$this->Correo->EditAttrs["class"] = "form-control";
			$this->Correo->EditCustomAttributes = "";
			$this->Correo->EditValue = ew_HtmlEncode($this->Correo->CurrentValue);
			$this->Correo->PlaceHolder = ew_RemoveHtml($this->Correo->FldCaption());

			// Ingreso
			$this->Ingreso->EditAttrs["class"] = "form-control";
			$this->Ingreso->EditCustomAttributes = "";
			$this->Ingreso->EditValue = ew_HtmlEncode($this->Ingreso->CurrentValue);
			$this->Ingreso->PlaceHolder = ew_RemoveHtml($this->Ingreso->FldCaption());

			// Clave
			$this->Clave->EditAttrs["class"] = "form-control ewPasswordStrength";
			$this->Clave->EditCustomAttributes = "";
			$this->Clave->EditValue = ew_HtmlEncode($this->Clave->CurrentValue);
			$this->Clave->PlaceHolder = ew_RemoveHtml($this->Clave->FldCaption());

			// Nivel
			$this->Nivel->EditAttrs["class"] = "form-control";
			$this->Nivel->EditCustomAttributes = "";
			if (!$Security->CanAdmin()) { // System admin
				$this->Nivel->EditValue = $Language->Phrase("PasswordMask");
			} else {
			if (trim(strval($this->Nivel->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`userlevelid`" . ew_SearchString("=", $this->Nivel->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `userlevelid`, `userlevelname` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `userlevels`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Nivel, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Nivel->EditValue = $arwrk;
			}

			// Activo
			$this->Activo->EditCustomAttributes = "";
			if (trim(strval($this->Activo->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Activo->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `si_no`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Activo, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Activo->EditValue = $arwrk;

			// Edit refer script
			// Id_Usuario

			$this->Id_Usuario->LinkCustomAttributes = "";
			$this->Id_Usuario->HrefValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->LinkCustomAttributes = "";
			$this->Cedula_Identificacion->HrefValue = "";

			// Entidad_EPS
			$this->Entidad_EPS->LinkCustomAttributes = "";
			$this->Entidad_EPS->HrefValue = "";

			// ENTIDAD_IPS
			$this->ENTIDAD_IPS->LinkCustomAttributes = "";
			$this->ENTIDAD_IPS->HrefValue = "";

			// Correo
			$this->Correo->LinkCustomAttributes = "";
			$this->Correo->HrefValue = "";

			// Ingreso
			$this->Ingreso->LinkCustomAttributes = "";
			$this->Ingreso->HrefValue = "";

			// Clave
			$this->Clave->LinkCustomAttributes = "";
			$this->Clave->HrefValue = "";

			// Nivel
			$this->Nivel->LinkCustomAttributes = "";
			$this->Nivel->HrefValue = "";

			// Activo
			$this->Activo->LinkCustomAttributes = "";
			$this->Activo->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->Nombres->FldIsDetailKey && !is_null($this->Nombres->FormValue) && $this->Nombres->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Nombres->FldCaption(), $this->Nombres->ReqErrMsg));
		}
		if (!$this->Apellidos->FldIsDetailKey && !is_null($this->Apellidos->FormValue) && $this->Apellidos->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Apellidos->FldCaption(), $this->Apellidos->ReqErrMsg));
		}
		if (!$this->Cedula_Identificacion->FldIsDetailKey && !is_null($this->Cedula_Identificacion->FormValue) && $this->Cedula_Identificacion->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Cedula_Identificacion->FldCaption(), $this->Cedula_Identificacion->ReqErrMsg));
		}
		if (!$this->ENTIDAD_IPS->FldIsDetailKey && !is_null($this->ENTIDAD_IPS->FormValue) && $this->ENTIDAD_IPS->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ENTIDAD_IPS->FldCaption(), $this->ENTIDAD_IPS->ReqErrMsg));
		}
		if (!$this->Correo->FldIsDetailKey && !is_null($this->Correo->FormValue) && $this->Correo->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Correo->FldCaption(), $this->Correo->ReqErrMsg));
		}
		if (!$this->Ingreso->FldIsDetailKey && !is_null($this->Ingreso->FormValue) && $this->Ingreso->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Ingreso->FldCaption(), $this->Ingreso->ReqErrMsg));
		}
		if (!$this->Clave->FldIsDetailKey && !is_null($this->Clave->FormValue) && $this->Clave->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Clave->FldCaption(), $this->Clave->ReqErrMsg));
		}
		if (!$this->Nivel->FldIsDetailKey && !is_null($this->Nivel->FormValue) && $this->Nivel->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Nivel->FldCaption(), $this->Nivel->ReqErrMsg));
		}
		if ($this->Activo->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Activo->FldCaption(), $this->Activo->ReqErrMsg));
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// Nombres
			$this->Nombres->SetDbValueDef($rsnew, $this->Nombres->CurrentValue, "", $this->Nombres->ReadOnly);

			// Apellidos
			$this->Apellidos->SetDbValueDef($rsnew, $this->Apellidos->CurrentValue, "", $this->Apellidos->ReadOnly);

			// Cedula_Identificacion
			$this->Cedula_Identificacion->SetDbValueDef($rsnew, $this->Cedula_Identificacion->CurrentValue, "", $this->Cedula_Identificacion->ReadOnly);

			// Entidad_EPS
			$this->Entidad_EPS->SetDbValueDef($rsnew, $this->Entidad_EPS->CurrentValue, NULL, $this->Entidad_EPS->ReadOnly);

			// ENTIDAD_IPS
			$this->ENTIDAD_IPS->SetDbValueDef($rsnew, $this->ENTIDAD_IPS->CurrentValue, "", $this->ENTIDAD_IPS->ReadOnly);

			// Correo
			$this->Correo->SetDbValueDef($rsnew, $this->Correo->CurrentValue, "", $this->Correo->ReadOnly);

			// Ingreso
			$this->Ingreso->SetDbValueDef($rsnew, $this->Ingreso->CurrentValue, "", $this->Ingreso->ReadOnly);

			// Clave
			$this->Clave->SetDbValueDef($rsnew, $this->Clave->CurrentValue, "", $this->Clave->ReadOnly || (EW_ENCRYPTED_PASSWORD && $rs->fields('Clave') == $this->Clave->CurrentValue));

			// Nivel
			if ($Security->CanAdmin()) { // System admin
			$this->Nivel->SetDbValueDef($rsnew, $this->Nivel->CurrentValue, 0, $this->Nivel->ReadOnly);
			}

			// Activo
			$this->Activo->SetDbValueDef($rsnew, $this->Activo->CurrentValue, 0, $this->Activo->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Show link optionally based on User ID
	function ShowOptionLink($id = "") {
		global $Security;
		if ($Security->IsLoggedIn() && !$Security->IsAdmin() && !$this->UserIDAllow($id))
			return $Security->IsValidUserID($this->ENTIDAD_IPS->CurrentValue);
		return TRUE;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("ficha_usuariolist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($ficha_usuario_edit)) $ficha_usuario_edit = new cficha_usuario_edit();

// Page init
$ficha_usuario_edit->Page_Init();

// Page main
$ficha_usuario_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ficha_usuario_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fficha_usuarioedit = new ew_Form("fficha_usuarioedit", "edit");

// Validate form
fficha_usuarioedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_Nombres");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Nombres->FldCaption(), $ficha_usuario->Nombres->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Apellidos");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Apellidos->FldCaption(), $ficha_usuario->Apellidos->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Cedula_Identificacion");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Cedula_Identificacion->FldCaption(), $ficha_usuario->Cedula_Identificacion->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_ENTIDAD_IPS");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->ENTIDAD_IPS->FldCaption(), $ficha_usuario->ENTIDAD_IPS->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Correo");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Correo->FldCaption(), $ficha_usuario->Correo->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Ingreso");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Ingreso->FldCaption(), $ficha_usuario->Ingreso->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Clave");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Clave->FldCaption(), $ficha_usuario->Clave->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Clave");
			if (elm && $(elm).hasClass("ewPasswordStrength") && !$(elm).data("validated"))
				return this.OnError(elm, ewLanguage.Phrase("PasswordTooSimple"));
			elm = this.GetElements("x" + infix + "_Nivel");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Nivel->FldCaption(), $ficha_usuario->Nivel->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Activo");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $ficha_usuario->Activo->FldCaption(), $ficha_usuario->Activo->ReqErrMsg)) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fficha_usuarioedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fficha_usuarioedit.ValidateRequired = true;
<?php } else { ?>
fficha_usuarioedit.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fficha_usuarioedit.Lists["x_Entidad_EPS"] = {"LinkField":"x_Codigo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo","x_Administradora_Salud","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fficha_usuarioedit.Lists["x_ENTIDAD_IPS"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Upgd","x_Upgd","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fficha_usuarioedit.Lists["x_Nivel"] = {"LinkField":"x_userlevelid","Ajax":true,"AutoFill":false,"DisplayFields":["x_userlevelname","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fficha_usuarioedit.Lists["x_Activo"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php $ficha_usuario_edit->ShowPageHeader(); ?>
<?php
$ficha_usuario_edit->ShowMessage();
?>
<form name="ewPagerForm" class="form-horizontal ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($ficha_usuario_edit->Pager)) $ficha_usuario_edit->Pager = new cPrevNextPager($ficha_usuario_edit->StartRec, $ficha_usuario_edit->DisplayRecs, $ficha_usuario_edit->TotalRecs) ?>
<?php if ($ficha_usuario_edit->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($ficha_usuario_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $ficha_usuario_edit->PageUrl() ?>start=<?php echo $ficha_usuario_edit->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($ficha_usuario_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $ficha_usuario_edit->PageUrl() ?>start=<?php echo $ficha_usuario_edit->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $ficha_usuario_edit->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($ficha_usuario_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $ficha_usuario_edit->PageUrl() ?>start=<?php echo $ficha_usuario_edit->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($ficha_usuario_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $ficha_usuario_edit->PageUrl() ?>start=<?php echo $ficha_usuario_edit->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ficha_usuario_edit->Pager->PageCount ?></span>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<form name="fficha_usuarioedit" id="fficha_usuarioedit" class="<?php echo $ficha_usuario_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($ficha_usuario_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $ficha_usuario_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ficha_usuario">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<!-- Fields to prevent google autofill -->
<input class="hidden" type="text" name="<?php echo ew_Encrypt(ew_Random()) ?>">
<input class="hidden" type="password" name="<?php echo ew_Encrypt(ew_Random()) ?>">
<div>
<?php if ($ficha_usuario->Id_Usuario->Visible) { // Id_Usuario ?>
	<div id="r_Id_Usuario" class="form-group">
		<label id="elh_ficha_usuario_Id_Usuario" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Id_Usuario->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Id_Usuario->CellAttributes() ?>>
<span id="el_ficha_usuario_Id_Usuario">
<span<?php echo $ficha_usuario->Id_Usuario->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $ficha_usuario->Id_Usuario->EditValue ?></p></span>
</span>
<input type="hidden" data-table="ficha_usuario" data-field="x_Id_Usuario" name="x_Id_Usuario" id="x_Id_Usuario" value="<?php echo ew_HtmlEncode($ficha_usuario->Id_Usuario->CurrentValue) ?>">
<?php echo $ficha_usuario->Id_Usuario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Nombres->Visible) { // Nombres ?>
	<div id="r_Nombres" class="form-group">
		<label id="elh_ficha_usuario_Nombres" for="x_Nombres" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Nombres->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Nombres->CellAttributes() ?>>
<span id="el_ficha_usuario_Nombres">
<input type="text" data-table="ficha_usuario" data-field="x_Nombres" name="x_Nombres" id="x_Nombres" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Nombres->getPlaceHolder()) ?>" value="<?php echo $ficha_usuario->Nombres->EditValue ?>"<?php echo $ficha_usuario->Nombres->EditAttributes() ?>>
</span>
<?php echo $ficha_usuario->Nombres->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Apellidos->Visible) { // Apellidos ?>
	<div id="r_Apellidos" class="form-group">
		<label id="elh_ficha_usuario_Apellidos" for="x_Apellidos" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Apellidos->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Apellidos->CellAttributes() ?>>
<span id="el_ficha_usuario_Apellidos">
<input type="text" data-table="ficha_usuario" data-field="x_Apellidos" name="x_Apellidos" id="x_Apellidos" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Apellidos->getPlaceHolder()) ?>" value="<?php echo $ficha_usuario->Apellidos->EditValue ?>"<?php echo $ficha_usuario->Apellidos->EditAttributes() ?>>
</span>
<?php echo $ficha_usuario->Apellidos->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Cedula_Identificacion->Visible) { // Cedula_Identificacion ?>
	<div id="r_Cedula_Identificacion" class="form-group">
		<label id="elh_ficha_usuario_Cedula_Identificacion" for="x_Cedula_Identificacion" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Cedula_Identificacion->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Cedula_Identificacion->CellAttributes() ?>>
<span id="el_ficha_usuario_Cedula_Identificacion">
<input type="text" data-table="ficha_usuario" data-field="x_Cedula_Identificacion" name="x_Cedula_Identificacion" id="x_Cedula_Identificacion" size="30" maxlength="30" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Cedula_Identificacion->getPlaceHolder()) ?>" value="<?php echo $ficha_usuario->Cedula_Identificacion->EditValue ?>"<?php echo $ficha_usuario->Cedula_Identificacion->EditAttributes() ?>>
</span>
<?php echo $ficha_usuario->Cedula_Identificacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Entidad_EPS->Visible) { // Entidad_EPS ?>
	<div id="r_Entidad_EPS" class="form-group">
		<label id="elh_ficha_usuario_Entidad_EPS" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Entidad_EPS->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Entidad_EPS->CellAttributes() ?>>
<span id="el_ficha_usuario_Entidad_EPS">
<?php
$wrkonchange = trim(" " . @$ficha_usuario->Entidad_EPS->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$ficha_usuario->Entidad_EPS->EditAttrs["onchange"] = "";
?>
<span id="as_x_Entidad_EPS" style="white-space: nowrap; z-index: 8950">
	<input type="text" name="sv_x_Entidad_EPS" id="sv_x_Entidad_EPS" value="<?php echo $ficha_usuario->Entidad_EPS->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Entidad_EPS->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Entidad_EPS->getPlaceHolder()) ?>"<?php echo $ficha_usuario->Entidad_EPS->EditAttributes() ?>>
</span>
<input type="hidden" data-table="ficha_usuario" data-field="x_Entidad_EPS" data-value-separator="<?php echo ew_HtmlEncode(is_array($ficha_usuario->Entidad_EPS->DisplayValueSeparator) ? json_encode($ficha_usuario->Entidad_EPS->DisplayValueSeparator) : $ficha_usuario->Entidad_EPS->DisplayValueSeparator) ?>" name="x_Entidad_EPS" id="x_Entidad_EPS" value="<?php echo ew_HtmlEncode($ficha_usuario->Entidad_EPS->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<?php
$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld` FROM `administradora_salud`";
$sWhereWrk = "`Codigo` LIKE '%{query_value}%' OR `Administradora_Salud` LIKE '%{query_value}%' OR CONCAT(`Codigo`,'" . ew_ValueSeparator(1, $Page->Entidad_EPS) . "',`Administradora_Salud`) LIKE '{query_value}%'";
$ficha_usuario->Lookup_Selecting($ficha_usuario->Entidad_EPS, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " LIMIT " . EW_AUTO_SUGGEST_MAX_ENTRIES;
?>
<input type="hidden" name="q_x_Entidad_EPS" id="q_x_Entidad_EPS" value="s=<?php echo ew_Encrypt($sSqlWrk) ?>&d=">
<script type="text/javascript">
fficha_usuarioedit.CreateAutoSuggest({"id":"x_Entidad_EPS","forceSelect":true});
</script>
</span>
<?php echo $ficha_usuario->Entidad_EPS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->ENTIDAD_IPS->Visible) { // ENTIDAD_IPS ?>
	<div id="r_ENTIDAD_IPS" class="form-group">
		<label id="elh_ficha_usuario_ENTIDAD_IPS" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->ENTIDAD_IPS->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->ENTIDAD_IPS->CellAttributes() ?>>
<?php if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$ficha_usuario->UserIDAllow("edit")) { // Non system admin ?>
<span id="el_ficha_usuario_ENTIDAD_IPS">
<span<?php echo $ficha_usuario->ENTIDAD_IPS->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $ficha_usuario->ENTIDAD_IPS->EditValue ?></p></span>
</span>
<input type="hidden" data-table="ficha_usuario" data-field="x_ENTIDAD_IPS" name="x_ENTIDAD_IPS" id="x_ENTIDAD_IPS" value="<?php echo ew_HtmlEncode($ficha_usuario->ENTIDAD_IPS->CurrentValue) ?>">
<?php } else { ?>
<span id="el_ficha_usuario_ENTIDAD_IPS">
<?php
$wrkonchange = trim(" " . @$ficha_usuario->ENTIDAD_IPS->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$ficha_usuario->ENTIDAD_IPS->EditAttrs["onchange"] = "";
?>
<span id="as_x_ENTIDAD_IPS" style="white-space: nowrap; z-index: 8940">
	<input type="text" name="sv_x_ENTIDAD_IPS" id="sv_x_ENTIDAD_IPS" value="<?php echo $ficha_usuario->ENTIDAD_IPS->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->ENTIDAD_IPS->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($ficha_usuario->ENTIDAD_IPS->getPlaceHolder()) ?>"<?php echo $ficha_usuario->ENTIDAD_IPS->EditAttributes() ?>>
</span>
<input type="hidden" data-table="ficha_usuario" data-field="x_ENTIDAD_IPS" data-value-separator="<?php echo ew_HtmlEncode(is_array($ficha_usuario->ENTIDAD_IPS->DisplayValueSeparator) ? json_encode($ficha_usuario->ENTIDAD_IPS->DisplayValueSeparator) : $ficha_usuario->ENTIDAD_IPS->DisplayValueSeparator) ?>" name="x_ENTIDAD_IPS" id="x_ENTIDAD_IPS" value="<?php echo ew_HtmlEncode($ficha_usuario->ENTIDAD_IPS->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<?php
$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld` FROM `entidad_upgd`";
$sWhereWrk = "`Codigo_Upgd` LIKE '%{query_value}%' OR `Upgd` LIKE '%{query_value}%' OR CONCAT(`Codigo_Upgd`,'" . ew_ValueSeparator(1, $Page->ENTIDAD_IPS) . "',`Upgd`) LIKE '{query_value}%'";
$ficha_usuario->Lookup_Selecting($ficha_usuario->ENTIDAD_IPS, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " LIMIT " . EW_AUTO_SUGGEST_MAX_ENTRIES;
?>
<input type="hidden" name="q_x_ENTIDAD_IPS" id="q_x_ENTIDAD_IPS" value="s=<?php echo ew_Encrypt($sSqlWrk) ?>&d=">
<script type="text/javascript">
fficha_usuarioedit.CreateAutoSuggest({"id":"x_ENTIDAD_IPS","forceSelect":true});
</script>
</span>
<?php } ?>
<?php echo $ficha_usuario->ENTIDAD_IPS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Correo->Visible) { // Correo ?>
	<div id="r_Correo" class="form-group">
		<label id="elh_ficha_usuario_Correo" for="x_Correo" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Correo->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Correo->CellAttributes() ?>>
<span id="el_ficha_usuario_Correo">
<input type="text" data-table="ficha_usuario" data-field="x_Correo" name="x_Correo" id="x_Correo" size="30" maxlength="120" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Correo->getPlaceHolder()) ?>" value="<?php echo $ficha_usuario->Correo->EditValue ?>"<?php echo $ficha_usuario->Correo->EditAttributes() ?>>
</span>
<?php echo $ficha_usuario->Correo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Ingreso->Visible) { // Ingreso ?>
	<div id="r_Ingreso" class="form-group">
		<label id="elh_ficha_usuario_Ingreso" for="x_Ingreso" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Ingreso->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Ingreso->CellAttributes() ?>>
<span id="el_ficha_usuario_Ingreso">
<input type="text" data-table="ficha_usuario" data-field="x_Ingreso" name="x_Ingreso" id="x_Ingreso" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Ingreso->getPlaceHolder()) ?>" value="<?php echo $ficha_usuario->Ingreso->EditValue ?>"<?php echo $ficha_usuario->Ingreso->EditAttributes() ?>>
</span>
<?php echo $ficha_usuario->Ingreso->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Clave->Visible) { // Clave ?>
	<div id="r_Clave" class="form-group">
		<label id="elh_ficha_usuario_Clave" for="x_Clave" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Clave->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Clave->CellAttributes() ?>>
<span id="el_ficha_usuario_Clave">
<div class="input-group" id="ig_Clave">
<input type="text" data-password-strength="pst_Clave" data-password-generated="pgt_Clave" data-table="ficha_usuario" data-field="x_Clave" name="x_Clave" id="x_Clave" value="<?php echo $ficha_usuario->Clave->EditValue ?>" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($ficha_usuario->Clave->getPlaceHolder()) ?>"<?php echo $ficha_usuario->Clave->EditAttributes() ?>>
<span class="input-group-btn">
	<button type="button" class="btn btn-default ewPasswordGenerator" title="<?php echo ew_HtmlTitle($Language->Phrase("GeneratePassword")) ?>" data-password-field="x_Clave" data-password-confirm="c_Clave" data-password-strength="pst_Clave" data-password-generated="pgt_Clave"><?php echo $Language->Phrase("GeneratePassword") ?></button>
</span>
</div>
<span class="help-block" id="pgt_Clave" style="display: none;"></span>
<div class="progress ewPasswordStrengthBar" id="pst_Clave" style="display: none;">
	<div class="progress-bar" role="progressbar"></div>
</div>
</span>
<?php echo $ficha_usuario->Clave->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Nivel->Visible) { // Nivel ?>
	<div id="r_Nivel" class="form-group">
		<label id="elh_ficha_usuario_Nivel" for="x_Nivel" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Nivel->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Nivel->CellAttributes() ?>>
<?php if (!$Security->IsAdmin() && $Security->IsLoggedIn()) { // Non system admin ?>
<span id="el_ficha_usuario_Nivel">
<p class="form-control-static"><?php echo $ficha_usuario->Nivel->EditValue ?></p>
</span>
<?php } else { ?>
<span id="el_ficha_usuario_Nivel">
<select data-table="ficha_usuario" data-field="x_Nivel" data-value-separator="<?php echo ew_HtmlEncode(is_array($ficha_usuario->Nivel->DisplayValueSeparator) ? json_encode($ficha_usuario->Nivel->DisplayValueSeparator) : $ficha_usuario->Nivel->DisplayValueSeparator) ?>" id="x_Nivel" name="x_Nivel"<?php echo $ficha_usuario->Nivel->EditAttributes() ?>>
<?php
if (is_array($ficha_usuario->Nivel->EditValue)) {
	$arwrk = $ficha_usuario->Nivel->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = ew_SameStr($ficha_usuario->Nivel->CurrentValue, $arwrk[$rowcntwrk][0]) ? " selected" : "";
		if ($selwrk <> "") $emptywrk = FALSE;		
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $ficha_usuario->Nivel->DisplayValue($arwrk[$rowcntwrk]) ?>
</option>
<?php
	}
	if ($emptywrk && strval($ficha_usuario->Nivel->CurrentValue) <> "") {
?>
<option value="<?php echo ew_HtmlEncode($ficha_usuario->Nivel->CurrentValue) ?>" selected><?php echo $ficha_usuario->Nivel->CurrentValue ?></option>
<?php
    }
}
?>
</select>
<?php
$sSqlWrk = "SELECT `userlevelid`, `userlevelname` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `userlevels`";
$sWhereWrk = "";
$ficha_usuario->Nivel->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$ficha_usuario->Nivel->LookupFilters += array("f0" => "`userlevelid` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$ficha_usuario->Lookup_Selecting($ficha_usuario->Nivel, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $ficha_usuario->Nivel->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Nivel" id="s_x_Nivel" value="<?php echo $ficha_usuario->Nivel->LookupFilterQuery() ?>">
</span>
<?php } ?>
<?php echo $ficha_usuario->Nivel->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ficha_usuario->Activo->Visible) { // Activo ?>
	<div id="r_Activo" class="form-group">
		<label id="elh_ficha_usuario_Activo" class="col-sm-2 control-label ewLabel"><?php echo $ficha_usuario->Activo->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $ficha_usuario->Activo->CellAttributes() ?>>
<span id="el_ficha_usuario_Activo">
<div id="tp_x_Activo" class="ewTemplate"><input type="radio" data-table="ficha_usuario" data-field="x_Activo" data-value-separator="<?php echo ew_HtmlEncode(is_array($ficha_usuario->Activo->DisplayValueSeparator) ? json_encode($ficha_usuario->Activo->DisplayValueSeparator) : $ficha_usuario->Activo->DisplayValueSeparator) ?>" name="x_Activo" id="x_Activo" value="{value}"<?php echo $ficha_usuario->Activo->EditAttributes() ?>></div>
<div id="dsl_x_Activo" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $ficha_usuario->Activo->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($ficha_usuario->Activo->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="ficha_usuario" data-field="x_Activo" name="x_Activo" id="x_Activo_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $ficha_usuario->Activo->EditAttributes() ?>><?php echo $ficha_usuario->Activo->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($ficha_usuario->Activo->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="ficha_usuario" data-field="x_Activo" name="x_Activo" id="x_Activo_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($ficha_usuario->Activo->CurrentValue) ?>" checked<?php echo $ficha_usuario->Activo->EditAttributes() ?>><?php echo $ficha_usuario->Activo->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
$sWhereWrk = "";
$ficha_usuario->Activo->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$ficha_usuario->Activo->LookupFilters += array("f0" => "`Consecutivo` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$ficha_usuario->Lookup_Selecting($ficha_usuario->Activo, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $ficha_usuario->Activo->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Activo" id="s_x_Activo" value="<?php echo $ficha_usuario->Activo->LookupFilterQuery() ?>">
</span>
<?php echo $ficha_usuario->Activo->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div>
<div class="form-group">
	<div class="col-sm-offset-2 col-sm-10">
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $ficha_usuario_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div>
</div>
</form>
<script type="text/javascript">
fficha_usuarioedit.Init();
</script>
<?php
$ficha_usuario_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ficha_usuario_edit->Page_Terminate();
?>
