<?php

// Global variable for table object
$ficha_usuario = NULL;

//
// Table class for ficha_usuario
//
class cficha_usuario extends cTable {
	var $Id_Usuario;
	var $Nombres;
	var $Apellidos;
	var $Cedula_Identificacion;
	var $Entidad_EPS;
	var $ENTIDAD_IPS;
	var $Correo;
	var $Ingreso;
	var $Clave;
	var $Nivel;
	var $Activo;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'ficha_usuario';
		$this->TableName = 'ficha_usuario';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`ficha_usuario`";
		$this->DBID = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = PHPExcel_Worksheet_PageSetup::ORIENTATION_DEFAULT; // Page orientation (PHPExcel only)
		$this->ExportExcelPageSize = PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4; // Page size (PHPExcel only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = ew_AllowAddDeleteRow(); // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// Id_Usuario
		$this->Id_Usuario = new cField('ficha_usuario', 'ficha_usuario', 'x_Id_Usuario', 'Id_Usuario', '`Id_Usuario`', '`Id_Usuario`', 19, -1, FALSE, '`Id_Usuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->Id_Usuario->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Id_Usuario'] = &$this->Id_Usuario;

		// Nombres
		$this->Nombres = new cField('ficha_usuario', 'ficha_usuario', 'x_Nombres', 'Nombres', '`Nombres`', '`Nombres`', 200, -1, FALSE, '`Nombres`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Nombres'] = &$this->Nombres;

		// Apellidos
		$this->Apellidos = new cField('ficha_usuario', 'ficha_usuario', 'x_Apellidos', 'Apellidos', '`Apellidos`', '`Apellidos`', 200, -1, FALSE, '`Apellidos`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Apellidos'] = &$this->Apellidos;

		// Cedula_Identificacion
		$this->Cedula_Identificacion = new cField('ficha_usuario', 'ficha_usuario', 'x_Cedula_Identificacion', 'Cedula_Identificacion', '`Cedula_Identificacion`', '`Cedula_Identificacion`', 200, -1, FALSE, '`Cedula_Identificacion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Cedula_Identificacion'] = &$this->Cedula_Identificacion;

		// Entidad_EPS
		$this->Entidad_EPS = new cField('ficha_usuario', 'ficha_usuario', 'x_Entidad_EPS', 'Entidad_EPS', '`Entidad_EPS`', '`Entidad_EPS`', 200, -1, FALSE, '`Entidad_EPS`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Entidad_EPS'] = &$this->Entidad_EPS;

		// ENTIDAD_IPS
		$this->ENTIDAD_IPS = new cField('ficha_usuario', 'ficha_usuario', 'x_ENTIDAD_IPS', 'ENTIDAD_IPS', '`ENTIDAD_IPS`', '`ENTIDAD_IPS`', 200, -1, FALSE, '`ENTIDAD_IPS`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['ENTIDAD_IPS'] = &$this->ENTIDAD_IPS;

		// Correo
		$this->Correo = new cField('ficha_usuario', 'ficha_usuario', 'x_Correo', 'Correo', '`Correo`', '`Correo`', 200, -1, FALSE, '`Correo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Correo'] = &$this->Correo;

		// Ingreso
		$this->Ingreso = new cField('ficha_usuario', 'ficha_usuario', 'x_Ingreso', 'Ingreso', '`Ingreso`', '`Ingreso`', 200, -1, FALSE, '`Ingreso`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Ingreso'] = &$this->Ingreso;

		// Clave
		$this->Clave = new cField('ficha_usuario', 'ficha_usuario', 'x_Clave', 'Clave', '`Clave`', '`Clave`', 200, -1, FALSE, '`Clave`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Clave'] = &$this->Clave;

		// Nivel
		$this->Nivel = new cField('ficha_usuario', 'ficha_usuario', 'x_Nivel', 'Nivel', '`Nivel`', '`Nivel`', 19, -1, FALSE, '`Nivel`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Nivel->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Nivel'] = &$this->Nivel;

		// Activo
		$this->Activo = new cField('ficha_usuario', 'ficha_usuario', 'x_Activo', 'Activo', '`Activo`', '`Activo`', 3, -1, FALSE, '`Activo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->Activo->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Activo'] = &$this->Activo;
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	var $_SqlFrom = "";

	function getSqlFrom() { // From
		return ($this->_SqlFrom <> "") ? $this->_SqlFrom : "`ficha_usuario`";
	}

	function SqlFrom() { // For backward compatibility
    	return $this->getSqlFrom();
	}

	function setSqlFrom($v) {
    	$this->_SqlFrom = $v;
	}
	var $_SqlSelect = "";

	function getSqlSelect() { // Select
		return ($this->_SqlSelect <> "") ? $this->_SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}

	function SqlSelect() { // For backward compatibility
    	return $this->getSqlSelect();
	}

	function setSqlSelect($v) {
    	$this->_SqlSelect = $v;
	}
	var $_SqlWhere = "";

	function getSqlWhere() { // Where
		$sWhere = ($this->_SqlWhere <> "") ? $this->_SqlWhere : "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlWhere() { // For backward compatibility
    	return $this->getSqlWhere();
	}

	function setSqlWhere($v) {
    	$this->_SqlWhere = $v;
	}
	var $_SqlGroupBy = "";

	function getSqlGroupBy() { // Group By
		return ($this->_SqlGroupBy <> "") ? $this->_SqlGroupBy : "";
	}

	function SqlGroupBy() { // For backward compatibility
    	return $this->getSqlGroupBy();
	}

	function setSqlGroupBy($v) {
    	$this->_SqlGroupBy = $v;
	}
	var $_SqlHaving = "";

	function getSqlHaving() { // Having
		return ($this->_SqlHaving <> "") ? $this->_SqlHaving : "";
	}

	function SqlHaving() { // For backward compatibility
    	return $this->getSqlHaving();
	}

	function setSqlHaving($v) {
    	$this->_SqlHaving = $v;
	}
	var $_SqlOrderBy = "";

	function getSqlOrderBy() { // Order By
		return ($this->_SqlOrderBy <> "") ? $this->_SqlOrderBy : "";
	}

	function SqlOrderBy() { // For backward compatibility
    	return $this->getSqlOrderBy();
	}

	function setSqlOrderBy($v) {
    	$this->_SqlOrderBy = $v;
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		global $Security;

		// Add User ID filter
		if ($Security->CurrentUserID() <> "" && !$Security->IsAdmin()) { // Non system admin
			$sFilter = $this->AddUserIDFilter($sFilter);
		}
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$sFilter = $this->CurrentFilter;
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$sFilter, $sSort);
	}

	// Table SQL with List page filter
	function SelectSQL() {
		$sFilter = $this->getSessionWhere();
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$this->Recordset_Selecting($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sSql) {
		$cnt = -1;
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') && preg_match("/^SELECT \* FROM/i", $sSql)) {
			$sSql = "SELECT COUNT(*) FROM" . preg_replace('/^SELECT\s([\s\S]+)?\*\sFROM/i', "", $sSql);
			$sOrderBy = $this->GetOrderBy();
			if (substr($sSql, strlen($sOrderBy) * -1) == $sOrderBy)
				$sSql = substr($sSql, 0, strlen($sSql) - strlen($sOrderBy)); // Remove ORDER BY clause
		} else {
			$sSql = "SELECT COUNT(*) FROM (" . $sSql . ") EW_COUNT_TABLE";
		}
		$conn = &$this->Connection();
		if ($rs = $conn->Execute($sSql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($sFilter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $sFilter;
		$this->Recordset_Selecting($this->CurrentFilter);

		//$sSql = $this->SQL();
		$sSql = $this->GetSQL($this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function SelectRecordCount() {
		$sSql = $this->SelectSQL();
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			$conn = &$this->Connection();
			if ($rs = $conn->Execute($sSql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// INSERT statement
	function InsertSQL(&$rs) {
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			if (EW_ENCRYPTED_PASSWORD && $name == 'Clave')
				$value = (EW_CASE_SENSITIVE_PASSWORD) ? ew_EncryptPassword($value) : ew_EncryptPassword(strtolower($value));
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		while (substr($names, -1) == ",")
			$names = substr($names, 0, -1);
		while (substr($values, -1) == ",")
			$values = substr($values, 0, -1);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		$conn = &$this->Connection();
		return $conn->Execute($this->InsertSQL($rs));
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			if (EW_ENCRYPTED_PASSWORD && $name == 'Clave') {
				$value = (EW_CASE_SENSITIVE_PASSWORD) ? ew_EncryptPassword($value) : ew_EncryptPassword(strtolower($value));
			}
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		while (substr($sql, -1) == ",")
			$sql = substr($sql, 0, -1);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE) {
		$conn = &$this->Connection();
		return $conn->Execute($this->UpdateSQL($rs, $where, $curfilter));
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Id_Usuario', $rs))
				ew_AddFilter($where, ew_QuotedName('Id_Usuario', $this->DBID) . '=' . ew_QuotedValue($rs['Id_Usuario'], $this->Id_Usuario->FldDataType, $this->DBID));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "", $curfilter = TRUE) {
		$conn = &$this->Connection();
		return $conn->Execute($this->DeleteSQL($rs, $where, $curfilter));
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`Id_Usuario` = @Id_Usuario@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->Id_Usuario->CurrentValue))
			$sKeyFilter = "0=1"; // Invalid key
		$sKeyFilter = str_replace("@Id_Usuario@", ew_AdjustSql($this->Id_Usuario->CurrentValue, $this->DBID), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "ficha_usuariolist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// List URL
	function GetListUrl() {
		return "ficha_usuariolist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			$url = $this->KeyUrl("ficha_usuarioview.php", $this->UrlParm($parm));
		else
			$url = $this->KeyUrl("ficha_usuarioview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
		return $this->AddMasterUrl($url);
	}

	// Add URL
	function GetAddUrl($parm = "") {
		if ($parm <> "")
			$url = "ficha_usuarioadd.php?" . $this->UrlParm($parm);
		else
			$url = "ficha_usuarioadd.php";
		return $this->AddMasterUrl($url);
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		$url = $this->KeyUrl("ficha_usuarioedit.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
		return $this->AddMasterUrl($url);
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		$url = $this->KeyUrl("ficha_usuarioadd.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
		return $this->AddMasterUrl($url);
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("ficha_usuariodelete.php", $this->UrlParm());
	}

	// Add master url
	function AddMasterUrl($url) {
		return $url;
	}

	function KeyToJson() {
		$json = "";
		$json .= "Id_Usuario:" . ew_VarToJson($this->Id_Usuario->CurrentValue, "number", "'");
		return "{" . $json . "}";
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->Id_Usuario->CurrentValue)) {
			$sUrl .= "Id_Usuario=" . urlencode($this->Id_Usuario->CurrentValue);
		} else {
			return "javascript:ew_Alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return ew_CurrentPage() . "?" . $sUrlParm;
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = ew_StripSlashes($_POST["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = ew_StripSlashes($_GET["key_m"]);
			$cnt = count($arKeys);
		} elseif (!empty($_GET) || !empty($_POST)) {
			$isPost = ew_IsHttpPost();
			if ($isPost && isset($_POST["Id_Usuario"]))
				$arKeys[] = ew_StripSlashes($_POST["Id_Usuario"]);
			elseif (isset($_GET["Id_Usuario"]))
				$arKeys[] = ew_StripSlashes($_GET["Id_Usuario"]);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->Id_Usuario->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($sFilter) {

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $sFilter;
		//$sSql = $this->SQL();

		$sSql = $this->GetSQL($sFilter, "");
		$conn = &$this->Connection();
		$rs = $conn->Execute($sSql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->Id_Usuario->setDbValue($rs->fields('Id_Usuario'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Cedula_Identificacion->setDbValue($rs->fields('Cedula_Identificacion'));
		$this->Entidad_EPS->setDbValue($rs->fields('Entidad_EPS'));
		$this->ENTIDAD_IPS->setDbValue($rs->fields('ENTIDAD_IPS'));
		$this->Correo->setDbValue($rs->fields('Correo'));
		$this->Ingreso->setDbValue($rs->fields('Ingreso'));
		$this->Clave->setDbValue($rs->fields('Clave'));
		$this->Nivel->setDbValue($rs->fields('Nivel'));
		$this->Activo->setDbValue($rs->fields('Activo'));
	}

	// Render list row values
	function RenderListRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

   // Common render codes
		// Id_Usuario
		// Nombres
		// Apellidos
		// Cedula_Identificacion
		// Entidad_EPS
		// ENTIDAD_IPS
		// Correo
		// Ingreso
		// Clave
		// Nivel
		// Activo
		// Id_Usuario

		$this->Id_Usuario->ViewValue = $this->Id_Usuario->CurrentValue;
		$this->Id_Usuario->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Cedula_Identificacion
		$this->Cedula_Identificacion->ViewValue = $this->Cedula_Identificacion->CurrentValue;
		$this->Cedula_Identificacion->ViewCustomAttributes = "";

		// Entidad_EPS
		$this->Entidad_EPS->ViewValue = $this->Entidad_EPS->CurrentValue;
		if (strval($this->Entidad_EPS->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->Entidad_EPS->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad_EPS, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Entidad_EPS->ViewValue = $this->Entidad_EPS->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad_EPS->ViewValue = $this->Entidad_EPS->CurrentValue;
			}
		} else {
			$this->Entidad_EPS->ViewValue = NULL;
		}
		$this->Entidad_EPS->ViewCustomAttributes = "";

		// ENTIDAD_IPS
		$this->ENTIDAD_IPS->ViewValue = $this->ENTIDAD_IPS->CurrentValue;
		if (strval($this->ENTIDAD_IPS->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->ENTIDAD_IPS->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ENTIDAD_IPS, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->ENTIDAD_IPS->ViewValue = $this->ENTIDAD_IPS->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ENTIDAD_IPS->ViewValue = $this->ENTIDAD_IPS->CurrentValue;
			}
		} else {
			$this->ENTIDAD_IPS->ViewValue = NULL;
		}
		$this->ENTIDAD_IPS->ViewCustomAttributes = "";

		// Correo
		$this->Correo->ViewValue = $this->Correo->CurrentValue;
		$this->Correo->ViewCustomAttributes = "";

		// Ingreso
		$this->Ingreso->ViewValue = $this->Ingreso->CurrentValue;
		$this->Ingreso->ViewCustomAttributes = "";

		// Clave
		$this->Clave->ViewValue = $this->Clave->CurrentValue;
		$this->Clave->ViewCustomAttributes = "";

		// Nivel
		if ($Security->CanAdmin()) { // System admin
		if (strval($this->Nivel->CurrentValue) <> "") {
			$sFilterWrk = "`userlevelid`" . ew_SearchString("=", $this->Nivel->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `userlevelid`, `userlevelname` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `userlevels`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Nivel, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Nivel->ViewValue = $this->Nivel->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Nivel->ViewValue = $this->Nivel->CurrentValue;
			}
		} else {
			$this->Nivel->ViewValue = NULL;
		}
		} else {
			$this->Nivel->ViewValue = $Language->Phrase("PasswordMask");
		}
		$this->Nivel->ViewCustomAttributes = "";

		// Activo
		if (strval($this->Activo->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Activo->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Activo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Activo->ViewValue = $this->Activo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Activo->ViewValue = $this->Activo->CurrentValue;
			}
		} else {
			$this->Activo->ViewValue = NULL;
		}
		$this->Activo->ViewCustomAttributes = "";

		// Id_Usuario
		$this->Id_Usuario->LinkCustomAttributes = "";
		$this->Id_Usuario->HrefValue = "";
		$this->Id_Usuario->TooltipValue = "";

		// Nombres
		$this->Nombres->LinkCustomAttributes = "";
		$this->Nombres->HrefValue = "";
		$this->Nombres->TooltipValue = "";

		// Apellidos
		$this->Apellidos->LinkCustomAttributes = "";
		$this->Apellidos->HrefValue = "";
		$this->Apellidos->TooltipValue = "";

		// Cedula_Identificacion
		$this->Cedula_Identificacion->LinkCustomAttributes = "";
		$this->Cedula_Identificacion->HrefValue = "";
		$this->Cedula_Identificacion->TooltipValue = "";

		// Entidad_EPS
		$this->Entidad_EPS->LinkCustomAttributes = "";
		$this->Entidad_EPS->HrefValue = "";
		$this->Entidad_EPS->TooltipValue = "";

		// ENTIDAD_IPS
		$this->ENTIDAD_IPS->LinkCustomAttributes = "";
		$this->ENTIDAD_IPS->HrefValue = "";
		$this->ENTIDAD_IPS->TooltipValue = "";

		// Correo
		$this->Correo->LinkCustomAttributes = "";
		$this->Correo->HrefValue = "";
		$this->Correo->TooltipValue = "";

		// Ingreso
		$this->Ingreso->LinkCustomAttributes = "";
		$this->Ingreso->HrefValue = "";
		$this->Ingreso->TooltipValue = "";

		// Clave
		$this->Clave->LinkCustomAttributes = "";
		$this->Clave->HrefValue = "";
		$this->Clave->TooltipValue = "";

		// Nivel
		$this->Nivel->LinkCustomAttributes = "";
		$this->Nivel->HrefValue = "";
		$this->Nivel->TooltipValue = "";

		// Activo
		$this->Activo->LinkCustomAttributes = "";
		$this->Activo->HrefValue = "";
		$this->Activo->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Render edit row values
	function RenderEditRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Id_Usuario
		$this->Id_Usuario->EditAttrs["class"] = "form-control";
		$this->Id_Usuario->EditCustomAttributes = "";
		$this->Id_Usuario->EditValue = $this->Id_Usuario->CurrentValue;
		$this->Id_Usuario->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->EditAttrs["class"] = "form-control";
		$this->Nombres->EditCustomAttributes = "";
		$this->Nombres->EditValue = $this->Nombres->CurrentValue;
		$this->Nombres->PlaceHolder = ew_RemoveHtml($this->Nombres->FldCaption());

		// Apellidos
		$this->Apellidos->EditAttrs["class"] = "form-control";
		$this->Apellidos->EditCustomAttributes = "";
		$this->Apellidos->EditValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->PlaceHolder = ew_RemoveHtml($this->Apellidos->FldCaption());

		// Cedula_Identificacion
		$this->Cedula_Identificacion->EditAttrs["class"] = "form-control";
		$this->Cedula_Identificacion->EditCustomAttributes = "";
		$this->Cedula_Identificacion->EditValue = $this->Cedula_Identificacion->CurrentValue;
		$this->Cedula_Identificacion->PlaceHolder = ew_RemoveHtml($this->Cedula_Identificacion->FldCaption());

		// Entidad_EPS
		$this->Entidad_EPS->EditAttrs["class"] = "form-control";
		$this->Entidad_EPS->EditCustomAttributes = "";
		$this->Entidad_EPS->EditValue = $this->Entidad_EPS->CurrentValue;
		$this->Entidad_EPS->PlaceHolder = ew_RemoveHtml($this->Entidad_EPS->FldCaption());

		// ENTIDAD_IPS
		$this->ENTIDAD_IPS->EditAttrs["class"] = "form-control";
		$this->ENTIDAD_IPS->EditCustomAttributes = "";
		if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$this->UserIDAllow("info")) { // Non system admin
			$this->ENTIDAD_IPS->CurrentValue = CurrentUserID();
		$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->CurrentValue;
		if (strval($this->ENTIDAD_IPS->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->ENTIDAD_IPS->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ENTIDAD_IPS, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->CurrentValue;
			}
		} else {
			$this->ENTIDAD_IPS->EditValue = NULL;
		}
		$this->ENTIDAD_IPS->ViewCustomAttributes = "";
		} else {
		$this->ENTIDAD_IPS->EditValue = $this->ENTIDAD_IPS->CurrentValue;
		$this->ENTIDAD_IPS->PlaceHolder = ew_RemoveHtml($this->ENTIDAD_IPS->FldCaption());
		}

		// Correo
		$this->Correo->EditAttrs["class"] = "form-control";
		$this->Correo->EditCustomAttributes = "";
		$this->Correo->EditValue = $this->Correo->CurrentValue;
		$this->Correo->PlaceHolder = ew_RemoveHtml($this->Correo->FldCaption());

		// Ingreso
		$this->Ingreso->EditAttrs["class"] = "form-control";
		$this->Ingreso->EditCustomAttributes = "";
		$this->Ingreso->EditValue = $this->Ingreso->CurrentValue;
		$this->Ingreso->PlaceHolder = ew_RemoveHtml($this->Ingreso->FldCaption());

		// Clave
		$this->Clave->EditAttrs["class"] = "form-control ewPasswordStrength";
		$this->Clave->EditCustomAttributes = "";
		$this->Clave->EditValue = $this->Clave->CurrentValue;
		$this->Clave->PlaceHolder = ew_RemoveHtml($this->Clave->FldCaption());

		// Nivel
		$this->Nivel->EditAttrs["class"] = "form-control";
		$this->Nivel->EditCustomAttributes = "";
		if (!$Security->CanAdmin()) { // System admin
			$this->Nivel->EditValue = $Language->Phrase("PasswordMask");
		} else {
		}

		// Activo
		$this->Activo->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {

		// Call Row Rendered event
		$this->Row_Rendered();
	}
	var $ExportDoc;

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;
		if (!$Doc->ExportCustom) {

			// Write header
			$Doc->ExportTableHeader();
			if ($Doc->Horizontal) { // Horizontal format, write header
				$Doc->BeginExportRow();
				if ($ExportPageType == "view") {
					if ($this->Id_Usuario->Exportable) $Doc->ExportCaption($this->Id_Usuario);
					if ($this->Nombres->Exportable) $Doc->ExportCaption($this->Nombres);
					if ($this->Apellidos->Exportable) $Doc->ExportCaption($this->Apellidos);
					if ($this->Cedula_Identificacion->Exportable) $Doc->ExportCaption($this->Cedula_Identificacion);
					if ($this->Entidad_EPS->Exportable) $Doc->ExportCaption($this->Entidad_EPS);
					if ($this->ENTIDAD_IPS->Exportable) $Doc->ExportCaption($this->ENTIDAD_IPS);
					if ($this->Correo->Exportable) $Doc->ExportCaption($this->Correo);
					if ($this->Ingreso->Exportable) $Doc->ExportCaption($this->Ingreso);
					if ($this->Clave->Exportable) $Doc->ExportCaption($this->Clave);
					if ($this->Nivel->Exportable) $Doc->ExportCaption($this->Nivel);
					if ($this->Activo->Exportable) $Doc->ExportCaption($this->Activo);
				} else {
					if ($this->Id_Usuario->Exportable) $Doc->ExportCaption($this->Id_Usuario);
					if ($this->Nombres->Exportable) $Doc->ExportCaption($this->Nombres);
					if ($this->Apellidos->Exportable) $Doc->ExportCaption($this->Apellidos);
					if ($this->Cedula_Identificacion->Exportable) $Doc->ExportCaption($this->Cedula_Identificacion);
					if ($this->Entidad_EPS->Exportable) $Doc->ExportCaption($this->Entidad_EPS);
					if ($this->ENTIDAD_IPS->Exportable) $Doc->ExportCaption($this->ENTIDAD_IPS);
					if ($this->Correo->Exportable) $Doc->ExportCaption($this->Correo);
					if ($this->Ingreso->Exportable) $Doc->ExportCaption($this->Ingreso);
					if ($this->Clave->Exportable) $Doc->ExportCaption($this->Clave);
					if ($this->Nivel->Exportable) $Doc->ExportCaption($this->Nivel);
					if ($this->Activo->Exportable) $Doc->ExportCaption($this->Activo);
				}
				$Doc->EndExportRow();
			}
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				if (!$Doc->ExportCustom) {
					$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
					if ($ExportPageType == "view") {
						if ($this->Id_Usuario->Exportable) $Doc->ExportField($this->Id_Usuario);
						if ($this->Nombres->Exportable) $Doc->ExportField($this->Nombres);
						if ($this->Apellidos->Exportable) $Doc->ExportField($this->Apellidos);
						if ($this->Cedula_Identificacion->Exportable) $Doc->ExportField($this->Cedula_Identificacion);
						if ($this->Entidad_EPS->Exportable) $Doc->ExportField($this->Entidad_EPS);
						if ($this->ENTIDAD_IPS->Exportable) $Doc->ExportField($this->ENTIDAD_IPS);
						if ($this->Correo->Exportable) $Doc->ExportField($this->Correo);
						if ($this->Ingreso->Exportable) $Doc->ExportField($this->Ingreso);
						if ($this->Clave->Exportable) $Doc->ExportField($this->Clave);
						if ($this->Nivel->Exportable) $Doc->ExportField($this->Nivel);
						if ($this->Activo->Exportable) $Doc->ExportField($this->Activo);
					} else {
						if ($this->Id_Usuario->Exportable) $Doc->ExportField($this->Id_Usuario);
						if ($this->Nombres->Exportable) $Doc->ExportField($this->Nombres);
						if ($this->Apellidos->Exportable) $Doc->ExportField($this->Apellidos);
						if ($this->Cedula_Identificacion->Exportable) $Doc->ExportField($this->Cedula_Identificacion);
						if ($this->Entidad_EPS->Exportable) $Doc->ExportField($this->Entidad_EPS);
						if ($this->ENTIDAD_IPS->Exportable) $Doc->ExportField($this->ENTIDAD_IPS);
						if ($this->Correo->Exportable) $Doc->ExportField($this->Correo);
						if ($this->Ingreso->Exportable) $Doc->ExportField($this->Ingreso);
						if ($this->Clave->Exportable) $Doc->ExportField($this->Clave);
						if ($this->Nivel->Exportable) $Doc->ExportField($this->Nivel);
						if ($this->Activo->Exportable) $Doc->ExportField($this->Activo);
					}
					$Doc->EndExportRow();
				}
			}

			// Call Row Export server event
			if ($Doc->ExportCustom)
				$this->Row_Export($Recordset->fields);
			$Recordset->MoveNext();
		}
		if (!$Doc->ExportCustom) {
			$Doc->ExportTableFooter();
		}
	}

	// User ID filter
	function UserIDFilter($userid) {
		$sUserIDFilter = '`ENTIDAD_IPS` = ' . ew_QuotedValue($userid, EW_DATATYPE_STRING, EW_USER_TABLE_DBID);
		return $sUserIDFilter;
	}

	// Add User ID filter
	function AddUserIDFilter($sFilter) {
		global $Security;
		$sFilterWrk = "";
		$id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
		if (!$this->UserIDAllow($id) && !$Security->IsAdmin()) {
			$sFilterWrk = $Security->UserIDList();
			if ($sFilterWrk <> "")
				$sFilterWrk = '`ENTIDAD_IPS` IN (' . $sFilterWrk . ')';
		}

		// Call User ID Filtering event
		$this->UserID_Filtering($sFilterWrk);
		ew_AddFilter($sFilter, $sFilterWrk);
		return $sFilter;
	}

	// User ID subquery
	function GetUserIDSubquery(&$fld, &$masterfld) {
		global $UserTableConn;
		$sWrk = "";
		$sSql = "SELECT " . $masterfld->FldExpression . " FROM `ficha_usuario`";
		$sFilter = $this->AddUserIDFilter("");
		if ($sFilter <> "") $sSql .= " WHERE " . $sFilter;

		// Use subquery
		if (EW_USE_SUBQUERY_FOR_MASTER_USER_ID) {
			$sWrk = $sSql;
		} else {

			// List all values
			if ($rs = $UserTableConn->Execute($sSql)) {
				while (!$rs->EOF) {
					if ($sWrk <> "") $sWrk .= ",";
					$sWrk .= ew_QuotedValue($rs->fields[0], $masterfld->FldDataType, EW_USER_TABLE_DBID);
					$rs->MoveNext();
				}
				$rs->Close();
			}
		}
		if ($sWrk <> "") {
			$sWrk = $fld->FldExpression . " IN (" . $sWrk . ")";
		}
		return $sWrk;
	}

	// Get auto fill value
	function GetAutoFill($id, $val) {
		$rsarr = array();
		$rowcnt = 0;

		// Output
		if (is_array($rsarr) && $rowcnt > 0) {
			$fldcnt = count($rsarr[0]);
			for ($i = 0; $i < $rowcnt; $i++) {
				for ($j = 0; $j < $fldcnt; $j++) {
					$str = strval($rsarr[$i][$j]);
					$str = ew_ConvertToUtf8($str);
					if (isset($post["keepCRLF"])) {
						$str = str_replace(array("\r", "\n"), array("\\r", "\\n"), $str);
					} else {
						$str = str_replace(array("\r", "\n"), array(" ", " "), $str);
					}
					$rsarr[$i][$j] = $str;
				}
			}
			return ew_ArrayToJson($rsarr);
		} else {
			return FALSE;
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here	
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here	
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here	
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->FldName, $fld->LookupFilters, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here	
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>); 

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
