<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "registroinfo.php" ?>
<?php include_once "ficha_usuarioinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$registro_delete = NULL; // Initialize page object first

class cregistro_delete extends cregistro {

	// Page ID
	var $PageID = 'delete';

	// Project ID
	var $ProjectID = "{43FC4B6C-8131-46B1-916C-14DB52B1691D}";

	// Table name
	var $TableName = 'registro';

	// Page object name
	var $PageObjName = 'registro_delete';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (registro)
		if (!isset($GLOBALS["registro"]) || get_class($GLOBALS["registro"]) == "cregistro") {
			$GLOBALS["registro"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["registro"];
		}

		// Table object (ficha_usuario)
		if (!isset($GLOBALS['ficha_usuario'])) $GLOBALS['ficha_usuario'] = new cficha_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'registro', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (ficha_usuario)
		if (!isset($UserTable)) {
			$UserTable = new cficha_usuario();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanDelete()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("registrolist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}
		if ($Security->IsLoggedIn()) {
			$Security->UserID_Loading();
			$Security->LoadUserID();
			$Security->UserID_Loaded();
			if (strval($Security->CurrentUserID()) == "") {
				$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
				$this->Page_Terminate(ew_GetUrl("registrolist.php"));
			}
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $registro;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($registro);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $TotalRecs = 0;
	var $RecCnt;
	var $RecKeys = array();
	var $Recordset;
	var $StartRowCnt = 1;
	var $RowCnt = 0;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->GetRecordKeys(); // Load record keys
		$sFilter = $this->GetKeyFilter();
		if ($sFilter == "")
			$this->Page_Terminate("registrolist.php"); // Prevent SQL injection, return to list

		// Set up filter (SQL WHHERE clause) and get return SQL
		// SQL constructor in registro class, registroinfo.php

		$this->CurrentFilter = $sFilter;

		// Check if valid user id
		$conn = &$this->Connection();
		$sql = $this->GetSQL($this->CurrentFilter, "");
		if ($this->Recordset = ew_LoadRecordset($sql, $conn)) {
			$res = TRUE;
			while (!$this->Recordset->EOF) {
				$this->LoadRowValues($this->Recordset);
				if (!$this->ShowOptionLink('delete')) {
					$sUserIdMsg = $Language->Phrase("NoDeletePermission");
					$this->setFailureMessage($sUserIdMsg);
					$res = FALSE;
					break;
				}
				$this->Recordset->MoveNext();
			}
			$this->Recordset->Close();
			if (!$res) $this->Page_Terminate("registrolist.php"); // Return to list
		}

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$this->CurrentAction = $_POST["a_delete"];
		} else {
			$this->CurrentAction = "D"; // Delete record directly
		}
		if ($this->CurrentAction == "D") {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->DeleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->Phrase("DeleteSuccess")); // Set up success message
				$this->Page_Terminate($this->getReturnUrl()); // Return to caller
			} else { // Delete failed
				$this->Page_Terminate($this->getReturnUrl()); // Return to caller
			}
		}
		if ($this->CurrentAction == "I") { // Load records for display
			if ($this->Recordset = $this->LoadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->Close();
				$this->Page_Terminate("registrolist.php"); // Return to list
			}
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Seguimiento->setDbValue($rs->fields('Seguimiento'));
		$this->Condicion_Final->setDbValue($rs->fields('Condicion_Final'));
		$this->Codigo_centro->setDbValue($rs->fields('Codigo_centro'));
		$this->Codigo_UPGD->setDbValue($rs->fields('Codigo_UPGD'));
		$this->Cod_Evento->setDbValue($rs->fields('Cod_Evento'));
		$this->Embarazo_Actual->setDbValue($rs->fields('Embarazo_Actual'));
		$this->Fecha_Notificacion->setDbValue($rs->fields('Fecha_Notificacion'));
		$this->Semana->setDbValue($rs->fields('Semana'));
		$this->Periodo_Epidemiologico->setDbValue($rs->fields('Periodo_Epidemiologico'));
		$this->Periodo_Sivigila->setDbValue($rs->fields('Periodo_Sivigila'));
		$this->Primer_Nombre->setDbValue($rs->fields('Primer_Nombre'));
		$this->Segundo_Nombre->setDbValue($rs->fields('Segundo_Nombre'));
		$this->Primer_Apellido->setDbValue($rs->fields('Primer_Apellido'));
		$this->Segundo_Apellido->setDbValue($rs->fields('Segundo_Apellido'));
		$this->Tipo_Id->setDbValue($rs->fields('Tipo_Id'));
		$this->Numero_Identificacion->setDbValue($rs->fields('Numero_Identificacion'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Unidad_Edad->setDbValue($rs->fields('Unidad_Edad'));
		$this->Sexo->setDbValue($rs->fields('Sexo'));
		$this->Pais_Ocurrencia->setDbValue($rs->fields('Pais_Ocurrencia'));
		$this->Depto_Ocurrencia->setDbValue($rs->fields('Depto_Ocurrencia'));
		$this->Municipio_Ocurrencia->setDbValue($rs->fields('Municipio_Ocurrencia'));
		$this->Area_Ocurrencia->setDbValue($rs->fields('Area_Ocurrencia'));
		$this->Localidad->setDbValue($rs->fields('Localidad'));
		$this->Barrio->setDbValue($rs->fields('Barrio'));
		$this->Direccion_Residencia->setDbValue($rs->fields('Direccion_Residencia'));
		$this->Ocupacion->setDbValue($rs->fields('Ocupacion'));
		$this->Tipo_Regimen_Salud->setDbValue($rs->fields('Tipo_Regimen_Salud'));
		$this->Cod_Administradora->setDbValue($rs->fields('Cod_Administradora'));
		$this->gp_discapa->setDbValue($rs->fields('gp_discapa'));
		$this->gp_desplaz->setDbValue($rs->fields('gp_desplaz'));
		$this->gp_migrant->setDbValue($rs->fields('gp_migrant'));
		$this->gp_carcela->setDbValue($rs->fields('gp_carcela'));
		$this->gp_gestan->setDbValue($rs->fields('gp_gestan'));
		$this->gp_indigen->setDbValue($rs->fields('gp_indigen'));
		$this->gp_pobicbf->setDbValue($rs->fields('gp_pobicbf'));
		$this->gp_mad_com->setDbValue($rs->fields('gp_mad_com'));
		$this->gp_desmovi->setDbValue($rs->fields('gp_desmovi'));
		$this->gp_psiquia->setDbValue($rs->fields('gp_psiquia'));
		$this->gp_vic_vio->setDbValue($rs->fields('gp_vic_vio'));
		$this->gp_otros->setDbValue($rs->fields('gp_otros'));
		$this->Depto_Residencia->setDbValue($rs->fields('Depto_Residencia'));
		$this->Municipio_Residencia->setDbValue($rs->fields('Municipio_Residencia'));
		$this->Fecha_Consulta->setDbValue($rs->fields('Fecha_Consulta'));
		$this->Fecha_Inicio_Sintomas->setDbValue($rs->fields('Fecha_Inicio_Sintomas'));
		$this->Hospitalizado->setDbValue($rs->fields('Hospitalizado'));
		$this->Fecha_Defuncion->setDbValue($rs->fields('Fecha_Defuncion'));
		$this->Numero_Certificado_Defuncion->setDbValue($rs->fields('Numero_Certificado_Defuncion'));
		$this->Causa_Basica_Muerte_CIEX->setDbValue($rs->fields('Causa_Basica_Muerte_CIEX'));
		$this->Entidad_fallecimiento->setDbValue($rs->fields('Entidad_fallecimiento'));
		$this->Telefono->setDbValue($rs->fields('Telefono'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Nombre_Profesional_Diligencia->setDbValue($rs->fields('Nombre_Profesional_Diligencia'));
		$this->Telefono_Profesional_Diligencia->setDbValue($rs->fields('Telefono_Profesional_Diligencia'));
		$this->Mecanismo_Probable_Transmision->setDbValue($rs->fields('Mecanismo_Probable_Transmision'));
		$this->Nombre_Madre->setDbValue($rs->fields('Nombre_Madre'));
		$this->Tipo_Id_Madre->setDbValue($rs->fields('Tipo_Id_Madre'));
		$this->Numero_Identificacion_Madre->setDbValue($rs->fields('Numero_Identificacion_Madre'));
		$this->Indentidad_Genero->setDbValue($rs->fields('Indentidad_Genero'));
		$this->Donador_Sangre_Ultimos_12_Meses->setDbValue($rs->fields('Donador_Sangre_Ultimos_12_Meses'));
		$this->Fecha_Donacion->setDbValue($rs->fields('Fecha_Donacion'));
		$this->Nombre_Institucion_Donacion->setDbValue($rs->fields('Nombre_Institucion_Donacion'));
		$this->Poblacion_clave->setDbValue($rs->fields('Poblacion_clave'));
		$this->Recibio_Asesoria_Pre_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Pre_Prueba'));
		$this->Recibio_Asesoria_Post_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Post_Prueba'));
		$this->Tipo_Prueba->setDbValue($rs->fields('Tipo_Prueba'));
		$this->Fecha_Resultado_Confirmatorio->setDbValue($rs->fields('Fecha_Resultado_Confirmatorio'));
		$this->Valor_Carga_Viral->setDbValue($rs->fields('Valor_Carga_Viral'));
		$this->Estado_Clinico_Notificacion->setDbValue($rs->fields('Estado_Clinico_Notificacion'));
		$this->Hijos_Mujeres_Menores_5->setDbValue($rs->fields('Hijos_Mujeres_Menores_5'));
		$this->Hijos_Hombres_Menores_5->setDbValue($rs->fields('Hijos_Hombres_Menores_5'));
		$this->Numero_Semanas_Embarazo->setDbValue($rs->fields('Numero_Semanas_Embarazo'));
		$this->Antecedentes_Embarazo->setDbValue($rs->fields('Antecedentes_Embarazo'));
		$this->Candidiasis_esofagica->setDbValue($rs->fields('Candidiasis_esofagica'));
		$this->Candidiasis_vias_aereas->setDbValue($rs->fields('Candidiasis_vias_aereas'));
		$this->Tuberculosis_pulmonar->setDbValue($rs->fields('Tuberculosis_pulmonar'));
		$this->Cancer_cervical->setDbValue($rs->fields('Cancer_cervical'));
		$this->Tuberculosis_extrapulmonar->setDbValue($rs->fields('Tuberculosis_extrapulmonar'));
		$this->Coccidiomicosis->setDbValue($rs->fields('Coccidiomicosis'));
		$this->Citomegalovirosis->setDbValue($rs->fields('Citomegalovirosis'));
		$this->Retinitis_citomegalovirosis->setDbValue($rs->fields('Retinitis_citomegalovirosis'));
		$this->Sindrome_Emanciacion->setDbValue($rs->fields('Sindrome_Emanciacion'));
		$this->Encefalopatia->setDbValue($rs->fields('Encefalopatia'));
		$this->Otras_micobacterias->setDbValue($rs->fields('Otras_micobacterias'));
		$this->Histoplasmosis_Extrapulmonar->setDbValue($rs->fields('Histoplasmosis_Extrapulmonar'));
		$this->isosporidiasis_cronica->setDbValue($rs->fields('isosporidiasis_cronica'));
		$this->herpes_zoster->setDbValue($rs->fields('herpes_zoster'));
		$this->Histoplasmosis_diseminada->setDbValue($rs->fields('Histoplasmosis_diseminada'));
		$this->Linfoma_Burkitt->setDbValue($rs->fields('Linfoma_Burkitt'));
		$this->Neumonia_Pneumocystis->setDbValue($rs->fields('Neumonia_Pneumocystis'));
		$this->Neumonia_Recurrente->setDbValue($rs->fields('Neumonia_Recurrente'));
		$this->Linfoma_Inmunoblastico->setDbValue($rs->fields('Linfoma_Inmunoblastico'));
		$this->Criptosporidiasis_cronica->setDbValue($rs->fields('Criptosporidiasis_cronica'));
		$this->Criptococosis_Extrapulmonar->setDbValue($rs->fields('Criptococosis_Extrapulmonar'));
		$this->Sarcoma_Kaposi->setDbValue($rs->fields('Sarcoma_Kaposi'));
		$this->Leucoencefalopatia_Multifocal->setDbValue($rs->fields('Leucoencefalopatia_Multifocal'));
		$this->Septicemia_recurrente->setDbValue($rs->fields('Septicemia_recurrente'));
		$this->Toxoplasmosis_cerebral->setDbValue($rs->fields('Toxoplasmosis_cerebral'));
		$this->HepatitisB->setDbValue($rs->fields('HepatitisB'));
		$this->HepatitisC->setDbValue($rs->fields('HepatitisC'));
		$this->Meningitis->setDbValue($rs->fields('Meningitis'));
		$this->RecuentoCD4->setDbValue($rs->fields('RecuentoCD4'));
		$this->Registrado_Por->setDbValue($rs->fields('Registrado_Por'));
		$this->Centro_Poblado->setDbValue($rs->fields('Centro_Poblado'));
		$this->Vereda->setDbValue($rs->fields('Vereda'));
		$this->Pertenencia_Etnica->setDbValue($rs->fields('Pertenencia_Etnica'));
		$this->Grupo_Poblacional->setDbValue($rs->fields('Grupo_Poblacional'));
		$this->Clasificacion_Inicial->setDbValue($rs->fields('Clasificacion_Inicial'));
		$this->Fecha_Hospitalizacion->setDbValue($rs->fields('Fecha_Hospitalizacion'));
		$this->Seguimiento_Clasificacion_Final->setDbValue($rs->fields('Seguimiento_Clasificacion_Final'));
		$this->Fecha_Ajuste->setDbValue($rs->fields('Fecha_Ajuste'));
		$this->Nombre_Evento->setDbValue($rs->fields('Nombre_Evento'));
		$this->Localidad_residencia->setDbValue($rs->fields('Localidad_residencia'));
		$this->Barrio_residencia->setDbValue($rs->fields('Barrio_residencia'));
		$this->Fecha_ingreso_app->setDbValue($rs->fields('Fecha_ingreso_app'));
		$this->Actualizado_por->setDbValue($rs->fields('Actualizado_por'));
		$this->Fecha_actualizacion_app->setDbValue($rs->fields('Fecha_actualizacion_app'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Consecutivo->DbValue = $row['Consecutivo'];
		$this->Seguimiento->DbValue = $row['Seguimiento'];
		$this->Condicion_Final->DbValue = $row['Condicion_Final'];
		$this->Codigo_centro->DbValue = $row['Codigo_centro'];
		$this->Codigo_UPGD->DbValue = $row['Codigo_UPGD'];
		$this->Cod_Evento->DbValue = $row['Cod_Evento'];
		$this->Embarazo_Actual->DbValue = $row['Embarazo_Actual'];
		$this->Fecha_Notificacion->DbValue = $row['Fecha_Notificacion'];
		$this->Semana->DbValue = $row['Semana'];
		$this->Periodo_Epidemiologico->DbValue = $row['Periodo_Epidemiologico'];
		$this->Periodo_Sivigila->DbValue = $row['Periodo_Sivigila'];
		$this->Primer_Nombre->DbValue = $row['Primer_Nombre'];
		$this->Segundo_Nombre->DbValue = $row['Segundo_Nombre'];
		$this->Primer_Apellido->DbValue = $row['Primer_Apellido'];
		$this->Segundo_Apellido->DbValue = $row['Segundo_Apellido'];
		$this->Tipo_Id->DbValue = $row['Tipo_Id'];
		$this->Numero_Identificacion->DbValue = $row['Numero_Identificacion'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Unidad_Edad->DbValue = $row['Unidad_Edad'];
		$this->Sexo->DbValue = $row['Sexo'];
		$this->Pais_Ocurrencia->DbValue = $row['Pais_Ocurrencia'];
		$this->Depto_Ocurrencia->DbValue = $row['Depto_Ocurrencia'];
		$this->Municipio_Ocurrencia->DbValue = $row['Municipio_Ocurrencia'];
		$this->Area_Ocurrencia->DbValue = $row['Area_Ocurrencia'];
		$this->Localidad->DbValue = $row['Localidad'];
		$this->Barrio->DbValue = $row['Barrio'];
		$this->Direccion_Residencia->DbValue = $row['Direccion_Residencia'];
		$this->Ocupacion->DbValue = $row['Ocupacion'];
		$this->Tipo_Regimen_Salud->DbValue = $row['Tipo_Regimen_Salud'];
		$this->Cod_Administradora->DbValue = $row['Cod_Administradora'];
		$this->gp_discapa->DbValue = $row['gp_discapa'];
		$this->gp_desplaz->DbValue = $row['gp_desplaz'];
		$this->gp_migrant->DbValue = $row['gp_migrant'];
		$this->gp_carcela->DbValue = $row['gp_carcela'];
		$this->gp_gestan->DbValue = $row['gp_gestan'];
		$this->gp_indigen->DbValue = $row['gp_indigen'];
		$this->gp_pobicbf->DbValue = $row['gp_pobicbf'];
		$this->gp_mad_com->DbValue = $row['gp_mad_com'];
		$this->gp_desmovi->DbValue = $row['gp_desmovi'];
		$this->gp_psiquia->DbValue = $row['gp_psiquia'];
		$this->gp_vic_vio->DbValue = $row['gp_vic_vio'];
		$this->gp_otros->DbValue = $row['gp_otros'];
		$this->Depto_Residencia->DbValue = $row['Depto_Residencia'];
		$this->Municipio_Residencia->DbValue = $row['Municipio_Residencia'];
		$this->Fecha_Consulta->DbValue = $row['Fecha_Consulta'];
		$this->Fecha_Inicio_Sintomas->DbValue = $row['Fecha_Inicio_Sintomas'];
		$this->Hospitalizado->DbValue = $row['Hospitalizado'];
		$this->Fecha_Defuncion->DbValue = $row['Fecha_Defuncion'];
		$this->Numero_Certificado_Defuncion->DbValue = $row['Numero_Certificado_Defuncion'];
		$this->Causa_Basica_Muerte_CIEX->DbValue = $row['Causa_Basica_Muerte_CIEX'];
		$this->Entidad_fallecimiento->DbValue = $row['Entidad_fallecimiento'];
		$this->Telefono->DbValue = $row['Telefono'];
		$this->Fecha_Nacimiento->DbValue = $row['Fecha_Nacimiento'];
		$this->Nombre_Profesional_Diligencia->DbValue = $row['Nombre_Profesional_Diligencia'];
		$this->Telefono_Profesional_Diligencia->DbValue = $row['Telefono_Profesional_Diligencia'];
		$this->Mecanismo_Probable_Transmision->DbValue = $row['Mecanismo_Probable_Transmision'];
		$this->Nombre_Madre->DbValue = $row['Nombre_Madre'];
		$this->Tipo_Id_Madre->DbValue = $row['Tipo_Id_Madre'];
		$this->Numero_Identificacion_Madre->DbValue = $row['Numero_Identificacion_Madre'];
		$this->Indentidad_Genero->DbValue = $row['Indentidad_Genero'];
		$this->Donador_Sangre_Ultimos_12_Meses->DbValue = $row['Donador_Sangre_Ultimos_12_Meses'];
		$this->Fecha_Donacion->DbValue = $row['Fecha_Donacion'];
		$this->Nombre_Institucion_Donacion->DbValue = $row['Nombre_Institucion_Donacion'];
		$this->Poblacion_clave->DbValue = $row['Poblacion_clave'];
		$this->Recibio_Asesoria_Pre_Prueba->DbValue = $row['Recibio_Asesoria_Pre_Prueba'];
		$this->Recibio_Asesoria_Post_Prueba->DbValue = $row['Recibio_Asesoria_Post_Prueba'];
		$this->Tipo_Prueba->DbValue = $row['Tipo_Prueba'];
		$this->Fecha_Resultado_Confirmatorio->DbValue = $row['Fecha_Resultado_Confirmatorio'];
		$this->Valor_Carga_Viral->DbValue = $row['Valor_Carga_Viral'];
		$this->Estado_Clinico_Notificacion->DbValue = $row['Estado_Clinico_Notificacion'];
		$this->Hijos_Mujeres_Menores_5->DbValue = $row['Hijos_Mujeres_Menores_5'];
		$this->Hijos_Hombres_Menores_5->DbValue = $row['Hijos_Hombres_Menores_5'];
		$this->Numero_Semanas_Embarazo->DbValue = $row['Numero_Semanas_Embarazo'];
		$this->Antecedentes_Embarazo->DbValue = $row['Antecedentes_Embarazo'];
		$this->Candidiasis_esofagica->DbValue = $row['Candidiasis_esofagica'];
		$this->Candidiasis_vias_aereas->DbValue = $row['Candidiasis_vias_aereas'];
		$this->Tuberculosis_pulmonar->DbValue = $row['Tuberculosis_pulmonar'];
		$this->Cancer_cervical->DbValue = $row['Cancer_cervical'];
		$this->Tuberculosis_extrapulmonar->DbValue = $row['Tuberculosis_extrapulmonar'];
		$this->Coccidiomicosis->DbValue = $row['Coccidiomicosis'];
		$this->Citomegalovirosis->DbValue = $row['Citomegalovirosis'];
		$this->Retinitis_citomegalovirosis->DbValue = $row['Retinitis_citomegalovirosis'];
		$this->Sindrome_Emanciacion->DbValue = $row['Sindrome_Emanciacion'];
		$this->Encefalopatia->DbValue = $row['Encefalopatia'];
		$this->Otras_micobacterias->DbValue = $row['Otras_micobacterias'];
		$this->Histoplasmosis_Extrapulmonar->DbValue = $row['Histoplasmosis_Extrapulmonar'];
		$this->isosporidiasis_cronica->DbValue = $row['isosporidiasis_cronica'];
		$this->herpes_zoster->DbValue = $row['herpes_zoster'];
		$this->Histoplasmosis_diseminada->DbValue = $row['Histoplasmosis_diseminada'];
		$this->Linfoma_Burkitt->DbValue = $row['Linfoma_Burkitt'];
		$this->Neumonia_Pneumocystis->DbValue = $row['Neumonia_Pneumocystis'];
		$this->Neumonia_Recurrente->DbValue = $row['Neumonia_Recurrente'];
		$this->Linfoma_Inmunoblastico->DbValue = $row['Linfoma_Inmunoblastico'];
		$this->Criptosporidiasis_cronica->DbValue = $row['Criptosporidiasis_cronica'];
		$this->Criptococosis_Extrapulmonar->DbValue = $row['Criptococosis_Extrapulmonar'];
		$this->Sarcoma_Kaposi->DbValue = $row['Sarcoma_Kaposi'];
		$this->Leucoencefalopatia_Multifocal->DbValue = $row['Leucoencefalopatia_Multifocal'];
		$this->Septicemia_recurrente->DbValue = $row['Septicemia_recurrente'];
		$this->Toxoplasmosis_cerebral->DbValue = $row['Toxoplasmosis_cerebral'];
		$this->HepatitisB->DbValue = $row['HepatitisB'];
		$this->HepatitisC->DbValue = $row['HepatitisC'];
		$this->Meningitis->DbValue = $row['Meningitis'];
		$this->RecuentoCD4->DbValue = $row['RecuentoCD4'];
		$this->Registrado_Por->DbValue = $row['Registrado_Por'];
		$this->Centro_Poblado->DbValue = $row['Centro_Poblado'];
		$this->Vereda->DbValue = $row['Vereda'];
		$this->Pertenencia_Etnica->DbValue = $row['Pertenencia_Etnica'];
		$this->Grupo_Poblacional->DbValue = $row['Grupo_Poblacional'];
		$this->Clasificacion_Inicial->DbValue = $row['Clasificacion_Inicial'];
		$this->Fecha_Hospitalizacion->DbValue = $row['Fecha_Hospitalizacion'];
		$this->Seguimiento_Clasificacion_Final->DbValue = $row['Seguimiento_Clasificacion_Final'];
		$this->Fecha_Ajuste->DbValue = $row['Fecha_Ajuste'];
		$this->Nombre_Evento->DbValue = $row['Nombre_Evento'];
		$this->Localidad_residencia->DbValue = $row['Localidad_residencia'];
		$this->Barrio_residencia->DbValue = $row['Barrio_residencia'];
		$this->Fecha_ingreso_app->DbValue = $row['Fecha_ingreso_app'];
		$this->Actualizado_por->DbValue = $row['Actualizado_por'];
		$this->Fecha_actualizacion_app->DbValue = $row['Fecha_actualizacion_app'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Consecutivo
		// Seguimiento
		// Condicion_Final
		// Codigo_centro
		// Codigo_UPGD
		// Cod_Evento
		// Embarazo_Actual
		// Fecha_Notificacion
		// Semana
		// Periodo_Epidemiologico
		// Periodo_Sivigila
		// Primer_Nombre
		// Segundo_Nombre
		// Primer_Apellido
		// Segundo_Apellido
		// Tipo_Id
		// Numero_Identificacion
		// Edad
		// Unidad_Edad
		// Sexo
		// Pais_Ocurrencia
		// Depto_Ocurrencia
		// Municipio_Ocurrencia
		// Area_Ocurrencia
		// Localidad
		// Barrio
		// Direccion_Residencia
		// Ocupacion
		// Tipo_Regimen_Salud
		// Cod_Administradora
		// gp_discapa
		// gp_desplaz
		// gp_migrant
		// gp_carcela
		// gp_gestan
		// gp_indigen
		// gp_pobicbf
		// gp_mad_com
		// gp_desmovi
		// gp_psiquia
		// gp_vic_vio
		// gp_otros
		// Depto_Residencia
		// Municipio_Residencia
		// Fecha_Consulta
		// Fecha_Inicio_Sintomas
		// Hospitalizado
		// Fecha_Defuncion
		// Numero_Certificado_Defuncion
		// Causa_Basica_Muerte_CIEX
		// Entidad_fallecimiento
		// Telefono
		// Fecha_Nacimiento
		// Nombre_Profesional_Diligencia
		// Telefono_Profesional_Diligencia
		// Mecanismo_Probable_Transmision
		// Nombre_Madre
		// Tipo_Id_Madre
		// Numero_Identificacion_Madre
		// Indentidad_Genero
		// Donador_Sangre_Ultimos_12_Meses
		// Fecha_Donacion
		// Nombre_Institucion_Donacion
		// Poblacion_clave
		// Recibio_Asesoria_Pre_Prueba
		// Recibio_Asesoria_Post_Prueba
		// Tipo_Prueba
		// Fecha_Resultado_Confirmatorio
		// Valor_Carga_Viral
		// Estado_Clinico_Notificacion
		// Hijos_Mujeres_Menores_5
		// Hijos_Hombres_Menores_5
		// Numero_Semanas_Embarazo
		// Antecedentes_Embarazo
		// Candidiasis_esofagica
		// Candidiasis_vias_aereas
		// Tuberculosis_pulmonar
		// Cancer_cervical
		// Tuberculosis_extrapulmonar
		// Coccidiomicosis
		// Citomegalovirosis
		// Retinitis_citomegalovirosis
		// Sindrome_Emanciacion
		// Encefalopatia
		// Otras_micobacterias
		// Histoplasmosis_Extrapulmonar
		// isosporidiasis_cronica
		// herpes_zoster
		// Histoplasmosis_diseminada
		// Linfoma_Burkitt
		// Neumonia_Pneumocystis
		// Neumonia_Recurrente
		// Linfoma_Inmunoblastico
		// Criptosporidiasis_cronica
		// Criptococosis_Extrapulmonar
		// Sarcoma_Kaposi
		// Leucoencefalopatia_Multifocal
		// Septicemia_recurrente
		// Toxoplasmosis_cerebral
		// HepatitisB
		// HepatitisC
		// Meningitis
		// RecuentoCD4
		// Registrado_Por
		// Centro_Poblado
		// Vereda
		// Pertenencia_Etnica
		// Grupo_Poblacional
		// Clasificacion_Inicial
		// Fecha_Hospitalizacion
		// Seguimiento_Clasificacion_Final
		// Fecha_Ajuste
		// Nombre_Evento
		// Localidad_residencia
		// Barrio_residencia
		// Fecha_ingreso_app
		// Actualizado_por
		// Fecha_actualizacion_app

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Consecutivo
		$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
		$this->Consecutivo->ViewCustomAttributes = "";

		// Seguimiento
		if (strval($this->Seguimiento->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Seguimiento->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Seguimiento, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Seguimiento->ViewValue = $this->Seguimiento->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Seguimiento->ViewValue = $this->Seguimiento->CurrentValue;
			}
		} else {
			$this->Seguimiento->ViewValue = NULL;
		}
		$this->Seguimiento->ViewCustomAttributes = "";

		// Condicion_Final
		if (strval($this->Condicion_Final->CurrentValue) <> "") {
			$sFilterWrk = "`No.Condicion_Final`" . ew_SearchString("=", $this->Condicion_Final->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `No.Condicion_Final`, `Condicion_Final` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `condicion_final`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Condicion_Final, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Condicion_Final->ViewValue = $this->Condicion_Final->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Condicion_Final->ViewValue = $this->Condicion_Final->CurrentValue;
			}
		} else {
			$this->Condicion_Final->ViewValue = NULL;
		}
		$this->Condicion_Final->ViewCustomAttributes = "";

		// Codigo_centro
		if (strval($this->Codigo_centro->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_centro->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Upgd` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Codigo_centro, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Codigo_centro->ViewValue = $this->Codigo_centro->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Codigo_centro->ViewValue = $this->Codigo_centro->CurrentValue;
			}
		} else {
			$this->Codigo_centro->ViewValue = NULL;
		}
		$this->Codigo_centro->ViewCustomAttributes = "";

		// Codigo_UPGD
		$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->CurrentValue;
		if (strval($this->Codigo_UPGD->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_UPGD->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Codigo_UPGD, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->CurrentValue;
			}
		} else {
			$this->Codigo_UPGD->ViewValue = NULL;
		}
		$this->Codigo_UPGD->ViewCustomAttributes = "";

		// Cod_Evento
		$this->Cod_Evento->ViewValue = $this->Cod_Evento->CurrentValue;
		$this->Cod_Evento->ViewCustomAttributes = "";

		// Embarazo_Actual
		if (strval($this->Embarazo_Actual->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Embarazo_Actual->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Embarazo_Actual, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Embarazo_Actual->ViewValue = $this->Embarazo_Actual->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Embarazo_Actual->ViewValue = $this->Embarazo_Actual->CurrentValue;
			}
		} else {
			$this->Embarazo_Actual->ViewValue = NULL;
		}
		$this->Embarazo_Actual->ViewCustomAttributes = "";

		// Fecha_Notificacion
		$this->Fecha_Notificacion->ViewValue = $this->Fecha_Notificacion->CurrentValue;
		$this->Fecha_Notificacion->ViewValue = ew_FormatDateTime($this->Fecha_Notificacion->ViewValue, 5);
		$this->Fecha_Notificacion->ViewCustomAttributes = "";

		// Semana
		if (strval($this->Semana->CurrentValue) <> "") {
			$sFilterWrk = "`Semana`" . ew_SearchString("=", $this->Semana->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Semana`, `Semana` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `semana_epidemiologica`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Semana, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Semana->ViewValue = $this->Semana->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Semana->ViewValue = $this->Semana->CurrentValue;
			}
		} else {
			$this->Semana->ViewValue = NULL;
		}
		$this->Semana->ViewCustomAttributes = "";

		// Periodo_Epidemiologico
		if (strval($this->Periodo_Epidemiologico->CurrentValue) <> "") {
			$sFilterWrk = "`Periodo_epidemiologico`" . ew_SearchString("=", $this->Periodo_Epidemiologico->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Periodo_epidemiologico`, `Periodo_epidemiologico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `periodo_epidemiologico`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Periodo_Epidemiologico, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Periodo_Epidemiologico->ViewValue = $this->Periodo_Epidemiologico->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Periodo_Epidemiologico->ViewValue = $this->Periodo_Epidemiologico->CurrentValue;
			}
		} else {
			$this->Periodo_Epidemiologico->ViewValue = NULL;
		}
		$this->Periodo_Epidemiologico->ViewCustomAttributes = "";

		// Periodo_Sivigila
		if (strval($this->Periodo_Sivigila->CurrentValue) <> "") {
			$sFilterWrk = "`Periodo`" . ew_SearchString("=", $this->Periodo_Sivigila->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Periodo`, `Periodo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `periodo`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Periodo_Sivigila, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Periodo_Sivigila->ViewValue = $this->Periodo_Sivigila->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Periodo_Sivigila->ViewValue = $this->Periodo_Sivigila->CurrentValue;
			}
		} else {
			$this->Periodo_Sivigila->ViewValue = NULL;
		}
		$this->Periodo_Sivigila->ViewCustomAttributes = "";

		// Primer_Nombre
		$this->Primer_Nombre->ViewValue = $this->Primer_Nombre->CurrentValue;
		$this->Primer_Nombre->ViewCustomAttributes = "";

		// Segundo_Nombre
		$this->Segundo_Nombre->ViewValue = $this->Segundo_Nombre->CurrentValue;
		$this->Segundo_Nombre->ViewCustomAttributes = "";

		// Primer_Apellido
		$this->Primer_Apellido->ViewValue = $this->Primer_Apellido->CurrentValue;
		$this->Primer_Apellido->ViewCustomAttributes = "";

		// Segundo_Apellido
		$this->Segundo_Apellido->ViewValue = $this->Segundo_Apellido->CurrentValue;
		$this->Segundo_Apellido->ViewCustomAttributes = "";

		// Tipo_Id
		if (strval($this->Tipo_Id->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Documento`" . ew_SearchString("=", $this->Tipo_Id->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Cod_Documento`, `Tipo_Ide` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Id, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Id->ViewValue = $this->Tipo_Id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Id->ViewValue = $this->Tipo_Id->CurrentValue;
			}
		} else {
			$this->Tipo_Id->ViewValue = NULL;
		}
		$this->Tipo_Id->ViewCustomAttributes = "";

		// Numero_Identificacion
		$this->Numero_Identificacion->ViewValue = $this->Numero_Identificacion->CurrentValue;
		$this->Numero_Identificacion->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Unidad_Edad
		if (strval($this->Unidad_Edad->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Unidad_Edad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Unidad_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `unidad_medida_edad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Unidad_Edad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Unidad_Edad->ViewValue = $this->Unidad_Edad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Unidad_Edad->ViewValue = $this->Unidad_Edad->CurrentValue;
			}
		} else {
			$this->Unidad_Edad->ViewValue = NULL;
		}
		$this->Unidad_Edad->ViewCustomAttributes = "";

		// Sexo
		if (strval($this->Sexo->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Sexo`" . ew_SearchString("=", $this->Sexo->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Sexo`, `Sexo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sexo`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sexo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sexo->ViewValue = $this->Sexo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
			}
		} else {
			$this->Sexo->ViewValue = NULL;
		}
		$this->Sexo->ViewCustomAttributes = "";

		// Pais_Ocurrencia
		if (strval($this->Pais_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Pais`" . ew_SearchString("=", $this->Pais_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Pais`, `Pais` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `pais`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Pais_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Pais_Ocurrencia->ViewValue = $this->Pais_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Pais_Ocurrencia->ViewValue = $this->Pais_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Pais_Ocurrencia->ViewValue = NULL;
		}
		$this->Pais_Ocurrencia->ViewCustomAttributes = "";

		// Depto_Ocurrencia
		if (strval($this->Depto_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Departamento`" . ew_SearchString("=", $this->Depto_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Departamento`, `Departamento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `departamento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Depto_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Depto_Ocurrencia->ViewValue = $this->Depto_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Depto_Ocurrencia->ViewValue = $this->Depto_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Depto_Ocurrencia->ViewValue = NULL;
		}
		$this->Depto_Ocurrencia->ViewCustomAttributes = "";

		// Municipio_Ocurrencia
		if (strval($this->Municipio_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Municipio`" . ew_SearchString("=", $this->Municipio_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Municipio`, `Municipio` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `municipio`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Municipio_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Municipio_Ocurrencia->ViewValue = $this->Municipio_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Municipio_Ocurrencia->ViewValue = $this->Municipio_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Municipio_Ocurrencia->ViewValue = NULL;
		}
		$this->Municipio_Ocurrencia->ViewCustomAttributes = "";

		// Area_Ocurrencia
		if (strval($this->Area_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Area_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Area_Ocurrencia` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `area_ocurrencia`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Area_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Area_Ocurrencia->ViewValue = $this->Area_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Area_Ocurrencia->ViewValue = $this->Area_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Area_Ocurrencia->ViewValue = NULL;
		}
		$this->Area_Ocurrencia->ViewCustomAttributes = "";

		// Localidad
		if (strval($this->Localidad->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Localidad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `localidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Localidad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Localidad->ViewValue = $this->Localidad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Localidad->ViewValue = $this->Localidad->CurrentValue;
			}
		} else {
			$this->Localidad->ViewValue = NULL;
		}
		$this->Localidad->ViewCustomAttributes = "";

		// Barrio
		if (strval($this->Barrio->CurrentValue) <> "") {
			$sFilterWrk = "`cod_barrio_vereda`" . ew_SearchString("=", $this->Barrio->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `cod_barrio_vereda`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrios_veredas`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Barrio, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Barrio->ViewValue = $this->Barrio->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Barrio->ViewValue = $this->Barrio->CurrentValue;
			}
		} else {
			$this->Barrio->ViewValue = NULL;
		}
		$this->Barrio->ViewCustomAttributes = "";

		// Direccion_Residencia
		$this->Direccion_Residencia->ViewValue = $this->Direccion_Residencia->CurrentValue;
		$this->Direccion_Residencia->ViewCustomAttributes = "";

		// Ocupacion
		if (strval($this->Ocupacion->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Ocupacion`" . ew_SearchString("=", $this->Ocupacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Ocupacion`, `Cod_Ocupacion` AS `DispFld`, `Ocupacion` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `ocupacion`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Ocupacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Ocupacion->ViewValue = $this->Ocupacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Ocupacion->ViewValue = $this->Ocupacion->CurrentValue;
			}
		} else {
			$this->Ocupacion->ViewValue = NULL;
		}
		$this->Ocupacion->ViewCustomAttributes = "";

		// Tipo_Regimen_Salud
		if (strval($this->Tipo_Regimen_Salud->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Regimen`" . ew_SearchString("=", $this->Tipo_Regimen_Salud->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Regimen`, `Codigo_Regimen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_regimen_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Regimen_Salud, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->CurrentValue;
			}
		} else {
			$this->Tipo_Regimen_Salud->ViewValue = NULL;
		}
		$this->Tipo_Regimen_Salud->ViewCustomAttributes = "";

		// Cod_Administradora
		if (strval($this->Cod_Administradora->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->Cod_Administradora->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Cod_Administradora, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Cod_Administradora->ViewValue = $this->Cod_Administradora->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Cod_Administradora->ViewValue = $this->Cod_Administradora->CurrentValue;
			}
		} else {
			$this->Cod_Administradora->ViewValue = NULL;
		}
		$this->Cod_Administradora->ViewCustomAttributes = "";

		// gp_discapa
		if (strval($this->gp_discapa->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_discapa->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_discapa, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_discapa->ViewValue = $this->gp_discapa->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_discapa->ViewValue = $this->gp_discapa->CurrentValue;
			}
		} else {
			$this->gp_discapa->ViewValue = NULL;
		}
		$this->gp_discapa->ViewCustomAttributes = "";

		// gp_desplaz
		if (strval($this->gp_desplaz->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_desplaz->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_desplaz, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_desplaz->ViewValue = $this->gp_desplaz->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_desplaz->ViewValue = $this->gp_desplaz->CurrentValue;
			}
		} else {
			$this->gp_desplaz->ViewValue = NULL;
		}
		$this->gp_desplaz->ViewCustomAttributes = "";

		// gp_migrant
		if (strval($this->gp_migrant->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_migrant->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_migrant, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_migrant->ViewValue = $this->gp_migrant->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_migrant->ViewValue = $this->gp_migrant->CurrentValue;
			}
		} else {
			$this->gp_migrant->ViewValue = NULL;
		}
		$this->gp_migrant->ViewCustomAttributes = "";

		// gp_carcela
		if (strval($this->gp_carcela->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_carcela->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_carcela, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_carcela->ViewValue = $this->gp_carcela->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_carcela->ViewValue = $this->gp_carcela->CurrentValue;
			}
		} else {
			$this->gp_carcela->ViewValue = NULL;
		}
		$this->gp_carcela->ViewCustomAttributes = "";

		// gp_gestan
		if (strval($this->gp_gestan->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_gestan->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_gestan, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_gestan->ViewValue = $this->gp_gestan->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_gestan->ViewValue = $this->gp_gestan->CurrentValue;
			}
		} else {
			$this->gp_gestan->ViewValue = NULL;
		}
		$this->gp_gestan->ViewCustomAttributes = "";

		// gp_indigen
		if (strval($this->gp_indigen->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_indigen->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_indigen, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_indigen->ViewValue = $this->gp_indigen->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_indigen->ViewValue = $this->gp_indigen->CurrentValue;
			}
		} else {
			$this->gp_indigen->ViewValue = NULL;
		}
		$this->gp_indigen->ViewCustomAttributes = "";

		// gp_pobicbf
		if (strval($this->gp_pobicbf->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_pobicbf->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_pobicbf, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_pobicbf->ViewValue = $this->gp_pobicbf->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_pobicbf->ViewValue = $this->gp_pobicbf->CurrentValue;
			}
		} else {
			$this->gp_pobicbf->ViewValue = NULL;
		}
		$this->gp_pobicbf->ViewCustomAttributes = "";

		// gp_mad_com
		if (strval($this->gp_mad_com->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_mad_com->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_mad_com, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_mad_com->ViewValue = $this->gp_mad_com->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_mad_com->ViewValue = $this->gp_mad_com->CurrentValue;
			}
		} else {
			$this->gp_mad_com->ViewValue = NULL;
		}
		$this->gp_mad_com->ViewCustomAttributes = "";

		// gp_desmovi
		if (strval($this->gp_desmovi->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_desmovi->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_desmovi, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_desmovi->ViewValue = $this->gp_desmovi->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_desmovi->ViewValue = $this->gp_desmovi->CurrentValue;
			}
		} else {
			$this->gp_desmovi->ViewValue = NULL;
		}
		$this->gp_desmovi->ViewCustomAttributes = "";

		// gp_psiquia
		if (strval($this->gp_psiquia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_psiquia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_psiquia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_psiquia->ViewValue = $this->gp_psiquia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_psiquia->ViewValue = $this->gp_psiquia->CurrentValue;
			}
		} else {
			$this->gp_psiquia->ViewValue = NULL;
		}
		$this->gp_psiquia->ViewCustomAttributes = "";

		// gp_vic_vio
		if (strval($this->gp_vic_vio->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_vic_vio->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_vic_vio, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_vic_vio->ViewValue = $this->gp_vic_vio->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_vic_vio->ViewValue = $this->gp_vic_vio->CurrentValue;
			}
		} else {
			$this->gp_vic_vio->ViewValue = NULL;
		}
		$this->gp_vic_vio->ViewCustomAttributes = "";

		// gp_otros
		if (strval($this->gp_otros->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_otros->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_otros, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_otros->ViewValue = $this->gp_otros->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_otros->ViewValue = $this->gp_otros->CurrentValue;
			}
		} else {
			$this->gp_otros->ViewValue = NULL;
		}
		$this->gp_otros->ViewCustomAttributes = "";

		// Depto_Residencia
		if (strval($this->Depto_Residencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Departamento`" . ew_SearchString("=", $this->Depto_Residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Departamento`, `Departamento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `departamento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Depto_Residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Depto_Residencia->ViewValue = $this->Depto_Residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Depto_Residencia->ViewValue = $this->Depto_Residencia->CurrentValue;
			}
		} else {
			$this->Depto_Residencia->ViewValue = NULL;
		}
		$this->Depto_Residencia->ViewCustomAttributes = "";

		// Municipio_Residencia
		if (strval($this->Municipio_Residencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Municipio`" . ew_SearchString("=", $this->Municipio_Residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Municipio`, `Municipio` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `municipio`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Municipio_Residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Municipio_Residencia->ViewValue = $this->Municipio_Residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Municipio_Residencia->ViewValue = $this->Municipio_Residencia->CurrentValue;
			}
		} else {
			$this->Municipio_Residencia->ViewValue = NULL;
		}
		$this->Municipio_Residencia->ViewCustomAttributes = "";

		// Fecha_Consulta
		$this->Fecha_Consulta->ViewValue = $this->Fecha_Consulta->CurrentValue;
		$this->Fecha_Consulta->ViewValue = ew_FormatDateTime($this->Fecha_Consulta->ViewValue, 5);
		$this->Fecha_Consulta->ViewCustomAttributes = "";

		// Fecha_Inicio_Sintomas
		$this->Fecha_Inicio_Sintomas->ViewValue = $this->Fecha_Inicio_Sintomas->CurrentValue;
		$this->Fecha_Inicio_Sintomas->ViewValue = ew_FormatDateTime($this->Fecha_Inicio_Sintomas->ViewValue, 5);
		$this->Fecha_Inicio_Sintomas->ViewCustomAttributes = "";

		// Hospitalizado
		if (strval($this->Hospitalizado->CurrentValue) <> "") {
			$arwrk = explode(",", $this->Hospitalizado->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`Consecutivo`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Hospitalizado, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Hospitalizado->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->Hospitalizado->ViewValue .= $this->Hospitalizado->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->Hospitalizado->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->Hospitalizado->ViewValue = $this->Hospitalizado->CurrentValue;
			}
		} else {
			$this->Hospitalizado->ViewValue = NULL;
		}
		$this->Hospitalizado->ViewCustomAttributes = "";

		// Fecha_Defuncion
		$this->Fecha_Defuncion->ViewValue = $this->Fecha_Defuncion->CurrentValue;
		$this->Fecha_Defuncion->ViewValue = ew_FormatDateTime($this->Fecha_Defuncion->ViewValue, 5);
		$this->Fecha_Defuncion->ViewCustomAttributes = "";

		// Numero_Certificado_Defuncion
		$this->Numero_Certificado_Defuncion->ViewValue = $this->Numero_Certificado_Defuncion->CurrentValue;
		$this->Numero_Certificado_Defuncion->ViewCustomAttributes = "";

		// Causa_Basica_Muerte_CIEX
		$this->Causa_Basica_Muerte_CIEX->ViewValue = $this->Causa_Basica_Muerte_CIEX->CurrentValue;
		$this->Causa_Basica_Muerte_CIEX->ViewCustomAttributes = "";

		// Entidad_fallecimiento
		$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->CurrentValue;
		if (strval($this->Entidad_fallecimiento->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Entidad_fallecimiento->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad_fallecimiento, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->CurrentValue;
			}
		} else {
			$this->Entidad_fallecimiento->ViewValue = NULL;
		}
		$this->Entidad_fallecimiento->ViewCustomAttributes = "";

		// Telefono
		$this->Telefono->ViewValue = $this->Telefono->CurrentValue;
		$this->Telefono->ViewCustomAttributes = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
		$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 5);
		$this->Fecha_Nacimiento->ViewCustomAttributes = "";

		// Nombre_Profesional_Diligencia
		$this->Nombre_Profesional_Diligencia->ViewValue = $this->Nombre_Profesional_Diligencia->CurrentValue;
		$this->Nombre_Profesional_Diligencia->ViewCustomAttributes = "";

		// Telefono_Profesional_Diligencia
		$this->Telefono_Profesional_Diligencia->ViewValue = $this->Telefono_Profesional_Diligencia->CurrentValue;
		$this->Telefono_Profesional_Diligencia->ViewCustomAttributes = "";

		// Mecanismo_Probable_Transmision
		if (strval($this->Mecanismo_Probable_Transmision->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Mecanismo_Probable_Transmision->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Mecanismo_Probable` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `mecanismo_probable_transmision`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Mecanismo_Probable_Transmision, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Mecanismo_Probable_Transmision->ViewValue = $this->Mecanismo_Probable_Transmision->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Mecanismo_Probable_Transmision->ViewValue = $this->Mecanismo_Probable_Transmision->CurrentValue;
			}
		} else {
			$this->Mecanismo_Probable_Transmision->ViewValue = NULL;
		}
		$this->Mecanismo_Probable_Transmision->ViewCustomAttributes = "";

		// Nombre_Madre
		$this->Nombre_Madre->ViewValue = $this->Nombre_Madre->CurrentValue;
		$this->Nombre_Madre->ViewCustomAttributes = "";

		// Tipo_Id_Madre
		if (strval($this->Tipo_Id_Madre->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Documento`" . ew_SearchString("=", $this->Tipo_Id_Madre->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Cod_Documento`, `Tipo_Ide` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Id_Madre, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Id_Madre->ViewValue = $this->Tipo_Id_Madre->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Id_Madre->ViewValue = $this->Tipo_Id_Madre->CurrentValue;
			}
		} else {
			$this->Tipo_Id_Madre->ViewValue = NULL;
		}
		$this->Tipo_Id_Madre->ViewCustomAttributes = "";

		// Numero_Identificacion_Madre
		$this->Numero_Identificacion_Madre->ViewValue = $this->Numero_Identificacion_Madre->CurrentValue;
		$this->Numero_Identificacion_Madre->ViewCustomAttributes = "";

		// Indentidad_Genero
		if (strval($this->Indentidad_Genero->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_identidad`" . ew_SearchString("=", $this->Indentidad_Genero->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_identidad`, `Identidad_genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `identidad_genero`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Indentidad_Genero, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Indentidad_Genero->ViewValue = $this->Indentidad_Genero->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Indentidad_Genero->ViewValue = $this->Indentidad_Genero->CurrentValue;
			}
		} else {
			$this->Indentidad_Genero->ViewValue = NULL;
		}
		$this->Indentidad_Genero->ViewCustomAttributes = "";

		// Donador_Sangre_Ultimos_12_Meses
		if (strval($this->Donador_Sangre_Ultimos_12_Meses->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Donador_Sangre_Ultimos_12_Meses, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = $this->Donador_Sangre_Ultimos_12_Meses->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue;
			}
		} else {
			$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = NULL;
		}
		$this->Donador_Sangre_Ultimos_12_Meses->ViewCustomAttributes = "";

		// Fecha_Donacion
		$this->Fecha_Donacion->ViewValue = $this->Fecha_Donacion->CurrentValue;
		$this->Fecha_Donacion->ViewValue = ew_FormatDateTime($this->Fecha_Donacion->ViewValue, 5);
		$this->Fecha_Donacion->ViewCustomAttributes = "";

		// Nombre_Institucion_Donacion
		$this->Nombre_Institucion_Donacion->ViewValue = $this->Nombre_Institucion_Donacion->CurrentValue;
		$this->Nombre_Institucion_Donacion->ViewCustomAttributes = "";

		// Poblacion_clave
		if (strval($this->Poblacion_clave->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Poblacion_clave->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Poblacion_clave` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `poblacion_clave`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Poblacion_clave, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Poblacion_clave->ViewValue = $this->Poblacion_clave->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Poblacion_clave->ViewValue = $this->Poblacion_clave->CurrentValue;
			}
		} else {
			$this->Poblacion_clave->ViewValue = NULL;
		}
		$this->Poblacion_clave->ViewCustomAttributes = "";

		// Recibio_Asesoria_Pre_Prueba
		if (strval($this->Recibio_Asesoria_Pre_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Recibio_Asesoria_Pre_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Recibio_Asesoria_Pre_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Recibio_Asesoria_Pre_Prueba->ViewValue = $this->Recibio_Asesoria_Pre_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Recibio_Asesoria_Pre_Prueba->ViewValue = $this->Recibio_Asesoria_Pre_Prueba->CurrentValue;
			}
		} else {
			$this->Recibio_Asesoria_Pre_Prueba->ViewValue = NULL;
		}
		$this->Recibio_Asesoria_Pre_Prueba->ViewCustomAttributes = "";

		// Recibio_Asesoria_Post_Prueba
		if (strval($this->Recibio_Asesoria_Post_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Recibio_Asesoria_Post_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Recibio_Asesoria_Post_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Recibio_Asesoria_Post_Prueba->ViewValue = $this->Recibio_Asesoria_Post_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Recibio_Asesoria_Post_Prueba->ViewValue = $this->Recibio_Asesoria_Post_Prueba->CurrentValue;
			}
		} else {
			$this->Recibio_Asesoria_Post_Prueba->ViewValue = NULL;
		}
		$this->Recibio_Asesoria_Post_Prueba->ViewCustomAttributes = "";

		// Tipo_Prueba
		if (strval($this->Tipo_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tipo_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Tipo_Prueba` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_prueba`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Prueba->ViewValue = $this->Tipo_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Prueba->ViewValue = $this->Tipo_Prueba->CurrentValue;
			}
		} else {
			$this->Tipo_Prueba->ViewValue = NULL;
		}
		$this->Tipo_Prueba->ViewCustomAttributes = "";

		// Fecha_Resultado_Confirmatorio
		$this->Fecha_Resultado_Confirmatorio->ViewValue = $this->Fecha_Resultado_Confirmatorio->CurrentValue;
		$this->Fecha_Resultado_Confirmatorio->ViewValue = ew_FormatDateTime($this->Fecha_Resultado_Confirmatorio->ViewValue, 5);
		$this->Fecha_Resultado_Confirmatorio->ViewCustomAttributes = "";

		// Valor_Carga_Viral
		$this->Valor_Carga_Viral->ViewValue = $this->Valor_Carga_Viral->CurrentValue;
		$this->Valor_Carga_Viral->ViewCustomAttributes = "";

		// Estado_Clinico_Notificacion
		if (strval($this->Estado_Clinico_Notificacion->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Estado_Clinico_Notificacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Estado_Clinico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `estado_clinico_paciente`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Estado_Clinico_Notificacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Estado_Clinico_Notificacion->ViewValue = $this->Estado_Clinico_Notificacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Estado_Clinico_Notificacion->ViewValue = $this->Estado_Clinico_Notificacion->CurrentValue;
			}
		} else {
			$this->Estado_Clinico_Notificacion->ViewValue = NULL;
		}
		$this->Estado_Clinico_Notificacion->ViewCustomAttributes = "";

		// Hijos_Mujeres_Menores_5
		$this->Hijos_Mujeres_Menores_5->ViewValue = $this->Hijos_Mujeres_Menores_5->CurrentValue;
		$this->Hijos_Mujeres_Menores_5->ViewCustomAttributes = "";

		// Hijos_Hombres_Menores_5
		$this->Hijos_Hombres_Menores_5->ViewValue = $this->Hijos_Hombres_Menores_5->CurrentValue;
		$this->Hijos_Hombres_Menores_5->ViewCustomAttributes = "";

		// Numero_Semanas_Embarazo
		$this->Numero_Semanas_Embarazo->ViewValue = $this->Numero_Semanas_Embarazo->CurrentValue;
		$this->Numero_Semanas_Embarazo->ViewCustomAttributes = "";

		// Antecedentes_Embarazo
		if (strval($this->Antecedentes_Embarazo->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Antecedentes_Embarazo->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Antecedentes_Embarazo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Antecedentes_Embarazo->ViewValue = $this->Antecedentes_Embarazo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Antecedentes_Embarazo->ViewValue = $this->Antecedentes_Embarazo->CurrentValue;
			}
		} else {
			$this->Antecedentes_Embarazo->ViewValue = NULL;
		}
		$this->Antecedentes_Embarazo->ViewCustomAttributes = "";

		// Candidiasis_esofagica
		if (strval($this->Candidiasis_esofagica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Candidiasis_esofagica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Candidiasis_esofagica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Candidiasis_esofagica->ViewValue = $this->Candidiasis_esofagica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Candidiasis_esofagica->ViewValue = $this->Candidiasis_esofagica->CurrentValue;
			}
		} else {
			$this->Candidiasis_esofagica->ViewValue = NULL;
		}
		$this->Candidiasis_esofagica->ViewCustomAttributes = "";

		// Candidiasis_vias_aereas
		if (strval($this->Candidiasis_vias_aereas->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Candidiasis_vias_aereas->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Candidiasis_vias_aereas, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Candidiasis_vias_aereas->ViewValue = $this->Candidiasis_vias_aereas->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Candidiasis_vias_aereas->ViewValue = $this->Candidiasis_vias_aereas->CurrentValue;
			}
		} else {
			$this->Candidiasis_vias_aereas->ViewValue = NULL;
		}
		$this->Candidiasis_vias_aereas->ViewCustomAttributes = "";

		// Tuberculosis_pulmonar
		if (strval($this->Tuberculosis_pulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tuberculosis_pulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tuberculosis_pulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tuberculosis_pulmonar->ViewValue = $this->Tuberculosis_pulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tuberculosis_pulmonar->ViewValue = $this->Tuberculosis_pulmonar->CurrentValue;
			}
		} else {
			$this->Tuberculosis_pulmonar->ViewValue = NULL;
		}
		$this->Tuberculosis_pulmonar->ViewCustomAttributes = "";

		// Cancer_cervical
		if (strval($this->Cancer_cervical->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Cancer_cervical->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Cancer_cervical, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Cancer_cervical->ViewValue = $this->Cancer_cervical->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Cancer_cervical->ViewValue = $this->Cancer_cervical->CurrentValue;
			}
		} else {
			$this->Cancer_cervical->ViewValue = NULL;
		}
		$this->Cancer_cervical->ViewCustomAttributes = "";

		// Tuberculosis_extrapulmonar
		if (strval($this->Tuberculosis_extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tuberculosis_extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tuberculosis_extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tuberculosis_extrapulmonar->ViewValue = $this->Tuberculosis_extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tuberculosis_extrapulmonar->ViewValue = $this->Tuberculosis_extrapulmonar->CurrentValue;
			}
		} else {
			$this->Tuberculosis_extrapulmonar->ViewValue = NULL;
		}
		$this->Tuberculosis_extrapulmonar->ViewCustomAttributes = "";

		// Coccidiomicosis
		if (strval($this->Coccidiomicosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Coccidiomicosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Coccidiomicosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Coccidiomicosis->ViewValue = $this->Coccidiomicosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Coccidiomicosis->ViewValue = $this->Coccidiomicosis->CurrentValue;
			}
		} else {
			$this->Coccidiomicosis->ViewValue = NULL;
		}
		$this->Coccidiomicosis->ViewCustomAttributes = "";

		// Citomegalovirosis
		if (strval($this->Citomegalovirosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Citomegalovirosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Citomegalovirosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Citomegalovirosis->ViewValue = $this->Citomegalovirosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Citomegalovirosis->ViewValue = $this->Citomegalovirosis->CurrentValue;
			}
		} else {
			$this->Citomegalovirosis->ViewValue = NULL;
		}
		$this->Citomegalovirosis->ViewCustomAttributes = "";

		// Retinitis_citomegalovirosis
		if (strval($this->Retinitis_citomegalovirosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Retinitis_citomegalovirosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Retinitis_citomegalovirosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Retinitis_citomegalovirosis->ViewValue = $this->Retinitis_citomegalovirosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Retinitis_citomegalovirosis->ViewValue = $this->Retinitis_citomegalovirosis->CurrentValue;
			}
		} else {
			$this->Retinitis_citomegalovirosis->ViewValue = NULL;
		}
		$this->Retinitis_citomegalovirosis->ViewCustomAttributes = "";

		// Sindrome_Emanciacion
		if (strval($this->Sindrome_Emanciacion->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Sindrome_Emanciacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sindrome_Emanciacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sindrome_Emanciacion->ViewValue = $this->Sindrome_Emanciacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sindrome_Emanciacion->ViewValue = $this->Sindrome_Emanciacion->CurrentValue;
			}
		} else {
			$this->Sindrome_Emanciacion->ViewValue = NULL;
		}
		$this->Sindrome_Emanciacion->ViewCustomAttributes = "";

		// Encefalopatia
		if (strval($this->Encefalopatia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Encefalopatia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Encefalopatia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Encefalopatia->ViewValue = $this->Encefalopatia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Encefalopatia->ViewValue = $this->Encefalopatia->CurrentValue;
			}
		} else {
			$this->Encefalopatia->ViewValue = NULL;
		}
		$this->Encefalopatia->ViewCustomAttributes = "";

		// Otras_micobacterias
		if (strval($this->Otras_micobacterias->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Otras_micobacterias->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Otras_micobacterias, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Otras_micobacterias->ViewValue = $this->Otras_micobacterias->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Otras_micobacterias->ViewValue = $this->Otras_micobacterias->CurrentValue;
			}
		} else {
			$this->Otras_micobacterias->ViewValue = NULL;
		}
		$this->Otras_micobacterias->ViewCustomAttributes = "";

		// Histoplasmosis_Extrapulmonar
		if (strval($this->Histoplasmosis_Extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Histoplasmosis_Extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Histoplasmosis_Extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Histoplasmosis_Extrapulmonar->ViewValue = $this->Histoplasmosis_Extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Histoplasmosis_Extrapulmonar->ViewValue = $this->Histoplasmosis_Extrapulmonar->CurrentValue;
			}
		} else {
			$this->Histoplasmosis_Extrapulmonar->ViewValue = NULL;
		}
		$this->Histoplasmosis_Extrapulmonar->ViewCustomAttributes = "";

		// isosporidiasis_cronica
		if (strval($this->isosporidiasis_cronica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->isosporidiasis_cronica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->isosporidiasis_cronica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->isosporidiasis_cronica->ViewValue = $this->isosporidiasis_cronica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->isosporidiasis_cronica->ViewValue = $this->isosporidiasis_cronica->CurrentValue;
			}
		} else {
			$this->isosporidiasis_cronica->ViewValue = NULL;
		}
		$this->isosporidiasis_cronica->ViewCustomAttributes = "";

		// herpes_zoster
		if (strval($this->herpes_zoster->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->herpes_zoster->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->herpes_zoster, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->herpes_zoster->ViewValue = $this->herpes_zoster->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->herpes_zoster->ViewValue = $this->herpes_zoster->CurrentValue;
			}
		} else {
			$this->herpes_zoster->ViewValue = NULL;
		}
		$this->herpes_zoster->ViewCustomAttributes = "";

		// Histoplasmosis_diseminada
		if (strval($this->Histoplasmosis_diseminada->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Histoplasmosis_diseminada->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Histoplasmosis_diseminada, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Histoplasmosis_diseminada->ViewValue = $this->Histoplasmosis_diseminada->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Histoplasmosis_diseminada->ViewValue = $this->Histoplasmosis_diseminada->CurrentValue;
			}
		} else {
			$this->Histoplasmosis_diseminada->ViewValue = NULL;
		}
		$this->Histoplasmosis_diseminada->ViewCustomAttributes = "";

		// Linfoma_Burkitt
		if (strval($this->Linfoma_Burkitt->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Linfoma_Burkitt->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Linfoma_Burkitt, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Linfoma_Burkitt->ViewValue = $this->Linfoma_Burkitt->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Linfoma_Burkitt->ViewValue = $this->Linfoma_Burkitt->CurrentValue;
			}
		} else {
			$this->Linfoma_Burkitt->ViewValue = NULL;
		}
		$this->Linfoma_Burkitt->ViewCustomAttributes = "";

		// Neumonia_Pneumocystis
		if (strval($this->Neumonia_Pneumocystis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Neumonia_Pneumocystis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Neumonia_Pneumocystis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Neumonia_Pneumocystis->ViewValue = $this->Neumonia_Pneumocystis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Neumonia_Pneumocystis->ViewValue = $this->Neumonia_Pneumocystis->CurrentValue;
			}
		} else {
			$this->Neumonia_Pneumocystis->ViewValue = NULL;
		}
		$this->Neumonia_Pneumocystis->ViewCustomAttributes = "";

		// Neumonia_Recurrente
		if (strval($this->Neumonia_Recurrente->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Neumonia_Recurrente->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Neumonia_Recurrente, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Neumonia_Recurrente->ViewValue = $this->Neumonia_Recurrente->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Neumonia_Recurrente->ViewValue = $this->Neumonia_Recurrente->CurrentValue;
			}
		} else {
			$this->Neumonia_Recurrente->ViewValue = NULL;
		}
		$this->Neumonia_Recurrente->ViewCustomAttributes = "";

		// Linfoma_Inmunoblastico
		if (strval($this->Linfoma_Inmunoblastico->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Linfoma_Inmunoblastico->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Linfoma_Inmunoblastico, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Linfoma_Inmunoblastico->ViewValue = $this->Linfoma_Inmunoblastico->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Linfoma_Inmunoblastico->ViewValue = $this->Linfoma_Inmunoblastico->CurrentValue;
			}
		} else {
			$this->Linfoma_Inmunoblastico->ViewValue = NULL;
		}
		$this->Linfoma_Inmunoblastico->ViewCustomAttributes = "";

		// Criptosporidiasis_cronica
		if (strval($this->Criptosporidiasis_cronica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Criptosporidiasis_cronica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Criptosporidiasis_cronica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Criptosporidiasis_cronica->ViewValue = $this->Criptosporidiasis_cronica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Criptosporidiasis_cronica->ViewValue = $this->Criptosporidiasis_cronica->CurrentValue;
			}
		} else {
			$this->Criptosporidiasis_cronica->ViewValue = NULL;
		}
		$this->Criptosporidiasis_cronica->ViewCustomAttributes = "";

		// Criptococosis_Extrapulmonar
		if (strval($this->Criptococosis_Extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Criptococosis_Extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Criptococosis_Extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Criptococosis_Extrapulmonar->ViewValue = $this->Criptococosis_Extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Criptococosis_Extrapulmonar->ViewValue = $this->Criptococosis_Extrapulmonar->CurrentValue;
			}
		} else {
			$this->Criptococosis_Extrapulmonar->ViewValue = NULL;
		}
		$this->Criptococosis_Extrapulmonar->ViewCustomAttributes = "";

		// Sarcoma_Kaposi
		if (strval($this->Sarcoma_Kaposi->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Sarcoma_Kaposi->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sarcoma_Kaposi, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sarcoma_Kaposi->ViewValue = $this->Sarcoma_Kaposi->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sarcoma_Kaposi->ViewValue = $this->Sarcoma_Kaposi->CurrentValue;
			}
		} else {
			$this->Sarcoma_Kaposi->ViewValue = NULL;
		}
		$this->Sarcoma_Kaposi->ViewCustomAttributes = "";

		// Leucoencefalopatia_Multifocal
		if (strval($this->Leucoencefalopatia_Multifocal->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Leucoencefalopatia_Multifocal->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Leucoencefalopatia_Multifocal, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Leucoencefalopatia_Multifocal->ViewValue = $this->Leucoencefalopatia_Multifocal->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Leucoencefalopatia_Multifocal->ViewValue = $this->Leucoencefalopatia_Multifocal->CurrentValue;
			}
		} else {
			$this->Leucoencefalopatia_Multifocal->ViewValue = NULL;
		}
		$this->Leucoencefalopatia_Multifocal->ViewCustomAttributes = "";

		// Septicemia_recurrente
		if (strval($this->Septicemia_recurrente->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Septicemia_recurrente->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Septicemia_recurrente, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Septicemia_recurrente->ViewValue = $this->Septicemia_recurrente->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Septicemia_recurrente->ViewValue = $this->Septicemia_recurrente->CurrentValue;
			}
		} else {
			$this->Septicemia_recurrente->ViewValue = NULL;
		}
		$this->Septicemia_recurrente->ViewCustomAttributes = "";

		// Toxoplasmosis_cerebral
		if (strval($this->Toxoplasmosis_cerebral->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Toxoplasmosis_cerebral->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Toxoplasmosis_cerebral, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Toxoplasmosis_cerebral->ViewValue = $this->Toxoplasmosis_cerebral->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Toxoplasmosis_cerebral->ViewValue = $this->Toxoplasmosis_cerebral->CurrentValue;
			}
		} else {
			$this->Toxoplasmosis_cerebral->ViewValue = NULL;
		}
		$this->Toxoplasmosis_cerebral->ViewCustomAttributes = "";

		// HepatitisB
		if (strval($this->HepatitisB->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->HepatitisB->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->HepatitisB, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->HepatitisB->ViewValue = $this->HepatitisB->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->HepatitisB->ViewValue = $this->HepatitisB->CurrentValue;
			}
		} else {
			$this->HepatitisB->ViewValue = NULL;
		}
		$this->HepatitisB->ViewCustomAttributes = "";

		// HepatitisC
		if (strval($this->HepatitisC->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->HepatitisC->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->HepatitisC, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->HepatitisC->ViewValue = $this->HepatitisC->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->HepatitisC->ViewValue = $this->HepatitisC->CurrentValue;
			}
		} else {
			$this->HepatitisC->ViewValue = NULL;
		}
		$this->HepatitisC->ViewCustomAttributes = "";

		// Meningitis
		if (strval($this->Meningitis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Meningitis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Meningitis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Meningitis->ViewValue = $this->Meningitis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Meningitis->ViewValue = $this->Meningitis->CurrentValue;
			}
		} else {
			$this->Meningitis->ViewValue = NULL;
		}
		$this->Meningitis->ViewCustomAttributes = "";

		// RecuentoCD4
		if (strval($this->RecuentoCD4->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->RecuentoCD4->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->RecuentoCD4, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->RecuentoCD4->ViewValue = $this->RecuentoCD4->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->RecuentoCD4->ViewValue = $this->RecuentoCD4->CurrentValue;
			}
		} else {
			$this->RecuentoCD4->ViewValue = NULL;
		}
		$this->RecuentoCD4->ViewCustomAttributes = "";

		// Registrado_Por
		$this->Registrado_Por->ViewValue = $this->Registrado_Por->CurrentValue;
		$this->Registrado_Por->ViewCustomAttributes = "";

		// Localidad_residencia
		if (strval($this->Localidad_residencia->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Localidad_residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `localidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Localidad_residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Localidad_residencia->ViewValue = $this->Localidad_residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Localidad_residencia->ViewValue = $this->Localidad_residencia->CurrentValue;
			}
		} else {
			$this->Localidad_residencia->ViewValue = NULL;
		}
		$this->Localidad_residencia->ViewCustomAttributes = "";

		// Barrio_residencia
		if (strval($this->Barrio_residencia->CurrentValue) <> "") {
			$sFilterWrk = "`cod_barrio_vereda`" . ew_SearchString("=", $this->Barrio_residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `cod_barrio_vereda`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrios_veredas`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Barrio_residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Barrio_residencia->ViewValue = $this->Barrio_residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Barrio_residencia->ViewValue = $this->Barrio_residencia->CurrentValue;
			}
		} else {
			$this->Barrio_residencia->ViewValue = NULL;
		}
		$this->Barrio_residencia->ViewCustomAttributes = "";

		// Fecha_ingreso_app
		$this->Fecha_ingreso_app->ViewValue = $this->Fecha_ingreso_app->CurrentValue;
		$this->Fecha_ingreso_app->ViewValue = ew_FormatDateTime($this->Fecha_ingreso_app->ViewValue, 5);
		$this->Fecha_ingreso_app->ViewCustomAttributes = "";

		// Actualizado_por
		$this->Actualizado_por->ViewValue = $this->Actualizado_por->CurrentValue;
		$this->Actualizado_por->ViewCustomAttributes = "";

		// Fecha_actualizacion_app
		$this->Fecha_actualizacion_app->ViewValue = $this->Fecha_actualizacion_app->CurrentValue;
		$this->Fecha_actualizacion_app->ViewValue = ew_FormatDateTime($this->Fecha_actualizacion_app->ViewValue, 5);
		$this->Fecha_actualizacion_app->ViewCustomAttributes = "";

			// Seguimiento
			$this->Seguimiento->LinkCustomAttributes = "";
			$this->Seguimiento->HrefValue = "";
			$this->Seguimiento->TooltipValue = "";

			// Condicion_Final
			$this->Condicion_Final->LinkCustomAttributes = "";
			$this->Condicion_Final->HrefValue = "";
			$this->Condicion_Final->TooltipValue = "";

			// Codigo_centro
			$this->Codigo_centro->LinkCustomAttributes = "";
			$this->Codigo_centro->HrefValue = "";
			$this->Codigo_centro->TooltipValue = "";

			// Codigo_UPGD
			$this->Codigo_UPGD->LinkCustomAttributes = "";
			$this->Codigo_UPGD->HrefValue = "";
			$this->Codigo_UPGD->TooltipValue = "";

			// Embarazo_Actual
			$this->Embarazo_Actual->LinkCustomAttributes = "";
			$this->Embarazo_Actual->HrefValue = "";
			$this->Embarazo_Actual->TooltipValue = "";

			// Fecha_Notificacion
			$this->Fecha_Notificacion->LinkCustomAttributes = "";
			$this->Fecha_Notificacion->HrefValue = "";
			$this->Fecha_Notificacion->TooltipValue = "";

			// Primer_Nombre
			$this->Primer_Nombre->LinkCustomAttributes = "";
			$this->Primer_Nombre->HrefValue = "";
			$this->Primer_Nombre->TooltipValue = "";

			// Segundo_Nombre
			$this->Segundo_Nombre->LinkCustomAttributes = "";
			$this->Segundo_Nombre->HrefValue = "";
			$this->Segundo_Nombre->TooltipValue = "";

			// Primer_Apellido
			$this->Primer_Apellido->LinkCustomAttributes = "";
			$this->Primer_Apellido->HrefValue = "";
			$this->Primer_Apellido->TooltipValue = "";

			// Numero_Identificacion
			$this->Numero_Identificacion->LinkCustomAttributes = "";
			$this->Numero_Identificacion->HrefValue = "";
			$this->Numero_Identificacion->TooltipValue = "";

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->LinkCustomAttributes = "";
			$this->Tipo_Regimen_Salud->HrefValue = "";
			$this->Tipo_Regimen_Salud->TooltipValue = "";

			// Cod_Administradora
			$this->Cod_Administradora->LinkCustomAttributes = "";
			$this->Cod_Administradora->HrefValue = "";
			$this->Cod_Administradora->TooltipValue = "";

			// Hospitalizado
			$this->Hospitalizado->LinkCustomAttributes = "";
			$this->Hospitalizado->HrefValue = "";
			$this->Hospitalizado->TooltipValue = "";

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->LinkCustomAttributes = "";
			$this->Mecanismo_Probable_Transmision->HrefValue = "";
			$this->Mecanismo_Probable_Transmision->TooltipValue = "";

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->LinkCustomAttributes = "";
			$this->Estado_Clinico_Notificacion->HrefValue = "";
			$this->Estado_Clinico_Notificacion->TooltipValue = "";

			// Registrado_Por
			$this->Registrado_Por->LinkCustomAttributes = "";
			$this->Registrado_Por->HrefValue = "";
			$this->Registrado_Por->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	//
	// Delete records based on current filter
	//
	function DeleteRows() {
		global $Language, $Security;
		if (!$Security->CanDelete()) {
			$this->setFailureMessage($Language->Phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$DeleteRows = TRUE;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
			$rs->Close();
			return FALSE;

		//} else {
		//	$this->LoadRowValues($rs); // Load row values

		}
		$rows = ($rs) ? $rs->GetRows() : array();
		$conn->BeginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $this->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= $GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"];
				$sThisKey .= $row['Consecutivo'];
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				$DeleteRows = $this->Delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		} else {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("DeleteCancelled"));
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}
		return $DeleteRows;
	}

	// Show link optionally based on User ID
	function ShowOptionLink($id = "") {
		global $Security;
		if ($Security->IsLoggedIn() && !$Security->IsAdmin() && !$this->UserIDAllow($id))
			return $Security->IsValidUserID($this->Codigo_centro->CurrentValue);
		return TRUE;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("registrolist.php"), "", $this->TableVar, TRUE);
		$PageId = "delete";
		$Breadcrumb->Add("delete", $PageId, $url);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($registro_delete)) $registro_delete = new cregistro_delete();

// Page init
$registro_delete->Page_Init();

// Page main
$registro_delete->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$registro_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "delete";
var CurrentForm = fregistrodelete = new ew_Form("fregistrodelete", "delete");

// Form_CustomValidate event
fregistrodelete.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fregistrodelete.ValidateRequired = true;
<?php } else { ?>
fregistrodelete.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fregistrodelete.Lists["x_Seguimiento"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Condicion_Final"] = {"LinkField":"x_No_Condicion_Final","Ajax":true,"AutoFill":false,"DisplayFields":["x_Condicion_Final","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Codigo_centro"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Upgd","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Codigo_UPGD"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Upgd","x_Upgd","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Embarazo_Actual"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Tipo_Regimen_Salud"] = {"LinkField":"x_Codigo_Regimen","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Regimen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Cod_Administradora"] = {"LinkField":"x_Codigo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo","x_Administradora_Salud","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Hospitalizado[]"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Mecanismo_Probable_Transmision"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Mecanismo_Probable","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrodelete.Lists["x_Estado_Clinico_Notificacion"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Estado_Clinico","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php $registro_delete->ShowPageHeader(); ?>
<?php
$registro_delete->ShowMessage();
?>
<form name="fregistrodelete" id="fregistrodelete" class="form-inline ewForm ewDeleteForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($registro_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $registro_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="registro">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($registro_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($EW_COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo ew_HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="ewGrid">
<div class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<table class="table ewTable">
<?php echo $registro->TableCustomInnerHtml ?>
	<thead>
	<tr class="ewTableHeader">
<?php if ($registro->Seguimiento->Visible) { // Seguimiento ?>
		<th><span id="elh_registro_Seguimiento" class="registro_Seguimiento"><?php echo $registro->Seguimiento->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Condicion_Final->Visible) { // Condicion_Final ?>
		<th><span id="elh_registro_Condicion_Final" class="registro_Condicion_Final"><?php echo $registro->Condicion_Final->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Codigo_centro->Visible) { // Codigo_centro ?>
		<th><span id="elh_registro_Codigo_centro" class="registro_Codigo_centro"><?php echo $registro->Codigo_centro->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Codigo_UPGD->Visible) { // Codigo_UPGD ?>
		<th><span id="elh_registro_Codigo_UPGD" class="registro_Codigo_UPGD"><?php echo $registro->Codigo_UPGD->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Embarazo_Actual->Visible) { // Embarazo_Actual ?>
		<th><span id="elh_registro_Embarazo_Actual" class="registro_Embarazo_Actual"><?php echo $registro->Embarazo_Actual->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Fecha_Notificacion->Visible) { // Fecha_Notificacion ?>
		<th><span id="elh_registro_Fecha_Notificacion" class="registro_Fecha_Notificacion"><?php echo $registro->Fecha_Notificacion->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Primer_Nombre->Visible) { // Primer_Nombre ?>
		<th><span id="elh_registro_Primer_Nombre" class="registro_Primer_Nombre"><?php echo $registro->Primer_Nombre->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Segundo_Nombre->Visible) { // Segundo_Nombre ?>
		<th><span id="elh_registro_Segundo_Nombre" class="registro_Segundo_Nombre"><?php echo $registro->Segundo_Nombre->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Primer_Apellido->Visible) { // Primer_Apellido ?>
		<th><span id="elh_registro_Primer_Apellido" class="registro_Primer_Apellido"><?php echo $registro->Primer_Apellido->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Numero_Identificacion->Visible) { // Numero_Identificacion ?>
		<th><span id="elh_registro_Numero_Identificacion" class="registro_Numero_Identificacion"><?php echo $registro->Numero_Identificacion->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
		<th><span id="elh_registro_Tipo_Regimen_Salud" class="registro_Tipo_Regimen_Salud"><?php echo $registro->Tipo_Regimen_Salud->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Cod_Administradora->Visible) { // Cod_Administradora ?>
		<th><span id="elh_registro_Cod_Administradora" class="registro_Cod_Administradora"><?php echo $registro->Cod_Administradora->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Hospitalizado->Visible) { // Hospitalizado ?>
		<th><span id="elh_registro_Hospitalizado" class="registro_Hospitalizado"><?php echo $registro->Hospitalizado->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Mecanismo_Probable_Transmision->Visible) { // Mecanismo_Probable_Transmision ?>
		<th><span id="elh_registro_Mecanismo_Probable_Transmision" class="registro_Mecanismo_Probable_Transmision"><?php echo $registro->Mecanismo_Probable_Transmision->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Estado_Clinico_Notificacion->Visible) { // Estado_Clinico_Notificacion ?>
		<th><span id="elh_registro_Estado_Clinico_Notificacion" class="registro_Estado_Clinico_Notificacion"><?php echo $registro->Estado_Clinico_Notificacion->FldCaption() ?></span></th>
<?php } ?>
<?php if ($registro->Registrado_Por->Visible) { // Registrado_Por ?>
		<th><span id="elh_registro_Registrado_Por" class="registro_Registrado_Por"><?php echo $registro->Registrado_Por->FldCaption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$registro_delete->RecCnt = 0;
$i = 0;
while (!$registro_delete->Recordset->EOF) {
	$registro_delete->RecCnt++;
	$registro_delete->RowCnt++;

	// Set row properties
	$registro->ResetAttrs();
	$registro->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$registro_delete->LoadRowValues($registro_delete->Recordset);

	// Render row
	$registro_delete->RenderRow();
?>
	<tr<?php echo $registro->RowAttributes() ?>>
<?php if ($registro->Seguimiento->Visible) { // Seguimiento ?>
		<td<?php echo $registro->Seguimiento->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Seguimiento" class="registro_Seguimiento">
<span<?php echo $registro->Seguimiento->ViewAttributes() ?>>
<?php echo $registro->Seguimiento->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Condicion_Final->Visible) { // Condicion_Final ?>
		<td<?php echo $registro->Condicion_Final->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Condicion_Final" class="registro_Condicion_Final">
<span<?php echo $registro->Condicion_Final->ViewAttributes() ?>>
<?php echo $registro->Condicion_Final->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Codigo_centro->Visible) { // Codigo_centro ?>
		<td<?php echo $registro->Codigo_centro->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Codigo_centro" class="registro_Codigo_centro">
<span<?php echo $registro->Codigo_centro->ViewAttributes() ?>>
<?php echo $registro->Codigo_centro->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Codigo_UPGD->Visible) { // Codigo_UPGD ?>
		<td<?php echo $registro->Codigo_UPGD->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Codigo_UPGD" class="registro_Codigo_UPGD">
<span<?php echo $registro->Codigo_UPGD->ViewAttributes() ?>>
<?php echo $registro->Codigo_UPGD->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Embarazo_Actual->Visible) { // Embarazo_Actual ?>
		<td<?php echo $registro->Embarazo_Actual->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Embarazo_Actual" class="registro_Embarazo_Actual">
<span<?php echo $registro->Embarazo_Actual->ViewAttributes() ?>>
<?php echo $registro->Embarazo_Actual->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Fecha_Notificacion->Visible) { // Fecha_Notificacion ?>
		<td<?php echo $registro->Fecha_Notificacion->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Fecha_Notificacion" class="registro_Fecha_Notificacion">
<span<?php echo $registro->Fecha_Notificacion->ViewAttributes() ?>>
<?php echo $registro->Fecha_Notificacion->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Primer_Nombre->Visible) { // Primer_Nombre ?>
		<td<?php echo $registro->Primer_Nombre->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Primer_Nombre" class="registro_Primer_Nombre">
<span<?php echo $registro->Primer_Nombre->ViewAttributes() ?>>
<?php echo $registro->Primer_Nombre->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Segundo_Nombre->Visible) { // Segundo_Nombre ?>
		<td<?php echo $registro->Segundo_Nombre->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Segundo_Nombre" class="registro_Segundo_Nombre">
<span<?php echo $registro->Segundo_Nombre->ViewAttributes() ?>>
<?php echo $registro->Segundo_Nombre->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Primer_Apellido->Visible) { // Primer_Apellido ?>
		<td<?php echo $registro->Primer_Apellido->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Primer_Apellido" class="registro_Primer_Apellido">
<span<?php echo $registro->Primer_Apellido->ViewAttributes() ?>>
<?php echo $registro->Primer_Apellido->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Numero_Identificacion->Visible) { // Numero_Identificacion ?>
		<td<?php echo $registro->Numero_Identificacion->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Numero_Identificacion" class="registro_Numero_Identificacion">
<span<?php echo $registro->Numero_Identificacion->ViewAttributes() ?>>
<?php echo $registro->Numero_Identificacion->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
		<td<?php echo $registro->Tipo_Regimen_Salud->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Tipo_Regimen_Salud" class="registro_Tipo_Regimen_Salud">
<span<?php echo $registro->Tipo_Regimen_Salud->ViewAttributes() ?>>
<?php echo $registro->Tipo_Regimen_Salud->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Cod_Administradora->Visible) { // Cod_Administradora ?>
		<td<?php echo $registro->Cod_Administradora->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Cod_Administradora" class="registro_Cod_Administradora">
<span<?php echo $registro->Cod_Administradora->ViewAttributes() ?>>
<?php echo $registro->Cod_Administradora->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Hospitalizado->Visible) { // Hospitalizado ?>
		<td<?php echo $registro->Hospitalizado->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Hospitalizado" class="registro_Hospitalizado">
<span<?php echo $registro->Hospitalizado->ViewAttributes() ?>>
<?php echo $registro->Hospitalizado->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Mecanismo_Probable_Transmision->Visible) { // Mecanismo_Probable_Transmision ?>
		<td<?php echo $registro->Mecanismo_Probable_Transmision->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Mecanismo_Probable_Transmision" class="registro_Mecanismo_Probable_Transmision">
<span<?php echo $registro->Mecanismo_Probable_Transmision->ViewAttributes() ?>>
<?php echo $registro->Mecanismo_Probable_Transmision->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Estado_Clinico_Notificacion->Visible) { // Estado_Clinico_Notificacion ?>
		<td<?php echo $registro->Estado_Clinico_Notificacion->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Estado_Clinico_Notificacion" class="registro_Estado_Clinico_Notificacion">
<span<?php echo $registro->Estado_Clinico_Notificacion->ViewAttributes() ?>>
<?php echo $registro->Estado_Clinico_Notificacion->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($registro->Registrado_Por->Visible) { // Registrado_Por ?>
		<td<?php echo $registro->Registrado_Por->CellAttributes() ?>>
<span id="el<?php echo $registro_delete->RowCnt ?>_registro_Registrado_Por" class="registro_Registrado_Por">
<span<?php echo $registro->Registrado_Por->ViewAttributes() ?>>
<?php echo $registro->Registrado_Por->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$registro_delete->Recordset->MoveNext();
}
$registro_delete->Recordset->Close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("DeleteBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $registro_delete->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
</div>
</form>
<script type="text/javascript">
fregistrodelete.Init();
</script>
<?php
$registro_delete->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$registro_delete->Page_Terminate();
?>
