<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "registroinfo.php" ?>
<?php include_once "ficha_usuarioinfo.php" ?>
<?php include_once "seguimiento_individual3gridcls.php" ?>
<?php include_once "seguimiento_maternogridcls.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$registro_list = NULL; // Initialize page object first

class cregistro_list extends cregistro {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{43FC4B6C-8131-46B1-916C-14DB52B1691D}";

	// Table name
	var $TableName = 'registro';

	// Page object name
	var $PageObjName = 'registro_list';

	// Grid form hidden field names
	var $FormName = 'fregistrolist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (registro)
		if (!isset($GLOBALS["registro"]) || get_class($GLOBALS["registro"]) == "cregistro") {
			$GLOBALS["registro"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["registro"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "registroadd.php?" . EW_TABLE_SHOW_DETAIL . "=";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "registrodelete.php";
		$this->MultiUpdateUrl = "registroupdate.php";

		// Table object (ficha_usuario)
		if (!isset($GLOBALS['ficha_usuario'])) $GLOBALS['ficha_usuario'] = new cficha_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'registro', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (ficha_usuario)
		if (!isset($UserTable)) {
			$UserTable = new cficha_usuario();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fregistrolistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}
		if ($Security->IsLoggedIn()) {
			$Security->UserID_Loading();
			$Security->LoadUserID();
			$Security->UserID_Loaded();
			if (strval($Security->CurrentUserID()) == "") {
				$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
				$this->Page_Terminate();
			}
		}

		// Get export parameters
		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->Registrado_Por->Visible = !$this->IsAddOrEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {

			// Process auto fill for detail table 'seguimiento_individual3'
			if (@$_POST["grid"] == "fseguimiento_individual3grid") {
				if (!isset($GLOBALS["seguimiento_individual3_grid"])) $GLOBALS["seguimiento_individual3_grid"] = new cseguimiento_individual3_grid;
				$GLOBALS["seguimiento_individual3_grid"]->Page_Init();
				$this->Page_Terminate();
				exit();
			}

			// Process auto fill for detail table 'seguimiento_materno'
			if (@$_POST["grid"] == "fseguimiento_maternogrid") {
				if (!isset($GLOBALS["seguimiento_materno_grid"])) $GLOBALS["seguimiento_materno_grid"] = new cseguimiento_materno_grid;
				$GLOBALS["seguimiento_materno_grid"]->Page_Init();
				$this->Page_Terminate();
				exit();
			}
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $registro;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($registro);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $seguimiento_individual3_Count;
	var $seguimiento_materno_Count;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Set up records per page
			$this->SetUpDisplayRecs();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Restore filter list
			$this->RestoreFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Set up number of records displayed per page
	function SetUpDisplayRecs() {
		$sWrk = @$_GET[EW_TABLE_REC_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayRecs = intval($sWrk);
			} else {
				if (strtolower($sWrk) == "all") { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->Consecutivo->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->Consecutivo->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Consecutivo->AdvancedSearch->ToJSON(), ","); // Field Consecutivo
		$sFilterList = ew_Concat($sFilterList, $this->Seguimiento->AdvancedSearch->ToJSON(), ","); // Field Seguimiento
		$sFilterList = ew_Concat($sFilterList, $this->Condicion_Final->AdvancedSearch->ToJSON(), ","); // Field Condicion_Final
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_centro->AdvancedSearch->ToJSON(), ","); // Field Codigo_centro
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_UPGD->AdvancedSearch->ToJSON(), ","); // Field Codigo_UPGD
		$sFilterList = ew_Concat($sFilterList, $this->Cod_Evento->AdvancedSearch->ToJSON(), ","); // Field Cod_Evento
		$sFilterList = ew_Concat($sFilterList, $this->Embarazo_Actual->AdvancedSearch->ToJSON(), ","); // Field Embarazo_Actual
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Notificacion->AdvancedSearch->ToJSON(), ","); // Field Fecha_Notificacion
		$sFilterList = ew_Concat($sFilterList, $this->Semana->AdvancedSearch->ToJSON(), ","); // Field Semana
		$sFilterList = ew_Concat($sFilterList, $this->Periodo_Epidemiologico->AdvancedSearch->ToJSON(), ","); // Field Periodo_Epidemiologico
		$sFilterList = ew_Concat($sFilterList, $this->Periodo_Sivigila->AdvancedSearch->ToJSON(), ","); // Field Periodo_Sivigila
		$sFilterList = ew_Concat($sFilterList, $this->Primer_Nombre->AdvancedSearch->ToJSON(), ","); // Field Primer_Nombre
		$sFilterList = ew_Concat($sFilterList, $this->Segundo_Nombre->AdvancedSearch->ToJSON(), ","); // Field Segundo_Nombre
		$sFilterList = ew_Concat($sFilterList, $this->Primer_Apellido->AdvancedSearch->ToJSON(), ","); // Field Primer_Apellido
		$sFilterList = ew_Concat($sFilterList, $this->Segundo_Apellido->AdvancedSearch->ToJSON(), ","); // Field Segundo_Apellido
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_Id->AdvancedSearch->ToJSON(), ","); // Field Tipo_Id
		$sFilterList = ew_Concat($sFilterList, $this->Numero_Identificacion->AdvancedSearch->ToJSON(), ","); // Field Numero_Identificacion
		$sFilterList = ew_Concat($sFilterList, $this->Edad->AdvancedSearch->ToJSON(), ","); // Field Edad
		$sFilterList = ew_Concat($sFilterList, $this->Unidad_Edad->AdvancedSearch->ToJSON(), ","); // Field Unidad_Edad
		$sFilterList = ew_Concat($sFilterList, $this->Sexo->AdvancedSearch->ToJSON(), ","); // Field Sexo
		$sFilterList = ew_Concat($sFilterList, $this->Pais_Ocurrencia->AdvancedSearch->ToJSON(), ","); // Field Pais_Ocurrencia
		$sFilterList = ew_Concat($sFilterList, $this->Depto_Ocurrencia->AdvancedSearch->ToJSON(), ","); // Field Depto_Ocurrencia
		$sFilterList = ew_Concat($sFilterList, $this->Municipio_Ocurrencia->AdvancedSearch->ToJSON(), ","); // Field Municipio_Ocurrencia
		$sFilterList = ew_Concat($sFilterList, $this->Area_Ocurrencia->AdvancedSearch->ToJSON(), ","); // Field Area_Ocurrencia
		$sFilterList = ew_Concat($sFilterList, $this->Localidad->AdvancedSearch->ToJSON(), ","); // Field Localidad
		$sFilterList = ew_Concat($sFilterList, $this->Barrio->AdvancedSearch->ToJSON(), ","); // Field Barrio
		$sFilterList = ew_Concat($sFilterList, $this->Direccion_Residencia->AdvancedSearch->ToJSON(), ","); // Field Direccion_Residencia
		$sFilterList = ew_Concat($sFilterList, $this->Ocupacion->AdvancedSearch->ToJSON(), ","); // Field Ocupacion
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_Regimen_Salud->AdvancedSearch->ToJSON(), ","); // Field Tipo_Regimen_Salud
		$sFilterList = ew_Concat($sFilterList, $this->Cod_Administradora->AdvancedSearch->ToJSON(), ","); // Field Cod_Administradora
		$sFilterList = ew_Concat($sFilterList, $this->gp_discapa->AdvancedSearch->ToJSON(), ","); // Field gp_discapa
		$sFilterList = ew_Concat($sFilterList, $this->gp_desplaz->AdvancedSearch->ToJSON(), ","); // Field gp_desplaz
		$sFilterList = ew_Concat($sFilterList, $this->gp_migrant->AdvancedSearch->ToJSON(), ","); // Field gp_migrant
		$sFilterList = ew_Concat($sFilterList, $this->gp_carcela->AdvancedSearch->ToJSON(), ","); // Field gp_carcela
		$sFilterList = ew_Concat($sFilterList, $this->gp_gestan->AdvancedSearch->ToJSON(), ","); // Field gp_gestan
		$sFilterList = ew_Concat($sFilterList, $this->gp_indigen->AdvancedSearch->ToJSON(), ","); // Field gp_indigen
		$sFilterList = ew_Concat($sFilterList, $this->gp_pobicbf->AdvancedSearch->ToJSON(), ","); // Field gp_pobicbf
		$sFilterList = ew_Concat($sFilterList, $this->gp_mad_com->AdvancedSearch->ToJSON(), ","); // Field gp_mad_com
		$sFilterList = ew_Concat($sFilterList, $this->gp_desmovi->AdvancedSearch->ToJSON(), ","); // Field gp_desmovi
		$sFilterList = ew_Concat($sFilterList, $this->gp_psiquia->AdvancedSearch->ToJSON(), ","); // Field gp_psiquia
		$sFilterList = ew_Concat($sFilterList, $this->gp_vic_vio->AdvancedSearch->ToJSON(), ","); // Field gp_vic_vio
		$sFilterList = ew_Concat($sFilterList, $this->gp_otros->AdvancedSearch->ToJSON(), ","); // Field gp_otros
		$sFilterList = ew_Concat($sFilterList, $this->Depto_Residencia->AdvancedSearch->ToJSON(), ","); // Field Depto_Residencia
		$sFilterList = ew_Concat($sFilterList, $this->Municipio_Residencia->AdvancedSearch->ToJSON(), ","); // Field Municipio_Residencia
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Consulta->AdvancedSearch->ToJSON(), ","); // Field Fecha_Consulta
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Inicio_Sintomas->AdvancedSearch->ToJSON(), ","); // Field Fecha_Inicio_Sintomas
		$sFilterList = ew_Concat($sFilterList, $this->Hospitalizado->AdvancedSearch->ToJSON(), ","); // Field Hospitalizado
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Defuncion->AdvancedSearch->ToJSON(), ","); // Field Fecha_Defuncion
		$sFilterList = ew_Concat($sFilterList, $this->Numero_Certificado_Defuncion->AdvancedSearch->ToJSON(), ","); // Field Numero_Certificado_Defuncion
		$sFilterList = ew_Concat($sFilterList, $this->Causa_Basica_Muerte_CIEX->AdvancedSearch->ToJSON(), ","); // Field Causa_Basica_Muerte_CIEX
		$sFilterList = ew_Concat($sFilterList, $this->Entidad_fallecimiento->AdvancedSearch->ToJSON(), ","); // Field Entidad_fallecimiento
		$sFilterList = ew_Concat($sFilterList, $this->Telefono->AdvancedSearch->ToJSON(), ","); // Field Telefono
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Nacimiento->AdvancedSearch->ToJSON(), ","); // Field Fecha_Nacimiento
		$sFilterList = ew_Concat($sFilterList, $this->Nombre_Profesional_Diligencia->AdvancedSearch->ToJSON(), ","); // Field Nombre_Profesional_Diligencia
		$sFilterList = ew_Concat($sFilterList, $this->Telefono_Profesional_Diligencia->AdvancedSearch->ToJSON(), ","); // Field Telefono_Profesional_Diligencia
		$sFilterList = ew_Concat($sFilterList, $this->Mecanismo_Probable_Transmision->AdvancedSearch->ToJSON(), ","); // Field Mecanismo_Probable_Transmision
		$sFilterList = ew_Concat($sFilterList, $this->Nombre_Madre->AdvancedSearch->ToJSON(), ","); // Field Nombre_Madre
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_Id_Madre->AdvancedSearch->ToJSON(), ","); // Field Tipo_Id_Madre
		$sFilterList = ew_Concat($sFilterList, $this->Numero_Identificacion_Madre->AdvancedSearch->ToJSON(), ","); // Field Numero_Identificacion_Madre
		$sFilterList = ew_Concat($sFilterList, $this->Indentidad_Genero->AdvancedSearch->ToJSON(), ","); // Field Indentidad_Genero
		$sFilterList = ew_Concat($sFilterList, $this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->ToJSON(), ","); // Field Donador_Sangre_Ultimos_12_Meses
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Donacion->AdvancedSearch->ToJSON(), ","); // Field Fecha_Donacion
		$sFilterList = ew_Concat($sFilterList, $this->Nombre_Institucion_Donacion->AdvancedSearch->ToJSON(), ","); // Field Nombre_Institucion_Donacion
		$sFilterList = ew_Concat($sFilterList, $this->Poblacion_clave->AdvancedSearch->ToJSON(), ","); // Field Poblacion_clave
		$sFilterList = ew_Concat($sFilterList, $this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->ToJSON(), ","); // Field Recibio_Asesoria_Pre_Prueba
		$sFilterList = ew_Concat($sFilterList, $this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->ToJSON(), ","); // Field Recibio_Asesoria_Post_Prueba
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_Prueba->AdvancedSearch->ToJSON(), ","); // Field Tipo_Prueba
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Resultado_Confirmatorio->AdvancedSearch->ToJSON(), ","); // Field Fecha_Resultado_Confirmatorio
		$sFilterList = ew_Concat($sFilterList, $this->Valor_Carga_Viral->AdvancedSearch->ToJSON(), ","); // Field Valor_Carga_Viral
		$sFilterList = ew_Concat($sFilterList, $this->Estado_Clinico_Notificacion->AdvancedSearch->ToJSON(), ","); // Field Estado_Clinico_Notificacion
		$sFilterList = ew_Concat($sFilterList, $this->Hijos_Mujeres_Menores_5->AdvancedSearch->ToJSON(), ","); // Field Hijos_Mujeres_Menores_5
		$sFilterList = ew_Concat($sFilterList, $this->Hijos_Hombres_Menores_5->AdvancedSearch->ToJSON(), ","); // Field Hijos_Hombres_Menores_5
		$sFilterList = ew_Concat($sFilterList, $this->Numero_Semanas_Embarazo->AdvancedSearch->ToJSON(), ","); // Field Numero_Semanas_Embarazo
		$sFilterList = ew_Concat($sFilterList, $this->Antecedentes_Embarazo->AdvancedSearch->ToJSON(), ","); // Field Antecedentes_Embarazo
		$sFilterList = ew_Concat($sFilterList, $this->Candidiasis_esofagica->AdvancedSearch->ToJSON(), ","); // Field Candidiasis_esofagica
		$sFilterList = ew_Concat($sFilterList, $this->Candidiasis_vias_aereas->AdvancedSearch->ToJSON(), ","); // Field Candidiasis_vias_aereas
		$sFilterList = ew_Concat($sFilterList, $this->Tuberculosis_pulmonar->AdvancedSearch->ToJSON(), ","); // Field Tuberculosis_pulmonar
		$sFilterList = ew_Concat($sFilterList, $this->Cancer_cervical->AdvancedSearch->ToJSON(), ","); // Field Cancer_cervical
		$sFilterList = ew_Concat($sFilterList, $this->Tuberculosis_extrapulmonar->AdvancedSearch->ToJSON(), ","); // Field Tuberculosis_extrapulmonar
		$sFilterList = ew_Concat($sFilterList, $this->Coccidiomicosis->AdvancedSearch->ToJSON(), ","); // Field Coccidiomicosis
		$sFilterList = ew_Concat($sFilterList, $this->Citomegalovirosis->AdvancedSearch->ToJSON(), ","); // Field Citomegalovirosis
		$sFilterList = ew_Concat($sFilterList, $this->Retinitis_citomegalovirosis->AdvancedSearch->ToJSON(), ","); // Field Retinitis_citomegalovirosis
		$sFilterList = ew_Concat($sFilterList, $this->Sindrome_Emanciacion->AdvancedSearch->ToJSON(), ","); // Field Sindrome_Emanciacion
		$sFilterList = ew_Concat($sFilterList, $this->Encefalopatia->AdvancedSearch->ToJSON(), ","); // Field Encefalopatia
		$sFilterList = ew_Concat($sFilterList, $this->Otras_micobacterias->AdvancedSearch->ToJSON(), ","); // Field Otras_micobacterias
		$sFilterList = ew_Concat($sFilterList, $this->Histoplasmosis_Extrapulmonar->AdvancedSearch->ToJSON(), ","); // Field Histoplasmosis_Extrapulmonar
		$sFilterList = ew_Concat($sFilterList, $this->isosporidiasis_cronica->AdvancedSearch->ToJSON(), ","); // Field isosporidiasis_cronica
		$sFilterList = ew_Concat($sFilterList, $this->herpes_zoster->AdvancedSearch->ToJSON(), ","); // Field herpes_zoster
		$sFilterList = ew_Concat($sFilterList, $this->Histoplasmosis_diseminada->AdvancedSearch->ToJSON(), ","); // Field Histoplasmosis_diseminada
		$sFilterList = ew_Concat($sFilterList, $this->Linfoma_Burkitt->AdvancedSearch->ToJSON(), ","); // Field Linfoma_Burkitt
		$sFilterList = ew_Concat($sFilterList, $this->Neumonia_Pneumocystis->AdvancedSearch->ToJSON(), ","); // Field Neumonia_Pneumocystis
		$sFilterList = ew_Concat($sFilterList, $this->Neumonia_Recurrente->AdvancedSearch->ToJSON(), ","); // Field Neumonia_Recurrente
		$sFilterList = ew_Concat($sFilterList, $this->Linfoma_Inmunoblastico->AdvancedSearch->ToJSON(), ","); // Field Linfoma_Inmunoblastico
		$sFilterList = ew_Concat($sFilterList, $this->Criptosporidiasis_cronica->AdvancedSearch->ToJSON(), ","); // Field Criptosporidiasis_cronica
		$sFilterList = ew_Concat($sFilterList, $this->Criptococosis_Extrapulmonar->AdvancedSearch->ToJSON(), ","); // Field Criptococosis_Extrapulmonar
		$sFilterList = ew_Concat($sFilterList, $this->Sarcoma_Kaposi->AdvancedSearch->ToJSON(), ","); // Field Sarcoma_Kaposi
		$sFilterList = ew_Concat($sFilterList, $this->Leucoencefalopatia_Multifocal->AdvancedSearch->ToJSON(), ","); // Field Leucoencefalopatia_Multifocal
		$sFilterList = ew_Concat($sFilterList, $this->Septicemia_recurrente->AdvancedSearch->ToJSON(), ","); // Field Septicemia_recurrente
		$sFilterList = ew_Concat($sFilterList, $this->Toxoplasmosis_cerebral->AdvancedSearch->ToJSON(), ","); // Field Toxoplasmosis_cerebral
		$sFilterList = ew_Concat($sFilterList, $this->HepatitisB->AdvancedSearch->ToJSON(), ","); // Field HepatitisB
		$sFilterList = ew_Concat($sFilterList, $this->HepatitisC->AdvancedSearch->ToJSON(), ","); // Field HepatitisC
		$sFilterList = ew_Concat($sFilterList, $this->Meningitis->AdvancedSearch->ToJSON(), ","); // Field Meningitis
		$sFilterList = ew_Concat($sFilterList, $this->RecuentoCD4->AdvancedSearch->ToJSON(), ","); // Field RecuentoCD4
		$sFilterList = ew_Concat($sFilterList, $this->Registrado_Por->AdvancedSearch->ToJSON(), ","); // Field Registrado_Por
		$sFilterList = ew_Concat($sFilterList, $this->Localidad_residencia->AdvancedSearch->ToJSON(), ","); // Field Localidad_residencia
		$sFilterList = ew_Concat($sFilterList, $this->Barrio_residencia->AdvancedSearch->ToJSON(), ","); // Field Barrio_residencia
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_ingreso_app->AdvancedSearch->ToJSON(), ","); // Field Fecha_ingreso_app
		$sFilterList = ew_Concat($sFilterList, $this->Actualizado_por->AdvancedSearch->ToJSON(), ","); // Field Actualizado_por
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_actualizacion_app->AdvancedSearch->ToJSON(), ","); // Field Fecha_actualizacion_app
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Consecutivo
		$this->Consecutivo->AdvancedSearch->SearchValue = @$filter["x_Consecutivo"];
		$this->Consecutivo->AdvancedSearch->SearchOperator = @$filter["z_Consecutivo"];
		$this->Consecutivo->AdvancedSearch->SearchCondition = @$filter["v_Consecutivo"];
		$this->Consecutivo->AdvancedSearch->SearchValue2 = @$filter["y_Consecutivo"];
		$this->Consecutivo->AdvancedSearch->SearchOperator2 = @$filter["w_Consecutivo"];
		$this->Consecutivo->AdvancedSearch->Save();

		// Field Seguimiento
		$this->Seguimiento->AdvancedSearch->SearchValue = @$filter["x_Seguimiento"];
		$this->Seguimiento->AdvancedSearch->SearchOperator = @$filter["z_Seguimiento"];
		$this->Seguimiento->AdvancedSearch->SearchCondition = @$filter["v_Seguimiento"];
		$this->Seguimiento->AdvancedSearch->SearchValue2 = @$filter["y_Seguimiento"];
		$this->Seguimiento->AdvancedSearch->SearchOperator2 = @$filter["w_Seguimiento"];
		$this->Seguimiento->AdvancedSearch->Save();

		// Field Condicion_Final
		$this->Condicion_Final->AdvancedSearch->SearchValue = @$filter["x_Condicion_Final"];
		$this->Condicion_Final->AdvancedSearch->SearchOperator = @$filter["z_Condicion_Final"];
		$this->Condicion_Final->AdvancedSearch->SearchCondition = @$filter["v_Condicion_Final"];
		$this->Condicion_Final->AdvancedSearch->SearchValue2 = @$filter["y_Condicion_Final"];
		$this->Condicion_Final->AdvancedSearch->SearchOperator2 = @$filter["w_Condicion_Final"];
		$this->Condicion_Final->AdvancedSearch->Save();

		// Field Codigo_centro
		$this->Codigo_centro->AdvancedSearch->SearchValue = @$filter["x_Codigo_centro"];
		$this->Codigo_centro->AdvancedSearch->SearchOperator = @$filter["z_Codigo_centro"];
		$this->Codigo_centro->AdvancedSearch->SearchCondition = @$filter["v_Codigo_centro"];
		$this->Codigo_centro->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_centro"];
		$this->Codigo_centro->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_centro"];
		$this->Codigo_centro->AdvancedSearch->Save();

		// Field Codigo_UPGD
		$this->Codigo_UPGD->AdvancedSearch->SearchValue = @$filter["x_Codigo_UPGD"];
		$this->Codigo_UPGD->AdvancedSearch->SearchOperator = @$filter["z_Codigo_UPGD"];
		$this->Codigo_UPGD->AdvancedSearch->SearchCondition = @$filter["v_Codigo_UPGD"];
		$this->Codigo_UPGD->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_UPGD"];
		$this->Codigo_UPGD->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_UPGD"];
		$this->Codigo_UPGD->AdvancedSearch->Save();

		// Field Cod_Evento
		$this->Cod_Evento->AdvancedSearch->SearchValue = @$filter["x_Cod_Evento"];
		$this->Cod_Evento->AdvancedSearch->SearchOperator = @$filter["z_Cod_Evento"];
		$this->Cod_Evento->AdvancedSearch->SearchCondition = @$filter["v_Cod_Evento"];
		$this->Cod_Evento->AdvancedSearch->SearchValue2 = @$filter["y_Cod_Evento"];
		$this->Cod_Evento->AdvancedSearch->SearchOperator2 = @$filter["w_Cod_Evento"];
		$this->Cod_Evento->AdvancedSearch->Save();

		// Field Embarazo_Actual
		$this->Embarazo_Actual->AdvancedSearch->SearchValue = @$filter["x_Embarazo_Actual"];
		$this->Embarazo_Actual->AdvancedSearch->SearchOperator = @$filter["z_Embarazo_Actual"];
		$this->Embarazo_Actual->AdvancedSearch->SearchCondition = @$filter["v_Embarazo_Actual"];
		$this->Embarazo_Actual->AdvancedSearch->SearchValue2 = @$filter["y_Embarazo_Actual"];
		$this->Embarazo_Actual->AdvancedSearch->SearchOperator2 = @$filter["w_Embarazo_Actual"];
		$this->Embarazo_Actual->AdvancedSearch->Save();

		// Field Fecha_Notificacion
		$this->Fecha_Notificacion->AdvancedSearch->SearchValue = @$filter["x_Fecha_Notificacion"];
		$this->Fecha_Notificacion->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Notificacion"];
		$this->Fecha_Notificacion->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Notificacion"];
		$this->Fecha_Notificacion->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Notificacion"];
		$this->Fecha_Notificacion->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Notificacion"];
		$this->Fecha_Notificacion->AdvancedSearch->Save();

		// Field Semana
		$this->Semana->AdvancedSearch->SearchValue = @$filter["x_Semana"];
		$this->Semana->AdvancedSearch->SearchOperator = @$filter["z_Semana"];
		$this->Semana->AdvancedSearch->SearchCondition = @$filter["v_Semana"];
		$this->Semana->AdvancedSearch->SearchValue2 = @$filter["y_Semana"];
		$this->Semana->AdvancedSearch->SearchOperator2 = @$filter["w_Semana"];
		$this->Semana->AdvancedSearch->Save();

		// Field Periodo_Epidemiologico
		$this->Periodo_Epidemiologico->AdvancedSearch->SearchValue = @$filter["x_Periodo_Epidemiologico"];
		$this->Periodo_Epidemiologico->AdvancedSearch->SearchOperator = @$filter["z_Periodo_Epidemiologico"];
		$this->Periodo_Epidemiologico->AdvancedSearch->SearchCondition = @$filter["v_Periodo_Epidemiologico"];
		$this->Periodo_Epidemiologico->AdvancedSearch->SearchValue2 = @$filter["y_Periodo_Epidemiologico"];
		$this->Periodo_Epidemiologico->AdvancedSearch->SearchOperator2 = @$filter["w_Periodo_Epidemiologico"];
		$this->Periodo_Epidemiologico->AdvancedSearch->Save();

		// Field Periodo_Sivigila
		$this->Periodo_Sivigila->AdvancedSearch->SearchValue = @$filter["x_Periodo_Sivigila"];
		$this->Periodo_Sivigila->AdvancedSearch->SearchOperator = @$filter["z_Periodo_Sivigila"];
		$this->Periodo_Sivigila->AdvancedSearch->SearchCondition = @$filter["v_Periodo_Sivigila"];
		$this->Periodo_Sivigila->AdvancedSearch->SearchValue2 = @$filter["y_Periodo_Sivigila"];
		$this->Periodo_Sivigila->AdvancedSearch->SearchOperator2 = @$filter["w_Periodo_Sivigila"];
		$this->Periodo_Sivigila->AdvancedSearch->Save();

		// Field Primer_Nombre
		$this->Primer_Nombre->AdvancedSearch->SearchValue = @$filter["x_Primer_Nombre"];
		$this->Primer_Nombre->AdvancedSearch->SearchOperator = @$filter["z_Primer_Nombre"];
		$this->Primer_Nombre->AdvancedSearch->SearchCondition = @$filter["v_Primer_Nombre"];
		$this->Primer_Nombre->AdvancedSearch->SearchValue2 = @$filter["y_Primer_Nombre"];
		$this->Primer_Nombre->AdvancedSearch->SearchOperator2 = @$filter["w_Primer_Nombre"];
		$this->Primer_Nombre->AdvancedSearch->Save();

		// Field Segundo_Nombre
		$this->Segundo_Nombre->AdvancedSearch->SearchValue = @$filter["x_Segundo_Nombre"];
		$this->Segundo_Nombre->AdvancedSearch->SearchOperator = @$filter["z_Segundo_Nombre"];
		$this->Segundo_Nombre->AdvancedSearch->SearchCondition = @$filter["v_Segundo_Nombre"];
		$this->Segundo_Nombre->AdvancedSearch->SearchValue2 = @$filter["y_Segundo_Nombre"];
		$this->Segundo_Nombre->AdvancedSearch->SearchOperator2 = @$filter["w_Segundo_Nombre"];
		$this->Segundo_Nombre->AdvancedSearch->Save();

		// Field Primer_Apellido
		$this->Primer_Apellido->AdvancedSearch->SearchValue = @$filter["x_Primer_Apellido"];
		$this->Primer_Apellido->AdvancedSearch->SearchOperator = @$filter["z_Primer_Apellido"];
		$this->Primer_Apellido->AdvancedSearch->SearchCondition = @$filter["v_Primer_Apellido"];
		$this->Primer_Apellido->AdvancedSearch->SearchValue2 = @$filter["y_Primer_Apellido"];
		$this->Primer_Apellido->AdvancedSearch->SearchOperator2 = @$filter["w_Primer_Apellido"];
		$this->Primer_Apellido->AdvancedSearch->Save();

		// Field Segundo_Apellido
		$this->Segundo_Apellido->AdvancedSearch->SearchValue = @$filter["x_Segundo_Apellido"];
		$this->Segundo_Apellido->AdvancedSearch->SearchOperator = @$filter["z_Segundo_Apellido"];
		$this->Segundo_Apellido->AdvancedSearch->SearchCondition = @$filter["v_Segundo_Apellido"];
		$this->Segundo_Apellido->AdvancedSearch->SearchValue2 = @$filter["y_Segundo_Apellido"];
		$this->Segundo_Apellido->AdvancedSearch->SearchOperator2 = @$filter["w_Segundo_Apellido"];
		$this->Segundo_Apellido->AdvancedSearch->Save();

		// Field Tipo_Id
		$this->Tipo_Id->AdvancedSearch->SearchValue = @$filter["x_Tipo_Id"];
		$this->Tipo_Id->AdvancedSearch->SearchOperator = @$filter["z_Tipo_Id"];
		$this->Tipo_Id->AdvancedSearch->SearchCondition = @$filter["v_Tipo_Id"];
		$this->Tipo_Id->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_Id"];
		$this->Tipo_Id->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_Id"];
		$this->Tipo_Id->AdvancedSearch->Save();

		// Field Numero_Identificacion
		$this->Numero_Identificacion->AdvancedSearch->SearchValue = @$filter["x_Numero_Identificacion"];
		$this->Numero_Identificacion->AdvancedSearch->SearchOperator = @$filter["z_Numero_Identificacion"];
		$this->Numero_Identificacion->AdvancedSearch->SearchCondition = @$filter["v_Numero_Identificacion"];
		$this->Numero_Identificacion->AdvancedSearch->SearchValue2 = @$filter["y_Numero_Identificacion"];
		$this->Numero_Identificacion->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_Identificacion"];
		$this->Numero_Identificacion->AdvancedSearch->Save();

		// Field Edad
		$this->Edad->AdvancedSearch->SearchValue = @$filter["x_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator = @$filter["z_Edad"];
		$this->Edad->AdvancedSearch->SearchCondition = @$filter["v_Edad"];
		$this->Edad->AdvancedSearch->SearchValue2 = @$filter["y_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator2 = @$filter["w_Edad"];
		$this->Edad->AdvancedSearch->Save();

		// Field Unidad_Edad
		$this->Unidad_Edad->AdvancedSearch->SearchValue = @$filter["x_Unidad_Edad"];
		$this->Unidad_Edad->AdvancedSearch->SearchOperator = @$filter["z_Unidad_Edad"];
		$this->Unidad_Edad->AdvancedSearch->SearchCondition = @$filter["v_Unidad_Edad"];
		$this->Unidad_Edad->AdvancedSearch->SearchValue2 = @$filter["y_Unidad_Edad"];
		$this->Unidad_Edad->AdvancedSearch->SearchOperator2 = @$filter["w_Unidad_Edad"];
		$this->Unidad_Edad->AdvancedSearch->Save();

		// Field Sexo
		$this->Sexo->AdvancedSearch->SearchValue = @$filter["x_Sexo"];
		$this->Sexo->AdvancedSearch->SearchOperator = @$filter["z_Sexo"];
		$this->Sexo->AdvancedSearch->SearchCondition = @$filter["v_Sexo"];
		$this->Sexo->AdvancedSearch->SearchValue2 = @$filter["y_Sexo"];
		$this->Sexo->AdvancedSearch->SearchOperator2 = @$filter["w_Sexo"];
		$this->Sexo->AdvancedSearch->Save();

		// Field Pais_Ocurrencia
		$this->Pais_Ocurrencia->AdvancedSearch->SearchValue = @$filter["x_Pais_Ocurrencia"];
		$this->Pais_Ocurrencia->AdvancedSearch->SearchOperator = @$filter["z_Pais_Ocurrencia"];
		$this->Pais_Ocurrencia->AdvancedSearch->SearchCondition = @$filter["v_Pais_Ocurrencia"];
		$this->Pais_Ocurrencia->AdvancedSearch->SearchValue2 = @$filter["y_Pais_Ocurrencia"];
		$this->Pais_Ocurrencia->AdvancedSearch->SearchOperator2 = @$filter["w_Pais_Ocurrencia"];
		$this->Pais_Ocurrencia->AdvancedSearch->Save();

		// Field Depto_Ocurrencia
		$this->Depto_Ocurrencia->AdvancedSearch->SearchValue = @$filter["x_Depto_Ocurrencia"];
		$this->Depto_Ocurrencia->AdvancedSearch->SearchOperator = @$filter["z_Depto_Ocurrencia"];
		$this->Depto_Ocurrencia->AdvancedSearch->SearchCondition = @$filter["v_Depto_Ocurrencia"];
		$this->Depto_Ocurrencia->AdvancedSearch->SearchValue2 = @$filter["y_Depto_Ocurrencia"];
		$this->Depto_Ocurrencia->AdvancedSearch->SearchOperator2 = @$filter["w_Depto_Ocurrencia"];
		$this->Depto_Ocurrencia->AdvancedSearch->Save();

		// Field Municipio_Ocurrencia
		$this->Municipio_Ocurrencia->AdvancedSearch->SearchValue = @$filter["x_Municipio_Ocurrencia"];
		$this->Municipio_Ocurrencia->AdvancedSearch->SearchOperator = @$filter["z_Municipio_Ocurrencia"];
		$this->Municipio_Ocurrencia->AdvancedSearch->SearchCondition = @$filter["v_Municipio_Ocurrencia"];
		$this->Municipio_Ocurrencia->AdvancedSearch->SearchValue2 = @$filter["y_Municipio_Ocurrencia"];
		$this->Municipio_Ocurrencia->AdvancedSearch->SearchOperator2 = @$filter["w_Municipio_Ocurrencia"];
		$this->Municipio_Ocurrencia->AdvancedSearch->Save();

		// Field Area_Ocurrencia
		$this->Area_Ocurrencia->AdvancedSearch->SearchValue = @$filter["x_Area_Ocurrencia"];
		$this->Area_Ocurrencia->AdvancedSearch->SearchOperator = @$filter["z_Area_Ocurrencia"];
		$this->Area_Ocurrencia->AdvancedSearch->SearchCondition = @$filter["v_Area_Ocurrencia"];
		$this->Area_Ocurrencia->AdvancedSearch->SearchValue2 = @$filter["y_Area_Ocurrencia"];
		$this->Area_Ocurrencia->AdvancedSearch->SearchOperator2 = @$filter["w_Area_Ocurrencia"];
		$this->Area_Ocurrencia->AdvancedSearch->Save();

		// Field Localidad
		$this->Localidad->AdvancedSearch->SearchValue = @$filter["x_Localidad"];
		$this->Localidad->AdvancedSearch->SearchOperator = @$filter["z_Localidad"];
		$this->Localidad->AdvancedSearch->SearchCondition = @$filter["v_Localidad"];
		$this->Localidad->AdvancedSearch->SearchValue2 = @$filter["y_Localidad"];
		$this->Localidad->AdvancedSearch->SearchOperator2 = @$filter["w_Localidad"];
		$this->Localidad->AdvancedSearch->Save();

		// Field Barrio
		$this->Barrio->AdvancedSearch->SearchValue = @$filter["x_Barrio"];
		$this->Barrio->AdvancedSearch->SearchOperator = @$filter["z_Barrio"];
		$this->Barrio->AdvancedSearch->SearchCondition = @$filter["v_Barrio"];
		$this->Barrio->AdvancedSearch->SearchValue2 = @$filter["y_Barrio"];
		$this->Barrio->AdvancedSearch->SearchOperator2 = @$filter["w_Barrio"];
		$this->Barrio->AdvancedSearch->Save();

		// Field Direccion_Residencia
		$this->Direccion_Residencia->AdvancedSearch->SearchValue = @$filter["x_Direccion_Residencia"];
		$this->Direccion_Residencia->AdvancedSearch->SearchOperator = @$filter["z_Direccion_Residencia"];
		$this->Direccion_Residencia->AdvancedSearch->SearchCondition = @$filter["v_Direccion_Residencia"];
		$this->Direccion_Residencia->AdvancedSearch->SearchValue2 = @$filter["y_Direccion_Residencia"];
		$this->Direccion_Residencia->AdvancedSearch->SearchOperator2 = @$filter["w_Direccion_Residencia"];
		$this->Direccion_Residencia->AdvancedSearch->Save();

		// Field Ocupacion
		$this->Ocupacion->AdvancedSearch->SearchValue = @$filter["x_Ocupacion"];
		$this->Ocupacion->AdvancedSearch->SearchOperator = @$filter["z_Ocupacion"];
		$this->Ocupacion->AdvancedSearch->SearchCondition = @$filter["v_Ocupacion"];
		$this->Ocupacion->AdvancedSearch->SearchValue2 = @$filter["y_Ocupacion"];
		$this->Ocupacion->AdvancedSearch->SearchOperator2 = @$filter["w_Ocupacion"];
		$this->Ocupacion->AdvancedSearch->Save();

		// Field Tipo_Regimen_Salud
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchValue = @$filter["x_Tipo_Regimen_Salud"];
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchOperator = @$filter["z_Tipo_Regimen_Salud"];
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchCondition = @$filter["v_Tipo_Regimen_Salud"];
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_Regimen_Salud"];
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_Regimen_Salud"];
		$this->Tipo_Regimen_Salud->AdvancedSearch->Save();

		// Field Cod_Administradora
		$this->Cod_Administradora->AdvancedSearch->SearchValue = @$filter["x_Cod_Administradora"];
		$this->Cod_Administradora->AdvancedSearch->SearchOperator = @$filter["z_Cod_Administradora"];
		$this->Cod_Administradora->AdvancedSearch->SearchCondition = @$filter["v_Cod_Administradora"];
		$this->Cod_Administradora->AdvancedSearch->SearchValue2 = @$filter["y_Cod_Administradora"];
		$this->Cod_Administradora->AdvancedSearch->SearchOperator2 = @$filter["w_Cod_Administradora"];
		$this->Cod_Administradora->AdvancedSearch->Save();

		// Field gp_discapa
		$this->gp_discapa->AdvancedSearch->SearchValue = @$filter["x_gp_discapa"];
		$this->gp_discapa->AdvancedSearch->SearchOperator = @$filter["z_gp_discapa"];
		$this->gp_discapa->AdvancedSearch->SearchCondition = @$filter["v_gp_discapa"];
		$this->gp_discapa->AdvancedSearch->SearchValue2 = @$filter["y_gp_discapa"];
		$this->gp_discapa->AdvancedSearch->SearchOperator2 = @$filter["w_gp_discapa"];
		$this->gp_discapa->AdvancedSearch->Save();

		// Field gp_desplaz
		$this->gp_desplaz->AdvancedSearch->SearchValue = @$filter["x_gp_desplaz"];
		$this->gp_desplaz->AdvancedSearch->SearchOperator = @$filter["z_gp_desplaz"];
		$this->gp_desplaz->AdvancedSearch->SearchCondition = @$filter["v_gp_desplaz"];
		$this->gp_desplaz->AdvancedSearch->SearchValue2 = @$filter["y_gp_desplaz"];
		$this->gp_desplaz->AdvancedSearch->SearchOperator2 = @$filter["w_gp_desplaz"];
		$this->gp_desplaz->AdvancedSearch->Save();

		// Field gp_migrant
		$this->gp_migrant->AdvancedSearch->SearchValue = @$filter["x_gp_migrant"];
		$this->gp_migrant->AdvancedSearch->SearchOperator = @$filter["z_gp_migrant"];
		$this->gp_migrant->AdvancedSearch->SearchCondition = @$filter["v_gp_migrant"];
		$this->gp_migrant->AdvancedSearch->SearchValue2 = @$filter["y_gp_migrant"];
		$this->gp_migrant->AdvancedSearch->SearchOperator2 = @$filter["w_gp_migrant"];
		$this->gp_migrant->AdvancedSearch->Save();

		// Field gp_carcela
		$this->gp_carcela->AdvancedSearch->SearchValue = @$filter["x_gp_carcela"];
		$this->gp_carcela->AdvancedSearch->SearchOperator = @$filter["z_gp_carcela"];
		$this->gp_carcela->AdvancedSearch->SearchCondition = @$filter["v_gp_carcela"];
		$this->gp_carcela->AdvancedSearch->SearchValue2 = @$filter["y_gp_carcela"];
		$this->gp_carcela->AdvancedSearch->SearchOperator2 = @$filter["w_gp_carcela"];
		$this->gp_carcela->AdvancedSearch->Save();

		// Field gp_gestan
		$this->gp_gestan->AdvancedSearch->SearchValue = @$filter["x_gp_gestan"];
		$this->gp_gestan->AdvancedSearch->SearchOperator = @$filter["z_gp_gestan"];
		$this->gp_gestan->AdvancedSearch->SearchCondition = @$filter["v_gp_gestan"];
		$this->gp_gestan->AdvancedSearch->SearchValue2 = @$filter["y_gp_gestan"];
		$this->gp_gestan->AdvancedSearch->SearchOperator2 = @$filter["w_gp_gestan"];
		$this->gp_gestan->AdvancedSearch->Save();

		// Field gp_indigen
		$this->gp_indigen->AdvancedSearch->SearchValue = @$filter["x_gp_indigen"];
		$this->gp_indigen->AdvancedSearch->SearchOperator = @$filter["z_gp_indigen"];
		$this->gp_indigen->AdvancedSearch->SearchCondition = @$filter["v_gp_indigen"];
		$this->gp_indigen->AdvancedSearch->SearchValue2 = @$filter["y_gp_indigen"];
		$this->gp_indigen->AdvancedSearch->SearchOperator2 = @$filter["w_gp_indigen"];
		$this->gp_indigen->AdvancedSearch->Save();

		// Field gp_pobicbf
		$this->gp_pobicbf->AdvancedSearch->SearchValue = @$filter["x_gp_pobicbf"];
		$this->gp_pobicbf->AdvancedSearch->SearchOperator = @$filter["z_gp_pobicbf"];
		$this->gp_pobicbf->AdvancedSearch->SearchCondition = @$filter["v_gp_pobicbf"];
		$this->gp_pobicbf->AdvancedSearch->SearchValue2 = @$filter["y_gp_pobicbf"];
		$this->gp_pobicbf->AdvancedSearch->SearchOperator2 = @$filter["w_gp_pobicbf"];
		$this->gp_pobicbf->AdvancedSearch->Save();

		// Field gp_mad_com
		$this->gp_mad_com->AdvancedSearch->SearchValue = @$filter["x_gp_mad_com"];
		$this->gp_mad_com->AdvancedSearch->SearchOperator = @$filter["z_gp_mad_com"];
		$this->gp_mad_com->AdvancedSearch->SearchCondition = @$filter["v_gp_mad_com"];
		$this->gp_mad_com->AdvancedSearch->SearchValue2 = @$filter["y_gp_mad_com"];
		$this->gp_mad_com->AdvancedSearch->SearchOperator2 = @$filter["w_gp_mad_com"];
		$this->gp_mad_com->AdvancedSearch->Save();

		// Field gp_desmovi
		$this->gp_desmovi->AdvancedSearch->SearchValue = @$filter["x_gp_desmovi"];
		$this->gp_desmovi->AdvancedSearch->SearchOperator = @$filter["z_gp_desmovi"];
		$this->gp_desmovi->AdvancedSearch->SearchCondition = @$filter["v_gp_desmovi"];
		$this->gp_desmovi->AdvancedSearch->SearchValue2 = @$filter["y_gp_desmovi"];
		$this->gp_desmovi->AdvancedSearch->SearchOperator2 = @$filter["w_gp_desmovi"];
		$this->gp_desmovi->AdvancedSearch->Save();

		// Field gp_psiquia
		$this->gp_psiquia->AdvancedSearch->SearchValue = @$filter["x_gp_psiquia"];
		$this->gp_psiquia->AdvancedSearch->SearchOperator = @$filter["z_gp_psiquia"];
		$this->gp_psiquia->AdvancedSearch->SearchCondition = @$filter["v_gp_psiquia"];
		$this->gp_psiquia->AdvancedSearch->SearchValue2 = @$filter["y_gp_psiquia"];
		$this->gp_psiquia->AdvancedSearch->SearchOperator2 = @$filter["w_gp_psiquia"];
		$this->gp_psiquia->AdvancedSearch->Save();

		// Field gp_vic_vio
		$this->gp_vic_vio->AdvancedSearch->SearchValue = @$filter["x_gp_vic_vio"];
		$this->gp_vic_vio->AdvancedSearch->SearchOperator = @$filter["z_gp_vic_vio"];
		$this->gp_vic_vio->AdvancedSearch->SearchCondition = @$filter["v_gp_vic_vio"];
		$this->gp_vic_vio->AdvancedSearch->SearchValue2 = @$filter["y_gp_vic_vio"];
		$this->gp_vic_vio->AdvancedSearch->SearchOperator2 = @$filter["w_gp_vic_vio"];
		$this->gp_vic_vio->AdvancedSearch->Save();

		// Field gp_otros
		$this->gp_otros->AdvancedSearch->SearchValue = @$filter["x_gp_otros"];
		$this->gp_otros->AdvancedSearch->SearchOperator = @$filter["z_gp_otros"];
		$this->gp_otros->AdvancedSearch->SearchCondition = @$filter["v_gp_otros"];
		$this->gp_otros->AdvancedSearch->SearchValue2 = @$filter["y_gp_otros"];
		$this->gp_otros->AdvancedSearch->SearchOperator2 = @$filter["w_gp_otros"];
		$this->gp_otros->AdvancedSearch->Save();

		// Field Depto_Residencia
		$this->Depto_Residencia->AdvancedSearch->SearchValue = @$filter["x_Depto_Residencia"];
		$this->Depto_Residencia->AdvancedSearch->SearchOperator = @$filter["z_Depto_Residencia"];
		$this->Depto_Residencia->AdvancedSearch->SearchCondition = @$filter["v_Depto_Residencia"];
		$this->Depto_Residencia->AdvancedSearch->SearchValue2 = @$filter["y_Depto_Residencia"];
		$this->Depto_Residencia->AdvancedSearch->SearchOperator2 = @$filter["w_Depto_Residencia"];
		$this->Depto_Residencia->AdvancedSearch->Save();

		// Field Municipio_Residencia
		$this->Municipio_Residencia->AdvancedSearch->SearchValue = @$filter["x_Municipio_Residencia"];
		$this->Municipio_Residencia->AdvancedSearch->SearchOperator = @$filter["z_Municipio_Residencia"];
		$this->Municipio_Residencia->AdvancedSearch->SearchCondition = @$filter["v_Municipio_Residencia"];
		$this->Municipio_Residencia->AdvancedSearch->SearchValue2 = @$filter["y_Municipio_Residencia"];
		$this->Municipio_Residencia->AdvancedSearch->SearchOperator2 = @$filter["w_Municipio_Residencia"];
		$this->Municipio_Residencia->AdvancedSearch->Save();

		// Field Fecha_Consulta
		$this->Fecha_Consulta->AdvancedSearch->SearchValue = @$filter["x_Fecha_Consulta"];
		$this->Fecha_Consulta->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Consulta"];
		$this->Fecha_Consulta->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Consulta"];
		$this->Fecha_Consulta->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Consulta"];
		$this->Fecha_Consulta->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Consulta"];
		$this->Fecha_Consulta->AdvancedSearch->Save();

		// Field Fecha_Inicio_Sintomas
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchValue = @$filter["x_Fecha_Inicio_Sintomas"];
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Inicio_Sintomas"];
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Inicio_Sintomas"];
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Inicio_Sintomas"];
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Inicio_Sintomas"];
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->Save();

		// Field Hospitalizado
		$this->Hospitalizado->AdvancedSearch->SearchValue = @$filter["x_Hospitalizado"];
		$this->Hospitalizado->AdvancedSearch->SearchOperator = @$filter["z_Hospitalizado"];
		$this->Hospitalizado->AdvancedSearch->SearchCondition = @$filter["v_Hospitalizado"];
		$this->Hospitalizado->AdvancedSearch->SearchValue2 = @$filter["y_Hospitalizado"];
		$this->Hospitalizado->AdvancedSearch->SearchOperator2 = @$filter["w_Hospitalizado"];
		$this->Hospitalizado->AdvancedSearch->Save();

		// Field Fecha_Defuncion
		$this->Fecha_Defuncion->AdvancedSearch->SearchValue = @$filter["x_Fecha_Defuncion"];
		$this->Fecha_Defuncion->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Defuncion"];
		$this->Fecha_Defuncion->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Defuncion"];
		$this->Fecha_Defuncion->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Defuncion"];
		$this->Fecha_Defuncion->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Defuncion"];
		$this->Fecha_Defuncion->AdvancedSearch->Save();

		// Field Numero_Certificado_Defuncion
		$this->Numero_Certificado_Defuncion->AdvancedSearch->SearchValue = @$filter["x_Numero_Certificado_Defuncion"];
		$this->Numero_Certificado_Defuncion->AdvancedSearch->SearchOperator = @$filter["z_Numero_Certificado_Defuncion"];
		$this->Numero_Certificado_Defuncion->AdvancedSearch->SearchCondition = @$filter["v_Numero_Certificado_Defuncion"];
		$this->Numero_Certificado_Defuncion->AdvancedSearch->SearchValue2 = @$filter["y_Numero_Certificado_Defuncion"];
		$this->Numero_Certificado_Defuncion->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_Certificado_Defuncion"];
		$this->Numero_Certificado_Defuncion->AdvancedSearch->Save();

		// Field Causa_Basica_Muerte_CIEX
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchValue = @$filter["x_Causa_Basica_Muerte_CIEX"];
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchOperator = @$filter["z_Causa_Basica_Muerte_CIEX"];
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchCondition = @$filter["v_Causa_Basica_Muerte_CIEX"];
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchValue2 = @$filter["y_Causa_Basica_Muerte_CIEX"];
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchOperator2 = @$filter["w_Causa_Basica_Muerte_CIEX"];
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->Save();

		// Field Entidad_fallecimiento
		$this->Entidad_fallecimiento->AdvancedSearch->SearchValue = @$filter["x_Entidad_fallecimiento"];
		$this->Entidad_fallecimiento->AdvancedSearch->SearchOperator = @$filter["z_Entidad_fallecimiento"];
		$this->Entidad_fallecimiento->AdvancedSearch->SearchCondition = @$filter["v_Entidad_fallecimiento"];
		$this->Entidad_fallecimiento->AdvancedSearch->SearchValue2 = @$filter["y_Entidad_fallecimiento"];
		$this->Entidad_fallecimiento->AdvancedSearch->SearchOperator2 = @$filter["w_Entidad_fallecimiento"];
		$this->Entidad_fallecimiento->AdvancedSearch->Save();

		// Field Telefono
		$this->Telefono->AdvancedSearch->SearchValue = @$filter["x_Telefono"];
		$this->Telefono->AdvancedSearch->SearchOperator = @$filter["z_Telefono"];
		$this->Telefono->AdvancedSearch->SearchCondition = @$filter["v_Telefono"];
		$this->Telefono->AdvancedSearch->SearchValue2 = @$filter["y_Telefono"];
		$this->Telefono->AdvancedSearch->SearchOperator2 = @$filter["w_Telefono"];
		$this->Telefono->AdvancedSearch->Save();

		// Field Fecha_Nacimiento
		$this->Fecha_Nacimiento->AdvancedSearch->SearchValue = @$filter["x_Fecha_Nacimiento"];
		$this->Fecha_Nacimiento->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Nacimiento"];
		$this->Fecha_Nacimiento->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Nacimiento"];
		$this->Fecha_Nacimiento->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Nacimiento"];
		$this->Fecha_Nacimiento->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Nacimiento"];
		$this->Fecha_Nacimiento->AdvancedSearch->Save();

		// Field Nombre_Profesional_Diligencia
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchValue = @$filter["x_Nombre_Profesional_Diligencia"];
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchOperator = @$filter["z_Nombre_Profesional_Diligencia"];
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchCondition = @$filter["v_Nombre_Profesional_Diligencia"];
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchValue2 = @$filter["y_Nombre_Profesional_Diligencia"];
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchOperator2 = @$filter["w_Nombre_Profesional_Diligencia"];
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->Save();

		// Field Telefono_Profesional_Diligencia
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchValue = @$filter["x_Telefono_Profesional_Diligencia"];
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchOperator = @$filter["z_Telefono_Profesional_Diligencia"];
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchCondition = @$filter["v_Telefono_Profesional_Diligencia"];
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchValue2 = @$filter["y_Telefono_Profesional_Diligencia"];
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchOperator2 = @$filter["w_Telefono_Profesional_Diligencia"];
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->Save();

		// Field Mecanismo_Probable_Transmision
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchValue = @$filter["x_Mecanismo_Probable_Transmision"];
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchOperator = @$filter["z_Mecanismo_Probable_Transmision"];
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchCondition = @$filter["v_Mecanismo_Probable_Transmision"];
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchValue2 = @$filter["y_Mecanismo_Probable_Transmision"];
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchOperator2 = @$filter["w_Mecanismo_Probable_Transmision"];
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->Save();

		// Field Nombre_Madre
		$this->Nombre_Madre->AdvancedSearch->SearchValue = @$filter["x_Nombre_Madre"];
		$this->Nombre_Madre->AdvancedSearch->SearchOperator = @$filter["z_Nombre_Madre"];
		$this->Nombre_Madre->AdvancedSearch->SearchCondition = @$filter["v_Nombre_Madre"];
		$this->Nombre_Madre->AdvancedSearch->SearchValue2 = @$filter["y_Nombre_Madre"];
		$this->Nombre_Madre->AdvancedSearch->SearchOperator2 = @$filter["w_Nombre_Madre"];
		$this->Nombre_Madre->AdvancedSearch->Save();

		// Field Tipo_Id_Madre
		$this->Tipo_Id_Madre->AdvancedSearch->SearchValue = @$filter["x_Tipo_Id_Madre"];
		$this->Tipo_Id_Madre->AdvancedSearch->SearchOperator = @$filter["z_Tipo_Id_Madre"];
		$this->Tipo_Id_Madre->AdvancedSearch->SearchCondition = @$filter["v_Tipo_Id_Madre"];
		$this->Tipo_Id_Madre->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_Id_Madre"];
		$this->Tipo_Id_Madre->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_Id_Madre"];
		$this->Tipo_Id_Madre->AdvancedSearch->Save();

		// Field Numero_Identificacion_Madre
		$this->Numero_Identificacion_Madre->AdvancedSearch->SearchValue = @$filter["x_Numero_Identificacion_Madre"];
		$this->Numero_Identificacion_Madre->AdvancedSearch->SearchOperator = @$filter["z_Numero_Identificacion_Madre"];
		$this->Numero_Identificacion_Madre->AdvancedSearch->SearchCondition = @$filter["v_Numero_Identificacion_Madre"];
		$this->Numero_Identificacion_Madre->AdvancedSearch->SearchValue2 = @$filter["y_Numero_Identificacion_Madre"];
		$this->Numero_Identificacion_Madre->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_Identificacion_Madre"];
		$this->Numero_Identificacion_Madre->AdvancedSearch->Save();

		// Field Indentidad_Genero
		$this->Indentidad_Genero->AdvancedSearch->SearchValue = @$filter["x_Indentidad_Genero"];
		$this->Indentidad_Genero->AdvancedSearch->SearchOperator = @$filter["z_Indentidad_Genero"];
		$this->Indentidad_Genero->AdvancedSearch->SearchCondition = @$filter["v_Indentidad_Genero"];
		$this->Indentidad_Genero->AdvancedSearch->SearchValue2 = @$filter["y_Indentidad_Genero"];
		$this->Indentidad_Genero->AdvancedSearch->SearchOperator2 = @$filter["w_Indentidad_Genero"];
		$this->Indentidad_Genero->AdvancedSearch->Save();

		// Field Donador_Sangre_Ultimos_12_Meses
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchValue = @$filter["x_Donador_Sangre_Ultimos_12_Meses"];
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchOperator = @$filter["z_Donador_Sangre_Ultimos_12_Meses"];
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchCondition = @$filter["v_Donador_Sangre_Ultimos_12_Meses"];
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchValue2 = @$filter["y_Donador_Sangre_Ultimos_12_Meses"];
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchOperator2 = @$filter["w_Donador_Sangre_Ultimos_12_Meses"];
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->Save();

		// Field Fecha_Donacion
		$this->Fecha_Donacion->AdvancedSearch->SearchValue = @$filter["x_Fecha_Donacion"];
		$this->Fecha_Donacion->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Donacion"];
		$this->Fecha_Donacion->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Donacion"];
		$this->Fecha_Donacion->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Donacion"];
		$this->Fecha_Donacion->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Donacion"];
		$this->Fecha_Donacion->AdvancedSearch->Save();

		// Field Nombre_Institucion_Donacion
		$this->Nombre_Institucion_Donacion->AdvancedSearch->SearchValue = @$filter["x_Nombre_Institucion_Donacion"];
		$this->Nombre_Institucion_Donacion->AdvancedSearch->SearchOperator = @$filter["z_Nombre_Institucion_Donacion"];
		$this->Nombre_Institucion_Donacion->AdvancedSearch->SearchCondition = @$filter["v_Nombre_Institucion_Donacion"];
		$this->Nombre_Institucion_Donacion->AdvancedSearch->SearchValue2 = @$filter["y_Nombre_Institucion_Donacion"];
		$this->Nombre_Institucion_Donacion->AdvancedSearch->SearchOperator2 = @$filter["w_Nombre_Institucion_Donacion"];
		$this->Nombre_Institucion_Donacion->AdvancedSearch->Save();

		// Field Poblacion_clave
		$this->Poblacion_clave->AdvancedSearch->SearchValue = @$filter["x_Poblacion_clave"];
		$this->Poblacion_clave->AdvancedSearch->SearchOperator = @$filter["z_Poblacion_clave"];
		$this->Poblacion_clave->AdvancedSearch->SearchCondition = @$filter["v_Poblacion_clave"];
		$this->Poblacion_clave->AdvancedSearch->SearchValue2 = @$filter["y_Poblacion_clave"];
		$this->Poblacion_clave->AdvancedSearch->SearchOperator2 = @$filter["w_Poblacion_clave"];
		$this->Poblacion_clave->AdvancedSearch->Save();

		// Field Recibio_Asesoria_Pre_Prueba
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchValue = @$filter["x_Recibio_Asesoria_Pre_Prueba"];
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchOperator = @$filter["z_Recibio_Asesoria_Pre_Prueba"];
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchCondition = @$filter["v_Recibio_Asesoria_Pre_Prueba"];
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchValue2 = @$filter["y_Recibio_Asesoria_Pre_Prueba"];
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchOperator2 = @$filter["w_Recibio_Asesoria_Pre_Prueba"];
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->Save();

		// Field Recibio_Asesoria_Post_Prueba
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchValue = @$filter["x_Recibio_Asesoria_Post_Prueba"];
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchOperator = @$filter["z_Recibio_Asesoria_Post_Prueba"];
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchCondition = @$filter["v_Recibio_Asesoria_Post_Prueba"];
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchValue2 = @$filter["y_Recibio_Asesoria_Post_Prueba"];
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchOperator2 = @$filter["w_Recibio_Asesoria_Post_Prueba"];
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->Save();

		// Field Tipo_Prueba
		$this->Tipo_Prueba->AdvancedSearch->SearchValue = @$filter["x_Tipo_Prueba"];
		$this->Tipo_Prueba->AdvancedSearch->SearchOperator = @$filter["z_Tipo_Prueba"];
		$this->Tipo_Prueba->AdvancedSearch->SearchCondition = @$filter["v_Tipo_Prueba"];
		$this->Tipo_Prueba->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_Prueba"];
		$this->Tipo_Prueba->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_Prueba"];
		$this->Tipo_Prueba->AdvancedSearch->Save();

		// Field Fecha_Resultado_Confirmatorio
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchValue = @$filter["x_Fecha_Resultado_Confirmatorio"];
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Resultado_Confirmatorio"];
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Resultado_Confirmatorio"];
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Resultado_Confirmatorio"];
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Resultado_Confirmatorio"];
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->Save();

		// Field Valor_Carga_Viral
		$this->Valor_Carga_Viral->AdvancedSearch->SearchValue = @$filter["x_Valor_Carga_Viral"];
		$this->Valor_Carga_Viral->AdvancedSearch->SearchOperator = @$filter["z_Valor_Carga_Viral"];
		$this->Valor_Carga_Viral->AdvancedSearch->SearchCondition = @$filter["v_Valor_Carga_Viral"];
		$this->Valor_Carga_Viral->AdvancedSearch->SearchValue2 = @$filter["y_Valor_Carga_Viral"];
		$this->Valor_Carga_Viral->AdvancedSearch->SearchOperator2 = @$filter["w_Valor_Carga_Viral"];
		$this->Valor_Carga_Viral->AdvancedSearch->Save();

		// Field Estado_Clinico_Notificacion
		$this->Estado_Clinico_Notificacion->AdvancedSearch->SearchValue = @$filter["x_Estado_Clinico_Notificacion"];
		$this->Estado_Clinico_Notificacion->AdvancedSearch->SearchOperator = @$filter["z_Estado_Clinico_Notificacion"];
		$this->Estado_Clinico_Notificacion->AdvancedSearch->SearchCondition = @$filter["v_Estado_Clinico_Notificacion"];
		$this->Estado_Clinico_Notificacion->AdvancedSearch->SearchValue2 = @$filter["y_Estado_Clinico_Notificacion"];
		$this->Estado_Clinico_Notificacion->AdvancedSearch->SearchOperator2 = @$filter["w_Estado_Clinico_Notificacion"];
		$this->Estado_Clinico_Notificacion->AdvancedSearch->Save();

		// Field Hijos_Mujeres_Menores_5
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchValue = @$filter["x_Hijos_Mujeres_Menores_5"];
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchOperator = @$filter["z_Hijos_Mujeres_Menores_5"];
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchCondition = @$filter["v_Hijos_Mujeres_Menores_5"];
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchValue2 = @$filter["y_Hijos_Mujeres_Menores_5"];
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchOperator2 = @$filter["w_Hijos_Mujeres_Menores_5"];
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->Save();

		// Field Hijos_Hombres_Menores_5
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchValue = @$filter["x_Hijos_Hombres_Menores_5"];
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchOperator = @$filter["z_Hijos_Hombres_Menores_5"];
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchCondition = @$filter["v_Hijos_Hombres_Menores_5"];
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchValue2 = @$filter["y_Hijos_Hombres_Menores_5"];
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchOperator2 = @$filter["w_Hijos_Hombres_Menores_5"];
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->Save();

		// Field Numero_Semanas_Embarazo
		$this->Numero_Semanas_Embarazo->AdvancedSearch->SearchValue = @$filter["x_Numero_Semanas_Embarazo"];
		$this->Numero_Semanas_Embarazo->AdvancedSearch->SearchOperator = @$filter["z_Numero_Semanas_Embarazo"];
		$this->Numero_Semanas_Embarazo->AdvancedSearch->SearchCondition = @$filter["v_Numero_Semanas_Embarazo"];
		$this->Numero_Semanas_Embarazo->AdvancedSearch->SearchValue2 = @$filter["y_Numero_Semanas_Embarazo"];
		$this->Numero_Semanas_Embarazo->AdvancedSearch->SearchOperator2 = @$filter["w_Numero_Semanas_Embarazo"];
		$this->Numero_Semanas_Embarazo->AdvancedSearch->Save();

		// Field Antecedentes_Embarazo
		$this->Antecedentes_Embarazo->AdvancedSearch->SearchValue = @$filter["x_Antecedentes_Embarazo"];
		$this->Antecedentes_Embarazo->AdvancedSearch->SearchOperator = @$filter["z_Antecedentes_Embarazo"];
		$this->Antecedentes_Embarazo->AdvancedSearch->SearchCondition = @$filter["v_Antecedentes_Embarazo"];
		$this->Antecedentes_Embarazo->AdvancedSearch->SearchValue2 = @$filter["y_Antecedentes_Embarazo"];
		$this->Antecedentes_Embarazo->AdvancedSearch->SearchOperator2 = @$filter["w_Antecedentes_Embarazo"];
		$this->Antecedentes_Embarazo->AdvancedSearch->Save();

		// Field Candidiasis_esofagica
		$this->Candidiasis_esofagica->AdvancedSearch->SearchValue = @$filter["x_Candidiasis_esofagica"];
		$this->Candidiasis_esofagica->AdvancedSearch->SearchOperator = @$filter["z_Candidiasis_esofagica"];
		$this->Candidiasis_esofagica->AdvancedSearch->SearchCondition = @$filter["v_Candidiasis_esofagica"];
		$this->Candidiasis_esofagica->AdvancedSearch->SearchValue2 = @$filter["y_Candidiasis_esofagica"];
		$this->Candidiasis_esofagica->AdvancedSearch->SearchOperator2 = @$filter["w_Candidiasis_esofagica"];
		$this->Candidiasis_esofagica->AdvancedSearch->Save();

		// Field Candidiasis_vias_aereas
		$this->Candidiasis_vias_aereas->AdvancedSearch->SearchValue = @$filter["x_Candidiasis_vias_aereas"];
		$this->Candidiasis_vias_aereas->AdvancedSearch->SearchOperator = @$filter["z_Candidiasis_vias_aereas"];
		$this->Candidiasis_vias_aereas->AdvancedSearch->SearchCondition = @$filter["v_Candidiasis_vias_aereas"];
		$this->Candidiasis_vias_aereas->AdvancedSearch->SearchValue2 = @$filter["y_Candidiasis_vias_aereas"];
		$this->Candidiasis_vias_aereas->AdvancedSearch->SearchOperator2 = @$filter["w_Candidiasis_vias_aereas"];
		$this->Candidiasis_vias_aereas->AdvancedSearch->Save();

		// Field Tuberculosis_pulmonar
		$this->Tuberculosis_pulmonar->AdvancedSearch->SearchValue = @$filter["x_Tuberculosis_pulmonar"];
		$this->Tuberculosis_pulmonar->AdvancedSearch->SearchOperator = @$filter["z_Tuberculosis_pulmonar"];
		$this->Tuberculosis_pulmonar->AdvancedSearch->SearchCondition = @$filter["v_Tuberculosis_pulmonar"];
		$this->Tuberculosis_pulmonar->AdvancedSearch->SearchValue2 = @$filter["y_Tuberculosis_pulmonar"];
		$this->Tuberculosis_pulmonar->AdvancedSearch->SearchOperator2 = @$filter["w_Tuberculosis_pulmonar"];
		$this->Tuberculosis_pulmonar->AdvancedSearch->Save();

		// Field Cancer_cervical
		$this->Cancer_cervical->AdvancedSearch->SearchValue = @$filter["x_Cancer_cervical"];
		$this->Cancer_cervical->AdvancedSearch->SearchOperator = @$filter["z_Cancer_cervical"];
		$this->Cancer_cervical->AdvancedSearch->SearchCondition = @$filter["v_Cancer_cervical"];
		$this->Cancer_cervical->AdvancedSearch->SearchValue2 = @$filter["y_Cancer_cervical"];
		$this->Cancer_cervical->AdvancedSearch->SearchOperator2 = @$filter["w_Cancer_cervical"];
		$this->Cancer_cervical->AdvancedSearch->Save();

		// Field Tuberculosis_extrapulmonar
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchValue = @$filter["x_Tuberculosis_extrapulmonar"];
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchOperator = @$filter["z_Tuberculosis_extrapulmonar"];
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchCondition = @$filter["v_Tuberculosis_extrapulmonar"];
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchValue2 = @$filter["y_Tuberculosis_extrapulmonar"];
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchOperator2 = @$filter["w_Tuberculosis_extrapulmonar"];
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->Save();

		// Field Coccidiomicosis
		$this->Coccidiomicosis->AdvancedSearch->SearchValue = @$filter["x_Coccidiomicosis"];
		$this->Coccidiomicosis->AdvancedSearch->SearchOperator = @$filter["z_Coccidiomicosis"];
		$this->Coccidiomicosis->AdvancedSearch->SearchCondition = @$filter["v_Coccidiomicosis"];
		$this->Coccidiomicosis->AdvancedSearch->SearchValue2 = @$filter["y_Coccidiomicosis"];
		$this->Coccidiomicosis->AdvancedSearch->SearchOperator2 = @$filter["w_Coccidiomicosis"];
		$this->Coccidiomicosis->AdvancedSearch->Save();

		// Field Citomegalovirosis
		$this->Citomegalovirosis->AdvancedSearch->SearchValue = @$filter["x_Citomegalovirosis"];
		$this->Citomegalovirosis->AdvancedSearch->SearchOperator = @$filter["z_Citomegalovirosis"];
		$this->Citomegalovirosis->AdvancedSearch->SearchCondition = @$filter["v_Citomegalovirosis"];
		$this->Citomegalovirosis->AdvancedSearch->SearchValue2 = @$filter["y_Citomegalovirosis"];
		$this->Citomegalovirosis->AdvancedSearch->SearchOperator2 = @$filter["w_Citomegalovirosis"];
		$this->Citomegalovirosis->AdvancedSearch->Save();

		// Field Retinitis_citomegalovirosis
		$this->Retinitis_citomegalovirosis->AdvancedSearch->SearchValue = @$filter["x_Retinitis_citomegalovirosis"];
		$this->Retinitis_citomegalovirosis->AdvancedSearch->SearchOperator = @$filter["z_Retinitis_citomegalovirosis"];
		$this->Retinitis_citomegalovirosis->AdvancedSearch->SearchCondition = @$filter["v_Retinitis_citomegalovirosis"];
		$this->Retinitis_citomegalovirosis->AdvancedSearch->SearchValue2 = @$filter["y_Retinitis_citomegalovirosis"];
		$this->Retinitis_citomegalovirosis->AdvancedSearch->SearchOperator2 = @$filter["w_Retinitis_citomegalovirosis"];
		$this->Retinitis_citomegalovirosis->AdvancedSearch->Save();

		// Field Sindrome_Emanciacion
		$this->Sindrome_Emanciacion->AdvancedSearch->SearchValue = @$filter["x_Sindrome_Emanciacion"];
		$this->Sindrome_Emanciacion->AdvancedSearch->SearchOperator = @$filter["z_Sindrome_Emanciacion"];
		$this->Sindrome_Emanciacion->AdvancedSearch->SearchCondition = @$filter["v_Sindrome_Emanciacion"];
		$this->Sindrome_Emanciacion->AdvancedSearch->SearchValue2 = @$filter["y_Sindrome_Emanciacion"];
		$this->Sindrome_Emanciacion->AdvancedSearch->SearchOperator2 = @$filter["w_Sindrome_Emanciacion"];
		$this->Sindrome_Emanciacion->AdvancedSearch->Save();

		// Field Encefalopatia
		$this->Encefalopatia->AdvancedSearch->SearchValue = @$filter["x_Encefalopatia"];
		$this->Encefalopatia->AdvancedSearch->SearchOperator = @$filter["z_Encefalopatia"];
		$this->Encefalopatia->AdvancedSearch->SearchCondition = @$filter["v_Encefalopatia"];
		$this->Encefalopatia->AdvancedSearch->SearchValue2 = @$filter["y_Encefalopatia"];
		$this->Encefalopatia->AdvancedSearch->SearchOperator2 = @$filter["w_Encefalopatia"];
		$this->Encefalopatia->AdvancedSearch->Save();

		// Field Otras_micobacterias
		$this->Otras_micobacterias->AdvancedSearch->SearchValue = @$filter["x_Otras_micobacterias"];
		$this->Otras_micobacterias->AdvancedSearch->SearchOperator = @$filter["z_Otras_micobacterias"];
		$this->Otras_micobacterias->AdvancedSearch->SearchCondition = @$filter["v_Otras_micobacterias"];
		$this->Otras_micobacterias->AdvancedSearch->SearchValue2 = @$filter["y_Otras_micobacterias"];
		$this->Otras_micobacterias->AdvancedSearch->SearchOperator2 = @$filter["w_Otras_micobacterias"];
		$this->Otras_micobacterias->AdvancedSearch->Save();

		// Field Histoplasmosis_Extrapulmonar
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchValue = @$filter["x_Histoplasmosis_Extrapulmonar"];
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchOperator = @$filter["z_Histoplasmosis_Extrapulmonar"];
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchCondition = @$filter["v_Histoplasmosis_Extrapulmonar"];
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchValue2 = @$filter["y_Histoplasmosis_Extrapulmonar"];
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchOperator2 = @$filter["w_Histoplasmosis_Extrapulmonar"];
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->Save();

		// Field isosporidiasis_cronica
		$this->isosporidiasis_cronica->AdvancedSearch->SearchValue = @$filter["x_isosporidiasis_cronica"];
		$this->isosporidiasis_cronica->AdvancedSearch->SearchOperator = @$filter["z_isosporidiasis_cronica"];
		$this->isosporidiasis_cronica->AdvancedSearch->SearchCondition = @$filter["v_isosporidiasis_cronica"];
		$this->isosporidiasis_cronica->AdvancedSearch->SearchValue2 = @$filter["y_isosporidiasis_cronica"];
		$this->isosporidiasis_cronica->AdvancedSearch->SearchOperator2 = @$filter["w_isosporidiasis_cronica"];
		$this->isosporidiasis_cronica->AdvancedSearch->Save();

		// Field herpes_zoster
		$this->herpes_zoster->AdvancedSearch->SearchValue = @$filter["x_herpes_zoster"];
		$this->herpes_zoster->AdvancedSearch->SearchOperator = @$filter["z_herpes_zoster"];
		$this->herpes_zoster->AdvancedSearch->SearchCondition = @$filter["v_herpes_zoster"];
		$this->herpes_zoster->AdvancedSearch->SearchValue2 = @$filter["y_herpes_zoster"];
		$this->herpes_zoster->AdvancedSearch->SearchOperator2 = @$filter["w_herpes_zoster"];
		$this->herpes_zoster->AdvancedSearch->Save();

		// Field Histoplasmosis_diseminada
		$this->Histoplasmosis_diseminada->AdvancedSearch->SearchValue = @$filter["x_Histoplasmosis_diseminada"];
		$this->Histoplasmosis_diseminada->AdvancedSearch->SearchOperator = @$filter["z_Histoplasmosis_diseminada"];
		$this->Histoplasmosis_diseminada->AdvancedSearch->SearchCondition = @$filter["v_Histoplasmosis_diseminada"];
		$this->Histoplasmosis_diseminada->AdvancedSearch->SearchValue2 = @$filter["y_Histoplasmosis_diseminada"];
		$this->Histoplasmosis_diseminada->AdvancedSearch->SearchOperator2 = @$filter["w_Histoplasmosis_diseminada"];
		$this->Histoplasmosis_diseminada->AdvancedSearch->Save();

		// Field Linfoma_Burkitt
		$this->Linfoma_Burkitt->AdvancedSearch->SearchValue = @$filter["x_Linfoma_Burkitt"];
		$this->Linfoma_Burkitt->AdvancedSearch->SearchOperator = @$filter["z_Linfoma_Burkitt"];
		$this->Linfoma_Burkitt->AdvancedSearch->SearchCondition = @$filter["v_Linfoma_Burkitt"];
		$this->Linfoma_Burkitt->AdvancedSearch->SearchValue2 = @$filter["y_Linfoma_Burkitt"];
		$this->Linfoma_Burkitt->AdvancedSearch->SearchOperator2 = @$filter["w_Linfoma_Burkitt"];
		$this->Linfoma_Burkitt->AdvancedSearch->Save();

		// Field Neumonia_Pneumocystis
		$this->Neumonia_Pneumocystis->AdvancedSearch->SearchValue = @$filter["x_Neumonia_Pneumocystis"];
		$this->Neumonia_Pneumocystis->AdvancedSearch->SearchOperator = @$filter["z_Neumonia_Pneumocystis"];
		$this->Neumonia_Pneumocystis->AdvancedSearch->SearchCondition = @$filter["v_Neumonia_Pneumocystis"];
		$this->Neumonia_Pneumocystis->AdvancedSearch->SearchValue2 = @$filter["y_Neumonia_Pneumocystis"];
		$this->Neumonia_Pneumocystis->AdvancedSearch->SearchOperator2 = @$filter["w_Neumonia_Pneumocystis"];
		$this->Neumonia_Pneumocystis->AdvancedSearch->Save();

		// Field Neumonia_Recurrente
		$this->Neumonia_Recurrente->AdvancedSearch->SearchValue = @$filter["x_Neumonia_Recurrente"];
		$this->Neumonia_Recurrente->AdvancedSearch->SearchOperator = @$filter["z_Neumonia_Recurrente"];
		$this->Neumonia_Recurrente->AdvancedSearch->SearchCondition = @$filter["v_Neumonia_Recurrente"];
		$this->Neumonia_Recurrente->AdvancedSearch->SearchValue2 = @$filter["y_Neumonia_Recurrente"];
		$this->Neumonia_Recurrente->AdvancedSearch->SearchOperator2 = @$filter["w_Neumonia_Recurrente"];
		$this->Neumonia_Recurrente->AdvancedSearch->Save();

		// Field Linfoma_Inmunoblastico
		$this->Linfoma_Inmunoblastico->AdvancedSearch->SearchValue = @$filter["x_Linfoma_Inmunoblastico"];
		$this->Linfoma_Inmunoblastico->AdvancedSearch->SearchOperator = @$filter["z_Linfoma_Inmunoblastico"];
		$this->Linfoma_Inmunoblastico->AdvancedSearch->SearchCondition = @$filter["v_Linfoma_Inmunoblastico"];
		$this->Linfoma_Inmunoblastico->AdvancedSearch->SearchValue2 = @$filter["y_Linfoma_Inmunoblastico"];
		$this->Linfoma_Inmunoblastico->AdvancedSearch->SearchOperator2 = @$filter["w_Linfoma_Inmunoblastico"];
		$this->Linfoma_Inmunoblastico->AdvancedSearch->Save();

		// Field Criptosporidiasis_cronica
		$this->Criptosporidiasis_cronica->AdvancedSearch->SearchValue = @$filter["x_Criptosporidiasis_cronica"];
		$this->Criptosporidiasis_cronica->AdvancedSearch->SearchOperator = @$filter["z_Criptosporidiasis_cronica"];
		$this->Criptosporidiasis_cronica->AdvancedSearch->SearchCondition = @$filter["v_Criptosporidiasis_cronica"];
		$this->Criptosporidiasis_cronica->AdvancedSearch->SearchValue2 = @$filter["y_Criptosporidiasis_cronica"];
		$this->Criptosporidiasis_cronica->AdvancedSearch->SearchOperator2 = @$filter["w_Criptosporidiasis_cronica"];
		$this->Criptosporidiasis_cronica->AdvancedSearch->Save();

		// Field Criptococosis_Extrapulmonar
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchValue = @$filter["x_Criptococosis_Extrapulmonar"];
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchOperator = @$filter["z_Criptococosis_Extrapulmonar"];
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchCondition = @$filter["v_Criptococosis_Extrapulmonar"];
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchValue2 = @$filter["y_Criptococosis_Extrapulmonar"];
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchOperator2 = @$filter["w_Criptococosis_Extrapulmonar"];
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->Save();

		// Field Sarcoma_Kaposi
		$this->Sarcoma_Kaposi->AdvancedSearch->SearchValue = @$filter["x_Sarcoma_Kaposi"];
		$this->Sarcoma_Kaposi->AdvancedSearch->SearchOperator = @$filter["z_Sarcoma_Kaposi"];
		$this->Sarcoma_Kaposi->AdvancedSearch->SearchCondition = @$filter["v_Sarcoma_Kaposi"];
		$this->Sarcoma_Kaposi->AdvancedSearch->SearchValue2 = @$filter["y_Sarcoma_Kaposi"];
		$this->Sarcoma_Kaposi->AdvancedSearch->SearchOperator2 = @$filter["w_Sarcoma_Kaposi"];
		$this->Sarcoma_Kaposi->AdvancedSearch->Save();

		// Field Leucoencefalopatia_Multifocal
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchValue = @$filter["x_Leucoencefalopatia_Multifocal"];
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchOperator = @$filter["z_Leucoencefalopatia_Multifocal"];
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchCondition = @$filter["v_Leucoencefalopatia_Multifocal"];
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchValue2 = @$filter["y_Leucoencefalopatia_Multifocal"];
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchOperator2 = @$filter["w_Leucoencefalopatia_Multifocal"];
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->Save();

		// Field Septicemia_recurrente
		$this->Septicemia_recurrente->AdvancedSearch->SearchValue = @$filter["x_Septicemia_recurrente"];
		$this->Septicemia_recurrente->AdvancedSearch->SearchOperator = @$filter["z_Septicemia_recurrente"];
		$this->Septicemia_recurrente->AdvancedSearch->SearchCondition = @$filter["v_Septicemia_recurrente"];
		$this->Septicemia_recurrente->AdvancedSearch->SearchValue2 = @$filter["y_Septicemia_recurrente"];
		$this->Septicemia_recurrente->AdvancedSearch->SearchOperator2 = @$filter["w_Septicemia_recurrente"];
		$this->Septicemia_recurrente->AdvancedSearch->Save();

		// Field Toxoplasmosis_cerebral
		$this->Toxoplasmosis_cerebral->AdvancedSearch->SearchValue = @$filter["x_Toxoplasmosis_cerebral"];
		$this->Toxoplasmosis_cerebral->AdvancedSearch->SearchOperator = @$filter["z_Toxoplasmosis_cerebral"];
		$this->Toxoplasmosis_cerebral->AdvancedSearch->SearchCondition = @$filter["v_Toxoplasmosis_cerebral"];
		$this->Toxoplasmosis_cerebral->AdvancedSearch->SearchValue2 = @$filter["y_Toxoplasmosis_cerebral"];
		$this->Toxoplasmosis_cerebral->AdvancedSearch->SearchOperator2 = @$filter["w_Toxoplasmosis_cerebral"];
		$this->Toxoplasmosis_cerebral->AdvancedSearch->Save();

		// Field HepatitisB
		$this->HepatitisB->AdvancedSearch->SearchValue = @$filter["x_HepatitisB"];
		$this->HepatitisB->AdvancedSearch->SearchOperator = @$filter["z_HepatitisB"];
		$this->HepatitisB->AdvancedSearch->SearchCondition = @$filter["v_HepatitisB"];
		$this->HepatitisB->AdvancedSearch->SearchValue2 = @$filter["y_HepatitisB"];
		$this->HepatitisB->AdvancedSearch->SearchOperator2 = @$filter["w_HepatitisB"];
		$this->HepatitisB->AdvancedSearch->Save();

		// Field HepatitisC
		$this->HepatitisC->AdvancedSearch->SearchValue = @$filter["x_HepatitisC"];
		$this->HepatitisC->AdvancedSearch->SearchOperator = @$filter["z_HepatitisC"];
		$this->HepatitisC->AdvancedSearch->SearchCondition = @$filter["v_HepatitisC"];
		$this->HepatitisC->AdvancedSearch->SearchValue2 = @$filter["y_HepatitisC"];
		$this->HepatitisC->AdvancedSearch->SearchOperator2 = @$filter["w_HepatitisC"];
		$this->HepatitisC->AdvancedSearch->Save();

		// Field Meningitis
		$this->Meningitis->AdvancedSearch->SearchValue = @$filter["x_Meningitis"];
		$this->Meningitis->AdvancedSearch->SearchOperator = @$filter["z_Meningitis"];
		$this->Meningitis->AdvancedSearch->SearchCondition = @$filter["v_Meningitis"];
		$this->Meningitis->AdvancedSearch->SearchValue2 = @$filter["y_Meningitis"];
		$this->Meningitis->AdvancedSearch->SearchOperator2 = @$filter["w_Meningitis"];
		$this->Meningitis->AdvancedSearch->Save();

		// Field RecuentoCD4
		$this->RecuentoCD4->AdvancedSearch->SearchValue = @$filter["x_RecuentoCD4"];
		$this->RecuentoCD4->AdvancedSearch->SearchOperator = @$filter["z_RecuentoCD4"];
		$this->RecuentoCD4->AdvancedSearch->SearchCondition = @$filter["v_RecuentoCD4"];
		$this->RecuentoCD4->AdvancedSearch->SearchValue2 = @$filter["y_RecuentoCD4"];
		$this->RecuentoCD4->AdvancedSearch->SearchOperator2 = @$filter["w_RecuentoCD4"];
		$this->RecuentoCD4->AdvancedSearch->Save();

		// Field Registrado_Por
		$this->Registrado_Por->AdvancedSearch->SearchValue = @$filter["x_Registrado_Por"];
		$this->Registrado_Por->AdvancedSearch->SearchOperator = @$filter["z_Registrado_Por"];
		$this->Registrado_Por->AdvancedSearch->SearchCondition = @$filter["v_Registrado_Por"];
		$this->Registrado_Por->AdvancedSearch->SearchValue2 = @$filter["y_Registrado_Por"];
		$this->Registrado_Por->AdvancedSearch->SearchOperator2 = @$filter["w_Registrado_Por"];
		$this->Registrado_Por->AdvancedSearch->Save();

		// Field Localidad_residencia
		$this->Localidad_residencia->AdvancedSearch->SearchValue = @$filter["x_Localidad_residencia"];
		$this->Localidad_residencia->AdvancedSearch->SearchOperator = @$filter["z_Localidad_residencia"];
		$this->Localidad_residencia->AdvancedSearch->SearchCondition = @$filter["v_Localidad_residencia"];
		$this->Localidad_residencia->AdvancedSearch->SearchValue2 = @$filter["y_Localidad_residencia"];
		$this->Localidad_residencia->AdvancedSearch->SearchOperator2 = @$filter["w_Localidad_residencia"];
		$this->Localidad_residencia->AdvancedSearch->Save();

		// Field Barrio_residencia
		$this->Barrio_residencia->AdvancedSearch->SearchValue = @$filter["x_Barrio_residencia"];
		$this->Barrio_residencia->AdvancedSearch->SearchOperator = @$filter["z_Barrio_residencia"];
		$this->Barrio_residencia->AdvancedSearch->SearchCondition = @$filter["v_Barrio_residencia"];
		$this->Barrio_residencia->AdvancedSearch->SearchValue2 = @$filter["y_Barrio_residencia"];
		$this->Barrio_residencia->AdvancedSearch->SearchOperator2 = @$filter["w_Barrio_residencia"];
		$this->Barrio_residencia->AdvancedSearch->Save();

		// Field Fecha_ingreso_app
		$this->Fecha_ingreso_app->AdvancedSearch->SearchValue = @$filter["x_Fecha_ingreso_app"];
		$this->Fecha_ingreso_app->AdvancedSearch->SearchOperator = @$filter["z_Fecha_ingreso_app"];
		$this->Fecha_ingreso_app->AdvancedSearch->SearchCondition = @$filter["v_Fecha_ingreso_app"];
		$this->Fecha_ingreso_app->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_ingreso_app"];
		$this->Fecha_ingreso_app->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_ingreso_app"];
		$this->Fecha_ingreso_app->AdvancedSearch->Save();

		// Field Actualizado_por
		$this->Actualizado_por->AdvancedSearch->SearchValue = @$filter["x_Actualizado_por"];
		$this->Actualizado_por->AdvancedSearch->SearchOperator = @$filter["z_Actualizado_por"];
		$this->Actualizado_por->AdvancedSearch->SearchCondition = @$filter["v_Actualizado_por"];
		$this->Actualizado_por->AdvancedSearch->SearchValue2 = @$filter["y_Actualizado_por"];
		$this->Actualizado_por->AdvancedSearch->SearchOperator2 = @$filter["w_Actualizado_por"];
		$this->Actualizado_por->AdvancedSearch->Save();

		// Field Fecha_actualizacion_app
		$this->Fecha_actualizacion_app->AdvancedSearch->SearchValue = @$filter["x_Fecha_actualizacion_app"];
		$this->Fecha_actualizacion_app->AdvancedSearch->SearchOperator = @$filter["z_Fecha_actualizacion_app"];
		$this->Fecha_actualizacion_app->AdvancedSearch->SearchCondition = @$filter["v_Fecha_actualizacion_app"];
		$this->Fecha_actualizacion_app->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_actualizacion_app"];
		$this->Fecha_actualizacion_app->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_actualizacion_app"];
		$this->Fecha_actualizacion_app->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->Consecutivo, $Default, FALSE); // Consecutivo
		$this->BuildSearchSql($sWhere, $this->Seguimiento, $Default, FALSE); // Seguimiento
		$this->BuildSearchSql($sWhere, $this->Condicion_Final, $Default, FALSE); // Condicion_Final
		$this->BuildSearchSql($sWhere, $this->Codigo_centro, $Default, FALSE); // Codigo_centro
		$this->BuildSearchSql($sWhere, $this->Codigo_UPGD, $Default, FALSE); // Codigo_UPGD
		$this->BuildSearchSql($sWhere, $this->Cod_Evento, $Default, FALSE); // Cod_Evento
		$this->BuildSearchSql($sWhere, $this->Embarazo_Actual, $Default, FALSE); // Embarazo_Actual
		$this->BuildSearchSql($sWhere, $this->Fecha_Notificacion, $Default, FALSE); // Fecha_Notificacion
		$this->BuildSearchSql($sWhere, $this->Semana, $Default, FALSE); // Semana
		$this->BuildSearchSql($sWhere, $this->Periodo_Epidemiologico, $Default, FALSE); // Periodo_Epidemiologico
		$this->BuildSearchSql($sWhere, $this->Periodo_Sivigila, $Default, FALSE); // Periodo_Sivigila
		$this->BuildSearchSql($sWhere, $this->Primer_Nombre, $Default, FALSE); // Primer_Nombre
		$this->BuildSearchSql($sWhere, $this->Segundo_Nombre, $Default, FALSE); // Segundo_Nombre
		$this->BuildSearchSql($sWhere, $this->Primer_Apellido, $Default, FALSE); // Primer_Apellido
		$this->BuildSearchSql($sWhere, $this->Segundo_Apellido, $Default, FALSE); // Segundo_Apellido
		$this->BuildSearchSql($sWhere, $this->Tipo_Id, $Default, FALSE); // Tipo_Id
		$this->BuildSearchSql($sWhere, $this->Numero_Identificacion, $Default, FALSE); // Numero_Identificacion
		$this->BuildSearchSql($sWhere, $this->Edad, $Default, FALSE); // Edad
		$this->BuildSearchSql($sWhere, $this->Unidad_Edad, $Default, FALSE); // Unidad_Edad
		$this->BuildSearchSql($sWhere, $this->Sexo, $Default, FALSE); // Sexo
		$this->BuildSearchSql($sWhere, $this->Pais_Ocurrencia, $Default, FALSE); // Pais_Ocurrencia
		$this->BuildSearchSql($sWhere, $this->Depto_Ocurrencia, $Default, FALSE); // Depto_Ocurrencia
		$this->BuildSearchSql($sWhere, $this->Municipio_Ocurrencia, $Default, FALSE); // Municipio_Ocurrencia
		$this->BuildSearchSql($sWhere, $this->Area_Ocurrencia, $Default, FALSE); // Area_Ocurrencia
		$this->BuildSearchSql($sWhere, $this->Localidad, $Default, FALSE); // Localidad
		$this->BuildSearchSql($sWhere, $this->Barrio, $Default, FALSE); // Barrio
		$this->BuildSearchSql($sWhere, $this->Direccion_Residencia, $Default, FALSE); // Direccion_Residencia
		$this->BuildSearchSql($sWhere, $this->Ocupacion, $Default, FALSE); // Ocupacion
		$this->BuildSearchSql($sWhere, $this->Tipo_Regimen_Salud, $Default, FALSE); // Tipo_Regimen_Salud
		$this->BuildSearchSql($sWhere, $this->Cod_Administradora, $Default, FALSE); // Cod_Administradora
		$this->BuildSearchSql($sWhere, $this->gp_discapa, $Default, FALSE); // gp_discapa
		$this->BuildSearchSql($sWhere, $this->gp_desplaz, $Default, FALSE); // gp_desplaz
		$this->BuildSearchSql($sWhere, $this->gp_migrant, $Default, FALSE); // gp_migrant
		$this->BuildSearchSql($sWhere, $this->gp_carcela, $Default, FALSE); // gp_carcela
		$this->BuildSearchSql($sWhere, $this->gp_gestan, $Default, FALSE); // gp_gestan
		$this->BuildSearchSql($sWhere, $this->gp_indigen, $Default, FALSE); // gp_indigen
		$this->BuildSearchSql($sWhere, $this->gp_pobicbf, $Default, FALSE); // gp_pobicbf
		$this->BuildSearchSql($sWhere, $this->gp_mad_com, $Default, FALSE); // gp_mad_com
		$this->BuildSearchSql($sWhere, $this->gp_desmovi, $Default, FALSE); // gp_desmovi
		$this->BuildSearchSql($sWhere, $this->gp_psiquia, $Default, FALSE); // gp_psiquia
		$this->BuildSearchSql($sWhere, $this->gp_vic_vio, $Default, FALSE); // gp_vic_vio
		$this->BuildSearchSql($sWhere, $this->gp_otros, $Default, FALSE); // gp_otros
		$this->BuildSearchSql($sWhere, $this->Depto_Residencia, $Default, FALSE); // Depto_Residencia
		$this->BuildSearchSql($sWhere, $this->Municipio_Residencia, $Default, FALSE); // Municipio_Residencia
		$this->BuildSearchSql($sWhere, $this->Fecha_Consulta, $Default, FALSE); // Fecha_Consulta
		$this->BuildSearchSql($sWhere, $this->Fecha_Inicio_Sintomas, $Default, FALSE); // Fecha_Inicio_Sintomas
		$this->BuildSearchSql($sWhere, $this->Hospitalizado, $Default, FALSE); // Hospitalizado
		$this->BuildSearchSql($sWhere, $this->Fecha_Defuncion, $Default, FALSE); // Fecha_Defuncion
		$this->BuildSearchSql($sWhere, $this->Numero_Certificado_Defuncion, $Default, FALSE); // Numero_Certificado_Defuncion
		$this->BuildSearchSql($sWhere, $this->Causa_Basica_Muerte_CIEX, $Default, FALSE); // Causa_Basica_Muerte_CIEX
		$this->BuildSearchSql($sWhere, $this->Entidad_fallecimiento, $Default, FALSE); // Entidad_fallecimiento
		$this->BuildSearchSql($sWhere, $this->Telefono, $Default, FALSE); // Telefono
		$this->BuildSearchSql($sWhere, $this->Fecha_Nacimiento, $Default, FALSE); // Fecha_Nacimiento
		$this->BuildSearchSql($sWhere, $this->Nombre_Profesional_Diligencia, $Default, FALSE); // Nombre_Profesional_Diligencia
		$this->BuildSearchSql($sWhere, $this->Telefono_Profesional_Diligencia, $Default, FALSE); // Telefono_Profesional_Diligencia
		$this->BuildSearchSql($sWhere, $this->Mecanismo_Probable_Transmision, $Default, FALSE); // Mecanismo_Probable_Transmision
		$this->BuildSearchSql($sWhere, $this->Nombre_Madre, $Default, FALSE); // Nombre_Madre
		$this->BuildSearchSql($sWhere, $this->Tipo_Id_Madre, $Default, FALSE); // Tipo_Id_Madre
		$this->BuildSearchSql($sWhere, $this->Numero_Identificacion_Madre, $Default, FALSE); // Numero_Identificacion_Madre
		$this->BuildSearchSql($sWhere, $this->Indentidad_Genero, $Default, FALSE); // Indentidad_Genero
		$this->BuildSearchSql($sWhere, $this->Donador_Sangre_Ultimos_12_Meses, $Default, FALSE); // Donador_Sangre_Ultimos_12_Meses
		$this->BuildSearchSql($sWhere, $this->Fecha_Donacion, $Default, FALSE); // Fecha_Donacion
		$this->BuildSearchSql($sWhere, $this->Nombre_Institucion_Donacion, $Default, FALSE); // Nombre_Institucion_Donacion
		$this->BuildSearchSql($sWhere, $this->Poblacion_clave, $Default, FALSE); // Poblacion_clave
		$this->BuildSearchSql($sWhere, $this->Recibio_Asesoria_Pre_Prueba, $Default, FALSE); // Recibio_Asesoria_Pre_Prueba
		$this->BuildSearchSql($sWhere, $this->Recibio_Asesoria_Post_Prueba, $Default, FALSE); // Recibio_Asesoria_Post_Prueba
		$this->BuildSearchSql($sWhere, $this->Tipo_Prueba, $Default, FALSE); // Tipo_Prueba
		$this->BuildSearchSql($sWhere, $this->Fecha_Resultado_Confirmatorio, $Default, FALSE); // Fecha_Resultado_Confirmatorio
		$this->BuildSearchSql($sWhere, $this->Valor_Carga_Viral, $Default, FALSE); // Valor_Carga_Viral
		$this->BuildSearchSql($sWhere, $this->Estado_Clinico_Notificacion, $Default, FALSE); // Estado_Clinico_Notificacion
		$this->BuildSearchSql($sWhere, $this->Hijos_Mujeres_Menores_5, $Default, FALSE); // Hijos_Mujeres_Menores_5
		$this->BuildSearchSql($sWhere, $this->Hijos_Hombres_Menores_5, $Default, FALSE); // Hijos_Hombres_Menores_5
		$this->BuildSearchSql($sWhere, $this->Numero_Semanas_Embarazo, $Default, FALSE); // Numero_Semanas_Embarazo
		$this->BuildSearchSql($sWhere, $this->Antecedentes_Embarazo, $Default, FALSE); // Antecedentes_Embarazo
		$this->BuildSearchSql($sWhere, $this->Candidiasis_esofagica, $Default, FALSE); // Candidiasis_esofagica
		$this->BuildSearchSql($sWhere, $this->Candidiasis_vias_aereas, $Default, FALSE); // Candidiasis_vias_aereas
		$this->BuildSearchSql($sWhere, $this->Tuberculosis_pulmonar, $Default, FALSE); // Tuberculosis_pulmonar
		$this->BuildSearchSql($sWhere, $this->Cancer_cervical, $Default, FALSE); // Cancer_cervical
		$this->BuildSearchSql($sWhere, $this->Tuberculosis_extrapulmonar, $Default, FALSE); // Tuberculosis_extrapulmonar
		$this->BuildSearchSql($sWhere, $this->Coccidiomicosis, $Default, FALSE); // Coccidiomicosis
		$this->BuildSearchSql($sWhere, $this->Citomegalovirosis, $Default, FALSE); // Citomegalovirosis
		$this->BuildSearchSql($sWhere, $this->Retinitis_citomegalovirosis, $Default, FALSE); // Retinitis_citomegalovirosis
		$this->BuildSearchSql($sWhere, $this->Sindrome_Emanciacion, $Default, FALSE); // Sindrome_Emanciacion
		$this->BuildSearchSql($sWhere, $this->Encefalopatia, $Default, FALSE); // Encefalopatia
		$this->BuildSearchSql($sWhere, $this->Otras_micobacterias, $Default, FALSE); // Otras_micobacterias
		$this->BuildSearchSql($sWhere, $this->Histoplasmosis_Extrapulmonar, $Default, FALSE); // Histoplasmosis_Extrapulmonar
		$this->BuildSearchSql($sWhere, $this->isosporidiasis_cronica, $Default, FALSE); // isosporidiasis_cronica
		$this->BuildSearchSql($sWhere, $this->herpes_zoster, $Default, FALSE); // herpes_zoster
		$this->BuildSearchSql($sWhere, $this->Histoplasmosis_diseminada, $Default, FALSE); // Histoplasmosis_diseminada
		$this->BuildSearchSql($sWhere, $this->Linfoma_Burkitt, $Default, FALSE); // Linfoma_Burkitt
		$this->BuildSearchSql($sWhere, $this->Neumonia_Pneumocystis, $Default, FALSE); // Neumonia_Pneumocystis
		$this->BuildSearchSql($sWhere, $this->Neumonia_Recurrente, $Default, FALSE); // Neumonia_Recurrente
		$this->BuildSearchSql($sWhere, $this->Linfoma_Inmunoblastico, $Default, FALSE); // Linfoma_Inmunoblastico
		$this->BuildSearchSql($sWhere, $this->Criptosporidiasis_cronica, $Default, FALSE); // Criptosporidiasis_cronica
		$this->BuildSearchSql($sWhere, $this->Criptococosis_Extrapulmonar, $Default, FALSE); // Criptococosis_Extrapulmonar
		$this->BuildSearchSql($sWhere, $this->Sarcoma_Kaposi, $Default, FALSE); // Sarcoma_Kaposi
		$this->BuildSearchSql($sWhere, $this->Leucoencefalopatia_Multifocal, $Default, FALSE); // Leucoencefalopatia_Multifocal
		$this->BuildSearchSql($sWhere, $this->Septicemia_recurrente, $Default, FALSE); // Septicemia_recurrente
		$this->BuildSearchSql($sWhere, $this->Toxoplasmosis_cerebral, $Default, FALSE); // Toxoplasmosis_cerebral
		$this->BuildSearchSql($sWhere, $this->HepatitisB, $Default, FALSE); // HepatitisB
		$this->BuildSearchSql($sWhere, $this->HepatitisC, $Default, FALSE); // HepatitisC
		$this->BuildSearchSql($sWhere, $this->Meningitis, $Default, FALSE); // Meningitis
		$this->BuildSearchSql($sWhere, $this->RecuentoCD4, $Default, FALSE); // RecuentoCD4
		$this->BuildSearchSql($sWhere, $this->Registrado_Por, $Default, FALSE); // Registrado_Por
		$this->BuildSearchSql($sWhere, $this->Localidad_residencia, $Default, FALSE); // Localidad_residencia
		$this->BuildSearchSql($sWhere, $this->Barrio_residencia, $Default, FALSE); // Barrio_residencia
		$this->BuildSearchSql($sWhere, $this->Fecha_ingreso_app, $Default, FALSE); // Fecha_ingreso_app
		$this->BuildSearchSql($sWhere, $this->Actualizado_por, $Default, FALSE); // Actualizado_por
		$this->BuildSearchSql($sWhere, $this->Fecha_actualizacion_app, $Default, FALSE); // Fecha_actualizacion_app

		// Set up search parm
		if (!$Default && $sWhere <> "") {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->Consecutivo->AdvancedSearch->Save(); // Consecutivo
			$this->Seguimiento->AdvancedSearch->Save(); // Seguimiento
			$this->Condicion_Final->AdvancedSearch->Save(); // Condicion_Final
			$this->Codigo_centro->AdvancedSearch->Save(); // Codigo_centro
			$this->Codigo_UPGD->AdvancedSearch->Save(); // Codigo_UPGD
			$this->Cod_Evento->AdvancedSearch->Save(); // Cod_Evento
			$this->Embarazo_Actual->AdvancedSearch->Save(); // Embarazo_Actual
			$this->Fecha_Notificacion->AdvancedSearch->Save(); // Fecha_Notificacion
			$this->Semana->AdvancedSearch->Save(); // Semana
			$this->Periodo_Epidemiologico->AdvancedSearch->Save(); // Periodo_Epidemiologico
			$this->Periodo_Sivigila->AdvancedSearch->Save(); // Periodo_Sivigila
			$this->Primer_Nombre->AdvancedSearch->Save(); // Primer_Nombre
			$this->Segundo_Nombre->AdvancedSearch->Save(); // Segundo_Nombre
			$this->Primer_Apellido->AdvancedSearch->Save(); // Primer_Apellido
			$this->Segundo_Apellido->AdvancedSearch->Save(); // Segundo_Apellido
			$this->Tipo_Id->AdvancedSearch->Save(); // Tipo_Id
			$this->Numero_Identificacion->AdvancedSearch->Save(); // Numero_Identificacion
			$this->Edad->AdvancedSearch->Save(); // Edad
			$this->Unidad_Edad->AdvancedSearch->Save(); // Unidad_Edad
			$this->Sexo->AdvancedSearch->Save(); // Sexo
			$this->Pais_Ocurrencia->AdvancedSearch->Save(); // Pais_Ocurrencia
			$this->Depto_Ocurrencia->AdvancedSearch->Save(); // Depto_Ocurrencia
			$this->Municipio_Ocurrencia->AdvancedSearch->Save(); // Municipio_Ocurrencia
			$this->Area_Ocurrencia->AdvancedSearch->Save(); // Area_Ocurrencia
			$this->Localidad->AdvancedSearch->Save(); // Localidad
			$this->Barrio->AdvancedSearch->Save(); // Barrio
			$this->Direccion_Residencia->AdvancedSearch->Save(); // Direccion_Residencia
			$this->Ocupacion->AdvancedSearch->Save(); // Ocupacion
			$this->Tipo_Regimen_Salud->AdvancedSearch->Save(); // Tipo_Regimen_Salud
			$this->Cod_Administradora->AdvancedSearch->Save(); // Cod_Administradora
			$this->gp_discapa->AdvancedSearch->Save(); // gp_discapa
			$this->gp_desplaz->AdvancedSearch->Save(); // gp_desplaz
			$this->gp_migrant->AdvancedSearch->Save(); // gp_migrant
			$this->gp_carcela->AdvancedSearch->Save(); // gp_carcela
			$this->gp_gestan->AdvancedSearch->Save(); // gp_gestan
			$this->gp_indigen->AdvancedSearch->Save(); // gp_indigen
			$this->gp_pobicbf->AdvancedSearch->Save(); // gp_pobicbf
			$this->gp_mad_com->AdvancedSearch->Save(); // gp_mad_com
			$this->gp_desmovi->AdvancedSearch->Save(); // gp_desmovi
			$this->gp_psiquia->AdvancedSearch->Save(); // gp_psiquia
			$this->gp_vic_vio->AdvancedSearch->Save(); // gp_vic_vio
			$this->gp_otros->AdvancedSearch->Save(); // gp_otros
			$this->Depto_Residencia->AdvancedSearch->Save(); // Depto_Residencia
			$this->Municipio_Residencia->AdvancedSearch->Save(); // Municipio_Residencia
			$this->Fecha_Consulta->AdvancedSearch->Save(); // Fecha_Consulta
			$this->Fecha_Inicio_Sintomas->AdvancedSearch->Save(); // Fecha_Inicio_Sintomas
			$this->Hospitalizado->AdvancedSearch->Save(); // Hospitalizado
			$this->Fecha_Defuncion->AdvancedSearch->Save(); // Fecha_Defuncion
			$this->Numero_Certificado_Defuncion->AdvancedSearch->Save(); // Numero_Certificado_Defuncion
			$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->Save(); // Causa_Basica_Muerte_CIEX
			$this->Entidad_fallecimiento->AdvancedSearch->Save(); // Entidad_fallecimiento
			$this->Telefono->AdvancedSearch->Save(); // Telefono
			$this->Fecha_Nacimiento->AdvancedSearch->Save(); // Fecha_Nacimiento
			$this->Nombre_Profesional_Diligencia->AdvancedSearch->Save(); // Nombre_Profesional_Diligencia
			$this->Telefono_Profesional_Diligencia->AdvancedSearch->Save(); // Telefono_Profesional_Diligencia
			$this->Mecanismo_Probable_Transmision->AdvancedSearch->Save(); // Mecanismo_Probable_Transmision
			$this->Nombre_Madre->AdvancedSearch->Save(); // Nombre_Madre
			$this->Tipo_Id_Madre->AdvancedSearch->Save(); // Tipo_Id_Madre
			$this->Numero_Identificacion_Madre->AdvancedSearch->Save(); // Numero_Identificacion_Madre
			$this->Indentidad_Genero->AdvancedSearch->Save(); // Indentidad_Genero
			$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->Save(); // Donador_Sangre_Ultimos_12_Meses
			$this->Fecha_Donacion->AdvancedSearch->Save(); // Fecha_Donacion
			$this->Nombre_Institucion_Donacion->AdvancedSearch->Save(); // Nombre_Institucion_Donacion
			$this->Poblacion_clave->AdvancedSearch->Save(); // Poblacion_clave
			$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->Save(); // Recibio_Asesoria_Pre_Prueba
			$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->Save(); // Recibio_Asesoria_Post_Prueba
			$this->Tipo_Prueba->AdvancedSearch->Save(); // Tipo_Prueba
			$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->Save(); // Fecha_Resultado_Confirmatorio
			$this->Valor_Carga_Viral->AdvancedSearch->Save(); // Valor_Carga_Viral
			$this->Estado_Clinico_Notificacion->AdvancedSearch->Save(); // Estado_Clinico_Notificacion
			$this->Hijos_Mujeres_Menores_5->AdvancedSearch->Save(); // Hijos_Mujeres_Menores_5
			$this->Hijos_Hombres_Menores_5->AdvancedSearch->Save(); // Hijos_Hombres_Menores_5
			$this->Numero_Semanas_Embarazo->AdvancedSearch->Save(); // Numero_Semanas_Embarazo
			$this->Antecedentes_Embarazo->AdvancedSearch->Save(); // Antecedentes_Embarazo
			$this->Candidiasis_esofagica->AdvancedSearch->Save(); // Candidiasis_esofagica
			$this->Candidiasis_vias_aereas->AdvancedSearch->Save(); // Candidiasis_vias_aereas
			$this->Tuberculosis_pulmonar->AdvancedSearch->Save(); // Tuberculosis_pulmonar
			$this->Cancer_cervical->AdvancedSearch->Save(); // Cancer_cervical
			$this->Tuberculosis_extrapulmonar->AdvancedSearch->Save(); // Tuberculosis_extrapulmonar
			$this->Coccidiomicosis->AdvancedSearch->Save(); // Coccidiomicosis
			$this->Citomegalovirosis->AdvancedSearch->Save(); // Citomegalovirosis
			$this->Retinitis_citomegalovirosis->AdvancedSearch->Save(); // Retinitis_citomegalovirosis
			$this->Sindrome_Emanciacion->AdvancedSearch->Save(); // Sindrome_Emanciacion
			$this->Encefalopatia->AdvancedSearch->Save(); // Encefalopatia
			$this->Otras_micobacterias->AdvancedSearch->Save(); // Otras_micobacterias
			$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->Save(); // Histoplasmosis_Extrapulmonar
			$this->isosporidiasis_cronica->AdvancedSearch->Save(); // isosporidiasis_cronica
			$this->herpes_zoster->AdvancedSearch->Save(); // herpes_zoster
			$this->Histoplasmosis_diseminada->AdvancedSearch->Save(); // Histoplasmosis_diseminada
			$this->Linfoma_Burkitt->AdvancedSearch->Save(); // Linfoma_Burkitt
			$this->Neumonia_Pneumocystis->AdvancedSearch->Save(); // Neumonia_Pneumocystis
			$this->Neumonia_Recurrente->AdvancedSearch->Save(); // Neumonia_Recurrente
			$this->Linfoma_Inmunoblastico->AdvancedSearch->Save(); // Linfoma_Inmunoblastico
			$this->Criptosporidiasis_cronica->AdvancedSearch->Save(); // Criptosporidiasis_cronica
			$this->Criptococosis_Extrapulmonar->AdvancedSearch->Save(); // Criptococosis_Extrapulmonar
			$this->Sarcoma_Kaposi->AdvancedSearch->Save(); // Sarcoma_Kaposi
			$this->Leucoencefalopatia_Multifocal->AdvancedSearch->Save(); // Leucoencefalopatia_Multifocal
			$this->Septicemia_recurrente->AdvancedSearch->Save(); // Septicemia_recurrente
			$this->Toxoplasmosis_cerebral->AdvancedSearch->Save(); // Toxoplasmosis_cerebral
			$this->HepatitisB->AdvancedSearch->Save(); // HepatitisB
			$this->HepatitisC->AdvancedSearch->Save(); // HepatitisC
			$this->Meningitis->AdvancedSearch->Save(); // Meningitis
			$this->RecuentoCD4->AdvancedSearch->Save(); // RecuentoCD4
			$this->Registrado_Por->AdvancedSearch->Save(); // Registrado_Por
			$this->Localidad_residencia->AdvancedSearch->Save(); // Localidad_residencia
			$this->Barrio_residencia->AdvancedSearch->Save(); // Barrio_residencia
			$this->Fecha_ingreso_app->AdvancedSearch->Save(); // Fecha_ingreso_app
			$this->Actualizado_por->AdvancedSearch->Save(); // Actualizado_por
			$this->Fecha_actualizacion_app->AdvancedSearch->Save(); // Fecha_actualizacion_app
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = substr($Fld->FldVar, 2);
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";

		//$FldVal = ew_StripSlashes($FldVal);
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);

		//$FldVal2 = ew_StripSlashes($FldVal2);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1 || $FldOpr <> "LIKE" ||
			($FldOpr2 <> "LIKE" && $FldVal2 <> ""))
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Seguimiento, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Condicion_Final, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_UPGD, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Fecha_Notificacion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Periodo_Sivigila, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Primer_Nombre, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Segundo_Nombre, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Primer_Apellido, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Segundo_Apellido, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Numero_Identificacion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Edad, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Sexo, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Localidad, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Tipo_Regimen_Salud, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Cod_Administradora, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Donador_Sangre_Ultimos_12_Meses, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Estado_Clinico_Notificacion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Localidad_residencia, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Barrio_residencia, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Actualizado_por, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->Consecutivo->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Seguimiento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Condicion_Final->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Codigo_centro->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Codigo_UPGD->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Cod_Evento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Embarazo_Actual->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Notificacion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Semana->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Periodo_Epidemiologico->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Periodo_Sivigila->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Primer_Nombre->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Segundo_Nombre->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Primer_Apellido->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Segundo_Apellido->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_Id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Numero_Identificacion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Unidad_Edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Sexo->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Pais_Ocurrencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Depto_Ocurrencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Municipio_Ocurrencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Area_Ocurrencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Localidad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Barrio->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Direccion_Residencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Ocupacion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_Regimen_Salud->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Cod_Administradora->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_discapa->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_desplaz->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_migrant->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_carcela->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_gestan->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_indigen->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_pobicbf->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_mad_com->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_desmovi->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_psiquia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_vic_vio->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->gp_otros->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Depto_Residencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Municipio_Residencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Consulta->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Inicio_Sintomas->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Hospitalizado->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Defuncion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Numero_Certificado_Defuncion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Causa_Basica_Muerte_CIEX->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Entidad_fallecimiento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Telefono->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Nacimiento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Nombre_Profesional_Diligencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Telefono_Profesional_Diligencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Mecanismo_Probable_Transmision->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Nombre_Madre->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_Id_Madre->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Numero_Identificacion_Madre->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Indentidad_Genero->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Donacion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Nombre_Institucion_Donacion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Poblacion_clave->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_Prueba->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Resultado_Confirmatorio->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Valor_Carga_Viral->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Estado_Clinico_Notificacion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Hijos_Mujeres_Menores_5->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Hijos_Hombres_Menores_5->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Numero_Semanas_Embarazo->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Antecedentes_Embarazo->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Candidiasis_esofagica->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Candidiasis_vias_aereas->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tuberculosis_pulmonar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Cancer_cervical->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tuberculosis_extrapulmonar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Coccidiomicosis->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Citomegalovirosis->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Retinitis_citomegalovirosis->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Sindrome_Emanciacion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Encefalopatia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Otras_micobacterias->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Histoplasmosis_Extrapulmonar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->isosporidiasis_cronica->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->herpes_zoster->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Histoplasmosis_diseminada->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Linfoma_Burkitt->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Neumonia_Pneumocystis->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Neumonia_Recurrente->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Linfoma_Inmunoblastico->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Criptosporidiasis_cronica->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Criptococosis_Extrapulmonar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Sarcoma_Kaposi->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Leucoencefalopatia_Multifocal->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Septicemia_recurrente->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Toxoplasmosis_cerebral->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->HepatitisB->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->HepatitisC->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Meningitis->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->RecuentoCD4->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Registrado_Por->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Localidad_residencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Barrio_residencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_ingreso_app->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Actualizado_por->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_actualizacion_app->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->Consecutivo->AdvancedSearch->UnsetSession();
		$this->Seguimiento->AdvancedSearch->UnsetSession();
		$this->Condicion_Final->AdvancedSearch->UnsetSession();
		$this->Codigo_centro->AdvancedSearch->UnsetSession();
		$this->Codigo_UPGD->AdvancedSearch->UnsetSession();
		$this->Cod_Evento->AdvancedSearch->UnsetSession();
		$this->Embarazo_Actual->AdvancedSearch->UnsetSession();
		$this->Fecha_Notificacion->AdvancedSearch->UnsetSession();
		$this->Semana->AdvancedSearch->UnsetSession();
		$this->Periodo_Epidemiologico->AdvancedSearch->UnsetSession();
		$this->Periodo_Sivigila->AdvancedSearch->UnsetSession();
		$this->Primer_Nombre->AdvancedSearch->UnsetSession();
		$this->Segundo_Nombre->AdvancedSearch->UnsetSession();
		$this->Primer_Apellido->AdvancedSearch->UnsetSession();
		$this->Segundo_Apellido->AdvancedSearch->UnsetSession();
		$this->Tipo_Id->AdvancedSearch->UnsetSession();
		$this->Numero_Identificacion->AdvancedSearch->UnsetSession();
		$this->Edad->AdvancedSearch->UnsetSession();
		$this->Unidad_Edad->AdvancedSearch->UnsetSession();
		$this->Sexo->AdvancedSearch->UnsetSession();
		$this->Pais_Ocurrencia->AdvancedSearch->UnsetSession();
		$this->Depto_Ocurrencia->AdvancedSearch->UnsetSession();
		$this->Municipio_Ocurrencia->AdvancedSearch->UnsetSession();
		$this->Area_Ocurrencia->AdvancedSearch->UnsetSession();
		$this->Localidad->AdvancedSearch->UnsetSession();
		$this->Barrio->AdvancedSearch->UnsetSession();
		$this->Direccion_Residencia->AdvancedSearch->UnsetSession();
		$this->Ocupacion->AdvancedSearch->UnsetSession();
		$this->Tipo_Regimen_Salud->AdvancedSearch->UnsetSession();
		$this->Cod_Administradora->AdvancedSearch->UnsetSession();
		$this->gp_discapa->AdvancedSearch->UnsetSession();
		$this->gp_desplaz->AdvancedSearch->UnsetSession();
		$this->gp_migrant->AdvancedSearch->UnsetSession();
		$this->gp_carcela->AdvancedSearch->UnsetSession();
		$this->gp_gestan->AdvancedSearch->UnsetSession();
		$this->gp_indigen->AdvancedSearch->UnsetSession();
		$this->gp_pobicbf->AdvancedSearch->UnsetSession();
		$this->gp_mad_com->AdvancedSearch->UnsetSession();
		$this->gp_desmovi->AdvancedSearch->UnsetSession();
		$this->gp_psiquia->AdvancedSearch->UnsetSession();
		$this->gp_vic_vio->AdvancedSearch->UnsetSession();
		$this->gp_otros->AdvancedSearch->UnsetSession();
		$this->Depto_Residencia->AdvancedSearch->UnsetSession();
		$this->Municipio_Residencia->AdvancedSearch->UnsetSession();
		$this->Fecha_Consulta->AdvancedSearch->UnsetSession();
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->UnsetSession();
		$this->Hospitalizado->AdvancedSearch->UnsetSession();
		$this->Fecha_Defuncion->AdvancedSearch->UnsetSession();
		$this->Numero_Certificado_Defuncion->AdvancedSearch->UnsetSession();
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->UnsetSession();
		$this->Entidad_fallecimiento->AdvancedSearch->UnsetSession();
		$this->Telefono->AdvancedSearch->UnsetSession();
		$this->Fecha_Nacimiento->AdvancedSearch->UnsetSession();
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->UnsetSession();
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->UnsetSession();
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->UnsetSession();
		$this->Nombre_Madre->AdvancedSearch->UnsetSession();
		$this->Tipo_Id_Madre->AdvancedSearch->UnsetSession();
		$this->Numero_Identificacion_Madre->AdvancedSearch->UnsetSession();
		$this->Indentidad_Genero->AdvancedSearch->UnsetSession();
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->UnsetSession();
		$this->Fecha_Donacion->AdvancedSearch->UnsetSession();
		$this->Nombre_Institucion_Donacion->AdvancedSearch->UnsetSession();
		$this->Poblacion_clave->AdvancedSearch->UnsetSession();
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->UnsetSession();
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->UnsetSession();
		$this->Tipo_Prueba->AdvancedSearch->UnsetSession();
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->UnsetSession();
		$this->Valor_Carga_Viral->AdvancedSearch->UnsetSession();
		$this->Estado_Clinico_Notificacion->AdvancedSearch->UnsetSession();
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->UnsetSession();
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->UnsetSession();
		$this->Numero_Semanas_Embarazo->AdvancedSearch->UnsetSession();
		$this->Antecedentes_Embarazo->AdvancedSearch->UnsetSession();
		$this->Candidiasis_esofagica->AdvancedSearch->UnsetSession();
		$this->Candidiasis_vias_aereas->AdvancedSearch->UnsetSession();
		$this->Tuberculosis_pulmonar->AdvancedSearch->UnsetSession();
		$this->Cancer_cervical->AdvancedSearch->UnsetSession();
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->UnsetSession();
		$this->Coccidiomicosis->AdvancedSearch->UnsetSession();
		$this->Citomegalovirosis->AdvancedSearch->UnsetSession();
		$this->Retinitis_citomegalovirosis->AdvancedSearch->UnsetSession();
		$this->Sindrome_Emanciacion->AdvancedSearch->UnsetSession();
		$this->Encefalopatia->AdvancedSearch->UnsetSession();
		$this->Otras_micobacterias->AdvancedSearch->UnsetSession();
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->UnsetSession();
		$this->isosporidiasis_cronica->AdvancedSearch->UnsetSession();
		$this->herpes_zoster->AdvancedSearch->UnsetSession();
		$this->Histoplasmosis_diseminada->AdvancedSearch->UnsetSession();
		$this->Linfoma_Burkitt->AdvancedSearch->UnsetSession();
		$this->Neumonia_Pneumocystis->AdvancedSearch->UnsetSession();
		$this->Neumonia_Recurrente->AdvancedSearch->UnsetSession();
		$this->Linfoma_Inmunoblastico->AdvancedSearch->UnsetSession();
		$this->Criptosporidiasis_cronica->AdvancedSearch->UnsetSession();
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->UnsetSession();
		$this->Sarcoma_Kaposi->AdvancedSearch->UnsetSession();
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->UnsetSession();
		$this->Septicemia_recurrente->AdvancedSearch->UnsetSession();
		$this->Toxoplasmosis_cerebral->AdvancedSearch->UnsetSession();
		$this->HepatitisB->AdvancedSearch->UnsetSession();
		$this->HepatitisC->AdvancedSearch->UnsetSession();
		$this->Meningitis->AdvancedSearch->UnsetSession();
		$this->RecuentoCD4->AdvancedSearch->UnsetSession();
		$this->Registrado_Por->AdvancedSearch->UnsetSession();
		$this->Localidad_residencia->AdvancedSearch->UnsetSession();
		$this->Barrio_residencia->AdvancedSearch->UnsetSession();
		$this->Fecha_ingreso_app->AdvancedSearch->UnsetSession();
		$this->Actualizado_por->AdvancedSearch->UnsetSession();
		$this->Fecha_actualizacion_app->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->Consecutivo->AdvancedSearch->Load();
		$this->Seguimiento->AdvancedSearch->Load();
		$this->Condicion_Final->AdvancedSearch->Load();
		$this->Codigo_centro->AdvancedSearch->Load();
		$this->Codigo_UPGD->AdvancedSearch->Load();
		$this->Cod_Evento->AdvancedSearch->Load();
		$this->Embarazo_Actual->AdvancedSearch->Load();
		$this->Fecha_Notificacion->AdvancedSearch->Load();
		$this->Semana->AdvancedSearch->Load();
		$this->Periodo_Epidemiologico->AdvancedSearch->Load();
		$this->Periodo_Sivigila->AdvancedSearch->Load();
		$this->Primer_Nombre->AdvancedSearch->Load();
		$this->Segundo_Nombre->AdvancedSearch->Load();
		$this->Primer_Apellido->AdvancedSearch->Load();
		$this->Segundo_Apellido->AdvancedSearch->Load();
		$this->Tipo_Id->AdvancedSearch->Load();
		$this->Numero_Identificacion->AdvancedSearch->Load();
		$this->Edad->AdvancedSearch->Load();
		$this->Unidad_Edad->AdvancedSearch->Load();
		$this->Sexo->AdvancedSearch->Load();
		$this->Pais_Ocurrencia->AdvancedSearch->Load();
		$this->Depto_Ocurrencia->AdvancedSearch->Load();
		$this->Municipio_Ocurrencia->AdvancedSearch->Load();
		$this->Area_Ocurrencia->AdvancedSearch->Load();
		$this->Localidad->AdvancedSearch->Load();
		$this->Barrio->AdvancedSearch->Load();
		$this->Direccion_Residencia->AdvancedSearch->Load();
		$this->Ocupacion->AdvancedSearch->Load();
		$this->Tipo_Regimen_Salud->AdvancedSearch->Load();
		$this->Cod_Administradora->AdvancedSearch->Load();
		$this->gp_discapa->AdvancedSearch->Load();
		$this->gp_desplaz->AdvancedSearch->Load();
		$this->gp_migrant->AdvancedSearch->Load();
		$this->gp_carcela->AdvancedSearch->Load();
		$this->gp_gestan->AdvancedSearch->Load();
		$this->gp_indigen->AdvancedSearch->Load();
		$this->gp_pobicbf->AdvancedSearch->Load();
		$this->gp_mad_com->AdvancedSearch->Load();
		$this->gp_desmovi->AdvancedSearch->Load();
		$this->gp_psiquia->AdvancedSearch->Load();
		$this->gp_vic_vio->AdvancedSearch->Load();
		$this->gp_otros->AdvancedSearch->Load();
		$this->Depto_Residencia->AdvancedSearch->Load();
		$this->Municipio_Residencia->AdvancedSearch->Load();
		$this->Fecha_Consulta->AdvancedSearch->Load();
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->Load();
		$this->Hospitalizado->AdvancedSearch->Load();
		$this->Fecha_Defuncion->AdvancedSearch->Load();
		$this->Numero_Certificado_Defuncion->AdvancedSearch->Load();
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->Load();
		$this->Entidad_fallecimiento->AdvancedSearch->Load();
		$this->Telefono->AdvancedSearch->Load();
		$this->Fecha_Nacimiento->AdvancedSearch->Load();
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->Load();
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->Load();
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->Load();
		$this->Nombre_Madre->AdvancedSearch->Load();
		$this->Tipo_Id_Madre->AdvancedSearch->Load();
		$this->Numero_Identificacion_Madre->AdvancedSearch->Load();
		$this->Indentidad_Genero->AdvancedSearch->Load();
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->Load();
		$this->Fecha_Donacion->AdvancedSearch->Load();
		$this->Nombre_Institucion_Donacion->AdvancedSearch->Load();
		$this->Poblacion_clave->AdvancedSearch->Load();
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->Load();
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->Load();
		$this->Tipo_Prueba->AdvancedSearch->Load();
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->Load();
		$this->Valor_Carga_Viral->AdvancedSearch->Load();
		$this->Estado_Clinico_Notificacion->AdvancedSearch->Load();
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->Load();
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->Load();
		$this->Numero_Semanas_Embarazo->AdvancedSearch->Load();
		$this->Antecedentes_Embarazo->AdvancedSearch->Load();
		$this->Candidiasis_esofagica->AdvancedSearch->Load();
		$this->Candidiasis_vias_aereas->AdvancedSearch->Load();
		$this->Tuberculosis_pulmonar->AdvancedSearch->Load();
		$this->Cancer_cervical->AdvancedSearch->Load();
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->Load();
		$this->Coccidiomicosis->AdvancedSearch->Load();
		$this->Citomegalovirosis->AdvancedSearch->Load();
		$this->Retinitis_citomegalovirosis->AdvancedSearch->Load();
		$this->Sindrome_Emanciacion->AdvancedSearch->Load();
		$this->Encefalopatia->AdvancedSearch->Load();
		$this->Otras_micobacterias->AdvancedSearch->Load();
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->Load();
		$this->isosporidiasis_cronica->AdvancedSearch->Load();
		$this->herpes_zoster->AdvancedSearch->Load();
		$this->Histoplasmosis_diseminada->AdvancedSearch->Load();
		$this->Linfoma_Burkitt->AdvancedSearch->Load();
		$this->Neumonia_Pneumocystis->AdvancedSearch->Load();
		$this->Neumonia_Recurrente->AdvancedSearch->Load();
		$this->Linfoma_Inmunoblastico->AdvancedSearch->Load();
		$this->Criptosporidiasis_cronica->AdvancedSearch->Load();
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->Load();
		$this->Sarcoma_Kaposi->AdvancedSearch->Load();
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->Load();
		$this->Septicemia_recurrente->AdvancedSearch->Load();
		$this->Toxoplasmosis_cerebral->AdvancedSearch->Load();
		$this->HepatitisB->AdvancedSearch->Load();
		$this->HepatitisC->AdvancedSearch->Load();
		$this->Meningitis->AdvancedSearch->Load();
		$this->RecuentoCD4->AdvancedSearch->Load();
		$this->Registrado_Por->AdvancedSearch->Load();
		$this->Localidad_residencia->AdvancedSearch->Load();
		$this->Barrio_residencia->AdvancedSearch->Load();
		$this->Fecha_ingreso_app->AdvancedSearch->Load();
		$this->Actualizado_por->AdvancedSearch->Load();
		$this->Fecha_actualizacion_app->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Seguimiento); // Seguimiento
			$this->UpdateSort($this->Condicion_Final); // Condicion_Final
			$this->UpdateSort($this->Codigo_centro); // Codigo_centro
			$this->UpdateSort($this->Codigo_UPGD); // Codigo_UPGD
			$this->UpdateSort($this->Embarazo_Actual); // Embarazo_Actual
			$this->UpdateSort($this->Fecha_Notificacion); // Fecha_Notificacion
			$this->UpdateSort($this->Primer_Nombre); // Primer_Nombre
			$this->UpdateSort($this->Segundo_Nombre); // Segundo_Nombre
			$this->UpdateSort($this->Primer_Apellido); // Primer_Apellido
			$this->UpdateSort($this->Numero_Identificacion); // Numero_Identificacion
			$this->UpdateSort($this->Tipo_Regimen_Salud); // Tipo_Regimen_Salud
			$this->UpdateSort($this->Cod_Administradora); // Cod_Administradora
			$this->UpdateSort($this->Hospitalizado); // Hospitalizado
			$this->UpdateSort($this->Mecanismo_Probable_Transmision); // Mecanismo_Probable_Transmision
			$this->UpdateSort($this->Estado_Clinico_Notificacion); // Estado_Clinico_Notificacion
			$this->UpdateSort($this->Registrado_Por); // Registrado_Por
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
				$this->Fecha_Notificacion->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Seguimiento->setSort("");
				$this->Condicion_Final->setSort("");
				$this->Codigo_centro->setSort("");
				$this->Codigo_UPGD->setSort("");
				$this->Embarazo_Actual->setSort("");
				$this->Fecha_Notificacion->setSort("");
				$this->Primer_Nombre->setSort("");
				$this->Segundo_Nombre->setSort("");
				$this->Primer_Apellido->setSort("");
				$this->Numero_Identificacion->setSort("");
				$this->Tipo_Regimen_Salud->setSort("");
				$this->Cod_Administradora->setSort("");
				$this->Hospitalizado->setSort("");
				$this->Mecanismo_Probable_Transmision->setSort("");
				$this->Estado_Clinico_Notificacion->setSort("");
				$this->Registrado_Por->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// "detail_seguimiento_individual3"
		$item = &$this->ListOptions->Add("detail_seguimiento_individual3");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->AllowList(CurrentProjectID() . 'seguimiento_individual3') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["seguimiento_individual3_grid"])) $GLOBALS["seguimiento_individual3_grid"] = new cseguimiento_individual3_grid;

		// "detail_seguimiento_materno"
		$item = &$this->ListOptions->Add("detail_seguimiento_materno");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->AllowList(CurrentProjectID() . 'seguimiento_materno') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["seguimiento_materno_grid"])) $GLOBALS["seguimiento_materno_grid"] = new cseguimiento_materno_grid;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$this->ListOptions->Add("details");
			$item->CssStyle = "white-space: nowrap;";
			$item->Visible = $this->ShowMultipleDetails;
			$item->OnLeft = TRUE;
			$item->ShowInButtonGroup = FALSE;
		}

		// Set up detail pages
		$pages = new cSubPages();
		$pages->Add("seguimiento_individual3");
		$pages->Add("seguimiento_materno");
		$this->DetailPages = $pages;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		if ($Security->CanView() && $this->ShowOptionLink('view'))
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		else
			$oListOpt->Body = "";

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		if ($Security->CanEdit() && $this->ShowOptionLink('edit')) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		if ($Security->CanAdd() && $this->ShowOptionLink('add')) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . ew_HtmlTitle($Language->Phrase("CopyLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("CopyLink")) . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}
		$DetailViewTblVar = "";
		$DetailCopyTblVar = "";
		$DetailEditTblVar = "";

		// "detail_seguimiento_individual3"
		$oListOpt = &$this->ListOptions->Items["detail_seguimiento_individual3"];
		if ($Security->AllowList(CurrentProjectID() . 'seguimiento_individual3') && $this->ShowOptionLink()) {
			$body = $Language->Phrase("DetailLink") . $Language->TablePhrase("seguimiento_individual3", "TblCaption");
			$body .= str_replace("%c", $this->seguimiento_individual3_Count, $Language->Phrase("DetailCount"));
			$body = "<a class=\"btn btn-default btn-sm ewRowLink ewDetail\" data-action=\"list\" href=\"" . ew_HtmlEncode("seguimiento_individual3list.php?" . EW_TABLE_SHOW_MASTER . "=registro&fk_Consecutivo=" . urlencode(strval($this->Consecutivo->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["seguimiento_individual3_grid"]->DetailView && $Security->CanView() && $this->ShowOptionLink('view') && $Security->AllowView(CurrentProjectID() . 'seguimiento_individual3')) {
				$links .= "<li><a class=\"ewRowLink ewDetailView\" data-action=\"view\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailViewLink")) . "\" href=\"" . ew_HtmlEncode($this->GetViewUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_individual3")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailViewLink")) . "</a></li>";
				if ($DetailViewTblVar <> "") $DetailViewTblVar .= ",";
				$DetailViewTblVar .= "seguimiento_individual3";
			}
			if ($GLOBALS["seguimiento_individual3_grid"]->DetailEdit && $Security->CanEdit() && $this->ShowOptionLink('edit') && $Security->AllowEdit(CurrentProjectID() . 'seguimiento_individual3')) {
				$links .= "<li><a class=\"ewRowLink ewDetailEdit\" data-action=\"edit\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailEditLink")) . "\" href=\"" . ew_HtmlEncode($this->GetEditUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_individual3")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailEditLink")) . "</a></li>";
				if ($DetailEditTblVar <> "") $DetailEditTblVar .= ",";
				$DetailEditTblVar .= "seguimiento_individual3";
			}
			if ($GLOBALS["seguimiento_individual3_grid"]->DetailAdd && $Security->CanAdd() && $this->ShowOptionLink('add') && $Security->AllowAdd(CurrentProjectID() . 'seguimiento_individual3')) {
				$links .= "<li><a class=\"ewRowLink ewDetailCopy\" data-action=\"add\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailCopyLink")) . "\" href=\"" . ew_HtmlEncode($this->GetCopyUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_individual3")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailCopyLink")) . "</a></li>";
				if ($DetailCopyTblVar <> "") $DetailCopyTblVar .= ",";
				$DetailCopyTblVar .= "seguimiento_individual3";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default btn-sm ewDetail\" data-toggle=\"dropdown\"><b class=\"caret\"></b></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group\">" . $body . "</div>";
			$oListOpt->Body = $body;
			if ($this->ShowMultipleDetails) $oListOpt->Visible = FALSE;
		}

		// "detail_seguimiento_materno"
		$oListOpt = &$this->ListOptions->Items["detail_seguimiento_materno"];
		if ($Security->AllowList(CurrentProjectID() . 'seguimiento_materno') && $this->ShowOptionLink()) {
			$body = $Language->Phrase("DetailLink") . $Language->TablePhrase("seguimiento_materno", "TblCaption");
			$body .= str_replace("%c", $this->seguimiento_materno_Count, $Language->Phrase("DetailCount"));
			$body = "<a class=\"btn btn-default btn-sm ewRowLink ewDetail\" data-action=\"list\" href=\"" . ew_HtmlEncode("seguimiento_maternolist.php?" . EW_TABLE_SHOW_MASTER . "=registro&fk_Consecutivo=" . urlencode(strval($this->Consecutivo->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["seguimiento_materno_grid"]->DetailView && $Security->CanView() && $this->ShowOptionLink('view') && $Security->AllowView(CurrentProjectID() . 'seguimiento_materno')) {
				$links .= "<li><a class=\"ewRowLink ewDetailView\" data-action=\"view\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailViewLink")) . "\" href=\"" . ew_HtmlEncode($this->GetViewUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_materno")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailViewLink")) . "</a></li>";
				if ($DetailViewTblVar <> "") $DetailViewTblVar .= ",";
				$DetailViewTblVar .= "seguimiento_materno";
			}
			if ($GLOBALS["seguimiento_materno_grid"]->DetailEdit && $Security->CanEdit() && $this->ShowOptionLink('edit') && $Security->AllowEdit(CurrentProjectID() . 'seguimiento_materno')) {
				$links .= "<li><a class=\"ewRowLink ewDetailEdit\" data-action=\"edit\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailEditLink")) . "\" href=\"" . ew_HtmlEncode($this->GetEditUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_materno")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailEditLink")) . "</a></li>";
				if ($DetailEditTblVar <> "") $DetailEditTblVar .= ",";
				$DetailEditTblVar .= "seguimiento_materno";
			}
			if ($GLOBALS["seguimiento_materno_grid"]->DetailAdd && $Security->CanAdd() && $this->ShowOptionLink('add') && $Security->AllowAdd(CurrentProjectID() . 'seguimiento_materno')) {
				$links .= "<li><a class=\"ewRowLink ewDetailCopy\" data-action=\"add\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailCopyLink")) . "\" href=\"" . ew_HtmlEncode($this->GetCopyUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_materno")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailCopyLink")) . "</a></li>";
				if ($DetailCopyTblVar <> "") $DetailCopyTblVar .= ",";
				$DetailCopyTblVar .= "seguimiento_materno";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default btn-sm ewDetail\" data-toggle=\"dropdown\"><b class=\"caret\"></b></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group\">" . $body . "</div>";
			$oListOpt->Body = $body;
			if ($this->ShowMultipleDetails) $oListOpt->Visible = FALSE;
		}
		if ($this->ShowMultipleDetails) {
			$body = $Language->Phrase("MultipleMasterDetails");
			$body = "<div class=\"btn-group\">";
			$links = "";
			if ($DetailViewTblVar <> "") {
				$links .= "<li><a class=\"ewRowLink ewDetailView\" data-action=\"view\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailViewLink")) . "\" href=\"" . ew_HtmlEncode($this->GetViewUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailViewTblVar)) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($DetailEditTblVar <> "") {
				$links .= "<li><a class=\"ewRowLink ewDetailEdit\" data-action=\"edit\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailEditLink")) . "\" href=\"" . ew_HtmlEncode($this->GetEditUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailEditTblVar)) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($DetailCopyTblVar <> "") {
				$links .= "<li><a class=\"ewRowLink ewDetailCopy\" data-action=\"add\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailCopyLink")) . "\" href=\"" . ew_HtmlEncode($this->GetCopyUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailCopyTblVar)) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default btn-sm ewMasterDetail\" title=\"" . ew_HtmlTitle($Language->Phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("MultipleMasterDetails") . "<b class=\"caret\"></b></button>";
				$body .= "<ul class=\"dropdown-menu ewMenu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$oListOpt = &$this->ListOptions->Items["details"];
			$oListOpt->Body = $body;
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" value=\"" . ew_HtmlEncode($this->Consecutivo->CurrentValue) . "\" onclick='ew_ClickMultiCheckbox(event);'>";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . ew_HtmlTitle($Language->Phrase("AddLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("AddLink")) . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["detail"];
		$DetailTableLink = "";
		$item = &$option->Add("detailadd_seguimiento_individual3");
		$url = $this->GetAddUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_individual3");
		$caption = $Language->Phrase("Add") . "&nbsp;" . $this->TableCaption() . "/" . $GLOBALS["seguimiento_individual3"]->TableCaption();
		$item->Body = "<a class=\"ewDetailAddGroup ewDetailAdd\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"" . ew_HtmlEncode($url) . "\">" . $caption . "</a>";
		$item->Visible = ($GLOBALS["seguimiento_individual3"]->DetailAdd && $Security->AllowAdd(CurrentProjectID() . 'seguimiento_individual3') && $Security->CanAdd());
		if ($item->Visible) {
			if ($DetailTableLink <> "") $DetailTableLink .= ",";
			$DetailTableLink .= "seguimiento_individual3";
		}
		$item = &$option->Add("detailadd_seguimiento_materno");
		$url = $this->GetAddUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_materno");
		$caption = $Language->Phrase("Add") . "&nbsp;" . $this->TableCaption() . "/" . $GLOBALS["seguimiento_materno"]->TableCaption();
		$item->Body = "<a class=\"ewDetailAddGroup ewDetailAdd\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"" . ew_HtmlEncode($url) . "\">" . $caption . "</a>";
		$item->Visible = ($GLOBALS["seguimiento_materno"]->DetailAdd && $Security->AllowAdd(CurrentProjectID() . 'seguimiento_materno') && $Security->CanAdd());
		if ($item->Visible) {
			if ($DetailTableLink <> "") $DetailTableLink .= ",";
			$DetailTableLink .= "seguimiento_materno";
		}

		// Add multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$option->Add("detailsadd");
			$url = $this->GetAddUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailTableLink);
			$item->Body = "<a class=\"ewDetailAddGroup ewDetailAdd\" title=\"" . ew_HtmlTitle($Language->Phrase("AddMasterDetailLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("AddMasterDetailLink")) . "\" href=\"" . ew_HtmlEncode($url) . "\">" . $Language->Phrase("AddMasterDetailLink") . "</a>";
			$item->Visible = ($DetailTableLink <> "" && $Security->CanAdd());

			// Hide single master/detail items
			$ar = explode(",", $DetailTableLink);
			$cnt = count($ar);
			for ($i = 0; $i < $cnt; $i++) {
				if ($item = &$option->GetItem("detailadd_" . $ar[$i]))
					$item->Visible = FALSE;
			}
		}
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.fregistrolist,url:'" . $this->MultiDeleteUrl . "',msg:ewLanguage.Phrase('DeleteConfirmMsg')});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fregistrolistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fregistrolistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fregistrolist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fregistrolistsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// Consecutivo

		$this->Consecutivo->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Consecutivo"]);
		if ($this->Consecutivo->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Consecutivo->AdvancedSearch->SearchOperator = @$_GET["z_Consecutivo"];

		// Seguimiento
		$this->Seguimiento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Seguimiento"]);
		if ($this->Seguimiento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Seguimiento->AdvancedSearch->SearchOperator = @$_GET["z_Seguimiento"];

		// Condicion_Final
		$this->Condicion_Final->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Condicion_Final"]);
		if ($this->Condicion_Final->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Condicion_Final->AdvancedSearch->SearchOperator = @$_GET["z_Condicion_Final"];

		// Codigo_centro
		$this->Codigo_centro->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Codigo_centro"]);
		if ($this->Codigo_centro->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Codigo_centro->AdvancedSearch->SearchOperator = @$_GET["z_Codigo_centro"];

		// Codigo_UPGD
		$this->Codigo_UPGD->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Codigo_UPGD"]);
		if ($this->Codigo_UPGD->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Codigo_UPGD->AdvancedSearch->SearchOperator = @$_GET["z_Codigo_UPGD"];

		// Cod_Evento
		$this->Cod_Evento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Cod_Evento"]);
		if ($this->Cod_Evento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Cod_Evento->AdvancedSearch->SearchOperator = @$_GET["z_Cod_Evento"];

		// Embarazo_Actual
		$this->Embarazo_Actual->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Embarazo_Actual"]);
		if ($this->Embarazo_Actual->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Embarazo_Actual->AdvancedSearch->SearchOperator = @$_GET["z_Embarazo_Actual"];

		// Fecha_Notificacion
		$this->Fecha_Notificacion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Notificacion"]);
		if ($this->Fecha_Notificacion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Notificacion->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Notificacion"];
		$this->Fecha_Notificacion->AdvancedSearch->SearchCondition = @$_GET["v_Fecha_Notificacion"];
		$this->Fecha_Notificacion->AdvancedSearch->SearchValue2 = ew_StripSlashes(@$_GET["y_Fecha_Notificacion"]);
		if ($this->Fecha_Notificacion->AdvancedSearch->SearchValue2 <> "") $this->Command = "search";
		$this->Fecha_Notificacion->AdvancedSearch->SearchOperator2 = @$_GET["w_Fecha_Notificacion"];

		// Semana
		$this->Semana->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Semana"]);
		if ($this->Semana->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Semana->AdvancedSearch->SearchOperator = @$_GET["z_Semana"];

		// Periodo_Epidemiologico
		$this->Periodo_Epidemiologico->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Periodo_Epidemiologico"]);
		if ($this->Periodo_Epidemiologico->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Periodo_Epidemiologico->AdvancedSearch->SearchOperator = @$_GET["z_Periodo_Epidemiologico"];

		// Periodo_Sivigila
		$this->Periodo_Sivigila->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Periodo_Sivigila"]);
		if ($this->Periodo_Sivigila->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Periodo_Sivigila->AdvancedSearch->SearchOperator = @$_GET["z_Periodo_Sivigila"];

		// Primer_Nombre
		$this->Primer_Nombre->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Primer_Nombre"]);
		if ($this->Primer_Nombre->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Primer_Nombre->AdvancedSearch->SearchOperator = @$_GET["z_Primer_Nombre"];

		// Segundo_Nombre
		$this->Segundo_Nombre->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Segundo_Nombre"]);
		if ($this->Segundo_Nombre->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Segundo_Nombre->AdvancedSearch->SearchOperator = @$_GET["z_Segundo_Nombre"];

		// Primer_Apellido
		$this->Primer_Apellido->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Primer_Apellido"]);
		if ($this->Primer_Apellido->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Primer_Apellido->AdvancedSearch->SearchOperator = @$_GET["z_Primer_Apellido"];

		// Segundo_Apellido
		$this->Segundo_Apellido->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Segundo_Apellido"]);
		if ($this->Segundo_Apellido->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Segundo_Apellido->AdvancedSearch->SearchOperator = @$_GET["z_Segundo_Apellido"];

		// Tipo_Id
		$this->Tipo_Id->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_Id"]);
		if ($this->Tipo_Id->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_Id->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_Id"];

		// Numero_Identificacion
		$this->Numero_Identificacion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Numero_Identificacion"]);
		if ($this->Numero_Identificacion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Numero_Identificacion->AdvancedSearch->SearchOperator = @$_GET["z_Numero_Identificacion"];

		// Edad
		$this->Edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Edad"]);
		if ($this->Edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Edad->AdvancedSearch->SearchOperator = @$_GET["z_Edad"];

		// Unidad_Edad
		$this->Unidad_Edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Unidad_Edad"]);
		if ($this->Unidad_Edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Unidad_Edad->AdvancedSearch->SearchOperator = @$_GET["z_Unidad_Edad"];

		// Sexo
		$this->Sexo->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Sexo"]);
		if ($this->Sexo->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Sexo->AdvancedSearch->SearchOperator = @$_GET["z_Sexo"];

		// Pais_Ocurrencia
		$this->Pais_Ocurrencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Pais_Ocurrencia"]);
		if ($this->Pais_Ocurrencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Pais_Ocurrencia->AdvancedSearch->SearchOperator = @$_GET["z_Pais_Ocurrencia"];

		// Depto_Ocurrencia
		$this->Depto_Ocurrencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Depto_Ocurrencia"]);
		if ($this->Depto_Ocurrencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Depto_Ocurrencia->AdvancedSearch->SearchOperator = @$_GET["z_Depto_Ocurrencia"];

		// Municipio_Ocurrencia
		$this->Municipio_Ocurrencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Municipio_Ocurrencia"]);
		if ($this->Municipio_Ocurrencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Municipio_Ocurrencia->AdvancedSearch->SearchOperator = @$_GET["z_Municipio_Ocurrencia"];

		// Area_Ocurrencia
		$this->Area_Ocurrencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Area_Ocurrencia"]);
		if ($this->Area_Ocurrencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Area_Ocurrencia->AdvancedSearch->SearchOperator = @$_GET["z_Area_Ocurrencia"];

		// Localidad
		$this->Localidad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Localidad"]);
		if ($this->Localidad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Localidad->AdvancedSearch->SearchOperator = @$_GET["z_Localidad"];

		// Barrio
		$this->Barrio->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Barrio"]);
		if ($this->Barrio->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Barrio->AdvancedSearch->SearchOperator = @$_GET["z_Barrio"];

		// Direccion_Residencia
		$this->Direccion_Residencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Direccion_Residencia"]);
		if ($this->Direccion_Residencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Direccion_Residencia->AdvancedSearch->SearchOperator = @$_GET["z_Direccion_Residencia"];

		// Ocupacion
		$this->Ocupacion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Ocupacion"]);
		if ($this->Ocupacion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Ocupacion->AdvancedSearch->SearchOperator = @$_GET["z_Ocupacion"];

		// Tipo_Regimen_Salud
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_Regimen_Salud"]);
		if ($this->Tipo_Regimen_Salud->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_Regimen_Salud"];

		// Cod_Administradora
		$this->Cod_Administradora->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Cod_Administradora"]);
		if ($this->Cod_Administradora->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Cod_Administradora->AdvancedSearch->SearchOperator = @$_GET["z_Cod_Administradora"];

		// gp_discapa
		$this->gp_discapa->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_discapa"]);
		if ($this->gp_discapa->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_discapa->AdvancedSearch->SearchOperator = @$_GET["z_gp_discapa"];

		// gp_desplaz
		$this->gp_desplaz->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_desplaz"]);
		if ($this->gp_desplaz->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_desplaz->AdvancedSearch->SearchOperator = @$_GET["z_gp_desplaz"];

		// gp_migrant
		$this->gp_migrant->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_migrant"]);
		if ($this->gp_migrant->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_migrant->AdvancedSearch->SearchOperator = @$_GET["z_gp_migrant"];

		// gp_carcela
		$this->gp_carcela->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_carcela"]);
		if ($this->gp_carcela->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_carcela->AdvancedSearch->SearchOperator = @$_GET["z_gp_carcela"];

		// gp_gestan
		$this->gp_gestan->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_gestan"]);
		if ($this->gp_gestan->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_gestan->AdvancedSearch->SearchOperator = @$_GET["z_gp_gestan"];

		// gp_indigen
		$this->gp_indigen->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_indigen"]);
		if ($this->gp_indigen->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_indigen->AdvancedSearch->SearchOperator = @$_GET["z_gp_indigen"];

		// gp_pobicbf
		$this->gp_pobicbf->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_pobicbf"]);
		if ($this->gp_pobicbf->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_pobicbf->AdvancedSearch->SearchOperator = @$_GET["z_gp_pobicbf"];

		// gp_mad_com
		$this->gp_mad_com->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_mad_com"]);
		if ($this->gp_mad_com->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_mad_com->AdvancedSearch->SearchOperator = @$_GET["z_gp_mad_com"];

		// gp_desmovi
		$this->gp_desmovi->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_desmovi"]);
		if ($this->gp_desmovi->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_desmovi->AdvancedSearch->SearchOperator = @$_GET["z_gp_desmovi"];

		// gp_psiquia
		$this->gp_psiquia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_psiquia"]);
		if ($this->gp_psiquia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_psiquia->AdvancedSearch->SearchOperator = @$_GET["z_gp_psiquia"];

		// gp_vic_vio
		$this->gp_vic_vio->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_vic_vio"]);
		if ($this->gp_vic_vio->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_vic_vio->AdvancedSearch->SearchOperator = @$_GET["z_gp_vic_vio"];

		// gp_otros
		$this->gp_otros->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_gp_otros"]);
		if ($this->gp_otros->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->gp_otros->AdvancedSearch->SearchOperator = @$_GET["z_gp_otros"];

		// Depto_Residencia
		$this->Depto_Residencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Depto_Residencia"]);
		if ($this->Depto_Residencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Depto_Residencia->AdvancedSearch->SearchOperator = @$_GET["z_Depto_Residencia"];

		// Municipio_Residencia
		$this->Municipio_Residencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Municipio_Residencia"]);
		if ($this->Municipio_Residencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Municipio_Residencia->AdvancedSearch->SearchOperator = @$_GET["z_Municipio_Residencia"];

		// Fecha_Consulta
		$this->Fecha_Consulta->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Consulta"]);
		if ($this->Fecha_Consulta->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Consulta->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Consulta"];

		// Fecha_Inicio_Sintomas
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Inicio_Sintomas"]);
		if ($this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Inicio_Sintomas"];

		// Hospitalizado
		$this->Hospitalizado->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Hospitalizado"]);
		if ($this->Hospitalizado->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Hospitalizado->AdvancedSearch->SearchOperator = @$_GET["z_Hospitalizado"];
		if (is_array($this->Hospitalizado->AdvancedSearch->SearchValue)) $this->Hospitalizado->AdvancedSearch->SearchValue = implode(",", $this->Hospitalizado->AdvancedSearch->SearchValue);
		if (is_array($this->Hospitalizado->AdvancedSearch->SearchValue2)) $this->Hospitalizado->AdvancedSearch->SearchValue2 = implode(",", $this->Hospitalizado->AdvancedSearch->SearchValue2);

		// Fecha_Defuncion
		$this->Fecha_Defuncion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Defuncion"]);
		if ($this->Fecha_Defuncion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Defuncion->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Defuncion"];
		$this->Fecha_Defuncion->AdvancedSearch->SearchCondition = @$_GET["v_Fecha_Defuncion"];
		$this->Fecha_Defuncion->AdvancedSearch->SearchValue2 = ew_StripSlashes(@$_GET["y_Fecha_Defuncion"]);
		if ($this->Fecha_Defuncion->AdvancedSearch->SearchValue2 <> "") $this->Command = "search";
		$this->Fecha_Defuncion->AdvancedSearch->SearchOperator2 = @$_GET["w_Fecha_Defuncion"];

		// Numero_Certificado_Defuncion
		$this->Numero_Certificado_Defuncion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Numero_Certificado_Defuncion"]);
		if ($this->Numero_Certificado_Defuncion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Numero_Certificado_Defuncion->AdvancedSearch->SearchOperator = @$_GET["z_Numero_Certificado_Defuncion"];

		// Causa_Basica_Muerte_CIEX
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Causa_Basica_Muerte_CIEX"]);
		if ($this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->SearchOperator = @$_GET["z_Causa_Basica_Muerte_CIEX"];

		// Entidad_fallecimiento
		$this->Entidad_fallecimiento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Entidad_fallecimiento"]);
		if ($this->Entidad_fallecimiento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Entidad_fallecimiento->AdvancedSearch->SearchOperator = @$_GET["z_Entidad_fallecimiento"];

		// Telefono
		$this->Telefono->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Telefono"]);
		if ($this->Telefono->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Telefono->AdvancedSearch->SearchOperator = @$_GET["z_Telefono"];

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Nacimiento"]);
		if ($this->Fecha_Nacimiento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Nacimiento->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Nacimiento"];

		// Nombre_Profesional_Diligencia
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Nombre_Profesional_Diligencia"]);
		if ($this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->SearchOperator = @$_GET["z_Nombre_Profesional_Diligencia"];

		// Telefono_Profesional_Diligencia
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Telefono_Profesional_Diligencia"]);
		if ($this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->SearchOperator = @$_GET["z_Telefono_Profesional_Diligencia"];

		// Mecanismo_Probable_Transmision
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Mecanismo_Probable_Transmision"]);
		if ($this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->SearchOperator = @$_GET["z_Mecanismo_Probable_Transmision"];

		// Nombre_Madre
		$this->Nombre_Madre->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Nombre_Madre"]);
		if ($this->Nombre_Madre->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Nombre_Madre->AdvancedSearch->SearchOperator = @$_GET["z_Nombre_Madre"];

		// Tipo_Id_Madre
		$this->Tipo_Id_Madre->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_Id_Madre"]);
		if ($this->Tipo_Id_Madre->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_Id_Madre->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_Id_Madre"];

		// Numero_Identificacion_Madre
		$this->Numero_Identificacion_Madre->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Numero_Identificacion_Madre"]);
		if ($this->Numero_Identificacion_Madre->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Numero_Identificacion_Madre->AdvancedSearch->SearchOperator = @$_GET["z_Numero_Identificacion_Madre"];

		// Indentidad_Genero
		$this->Indentidad_Genero->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Indentidad_Genero"]);
		if ($this->Indentidad_Genero->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Indentidad_Genero->AdvancedSearch->SearchOperator = @$_GET["z_Indentidad_Genero"];

		// Donador_Sangre_Ultimos_12_Meses
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Donador_Sangre_Ultimos_12_Meses"]);
		if ($this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->SearchOperator = @$_GET["z_Donador_Sangre_Ultimos_12_Meses"];

		// Fecha_Donacion
		$this->Fecha_Donacion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Donacion"]);
		if ($this->Fecha_Donacion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Donacion->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Donacion"];

		// Nombre_Institucion_Donacion
		$this->Nombre_Institucion_Donacion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Nombre_Institucion_Donacion"]);
		if ($this->Nombre_Institucion_Donacion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Nombre_Institucion_Donacion->AdvancedSearch->SearchOperator = @$_GET["z_Nombre_Institucion_Donacion"];

		// Poblacion_clave
		$this->Poblacion_clave->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Poblacion_clave"]);
		if ($this->Poblacion_clave->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Poblacion_clave->AdvancedSearch->SearchOperator = @$_GET["z_Poblacion_clave"];

		// Recibio_Asesoria_Pre_Prueba
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Recibio_Asesoria_Pre_Prueba"]);
		if ($this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->SearchOperator = @$_GET["z_Recibio_Asesoria_Pre_Prueba"];

		// Recibio_Asesoria_Post_Prueba
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Recibio_Asesoria_Post_Prueba"]);
		if ($this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->SearchOperator = @$_GET["z_Recibio_Asesoria_Post_Prueba"];

		// Tipo_Prueba
		$this->Tipo_Prueba->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_Prueba"]);
		if ($this->Tipo_Prueba->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_Prueba->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_Prueba"];

		// Fecha_Resultado_Confirmatorio
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Resultado_Confirmatorio"]);
		if ($this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Resultado_Confirmatorio"];

		// Valor_Carga_Viral
		$this->Valor_Carga_Viral->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Valor_Carga_Viral"]);
		if ($this->Valor_Carga_Viral->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Valor_Carga_Viral->AdvancedSearch->SearchOperator = @$_GET["z_Valor_Carga_Viral"];

		// Estado_Clinico_Notificacion
		$this->Estado_Clinico_Notificacion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Estado_Clinico_Notificacion"]);
		if ($this->Estado_Clinico_Notificacion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Estado_Clinico_Notificacion->AdvancedSearch->SearchOperator = @$_GET["z_Estado_Clinico_Notificacion"];

		// Hijos_Mujeres_Menores_5
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Hijos_Mujeres_Menores_5"]);
		if ($this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->SearchOperator = @$_GET["z_Hijos_Mujeres_Menores_5"];

		// Hijos_Hombres_Menores_5
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Hijos_Hombres_Menores_5"]);
		if ($this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->SearchOperator = @$_GET["z_Hijos_Hombres_Menores_5"];

		// Numero_Semanas_Embarazo
		$this->Numero_Semanas_Embarazo->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Numero_Semanas_Embarazo"]);
		if ($this->Numero_Semanas_Embarazo->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Numero_Semanas_Embarazo->AdvancedSearch->SearchOperator = @$_GET["z_Numero_Semanas_Embarazo"];

		// Antecedentes_Embarazo
		$this->Antecedentes_Embarazo->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Antecedentes_Embarazo"]);
		if ($this->Antecedentes_Embarazo->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Antecedentes_Embarazo->AdvancedSearch->SearchOperator = @$_GET["z_Antecedentes_Embarazo"];

		// Candidiasis_esofagica
		$this->Candidiasis_esofagica->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Candidiasis_esofagica"]);
		if ($this->Candidiasis_esofagica->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Candidiasis_esofagica->AdvancedSearch->SearchOperator = @$_GET["z_Candidiasis_esofagica"];

		// Candidiasis_vias_aereas
		$this->Candidiasis_vias_aereas->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Candidiasis_vias_aereas"]);
		if ($this->Candidiasis_vias_aereas->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Candidiasis_vias_aereas->AdvancedSearch->SearchOperator = @$_GET["z_Candidiasis_vias_aereas"];

		// Tuberculosis_pulmonar
		$this->Tuberculosis_pulmonar->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tuberculosis_pulmonar"]);
		if ($this->Tuberculosis_pulmonar->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tuberculosis_pulmonar->AdvancedSearch->SearchOperator = @$_GET["z_Tuberculosis_pulmonar"];

		// Cancer_cervical
		$this->Cancer_cervical->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Cancer_cervical"]);
		if ($this->Cancer_cervical->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Cancer_cervical->AdvancedSearch->SearchOperator = @$_GET["z_Cancer_cervical"];

		// Tuberculosis_extrapulmonar
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tuberculosis_extrapulmonar"]);
		if ($this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->SearchOperator = @$_GET["z_Tuberculosis_extrapulmonar"];

		// Coccidiomicosis
		$this->Coccidiomicosis->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Coccidiomicosis"]);
		if ($this->Coccidiomicosis->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Coccidiomicosis->AdvancedSearch->SearchOperator = @$_GET["z_Coccidiomicosis"];

		// Citomegalovirosis
		$this->Citomegalovirosis->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Citomegalovirosis"]);
		if ($this->Citomegalovirosis->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Citomegalovirosis->AdvancedSearch->SearchOperator = @$_GET["z_Citomegalovirosis"];

		// Retinitis_citomegalovirosis
		$this->Retinitis_citomegalovirosis->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Retinitis_citomegalovirosis"]);
		if ($this->Retinitis_citomegalovirosis->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Retinitis_citomegalovirosis->AdvancedSearch->SearchOperator = @$_GET["z_Retinitis_citomegalovirosis"];

		// Sindrome_Emanciacion
		$this->Sindrome_Emanciacion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Sindrome_Emanciacion"]);
		if ($this->Sindrome_Emanciacion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Sindrome_Emanciacion->AdvancedSearch->SearchOperator = @$_GET["z_Sindrome_Emanciacion"];

		// Encefalopatia
		$this->Encefalopatia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Encefalopatia"]);
		if ($this->Encefalopatia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Encefalopatia->AdvancedSearch->SearchOperator = @$_GET["z_Encefalopatia"];

		// Otras_micobacterias
		$this->Otras_micobacterias->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Otras_micobacterias"]);
		if ($this->Otras_micobacterias->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Otras_micobacterias->AdvancedSearch->SearchOperator = @$_GET["z_Otras_micobacterias"];

		// Histoplasmosis_Extrapulmonar
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Histoplasmosis_Extrapulmonar"]);
		if ($this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->SearchOperator = @$_GET["z_Histoplasmosis_Extrapulmonar"];

		// isosporidiasis_cronica
		$this->isosporidiasis_cronica->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_isosporidiasis_cronica"]);
		if ($this->isosporidiasis_cronica->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->isosporidiasis_cronica->AdvancedSearch->SearchOperator = @$_GET["z_isosporidiasis_cronica"];

		// herpes_zoster
		$this->herpes_zoster->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_herpes_zoster"]);
		if ($this->herpes_zoster->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->herpes_zoster->AdvancedSearch->SearchOperator = @$_GET["z_herpes_zoster"];

		// Histoplasmosis_diseminada
		$this->Histoplasmosis_diseminada->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Histoplasmosis_diseminada"]);
		if ($this->Histoplasmosis_diseminada->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Histoplasmosis_diseminada->AdvancedSearch->SearchOperator = @$_GET["z_Histoplasmosis_diseminada"];

		// Linfoma_Burkitt
		$this->Linfoma_Burkitt->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Linfoma_Burkitt"]);
		if ($this->Linfoma_Burkitt->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Linfoma_Burkitt->AdvancedSearch->SearchOperator = @$_GET["z_Linfoma_Burkitt"];

		// Neumonia_Pneumocystis
		$this->Neumonia_Pneumocystis->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Neumonia_Pneumocystis"]);
		if ($this->Neumonia_Pneumocystis->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Neumonia_Pneumocystis->AdvancedSearch->SearchOperator = @$_GET["z_Neumonia_Pneumocystis"];

		// Neumonia_Recurrente
		$this->Neumonia_Recurrente->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Neumonia_Recurrente"]);
		if ($this->Neumonia_Recurrente->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Neumonia_Recurrente->AdvancedSearch->SearchOperator = @$_GET["z_Neumonia_Recurrente"];

		// Linfoma_Inmunoblastico
		$this->Linfoma_Inmunoblastico->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Linfoma_Inmunoblastico"]);
		if ($this->Linfoma_Inmunoblastico->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Linfoma_Inmunoblastico->AdvancedSearch->SearchOperator = @$_GET["z_Linfoma_Inmunoblastico"];

		// Criptosporidiasis_cronica
		$this->Criptosporidiasis_cronica->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Criptosporidiasis_cronica"]);
		if ($this->Criptosporidiasis_cronica->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Criptosporidiasis_cronica->AdvancedSearch->SearchOperator = @$_GET["z_Criptosporidiasis_cronica"];

		// Criptococosis_Extrapulmonar
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Criptococosis_Extrapulmonar"]);
		if ($this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->SearchOperator = @$_GET["z_Criptococosis_Extrapulmonar"];

		// Sarcoma_Kaposi
		$this->Sarcoma_Kaposi->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Sarcoma_Kaposi"]);
		if ($this->Sarcoma_Kaposi->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Sarcoma_Kaposi->AdvancedSearch->SearchOperator = @$_GET["z_Sarcoma_Kaposi"];

		// Leucoencefalopatia_Multifocal
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Leucoencefalopatia_Multifocal"]);
		if ($this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->SearchOperator = @$_GET["z_Leucoencefalopatia_Multifocal"];

		// Septicemia_recurrente
		$this->Septicemia_recurrente->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Septicemia_recurrente"]);
		if ($this->Septicemia_recurrente->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Septicemia_recurrente->AdvancedSearch->SearchOperator = @$_GET["z_Septicemia_recurrente"];

		// Toxoplasmosis_cerebral
		$this->Toxoplasmosis_cerebral->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Toxoplasmosis_cerebral"]);
		if ($this->Toxoplasmosis_cerebral->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Toxoplasmosis_cerebral->AdvancedSearch->SearchOperator = @$_GET["z_Toxoplasmosis_cerebral"];

		// HepatitisB
		$this->HepatitisB->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_HepatitisB"]);
		if ($this->HepatitisB->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->HepatitisB->AdvancedSearch->SearchOperator = @$_GET["z_HepatitisB"];

		// HepatitisC
		$this->HepatitisC->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_HepatitisC"]);
		if ($this->HepatitisC->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->HepatitisC->AdvancedSearch->SearchOperator = @$_GET["z_HepatitisC"];

		// Meningitis
		$this->Meningitis->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Meningitis"]);
		if ($this->Meningitis->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Meningitis->AdvancedSearch->SearchOperator = @$_GET["z_Meningitis"];

		// RecuentoCD4
		$this->RecuentoCD4->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_RecuentoCD4"]);
		if ($this->RecuentoCD4->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->RecuentoCD4->AdvancedSearch->SearchOperator = @$_GET["z_RecuentoCD4"];

		// Registrado_Por
		$this->Registrado_Por->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Registrado_Por"]);
		if ($this->Registrado_Por->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Registrado_Por->AdvancedSearch->SearchOperator = @$_GET["z_Registrado_Por"];

		// Localidad_residencia
		$this->Localidad_residencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Localidad_residencia"]);
		if ($this->Localidad_residencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Localidad_residencia->AdvancedSearch->SearchOperator = @$_GET["z_Localidad_residencia"];

		// Barrio_residencia
		$this->Barrio_residencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Barrio_residencia"]);
		if ($this->Barrio_residencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Barrio_residencia->AdvancedSearch->SearchOperator = @$_GET["z_Barrio_residencia"];

		// Fecha_ingreso_app
		$this->Fecha_ingreso_app->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_ingreso_app"]);
		if ($this->Fecha_ingreso_app->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_ingreso_app->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_ingreso_app"];

		// Actualizado_por
		$this->Actualizado_por->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Actualizado_por"]);
		if ($this->Actualizado_por->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Actualizado_por->AdvancedSearch->SearchOperator = @$_GET["z_Actualizado_por"];

		// Fecha_actualizacion_app
		$this->Fecha_actualizacion_app->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_actualizacion_app"]);
		if ($this->Fecha_actualizacion_app->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_actualizacion_app->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_actualizacion_app"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Seguimiento->setDbValue($rs->fields('Seguimiento'));
		$this->Condicion_Final->setDbValue($rs->fields('Condicion_Final'));
		$this->Codigo_centro->setDbValue($rs->fields('Codigo_centro'));
		$this->Codigo_UPGD->setDbValue($rs->fields('Codigo_UPGD'));
		$this->Cod_Evento->setDbValue($rs->fields('Cod_Evento'));
		$this->Embarazo_Actual->setDbValue($rs->fields('Embarazo_Actual'));
		$this->Fecha_Notificacion->setDbValue($rs->fields('Fecha_Notificacion'));
		$this->Semana->setDbValue($rs->fields('Semana'));
		$this->Periodo_Epidemiologico->setDbValue($rs->fields('Periodo_Epidemiologico'));
		$this->Periodo_Sivigila->setDbValue($rs->fields('Periodo_Sivigila'));
		$this->Primer_Nombre->setDbValue($rs->fields('Primer_Nombre'));
		$this->Segundo_Nombre->setDbValue($rs->fields('Segundo_Nombre'));
		$this->Primer_Apellido->setDbValue($rs->fields('Primer_Apellido'));
		$this->Segundo_Apellido->setDbValue($rs->fields('Segundo_Apellido'));
		$this->Tipo_Id->setDbValue($rs->fields('Tipo_Id'));
		$this->Numero_Identificacion->setDbValue($rs->fields('Numero_Identificacion'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Unidad_Edad->setDbValue($rs->fields('Unidad_Edad'));
		$this->Sexo->setDbValue($rs->fields('Sexo'));
		$this->Pais_Ocurrencia->setDbValue($rs->fields('Pais_Ocurrencia'));
		$this->Depto_Ocurrencia->setDbValue($rs->fields('Depto_Ocurrencia'));
		$this->Municipio_Ocurrencia->setDbValue($rs->fields('Municipio_Ocurrencia'));
		$this->Area_Ocurrencia->setDbValue($rs->fields('Area_Ocurrencia'));
		$this->Localidad->setDbValue($rs->fields('Localidad'));
		$this->Barrio->setDbValue($rs->fields('Barrio'));
		$this->Direccion_Residencia->setDbValue($rs->fields('Direccion_Residencia'));
		$this->Ocupacion->setDbValue($rs->fields('Ocupacion'));
		$this->Tipo_Regimen_Salud->setDbValue($rs->fields('Tipo_Regimen_Salud'));
		$this->Cod_Administradora->setDbValue($rs->fields('Cod_Administradora'));
		$this->gp_discapa->setDbValue($rs->fields('gp_discapa'));
		$this->gp_desplaz->setDbValue($rs->fields('gp_desplaz'));
		$this->gp_migrant->setDbValue($rs->fields('gp_migrant'));
		$this->gp_carcela->setDbValue($rs->fields('gp_carcela'));
		$this->gp_gestan->setDbValue($rs->fields('gp_gestan'));
		$this->gp_indigen->setDbValue($rs->fields('gp_indigen'));
		$this->gp_pobicbf->setDbValue($rs->fields('gp_pobicbf'));
		$this->gp_mad_com->setDbValue($rs->fields('gp_mad_com'));
		$this->gp_desmovi->setDbValue($rs->fields('gp_desmovi'));
		$this->gp_psiquia->setDbValue($rs->fields('gp_psiquia'));
		$this->gp_vic_vio->setDbValue($rs->fields('gp_vic_vio'));
		$this->gp_otros->setDbValue($rs->fields('gp_otros'));
		$this->Depto_Residencia->setDbValue($rs->fields('Depto_Residencia'));
		$this->Municipio_Residencia->setDbValue($rs->fields('Municipio_Residencia'));
		$this->Fecha_Consulta->setDbValue($rs->fields('Fecha_Consulta'));
		$this->Fecha_Inicio_Sintomas->setDbValue($rs->fields('Fecha_Inicio_Sintomas'));
		$this->Hospitalizado->setDbValue($rs->fields('Hospitalizado'));
		$this->Fecha_Defuncion->setDbValue($rs->fields('Fecha_Defuncion'));
		$this->Numero_Certificado_Defuncion->setDbValue($rs->fields('Numero_Certificado_Defuncion'));
		$this->Causa_Basica_Muerte_CIEX->setDbValue($rs->fields('Causa_Basica_Muerte_CIEX'));
		$this->Entidad_fallecimiento->setDbValue($rs->fields('Entidad_fallecimiento'));
		$this->Telefono->setDbValue($rs->fields('Telefono'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Nombre_Profesional_Diligencia->setDbValue($rs->fields('Nombre_Profesional_Diligencia'));
		$this->Telefono_Profesional_Diligencia->setDbValue($rs->fields('Telefono_Profesional_Diligencia'));
		$this->Mecanismo_Probable_Transmision->setDbValue($rs->fields('Mecanismo_Probable_Transmision'));
		$this->Nombre_Madre->setDbValue($rs->fields('Nombre_Madre'));
		$this->Tipo_Id_Madre->setDbValue($rs->fields('Tipo_Id_Madre'));
		$this->Numero_Identificacion_Madre->setDbValue($rs->fields('Numero_Identificacion_Madre'));
		$this->Indentidad_Genero->setDbValue($rs->fields('Indentidad_Genero'));
		$this->Donador_Sangre_Ultimos_12_Meses->setDbValue($rs->fields('Donador_Sangre_Ultimos_12_Meses'));
		$this->Fecha_Donacion->setDbValue($rs->fields('Fecha_Donacion'));
		$this->Nombre_Institucion_Donacion->setDbValue($rs->fields('Nombre_Institucion_Donacion'));
		$this->Poblacion_clave->setDbValue($rs->fields('Poblacion_clave'));
		$this->Recibio_Asesoria_Pre_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Pre_Prueba'));
		$this->Recibio_Asesoria_Post_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Post_Prueba'));
		$this->Tipo_Prueba->setDbValue($rs->fields('Tipo_Prueba'));
		$this->Fecha_Resultado_Confirmatorio->setDbValue($rs->fields('Fecha_Resultado_Confirmatorio'));
		$this->Valor_Carga_Viral->setDbValue($rs->fields('Valor_Carga_Viral'));
		$this->Estado_Clinico_Notificacion->setDbValue($rs->fields('Estado_Clinico_Notificacion'));
		$this->Hijos_Mujeres_Menores_5->setDbValue($rs->fields('Hijos_Mujeres_Menores_5'));
		$this->Hijos_Hombres_Menores_5->setDbValue($rs->fields('Hijos_Hombres_Menores_5'));
		$this->Numero_Semanas_Embarazo->setDbValue($rs->fields('Numero_Semanas_Embarazo'));
		$this->Antecedentes_Embarazo->setDbValue($rs->fields('Antecedentes_Embarazo'));
		$this->Candidiasis_esofagica->setDbValue($rs->fields('Candidiasis_esofagica'));
		$this->Candidiasis_vias_aereas->setDbValue($rs->fields('Candidiasis_vias_aereas'));
		$this->Tuberculosis_pulmonar->setDbValue($rs->fields('Tuberculosis_pulmonar'));
		$this->Cancer_cervical->setDbValue($rs->fields('Cancer_cervical'));
		$this->Tuberculosis_extrapulmonar->setDbValue($rs->fields('Tuberculosis_extrapulmonar'));
		$this->Coccidiomicosis->setDbValue($rs->fields('Coccidiomicosis'));
		$this->Citomegalovirosis->setDbValue($rs->fields('Citomegalovirosis'));
		$this->Retinitis_citomegalovirosis->setDbValue($rs->fields('Retinitis_citomegalovirosis'));
		$this->Sindrome_Emanciacion->setDbValue($rs->fields('Sindrome_Emanciacion'));
		$this->Encefalopatia->setDbValue($rs->fields('Encefalopatia'));
		$this->Otras_micobacterias->setDbValue($rs->fields('Otras_micobacterias'));
		$this->Histoplasmosis_Extrapulmonar->setDbValue($rs->fields('Histoplasmosis_Extrapulmonar'));
		$this->isosporidiasis_cronica->setDbValue($rs->fields('isosporidiasis_cronica'));
		$this->herpes_zoster->setDbValue($rs->fields('herpes_zoster'));
		$this->Histoplasmosis_diseminada->setDbValue($rs->fields('Histoplasmosis_diseminada'));
		$this->Linfoma_Burkitt->setDbValue($rs->fields('Linfoma_Burkitt'));
		$this->Neumonia_Pneumocystis->setDbValue($rs->fields('Neumonia_Pneumocystis'));
		$this->Neumonia_Recurrente->setDbValue($rs->fields('Neumonia_Recurrente'));
		$this->Linfoma_Inmunoblastico->setDbValue($rs->fields('Linfoma_Inmunoblastico'));
		$this->Criptosporidiasis_cronica->setDbValue($rs->fields('Criptosporidiasis_cronica'));
		$this->Criptococosis_Extrapulmonar->setDbValue($rs->fields('Criptococosis_Extrapulmonar'));
		$this->Sarcoma_Kaposi->setDbValue($rs->fields('Sarcoma_Kaposi'));
		$this->Leucoencefalopatia_Multifocal->setDbValue($rs->fields('Leucoencefalopatia_Multifocal'));
		$this->Septicemia_recurrente->setDbValue($rs->fields('Septicemia_recurrente'));
		$this->Toxoplasmosis_cerebral->setDbValue($rs->fields('Toxoplasmosis_cerebral'));
		$this->HepatitisB->setDbValue($rs->fields('HepatitisB'));
		$this->HepatitisC->setDbValue($rs->fields('HepatitisC'));
		$this->Meningitis->setDbValue($rs->fields('Meningitis'));
		$this->RecuentoCD4->setDbValue($rs->fields('RecuentoCD4'));
		$this->Registrado_Por->setDbValue($rs->fields('Registrado_Por'));
		$this->Centro_Poblado->setDbValue($rs->fields('Centro_Poblado'));
		$this->Vereda->setDbValue($rs->fields('Vereda'));
		$this->Pertenencia_Etnica->setDbValue($rs->fields('Pertenencia_Etnica'));
		$this->Grupo_Poblacional->setDbValue($rs->fields('Grupo_Poblacional'));
		$this->Clasificacion_Inicial->setDbValue($rs->fields('Clasificacion_Inicial'));
		$this->Fecha_Hospitalizacion->setDbValue($rs->fields('Fecha_Hospitalizacion'));
		$this->Seguimiento_Clasificacion_Final->setDbValue($rs->fields('Seguimiento_Clasificacion_Final'));
		$this->Fecha_Ajuste->setDbValue($rs->fields('Fecha_Ajuste'));
		$this->Nombre_Evento->setDbValue($rs->fields('Nombre_Evento'));
		$this->Localidad_residencia->setDbValue($rs->fields('Localidad_residencia'));
		$this->Barrio_residencia->setDbValue($rs->fields('Barrio_residencia'));
		$this->Fecha_ingreso_app->setDbValue($rs->fields('Fecha_ingreso_app'));
		$this->Actualizado_por->setDbValue($rs->fields('Actualizado_por'));
		$this->Fecha_actualizacion_app->setDbValue($rs->fields('Fecha_actualizacion_app'));
		if (!isset($GLOBALS["seguimiento_individual3_grid"])) $GLOBALS["seguimiento_individual3_grid"] = new cseguimiento_individual3_grid;
		$sDetailFilter = $GLOBALS["seguimiento_individual3"]->SqlDetailFilter_registro();
		$sDetailFilter = str_replace("@Id_Registro@", ew_AdjustSql($this->Consecutivo->DbValue, "DB"), $sDetailFilter);
		$GLOBALS["seguimiento_individual3"]->setCurrentMasterTable("registro");
		$sDetailFilter = $GLOBALS["seguimiento_individual3"]->ApplyUserIDFilters($sDetailFilter);
		$this->seguimiento_individual3_Count = $GLOBALS["seguimiento_individual3"]->LoadRecordCount($sDetailFilter);
		if (!isset($GLOBALS["seguimiento_materno_grid"])) $GLOBALS["seguimiento_materno_grid"] = new cseguimiento_materno_grid;
		$sDetailFilter = $GLOBALS["seguimiento_materno"]->SqlDetailFilter_registro();
		$sDetailFilter = str_replace("@Id_Registro@", ew_AdjustSql($this->Consecutivo->DbValue, "DB"), $sDetailFilter);
		$GLOBALS["seguimiento_materno"]->setCurrentMasterTable("registro");
		$sDetailFilter = $GLOBALS["seguimiento_materno"]->ApplyUserIDFilters($sDetailFilter);
		$this->seguimiento_materno_Count = $GLOBALS["seguimiento_materno"]->LoadRecordCount($sDetailFilter);
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Consecutivo->DbValue = $row['Consecutivo'];
		$this->Seguimiento->DbValue = $row['Seguimiento'];
		$this->Condicion_Final->DbValue = $row['Condicion_Final'];
		$this->Codigo_centro->DbValue = $row['Codigo_centro'];
		$this->Codigo_UPGD->DbValue = $row['Codigo_UPGD'];
		$this->Cod_Evento->DbValue = $row['Cod_Evento'];
		$this->Embarazo_Actual->DbValue = $row['Embarazo_Actual'];
		$this->Fecha_Notificacion->DbValue = $row['Fecha_Notificacion'];
		$this->Semana->DbValue = $row['Semana'];
		$this->Periodo_Epidemiologico->DbValue = $row['Periodo_Epidemiologico'];
		$this->Periodo_Sivigila->DbValue = $row['Periodo_Sivigila'];
		$this->Primer_Nombre->DbValue = $row['Primer_Nombre'];
		$this->Segundo_Nombre->DbValue = $row['Segundo_Nombre'];
		$this->Primer_Apellido->DbValue = $row['Primer_Apellido'];
		$this->Segundo_Apellido->DbValue = $row['Segundo_Apellido'];
		$this->Tipo_Id->DbValue = $row['Tipo_Id'];
		$this->Numero_Identificacion->DbValue = $row['Numero_Identificacion'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Unidad_Edad->DbValue = $row['Unidad_Edad'];
		$this->Sexo->DbValue = $row['Sexo'];
		$this->Pais_Ocurrencia->DbValue = $row['Pais_Ocurrencia'];
		$this->Depto_Ocurrencia->DbValue = $row['Depto_Ocurrencia'];
		$this->Municipio_Ocurrencia->DbValue = $row['Municipio_Ocurrencia'];
		$this->Area_Ocurrencia->DbValue = $row['Area_Ocurrencia'];
		$this->Localidad->DbValue = $row['Localidad'];
		$this->Barrio->DbValue = $row['Barrio'];
		$this->Direccion_Residencia->DbValue = $row['Direccion_Residencia'];
		$this->Ocupacion->DbValue = $row['Ocupacion'];
		$this->Tipo_Regimen_Salud->DbValue = $row['Tipo_Regimen_Salud'];
		$this->Cod_Administradora->DbValue = $row['Cod_Administradora'];
		$this->gp_discapa->DbValue = $row['gp_discapa'];
		$this->gp_desplaz->DbValue = $row['gp_desplaz'];
		$this->gp_migrant->DbValue = $row['gp_migrant'];
		$this->gp_carcela->DbValue = $row['gp_carcela'];
		$this->gp_gestan->DbValue = $row['gp_gestan'];
		$this->gp_indigen->DbValue = $row['gp_indigen'];
		$this->gp_pobicbf->DbValue = $row['gp_pobicbf'];
		$this->gp_mad_com->DbValue = $row['gp_mad_com'];
		$this->gp_desmovi->DbValue = $row['gp_desmovi'];
		$this->gp_psiquia->DbValue = $row['gp_psiquia'];
		$this->gp_vic_vio->DbValue = $row['gp_vic_vio'];
		$this->gp_otros->DbValue = $row['gp_otros'];
		$this->Depto_Residencia->DbValue = $row['Depto_Residencia'];
		$this->Municipio_Residencia->DbValue = $row['Municipio_Residencia'];
		$this->Fecha_Consulta->DbValue = $row['Fecha_Consulta'];
		$this->Fecha_Inicio_Sintomas->DbValue = $row['Fecha_Inicio_Sintomas'];
		$this->Hospitalizado->DbValue = $row['Hospitalizado'];
		$this->Fecha_Defuncion->DbValue = $row['Fecha_Defuncion'];
		$this->Numero_Certificado_Defuncion->DbValue = $row['Numero_Certificado_Defuncion'];
		$this->Causa_Basica_Muerte_CIEX->DbValue = $row['Causa_Basica_Muerte_CIEX'];
		$this->Entidad_fallecimiento->DbValue = $row['Entidad_fallecimiento'];
		$this->Telefono->DbValue = $row['Telefono'];
		$this->Fecha_Nacimiento->DbValue = $row['Fecha_Nacimiento'];
		$this->Nombre_Profesional_Diligencia->DbValue = $row['Nombre_Profesional_Diligencia'];
		$this->Telefono_Profesional_Diligencia->DbValue = $row['Telefono_Profesional_Diligencia'];
		$this->Mecanismo_Probable_Transmision->DbValue = $row['Mecanismo_Probable_Transmision'];
		$this->Nombre_Madre->DbValue = $row['Nombre_Madre'];
		$this->Tipo_Id_Madre->DbValue = $row['Tipo_Id_Madre'];
		$this->Numero_Identificacion_Madre->DbValue = $row['Numero_Identificacion_Madre'];
		$this->Indentidad_Genero->DbValue = $row['Indentidad_Genero'];
		$this->Donador_Sangre_Ultimos_12_Meses->DbValue = $row['Donador_Sangre_Ultimos_12_Meses'];
		$this->Fecha_Donacion->DbValue = $row['Fecha_Donacion'];
		$this->Nombre_Institucion_Donacion->DbValue = $row['Nombre_Institucion_Donacion'];
		$this->Poblacion_clave->DbValue = $row['Poblacion_clave'];
		$this->Recibio_Asesoria_Pre_Prueba->DbValue = $row['Recibio_Asesoria_Pre_Prueba'];
		$this->Recibio_Asesoria_Post_Prueba->DbValue = $row['Recibio_Asesoria_Post_Prueba'];
		$this->Tipo_Prueba->DbValue = $row['Tipo_Prueba'];
		$this->Fecha_Resultado_Confirmatorio->DbValue = $row['Fecha_Resultado_Confirmatorio'];
		$this->Valor_Carga_Viral->DbValue = $row['Valor_Carga_Viral'];
		$this->Estado_Clinico_Notificacion->DbValue = $row['Estado_Clinico_Notificacion'];
		$this->Hijos_Mujeres_Menores_5->DbValue = $row['Hijos_Mujeres_Menores_5'];
		$this->Hijos_Hombres_Menores_5->DbValue = $row['Hijos_Hombres_Menores_5'];
		$this->Numero_Semanas_Embarazo->DbValue = $row['Numero_Semanas_Embarazo'];
		$this->Antecedentes_Embarazo->DbValue = $row['Antecedentes_Embarazo'];
		$this->Candidiasis_esofagica->DbValue = $row['Candidiasis_esofagica'];
		$this->Candidiasis_vias_aereas->DbValue = $row['Candidiasis_vias_aereas'];
		$this->Tuberculosis_pulmonar->DbValue = $row['Tuberculosis_pulmonar'];
		$this->Cancer_cervical->DbValue = $row['Cancer_cervical'];
		$this->Tuberculosis_extrapulmonar->DbValue = $row['Tuberculosis_extrapulmonar'];
		$this->Coccidiomicosis->DbValue = $row['Coccidiomicosis'];
		$this->Citomegalovirosis->DbValue = $row['Citomegalovirosis'];
		$this->Retinitis_citomegalovirosis->DbValue = $row['Retinitis_citomegalovirosis'];
		$this->Sindrome_Emanciacion->DbValue = $row['Sindrome_Emanciacion'];
		$this->Encefalopatia->DbValue = $row['Encefalopatia'];
		$this->Otras_micobacterias->DbValue = $row['Otras_micobacterias'];
		$this->Histoplasmosis_Extrapulmonar->DbValue = $row['Histoplasmosis_Extrapulmonar'];
		$this->isosporidiasis_cronica->DbValue = $row['isosporidiasis_cronica'];
		$this->herpes_zoster->DbValue = $row['herpes_zoster'];
		$this->Histoplasmosis_diseminada->DbValue = $row['Histoplasmosis_diseminada'];
		$this->Linfoma_Burkitt->DbValue = $row['Linfoma_Burkitt'];
		$this->Neumonia_Pneumocystis->DbValue = $row['Neumonia_Pneumocystis'];
		$this->Neumonia_Recurrente->DbValue = $row['Neumonia_Recurrente'];
		$this->Linfoma_Inmunoblastico->DbValue = $row['Linfoma_Inmunoblastico'];
		$this->Criptosporidiasis_cronica->DbValue = $row['Criptosporidiasis_cronica'];
		$this->Criptococosis_Extrapulmonar->DbValue = $row['Criptococosis_Extrapulmonar'];
		$this->Sarcoma_Kaposi->DbValue = $row['Sarcoma_Kaposi'];
		$this->Leucoencefalopatia_Multifocal->DbValue = $row['Leucoencefalopatia_Multifocal'];
		$this->Septicemia_recurrente->DbValue = $row['Septicemia_recurrente'];
		$this->Toxoplasmosis_cerebral->DbValue = $row['Toxoplasmosis_cerebral'];
		$this->HepatitisB->DbValue = $row['HepatitisB'];
		$this->HepatitisC->DbValue = $row['HepatitisC'];
		$this->Meningitis->DbValue = $row['Meningitis'];
		$this->RecuentoCD4->DbValue = $row['RecuentoCD4'];
		$this->Registrado_Por->DbValue = $row['Registrado_Por'];
		$this->Centro_Poblado->DbValue = $row['Centro_Poblado'];
		$this->Vereda->DbValue = $row['Vereda'];
		$this->Pertenencia_Etnica->DbValue = $row['Pertenencia_Etnica'];
		$this->Grupo_Poblacional->DbValue = $row['Grupo_Poblacional'];
		$this->Clasificacion_Inicial->DbValue = $row['Clasificacion_Inicial'];
		$this->Fecha_Hospitalizacion->DbValue = $row['Fecha_Hospitalizacion'];
		$this->Seguimiento_Clasificacion_Final->DbValue = $row['Seguimiento_Clasificacion_Final'];
		$this->Fecha_Ajuste->DbValue = $row['Fecha_Ajuste'];
		$this->Nombre_Evento->DbValue = $row['Nombre_Evento'];
		$this->Localidad_residencia->DbValue = $row['Localidad_residencia'];
		$this->Barrio_residencia->DbValue = $row['Barrio_residencia'];
		$this->Fecha_ingreso_app->DbValue = $row['Fecha_ingreso_app'];
		$this->Actualizado_por->DbValue = $row['Actualizado_por'];
		$this->Fecha_actualizacion_app->DbValue = $row['Fecha_actualizacion_app'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("Consecutivo")) <> "")
			$this->Consecutivo->CurrentValue = $this->getKey("Consecutivo"); // Consecutivo
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Consecutivo
		// Seguimiento
		// Condicion_Final
		// Codigo_centro
		// Codigo_UPGD
		// Cod_Evento
		// Embarazo_Actual
		// Fecha_Notificacion
		// Semana
		// Periodo_Epidemiologico
		// Periodo_Sivigila
		// Primer_Nombre
		// Segundo_Nombre
		// Primer_Apellido
		// Segundo_Apellido
		// Tipo_Id
		// Numero_Identificacion
		// Edad
		// Unidad_Edad
		// Sexo
		// Pais_Ocurrencia
		// Depto_Ocurrencia
		// Municipio_Ocurrencia
		// Area_Ocurrencia
		// Localidad
		// Barrio
		// Direccion_Residencia
		// Ocupacion
		// Tipo_Regimen_Salud
		// Cod_Administradora
		// gp_discapa
		// gp_desplaz
		// gp_migrant
		// gp_carcela
		// gp_gestan
		// gp_indigen
		// gp_pobicbf
		// gp_mad_com
		// gp_desmovi
		// gp_psiquia
		// gp_vic_vio
		// gp_otros
		// Depto_Residencia
		// Municipio_Residencia
		// Fecha_Consulta
		// Fecha_Inicio_Sintomas
		// Hospitalizado
		// Fecha_Defuncion
		// Numero_Certificado_Defuncion
		// Causa_Basica_Muerte_CIEX
		// Entidad_fallecimiento
		// Telefono
		// Fecha_Nacimiento
		// Nombre_Profesional_Diligencia
		// Telefono_Profesional_Diligencia
		// Mecanismo_Probable_Transmision
		// Nombre_Madre
		// Tipo_Id_Madre
		// Numero_Identificacion_Madre
		// Indentidad_Genero
		// Donador_Sangre_Ultimos_12_Meses
		// Fecha_Donacion
		// Nombre_Institucion_Donacion
		// Poblacion_clave
		// Recibio_Asesoria_Pre_Prueba
		// Recibio_Asesoria_Post_Prueba
		// Tipo_Prueba
		// Fecha_Resultado_Confirmatorio
		// Valor_Carga_Viral
		// Estado_Clinico_Notificacion
		// Hijos_Mujeres_Menores_5
		// Hijos_Hombres_Menores_5
		// Numero_Semanas_Embarazo
		// Antecedentes_Embarazo
		// Candidiasis_esofagica
		// Candidiasis_vias_aereas
		// Tuberculosis_pulmonar
		// Cancer_cervical
		// Tuberculosis_extrapulmonar
		// Coccidiomicosis
		// Citomegalovirosis
		// Retinitis_citomegalovirosis
		// Sindrome_Emanciacion
		// Encefalopatia
		// Otras_micobacterias
		// Histoplasmosis_Extrapulmonar
		// isosporidiasis_cronica
		// herpes_zoster
		// Histoplasmosis_diseminada
		// Linfoma_Burkitt
		// Neumonia_Pneumocystis
		// Neumonia_Recurrente
		// Linfoma_Inmunoblastico
		// Criptosporidiasis_cronica
		// Criptococosis_Extrapulmonar
		// Sarcoma_Kaposi
		// Leucoencefalopatia_Multifocal
		// Septicemia_recurrente
		// Toxoplasmosis_cerebral
		// HepatitisB
		// HepatitisC
		// Meningitis
		// RecuentoCD4
		// Registrado_Por
		// Centro_Poblado
		// Vereda
		// Pertenencia_Etnica
		// Grupo_Poblacional
		// Clasificacion_Inicial
		// Fecha_Hospitalizacion
		// Seguimiento_Clasificacion_Final
		// Fecha_Ajuste
		// Nombre_Evento
		// Localidad_residencia
		// Barrio_residencia
		// Fecha_ingreso_app
		// Actualizado_por
		// Fecha_actualizacion_app

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Consecutivo
		$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
		$this->Consecutivo->ViewCustomAttributes = "";

		// Seguimiento
		if (strval($this->Seguimiento->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Seguimiento->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Seguimiento, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Seguimiento->ViewValue = $this->Seguimiento->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Seguimiento->ViewValue = $this->Seguimiento->CurrentValue;
			}
		} else {
			$this->Seguimiento->ViewValue = NULL;
		}
		$this->Seguimiento->ViewCustomAttributes = "";

		// Condicion_Final
		if (strval($this->Condicion_Final->CurrentValue) <> "") {
			$sFilterWrk = "`No.Condicion_Final`" . ew_SearchString("=", $this->Condicion_Final->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `No.Condicion_Final`, `Condicion_Final` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `condicion_final`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Condicion_Final, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Condicion_Final->ViewValue = $this->Condicion_Final->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Condicion_Final->ViewValue = $this->Condicion_Final->CurrentValue;
			}
		} else {
			$this->Condicion_Final->ViewValue = NULL;
		}
		$this->Condicion_Final->ViewCustomAttributes = "";

		// Codigo_centro
		if (strval($this->Codigo_centro->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_centro->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Upgd` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Codigo_centro, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Codigo_centro->ViewValue = $this->Codigo_centro->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Codigo_centro->ViewValue = $this->Codigo_centro->CurrentValue;
			}
		} else {
			$this->Codigo_centro->ViewValue = NULL;
		}
		$this->Codigo_centro->ViewCustomAttributes = "";

		// Codigo_UPGD
		$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->CurrentValue;
		if (strval($this->Codigo_UPGD->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_UPGD->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Codigo_UPGD, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->CurrentValue;
			}
		} else {
			$this->Codigo_UPGD->ViewValue = NULL;
		}
		$this->Codigo_UPGD->ViewCustomAttributes = "";

		// Cod_Evento
		$this->Cod_Evento->ViewValue = $this->Cod_Evento->CurrentValue;
		$this->Cod_Evento->ViewCustomAttributes = "";

		// Embarazo_Actual
		if (strval($this->Embarazo_Actual->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Embarazo_Actual->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Embarazo_Actual, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Embarazo_Actual->ViewValue = $this->Embarazo_Actual->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Embarazo_Actual->ViewValue = $this->Embarazo_Actual->CurrentValue;
			}
		} else {
			$this->Embarazo_Actual->ViewValue = NULL;
		}
		$this->Embarazo_Actual->ViewCustomAttributes = "";

		// Fecha_Notificacion
		$this->Fecha_Notificacion->ViewValue = $this->Fecha_Notificacion->CurrentValue;
		$this->Fecha_Notificacion->ViewValue = ew_FormatDateTime($this->Fecha_Notificacion->ViewValue, 5);
		$this->Fecha_Notificacion->ViewCustomAttributes = "";

		// Semana
		if (strval($this->Semana->CurrentValue) <> "") {
			$sFilterWrk = "`Semana`" . ew_SearchString("=", $this->Semana->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Semana`, `Semana` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `semana_epidemiologica`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Semana, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Semana->ViewValue = $this->Semana->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Semana->ViewValue = $this->Semana->CurrentValue;
			}
		} else {
			$this->Semana->ViewValue = NULL;
		}
		$this->Semana->ViewCustomAttributes = "";

		// Periodo_Epidemiologico
		if (strval($this->Periodo_Epidemiologico->CurrentValue) <> "") {
			$sFilterWrk = "`Periodo_epidemiologico`" . ew_SearchString("=", $this->Periodo_Epidemiologico->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Periodo_epidemiologico`, `Periodo_epidemiologico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `periodo_epidemiologico`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Periodo_Epidemiologico, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Periodo_Epidemiologico->ViewValue = $this->Periodo_Epidemiologico->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Periodo_Epidemiologico->ViewValue = $this->Periodo_Epidemiologico->CurrentValue;
			}
		} else {
			$this->Periodo_Epidemiologico->ViewValue = NULL;
		}
		$this->Periodo_Epidemiologico->ViewCustomAttributes = "";

		// Periodo_Sivigila
		if (strval($this->Periodo_Sivigila->CurrentValue) <> "") {
			$sFilterWrk = "`Periodo`" . ew_SearchString("=", $this->Periodo_Sivigila->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Periodo`, `Periodo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `periodo`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Periodo_Sivigila, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Periodo_Sivigila->ViewValue = $this->Periodo_Sivigila->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Periodo_Sivigila->ViewValue = $this->Periodo_Sivigila->CurrentValue;
			}
		} else {
			$this->Periodo_Sivigila->ViewValue = NULL;
		}
		$this->Periodo_Sivigila->ViewCustomAttributes = "";

		// Primer_Nombre
		$this->Primer_Nombre->ViewValue = $this->Primer_Nombre->CurrentValue;
		$this->Primer_Nombre->ViewCustomAttributes = "";

		// Segundo_Nombre
		$this->Segundo_Nombre->ViewValue = $this->Segundo_Nombre->CurrentValue;
		$this->Segundo_Nombre->ViewCustomAttributes = "";

		// Primer_Apellido
		$this->Primer_Apellido->ViewValue = $this->Primer_Apellido->CurrentValue;
		$this->Primer_Apellido->ViewCustomAttributes = "";

		// Segundo_Apellido
		$this->Segundo_Apellido->ViewValue = $this->Segundo_Apellido->CurrentValue;
		$this->Segundo_Apellido->ViewCustomAttributes = "";

		// Tipo_Id
		if (strval($this->Tipo_Id->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Documento`" . ew_SearchString("=", $this->Tipo_Id->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Cod_Documento`, `Tipo_Ide` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Id, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Id->ViewValue = $this->Tipo_Id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Id->ViewValue = $this->Tipo_Id->CurrentValue;
			}
		} else {
			$this->Tipo_Id->ViewValue = NULL;
		}
		$this->Tipo_Id->ViewCustomAttributes = "";

		// Numero_Identificacion
		$this->Numero_Identificacion->ViewValue = $this->Numero_Identificacion->CurrentValue;
		$this->Numero_Identificacion->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Unidad_Edad
		if (strval($this->Unidad_Edad->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Unidad_Edad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Unidad_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `unidad_medida_edad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Unidad_Edad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Unidad_Edad->ViewValue = $this->Unidad_Edad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Unidad_Edad->ViewValue = $this->Unidad_Edad->CurrentValue;
			}
		} else {
			$this->Unidad_Edad->ViewValue = NULL;
		}
		$this->Unidad_Edad->ViewCustomAttributes = "";

		// Sexo
		if (strval($this->Sexo->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Sexo`" . ew_SearchString("=", $this->Sexo->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Sexo`, `Sexo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sexo`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sexo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sexo->ViewValue = $this->Sexo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
			}
		} else {
			$this->Sexo->ViewValue = NULL;
		}
		$this->Sexo->ViewCustomAttributes = "";

		// Pais_Ocurrencia
		if (strval($this->Pais_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Pais`" . ew_SearchString("=", $this->Pais_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Pais`, `Pais` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `pais`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Pais_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Pais_Ocurrencia->ViewValue = $this->Pais_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Pais_Ocurrencia->ViewValue = $this->Pais_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Pais_Ocurrencia->ViewValue = NULL;
		}
		$this->Pais_Ocurrencia->ViewCustomAttributes = "";

		// Depto_Ocurrencia
		if (strval($this->Depto_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Departamento`" . ew_SearchString("=", $this->Depto_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Departamento`, `Departamento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `departamento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Depto_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Depto_Ocurrencia->ViewValue = $this->Depto_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Depto_Ocurrencia->ViewValue = $this->Depto_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Depto_Ocurrencia->ViewValue = NULL;
		}
		$this->Depto_Ocurrencia->ViewCustomAttributes = "";

		// Municipio_Ocurrencia
		if (strval($this->Municipio_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Municipio`" . ew_SearchString("=", $this->Municipio_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Municipio`, `Municipio` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `municipio`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Municipio_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Municipio_Ocurrencia->ViewValue = $this->Municipio_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Municipio_Ocurrencia->ViewValue = $this->Municipio_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Municipio_Ocurrencia->ViewValue = NULL;
		}
		$this->Municipio_Ocurrencia->ViewCustomAttributes = "";

		// Area_Ocurrencia
		if (strval($this->Area_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Area_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Area_Ocurrencia` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `area_ocurrencia`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Area_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Area_Ocurrencia->ViewValue = $this->Area_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Area_Ocurrencia->ViewValue = $this->Area_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Area_Ocurrencia->ViewValue = NULL;
		}
		$this->Area_Ocurrencia->ViewCustomAttributes = "";

		// Localidad
		if (strval($this->Localidad->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Localidad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `localidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Localidad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Localidad->ViewValue = $this->Localidad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Localidad->ViewValue = $this->Localidad->CurrentValue;
			}
		} else {
			$this->Localidad->ViewValue = NULL;
		}
		$this->Localidad->ViewCustomAttributes = "";

		// Barrio
		if (strval($this->Barrio->CurrentValue) <> "") {
			$sFilterWrk = "`cod_barrio_vereda`" . ew_SearchString("=", $this->Barrio->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `cod_barrio_vereda`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrios_veredas`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Barrio, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Barrio->ViewValue = $this->Barrio->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Barrio->ViewValue = $this->Barrio->CurrentValue;
			}
		} else {
			$this->Barrio->ViewValue = NULL;
		}
		$this->Barrio->ViewCustomAttributes = "";

		// Direccion_Residencia
		$this->Direccion_Residencia->ViewValue = $this->Direccion_Residencia->CurrentValue;
		$this->Direccion_Residencia->ViewCustomAttributes = "";

		// Ocupacion
		if (strval($this->Ocupacion->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Ocupacion`" . ew_SearchString("=", $this->Ocupacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Ocupacion`, `Cod_Ocupacion` AS `DispFld`, `Ocupacion` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `ocupacion`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Ocupacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Ocupacion->ViewValue = $this->Ocupacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Ocupacion->ViewValue = $this->Ocupacion->CurrentValue;
			}
		} else {
			$this->Ocupacion->ViewValue = NULL;
		}
		$this->Ocupacion->ViewCustomAttributes = "";

		// Tipo_Regimen_Salud
		if (strval($this->Tipo_Regimen_Salud->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Regimen`" . ew_SearchString("=", $this->Tipo_Regimen_Salud->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Regimen`, `Codigo_Regimen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_regimen_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Regimen_Salud, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->CurrentValue;
			}
		} else {
			$this->Tipo_Regimen_Salud->ViewValue = NULL;
		}
		$this->Tipo_Regimen_Salud->ViewCustomAttributes = "";

		// Cod_Administradora
		if (strval($this->Cod_Administradora->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->Cod_Administradora->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Cod_Administradora, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Cod_Administradora->ViewValue = $this->Cod_Administradora->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Cod_Administradora->ViewValue = $this->Cod_Administradora->CurrentValue;
			}
		} else {
			$this->Cod_Administradora->ViewValue = NULL;
		}
		$this->Cod_Administradora->ViewCustomAttributes = "";

		// gp_discapa
		if (strval($this->gp_discapa->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_discapa->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_discapa, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_discapa->ViewValue = $this->gp_discapa->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_discapa->ViewValue = $this->gp_discapa->CurrentValue;
			}
		} else {
			$this->gp_discapa->ViewValue = NULL;
		}
		$this->gp_discapa->ViewCustomAttributes = "";

		// gp_desplaz
		if (strval($this->gp_desplaz->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_desplaz->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_desplaz, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_desplaz->ViewValue = $this->gp_desplaz->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_desplaz->ViewValue = $this->gp_desplaz->CurrentValue;
			}
		} else {
			$this->gp_desplaz->ViewValue = NULL;
		}
		$this->gp_desplaz->ViewCustomAttributes = "";

		// gp_migrant
		if (strval($this->gp_migrant->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_migrant->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_migrant, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_migrant->ViewValue = $this->gp_migrant->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_migrant->ViewValue = $this->gp_migrant->CurrentValue;
			}
		} else {
			$this->gp_migrant->ViewValue = NULL;
		}
		$this->gp_migrant->ViewCustomAttributes = "";

		// gp_carcela
		if (strval($this->gp_carcela->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_carcela->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_carcela, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_carcela->ViewValue = $this->gp_carcela->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_carcela->ViewValue = $this->gp_carcela->CurrentValue;
			}
		} else {
			$this->gp_carcela->ViewValue = NULL;
		}
		$this->gp_carcela->ViewCustomAttributes = "";

		// gp_gestan
		if (strval($this->gp_gestan->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_gestan->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_gestan, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_gestan->ViewValue = $this->gp_gestan->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_gestan->ViewValue = $this->gp_gestan->CurrentValue;
			}
		} else {
			$this->gp_gestan->ViewValue = NULL;
		}
		$this->gp_gestan->ViewCustomAttributes = "";

		// gp_indigen
		if (strval($this->gp_indigen->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_indigen->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_indigen, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_indigen->ViewValue = $this->gp_indigen->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_indigen->ViewValue = $this->gp_indigen->CurrentValue;
			}
		} else {
			$this->gp_indigen->ViewValue = NULL;
		}
		$this->gp_indigen->ViewCustomAttributes = "";

		// gp_pobicbf
		if (strval($this->gp_pobicbf->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_pobicbf->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_pobicbf, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_pobicbf->ViewValue = $this->gp_pobicbf->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_pobicbf->ViewValue = $this->gp_pobicbf->CurrentValue;
			}
		} else {
			$this->gp_pobicbf->ViewValue = NULL;
		}
		$this->gp_pobicbf->ViewCustomAttributes = "";

		// gp_mad_com
		if (strval($this->gp_mad_com->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_mad_com->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_mad_com, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_mad_com->ViewValue = $this->gp_mad_com->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_mad_com->ViewValue = $this->gp_mad_com->CurrentValue;
			}
		} else {
			$this->gp_mad_com->ViewValue = NULL;
		}
		$this->gp_mad_com->ViewCustomAttributes = "";

		// gp_desmovi
		if (strval($this->gp_desmovi->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_desmovi->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_desmovi, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_desmovi->ViewValue = $this->gp_desmovi->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_desmovi->ViewValue = $this->gp_desmovi->CurrentValue;
			}
		} else {
			$this->gp_desmovi->ViewValue = NULL;
		}
		$this->gp_desmovi->ViewCustomAttributes = "";

		// gp_psiquia
		if (strval($this->gp_psiquia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_psiquia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_psiquia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_psiquia->ViewValue = $this->gp_psiquia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_psiquia->ViewValue = $this->gp_psiquia->CurrentValue;
			}
		} else {
			$this->gp_psiquia->ViewValue = NULL;
		}
		$this->gp_psiquia->ViewCustomAttributes = "";

		// gp_vic_vio
		if (strval($this->gp_vic_vio->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_vic_vio->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_vic_vio, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_vic_vio->ViewValue = $this->gp_vic_vio->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_vic_vio->ViewValue = $this->gp_vic_vio->CurrentValue;
			}
		} else {
			$this->gp_vic_vio->ViewValue = NULL;
		}
		$this->gp_vic_vio->ViewCustomAttributes = "";

		// gp_otros
		if (strval($this->gp_otros->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_otros->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_otros, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_otros->ViewValue = $this->gp_otros->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_otros->ViewValue = $this->gp_otros->CurrentValue;
			}
		} else {
			$this->gp_otros->ViewValue = NULL;
		}
		$this->gp_otros->ViewCustomAttributes = "";

		// Depto_Residencia
		if (strval($this->Depto_Residencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Departamento`" . ew_SearchString("=", $this->Depto_Residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Departamento`, `Departamento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `departamento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Depto_Residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Depto_Residencia->ViewValue = $this->Depto_Residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Depto_Residencia->ViewValue = $this->Depto_Residencia->CurrentValue;
			}
		} else {
			$this->Depto_Residencia->ViewValue = NULL;
		}
		$this->Depto_Residencia->ViewCustomAttributes = "";

		// Municipio_Residencia
		if (strval($this->Municipio_Residencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Municipio`" . ew_SearchString("=", $this->Municipio_Residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Municipio`, `Municipio` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `municipio`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Municipio_Residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Municipio_Residencia->ViewValue = $this->Municipio_Residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Municipio_Residencia->ViewValue = $this->Municipio_Residencia->CurrentValue;
			}
		} else {
			$this->Municipio_Residencia->ViewValue = NULL;
		}
		$this->Municipio_Residencia->ViewCustomAttributes = "";

		// Fecha_Consulta
		$this->Fecha_Consulta->ViewValue = $this->Fecha_Consulta->CurrentValue;
		$this->Fecha_Consulta->ViewValue = ew_FormatDateTime($this->Fecha_Consulta->ViewValue, 5);
		$this->Fecha_Consulta->ViewCustomAttributes = "";

		// Fecha_Inicio_Sintomas
		$this->Fecha_Inicio_Sintomas->ViewValue = $this->Fecha_Inicio_Sintomas->CurrentValue;
		$this->Fecha_Inicio_Sintomas->ViewValue = ew_FormatDateTime($this->Fecha_Inicio_Sintomas->ViewValue, 5);
		$this->Fecha_Inicio_Sintomas->ViewCustomAttributes = "";

		// Hospitalizado
		if (strval($this->Hospitalizado->CurrentValue) <> "") {
			$arwrk = explode(",", $this->Hospitalizado->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`Consecutivo`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Hospitalizado, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Hospitalizado->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->Hospitalizado->ViewValue .= $this->Hospitalizado->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->Hospitalizado->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->Hospitalizado->ViewValue = $this->Hospitalizado->CurrentValue;
			}
		} else {
			$this->Hospitalizado->ViewValue = NULL;
		}
		$this->Hospitalizado->ViewCustomAttributes = "";

		// Fecha_Defuncion
		$this->Fecha_Defuncion->ViewValue = $this->Fecha_Defuncion->CurrentValue;
		$this->Fecha_Defuncion->ViewValue = ew_FormatDateTime($this->Fecha_Defuncion->ViewValue, 5);
		$this->Fecha_Defuncion->ViewCustomAttributes = "";

		// Numero_Certificado_Defuncion
		$this->Numero_Certificado_Defuncion->ViewValue = $this->Numero_Certificado_Defuncion->CurrentValue;
		$this->Numero_Certificado_Defuncion->ViewCustomAttributes = "";

		// Causa_Basica_Muerte_CIEX
		$this->Causa_Basica_Muerte_CIEX->ViewValue = $this->Causa_Basica_Muerte_CIEX->CurrentValue;
		$this->Causa_Basica_Muerte_CIEX->ViewCustomAttributes = "";

		// Entidad_fallecimiento
		$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->CurrentValue;
		if (strval($this->Entidad_fallecimiento->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Entidad_fallecimiento->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad_fallecimiento, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->CurrentValue;
			}
		} else {
			$this->Entidad_fallecimiento->ViewValue = NULL;
		}
		$this->Entidad_fallecimiento->ViewCustomAttributes = "";

		// Telefono
		$this->Telefono->ViewValue = $this->Telefono->CurrentValue;
		$this->Telefono->ViewCustomAttributes = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
		$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 5);
		$this->Fecha_Nacimiento->ViewCustomAttributes = "";

		// Nombre_Profesional_Diligencia
		$this->Nombre_Profesional_Diligencia->ViewValue = $this->Nombre_Profesional_Diligencia->CurrentValue;
		$this->Nombre_Profesional_Diligencia->ViewCustomAttributes = "";

		// Telefono_Profesional_Diligencia
		$this->Telefono_Profesional_Diligencia->ViewValue = $this->Telefono_Profesional_Diligencia->CurrentValue;
		$this->Telefono_Profesional_Diligencia->ViewCustomAttributes = "";

		// Mecanismo_Probable_Transmision
		if (strval($this->Mecanismo_Probable_Transmision->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Mecanismo_Probable_Transmision->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Mecanismo_Probable` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `mecanismo_probable_transmision`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Mecanismo_Probable_Transmision, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Mecanismo_Probable_Transmision->ViewValue = $this->Mecanismo_Probable_Transmision->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Mecanismo_Probable_Transmision->ViewValue = $this->Mecanismo_Probable_Transmision->CurrentValue;
			}
		} else {
			$this->Mecanismo_Probable_Transmision->ViewValue = NULL;
		}
		$this->Mecanismo_Probable_Transmision->ViewCustomAttributes = "";

		// Nombre_Madre
		$this->Nombre_Madre->ViewValue = $this->Nombre_Madre->CurrentValue;
		$this->Nombre_Madre->ViewCustomAttributes = "";

		// Tipo_Id_Madre
		if (strval($this->Tipo_Id_Madre->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Documento`" . ew_SearchString("=", $this->Tipo_Id_Madre->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Cod_Documento`, `Tipo_Ide` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Id_Madre, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Id_Madre->ViewValue = $this->Tipo_Id_Madre->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Id_Madre->ViewValue = $this->Tipo_Id_Madre->CurrentValue;
			}
		} else {
			$this->Tipo_Id_Madre->ViewValue = NULL;
		}
		$this->Tipo_Id_Madre->ViewCustomAttributes = "";

		// Numero_Identificacion_Madre
		$this->Numero_Identificacion_Madre->ViewValue = $this->Numero_Identificacion_Madre->CurrentValue;
		$this->Numero_Identificacion_Madre->ViewCustomAttributes = "";

		// Indentidad_Genero
		if (strval($this->Indentidad_Genero->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_identidad`" . ew_SearchString("=", $this->Indentidad_Genero->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_identidad`, `Identidad_genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `identidad_genero`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Indentidad_Genero, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Indentidad_Genero->ViewValue = $this->Indentidad_Genero->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Indentidad_Genero->ViewValue = $this->Indentidad_Genero->CurrentValue;
			}
		} else {
			$this->Indentidad_Genero->ViewValue = NULL;
		}
		$this->Indentidad_Genero->ViewCustomAttributes = "";

		// Donador_Sangre_Ultimos_12_Meses
		if (strval($this->Donador_Sangre_Ultimos_12_Meses->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Donador_Sangre_Ultimos_12_Meses, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = $this->Donador_Sangre_Ultimos_12_Meses->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue;
			}
		} else {
			$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = NULL;
		}
		$this->Donador_Sangre_Ultimos_12_Meses->ViewCustomAttributes = "";

		// Fecha_Donacion
		$this->Fecha_Donacion->ViewValue = $this->Fecha_Donacion->CurrentValue;
		$this->Fecha_Donacion->ViewValue = ew_FormatDateTime($this->Fecha_Donacion->ViewValue, 5);
		$this->Fecha_Donacion->ViewCustomAttributes = "";

		// Nombre_Institucion_Donacion
		$this->Nombre_Institucion_Donacion->ViewValue = $this->Nombre_Institucion_Donacion->CurrentValue;
		$this->Nombre_Institucion_Donacion->ViewCustomAttributes = "";

		// Poblacion_clave
		if (strval($this->Poblacion_clave->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Poblacion_clave->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Poblacion_clave` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `poblacion_clave`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Poblacion_clave, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Poblacion_clave->ViewValue = $this->Poblacion_clave->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Poblacion_clave->ViewValue = $this->Poblacion_clave->CurrentValue;
			}
		} else {
			$this->Poblacion_clave->ViewValue = NULL;
		}
		$this->Poblacion_clave->ViewCustomAttributes = "";

		// Recibio_Asesoria_Pre_Prueba
		if (strval($this->Recibio_Asesoria_Pre_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Recibio_Asesoria_Pre_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Recibio_Asesoria_Pre_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Recibio_Asesoria_Pre_Prueba->ViewValue = $this->Recibio_Asesoria_Pre_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Recibio_Asesoria_Pre_Prueba->ViewValue = $this->Recibio_Asesoria_Pre_Prueba->CurrentValue;
			}
		} else {
			$this->Recibio_Asesoria_Pre_Prueba->ViewValue = NULL;
		}
		$this->Recibio_Asesoria_Pre_Prueba->ViewCustomAttributes = "";

		// Recibio_Asesoria_Post_Prueba
		if (strval($this->Recibio_Asesoria_Post_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Recibio_Asesoria_Post_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Recibio_Asesoria_Post_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Recibio_Asesoria_Post_Prueba->ViewValue = $this->Recibio_Asesoria_Post_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Recibio_Asesoria_Post_Prueba->ViewValue = $this->Recibio_Asesoria_Post_Prueba->CurrentValue;
			}
		} else {
			$this->Recibio_Asesoria_Post_Prueba->ViewValue = NULL;
		}
		$this->Recibio_Asesoria_Post_Prueba->ViewCustomAttributes = "";

		// Tipo_Prueba
		if (strval($this->Tipo_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tipo_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Tipo_Prueba` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_prueba`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Prueba->ViewValue = $this->Tipo_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Prueba->ViewValue = $this->Tipo_Prueba->CurrentValue;
			}
		} else {
			$this->Tipo_Prueba->ViewValue = NULL;
		}
		$this->Tipo_Prueba->ViewCustomAttributes = "";

		// Fecha_Resultado_Confirmatorio
		$this->Fecha_Resultado_Confirmatorio->ViewValue = $this->Fecha_Resultado_Confirmatorio->CurrentValue;
		$this->Fecha_Resultado_Confirmatorio->ViewValue = ew_FormatDateTime($this->Fecha_Resultado_Confirmatorio->ViewValue, 5);
		$this->Fecha_Resultado_Confirmatorio->ViewCustomAttributes = "";

		// Valor_Carga_Viral
		$this->Valor_Carga_Viral->ViewValue = $this->Valor_Carga_Viral->CurrentValue;
		$this->Valor_Carga_Viral->ViewCustomAttributes = "";

		// Estado_Clinico_Notificacion
		if (strval($this->Estado_Clinico_Notificacion->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Estado_Clinico_Notificacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Estado_Clinico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `estado_clinico_paciente`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Estado_Clinico_Notificacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Estado_Clinico_Notificacion->ViewValue = $this->Estado_Clinico_Notificacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Estado_Clinico_Notificacion->ViewValue = $this->Estado_Clinico_Notificacion->CurrentValue;
			}
		} else {
			$this->Estado_Clinico_Notificacion->ViewValue = NULL;
		}
		$this->Estado_Clinico_Notificacion->ViewCustomAttributes = "";

		// Hijos_Mujeres_Menores_5
		$this->Hijos_Mujeres_Menores_5->ViewValue = $this->Hijos_Mujeres_Menores_5->CurrentValue;
		$this->Hijos_Mujeres_Menores_5->ViewCustomAttributes = "";

		// Hijos_Hombres_Menores_5
		$this->Hijos_Hombres_Menores_5->ViewValue = $this->Hijos_Hombres_Menores_5->CurrentValue;
		$this->Hijos_Hombres_Menores_5->ViewCustomAttributes = "";

		// Numero_Semanas_Embarazo
		$this->Numero_Semanas_Embarazo->ViewValue = $this->Numero_Semanas_Embarazo->CurrentValue;
		$this->Numero_Semanas_Embarazo->ViewCustomAttributes = "";

		// Antecedentes_Embarazo
		if (strval($this->Antecedentes_Embarazo->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Antecedentes_Embarazo->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Antecedentes_Embarazo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Antecedentes_Embarazo->ViewValue = $this->Antecedentes_Embarazo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Antecedentes_Embarazo->ViewValue = $this->Antecedentes_Embarazo->CurrentValue;
			}
		} else {
			$this->Antecedentes_Embarazo->ViewValue = NULL;
		}
		$this->Antecedentes_Embarazo->ViewCustomAttributes = "";

		// Candidiasis_esofagica
		if (strval($this->Candidiasis_esofagica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Candidiasis_esofagica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Candidiasis_esofagica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Candidiasis_esofagica->ViewValue = $this->Candidiasis_esofagica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Candidiasis_esofagica->ViewValue = $this->Candidiasis_esofagica->CurrentValue;
			}
		} else {
			$this->Candidiasis_esofagica->ViewValue = NULL;
		}
		$this->Candidiasis_esofagica->ViewCustomAttributes = "";

		// Candidiasis_vias_aereas
		if (strval($this->Candidiasis_vias_aereas->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Candidiasis_vias_aereas->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Candidiasis_vias_aereas, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Candidiasis_vias_aereas->ViewValue = $this->Candidiasis_vias_aereas->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Candidiasis_vias_aereas->ViewValue = $this->Candidiasis_vias_aereas->CurrentValue;
			}
		} else {
			$this->Candidiasis_vias_aereas->ViewValue = NULL;
		}
		$this->Candidiasis_vias_aereas->ViewCustomAttributes = "";

		// Tuberculosis_pulmonar
		if (strval($this->Tuberculosis_pulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tuberculosis_pulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tuberculosis_pulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tuberculosis_pulmonar->ViewValue = $this->Tuberculosis_pulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tuberculosis_pulmonar->ViewValue = $this->Tuberculosis_pulmonar->CurrentValue;
			}
		} else {
			$this->Tuberculosis_pulmonar->ViewValue = NULL;
		}
		$this->Tuberculosis_pulmonar->ViewCustomAttributes = "";

		// Cancer_cervical
		if (strval($this->Cancer_cervical->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Cancer_cervical->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Cancer_cervical, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Cancer_cervical->ViewValue = $this->Cancer_cervical->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Cancer_cervical->ViewValue = $this->Cancer_cervical->CurrentValue;
			}
		} else {
			$this->Cancer_cervical->ViewValue = NULL;
		}
		$this->Cancer_cervical->ViewCustomAttributes = "";

		// Tuberculosis_extrapulmonar
		if (strval($this->Tuberculosis_extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tuberculosis_extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tuberculosis_extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tuberculosis_extrapulmonar->ViewValue = $this->Tuberculosis_extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tuberculosis_extrapulmonar->ViewValue = $this->Tuberculosis_extrapulmonar->CurrentValue;
			}
		} else {
			$this->Tuberculosis_extrapulmonar->ViewValue = NULL;
		}
		$this->Tuberculosis_extrapulmonar->ViewCustomAttributes = "";

		// Coccidiomicosis
		if (strval($this->Coccidiomicosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Coccidiomicosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Coccidiomicosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Coccidiomicosis->ViewValue = $this->Coccidiomicosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Coccidiomicosis->ViewValue = $this->Coccidiomicosis->CurrentValue;
			}
		} else {
			$this->Coccidiomicosis->ViewValue = NULL;
		}
		$this->Coccidiomicosis->ViewCustomAttributes = "";

		// Citomegalovirosis
		if (strval($this->Citomegalovirosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Citomegalovirosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Citomegalovirosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Citomegalovirosis->ViewValue = $this->Citomegalovirosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Citomegalovirosis->ViewValue = $this->Citomegalovirosis->CurrentValue;
			}
		} else {
			$this->Citomegalovirosis->ViewValue = NULL;
		}
		$this->Citomegalovirosis->ViewCustomAttributes = "";

		// Retinitis_citomegalovirosis
		if (strval($this->Retinitis_citomegalovirosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Retinitis_citomegalovirosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Retinitis_citomegalovirosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Retinitis_citomegalovirosis->ViewValue = $this->Retinitis_citomegalovirosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Retinitis_citomegalovirosis->ViewValue = $this->Retinitis_citomegalovirosis->CurrentValue;
			}
		} else {
			$this->Retinitis_citomegalovirosis->ViewValue = NULL;
		}
		$this->Retinitis_citomegalovirosis->ViewCustomAttributes = "";

		// Sindrome_Emanciacion
		if (strval($this->Sindrome_Emanciacion->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Sindrome_Emanciacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sindrome_Emanciacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sindrome_Emanciacion->ViewValue = $this->Sindrome_Emanciacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sindrome_Emanciacion->ViewValue = $this->Sindrome_Emanciacion->CurrentValue;
			}
		} else {
			$this->Sindrome_Emanciacion->ViewValue = NULL;
		}
		$this->Sindrome_Emanciacion->ViewCustomAttributes = "";

		// Encefalopatia
		if (strval($this->Encefalopatia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Encefalopatia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Encefalopatia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Encefalopatia->ViewValue = $this->Encefalopatia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Encefalopatia->ViewValue = $this->Encefalopatia->CurrentValue;
			}
		} else {
			$this->Encefalopatia->ViewValue = NULL;
		}
		$this->Encefalopatia->ViewCustomAttributes = "";

		// Otras_micobacterias
		if (strval($this->Otras_micobacterias->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Otras_micobacterias->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Otras_micobacterias, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Otras_micobacterias->ViewValue = $this->Otras_micobacterias->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Otras_micobacterias->ViewValue = $this->Otras_micobacterias->CurrentValue;
			}
		} else {
			$this->Otras_micobacterias->ViewValue = NULL;
		}
		$this->Otras_micobacterias->ViewCustomAttributes = "";

		// Histoplasmosis_Extrapulmonar
		if (strval($this->Histoplasmosis_Extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Histoplasmosis_Extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Histoplasmosis_Extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Histoplasmosis_Extrapulmonar->ViewValue = $this->Histoplasmosis_Extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Histoplasmosis_Extrapulmonar->ViewValue = $this->Histoplasmosis_Extrapulmonar->CurrentValue;
			}
		} else {
			$this->Histoplasmosis_Extrapulmonar->ViewValue = NULL;
		}
		$this->Histoplasmosis_Extrapulmonar->ViewCustomAttributes = "";

		// isosporidiasis_cronica
		if (strval($this->isosporidiasis_cronica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->isosporidiasis_cronica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->isosporidiasis_cronica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->isosporidiasis_cronica->ViewValue = $this->isosporidiasis_cronica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->isosporidiasis_cronica->ViewValue = $this->isosporidiasis_cronica->CurrentValue;
			}
		} else {
			$this->isosporidiasis_cronica->ViewValue = NULL;
		}
		$this->isosporidiasis_cronica->ViewCustomAttributes = "";

		// herpes_zoster
		if (strval($this->herpes_zoster->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->herpes_zoster->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->herpes_zoster, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->herpes_zoster->ViewValue = $this->herpes_zoster->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->herpes_zoster->ViewValue = $this->herpes_zoster->CurrentValue;
			}
		} else {
			$this->herpes_zoster->ViewValue = NULL;
		}
		$this->herpes_zoster->ViewCustomAttributes = "";

		// Histoplasmosis_diseminada
		if (strval($this->Histoplasmosis_diseminada->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Histoplasmosis_diseminada->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Histoplasmosis_diseminada, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Histoplasmosis_diseminada->ViewValue = $this->Histoplasmosis_diseminada->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Histoplasmosis_diseminada->ViewValue = $this->Histoplasmosis_diseminada->CurrentValue;
			}
		} else {
			$this->Histoplasmosis_diseminada->ViewValue = NULL;
		}
		$this->Histoplasmosis_diseminada->ViewCustomAttributes = "";

		// Linfoma_Burkitt
		if (strval($this->Linfoma_Burkitt->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Linfoma_Burkitt->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Linfoma_Burkitt, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Linfoma_Burkitt->ViewValue = $this->Linfoma_Burkitt->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Linfoma_Burkitt->ViewValue = $this->Linfoma_Burkitt->CurrentValue;
			}
		} else {
			$this->Linfoma_Burkitt->ViewValue = NULL;
		}
		$this->Linfoma_Burkitt->ViewCustomAttributes = "";

		// Neumonia_Pneumocystis
		if (strval($this->Neumonia_Pneumocystis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Neumonia_Pneumocystis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Neumonia_Pneumocystis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Neumonia_Pneumocystis->ViewValue = $this->Neumonia_Pneumocystis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Neumonia_Pneumocystis->ViewValue = $this->Neumonia_Pneumocystis->CurrentValue;
			}
		} else {
			$this->Neumonia_Pneumocystis->ViewValue = NULL;
		}
		$this->Neumonia_Pneumocystis->ViewCustomAttributes = "";

		// Neumonia_Recurrente
		if (strval($this->Neumonia_Recurrente->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Neumonia_Recurrente->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Neumonia_Recurrente, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Neumonia_Recurrente->ViewValue = $this->Neumonia_Recurrente->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Neumonia_Recurrente->ViewValue = $this->Neumonia_Recurrente->CurrentValue;
			}
		} else {
			$this->Neumonia_Recurrente->ViewValue = NULL;
		}
		$this->Neumonia_Recurrente->ViewCustomAttributes = "";

		// Linfoma_Inmunoblastico
		if (strval($this->Linfoma_Inmunoblastico->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Linfoma_Inmunoblastico->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Linfoma_Inmunoblastico, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Linfoma_Inmunoblastico->ViewValue = $this->Linfoma_Inmunoblastico->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Linfoma_Inmunoblastico->ViewValue = $this->Linfoma_Inmunoblastico->CurrentValue;
			}
		} else {
			$this->Linfoma_Inmunoblastico->ViewValue = NULL;
		}
		$this->Linfoma_Inmunoblastico->ViewCustomAttributes = "";

		// Criptosporidiasis_cronica
		if (strval($this->Criptosporidiasis_cronica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Criptosporidiasis_cronica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Criptosporidiasis_cronica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Criptosporidiasis_cronica->ViewValue = $this->Criptosporidiasis_cronica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Criptosporidiasis_cronica->ViewValue = $this->Criptosporidiasis_cronica->CurrentValue;
			}
		} else {
			$this->Criptosporidiasis_cronica->ViewValue = NULL;
		}
		$this->Criptosporidiasis_cronica->ViewCustomAttributes = "";

		// Criptococosis_Extrapulmonar
		if (strval($this->Criptococosis_Extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Criptococosis_Extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Criptococosis_Extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Criptococosis_Extrapulmonar->ViewValue = $this->Criptococosis_Extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Criptococosis_Extrapulmonar->ViewValue = $this->Criptococosis_Extrapulmonar->CurrentValue;
			}
		} else {
			$this->Criptococosis_Extrapulmonar->ViewValue = NULL;
		}
		$this->Criptococosis_Extrapulmonar->ViewCustomAttributes = "";

		// Sarcoma_Kaposi
		if (strval($this->Sarcoma_Kaposi->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Sarcoma_Kaposi->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sarcoma_Kaposi, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sarcoma_Kaposi->ViewValue = $this->Sarcoma_Kaposi->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sarcoma_Kaposi->ViewValue = $this->Sarcoma_Kaposi->CurrentValue;
			}
		} else {
			$this->Sarcoma_Kaposi->ViewValue = NULL;
		}
		$this->Sarcoma_Kaposi->ViewCustomAttributes = "";

		// Leucoencefalopatia_Multifocal
		if (strval($this->Leucoencefalopatia_Multifocal->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Leucoencefalopatia_Multifocal->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Leucoencefalopatia_Multifocal, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Leucoencefalopatia_Multifocal->ViewValue = $this->Leucoencefalopatia_Multifocal->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Leucoencefalopatia_Multifocal->ViewValue = $this->Leucoencefalopatia_Multifocal->CurrentValue;
			}
		} else {
			$this->Leucoencefalopatia_Multifocal->ViewValue = NULL;
		}
		$this->Leucoencefalopatia_Multifocal->ViewCustomAttributes = "";

		// Septicemia_recurrente
		if (strval($this->Septicemia_recurrente->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Septicemia_recurrente->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Septicemia_recurrente, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Septicemia_recurrente->ViewValue = $this->Septicemia_recurrente->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Septicemia_recurrente->ViewValue = $this->Septicemia_recurrente->CurrentValue;
			}
		} else {
			$this->Septicemia_recurrente->ViewValue = NULL;
		}
		$this->Septicemia_recurrente->ViewCustomAttributes = "";

		// Toxoplasmosis_cerebral
		if (strval($this->Toxoplasmosis_cerebral->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Toxoplasmosis_cerebral->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Toxoplasmosis_cerebral, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Toxoplasmosis_cerebral->ViewValue = $this->Toxoplasmosis_cerebral->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Toxoplasmosis_cerebral->ViewValue = $this->Toxoplasmosis_cerebral->CurrentValue;
			}
		} else {
			$this->Toxoplasmosis_cerebral->ViewValue = NULL;
		}
		$this->Toxoplasmosis_cerebral->ViewCustomAttributes = "";

		// HepatitisB
		if (strval($this->HepatitisB->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->HepatitisB->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->HepatitisB, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->HepatitisB->ViewValue = $this->HepatitisB->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->HepatitisB->ViewValue = $this->HepatitisB->CurrentValue;
			}
		} else {
			$this->HepatitisB->ViewValue = NULL;
		}
		$this->HepatitisB->ViewCustomAttributes = "";

		// HepatitisC
		if (strval($this->HepatitisC->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->HepatitisC->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->HepatitisC, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->HepatitisC->ViewValue = $this->HepatitisC->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->HepatitisC->ViewValue = $this->HepatitisC->CurrentValue;
			}
		} else {
			$this->HepatitisC->ViewValue = NULL;
		}
		$this->HepatitisC->ViewCustomAttributes = "";

		// Meningitis
		if (strval($this->Meningitis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Meningitis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Meningitis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Meningitis->ViewValue = $this->Meningitis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Meningitis->ViewValue = $this->Meningitis->CurrentValue;
			}
		} else {
			$this->Meningitis->ViewValue = NULL;
		}
		$this->Meningitis->ViewCustomAttributes = "";

		// RecuentoCD4
		if (strval($this->RecuentoCD4->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->RecuentoCD4->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->RecuentoCD4, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->RecuentoCD4->ViewValue = $this->RecuentoCD4->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->RecuentoCD4->ViewValue = $this->RecuentoCD4->CurrentValue;
			}
		} else {
			$this->RecuentoCD4->ViewValue = NULL;
		}
		$this->RecuentoCD4->ViewCustomAttributes = "";

		// Registrado_Por
		$this->Registrado_Por->ViewValue = $this->Registrado_Por->CurrentValue;
		$this->Registrado_Por->ViewCustomAttributes = "";

		// Localidad_residencia
		if (strval($this->Localidad_residencia->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Localidad_residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `localidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Localidad_residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Localidad_residencia->ViewValue = $this->Localidad_residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Localidad_residencia->ViewValue = $this->Localidad_residencia->CurrentValue;
			}
		} else {
			$this->Localidad_residencia->ViewValue = NULL;
		}
		$this->Localidad_residencia->ViewCustomAttributes = "";

		// Barrio_residencia
		if (strval($this->Barrio_residencia->CurrentValue) <> "") {
			$sFilterWrk = "`cod_barrio_vereda`" . ew_SearchString("=", $this->Barrio_residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `cod_barrio_vereda`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrios_veredas`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Barrio_residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Barrio_residencia->ViewValue = $this->Barrio_residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Barrio_residencia->ViewValue = $this->Barrio_residencia->CurrentValue;
			}
		} else {
			$this->Barrio_residencia->ViewValue = NULL;
		}
		$this->Barrio_residencia->ViewCustomAttributes = "";

		// Fecha_ingreso_app
		$this->Fecha_ingreso_app->ViewValue = $this->Fecha_ingreso_app->CurrentValue;
		$this->Fecha_ingreso_app->ViewValue = ew_FormatDateTime($this->Fecha_ingreso_app->ViewValue, 5);
		$this->Fecha_ingreso_app->ViewCustomAttributes = "";

		// Actualizado_por
		$this->Actualizado_por->ViewValue = $this->Actualizado_por->CurrentValue;
		$this->Actualizado_por->ViewCustomAttributes = "";

		// Fecha_actualizacion_app
		$this->Fecha_actualizacion_app->ViewValue = $this->Fecha_actualizacion_app->CurrentValue;
		$this->Fecha_actualizacion_app->ViewValue = ew_FormatDateTime($this->Fecha_actualizacion_app->ViewValue, 5);
		$this->Fecha_actualizacion_app->ViewCustomAttributes = "";

			// Seguimiento
			$this->Seguimiento->LinkCustomAttributes = "";
			$this->Seguimiento->HrefValue = "";
			$this->Seguimiento->TooltipValue = "";

			// Condicion_Final
			$this->Condicion_Final->LinkCustomAttributes = "";
			$this->Condicion_Final->HrefValue = "";
			$this->Condicion_Final->TooltipValue = "";

			// Codigo_centro
			$this->Codigo_centro->LinkCustomAttributes = "";
			$this->Codigo_centro->HrefValue = "";
			$this->Codigo_centro->TooltipValue = "";

			// Codigo_UPGD
			$this->Codigo_UPGD->LinkCustomAttributes = "";
			$this->Codigo_UPGD->HrefValue = "";
			$this->Codigo_UPGD->TooltipValue = "";

			// Embarazo_Actual
			$this->Embarazo_Actual->LinkCustomAttributes = "";
			$this->Embarazo_Actual->HrefValue = "";
			$this->Embarazo_Actual->TooltipValue = "";

			// Fecha_Notificacion
			$this->Fecha_Notificacion->LinkCustomAttributes = "";
			$this->Fecha_Notificacion->HrefValue = "";
			$this->Fecha_Notificacion->TooltipValue = "";

			// Primer_Nombre
			$this->Primer_Nombre->LinkCustomAttributes = "";
			$this->Primer_Nombre->HrefValue = "";
			$this->Primer_Nombre->TooltipValue = "";

			// Segundo_Nombre
			$this->Segundo_Nombre->LinkCustomAttributes = "";
			$this->Segundo_Nombre->HrefValue = "";
			$this->Segundo_Nombre->TooltipValue = "";

			// Primer_Apellido
			$this->Primer_Apellido->LinkCustomAttributes = "";
			$this->Primer_Apellido->HrefValue = "";
			$this->Primer_Apellido->TooltipValue = "";

			// Numero_Identificacion
			$this->Numero_Identificacion->LinkCustomAttributes = "";
			$this->Numero_Identificacion->HrefValue = "";
			$this->Numero_Identificacion->TooltipValue = "";

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->LinkCustomAttributes = "";
			$this->Tipo_Regimen_Salud->HrefValue = "";
			$this->Tipo_Regimen_Salud->TooltipValue = "";

			// Cod_Administradora
			$this->Cod_Administradora->LinkCustomAttributes = "";
			$this->Cod_Administradora->HrefValue = "";
			$this->Cod_Administradora->TooltipValue = "";

			// Hospitalizado
			$this->Hospitalizado->LinkCustomAttributes = "";
			$this->Hospitalizado->HrefValue = "";
			$this->Hospitalizado->TooltipValue = "";

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->LinkCustomAttributes = "";
			$this->Mecanismo_Probable_Transmision->HrefValue = "";
			$this->Mecanismo_Probable_Transmision->TooltipValue = "";

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->LinkCustomAttributes = "";
			$this->Estado_Clinico_Notificacion->HrefValue = "";
			$this->Estado_Clinico_Notificacion->TooltipValue = "";

			// Registrado_Por
			$this->Registrado_Por->LinkCustomAttributes = "";
			$this->Registrado_Por->HrefValue = "";
			$this->Registrado_Por->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// Seguimiento
			$this->Seguimiento->EditCustomAttributes = "";
			if (trim(strval($this->Seguimiento->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Seguimiento->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `si_no`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Seguimiento, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Seguimiento->EditValue = $arwrk;

			// Condicion_Final
			$this->Condicion_Final->EditAttrs["class"] = "form-control";
			$this->Condicion_Final->EditCustomAttributes = "";
			if (trim(strval($this->Condicion_Final->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`No.Condicion_Final`" . ew_SearchString("=", $this->Condicion_Final->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `No.Condicion_Final`, `Condicion_Final` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `condicion_final`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Condicion_Final, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Condicion_Final->EditValue = $arwrk;

			// Codigo_centro
			$this->Codigo_centro->EditAttrs["class"] = "form-control";
			$this->Codigo_centro->EditCustomAttributes = "";
			if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$this->UserIDAllow($this->CurrentAction)) { // Non system admin
				$this->Codigo_centro->AdvancedSearch->SearchValue = CurrentUserID();
			if (strval($this->Codigo_centro->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_centro->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `Codigo_Upgd`, `Upgd` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Codigo_centro, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->Codigo_centro->EditValue = $this->Codigo_centro->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Codigo_centro->EditValue = $this->Codigo_centro->AdvancedSearch->SearchValue;
				}
			} else {
				$this->Codigo_centro->EditValue = NULL;
			}
			$this->Codigo_centro->ViewCustomAttributes = "";
			} else {
			if (trim(strval($this->Codigo_centro->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_centro->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `Codigo_Upgd`, `Upgd` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `entidad_upgd`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Codigo_centro, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Codigo_centro->EditValue = $arwrk;
			}

			// Codigo_UPGD
			$this->Codigo_UPGD->EditAttrs["class"] = "form-control";
			$this->Codigo_UPGD->EditCustomAttributes = "";
			$this->Codigo_UPGD->EditValue = ew_HtmlEncode($this->Codigo_UPGD->AdvancedSearch->SearchValue);
			if (strval($this->Codigo_UPGD->AdvancedSearch->SearchValue) <> "") {
				$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_UPGD->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Codigo_UPGD, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
					$arwrk[2] = ew_HtmlEncode($rswrk->fields('Disp2Fld'));
					$this->Codigo_UPGD->EditValue = $this->Codigo_UPGD->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Codigo_UPGD->EditValue = ew_HtmlEncode($this->Codigo_UPGD->AdvancedSearch->SearchValue);
				}
			} else {
				$this->Codigo_UPGD->EditValue = NULL;
			}
			$this->Codigo_UPGD->PlaceHolder = ew_RemoveHtml($this->Codigo_UPGD->FldCaption());

			// Embarazo_Actual
			$this->Embarazo_Actual->EditCustomAttributes = "";
			if (trim(strval($this->Embarazo_Actual->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Embarazo_Actual->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `si_no`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Embarazo_Actual, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Embarazo_Actual->EditValue = $arwrk;

			// Fecha_Notificacion
			$this->Fecha_Notificacion->EditAttrs["class"] = "form-control";
			$this->Fecha_Notificacion->EditCustomAttributes = "";
			$this->Fecha_Notificacion->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_Notificacion->AdvancedSearch->SearchValue, 5), 5));
			$this->Fecha_Notificacion->PlaceHolder = ew_RemoveHtml($this->Fecha_Notificacion->FldCaption());
			$this->Fecha_Notificacion->EditAttrs["class"] = "form-control";
			$this->Fecha_Notificacion->EditCustomAttributes = "";
			$this->Fecha_Notificacion->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_Notificacion->AdvancedSearch->SearchValue2, 5), 5));
			$this->Fecha_Notificacion->PlaceHolder = ew_RemoveHtml($this->Fecha_Notificacion->FldCaption());

			// Primer_Nombre
			$this->Primer_Nombre->EditAttrs["class"] = "form-control";
			$this->Primer_Nombre->EditCustomAttributes = "";
			$this->Primer_Nombre->EditValue = ew_HtmlEncode($this->Primer_Nombre->AdvancedSearch->SearchValue);
			$this->Primer_Nombre->PlaceHolder = ew_RemoveHtml($this->Primer_Nombre->FldCaption());

			// Segundo_Nombre
			$this->Segundo_Nombre->EditAttrs["class"] = "form-control";
			$this->Segundo_Nombre->EditCustomAttributes = "";
			$this->Segundo_Nombre->EditValue = ew_HtmlEncode($this->Segundo_Nombre->AdvancedSearch->SearchValue);
			$this->Segundo_Nombre->PlaceHolder = ew_RemoveHtml($this->Segundo_Nombre->FldCaption());

			// Primer_Apellido
			$this->Primer_Apellido->EditAttrs["class"] = "form-control";
			$this->Primer_Apellido->EditCustomAttributes = "";
			$this->Primer_Apellido->EditValue = ew_HtmlEncode($this->Primer_Apellido->AdvancedSearch->SearchValue);
			$this->Primer_Apellido->PlaceHolder = ew_RemoveHtml($this->Primer_Apellido->FldCaption());

			// Numero_Identificacion
			$this->Numero_Identificacion->EditAttrs["class"] = "form-control";
			$this->Numero_Identificacion->EditCustomAttributes = "";
			$this->Numero_Identificacion->EditValue = ew_HtmlEncode($this->Numero_Identificacion->AdvancedSearch->SearchValue);
			$this->Numero_Identificacion->PlaceHolder = ew_RemoveHtml($this->Numero_Identificacion->FldCaption());

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->EditAttrs["class"] = "form-control";
			$this->Tipo_Regimen_Salud->EditCustomAttributes = "";

			// Cod_Administradora
			$this->Cod_Administradora->EditAttrs["class"] = "form-control";
			$this->Cod_Administradora->EditCustomAttributes = "";
			if (trim(strval($this->Cod_Administradora->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->Cod_Administradora->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `administradora_salud`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Cod_Administradora, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Cod_Administradora->EditValue = $arwrk;

			// Hospitalizado
			$this->Hospitalizado->EditCustomAttributes = "";

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->EditAttrs["class"] = "form-control";
			$this->Mecanismo_Probable_Transmision->EditCustomAttributes = "";

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->EditAttrs["class"] = "form-control";
			$this->Estado_Clinico_Notificacion->EditCustomAttributes = "";
			if (trim(strval($this->Estado_Clinico_Notificacion->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Estado_Clinico_Notificacion->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Consecutivo`, `Estado_Clinico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `estado_clinico_paciente`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Estado_Clinico_Notificacion, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Estado_Clinico_Notificacion->EditValue = $arwrk;

			// Registrado_Por
			$this->Registrado_Por->EditAttrs["class"] = "form-control";
			$this->Registrado_Por->EditCustomAttributes = "";
			$this->Registrado_Por->EditValue = ew_HtmlEncode($this->Registrado_Por->AdvancedSearch->SearchValue);
			$this->Registrado_Por->PlaceHolder = ew_RemoveHtml($this->Registrado_Por->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckInteger($this->Codigo_UPGD->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->Codigo_UPGD->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Notificacion->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->Fecha_Notificacion->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Notificacion->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->Fecha_Notificacion->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->Consecutivo->AdvancedSearch->Load();
		$this->Seguimiento->AdvancedSearch->Load();
		$this->Condicion_Final->AdvancedSearch->Load();
		$this->Codigo_centro->AdvancedSearch->Load();
		$this->Codigo_UPGD->AdvancedSearch->Load();
		$this->Cod_Evento->AdvancedSearch->Load();
		$this->Embarazo_Actual->AdvancedSearch->Load();
		$this->Fecha_Notificacion->AdvancedSearch->Load();
		$this->Semana->AdvancedSearch->Load();
		$this->Periodo_Epidemiologico->AdvancedSearch->Load();
		$this->Periodo_Sivigila->AdvancedSearch->Load();
		$this->Primer_Nombre->AdvancedSearch->Load();
		$this->Segundo_Nombre->AdvancedSearch->Load();
		$this->Primer_Apellido->AdvancedSearch->Load();
		$this->Segundo_Apellido->AdvancedSearch->Load();
		$this->Tipo_Id->AdvancedSearch->Load();
		$this->Numero_Identificacion->AdvancedSearch->Load();
		$this->Edad->AdvancedSearch->Load();
		$this->Unidad_Edad->AdvancedSearch->Load();
		$this->Sexo->AdvancedSearch->Load();
		$this->Pais_Ocurrencia->AdvancedSearch->Load();
		$this->Depto_Ocurrencia->AdvancedSearch->Load();
		$this->Municipio_Ocurrencia->AdvancedSearch->Load();
		$this->Area_Ocurrencia->AdvancedSearch->Load();
		$this->Localidad->AdvancedSearch->Load();
		$this->Barrio->AdvancedSearch->Load();
		$this->Direccion_Residencia->AdvancedSearch->Load();
		$this->Ocupacion->AdvancedSearch->Load();
		$this->Tipo_Regimen_Salud->AdvancedSearch->Load();
		$this->Cod_Administradora->AdvancedSearch->Load();
		$this->gp_discapa->AdvancedSearch->Load();
		$this->gp_desplaz->AdvancedSearch->Load();
		$this->gp_migrant->AdvancedSearch->Load();
		$this->gp_carcela->AdvancedSearch->Load();
		$this->gp_gestan->AdvancedSearch->Load();
		$this->gp_indigen->AdvancedSearch->Load();
		$this->gp_pobicbf->AdvancedSearch->Load();
		$this->gp_mad_com->AdvancedSearch->Load();
		$this->gp_desmovi->AdvancedSearch->Load();
		$this->gp_psiquia->AdvancedSearch->Load();
		$this->gp_vic_vio->AdvancedSearch->Load();
		$this->gp_otros->AdvancedSearch->Load();
		$this->Depto_Residencia->AdvancedSearch->Load();
		$this->Municipio_Residencia->AdvancedSearch->Load();
		$this->Fecha_Consulta->AdvancedSearch->Load();
		$this->Fecha_Inicio_Sintomas->AdvancedSearch->Load();
		$this->Hospitalizado->AdvancedSearch->Load();
		$this->Fecha_Defuncion->AdvancedSearch->Load();
		$this->Numero_Certificado_Defuncion->AdvancedSearch->Load();
		$this->Causa_Basica_Muerte_CIEX->AdvancedSearch->Load();
		$this->Entidad_fallecimiento->AdvancedSearch->Load();
		$this->Telefono->AdvancedSearch->Load();
		$this->Fecha_Nacimiento->AdvancedSearch->Load();
		$this->Nombre_Profesional_Diligencia->AdvancedSearch->Load();
		$this->Telefono_Profesional_Diligencia->AdvancedSearch->Load();
		$this->Mecanismo_Probable_Transmision->AdvancedSearch->Load();
		$this->Nombre_Madre->AdvancedSearch->Load();
		$this->Tipo_Id_Madre->AdvancedSearch->Load();
		$this->Numero_Identificacion_Madre->AdvancedSearch->Load();
		$this->Indentidad_Genero->AdvancedSearch->Load();
		$this->Donador_Sangre_Ultimos_12_Meses->AdvancedSearch->Load();
		$this->Fecha_Donacion->AdvancedSearch->Load();
		$this->Nombre_Institucion_Donacion->AdvancedSearch->Load();
		$this->Poblacion_clave->AdvancedSearch->Load();
		$this->Recibio_Asesoria_Pre_Prueba->AdvancedSearch->Load();
		$this->Recibio_Asesoria_Post_Prueba->AdvancedSearch->Load();
		$this->Tipo_Prueba->AdvancedSearch->Load();
		$this->Fecha_Resultado_Confirmatorio->AdvancedSearch->Load();
		$this->Valor_Carga_Viral->AdvancedSearch->Load();
		$this->Estado_Clinico_Notificacion->AdvancedSearch->Load();
		$this->Hijos_Mujeres_Menores_5->AdvancedSearch->Load();
		$this->Hijos_Hombres_Menores_5->AdvancedSearch->Load();
		$this->Numero_Semanas_Embarazo->AdvancedSearch->Load();
		$this->Antecedentes_Embarazo->AdvancedSearch->Load();
		$this->Candidiasis_esofagica->AdvancedSearch->Load();
		$this->Candidiasis_vias_aereas->AdvancedSearch->Load();
		$this->Tuberculosis_pulmonar->AdvancedSearch->Load();
		$this->Cancer_cervical->AdvancedSearch->Load();
		$this->Tuberculosis_extrapulmonar->AdvancedSearch->Load();
		$this->Coccidiomicosis->AdvancedSearch->Load();
		$this->Citomegalovirosis->AdvancedSearch->Load();
		$this->Retinitis_citomegalovirosis->AdvancedSearch->Load();
		$this->Sindrome_Emanciacion->AdvancedSearch->Load();
		$this->Encefalopatia->AdvancedSearch->Load();
		$this->Otras_micobacterias->AdvancedSearch->Load();
		$this->Histoplasmosis_Extrapulmonar->AdvancedSearch->Load();
		$this->isosporidiasis_cronica->AdvancedSearch->Load();
		$this->herpes_zoster->AdvancedSearch->Load();
		$this->Histoplasmosis_diseminada->AdvancedSearch->Load();
		$this->Linfoma_Burkitt->AdvancedSearch->Load();
		$this->Neumonia_Pneumocystis->AdvancedSearch->Load();
		$this->Neumonia_Recurrente->AdvancedSearch->Load();
		$this->Linfoma_Inmunoblastico->AdvancedSearch->Load();
		$this->Criptosporidiasis_cronica->AdvancedSearch->Load();
		$this->Criptococosis_Extrapulmonar->AdvancedSearch->Load();
		$this->Sarcoma_Kaposi->AdvancedSearch->Load();
		$this->Leucoencefalopatia_Multifocal->AdvancedSearch->Load();
		$this->Septicemia_recurrente->AdvancedSearch->Load();
		$this->Toxoplasmosis_cerebral->AdvancedSearch->Load();
		$this->HepatitisB->AdvancedSearch->Load();
		$this->HepatitisC->AdvancedSearch->Load();
		$this->Meningitis->AdvancedSearch->Load();
		$this->RecuentoCD4->AdvancedSearch->Load();
		$this->Registrado_Por->AdvancedSearch->Load();
		$this->Localidad_residencia->AdvancedSearch->Load();
		$this->Barrio_residencia->AdvancedSearch->Load();
		$this->Fecha_ingreso_app->AdvancedSearch->Load();
		$this->Actualizado_por->AdvancedSearch->Load();
		$this->Fecha_actualizacion_app->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_registro\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_registro',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fregistrolist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetUpStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Show link optionally based on User ID
	function ShowOptionLink($id = "") {
		global $Security;
		if ($Security->IsLoggedIn() && !$Security->IsAdmin() && !$this->UserIDAllow($id))
			return $Security->IsValidUserID($this->Codigo_centro->CurrentValue);
		return TRUE;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($registro_list)) $registro_list = new cregistro_list();

// Page init
$registro_list->Page_Init();

// Page main
$registro_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$registro_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($registro->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fregistrolist = new ew_Form("fregistrolist", "list");
fregistrolist.FormKeyCountName = '<?php echo $registro_list->FormKeyCountName ?>';

// Form_CustomValidate event
fregistrolist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fregistrolist.ValidateRequired = true;
<?php } else { ?>
fregistrolist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fregistrolist.Lists["x_Seguimiento"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Condicion_Final"] = {"LinkField":"x_No_Condicion_Final","Ajax":true,"AutoFill":false,"DisplayFields":["x_Condicion_Final","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Codigo_centro"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Upgd","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Codigo_UPGD"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Upgd","x_Upgd","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Embarazo_Actual"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Tipo_Regimen_Salud"] = {"LinkField":"x_Codigo_Regimen","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Regimen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Cod_Administradora"] = {"LinkField":"x_Codigo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo","x_Administradora_Salud","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Hospitalizado[]"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Mecanismo_Probable_Transmision"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Mecanismo_Probable","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolist.Lists["x_Estado_Clinico_Notificacion"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Estado_Clinico","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
var CurrentSearchForm = fregistrolistsrch = new ew_Form("fregistrolistsrch");

// Validate function for search
fregistrolistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_Codigo_UPGD");
	if (elm && !ew_CheckInteger(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($registro->Codigo_UPGD->FldErrMsg()) ?>");
	elm = this.GetElements("x" + infix + "_Fecha_Notificacion");
	if (elm && !ew_CheckDate(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($registro->Fecha_Notificacion->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fregistrolistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fregistrolistsrch.ValidateRequired = true; // Use JavaScript validation
<?php } else { ?>
fregistrolistsrch.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Dynamic selection lists
fregistrolistsrch.Lists["x_Seguimiento"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolistsrch.Lists["x_Condicion_Final"] = {"LinkField":"x_No_Condicion_Final","Ajax":true,"AutoFill":false,"DisplayFields":["x_Condicion_Final","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolistsrch.Lists["x_Codigo_centro"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Upgd","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolistsrch.Lists["x_Codigo_UPGD"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Upgd","x_Upgd","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolistsrch.Lists["x_Embarazo_Actual"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolistsrch.Lists["x_Cod_Administradora"] = {"LinkField":"x_Codigo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo","x_Administradora_Salud","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistrolistsrch.Lists["x_Estado_Clinico_Notificacion"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Estado_Clinico","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Init search panel as collapsed
if (fregistrolistsrch) fregistrolistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($registro->Export == "") { ?>
<div class="ewToolbar">
<?php if ($registro->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($registro_list->TotalRecs > 0 && $registro_list->ExportOptions->Visible()) { ?>
<?php $registro_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($registro_list->SearchOptions->Visible()) { ?>
<?php $registro_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($registro_list->FilterOptions->Visible()) { ?>
<?php $registro_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php if ($registro->Export == "") { ?>
<?php echo $Language->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $registro_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($registro_list->TotalRecs <= 0)
			$registro_list->TotalRecs = $registro->SelectRecordCount();
	} else {
		if (!$registro_list->Recordset && ($registro_list->Recordset = $registro_list->LoadRecordset()))
			$registro_list->TotalRecs = $registro_list->Recordset->RecordCount();
	}
	$registro_list->StartRec = 1;
	if ($registro_list->DisplayRecs <= 0 || ($registro->Export <> "" && $registro->ExportAll)) // Display all records
		$registro_list->DisplayRecs = $registro_list->TotalRecs;
	if (!($registro->Export <> "" && $registro->ExportAll))
		$registro_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$registro_list->Recordset = $registro_list->LoadRecordset($registro_list->StartRec-1, $registro_list->DisplayRecs);

	// Set no record found message
	if ($registro->CurrentAction == "" && $registro_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$registro_list->setWarningMessage(ew_DeniedMsg());
		if ($registro_list->SearchWhere == "0=101")
			$registro_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$registro_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$registro_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($registro->Export == "" && $registro->CurrentAction == "") { ?>
<form name="fregistrolistsrch" id="fregistrolistsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($registro_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fregistrolistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="registro">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$registro_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$registro->RowType = EW_ROWTYPE_SEARCH;

// Render row
$registro->ResetAttrs();
$registro_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($registro->Seguimiento->Visible) { // Seguimiento ?>
	<div id="xsc_Seguimiento" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $registro->Seguimiento->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Seguimiento" id="z_Seguimiento" value="="></span>
		<span class="ewSearchField">
<div id="tp_x_Seguimiento" class="ewTemplate"><input type="radio" data-table="registro" data-field="x_Seguimiento" data-value-separator="<?php echo ew_HtmlEncode(is_array($registro->Seguimiento->DisplayValueSeparator) ? json_encode($registro->Seguimiento->DisplayValueSeparator) : $registro->Seguimiento->DisplayValueSeparator) ?>" name="x_Seguimiento" id="x_Seguimiento" value="{value}"<?php echo $registro->Seguimiento->EditAttributes() ?>></div>
<div id="dsl_x_Seguimiento" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $registro->Seguimiento->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($registro->Seguimiento->AdvancedSearch->SearchValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="registro" data-field="x_Seguimiento" name="x_Seguimiento" id="x_Seguimiento_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $registro->Seguimiento->EditAttributes() ?>><?php echo $registro->Seguimiento->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($registro->Seguimiento->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="registro" data-field="x_Seguimiento" name="x_Seguimiento" id="x_Seguimiento_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($registro->Seguimiento->CurrentValue) ?>" checked<?php echo $registro->Seguimiento->EditAttributes() ?>><?php echo $registro->Seguimiento->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
$sWhereWrk = "";
$registro->Seguimiento->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$registro->Seguimiento->LookupFilters += array("f0" => "`Consecutivo` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$registro->Lookup_Selecting($registro->Seguimiento, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $registro->Seguimiento->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Seguimiento" id="s_x_Seguimiento" value="<?php echo $registro->Seguimiento->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($registro->Condicion_Final->Visible) { // Condicion_Final ?>
	<div id="xsc_Condicion_Final" class="ewCell form-group">
		<label for="x_Condicion_Final" class="ewSearchCaption ewLabel"><?php echo $registro->Condicion_Final->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Condicion_Final" id="z_Condicion_Final" value="="></span>
		<span class="ewSearchField">
<select data-table="registro" data-field="x_Condicion_Final" data-value-separator="<?php echo ew_HtmlEncode(is_array($registro->Condicion_Final->DisplayValueSeparator) ? json_encode($registro->Condicion_Final->DisplayValueSeparator) : $registro->Condicion_Final->DisplayValueSeparator) ?>" id="x_Condicion_Final" name="x_Condicion_Final"<?php echo $registro->Condicion_Final->EditAttributes() ?>>
<?php
if (is_array($registro->Condicion_Final->EditValue)) {
	$arwrk = $registro->Condicion_Final->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = ew_SameStr($registro->Condicion_Final->AdvancedSearch->SearchValue, $arwrk[$rowcntwrk][0]) ? " selected" : "";
		if ($selwrk <> "") $emptywrk = FALSE;		
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $registro->Condicion_Final->DisplayValue($arwrk[$rowcntwrk]) ?>
</option>
<?php
	}
	if ($emptywrk && strval($registro->Condicion_Final->CurrentValue) <> "") {
?>
<option value="<?php echo ew_HtmlEncode($registro->Condicion_Final->CurrentValue) ?>" selected><?php echo $registro->Condicion_Final->CurrentValue ?></option>
<?php
    }
}
?>
</select>
<?php
$sSqlWrk = "SELECT `No.Condicion_Final`, `Condicion_Final` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `condicion_final`";
$sWhereWrk = "";
$registro->Condicion_Final->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$registro->Condicion_Final->LookupFilters += array("f0" => "`No.Condicion_Final` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$registro->Lookup_Selecting($registro->Condicion_Final, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $registro->Condicion_Final->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Condicion_Final" id="s_x_Condicion_Final" value="<?php echo $registro->Condicion_Final->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($registro->Codigo_centro->Visible) { // Codigo_centro ?>
	<div id="xsc_Codigo_centro" class="ewCell form-group">
		<label for="x_Codigo_centro" class="ewSearchCaption ewLabel"><?php echo $registro->Codigo_centro->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Codigo_centro" id="z_Codigo_centro" value="="></span>
		<span class="ewSearchField">
<?php if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$registro->UserIDAllow($registro->CurrentAction)) { // Non system admin ?>
<span<?php echo $registro->Codigo_centro->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $registro->Codigo_centro->EditValue ?></p></span>
<input type="hidden" data-table="registro" data-field="x_Codigo_centro" name="x_Codigo_centro" id="x_Codigo_centro" value="<?php echo ew_HtmlEncode($registro->Codigo_centro->AdvancedSearch->SearchValue) ?>">
<?php } else { ?>
<select data-table="registro" data-field="x_Codigo_centro" data-value-separator="<?php echo ew_HtmlEncode(is_array($registro->Codigo_centro->DisplayValueSeparator) ? json_encode($registro->Codigo_centro->DisplayValueSeparator) : $registro->Codigo_centro->DisplayValueSeparator) ?>" id="x_Codigo_centro" name="x_Codigo_centro"<?php echo $registro->Codigo_centro->EditAttributes() ?>>
<?php
if (is_array($registro->Codigo_centro->EditValue)) {
	$arwrk = $registro->Codigo_centro->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = ew_SameStr($registro->Codigo_centro->AdvancedSearch->SearchValue, $arwrk[$rowcntwrk][0]) ? " selected" : "";
		if ($selwrk <> "") $emptywrk = FALSE;		
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $registro->Codigo_centro->DisplayValue($arwrk[$rowcntwrk]) ?>
</option>
<?php
	}
	if ($emptywrk && strval($registro->Codigo_centro->CurrentValue) <> "") {
?>
<option value="<?php echo ew_HtmlEncode($registro->Codigo_centro->CurrentValue) ?>" selected><?php echo $registro->Codigo_centro->CurrentValue ?></option>
<?php
    }
}
?>
</select>
<?php
$sSqlWrk = "SELECT `Codigo_Upgd`, `Upgd` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
$sWhereWrk = "";
$registro->Codigo_centro->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$registro->Codigo_centro->LookupFilters += array("f0" => "`Codigo_Upgd` = {filter_value}", "t0" => "200", "fn0" => "");
$sSqlWrk = "";
$registro->Lookup_Selecting($registro->Codigo_centro, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $registro->Codigo_centro->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Codigo_centro" id="s_x_Codigo_centro" value="<?php echo $registro->Codigo_centro->LookupFilterQuery() ?>">
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($registro->Codigo_UPGD->Visible) { // Codigo_UPGD ?>
	<div id="xsc_Codigo_UPGD" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $registro->Codigo_UPGD->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Codigo_UPGD" id="z_Codigo_UPGD" value="="></span>
		<span class="ewSearchField">
<?php
$wrkonchange = trim(" " . @$registro->Codigo_UPGD->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$registro->Codigo_UPGD->EditAttrs["onchange"] = "";
?>
<span id="as_x_Codigo_UPGD" style="white-space: nowrap; z-index: 8950">
	<input type="text" name="sv_x_Codigo_UPGD" id="sv_x_Codigo_UPGD" value="<?php echo $registro->Codigo_UPGD->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($registro->Codigo_UPGD->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($registro->Codigo_UPGD->getPlaceHolder()) ?>"<?php echo $registro->Codigo_UPGD->EditAttributes() ?>>
</span>
<input type="hidden" data-table="registro" data-field="x_Codigo_UPGD" data-value-separator="<?php echo ew_HtmlEncode(is_array($registro->Codigo_UPGD->DisplayValueSeparator) ? json_encode($registro->Codigo_UPGD->DisplayValueSeparator) : $registro->Codigo_UPGD->DisplayValueSeparator) ?>" name="x_Codigo_UPGD" id="x_Codigo_UPGD" value="<?php echo ew_HtmlEncode($registro->Codigo_UPGD->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<?php
$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld` FROM `entidad_upgd`";
$sWhereWrk = "`Codigo_Upgd` LIKE '%{query_value}%' OR `Upgd` LIKE '%{query_value}%' OR CONCAT(`Codigo_Upgd`,'" . ew_ValueSeparator(1, $Page->Codigo_UPGD) . "',`Upgd`) LIKE '{query_value}%'";
$registro->Lookup_Selecting($registro->Codigo_UPGD, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " LIMIT " . EW_AUTO_SUGGEST_MAX_ENTRIES;
?>
<input type="hidden" name="q_x_Codigo_UPGD" id="q_x_Codigo_UPGD" value="s=<?php echo ew_Encrypt($sSqlWrk) ?>&d=">
<script type="text/javascript">
fregistrolistsrch.CreateAutoSuggest({"id":"x_Codigo_UPGD","forceSelect":true});
</script>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($registro->Embarazo_Actual->Visible) { // Embarazo_Actual ?>
	<div id="xsc_Embarazo_Actual" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $registro->Embarazo_Actual->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Embarazo_Actual" id="z_Embarazo_Actual" value="="></span>
		<span class="ewSearchField">
<div id="tp_x_Embarazo_Actual" class="ewTemplate"><input type="radio" data-table="registro" data-field="x_Embarazo_Actual" data-value-separator="<?php echo ew_HtmlEncode(is_array($registro->Embarazo_Actual->DisplayValueSeparator) ? json_encode($registro->Embarazo_Actual->DisplayValueSeparator) : $registro->Embarazo_Actual->DisplayValueSeparator) ?>" name="x_Embarazo_Actual" id="x_Embarazo_Actual" value="{value}"<?php echo $registro->Embarazo_Actual->EditAttributes() ?>></div>
<div id="dsl_x_Embarazo_Actual" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $registro->Embarazo_Actual->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($registro->Embarazo_Actual->AdvancedSearch->SearchValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="registro" data-field="x_Embarazo_Actual" name="x_Embarazo_Actual" id="x_Embarazo_Actual_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $registro->Embarazo_Actual->EditAttributes() ?>><?php echo $registro->Embarazo_Actual->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($registro->Embarazo_Actual->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="registro" data-field="x_Embarazo_Actual" name="x_Embarazo_Actual" id="x_Embarazo_Actual_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($registro->Embarazo_Actual->CurrentValue) ?>" checked<?php echo $registro->Embarazo_Actual->EditAttributes() ?>><?php echo $registro->Embarazo_Actual->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
$sWhereWrk = "";
$registro->Embarazo_Actual->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$registro->Embarazo_Actual->LookupFilters += array("f0" => "`Consecutivo` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$registro->Lookup_Selecting($registro->Embarazo_Actual, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $registro->Embarazo_Actual->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Embarazo_Actual" id="s_x_Embarazo_Actual" value="<?php echo $registro->Embarazo_Actual->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($registro->Fecha_Notificacion->Visible) { // Fecha_Notificacion ?>
	<div id="xsc_Fecha_Notificacion" class="ewCell form-group">
		<label for="x_Fecha_Notificacion" class="ewSearchCaption ewLabel"><?php echo $registro->Fecha_Notificacion->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("BETWEEN") ?><input type="hidden" name="z_Fecha_Notificacion" id="z_Fecha_Notificacion" value="BETWEEN"></span>
		<span class="ewSearchField">
<input type="text" data-table="registro" data-field="x_Fecha_Notificacion" data-format="5" name="x_Fecha_Notificacion" id="x_Fecha_Notificacion" placeholder="<?php echo ew_HtmlEncode($registro->Fecha_Notificacion->getPlaceHolder()) ?>" value="<?php echo $registro->Fecha_Notificacion->EditValue ?>"<?php echo $registro->Fecha_Notificacion->EditAttributes() ?>>
<?php if (!$registro->Fecha_Notificacion->ReadOnly && !$registro->Fecha_Notificacion->Disabled && !isset($registro->Fecha_Notificacion->EditAttrs["readonly"]) && !isset($registro->Fecha_Notificacion->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateCalendar("fregistrolistsrch", "x_Fecha_Notificacion", "%Y/%m/%d");
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_Fecha_Notificacion">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_Fecha_Notificacion">
<input type="text" data-table="registro" data-field="x_Fecha_Notificacion" data-format="5" name="y_Fecha_Notificacion" id="y_Fecha_Notificacion" placeholder="<?php echo ew_HtmlEncode($registro->Fecha_Notificacion->getPlaceHolder()) ?>" value="<?php echo $registro->Fecha_Notificacion->EditValue2 ?>"<?php echo $registro->Fecha_Notificacion->EditAttributes() ?>>
<?php if (!$registro->Fecha_Notificacion->ReadOnly && !$registro->Fecha_Notificacion->Disabled && !isset($registro->Fecha_Notificacion->EditAttrs["readonly"]) && !isset($registro->Fecha_Notificacion->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateCalendar("fregistrolistsrch", "y_Fecha_Notificacion", "%Y/%m/%d");
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
<?php if ($registro->Primer_Nombre->Visible) { // Primer_Nombre ?>
	<div id="xsc_Primer_Nombre" class="ewCell form-group">
		<label for="x_Primer_Nombre" class="ewSearchCaption ewLabel"><?php echo $registro->Primer_Nombre->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Primer_Nombre" id="z_Primer_Nombre" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="registro" data-field="x_Primer_Nombre" name="x_Primer_Nombre" id="x_Primer_Nombre" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registro->Primer_Nombre->getPlaceHolder()) ?>" value="<?php echo $registro->Primer_Nombre->EditValue ?>"<?php echo $registro->Primer_Nombre->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_8" class="ewRow">
<?php if ($registro->Segundo_Nombre->Visible) { // Segundo_Nombre ?>
	<div id="xsc_Segundo_Nombre" class="ewCell form-group">
		<label for="x_Segundo_Nombre" class="ewSearchCaption ewLabel"><?php echo $registro->Segundo_Nombre->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Segundo_Nombre" id="z_Segundo_Nombre" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="registro" data-field="x_Segundo_Nombre" name="x_Segundo_Nombre" id="x_Segundo_Nombre" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registro->Segundo_Nombre->getPlaceHolder()) ?>" value="<?php echo $registro->Segundo_Nombre->EditValue ?>"<?php echo $registro->Segundo_Nombre->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_9" class="ewRow">
<?php if ($registro->Primer_Apellido->Visible) { // Primer_Apellido ?>
	<div id="xsc_Primer_Apellido" class="ewCell form-group">
		<label for="x_Primer_Apellido" class="ewSearchCaption ewLabel"><?php echo $registro->Primer_Apellido->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Primer_Apellido" id="z_Primer_Apellido" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="registro" data-field="x_Primer_Apellido" name="x_Primer_Apellido" id="x_Primer_Apellido" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registro->Primer_Apellido->getPlaceHolder()) ?>" value="<?php echo $registro->Primer_Apellido->EditValue ?>"<?php echo $registro->Primer_Apellido->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_10" class="ewRow">
<?php if ($registro->Numero_Identificacion->Visible) { // Numero_Identificacion ?>
	<div id="xsc_Numero_Identificacion" class="ewCell form-group">
		<label for="x_Numero_Identificacion" class="ewSearchCaption ewLabel"><?php echo $registro->Numero_Identificacion->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Numero_Identificacion" id="z_Numero_Identificacion" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="registro" data-field="x_Numero_Identificacion" name="x_Numero_Identificacion" id="x_Numero_Identificacion" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($registro->Numero_Identificacion->getPlaceHolder()) ?>" value="<?php echo $registro->Numero_Identificacion->EditValue ?>"<?php echo $registro->Numero_Identificacion->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_11" class="ewRow">
<?php if ($registro->Cod_Administradora->Visible) { // Cod_Administradora ?>
	<div id="xsc_Cod_Administradora" class="ewCell form-group">
		<label for="x_Cod_Administradora" class="ewSearchCaption ewLabel"><?php echo $registro->Cod_Administradora->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Cod_Administradora" id="z_Cod_Administradora" value="LIKE"></span>
		<span class="ewSearchField">
<select data-table="registro" data-field="x_Cod_Administradora" data-value-separator="<?php echo ew_HtmlEncode(is_array($registro->Cod_Administradora->DisplayValueSeparator) ? json_encode($registro->Cod_Administradora->DisplayValueSeparator) : $registro->Cod_Administradora->DisplayValueSeparator) ?>" id="x_Cod_Administradora" name="x_Cod_Administradora"<?php echo $registro->Cod_Administradora->EditAttributes() ?>>
<?php
if (is_array($registro->Cod_Administradora->EditValue)) {
	$arwrk = $registro->Cod_Administradora->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = ew_SameStr($registro->Cod_Administradora->AdvancedSearch->SearchValue, $arwrk[$rowcntwrk][0]) ? " selected" : "";
		if ($selwrk <> "") $emptywrk = FALSE;		
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $registro->Cod_Administradora->DisplayValue($arwrk[$rowcntwrk]) ?>
</option>
<?php
	}
	if ($emptywrk && strval($registro->Cod_Administradora->CurrentValue) <> "") {
?>
<option value="<?php echo ew_HtmlEncode($registro->Cod_Administradora->CurrentValue) ?>" selected><?php echo $registro->Cod_Administradora->CurrentValue ?></option>
<?php
    }
}
?>
</select>
<?php
$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
$sWhereWrk = "";
$registro->Cod_Administradora->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$registro->Cod_Administradora->LookupFilters += array("f0" => "`Codigo` = {filter_value}", "t0" => "200", "fn0" => "");
$sSqlWrk = "";
$registro->Lookup_Selecting($registro->Cod_Administradora, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $registro->Cod_Administradora->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Cod_Administradora" id="s_x_Cod_Administradora" value="<?php echo $registro->Cod_Administradora->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_12" class="ewRow">
<?php if ($registro->Estado_Clinico_Notificacion->Visible) { // Estado_Clinico_Notificacion ?>
	<div id="xsc_Estado_Clinico_Notificacion" class="ewCell form-group">
		<label for="x_Estado_Clinico_Notificacion" class="ewSearchCaption ewLabel"><?php echo $registro->Estado_Clinico_Notificacion->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Estado_Clinico_Notificacion" id="z_Estado_Clinico_Notificacion" value="="></span>
		<span class="ewSearchField">
<select data-table="registro" data-field="x_Estado_Clinico_Notificacion" data-value-separator="<?php echo ew_HtmlEncode(is_array($registro->Estado_Clinico_Notificacion->DisplayValueSeparator) ? json_encode($registro->Estado_Clinico_Notificacion->DisplayValueSeparator) : $registro->Estado_Clinico_Notificacion->DisplayValueSeparator) ?>" id="x_Estado_Clinico_Notificacion" name="x_Estado_Clinico_Notificacion"<?php echo $registro->Estado_Clinico_Notificacion->EditAttributes() ?>>
<?php
if (is_array($registro->Estado_Clinico_Notificacion->EditValue)) {
	$arwrk = $registro->Estado_Clinico_Notificacion->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = ew_SameStr($registro->Estado_Clinico_Notificacion->AdvancedSearch->SearchValue, $arwrk[$rowcntwrk][0]) ? " selected" : "";
		if ($selwrk <> "") $emptywrk = FALSE;		
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $registro->Estado_Clinico_Notificacion->DisplayValue($arwrk[$rowcntwrk]) ?>
</option>
<?php
	}
	if ($emptywrk && strval($registro->Estado_Clinico_Notificacion->CurrentValue) <> "") {
?>
<option value="<?php echo ew_HtmlEncode($registro->Estado_Clinico_Notificacion->CurrentValue) ?>" selected><?php echo $registro->Estado_Clinico_Notificacion->CurrentValue ?></option>
<?php
    }
}
?>
</select>
<?php
$sSqlWrk = "SELECT `Consecutivo`, `Estado_Clinico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `estado_clinico_paciente`";
$sWhereWrk = "";
$registro->Estado_Clinico_Notificacion->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$registro->Estado_Clinico_Notificacion->LookupFilters += array("f0" => "`Consecutivo` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$registro->Lookup_Selecting($registro->Estado_Clinico_Notificacion, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $registro->Estado_Clinico_Notificacion->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Estado_Clinico_Notificacion" id="s_x_Estado_Clinico_Notificacion" value="<?php echo $registro->Estado_Clinico_Notificacion->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_13" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($registro_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($registro_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $registro_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($registro_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($registro_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($registro_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($registro_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $registro_list->ShowPageHeader(); ?>
<?php
$registro_list->ShowMessage();
?>
<?php if ($registro_list->TotalRecs > 0 || $registro->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<?php if ($registro->Export == "") { ?>
<div class="panel-heading ewGridUpperPanel">
<?php if ($registro->CurrentAction <> "gridadd" && $registro->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($registro_list->Pager)) $registro_list->Pager = new cPrevNextPager($registro_list->StartRec, $registro_list->DisplayRecs, $registro_list->TotalRecs) ?>
<?php if ($registro_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($registro_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $registro_list->PageUrl() ?>start=<?php echo $registro_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($registro_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $registro_list->PageUrl() ?>start=<?php echo $registro_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $registro_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($registro_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $registro_list->PageUrl() ?>start=<?php echo $registro_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($registro_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $registro_list->PageUrl() ?>start=<?php echo $registro_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $registro_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $registro_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $registro_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $registro_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($registro_list->TotalRecs > 0) { ?>
<div class="ewPager">
<input type="hidden" name="t" value="registro">
<select name="<?php echo EW_TABLE_REC_PER_PAGE ?>" class="form-control input-sm" onchange="this.form.submit();">
<option value="20"<?php if ($registro_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="40"<?php if ($registro_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($registro_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($registro_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($registro_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fregistrolist" id="fregistrolist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($registro_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $registro_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="registro">
<div id="gmp_registro" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($registro_list->TotalRecs > 0) { ?>
<table id="tbl_registrolist" class="table ewTable">
<?php echo $registro->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$registro_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$registro_list->RenderListOptions();

// Render list options (header, left)
$registro_list->ListOptions->Render("header", "left");
?>
<?php if ($registro->Seguimiento->Visible) { // Seguimiento ?>
	<?php if ($registro->SortUrl($registro->Seguimiento) == "") { ?>
		<th data-name="Seguimiento"><div id="elh_registro_Seguimiento" class="registro_Seguimiento"><div class="ewTableHeaderCaption"><?php echo $registro->Seguimiento->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Seguimiento"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Seguimiento) ?>',1);"><div id="elh_registro_Seguimiento" class="registro_Seguimiento">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Seguimiento->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Seguimiento->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Seguimiento->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Condicion_Final->Visible) { // Condicion_Final ?>
	<?php if ($registro->SortUrl($registro->Condicion_Final) == "") { ?>
		<th data-name="Condicion_Final"><div id="elh_registro_Condicion_Final" class="registro_Condicion_Final"><div class="ewTableHeaderCaption"><?php echo $registro->Condicion_Final->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Condicion_Final"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Condicion_Final) ?>',1);"><div id="elh_registro_Condicion_Final" class="registro_Condicion_Final">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Condicion_Final->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Condicion_Final->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Condicion_Final->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Codigo_centro->Visible) { // Codigo_centro ?>
	<?php if ($registro->SortUrl($registro->Codigo_centro) == "") { ?>
		<th data-name="Codigo_centro"><div id="elh_registro_Codigo_centro" class="registro_Codigo_centro"><div class="ewTableHeaderCaption"><?php echo $registro->Codigo_centro->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_centro"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Codigo_centro) ?>',1);"><div id="elh_registro_Codigo_centro" class="registro_Codigo_centro">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Codigo_centro->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Codigo_centro->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Codigo_centro->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Codigo_UPGD->Visible) { // Codigo_UPGD ?>
	<?php if ($registro->SortUrl($registro->Codigo_UPGD) == "") { ?>
		<th data-name="Codigo_UPGD"><div id="elh_registro_Codigo_UPGD" class="registro_Codigo_UPGD"><div class="ewTableHeaderCaption"><?php echo $registro->Codigo_UPGD->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_UPGD"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Codigo_UPGD) ?>',1);"><div id="elh_registro_Codigo_UPGD" class="registro_Codigo_UPGD">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Codigo_UPGD->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($registro->Codigo_UPGD->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Codigo_UPGD->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Embarazo_Actual->Visible) { // Embarazo_Actual ?>
	<?php if ($registro->SortUrl($registro->Embarazo_Actual) == "") { ?>
		<th data-name="Embarazo_Actual"><div id="elh_registro_Embarazo_Actual" class="registro_Embarazo_Actual"><div class="ewTableHeaderCaption"><?php echo $registro->Embarazo_Actual->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Embarazo_Actual"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Embarazo_Actual) ?>',1);"><div id="elh_registro_Embarazo_Actual" class="registro_Embarazo_Actual">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Embarazo_Actual->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Embarazo_Actual->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Embarazo_Actual->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Fecha_Notificacion->Visible) { // Fecha_Notificacion ?>
	<?php if ($registro->SortUrl($registro->Fecha_Notificacion) == "") { ?>
		<th data-name="Fecha_Notificacion"><div id="elh_registro_Fecha_Notificacion" class="registro_Fecha_Notificacion"><div class="ewTableHeaderCaption"><?php echo $registro->Fecha_Notificacion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_Notificacion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Fecha_Notificacion) ?>',1);"><div id="elh_registro_Fecha_Notificacion" class="registro_Fecha_Notificacion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Fecha_Notificacion->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($registro->Fecha_Notificacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Fecha_Notificacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Primer_Nombre->Visible) { // Primer_Nombre ?>
	<?php if ($registro->SortUrl($registro->Primer_Nombre) == "") { ?>
		<th data-name="Primer_Nombre"><div id="elh_registro_Primer_Nombre" class="registro_Primer_Nombre"><div class="ewTableHeaderCaption"><?php echo $registro->Primer_Nombre->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primer_Nombre"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Primer_Nombre) ?>',1);"><div id="elh_registro_Primer_Nombre" class="registro_Primer_Nombre">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Primer_Nombre->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($registro->Primer_Nombre->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Primer_Nombre->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Segundo_Nombre->Visible) { // Segundo_Nombre ?>
	<?php if ($registro->SortUrl($registro->Segundo_Nombre) == "") { ?>
		<th data-name="Segundo_Nombre"><div id="elh_registro_Segundo_Nombre" class="registro_Segundo_Nombre"><div class="ewTableHeaderCaption"><?php echo $registro->Segundo_Nombre->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Segundo_Nombre"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Segundo_Nombre) ?>',1);"><div id="elh_registro_Segundo_Nombre" class="registro_Segundo_Nombre">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Segundo_Nombre->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($registro->Segundo_Nombre->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Segundo_Nombre->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Primer_Apellido->Visible) { // Primer_Apellido ?>
	<?php if ($registro->SortUrl($registro->Primer_Apellido) == "") { ?>
		<th data-name="Primer_Apellido"><div id="elh_registro_Primer_Apellido" class="registro_Primer_Apellido"><div class="ewTableHeaderCaption"><?php echo $registro->Primer_Apellido->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primer_Apellido"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Primer_Apellido) ?>',1);"><div id="elh_registro_Primer_Apellido" class="registro_Primer_Apellido">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Primer_Apellido->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($registro->Primer_Apellido->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Primer_Apellido->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Numero_Identificacion->Visible) { // Numero_Identificacion ?>
	<?php if ($registro->SortUrl($registro->Numero_Identificacion) == "") { ?>
		<th data-name="Numero_Identificacion"><div id="elh_registro_Numero_Identificacion" class="registro_Numero_Identificacion"><div class="ewTableHeaderCaption"><?php echo $registro->Numero_Identificacion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero_Identificacion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Numero_Identificacion) ?>',1);"><div id="elh_registro_Numero_Identificacion" class="registro_Numero_Identificacion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Numero_Identificacion->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($registro->Numero_Identificacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Numero_Identificacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
	<?php if ($registro->SortUrl($registro->Tipo_Regimen_Salud) == "") { ?>
		<th data-name="Tipo_Regimen_Salud"><div id="elh_registro_Tipo_Regimen_Salud" class="registro_Tipo_Regimen_Salud"><div class="ewTableHeaderCaption"><?php echo $registro->Tipo_Regimen_Salud->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tipo_Regimen_Salud"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Tipo_Regimen_Salud) ?>',1);"><div id="elh_registro_Tipo_Regimen_Salud" class="registro_Tipo_Regimen_Salud">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Tipo_Regimen_Salud->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Tipo_Regimen_Salud->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Tipo_Regimen_Salud->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Cod_Administradora->Visible) { // Cod_Administradora ?>
	<?php if ($registro->SortUrl($registro->Cod_Administradora) == "") { ?>
		<th data-name="Cod_Administradora"><div id="elh_registro_Cod_Administradora" class="registro_Cod_Administradora"><div class="ewTableHeaderCaption"><?php echo $registro->Cod_Administradora->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Cod_Administradora"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Cod_Administradora) ?>',1);"><div id="elh_registro_Cod_Administradora" class="registro_Cod_Administradora">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Cod_Administradora->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Cod_Administradora->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Cod_Administradora->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Hospitalizado->Visible) { // Hospitalizado ?>
	<?php if ($registro->SortUrl($registro->Hospitalizado) == "") { ?>
		<th data-name="Hospitalizado"><div id="elh_registro_Hospitalizado" class="registro_Hospitalizado"><div class="ewTableHeaderCaption"><?php echo $registro->Hospitalizado->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hospitalizado"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Hospitalizado) ?>',1);"><div id="elh_registro_Hospitalizado" class="registro_Hospitalizado">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Hospitalizado->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Hospitalizado->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Hospitalizado->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Mecanismo_Probable_Transmision->Visible) { // Mecanismo_Probable_Transmision ?>
	<?php if ($registro->SortUrl($registro->Mecanismo_Probable_Transmision) == "") { ?>
		<th data-name="Mecanismo_Probable_Transmision"><div id="elh_registro_Mecanismo_Probable_Transmision" class="registro_Mecanismo_Probable_Transmision"><div class="ewTableHeaderCaption"><?php echo $registro->Mecanismo_Probable_Transmision->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Mecanismo_Probable_Transmision"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Mecanismo_Probable_Transmision) ?>',1);"><div id="elh_registro_Mecanismo_Probable_Transmision" class="registro_Mecanismo_Probable_Transmision">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Mecanismo_Probable_Transmision->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Mecanismo_Probable_Transmision->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Mecanismo_Probable_Transmision->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Estado_Clinico_Notificacion->Visible) { // Estado_Clinico_Notificacion ?>
	<?php if ($registro->SortUrl($registro->Estado_Clinico_Notificacion) == "") { ?>
		<th data-name="Estado_Clinico_Notificacion"><div id="elh_registro_Estado_Clinico_Notificacion" class="registro_Estado_Clinico_Notificacion"><div class="ewTableHeaderCaption"><?php echo $registro->Estado_Clinico_Notificacion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Estado_Clinico_Notificacion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Estado_Clinico_Notificacion) ?>',1);"><div id="elh_registro_Estado_Clinico_Notificacion" class="registro_Estado_Clinico_Notificacion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Estado_Clinico_Notificacion->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Estado_Clinico_Notificacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Estado_Clinico_Notificacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($registro->Registrado_Por->Visible) { // Registrado_Por ?>
	<?php if ($registro->SortUrl($registro->Registrado_Por) == "") { ?>
		<th data-name="Registrado_Por"><div id="elh_registro_Registrado_Por" class="registro_Registrado_Por"><div class="ewTableHeaderCaption"><?php echo $registro->Registrado_Por->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Registrado_Por"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $registro->SortUrl($registro->Registrado_Por) ?>',1);"><div id="elh_registro_Registrado_Por" class="registro_Registrado_Por">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $registro->Registrado_Por->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($registro->Registrado_Por->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($registro->Registrado_Por->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$registro_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($registro->ExportAll && $registro->Export <> "") {
	$registro_list->StopRec = $registro_list->TotalRecs;
} else {

	// Set the last record to display
	if ($registro_list->TotalRecs > $registro_list->StartRec + $registro_list->DisplayRecs - 1)
		$registro_list->StopRec = $registro_list->StartRec + $registro_list->DisplayRecs - 1;
	else
		$registro_list->StopRec = $registro_list->TotalRecs;
}
$registro_list->RecCnt = $registro_list->StartRec - 1;
if ($registro_list->Recordset && !$registro_list->Recordset->EOF) {
	$registro_list->Recordset->MoveFirst();
	$bSelectLimit = $registro_list->UseSelectLimit;
	if (!$bSelectLimit && $registro_list->StartRec > 1)
		$registro_list->Recordset->Move($registro_list->StartRec - 1);
} elseif (!$registro->AllowAddDeleteRow && $registro_list->StopRec == 0) {
	$registro_list->StopRec = $registro->GridAddRowCount;
}

// Initialize aggregate
$registro->RowType = EW_ROWTYPE_AGGREGATEINIT;
$registro->ResetAttrs();
$registro_list->RenderRow();
while ($registro_list->RecCnt < $registro_list->StopRec) {
	$registro_list->RecCnt++;
	if (intval($registro_list->RecCnt) >= intval($registro_list->StartRec)) {
		$registro_list->RowCnt++;

		// Set up key count
		$registro_list->KeyCount = $registro_list->RowIndex;

		// Init row class and style
		$registro->ResetAttrs();
		$registro->CssClass = "";
		if ($registro->CurrentAction == "gridadd") {
		} else {
			$registro_list->LoadRowValues($registro_list->Recordset); // Load row values
		}
		$registro->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$registro->RowAttrs = array_merge($registro->RowAttrs, array('data-rowindex'=>$registro_list->RowCnt, 'id'=>'r' . $registro_list->RowCnt . '_registro', 'data-rowtype'=>$registro->RowType));

		// Render row
		$registro_list->RenderRow();

		// Render list options
		$registro_list->RenderListOptions();
?>
	<tr<?php echo $registro->RowAttributes() ?>>
<?php

// Render list options (body, left)
$registro_list->ListOptions->Render("body", "left", $registro_list->RowCnt);
?>
	<?php if ($registro->Seguimiento->Visible) { // Seguimiento ?>
		<td data-name="Seguimiento"<?php echo $registro->Seguimiento->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Seguimiento" class="registro_Seguimiento">
<span<?php echo $registro->Seguimiento->ViewAttributes() ?>>
<?php echo $registro->Seguimiento->ListViewValue() ?></span>
</span>
<a id="<?php echo $registro_list->PageObjName . "_row_" . $registro_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($registro->Condicion_Final->Visible) { // Condicion_Final ?>
		<td data-name="Condicion_Final"<?php echo $registro->Condicion_Final->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Condicion_Final" class="registro_Condicion_Final">
<span<?php echo $registro->Condicion_Final->ViewAttributes() ?>>
<?php echo $registro->Condicion_Final->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Codigo_centro->Visible) { // Codigo_centro ?>
		<td data-name="Codigo_centro"<?php echo $registro->Codigo_centro->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Codigo_centro" class="registro_Codigo_centro">
<span<?php echo $registro->Codigo_centro->ViewAttributes() ?>>
<?php echo $registro->Codigo_centro->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Codigo_UPGD->Visible) { // Codigo_UPGD ?>
		<td data-name="Codigo_UPGD"<?php echo $registro->Codigo_UPGD->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Codigo_UPGD" class="registro_Codigo_UPGD">
<span<?php echo $registro->Codigo_UPGD->ViewAttributes() ?>>
<?php echo $registro->Codigo_UPGD->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Embarazo_Actual->Visible) { // Embarazo_Actual ?>
		<td data-name="Embarazo_Actual"<?php echo $registro->Embarazo_Actual->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Embarazo_Actual" class="registro_Embarazo_Actual">
<span<?php echo $registro->Embarazo_Actual->ViewAttributes() ?>>
<?php echo $registro->Embarazo_Actual->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Fecha_Notificacion->Visible) { // Fecha_Notificacion ?>
		<td data-name="Fecha_Notificacion"<?php echo $registro->Fecha_Notificacion->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Fecha_Notificacion" class="registro_Fecha_Notificacion">
<span<?php echo $registro->Fecha_Notificacion->ViewAttributes() ?>>
<?php echo $registro->Fecha_Notificacion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Primer_Nombre->Visible) { // Primer_Nombre ?>
		<td data-name="Primer_Nombre"<?php echo $registro->Primer_Nombre->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Primer_Nombre" class="registro_Primer_Nombre">
<span<?php echo $registro->Primer_Nombre->ViewAttributes() ?>>
<?php echo $registro->Primer_Nombre->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Segundo_Nombre->Visible) { // Segundo_Nombre ?>
		<td data-name="Segundo_Nombre"<?php echo $registro->Segundo_Nombre->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Segundo_Nombre" class="registro_Segundo_Nombre">
<span<?php echo $registro->Segundo_Nombre->ViewAttributes() ?>>
<?php echo $registro->Segundo_Nombre->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Primer_Apellido->Visible) { // Primer_Apellido ?>
		<td data-name="Primer_Apellido"<?php echo $registro->Primer_Apellido->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Primer_Apellido" class="registro_Primer_Apellido">
<span<?php echo $registro->Primer_Apellido->ViewAttributes() ?>>
<?php echo $registro->Primer_Apellido->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Numero_Identificacion->Visible) { // Numero_Identificacion ?>
		<td data-name="Numero_Identificacion"<?php echo $registro->Numero_Identificacion->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Numero_Identificacion" class="registro_Numero_Identificacion">
<span<?php echo $registro->Numero_Identificacion->ViewAttributes() ?>>
<?php echo $registro->Numero_Identificacion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
		<td data-name="Tipo_Regimen_Salud"<?php echo $registro->Tipo_Regimen_Salud->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Tipo_Regimen_Salud" class="registro_Tipo_Regimen_Salud">
<span<?php echo $registro->Tipo_Regimen_Salud->ViewAttributes() ?>>
<?php echo $registro->Tipo_Regimen_Salud->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Cod_Administradora->Visible) { // Cod_Administradora ?>
		<td data-name="Cod_Administradora"<?php echo $registro->Cod_Administradora->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Cod_Administradora" class="registro_Cod_Administradora">
<span<?php echo $registro->Cod_Administradora->ViewAttributes() ?>>
<?php echo $registro->Cod_Administradora->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Hospitalizado->Visible) { // Hospitalizado ?>
		<td data-name="Hospitalizado"<?php echo $registro->Hospitalizado->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Hospitalizado" class="registro_Hospitalizado">
<span<?php echo $registro->Hospitalizado->ViewAttributes() ?>>
<?php echo $registro->Hospitalizado->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Mecanismo_Probable_Transmision->Visible) { // Mecanismo_Probable_Transmision ?>
		<td data-name="Mecanismo_Probable_Transmision"<?php echo $registro->Mecanismo_Probable_Transmision->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Mecanismo_Probable_Transmision" class="registro_Mecanismo_Probable_Transmision">
<span<?php echo $registro->Mecanismo_Probable_Transmision->ViewAttributes() ?>>
<?php echo $registro->Mecanismo_Probable_Transmision->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Estado_Clinico_Notificacion->Visible) { // Estado_Clinico_Notificacion ?>
		<td data-name="Estado_Clinico_Notificacion"<?php echo $registro->Estado_Clinico_Notificacion->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Estado_Clinico_Notificacion" class="registro_Estado_Clinico_Notificacion">
<span<?php echo $registro->Estado_Clinico_Notificacion->ViewAttributes() ?>>
<?php echo $registro->Estado_Clinico_Notificacion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($registro->Registrado_Por->Visible) { // Registrado_Por ?>
		<td data-name="Registrado_Por"<?php echo $registro->Registrado_Por->CellAttributes() ?>>
<span id="el<?php echo $registro_list->RowCnt ?>_registro_Registrado_Por" class="registro_Registrado_Por">
<span<?php echo $registro->Registrado_Por->ViewAttributes() ?>>
<?php echo $registro->Registrado_Por->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$registro_list->ListOptions->Render("body", "right", $registro_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($registro->CurrentAction <> "gridadd")
		$registro_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($registro->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($registro_list->Recordset)
	$registro_list->Recordset->Close();
?>
</div>
<?php } ?>
<?php if ($registro_list->TotalRecs == 0 && $registro->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($registro_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
<script type="text/javascript">
fregistrolistsrch.Init();
fregistrolistsrch.FilterList = <?php echo $registro_list->GetFilterList() ?>;
fregistrolist.Init();
</script>
<?php } ?>
<?php
$registro_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($registro->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$registro_list->Page_Terminate();
?>
