<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "registropruebainfo.php" ?>
<?php include_once "ficha_usuarioinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$registroprueba_edit = NULL; // Initialize page object first

class cregistroprueba_edit extends cregistroprueba {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = "{43FC4B6C-8131-46B1-916C-14DB52B1691D}";

	// Table name
	var $TableName = 'registroprueba';

	// Page object name
	var $PageObjName = 'registroprueba_edit';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (registroprueba)
		if (!isset($GLOBALS["registroprueba"]) || get_class($GLOBALS["registroprueba"]) == "cregistroprueba") {
			$GLOBALS["registroprueba"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["registroprueba"];
		}

		// Table object (ficha_usuario)
		if (!isset($GLOBALS['ficha_usuario'])) $GLOBALS['ficha_usuario'] = new cficha_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'registroprueba', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (ficha_usuario)
		if (!isset($UserTable)) {
			$UserTable = new cficha_usuario();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("registropruebalist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}
		if ($Security->IsLoggedIn()) {
			$Security->UserID_Loading();
			$Security->LoadUserID();
			$Security->UserID_Loaded();
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->Consecutivo->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $registroprueba;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($registroprueba);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $DbMasterFilter;
	var $DbDetailFilter;
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Load key from QueryString
		if (@$_GET["Consecutivo"] <> "") {
			$this->Consecutivo->setQueryStringValue($_GET["Consecutivo"]);
			$this->RecKey["Consecutivo"] = $this->Consecutivo->QueryStringValue;
		} else {
			$bLoadCurrentRecord = TRUE;
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($this->Recordset = $this->LoadRecordset()) // Load records
			$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$this->Page_Terminate("registropruebalist.php"); // Return to list page
		} elseif ($bLoadCurrentRecord) { // Load current record position
			$this->SetUpStartRec(); // Set up start record position

			// Point to current record
			if (intval($this->StartRec) <= intval($this->TotalRecs)) {
				$bMatchRecord = TRUE;
				$this->Recordset->Move($this->StartRec-1);
			}
		} else { // Match key values
			while (!$this->Recordset->EOF) {
				if (strval($this->Consecutivo->CurrentValue) == strval($this->Recordset->fields('Consecutivo'))) {
					$this->setStartRecordNumber($this->StartRec); // Save record position
					$bMatchRecord = TRUE;
					break;
				} else {
					$this->StartRec++;
					$this->Recordset->MoveNext();
				}
			}
		}

		// Process form if post back
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			$this->LoadFormValues(); // Get form values
		} else {
			$this->CurrentAction = "I"; // Default action is display
		}

		// Validate form if post back
		if (@$_POST["a_edit"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$bMatchRecord) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
					$this->Page_Terminate("registropruebalist.php"); // Return to list page
				} else {
					$this->LoadRowValues($this->Recordset); // Load row values
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "registropruebalist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to list page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->Consecutivo->FldIsDetailKey)
			$this->Consecutivo->setFormValue($objForm->GetValue("x_Consecutivo"));
		if (!$this->Seguimiento->FldIsDetailKey) {
			$this->Seguimiento->setFormValue($objForm->GetValue("x_Seguimiento"));
		}
		if (!$this->Primer_Nombre->FldIsDetailKey) {
			$this->Primer_Nombre->setFormValue($objForm->GetValue("x_Primer_Nombre"));
		}
		if (!$this->Segundo_Nombre->FldIsDetailKey) {
			$this->Segundo_Nombre->setFormValue($objForm->GetValue("x_Segundo_Nombre"));
		}
		if (!$this->Primer_Apellido->FldIsDetailKey) {
			$this->Primer_Apellido->setFormValue($objForm->GetValue("x_Primer_Apellido"));
		}
		if (!$this->Segundo_Apellido->FldIsDetailKey) {
			$this->Segundo_Apellido->setFormValue($objForm->GetValue("x_Segundo_Apellido"));
		}
		if (!$this->Tipo_Id->FldIsDetailKey) {
			$this->Tipo_Id->setFormValue($objForm->GetValue("x_Tipo_Id"));
		}
		if (!$this->Numero_Identificacion->FldIsDetailKey) {
			$this->Numero_Identificacion->setFormValue($objForm->GetValue("x_Numero_Identificacion"));
		}
		if (!$this->Telefono->FldIsDetailKey) {
			$this->Telefono->setFormValue($objForm->GetValue("x_Telefono"));
		}
		if (!$this->Fecha_Nacimiento->FldIsDetailKey) {
			$this->Fecha_Nacimiento->setFormValue($objForm->GetValue("x_Fecha_Nacimiento"));
			$this->Fecha_Nacimiento->CurrentValue = ew_UnFormatDateTime($this->Fecha_Nacimiento->CurrentValue, 5);
		}
		if (!$this->Edad->FldIsDetailKey) {
			$this->Edad->setFormValue($objForm->GetValue("x_Edad"));
		}
		if (!$this->Unidad_Edad->FldIsDetailKey) {
			$this->Unidad_Edad->setFormValue($objForm->GetValue("x_Unidad_Edad"));
		}
		if (!$this->Sexo->FldIsDetailKey) {
			$this->Sexo->setFormValue($objForm->GetValue("x_Sexo"));
		}
		if (!$this->Pais_Ocurrencia->FldIsDetailKey) {
			$this->Pais_Ocurrencia->setFormValue($objForm->GetValue("x_Pais_Ocurrencia"));
		}
		if (!$this->Depto_Ocurrencia->FldIsDetailKey) {
			$this->Depto_Ocurrencia->setFormValue($objForm->GetValue("x_Depto_Ocurrencia"));
		}
		if (!$this->Municipio_Ocurrencia->FldIsDetailKey) {
			$this->Municipio_Ocurrencia->setFormValue($objForm->GetValue("x_Municipio_Ocurrencia"));
		}
		if (!$this->Area_Ocurrencia->FldIsDetailKey) {
			$this->Area_Ocurrencia->setFormValue($objForm->GetValue("x_Area_Ocurrencia"));
		}
		if (!$this->Localidad->FldIsDetailKey) {
			$this->Localidad->setFormValue($objForm->GetValue("x_Localidad"));
		}
		if (!$this->Centro_Poblado->FldIsDetailKey) {
			$this->Centro_Poblado->setFormValue($objForm->GetValue("x_Centro_Poblado"));
		}
		if (!$this->Vereda->FldIsDetailKey) {
			$this->Vereda->setFormValue($objForm->GetValue("x_Vereda"));
		}
		if (!$this->Barrio->FldIsDetailKey) {
			$this->Barrio->setFormValue($objForm->GetValue("x_Barrio"));
		}
		if (!$this->Direccion_Residencia->FldIsDetailKey) {
			$this->Direccion_Residencia->setFormValue($objForm->GetValue("x_Direccion_Residencia"));
		}
		if (!$this->Ocupacion->FldIsDetailKey) {
			$this->Ocupacion->setFormValue($objForm->GetValue("x_Ocupacion"));
		}
		if (!$this->Tipo_Regimen_Salud->FldIsDetailKey) {
			$this->Tipo_Regimen_Salud->setFormValue($objForm->GetValue("x_Tipo_Regimen_Salud"));
		}
		if (!$this->Cod_Administradora->FldIsDetailKey) {
			$this->Cod_Administradora->setFormValue($objForm->GetValue("x_Cod_Administradora"));
		}
		if (!$this->Pertenencia_Etnica->FldIsDetailKey) {
			$this->Pertenencia_Etnica->setFormValue($objForm->GetValue("x_Pertenencia_Etnica"));
		}
		if (!$this->Grupo_Poblacional->FldIsDetailKey) {
			$this->Grupo_Poblacional->setFormValue($objForm->GetValue("x_Grupo_Poblacional"));
		}
		if (!$this->Depto_Residencia->FldIsDetailKey) {
			$this->Depto_Residencia->setFormValue($objForm->GetValue("x_Depto_Residencia"));
		}
		if (!$this->Municipio_Residencia->FldIsDetailKey) {
			$this->Municipio_Residencia->setFormValue($objForm->GetValue("x_Municipio_Residencia"));
		}
		if (!$this->Fecha_Consulta->FldIsDetailKey) {
			$this->Fecha_Consulta->setFormValue($objForm->GetValue("x_Fecha_Consulta"));
			$this->Fecha_Consulta->CurrentValue = ew_UnFormatDateTime($this->Fecha_Consulta->CurrentValue, 5);
		}
		if (!$this->Fecha_Inicio_Sintomas->FldIsDetailKey) {
			$this->Fecha_Inicio_Sintomas->setFormValue($objForm->GetValue("x_Fecha_Inicio_Sintomas"));
			$this->Fecha_Inicio_Sintomas->CurrentValue = ew_UnFormatDateTime($this->Fecha_Inicio_Sintomas->CurrentValue, 5);
		}
		if (!$this->Clasificacion_Inicial->FldIsDetailKey) {
			$this->Clasificacion_Inicial->setFormValue($objForm->GetValue("x_Clasificacion_Inicial"));
		}
		if (!$this->Hospitalizado->FldIsDetailKey) {
			$this->Hospitalizado->setFormValue($objForm->GetValue("x_Hospitalizado"));
		}
		if (!$this->Fecha_Hospitalizacion->FldIsDetailKey) {
			$this->Fecha_Hospitalizacion->setFormValue($objForm->GetValue("x_Fecha_Hospitalizacion"));
			$this->Fecha_Hospitalizacion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Hospitalizacion->CurrentValue, 5);
		}
		if (!$this->Condicion_Final->FldIsDetailKey) {
			$this->Condicion_Final->setFormValue($objForm->GetValue("x_Condicion_Final"));
		}
		if (!$this->Fecha_Defuncion->FldIsDetailKey) {
			$this->Fecha_Defuncion->setFormValue($objForm->GetValue("x_Fecha_Defuncion"));
			$this->Fecha_Defuncion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Defuncion->CurrentValue, 5);
		}
		if (!$this->Numero_Certificado_Defuncion->FldIsDetailKey) {
			$this->Numero_Certificado_Defuncion->setFormValue($objForm->GetValue("x_Numero_Certificado_Defuncion"));
		}
		if (!$this->Causa_Basica_Muerte_CIEX->FldIsDetailKey) {
			$this->Causa_Basica_Muerte_CIEX->setFormValue($objForm->GetValue("x_Causa_Basica_Muerte_CIEX"));
		}
		if (!$this->Nombre_Profesional_Diligencia->FldIsDetailKey) {
			$this->Nombre_Profesional_Diligencia->setFormValue($objForm->GetValue("x_Nombre_Profesional_Diligencia"));
		}
		if (!$this->Telefono_Profesional_Diligencia->FldIsDetailKey) {
			$this->Telefono_Profesional_Diligencia->setFormValue($objForm->GetValue("x_Telefono_Profesional_Diligencia"));
		}
		if (!$this->Seguimiento_Clasificacion_Final->FldIsDetailKey) {
			$this->Seguimiento_Clasificacion_Final->setFormValue($objForm->GetValue("x_Seguimiento_Clasificacion_Final"));
		}
		if (!$this->Fecha_Ajuste->FldIsDetailKey) {
			$this->Fecha_Ajuste->setFormValue($objForm->GetValue("x_Fecha_Ajuste"));
			$this->Fecha_Ajuste->CurrentValue = ew_UnFormatDateTime($this->Fecha_Ajuste->CurrentValue, 5);
		}
		if (!$this->Codigo_UPGD->FldIsDetailKey) {
			$this->Codigo_UPGD->setFormValue($objForm->GetValue("x_Codigo_UPGD"));
		}
		if (!$this->Nombre_Evento->FldIsDetailKey) {
			$this->Nombre_Evento->setFormValue($objForm->GetValue("x_Nombre_Evento"));
		}
		if (!$this->Cod_Evento->FldIsDetailKey) {
			$this->Cod_Evento->setFormValue($objForm->GetValue("x_Cod_Evento"));
		}
		if (!$this->Fecha_Notificacion->FldIsDetailKey) {
			$this->Fecha_Notificacion->setFormValue($objForm->GetValue("x_Fecha_Notificacion"));
			$this->Fecha_Notificacion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Notificacion->CurrentValue, 5);
		}
		if (!$this->Semana->FldIsDetailKey) {
			$this->Semana->setFormValue($objForm->GetValue("x_Semana"));
		}
		if (!$this->Mecanismo_Probable_Transmision->FldIsDetailKey) {
			$this->Mecanismo_Probable_Transmision->setFormValue($objForm->GetValue("x_Mecanismo_Probable_Transmision"));
		}
		if (!$this->Nombre_Madre->FldIsDetailKey) {
			$this->Nombre_Madre->setFormValue($objForm->GetValue("x_Nombre_Madre"));
		}
		if (!$this->Tipo_Id_Madre->FldIsDetailKey) {
			$this->Tipo_Id_Madre->setFormValue($objForm->GetValue("x_Tipo_Id_Madre"));
		}
		if (!$this->Numero_Identificacion_Madre->FldIsDetailKey) {
			$this->Numero_Identificacion_Madre->setFormValue($objForm->GetValue("x_Numero_Identificacion_Madre"));
		}
		if (!$this->Indentidad_Genero->FldIsDetailKey) {
			$this->Indentidad_Genero->setFormValue($objForm->GetValue("x_Indentidad_Genero"));
		}
		if (!$this->Donador_Sangre_Ultimos_12_Meses->FldIsDetailKey) {
			$this->Donador_Sangre_Ultimos_12_Meses->setFormValue($objForm->GetValue("x_Donador_Sangre_Ultimos_12_Meses"));
		}
		if (!$this->Fecha_Donacion->FldIsDetailKey) {
			$this->Fecha_Donacion->setFormValue($objForm->GetValue("x_Fecha_Donacion"));
			$this->Fecha_Donacion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Donacion->CurrentValue, 5);
		}
		if (!$this->Nombre_Institucion_Donacion->FldIsDetailKey) {
			$this->Nombre_Institucion_Donacion->setFormValue($objForm->GetValue("x_Nombre_Institucion_Donacion"));
		}
		if (!$this->Recibio_Asesoria_Pre_Prueba->FldIsDetailKey) {
			$this->Recibio_Asesoria_Pre_Prueba->setFormValue($objForm->GetValue("x_Recibio_Asesoria_Pre_Prueba"));
		}
		if (!$this->Recibio_Asesoria_Post_Prueba->FldIsDetailKey) {
			$this->Recibio_Asesoria_Post_Prueba->setFormValue($objForm->GetValue("x_Recibio_Asesoria_Post_Prueba"));
		}
		if (!$this->Tipo_Prueba->FldIsDetailKey) {
			$this->Tipo_Prueba->setFormValue($objForm->GetValue("x_Tipo_Prueba"));
		}
		if (!$this->Fecha_Resultado_Confirmatorio->FldIsDetailKey) {
			$this->Fecha_Resultado_Confirmatorio->setFormValue($objForm->GetValue("x_Fecha_Resultado_Confirmatorio"));
			$this->Fecha_Resultado_Confirmatorio->CurrentValue = ew_UnFormatDateTime($this->Fecha_Resultado_Confirmatorio->CurrentValue, 5);
		}
		if (!$this->Valor_Carga_Viral->FldIsDetailKey) {
			$this->Valor_Carga_Viral->setFormValue($objForm->GetValue("x_Valor_Carga_Viral"));
		}
		if (!$this->Estado_Clinico_Notificacion->FldIsDetailKey) {
			$this->Estado_Clinico_Notificacion->setFormValue($objForm->GetValue("x_Estado_Clinico_Notificacion"));
		}
		if (!$this->Hijos_Mujeres_Menores_5->FldIsDetailKey) {
			$this->Hijos_Mujeres_Menores_5->setFormValue($objForm->GetValue("x_Hijos_Mujeres_Menores_5"));
		}
		if (!$this->Hijos_Hombres_Menores_5->FldIsDetailKey) {
			$this->Hijos_Hombres_Menores_5->setFormValue($objForm->GetValue("x_Hijos_Hombres_Menores_5"));
		}
		if (!$this->Embarazo_Actual->FldIsDetailKey) {
			$this->Embarazo_Actual->setFormValue($objForm->GetValue("x_Embarazo_Actual"));
		}
		if (!$this->Antecedentes_Embarazo->FldIsDetailKey) {
			$this->Antecedentes_Embarazo->setFormValue($objForm->GetValue("x_Antecedentes_Embarazo"));
		}
		if (!$this->Numero_Semanas_Embarazo->FldIsDetailKey) {
			$this->Numero_Semanas_Embarazo->setFormValue($objForm->GetValue("x_Numero_Semanas_Embarazo"));
		}
		if (!$this->Candidiasis_esofagica->FldIsDetailKey) {
			$this->Candidiasis_esofagica->setFormValue($objForm->GetValue("x_Candidiasis_esofagica"));
		}
		if (!$this->Candidiasis_vias_aereas->FldIsDetailKey) {
			$this->Candidiasis_vias_aereas->setFormValue($objForm->GetValue("x_Candidiasis_vias_aereas"));
		}
		if (!$this->Tuberculosis_pulmonar->FldIsDetailKey) {
			$this->Tuberculosis_pulmonar->setFormValue($objForm->GetValue("x_Tuberculosis_pulmonar"));
		}
		if (!$this->Cancer_cervical->FldIsDetailKey) {
			$this->Cancer_cervical->setFormValue($objForm->GetValue("x_Cancer_cervical"));
		}
		if (!$this->Tuberculosis_extrapulmonar->FldIsDetailKey) {
			$this->Tuberculosis_extrapulmonar->setFormValue($objForm->GetValue("x_Tuberculosis_extrapulmonar"));
		}
		if (!$this->Coccidiomicosis->FldIsDetailKey) {
			$this->Coccidiomicosis->setFormValue($objForm->GetValue("x_Coccidiomicosis"));
		}
		if (!$this->Citomegalovirosis->FldIsDetailKey) {
			$this->Citomegalovirosis->setFormValue($objForm->GetValue("x_Citomegalovirosis"));
		}
		if (!$this->Retinitis_citomegalovirosis->FldIsDetailKey) {
			$this->Retinitis_citomegalovirosis->setFormValue($objForm->GetValue("x_Retinitis_citomegalovirosis"));
		}
		if (!$this->Encefalopatia->FldIsDetailKey) {
			$this->Encefalopatia->setFormValue($objForm->GetValue("x_Encefalopatia"));
		}
		if (!$this->Otras_micobacterias->FldIsDetailKey) {
			$this->Otras_micobacterias->setFormValue($objForm->GetValue("x_Otras_micobacterias"));
		}
		if (!$this->Histoplasmosis_Extrapulmonar->FldIsDetailKey) {
			$this->Histoplasmosis_Extrapulmonar->setFormValue($objForm->GetValue("x_Histoplasmosis_Extrapulmonar"));
		}
		if (!$this->isosporidiasis_cronica->FldIsDetailKey) {
			$this->isosporidiasis_cronica->setFormValue($objForm->GetValue("x_isosporidiasis_cronica"));
		}
		if (!$this->herpes_zoster->FldIsDetailKey) {
			$this->herpes_zoster->setFormValue($objForm->GetValue("x_herpes_zoster"));
		}
		if (!$this->Histoplasmosis_diseminada->FldIsDetailKey) {
			$this->Histoplasmosis_diseminada->setFormValue($objForm->GetValue("x_Histoplasmosis_diseminada"));
		}
		if (!$this->Linfoma_Burkitt->FldIsDetailKey) {
			$this->Linfoma_Burkitt->setFormValue($objForm->GetValue("x_Linfoma_Burkitt"));
		}
		if (!$this->Neumonia_Pneumocystis->FldIsDetailKey) {
			$this->Neumonia_Pneumocystis->setFormValue($objForm->GetValue("x_Neumonia_Pneumocystis"));
		}
		if (!$this->Neumonia_Recurrente->FldIsDetailKey) {
			$this->Neumonia_Recurrente->setFormValue($objForm->GetValue("x_Neumonia_Recurrente"));
		}
		if (!$this->Linfoma_Inmunoblastico->FldIsDetailKey) {
			$this->Linfoma_Inmunoblastico->setFormValue($objForm->GetValue("x_Linfoma_Inmunoblastico"));
		}
		if (!$this->Criptosporidiasis_cronica->FldIsDetailKey) {
			$this->Criptosporidiasis_cronica->setFormValue($objForm->GetValue("x_Criptosporidiasis_cronica"));
		}
		if (!$this->Criptococosis_Extrapulmonar->FldIsDetailKey) {
			$this->Criptococosis_Extrapulmonar->setFormValue($objForm->GetValue("x_Criptococosis_Extrapulmonar"));
		}
		if (!$this->Sarcoma_Kaposi->FldIsDetailKey) {
			$this->Sarcoma_Kaposi->setFormValue($objForm->GetValue("x_Sarcoma_Kaposi"));
		}
		if (!$this->Sindrome_Emanciacion->FldIsDetailKey) {
			$this->Sindrome_Emanciacion->setFormValue($objForm->GetValue("x_Sindrome_Emanciacion"));
		}
		if (!$this->Leucoencefalopatia_Multifocal->FldIsDetailKey) {
			$this->Leucoencefalopatia_Multifocal->setFormValue($objForm->GetValue("x_Leucoencefalopatia_Multifocal"));
		}
		if (!$this->Septicemia_recurrente->FldIsDetailKey) {
			$this->Septicemia_recurrente->setFormValue($objForm->GetValue("x_Septicemia_recurrente"));
		}
		if (!$this->Toxoplasmosis_cerebral->FldIsDetailKey) {
			$this->Toxoplasmosis_cerebral->setFormValue($objForm->GetValue("x_Toxoplasmosis_cerebral"));
		}
		if (!$this->HepatitisB->FldIsDetailKey) {
			$this->HepatitisB->setFormValue($objForm->GetValue("x_HepatitisB"));
		}
		if (!$this->HepatitisC->FldIsDetailKey) {
			$this->HepatitisC->setFormValue($objForm->GetValue("x_HepatitisC"));
		}
		if (!$this->Meningitis->FldIsDetailKey) {
			$this->Meningitis->setFormValue($objForm->GetValue("x_Meningitis"));
		}
		if (!$this->RecuentoCD4->FldIsDetailKey) {
			$this->RecuentoCD4->setFormValue($objForm->GetValue("x_RecuentoCD4"));
		}
		if (!$this->Registrado_Por->FldIsDetailKey) {
			$this->Registrado_Por->setFormValue($objForm->GetValue("x_Registrado_Por"));
		}
		if (!$this->Actualmente_Seguimiento->FldIsDetailKey) {
			$this->Actualmente_Seguimiento->setFormValue($objForm->GetValue("x_Actualmente_Seguimiento"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadRow();
		$this->Consecutivo->CurrentValue = $this->Consecutivo->FormValue;
		$this->Seguimiento->CurrentValue = $this->Seguimiento->FormValue;
		$this->Primer_Nombre->CurrentValue = $this->Primer_Nombre->FormValue;
		$this->Segundo_Nombre->CurrentValue = $this->Segundo_Nombre->FormValue;
		$this->Primer_Apellido->CurrentValue = $this->Primer_Apellido->FormValue;
		$this->Segundo_Apellido->CurrentValue = $this->Segundo_Apellido->FormValue;
		$this->Tipo_Id->CurrentValue = $this->Tipo_Id->FormValue;
		$this->Numero_Identificacion->CurrentValue = $this->Numero_Identificacion->FormValue;
		$this->Telefono->CurrentValue = $this->Telefono->FormValue;
		$this->Fecha_Nacimiento->CurrentValue = $this->Fecha_Nacimiento->FormValue;
		$this->Fecha_Nacimiento->CurrentValue = ew_UnFormatDateTime($this->Fecha_Nacimiento->CurrentValue, 5);
		$this->Edad->CurrentValue = $this->Edad->FormValue;
		$this->Unidad_Edad->CurrentValue = $this->Unidad_Edad->FormValue;
		$this->Sexo->CurrentValue = $this->Sexo->FormValue;
		$this->Pais_Ocurrencia->CurrentValue = $this->Pais_Ocurrencia->FormValue;
		$this->Depto_Ocurrencia->CurrentValue = $this->Depto_Ocurrencia->FormValue;
		$this->Municipio_Ocurrencia->CurrentValue = $this->Municipio_Ocurrencia->FormValue;
		$this->Area_Ocurrencia->CurrentValue = $this->Area_Ocurrencia->FormValue;
		$this->Localidad->CurrentValue = $this->Localidad->FormValue;
		$this->Centro_Poblado->CurrentValue = $this->Centro_Poblado->FormValue;
		$this->Vereda->CurrentValue = $this->Vereda->FormValue;
		$this->Barrio->CurrentValue = $this->Barrio->FormValue;
		$this->Direccion_Residencia->CurrentValue = $this->Direccion_Residencia->FormValue;
		$this->Ocupacion->CurrentValue = $this->Ocupacion->FormValue;
		$this->Tipo_Regimen_Salud->CurrentValue = $this->Tipo_Regimen_Salud->FormValue;
		$this->Cod_Administradora->CurrentValue = $this->Cod_Administradora->FormValue;
		$this->Pertenencia_Etnica->CurrentValue = $this->Pertenencia_Etnica->FormValue;
		$this->Grupo_Poblacional->CurrentValue = $this->Grupo_Poblacional->FormValue;
		$this->Depto_Residencia->CurrentValue = $this->Depto_Residencia->FormValue;
		$this->Municipio_Residencia->CurrentValue = $this->Municipio_Residencia->FormValue;
		$this->Fecha_Consulta->CurrentValue = $this->Fecha_Consulta->FormValue;
		$this->Fecha_Consulta->CurrentValue = ew_UnFormatDateTime($this->Fecha_Consulta->CurrentValue, 5);
		$this->Fecha_Inicio_Sintomas->CurrentValue = $this->Fecha_Inicio_Sintomas->FormValue;
		$this->Fecha_Inicio_Sintomas->CurrentValue = ew_UnFormatDateTime($this->Fecha_Inicio_Sintomas->CurrentValue, 5);
		$this->Clasificacion_Inicial->CurrentValue = $this->Clasificacion_Inicial->FormValue;
		$this->Hospitalizado->CurrentValue = $this->Hospitalizado->FormValue;
		$this->Fecha_Hospitalizacion->CurrentValue = $this->Fecha_Hospitalizacion->FormValue;
		$this->Fecha_Hospitalizacion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Hospitalizacion->CurrentValue, 5);
		$this->Condicion_Final->CurrentValue = $this->Condicion_Final->FormValue;
		$this->Fecha_Defuncion->CurrentValue = $this->Fecha_Defuncion->FormValue;
		$this->Fecha_Defuncion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Defuncion->CurrentValue, 5);
		$this->Numero_Certificado_Defuncion->CurrentValue = $this->Numero_Certificado_Defuncion->FormValue;
		$this->Causa_Basica_Muerte_CIEX->CurrentValue = $this->Causa_Basica_Muerte_CIEX->FormValue;
		$this->Nombre_Profesional_Diligencia->CurrentValue = $this->Nombre_Profesional_Diligencia->FormValue;
		$this->Telefono_Profesional_Diligencia->CurrentValue = $this->Telefono_Profesional_Diligencia->FormValue;
		$this->Seguimiento_Clasificacion_Final->CurrentValue = $this->Seguimiento_Clasificacion_Final->FormValue;
		$this->Fecha_Ajuste->CurrentValue = $this->Fecha_Ajuste->FormValue;
		$this->Fecha_Ajuste->CurrentValue = ew_UnFormatDateTime($this->Fecha_Ajuste->CurrentValue, 5);
		$this->Codigo_UPGD->CurrentValue = $this->Codigo_UPGD->FormValue;
		$this->Nombre_Evento->CurrentValue = $this->Nombre_Evento->FormValue;
		$this->Cod_Evento->CurrentValue = $this->Cod_Evento->FormValue;
		$this->Fecha_Notificacion->CurrentValue = $this->Fecha_Notificacion->FormValue;
		$this->Fecha_Notificacion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Notificacion->CurrentValue, 5);
		$this->Semana->CurrentValue = $this->Semana->FormValue;
		$this->Mecanismo_Probable_Transmision->CurrentValue = $this->Mecanismo_Probable_Transmision->FormValue;
		$this->Nombre_Madre->CurrentValue = $this->Nombre_Madre->FormValue;
		$this->Tipo_Id_Madre->CurrentValue = $this->Tipo_Id_Madre->FormValue;
		$this->Numero_Identificacion_Madre->CurrentValue = $this->Numero_Identificacion_Madre->FormValue;
		$this->Indentidad_Genero->CurrentValue = $this->Indentidad_Genero->FormValue;
		$this->Donador_Sangre_Ultimos_12_Meses->CurrentValue = $this->Donador_Sangre_Ultimos_12_Meses->FormValue;
		$this->Fecha_Donacion->CurrentValue = $this->Fecha_Donacion->FormValue;
		$this->Fecha_Donacion->CurrentValue = ew_UnFormatDateTime($this->Fecha_Donacion->CurrentValue, 5);
		$this->Nombre_Institucion_Donacion->CurrentValue = $this->Nombre_Institucion_Donacion->FormValue;
		$this->Recibio_Asesoria_Pre_Prueba->CurrentValue = $this->Recibio_Asesoria_Pre_Prueba->FormValue;
		$this->Recibio_Asesoria_Post_Prueba->CurrentValue = $this->Recibio_Asesoria_Post_Prueba->FormValue;
		$this->Tipo_Prueba->CurrentValue = $this->Tipo_Prueba->FormValue;
		$this->Fecha_Resultado_Confirmatorio->CurrentValue = $this->Fecha_Resultado_Confirmatorio->FormValue;
		$this->Fecha_Resultado_Confirmatorio->CurrentValue = ew_UnFormatDateTime($this->Fecha_Resultado_Confirmatorio->CurrentValue, 5);
		$this->Valor_Carga_Viral->CurrentValue = $this->Valor_Carga_Viral->FormValue;
		$this->Estado_Clinico_Notificacion->CurrentValue = $this->Estado_Clinico_Notificacion->FormValue;
		$this->Hijos_Mujeres_Menores_5->CurrentValue = $this->Hijos_Mujeres_Menores_5->FormValue;
		$this->Hijos_Hombres_Menores_5->CurrentValue = $this->Hijos_Hombres_Menores_5->FormValue;
		$this->Embarazo_Actual->CurrentValue = $this->Embarazo_Actual->FormValue;
		$this->Antecedentes_Embarazo->CurrentValue = $this->Antecedentes_Embarazo->FormValue;
		$this->Numero_Semanas_Embarazo->CurrentValue = $this->Numero_Semanas_Embarazo->FormValue;
		$this->Candidiasis_esofagica->CurrentValue = $this->Candidiasis_esofagica->FormValue;
		$this->Candidiasis_vias_aereas->CurrentValue = $this->Candidiasis_vias_aereas->FormValue;
		$this->Tuberculosis_pulmonar->CurrentValue = $this->Tuberculosis_pulmonar->FormValue;
		$this->Cancer_cervical->CurrentValue = $this->Cancer_cervical->FormValue;
		$this->Tuberculosis_extrapulmonar->CurrentValue = $this->Tuberculosis_extrapulmonar->FormValue;
		$this->Coccidiomicosis->CurrentValue = $this->Coccidiomicosis->FormValue;
		$this->Citomegalovirosis->CurrentValue = $this->Citomegalovirosis->FormValue;
		$this->Retinitis_citomegalovirosis->CurrentValue = $this->Retinitis_citomegalovirosis->FormValue;
		$this->Encefalopatia->CurrentValue = $this->Encefalopatia->FormValue;
		$this->Otras_micobacterias->CurrentValue = $this->Otras_micobacterias->FormValue;
		$this->Histoplasmosis_Extrapulmonar->CurrentValue = $this->Histoplasmosis_Extrapulmonar->FormValue;
		$this->isosporidiasis_cronica->CurrentValue = $this->isosporidiasis_cronica->FormValue;
		$this->herpes_zoster->CurrentValue = $this->herpes_zoster->FormValue;
		$this->Histoplasmosis_diseminada->CurrentValue = $this->Histoplasmosis_diseminada->FormValue;
		$this->Linfoma_Burkitt->CurrentValue = $this->Linfoma_Burkitt->FormValue;
		$this->Neumonia_Pneumocystis->CurrentValue = $this->Neumonia_Pneumocystis->FormValue;
		$this->Neumonia_Recurrente->CurrentValue = $this->Neumonia_Recurrente->FormValue;
		$this->Linfoma_Inmunoblastico->CurrentValue = $this->Linfoma_Inmunoblastico->FormValue;
		$this->Criptosporidiasis_cronica->CurrentValue = $this->Criptosporidiasis_cronica->FormValue;
		$this->Criptococosis_Extrapulmonar->CurrentValue = $this->Criptococosis_Extrapulmonar->FormValue;
		$this->Sarcoma_Kaposi->CurrentValue = $this->Sarcoma_Kaposi->FormValue;
		$this->Sindrome_Emanciacion->CurrentValue = $this->Sindrome_Emanciacion->FormValue;
		$this->Leucoencefalopatia_Multifocal->CurrentValue = $this->Leucoencefalopatia_Multifocal->FormValue;
		$this->Septicemia_recurrente->CurrentValue = $this->Septicemia_recurrente->FormValue;
		$this->Toxoplasmosis_cerebral->CurrentValue = $this->Toxoplasmosis_cerebral->FormValue;
		$this->HepatitisB->CurrentValue = $this->HepatitisB->FormValue;
		$this->HepatitisC->CurrentValue = $this->HepatitisC->FormValue;
		$this->Meningitis->CurrentValue = $this->Meningitis->FormValue;
		$this->RecuentoCD4->CurrentValue = $this->RecuentoCD4->FormValue;
		$this->Registrado_Por->CurrentValue = $this->Registrado_Por->FormValue;
		$this->Actualmente_Seguimiento->CurrentValue = $this->Actualmente_Seguimiento->FormValue;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Seguimiento->setDbValue($rs->fields('Seguimiento'));
		$this->Primer_Nombre->setDbValue($rs->fields('Primer_Nombre'));
		$this->Segundo_Nombre->setDbValue($rs->fields('Segundo_Nombre'));
		$this->Primer_Apellido->setDbValue($rs->fields('Primer_Apellido'));
		$this->Segundo_Apellido->setDbValue($rs->fields('Segundo_Apellido'));
		$this->Tipo_Id->setDbValue($rs->fields('Tipo_Id'));
		$this->Numero_Identificacion->setDbValue($rs->fields('Numero_Identificacion'));
		$this->Telefono->setDbValue($rs->fields('Telefono'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Unidad_Edad->setDbValue($rs->fields('Unidad_Edad'));
		$this->Sexo->setDbValue($rs->fields('Sexo'));
		$this->Pais_Ocurrencia->setDbValue($rs->fields('Pais_Ocurrencia'));
		$this->Depto_Ocurrencia->setDbValue($rs->fields('Depto_Ocurrencia'));
		$this->Municipio_Ocurrencia->setDbValue($rs->fields('Municipio_Ocurrencia'));
		$this->Area_Ocurrencia->setDbValue($rs->fields('Area_Ocurrencia'));
		$this->Localidad->setDbValue($rs->fields('Localidad'));
		$this->Centro_Poblado->setDbValue($rs->fields('Centro_Poblado'));
		$this->Vereda->setDbValue($rs->fields('Vereda'));
		$this->Barrio->setDbValue($rs->fields('Barrio'));
		$this->Direccion_Residencia->setDbValue($rs->fields('Direccion_Residencia'));
		$this->Ocupacion->setDbValue($rs->fields('Ocupacion'));
		$this->Tipo_Regimen_Salud->setDbValue($rs->fields('Tipo_Regimen_Salud'));
		$this->Cod_Administradora->setDbValue($rs->fields('Cod_Administradora'));
		$this->Pertenencia_Etnica->setDbValue($rs->fields('Pertenencia_Etnica'));
		$this->Grupo_Poblacional->setDbValue($rs->fields('Grupo_Poblacional'));
		$this->Depto_Residencia->setDbValue($rs->fields('Depto_Residencia'));
		$this->Municipio_Residencia->setDbValue($rs->fields('Municipio_Residencia'));
		$this->Fecha_Consulta->setDbValue($rs->fields('Fecha_Consulta'));
		$this->Fecha_Inicio_Sintomas->setDbValue($rs->fields('Fecha_Inicio_Sintomas'));
		$this->Clasificacion_Inicial->setDbValue($rs->fields('Clasificacion_Inicial'));
		$this->Hospitalizado->setDbValue($rs->fields('Hospitalizado'));
		$this->Fecha_Hospitalizacion->setDbValue($rs->fields('Fecha_Hospitalizacion'));
		$this->Condicion_Final->setDbValue($rs->fields('Condicion_Final'));
		$this->Fecha_Defuncion->setDbValue($rs->fields('Fecha_Defuncion'));
		$this->Numero_Certificado_Defuncion->setDbValue($rs->fields('Numero_Certificado_Defuncion'));
		$this->Causa_Basica_Muerte_CIEX->setDbValue($rs->fields('Causa_Basica_Muerte_CIEX'));
		$this->Nombre_Profesional_Diligencia->setDbValue($rs->fields('Nombre_Profesional_Diligencia'));
		$this->Telefono_Profesional_Diligencia->setDbValue($rs->fields('Telefono_Profesional_Diligencia'));
		$this->Seguimiento_Clasificacion_Final->setDbValue($rs->fields('Seguimiento_Clasificacion_Final'));
		$this->Fecha_Ajuste->setDbValue($rs->fields('Fecha_Ajuste'));
		$this->Codigo_UPGD->setDbValue($rs->fields('Codigo_UPGD'));
		$this->Nombre_Evento->setDbValue($rs->fields('Nombre_Evento'));
		$this->Cod_Evento->setDbValue($rs->fields('Cod_Evento'));
		$this->Fecha_Notificacion->setDbValue($rs->fields('Fecha_Notificacion'));
		$this->Semana->setDbValue($rs->fields('Semana'));
		$this->Mecanismo_Probable_Transmision->setDbValue($rs->fields('Mecanismo_Probable_Transmision'));
		$this->Nombre_Madre->setDbValue($rs->fields('Nombre_Madre'));
		$this->Tipo_Id_Madre->setDbValue($rs->fields('Tipo_Id_Madre'));
		$this->Numero_Identificacion_Madre->setDbValue($rs->fields('Numero_Identificacion_Madre'));
		$this->Indentidad_Genero->setDbValue($rs->fields('Indentidad_Genero'));
		$this->Donador_Sangre_Ultimos_12_Meses->setDbValue($rs->fields('Donador_Sangre_Ultimos_12_Meses'));
		$this->Fecha_Donacion->setDbValue($rs->fields('Fecha_Donacion'));
		$this->Nombre_Institucion_Donacion->setDbValue($rs->fields('Nombre_Institucion_Donacion'));
		$this->Recibio_Asesoria_Pre_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Pre_Prueba'));
		$this->Recibio_Asesoria_Post_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Post_Prueba'));
		$this->Tipo_Prueba->setDbValue($rs->fields('Tipo_Prueba'));
		$this->Fecha_Resultado_Confirmatorio->setDbValue($rs->fields('Fecha_Resultado_Confirmatorio'));
		$this->Valor_Carga_Viral->setDbValue($rs->fields('Valor_Carga_Viral'));
		$this->Estado_Clinico_Notificacion->setDbValue($rs->fields('Estado_Clinico_Notificacion'));
		$this->Hijos_Mujeres_Menores_5->setDbValue($rs->fields('Hijos_Mujeres_Menores_5'));
		$this->Hijos_Hombres_Menores_5->setDbValue($rs->fields('Hijos_Hombres_Menores_5'));
		$this->Embarazo_Actual->setDbValue($rs->fields('Embarazo_Actual'));
		$this->Antecedentes_Embarazo->setDbValue($rs->fields('Antecedentes_Embarazo'));
		$this->Numero_Semanas_Embarazo->setDbValue($rs->fields('Numero_Semanas_Embarazo'));
		$this->Candidiasis_esofagica->setDbValue($rs->fields('Candidiasis_esofagica'));
		$this->Candidiasis_vias_aereas->setDbValue($rs->fields('Candidiasis_vias_aereas'));
		$this->Tuberculosis_pulmonar->setDbValue($rs->fields('Tuberculosis_pulmonar'));
		$this->Cancer_cervical->setDbValue($rs->fields('Cancer_cervical'));
		$this->Tuberculosis_extrapulmonar->setDbValue($rs->fields('Tuberculosis_extrapulmonar'));
		$this->Coccidiomicosis->setDbValue($rs->fields('Coccidiomicosis'));
		$this->Citomegalovirosis->setDbValue($rs->fields('Citomegalovirosis'));
		$this->Retinitis_citomegalovirosis->setDbValue($rs->fields('Retinitis_citomegalovirosis'));
		$this->Encefalopatia->setDbValue($rs->fields('Encefalopatia'));
		$this->Otras_micobacterias->setDbValue($rs->fields('Otras_micobacterias'));
		$this->Histoplasmosis_Extrapulmonar->setDbValue($rs->fields('Histoplasmosis_Extrapulmonar'));
		$this->isosporidiasis_cronica->setDbValue($rs->fields('isosporidiasis_cronica'));
		$this->herpes_zoster->setDbValue($rs->fields('herpes_zoster'));
		$this->Histoplasmosis_diseminada->setDbValue($rs->fields('Histoplasmosis_diseminada'));
		$this->Linfoma_Burkitt->setDbValue($rs->fields('Linfoma_Burkitt'));
		$this->Neumonia_Pneumocystis->setDbValue($rs->fields('Neumonia_Pneumocystis'));
		$this->Neumonia_Recurrente->setDbValue($rs->fields('Neumonia_Recurrente'));
		$this->Linfoma_Inmunoblastico->setDbValue($rs->fields('Linfoma_Inmunoblastico'));
		$this->Criptosporidiasis_cronica->setDbValue($rs->fields('Criptosporidiasis_cronica'));
		$this->Criptococosis_Extrapulmonar->setDbValue($rs->fields('Criptococosis_Extrapulmonar'));
		$this->Sarcoma_Kaposi->setDbValue($rs->fields('Sarcoma_Kaposi'));
		$this->Sindrome_Emanciacion->setDbValue($rs->fields('Sindrome_Emanciacion'));
		$this->Leucoencefalopatia_Multifocal->setDbValue($rs->fields('Leucoencefalopatia_Multifocal'));
		$this->Septicemia_recurrente->setDbValue($rs->fields('Septicemia_recurrente'));
		$this->Toxoplasmosis_cerebral->setDbValue($rs->fields('Toxoplasmosis_cerebral'));
		$this->HepatitisB->setDbValue($rs->fields('HepatitisB'));
		$this->HepatitisC->setDbValue($rs->fields('HepatitisC'));
		$this->Meningitis->setDbValue($rs->fields('Meningitis'));
		$this->RecuentoCD4->setDbValue($rs->fields('RecuentoCD4'));
		$this->Registrado_Por->setDbValue($rs->fields('Registrado_Por'));
		$this->Actualmente_Seguimiento->setDbValue($rs->fields('Actualmente_Seguimiento'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Consecutivo->DbValue = $row['Consecutivo'];
		$this->Seguimiento->DbValue = $row['Seguimiento'];
		$this->Primer_Nombre->DbValue = $row['Primer_Nombre'];
		$this->Segundo_Nombre->DbValue = $row['Segundo_Nombre'];
		$this->Primer_Apellido->DbValue = $row['Primer_Apellido'];
		$this->Segundo_Apellido->DbValue = $row['Segundo_Apellido'];
		$this->Tipo_Id->DbValue = $row['Tipo_Id'];
		$this->Numero_Identificacion->DbValue = $row['Numero_Identificacion'];
		$this->Telefono->DbValue = $row['Telefono'];
		$this->Fecha_Nacimiento->DbValue = $row['Fecha_Nacimiento'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Unidad_Edad->DbValue = $row['Unidad_Edad'];
		$this->Sexo->DbValue = $row['Sexo'];
		$this->Pais_Ocurrencia->DbValue = $row['Pais_Ocurrencia'];
		$this->Depto_Ocurrencia->DbValue = $row['Depto_Ocurrencia'];
		$this->Municipio_Ocurrencia->DbValue = $row['Municipio_Ocurrencia'];
		$this->Area_Ocurrencia->DbValue = $row['Area_Ocurrencia'];
		$this->Localidad->DbValue = $row['Localidad'];
		$this->Centro_Poblado->DbValue = $row['Centro_Poblado'];
		$this->Vereda->DbValue = $row['Vereda'];
		$this->Barrio->DbValue = $row['Barrio'];
		$this->Direccion_Residencia->DbValue = $row['Direccion_Residencia'];
		$this->Ocupacion->DbValue = $row['Ocupacion'];
		$this->Tipo_Regimen_Salud->DbValue = $row['Tipo_Regimen_Salud'];
		$this->Cod_Administradora->DbValue = $row['Cod_Administradora'];
		$this->Pertenencia_Etnica->DbValue = $row['Pertenencia_Etnica'];
		$this->Grupo_Poblacional->DbValue = $row['Grupo_Poblacional'];
		$this->Depto_Residencia->DbValue = $row['Depto_Residencia'];
		$this->Municipio_Residencia->DbValue = $row['Municipio_Residencia'];
		$this->Fecha_Consulta->DbValue = $row['Fecha_Consulta'];
		$this->Fecha_Inicio_Sintomas->DbValue = $row['Fecha_Inicio_Sintomas'];
		$this->Clasificacion_Inicial->DbValue = $row['Clasificacion_Inicial'];
		$this->Hospitalizado->DbValue = $row['Hospitalizado'];
		$this->Fecha_Hospitalizacion->DbValue = $row['Fecha_Hospitalizacion'];
		$this->Condicion_Final->DbValue = $row['Condicion_Final'];
		$this->Fecha_Defuncion->DbValue = $row['Fecha_Defuncion'];
		$this->Numero_Certificado_Defuncion->DbValue = $row['Numero_Certificado_Defuncion'];
		$this->Causa_Basica_Muerte_CIEX->DbValue = $row['Causa_Basica_Muerte_CIEX'];
		$this->Nombre_Profesional_Diligencia->DbValue = $row['Nombre_Profesional_Diligencia'];
		$this->Telefono_Profesional_Diligencia->DbValue = $row['Telefono_Profesional_Diligencia'];
		$this->Seguimiento_Clasificacion_Final->DbValue = $row['Seguimiento_Clasificacion_Final'];
		$this->Fecha_Ajuste->DbValue = $row['Fecha_Ajuste'];
		$this->Codigo_UPGD->DbValue = $row['Codigo_UPGD'];
		$this->Nombre_Evento->DbValue = $row['Nombre_Evento'];
		$this->Cod_Evento->DbValue = $row['Cod_Evento'];
		$this->Fecha_Notificacion->DbValue = $row['Fecha_Notificacion'];
		$this->Semana->DbValue = $row['Semana'];
		$this->Mecanismo_Probable_Transmision->DbValue = $row['Mecanismo_Probable_Transmision'];
		$this->Nombre_Madre->DbValue = $row['Nombre_Madre'];
		$this->Tipo_Id_Madre->DbValue = $row['Tipo_Id_Madre'];
		$this->Numero_Identificacion_Madre->DbValue = $row['Numero_Identificacion_Madre'];
		$this->Indentidad_Genero->DbValue = $row['Indentidad_Genero'];
		$this->Donador_Sangre_Ultimos_12_Meses->DbValue = $row['Donador_Sangre_Ultimos_12_Meses'];
		$this->Fecha_Donacion->DbValue = $row['Fecha_Donacion'];
		$this->Nombre_Institucion_Donacion->DbValue = $row['Nombre_Institucion_Donacion'];
		$this->Recibio_Asesoria_Pre_Prueba->DbValue = $row['Recibio_Asesoria_Pre_Prueba'];
		$this->Recibio_Asesoria_Post_Prueba->DbValue = $row['Recibio_Asesoria_Post_Prueba'];
		$this->Tipo_Prueba->DbValue = $row['Tipo_Prueba'];
		$this->Fecha_Resultado_Confirmatorio->DbValue = $row['Fecha_Resultado_Confirmatorio'];
		$this->Valor_Carga_Viral->DbValue = $row['Valor_Carga_Viral'];
		$this->Estado_Clinico_Notificacion->DbValue = $row['Estado_Clinico_Notificacion'];
		$this->Hijos_Mujeres_Menores_5->DbValue = $row['Hijos_Mujeres_Menores_5'];
		$this->Hijos_Hombres_Menores_5->DbValue = $row['Hijos_Hombres_Menores_5'];
		$this->Embarazo_Actual->DbValue = $row['Embarazo_Actual'];
		$this->Antecedentes_Embarazo->DbValue = $row['Antecedentes_Embarazo'];
		$this->Numero_Semanas_Embarazo->DbValue = $row['Numero_Semanas_Embarazo'];
		$this->Candidiasis_esofagica->DbValue = $row['Candidiasis_esofagica'];
		$this->Candidiasis_vias_aereas->DbValue = $row['Candidiasis_vias_aereas'];
		$this->Tuberculosis_pulmonar->DbValue = $row['Tuberculosis_pulmonar'];
		$this->Cancer_cervical->DbValue = $row['Cancer_cervical'];
		$this->Tuberculosis_extrapulmonar->DbValue = $row['Tuberculosis_extrapulmonar'];
		$this->Coccidiomicosis->DbValue = $row['Coccidiomicosis'];
		$this->Citomegalovirosis->DbValue = $row['Citomegalovirosis'];
		$this->Retinitis_citomegalovirosis->DbValue = $row['Retinitis_citomegalovirosis'];
		$this->Encefalopatia->DbValue = $row['Encefalopatia'];
		$this->Otras_micobacterias->DbValue = $row['Otras_micobacterias'];
		$this->Histoplasmosis_Extrapulmonar->DbValue = $row['Histoplasmosis_Extrapulmonar'];
		$this->isosporidiasis_cronica->DbValue = $row['isosporidiasis_cronica'];
		$this->herpes_zoster->DbValue = $row['herpes_zoster'];
		$this->Histoplasmosis_diseminada->DbValue = $row['Histoplasmosis_diseminada'];
		$this->Linfoma_Burkitt->DbValue = $row['Linfoma_Burkitt'];
		$this->Neumonia_Pneumocystis->DbValue = $row['Neumonia_Pneumocystis'];
		$this->Neumonia_Recurrente->DbValue = $row['Neumonia_Recurrente'];
		$this->Linfoma_Inmunoblastico->DbValue = $row['Linfoma_Inmunoblastico'];
		$this->Criptosporidiasis_cronica->DbValue = $row['Criptosporidiasis_cronica'];
		$this->Criptococosis_Extrapulmonar->DbValue = $row['Criptococosis_Extrapulmonar'];
		$this->Sarcoma_Kaposi->DbValue = $row['Sarcoma_Kaposi'];
		$this->Sindrome_Emanciacion->DbValue = $row['Sindrome_Emanciacion'];
		$this->Leucoencefalopatia_Multifocal->DbValue = $row['Leucoencefalopatia_Multifocal'];
		$this->Septicemia_recurrente->DbValue = $row['Septicemia_recurrente'];
		$this->Toxoplasmosis_cerebral->DbValue = $row['Toxoplasmosis_cerebral'];
		$this->HepatitisB->DbValue = $row['HepatitisB'];
		$this->HepatitisC->DbValue = $row['HepatitisC'];
		$this->Meningitis->DbValue = $row['Meningitis'];
		$this->RecuentoCD4->DbValue = $row['RecuentoCD4'];
		$this->Registrado_Por->DbValue = $row['Registrado_Por'];
		$this->Actualmente_Seguimiento->DbValue = $row['Actualmente_Seguimiento'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Consecutivo
		// Seguimiento
		// Primer_Nombre
		// Segundo_Nombre
		// Primer_Apellido
		// Segundo_Apellido
		// Tipo_Id
		// Numero_Identificacion
		// Telefono
		// Fecha_Nacimiento
		// Edad
		// Unidad_Edad
		// Sexo
		// Pais_Ocurrencia
		// Depto_Ocurrencia
		// Municipio_Ocurrencia
		// Area_Ocurrencia
		// Localidad
		// Centro_Poblado
		// Vereda
		// Barrio
		// Direccion_Residencia
		// Ocupacion
		// Tipo_Regimen_Salud
		// Cod_Administradora
		// Pertenencia_Etnica
		// Grupo_Poblacional
		// Depto_Residencia
		// Municipio_Residencia
		// Fecha_Consulta
		// Fecha_Inicio_Sintomas
		// Clasificacion_Inicial
		// Hospitalizado
		// Fecha_Hospitalizacion
		// Condicion_Final
		// Fecha_Defuncion
		// Numero_Certificado_Defuncion
		// Causa_Basica_Muerte_CIEX
		// Nombre_Profesional_Diligencia
		// Telefono_Profesional_Diligencia
		// Seguimiento_Clasificacion_Final
		// Fecha_Ajuste
		// Codigo_UPGD
		// Nombre_Evento
		// Cod_Evento
		// Fecha_Notificacion
		// Semana
		// Mecanismo_Probable_Transmision
		// Nombre_Madre
		// Tipo_Id_Madre
		// Numero_Identificacion_Madre
		// Indentidad_Genero
		// Donador_Sangre_Ultimos_12_Meses
		// Fecha_Donacion
		// Nombre_Institucion_Donacion
		// Recibio_Asesoria_Pre_Prueba
		// Recibio_Asesoria_Post_Prueba
		// Tipo_Prueba
		// Fecha_Resultado_Confirmatorio
		// Valor_Carga_Viral
		// Estado_Clinico_Notificacion
		// Hijos_Mujeres_Menores_5
		// Hijos_Hombres_Menores_5
		// Embarazo_Actual
		// Antecedentes_Embarazo
		// Numero_Semanas_Embarazo
		// Candidiasis_esofagica
		// Candidiasis_vias_aereas
		// Tuberculosis_pulmonar
		// Cancer_cervical
		// Tuberculosis_extrapulmonar
		// Coccidiomicosis
		// Citomegalovirosis
		// Retinitis_citomegalovirosis
		// Encefalopatia
		// Otras_micobacterias
		// Histoplasmosis_Extrapulmonar
		// isosporidiasis_cronica
		// herpes_zoster
		// Histoplasmosis_diseminada
		// Linfoma_Burkitt
		// Neumonia_Pneumocystis
		// Neumonia_Recurrente
		// Linfoma_Inmunoblastico
		// Criptosporidiasis_cronica
		// Criptococosis_Extrapulmonar
		// Sarcoma_Kaposi
		// Sindrome_Emanciacion
		// Leucoencefalopatia_Multifocal
		// Septicemia_recurrente
		// Toxoplasmosis_cerebral
		// HepatitisB
		// HepatitisC
		// Meningitis
		// RecuentoCD4
		// Registrado_Por
		// Actualmente_Seguimiento

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Consecutivo
		$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
		$this->Consecutivo->ViewCustomAttributes = "";

		// Seguimiento
		$this->Seguimiento->ViewValue = $this->Seguimiento->CurrentValue;
		$this->Seguimiento->ViewCustomAttributes = "";

		// Primer_Nombre
		$this->Primer_Nombre->ViewValue = $this->Primer_Nombre->CurrentValue;
		$this->Primer_Nombre->ViewCustomAttributes = "";

		// Segundo_Nombre
		$this->Segundo_Nombre->ViewValue = $this->Segundo_Nombre->CurrentValue;
		$this->Segundo_Nombre->ViewCustomAttributes = "";

		// Primer_Apellido
		$this->Primer_Apellido->ViewValue = $this->Primer_Apellido->CurrentValue;
		$this->Primer_Apellido->ViewCustomAttributes = "";

		// Segundo_Apellido
		$this->Segundo_Apellido->ViewValue = $this->Segundo_Apellido->CurrentValue;
		$this->Segundo_Apellido->ViewCustomAttributes = "";

		// Tipo_Id
		$this->Tipo_Id->ViewValue = $this->Tipo_Id->CurrentValue;
		$this->Tipo_Id->ViewCustomAttributes = "";

		// Numero_Identificacion
		$this->Numero_Identificacion->ViewValue = $this->Numero_Identificacion->CurrentValue;
		$this->Numero_Identificacion->ViewCustomAttributes = "";

		// Telefono
		$this->Telefono->ViewValue = $this->Telefono->CurrentValue;
		$this->Telefono->ViewCustomAttributes = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
		$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 5);
		$this->Fecha_Nacimiento->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Unidad_Edad
		$this->Unidad_Edad->ViewValue = $this->Unidad_Edad->CurrentValue;
		$this->Unidad_Edad->ViewCustomAttributes = "";

		// Sexo
		$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
		$this->Sexo->ViewCustomAttributes = "";

		// Pais_Ocurrencia
		$this->Pais_Ocurrencia->ViewValue = $this->Pais_Ocurrencia->CurrentValue;
		$this->Pais_Ocurrencia->ViewCustomAttributes = "";

		// Depto_Ocurrencia
		$this->Depto_Ocurrencia->ViewValue = $this->Depto_Ocurrencia->CurrentValue;
		$this->Depto_Ocurrencia->ViewCustomAttributes = "";

		// Municipio_Ocurrencia
		$this->Municipio_Ocurrencia->ViewValue = $this->Municipio_Ocurrencia->CurrentValue;
		$this->Municipio_Ocurrencia->ViewCustomAttributes = "";

		// Area_Ocurrencia
		$this->Area_Ocurrencia->ViewValue = $this->Area_Ocurrencia->CurrentValue;
		$this->Area_Ocurrencia->ViewCustomAttributes = "";

		// Localidad
		$this->Localidad->ViewValue = $this->Localidad->CurrentValue;
		$this->Localidad->ViewCustomAttributes = "";

		// Centro_Poblado
		$this->Centro_Poblado->ViewValue = $this->Centro_Poblado->CurrentValue;
		$this->Centro_Poblado->ViewCustomAttributes = "";

		// Vereda
		$this->Vereda->ViewValue = $this->Vereda->CurrentValue;
		$this->Vereda->ViewCustomAttributes = "";

		// Barrio
		$this->Barrio->ViewValue = $this->Barrio->CurrentValue;
		$this->Barrio->ViewCustomAttributes = "";

		// Direccion_Residencia
		$this->Direccion_Residencia->ViewValue = $this->Direccion_Residencia->CurrentValue;
		$this->Direccion_Residencia->ViewCustomAttributes = "";

		// Ocupacion
		$this->Ocupacion->ViewValue = $this->Ocupacion->CurrentValue;
		$this->Ocupacion->ViewCustomAttributes = "";

		// Tipo_Regimen_Salud
		$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->CurrentValue;
		$this->Tipo_Regimen_Salud->ViewCustomAttributes = "";

		// Cod_Administradora
		$this->Cod_Administradora->ViewValue = $this->Cod_Administradora->CurrentValue;
		$this->Cod_Administradora->ViewCustomAttributes = "";

		// Pertenencia_Etnica
		$this->Pertenencia_Etnica->ViewValue = $this->Pertenencia_Etnica->CurrentValue;
		$this->Pertenencia_Etnica->ViewCustomAttributes = "";

		// Grupo_Poblacional
		$this->Grupo_Poblacional->ViewValue = $this->Grupo_Poblacional->CurrentValue;
		$this->Grupo_Poblacional->ViewCustomAttributes = "";

		// Depto_Residencia
		$this->Depto_Residencia->ViewValue = $this->Depto_Residencia->CurrentValue;
		$this->Depto_Residencia->ViewCustomAttributes = "";

		// Municipio_Residencia
		$this->Municipio_Residencia->ViewValue = $this->Municipio_Residencia->CurrentValue;
		$this->Municipio_Residencia->ViewCustomAttributes = "";

		// Fecha_Consulta
		$this->Fecha_Consulta->ViewValue = $this->Fecha_Consulta->CurrentValue;
		$this->Fecha_Consulta->ViewValue = ew_FormatDateTime($this->Fecha_Consulta->ViewValue, 5);
		$this->Fecha_Consulta->ViewCustomAttributes = "";

		// Fecha_Inicio_Sintomas
		$this->Fecha_Inicio_Sintomas->ViewValue = $this->Fecha_Inicio_Sintomas->CurrentValue;
		$this->Fecha_Inicio_Sintomas->ViewValue = ew_FormatDateTime($this->Fecha_Inicio_Sintomas->ViewValue, 5);
		$this->Fecha_Inicio_Sintomas->ViewCustomAttributes = "";

		// Clasificacion_Inicial
		$this->Clasificacion_Inicial->ViewValue = $this->Clasificacion_Inicial->CurrentValue;
		$this->Clasificacion_Inicial->ViewCustomAttributes = "";

		// Hospitalizado
		$this->Hospitalizado->ViewValue = $this->Hospitalizado->CurrentValue;
		$this->Hospitalizado->ViewCustomAttributes = "";

		// Fecha_Hospitalizacion
		$this->Fecha_Hospitalizacion->ViewValue = $this->Fecha_Hospitalizacion->CurrentValue;
		$this->Fecha_Hospitalizacion->ViewValue = ew_FormatDateTime($this->Fecha_Hospitalizacion->ViewValue, 5);
		$this->Fecha_Hospitalizacion->ViewCustomAttributes = "";

		// Condicion_Final
		$this->Condicion_Final->ViewValue = $this->Condicion_Final->CurrentValue;
		$this->Condicion_Final->ViewCustomAttributes = "";

		// Fecha_Defuncion
		$this->Fecha_Defuncion->ViewValue = $this->Fecha_Defuncion->CurrentValue;
		$this->Fecha_Defuncion->ViewValue = ew_FormatDateTime($this->Fecha_Defuncion->ViewValue, 5);
		$this->Fecha_Defuncion->ViewCustomAttributes = "";

		// Numero_Certificado_Defuncion
		$this->Numero_Certificado_Defuncion->ViewValue = $this->Numero_Certificado_Defuncion->CurrentValue;
		$this->Numero_Certificado_Defuncion->ViewCustomAttributes = "";

		// Causa_Basica_Muerte_CIEX
		$this->Causa_Basica_Muerte_CIEX->ViewValue = $this->Causa_Basica_Muerte_CIEX->CurrentValue;
		$this->Causa_Basica_Muerte_CIEX->ViewCustomAttributes = "";

		// Nombre_Profesional_Diligencia
		$this->Nombre_Profesional_Diligencia->ViewValue = $this->Nombre_Profesional_Diligencia->CurrentValue;
		$this->Nombre_Profesional_Diligencia->ViewCustomAttributes = "";

		// Telefono_Profesional_Diligencia
		$this->Telefono_Profesional_Diligencia->ViewValue = $this->Telefono_Profesional_Diligencia->CurrentValue;
		$this->Telefono_Profesional_Diligencia->ViewCustomAttributes = "";

		// Seguimiento_Clasificacion_Final
		$this->Seguimiento_Clasificacion_Final->ViewValue = $this->Seguimiento_Clasificacion_Final->CurrentValue;
		$this->Seguimiento_Clasificacion_Final->ViewCustomAttributes = "";

		// Fecha_Ajuste
		$this->Fecha_Ajuste->ViewValue = $this->Fecha_Ajuste->CurrentValue;
		$this->Fecha_Ajuste->ViewValue = ew_FormatDateTime($this->Fecha_Ajuste->ViewValue, 5);
		$this->Fecha_Ajuste->ViewCustomAttributes = "";

		// Codigo_UPGD
		$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->CurrentValue;
		$this->Codigo_UPGD->ViewCustomAttributes = "";

		// Nombre_Evento
		$this->Nombre_Evento->ViewValue = $this->Nombre_Evento->CurrentValue;
		$this->Nombre_Evento->ViewCustomAttributes = "";

		// Cod_Evento
		$this->Cod_Evento->ViewValue = $this->Cod_Evento->CurrentValue;
		$this->Cod_Evento->ViewCustomAttributes = "";

		// Fecha_Notificacion
		$this->Fecha_Notificacion->ViewValue = $this->Fecha_Notificacion->CurrentValue;
		$this->Fecha_Notificacion->ViewValue = ew_FormatDateTime($this->Fecha_Notificacion->ViewValue, 5);
		$this->Fecha_Notificacion->ViewCustomAttributes = "";

		// Semana
		$this->Semana->ViewValue = $this->Semana->CurrentValue;
		$this->Semana->ViewCustomAttributes = "";

		// Mecanismo_Probable_Transmision
		$this->Mecanismo_Probable_Transmision->ViewValue = $this->Mecanismo_Probable_Transmision->CurrentValue;
		$this->Mecanismo_Probable_Transmision->ViewCustomAttributes = "";

		// Nombre_Madre
		$this->Nombre_Madre->ViewValue = $this->Nombre_Madre->CurrentValue;
		$this->Nombre_Madre->ViewCustomAttributes = "";

		// Tipo_Id_Madre
		$this->Tipo_Id_Madre->ViewValue = $this->Tipo_Id_Madre->CurrentValue;
		$this->Tipo_Id_Madre->ViewCustomAttributes = "";

		// Numero_Identificacion_Madre
		$this->Numero_Identificacion_Madre->ViewValue = $this->Numero_Identificacion_Madre->CurrentValue;
		$this->Numero_Identificacion_Madre->ViewCustomAttributes = "";

		// Indentidad_Genero
		$this->Indentidad_Genero->ViewValue = $this->Indentidad_Genero->CurrentValue;
		$this->Indentidad_Genero->ViewCustomAttributes = "";

		// Donador_Sangre_Ultimos_12_Meses
		$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue;
		$this->Donador_Sangre_Ultimos_12_Meses->ViewCustomAttributes = "";

		// Fecha_Donacion
		$this->Fecha_Donacion->ViewValue = $this->Fecha_Donacion->CurrentValue;
		$this->Fecha_Donacion->ViewValue = ew_FormatDateTime($this->Fecha_Donacion->ViewValue, 5);
		$this->Fecha_Donacion->ViewCustomAttributes = "";

		// Nombre_Institucion_Donacion
		$this->Nombre_Institucion_Donacion->ViewValue = $this->Nombre_Institucion_Donacion->CurrentValue;
		$this->Nombre_Institucion_Donacion->ViewCustomAttributes = "";

		// Recibio_Asesoria_Pre_Prueba
		$this->Recibio_Asesoria_Pre_Prueba->ViewValue = $this->Recibio_Asesoria_Pre_Prueba->CurrentValue;
		$this->Recibio_Asesoria_Pre_Prueba->ViewCustomAttributes = "";

		// Recibio_Asesoria_Post_Prueba
		$this->Recibio_Asesoria_Post_Prueba->ViewValue = $this->Recibio_Asesoria_Post_Prueba->CurrentValue;
		$this->Recibio_Asesoria_Post_Prueba->ViewCustomAttributes = "";

		// Tipo_Prueba
		$this->Tipo_Prueba->ViewValue = $this->Tipo_Prueba->CurrentValue;
		$this->Tipo_Prueba->ViewCustomAttributes = "";

		// Fecha_Resultado_Confirmatorio
		$this->Fecha_Resultado_Confirmatorio->ViewValue = $this->Fecha_Resultado_Confirmatorio->CurrentValue;
		$this->Fecha_Resultado_Confirmatorio->ViewValue = ew_FormatDateTime($this->Fecha_Resultado_Confirmatorio->ViewValue, 5);
		$this->Fecha_Resultado_Confirmatorio->ViewCustomAttributes = "";

		// Valor_Carga_Viral
		$this->Valor_Carga_Viral->ViewValue = $this->Valor_Carga_Viral->CurrentValue;
		$this->Valor_Carga_Viral->ViewCustomAttributes = "";

		// Estado_Clinico_Notificacion
		$this->Estado_Clinico_Notificacion->ViewValue = $this->Estado_Clinico_Notificacion->CurrentValue;
		$this->Estado_Clinico_Notificacion->ViewCustomAttributes = "";

		// Hijos_Mujeres_Menores_5
		$this->Hijos_Mujeres_Menores_5->ViewValue = $this->Hijos_Mujeres_Menores_5->CurrentValue;
		$this->Hijos_Mujeres_Menores_5->ViewCustomAttributes = "";

		// Hijos_Hombres_Menores_5
		$this->Hijos_Hombres_Menores_5->ViewValue = $this->Hijos_Hombres_Menores_5->CurrentValue;
		$this->Hijos_Hombres_Menores_5->ViewCustomAttributes = "";

		// Embarazo_Actual
		$this->Embarazo_Actual->ViewValue = $this->Embarazo_Actual->CurrentValue;
		$this->Embarazo_Actual->ViewCustomAttributes = "";

		// Antecedentes_Embarazo
		$this->Antecedentes_Embarazo->ViewValue = $this->Antecedentes_Embarazo->CurrentValue;
		$this->Antecedentes_Embarazo->ViewCustomAttributes = "";

		// Numero_Semanas_Embarazo
		$this->Numero_Semanas_Embarazo->ViewValue = $this->Numero_Semanas_Embarazo->CurrentValue;
		$this->Numero_Semanas_Embarazo->ViewCustomAttributes = "";

		// Candidiasis_esofagica
		$this->Candidiasis_esofagica->ViewValue = $this->Candidiasis_esofagica->CurrentValue;
		$this->Candidiasis_esofagica->ViewCustomAttributes = "";

		// Candidiasis_vias_aereas
		$this->Candidiasis_vias_aereas->ViewValue = $this->Candidiasis_vias_aereas->CurrentValue;
		$this->Candidiasis_vias_aereas->ViewCustomAttributes = "";

		// Tuberculosis_pulmonar
		$this->Tuberculosis_pulmonar->ViewValue = $this->Tuberculosis_pulmonar->CurrentValue;
		$this->Tuberculosis_pulmonar->ViewCustomAttributes = "";

		// Cancer_cervical
		$this->Cancer_cervical->ViewValue = $this->Cancer_cervical->CurrentValue;
		$this->Cancer_cervical->ViewCustomAttributes = "";

		// Tuberculosis_extrapulmonar
		$this->Tuberculosis_extrapulmonar->ViewValue = $this->Tuberculosis_extrapulmonar->CurrentValue;
		$this->Tuberculosis_extrapulmonar->ViewCustomAttributes = "";

		// Coccidiomicosis
		$this->Coccidiomicosis->ViewValue = $this->Coccidiomicosis->CurrentValue;
		$this->Coccidiomicosis->ViewCustomAttributes = "";

		// Citomegalovirosis
		$this->Citomegalovirosis->ViewValue = $this->Citomegalovirosis->CurrentValue;
		$this->Citomegalovirosis->ViewCustomAttributes = "";

		// Retinitis_citomegalovirosis
		$this->Retinitis_citomegalovirosis->ViewValue = $this->Retinitis_citomegalovirosis->CurrentValue;
		$this->Retinitis_citomegalovirosis->ViewCustomAttributes = "";

		// Encefalopatia
		$this->Encefalopatia->ViewValue = $this->Encefalopatia->CurrentValue;
		$this->Encefalopatia->ViewCustomAttributes = "";

		// Otras_micobacterias
		$this->Otras_micobacterias->ViewValue = $this->Otras_micobacterias->CurrentValue;
		$this->Otras_micobacterias->ViewCustomAttributes = "";

		// Histoplasmosis_Extrapulmonar
		$this->Histoplasmosis_Extrapulmonar->ViewValue = $this->Histoplasmosis_Extrapulmonar->CurrentValue;
		$this->Histoplasmosis_Extrapulmonar->ViewCustomAttributes = "";

		// isosporidiasis_cronica
		$this->isosporidiasis_cronica->ViewValue = $this->isosporidiasis_cronica->CurrentValue;
		$this->isosporidiasis_cronica->ViewCustomAttributes = "";

		// herpes_zoster
		$this->herpes_zoster->ViewValue = $this->herpes_zoster->CurrentValue;
		$this->herpes_zoster->ViewCustomAttributes = "";

		// Histoplasmosis_diseminada
		$this->Histoplasmosis_diseminada->ViewValue = $this->Histoplasmosis_diseminada->CurrentValue;
		$this->Histoplasmosis_diseminada->ViewCustomAttributes = "";

		// Linfoma_Burkitt
		$this->Linfoma_Burkitt->ViewValue = $this->Linfoma_Burkitt->CurrentValue;
		$this->Linfoma_Burkitt->ViewCustomAttributes = "";

		// Neumonia_Pneumocystis
		$this->Neumonia_Pneumocystis->ViewValue = $this->Neumonia_Pneumocystis->CurrentValue;
		$this->Neumonia_Pneumocystis->ViewCustomAttributes = "";

		// Neumonia_Recurrente
		$this->Neumonia_Recurrente->ViewValue = $this->Neumonia_Recurrente->CurrentValue;
		$this->Neumonia_Recurrente->ViewCustomAttributes = "";

		// Linfoma_Inmunoblastico
		$this->Linfoma_Inmunoblastico->ViewValue = $this->Linfoma_Inmunoblastico->CurrentValue;
		$this->Linfoma_Inmunoblastico->ViewCustomAttributes = "";

		// Criptosporidiasis_cronica
		$this->Criptosporidiasis_cronica->ViewValue = $this->Criptosporidiasis_cronica->CurrentValue;
		$this->Criptosporidiasis_cronica->ViewCustomAttributes = "";

		// Criptococosis_Extrapulmonar
		$this->Criptococosis_Extrapulmonar->ViewValue = $this->Criptococosis_Extrapulmonar->CurrentValue;
		$this->Criptococosis_Extrapulmonar->ViewCustomAttributes = "";

		// Sarcoma_Kaposi
		$this->Sarcoma_Kaposi->ViewValue = $this->Sarcoma_Kaposi->CurrentValue;
		$this->Sarcoma_Kaposi->ViewCustomAttributes = "";

		// Sindrome_Emanciacion
		$this->Sindrome_Emanciacion->ViewValue = $this->Sindrome_Emanciacion->CurrentValue;
		$this->Sindrome_Emanciacion->ViewCustomAttributes = "";

		// Leucoencefalopatia_Multifocal
		$this->Leucoencefalopatia_Multifocal->ViewValue = $this->Leucoencefalopatia_Multifocal->CurrentValue;
		$this->Leucoencefalopatia_Multifocal->ViewCustomAttributes = "";

		// Septicemia_recurrente
		$this->Septicemia_recurrente->ViewValue = $this->Septicemia_recurrente->CurrentValue;
		$this->Septicemia_recurrente->ViewCustomAttributes = "";

		// Toxoplasmosis_cerebral
		$this->Toxoplasmosis_cerebral->ViewValue = $this->Toxoplasmosis_cerebral->CurrentValue;
		$this->Toxoplasmosis_cerebral->ViewCustomAttributes = "";

		// HepatitisB
		$this->HepatitisB->ViewValue = $this->HepatitisB->CurrentValue;
		$this->HepatitisB->ViewCustomAttributes = "";

		// HepatitisC
		$this->HepatitisC->ViewValue = $this->HepatitisC->CurrentValue;
		$this->HepatitisC->ViewCustomAttributes = "";

		// Meningitis
		$this->Meningitis->ViewValue = $this->Meningitis->CurrentValue;
		$this->Meningitis->ViewCustomAttributes = "";

		// RecuentoCD4
		$this->RecuentoCD4->ViewValue = $this->RecuentoCD4->CurrentValue;
		$this->RecuentoCD4->ViewCustomAttributes = "";

		// Registrado_Por
		$this->Registrado_Por->ViewValue = $this->Registrado_Por->CurrentValue;
		$this->Registrado_Por->ViewCustomAttributes = "";

		// Actualmente_Seguimiento
		$this->Actualmente_Seguimiento->ViewValue = $this->Actualmente_Seguimiento->CurrentValue;
		$this->Actualmente_Seguimiento->ViewCustomAttributes = "";

			// Consecutivo
			$this->Consecutivo->LinkCustomAttributes = "";
			$this->Consecutivo->HrefValue = "";
			$this->Consecutivo->TooltipValue = "";

			// Seguimiento
			$this->Seguimiento->LinkCustomAttributes = "";
			$this->Seguimiento->HrefValue = "";
			$this->Seguimiento->TooltipValue = "";

			// Primer_Nombre
			$this->Primer_Nombre->LinkCustomAttributes = "";
			$this->Primer_Nombre->HrefValue = "";
			$this->Primer_Nombre->TooltipValue = "";

			// Segundo_Nombre
			$this->Segundo_Nombre->LinkCustomAttributes = "";
			$this->Segundo_Nombre->HrefValue = "";
			$this->Segundo_Nombre->TooltipValue = "";

			// Primer_Apellido
			$this->Primer_Apellido->LinkCustomAttributes = "";
			$this->Primer_Apellido->HrefValue = "";
			$this->Primer_Apellido->TooltipValue = "";

			// Segundo_Apellido
			$this->Segundo_Apellido->LinkCustomAttributes = "";
			$this->Segundo_Apellido->HrefValue = "";
			$this->Segundo_Apellido->TooltipValue = "";

			// Tipo_Id
			$this->Tipo_Id->LinkCustomAttributes = "";
			$this->Tipo_Id->HrefValue = "";
			$this->Tipo_Id->TooltipValue = "";

			// Numero_Identificacion
			$this->Numero_Identificacion->LinkCustomAttributes = "";
			$this->Numero_Identificacion->HrefValue = "";
			$this->Numero_Identificacion->TooltipValue = "";

			// Telefono
			$this->Telefono->LinkCustomAttributes = "";
			$this->Telefono->HrefValue = "";
			$this->Telefono->TooltipValue = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->LinkCustomAttributes = "";
			$this->Fecha_Nacimiento->HrefValue = "";
			$this->Fecha_Nacimiento->TooltipValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";
			$this->Edad->TooltipValue = "";

			// Unidad_Edad
			$this->Unidad_Edad->LinkCustomAttributes = "";
			$this->Unidad_Edad->HrefValue = "";
			$this->Unidad_Edad->TooltipValue = "";

			// Sexo
			$this->Sexo->LinkCustomAttributes = "";
			$this->Sexo->HrefValue = "";
			$this->Sexo->TooltipValue = "";

			// Pais_Ocurrencia
			$this->Pais_Ocurrencia->LinkCustomAttributes = "";
			$this->Pais_Ocurrencia->HrefValue = "";
			$this->Pais_Ocurrencia->TooltipValue = "";

			// Depto_Ocurrencia
			$this->Depto_Ocurrencia->LinkCustomAttributes = "";
			$this->Depto_Ocurrencia->HrefValue = "";
			$this->Depto_Ocurrencia->TooltipValue = "";

			// Municipio_Ocurrencia
			$this->Municipio_Ocurrencia->LinkCustomAttributes = "";
			$this->Municipio_Ocurrencia->HrefValue = "";
			$this->Municipio_Ocurrencia->TooltipValue = "";

			// Area_Ocurrencia
			$this->Area_Ocurrencia->LinkCustomAttributes = "";
			$this->Area_Ocurrencia->HrefValue = "";
			$this->Area_Ocurrencia->TooltipValue = "";

			// Localidad
			$this->Localidad->LinkCustomAttributes = "";
			$this->Localidad->HrefValue = "";
			$this->Localidad->TooltipValue = "";

			// Centro_Poblado
			$this->Centro_Poblado->LinkCustomAttributes = "";
			$this->Centro_Poblado->HrefValue = "";
			$this->Centro_Poblado->TooltipValue = "";

			// Vereda
			$this->Vereda->LinkCustomAttributes = "";
			$this->Vereda->HrefValue = "";
			$this->Vereda->TooltipValue = "";

			// Barrio
			$this->Barrio->LinkCustomAttributes = "";
			$this->Barrio->HrefValue = "";
			$this->Barrio->TooltipValue = "";

			// Direccion_Residencia
			$this->Direccion_Residencia->LinkCustomAttributes = "";
			$this->Direccion_Residencia->HrefValue = "";
			$this->Direccion_Residencia->TooltipValue = "";

			// Ocupacion
			$this->Ocupacion->LinkCustomAttributes = "";
			$this->Ocupacion->HrefValue = "";
			$this->Ocupacion->TooltipValue = "";

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->LinkCustomAttributes = "";
			$this->Tipo_Regimen_Salud->HrefValue = "";
			$this->Tipo_Regimen_Salud->TooltipValue = "";

			// Cod_Administradora
			$this->Cod_Administradora->LinkCustomAttributes = "";
			$this->Cod_Administradora->HrefValue = "";
			$this->Cod_Administradora->TooltipValue = "";

			// Pertenencia_Etnica
			$this->Pertenencia_Etnica->LinkCustomAttributes = "";
			$this->Pertenencia_Etnica->HrefValue = "";
			$this->Pertenencia_Etnica->TooltipValue = "";

			// Grupo_Poblacional
			$this->Grupo_Poblacional->LinkCustomAttributes = "";
			$this->Grupo_Poblacional->HrefValue = "";
			$this->Grupo_Poblacional->TooltipValue = "";

			// Depto_Residencia
			$this->Depto_Residencia->LinkCustomAttributes = "";
			$this->Depto_Residencia->HrefValue = "";
			$this->Depto_Residencia->TooltipValue = "";

			// Municipio_Residencia
			$this->Municipio_Residencia->LinkCustomAttributes = "";
			$this->Municipio_Residencia->HrefValue = "";
			$this->Municipio_Residencia->TooltipValue = "";

			// Fecha_Consulta
			$this->Fecha_Consulta->LinkCustomAttributes = "";
			$this->Fecha_Consulta->HrefValue = "";
			$this->Fecha_Consulta->TooltipValue = "";

			// Fecha_Inicio_Sintomas
			$this->Fecha_Inicio_Sintomas->LinkCustomAttributes = "";
			$this->Fecha_Inicio_Sintomas->HrefValue = "";
			$this->Fecha_Inicio_Sintomas->TooltipValue = "";

			// Clasificacion_Inicial
			$this->Clasificacion_Inicial->LinkCustomAttributes = "";
			$this->Clasificacion_Inicial->HrefValue = "";
			$this->Clasificacion_Inicial->TooltipValue = "";

			// Hospitalizado
			$this->Hospitalizado->LinkCustomAttributes = "";
			$this->Hospitalizado->HrefValue = "";
			$this->Hospitalizado->TooltipValue = "";

			// Fecha_Hospitalizacion
			$this->Fecha_Hospitalizacion->LinkCustomAttributes = "";
			$this->Fecha_Hospitalizacion->HrefValue = "";
			$this->Fecha_Hospitalizacion->TooltipValue = "";

			// Condicion_Final
			$this->Condicion_Final->LinkCustomAttributes = "";
			$this->Condicion_Final->HrefValue = "";
			$this->Condicion_Final->TooltipValue = "";

			// Fecha_Defuncion
			$this->Fecha_Defuncion->LinkCustomAttributes = "";
			$this->Fecha_Defuncion->HrefValue = "";
			$this->Fecha_Defuncion->TooltipValue = "";

			// Numero_Certificado_Defuncion
			$this->Numero_Certificado_Defuncion->LinkCustomAttributes = "";
			$this->Numero_Certificado_Defuncion->HrefValue = "";
			$this->Numero_Certificado_Defuncion->TooltipValue = "";

			// Causa_Basica_Muerte_CIEX
			$this->Causa_Basica_Muerte_CIEX->LinkCustomAttributes = "";
			$this->Causa_Basica_Muerte_CIEX->HrefValue = "";
			$this->Causa_Basica_Muerte_CIEX->TooltipValue = "";

			// Nombre_Profesional_Diligencia
			$this->Nombre_Profesional_Diligencia->LinkCustomAttributes = "";
			$this->Nombre_Profesional_Diligencia->HrefValue = "";
			$this->Nombre_Profesional_Diligencia->TooltipValue = "";

			// Telefono_Profesional_Diligencia
			$this->Telefono_Profesional_Diligencia->LinkCustomAttributes = "";
			$this->Telefono_Profesional_Diligencia->HrefValue = "";
			$this->Telefono_Profesional_Diligencia->TooltipValue = "";

			// Seguimiento_Clasificacion_Final
			$this->Seguimiento_Clasificacion_Final->LinkCustomAttributes = "";
			$this->Seguimiento_Clasificacion_Final->HrefValue = "";
			$this->Seguimiento_Clasificacion_Final->TooltipValue = "";

			// Fecha_Ajuste
			$this->Fecha_Ajuste->LinkCustomAttributes = "";
			$this->Fecha_Ajuste->HrefValue = "";
			$this->Fecha_Ajuste->TooltipValue = "";

			// Codigo_UPGD
			$this->Codigo_UPGD->LinkCustomAttributes = "";
			$this->Codigo_UPGD->HrefValue = "";
			$this->Codigo_UPGD->TooltipValue = "";

			// Nombre_Evento
			$this->Nombre_Evento->LinkCustomAttributes = "";
			$this->Nombre_Evento->HrefValue = "";
			$this->Nombre_Evento->TooltipValue = "";

			// Cod_Evento
			$this->Cod_Evento->LinkCustomAttributes = "";
			$this->Cod_Evento->HrefValue = "";
			$this->Cod_Evento->TooltipValue = "";

			// Fecha_Notificacion
			$this->Fecha_Notificacion->LinkCustomAttributes = "";
			$this->Fecha_Notificacion->HrefValue = "";
			$this->Fecha_Notificacion->TooltipValue = "";

			// Semana
			$this->Semana->LinkCustomAttributes = "";
			$this->Semana->HrefValue = "";
			$this->Semana->TooltipValue = "";

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->LinkCustomAttributes = "";
			$this->Mecanismo_Probable_Transmision->HrefValue = "";
			$this->Mecanismo_Probable_Transmision->TooltipValue = "";

			// Nombre_Madre
			$this->Nombre_Madre->LinkCustomAttributes = "";
			$this->Nombre_Madre->HrefValue = "";
			$this->Nombre_Madre->TooltipValue = "";

			// Tipo_Id_Madre
			$this->Tipo_Id_Madre->LinkCustomAttributes = "";
			$this->Tipo_Id_Madre->HrefValue = "";
			$this->Tipo_Id_Madre->TooltipValue = "";

			// Numero_Identificacion_Madre
			$this->Numero_Identificacion_Madre->LinkCustomAttributes = "";
			$this->Numero_Identificacion_Madre->HrefValue = "";
			$this->Numero_Identificacion_Madre->TooltipValue = "";

			// Indentidad_Genero
			$this->Indentidad_Genero->LinkCustomAttributes = "";
			$this->Indentidad_Genero->HrefValue = "";
			$this->Indentidad_Genero->TooltipValue = "";

			// Donador_Sangre_Ultimos_12_Meses
			$this->Donador_Sangre_Ultimos_12_Meses->LinkCustomAttributes = "";
			$this->Donador_Sangre_Ultimos_12_Meses->HrefValue = "";
			$this->Donador_Sangre_Ultimos_12_Meses->TooltipValue = "";

			// Fecha_Donacion
			$this->Fecha_Donacion->LinkCustomAttributes = "";
			$this->Fecha_Donacion->HrefValue = "";
			$this->Fecha_Donacion->TooltipValue = "";

			// Nombre_Institucion_Donacion
			$this->Nombre_Institucion_Donacion->LinkCustomAttributes = "";
			$this->Nombre_Institucion_Donacion->HrefValue = "";
			$this->Nombre_Institucion_Donacion->TooltipValue = "";

			// Recibio_Asesoria_Pre_Prueba
			$this->Recibio_Asesoria_Pre_Prueba->LinkCustomAttributes = "";
			$this->Recibio_Asesoria_Pre_Prueba->HrefValue = "";
			$this->Recibio_Asesoria_Pre_Prueba->TooltipValue = "";

			// Recibio_Asesoria_Post_Prueba
			$this->Recibio_Asesoria_Post_Prueba->LinkCustomAttributes = "";
			$this->Recibio_Asesoria_Post_Prueba->HrefValue = "";
			$this->Recibio_Asesoria_Post_Prueba->TooltipValue = "";

			// Tipo_Prueba
			$this->Tipo_Prueba->LinkCustomAttributes = "";
			$this->Tipo_Prueba->HrefValue = "";
			$this->Tipo_Prueba->TooltipValue = "";

			// Fecha_Resultado_Confirmatorio
			$this->Fecha_Resultado_Confirmatorio->LinkCustomAttributes = "";
			$this->Fecha_Resultado_Confirmatorio->HrefValue = "";
			$this->Fecha_Resultado_Confirmatorio->TooltipValue = "";

			// Valor_Carga_Viral
			$this->Valor_Carga_Viral->LinkCustomAttributes = "";
			$this->Valor_Carga_Viral->HrefValue = "";
			$this->Valor_Carga_Viral->TooltipValue = "";

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->LinkCustomAttributes = "";
			$this->Estado_Clinico_Notificacion->HrefValue = "";
			$this->Estado_Clinico_Notificacion->TooltipValue = "";

			// Hijos_Mujeres_Menores_5
			$this->Hijos_Mujeres_Menores_5->LinkCustomAttributes = "";
			$this->Hijos_Mujeres_Menores_5->HrefValue = "";
			$this->Hijos_Mujeres_Menores_5->TooltipValue = "";

			// Hijos_Hombres_Menores_5
			$this->Hijos_Hombres_Menores_5->LinkCustomAttributes = "";
			$this->Hijos_Hombres_Menores_5->HrefValue = "";
			$this->Hijos_Hombres_Menores_5->TooltipValue = "";

			// Embarazo_Actual
			$this->Embarazo_Actual->LinkCustomAttributes = "";
			$this->Embarazo_Actual->HrefValue = "";
			$this->Embarazo_Actual->TooltipValue = "";

			// Antecedentes_Embarazo
			$this->Antecedentes_Embarazo->LinkCustomAttributes = "";
			$this->Antecedentes_Embarazo->HrefValue = "";
			$this->Antecedentes_Embarazo->TooltipValue = "";

			// Numero_Semanas_Embarazo
			$this->Numero_Semanas_Embarazo->LinkCustomAttributes = "";
			$this->Numero_Semanas_Embarazo->HrefValue = "";
			$this->Numero_Semanas_Embarazo->TooltipValue = "";

			// Candidiasis_esofagica
			$this->Candidiasis_esofagica->LinkCustomAttributes = "";
			$this->Candidiasis_esofagica->HrefValue = "";
			$this->Candidiasis_esofagica->TooltipValue = "";

			// Candidiasis_vias_aereas
			$this->Candidiasis_vias_aereas->LinkCustomAttributes = "";
			$this->Candidiasis_vias_aereas->HrefValue = "";
			$this->Candidiasis_vias_aereas->TooltipValue = "";

			// Tuberculosis_pulmonar
			$this->Tuberculosis_pulmonar->LinkCustomAttributes = "";
			$this->Tuberculosis_pulmonar->HrefValue = "";
			$this->Tuberculosis_pulmonar->TooltipValue = "";

			// Cancer_cervical
			$this->Cancer_cervical->LinkCustomAttributes = "";
			$this->Cancer_cervical->HrefValue = "";
			$this->Cancer_cervical->TooltipValue = "";

			// Tuberculosis_extrapulmonar
			$this->Tuberculosis_extrapulmonar->LinkCustomAttributes = "";
			$this->Tuberculosis_extrapulmonar->HrefValue = "";
			$this->Tuberculosis_extrapulmonar->TooltipValue = "";

			// Coccidiomicosis
			$this->Coccidiomicosis->LinkCustomAttributes = "";
			$this->Coccidiomicosis->HrefValue = "";
			$this->Coccidiomicosis->TooltipValue = "";

			// Citomegalovirosis
			$this->Citomegalovirosis->LinkCustomAttributes = "";
			$this->Citomegalovirosis->HrefValue = "";
			$this->Citomegalovirosis->TooltipValue = "";

			// Retinitis_citomegalovirosis
			$this->Retinitis_citomegalovirosis->LinkCustomAttributes = "";
			$this->Retinitis_citomegalovirosis->HrefValue = "";
			$this->Retinitis_citomegalovirosis->TooltipValue = "";

			// Encefalopatia
			$this->Encefalopatia->LinkCustomAttributes = "";
			$this->Encefalopatia->HrefValue = "";
			$this->Encefalopatia->TooltipValue = "";

			// Otras_micobacterias
			$this->Otras_micobacterias->LinkCustomAttributes = "";
			$this->Otras_micobacterias->HrefValue = "";
			$this->Otras_micobacterias->TooltipValue = "";

			// Histoplasmosis_Extrapulmonar
			$this->Histoplasmosis_Extrapulmonar->LinkCustomAttributes = "";
			$this->Histoplasmosis_Extrapulmonar->HrefValue = "";
			$this->Histoplasmosis_Extrapulmonar->TooltipValue = "";

			// isosporidiasis_cronica
			$this->isosporidiasis_cronica->LinkCustomAttributes = "";
			$this->isosporidiasis_cronica->HrefValue = "";
			$this->isosporidiasis_cronica->TooltipValue = "";

			// herpes_zoster
			$this->herpes_zoster->LinkCustomAttributes = "";
			$this->herpes_zoster->HrefValue = "";
			$this->herpes_zoster->TooltipValue = "";

			// Histoplasmosis_diseminada
			$this->Histoplasmosis_diseminada->LinkCustomAttributes = "";
			$this->Histoplasmosis_diseminada->HrefValue = "";
			$this->Histoplasmosis_diseminada->TooltipValue = "";

			// Linfoma_Burkitt
			$this->Linfoma_Burkitt->LinkCustomAttributes = "";
			$this->Linfoma_Burkitt->HrefValue = "";
			$this->Linfoma_Burkitt->TooltipValue = "";

			// Neumonia_Pneumocystis
			$this->Neumonia_Pneumocystis->LinkCustomAttributes = "";
			$this->Neumonia_Pneumocystis->HrefValue = "";
			$this->Neumonia_Pneumocystis->TooltipValue = "";

			// Neumonia_Recurrente
			$this->Neumonia_Recurrente->LinkCustomAttributes = "";
			$this->Neumonia_Recurrente->HrefValue = "";
			$this->Neumonia_Recurrente->TooltipValue = "";

			// Linfoma_Inmunoblastico
			$this->Linfoma_Inmunoblastico->LinkCustomAttributes = "";
			$this->Linfoma_Inmunoblastico->HrefValue = "";
			$this->Linfoma_Inmunoblastico->TooltipValue = "";

			// Criptosporidiasis_cronica
			$this->Criptosporidiasis_cronica->LinkCustomAttributes = "";
			$this->Criptosporidiasis_cronica->HrefValue = "";
			$this->Criptosporidiasis_cronica->TooltipValue = "";

			// Criptococosis_Extrapulmonar
			$this->Criptococosis_Extrapulmonar->LinkCustomAttributes = "";
			$this->Criptococosis_Extrapulmonar->HrefValue = "";
			$this->Criptococosis_Extrapulmonar->TooltipValue = "";

			// Sarcoma_Kaposi
			$this->Sarcoma_Kaposi->LinkCustomAttributes = "";
			$this->Sarcoma_Kaposi->HrefValue = "";
			$this->Sarcoma_Kaposi->TooltipValue = "";

			// Sindrome_Emanciacion
			$this->Sindrome_Emanciacion->LinkCustomAttributes = "";
			$this->Sindrome_Emanciacion->HrefValue = "";
			$this->Sindrome_Emanciacion->TooltipValue = "";

			// Leucoencefalopatia_Multifocal
			$this->Leucoencefalopatia_Multifocal->LinkCustomAttributes = "";
			$this->Leucoencefalopatia_Multifocal->HrefValue = "";
			$this->Leucoencefalopatia_Multifocal->TooltipValue = "";

			// Septicemia_recurrente
			$this->Septicemia_recurrente->LinkCustomAttributes = "";
			$this->Septicemia_recurrente->HrefValue = "";
			$this->Septicemia_recurrente->TooltipValue = "";

			// Toxoplasmosis_cerebral
			$this->Toxoplasmosis_cerebral->LinkCustomAttributes = "";
			$this->Toxoplasmosis_cerebral->HrefValue = "";
			$this->Toxoplasmosis_cerebral->TooltipValue = "";

			// HepatitisB
			$this->HepatitisB->LinkCustomAttributes = "";
			$this->HepatitisB->HrefValue = "";
			$this->HepatitisB->TooltipValue = "";

			// HepatitisC
			$this->HepatitisC->LinkCustomAttributes = "";
			$this->HepatitisC->HrefValue = "";
			$this->HepatitisC->TooltipValue = "";

			// Meningitis
			$this->Meningitis->LinkCustomAttributes = "";
			$this->Meningitis->HrefValue = "";
			$this->Meningitis->TooltipValue = "";

			// RecuentoCD4
			$this->RecuentoCD4->LinkCustomAttributes = "";
			$this->RecuentoCD4->HrefValue = "";
			$this->RecuentoCD4->TooltipValue = "";

			// Registrado_Por
			$this->Registrado_Por->LinkCustomAttributes = "";
			$this->Registrado_Por->HrefValue = "";
			$this->Registrado_Por->TooltipValue = "";

			// Actualmente_Seguimiento
			$this->Actualmente_Seguimiento->LinkCustomAttributes = "";
			$this->Actualmente_Seguimiento->HrefValue = "";
			$this->Actualmente_Seguimiento->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// Consecutivo
			$this->Consecutivo->EditAttrs["class"] = "form-control";
			$this->Consecutivo->EditCustomAttributes = "";
			$this->Consecutivo->EditValue = $this->Consecutivo->CurrentValue;
			$this->Consecutivo->ViewCustomAttributes = "";

			// Seguimiento
			$this->Seguimiento->EditAttrs["class"] = "form-control";
			$this->Seguimiento->EditCustomAttributes = "";
			$this->Seguimiento->EditValue = ew_HtmlEncode($this->Seguimiento->CurrentValue);
			$this->Seguimiento->PlaceHolder = ew_RemoveHtml($this->Seguimiento->FldCaption());

			// Primer_Nombre
			$this->Primer_Nombre->EditAttrs["class"] = "form-control";
			$this->Primer_Nombre->EditCustomAttributes = "";
			$this->Primer_Nombre->EditValue = ew_HtmlEncode($this->Primer_Nombre->CurrentValue);
			$this->Primer_Nombre->PlaceHolder = ew_RemoveHtml($this->Primer_Nombre->FldCaption());

			// Segundo_Nombre
			$this->Segundo_Nombre->EditAttrs["class"] = "form-control";
			$this->Segundo_Nombre->EditCustomAttributes = "";
			$this->Segundo_Nombre->EditValue = ew_HtmlEncode($this->Segundo_Nombre->CurrentValue);
			$this->Segundo_Nombre->PlaceHolder = ew_RemoveHtml($this->Segundo_Nombre->FldCaption());

			// Primer_Apellido
			$this->Primer_Apellido->EditAttrs["class"] = "form-control";
			$this->Primer_Apellido->EditCustomAttributes = "";
			$this->Primer_Apellido->EditValue = ew_HtmlEncode($this->Primer_Apellido->CurrentValue);
			$this->Primer_Apellido->PlaceHolder = ew_RemoveHtml($this->Primer_Apellido->FldCaption());

			// Segundo_Apellido
			$this->Segundo_Apellido->EditAttrs["class"] = "form-control";
			$this->Segundo_Apellido->EditCustomAttributes = "";
			$this->Segundo_Apellido->EditValue = ew_HtmlEncode($this->Segundo_Apellido->CurrentValue);
			$this->Segundo_Apellido->PlaceHolder = ew_RemoveHtml($this->Segundo_Apellido->FldCaption());

			// Tipo_Id
			$this->Tipo_Id->EditAttrs["class"] = "form-control";
			$this->Tipo_Id->EditCustomAttributes = "";
			$this->Tipo_Id->EditValue = ew_HtmlEncode($this->Tipo_Id->CurrentValue);
			$this->Tipo_Id->PlaceHolder = ew_RemoveHtml($this->Tipo_Id->FldCaption());

			// Numero_Identificacion
			$this->Numero_Identificacion->EditAttrs["class"] = "form-control";
			$this->Numero_Identificacion->EditCustomAttributes = "";
			$this->Numero_Identificacion->EditValue = ew_HtmlEncode($this->Numero_Identificacion->CurrentValue);
			$this->Numero_Identificacion->PlaceHolder = ew_RemoveHtml($this->Numero_Identificacion->FldCaption());

			// Telefono
			$this->Telefono->EditAttrs["class"] = "form-control";
			$this->Telefono->EditCustomAttributes = "";
			$this->Telefono->EditValue = ew_HtmlEncode($this->Telefono->CurrentValue);
			$this->Telefono->PlaceHolder = ew_RemoveHtml($this->Telefono->FldCaption());

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->EditAttrs["class"] = "form-control";
			$this->Fecha_Nacimiento->EditCustomAttributes = "";
			$this->Fecha_Nacimiento->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Nacimiento->CurrentValue, 5));
			$this->Fecha_Nacimiento->PlaceHolder = ew_RemoveHtml($this->Fecha_Nacimiento->FldCaption());

			// Edad
			$this->Edad->EditAttrs["class"] = "form-control";
			$this->Edad->EditCustomAttributes = "";
			$this->Edad->EditValue = ew_HtmlEncode($this->Edad->CurrentValue);
			$this->Edad->PlaceHolder = ew_RemoveHtml($this->Edad->FldCaption());

			// Unidad_Edad
			$this->Unidad_Edad->EditAttrs["class"] = "form-control";
			$this->Unidad_Edad->EditCustomAttributes = "";
			$this->Unidad_Edad->EditValue = ew_HtmlEncode($this->Unidad_Edad->CurrentValue);
			$this->Unidad_Edad->PlaceHolder = ew_RemoveHtml($this->Unidad_Edad->FldCaption());

			// Sexo
			$this->Sexo->EditAttrs["class"] = "form-control";
			$this->Sexo->EditCustomAttributes = "";
			$this->Sexo->EditValue = ew_HtmlEncode($this->Sexo->CurrentValue);
			$this->Sexo->PlaceHolder = ew_RemoveHtml($this->Sexo->FldCaption());

			// Pais_Ocurrencia
			$this->Pais_Ocurrencia->EditAttrs["class"] = "form-control";
			$this->Pais_Ocurrencia->EditCustomAttributes = "";
			$this->Pais_Ocurrencia->EditValue = ew_HtmlEncode($this->Pais_Ocurrencia->CurrentValue);
			$this->Pais_Ocurrencia->PlaceHolder = ew_RemoveHtml($this->Pais_Ocurrencia->FldCaption());

			// Depto_Ocurrencia
			$this->Depto_Ocurrencia->EditAttrs["class"] = "form-control";
			$this->Depto_Ocurrencia->EditCustomAttributes = "";
			$this->Depto_Ocurrencia->EditValue = ew_HtmlEncode($this->Depto_Ocurrencia->CurrentValue);
			$this->Depto_Ocurrencia->PlaceHolder = ew_RemoveHtml($this->Depto_Ocurrencia->FldCaption());

			// Municipio_Ocurrencia
			$this->Municipio_Ocurrencia->EditAttrs["class"] = "form-control";
			$this->Municipio_Ocurrencia->EditCustomAttributes = "";
			$this->Municipio_Ocurrencia->EditValue = ew_HtmlEncode($this->Municipio_Ocurrencia->CurrentValue);
			$this->Municipio_Ocurrencia->PlaceHolder = ew_RemoveHtml($this->Municipio_Ocurrencia->FldCaption());

			// Area_Ocurrencia
			$this->Area_Ocurrencia->EditAttrs["class"] = "form-control";
			$this->Area_Ocurrencia->EditCustomAttributes = "";
			$this->Area_Ocurrencia->EditValue = ew_HtmlEncode($this->Area_Ocurrencia->CurrentValue);
			$this->Area_Ocurrencia->PlaceHolder = ew_RemoveHtml($this->Area_Ocurrencia->FldCaption());

			// Localidad
			$this->Localidad->EditAttrs["class"] = "form-control";
			$this->Localidad->EditCustomAttributes = "";
			$this->Localidad->EditValue = ew_HtmlEncode($this->Localidad->CurrentValue);
			$this->Localidad->PlaceHolder = ew_RemoveHtml($this->Localidad->FldCaption());

			// Centro_Poblado
			$this->Centro_Poblado->EditAttrs["class"] = "form-control";
			$this->Centro_Poblado->EditCustomAttributes = "";
			$this->Centro_Poblado->EditValue = ew_HtmlEncode($this->Centro_Poblado->CurrentValue);
			$this->Centro_Poblado->PlaceHolder = ew_RemoveHtml($this->Centro_Poblado->FldCaption());

			// Vereda
			$this->Vereda->EditAttrs["class"] = "form-control";
			$this->Vereda->EditCustomAttributes = "";
			$this->Vereda->EditValue = ew_HtmlEncode($this->Vereda->CurrentValue);
			$this->Vereda->PlaceHolder = ew_RemoveHtml($this->Vereda->FldCaption());

			// Barrio
			$this->Barrio->EditAttrs["class"] = "form-control";
			$this->Barrio->EditCustomAttributes = "";
			$this->Barrio->EditValue = ew_HtmlEncode($this->Barrio->CurrentValue);
			$this->Barrio->PlaceHolder = ew_RemoveHtml($this->Barrio->FldCaption());

			// Direccion_Residencia
			$this->Direccion_Residencia->EditAttrs["class"] = "form-control";
			$this->Direccion_Residencia->EditCustomAttributes = "";
			$this->Direccion_Residencia->EditValue = ew_HtmlEncode($this->Direccion_Residencia->CurrentValue);
			$this->Direccion_Residencia->PlaceHolder = ew_RemoveHtml($this->Direccion_Residencia->FldCaption());

			// Ocupacion
			$this->Ocupacion->EditAttrs["class"] = "form-control";
			$this->Ocupacion->EditCustomAttributes = "";
			$this->Ocupacion->EditValue = ew_HtmlEncode($this->Ocupacion->CurrentValue);
			$this->Ocupacion->PlaceHolder = ew_RemoveHtml($this->Ocupacion->FldCaption());

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->EditAttrs["class"] = "form-control";
			$this->Tipo_Regimen_Salud->EditCustomAttributes = "";
			$this->Tipo_Regimen_Salud->EditValue = ew_HtmlEncode($this->Tipo_Regimen_Salud->CurrentValue);
			$this->Tipo_Regimen_Salud->PlaceHolder = ew_RemoveHtml($this->Tipo_Regimen_Salud->FldCaption());

			// Cod_Administradora
			$this->Cod_Administradora->EditAttrs["class"] = "form-control";
			$this->Cod_Administradora->EditCustomAttributes = "";
			$this->Cod_Administradora->EditValue = ew_HtmlEncode($this->Cod_Administradora->CurrentValue);
			$this->Cod_Administradora->PlaceHolder = ew_RemoveHtml($this->Cod_Administradora->FldCaption());

			// Pertenencia_Etnica
			$this->Pertenencia_Etnica->EditAttrs["class"] = "form-control";
			$this->Pertenencia_Etnica->EditCustomAttributes = "";
			$this->Pertenencia_Etnica->EditValue = ew_HtmlEncode($this->Pertenencia_Etnica->CurrentValue);
			$this->Pertenencia_Etnica->PlaceHolder = ew_RemoveHtml($this->Pertenencia_Etnica->FldCaption());

			// Grupo_Poblacional
			$this->Grupo_Poblacional->EditAttrs["class"] = "form-control";
			$this->Grupo_Poblacional->EditCustomAttributes = "";
			$this->Grupo_Poblacional->EditValue = ew_HtmlEncode($this->Grupo_Poblacional->CurrentValue);
			$this->Grupo_Poblacional->PlaceHolder = ew_RemoveHtml($this->Grupo_Poblacional->FldCaption());

			// Depto_Residencia
			$this->Depto_Residencia->EditAttrs["class"] = "form-control";
			$this->Depto_Residencia->EditCustomAttributes = "";
			$this->Depto_Residencia->EditValue = ew_HtmlEncode($this->Depto_Residencia->CurrentValue);
			$this->Depto_Residencia->PlaceHolder = ew_RemoveHtml($this->Depto_Residencia->FldCaption());

			// Municipio_Residencia
			$this->Municipio_Residencia->EditAttrs["class"] = "form-control";
			$this->Municipio_Residencia->EditCustomAttributes = "";
			$this->Municipio_Residencia->EditValue = ew_HtmlEncode($this->Municipio_Residencia->CurrentValue);
			$this->Municipio_Residencia->PlaceHolder = ew_RemoveHtml($this->Municipio_Residencia->FldCaption());

			// Fecha_Consulta
			$this->Fecha_Consulta->EditAttrs["class"] = "form-control";
			$this->Fecha_Consulta->EditCustomAttributes = "";
			$this->Fecha_Consulta->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Consulta->CurrentValue, 5));
			$this->Fecha_Consulta->PlaceHolder = ew_RemoveHtml($this->Fecha_Consulta->FldCaption());

			// Fecha_Inicio_Sintomas
			$this->Fecha_Inicio_Sintomas->EditAttrs["class"] = "form-control";
			$this->Fecha_Inicio_Sintomas->EditCustomAttributes = "";
			$this->Fecha_Inicio_Sintomas->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Inicio_Sintomas->CurrentValue, 5));
			$this->Fecha_Inicio_Sintomas->PlaceHolder = ew_RemoveHtml($this->Fecha_Inicio_Sintomas->FldCaption());

			// Clasificacion_Inicial
			$this->Clasificacion_Inicial->EditAttrs["class"] = "form-control";
			$this->Clasificacion_Inicial->EditCustomAttributes = "";
			$this->Clasificacion_Inicial->EditValue = ew_HtmlEncode($this->Clasificacion_Inicial->CurrentValue);
			$this->Clasificacion_Inicial->PlaceHolder = ew_RemoveHtml($this->Clasificacion_Inicial->FldCaption());

			// Hospitalizado
			$this->Hospitalizado->EditAttrs["class"] = "form-control";
			$this->Hospitalizado->EditCustomAttributes = "";
			$this->Hospitalizado->EditValue = ew_HtmlEncode($this->Hospitalizado->CurrentValue);
			$this->Hospitalizado->PlaceHolder = ew_RemoveHtml($this->Hospitalizado->FldCaption());

			// Fecha_Hospitalizacion
			$this->Fecha_Hospitalizacion->EditAttrs["class"] = "form-control";
			$this->Fecha_Hospitalizacion->EditCustomAttributes = "";
			$this->Fecha_Hospitalizacion->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Hospitalizacion->CurrentValue, 5));
			$this->Fecha_Hospitalizacion->PlaceHolder = ew_RemoveHtml($this->Fecha_Hospitalizacion->FldCaption());

			// Condicion_Final
			$this->Condicion_Final->EditAttrs["class"] = "form-control";
			$this->Condicion_Final->EditCustomAttributes = "";
			$this->Condicion_Final->EditValue = ew_HtmlEncode($this->Condicion_Final->CurrentValue);
			$this->Condicion_Final->PlaceHolder = ew_RemoveHtml($this->Condicion_Final->FldCaption());

			// Fecha_Defuncion
			$this->Fecha_Defuncion->EditAttrs["class"] = "form-control";
			$this->Fecha_Defuncion->EditCustomAttributes = "";
			$this->Fecha_Defuncion->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Defuncion->CurrentValue, 5));
			$this->Fecha_Defuncion->PlaceHolder = ew_RemoveHtml($this->Fecha_Defuncion->FldCaption());

			// Numero_Certificado_Defuncion
			$this->Numero_Certificado_Defuncion->EditAttrs["class"] = "form-control";
			$this->Numero_Certificado_Defuncion->EditCustomAttributes = "";
			$this->Numero_Certificado_Defuncion->EditValue = ew_HtmlEncode($this->Numero_Certificado_Defuncion->CurrentValue);
			$this->Numero_Certificado_Defuncion->PlaceHolder = ew_RemoveHtml($this->Numero_Certificado_Defuncion->FldCaption());

			// Causa_Basica_Muerte_CIEX
			$this->Causa_Basica_Muerte_CIEX->EditAttrs["class"] = "form-control";
			$this->Causa_Basica_Muerte_CIEX->EditCustomAttributes = "";
			$this->Causa_Basica_Muerte_CIEX->EditValue = ew_HtmlEncode($this->Causa_Basica_Muerte_CIEX->CurrentValue);
			$this->Causa_Basica_Muerte_CIEX->PlaceHolder = ew_RemoveHtml($this->Causa_Basica_Muerte_CIEX->FldCaption());

			// Nombre_Profesional_Diligencia
			$this->Nombre_Profesional_Diligencia->EditAttrs["class"] = "form-control";
			$this->Nombre_Profesional_Diligencia->EditCustomAttributes = "";
			$this->Nombre_Profesional_Diligencia->EditValue = ew_HtmlEncode($this->Nombre_Profesional_Diligencia->CurrentValue);
			$this->Nombre_Profesional_Diligencia->PlaceHolder = ew_RemoveHtml($this->Nombre_Profesional_Diligencia->FldCaption());

			// Telefono_Profesional_Diligencia
			$this->Telefono_Profesional_Diligencia->EditAttrs["class"] = "form-control";
			$this->Telefono_Profesional_Diligencia->EditCustomAttributes = "";
			$this->Telefono_Profesional_Diligencia->EditValue = ew_HtmlEncode($this->Telefono_Profesional_Diligencia->CurrentValue);
			$this->Telefono_Profesional_Diligencia->PlaceHolder = ew_RemoveHtml($this->Telefono_Profesional_Diligencia->FldCaption());

			// Seguimiento_Clasificacion_Final
			$this->Seguimiento_Clasificacion_Final->EditAttrs["class"] = "form-control";
			$this->Seguimiento_Clasificacion_Final->EditCustomAttributes = "";
			$this->Seguimiento_Clasificacion_Final->EditValue = ew_HtmlEncode($this->Seguimiento_Clasificacion_Final->CurrentValue);
			$this->Seguimiento_Clasificacion_Final->PlaceHolder = ew_RemoveHtml($this->Seguimiento_Clasificacion_Final->FldCaption());

			// Fecha_Ajuste
			$this->Fecha_Ajuste->EditAttrs["class"] = "form-control";
			$this->Fecha_Ajuste->EditCustomAttributes = "";
			$this->Fecha_Ajuste->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Ajuste->CurrentValue, 5));
			$this->Fecha_Ajuste->PlaceHolder = ew_RemoveHtml($this->Fecha_Ajuste->FldCaption());

			// Codigo_UPGD
			$this->Codigo_UPGD->EditAttrs["class"] = "form-control";
			$this->Codigo_UPGD->EditCustomAttributes = "";
			$this->Codigo_UPGD->EditValue = ew_HtmlEncode($this->Codigo_UPGD->CurrentValue);
			$this->Codigo_UPGD->PlaceHolder = ew_RemoveHtml($this->Codigo_UPGD->FldCaption());

			// Nombre_Evento
			$this->Nombre_Evento->EditAttrs["class"] = "form-control";
			$this->Nombre_Evento->EditCustomAttributes = "";
			$this->Nombre_Evento->EditValue = ew_HtmlEncode($this->Nombre_Evento->CurrentValue);
			$this->Nombre_Evento->PlaceHolder = ew_RemoveHtml($this->Nombre_Evento->FldCaption());

			// Cod_Evento
			$this->Cod_Evento->EditAttrs["class"] = "form-control";
			$this->Cod_Evento->EditCustomAttributes = "";
			$this->Cod_Evento->EditValue = ew_HtmlEncode($this->Cod_Evento->CurrentValue);
			$this->Cod_Evento->PlaceHolder = ew_RemoveHtml($this->Cod_Evento->FldCaption());

			// Fecha_Notificacion
			$this->Fecha_Notificacion->EditAttrs["class"] = "form-control";
			$this->Fecha_Notificacion->EditCustomAttributes = "";
			$this->Fecha_Notificacion->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Notificacion->CurrentValue, 5));
			$this->Fecha_Notificacion->PlaceHolder = ew_RemoveHtml($this->Fecha_Notificacion->FldCaption());

			// Semana
			$this->Semana->EditAttrs["class"] = "form-control";
			$this->Semana->EditCustomAttributes = "";
			$this->Semana->EditValue = ew_HtmlEncode($this->Semana->CurrentValue);
			$this->Semana->PlaceHolder = ew_RemoveHtml($this->Semana->FldCaption());

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->EditAttrs["class"] = "form-control";
			$this->Mecanismo_Probable_Transmision->EditCustomAttributes = "";
			$this->Mecanismo_Probable_Transmision->EditValue = ew_HtmlEncode($this->Mecanismo_Probable_Transmision->CurrentValue);
			$this->Mecanismo_Probable_Transmision->PlaceHolder = ew_RemoveHtml($this->Mecanismo_Probable_Transmision->FldCaption());

			// Nombre_Madre
			$this->Nombre_Madre->EditAttrs["class"] = "form-control";
			$this->Nombre_Madre->EditCustomAttributes = "";
			$this->Nombre_Madre->EditValue = ew_HtmlEncode($this->Nombre_Madre->CurrentValue);
			$this->Nombre_Madre->PlaceHolder = ew_RemoveHtml($this->Nombre_Madre->FldCaption());

			// Tipo_Id_Madre
			$this->Tipo_Id_Madre->EditAttrs["class"] = "form-control";
			$this->Tipo_Id_Madre->EditCustomAttributes = "";
			$this->Tipo_Id_Madre->EditValue = ew_HtmlEncode($this->Tipo_Id_Madre->CurrentValue);
			$this->Tipo_Id_Madre->PlaceHolder = ew_RemoveHtml($this->Tipo_Id_Madre->FldCaption());

			// Numero_Identificacion_Madre
			$this->Numero_Identificacion_Madre->EditAttrs["class"] = "form-control";
			$this->Numero_Identificacion_Madre->EditCustomAttributes = "";
			$this->Numero_Identificacion_Madre->EditValue = ew_HtmlEncode($this->Numero_Identificacion_Madre->CurrentValue);
			$this->Numero_Identificacion_Madre->PlaceHolder = ew_RemoveHtml($this->Numero_Identificacion_Madre->FldCaption());

			// Indentidad_Genero
			$this->Indentidad_Genero->EditAttrs["class"] = "form-control";
			$this->Indentidad_Genero->EditCustomAttributes = "";
			$this->Indentidad_Genero->EditValue = ew_HtmlEncode($this->Indentidad_Genero->CurrentValue);
			$this->Indentidad_Genero->PlaceHolder = ew_RemoveHtml($this->Indentidad_Genero->FldCaption());

			// Donador_Sangre_Ultimos_12_Meses
			$this->Donador_Sangre_Ultimos_12_Meses->EditAttrs["class"] = "form-control";
			$this->Donador_Sangre_Ultimos_12_Meses->EditCustomAttributes = "";
			$this->Donador_Sangre_Ultimos_12_Meses->EditValue = ew_HtmlEncode($this->Donador_Sangre_Ultimos_12_Meses->CurrentValue);
			$this->Donador_Sangre_Ultimos_12_Meses->PlaceHolder = ew_RemoveHtml($this->Donador_Sangre_Ultimos_12_Meses->FldCaption());

			// Fecha_Donacion
			$this->Fecha_Donacion->EditAttrs["class"] = "form-control";
			$this->Fecha_Donacion->EditCustomAttributes = "";
			$this->Fecha_Donacion->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Donacion->CurrentValue, 5));
			$this->Fecha_Donacion->PlaceHolder = ew_RemoveHtml($this->Fecha_Donacion->FldCaption());

			// Nombre_Institucion_Donacion
			$this->Nombre_Institucion_Donacion->EditAttrs["class"] = "form-control";
			$this->Nombre_Institucion_Donacion->EditCustomAttributes = "";
			$this->Nombre_Institucion_Donacion->EditValue = ew_HtmlEncode($this->Nombre_Institucion_Donacion->CurrentValue);
			$this->Nombre_Institucion_Donacion->PlaceHolder = ew_RemoveHtml($this->Nombre_Institucion_Donacion->FldCaption());

			// Recibio_Asesoria_Pre_Prueba
			$this->Recibio_Asesoria_Pre_Prueba->EditAttrs["class"] = "form-control";
			$this->Recibio_Asesoria_Pre_Prueba->EditCustomAttributes = "";
			$this->Recibio_Asesoria_Pre_Prueba->EditValue = ew_HtmlEncode($this->Recibio_Asesoria_Pre_Prueba->CurrentValue);
			$this->Recibio_Asesoria_Pre_Prueba->PlaceHolder = ew_RemoveHtml($this->Recibio_Asesoria_Pre_Prueba->FldCaption());

			// Recibio_Asesoria_Post_Prueba
			$this->Recibio_Asesoria_Post_Prueba->EditAttrs["class"] = "form-control";
			$this->Recibio_Asesoria_Post_Prueba->EditCustomAttributes = "";
			$this->Recibio_Asesoria_Post_Prueba->EditValue = ew_HtmlEncode($this->Recibio_Asesoria_Post_Prueba->CurrentValue);
			$this->Recibio_Asesoria_Post_Prueba->PlaceHolder = ew_RemoveHtml($this->Recibio_Asesoria_Post_Prueba->FldCaption());

			// Tipo_Prueba
			$this->Tipo_Prueba->EditAttrs["class"] = "form-control";
			$this->Tipo_Prueba->EditCustomAttributes = "";
			$this->Tipo_Prueba->EditValue = ew_HtmlEncode($this->Tipo_Prueba->CurrentValue);
			$this->Tipo_Prueba->PlaceHolder = ew_RemoveHtml($this->Tipo_Prueba->FldCaption());

			// Fecha_Resultado_Confirmatorio
			$this->Fecha_Resultado_Confirmatorio->EditAttrs["class"] = "form-control";
			$this->Fecha_Resultado_Confirmatorio->EditCustomAttributes = "";
			$this->Fecha_Resultado_Confirmatorio->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Resultado_Confirmatorio->CurrentValue, 5));
			$this->Fecha_Resultado_Confirmatorio->PlaceHolder = ew_RemoveHtml($this->Fecha_Resultado_Confirmatorio->FldCaption());

			// Valor_Carga_Viral
			$this->Valor_Carga_Viral->EditAttrs["class"] = "form-control";
			$this->Valor_Carga_Viral->EditCustomAttributes = "";
			$this->Valor_Carga_Viral->EditValue = ew_HtmlEncode($this->Valor_Carga_Viral->CurrentValue);
			$this->Valor_Carga_Viral->PlaceHolder = ew_RemoveHtml($this->Valor_Carga_Viral->FldCaption());

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->EditAttrs["class"] = "form-control";
			$this->Estado_Clinico_Notificacion->EditCustomAttributes = "";
			$this->Estado_Clinico_Notificacion->EditValue = ew_HtmlEncode($this->Estado_Clinico_Notificacion->CurrentValue);
			$this->Estado_Clinico_Notificacion->PlaceHolder = ew_RemoveHtml($this->Estado_Clinico_Notificacion->FldCaption());

			// Hijos_Mujeres_Menores_5
			$this->Hijos_Mujeres_Menores_5->EditAttrs["class"] = "form-control";
			$this->Hijos_Mujeres_Menores_5->EditCustomAttributes = "";
			$this->Hijos_Mujeres_Menores_5->EditValue = ew_HtmlEncode($this->Hijos_Mujeres_Menores_5->CurrentValue);
			$this->Hijos_Mujeres_Menores_5->PlaceHolder = ew_RemoveHtml($this->Hijos_Mujeres_Menores_5->FldCaption());

			// Hijos_Hombres_Menores_5
			$this->Hijos_Hombres_Menores_5->EditAttrs["class"] = "form-control";
			$this->Hijos_Hombres_Menores_5->EditCustomAttributes = "";
			$this->Hijos_Hombres_Menores_5->EditValue = ew_HtmlEncode($this->Hijos_Hombres_Menores_5->CurrentValue);
			$this->Hijos_Hombres_Menores_5->PlaceHolder = ew_RemoveHtml($this->Hijos_Hombres_Menores_5->FldCaption());

			// Embarazo_Actual
			$this->Embarazo_Actual->EditAttrs["class"] = "form-control";
			$this->Embarazo_Actual->EditCustomAttributes = "";
			$this->Embarazo_Actual->EditValue = ew_HtmlEncode($this->Embarazo_Actual->CurrentValue);
			$this->Embarazo_Actual->PlaceHolder = ew_RemoveHtml($this->Embarazo_Actual->FldCaption());

			// Antecedentes_Embarazo
			$this->Antecedentes_Embarazo->EditAttrs["class"] = "form-control";
			$this->Antecedentes_Embarazo->EditCustomAttributes = "";
			$this->Antecedentes_Embarazo->EditValue = ew_HtmlEncode($this->Antecedentes_Embarazo->CurrentValue);
			$this->Antecedentes_Embarazo->PlaceHolder = ew_RemoveHtml($this->Antecedentes_Embarazo->FldCaption());

			// Numero_Semanas_Embarazo
			$this->Numero_Semanas_Embarazo->EditAttrs["class"] = "form-control";
			$this->Numero_Semanas_Embarazo->EditCustomAttributes = "";
			$this->Numero_Semanas_Embarazo->EditValue = ew_HtmlEncode($this->Numero_Semanas_Embarazo->CurrentValue);
			$this->Numero_Semanas_Embarazo->PlaceHolder = ew_RemoveHtml($this->Numero_Semanas_Embarazo->FldCaption());

			// Candidiasis_esofagica
			$this->Candidiasis_esofagica->EditAttrs["class"] = "form-control";
			$this->Candidiasis_esofagica->EditCustomAttributes = "";
			$this->Candidiasis_esofagica->EditValue = ew_HtmlEncode($this->Candidiasis_esofagica->CurrentValue);
			$this->Candidiasis_esofagica->PlaceHolder = ew_RemoveHtml($this->Candidiasis_esofagica->FldCaption());

			// Candidiasis_vias_aereas
			$this->Candidiasis_vias_aereas->EditAttrs["class"] = "form-control";
			$this->Candidiasis_vias_aereas->EditCustomAttributes = "";
			$this->Candidiasis_vias_aereas->EditValue = ew_HtmlEncode($this->Candidiasis_vias_aereas->CurrentValue);
			$this->Candidiasis_vias_aereas->PlaceHolder = ew_RemoveHtml($this->Candidiasis_vias_aereas->FldCaption());

			// Tuberculosis_pulmonar
			$this->Tuberculosis_pulmonar->EditAttrs["class"] = "form-control";
			$this->Tuberculosis_pulmonar->EditCustomAttributes = "";
			$this->Tuberculosis_pulmonar->EditValue = ew_HtmlEncode($this->Tuberculosis_pulmonar->CurrentValue);
			$this->Tuberculosis_pulmonar->PlaceHolder = ew_RemoveHtml($this->Tuberculosis_pulmonar->FldCaption());

			// Cancer_cervical
			$this->Cancer_cervical->EditAttrs["class"] = "form-control";
			$this->Cancer_cervical->EditCustomAttributes = "";
			$this->Cancer_cervical->EditValue = ew_HtmlEncode($this->Cancer_cervical->CurrentValue);
			$this->Cancer_cervical->PlaceHolder = ew_RemoveHtml($this->Cancer_cervical->FldCaption());

			// Tuberculosis_extrapulmonar
			$this->Tuberculosis_extrapulmonar->EditAttrs["class"] = "form-control";
			$this->Tuberculosis_extrapulmonar->EditCustomAttributes = "";
			$this->Tuberculosis_extrapulmonar->EditValue = ew_HtmlEncode($this->Tuberculosis_extrapulmonar->CurrentValue);
			$this->Tuberculosis_extrapulmonar->PlaceHolder = ew_RemoveHtml($this->Tuberculosis_extrapulmonar->FldCaption());

			// Coccidiomicosis
			$this->Coccidiomicosis->EditAttrs["class"] = "form-control";
			$this->Coccidiomicosis->EditCustomAttributes = "";
			$this->Coccidiomicosis->EditValue = ew_HtmlEncode($this->Coccidiomicosis->CurrentValue);
			$this->Coccidiomicosis->PlaceHolder = ew_RemoveHtml($this->Coccidiomicosis->FldCaption());

			// Citomegalovirosis
			$this->Citomegalovirosis->EditAttrs["class"] = "form-control";
			$this->Citomegalovirosis->EditCustomAttributes = "";
			$this->Citomegalovirosis->EditValue = ew_HtmlEncode($this->Citomegalovirosis->CurrentValue);
			$this->Citomegalovirosis->PlaceHolder = ew_RemoveHtml($this->Citomegalovirosis->FldCaption());

			// Retinitis_citomegalovirosis
			$this->Retinitis_citomegalovirosis->EditAttrs["class"] = "form-control";
			$this->Retinitis_citomegalovirosis->EditCustomAttributes = "";
			$this->Retinitis_citomegalovirosis->EditValue = ew_HtmlEncode($this->Retinitis_citomegalovirosis->CurrentValue);
			$this->Retinitis_citomegalovirosis->PlaceHolder = ew_RemoveHtml($this->Retinitis_citomegalovirosis->FldCaption());

			// Encefalopatia
			$this->Encefalopatia->EditAttrs["class"] = "form-control";
			$this->Encefalopatia->EditCustomAttributes = "";
			$this->Encefalopatia->EditValue = ew_HtmlEncode($this->Encefalopatia->CurrentValue);
			$this->Encefalopatia->PlaceHolder = ew_RemoveHtml($this->Encefalopatia->FldCaption());

			// Otras_micobacterias
			$this->Otras_micobacterias->EditAttrs["class"] = "form-control";
			$this->Otras_micobacterias->EditCustomAttributes = "";
			$this->Otras_micobacterias->EditValue = ew_HtmlEncode($this->Otras_micobacterias->CurrentValue);
			$this->Otras_micobacterias->PlaceHolder = ew_RemoveHtml($this->Otras_micobacterias->FldCaption());

			// Histoplasmosis_Extrapulmonar
			$this->Histoplasmosis_Extrapulmonar->EditAttrs["class"] = "form-control";
			$this->Histoplasmosis_Extrapulmonar->EditCustomAttributes = "";
			$this->Histoplasmosis_Extrapulmonar->EditValue = ew_HtmlEncode($this->Histoplasmosis_Extrapulmonar->CurrentValue);
			$this->Histoplasmosis_Extrapulmonar->PlaceHolder = ew_RemoveHtml($this->Histoplasmosis_Extrapulmonar->FldCaption());

			// isosporidiasis_cronica
			$this->isosporidiasis_cronica->EditAttrs["class"] = "form-control";
			$this->isosporidiasis_cronica->EditCustomAttributes = "";
			$this->isosporidiasis_cronica->EditValue = ew_HtmlEncode($this->isosporidiasis_cronica->CurrentValue);
			$this->isosporidiasis_cronica->PlaceHolder = ew_RemoveHtml($this->isosporidiasis_cronica->FldCaption());

			// herpes_zoster
			$this->herpes_zoster->EditAttrs["class"] = "form-control";
			$this->herpes_zoster->EditCustomAttributes = "";
			$this->herpes_zoster->EditValue = ew_HtmlEncode($this->herpes_zoster->CurrentValue);
			$this->herpes_zoster->PlaceHolder = ew_RemoveHtml($this->herpes_zoster->FldCaption());

			// Histoplasmosis_diseminada
			$this->Histoplasmosis_diseminada->EditAttrs["class"] = "form-control";
			$this->Histoplasmosis_diseminada->EditCustomAttributes = "";
			$this->Histoplasmosis_diseminada->EditValue = ew_HtmlEncode($this->Histoplasmosis_diseminada->CurrentValue);
			$this->Histoplasmosis_diseminada->PlaceHolder = ew_RemoveHtml($this->Histoplasmosis_diseminada->FldCaption());

			// Linfoma_Burkitt
			$this->Linfoma_Burkitt->EditAttrs["class"] = "form-control";
			$this->Linfoma_Burkitt->EditCustomAttributes = "";
			$this->Linfoma_Burkitt->EditValue = ew_HtmlEncode($this->Linfoma_Burkitt->CurrentValue);
			$this->Linfoma_Burkitt->PlaceHolder = ew_RemoveHtml($this->Linfoma_Burkitt->FldCaption());

			// Neumonia_Pneumocystis
			$this->Neumonia_Pneumocystis->EditAttrs["class"] = "form-control";
			$this->Neumonia_Pneumocystis->EditCustomAttributes = "";
			$this->Neumonia_Pneumocystis->EditValue = ew_HtmlEncode($this->Neumonia_Pneumocystis->CurrentValue);
			$this->Neumonia_Pneumocystis->PlaceHolder = ew_RemoveHtml($this->Neumonia_Pneumocystis->FldCaption());

			// Neumonia_Recurrente
			$this->Neumonia_Recurrente->EditAttrs["class"] = "form-control";
			$this->Neumonia_Recurrente->EditCustomAttributes = "";
			$this->Neumonia_Recurrente->EditValue = ew_HtmlEncode($this->Neumonia_Recurrente->CurrentValue);
			$this->Neumonia_Recurrente->PlaceHolder = ew_RemoveHtml($this->Neumonia_Recurrente->FldCaption());

			// Linfoma_Inmunoblastico
			$this->Linfoma_Inmunoblastico->EditAttrs["class"] = "form-control";
			$this->Linfoma_Inmunoblastico->EditCustomAttributes = "";
			$this->Linfoma_Inmunoblastico->EditValue = ew_HtmlEncode($this->Linfoma_Inmunoblastico->CurrentValue);
			$this->Linfoma_Inmunoblastico->PlaceHolder = ew_RemoveHtml($this->Linfoma_Inmunoblastico->FldCaption());

			// Criptosporidiasis_cronica
			$this->Criptosporidiasis_cronica->EditAttrs["class"] = "form-control";
			$this->Criptosporidiasis_cronica->EditCustomAttributes = "";
			$this->Criptosporidiasis_cronica->EditValue = ew_HtmlEncode($this->Criptosporidiasis_cronica->CurrentValue);
			$this->Criptosporidiasis_cronica->PlaceHolder = ew_RemoveHtml($this->Criptosporidiasis_cronica->FldCaption());

			// Criptococosis_Extrapulmonar
			$this->Criptococosis_Extrapulmonar->EditAttrs["class"] = "form-control";
			$this->Criptococosis_Extrapulmonar->EditCustomAttributes = "";
			$this->Criptococosis_Extrapulmonar->EditValue = ew_HtmlEncode($this->Criptococosis_Extrapulmonar->CurrentValue);
			$this->Criptococosis_Extrapulmonar->PlaceHolder = ew_RemoveHtml($this->Criptococosis_Extrapulmonar->FldCaption());

			// Sarcoma_Kaposi
			$this->Sarcoma_Kaposi->EditAttrs["class"] = "form-control";
			$this->Sarcoma_Kaposi->EditCustomAttributes = "";
			$this->Sarcoma_Kaposi->EditValue = ew_HtmlEncode($this->Sarcoma_Kaposi->CurrentValue);
			$this->Sarcoma_Kaposi->PlaceHolder = ew_RemoveHtml($this->Sarcoma_Kaposi->FldCaption());

			// Sindrome_Emanciacion
			$this->Sindrome_Emanciacion->EditAttrs["class"] = "form-control";
			$this->Sindrome_Emanciacion->EditCustomAttributes = "";
			$this->Sindrome_Emanciacion->EditValue = ew_HtmlEncode($this->Sindrome_Emanciacion->CurrentValue);
			$this->Sindrome_Emanciacion->PlaceHolder = ew_RemoveHtml($this->Sindrome_Emanciacion->FldCaption());

			// Leucoencefalopatia_Multifocal
			$this->Leucoencefalopatia_Multifocal->EditAttrs["class"] = "form-control";
			$this->Leucoencefalopatia_Multifocal->EditCustomAttributes = "";
			$this->Leucoencefalopatia_Multifocal->EditValue = ew_HtmlEncode($this->Leucoencefalopatia_Multifocal->CurrentValue);
			$this->Leucoencefalopatia_Multifocal->PlaceHolder = ew_RemoveHtml($this->Leucoencefalopatia_Multifocal->FldCaption());

			// Septicemia_recurrente
			$this->Septicemia_recurrente->EditAttrs["class"] = "form-control";
			$this->Septicemia_recurrente->EditCustomAttributes = "";
			$this->Septicemia_recurrente->EditValue = ew_HtmlEncode($this->Septicemia_recurrente->CurrentValue);
			$this->Septicemia_recurrente->PlaceHolder = ew_RemoveHtml($this->Septicemia_recurrente->FldCaption());

			// Toxoplasmosis_cerebral
			$this->Toxoplasmosis_cerebral->EditAttrs["class"] = "form-control";
			$this->Toxoplasmosis_cerebral->EditCustomAttributes = "";
			$this->Toxoplasmosis_cerebral->EditValue = ew_HtmlEncode($this->Toxoplasmosis_cerebral->CurrentValue);
			$this->Toxoplasmosis_cerebral->PlaceHolder = ew_RemoveHtml($this->Toxoplasmosis_cerebral->FldCaption());

			// HepatitisB
			$this->HepatitisB->EditAttrs["class"] = "form-control";
			$this->HepatitisB->EditCustomAttributes = "";
			$this->HepatitisB->EditValue = ew_HtmlEncode($this->HepatitisB->CurrentValue);
			$this->HepatitisB->PlaceHolder = ew_RemoveHtml($this->HepatitisB->FldCaption());

			// HepatitisC
			$this->HepatitisC->EditAttrs["class"] = "form-control";
			$this->HepatitisC->EditCustomAttributes = "";
			$this->HepatitisC->EditValue = ew_HtmlEncode($this->HepatitisC->CurrentValue);
			$this->HepatitisC->PlaceHolder = ew_RemoveHtml($this->HepatitisC->FldCaption());

			// Meningitis
			$this->Meningitis->EditAttrs["class"] = "form-control";
			$this->Meningitis->EditCustomAttributes = "";
			$this->Meningitis->EditValue = ew_HtmlEncode($this->Meningitis->CurrentValue);
			$this->Meningitis->PlaceHolder = ew_RemoveHtml($this->Meningitis->FldCaption());

			// RecuentoCD4
			$this->RecuentoCD4->EditAttrs["class"] = "form-control";
			$this->RecuentoCD4->EditCustomAttributes = "";
			$this->RecuentoCD4->EditValue = ew_HtmlEncode($this->RecuentoCD4->CurrentValue);
			$this->RecuentoCD4->PlaceHolder = ew_RemoveHtml($this->RecuentoCD4->FldCaption());

			// Registrado_Por
			$this->Registrado_Por->EditAttrs["class"] = "form-control";
			$this->Registrado_Por->EditCustomAttributes = "";
			$this->Registrado_Por->EditValue = ew_HtmlEncode($this->Registrado_Por->CurrentValue);
			$this->Registrado_Por->PlaceHolder = ew_RemoveHtml($this->Registrado_Por->FldCaption());

			// Actualmente_Seguimiento
			$this->Actualmente_Seguimiento->EditAttrs["class"] = "form-control";
			$this->Actualmente_Seguimiento->EditCustomAttributes = "";
			$this->Actualmente_Seguimiento->EditValue = ew_HtmlEncode($this->Actualmente_Seguimiento->CurrentValue);
			$this->Actualmente_Seguimiento->PlaceHolder = ew_RemoveHtml($this->Actualmente_Seguimiento->FldCaption());

			// Edit refer script
			// Consecutivo

			$this->Consecutivo->LinkCustomAttributes = "";
			$this->Consecutivo->HrefValue = "";

			// Seguimiento
			$this->Seguimiento->LinkCustomAttributes = "";
			$this->Seguimiento->HrefValue = "";

			// Primer_Nombre
			$this->Primer_Nombre->LinkCustomAttributes = "";
			$this->Primer_Nombre->HrefValue = "";

			// Segundo_Nombre
			$this->Segundo_Nombre->LinkCustomAttributes = "";
			$this->Segundo_Nombre->HrefValue = "";

			// Primer_Apellido
			$this->Primer_Apellido->LinkCustomAttributes = "";
			$this->Primer_Apellido->HrefValue = "";

			// Segundo_Apellido
			$this->Segundo_Apellido->LinkCustomAttributes = "";
			$this->Segundo_Apellido->HrefValue = "";

			// Tipo_Id
			$this->Tipo_Id->LinkCustomAttributes = "";
			$this->Tipo_Id->HrefValue = "";

			// Numero_Identificacion
			$this->Numero_Identificacion->LinkCustomAttributes = "";
			$this->Numero_Identificacion->HrefValue = "";

			// Telefono
			$this->Telefono->LinkCustomAttributes = "";
			$this->Telefono->HrefValue = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->LinkCustomAttributes = "";
			$this->Fecha_Nacimiento->HrefValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";

			// Unidad_Edad
			$this->Unidad_Edad->LinkCustomAttributes = "";
			$this->Unidad_Edad->HrefValue = "";

			// Sexo
			$this->Sexo->LinkCustomAttributes = "";
			$this->Sexo->HrefValue = "";

			// Pais_Ocurrencia
			$this->Pais_Ocurrencia->LinkCustomAttributes = "";
			$this->Pais_Ocurrencia->HrefValue = "";

			// Depto_Ocurrencia
			$this->Depto_Ocurrencia->LinkCustomAttributes = "";
			$this->Depto_Ocurrencia->HrefValue = "";

			// Municipio_Ocurrencia
			$this->Municipio_Ocurrencia->LinkCustomAttributes = "";
			$this->Municipio_Ocurrencia->HrefValue = "";

			// Area_Ocurrencia
			$this->Area_Ocurrencia->LinkCustomAttributes = "";
			$this->Area_Ocurrencia->HrefValue = "";

			// Localidad
			$this->Localidad->LinkCustomAttributes = "";
			$this->Localidad->HrefValue = "";

			// Centro_Poblado
			$this->Centro_Poblado->LinkCustomAttributes = "";
			$this->Centro_Poblado->HrefValue = "";

			// Vereda
			$this->Vereda->LinkCustomAttributes = "";
			$this->Vereda->HrefValue = "";

			// Barrio
			$this->Barrio->LinkCustomAttributes = "";
			$this->Barrio->HrefValue = "";

			// Direccion_Residencia
			$this->Direccion_Residencia->LinkCustomAttributes = "";
			$this->Direccion_Residencia->HrefValue = "";

			// Ocupacion
			$this->Ocupacion->LinkCustomAttributes = "";
			$this->Ocupacion->HrefValue = "";

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->LinkCustomAttributes = "";
			$this->Tipo_Regimen_Salud->HrefValue = "";

			// Cod_Administradora
			$this->Cod_Administradora->LinkCustomAttributes = "";
			$this->Cod_Administradora->HrefValue = "";

			// Pertenencia_Etnica
			$this->Pertenencia_Etnica->LinkCustomAttributes = "";
			$this->Pertenencia_Etnica->HrefValue = "";

			// Grupo_Poblacional
			$this->Grupo_Poblacional->LinkCustomAttributes = "";
			$this->Grupo_Poblacional->HrefValue = "";

			// Depto_Residencia
			$this->Depto_Residencia->LinkCustomAttributes = "";
			$this->Depto_Residencia->HrefValue = "";

			// Municipio_Residencia
			$this->Municipio_Residencia->LinkCustomAttributes = "";
			$this->Municipio_Residencia->HrefValue = "";

			// Fecha_Consulta
			$this->Fecha_Consulta->LinkCustomAttributes = "";
			$this->Fecha_Consulta->HrefValue = "";

			// Fecha_Inicio_Sintomas
			$this->Fecha_Inicio_Sintomas->LinkCustomAttributes = "";
			$this->Fecha_Inicio_Sintomas->HrefValue = "";

			// Clasificacion_Inicial
			$this->Clasificacion_Inicial->LinkCustomAttributes = "";
			$this->Clasificacion_Inicial->HrefValue = "";

			// Hospitalizado
			$this->Hospitalizado->LinkCustomAttributes = "";
			$this->Hospitalizado->HrefValue = "";

			// Fecha_Hospitalizacion
			$this->Fecha_Hospitalizacion->LinkCustomAttributes = "";
			$this->Fecha_Hospitalizacion->HrefValue = "";

			// Condicion_Final
			$this->Condicion_Final->LinkCustomAttributes = "";
			$this->Condicion_Final->HrefValue = "";

			// Fecha_Defuncion
			$this->Fecha_Defuncion->LinkCustomAttributes = "";
			$this->Fecha_Defuncion->HrefValue = "";

			// Numero_Certificado_Defuncion
			$this->Numero_Certificado_Defuncion->LinkCustomAttributes = "";
			$this->Numero_Certificado_Defuncion->HrefValue = "";

			// Causa_Basica_Muerte_CIEX
			$this->Causa_Basica_Muerte_CIEX->LinkCustomAttributes = "";
			$this->Causa_Basica_Muerte_CIEX->HrefValue = "";

			// Nombre_Profesional_Diligencia
			$this->Nombre_Profesional_Diligencia->LinkCustomAttributes = "";
			$this->Nombre_Profesional_Diligencia->HrefValue = "";

			// Telefono_Profesional_Diligencia
			$this->Telefono_Profesional_Diligencia->LinkCustomAttributes = "";
			$this->Telefono_Profesional_Diligencia->HrefValue = "";

			// Seguimiento_Clasificacion_Final
			$this->Seguimiento_Clasificacion_Final->LinkCustomAttributes = "";
			$this->Seguimiento_Clasificacion_Final->HrefValue = "";

			// Fecha_Ajuste
			$this->Fecha_Ajuste->LinkCustomAttributes = "";
			$this->Fecha_Ajuste->HrefValue = "";

			// Codigo_UPGD
			$this->Codigo_UPGD->LinkCustomAttributes = "";
			$this->Codigo_UPGD->HrefValue = "";

			// Nombre_Evento
			$this->Nombre_Evento->LinkCustomAttributes = "";
			$this->Nombre_Evento->HrefValue = "";

			// Cod_Evento
			$this->Cod_Evento->LinkCustomAttributes = "";
			$this->Cod_Evento->HrefValue = "";

			// Fecha_Notificacion
			$this->Fecha_Notificacion->LinkCustomAttributes = "";
			$this->Fecha_Notificacion->HrefValue = "";

			// Semana
			$this->Semana->LinkCustomAttributes = "";
			$this->Semana->HrefValue = "";

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->LinkCustomAttributes = "";
			$this->Mecanismo_Probable_Transmision->HrefValue = "";

			// Nombre_Madre
			$this->Nombre_Madre->LinkCustomAttributes = "";
			$this->Nombre_Madre->HrefValue = "";

			// Tipo_Id_Madre
			$this->Tipo_Id_Madre->LinkCustomAttributes = "";
			$this->Tipo_Id_Madre->HrefValue = "";

			// Numero_Identificacion_Madre
			$this->Numero_Identificacion_Madre->LinkCustomAttributes = "";
			$this->Numero_Identificacion_Madre->HrefValue = "";

			// Indentidad_Genero
			$this->Indentidad_Genero->LinkCustomAttributes = "";
			$this->Indentidad_Genero->HrefValue = "";

			// Donador_Sangre_Ultimos_12_Meses
			$this->Donador_Sangre_Ultimos_12_Meses->LinkCustomAttributes = "";
			$this->Donador_Sangre_Ultimos_12_Meses->HrefValue = "";

			// Fecha_Donacion
			$this->Fecha_Donacion->LinkCustomAttributes = "";
			$this->Fecha_Donacion->HrefValue = "";

			// Nombre_Institucion_Donacion
			$this->Nombre_Institucion_Donacion->LinkCustomAttributes = "";
			$this->Nombre_Institucion_Donacion->HrefValue = "";

			// Recibio_Asesoria_Pre_Prueba
			$this->Recibio_Asesoria_Pre_Prueba->LinkCustomAttributes = "";
			$this->Recibio_Asesoria_Pre_Prueba->HrefValue = "";

			// Recibio_Asesoria_Post_Prueba
			$this->Recibio_Asesoria_Post_Prueba->LinkCustomAttributes = "";
			$this->Recibio_Asesoria_Post_Prueba->HrefValue = "";

			// Tipo_Prueba
			$this->Tipo_Prueba->LinkCustomAttributes = "";
			$this->Tipo_Prueba->HrefValue = "";

			// Fecha_Resultado_Confirmatorio
			$this->Fecha_Resultado_Confirmatorio->LinkCustomAttributes = "";
			$this->Fecha_Resultado_Confirmatorio->HrefValue = "";

			// Valor_Carga_Viral
			$this->Valor_Carga_Viral->LinkCustomAttributes = "";
			$this->Valor_Carga_Viral->HrefValue = "";

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->LinkCustomAttributes = "";
			$this->Estado_Clinico_Notificacion->HrefValue = "";

			// Hijos_Mujeres_Menores_5
			$this->Hijos_Mujeres_Menores_5->LinkCustomAttributes = "";
			$this->Hijos_Mujeres_Menores_5->HrefValue = "";

			// Hijos_Hombres_Menores_5
			$this->Hijos_Hombres_Menores_5->LinkCustomAttributes = "";
			$this->Hijos_Hombres_Menores_5->HrefValue = "";

			// Embarazo_Actual
			$this->Embarazo_Actual->LinkCustomAttributes = "";
			$this->Embarazo_Actual->HrefValue = "";

			// Antecedentes_Embarazo
			$this->Antecedentes_Embarazo->LinkCustomAttributes = "";
			$this->Antecedentes_Embarazo->HrefValue = "";

			// Numero_Semanas_Embarazo
			$this->Numero_Semanas_Embarazo->LinkCustomAttributes = "";
			$this->Numero_Semanas_Embarazo->HrefValue = "";

			// Candidiasis_esofagica
			$this->Candidiasis_esofagica->LinkCustomAttributes = "";
			$this->Candidiasis_esofagica->HrefValue = "";

			// Candidiasis_vias_aereas
			$this->Candidiasis_vias_aereas->LinkCustomAttributes = "";
			$this->Candidiasis_vias_aereas->HrefValue = "";

			// Tuberculosis_pulmonar
			$this->Tuberculosis_pulmonar->LinkCustomAttributes = "";
			$this->Tuberculosis_pulmonar->HrefValue = "";

			// Cancer_cervical
			$this->Cancer_cervical->LinkCustomAttributes = "";
			$this->Cancer_cervical->HrefValue = "";

			// Tuberculosis_extrapulmonar
			$this->Tuberculosis_extrapulmonar->LinkCustomAttributes = "";
			$this->Tuberculosis_extrapulmonar->HrefValue = "";

			// Coccidiomicosis
			$this->Coccidiomicosis->LinkCustomAttributes = "";
			$this->Coccidiomicosis->HrefValue = "";

			// Citomegalovirosis
			$this->Citomegalovirosis->LinkCustomAttributes = "";
			$this->Citomegalovirosis->HrefValue = "";

			// Retinitis_citomegalovirosis
			$this->Retinitis_citomegalovirosis->LinkCustomAttributes = "";
			$this->Retinitis_citomegalovirosis->HrefValue = "";

			// Encefalopatia
			$this->Encefalopatia->LinkCustomAttributes = "";
			$this->Encefalopatia->HrefValue = "";

			// Otras_micobacterias
			$this->Otras_micobacterias->LinkCustomAttributes = "";
			$this->Otras_micobacterias->HrefValue = "";

			// Histoplasmosis_Extrapulmonar
			$this->Histoplasmosis_Extrapulmonar->LinkCustomAttributes = "";
			$this->Histoplasmosis_Extrapulmonar->HrefValue = "";

			// isosporidiasis_cronica
			$this->isosporidiasis_cronica->LinkCustomAttributes = "";
			$this->isosporidiasis_cronica->HrefValue = "";

			// herpes_zoster
			$this->herpes_zoster->LinkCustomAttributes = "";
			$this->herpes_zoster->HrefValue = "";

			// Histoplasmosis_diseminada
			$this->Histoplasmosis_diseminada->LinkCustomAttributes = "";
			$this->Histoplasmosis_diseminada->HrefValue = "";

			// Linfoma_Burkitt
			$this->Linfoma_Burkitt->LinkCustomAttributes = "";
			$this->Linfoma_Burkitt->HrefValue = "";

			// Neumonia_Pneumocystis
			$this->Neumonia_Pneumocystis->LinkCustomAttributes = "";
			$this->Neumonia_Pneumocystis->HrefValue = "";

			// Neumonia_Recurrente
			$this->Neumonia_Recurrente->LinkCustomAttributes = "";
			$this->Neumonia_Recurrente->HrefValue = "";

			// Linfoma_Inmunoblastico
			$this->Linfoma_Inmunoblastico->LinkCustomAttributes = "";
			$this->Linfoma_Inmunoblastico->HrefValue = "";

			// Criptosporidiasis_cronica
			$this->Criptosporidiasis_cronica->LinkCustomAttributes = "";
			$this->Criptosporidiasis_cronica->HrefValue = "";

			// Criptococosis_Extrapulmonar
			$this->Criptococosis_Extrapulmonar->LinkCustomAttributes = "";
			$this->Criptococosis_Extrapulmonar->HrefValue = "";

			// Sarcoma_Kaposi
			$this->Sarcoma_Kaposi->LinkCustomAttributes = "";
			$this->Sarcoma_Kaposi->HrefValue = "";

			// Sindrome_Emanciacion
			$this->Sindrome_Emanciacion->LinkCustomAttributes = "";
			$this->Sindrome_Emanciacion->HrefValue = "";

			// Leucoencefalopatia_Multifocal
			$this->Leucoencefalopatia_Multifocal->LinkCustomAttributes = "";
			$this->Leucoencefalopatia_Multifocal->HrefValue = "";

			// Septicemia_recurrente
			$this->Septicemia_recurrente->LinkCustomAttributes = "";
			$this->Septicemia_recurrente->HrefValue = "";

			// Toxoplasmosis_cerebral
			$this->Toxoplasmosis_cerebral->LinkCustomAttributes = "";
			$this->Toxoplasmosis_cerebral->HrefValue = "";

			// HepatitisB
			$this->HepatitisB->LinkCustomAttributes = "";
			$this->HepatitisB->HrefValue = "";

			// HepatitisC
			$this->HepatitisC->LinkCustomAttributes = "";
			$this->HepatitisC->HrefValue = "";

			// Meningitis
			$this->Meningitis->LinkCustomAttributes = "";
			$this->Meningitis->HrefValue = "";

			// RecuentoCD4
			$this->RecuentoCD4->LinkCustomAttributes = "";
			$this->RecuentoCD4->HrefValue = "";

			// Registrado_Por
			$this->Registrado_Por->LinkCustomAttributes = "";
			$this->Registrado_Por->HrefValue = "";

			// Actualmente_Seguimiento
			$this->Actualmente_Seguimiento->LinkCustomAttributes = "";
			$this->Actualmente_Seguimiento->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckInteger($this->Seguimiento->FormValue)) {
			ew_AddMessage($gsFormError, $this->Seguimiento->FldErrMsg());
		}
		if (!$this->Primer_Nombre->FldIsDetailKey && !is_null($this->Primer_Nombre->FormValue) && $this->Primer_Nombre->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Primer_Nombre->FldCaption(), $this->Primer_Nombre->ReqErrMsg));
		}
		if (!$this->Primer_Apellido->FldIsDetailKey && !is_null($this->Primer_Apellido->FormValue) && $this->Primer_Apellido->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Primer_Apellido->FldCaption(), $this->Primer_Apellido->ReqErrMsg));
		}
		if (!$this->Numero_Identificacion->FldIsDetailKey && !is_null($this->Numero_Identificacion->FormValue) && $this->Numero_Identificacion->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Numero_Identificacion->FldCaption(), $this->Numero_Identificacion->ReqErrMsg));
		}
		if (!ew_CheckDate($this->Fecha_Nacimiento->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Nacimiento->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Edad->FormValue)) {
			ew_AddMessage($gsFormError, $this->Edad->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Unidad_Edad->FormValue)) {
			ew_AddMessage($gsFormError, $this->Unidad_Edad->FldErrMsg());
		}
		if (!$this->Sexo->FldIsDetailKey && !is_null($this->Sexo->FormValue) && $this->Sexo->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Sexo->FldCaption(), $this->Sexo->ReqErrMsg));
		}
		if (!$this->Pais_Ocurrencia->FldIsDetailKey && !is_null($this->Pais_Ocurrencia->FormValue) && $this->Pais_Ocurrencia->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Pais_Ocurrencia->FldCaption(), $this->Pais_Ocurrencia->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->Pais_Ocurrencia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Pais_Ocurrencia->FldErrMsg());
		}
		if (!$this->Depto_Ocurrencia->FldIsDetailKey && !is_null($this->Depto_Ocurrencia->FormValue) && $this->Depto_Ocurrencia->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Depto_Ocurrencia->FldCaption(), $this->Depto_Ocurrencia->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->Depto_Ocurrencia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Depto_Ocurrencia->FldErrMsg());
		}
		if (!$this->Municipio_Ocurrencia->FldIsDetailKey && !is_null($this->Municipio_Ocurrencia->FormValue) && $this->Municipio_Ocurrencia->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Municipio_Ocurrencia->FldCaption(), $this->Municipio_Ocurrencia->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->Municipio_Ocurrencia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Municipio_Ocurrencia->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Area_Ocurrencia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Area_Ocurrencia->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Localidad->FormValue)) {
			ew_AddMessage($gsFormError, $this->Localidad->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Ocupacion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Ocupacion->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Pertenencia_Etnica->FormValue)) {
			ew_AddMessage($gsFormError, $this->Pertenencia_Etnica->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Grupo_Poblacional->FormValue)) {
			ew_AddMessage($gsFormError, $this->Grupo_Poblacional->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Depto_Residencia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Depto_Residencia->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Municipio_Residencia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Municipio_Residencia->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Consulta->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Consulta->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Inicio_Sintomas->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Inicio_Sintomas->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Clasificacion_Inicial->FormValue)) {
			ew_AddMessage($gsFormError, $this->Clasificacion_Inicial->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Hospitalizado->FormValue)) {
			ew_AddMessage($gsFormError, $this->Hospitalizado->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Hospitalizacion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Hospitalizacion->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Defuncion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Defuncion->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Numero_Certificado_Defuncion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Numero_Certificado_Defuncion->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Telefono_Profesional_Diligencia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Telefono_Profesional_Diligencia->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Ajuste->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Ajuste->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Cod_Evento->FormValue)) {
			ew_AddMessage($gsFormError, $this->Cod_Evento->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Notificacion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Notificacion->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Semana->FormValue)) {
			ew_AddMessage($gsFormError, $this->Semana->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Mecanismo_Probable_Transmision->FormValue)) {
			ew_AddMessage($gsFormError, $this->Mecanismo_Probable_Transmision->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Numero_Identificacion_Madre->FormValue)) {
			ew_AddMessage($gsFormError, $this->Numero_Identificacion_Madre->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Donador_Sangre_Ultimos_12_Meses->FormValue)) {
			ew_AddMessage($gsFormError, $this->Donador_Sangre_Ultimos_12_Meses->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Donacion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Donacion->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Recibio_Asesoria_Pre_Prueba->FormValue)) {
			ew_AddMessage($gsFormError, $this->Recibio_Asesoria_Pre_Prueba->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Recibio_Asesoria_Post_Prueba->FormValue)) {
			ew_AddMessage($gsFormError, $this->Recibio_Asesoria_Post_Prueba->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Tipo_Prueba->FormValue)) {
			ew_AddMessage($gsFormError, $this->Tipo_Prueba->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_Resultado_Confirmatorio->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Resultado_Confirmatorio->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Estado_Clinico_Notificacion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Estado_Clinico_Notificacion->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Hijos_Mujeres_Menores_5->FormValue)) {
			ew_AddMessage($gsFormError, $this->Hijos_Mujeres_Menores_5->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Hijos_Hombres_Menores_5->FormValue)) {
			ew_AddMessage($gsFormError, $this->Hijos_Hombres_Menores_5->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Embarazo_Actual->FormValue)) {
			ew_AddMessage($gsFormError, $this->Embarazo_Actual->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Antecedentes_Embarazo->FormValue)) {
			ew_AddMessage($gsFormError, $this->Antecedentes_Embarazo->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Numero_Semanas_Embarazo->FormValue)) {
			ew_AddMessage($gsFormError, $this->Numero_Semanas_Embarazo->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Candidiasis_esofagica->FormValue)) {
			ew_AddMessage($gsFormError, $this->Candidiasis_esofagica->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Candidiasis_vias_aereas->FormValue)) {
			ew_AddMessage($gsFormError, $this->Candidiasis_vias_aereas->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Tuberculosis_pulmonar->FormValue)) {
			ew_AddMessage($gsFormError, $this->Tuberculosis_pulmonar->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Cancer_cervical->FormValue)) {
			ew_AddMessage($gsFormError, $this->Cancer_cervical->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Tuberculosis_extrapulmonar->FormValue)) {
			ew_AddMessage($gsFormError, $this->Tuberculosis_extrapulmonar->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Coccidiomicosis->FormValue)) {
			ew_AddMessage($gsFormError, $this->Coccidiomicosis->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Citomegalovirosis->FormValue)) {
			ew_AddMessage($gsFormError, $this->Citomegalovirosis->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Retinitis_citomegalovirosis->FormValue)) {
			ew_AddMessage($gsFormError, $this->Retinitis_citomegalovirosis->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Encefalopatia->FormValue)) {
			ew_AddMessage($gsFormError, $this->Encefalopatia->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Otras_micobacterias->FormValue)) {
			ew_AddMessage($gsFormError, $this->Otras_micobacterias->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Histoplasmosis_Extrapulmonar->FormValue)) {
			ew_AddMessage($gsFormError, $this->Histoplasmosis_Extrapulmonar->FldErrMsg());
		}
		if (!ew_CheckInteger($this->isosporidiasis_cronica->FormValue)) {
			ew_AddMessage($gsFormError, $this->isosporidiasis_cronica->FldErrMsg());
		}
		if (!ew_CheckInteger($this->herpes_zoster->FormValue)) {
			ew_AddMessage($gsFormError, $this->herpes_zoster->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Histoplasmosis_diseminada->FormValue)) {
			ew_AddMessage($gsFormError, $this->Histoplasmosis_diseminada->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Linfoma_Burkitt->FormValue)) {
			ew_AddMessage($gsFormError, $this->Linfoma_Burkitt->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Neumonia_Pneumocystis->FormValue)) {
			ew_AddMessage($gsFormError, $this->Neumonia_Pneumocystis->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Neumonia_Recurrente->FormValue)) {
			ew_AddMessage($gsFormError, $this->Neumonia_Recurrente->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Linfoma_Inmunoblastico->FormValue)) {
			ew_AddMessage($gsFormError, $this->Linfoma_Inmunoblastico->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Criptosporidiasis_cronica->FormValue)) {
			ew_AddMessage($gsFormError, $this->Criptosporidiasis_cronica->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Criptococosis_Extrapulmonar->FormValue)) {
			ew_AddMessage($gsFormError, $this->Criptococosis_Extrapulmonar->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Sarcoma_Kaposi->FormValue)) {
			ew_AddMessage($gsFormError, $this->Sarcoma_Kaposi->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Sindrome_Emanciacion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Sindrome_Emanciacion->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Leucoencefalopatia_Multifocal->FormValue)) {
			ew_AddMessage($gsFormError, $this->Leucoencefalopatia_Multifocal->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Septicemia_recurrente->FormValue)) {
			ew_AddMessage($gsFormError, $this->Septicemia_recurrente->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Toxoplasmosis_cerebral->FormValue)) {
			ew_AddMessage($gsFormError, $this->Toxoplasmosis_cerebral->FldErrMsg());
		}
		if (!ew_CheckInteger($this->HepatitisB->FormValue)) {
			ew_AddMessage($gsFormError, $this->HepatitisB->FldErrMsg());
		}
		if (!ew_CheckInteger($this->HepatitisC->FormValue)) {
			ew_AddMessage($gsFormError, $this->HepatitisC->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Meningitis->FormValue)) {
			ew_AddMessage($gsFormError, $this->Meningitis->FldErrMsg());
		}
		if (!ew_CheckInteger($this->RecuentoCD4->FormValue)) {
			ew_AddMessage($gsFormError, $this->RecuentoCD4->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Actualmente_Seguimiento->FormValue)) {
			ew_AddMessage($gsFormError, $this->Actualmente_Seguimiento->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// Seguimiento
			$this->Seguimiento->SetDbValueDef($rsnew, $this->Seguimiento->CurrentValue, NULL, $this->Seguimiento->ReadOnly);

			// Primer_Nombre
			$this->Primer_Nombre->SetDbValueDef($rsnew, $this->Primer_Nombre->CurrentValue, "", $this->Primer_Nombre->ReadOnly);

			// Segundo_Nombre
			$this->Segundo_Nombre->SetDbValueDef($rsnew, $this->Segundo_Nombre->CurrentValue, NULL, $this->Segundo_Nombre->ReadOnly);

			// Primer_Apellido
			$this->Primer_Apellido->SetDbValueDef($rsnew, $this->Primer_Apellido->CurrentValue, "", $this->Primer_Apellido->ReadOnly);

			// Segundo_Apellido
			$this->Segundo_Apellido->SetDbValueDef($rsnew, $this->Segundo_Apellido->CurrentValue, NULL, $this->Segundo_Apellido->ReadOnly);

			// Tipo_Id
			$this->Tipo_Id->SetDbValueDef($rsnew, $this->Tipo_Id->CurrentValue, NULL, $this->Tipo_Id->ReadOnly);

			// Numero_Identificacion
			$this->Numero_Identificacion->SetDbValueDef($rsnew, $this->Numero_Identificacion->CurrentValue, "", $this->Numero_Identificacion->ReadOnly);

			// Telefono
			$this->Telefono->SetDbValueDef($rsnew, $this->Telefono->CurrentValue, NULL, $this->Telefono->ReadOnly);

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Nacimiento->CurrentValue, 5), NULL, $this->Fecha_Nacimiento->ReadOnly);

			// Edad
			$this->Edad->SetDbValueDef($rsnew, $this->Edad->CurrentValue, NULL, $this->Edad->ReadOnly);

			// Unidad_Edad
			$this->Unidad_Edad->SetDbValueDef($rsnew, $this->Unidad_Edad->CurrentValue, NULL, $this->Unidad_Edad->ReadOnly);

			// Sexo
			$this->Sexo->SetDbValueDef($rsnew, $this->Sexo->CurrentValue, "", $this->Sexo->ReadOnly);

			// Pais_Ocurrencia
			$this->Pais_Ocurrencia->SetDbValueDef($rsnew, $this->Pais_Ocurrencia->CurrentValue, 0, $this->Pais_Ocurrencia->ReadOnly);

			// Depto_Ocurrencia
			$this->Depto_Ocurrencia->SetDbValueDef($rsnew, $this->Depto_Ocurrencia->CurrentValue, 0, $this->Depto_Ocurrencia->ReadOnly);

			// Municipio_Ocurrencia
			$this->Municipio_Ocurrencia->SetDbValueDef($rsnew, $this->Municipio_Ocurrencia->CurrentValue, 0, $this->Municipio_Ocurrencia->ReadOnly);

			// Area_Ocurrencia
			$this->Area_Ocurrencia->SetDbValueDef($rsnew, $this->Area_Ocurrencia->CurrentValue, NULL, $this->Area_Ocurrencia->ReadOnly);

			// Localidad
			$this->Localidad->SetDbValueDef($rsnew, $this->Localidad->CurrentValue, NULL, $this->Localidad->ReadOnly);

			// Centro_Poblado
			$this->Centro_Poblado->SetDbValueDef($rsnew, $this->Centro_Poblado->CurrentValue, NULL, $this->Centro_Poblado->ReadOnly);

			// Vereda
			$this->Vereda->SetDbValueDef($rsnew, $this->Vereda->CurrentValue, NULL, $this->Vereda->ReadOnly);

			// Barrio
			$this->Barrio->SetDbValueDef($rsnew, $this->Barrio->CurrentValue, NULL, $this->Barrio->ReadOnly);

			// Direccion_Residencia
			$this->Direccion_Residencia->SetDbValueDef($rsnew, $this->Direccion_Residencia->CurrentValue, NULL, $this->Direccion_Residencia->ReadOnly);

			// Ocupacion
			$this->Ocupacion->SetDbValueDef($rsnew, $this->Ocupacion->CurrentValue, NULL, $this->Ocupacion->ReadOnly);

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->SetDbValueDef($rsnew, $this->Tipo_Regimen_Salud->CurrentValue, NULL, $this->Tipo_Regimen_Salud->ReadOnly);

			// Cod_Administradora
			$this->Cod_Administradora->SetDbValueDef($rsnew, $this->Cod_Administradora->CurrentValue, NULL, $this->Cod_Administradora->ReadOnly);

			// Pertenencia_Etnica
			$this->Pertenencia_Etnica->SetDbValueDef($rsnew, $this->Pertenencia_Etnica->CurrentValue, NULL, $this->Pertenencia_Etnica->ReadOnly);

			// Grupo_Poblacional
			$this->Grupo_Poblacional->SetDbValueDef($rsnew, $this->Grupo_Poblacional->CurrentValue, NULL, $this->Grupo_Poblacional->ReadOnly);

			// Depto_Residencia
			$this->Depto_Residencia->SetDbValueDef($rsnew, $this->Depto_Residencia->CurrentValue, NULL, $this->Depto_Residencia->ReadOnly);

			// Municipio_Residencia
			$this->Municipio_Residencia->SetDbValueDef($rsnew, $this->Municipio_Residencia->CurrentValue, NULL, $this->Municipio_Residencia->ReadOnly);

			// Fecha_Consulta
			$this->Fecha_Consulta->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Consulta->CurrentValue, 5), NULL, $this->Fecha_Consulta->ReadOnly);

			// Fecha_Inicio_Sintomas
			$this->Fecha_Inicio_Sintomas->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Inicio_Sintomas->CurrentValue, 5), NULL, $this->Fecha_Inicio_Sintomas->ReadOnly);

			// Clasificacion_Inicial
			$this->Clasificacion_Inicial->SetDbValueDef($rsnew, $this->Clasificacion_Inicial->CurrentValue, NULL, $this->Clasificacion_Inicial->ReadOnly);

			// Hospitalizado
			$this->Hospitalizado->SetDbValueDef($rsnew, $this->Hospitalizado->CurrentValue, NULL, $this->Hospitalizado->ReadOnly);

			// Fecha_Hospitalizacion
			$this->Fecha_Hospitalizacion->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Hospitalizacion->CurrentValue, 5), NULL, $this->Fecha_Hospitalizacion->ReadOnly);

			// Condicion_Final
			$this->Condicion_Final->SetDbValueDef($rsnew, $this->Condicion_Final->CurrentValue, NULL, $this->Condicion_Final->ReadOnly);

			// Fecha_Defuncion
			$this->Fecha_Defuncion->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Defuncion->CurrentValue, 5), NULL, $this->Fecha_Defuncion->ReadOnly);

			// Numero_Certificado_Defuncion
			$this->Numero_Certificado_Defuncion->SetDbValueDef($rsnew, $this->Numero_Certificado_Defuncion->CurrentValue, NULL, $this->Numero_Certificado_Defuncion->ReadOnly);

			// Causa_Basica_Muerte_CIEX
			$this->Causa_Basica_Muerte_CIEX->SetDbValueDef($rsnew, $this->Causa_Basica_Muerte_CIEX->CurrentValue, NULL, $this->Causa_Basica_Muerte_CIEX->ReadOnly);

			// Nombre_Profesional_Diligencia
			$this->Nombre_Profesional_Diligencia->SetDbValueDef($rsnew, $this->Nombre_Profesional_Diligencia->CurrentValue, NULL, $this->Nombre_Profesional_Diligencia->ReadOnly);

			// Telefono_Profesional_Diligencia
			$this->Telefono_Profesional_Diligencia->SetDbValueDef($rsnew, $this->Telefono_Profesional_Diligencia->CurrentValue, NULL, $this->Telefono_Profesional_Diligencia->ReadOnly);

			// Seguimiento_Clasificacion_Final
			$this->Seguimiento_Clasificacion_Final->SetDbValueDef($rsnew, $this->Seguimiento_Clasificacion_Final->CurrentValue, NULL, $this->Seguimiento_Clasificacion_Final->ReadOnly);

			// Fecha_Ajuste
			$this->Fecha_Ajuste->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Ajuste->CurrentValue, 5), NULL, $this->Fecha_Ajuste->ReadOnly);

			// Codigo_UPGD
			$this->Codigo_UPGD->SetDbValueDef($rsnew, $this->Codigo_UPGD->CurrentValue, NULL, $this->Codigo_UPGD->ReadOnly);

			// Nombre_Evento
			$this->Nombre_Evento->SetDbValueDef($rsnew, $this->Nombre_Evento->CurrentValue, NULL, $this->Nombre_Evento->ReadOnly);

			// Cod_Evento
			$this->Cod_Evento->SetDbValueDef($rsnew, $this->Cod_Evento->CurrentValue, NULL, $this->Cod_Evento->ReadOnly);

			// Fecha_Notificacion
			$this->Fecha_Notificacion->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Notificacion->CurrentValue, 5), NULL, $this->Fecha_Notificacion->ReadOnly);

			// Semana
			$this->Semana->SetDbValueDef($rsnew, $this->Semana->CurrentValue, NULL, $this->Semana->ReadOnly);

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->SetDbValueDef($rsnew, $this->Mecanismo_Probable_Transmision->CurrentValue, NULL, $this->Mecanismo_Probable_Transmision->ReadOnly);

			// Nombre_Madre
			$this->Nombre_Madre->SetDbValueDef($rsnew, $this->Nombre_Madre->CurrentValue, NULL, $this->Nombre_Madre->ReadOnly);

			// Tipo_Id_Madre
			$this->Tipo_Id_Madre->SetDbValueDef($rsnew, $this->Tipo_Id_Madre->CurrentValue, NULL, $this->Tipo_Id_Madre->ReadOnly);

			// Numero_Identificacion_Madre
			$this->Numero_Identificacion_Madre->SetDbValueDef($rsnew, $this->Numero_Identificacion_Madre->CurrentValue, NULL, $this->Numero_Identificacion_Madre->ReadOnly);

			// Indentidad_Genero
			$this->Indentidad_Genero->SetDbValueDef($rsnew, $this->Indentidad_Genero->CurrentValue, NULL, $this->Indentidad_Genero->ReadOnly);

			// Donador_Sangre_Ultimos_12_Meses
			$this->Donador_Sangre_Ultimos_12_Meses->SetDbValueDef($rsnew, $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue, NULL, $this->Donador_Sangre_Ultimos_12_Meses->ReadOnly);

			// Fecha_Donacion
			$this->Fecha_Donacion->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Donacion->CurrentValue, 5), NULL, $this->Fecha_Donacion->ReadOnly);

			// Nombre_Institucion_Donacion
			$this->Nombre_Institucion_Donacion->SetDbValueDef($rsnew, $this->Nombre_Institucion_Donacion->CurrentValue, NULL, $this->Nombre_Institucion_Donacion->ReadOnly);

			// Recibio_Asesoria_Pre_Prueba
			$this->Recibio_Asesoria_Pre_Prueba->SetDbValueDef($rsnew, $this->Recibio_Asesoria_Pre_Prueba->CurrentValue, NULL, $this->Recibio_Asesoria_Pre_Prueba->ReadOnly);

			// Recibio_Asesoria_Post_Prueba
			$this->Recibio_Asesoria_Post_Prueba->SetDbValueDef($rsnew, $this->Recibio_Asesoria_Post_Prueba->CurrentValue, NULL, $this->Recibio_Asesoria_Post_Prueba->ReadOnly);

			// Tipo_Prueba
			$this->Tipo_Prueba->SetDbValueDef($rsnew, $this->Tipo_Prueba->CurrentValue, NULL, $this->Tipo_Prueba->ReadOnly);

			// Fecha_Resultado_Confirmatorio
			$this->Fecha_Resultado_Confirmatorio->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Resultado_Confirmatorio->CurrentValue, 5), NULL, $this->Fecha_Resultado_Confirmatorio->ReadOnly);

			// Valor_Carga_Viral
			$this->Valor_Carga_Viral->SetDbValueDef($rsnew, $this->Valor_Carga_Viral->CurrentValue, NULL, $this->Valor_Carga_Viral->ReadOnly);

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->SetDbValueDef($rsnew, $this->Estado_Clinico_Notificacion->CurrentValue, NULL, $this->Estado_Clinico_Notificacion->ReadOnly);

			// Hijos_Mujeres_Menores_5
			$this->Hijos_Mujeres_Menores_5->SetDbValueDef($rsnew, $this->Hijos_Mujeres_Menores_5->CurrentValue, NULL, $this->Hijos_Mujeres_Menores_5->ReadOnly);

			// Hijos_Hombres_Menores_5
			$this->Hijos_Hombres_Menores_5->SetDbValueDef($rsnew, $this->Hijos_Hombres_Menores_5->CurrentValue, NULL, $this->Hijos_Hombres_Menores_5->ReadOnly);

			// Embarazo_Actual
			$this->Embarazo_Actual->SetDbValueDef($rsnew, $this->Embarazo_Actual->CurrentValue, NULL, $this->Embarazo_Actual->ReadOnly);

			// Antecedentes_Embarazo
			$this->Antecedentes_Embarazo->SetDbValueDef($rsnew, $this->Antecedentes_Embarazo->CurrentValue, NULL, $this->Antecedentes_Embarazo->ReadOnly);

			// Numero_Semanas_Embarazo
			$this->Numero_Semanas_Embarazo->SetDbValueDef($rsnew, $this->Numero_Semanas_Embarazo->CurrentValue, NULL, $this->Numero_Semanas_Embarazo->ReadOnly);

			// Candidiasis_esofagica
			$this->Candidiasis_esofagica->SetDbValueDef($rsnew, $this->Candidiasis_esofagica->CurrentValue, NULL, $this->Candidiasis_esofagica->ReadOnly);

			// Candidiasis_vias_aereas
			$this->Candidiasis_vias_aereas->SetDbValueDef($rsnew, $this->Candidiasis_vias_aereas->CurrentValue, NULL, $this->Candidiasis_vias_aereas->ReadOnly);

			// Tuberculosis_pulmonar
			$this->Tuberculosis_pulmonar->SetDbValueDef($rsnew, $this->Tuberculosis_pulmonar->CurrentValue, NULL, $this->Tuberculosis_pulmonar->ReadOnly);

			// Cancer_cervical
			$this->Cancer_cervical->SetDbValueDef($rsnew, $this->Cancer_cervical->CurrentValue, NULL, $this->Cancer_cervical->ReadOnly);

			// Tuberculosis_extrapulmonar
			$this->Tuberculosis_extrapulmonar->SetDbValueDef($rsnew, $this->Tuberculosis_extrapulmonar->CurrentValue, NULL, $this->Tuberculosis_extrapulmonar->ReadOnly);

			// Coccidiomicosis
			$this->Coccidiomicosis->SetDbValueDef($rsnew, $this->Coccidiomicosis->CurrentValue, NULL, $this->Coccidiomicosis->ReadOnly);

			// Citomegalovirosis
			$this->Citomegalovirosis->SetDbValueDef($rsnew, $this->Citomegalovirosis->CurrentValue, NULL, $this->Citomegalovirosis->ReadOnly);

			// Retinitis_citomegalovirosis
			$this->Retinitis_citomegalovirosis->SetDbValueDef($rsnew, $this->Retinitis_citomegalovirosis->CurrentValue, NULL, $this->Retinitis_citomegalovirosis->ReadOnly);

			// Encefalopatia
			$this->Encefalopatia->SetDbValueDef($rsnew, $this->Encefalopatia->CurrentValue, NULL, $this->Encefalopatia->ReadOnly);

			// Otras_micobacterias
			$this->Otras_micobacterias->SetDbValueDef($rsnew, $this->Otras_micobacterias->CurrentValue, NULL, $this->Otras_micobacterias->ReadOnly);

			// Histoplasmosis_Extrapulmonar
			$this->Histoplasmosis_Extrapulmonar->SetDbValueDef($rsnew, $this->Histoplasmosis_Extrapulmonar->CurrentValue, NULL, $this->Histoplasmosis_Extrapulmonar->ReadOnly);

			// isosporidiasis_cronica
			$this->isosporidiasis_cronica->SetDbValueDef($rsnew, $this->isosporidiasis_cronica->CurrentValue, NULL, $this->isosporidiasis_cronica->ReadOnly);

			// herpes_zoster
			$this->herpes_zoster->SetDbValueDef($rsnew, $this->herpes_zoster->CurrentValue, NULL, $this->herpes_zoster->ReadOnly);

			// Histoplasmosis_diseminada
			$this->Histoplasmosis_diseminada->SetDbValueDef($rsnew, $this->Histoplasmosis_diseminada->CurrentValue, NULL, $this->Histoplasmosis_diseminada->ReadOnly);

			// Linfoma_Burkitt
			$this->Linfoma_Burkitt->SetDbValueDef($rsnew, $this->Linfoma_Burkitt->CurrentValue, NULL, $this->Linfoma_Burkitt->ReadOnly);

			// Neumonia_Pneumocystis
			$this->Neumonia_Pneumocystis->SetDbValueDef($rsnew, $this->Neumonia_Pneumocystis->CurrentValue, NULL, $this->Neumonia_Pneumocystis->ReadOnly);

			// Neumonia_Recurrente
			$this->Neumonia_Recurrente->SetDbValueDef($rsnew, $this->Neumonia_Recurrente->CurrentValue, NULL, $this->Neumonia_Recurrente->ReadOnly);

			// Linfoma_Inmunoblastico
			$this->Linfoma_Inmunoblastico->SetDbValueDef($rsnew, $this->Linfoma_Inmunoblastico->CurrentValue, NULL, $this->Linfoma_Inmunoblastico->ReadOnly);

			// Criptosporidiasis_cronica
			$this->Criptosporidiasis_cronica->SetDbValueDef($rsnew, $this->Criptosporidiasis_cronica->CurrentValue, NULL, $this->Criptosporidiasis_cronica->ReadOnly);

			// Criptococosis_Extrapulmonar
			$this->Criptococosis_Extrapulmonar->SetDbValueDef($rsnew, $this->Criptococosis_Extrapulmonar->CurrentValue, NULL, $this->Criptococosis_Extrapulmonar->ReadOnly);

			// Sarcoma_Kaposi
			$this->Sarcoma_Kaposi->SetDbValueDef($rsnew, $this->Sarcoma_Kaposi->CurrentValue, NULL, $this->Sarcoma_Kaposi->ReadOnly);

			// Sindrome_Emanciacion
			$this->Sindrome_Emanciacion->SetDbValueDef($rsnew, $this->Sindrome_Emanciacion->CurrentValue, NULL, $this->Sindrome_Emanciacion->ReadOnly);

			// Leucoencefalopatia_Multifocal
			$this->Leucoencefalopatia_Multifocal->SetDbValueDef($rsnew, $this->Leucoencefalopatia_Multifocal->CurrentValue, NULL, $this->Leucoencefalopatia_Multifocal->ReadOnly);

			// Septicemia_recurrente
			$this->Septicemia_recurrente->SetDbValueDef($rsnew, $this->Septicemia_recurrente->CurrentValue, NULL, $this->Septicemia_recurrente->ReadOnly);

			// Toxoplasmosis_cerebral
			$this->Toxoplasmosis_cerebral->SetDbValueDef($rsnew, $this->Toxoplasmosis_cerebral->CurrentValue, NULL, $this->Toxoplasmosis_cerebral->ReadOnly);

			// HepatitisB
			$this->HepatitisB->SetDbValueDef($rsnew, $this->HepatitisB->CurrentValue, NULL, $this->HepatitisB->ReadOnly);

			// HepatitisC
			$this->HepatitisC->SetDbValueDef($rsnew, $this->HepatitisC->CurrentValue, NULL, $this->HepatitisC->ReadOnly);

			// Meningitis
			$this->Meningitis->SetDbValueDef($rsnew, $this->Meningitis->CurrentValue, NULL, $this->Meningitis->ReadOnly);

			// RecuentoCD4
			$this->RecuentoCD4->SetDbValueDef($rsnew, $this->RecuentoCD4->CurrentValue, NULL, $this->RecuentoCD4->ReadOnly);

			// Registrado_Por
			$this->Registrado_Por->SetDbValueDef($rsnew, $this->Registrado_Por->CurrentValue, NULL, $this->Registrado_Por->ReadOnly);

			// Actualmente_Seguimiento
			$this->Actualmente_Seguimiento->SetDbValueDef($rsnew, $this->Actualmente_Seguimiento->CurrentValue, NULL, $this->Actualmente_Seguimiento->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("registropruebalist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($registroprueba_edit)) $registroprueba_edit = new cregistroprueba_edit();

// Page init
$registroprueba_edit->Page_Init();

// Page main
$registroprueba_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$registroprueba_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fregistropruebaedit = new ew_Form("fregistropruebaedit", "edit");

// Validate form
fregistropruebaedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_Seguimiento");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Seguimiento->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Primer_Nombre");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $registroprueba->Primer_Nombre->FldCaption(), $registroprueba->Primer_Nombre->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Primer_Apellido");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $registroprueba->Primer_Apellido->FldCaption(), $registroprueba->Primer_Apellido->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Numero_Identificacion");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $registroprueba->Numero_Identificacion->FldCaption(), $registroprueba->Numero_Identificacion->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Nacimiento");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Nacimiento->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Edad");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Edad->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Unidad_Edad");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Unidad_Edad->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Sexo");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $registroprueba->Sexo->FldCaption(), $registroprueba->Sexo->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Pais_Ocurrencia");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $registroprueba->Pais_Ocurrencia->FldCaption(), $registroprueba->Pais_Ocurrencia->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Pais_Ocurrencia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Pais_Ocurrencia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Depto_Ocurrencia");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $registroprueba->Depto_Ocurrencia->FldCaption(), $registroprueba->Depto_Ocurrencia->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Depto_Ocurrencia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Depto_Ocurrencia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Municipio_Ocurrencia");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $registroprueba->Municipio_Ocurrencia->FldCaption(), $registroprueba->Municipio_Ocurrencia->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Municipio_Ocurrencia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Municipio_Ocurrencia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Area_Ocurrencia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Area_Ocurrencia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Localidad");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Localidad->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Ocupacion");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Ocupacion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Pertenencia_Etnica");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Pertenencia_Etnica->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Grupo_Poblacional");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Grupo_Poblacional->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Depto_Residencia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Depto_Residencia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Municipio_Residencia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Municipio_Residencia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Consulta");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Consulta->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Inicio_Sintomas");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Inicio_Sintomas->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Clasificacion_Inicial");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Clasificacion_Inicial->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Hospitalizado");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Hospitalizado->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Hospitalizacion");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Hospitalizacion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Defuncion");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Defuncion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Numero_Certificado_Defuncion");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Numero_Certificado_Defuncion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Telefono_Profesional_Diligencia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Telefono_Profesional_Diligencia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Ajuste");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Ajuste->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Cod_Evento");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Cod_Evento->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Notificacion");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Notificacion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Semana");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Semana->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Mecanismo_Probable_Transmision");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Mecanismo_Probable_Transmision->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Numero_Identificacion_Madre");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Numero_Identificacion_Madre->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Donador_Sangre_Ultimos_12_Meses");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Donador_Sangre_Ultimos_12_Meses->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Donacion");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Donacion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Recibio_Asesoria_Pre_Prueba");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Recibio_Asesoria_Pre_Prueba->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Recibio_Asesoria_Post_Prueba");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Recibio_Asesoria_Post_Prueba->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Tipo_Prueba");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Tipo_Prueba->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Resultado_Confirmatorio");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Fecha_Resultado_Confirmatorio->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Estado_Clinico_Notificacion");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Estado_Clinico_Notificacion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Hijos_Mujeres_Menores_5");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Hijos_Mujeres_Menores_5->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Hijos_Hombres_Menores_5");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Hijos_Hombres_Menores_5->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Embarazo_Actual");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Embarazo_Actual->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Antecedentes_Embarazo");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Antecedentes_Embarazo->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Numero_Semanas_Embarazo");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Numero_Semanas_Embarazo->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Candidiasis_esofagica");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Candidiasis_esofagica->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Candidiasis_vias_aereas");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Candidiasis_vias_aereas->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Tuberculosis_pulmonar");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Tuberculosis_pulmonar->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Cancer_cervical");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Cancer_cervical->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Tuberculosis_extrapulmonar");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Tuberculosis_extrapulmonar->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Coccidiomicosis");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Coccidiomicosis->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Citomegalovirosis");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Citomegalovirosis->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Retinitis_citomegalovirosis");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Retinitis_citomegalovirosis->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Encefalopatia");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Encefalopatia->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Otras_micobacterias");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Otras_micobacterias->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Histoplasmosis_Extrapulmonar");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Histoplasmosis_Extrapulmonar->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_isosporidiasis_cronica");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->isosporidiasis_cronica->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_herpes_zoster");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->herpes_zoster->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Histoplasmosis_diseminada");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Histoplasmosis_diseminada->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Linfoma_Burkitt");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Linfoma_Burkitt->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Neumonia_Pneumocystis");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Neumonia_Pneumocystis->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Neumonia_Recurrente");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Neumonia_Recurrente->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Linfoma_Inmunoblastico");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Linfoma_Inmunoblastico->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Criptosporidiasis_cronica");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Criptosporidiasis_cronica->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Criptococosis_Extrapulmonar");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Criptococosis_Extrapulmonar->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Sarcoma_Kaposi");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Sarcoma_Kaposi->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Sindrome_Emanciacion");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Sindrome_Emanciacion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Leucoencefalopatia_Multifocal");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Leucoencefalopatia_Multifocal->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Septicemia_recurrente");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Septicemia_recurrente->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Toxoplasmosis_cerebral");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Toxoplasmosis_cerebral->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_HepatitisB");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->HepatitisB->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_HepatitisC");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->HepatitisC->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Meningitis");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Meningitis->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_RecuentoCD4");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->RecuentoCD4->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Actualmente_Seguimiento");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($registroprueba->Actualmente_Seguimiento->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fregistropruebaedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fregistropruebaedit.ValidateRequired = true;
<?php } else { ?>
fregistropruebaedit.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php $registroprueba_edit->ShowPageHeader(); ?>
<?php
$registroprueba_edit->ShowMessage();
?>
<form name="ewPagerForm" class="form-horizontal ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($registroprueba_edit->Pager)) $registroprueba_edit->Pager = new cPrevNextPager($registroprueba_edit->StartRec, $registroprueba_edit->DisplayRecs, $registroprueba_edit->TotalRecs) ?>
<?php if ($registroprueba_edit->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($registroprueba_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $registroprueba_edit->PageUrl() ?>start=<?php echo $registroprueba_edit->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($registroprueba_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $registroprueba_edit->PageUrl() ?>start=<?php echo $registroprueba_edit->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $registroprueba_edit->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($registroprueba_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $registroprueba_edit->PageUrl() ?>start=<?php echo $registroprueba_edit->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($registroprueba_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $registroprueba_edit->PageUrl() ?>start=<?php echo $registroprueba_edit->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $registroprueba_edit->Pager->PageCount ?></span>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<form name="fregistropruebaedit" id="fregistropruebaedit" class="<?php echo $registroprueba_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($registroprueba_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $registroprueba_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="registroprueba">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<div>
<?php if ($registroprueba->Consecutivo->Visible) { // Consecutivo ?>
	<div id="r_Consecutivo" class="form-group">
		<label id="elh_registroprueba_Consecutivo" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Consecutivo->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Consecutivo->CellAttributes() ?>>
<span id="el_registroprueba_Consecutivo">
<span<?php echo $registroprueba->Consecutivo->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $registroprueba->Consecutivo->EditValue ?></p></span>
</span>
<input type="hidden" data-table="registroprueba" data-field="x_Consecutivo" name="x_Consecutivo" id="x_Consecutivo" value="<?php echo ew_HtmlEncode($registroprueba->Consecutivo->CurrentValue) ?>">
<?php echo $registroprueba->Consecutivo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Seguimiento->Visible) { // Seguimiento ?>
	<div id="r_Seguimiento" class="form-group">
		<label id="elh_registroprueba_Seguimiento" for="x_Seguimiento" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Seguimiento->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Seguimiento->CellAttributes() ?>>
<span id="el_registroprueba_Seguimiento">
<input type="text" data-table="registroprueba" data-field="x_Seguimiento" name="x_Seguimiento" id="x_Seguimiento" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Seguimiento->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Seguimiento->EditValue ?>"<?php echo $registroprueba->Seguimiento->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Seguimiento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Primer_Nombre->Visible) { // Primer_Nombre ?>
	<div id="r_Primer_Nombre" class="form-group">
		<label id="elh_registroprueba_Primer_Nombre" for="x_Primer_Nombre" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Primer_Nombre->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Primer_Nombre->CellAttributes() ?>>
<span id="el_registroprueba_Primer_Nombre">
<input type="text" data-table="registroprueba" data-field="x_Primer_Nombre" name="x_Primer_Nombre" id="x_Primer_Nombre" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Primer_Nombre->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Primer_Nombre->EditValue ?>"<?php echo $registroprueba->Primer_Nombre->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Primer_Nombre->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Segundo_Nombre->Visible) { // Segundo_Nombre ?>
	<div id="r_Segundo_Nombre" class="form-group">
		<label id="elh_registroprueba_Segundo_Nombre" for="x_Segundo_Nombre" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Segundo_Nombre->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Segundo_Nombre->CellAttributes() ?>>
<span id="el_registroprueba_Segundo_Nombre">
<input type="text" data-table="registroprueba" data-field="x_Segundo_Nombre" name="x_Segundo_Nombre" id="x_Segundo_Nombre" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Segundo_Nombre->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Segundo_Nombre->EditValue ?>"<?php echo $registroprueba->Segundo_Nombre->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Segundo_Nombre->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Primer_Apellido->Visible) { // Primer_Apellido ?>
	<div id="r_Primer_Apellido" class="form-group">
		<label id="elh_registroprueba_Primer_Apellido" for="x_Primer_Apellido" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Primer_Apellido->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Primer_Apellido->CellAttributes() ?>>
<span id="el_registroprueba_Primer_Apellido">
<input type="text" data-table="registroprueba" data-field="x_Primer_Apellido" name="x_Primer_Apellido" id="x_Primer_Apellido" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Primer_Apellido->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Primer_Apellido->EditValue ?>"<?php echo $registroprueba->Primer_Apellido->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Primer_Apellido->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Segundo_Apellido->Visible) { // Segundo_Apellido ?>
	<div id="r_Segundo_Apellido" class="form-group">
		<label id="elh_registroprueba_Segundo_Apellido" for="x_Segundo_Apellido" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Segundo_Apellido->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Segundo_Apellido->CellAttributes() ?>>
<span id="el_registroprueba_Segundo_Apellido">
<input type="text" data-table="registroprueba" data-field="x_Segundo_Apellido" name="x_Segundo_Apellido" id="x_Segundo_Apellido" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Segundo_Apellido->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Segundo_Apellido->EditValue ?>"<?php echo $registroprueba->Segundo_Apellido->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Segundo_Apellido->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Tipo_Id->Visible) { // Tipo_Id ?>
	<div id="r_Tipo_Id" class="form-group">
		<label id="elh_registroprueba_Tipo_Id" for="x_Tipo_Id" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Tipo_Id->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Tipo_Id->CellAttributes() ?>>
<span id="el_registroprueba_Tipo_Id">
<input type="text" data-table="registroprueba" data-field="x_Tipo_Id" name="x_Tipo_Id" id="x_Tipo_Id" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($registroprueba->Tipo_Id->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Tipo_Id->EditValue ?>"<?php echo $registroprueba->Tipo_Id->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Tipo_Id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Numero_Identificacion->Visible) { // Numero_Identificacion ?>
	<div id="r_Numero_Identificacion" class="form-group">
		<label id="elh_registroprueba_Numero_Identificacion" for="x_Numero_Identificacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Numero_Identificacion->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Numero_Identificacion->CellAttributes() ?>>
<span id="el_registroprueba_Numero_Identificacion">
<input type="text" data-table="registroprueba" data-field="x_Numero_Identificacion" name="x_Numero_Identificacion" id="x_Numero_Identificacion" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($registroprueba->Numero_Identificacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Numero_Identificacion->EditValue ?>"<?php echo $registroprueba->Numero_Identificacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Numero_Identificacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Telefono->Visible) { // Telefono ?>
	<div id="r_Telefono" class="form-group">
		<label id="elh_registroprueba_Telefono" for="x_Telefono" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Telefono->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Telefono->CellAttributes() ?>>
<span id="el_registroprueba_Telefono">
<input type="text" data-table="registroprueba" data-field="x_Telefono" name="x_Telefono" id="x_Telefono" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Telefono->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Telefono->EditValue ?>"<?php echo $registroprueba->Telefono->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Telefono->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Nacimiento->Visible) { // Fecha_Nacimiento ?>
	<div id="r_Fecha_Nacimiento" class="form-group">
		<label id="elh_registroprueba_Fecha_Nacimiento" for="x_Fecha_Nacimiento" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Nacimiento->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Nacimiento->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Nacimiento">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Nacimiento" data-format="5" name="x_Fecha_Nacimiento" id="x_Fecha_Nacimiento" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Nacimiento->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Nacimiento->EditValue ?>"<?php echo $registroprueba->Fecha_Nacimiento->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Nacimiento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Edad->Visible) { // Edad ?>
	<div id="r_Edad" class="form-group">
		<label id="elh_registroprueba_Edad" for="x_Edad" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Edad->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Edad->CellAttributes() ?>>
<span id="el_registroprueba_Edad">
<input type="text" data-table="registroprueba" data-field="x_Edad" name="x_Edad" id="x_Edad" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Edad->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Edad->EditValue ?>"<?php echo $registroprueba->Edad->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Edad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Unidad_Edad->Visible) { // Unidad_Edad ?>
	<div id="r_Unidad_Edad" class="form-group">
		<label id="elh_registroprueba_Unidad_Edad" for="x_Unidad_Edad" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Unidad_Edad->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Unidad_Edad->CellAttributes() ?>>
<span id="el_registroprueba_Unidad_Edad">
<input type="text" data-table="registroprueba" data-field="x_Unidad_Edad" name="x_Unidad_Edad" id="x_Unidad_Edad" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Unidad_Edad->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Unidad_Edad->EditValue ?>"<?php echo $registroprueba->Unidad_Edad->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Unidad_Edad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Sexo->Visible) { // Sexo ?>
	<div id="r_Sexo" class="form-group">
		<label id="elh_registroprueba_Sexo" for="x_Sexo" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Sexo->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Sexo->CellAttributes() ?>>
<span id="el_registroprueba_Sexo">
<input type="text" data-table="registroprueba" data-field="x_Sexo" name="x_Sexo" id="x_Sexo" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($registroprueba->Sexo->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Sexo->EditValue ?>"<?php echo $registroprueba->Sexo->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Sexo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Pais_Ocurrencia->Visible) { // Pais_Ocurrencia ?>
	<div id="r_Pais_Ocurrencia" class="form-group">
		<label id="elh_registroprueba_Pais_Ocurrencia" for="x_Pais_Ocurrencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Pais_Ocurrencia->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Pais_Ocurrencia->CellAttributes() ?>>
<span id="el_registroprueba_Pais_Ocurrencia">
<input type="text" data-table="registroprueba" data-field="x_Pais_Ocurrencia" name="x_Pais_Ocurrencia" id="x_Pais_Ocurrencia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Pais_Ocurrencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Pais_Ocurrencia->EditValue ?>"<?php echo $registroprueba->Pais_Ocurrencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Pais_Ocurrencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Depto_Ocurrencia->Visible) { // Depto_Ocurrencia ?>
	<div id="r_Depto_Ocurrencia" class="form-group">
		<label id="elh_registroprueba_Depto_Ocurrencia" for="x_Depto_Ocurrencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Depto_Ocurrencia->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Depto_Ocurrencia->CellAttributes() ?>>
<span id="el_registroprueba_Depto_Ocurrencia">
<input type="text" data-table="registroprueba" data-field="x_Depto_Ocurrencia" name="x_Depto_Ocurrencia" id="x_Depto_Ocurrencia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Depto_Ocurrencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Depto_Ocurrencia->EditValue ?>"<?php echo $registroprueba->Depto_Ocurrencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Depto_Ocurrencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Municipio_Ocurrencia->Visible) { // Municipio_Ocurrencia ?>
	<div id="r_Municipio_Ocurrencia" class="form-group">
		<label id="elh_registroprueba_Municipio_Ocurrencia" for="x_Municipio_Ocurrencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Municipio_Ocurrencia->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Municipio_Ocurrencia->CellAttributes() ?>>
<span id="el_registroprueba_Municipio_Ocurrencia">
<input type="text" data-table="registroprueba" data-field="x_Municipio_Ocurrencia" name="x_Municipio_Ocurrencia" id="x_Municipio_Ocurrencia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Municipio_Ocurrencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Municipio_Ocurrencia->EditValue ?>"<?php echo $registroprueba->Municipio_Ocurrencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Municipio_Ocurrencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Area_Ocurrencia->Visible) { // Area_Ocurrencia ?>
	<div id="r_Area_Ocurrencia" class="form-group">
		<label id="elh_registroprueba_Area_Ocurrencia" for="x_Area_Ocurrencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Area_Ocurrencia->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Area_Ocurrencia->CellAttributes() ?>>
<span id="el_registroprueba_Area_Ocurrencia">
<input type="text" data-table="registroprueba" data-field="x_Area_Ocurrencia" name="x_Area_Ocurrencia" id="x_Area_Ocurrencia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Area_Ocurrencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Area_Ocurrencia->EditValue ?>"<?php echo $registroprueba->Area_Ocurrencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Area_Ocurrencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Localidad->Visible) { // Localidad ?>
	<div id="r_Localidad" class="form-group">
		<label id="elh_registroprueba_Localidad" for="x_Localidad" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Localidad->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Localidad->CellAttributes() ?>>
<span id="el_registroprueba_Localidad">
<input type="text" data-table="registroprueba" data-field="x_Localidad" name="x_Localidad" id="x_Localidad" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Localidad->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Localidad->EditValue ?>"<?php echo $registroprueba->Localidad->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Localidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Centro_Poblado->Visible) { // Centro_Poblado ?>
	<div id="r_Centro_Poblado" class="form-group">
		<label id="elh_registroprueba_Centro_Poblado" for="x_Centro_Poblado" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Centro_Poblado->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Centro_Poblado->CellAttributes() ?>>
<span id="el_registroprueba_Centro_Poblado">
<input type="text" data-table="registroprueba" data-field="x_Centro_Poblado" name="x_Centro_Poblado" id="x_Centro_Poblado" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Centro_Poblado->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Centro_Poblado->EditValue ?>"<?php echo $registroprueba->Centro_Poblado->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Centro_Poblado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Vereda->Visible) { // Vereda ?>
	<div id="r_Vereda" class="form-group">
		<label id="elh_registroprueba_Vereda" for="x_Vereda" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Vereda->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Vereda->CellAttributes() ?>>
<span id="el_registroprueba_Vereda">
<input type="text" data-table="registroprueba" data-field="x_Vereda" name="x_Vereda" id="x_Vereda" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Vereda->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Vereda->EditValue ?>"<?php echo $registroprueba->Vereda->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Vereda->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Barrio->Visible) { // Barrio ?>
	<div id="r_Barrio" class="form-group">
		<label id="elh_registroprueba_Barrio" for="x_Barrio" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Barrio->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Barrio->CellAttributes() ?>>
<span id="el_registroprueba_Barrio">
<input type="text" data-table="registroprueba" data-field="x_Barrio" name="x_Barrio" id="x_Barrio" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($registroprueba->Barrio->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Barrio->EditValue ?>"<?php echo $registroprueba->Barrio->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Barrio->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Direccion_Residencia->Visible) { // Direccion_Residencia ?>
	<div id="r_Direccion_Residencia" class="form-group">
		<label id="elh_registroprueba_Direccion_Residencia" for="x_Direccion_Residencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Direccion_Residencia->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Direccion_Residencia->CellAttributes() ?>>
<span id="el_registroprueba_Direccion_Residencia">
<input type="text" data-table="registroprueba" data-field="x_Direccion_Residencia" name="x_Direccion_Residencia" id="x_Direccion_Residencia" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($registroprueba->Direccion_Residencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Direccion_Residencia->EditValue ?>"<?php echo $registroprueba->Direccion_Residencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Direccion_Residencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Ocupacion->Visible) { // Ocupacion ?>
	<div id="r_Ocupacion" class="form-group">
		<label id="elh_registroprueba_Ocupacion" for="x_Ocupacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Ocupacion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Ocupacion->CellAttributes() ?>>
<span id="el_registroprueba_Ocupacion">
<input type="text" data-table="registroprueba" data-field="x_Ocupacion" name="x_Ocupacion" id="x_Ocupacion" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Ocupacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Ocupacion->EditValue ?>"<?php echo $registroprueba->Ocupacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Ocupacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
	<div id="r_Tipo_Regimen_Salud" class="form-group">
		<label id="elh_registroprueba_Tipo_Regimen_Salud" for="x_Tipo_Regimen_Salud" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Tipo_Regimen_Salud->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Tipo_Regimen_Salud->CellAttributes() ?>>
<span id="el_registroprueba_Tipo_Regimen_Salud">
<input type="text" data-table="registroprueba" data-field="x_Tipo_Regimen_Salud" name="x_Tipo_Regimen_Salud" id="x_Tipo_Regimen_Salud" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($registroprueba->Tipo_Regimen_Salud->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Tipo_Regimen_Salud->EditValue ?>"<?php echo $registroprueba->Tipo_Regimen_Salud->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Tipo_Regimen_Salud->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Cod_Administradora->Visible) { // Cod_Administradora ?>
	<div id="r_Cod_Administradora" class="form-group">
		<label id="elh_registroprueba_Cod_Administradora" for="x_Cod_Administradora" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Cod_Administradora->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Cod_Administradora->CellAttributes() ?>>
<span id="el_registroprueba_Cod_Administradora">
<input type="text" data-table="registroprueba" data-field="x_Cod_Administradora" name="x_Cod_Administradora" id="x_Cod_Administradora" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($registroprueba->Cod_Administradora->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Cod_Administradora->EditValue ?>"<?php echo $registroprueba->Cod_Administradora->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Cod_Administradora->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Pertenencia_Etnica->Visible) { // Pertenencia_Etnica ?>
	<div id="r_Pertenencia_Etnica" class="form-group">
		<label id="elh_registroprueba_Pertenencia_Etnica" for="x_Pertenencia_Etnica" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Pertenencia_Etnica->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Pertenencia_Etnica->CellAttributes() ?>>
<span id="el_registroprueba_Pertenencia_Etnica">
<input type="text" data-table="registroprueba" data-field="x_Pertenencia_Etnica" name="x_Pertenencia_Etnica" id="x_Pertenencia_Etnica" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Pertenencia_Etnica->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Pertenencia_Etnica->EditValue ?>"<?php echo $registroprueba->Pertenencia_Etnica->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Pertenencia_Etnica->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Grupo_Poblacional->Visible) { // Grupo_Poblacional ?>
	<div id="r_Grupo_Poblacional" class="form-group">
		<label id="elh_registroprueba_Grupo_Poblacional" for="x_Grupo_Poblacional" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Grupo_Poblacional->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Grupo_Poblacional->CellAttributes() ?>>
<span id="el_registroprueba_Grupo_Poblacional">
<input type="text" data-table="registroprueba" data-field="x_Grupo_Poblacional" name="x_Grupo_Poblacional" id="x_Grupo_Poblacional" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Grupo_Poblacional->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Grupo_Poblacional->EditValue ?>"<?php echo $registroprueba->Grupo_Poblacional->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Grupo_Poblacional->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Depto_Residencia->Visible) { // Depto_Residencia ?>
	<div id="r_Depto_Residencia" class="form-group">
		<label id="elh_registroprueba_Depto_Residencia" for="x_Depto_Residencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Depto_Residencia->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Depto_Residencia->CellAttributes() ?>>
<span id="el_registroprueba_Depto_Residencia">
<input type="text" data-table="registroprueba" data-field="x_Depto_Residencia" name="x_Depto_Residencia" id="x_Depto_Residencia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Depto_Residencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Depto_Residencia->EditValue ?>"<?php echo $registroprueba->Depto_Residencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Depto_Residencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Municipio_Residencia->Visible) { // Municipio_Residencia ?>
	<div id="r_Municipio_Residencia" class="form-group">
		<label id="elh_registroprueba_Municipio_Residencia" for="x_Municipio_Residencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Municipio_Residencia->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Municipio_Residencia->CellAttributes() ?>>
<span id="el_registroprueba_Municipio_Residencia">
<input type="text" data-table="registroprueba" data-field="x_Municipio_Residencia" name="x_Municipio_Residencia" id="x_Municipio_Residencia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Municipio_Residencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Municipio_Residencia->EditValue ?>"<?php echo $registroprueba->Municipio_Residencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Municipio_Residencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Consulta->Visible) { // Fecha_Consulta ?>
	<div id="r_Fecha_Consulta" class="form-group">
		<label id="elh_registroprueba_Fecha_Consulta" for="x_Fecha_Consulta" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Consulta->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Consulta->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Consulta">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Consulta" data-format="5" name="x_Fecha_Consulta" id="x_Fecha_Consulta" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Consulta->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Consulta->EditValue ?>"<?php echo $registroprueba->Fecha_Consulta->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Consulta->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Inicio_Sintomas->Visible) { // Fecha_Inicio_Sintomas ?>
	<div id="r_Fecha_Inicio_Sintomas" class="form-group">
		<label id="elh_registroprueba_Fecha_Inicio_Sintomas" for="x_Fecha_Inicio_Sintomas" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Inicio_Sintomas->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Inicio_Sintomas->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Inicio_Sintomas">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Inicio_Sintomas" data-format="5" name="x_Fecha_Inicio_Sintomas" id="x_Fecha_Inicio_Sintomas" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Inicio_Sintomas->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Inicio_Sintomas->EditValue ?>"<?php echo $registroprueba->Fecha_Inicio_Sintomas->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Inicio_Sintomas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Clasificacion_Inicial->Visible) { // Clasificacion_Inicial ?>
	<div id="r_Clasificacion_Inicial" class="form-group">
		<label id="elh_registroprueba_Clasificacion_Inicial" for="x_Clasificacion_Inicial" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Clasificacion_Inicial->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Clasificacion_Inicial->CellAttributes() ?>>
<span id="el_registroprueba_Clasificacion_Inicial">
<input type="text" data-table="registroprueba" data-field="x_Clasificacion_Inicial" name="x_Clasificacion_Inicial" id="x_Clasificacion_Inicial" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Clasificacion_Inicial->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Clasificacion_Inicial->EditValue ?>"<?php echo $registroprueba->Clasificacion_Inicial->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Clasificacion_Inicial->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Hospitalizado->Visible) { // Hospitalizado ?>
	<div id="r_Hospitalizado" class="form-group">
		<label id="elh_registroprueba_Hospitalizado" for="x_Hospitalizado" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Hospitalizado->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Hospitalizado->CellAttributes() ?>>
<span id="el_registroprueba_Hospitalizado">
<input type="text" data-table="registroprueba" data-field="x_Hospitalizado" name="x_Hospitalizado" id="x_Hospitalizado" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Hospitalizado->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Hospitalizado->EditValue ?>"<?php echo $registroprueba->Hospitalizado->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Hospitalizado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Hospitalizacion->Visible) { // Fecha_Hospitalizacion ?>
	<div id="r_Fecha_Hospitalizacion" class="form-group">
		<label id="elh_registroprueba_Fecha_Hospitalizacion" for="x_Fecha_Hospitalizacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Hospitalizacion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Hospitalizacion->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Hospitalizacion">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Hospitalizacion" data-format="5" name="x_Fecha_Hospitalizacion" id="x_Fecha_Hospitalizacion" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Hospitalizacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Hospitalizacion->EditValue ?>"<?php echo $registroprueba->Fecha_Hospitalizacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Hospitalizacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Condicion_Final->Visible) { // Condicion_Final ?>
	<div id="r_Condicion_Final" class="form-group">
		<label id="elh_registroprueba_Condicion_Final" for="x_Condicion_Final" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Condicion_Final->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Condicion_Final->CellAttributes() ?>>
<span id="el_registroprueba_Condicion_Final">
<input type="text" data-table="registroprueba" data-field="x_Condicion_Final" name="x_Condicion_Final" id="x_Condicion_Final" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($registroprueba->Condicion_Final->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Condicion_Final->EditValue ?>"<?php echo $registroprueba->Condicion_Final->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Condicion_Final->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Defuncion->Visible) { // Fecha_Defuncion ?>
	<div id="r_Fecha_Defuncion" class="form-group">
		<label id="elh_registroprueba_Fecha_Defuncion" for="x_Fecha_Defuncion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Defuncion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Defuncion->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Defuncion">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Defuncion" data-format="5" name="x_Fecha_Defuncion" id="x_Fecha_Defuncion" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Defuncion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Defuncion->EditValue ?>"<?php echo $registroprueba->Fecha_Defuncion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Defuncion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Numero_Certificado_Defuncion->Visible) { // Numero_Certificado_Defuncion ?>
	<div id="r_Numero_Certificado_Defuncion" class="form-group">
		<label id="elh_registroprueba_Numero_Certificado_Defuncion" for="x_Numero_Certificado_Defuncion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Numero_Certificado_Defuncion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Numero_Certificado_Defuncion->CellAttributes() ?>>
<span id="el_registroprueba_Numero_Certificado_Defuncion">
<input type="text" data-table="registroprueba" data-field="x_Numero_Certificado_Defuncion" name="x_Numero_Certificado_Defuncion" id="x_Numero_Certificado_Defuncion" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Numero_Certificado_Defuncion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Numero_Certificado_Defuncion->EditValue ?>"<?php echo $registroprueba->Numero_Certificado_Defuncion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Numero_Certificado_Defuncion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Causa_Basica_Muerte_CIEX->Visible) { // Causa_Basica_Muerte_CIEX ?>
	<div id="r_Causa_Basica_Muerte_CIEX" class="form-group">
		<label id="elh_registroprueba_Causa_Basica_Muerte_CIEX" for="x_Causa_Basica_Muerte_CIEX" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Causa_Basica_Muerte_CIEX->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Causa_Basica_Muerte_CIEX->CellAttributes() ?>>
<span id="el_registroprueba_Causa_Basica_Muerte_CIEX">
<input type="text" data-table="registroprueba" data-field="x_Causa_Basica_Muerte_CIEX" name="x_Causa_Basica_Muerte_CIEX" id="x_Causa_Basica_Muerte_CIEX" size="30" maxlength="150" placeholder="<?php echo ew_HtmlEncode($registroprueba->Causa_Basica_Muerte_CIEX->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Causa_Basica_Muerte_CIEX->EditValue ?>"<?php echo $registroprueba->Causa_Basica_Muerte_CIEX->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Causa_Basica_Muerte_CIEX->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Nombre_Profesional_Diligencia->Visible) { // Nombre_Profesional_Diligencia ?>
	<div id="r_Nombre_Profesional_Diligencia" class="form-group">
		<label id="elh_registroprueba_Nombre_Profesional_Diligencia" for="x_Nombre_Profesional_Diligencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Nombre_Profesional_Diligencia->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Nombre_Profesional_Diligencia->CellAttributes() ?>>
<span id="el_registroprueba_Nombre_Profesional_Diligencia">
<input type="text" data-table="registroprueba" data-field="x_Nombre_Profesional_Diligencia" name="x_Nombre_Profesional_Diligencia" id="x_Nombre_Profesional_Diligencia" size="30" maxlength="200" placeholder="<?php echo ew_HtmlEncode($registroprueba->Nombre_Profesional_Diligencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Nombre_Profesional_Diligencia->EditValue ?>"<?php echo $registroprueba->Nombre_Profesional_Diligencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Nombre_Profesional_Diligencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Telefono_Profesional_Diligencia->Visible) { // Telefono_Profesional_Diligencia ?>
	<div id="r_Telefono_Profesional_Diligencia" class="form-group">
		<label id="elh_registroprueba_Telefono_Profesional_Diligencia" for="x_Telefono_Profesional_Diligencia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Telefono_Profesional_Diligencia->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Telefono_Profesional_Diligencia->CellAttributes() ?>>
<span id="el_registroprueba_Telefono_Profesional_Diligencia">
<input type="text" data-table="registroprueba" data-field="x_Telefono_Profesional_Diligencia" name="x_Telefono_Profesional_Diligencia" id="x_Telefono_Profesional_Diligencia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Telefono_Profesional_Diligencia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Telefono_Profesional_Diligencia->EditValue ?>"<?php echo $registroprueba->Telefono_Profesional_Diligencia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Telefono_Profesional_Diligencia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Seguimiento_Clasificacion_Final->Visible) { // Seguimiento_Clasificacion_Final ?>
	<div id="r_Seguimiento_Clasificacion_Final" class="form-group">
		<label id="elh_registroprueba_Seguimiento_Clasificacion_Final" for="x_Seguimiento_Clasificacion_Final" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Seguimiento_Clasificacion_Final->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Seguimiento_Clasificacion_Final->CellAttributes() ?>>
<span id="el_registroprueba_Seguimiento_Clasificacion_Final">
<input type="text" data-table="registroprueba" data-field="x_Seguimiento_Clasificacion_Final" name="x_Seguimiento_Clasificacion_Final" id="x_Seguimiento_Clasificacion_Final" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($registroprueba->Seguimiento_Clasificacion_Final->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Seguimiento_Clasificacion_Final->EditValue ?>"<?php echo $registroprueba->Seguimiento_Clasificacion_Final->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Seguimiento_Clasificacion_Final->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Ajuste->Visible) { // Fecha_Ajuste ?>
	<div id="r_Fecha_Ajuste" class="form-group">
		<label id="elh_registroprueba_Fecha_Ajuste" for="x_Fecha_Ajuste" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Ajuste->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Ajuste->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Ajuste">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Ajuste" data-format="5" name="x_Fecha_Ajuste" id="x_Fecha_Ajuste" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Ajuste->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Ajuste->EditValue ?>"<?php echo $registroprueba->Fecha_Ajuste->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Ajuste->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Codigo_UPGD->Visible) { // Codigo_UPGD ?>
	<div id="r_Codigo_UPGD" class="form-group">
		<label id="elh_registroprueba_Codigo_UPGD" for="x_Codigo_UPGD" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Codigo_UPGD->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Codigo_UPGD->CellAttributes() ?>>
<span id="el_registroprueba_Codigo_UPGD">
<input type="text" data-table="registroprueba" data-field="x_Codigo_UPGD" name="x_Codigo_UPGD" id="x_Codigo_UPGD" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($registroprueba->Codigo_UPGD->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Codigo_UPGD->EditValue ?>"<?php echo $registroprueba->Codigo_UPGD->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Codigo_UPGD->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Nombre_Evento->Visible) { // Nombre_Evento ?>
	<div id="r_Nombre_Evento" class="form-group">
		<label id="elh_registroprueba_Nombre_Evento" for="x_Nombre_Evento" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Nombre_Evento->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Nombre_Evento->CellAttributes() ?>>
<span id="el_registroprueba_Nombre_Evento">
<input type="text" data-table="registroprueba" data-field="x_Nombre_Evento" name="x_Nombre_Evento" id="x_Nombre_Evento" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($registroprueba->Nombre_Evento->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Nombre_Evento->EditValue ?>"<?php echo $registroprueba->Nombre_Evento->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Nombre_Evento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Cod_Evento->Visible) { // Cod_Evento ?>
	<div id="r_Cod_Evento" class="form-group">
		<label id="elh_registroprueba_Cod_Evento" for="x_Cod_Evento" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Cod_Evento->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Cod_Evento->CellAttributes() ?>>
<span id="el_registroprueba_Cod_Evento">
<input type="text" data-table="registroprueba" data-field="x_Cod_Evento" name="x_Cod_Evento" id="x_Cod_Evento" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Cod_Evento->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Cod_Evento->EditValue ?>"<?php echo $registroprueba->Cod_Evento->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Cod_Evento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Notificacion->Visible) { // Fecha_Notificacion ?>
	<div id="r_Fecha_Notificacion" class="form-group">
		<label id="elh_registroprueba_Fecha_Notificacion" for="x_Fecha_Notificacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Notificacion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Notificacion->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Notificacion">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Notificacion" data-format="5" name="x_Fecha_Notificacion" id="x_Fecha_Notificacion" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Notificacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Notificacion->EditValue ?>"<?php echo $registroprueba->Fecha_Notificacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Notificacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Semana->Visible) { // Semana ?>
	<div id="r_Semana" class="form-group">
		<label id="elh_registroprueba_Semana" for="x_Semana" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Semana->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Semana->CellAttributes() ?>>
<span id="el_registroprueba_Semana">
<input type="text" data-table="registroprueba" data-field="x_Semana" name="x_Semana" id="x_Semana" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Semana->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Semana->EditValue ?>"<?php echo $registroprueba->Semana->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Semana->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Mecanismo_Probable_Transmision->Visible) { // Mecanismo_Probable_Transmision ?>
	<div id="r_Mecanismo_Probable_Transmision" class="form-group">
		<label id="elh_registroprueba_Mecanismo_Probable_Transmision" for="x_Mecanismo_Probable_Transmision" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Mecanismo_Probable_Transmision->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Mecanismo_Probable_Transmision->CellAttributes() ?>>
<span id="el_registroprueba_Mecanismo_Probable_Transmision">
<input type="text" data-table="registroprueba" data-field="x_Mecanismo_Probable_Transmision" name="x_Mecanismo_Probable_Transmision" id="x_Mecanismo_Probable_Transmision" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Mecanismo_Probable_Transmision->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Mecanismo_Probable_Transmision->EditValue ?>"<?php echo $registroprueba->Mecanismo_Probable_Transmision->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Mecanismo_Probable_Transmision->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Nombre_Madre->Visible) { // Nombre_Madre ?>
	<div id="r_Nombre_Madre" class="form-group">
		<label id="elh_registroprueba_Nombre_Madre" for="x_Nombre_Madre" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Nombre_Madre->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Nombre_Madre->CellAttributes() ?>>
<span id="el_registroprueba_Nombre_Madre">
<input type="text" data-table="registroprueba" data-field="x_Nombre_Madre" name="x_Nombre_Madre" id="x_Nombre_Madre" size="30" maxlength="200" placeholder="<?php echo ew_HtmlEncode($registroprueba->Nombre_Madre->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Nombre_Madre->EditValue ?>"<?php echo $registroprueba->Nombre_Madre->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Nombre_Madre->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Tipo_Id_Madre->Visible) { // Tipo_Id_Madre ?>
	<div id="r_Tipo_Id_Madre" class="form-group">
		<label id="elh_registroprueba_Tipo_Id_Madre" for="x_Tipo_Id_Madre" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Tipo_Id_Madre->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Tipo_Id_Madre->CellAttributes() ?>>
<span id="el_registroprueba_Tipo_Id_Madre">
<input type="text" data-table="registroprueba" data-field="x_Tipo_Id_Madre" name="x_Tipo_Id_Madre" id="x_Tipo_Id_Madre" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($registroprueba->Tipo_Id_Madre->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Tipo_Id_Madre->EditValue ?>"<?php echo $registroprueba->Tipo_Id_Madre->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Tipo_Id_Madre->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Numero_Identificacion_Madre->Visible) { // Numero_Identificacion_Madre ?>
	<div id="r_Numero_Identificacion_Madre" class="form-group">
		<label id="elh_registroprueba_Numero_Identificacion_Madre" for="x_Numero_Identificacion_Madre" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Numero_Identificacion_Madre->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Numero_Identificacion_Madre->CellAttributes() ?>>
<span id="el_registroprueba_Numero_Identificacion_Madre">
<input type="text" data-table="registroprueba" data-field="x_Numero_Identificacion_Madre" name="x_Numero_Identificacion_Madre" id="x_Numero_Identificacion_Madre" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Numero_Identificacion_Madre->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Numero_Identificacion_Madre->EditValue ?>"<?php echo $registroprueba->Numero_Identificacion_Madre->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Numero_Identificacion_Madre->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Indentidad_Genero->Visible) { // Indentidad_Genero ?>
	<div id="r_Indentidad_Genero" class="form-group">
		<label id="elh_registroprueba_Indentidad_Genero" for="x_Indentidad_Genero" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Indentidad_Genero->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Indentidad_Genero->CellAttributes() ?>>
<span id="el_registroprueba_Indentidad_Genero">
<input type="text" data-table="registroprueba" data-field="x_Indentidad_Genero" name="x_Indentidad_Genero" id="x_Indentidad_Genero" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($registroprueba->Indentidad_Genero->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Indentidad_Genero->EditValue ?>"<?php echo $registroprueba->Indentidad_Genero->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Indentidad_Genero->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Donador_Sangre_Ultimos_12_Meses->Visible) { // Donador_Sangre_Ultimos_12_Meses ?>
	<div id="r_Donador_Sangre_Ultimos_12_Meses" class="form-group">
		<label id="elh_registroprueba_Donador_Sangre_Ultimos_12_Meses" for="x_Donador_Sangre_Ultimos_12_Meses" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Donador_Sangre_Ultimos_12_Meses->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Donador_Sangre_Ultimos_12_Meses->CellAttributes() ?>>
<span id="el_registroprueba_Donador_Sangre_Ultimos_12_Meses">
<input type="text" data-table="registroprueba" data-field="x_Donador_Sangre_Ultimos_12_Meses" name="x_Donador_Sangre_Ultimos_12_Meses" id="x_Donador_Sangre_Ultimos_12_Meses" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Donador_Sangre_Ultimos_12_Meses->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Donador_Sangre_Ultimos_12_Meses->EditValue ?>"<?php echo $registroprueba->Donador_Sangre_Ultimos_12_Meses->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Donador_Sangre_Ultimos_12_Meses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Donacion->Visible) { // Fecha_Donacion ?>
	<div id="r_Fecha_Donacion" class="form-group">
		<label id="elh_registroprueba_Fecha_Donacion" for="x_Fecha_Donacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Donacion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Donacion->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Donacion">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Donacion" data-format="5" name="x_Fecha_Donacion" id="x_Fecha_Donacion" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Donacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Donacion->EditValue ?>"<?php echo $registroprueba->Fecha_Donacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Donacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Nombre_Institucion_Donacion->Visible) { // Nombre_Institucion_Donacion ?>
	<div id="r_Nombre_Institucion_Donacion" class="form-group">
		<label id="elh_registroprueba_Nombre_Institucion_Donacion" for="x_Nombre_Institucion_Donacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Nombre_Institucion_Donacion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Nombre_Institucion_Donacion->CellAttributes() ?>>
<span id="el_registroprueba_Nombre_Institucion_Donacion">
<input type="text" data-table="registroprueba" data-field="x_Nombre_Institucion_Donacion" name="x_Nombre_Institucion_Donacion" id="x_Nombre_Institucion_Donacion" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($registroprueba->Nombre_Institucion_Donacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Nombre_Institucion_Donacion->EditValue ?>"<?php echo $registroprueba->Nombre_Institucion_Donacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Nombre_Institucion_Donacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Recibio_Asesoria_Pre_Prueba->Visible) { // Recibio_Asesoria_Pre_Prueba ?>
	<div id="r_Recibio_Asesoria_Pre_Prueba" class="form-group">
		<label id="elh_registroprueba_Recibio_Asesoria_Pre_Prueba" for="x_Recibio_Asesoria_Pre_Prueba" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Recibio_Asesoria_Pre_Prueba->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Recibio_Asesoria_Pre_Prueba->CellAttributes() ?>>
<span id="el_registroprueba_Recibio_Asesoria_Pre_Prueba">
<input type="text" data-table="registroprueba" data-field="x_Recibio_Asesoria_Pre_Prueba" name="x_Recibio_Asesoria_Pre_Prueba" id="x_Recibio_Asesoria_Pre_Prueba" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Recibio_Asesoria_Pre_Prueba->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Recibio_Asesoria_Pre_Prueba->EditValue ?>"<?php echo $registroprueba->Recibio_Asesoria_Pre_Prueba->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Recibio_Asesoria_Pre_Prueba->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Recibio_Asesoria_Post_Prueba->Visible) { // Recibio_Asesoria_Post_Prueba ?>
	<div id="r_Recibio_Asesoria_Post_Prueba" class="form-group">
		<label id="elh_registroprueba_Recibio_Asesoria_Post_Prueba" for="x_Recibio_Asesoria_Post_Prueba" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Recibio_Asesoria_Post_Prueba->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Recibio_Asesoria_Post_Prueba->CellAttributes() ?>>
<span id="el_registroprueba_Recibio_Asesoria_Post_Prueba">
<input type="text" data-table="registroprueba" data-field="x_Recibio_Asesoria_Post_Prueba" name="x_Recibio_Asesoria_Post_Prueba" id="x_Recibio_Asesoria_Post_Prueba" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Recibio_Asesoria_Post_Prueba->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Recibio_Asesoria_Post_Prueba->EditValue ?>"<?php echo $registroprueba->Recibio_Asesoria_Post_Prueba->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Recibio_Asesoria_Post_Prueba->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Tipo_Prueba->Visible) { // Tipo_Prueba ?>
	<div id="r_Tipo_Prueba" class="form-group">
		<label id="elh_registroprueba_Tipo_Prueba" for="x_Tipo_Prueba" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Tipo_Prueba->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Tipo_Prueba->CellAttributes() ?>>
<span id="el_registroprueba_Tipo_Prueba">
<input type="text" data-table="registroprueba" data-field="x_Tipo_Prueba" name="x_Tipo_Prueba" id="x_Tipo_Prueba" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Tipo_Prueba->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Tipo_Prueba->EditValue ?>"<?php echo $registroprueba->Tipo_Prueba->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Tipo_Prueba->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Fecha_Resultado_Confirmatorio->Visible) { // Fecha_Resultado_Confirmatorio ?>
	<div id="r_Fecha_Resultado_Confirmatorio" class="form-group">
		<label id="elh_registroprueba_Fecha_Resultado_Confirmatorio" for="x_Fecha_Resultado_Confirmatorio" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Fecha_Resultado_Confirmatorio->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Fecha_Resultado_Confirmatorio->CellAttributes() ?>>
<span id="el_registroprueba_Fecha_Resultado_Confirmatorio">
<input type="text" data-table="registroprueba" data-field="x_Fecha_Resultado_Confirmatorio" data-format="5" name="x_Fecha_Resultado_Confirmatorio" id="x_Fecha_Resultado_Confirmatorio" placeholder="<?php echo ew_HtmlEncode($registroprueba->Fecha_Resultado_Confirmatorio->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Fecha_Resultado_Confirmatorio->EditValue ?>"<?php echo $registroprueba->Fecha_Resultado_Confirmatorio->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Fecha_Resultado_Confirmatorio->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Valor_Carga_Viral->Visible) { // Valor_Carga_Viral ?>
	<div id="r_Valor_Carga_Viral" class="form-group">
		<label id="elh_registroprueba_Valor_Carga_Viral" for="x_Valor_Carga_Viral" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Valor_Carga_Viral->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Valor_Carga_Viral->CellAttributes() ?>>
<span id="el_registroprueba_Valor_Carga_Viral">
<input type="text" data-table="registroprueba" data-field="x_Valor_Carga_Viral" name="x_Valor_Carga_Viral" id="x_Valor_Carga_Viral" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Valor_Carga_Viral->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Valor_Carga_Viral->EditValue ?>"<?php echo $registroprueba->Valor_Carga_Viral->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Valor_Carga_Viral->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Estado_Clinico_Notificacion->Visible) { // Estado_Clinico_Notificacion ?>
	<div id="r_Estado_Clinico_Notificacion" class="form-group">
		<label id="elh_registroprueba_Estado_Clinico_Notificacion" for="x_Estado_Clinico_Notificacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Estado_Clinico_Notificacion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Estado_Clinico_Notificacion->CellAttributes() ?>>
<span id="el_registroprueba_Estado_Clinico_Notificacion">
<input type="text" data-table="registroprueba" data-field="x_Estado_Clinico_Notificacion" name="x_Estado_Clinico_Notificacion" id="x_Estado_Clinico_Notificacion" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Estado_Clinico_Notificacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Estado_Clinico_Notificacion->EditValue ?>"<?php echo $registroprueba->Estado_Clinico_Notificacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Estado_Clinico_Notificacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Hijos_Mujeres_Menores_5->Visible) { // Hijos_Mujeres_Menores_5 ?>
	<div id="r_Hijos_Mujeres_Menores_5" class="form-group">
		<label id="elh_registroprueba_Hijos_Mujeres_Menores_5" for="x_Hijos_Mujeres_Menores_5" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Hijos_Mujeres_Menores_5->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Hijos_Mujeres_Menores_5->CellAttributes() ?>>
<span id="el_registroprueba_Hijos_Mujeres_Menores_5">
<input type="text" data-table="registroprueba" data-field="x_Hijos_Mujeres_Menores_5" name="x_Hijos_Mujeres_Menores_5" id="x_Hijos_Mujeres_Menores_5" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Hijos_Mujeres_Menores_5->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Hijos_Mujeres_Menores_5->EditValue ?>"<?php echo $registroprueba->Hijos_Mujeres_Menores_5->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Hijos_Mujeres_Menores_5->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Hijos_Hombres_Menores_5->Visible) { // Hijos_Hombres_Menores_5 ?>
	<div id="r_Hijos_Hombres_Menores_5" class="form-group">
		<label id="elh_registroprueba_Hijos_Hombres_Menores_5" for="x_Hijos_Hombres_Menores_5" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Hijos_Hombres_Menores_5->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Hijos_Hombres_Menores_5->CellAttributes() ?>>
<span id="el_registroprueba_Hijos_Hombres_Menores_5">
<input type="text" data-table="registroprueba" data-field="x_Hijos_Hombres_Menores_5" name="x_Hijos_Hombres_Menores_5" id="x_Hijos_Hombres_Menores_5" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Hijos_Hombres_Menores_5->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Hijos_Hombres_Menores_5->EditValue ?>"<?php echo $registroprueba->Hijos_Hombres_Menores_5->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Hijos_Hombres_Menores_5->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Embarazo_Actual->Visible) { // Embarazo_Actual ?>
	<div id="r_Embarazo_Actual" class="form-group">
		<label id="elh_registroprueba_Embarazo_Actual" for="x_Embarazo_Actual" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Embarazo_Actual->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Embarazo_Actual->CellAttributes() ?>>
<span id="el_registroprueba_Embarazo_Actual">
<input type="text" data-table="registroprueba" data-field="x_Embarazo_Actual" name="x_Embarazo_Actual" id="x_Embarazo_Actual" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Embarazo_Actual->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Embarazo_Actual->EditValue ?>"<?php echo $registroprueba->Embarazo_Actual->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Embarazo_Actual->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Antecedentes_Embarazo->Visible) { // Antecedentes_Embarazo ?>
	<div id="r_Antecedentes_Embarazo" class="form-group">
		<label id="elh_registroprueba_Antecedentes_Embarazo" for="x_Antecedentes_Embarazo" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Antecedentes_Embarazo->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Antecedentes_Embarazo->CellAttributes() ?>>
<span id="el_registroprueba_Antecedentes_Embarazo">
<input type="text" data-table="registroprueba" data-field="x_Antecedentes_Embarazo" name="x_Antecedentes_Embarazo" id="x_Antecedentes_Embarazo" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Antecedentes_Embarazo->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Antecedentes_Embarazo->EditValue ?>"<?php echo $registroprueba->Antecedentes_Embarazo->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Antecedentes_Embarazo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Numero_Semanas_Embarazo->Visible) { // Numero_Semanas_Embarazo ?>
	<div id="r_Numero_Semanas_Embarazo" class="form-group">
		<label id="elh_registroprueba_Numero_Semanas_Embarazo" for="x_Numero_Semanas_Embarazo" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Numero_Semanas_Embarazo->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Numero_Semanas_Embarazo->CellAttributes() ?>>
<span id="el_registroprueba_Numero_Semanas_Embarazo">
<input type="text" data-table="registroprueba" data-field="x_Numero_Semanas_Embarazo" name="x_Numero_Semanas_Embarazo" id="x_Numero_Semanas_Embarazo" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Numero_Semanas_Embarazo->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Numero_Semanas_Embarazo->EditValue ?>"<?php echo $registroprueba->Numero_Semanas_Embarazo->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Numero_Semanas_Embarazo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Candidiasis_esofagica->Visible) { // Candidiasis_esofagica ?>
	<div id="r_Candidiasis_esofagica" class="form-group">
		<label id="elh_registroprueba_Candidiasis_esofagica" for="x_Candidiasis_esofagica" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Candidiasis_esofagica->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Candidiasis_esofagica->CellAttributes() ?>>
<span id="el_registroprueba_Candidiasis_esofagica">
<input type="text" data-table="registroprueba" data-field="x_Candidiasis_esofagica" name="x_Candidiasis_esofagica" id="x_Candidiasis_esofagica" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Candidiasis_esofagica->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Candidiasis_esofagica->EditValue ?>"<?php echo $registroprueba->Candidiasis_esofagica->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Candidiasis_esofagica->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Candidiasis_vias_aereas->Visible) { // Candidiasis_vias_aereas ?>
	<div id="r_Candidiasis_vias_aereas" class="form-group">
		<label id="elh_registroprueba_Candidiasis_vias_aereas" for="x_Candidiasis_vias_aereas" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Candidiasis_vias_aereas->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Candidiasis_vias_aereas->CellAttributes() ?>>
<span id="el_registroprueba_Candidiasis_vias_aereas">
<input type="text" data-table="registroprueba" data-field="x_Candidiasis_vias_aereas" name="x_Candidiasis_vias_aereas" id="x_Candidiasis_vias_aereas" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Candidiasis_vias_aereas->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Candidiasis_vias_aereas->EditValue ?>"<?php echo $registroprueba->Candidiasis_vias_aereas->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Candidiasis_vias_aereas->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Tuberculosis_pulmonar->Visible) { // Tuberculosis_pulmonar ?>
	<div id="r_Tuberculosis_pulmonar" class="form-group">
		<label id="elh_registroprueba_Tuberculosis_pulmonar" for="x_Tuberculosis_pulmonar" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Tuberculosis_pulmonar->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Tuberculosis_pulmonar->CellAttributes() ?>>
<span id="el_registroprueba_Tuberculosis_pulmonar">
<input type="text" data-table="registroprueba" data-field="x_Tuberculosis_pulmonar" name="x_Tuberculosis_pulmonar" id="x_Tuberculosis_pulmonar" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Tuberculosis_pulmonar->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Tuberculosis_pulmonar->EditValue ?>"<?php echo $registroprueba->Tuberculosis_pulmonar->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Tuberculosis_pulmonar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Cancer_cervical->Visible) { // Cancer_cervical ?>
	<div id="r_Cancer_cervical" class="form-group">
		<label id="elh_registroprueba_Cancer_cervical" for="x_Cancer_cervical" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Cancer_cervical->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Cancer_cervical->CellAttributes() ?>>
<span id="el_registroprueba_Cancer_cervical">
<input type="text" data-table="registroprueba" data-field="x_Cancer_cervical" name="x_Cancer_cervical" id="x_Cancer_cervical" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Cancer_cervical->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Cancer_cervical->EditValue ?>"<?php echo $registroprueba->Cancer_cervical->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Cancer_cervical->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Tuberculosis_extrapulmonar->Visible) { // Tuberculosis_extrapulmonar ?>
	<div id="r_Tuberculosis_extrapulmonar" class="form-group">
		<label id="elh_registroprueba_Tuberculosis_extrapulmonar" for="x_Tuberculosis_extrapulmonar" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Tuberculosis_extrapulmonar->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Tuberculosis_extrapulmonar->CellAttributes() ?>>
<span id="el_registroprueba_Tuberculosis_extrapulmonar">
<input type="text" data-table="registroprueba" data-field="x_Tuberculosis_extrapulmonar" name="x_Tuberculosis_extrapulmonar" id="x_Tuberculosis_extrapulmonar" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Tuberculosis_extrapulmonar->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Tuberculosis_extrapulmonar->EditValue ?>"<?php echo $registroprueba->Tuberculosis_extrapulmonar->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Tuberculosis_extrapulmonar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Coccidiomicosis->Visible) { // Coccidiomicosis ?>
	<div id="r_Coccidiomicosis" class="form-group">
		<label id="elh_registroprueba_Coccidiomicosis" for="x_Coccidiomicosis" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Coccidiomicosis->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Coccidiomicosis->CellAttributes() ?>>
<span id="el_registroprueba_Coccidiomicosis">
<input type="text" data-table="registroprueba" data-field="x_Coccidiomicosis" name="x_Coccidiomicosis" id="x_Coccidiomicosis" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Coccidiomicosis->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Coccidiomicosis->EditValue ?>"<?php echo $registroprueba->Coccidiomicosis->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Coccidiomicosis->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Citomegalovirosis->Visible) { // Citomegalovirosis ?>
	<div id="r_Citomegalovirosis" class="form-group">
		<label id="elh_registroprueba_Citomegalovirosis" for="x_Citomegalovirosis" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Citomegalovirosis->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Citomegalovirosis->CellAttributes() ?>>
<span id="el_registroprueba_Citomegalovirosis">
<input type="text" data-table="registroprueba" data-field="x_Citomegalovirosis" name="x_Citomegalovirosis" id="x_Citomegalovirosis" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Citomegalovirosis->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Citomegalovirosis->EditValue ?>"<?php echo $registroprueba->Citomegalovirosis->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Citomegalovirosis->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Retinitis_citomegalovirosis->Visible) { // Retinitis_citomegalovirosis ?>
	<div id="r_Retinitis_citomegalovirosis" class="form-group">
		<label id="elh_registroprueba_Retinitis_citomegalovirosis" for="x_Retinitis_citomegalovirosis" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Retinitis_citomegalovirosis->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Retinitis_citomegalovirosis->CellAttributes() ?>>
<span id="el_registroprueba_Retinitis_citomegalovirosis">
<input type="text" data-table="registroprueba" data-field="x_Retinitis_citomegalovirosis" name="x_Retinitis_citomegalovirosis" id="x_Retinitis_citomegalovirosis" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Retinitis_citomegalovirosis->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Retinitis_citomegalovirosis->EditValue ?>"<?php echo $registroprueba->Retinitis_citomegalovirosis->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Retinitis_citomegalovirosis->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Encefalopatia->Visible) { // Encefalopatia ?>
	<div id="r_Encefalopatia" class="form-group">
		<label id="elh_registroprueba_Encefalopatia" for="x_Encefalopatia" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Encefalopatia->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Encefalopatia->CellAttributes() ?>>
<span id="el_registroprueba_Encefalopatia">
<input type="text" data-table="registroprueba" data-field="x_Encefalopatia" name="x_Encefalopatia" id="x_Encefalopatia" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Encefalopatia->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Encefalopatia->EditValue ?>"<?php echo $registroprueba->Encefalopatia->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Encefalopatia->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Otras_micobacterias->Visible) { // Otras_micobacterias ?>
	<div id="r_Otras_micobacterias" class="form-group">
		<label id="elh_registroprueba_Otras_micobacterias" for="x_Otras_micobacterias" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Otras_micobacterias->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Otras_micobacterias->CellAttributes() ?>>
<span id="el_registroprueba_Otras_micobacterias">
<input type="text" data-table="registroprueba" data-field="x_Otras_micobacterias" name="x_Otras_micobacterias" id="x_Otras_micobacterias" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Otras_micobacterias->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Otras_micobacterias->EditValue ?>"<?php echo $registroprueba->Otras_micobacterias->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Otras_micobacterias->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Histoplasmosis_Extrapulmonar->Visible) { // Histoplasmosis_Extrapulmonar ?>
	<div id="r_Histoplasmosis_Extrapulmonar" class="form-group">
		<label id="elh_registroprueba_Histoplasmosis_Extrapulmonar" for="x_Histoplasmosis_Extrapulmonar" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Histoplasmosis_Extrapulmonar->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Histoplasmosis_Extrapulmonar->CellAttributes() ?>>
<span id="el_registroprueba_Histoplasmosis_Extrapulmonar">
<input type="text" data-table="registroprueba" data-field="x_Histoplasmosis_Extrapulmonar" name="x_Histoplasmosis_Extrapulmonar" id="x_Histoplasmosis_Extrapulmonar" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Histoplasmosis_Extrapulmonar->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Histoplasmosis_Extrapulmonar->EditValue ?>"<?php echo $registroprueba->Histoplasmosis_Extrapulmonar->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Histoplasmosis_Extrapulmonar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->isosporidiasis_cronica->Visible) { // isosporidiasis_cronica ?>
	<div id="r_isosporidiasis_cronica" class="form-group">
		<label id="elh_registroprueba_isosporidiasis_cronica" for="x_isosporidiasis_cronica" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->isosporidiasis_cronica->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->isosporidiasis_cronica->CellAttributes() ?>>
<span id="el_registroprueba_isosporidiasis_cronica">
<input type="text" data-table="registroprueba" data-field="x_isosporidiasis_cronica" name="x_isosporidiasis_cronica" id="x_isosporidiasis_cronica" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->isosporidiasis_cronica->getPlaceHolder()) ?>" value="<?php echo $registroprueba->isosporidiasis_cronica->EditValue ?>"<?php echo $registroprueba->isosporidiasis_cronica->EditAttributes() ?>>
</span>
<?php echo $registroprueba->isosporidiasis_cronica->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->herpes_zoster->Visible) { // herpes_zoster ?>
	<div id="r_herpes_zoster" class="form-group">
		<label id="elh_registroprueba_herpes_zoster" for="x_herpes_zoster" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->herpes_zoster->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->herpes_zoster->CellAttributes() ?>>
<span id="el_registroprueba_herpes_zoster">
<input type="text" data-table="registroprueba" data-field="x_herpes_zoster" name="x_herpes_zoster" id="x_herpes_zoster" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->herpes_zoster->getPlaceHolder()) ?>" value="<?php echo $registroprueba->herpes_zoster->EditValue ?>"<?php echo $registroprueba->herpes_zoster->EditAttributes() ?>>
</span>
<?php echo $registroprueba->herpes_zoster->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Histoplasmosis_diseminada->Visible) { // Histoplasmosis_diseminada ?>
	<div id="r_Histoplasmosis_diseminada" class="form-group">
		<label id="elh_registroprueba_Histoplasmosis_diseminada" for="x_Histoplasmosis_diseminada" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Histoplasmosis_diseminada->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Histoplasmosis_diseminada->CellAttributes() ?>>
<span id="el_registroprueba_Histoplasmosis_diseminada">
<input type="text" data-table="registroprueba" data-field="x_Histoplasmosis_diseminada" name="x_Histoplasmosis_diseminada" id="x_Histoplasmosis_diseminada" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Histoplasmosis_diseminada->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Histoplasmosis_diseminada->EditValue ?>"<?php echo $registroprueba->Histoplasmosis_diseminada->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Histoplasmosis_diseminada->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Linfoma_Burkitt->Visible) { // Linfoma_Burkitt ?>
	<div id="r_Linfoma_Burkitt" class="form-group">
		<label id="elh_registroprueba_Linfoma_Burkitt" for="x_Linfoma_Burkitt" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Linfoma_Burkitt->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Linfoma_Burkitt->CellAttributes() ?>>
<span id="el_registroprueba_Linfoma_Burkitt">
<input type="text" data-table="registroprueba" data-field="x_Linfoma_Burkitt" name="x_Linfoma_Burkitt" id="x_Linfoma_Burkitt" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Linfoma_Burkitt->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Linfoma_Burkitt->EditValue ?>"<?php echo $registroprueba->Linfoma_Burkitt->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Linfoma_Burkitt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Neumonia_Pneumocystis->Visible) { // Neumonia_Pneumocystis ?>
	<div id="r_Neumonia_Pneumocystis" class="form-group">
		<label id="elh_registroprueba_Neumonia_Pneumocystis" for="x_Neumonia_Pneumocystis" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Neumonia_Pneumocystis->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Neumonia_Pneumocystis->CellAttributes() ?>>
<span id="el_registroprueba_Neumonia_Pneumocystis">
<input type="text" data-table="registroprueba" data-field="x_Neumonia_Pneumocystis" name="x_Neumonia_Pneumocystis" id="x_Neumonia_Pneumocystis" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Neumonia_Pneumocystis->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Neumonia_Pneumocystis->EditValue ?>"<?php echo $registroprueba->Neumonia_Pneumocystis->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Neumonia_Pneumocystis->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Neumonia_Recurrente->Visible) { // Neumonia_Recurrente ?>
	<div id="r_Neumonia_Recurrente" class="form-group">
		<label id="elh_registroprueba_Neumonia_Recurrente" for="x_Neumonia_Recurrente" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Neumonia_Recurrente->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Neumonia_Recurrente->CellAttributes() ?>>
<span id="el_registroprueba_Neumonia_Recurrente">
<input type="text" data-table="registroprueba" data-field="x_Neumonia_Recurrente" name="x_Neumonia_Recurrente" id="x_Neumonia_Recurrente" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Neumonia_Recurrente->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Neumonia_Recurrente->EditValue ?>"<?php echo $registroprueba->Neumonia_Recurrente->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Neumonia_Recurrente->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Linfoma_Inmunoblastico->Visible) { // Linfoma_Inmunoblastico ?>
	<div id="r_Linfoma_Inmunoblastico" class="form-group">
		<label id="elh_registroprueba_Linfoma_Inmunoblastico" for="x_Linfoma_Inmunoblastico" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Linfoma_Inmunoblastico->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Linfoma_Inmunoblastico->CellAttributes() ?>>
<span id="el_registroprueba_Linfoma_Inmunoblastico">
<input type="text" data-table="registroprueba" data-field="x_Linfoma_Inmunoblastico" name="x_Linfoma_Inmunoblastico" id="x_Linfoma_Inmunoblastico" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Linfoma_Inmunoblastico->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Linfoma_Inmunoblastico->EditValue ?>"<?php echo $registroprueba->Linfoma_Inmunoblastico->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Linfoma_Inmunoblastico->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Criptosporidiasis_cronica->Visible) { // Criptosporidiasis_cronica ?>
	<div id="r_Criptosporidiasis_cronica" class="form-group">
		<label id="elh_registroprueba_Criptosporidiasis_cronica" for="x_Criptosporidiasis_cronica" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Criptosporidiasis_cronica->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Criptosporidiasis_cronica->CellAttributes() ?>>
<span id="el_registroprueba_Criptosporidiasis_cronica">
<input type="text" data-table="registroprueba" data-field="x_Criptosporidiasis_cronica" name="x_Criptosporidiasis_cronica" id="x_Criptosporidiasis_cronica" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Criptosporidiasis_cronica->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Criptosporidiasis_cronica->EditValue ?>"<?php echo $registroprueba->Criptosporidiasis_cronica->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Criptosporidiasis_cronica->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Criptococosis_Extrapulmonar->Visible) { // Criptococosis_Extrapulmonar ?>
	<div id="r_Criptococosis_Extrapulmonar" class="form-group">
		<label id="elh_registroprueba_Criptococosis_Extrapulmonar" for="x_Criptococosis_Extrapulmonar" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Criptococosis_Extrapulmonar->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Criptococosis_Extrapulmonar->CellAttributes() ?>>
<span id="el_registroprueba_Criptococosis_Extrapulmonar">
<input type="text" data-table="registroprueba" data-field="x_Criptococosis_Extrapulmonar" name="x_Criptococosis_Extrapulmonar" id="x_Criptococosis_Extrapulmonar" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Criptococosis_Extrapulmonar->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Criptococosis_Extrapulmonar->EditValue ?>"<?php echo $registroprueba->Criptococosis_Extrapulmonar->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Criptococosis_Extrapulmonar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Sarcoma_Kaposi->Visible) { // Sarcoma_Kaposi ?>
	<div id="r_Sarcoma_Kaposi" class="form-group">
		<label id="elh_registroprueba_Sarcoma_Kaposi" for="x_Sarcoma_Kaposi" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Sarcoma_Kaposi->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Sarcoma_Kaposi->CellAttributes() ?>>
<span id="el_registroprueba_Sarcoma_Kaposi">
<input type="text" data-table="registroprueba" data-field="x_Sarcoma_Kaposi" name="x_Sarcoma_Kaposi" id="x_Sarcoma_Kaposi" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Sarcoma_Kaposi->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Sarcoma_Kaposi->EditValue ?>"<?php echo $registroprueba->Sarcoma_Kaposi->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Sarcoma_Kaposi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Sindrome_Emanciacion->Visible) { // Sindrome_Emanciacion ?>
	<div id="r_Sindrome_Emanciacion" class="form-group">
		<label id="elh_registroprueba_Sindrome_Emanciacion" for="x_Sindrome_Emanciacion" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Sindrome_Emanciacion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Sindrome_Emanciacion->CellAttributes() ?>>
<span id="el_registroprueba_Sindrome_Emanciacion">
<input type="text" data-table="registroprueba" data-field="x_Sindrome_Emanciacion" name="x_Sindrome_Emanciacion" id="x_Sindrome_Emanciacion" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Sindrome_Emanciacion->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Sindrome_Emanciacion->EditValue ?>"<?php echo $registroprueba->Sindrome_Emanciacion->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Sindrome_Emanciacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Leucoencefalopatia_Multifocal->Visible) { // Leucoencefalopatia_Multifocal ?>
	<div id="r_Leucoencefalopatia_Multifocal" class="form-group">
		<label id="elh_registroprueba_Leucoencefalopatia_Multifocal" for="x_Leucoencefalopatia_Multifocal" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Leucoencefalopatia_Multifocal->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Leucoencefalopatia_Multifocal->CellAttributes() ?>>
<span id="el_registroprueba_Leucoencefalopatia_Multifocal">
<input type="text" data-table="registroprueba" data-field="x_Leucoencefalopatia_Multifocal" name="x_Leucoencefalopatia_Multifocal" id="x_Leucoencefalopatia_Multifocal" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Leucoencefalopatia_Multifocal->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Leucoencefalopatia_Multifocal->EditValue ?>"<?php echo $registroprueba->Leucoencefalopatia_Multifocal->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Leucoencefalopatia_Multifocal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Septicemia_recurrente->Visible) { // Septicemia_recurrente ?>
	<div id="r_Septicemia_recurrente" class="form-group">
		<label id="elh_registroprueba_Septicemia_recurrente" for="x_Septicemia_recurrente" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Septicemia_recurrente->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Septicemia_recurrente->CellAttributes() ?>>
<span id="el_registroprueba_Septicemia_recurrente">
<input type="text" data-table="registroprueba" data-field="x_Septicemia_recurrente" name="x_Septicemia_recurrente" id="x_Septicemia_recurrente" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Septicemia_recurrente->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Septicemia_recurrente->EditValue ?>"<?php echo $registroprueba->Septicemia_recurrente->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Septicemia_recurrente->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Toxoplasmosis_cerebral->Visible) { // Toxoplasmosis_cerebral ?>
	<div id="r_Toxoplasmosis_cerebral" class="form-group">
		<label id="elh_registroprueba_Toxoplasmosis_cerebral" for="x_Toxoplasmosis_cerebral" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Toxoplasmosis_cerebral->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Toxoplasmosis_cerebral->CellAttributes() ?>>
<span id="el_registroprueba_Toxoplasmosis_cerebral">
<input type="text" data-table="registroprueba" data-field="x_Toxoplasmosis_cerebral" name="x_Toxoplasmosis_cerebral" id="x_Toxoplasmosis_cerebral" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Toxoplasmosis_cerebral->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Toxoplasmosis_cerebral->EditValue ?>"<?php echo $registroprueba->Toxoplasmosis_cerebral->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Toxoplasmosis_cerebral->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->HepatitisB->Visible) { // HepatitisB ?>
	<div id="r_HepatitisB" class="form-group">
		<label id="elh_registroprueba_HepatitisB" for="x_HepatitisB" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->HepatitisB->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->HepatitisB->CellAttributes() ?>>
<span id="el_registroprueba_HepatitisB">
<input type="text" data-table="registroprueba" data-field="x_HepatitisB" name="x_HepatitisB" id="x_HepatitisB" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->HepatitisB->getPlaceHolder()) ?>" value="<?php echo $registroprueba->HepatitisB->EditValue ?>"<?php echo $registroprueba->HepatitisB->EditAttributes() ?>>
</span>
<?php echo $registroprueba->HepatitisB->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->HepatitisC->Visible) { // HepatitisC ?>
	<div id="r_HepatitisC" class="form-group">
		<label id="elh_registroprueba_HepatitisC" for="x_HepatitisC" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->HepatitisC->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->HepatitisC->CellAttributes() ?>>
<span id="el_registroprueba_HepatitisC">
<input type="text" data-table="registroprueba" data-field="x_HepatitisC" name="x_HepatitisC" id="x_HepatitisC" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->HepatitisC->getPlaceHolder()) ?>" value="<?php echo $registroprueba->HepatitisC->EditValue ?>"<?php echo $registroprueba->HepatitisC->EditAttributes() ?>>
</span>
<?php echo $registroprueba->HepatitisC->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Meningitis->Visible) { // Meningitis ?>
	<div id="r_Meningitis" class="form-group">
		<label id="elh_registroprueba_Meningitis" for="x_Meningitis" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Meningitis->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Meningitis->CellAttributes() ?>>
<span id="el_registroprueba_Meningitis">
<input type="text" data-table="registroprueba" data-field="x_Meningitis" name="x_Meningitis" id="x_Meningitis" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Meningitis->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Meningitis->EditValue ?>"<?php echo $registroprueba->Meningitis->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Meningitis->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->RecuentoCD4->Visible) { // RecuentoCD4 ?>
	<div id="r_RecuentoCD4" class="form-group">
		<label id="elh_registroprueba_RecuentoCD4" for="x_RecuentoCD4" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->RecuentoCD4->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->RecuentoCD4->CellAttributes() ?>>
<span id="el_registroprueba_RecuentoCD4">
<input type="text" data-table="registroprueba" data-field="x_RecuentoCD4" name="x_RecuentoCD4" id="x_RecuentoCD4" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->RecuentoCD4->getPlaceHolder()) ?>" value="<?php echo $registroprueba->RecuentoCD4->EditValue ?>"<?php echo $registroprueba->RecuentoCD4->EditAttributes() ?>>
</span>
<?php echo $registroprueba->RecuentoCD4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Registrado_Por->Visible) { // Registrado_Por ?>
	<div id="r_Registrado_Por" class="form-group">
		<label id="elh_registroprueba_Registrado_Por" for="x_Registrado_Por" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Registrado_Por->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Registrado_Por->CellAttributes() ?>>
<span id="el_registroprueba_Registrado_Por">
<input type="text" data-table="registroprueba" data-field="x_Registrado_Por" name="x_Registrado_Por" id="x_Registrado_Por" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($registroprueba->Registrado_Por->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Registrado_Por->EditValue ?>"<?php echo $registroprueba->Registrado_Por->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Registrado_Por->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($registroprueba->Actualmente_Seguimiento->Visible) { // Actualmente_Seguimiento ?>
	<div id="r_Actualmente_Seguimiento" class="form-group">
		<label id="elh_registroprueba_Actualmente_Seguimiento" for="x_Actualmente_Seguimiento" class="col-sm-2 control-label ewLabel"><?php echo $registroprueba->Actualmente_Seguimiento->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $registroprueba->Actualmente_Seguimiento->CellAttributes() ?>>
<span id="el_registroprueba_Actualmente_Seguimiento">
<input type="text" data-table="registroprueba" data-field="x_Actualmente_Seguimiento" name="x_Actualmente_Seguimiento" id="x_Actualmente_Seguimiento" size="30" placeholder="<?php echo ew_HtmlEncode($registroprueba->Actualmente_Seguimiento->getPlaceHolder()) ?>" value="<?php echo $registroprueba->Actualmente_Seguimiento->EditValue ?>"<?php echo $registroprueba->Actualmente_Seguimiento->EditAttributes() ?>>
</span>
<?php echo $registroprueba->Actualmente_Seguimiento->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div>
<div class="form-group">
	<div class="col-sm-offset-2 col-sm-10">
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $registroprueba_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div>
</div>
</form>
<script type="text/javascript">
fregistropruebaedit.Init();
</script>
<?php
$registroprueba_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$registroprueba_edit->Page_Terminate();
?>
