<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "registroinfo.php" ?>
<?php include_once "ficha_usuarioinfo.php" ?>
<?php include_once "seguimiento_individual3gridcls.php" ?>
<?php include_once "seguimiento_maternogridcls.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$registro_view = NULL; // Initialize page object first

class cregistro_view extends cregistro {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{43FC4B6C-8131-46B1-916C-14DB52B1691D}";

	// Table name
	var $TableName = 'registro';

	// Page object name
	var $PageObjName = 'registro_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (registro)
		if (!isset($GLOBALS["registro"]) || get_class($GLOBALS["registro"]) == "cregistro") {
			$GLOBALS["registro"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["registro"];
		}
		$KeyUrl = "";
		if (@$_GET["Consecutivo"] <> "") {
			$this->RecKey["Consecutivo"] = $_GET["Consecutivo"];
			$KeyUrl .= "&amp;Consecutivo=" . urlencode($this->RecKey["Consecutivo"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (ficha_usuario)
		if (!isset($GLOBALS['ficha_usuario'])) $GLOBALS['ficha_usuario'] = new cficha_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'registro', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (ficha_usuario)
		if (!isset($UserTable)) {
			$UserTable = new cficha_usuario();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("registrolist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}
		if ($Security->IsLoggedIn()) {
			$Security->UserID_Loading();
			$Security->LoadUserID();
			$Security->UserID_Loaded();
			if (strval($Security->CurrentUserID()) == "") {
				$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
				$this->Page_Terminate(ew_GetUrl("registrolist.php"));
			}
		}

		// Get export parameters
		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header
		if (@$_GET["Consecutivo"] <> "") {
			if ($gsExportFile <> "") $gsExportFile .= "_";
			$gsExportFile .= ew_StripSlashes($_GET["Consecutivo"]);
		}

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Setup export options
		$this->SetupExportOptions();
		$this->Consecutivo->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Set up multi page object
		$this->SetupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $registro;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($registro);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $DbMasterFilter;
	var $DbDetailFilter;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $RecCnt;
	var $RecKey = array();
	var $seguimiento_individual3_Count;
	var $seguimiento_materno_Count;
	var $Recordset;
	var $MultiPages; // Multi pages object

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["Consecutivo"] <> "") {
				$this->Consecutivo->setQueryStringValue($_GET["Consecutivo"]);
				$this->RecKey["Consecutivo"] = $this->Consecutivo->QueryStringValue;
			} elseif (@$_POST["Consecutivo"] <> "") {
				$this->Consecutivo->setFormValue($_POST["Consecutivo"]);
				$this->RecKey["Consecutivo"] = $this->Consecutivo->FormValue;
			} else {
				$bLoadCurrentRecord = TRUE;
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					$this->StartRec = 1; // Initialize start position
					if ($this->Recordset = $this->LoadRecordset()) // Load records
						$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
					if ($this->TotalRecs <= 0) { // No record found
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$this->Page_Terminate("registrolist.php"); // Return to list page
					} elseif ($bLoadCurrentRecord) { // Load current record position
						$this->SetUpStartRec(); // Set up start record position

						// Point to current record
						if (intval($this->StartRec) <= intval($this->TotalRecs)) {
							$bMatchRecord = TRUE;
							$this->Recordset->Move($this->StartRec-1);
						}
					} else { // Match key values
						while (!$this->Recordset->EOF) {
							if (strval($this->Consecutivo->CurrentValue) == strval($this->Recordset->fields('Consecutivo'))) {
								$this->setStartRecordNumber($this->StartRec); // Save record position
								$bMatchRecord = TRUE;
								break;
							} else {
								$this->StartRec++;
								$this->Recordset->MoveNext();
							}
						}
					}
					if (!$bMatchRecord) {
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "registrolist.php"; // No matching record, return to list
					} else {
						$this->LoadRowValues($this->Recordset); // Load row values
					}
			}

			// Export data only
			if ($this->CustomExport == "" && in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "registrolist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();

		// Set up detail parameters
		$this->SetUpDetailParms();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageAddLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageAddLink")) . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Edit
		$item = &$option->Add("edit");
		$item->Body = "<a class=\"ewAction ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageEditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageEditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->CanEdit()&& $this->ShowOptionLink('edit'));

		// Copy
		$item = &$option->Add("copy");
		$item->Body = "<a class=\"ewAction ewCopy\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageCopyLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageCopyLink")) . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->CanAdd() && $this->ShowOptionLink('add'));

		// Delete
		$item = &$option->Add("delete");
		$item->Body = "<a onclick=\"return ew_ConfirmDelete(this);\" class=\"ewAction ewDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->CanDelete() && $this->ShowOptionLink('delete'));
		$option = &$options["detail"];
		$DetailTableLink = "";
		$DetailViewTblVar = "";
		$DetailCopyTblVar = "";
		$DetailEditTblVar = "";

		// "detail_seguimiento_individual3"
		$item = &$option->Add("detail_seguimiento_individual3");
		$body = $Language->Phrase("ViewPageDetailLink") . $Language->TablePhrase("seguimiento_individual3", "TblCaption");
		$body .= str_replace("%c", $this->seguimiento_individual3_Count, $Language->Phrase("DetailCount"));
		$body = "<a class=\"btn btn-default btn-sm ewRowLink ewDetail\" data-action=\"list\" href=\"" . ew_HtmlEncode("seguimiento_individual3list.php?" . EW_TABLE_SHOW_MASTER . "=registro&fk_Consecutivo=" . urlencode(strval($this->Consecutivo->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if ($GLOBALS["seguimiento_individual3_grid"] && $GLOBALS["seguimiento_individual3_grid"]->DetailView && $Security->CanView() && $Security->AllowView(CurrentProjectID() . 'seguimiento_individual3')) {
			$links .= "<li><a class=\"ewRowLink ewDetailView\" data-action=\"view\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailViewLink")) . "\" href=\"" . ew_HtmlEncode($this->GetViewUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_individual3")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailViewLink")) . "</a></li>";
			if ($DetailViewTblVar <> "") $DetailViewTblVar .= ",";
			$DetailViewTblVar .= "seguimiento_individual3";
		}
		if ($GLOBALS["seguimiento_individual3_grid"] && $GLOBALS["seguimiento_individual3_grid"]->DetailEdit && $Security->CanEdit() && $Security->AllowEdit(CurrentProjectID() . 'seguimiento_individual3')) {
			$links .= "<li><a class=\"ewRowLink ewDetailEdit\" data-action=\"edit\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailEditLink")) . "\" href=\"" . ew_HtmlEncode($this->GetEditUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_individual3")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailEditLink")) . "</a></li>";
			if ($DetailEditTblVar <> "") $DetailEditTblVar .= ",";
			$DetailEditTblVar .= "seguimiento_individual3";
		}
		if ($GLOBALS["seguimiento_individual3_grid"] && $GLOBALS["seguimiento_individual3_grid"]->DetailAdd && $Security->CanAdd() && $Security->AllowAdd(CurrentProjectID() . 'seguimiento_individual3')) {
			$links .= "<li><a class=\"ewRowLink ewDetailCopy\" data-action=\"add\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailCopyLink")) . "\" href=\"" . ew_HtmlEncode($this->GetCopyUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_individual3")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($DetailCopyTblVar <> "") $DetailCopyTblVar .= ",";
			$DetailCopyTblVar .= "seguimiento_individual3";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default btn-sm ewDetail\" data-toggle=\"dropdown\"><b class=\"caret\"></b></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->AllowList(CurrentProjectID() . 'seguimiento_individual3');
		if ($item->Visible) {
			if ($DetailTableLink <> "") $DetailTableLink .= ",";
			$DetailTableLink .= "seguimiento_individual3";
		}
		if ($this->ShowMultipleDetails) $item->Visible = FALSE;

		// "detail_seguimiento_materno"
		$item = &$option->Add("detail_seguimiento_materno");
		$body = $Language->Phrase("ViewPageDetailLink") . $Language->TablePhrase("seguimiento_materno", "TblCaption");
		$body .= str_replace("%c", $this->seguimiento_materno_Count, $Language->Phrase("DetailCount"));
		$body = "<a class=\"btn btn-default btn-sm ewRowLink ewDetail\" data-action=\"list\" href=\"" . ew_HtmlEncode("seguimiento_maternolist.php?" . EW_TABLE_SHOW_MASTER . "=registro&fk_Consecutivo=" . urlencode(strval($this->Consecutivo->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if ($GLOBALS["seguimiento_materno_grid"] && $GLOBALS["seguimiento_materno_grid"]->DetailView && $Security->CanView() && $Security->AllowView(CurrentProjectID() . 'seguimiento_materno')) {
			$links .= "<li><a class=\"ewRowLink ewDetailView\" data-action=\"view\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailViewLink")) . "\" href=\"" . ew_HtmlEncode($this->GetViewUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_materno")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailViewLink")) . "</a></li>";
			if ($DetailViewTblVar <> "") $DetailViewTblVar .= ",";
			$DetailViewTblVar .= "seguimiento_materno";
		}
		if ($GLOBALS["seguimiento_materno_grid"] && $GLOBALS["seguimiento_materno_grid"]->DetailEdit && $Security->CanEdit() && $Security->AllowEdit(CurrentProjectID() . 'seguimiento_materno')) {
			$links .= "<li><a class=\"ewRowLink ewDetailEdit\" data-action=\"edit\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailEditLink")) . "\" href=\"" . ew_HtmlEncode($this->GetEditUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_materno")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailEditLink")) . "</a></li>";
			if ($DetailEditTblVar <> "") $DetailEditTblVar .= ",";
			$DetailEditTblVar .= "seguimiento_materno";
		}
		if ($GLOBALS["seguimiento_materno_grid"] && $GLOBALS["seguimiento_materno_grid"]->DetailAdd && $Security->CanAdd() && $Security->AllowAdd(CurrentProjectID() . 'seguimiento_materno')) {
			$links .= "<li><a class=\"ewRowLink ewDetailCopy\" data-action=\"add\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailCopyLink")) . "\" href=\"" . ew_HtmlEncode($this->GetCopyUrl(EW_TABLE_SHOW_DETAIL . "=seguimiento_materno")) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($DetailCopyTblVar <> "") $DetailCopyTblVar .= ",";
			$DetailCopyTblVar .= "seguimiento_materno";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default btn-sm ewDetail\" data-toggle=\"dropdown\"><b class=\"caret\"></b></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->AllowList(CurrentProjectID() . 'seguimiento_materno');
		if ($item->Visible) {
			if ($DetailTableLink <> "") $DetailTableLink .= ",";
			$DetailTableLink .= "seguimiento_materno";
		}
		if ($this->ShowMultipleDetails) $item->Visible = FALSE;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = $Language->Phrase("MultipleMasterDetails");
			$body = "<div class=\"btn-group\">";
			$links = "";
			if ($DetailViewTblVar <> "") {
				$links .= "<li><a class=\"ewRowLink ewDetailView\" data-action=\"view\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailViewLink")) . "\" href=\"" . ew_HtmlEncode($this->GetViewUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailViewTblVar)) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($DetailEditTblVar <> "") {
				$links .= "<li><a class=\"ewRowLink ewDetailEdit\" data-action=\"edit\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailEditLink")) . "\" href=\"" . ew_HtmlEncode($this->GetEditUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailEditTblVar)) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($DetailCopyTblVar <> "") {
				$links .= "<li><a class=\"ewRowLink ewDetailCopy\" data-action=\"add\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("MasterDetailCopyLink")) . "\" href=\"" . ew_HtmlEncode($this->GetCopyUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailCopyTblVar)) . "\">" . ew_HtmlImageAndText($Language->Phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default btn-sm ewMasterDetail\" title=\"" . ew_HtmlTitle($Language->Phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("MultipleMasterDetails") . "<b class=\"caret\"></b></button>";
				$body .= "<ul class=\"dropdown-menu ewMenu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$oListOpt = &$option->Add("details");
			$oListOpt->Body = $body;
		}

		// Set up detail default
		$option = &$options["detail"];
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$option->UseImageAndText = TRUE;
		$ar = explode(",", $DetailTableLink);
		$cnt = count($ar);
		$option->UseDropDownButton = ($cnt > 1);
		$option->UseButtonGroup = TRUE;
		$item = &$option->Add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
		$option->UseImageAndText = TRUE;
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->Add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Seguimiento->setDbValue($rs->fields('Seguimiento'));
		$this->Condicion_Final->setDbValue($rs->fields('Condicion_Final'));
		$this->Codigo_centro->setDbValue($rs->fields('Codigo_centro'));
		$this->Codigo_UPGD->setDbValue($rs->fields('Codigo_UPGD'));
		$this->Cod_Evento->setDbValue($rs->fields('Cod_Evento'));
		$this->Embarazo_Actual->setDbValue($rs->fields('Embarazo_Actual'));
		$this->Fecha_Notificacion->setDbValue($rs->fields('Fecha_Notificacion'));
		$this->Semana->setDbValue($rs->fields('Semana'));
		$this->Periodo_Epidemiologico->setDbValue($rs->fields('Periodo_Epidemiologico'));
		$this->Periodo_Sivigila->setDbValue($rs->fields('Periodo_Sivigila'));
		$this->Primer_Nombre->setDbValue($rs->fields('Primer_Nombre'));
		$this->Segundo_Nombre->setDbValue($rs->fields('Segundo_Nombre'));
		$this->Primer_Apellido->setDbValue($rs->fields('Primer_Apellido'));
		$this->Segundo_Apellido->setDbValue($rs->fields('Segundo_Apellido'));
		$this->Tipo_Id->setDbValue($rs->fields('Tipo_Id'));
		$this->Numero_Identificacion->setDbValue($rs->fields('Numero_Identificacion'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Unidad_Edad->setDbValue($rs->fields('Unidad_Edad'));
		$this->Sexo->setDbValue($rs->fields('Sexo'));
		$this->Pais_Ocurrencia->setDbValue($rs->fields('Pais_Ocurrencia'));
		$this->Depto_Ocurrencia->setDbValue($rs->fields('Depto_Ocurrencia'));
		$this->Municipio_Ocurrencia->setDbValue($rs->fields('Municipio_Ocurrencia'));
		$this->Area_Ocurrencia->setDbValue($rs->fields('Area_Ocurrencia'));
		$this->Localidad->setDbValue($rs->fields('Localidad'));
		$this->Barrio->setDbValue($rs->fields('Barrio'));
		$this->Direccion_Residencia->setDbValue($rs->fields('Direccion_Residencia'));
		$this->Ocupacion->setDbValue($rs->fields('Ocupacion'));
		$this->Tipo_Regimen_Salud->setDbValue($rs->fields('Tipo_Regimen_Salud'));
		$this->Cod_Administradora->setDbValue($rs->fields('Cod_Administradora'));
		$this->gp_discapa->setDbValue($rs->fields('gp_discapa'));
		$this->gp_desplaz->setDbValue($rs->fields('gp_desplaz'));
		$this->gp_migrant->setDbValue($rs->fields('gp_migrant'));
		$this->gp_carcela->setDbValue($rs->fields('gp_carcela'));
		$this->gp_gestan->setDbValue($rs->fields('gp_gestan'));
		$this->gp_indigen->setDbValue($rs->fields('gp_indigen'));
		$this->gp_pobicbf->setDbValue($rs->fields('gp_pobicbf'));
		$this->gp_mad_com->setDbValue($rs->fields('gp_mad_com'));
		$this->gp_desmovi->setDbValue($rs->fields('gp_desmovi'));
		$this->gp_psiquia->setDbValue($rs->fields('gp_psiquia'));
		$this->gp_vic_vio->setDbValue($rs->fields('gp_vic_vio'));
		$this->gp_otros->setDbValue($rs->fields('gp_otros'));
		$this->Depto_Residencia->setDbValue($rs->fields('Depto_Residencia'));
		$this->Municipio_Residencia->setDbValue($rs->fields('Municipio_Residencia'));
		$this->Fecha_Consulta->setDbValue($rs->fields('Fecha_Consulta'));
		$this->Fecha_Inicio_Sintomas->setDbValue($rs->fields('Fecha_Inicio_Sintomas'));
		$this->Hospitalizado->setDbValue($rs->fields('Hospitalizado'));
		$this->Fecha_Defuncion->setDbValue($rs->fields('Fecha_Defuncion'));
		$this->Numero_Certificado_Defuncion->setDbValue($rs->fields('Numero_Certificado_Defuncion'));
		$this->Causa_Basica_Muerte_CIEX->setDbValue($rs->fields('Causa_Basica_Muerte_CIEX'));
		$this->Entidad_fallecimiento->setDbValue($rs->fields('Entidad_fallecimiento'));
		$this->Telefono->setDbValue($rs->fields('Telefono'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Nombre_Profesional_Diligencia->setDbValue($rs->fields('Nombre_Profesional_Diligencia'));
		$this->Telefono_Profesional_Diligencia->setDbValue($rs->fields('Telefono_Profesional_Diligencia'));
		$this->Mecanismo_Probable_Transmision->setDbValue($rs->fields('Mecanismo_Probable_Transmision'));
		$this->Nombre_Madre->setDbValue($rs->fields('Nombre_Madre'));
		$this->Tipo_Id_Madre->setDbValue($rs->fields('Tipo_Id_Madre'));
		$this->Numero_Identificacion_Madre->setDbValue($rs->fields('Numero_Identificacion_Madre'));
		$this->Indentidad_Genero->setDbValue($rs->fields('Indentidad_Genero'));
		$this->Donador_Sangre_Ultimos_12_Meses->setDbValue($rs->fields('Donador_Sangre_Ultimos_12_Meses'));
		$this->Fecha_Donacion->setDbValue($rs->fields('Fecha_Donacion'));
		$this->Nombre_Institucion_Donacion->setDbValue($rs->fields('Nombre_Institucion_Donacion'));
		$this->Poblacion_clave->setDbValue($rs->fields('Poblacion_clave'));
		$this->Recibio_Asesoria_Pre_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Pre_Prueba'));
		$this->Recibio_Asesoria_Post_Prueba->setDbValue($rs->fields('Recibio_Asesoria_Post_Prueba'));
		$this->Tipo_Prueba->setDbValue($rs->fields('Tipo_Prueba'));
		$this->Fecha_Resultado_Confirmatorio->setDbValue($rs->fields('Fecha_Resultado_Confirmatorio'));
		$this->Valor_Carga_Viral->setDbValue($rs->fields('Valor_Carga_Viral'));
		$this->Estado_Clinico_Notificacion->setDbValue($rs->fields('Estado_Clinico_Notificacion'));
		$this->Hijos_Mujeres_Menores_5->setDbValue($rs->fields('Hijos_Mujeres_Menores_5'));
		$this->Hijos_Hombres_Menores_5->setDbValue($rs->fields('Hijos_Hombres_Menores_5'));
		$this->Numero_Semanas_Embarazo->setDbValue($rs->fields('Numero_Semanas_Embarazo'));
		$this->Antecedentes_Embarazo->setDbValue($rs->fields('Antecedentes_Embarazo'));
		$this->Candidiasis_esofagica->setDbValue($rs->fields('Candidiasis_esofagica'));
		$this->Candidiasis_vias_aereas->setDbValue($rs->fields('Candidiasis_vias_aereas'));
		$this->Tuberculosis_pulmonar->setDbValue($rs->fields('Tuberculosis_pulmonar'));
		$this->Cancer_cervical->setDbValue($rs->fields('Cancer_cervical'));
		$this->Tuberculosis_extrapulmonar->setDbValue($rs->fields('Tuberculosis_extrapulmonar'));
		$this->Coccidiomicosis->setDbValue($rs->fields('Coccidiomicosis'));
		$this->Citomegalovirosis->setDbValue($rs->fields('Citomegalovirosis'));
		$this->Retinitis_citomegalovirosis->setDbValue($rs->fields('Retinitis_citomegalovirosis'));
		$this->Sindrome_Emanciacion->setDbValue($rs->fields('Sindrome_Emanciacion'));
		$this->Encefalopatia->setDbValue($rs->fields('Encefalopatia'));
		$this->Otras_micobacterias->setDbValue($rs->fields('Otras_micobacterias'));
		$this->Histoplasmosis_Extrapulmonar->setDbValue($rs->fields('Histoplasmosis_Extrapulmonar'));
		$this->isosporidiasis_cronica->setDbValue($rs->fields('isosporidiasis_cronica'));
		$this->herpes_zoster->setDbValue($rs->fields('herpes_zoster'));
		$this->Histoplasmosis_diseminada->setDbValue($rs->fields('Histoplasmosis_diseminada'));
		$this->Linfoma_Burkitt->setDbValue($rs->fields('Linfoma_Burkitt'));
		$this->Neumonia_Pneumocystis->setDbValue($rs->fields('Neumonia_Pneumocystis'));
		$this->Neumonia_Recurrente->setDbValue($rs->fields('Neumonia_Recurrente'));
		$this->Linfoma_Inmunoblastico->setDbValue($rs->fields('Linfoma_Inmunoblastico'));
		$this->Criptosporidiasis_cronica->setDbValue($rs->fields('Criptosporidiasis_cronica'));
		$this->Criptococosis_Extrapulmonar->setDbValue($rs->fields('Criptococosis_Extrapulmonar'));
		$this->Sarcoma_Kaposi->setDbValue($rs->fields('Sarcoma_Kaposi'));
		$this->Leucoencefalopatia_Multifocal->setDbValue($rs->fields('Leucoencefalopatia_Multifocal'));
		$this->Septicemia_recurrente->setDbValue($rs->fields('Septicemia_recurrente'));
		$this->Toxoplasmosis_cerebral->setDbValue($rs->fields('Toxoplasmosis_cerebral'));
		$this->HepatitisB->setDbValue($rs->fields('HepatitisB'));
		$this->HepatitisC->setDbValue($rs->fields('HepatitisC'));
		$this->Meningitis->setDbValue($rs->fields('Meningitis'));
		$this->RecuentoCD4->setDbValue($rs->fields('RecuentoCD4'));
		$this->Registrado_Por->setDbValue($rs->fields('Registrado_Por'));
		$this->Centro_Poblado->setDbValue($rs->fields('Centro_Poblado'));
		$this->Vereda->setDbValue($rs->fields('Vereda'));
		$this->Pertenencia_Etnica->setDbValue($rs->fields('Pertenencia_Etnica'));
		$this->Grupo_Poblacional->setDbValue($rs->fields('Grupo_Poblacional'));
		$this->Clasificacion_Inicial->setDbValue($rs->fields('Clasificacion_Inicial'));
		$this->Fecha_Hospitalizacion->setDbValue($rs->fields('Fecha_Hospitalizacion'));
		$this->Seguimiento_Clasificacion_Final->setDbValue($rs->fields('Seguimiento_Clasificacion_Final'));
		$this->Fecha_Ajuste->setDbValue($rs->fields('Fecha_Ajuste'));
		$this->Nombre_Evento->setDbValue($rs->fields('Nombre_Evento'));
		$this->Localidad_residencia->setDbValue($rs->fields('Localidad_residencia'));
		$this->Barrio_residencia->setDbValue($rs->fields('Barrio_residencia'));
		$this->Fecha_ingreso_app->setDbValue($rs->fields('Fecha_ingreso_app'));
		$this->Actualizado_por->setDbValue($rs->fields('Actualizado_por'));
		$this->Fecha_actualizacion_app->setDbValue($rs->fields('Fecha_actualizacion_app'));
		if (!isset($GLOBALS["seguimiento_individual3_grid"])) $GLOBALS["seguimiento_individual3_grid"] = new cseguimiento_individual3_grid;
		$sDetailFilter = $GLOBALS["seguimiento_individual3"]->SqlDetailFilter_registro();
		$sDetailFilter = str_replace("@Id_Registro@", ew_AdjustSql($this->Consecutivo->DbValue, "DB"), $sDetailFilter);
		$GLOBALS["seguimiento_individual3"]->setCurrentMasterTable("registro");
		$sDetailFilter = $GLOBALS["seguimiento_individual3"]->ApplyUserIDFilters($sDetailFilter);
		$this->seguimiento_individual3_Count = $GLOBALS["seguimiento_individual3"]->LoadRecordCount($sDetailFilter);
		if (!isset($GLOBALS["seguimiento_materno_grid"])) $GLOBALS["seguimiento_materno_grid"] = new cseguimiento_materno_grid;
		$sDetailFilter = $GLOBALS["seguimiento_materno"]->SqlDetailFilter_registro();
		$sDetailFilter = str_replace("@Id_Registro@", ew_AdjustSql($this->Consecutivo->DbValue, "DB"), $sDetailFilter);
		$GLOBALS["seguimiento_materno"]->setCurrentMasterTable("registro");
		$sDetailFilter = $GLOBALS["seguimiento_materno"]->ApplyUserIDFilters($sDetailFilter);
		$this->seguimiento_materno_Count = $GLOBALS["seguimiento_materno"]->LoadRecordCount($sDetailFilter);
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Consecutivo->DbValue = $row['Consecutivo'];
		$this->Seguimiento->DbValue = $row['Seguimiento'];
		$this->Condicion_Final->DbValue = $row['Condicion_Final'];
		$this->Codigo_centro->DbValue = $row['Codigo_centro'];
		$this->Codigo_UPGD->DbValue = $row['Codigo_UPGD'];
		$this->Cod_Evento->DbValue = $row['Cod_Evento'];
		$this->Embarazo_Actual->DbValue = $row['Embarazo_Actual'];
		$this->Fecha_Notificacion->DbValue = $row['Fecha_Notificacion'];
		$this->Semana->DbValue = $row['Semana'];
		$this->Periodo_Epidemiologico->DbValue = $row['Periodo_Epidemiologico'];
		$this->Periodo_Sivigila->DbValue = $row['Periodo_Sivigila'];
		$this->Primer_Nombre->DbValue = $row['Primer_Nombre'];
		$this->Segundo_Nombre->DbValue = $row['Segundo_Nombre'];
		$this->Primer_Apellido->DbValue = $row['Primer_Apellido'];
		$this->Segundo_Apellido->DbValue = $row['Segundo_Apellido'];
		$this->Tipo_Id->DbValue = $row['Tipo_Id'];
		$this->Numero_Identificacion->DbValue = $row['Numero_Identificacion'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Unidad_Edad->DbValue = $row['Unidad_Edad'];
		$this->Sexo->DbValue = $row['Sexo'];
		$this->Pais_Ocurrencia->DbValue = $row['Pais_Ocurrencia'];
		$this->Depto_Ocurrencia->DbValue = $row['Depto_Ocurrencia'];
		$this->Municipio_Ocurrencia->DbValue = $row['Municipio_Ocurrencia'];
		$this->Area_Ocurrencia->DbValue = $row['Area_Ocurrencia'];
		$this->Localidad->DbValue = $row['Localidad'];
		$this->Barrio->DbValue = $row['Barrio'];
		$this->Direccion_Residencia->DbValue = $row['Direccion_Residencia'];
		$this->Ocupacion->DbValue = $row['Ocupacion'];
		$this->Tipo_Regimen_Salud->DbValue = $row['Tipo_Regimen_Salud'];
		$this->Cod_Administradora->DbValue = $row['Cod_Administradora'];
		$this->gp_discapa->DbValue = $row['gp_discapa'];
		$this->gp_desplaz->DbValue = $row['gp_desplaz'];
		$this->gp_migrant->DbValue = $row['gp_migrant'];
		$this->gp_carcela->DbValue = $row['gp_carcela'];
		$this->gp_gestan->DbValue = $row['gp_gestan'];
		$this->gp_indigen->DbValue = $row['gp_indigen'];
		$this->gp_pobicbf->DbValue = $row['gp_pobicbf'];
		$this->gp_mad_com->DbValue = $row['gp_mad_com'];
		$this->gp_desmovi->DbValue = $row['gp_desmovi'];
		$this->gp_psiquia->DbValue = $row['gp_psiquia'];
		$this->gp_vic_vio->DbValue = $row['gp_vic_vio'];
		$this->gp_otros->DbValue = $row['gp_otros'];
		$this->Depto_Residencia->DbValue = $row['Depto_Residencia'];
		$this->Municipio_Residencia->DbValue = $row['Municipio_Residencia'];
		$this->Fecha_Consulta->DbValue = $row['Fecha_Consulta'];
		$this->Fecha_Inicio_Sintomas->DbValue = $row['Fecha_Inicio_Sintomas'];
		$this->Hospitalizado->DbValue = $row['Hospitalizado'];
		$this->Fecha_Defuncion->DbValue = $row['Fecha_Defuncion'];
		$this->Numero_Certificado_Defuncion->DbValue = $row['Numero_Certificado_Defuncion'];
		$this->Causa_Basica_Muerte_CIEX->DbValue = $row['Causa_Basica_Muerte_CIEX'];
		$this->Entidad_fallecimiento->DbValue = $row['Entidad_fallecimiento'];
		$this->Telefono->DbValue = $row['Telefono'];
		$this->Fecha_Nacimiento->DbValue = $row['Fecha_Nacimiento'];
		$this->Nombre_Profesional_Diligencia->DbValue = $row['Nombre_Profesional_Diligencia'];
		$this->Telefono_Profesional_Diligencia->DbValue = $row['Telefono_Profesional_Diligencia'];
		$this->Mecanismo_Probable_Transmision->DbValue = $row['Mecanismo_Probable_Transmision'];
		$this->Nombre_Madre->DbValue = $row['Nombre_Madre'];
		$this->Tipo_Id_Madre->DbValue = $row['Tipo_Id_Madre'];
		$this->Numero_Identificacion_Madre->DbValue = $row['Numero_Identificacion_Madre'];
		$this->Indentidad_Genero->DbValue = $row['Indentidad_Genero'];
		$this->Donador_Sangre_Ultimos_12_Meses->DbValue = $row['Donador_Sangre_Ultimos_12_Meses'];
		$this->Fecha_Donacion->DbValue = $row['Fecha_Donacion'];
		$this->Nombre_Institucion_Donacion->DbValue = $row['Nombre_Institucion_Donacion'];
		$this->Poblacion_clave->DbValue = $row['Poblacion_clave'];
		$this->Recibio_Asesoria_Pre_Prueba->DbValue = $row['Recibio_Asesoria_Pre_Prueba'];
		$this->Recibio_Asesoria_Post_Prueba->DbValue = $row['Recibio_Asesoria_Post_Prueba'];
		$this->Tipo_Prueba->DbValue = $row['Tipo_Prueba'];
		$this->Fecha_Resultado_Confirmatorio->DbValue = $row['Fecha_Resultado_Confirmatorio'];
		$this->Valor_Carga_Viral->DbValue = $row['Valor_Carga_Viral'];
		$this->Estado_Clinico_Notificacion->DbValue = $row['Estado_Clinico_Notificacion'];
		$this->Hijos_Mujeres_Menores_5->DbValue = $row['Hijos_Mujeres_Menores_5'];
		$this->Hijos_Hombres_Menores_5->DbValue = $row['Hijos_Hombres_Menores_5'];
		$this->Numero_Semanas_Embarazo->DbValue = $row['Numero_Semanas_Embarazo'];
		$this->Antecedentes_Embarazo->DbValue = $row['Antecedentes_Embarazo'];
		$this->Candidiasis_esofagica->DbValue = $row['Candidiasis_esofagica'];
		$this->Candidiasis_vias_aereas->DbValue = $row['Candidiasis_vias_aereas'];
		$this->Tuberculosis_pulmonar->DbValue = $row['Tuberculosis_pulmonar'];
		$this->Cancer_cervical->DbValue = $row['Cancer_cervical'];
		$this->Tuberculosis_extrapulmonar->DbValue = $row['Tuberculosis_extrapulmonar'];
		$this->Coccidiomicosis->DbValue = $row['Coccidiomicosis'];
		$this->Citomegalovirosis->DbValue = $row['Citomegalovirosis'];
		$this->Retinitis_citomegalovirosis->DbValue = $row['Retinitis_citomegalovirosis'];
		$this->Sindrome_Emanciacion->DbValue = $row['Sindrome_Emanciacion'];
		$this->Encefalopatia->DbValue = $row['Encefalopatia'];
		$this->Otras_micobacterias->DbValue = $row['Otras_micobacterias'];
		$this->Histoplasmosis_Extrapulmonar->DbValue = $row['Histoplasmosis_Extrapulmonar'];
		$this->isosporidiasis_cronica->DbValue = $row['isosporidiasis_cronica'];
		$this->herpes_zoster->DbValue = $row['herpes_zoster'];
		$this->Histoplasmosis_diseminada->DbValue = $row['Histoplasmosis_diseminada'];
		$this->Linfoma_Burkitt->DbValue = $row['Linfoma_Burkitt'];
		$this->Neumonia_Pneumocystis->DbValue = $row['Neumonia_Pneumocystis'];
		$this->Neumonia_Recurrente->DbValue = $row['Neumonia_Recurrente'];
		$this->Linfoma_Inmunoblastico->DbValue = $row['Linfoma_Inmunoblastico'];
		$this->Criptosporidiasis_cronica->DbValue = $row['Criptosporidiasis_cronica'];
		$this->Criptococosis_Extrapulmonar->DbValue = $row['Criptococosis_Extrapulmonar'];
		$this->Sarcoma_Kaposi->DbValue = $row['Sarcoma_Kaposi'];
		$this->Leucoencefalopatia_Multifocal->DbValue = $row['Leucoencefalopatia_Multifocal'];
		$this->Septicemia_recurrente->DbValue = $row['Septicemia_recurrente'];
		$this->Toxoplasmosis_cerebral->DbValue = $row['Toxoplasmosis_cerebral'];
		$this->HepatitisB->DbValue = $row['HepatitisB'];
		$this->HepatitisC->DbValue = $row['HepatitisC'];
		$this->Meningitis->DbValue = $row['Meningitis'];
		$this->RecuentoCD4->DbValue = $row['RecuentoCD4'];
		$this->Registrado_Por->DbValue = $row['Registrado_Por'];
		$this->Centro_Poblado->DbValue = $row['Centro_Poblado'];
		$this->Vereda->DbValue = $row['Vereda'];
		$this->Pertenencia_Etnica->DbValue = $row['Pertenencia_Etnica'];
		$this->Grupo_Poblacional->DbValue = $row['Grupo_Poblacional'];
		$this->Clasificacion_Inicial->DbValue = $row['Clasificacion_Inicial'];
		$this->Fecha_Hospitalizacion->DbValue = $row['Fecha_Hospitalizacion'];
		$this->Seguimiento_Clasificacion_Final->DbValue = $row['Seguimiento_Clasificacion_Final'];
		$this->Fecha_Ajuste->DbValue = $row['Fecha_Ajuste'];
		$this->Nombre_Evento->DbValue = $row['Nombre_Evento'];
		$this->Localidad_residencia->DbValue = $row['Localidad_residencia'];
		$this->Barrio_residencia->DbValue = $row['Barrio_residencia'];
		$this->Fecha_ingreso_app->DbValue = $row['Fecha_ingreso_app'];
		$this->Actualizado_por->DbValue = $row['Actualizado_por'];
		$this->Fecha_actualizacion_app->DbValue = $row['Fecha_actualizacion_app'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Consecutivo
		// Seguimiento
		// Condicion_Final
		// Codigo_centro
		// Codigo_UPGD
		// Cod_Evento
		// Embarazo_Actual
		// Fecha_Notificacion
		// Semana
		// Periodo_Epidemiologico
		// Periodo_Sivigila
		// Primer_Nombre
		// Segundo_Nombre
		// Primer_Apellido
		// Segundo_Apellido
		// Tipo_Id
		// Numero_Identificacion
		// Edad
		// Unidad_Edad
		// Sexo
		// Pais_Ocurrencia
		// Depto_Ocurrencia
		// Municipio_Ocurrencia
		// Area_Ocurrencia
		// Localidad
		// Barrio
		// Direccion_Residencia
		// Ocupacion
		// Tipo_Regimen_Salud
		// Cod_Administradora
		// gp_discapa
		// gp_desplaz
		// gp_migrant
		// gp_carcela
		// gp_gestan
		// gp_indigen
		// gp_pobicbf
		// gp_mad_com
		// gp_desmovi
		// gp_psiquia
		// gp_vic_vio
		// gp_otros
		// Depto_Residencia
		// Municipio_Residencia
		// Fecha_Consulta
		// Fecha_Inicio_Sintomas
		// Hospitalizado
		// Fecha_Defuncion
		// Numero_Certificado_Defuncion
		// Causa_Basica_Muerte_CIEX
		// Entidad_fallecimiento
		// Telefono
		// Fecha_Nacimiento
		// Nombre_Profesional_Diligencia
		// Telefono_Profesional_Diligencia
		// Mecanismo_Probable_Transmision
		// Nombre_Madre
		// Tipo_Id_Madre
		// Numero_Identificacion_Madre
		// Indentidad_Genero
		// Donador_Sangre_Ultimos_12_Meses
		// Fecha_Donacion
		// Nombre_Institucion_Donacion
		// Poblacion_clave
		// Recibio_Asesoria_Pre_Prueba
		// Recibio_Asesoria_Post_Prueba
		// Tipo_Prueba
		// Fecha_Resultado_Confirmatorio
		// Valor_Carga_Viral
		// Estado_Clinico_Notificacion
		// Hijos_Mujeres_Menores_5
		// Hijos_Hombres_Menores_5
		// Numero_Semanas_Embarazo
		// Antecedentes_Embarazo
		// Candidiasis_esofagica
		// Candidiasis_vias_aereas
		// Tuberculosis_pulmonar
		// Cancer_cervical
		// Tuberculosis_extrapulmonar
		// Coccidiomicosis
		// Citomegalovirosis
		// Retinitis_citomegalovirosis
		// Sindrome_Emanciacion
		// Encefalopatia
		// Otras_micobacterias
		// Histoplasmosis_Extrapulmonar
		// isosporidiasis_cronica
		// herpes_zoster
		// Histoplasmosis_diseminada
		// Linfoma_Burkitt
		// Neumonia_Pneumocystis
		// Neumonia_Recurrente
		// Linfoma_Inmunoblastico
		// Criptosporidiasis_cronica
		// Criptococosis_Extrapulmonar
		// Sarcoma_Kaposi
		// Leucoencefalopatia_Multifocal
		// Septicemia_recurrente
		// Toxoplasmosis_cerebral
		// HepatitisB
		// HepatitisC
		// Meningitis
		// RecuentoCD4
		// Registrado_Por
		// Centro_Poblado
		// Vereda
		// Pertenencia_Etnica
		// Grupo_Poblacional
		// Clasificacion_Inicial
		// Fecha_Hospitalizacion
		// Seguimiento_Clasificacion_Final
		// Fecha_Ajuste
		// Nombre_Evento
		// Localidad_residencia
		// Barrio_residencia
		// Fecha_ingreso_app
		// Actualizado_por
		// Fecha_actualizacion_app

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Consecutivo
		$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
		$this->Consecutivo->ViewCustomAttributes = "";

		// Seguimiento
		if (strval($this->Seguimiento->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Seguimiento->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Seguimiento, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Seguimiento->ViewValue = $this->Seguimiento->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Seguimiento->ViewValue = $this->Seguimiento->CurrentValue;
			}
		} else {
			$this->Seguimiento->ViewValue = NULL;
		}
		$this->Seguimiento->ViewCustomAttributes = "";

		// Condicion_Final
		if (strval($this->Condicion_Final->CurrentValue) <> "") {
			$sFilterWrk = "`No.Condicion_Final`" . ew_SearchString("=", $this->Condicion_Final->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `No.Condicion_Final`, `Condicion_Final` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `condicion_final`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Condicion_Final, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Condicion_Final->ViewValue = $this->Condicion_Final->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Condicion_Final->ViewValue = $this->Condicion_Final->CurrentValue;
			}
		} else {
			$this->Condicion_Final->ViewValue = NULL;
		}
		$this->Condicion_Final->ViewCustomAttributes = "";

		// Codigo_centro
		if (strval($this->Codigo_centro->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_centro->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Upgd` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Codigo_centro, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Codigo_centro->ViewValue = $this->Codigo_centro->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Codigo_centro->ViewValue = $this->Codigo_centro->CurrentValue;
			}
		} else {
			$this->Codigo_centro->ViewValue = NULL;
		}
		$this->Codigo_centro->ViewCustomAttributes = "";

		// Codigo_UPGD
		$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->CurrentValue;
		if (strval($this->Codigo_UPGD->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Codigo_UPGD->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Codigo_UPGD, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Codigo_UPGD->ViewValue = $this->Codigo_UPGD->CurrentValue;
			}
		} else {
			$this->Codigo_UPGD->ViewValue = NULL;
		}
		$this->Codigo_UPGD->ViewCustomAttributes = "";

		// Cod_Evento
		$this->Cod_Evento->ViewValue = $this->Cod_Evento->CurrentValue;
		$this->Cod_Evento->ViewCustomAttributes = "";

		// Embarazo_Actual
		if (strval($this->Embarazo_Actual->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Embarazo_Actual->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Embarazo_Actual, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Embarazo_Actual->ViewValue = $this->Embarazo_Actual->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Embarazo_Actual->ViewValue = $this->Embarazo_Actual->CurrentValue;
			}
		} else {
			$this->Embarazo_Actual->ViewValue = NULL;
		}
		$this->Embarazo_Actual->ViewCustomAttributes = "";

		// Fecha_Notificacion
		$this->Fecha_Notificacion->ViewValue = $this->Fecha_Notificacion->CurrentValue;
		$this->Fecha_Notificacion->ViewValue = ew_FormatDateTime($this->Fecha_Notificacion->ViewValue, 5);
		$this->Fecha_Notificacion->ViewCustomAttributes = "";

		// Semana
		if (strval($this->Semana->CurrentValue) <> "") {
			$sFilterWrk = "`Semana`" . ew_SearchString("=", $this->Semana->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Semana`, `Semana` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `semana_epidemiologica`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Semana, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Semana->ViewValue = $this->Semana->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Semana->ViewValue = $this->Semana->CurrentValue;
			}
		} else {
			$this->Semana->ViewValue = NULL;
		}
		$this->Semana->ViewCustomAttributes = "";

		// Periodo_Epidemiologico
		if (strval($this->Periodo_Epidemiologico->CurrentValue) <> "") {
			$sFilterWrk = "`Periodo_epidemiologico`" . ew_SearchString("=", $this->Periodo_Epidemiologico->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Periodo_epidemiologico`, `Periodo_epidemiologico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `periodo_epidemiologico`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Periodo_Epidemiologico, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Periodo_Epidemiologico->ViewValue = $this->Periodo_Epidemiologico->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Periodo_Epidemiologico->ViewValue = $this->Periodo_Epidemiologico->CurrentValue;
			}
		} else {
			$this->Periodo_Epidemiologico->ViewValue = NULL;
		}
		$this->Periodo_Epidemiologico->ViewCustomAttributes = "";

		// Periodo_Sivigila
		if (strval($this->Periodo_Sivigila->CurrentValue) <> "") {
			$sFilterWrk = "`Periodo`" . ew_SearchString("=", $this->Periodo_Sivigila->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Periodo`, `Periodo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `periodo`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Periodo_Sivigila, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Periodo_Sivigila->ViewValue = $this->Periodo_Sivigila->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Periodo_Sivigila->ViewValue = $this->Periodo_Sivigila->CurrentValue;
			}
		} else {
			$this->Periodo_Sivigila->ViewValue = NULL;
		}
		$this->Periodo_Sivigila->ViewCustomAttributes = "";

		// Primer_Nombre
		$this->Primer_Nombre->ViewValue = $this->Primer_Nombre->CurrentValue;
		$this->Primer_Nombre->ViewCustomAttributes = "";

		// Segundo_Nombre
		$this->Segundo_Nombre->ViewValue = $this->Segundo_Nombre->CurrentValue;
		$this->Segundo_Nombre->ViewCustomAttributes = "";

		// Primer_Apellido
		$this->Primer_Apellido->ViewValue = $this->Primer_Apellido->CurrentValue;
		$this->Primer_Apellido->ViewCustomAttributes = "";

		// Segundo_Apellido
		$this->Segundo_Apellido->ViewValue = $this->Segundo_Apellido->CurrentValue;
		$this->Segundo_Apellido->ViewCustomAttributes = "";

		// Tipo_Id
		if (strval($this->Tipo_Id->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Documento`" . ew_SearchString("=", $this->Tipo_Id->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Cod_Documento`, `Tipo_Ide` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Id, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Id->ViewValue = $this->Tipo_Id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Id->ViewValue = $this->Tipo_Id->CurrentValue;
			}
		} else {
			$this->Tipo_Id->ViewValue = NULL;
		}
		$this->Tipo_Id->ViewCustomAttributes = "";

		// Numero_Identificacion
		$this->Numero_Identificacion->ViewValue = $this->Numero_Identificacion->CurrentValue;
		$this->Numero_Identificacion->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Unidad_Edad
		if (strval($this->Unidad_Edad->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Unidad_Edad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Unidad_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `unidad_medida_edad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Unidad_Edad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Unidad_Edad->ViewValue = $this->Unidad_Edad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Unidad_Edad->ViewValue = $this->Unidad_Edad->CurrentValue;
			}
		} else {
			$this->Unidad_Edad->ViewValue = NULL;
		}
		$this->Unidad_Edad->ViewCustomAttributes = "";

		// Sexo
		if (strval($this->Sexo->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Sexo`" . ew_SearchString("=", $this->Sexo->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Sexo`, `Sexo` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sexo`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sexo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sexo->ViewValue = $this->Sexo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
			}
		} else {
			$this->Sexo->ViewValue = NULL;
		}
		$this->Sexo->ViewCustomAttributes = "";

		// Pais_Ocurrencia
		if (strval($this->Pais_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Pais`" . ew_SearchString("=", $this->Pais_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Pais`, `Pais` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `pais`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Pais_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Pais_Ocurrencia->ViewValue = $this->Pais_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Pais_Ocurrencia->ViewValue = $this->Pais_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Pais_Ocurrencia->ViewValue = NULL;
		}
		$this->Pais_Ocurrencia->ViewCustomAttributes = "";

		// Depto_Ocurrencia
		if (strval($this->Depto_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Departamento`" . ew_SearchString("=", $this->Depto_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Departamento`, `Departamento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `departamento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Depto_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Depto_Ocurrencia->ViewValue = $this->Depto_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Depto_Ocurrencia->ViewValue = $this->Depto_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Depto_Ocurrencia->ViewValue = NULL;
		}
		$this->Depto_Ocurrencia->ViewCustomAttributes = "";

		// Municipio_Ocurrencia
		if (strval($this->Municipio_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Municipio`" . ew_SearchString("=", $this->Municipio_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Municipio`, `Municipio` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `municipio`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Municipio_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Municipio_Ocurrencia->ViewValue = $this->Municipio_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Municipio_Ocurrencia->ViewValue = $this->Municipio_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Municipio_Ocurrencia->ViewValue = NULL;
		}
		$this->Municipio_Ocurrencia->ViewCustomAttributes = "";

		// Area_Ocurrencia
		if (strval($this->Area_Ocurrencia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Area_Ocurrencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Area_Ocurrencia` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `area_ocurrencia`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Area_Ocurrencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Area_Ocurrencia->ViewValue = $this->Area_Ocurrencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Area_Ocurrencia->ViewValue = $this->Area_Ocurrencia->CurrentValue;
			}
		} else {
			$this->Area_Ocurrencia->ViewValue = NULL;
		}
		$this->Area_Ocurrencia->ViewCustomAttributes = "";

		// Localidad
		if (strval($this->Localidad->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Localidad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `localidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Localidad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Localidad->ViewValue = $this->Localidad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Localidad->ViewValue = $this->Localidad->CurrentValue;
			}
		} else {
			$this->Localidad->ViewValue = NULL;
		}
		$this->Localidad->ViewCustomAttributes = "";

		// Barrio
		if (strval($this->Barrio->CurrentValue) <> "") {
			$sFilterWrk = "`cod_barrio_vereda`" . ew_SearchString("=", $this->Barrio->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `cod_barrio_vereda`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrios_veredas`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Barrio, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Barrio->ViewValue = $this->Barrio->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Barrio->ViewValue = $this->Barrio->CurrentValue;
			}
		} else {
			$this->Barrio->ViewValue = NULL;
		}
		$this->Barrio->ViewCustomAttributes = "";

		// Direccion_Residencia
		$this->Direccion_Residencia->ViewValue = $this->Direccion_Residencia->CurrentValue;
		$this->Direccion_Residencia->ViewCustomAttributes = "";

		// Ocupacion
		if (strval($this->Ocupacion->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Ocupacion`" . ew_SearchString("=", $this->Ocupacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Ocupacion`, `Cod_Ocupacion` AS `DispFld`, `Ocupacion` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `ocupacion`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Ocupacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Ocupacion->ViewValue = $this->Ocupacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Ocupacion->ViewValue = $this->Ocupacion->CurrentValue;
			}
		} else {
			$this->Ocupacion->ViewValue = NULL;
		}
		$this->Ocupacion->ViewCustomAttributes = "";

		// Tipo_Regimen_Salud
		if (strval($this->Tipo_Regimen_Salud->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Regimen`" . ew_SearchString("=", $this->Tipo_Regimen_Salud->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Regimen`, `Codigo_Regimen` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_regimen_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Regimen_Salud, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->CurrentValue;
			}
		} else {
			$this->Tipo_Regimen_Salud->ViewValue = NULL;
		}
		$this->Tipo_Regimen_Salud->ViewCustomAttributes = "";

		// Cod_Administradora
		if (strval($this->Cod_Administradora->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->Cod_Administradora->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo`, `Codigo` AS `DispFld`, `Administradora_Salud` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Cod_Administradora, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Cod_Administradora->ViewValue = $this->Cod_Administradora->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Cod_Administradora->ViewValue = $this->Cod_Administradora->CurrentValue;
			}
		} else {
			$this->Cod_Administradora->ViewValue = NULL;
		}
		$this->Cod_Administradora->ViewCustomAttributes = "";

		// gp_discapa
		if (strval($this->gp_discapa->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_discapa->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_discapa, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_discapa->ViewValue = $this->gp_discapa->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_discapa->ViewValue = $this->gp_discapa->CurrentValue;
			}
		} else {
			$this->gp_discapa->ViewValue = NULL;
		}
		$this->gp_discapa->ViewCustomAttributes = "";

		// gp_desplaz
		if (strval($this->gp_desplaz->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_desplaz->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_desplaz, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_desplaz->ViewValue = $this->gp_desplaz->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_desplaz->ViewValue = $this->gp_desplaz->CurrentValue;
			}
		} else {
			$this->gp_desplaz->ViewValue = NULL;
		}
		$this->gp_desplaz->ViewCustomAttributes = "";

		// gp_migrant
		if (strval($this->gp_migrant->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_migrant->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_migrant, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_migrant->ViewValue = $this->gp_migrant->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_migrant->ViewValue = $this->gp_migrant->CurrentValue;
			}
		} else {
			$this->gp_migrant->ViewValue = NULL;
		}
		$this->gp_migrant->ViewCustomAttributes = "";

		// gp_carcela
		if (strval($this->gp_carcela->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_carcela->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_carcela, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_carcela->ViewValue = $this->gp_carcela->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_carcela->ViewValue = $this->gp_carcela->CurrentValue;
			}
		} else {
			$this->gp_carcela->ViewValue = NULL;
		}
		$this->gp_carcela->ViewCustomAttributes = "";

		// gp_gestan
		if (strval($this->gp_gestan->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_gestan->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_gestan, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_gestan->ViewValue = $this->gp_gestan->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_gestan->ViewValue = $this->gp_gestan->CurrentValue;
			}
		} else {
			$this->gp_gestan->ViewValue = NULL;
		}
		$this->gp_gestan->ViewCustomAttributes = "";

		// gp_indigen
		if (strval($this->gp_indigen->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_indigen->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_indigen, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_indigen->ViewValue = $this->gp_indigen->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_indigen->ViewValue = $this->gp_indigen->CurrentValue;
			}
		} else {
			$this->gp_indigen->ViewValue = NULL;
		}
		$this->gp_indigen->ViewCustomAttributes = "";

		// gp_pobicbf
		if (strval($this->gp_pobicbf->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_pobicbf->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_pobicbf, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_pobicbf->ViewValue = $this->gp_pobicbf->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_pobicbf->ViewValue = $this->gp_pobicbf->CurrentValue;
			}
		} else {
			$this->gp_pobicbf->ViewValue = NULL;
		}
		$this->gp_pobicbf->ViewCustomAttributes = "";

		// gp_mad_com
		if (strval($this->gp_mad_com->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_mad_com->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_mad_com, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_mad_com->ViewValue = $this->gp_mad_com->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_mad_com->ViewValue = $this->gp_mad_com->CurrentValue;
			}
		} else {
			$this->gp_mad_com->ViewValue = NULL;
		}
		$this->gp_mad_com->ViewCustomAttributes = "";

		// gp_desmovi
		if (strval($this->gp_desmovi->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_desmovi->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_desmovi, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_desmovi->ViewValue = $this->gp_desmovi->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_desmovi->ViewValue = $this->gp_desmovi->CurrentValue;
			}
		} else {
			$this->gp_desmovi->ViewValue = NULL;
		}
		$this->gp_desmovi->ViewCustomAttributes = "";

		// gp_psiquia
		if (strval($this->gp_psiquia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_psiquia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_psiquia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_psiquia->ViewValue = $this->gp_psiquia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_psiquia->ViewValue = $this->gp_psiquia->CurrentValue;
			}
		} else {
			$this->gp_psiquia->ViewValue = NULL;
		}
		$this->gp_psiquia->ViewCustomAttributes = "";

		// gp_vic_vio
		if (strval($this->gp_vic_vio->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_vic_vio->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_vic_vio, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_vic_vio->ViewValue = $this->gp_vic_vio->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_vic_vio->ViewValue = $this->gp_vic_vio->CurrentValue;
			}
		} else {
			$this->gp_vic_vio->ViewValue = NULL;
		}
		$this->gp_vic_vio->ViewCustomAttributes = "";

		// gp_otros
		if (strval($this->gp_otros->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->gp_otros->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->gp_otros, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->gp_otros->ViewValue = $this->gp_otros->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->gp_otros->ViewValue = $this->gp_otros->CurrentValue;
			}
		} else {
			$this->gp_otros->ViewValue = NULL;
		}
		$this->gp_otros->ViewCustomAttributes = "";

		// Depto_Residencia
		if (strval($this->Depto_Residencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Departamento`" . ew_SearchString("=", $this->Depto_Residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Departamento`, `Departamento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `departamento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Depto_Residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Depto_Residencia->ViewValue = $this->Depto_Residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Depto_Residencia->ViewValue = $this->Depto_Residencia->CurrentValue;
			}
		} else {
			$this->Depto_Residencia->ViewValue = NULL;
		}
		$this->Depto_Residencia->ViewCustomAttributes = "";

		// Municipio_Residencia
		if (strval($this->Municipio_Residencia->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Municipio`" . ew_SearchString("=", $this->Municipio_Residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Cod_Municipio`, `Municipio` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `municipio`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Municipio_Residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Municipio_Residencia->ViewValue = $this->Municipio_Residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Municipio_Residencia->ViewValue = $this->Municipio_Residencia->CurrentValue;
			}
		} else {
			$this->Municipio_Residencia->ViewValue = NULL;
		}
		$this->Municipio_Residencia->ViewCustomAttributes = "";

		// Fecha_Consulta
		$this->Fecha_Consulta->ViewValue = $this->Fecha_Consulta->CurrentValue;
		$this->Fecha_Consulta->ViewValue = ew_FormatDateTime($this->Fecha_Consulta->ViewValue, 5);
		$this->Fecha_Consulta->ViewCustomAttributes = "";

		// Fecha_Inicio_Sintomas
		$this->Fecha_Inicio_Sintomas->ViewValue = $this->Fecha_Inicio_Sintomas->CurrentValue;
		$this->Fecha_Inicio_Sintomas->ViewValue = ew_FormatDateTime($this->Fecha_Inicio_Sintomas->ViewValue, 5);
		$this->Fecha_Inicio_Sintomas->ViewCustomAttributes = "";

		// Hospitalizado
		if (strval($this->Hospitalizado->CurrentValue) <> "") {
			$arwrk = explode(",", $this->Hospitalizado->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`Consecutivo`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Hospitalizado, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Hospitalizado->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->Hospitalizado->ViewValue .= $this->Hospitalizado->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->Hospitalizado->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->Hospitalizado->ViewValue = $this->Hospitalizado->CurrentValue;
			}
		} else {
			$this->Hospitalizado->ViewValue = NULL;
		}
		$this->Hospitalizado->ViewCustomAttributes = "";

		// Fecha_Defuncion
		$this->Fecha_Defuncion->ViewValue = $this->Fecha_Defuncion->CurrentValue;
		$this->Fecha_Defuncion->ViewValue = ew_FormatDateTime($this->Fecha_Defuncion->ViewValue, 5);
		$this->Fecha_Defuncion->ViewCustomAttributes = "";

		// Numero_Certificado_Defuncion
		$this->Numero_Certificado_Defuncion->ViewValue = $this->Numero_Certificado_Defuncion->CurrentValue;
		$this->Numero_Certificado_Defuncion->ViewCustomAttributes = "";

		// Causa_Basica_Muerte_CIEX
		$this->Causa_Basica_Muerte_CIEX->ViewValue = $this->Causa_Basica_Muerte_CIEX->CurrentValue;
		$this->Causa_Basica_Muerte_CIEX->ViewCustomAttributes = "";

		// Entidad_fallecimiento
		$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->CurrentValue;
		if (strval($this->Entidad_fallecimiento->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_Upgd`" . ew_SearchString("=", $this->Entidad_fallecimiento->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_Upgd`, `Codigo_Upgd` AS `DispFld`, `Upgd` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad_fallecimiento, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad_fallecimiento->ViewValue = $this->Entidad_fallecimiento->CurrentValue;
			}
		} else {
			$this->Entidad_fallecimiento->ViewValue = NULL;
		}
		$this->Entidad_fallecimiento->ViewCustomAttributes = "";

		// Telefono
		$this->Telefono->ViewValue = $this->Telefono->CurrentValue;
		$this->Telefono->ViewCustomAttributes = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
		$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 5);
		$this->Fecha_Nacimiento->ViewCustomAttributes = "";

		// Nombre_Profesional_Diligencia
		$this->Nombre_Profesional_Diligencia->ViewValue = $this->Nombre_Profesional_Diligencia->CurrentValue;
		$this->Nombre_Profesional_Diligencia->ViewCustomAttributes = "";

		// Telefono_Profesional_Diligencia
		$this->Telefono_Profesional_Diligencia->ViewValue = $this->Telefono_Profesional_Diligencia->CurrentValue;
		$this->Telefono_Profesional_Diligencia->ViewCustomAttributes = "";

		// Mecanismo_Probable_Transmision
		if (strval($this->Mecanismo_Probable_Transmision->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Mecanismo_Probable_Transmision->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Mecanismo_Probable` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `mecanismo_probable_transmision`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Mecanismo_Probable_Transmision, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Mecanismo_Probable_Transmision->ViewValue = $this->Mecanismo_Probable_Transmision->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Mecanismo_Probable_Transmision->ViewValue = $this->Mecanismo_Probable_Transmision->CurrentValue;
			}
		} else {
			$this->Mecanismo_Probable_Transmision->ViewValue = NULL;
		}
		$this->Mecanismo_Probable_Transmision->ViewCustomAttributes = "";

		// Nombre_Madre
		$this->Nombre_Madre->ViewValue = $this->Nombre_Madre->CurrentValue;
		$this->Nombre_Madre->ViewCustomAttributes = "";

		// Tipo_Id_Madre
		if (strval($this->Tipo_Id_Madre->CurrentValue) <> "") {
			$sFilterWrk = "`Cod_Documento`" . ew_SearchString("=", $this->Tipo_Id_Madre->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Cod_Documento`, `Tipo_Ide` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Id_Madre, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Id_Madre->ViewValue = $this->Tipo_Id_Madre->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Id_Madre->ViewValue = $this->Tipo_Id_Madre->CurrentValue;
			}
		} else {
			$this->Tipo_Id_Madre->ViewValue = NULL;
		}
		$this->Tipo_Id_Madre->ViewCustomAttributes = "";

		// Numero_Identificacion_Madre
		$this->Numero_Identificacion_Madre->ViewValue = $this->Numero_Identificacion_Madre->CurrentValue;
		$this->Numero_Identificacion_Madre->ViewCustomAttributes = "";

		// Indentidad_Genero
		if (strval($this->Indentidad_Genero->CurrentValue) <> "") {
			$sFilterWrk = "`Codigo_identidad`" . ew_SearchString("=", $this->Indentidad_Genero->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Codigo_identidad`, `Identidad_genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `identidad_genero`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Indentidad_Genero, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Indentidad_Genero->ViewValue = $this->Indentidad_Genero->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Indentidad_Genero->ViewValue = $this->Indentidad_Genero->CurrentValue;
			}
		} else {
			$this->Indentidad_Genero->ViewValue = NULL;
		}
		$this->Indentidad_Genero->ViewCustomAttributes = "";

		// Donador_Sangre_Ultimos_12_Meses
		if (strval($this->Donador_Sangre_Ultimos_12_Meses->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Donador_Sangre_Ultimos_12_Meses, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = $this->Donador_Sangre_Ultimos_12_Meses->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = $this->Donador_Sangre_Ultimos_12_Meses->CurrentValue;
			}
		} else {
			$this->Donador_Sangre_Ultimos_12_Meses->ViewValue = NULL;
		}
		$this->Donador_Sangre_Ultimos_12_Meses->ViewCustomAttributes = "";

		// Fecha_Donacion
		$this->Fecha_Donacion->ViewValue = $this->Fecha_Donacion->CurrentValue;
		$this->Fecha_Donacion->ViewValue = ew_FormatDateTime($this->Fecha_Donacion->ViewValue, 5);
		$this->Fecha_Donacion->ViewCustomAttributes = "";

		// Nombre_Institucion_Donacion
		$this->Nombre_Institucion_Donacion->ViewValue = $this->Nombre_Institucion_Donacion->CurrentValue;
		$this->Nombre_Institucion_Donacion->ViewCustomAttributes = "";

		// Poblacion_clave
		if (strval($this->Poblacion_clave->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Poblacion_clave->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Poblacion_clave` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `poblacion_clave`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Poblacion_clave, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Poblacion_clave->ViewValue = $this->Poblacion_clave->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Poblacion_clave->ViewValue = $this->Poblacion_clave->CurrentValue;
			}
		} else {
			$this->Poblacion_clave->ViewValue = NULL;
		}
		$this->Poblacion_clave->ViewCustomAttributes = "";

		// Recibio_Asesoria_Pre_Prueba
		if (strval($this->Recibio_Asesoria_Pre_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Recibio_Asesoria_Pre_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Recibio_Asesoria_Pre_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Recibio_Asesoria_Pre_Prueba->ViewValue = $this->Recibio_Asesoria_Pre_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Recibio_Asesoria_Pre_Prueba->ViewValue = $this->Recibio_Asesoria_Pre_Prueba->CurrentValue;
			}
		} else {
			$this->Recibio_Asesoria_Pre_Prueba->ViewValue = NULL;
		}
		$this->Recibio_Asesoria_Pre_Prueba->ViewCustomAttributes = "";

		// Recibio_Asesoria_Post_Prueba
		if (strval($this->Recibio_Asesoria_Post_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Recibio_Asesoria_Post_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Recibio_Asesoria_Post_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Recibio_Asesoria_Post_Prueba->ViewValue = $this->Recibio_Asesoria_Post_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Recibio_Asesoria_Post_Prueba->ViewValue = $this->Recibio_Asesoria_Post_Prueba->CurrentValue;
			}
		} else {
			$this->Recibio_Asesoria_Post_Prueba->ViewValue = NULL;
		}
		$this->Recibio_Asesoria_Post_Prueba->ViewCustomAttributes = "";

		// Tipo_Prueba
		if (strval($this->Tipo_Prueba->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tipo_Prueba->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Tipo_Prueba` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_prueba`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_Prueba, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_Prueba->ViewValue = $this->Tipo_Prueba->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_Prueba->ViewValue = $this->Tipo_Prueba->CurrentValue;
			}
		} else {
			$this->Tipo_Prueba->ViewValue = NULL;
		}
		$this->Tipo_Prueba->ViewCustomAttributes = "";

		// Fecha_Resultado_Confirmatorio
		$this->Fecha_Resultado_Confirmatorio->ViewValue = $this->Fecha_Resultado_Confirmatorio->CurrentValue;
		$this->Fecha_Resultado_Confirmatorio->ViewValue = ew_FormatDateTime($this->Fecha_Resultado_Confirmatorio->ViewValue, 5);
		$this->Fecha_Resultado_Confirmatorio->ViewCustomAttributes = "";

		// Valor_Carga_Viral
		$this->Valor_Carga_Viral->ViewValue = $this->Valor_Carga_Viral->CurrentValue;
		$this->Valor_Carga_Viral->ViewCustomAttributes = "";

		// Estado_Clinico_Notificacion
		if (strval($this->Estado_Clinico_Notificacion->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Estado_Clinico_Notificacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Estado_Clinico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `estado_clinico_paciente`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Estado_Clinico_Notificacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Estado_Clinico_Notificacion->ViewValue = $this->Estado_Clinico_Notificacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Estado_Clinico_Notificacion->ViewValue = $this->Estado_Clinico_Notificacion->CurrentValue;
			}
		} else {
			$this->Estado_Clinico_Notificacion->ViewValue = NULL;
		}
		$this->Estado_Clinico_Notificacion->ViewCustomAttributes = "";

		// Hijos_Mujeres_Menores_5
		$this->Hijos_Mujeres_Menores_5->ViewValue = $this->Hijos_Mujeres_Menores_5->CurrentValue;
		$this->Hijos_Mujeres_Menores_5->ViewCustomAttributes = "";

		// Hijos_Hombres_Menores_5
		$this->Hijos_Hombres_Menores_5->ViewValue = $this->Hijos_Hombres_Menores_5->CurrentValue;
		$this->Hijos_Hombres_Menores_5->ViewCustomAttributes = "";

		// Numero_Semanas_Embarazo
		$this->Numero_Semanas_Embarazo->ViewValue = $this->Numero_Semanas_Embarazo->CurrentValue;
		$this->Numero_Semanas_Embarazo->ViewCustomAttributes = "";

		// Antecedentes_Embarazo
		if (strval($this->Antecedentes_Embarazo->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Antecedentes_Embarazo->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Antecedentes_Embarazo, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Antecedentes_Embarazo->ViewValue = $this->Antecedentes_Embarazo->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Antecedentes_Embarazo->ViewValue = $this->Antecedentes_Embarazo->CurrentValue;
			}
		} else {
			$this->Antecedentes_Embarazo->ViewValue = NULL;
		}
		$this->Antecedentes_Embarazo->ViewCustomAttributes = "";

		// Candidiasis_esofagica
		if (strval($this->Candidiasis_esofagica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Candidiasis_esofagica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Candidiasis_esofagica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Candidiasis_esofagica->ViewValue = $this->Candidiasis_esofagica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Candidiasis_esofagica->ViewValue = $this->Candidiasis_esofagica->CurrentValue;
			}
		} else {
			$this->Candidiasis_esofagica->ViewValue = NULL;
		}
		$this->Candidiasis_esofagica->ViewCustomAttributes = "";

		// Candidiasis_vias_aereas
		if (strval($this->Candidiasis_vias_aereas->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Candidiasis_vias_aereas->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Candidiasis_vias_aereas, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Candidiasis_vias_aereas->ViewValue = $this->Candidiasis_vias_aereas->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Candidiasis_vias_aereas->ViewValue = $this->Candidiasis_vias_aereas->CurrentValue;
			}
		} else {
			$this->Candidiasis_vias_aereas->ViewValue = NULL;
		}
		$this->Candidiasis_vias_aereas->ViewCustomAttributes = "";

		// Tuberculosis_pulmonar
		if (strval($this->Tuberculosis_pulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tuberculosis_pulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tuberculosis_pulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tuberculosis_pulmonar->ViewValue = $this->Tuberculosis_pulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tuberculosis_pulmonar->ViewValue = $this->Tuberculosis_pulmonar->CurrentValue;
			}
		} else {
			$this->Tuberculosis_pulmonar->ViewValue = NULL;
		}
		$this->Tuberculosis_pulmonar->ViewCustomAttributes = "";

		// Cancer_cervical
		if (strval($this->Cancer_cervical->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Cancer_cervical->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Cancer_cervical, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Cancer_cervical->ViewValue = $this->Cancer_cervical->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Cancer_cervical->ViewValue = $this->Cancer_cervical->CurrentValue;
			}
		} else {
			$this->Cancer_cervical->ViewValue = NULL;
		}
		$this->Cancer_cervical->ViewCustomAttributes = "";

		// Tuberculosis_extrapulmonar
		if (strval($this->Tuberculosis_extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Tuberculosis_extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tuberculosis_extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tuberculosis_extrapulmonar->ViewValue = $this->Tuberculosis_extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tuberculosis_extrapulmonar->ViewValue = $this->Tuberculosis_extrapulmonar->CurrentValue;
			}
		} else {
			$this->Tuberculosis_extrapulmonar->ViewValue = NULL;
		}
		$this->Tuberculosis_extrapulmonar->ViewCustomAttributes = "";

		// Coccidiomicosis
		if (strval($this->Coccidiomicosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Coccidiomicosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Coccidiomicosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Coccidiomicosis->ViewValue = $this->Coccidiomicosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Coccidiomicosis->ViewValue = $this->Coccidiomicosis->CurrentValue;
			}
		} else {
			$this->Coccidiomicosis->ViewValue = NULL;
		}
		$this->Coccidiomicosis->ViewCustomAttributes = "";

		// Citomegalovirosis
		if (strval($this->Citomegalovirosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Citomegalovirosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Citomegalovirosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Citomegalovirosis->ViewValue = $this->Citomegalovirosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Citomegalovirosis->ViewValue = $this->Citomegalovirosis->CurrentValue;
			}
		} else {
			$this->Citomegalovirosis->ViewValue = NULL;
		}
		$this->Citomegalovirosis->ViewCustomAttributes = "";

		// Retinitis_citomegalovirosis
		if (strval($this->Retinitis_citomegalovirosis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Retinitis_citomegalovirosis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Retinitis_citomegalovirosis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Retinitis_citomegalovirosis->ViewValue = $this->Retinitis_citomegalovirosis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Retinitis_citomegalovirosis->ViewValue = $this->Retinitis_citomegalovirosis->CurrentValue;
			}
		} else {
			$this->Retinitis_citomegalovirosis->ViewValue = NULL;
		}
		$this->Retinitis_citomegalovirosis->ViewCustomAttributes = "";

		// Sindrome_Emanciacion
		if (strval($this->Sindrome_Emanciacion->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Sindrome_Emanciacion->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sindrome_Emanciacion, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sindrome_Emanciacion->ViewValue = $this->Sindrome_Emanciacion->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sindrome_Emanciacion->ViewValue = $this->Sindrome_Emanciacion->CurrentValue;
			}
		} else {
			$this->Sindrome_Emanciacion->ViewValue = NULL;
		}
		$this->Sindrome_Emanciacion->ViewCustomAttributes = "";

		// Encefalopatia
		if (strval($this->Encefalopatia->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Encefalopatia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Encefalopatia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Encefalopatia->ViewValue = $this->Encefalopatia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Encefalopatia->ViewValue = $this->Encefalopatia->CurrentValue;
			}
		} else {
			$this->Encefalopatia->ViewValue = NULL;
		}
		$this->Encefalopatia->ViewCustomAttributes = "";

		// Otras_micobacterias
		if (strval($this->Otras_micobacterias->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Otras_micobacterias->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Otras_micobacterias, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Otras_micobacterias->ViewValue = $this->Otras_micobacterias->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Otras_micobacterias->ViewValue = $this->Otras_micobacterias->CurrentValue;
			}
		} else {
			$this->Otras_micobacterias->ViewValue = NULL;
		}
		$this->Otras_micobacterias->ViewCustomAttributes = "";

		// Histoplasmosis_Extrapulmonar
		if (strval($this->Histoplasmosis_Extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Histoplasmosis_Extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Histoplasmosis_Extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Histoplasmosis_Extrapulmonar->ViewValue = $this->Histoplasmosis_Extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Histoplasmosis_Extrapulmonar->ViewValue = $this->Histoplasmosis_Extrapulmonar->CurrentValue;
			}
		} else {
			$this->Histoplasmosis_Extrapulmonar->ViewValue = NULL;
		}
		$this->Histoplasmosis_Extrapulmonar->ViewCustomAttributes = "";

		// isosporidiasis_cronica
		if (strval($this->isosporidiasis_cronica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->isosporidiasis_cronica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->isosporidiasis_cronica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->isosporidiasis_cronica->ViewValue = $this->isosporidiasis_cronica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->isosporidiasis_cronica->ViewValue = $this->isosporidiasis_cronica->CurrentValue;
			}
		} else {
			$this->isosporidiasis_cronica->ViewValue = NULL;
		}
		$this->isosporidiasis_cronica->ViewCustomAttributes = "";

		// herpes_zoster
		if (strval($this->herpes_zoster->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->herpes_zoster->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->herpes_zoster, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->herpes_zoster->ViewValue = $this->herpes_zoster->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->herpes_zoster->ViewValue = $this->herpes_zoster->CurrentValue;
			}
		} else {
			$this->herpes_zoster->ViewValue = NULL;
		}
		$this->herpes_zoster->ViewCustomAttributes = "";

		// Histoplasmosis_diseminada
		if (strval($this->Histoplasmosis_diseminada->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Histoplasmosis_diseminada->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Histoplasmosis_diseminada, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Histoplasmosis_diseminada->ViewValue = $this->Histoplasmosis_diseminada->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Histoplasmosis_diseminada->ViewValue = $this->Histoplasmosis_diseminada->CurrentValue;
			}
		} else {
			$this->Histoplasmosis_diseminada->ViewValue = NULL;
		}
		$this->Histoplasmosis_diseminada->ViewCustomAttributes = "";

		// Linfoma_Burkitt
		if (strval($this->Linfoma_Burkitt->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Linfoma_Burkitt->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Linfoma_Burkitt, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Linfoma_Burkitt->ViewValue = $this->Linfoma_Burkitt->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Linfoma_Burkitt->ViewValue = $this->Linfoma_Burkitt->CurrentValue;
			}
		} else {
			$this->Linfoma_Burkitt->ViewValue = NULL;
		}
		$this->Linfoma_Burkitt->ViewCustomAttributes = "";

		// Neumonia_Pneumocystis
		if (strval($this->Neumonia_Pneumocystis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Neumonia_Pneumocystis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Neumonia_Pneumocystis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Neumonia_Pneumocystis->ViewValue = $this->Neumonia_Pneumocystis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Neumonia_Pneumocystis->ViewValue = $this->Neumonia_Pneumocystis->CurrentValue;
			}
		} else {
			$this->Neumonia_Pneumocystis->ViewValue = NULL;
		}
		$this->Neumonia_Pneumocystis->ViewCustomAttributes = "";

		// Neumonia_Recurrente
		if (strval($this->Neumonia_Recurrente->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Neumonia_Recurrente->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Neumonia_Recurrente, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Neumonia_Recurrente->ViewValue = $this->Neumonia_Recurrente->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Neumonia_Recurrente->ViewValue = $this->Neumonia_Recurrente->CurrentValue;
			}
		} else {
			$this->Neumonia_Recurrente->ViewValue = NULL;
		}
		$this->Neumonia_Recurrente->ViewCustomAttributes = "";

		// Linfoma_Inmunoblastico
		if (strval($this->Linfoma_Inmunoblastico->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Linfoma_Inmunoblastico->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Linfoma_Inmunoblastico, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Linfoma_Inmunoblastico->ViewValue = $this->Linfoma_Inmunoblastico->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Linfoma_Inmunoblastico->ViewValue = $this->Linfoma_Inmunoblastico->CurrentValue;
			}
		} else {
			$this->Linfoma_Inmunoblastico->ViewValue = NULL;
		}
		$this->Linfoma_Inmunoblastico->ViewCustomAttributes = "";

		// Criptosporidiasis_cronica
		if (strval($this->Criptosporidiasis_cronica->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Criptosporidiasis_cronica->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Criptosporidiasis_cronica, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Criptosporidiasis_cronica->ViewValue = $this->Criptosporidiasis_cronica->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Criptosporidiasis_cronica->ViewValue = $this->Criptosporidiasis_cronica->CurrentValue;
			}
		} else {
			$this->Criptosporidiasis_cronica->ViewValue = NULL;
		}
		$this->Criptosporidiasis_cronica->ViewCustomAttributes = "";

		// Criptococosis_Extrapulmonar
		if (strval($this->Criptococosis_Extrapulmonar->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Criptococosis_Extrapulmonar->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Criptococosis_Extrapulmonar, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Criptococosis_Extrapulmonar->ViewValue = $this->Criptococosis_Extrapulmonar->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Criptococosis_Extrapulmonar->ViewValue = $this->Criptococosis_Extrapulmonar->CurrentValue;
			}
		} else {
			$this->Criptococosis_Extrapulmonar->ViewValue = NULL;
		}
		$this->Criptococosis_Extrapulmonar->ViewCustomAttributes = "";

		// Sarcoma_Kaposi
		if (strval($this->Sarcoma_Kaposi->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Sarcoma_Kaposi->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Sarcoma_Kaposi, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Sarcoma_Kaposi->ViewValue = $this->Sarcoma_Kaposi->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Sarcoma_Kaposi->ViewValue = $this->Sarcoma_Kaposi->CurrentValue;
			}
		} else {
			$this->Sarcoma_Kaposi->ViewValue = NULL;
		}
		$this->Sarcoma_Kaposi->ViewCustomAttributes = "";

		// Leucoencefalopatia_Multifocal
		if (strval($this->Leucoencefalopatia_Multifocal->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Leucoencefalopatia_Multifocal->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Leucoencefalopatia_Multifocal, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Leucoencefalopatia_Multifocal->ViewValue = $this->Leucoencefalopatia_Multifocal->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Leucoencefalopatia_Multifocal->ViewValue = $this->Leucoencefalopatia_Multifocal->CurrentValue;
			}
		} else {
			$this->Leucoencefalopatia_Multifocal->ViewValue = NULL;
		}
		$this->Leucoencefalopatia_Multifocal->ViewCustomAttributes = "";

		// Septicemia_recurrente
		if (strval($this->Septicemia_recurrente->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Septicemia_recurrente->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Septicemia_recurrente, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Septicemia_recurrente->ViewValue = $this->Septicemia_recurrente->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Septicemia_recurrente->ViewValue = $this->Septicemia_recurrente->CurrentValue;
			}
		} else {
			$this->Septicemia_recurrente->ViewValue = NULL;
		}
		$this->Septicemia_recurrente->ViewCustomAttributes = "";

		// Toxoplasmosis_cerebral
		if (strval($this->Toxoplasmosis_cerebral->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Toxoplasmosis_cerebral->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Toxoplasmosis_cerebral, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Toxoplasmosis_cerebral->ViewValue = $this->Toxoplasmosis_cerebral->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Toxoplasmosis_cerebral->ViewValue = $this->Toxoplasmosis_cerebral->CurrentValue;
			}
		} else {
			$this->Toxoplasmosis_cerebral->ViewValue = NULL;
		}
		$this->Toxoplasmosis_cerebral->ViewCustomAttributes = "";

		// HepatitisB
		if (strval($this->HepatitisB->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->HepatitisB->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->HepatitisB, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->HepatitisB->ViewValue = $this->HepatitisB->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->HepatitisB->ViewValue = $this->HepatitisB->CurrentValue;
			}
		} else {
			$this->HepatitisB->ViewValue = NULL;
		}
		$this->HepatitisB->ViewCustomAttributes = "";

		// HepatitisC
		if (strval($this->HepatitisC->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->HepatitisC->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->HepatitisC, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->HepatitisC->ViewValue = $this->HepatitisC->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->HepatitisC->ViewValue = $this->HepatitisC->CurrentValue;
			}
		} else {
			$this->HepatitisC->ViewValue = NULL;
		}
		$this->HepatitisC->ViewCustomAttributes = "";

		// Meningitis
		if (strval($this->Meningitis->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Meningitis->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Meningitis, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Meningitis->ViewValue = $this->Meningitis->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Meningitis->ViewValue = $this->Meningitis->CurrentValue;
			}
		} else {
			$this->Meningitis->ViewValue = NULL;
		}
		$this->Meningitis->ViewCustomAttributes = "";

		// RecuentoCD4
		if (strval($this->RecuentoCD4->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->RecuentoCD4->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Consecutivo`, `Si_No` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `si_no`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->RecuentoCD4, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->RecuentoCD4->ViewValue = $this->RecuentoCD4->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->RecuentoCD4->ViewValue = $this->RecuentoCD4->CurrentValue;
			}
		} else {
			$this->RecuentoCD4->ViewValue = NULL;
		}
		$this->RecuentoCD4->ViewCustomAttributes = "";

		// Registrado_Por
		$this->Registrado_Por->ViewValue = $this->Registrado_Por->CurrentValue;
		$this->Registrado_Por->ViewCustomAttributes = "";

		// Localidad_residencia
		if (strval($this->Localidad_residencia->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Localidad_residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `localidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Localidad_residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Localidad_residencia->ViewValue = $this->Localidad_residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Localidad_residencia->ViewValue = $this->Localidad_residencia->CurrentValue;
			}
		} else {
			$this->Localidad_residencia->ViewValue = NULL;
		}
		$this->Localidad_residencia->ViewCustomAttributes = "";

		// Barrio_residencia
		if (strval($this->Barrio_residencia->CurrentValue) <> "") {
			$sFilterWrk = "`cod_barrio_vereda`" . ew_SearchString("=", $this->Barrio_residencia->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `cod_barrio_vereda`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrios_veredas`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Barrio_residencia, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Barrio_residencia->ViewValue = $this->Barrio_residencia->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Barrio_residencia->ViewValue = $this->Barrio_residencia->CurrentValue;
			}
		} else {
			$this->Barrio_residencia->ViewValue = NULL;
		}
		$this->Barrio_residencia->ViewCustomAttributes = "";

		// Fecha_ingreso_app
		$this->Fecha_ingreso_app->ViewValue = $this->Fecha_ingreso_app->CurrentValue;
		$this->Fecha_ingreso_app->ViewValue = ew_FormatDateTime($this->Fecha_ingreso_app->ViewValue, 5);
		$this->Fecha_ingreso_app->ViewCustomAttributes = "";

		// Actualizado_por
		$this->Actualizado_por->ViewValue = $this->Actualizado_por->CurrentValue;
		$this->Actualizado_por->ViewCustomAttributes = "";

		// Fecha_actualizacion_app
		$this->Fecha_actualizacion_app->ViewValue = $this->Fecha_actualizacion_app->CurrentValue;
		$this->Fecha_actualizacion_app->ViewValue = ew_FormatDateTime($this->Fecha_actualizacion_app->ViewValue, 5);
		$this->Fecha_actualizacion_app->ViewCustomAttributes = "";

			// Consecutivo
			$this->Consecutivo->LinkCustomAttributes = "";
			$this->Consecutivo->HrefValue = "";
			$this->Consecutivo->TooltipValue = "";

			// Seguimiento
			$this->Seguimiento->LinkCustomAttributes = "";
			$this->Seguimiento->HrefValue = "";
			$this->Seguimiento->TooltipValue = "";

			// Condicion_Final
			$this->Condicion_Final->LinkCustomAttributes = "";
			$this->Condicion_Final->HrefValue = "";
			$this->Condicion_Final->TooltipValue = "";

			// Codigo_centro
			$this->Codigo_centro->LinkCustomAttributes = "";
			$this->Codigo_centro->HrefValue = "";
			$this->Codigo_centro->TooltipValue = "";

			// Codigo_UPGD
			$this->Codigo_UPGD->LinkCustomAttributes = "";
			$this->Codigo_UPGD->HrefValue = "";
			$this->Codigo_UPGD->TooltipValue = "";

			// Cod_Evento
			$this->Cod_Evento->LinkCustomAttributes = "";
			$this->Cod_Evento->HrefValue = "";
			$this->Cod_Evento->TooltipValue = "";

			// Embarazo_Actual
			$this->Embarazo_Actual->LinkCustomAttributes = "";
			$this->Embarazo_Actual->HrefValue = "";
			$this->Embarazo_Actual->TooltipValue = "";

			// Fecha_Notificacion
			$this->Fecha_Notificacion->LinkCustomAttributes = "";
			$this->Fecha_Notificacion->HrefValue = "";
			$this->Fecha_Notificacion->TooltipValue = "";

			// Semana
			$this->Semana->LinkCustomAttributes = "";
			$this->Semana->HrefValue = "";
			$this->Semana->TooltipValue = "";

			// Periodo_Epidemiologico
			$this->Periodo_Epidemiologico->LinkCustomAttributes = "";
			$this->Periodo_Epidemiologico->HrefValue = "";
			$this->Periodo_Epidemiologico->TooltipValue = "";

			// Periodo_Sivigila
			$this->Periodo_Sivigila->LinkCustomAttributes = "";
			$this->Periodo_Sivigila->HrefValue = "";
			$this->Periodo_Sivigila->TooltipValue = "";

			// Primer_Nombre
			$this->Primer_Nombre->LinkCustomAttributes = "";
			$this->Primer_Nombre->HrefValue = "";
			$this->Primer_Nombre->TooltipValue = "";

			// Segundo_Nombre
			$this->Segundo_Nombre->LinkCustomAttributes = "";
			$this->Segundo_Nombre->HrefValue = "";
			$this->Segundo_Nombre->TooltipValue = "";

			// Primer_Apellido
			$this->Primer_Apellido->LinkCustomAttributes = "";
			$this->Primer_Apellido->HrefValue = "";
			$this->Primer_Apellido->TooltipValue = "";

			// Segundo_Apellido
			$this->Segundo_Apellido->LinkCustomAttributes = "";
			$this->Segundo_Apellido->HrefValue = "";
			$this->Segundo_Apellido->TooltipValue = "";

			// Tipo_Id
			$this->Tipo_Id->LinkCustomAttributes = "";
			$this->Tipo_Id->HrefValue = "";
			$this->Tipo_Id->TooltipValue = "";

			// Numero_Identificacion
			$this->Numero_Identificacion->LinkCustomAttributes = "";
			$this->Numero_Identificacion->HrefValue = "";
			$this->Numero_Identificacion->TooltipValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";
			$this->Edad->TooltipValue = "";

			// Unidad_Edad
			$this->Unidad_Edad->LinkCustomAttributes = "";
			$this->Unidad_Edad->HrefValue = "";
			$this->Unidad_Edad->TooltipValue = "";

			// Sexo
			$this->Sexo->LinkCustomAttributes = "";
			$this->Sexo->HrefValue = "";
			$this->Sexo->TooltipValue = "";

			// Pais_Ocurrencia
			$this->Pais_Ocurrencia->LinkCustomAttributes = "";
			$this->Pais_Ocurrencia->HrefValue = "";
			$this->Pais_Ocurrencia->TooltipValue = "";

			// Depto_Ocurrencia
			$this->Depto_Ocurrencia->LinkCustomAttributes = "";
			$this->Depto_Ocurrencia->HrefValue = "";
			$this->Depto_Ocurrencia->TooltipValue = "";

			// Municipio_Ocurrencia
			$this->Municipio_Ocurrencia->LinkCustomAttributes = "";
			$this->Municipio_Ocurrencia->HrefValue = "";
			$this->Municipio_Ocurrencia->TooltipValue = "";

			// Area_Ocurrencia
			$this->Area_Ocurrencia->LinkCustomAttributes = "";
			$this->Area_Ocurrencia->HrefValue = "";
			$this->Area_Ocurrencia->TooltipValue = "";

			// Localidad
			$this->Localidad->LinkCustomAttributes = "";
			$this->Localidad->HrefValue = "";
			$this->Localidad->TooltipValue = "";

			// Barrio
			$this->Barrio->LinkCustomAttributes = "";
			$this->Barrio->HrefValue = "";
			$this->Barrio->TooltipValue = "";

			// Direccion_Residencia
			$this->Direccion_Residencia->LinkCustomAttributes = "";
			$this->Direccion_Residencia->HrefValue = "";
			$this->Direccion_Residencia->TooltipValue = "";

			// Ocupacion
			$this->Ocupacion->LinkCustomAttributes = "";
			$this->Ocupacion->HrefValue = "";
			$this->Ocupacion->TooltipValue = "";

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->LinkCustomAttributes = "";
			$this->Tipo_Regimen_Salud->HrefValue = "";
			$this->Tipo_Regimen_Salud->TooltipValue = "";

			// Cod_Administradora
			$this->Cod_Administradora->LinkCustomAttributes = "";
			$this->Cod_Administradora->HrefValue = "";
			$this->Cod_Administradora->TooltipValue = "";

			// gp_discapa
			$this->gp_discapa->LinkCustomAttributes = "";
			$this->gp_discapa->HrefValue = "";
			$this->gp_discapa->TooltipValue = "";

			// gp_desplaz
			$this->gp_desplaz->LinkCustomAttributes = "";
			$this->gp_desplaz->HrefValue = "";
			$this->gp_desplaz->TooltipValue = "";

			// gp_migrant
			$this->gp_migrant->LinkCustomAttributes = "";
			$this->gp_migrant->HrefValue = "";
			$this->gp_migrant->TooltipValue = "";

			// gp_carcela
			$this->gp_carcela->LinkCustomAttributes = "";
			$this->gp_carcela->HrefValue = "";
			$this->gp_carcela->TooltipValue = "";

			// gp_gestan
			$this->gp_gestan->LinkCustomAttributes = "";
			$this->gp_gestan->HrefValue = "";
			$this->gp_gestan->TooltipValue = "";

			// gp_indigen
			$this->gp_indigen->LinkCustomAttributes = "";
			$this->gp_indigen->HrefValue = "";
			$this->gp_indigen->TooltipValue = "";

			// gp_pobicbf
			$this->gp_pobicbf->LinkCustomAttributes = "";
			$this->gp_pobicbf->HrefValue = "";
			$this->gp_pobicbf->TooltipValue = "";

			// gp_mad_com
			$this->gp_mad_com->LinkCustomAttributes = "";
			$this->gp_mad_com->HrefValue = "";
			$this->gp_mad_com->TooltipValue = "";

			// gp_desmovi
			$this->gp_desmovi->LinkCustomAttributes = "";
			$this->gp_desmovi->HrefValue = "";
			$this->gp_desmovi->TooltipValue = "";

			// gp_psiquia
			$this->gp_psiquia->LinkCustomAttributes = "";
			$this->gp_psiquia->HrefValue = "";
			$this->gp_psiquia->TooltipValue = "";

			// gp_vic_vio
			$this->gp_vic_vio->LinkCustomAttributes = "";
			$this->gp_vic_vio->HrefValue = "";
			$this->gp_vic_vio->TooltipValue = "";

			// gp_otros
			$this->gp_otros->LinkCustomAttributes = "";
			$this->gp_otros->HrefValue = "";
			$this->gp_otros->TooltipValue = "";

			// Depto_Residencia
			$this->Depto_Residencia->LinkCustomAttributes = "";
			$this->Depto_Residencia->HrefValue = "";
			$this->Depto_Residencia->TooltipValue = "";

			// Municipio_Residencia
			$this->Municipio_Residencia->LinkCustomAttributes = "";
			$this->Municipio_Residencia->HrefValue = "";
			$this->Municipio_Residencia->TooltipValue = "";

			// Fecha_Consulta
			$this->Fecha_Consulta->LinkCustomAttributes = "";
			$this->Fecha_Consulta->HrefValue = "";
			$this->Fecha_Consulta->TooltipValue = "";

			// Fecha_Inicio_Sintomas
			$this->Fecha_Inicio_Sintomas->LinkCustomAttributes = "";
			$this->Fecha_Inicio_Sintomas->HrefValue = "";
			$this->Fecha_Inicio_Sintomas->TooltipValue = "";

			// Hospitalizado
			$this->Hospitalizado->LinkCustomAttributes = "";
			$this->Hospitalizado->HrefValue = "";
			$this->Hospitalizado->TooltipValue = "";

			// Fecha_Defuncion
			$this->Fecha_Defuncion->LinkCustomAttributes = "";
			$this->Fecha_Defuncion->HrefValue = "";
			$this->Fecha_Defuncion->TooltipValue = "";

			// Numero_Certificado_Defuncion
			$this->Numero_Certificado_Defuncion->LinkCustomAttributes = "";
			$this->Numero_Certificado_Defuncion->HrefValue = "";
			$this->Numero_Certificado_Defuncion->TooltipValue = "";

			// Causa_Basica_Muerte_CIEX
			$this->Causa_Basica_Muerte_CIEX->LinkCustomAttributes = "";
			$this->Causa_Basica_Muerte_CIEX->HrefValue = "";
			$this->Causa_Basica_Muerte_CIEX->TooltipValue = "";

			// Entidad_fallecimiento
			$this->Entidad_fallecimiento->LinkCustomAttributes = "";
			$this->Entidad_fallecimiento->HrefValue = "";
			$this->Entidad_fallecimiento->TooltipValue = "";

			// Telefono
			$this->Telefono->LinkCustomAttributes = "";
			$this->Telefono->HrefValue = "";
			$this->Telefono->TooltipValue = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->LinkCustomAttributes = "";
			$this->Fecha_Nacimiento->HrefValue = "";
			$this->Fecha_Nacimiento->TooltipValue = "";

			// Nombre_Profesional_Diligencia
			$this->Nombre_Profesional_Diligencia->LinkCustomAttributes = "";
			$this->Nombre_Profesional_Diligencia->HrefValue = "";
			$this->Nombre_Profesional_Diligencia->TooltipValue = "";

			// Telefono_Profesional_Diligencia
			$this->Telefono_Profesional_Diligencia->LinkCustomAttributes = "";
			$this->Telefono_Profesional_Diligencia->HrefValue = "";
			$this->Telefono_Profesional_Diligencia->TooltipValue = "";

			// Mecanismo_Probable_Transmision
			$this->Mecanismo_Probable_Transmision->LinkCustomAttributes = "";
			$this->Mecanismo_Probable_Transmision->HrefValue = "";
			$this->Mecanismo_Probable_Transmision->TooltipValue = "";

			// Nombre_Madre
			$this->Nombre_Madre->LinkCustomAttributes = "";
			$this->Nombre_Madre->HrefValue = "";
			$this->Nombre_Madre->TooltipValue = "";

			// Tipo_Id_Madre
			$this->Tipo_Id_Madre->LinkCustomAttributes = "";
			$this->Tipo_Id_Madre->HrefValue = "";
			$this->Tipo_Id_Madre->TooltipValue = "";

			// Numero_Identificacion_Madre
			$this->Numero_Identificacion_Madre->LinkCustomAttributes = "";
			$this->Numero_Identificacion_Madre->HrefValue = "";
			$this->Numero_Identificacion_Madre->TooltipValue = "";

			// Indentidad_Genero
			$this->Indentidad_Genero->LinkCustomAttributes = "";
			$this->Indentidad_Genero->HrefValue = "";
			$this->Indentidad_Genero->TooltipValue = "";

			// Donador_Sangre_Ultimos_12_Meses
			$this->Donador_Sangre_Ultimos_12_Meses->LinkCustomAttributes = "";
			$this->Donador_Sangre_Ultimos_12_Meses->HrefValue = "";
			$this->Donador_Sangre_Ultimos_12_Meses->TooltipValue = "";

			// Fecha_Donacion
			$this->Fecha_Donacion->LinkCustomAttributes = "";
			$this->Fecha_Donacion->HrefValue = "";
			$this->Fecha_Donacion->TooltipValue = "";

			// Nombre_Institucion_Donacion
			$this->Nombre_Institucion_Donacion->LinkCustomAttributes = "";
			$this->Nombre_Institucion_Donacion->HrefValue = "";
			$this->Nombre_Institucion_Donacion->TooltipValue = "";

			// Poblacion_clave
			$this->Poblacion_clave->LinkCustomAttributes = "";
			$this->Poblacion_clave->HrefValue = "";
			$this->Poblacion_clave->TooltipValue = "";

			// Recibio_Asesoria_Pre_Prueba
			$this->Recibio_Asesoria_Pre_Prueba->LinkCustomAttributes = "";
			$this->Recibio_Asesoria_Pre_Prueba->HrefValue = "";
			$this->Recibio_Asesoria_Pre_Prueba->TooltipValue = "";

			// Recibio_Asesoria_Post_Prueba
			$this->Recibio_Asesoria_Post_Prueba->LinkCustomAttributes = "";
			$this->Recibio_Asesoria_Post_Prueba->HrefValue = "";
			$this->Recibio_Asesoria_Post_Prueba->TooltipValue = "";

			// Tipo_Prueba
			$this->Tipo_Prueba->LinkCustomAttributes = "";
			$this->Tipo_Prueba->HrefValue = "";
			$this->Tipo_Prueba->TooltipValue = "";

			// Fecha_Resultado_Confirmatorio
			$this->Fecha_Resultado_Confirmatorio->LinkCustomAttributes = "";
			$this->Fecha_Resultado_Confirmatorio->HrefValue = "";
			$this->Fecha_Resultado_Confirmatorio->TooltipValue = "";

			// Valor_Carga_Viral
			$this->Valor_Carga_Viral->LinkCustomAttributes = "";
			$this->Valor_Carga_Viral->HrefValue = "";
			$this->Valor_Carga_Viral->TooltipValue = "";

			// Estado_Clinico_Notificacion
			$this->Estado_Clinico_Notificacion->LinkCustomAttributes = "";
			$this->Estado_Clinico_Notificacion->HrefValue = "";
			$this->Estado_Clinico_Notificacion->TooltipValue = "";

			// Hijos_Mujeres_Menores_5
			$this->Hijos_Mujeres_Menores_5->LinkCustomAttributes = "";
			$this->Hijos_Mujeres_Menores_5->HrefValue = "";
			$this->Hijos_Mujeres_Menores_5->TooltipValue = "";

			// Hijos_Hombres_Menores_5
			$this->Hijos_Hombres_Menores_5->LinkCustomAttributes = "";
			$this->Hijos_Hombres_Menores_5->HrefValue = "";
			$this->Hijos_Hombres_Menores_5->TooltipValue = "";

			// Numero_Semanas_Embarazo
			$this->Numero_Semanas_Embarazo->LinkCustomAttributes = "";
			$this->Numero_Semanas_Embarazo->HrefValue = "";
			$this->Numero_Semanas_Embarazo->TooltipValue = "";

			// Antecedentes_Embarazo
			$this->Antecedentes_Embarazo->LinkCustomAttributes = "";
			$this->Antecedentes_Embarazo->HrefValue = "";
			$this->Antecedentes_Embarazo->TooltipValue = "";

			// Candidiasis_esofagica
			$this->Candidiasis_esofagica->LinkCustomAttributes = "";
			$this->Candidiasis_esofagica->HrefValue = "";
			$this->Candidiasis_esofagica->TooltipValue = "";

			// Candidiasis_vias_aereas
			$this->Candidiasis_vias_aereas->LinkCustomAttributes = "";
			$this->Candidiasis_vias_aereas->HrefValue = "";
			$this->Candidiasis_vias_aereas->TooltipValue = "";

			// Tuberculosis_pulmonar
			$this->Tuberculosis_pulmonar->LinkCustomAttributes = "";
			$this->Tuberculosis_pulmonar->HrefValue = "";
			$this->Tuberculosis_pulmonar->TooltipValue = "";

			// Cancer_cervical
			$this->Cancer_cervical->LinkCustomAttributes = "";
			$this->Cancer_cervical->HrefValue = "";
			$this->Cancer_cervical->TooltipValue = "";

			// Tuberculosis_extrapulmonar
			$this->Tuberculosis_extrapulmonar->LinkCustomAttributes = "";
			$this->Tuberculosis_extrapulmonar->HrefValue = "";
			$this->Tuberculosis_extrapulmonar->TooltipValue = "";

			// Coccidiomicosis
			$this->Coccidiomicosis->LinkCustomAttributes = "";
			$this->Coccidiomicosis->HrefValue = "";
			$this->Coccidiomicosis->TooltipValue = "";

			// Citomegalovirosis
			$this->Citomegalovirosis->LinkCustomAttributes = "";
			$this->Citomegalovirosis->HrefValue = "";
			$this->Citomegalovirosis->TooltipValue = "";

			// Retinitis_citomegalovirosis
			$this->Retinitis_citomegalovirosis->LinkCustomAttributes = "";
			$this->Retinitis_citomegalovirosis->HrefValue = "";
			$this->Retinitis_citomegalovirosis->TooltipValue = "";

			// Sindrome_Emanciacion
			$this->Sindrome_Emanciacion->LinkCustomAttributes = "";
			$this->Sindrome_Emanciacion->HrefValue = "";
			$this->Sindrome_Emanciacion->TooltipValue = "";

			// Encefalopatia
			$this->Encefalopatia->LinkCustomAttributes = "";
			$this->Encefalopatia->HrefValue = "";
			$this->Encefalopatia->TooltipValue = "";

			// Otras_micobacterias
			$this->Otras_micobacterias->LinkCustomAttributes = "";
			$this->Otras_micobacterias->HrefValue = "";
			$this->Otras_micobacterias->TooltipValue = "";

			// Histoplasmosis_Extrapulmonar
			$this->Histoplasmosis_Extrapulmonar->LinkCustomAttributes = "";
			$this->Histoplasmosis_Extrapulmonar->HrefValue = "";
			$this->Histoplasmosis_Extrapulmonar->TooltipValue = "";

			// isosporidiasis_cronica
			$this->isosporidiasis_cronica->LinkCustomAttributes = "";
			$this->isosporidiasis_cronica->HrefValue = "";
			$this->isosporidiasis_cronica->TooltipValue = "";

			// herpes_zoster
			$this->herpes_zoster->LinkCustomAttributes = "";
			$this->herpes_zoster->HrefValue = "";
			$this->herpes_zoster->TooltipValue = "";

			// Histoplasmosis_diseminada
			$this->Histoplasmosis_diseminada->LinkCustomAttributes = "";
			$this->Histoplasmosis_diseminada->HrefValue = "";
			$this->Histoplasmosis_diseminada->TooltipValue = "";

			// Linfoma_Burkitt
			$this->Linfoma_Burkitt->LinkCustomAttributes = "";
			$this->Linfoma_Burkitt->HrefValue = "";
			$this->Linfoma_Burkitt->TooltipValue = "";

			// Neumonia_Pneumocystis
			$this->Neumonia_Pneumocystis->LinkCustomAttributes = "";
			$this->Neumonia_Pneumocystis->HrefValue = "";
			$this->Neumonia_Pneumocystis->TooltipValue = "";

			// Neumonia_Recurrente
			$this->Neumonia_Recurrente->LinkCustomAttributes = "";
			$this->Neumonia_Recurrente->HrefValue = "";
			$this->Neumonia_Recurrente->TooltipValue = "";

			// Linfoma_Inmunoblastico
			$this->Linfoma_Inmunoblastico->LinkCustomAttributes = "";
			$this->Linfoma_Inmunoblastico->HrefValue = "";
			$this->Linfoma_Inmunoblastico->TooltipValue = "";

			// Criptosporidiasis_cronica
			$this->Criptosporidiasis_cronica->LinkCustomAttributes = "";
			$this->Criptosporidiasis_cronica->HrefValue = "";
			$this->Criptosporidiasis_cronica->TooltipValue = "";

			// Criptococosis_Extrapulmonar
			$this->Criptococosis_Extrapulmonar->LinkCustomAttributes = "";
			$this->Criptococosis_Extrapulmonar->HrefValue = "";
			$this->Criptococosis_Extrapulmonar->TooltipValue = "";

			// Sarcoma_Kaposi
			$this->Sarcoma_Kaposi->LinkCustomAttributes = "";
			$this->Sarcoma_Kaposi->HrefValue = "";
			$this->Sarcoma_Kaposi->TooltipValue = "";

			// Leucoencefalopatia_Multifocal
			$this->Leucoencefalopatia_Multifocal->LinkCustomAttributes = "";
			$this->Leucoencefalopatia_Multifocal->HrefValue = "";
			$this->Leucoencefalopatia_Multifocal->TooltipValue = "";

			// Septicemia_recurrente
			$this->Septicemia_recurrente->LinkCustomAttributes = "";
			$this->Septicemia_recurrente->HrefValue = "";
			$this->Septicemia_recurrente->TooltipValue = "";

			// Toxoplasmosis_cerebral
			$this->Toxoplasmosis_cerebral->LinkCustomAttributes = "";
			$this->Toxoplasmosis_cerebral->HrefValue = "";
			$this->Toxoplasmosis_cerebral->TooltipValue = "";

			// HepatitisB
			$this->HepatitisB->LinkCustomAttributes = "";
			$this->HepatitisB->HrefValue = "";
			$this->HepatitisB->TooltipValue = "";

			// HepatitisC
			$this->HepatitisC->LinkCustomAttributes = "";
			$this->HepatitisC->HrefValue = "";
			$this->HepatitisC->TooltipValue = "";

			// Meningitis
			$this->Meningitis->LinkCustomAttributes = "";
			$this->Meningitis->HrefValue = "";
			$this->Meningitis->TooltipValue = "";

			// RecuentoCD4
			$this->RecuentoCD4->LinkCustomAttributes = "";
			$this->RecuentoCD4->HrefValue = "";
			$this->RecuentoCD4->TooltipValue = "";

			// Registrado_Por
			$this->Registrado_Por->LinkCustomAttributes = "";
			$this->Registrado_Por->HrefValue = "";
			$this->Registrado_Por->TooltipValue = "";

			// Localidad_residencia
			$this->Localidad_residencia->LinkCustomAttributes = "";
			$this->Localidad_residencia->HrefValue = "";
			$this->Localidad_residencia->TooltipValue = "";

			// Barrio_residencia
			$this->Barrio_residencia->LinkCustomAttributes = "";
			$this->Barrio_residencia->HrefValue = "";
			$this->Barrio_residencia->TooltipValue = "";

			// Fecha_ingreso_app
			$this->Fecha_ingreso_app->LinkCustomAttributes = "";
			$this->Fecha_ingreso_app->HrefValue = "";
			$this->Fecha_ingreso_app->TooltipValue = "";

			// Actualizado_por
			$this->Actualizado_por->LinkCustomAttributes = "";
			$this->Actualizado_por->HrefValue = "";
			$this->Actualizado_por->TooltipValue = "";

			// Fecha_actualizacion_app
			$this->Fecha_actualizacion_app->LinkCustomAttributes = "";
			$this->Fecha_actualizacion_app->HrefValue = "";
			$this->Fecha_actualizacion_app->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_registro\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_registro',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fregistroview,key:" . ew_ArrayToJsonAttr($this->RecKey) . ",sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = FALSE;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;
		$this->SetUpStartRec(); // Set up start record position

		// Set the last record to display
		if ($this->DisplayRecs <= 0) {
			$this->StopRec = $this->TotalRecs;
		} else {
			$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
		}
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "v");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "view");

		// Export detail records (seguimiento_individual3)
		if (EW_EXPORT_DETAIL_RECORDS && in_array("seguimiento_individual3", explode(",", $this->getCurrentDetailTable()))) {
			global $seguimiento_individual3;
			if (!isset($seguimiento_individual3)) $seguimiento_individual3 = new cseguimiento_individual3;
			$rsdetail = $seguimiento_individual3->LoadRs($seguimiento_individual3->GetDetailFilter()); // Load detail records
			if ($rsdetail && !$rsdetail->EOF) {
				$ExportStyle = $Doc->Style;
				$Doc->SetStyle("h"); // Change to horizontal
				if ($this->Export <> "csv" || EW_EXPORT_DETAIL_RECORDS_FOR_CSV) {
					$Doc->ExportEmptyRow();
					$detailcnt = $rsdetail->RecordCount();
					$seguimiento_individual3->ExportDocument($Doc, $rsdetail, 1, $detailcnt);
				}
				$Doc->SetStyle($ExportStyle); // Restore
				$rsdetail->Close();
			}
		}

		// Export detail records (seguimiento_materno)
		if (EW_EXPORT_DETAIL_RECORDS && in_array("seguimiento_materno", explode(",", $this->getCurrentDetailTable()))) {
			global $seguimiento_materno;
			if (!isset($seguimiento_materno)) $seguimiento_materno = new cseguimiento_materno;
			$rsdetail = $seguimiento_materno->LoadRs($seguimiento_materno->GetDetailFilter()); // Load detail records
			if ($rsdetail && !$rsdetail->EOF) {
				$ExportStyle = $Doc->Style;
				$Doc->SetStyle("h"); // Change to horizontal
				if ($this->Export <> "csv" || EW_EXPORT_DETAIL_RECORDS_FOR_CSV) {
					$Doc->ExportEmptyRow();
					$detailcnt = $rsdetail->RecordCount();
					$seguimiento_materno->ExportDocument($Doc, $rsdetail, 1, $detailcnt);
				}
				$Doc->SetStyle($ExportStyle); // Restore
				$rsdetail->Close();
			}
		}
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Show link optionally based on User ID
	function ShowOptionLink($id = "") {
		global $Security;
		if ($Security->IsLoggedIn() && !$Security->IsAdmin() && !$this->UserIDAllow($id))
			return $Security->IsValidUserID($this->Codigo_centro->CurrentValue);
		return TRUE;
	}

	// Set up detail parms based on QueryString
	function SetUpDetailParms() {

		// Get the keys for master table
		if (isset($_GET[EW_TABLE_SHOW_DETAIL])) {
			$sDetailTblVar = $_GET[EW_TABLE_SHOW_DETAIL];
			$this->setCurrentDetailTable($sDetailTblVar);
		} else {
			$sDetailTblVar = $this->getCurrentDetailTable();
		}
		if ($sDetailTblVar <> "") {
			$DetailTblVar = explode(",", $sDetailTblVar);
			if (in_array("seguimiento_individual3", $DetailTblVar)) {
				if (!isset($GLOBALS["seguimiento_individual3_grid"]))
					$GLOBALS["seguimiento_individual3_grid"] = new cseguimiento_individual3_grid;
				if ($GLOBALS["seguimiento_individual3_grid"]->DetailView) {
					$GLOBALS["seguimiento_individual3_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["seguimiento_individual3_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["seguimiento_individual3_grid"]->setStartRecordNumber(1);
					$GLOBALS["seguimiento_individual3_grid"]->Id_Registro->FldIsDetailKey = TRUE;
					$GLOBALS["seguimiento_individual3_grid"]->Id_Registro->CurrentValue = $this->Consecutivo->CurrentValue;
					$GLOBALS["seguimiento_individual3_grid"]->Id_Registro->setSessionValue($GLOBALS["seguimiento_individual3_grid"]->Id_Registro->CurrentValue);
				}
			}
			if (in_array("seguimiento_materno", $DetailTblVar)) {
				if (!isset($GLOBALS["seguimiento_materno_grid"]))
					$GLOBALS["seguimiento_materno_grid"] = new cseguimiento_materno_grid;
				if ($GLOBALS["seguimiento_materno_grid"]->DetailView) {
					$GLOBALS["seguimiento_materno_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["seguimiento_materno_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["seguimiento_materno_grid"]->setStartRecordNumber(1);
					$GLOBALS["seguimiento_materno_grid"]->Id_Registro->FldIsDetailKey = TRUE;
					$GLOBALS["seguimiento_materno_grid"]->Id_Registro->CurrentValue = $this->Consecutivo->CurrentValue;
					$GLOBALS["seguimiento_materno_grid"]->Id_Registro->setSessionValue($GLOBALS["seguimiento_materno_grid"]->Id_Registro->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("registrolist.php"), "", $this->TableVar, TRUE);
		$PageId = "view";
		$Breadcrumb->Add("view", $PageId, $url);
	}

	// Set up multi pages
	function SetupMultiPages() {
		$pages = new cSubPages();
		$pages->Style = "tabs";
		$pages->Add(0);
		$pages->Add(1);
		$pages->Add(2);
		$pages->Add(3);
		$pages->Add(4);
		$pages->Add(5);
		$pages->Add(6);
		$pages->Add(7);
		$pages->Add(8);
		$this->MultiPages = $pages;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($registro_view)) $registro_view = new cregistro_view();

// Page init
$registro_view->Page_Init();

// Page main
$registro_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$registro_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($registro->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "view";
var CurrentForm = fregistroview = new ew_Form("fregistroview", "view");

// Form_CustomValidate event
fregistroview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fregistroview.ValidateRequired = true;
<?php } else { ?>
fregistroview.ValidateRequired = false; 
<?php } ?>

// Multi-Page
fregistroview.MultiPage = new ew_MultiPage("fregistroview");

// Dynamic selection lists
fregistroview.Lists["x_Seguimiento"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Condicion_Final"] = {"LinkField":"x_No_Condicion_Final","Ajax":true,"AutoFill":false,"DisplayFields":["x_Condicion_Final","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Codigo_centro"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Upgd","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Codigo_UPGD"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Upgd","x_Upgd","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Embarazo_Actual"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Semana"] = {"LinkField":"x_Semana","Ajax":true,"AutoFill":false,"DisplayFields":["x_Semana","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Periodo_Epidemiologico"] = {"LinkField":"x_Periodo_epidemiologico","Ajax":true,"AutoFill":false,"DisplayFields":["x_Periodo_epidemiologico","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Periodo_Sivigila"] = {"LinkField":"x_Periodo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Periodo","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Tipo_Id"] = {"LinkField":"x_Cod_Documento","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_Ide","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Unidad_Edad"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Unidad_Edad","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Sexo"] = {"LinkField":"x_Codigo_Sexo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Sexo","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Pais_Ocurrencia"] = {"LinkField":"x_Cod_Pais","Ajax":true,"AutoFill":false,"DisplayFields":["x_Pais","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Depto_Ocurrencia"] = {"LinkField":"x_Cod_Departamento","Ajax":true,"AutoFill":false,"DisplayFields":["x_Departamento","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Municipio_Ocurrencia"] = {"LinkField":"x_Cod_Municipio","Ajax":true,"AutoFill":false,"DisplayFields":["x_Municipio","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Area_Ocurrencia"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Area_Ocurrencia","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Localidad"] = {"LinkField":"x_consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Localidad_Comuna","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Barrio"] = {"LinkField":"x_cod_barrio_vereda","Ajax":true,"AutoFill":false,"DisplayFields":["x_Barrio_Vereda","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Ocupacion"] = {"LinkField":"x_Cod_Ocupacion","Ajax":true,"AutoFill":false,"DisplayFields":["x_Cod_Ocupacion","x_Ocupacion","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Tipo_Regimen_Salud"] = {"LinkField":"x_Codigo_Regimen","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Regimen","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Cod_Administradora"] = {"LinkField":"x_Codigo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo","x_Administradora_Salud","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_discapa"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_desplaz"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_migrant"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_carcela"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_gestan"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_indigen"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_pobicbf"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_mad_com"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_desmovi"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_psiquia"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_vic_vio"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_gp_otros"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Depto_Residencia"] = {"LinkField":"x_Cod_Departamento","Ajax":true,"AutoFill":false,"DisplayFields":["x_Departamento","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Municipio_Residencia"] = {"LinkField":"x_Cod_Municipio","Ajax":true,"AutoFill":false,"DisplayFields":["x_Municipio","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Hospitalizado[]"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Entidad_fallecimiento"] = {"LinkField":"x_Codigo_Upgd","Ajax":true,"AutoFill":false,"DisplayFields":["x_Codigo_Upgd","x_Upgd","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Mecanismo_Probable_Transmision"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Mecanismo_Probable","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Tipo_Id_Madre"] = {"LinkField":"x_Cod_Documento","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_Ide","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Indentidad_Genero"] = {"LinkField":"x_Codigo_identidad","Ajax":true,"AutoFill":false,"DisplayFields":["x_Identidad_genero","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Donador_Sangre_Ultimos_12_Meses"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Poblacion_clave"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Poblacion_clave","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Recibio_Asesoria_Pre_Prueba"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Recibio_Asesoria_Post_Prueba"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Tipo_Prueba"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_Prueba","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Estado_Clinico_Notificacion"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Estado_Clinico","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Antecedentes_Embarazo"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Candidiasis_esofagica"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Candidiasis_vias_aereas"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Tuberculosis_pulmonar"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Cancer_cervical"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Tuberculosis_extrapulmonar"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Coccidiomicosis"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Citomegalovirosis"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Retinitis_citomegalovirosis"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Sindrome_Emanciacion"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Encefalopatia"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Otras_micobacterias"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Histoplasmosis_Extrapulmonar"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_isosporidiasis_cronica"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_herpes_zoster"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Histoplasmosis_diseminada"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Linfoma_Burkitt"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Neumonia_Pneumocystis"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Neumonia_Recurrente"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Linfoma_Inmunoblastico"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Criptosporidiasis_cronica"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Criptococosis_Extrapulmonar"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Sarcoma_Kaposi"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Leucoencefalopatia_Multifocal"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Septicemia_recurrente"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Toxoplasmosis_cerebral"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_HepatitisB"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_HepatitisC"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Meningitis"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_RecuentoCD4"] = {"LinkField":"x_Consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Si_No","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Localidad_residencia"] = {"LinkField":"x_consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Localidad_Comuna","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fregistroview.Lists["x_Barrio_residencia"] = {"LinkField":"x_cod_barrio_vereda","Ajax":true,"AutoFill":false,"DisplayFields":["x_Barrio_Vereda","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($registro->Export == "") { ?>
<div class="ewToolbar">
<?php if ($registro->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php $registro_view->ExportOptions->Render("body") ?>
<?php
	foreach ($registro_view->OtherOptions as &$option)
		$option->Render("body");
?>
<?php if ($registro->Export == "") { ?>
<?php echo $Language->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $registro_view->ShowPageHeader(); ?>
<?php
$registro_view->ShowMessage();
?>
<?php if ($registro->Export == "") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($registro_view->Pager)) $registro_view->Pager = new cPrevNextPager($registro_view->StartRec, $registro_view->DisplayRecs, $registro_view->TotalRecs) ?>
<?php if ($registro_view->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($registro_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $registro_view->PageUrl() ?>start=<?php echo $registro_view->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($registro_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $registro_view->PageUrl() ?>start=<?php echo $registro_view->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $registro_view->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($registro_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $registro_view->PageUrl() ?>start=<?php echo $registro_view->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($registro_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $registro_view->PageUrl() ?>start=<?php echo $registro_view->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $registro_view->Pager->PageCount ?></span>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fregistroview" id="fregistroview" class="form-inline ewForm ewViewForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($registro_view->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $registro_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="registro">
<?php if ($registro->Export == "") { ?>
<div class="ewMultiPage">
<div class="tabbable" id="registro_view">
	<ul class="nav<?php echo $registro_view->MultiPages->NavStyle() ?>">
		<li<?php echo $registro_view->MultiPages->TabStyle("1") ?>><a href="#tab_registro1" data-toggle="tab"><?php echo $registro->PageCaption(1) ?></a></li>
		<li<?php echo $registro_view->MultiPages->TabStyle("2") ?>><a href="#tab_registro2" data-toggle="tab"><?php echo $registro->PageCaption(2) ?></a></li>
		<li<?php echo $registro_view->MultiPages->TabStyle("3") ?>><a href="#tab_registro3" data-toggle="tab"><?php echo $registro->PageCaption(3) ?></a></li>
		<li<?php echo $registro_view->MultiPages->TabStyle("4") ?>><a href="#tab_registro4" data-toggle="tab"><?php echo $registro->PageCaption(4) ?></a></li>
		<li<?php echo $registro_view->MultiPages->TabStyle("5") ?>><a href="#tab_registro5" data-toggle="tab"><?php echo $registro->PageCaption(5) ?></a></li>
		<li<?php echo $registro_view->MultiPages->TabStyle("6") ?>><a href="#tab_registro6" data-toggle="tab"><?php echo $registro->PageCaption(6) ?></a></li>
		<li<?php echo $registro_view->MultiPages->TabStyle("7") ?>><a href="#tab_registro7" data-toggle="tab"><?php echo $registro->PageCaption(7) ?></a></li>
		<li<?php echo $registro_view->MultiPages->TabStyle("8") ?>><a href="#tab_registro8" data-toggle="tab"><?php echo $registro->PageCaption(8) ?></a></li>
	</ul>
	<div class="tab-content">
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("1") ?>" id="tab_registro1">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->Consecutivo->Visible) { // Consecutivo ?>
	<tr id="r_Consecutivo">
		<td><span id="elh_registro_Consecutivo"><?php echo $registro->Consecutivo->FldCaption() ?></span></td>
		<td data-name="Consecutivo"<?php echo $registro->Consecutivo->CellAttributes() ?>>
<span id="el_registro_Consecutivo" data-page="1">
<span<?php echo $registro->Consecutivo->ViewAttributes() ?>>
<?php echo $registro->Consecutivo->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Seguimiento->Visible) { // Seguimiento ?>
	<tr id="r_Seguimiento">
		<td><span id="elh_registro_Seguimiento"><?php echo $registro->Seguimiento->FldCaption() ?></span></td>
		<td data-name="Seguimiento"<?php echo $registro->Seguimiento->CellAttributes() ?>>
<span id="el_registro_Seguimiento" data-page="1">
<span<?php echo $registro->Seguimiento->ViewAttributes() ?>>
<?php echo $registro->Seguimiento->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Codigo_centro->Visible) { // Codigo_centro ?>
	<tr id="r_Codigo_centro">
		<td><span id="elh_registro_Codigo_centro"><?php echo $registro->Codigo_centro->FldCaption() ?></span></td>
		<td data-name="Codigo_centro"<?php echo $registro->Codigo_centro->CellAttributes() ?>>
<span id="el_registro_Codigo_centro" data-page="1">
<span<?php echo $registro->Codigo_centro->ViewAttributes() ?>>
<?php echo $registro->Codigo_centro->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Codigo_UPGD->Visible) { // Codigo_UPGD ?>
	<tr id="r_Codigo_UPGD">
		<td><span id="elh_registro_Codigo_UPGD"><?php echo $registro->Codigo_UPGD->FldCaption() ?></span></td>
		<td data-name="Codigo_UPGD"<?php echo $registro->Codigo_UPGD->CellAttributes() ?>>
<span id="el_registro_Codigo_UPGD" data-page="1">
<span<?php echo $registro->Codigo_UPGD->ViewAttributes() ?>>
<?php echo $registro->Codigo_UPGD->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Cod_Evento->Visible) { // Cod_Evento ?>
	<tr id="r_Cod_Evento">
		<td><span id="elh_registro_Cod_Evento"><?php echo $registro->Cod_Evento->FldCaption() ?></span></td>
		<td data-name="Cod_Evento"<?php echo $registro->Cod_Evento->CellAttributes() ?>>
<span id="el_registro_Cod_Evento" data-page="1">
<span<?php echo $registro->Cod_Evento->ViewAttributes() ?>>
<?php echo $registro->Cod_Evento->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_Notificacion->Visible) { // Fecha_Notificacion ?>
	<tr id="r_Fecha_Notificacion">
		<td><span id="elh_registro_Fecha_Notificacion"><?php echo $registro->Fecha_Notificacion->FldCaption() ?></span></td>
		<td data-name="Fecha_Notificacion"<?php echo $registro->Fecha_Notificacion->CellAttributes() ?>>
<span id="el_registro_Fecha_Notificacion" data-page="1">
<span<?php echo $registro->Fecha_Notificacion->ViewAttributes() ?>>
<?php echo $registro->Fecha_Notificacion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Semana->Visible) { // Semana ?>
	<tr id="r_Semana">
		<td><span id="elh_registro_Semana"><?php echo $registro->Semana->FldCaption() ?></span></td>
		<td data-name="Semana"<?php echo $registro->Semana->CellAttributes() ?>>
<span id="el_registro_Semana" data-page="1">
<span<?php echo $registro->Semana->ViewAttributes() ?>>
<?php echo $registro->Semana->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Periodo_Epidemiologico->Visible) { // Periodo_Epidemiologico ?>
	<tr id="r_Periodo_Epidemiologico">
		<td><span id="elh_registro_Periodo_Epidemiologico"><?php echo $registro->Periodo_Epidemiologico->FldCaption() ?></span></td>
		<td data-name="Periodo_Epidemiologico"<?php echo $registro->Periodo_Epidemiologico->CellAttributes() ?>>
<span id="el_registro_Periodo_Epidemiologico" data-page="1">
<span<?php echo $registro->Periodo_Epidemiologico->ViewAttributes() ?>>
<?php echo $registro->Periodo_Epidemiologico->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Periodo_Sivigila->Visible) { // Periodo_Sivigila ?>
	<tr id="r_Periodo_Sivigila">
		<td><span id="elh_registro_Periodo_Sivigila"><?php echo $registro->Periodo_Sivigila->FldCaption() ?></span></td>
		<td data-name="Periodo_Sivigila"<?php echo $registro->Periodo_Sivigila->CellAttributes() ?>>
<span id="el_registro_Periodo_Sivigila" data-page="1">
<span<?php echo $registro->Periodo_Sivigila->ViewAttributes() ?>>
<?php echo $registro->Periodo_Sivigila->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Registrado_Por->Visible) { // Registrado_Por ?>
	<tr id="r_Registrado_Por">
		<td><span id="elh_registro_Registrado_Por"><?php echo $registro->Registrado_Por->FldCaption() ?></span></td>
		<td data-name="Registrado_Por"<?php echo $registro->Registrado_Por->CellAttributes() ?>>
<span id="el_registro_Registrado_Por" data-page="1">
<span<?php echo $registro->Registrado_Por->ViewAttributes() ?>>
<?php echo $registro->Registrado_Por->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Localidad_residencia->Visible) { // Localidad_residencia ?>
	<tr id="r_Localidad_residencia">
		<td><span id="elh_registro_Localidad_residencia"><?php echo $registro->Localidad_residencia->FldCaption() ?></span></td>
		<td data-name="Localidad_residencia"<?php echo $registro->Localidad_residencia->CellAttributes() ?>>
<span id="el_registro_Localidad_residencia" data-page="1">
<span<?php echo $registro->Localidad_residencia->ViewAttributes() ?>>
<?php echo $registro->Localidad_residencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Barrio_residencia->Visible) { // Barrio_residencia ?>
	<tr id="r_Barrio_residencia">
		<td><span id="elh_registro_Barrio_residencia"><?php echo $registro->Barrio_residencia->FldCaption() ?></span></td>
		<td data-name="Barrio_residencia"<?php echo $registro->Barrio_residencia->CellAttributes() ?>>
<span id="el_registro_Barrio_residencia" data-page="1">
<span<?php echo $registro->Barrio_residencia->ViewAttributes() ?>>
<?php echo $registro->Barrio_residencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_ingreso_app->Visible) { // Fecha_ingreso_app ?>
	<tr id="r_Fecha_ingreso_app">
		<td><span id="elh_registro_Fecha_ingreso_app"><?php echo $registro->Fecha_ingreso_app->FldCaption() ?></span></td>
		<td data-name="Fecha_ingreso_app"<?php echo $registro->Fecha_ingreso_app->CellAttributes() ?>>
<span id="el_registro_Fecha_ingreso_app" data-page="1">
<span<?php echo $registro->Fecha_ingreso_app->ViewAttributes() ?>>
<?php echo $registro->Fecha_ingreso_app->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Actualizado_por->Visible) { // Actualizado_por ?>
	<tr id="r_Actualizado_por">
		<td><span id="elh_registro_Actualizado_por"><?php echo $registro->Actualizado_por->FldCaption() ?></span></td>
		<td data-name="Actualizado_por"<?php echo $registro->Actualizado_por->CellAttributes() ?>>
<span id="el_registro_Actualizado_por" data-page="1">
<span<?php echo $registro->Actualizado_por->ViewAttributes() ?>>
<?php echo $registro->Actualizado_por->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_actualizacion_app->Visible) { // Fecha_actualizacion_app ?>
	<tr id="r_Fecha_actualizacion_app">
		<td><span id="elh_registro_Fecha_actualizacion_app"><?php echo $registro->Fecha_actualizacion_app->FldCaption() ?></span></td>
		<td data-name="Fecha_actualizacion_app"<?php echo $registro->Fecha_actualizacion_app->CellAttributes() ?>>
<span id="el_registro_Fecha_actualizacion_app" data-page="1">
<span<?php echo $registro->Fecha_actualizacion_app->ViewAttributes() ?>>
<?php echo $registro->Fecha_actualizacion_app->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("2") ?>" id="tab_registro2">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->Primer_Nombre->Visible) { // Primer_Nombre ?>
	<tr id="r_Primer_Nombre">
		<td><span id="elh_registro_Primer_Nombre"><?php echo $registro->Primer_Nombre->FldCaption() ?></span></td>
		<td data-name="Primer_Nombre"<?php echo $registro->Primer_Nombre->CellAttributes() ?>>
<span id="el_registro_Primer_Nombre" data-page="2">
<span<?php echo $registro->Primer_Nombre->ViewAttributes() ?>>
<?php echo $registro->Primer_Nombre->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Segundo_Nombre->Visible) { // Segundo_Nombre ?>
	<tr id="r_Segundo_Nombre">
		<td><span id="elh_registro_Segundo_Nombre"><?php echo $registro->Segundo_Nombre->FldCaption() ?></span></td>
		<td data-name="Segundo_Nombre"<?php echo $registro->Segundo_Nombre->CellAttributes() ?>>
<span id="el_registro_Segundo_Nombre" data-page="2">
<span<?php echo $registro->Segundo_Nombre->ViewAttributes() ?>>
<?php echo $registro->Segundo_Nombre->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Primer_Apellido->Visible) { // Primer_Apellido ?>
	<tr id="r_Primer_Apellido">
		<td><span id="elh_registro_Primer_Apellido"><?php echo $registro->Primer_Apellido->FldCaption() ?></span></td>
		<td data-name="Primer_Apellido"<?php echo $registro->Primer_Apellido->CellAttributes() ?>>
<span id="el_registro_Primer_Apellido" data-page="2">
<span<?php echo $registro->Primer_Apellido->ViewAttributes() ?>>
<?php echo $registro->Primer_Apellido->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Segundo_Apellido->Visible) { // Segundo_Apellido ?>
	<tr id="r_Segundo_Apellido">
		<td><span id="elh_registro_Segundo_Apellido"><?php echo $registro->Segundo_Apellido->FldCaption() ?></span></td>
		<td data-name="Segundo_Apellido"<?php echo $registro->Segundo_Apellido->CellAttributes() ?>>
<span id="el_registro_Segundo_Apellido" data-page="2">
<span<?php echo $registro->Segundo_Apellido->ViewAttributes() ?>>
<?php echo $registro->Segundo_Apellido->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Tipo_Id->Visible) { // Tipo_Id ?>
	<tr id="r_Tipo_Id">
		<td><span id="elh_registro_Tipo_Id"><?php echo $registro->Tipo_Id->FldCaption() ?></span></td>
		<td data-name="Tipo_Id"<?php echo $registro->Tipo_Id->CellAttributes() ?>>
<span id="el_registro_Tipo_Id" data-page="2">
<span<?php echo $registro->Tipo_Id->ViewAttributes() ?>>
<?php echo $registro->Tipo_Id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Numero_Identificacion->Visible) { // Numero_Identificacion ?>
	<tr id="r_Numero_Identificacion">
		<td><span id="elh_registro_Numero_Identificacion"><?php echo $registro->Numero_Identificacion->FldCaption() ?></span></td>
		<td data-name="Numero_Identificacion"<?php echo $registro->Numero_Identificacion->CellAttributes() ?>>
<span id="el_registro_Numero_Identificacion" data-page="2">
<span<?php echo $registro->Numero_Identificacion->ViewAttributes() ?>>
<?php echo $registro->Numero_Identificacion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Edad->Visible) { // Edad ?>
	<tr id="r_Edad">
		<td><span id="elh_registro_Edad"><?php echo $registro->Edad->FldCaption() ?></span></td>
		<td data-name="Edad"<?php echo $registro->Edad->CellAttributes() ?>>
<span id="el_registro_Edad" data-page="2">
<span<?php echo $registro->Edad->ViewAttributes() ?>>
<?php echo $registro->Edad->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Unidad_Edad->Visible) { // Unidad_Edad ?>
	<tr id="r_Unidad_Edad">
		<td><span id="elh_registro_Unidad_Edad"><?php echo $registro->Unidad_Edad->FldCaption() ?></span></td>
		<td data-name="Unidad_Edad"<?php echo $registro->Unidad_Edad->CellAttributes() ?>>
<span id="el_registro_Unidad_Edad" data-page="2">
<span<?php echo $registro->Unidad_Edad->ViewAttributes() ?>>
<?php echo $registro->Unidad_Edad->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Sexo->Visible) { // Sexo ?>
	<tr id="r_Sexo">
		<td><span id="elh_registro_Sexo"><?php echo $registro->Sexo->FldCaption() ?></span></td>
		<td data-name="Sexo"<?php echo $registro->Sexo->CellAttributes() ?>>
<span id="el_registro_Sexo" data-page="2">
<span<?php echo $registro->Sexo->ViewAttributes() ?>>
<?php echo $registro->Sexo->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Pais_Ocurrencia->Visible) { // Pais_Ocurrencia ?>
	<tr id="r_Pais_Ocurrencia">
		<td><span id="elh_registro_Pais_Ocurrencia"><?php echo $registro->Pais_Ocurrencia->FldCaption() ?></span></td>
		<td data-name="Pais_Ocurrencia"<?php echo $registro->Pais_Ocurrencia->CellAttributes() ?>>
<span id="el_registro_Pais_Ocurrencia" data-page="2">
<span<?php echo $registro->Pais_Ocurrencia->ViewAttributes() ?>>
<?php echo $registro->Pais_Ocurrencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Depto_Ocurrencia->Visible) { // Depto_Ocurrencia ?>
	<tr id="r_Depto_Ocurrencia">
		<td><span id="elh_registro_Depto_Ocurrencia"><?php echo $registro->Depto_Ocurrencia->FldCaption() ?></span></td>
		<td data-name="Depto_Ocurrencia"<?php echo $registro->Depto_Ocurrencia->CellAttributes() ?>>
<span id="el_registro_Depto_Ocurrencia" data-page="2">
<span<?php echo $registro->Depto_Ocurrencia->ViewAttributes() ?>>
<?php echo $registro->Depto_Ocurrencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Municipio_Ocurrencia->Visible) { // Municipio_Ocurrencia ?>
	<tr id="r_Municipio_Ocurrencia">
		<td><span id="elh_registro_Municipio_Ocurrencia"><?php echo $registro->Municipio_Ocurrencia->FldCaption() ?></span></td>
		<td data-name="Municipio_Ocurrencia"<?php echo $registro->Municipio_Ocurrencia->CellAttributes() ?>>
<span id="el_registro_Municipio_Ocurrencia" data-page="2">
<span<?php echo $registro->Municipio_Ocurrencia->ViewAttributes() ?>>
<?php echo $registro->Municipio_Ocurrencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Area_Ocurrencia->Visible) { // Area_Ocurrencia ?>
	<tr id="r_Area_Ocurrencia">
		<td><span id="elh_registro_Area_Ocurrencia"><?php echo $registro->Area_Ocurrencia->FldCaption() ?></span></td>
		<td data-name="Area_Ocurrencia"<?php echo $registro->Area_Ocurrencia->CellAttributes() ?>>
<span id="el_registro_Area_Ocurrencia" data-page="2">
<span<?php echo $registro->Area_Ocurrencia->ViewAttributes() ?>>
<?php echo $registro->Area_Ocurrencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Localidad->Visible) { // Localidad ?>
	<tr id="r_Localidad">
		<td><span id="elh_registro_Localidad"><?php echo $registro->Localidad->FldCaption() ?></span></td>
		<td data-name="Localidad"<?php echo $registro->Localidad->CellAttributes() ?>>
<span id="el_registro_Localidad" data-page="2">
<span<?php echo $registro->Localidad->ViewAttributes() ?>>
<?php echo $registro->Localidad->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Barrio->Visible) { // Barrio ?>
	<tr id="r_Barrio">
		<td><span id="elh_registro_Barrio"><?php echo $registro->Barrio->FldCaption() ?></span></td>
		<td data-name="Barrio"<?php echo $registro->Barrio->CellAttributes() ?>>
<span id="el_registro_Barrio" data-page="2">
<span<?php echo $registro->Barrio->ViewAttributes() ?>>
<?php echo $registro->Barrio->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Direccion_Residencia->Visible) { // Direccion_Residencia ?>
	<tr id="r_Direccion_Residencia">
		<td><span id="elh_registro_Direccion_Residencia"><?php echo $registro->Direccion_Residencia->FldCaption() ?></span></td>
		<td data-name="Direccion_Residencia"<?php echo $registro->Direccion_Residencia->CellAttributes() ?>>
<span id="el_registro_Direccion_Residencia" data-page="2">
<span<?php echo $registro->Direccion_Residencia->ViewAttributes() ?>>
<?php echo $registro->Direccion_Residencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Ocupacion->Visible) { // Ocupacion ?>
	<tr id="r_Ocupacion">
		<td><span id="elh_registro_Ocupacion"><?php echo $registro->Ocupacion->FldCaption() ?></span></td>
		<td data-name="Ocupacion"<?php echo $registro->Ocupacion->CellAttributes() ?>>
<span id="el_registro_Ocupacion" data-page="2">
<span<?php echo $registro->Ocupacion->ViewAttributes() ?>>
<?php echo $registro->Ocupacion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
	<tr id="r_Tipo_Regimen_Salud">
		<td><span id="elh_registro_Tipo_Regimen_Salud"><?php echo $registro->Tipo_Regimen_Salud->FldCaption() ?></span></td>
		<td data-name="Tipo_Regimen_Salud"<?php echo $registro->Tipo_Regimen_Salud->CellAttributes() ?>>
<span id="el_registro_Tipo_Regimen_Salud" data-page="2">
<span<?php echo $registro->Tipo_Regimen_Salud->ViewAttributes() ?>>
<?php echo $registro->Tipo_Regimen_Salud->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Cod_Administradora->Visible) { // Cod_Administradora ?>
	<tr id="r_Cod_Administradora">
		<td><span id="elh_registro_Cod_Administradora"><?php echo $registro->Cod_Administradora->FldCaption() ?></span></td>
		<td data-name="Cod_Administradora"<?php echo $registro->Cod_Administradora->CellAttributes() ?>>
<span id="el_registro_Cod_Administradora" data-page="2">
<span<?php echo $registro->Cod_Administradora->ViewAttributes() ?>>
<?php echo $registro->Cod_Administradora->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Telefono->Visible) { // Telefono ?>
	<tr id="r_Telefono">
		<td><span id="elh_registro_Telefono"><?php echo $registro->Telefono->FldCaption() ?></span></td>
		<td data-name="Telefono"<?php echo $registro->Telefono->CellAttributes() ?>>
<span id="el_registro_Telefono" data-page="2">
<span<?php echo $registro->Telefono->ViewAttributes() ?>>
<?php echo $registro->Telefono->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_Nacimiento->Visible) { // Fecha_Nacimiento ?>
	<tr id="r_Fecha_Nacimiento">
		<td><span id="elh_registro_Fecha_Nacimiento"><?php echo $registro->Fecha_Nacimiento->FldCaption() ?></span></td>
		<td data-name="Fecha_Nacimiento"<?php echo $registro->Fecha_Nacimiento->CellAttributes() ?>>
<span id="el_registro_Fecha_Nacimiento" data-page="2">
<span<?php echo $registro->Fecha_Nacimiento->ViewAttributes() ?>>
<?php echo $registro->Fecha_Nacimiento->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("3") ?>" id="tab_registro3">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->gp_discapa->Visible) { // gp_discapa ?>
	<tr id="r_gp_discapa">
		<td><span id="elh_registro_gp_discapa"><?php echo $registro->gp_discapa->FldCaption() ?></span></td>
		<td data-name="gp_discapa"<?php echo $registro->gp_discapa->CellAttributes() ?>>
<span id="el_registro_gp_discapa" data-page="3">
<span<?php echo $registro->gp_discapa->ViewAttributes() ?>>
<?php echo $registro->gp_discapa->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_desplaz->Visible) { // gp_desplaz ?>
	<tr id="r_gp_desplaz">
		<td><span id="elh_registro_gp_desplaz"><?php echo $registro->gp_desplaz->FldCaption() ?></span></td>
		<td data-name="gp_desplaz"<?php echo $registro->gp_desplaz->CellAttributes() ?>>
<span id="el_registro_gp_desplaz" data-page="3">
<span<?php echo $registro->gp_desplaz->ViewAttributes() ?>>
<?php echo $registro->gp_desplaz->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_migrant->Visible) { // gp_migrant ?>
	<tr id="r_gp_migrant">
		<td><span id="elh_registro_gp_migrant"><?php echo $registro->gp_migrant->FldCaption() ?></span></td>
		<td data-name="gp_migrant"<?php echo $registro->gp_migrant->CellAttributes() ?>>
<span id="el_registro_gp_migrant" data-page="3">
<span<?php echo $registro->gp_migrant->ViewAttributes() ?>>
<?php echo $registro->gp_migrant->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_carcela->Visible) { // gp_carcela ?>
	<tr id="r_gp_carcela">
		<td><span id="elh_registro_gp_carcela"><?php echo $registro->gp_carcela->FldCaption() ?></span></td>
		<td data-name="gp_carcela"<?php echo $registro->gp_carcela->CellAttributes() ?>>
<span id="el_registro_gp_carcela" data-page="3">
<span<?php echo $registro->gp_carcela->ViewAttributes() ?>>
<?php echo $registro->gp_carcela->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_gestan->Visible) { // gp_gestan ?>
	<tr id="r_gp_gestan">
		<td><span id="elh_registro_gp_gestan"><?php echo $registro->gp_gestan->FldCaption() ?></span></td>
		<td data-name="gp_gestan"<?php echo $registro->gp_gestan->CellAttributes() ?>>
<span id="el_registro_gp_gestan" data-page="3">
<span<?php echo $registro->gp_gestan->ViewAttributes() ?>>
<?php echo $registro->gp_gestan->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_indigen->Visible) { // gp_indigen ?>
	<tr id="r_gp_indigen">
		<td><span id="elh_registro_gp_indigen"><?php echo $registro->gp_indigen->FldCaption() ?></span></td>
		<td data-name="gp_indigen"<?php echo $registro->gp_indigen->CellAttributes() ?>>
<span id="el_registro_gp_indigen" data-page="3">
<span<?php echo $registro->gp_indigen->ViewAttributes() ?>>
<?php echo $registro->gp_indigen->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_pobicbf->Visible) { // gp_pobicbf ?>
	<tr id="r_gp_pobicbf">
		<td><span id="elh_registro_gp_pobicbf"><?php echo $registro->gp_pobicbf->FldCaption() ?></span></td>
		<td data-name="gp_pobicbf"<?php echo $registro->gp_pobicbf->CellAttributes() ?>>
<span id="el_registro_gp_pobicbf" data-page="3">
<span<?php echo $registro->gp_pobicbf->ViewAttributes() ?>>
<?php echo $registro->gp_pobicbf->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_mad_com->Visible) { // gp_mad_com ?>
	<tr id="r_gp_mad_com">
		<td><span id="elh_registro_gp_mad_com"><?php echo $registro->gp_mad_com->FldCaption() ?></span></td>
		<td data-name="gp_mad_com"<?php echo $registro->gp_mad_com->CellAttributes() ?>>
<span id="el_registro_gp_mad_com" data-page="3">
<span<?php echo $registro->gp_mad_com->ViewAttributes() ?>>
<?php echo $registro->gp_mad_com->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_desmovi->Visible) { // gp_desmovi ?>
	<tr id="r_gp_desmovi">
		<td><span id="elh_registro_gp_desmovi"><?php echo $registro->gp_desmovi->FldCaption() ?></span></td>
		<td data-name="gp_desmovi"<?php echo $registro->gp_desmovi->CellAttributes() ?>>
<span id="el_registro_gp_desmovi" data-page="3">
<span<?php echo $registro->gp_desmovi->ViewAttributes() ?>>
<?php echo $registro->gp_desmovi->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_psiquia->Visible) { // gp_psiquia ?>
	<tr id="r_gp_psiquia">
		<td><span id="elh_registro_gp_psiquia"><?php echo $registro->gp_psiquia->FldCaption() ?></span></td>
		<td data-name="gp_psiquia"<?php echo $registro->gp_psiquia->CellAttributes() ?>>
<span id="el_registro_gp_psiquia" data-page="3">
<span<?php echo $registro->gp_psiquia->ViewAttributes() ?>>
<?php echo $registro->gp_psiquia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_vic_vio->Visible) { // gp_vic_vio ?>
	<tr id="r_gp_vic_vio">
		<td><span id="elh_registro_gp_vic_vio"><?php echo $registro->gp_vic_vio->FldCaption() ?></span></td>
		<td data-name="gp_vic_vio"<?php echo $registro->gp_vic_vio->CellAttributes() ?>>
<span id="el_registro_gp_vic_vio" data-page="3">
<span<?php echo $registro->gp_vic_vio->ViewAttributes() ?>>
<?php echo $registro->gp_vic_vio->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->gp_otros->Visible) { // gp_otros ?>
	<tr id="r_gp_otros">
		<td><span id="elh_registro_gp_otros"><?php echo $registro->gp_otros->FldCaption() ?></span></td>
		<td data-name="gp_otros"<?php echo $registro->gp_otros->CellAttributes() ?>>
<span id="el_registro_gp_otros" data-page="3">
<span<?php echo $registro->gp_otros->ViewAttributes() ?>>
<?php echo $registro->gp_otros->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("4") ?>" id="tab_registro4">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->Condicion_Final->Visible) { // Condicion_Final ?>
	<tr id="r_Condicion_Final">
		<td><span id="elh_registro_Condicion_Final"><?php echo $registro->Condicion_Final->FldCaption() ?></span></td>
		<td data-name="Condicion_Final"<?php echo $registro->Condicion_Final->CellAttributes() ?>>
<span id="el_registro_Condicion_Final" data-page="4">
<span<?php echo $registro->Condicion_Final->ViewAttributes() ?>>
<?php echo $registro->Condicion_Final->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Depto_Residencia->Visible) { // Depto_Residencia ?>
	<tr id="r_Depto_Residencia">
		<td><span id="elh_registro_Depto_Residencia"><?php echo $registro->Depto_Residencia->FldCaption() ?></span></td>
		<td data-name="Depto_Residencia"<?php echo $registro->Depto_Residencia->CellAttributes() ?>>
<span id="el_registro_Depto_Residencia" data-page="4">
<span<?php echo $registro->Depto_Residencia->ViewAttributes() ?>>
<?php echo $registro->Depto_Residencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Municipio_Residencia->Visible) { // Municipio_Residencia ?>
	<tr id="r_Municipio_Residencia">
		<td><span id="elh_registro_Municipio_Residencia"><?php echo $registro->Municipio_Residencia->FldCaption() ?></span></td>
		<td data-name="Municipio_Residencia"<?php echo $registro->Municipio_Residencia->CellAttributes() ?>>
<span id="el_registro_Municipio_Residencia" data-page="4">
<span<?php echo $registro->Municipio_Residencia->ViewAttributes() ?>>
<?php echo $registro->Municipio_Residencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_Consulta->Visible) { // Fecha_Consulta ?>
	<tr id="r_Fecha_Consulta">
		<td><span id="elh_registro_Fecha_Consulta"><?php echo $registro->Fecha_Consulta->FldCaption() ?></span></td>
		<td data-name="Fecha_Consulta"<?php echo $registro->Fecha_Consulta->CellAttributes() ?>>
<span id="el_registro_Fecha_Consulta" data-page="4">
<span<?php echo $registro->Fecha_Consulta->ViewAttributes() ?>>
<?php echo $registro->Fecha_Consulta->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_Inicio_Sintomas->Visible) { // Fecha_Inicio_Sintomas ?>
	<tr id="r_Fecha_Inicio_Sintomas">
		<td><span id="elh_registro_Fecha_Inicio_Sintomas"><?php echo $registro->Fecha_Inicio_Sintomas->FldCaption() ?></span></td>
		<td data-name="Fecha_Inicio_Sintomas"<?php echo $registro->Fecha_Inicio_Sintomas->CellAttributes() ?>>
<span id="el_registro_Fecha_Inicio_Sintomas" data-page="4">
<span<?php echo $registro->Fecha_Inicio_Sintomas->ViewAttributes() ?>>
<?php echo $registro->Fecha_Inicio_Sintomas->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Hospitalizado->Visible) { // Hospitalizado ?>
	<tr id="r_Hospitalizado">
		<td><span id="elh_registro_Hospitalizado"><?php echo $registro->Hospitalizado->FldCaption() ?></span></td>
		<td data-name="Hospitalizado"<?php echo $registro->Hospitalizado->CellAttributes() ?>>
<span id="el_registro_Hospitalizado" data-page="4">
<span<?php echo $registro->Hospitalizado->ViewAttributes() ?>>
<?php echo $registro->Hospitalizado->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_Defuncion->Visible) { // Fecha_Defuncion ?>
	<tr id="r_Fecha_Defuncion">
		<td><span id="elh_registro_Fecha_Defuncion"><?php echo $registro->Fecha_Defuncion->FldCaption() ?></span></td>
		<td data-name="Fecha_Defuncion"<?php echo $registro->Fecha_Defuncion->CellAttributes() ?>>
<span id="el_registro_Fecha_Defuncion" data-page="4">
<span<?php echo $registro->Fecha_Defuncion->ViewAttributes() ?>>
<?php echo $registro->Fecha_Defuncion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Numero_Certificado_Defuncion->Visible) { // Numero_Certificado_Defuncion ?>
	<tr id="r_Numero_Certificado_Defuncion">
		<td><span id="elh_registro_Numero_Certificado_Defuncion"><?php echo $registro->Numero_Certificado_Defuncion->FldCaption() ?></span></td>
		<td data-name="Numero_Certificado_Defuncion"<?php echo $registro->Numero_Certificado_Defuncion->CellAttributes() ?>>
<span id="el_registro_Numero_Certificado_Defuncion" data-page="4">
<span<?php echo $registro->Numero_Certificado_Defuncion->ViewAttributes() ?>>
<?php echo $registro->Numero_Certificado_Defuncion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Causa_Basica_Muerte_CIEX->Visible) { // Causa_Basica_Muerte_CIEX ?>
	<tr id="r_Causa_Basica_Muerte_CIEX">
		<td><span id="elh_registro_Causa_Basica_Muerte_CIEX"><?php echo $registro->Causa_Basica_Muerte_CIEX->FldCaption() ?></span></td>
		<td data-name="Causa_Basica_Muerte_CIEX"<?php echo $registro->Causa_Basica_Muerte_CIEX->CellAttributes() ?>>
<span id="el_registro_Causa_Basica_Muerte_CIEX" data-page="4">
<span<?php echo $registro->Causa_Basica_Muerte_CIEX->ViewAttributes() ?>>
<?php echo $registro->Causa_Basica_Muerte_CIEX->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Entidad_fallecimiento->Visible) { // Entidad_fallecimiento ?>
	<tr id="r_Entidad_fallecimiento">
		<td><span id="elh_registro_Entidad_fallecimiento"><?php echo $registro->Entidad_fallecimiento->FldCaption() ?></span></td>
		<td data-name="Entidad_fallecimiento"<?php echo $registro->Entidad_fallecimiento->CellAttributes() ?>>
<span id="el_registro_Entidad_fallecimiento" data-page="4">
<span<?php echo $registro->Entidad_fallecimiento->ViewAttributes() ?>>
<?php echo $registro->Entidad_fallecimiento->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Nombre_Profesional_Diligencia->Visible) { // Nombre_Profesional_Diligencia ?>
	<tr id="r_Nombre_Profesional_Diligencia">
		<td><span id="elh_registro_Nombre_Profesional_Diligencia"><?php echo $registro->Nombre_Profesional_Diligencia->FldCaption() ?></span></td>
		<td data-name="Nombre_Profesional_Diligencia"<?php echo $registro->Nombre_Profesional_Diligencia->CellAttributes() ?>>
<span id="el_registro_Nombre_Profesional_Diligencia" data-page="4">
<span<?php echo $registro->Nombre_Profesional_Diligencia->ViewAttributes() ?>>
<?php echo $registro->Nombre_Profesional_Diligencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Telefono_Profesional_Diligencia->Visible) { // Telefono_Profesional_Diligencia ?>
	<tr id="r_Telefono_Profesional_Diligencia">
		<td><span id="elh_registro_Telefono_Profesional_Diligencia"><?php echo $registro->Telefono_Profesional_Diligencia->FldCaption() ?></span></td>
		<td data-name="Telefono_Profesional_Diligencia"<?php echo $registro->Telefono_Profesional_Diligencia->CellAttributes() ?>>
<span id="el_registro_Telefono_Profesional_Diligencia" data-page="4">
<span<?php echo $registro->Telefono_Profesional_Diligencia->ViewAttributes() ?>>
<?php echo $registro->Telefono_Profesional_Diligencia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Valor_Carga_Viral->Visible) { // Valor_Carga_Viral ?>
	<tr id="r_Valor_Carga_Viral">
		<td><span id="elh_registro_Valor_Carga_Viral"><?php echo $registro->Valor_Carga_Viral->FldCaption() ?></span></td>
		<td data-name="Valor_Carga_Viral"<?php echo $registro->Valor_Carga_Viral->CellAttributes() ?>>
<span id="el_registro_Valor_Carga_Viral" data-page="4">
<span<?php echo $registro->Valor_Carga_Viral->ViewAttributes() ?>>
<?php echo $registro->Valor_Carga_Viral->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("5") ?>" id="tab_registro5">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->Mecanismo_Probable_Transmision->Visible) { // Mecanismo_Probable_Transmision ?>
	<tr id="r_Mecanismo_Probable_Transmision">
		<td><span id="elh_registro_Mecanismo_Probable_Transmision"><?php echo $registro->Mecanismo_Probable_Transmision->FldCaption() ?></span></td>
		<td data-name="Mecanismo_Probable_Transmision"<?php echo $registro->Mecanismo_Probable_Transmision->CellAttributes() ?>>
<span id="el_registro_Mecanismo_Probable_Transmision" data-page="5">
<span<?php echo $registro->Mecanismo_Probable_Transmision->ViewAttributes() ?>>
<?php echo $registro->Mecanismo_Probable_Transmision->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Nombre_Madre->Visible) { // Nombre_Madre ?>
	<tr id="r_Nombre_Madre">
		<td><span id="elh_registro_Nombre_Madre"><?php echo $registro->Nombre_Madre->FldCaption() ?></span></td>
		<td data-name="Nombre_Madre"<?php echo $registro->Nombre_Madre->CellAttributes() ?>>
<span id="el_registro_Nombre_Madre" data-page="5">
<span<?php echo $registro->Nombre_Madre->ViewAttributes() ?>>
<?php echo $registro->Nombre_Madre->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Tipo_Id_Madre->Visible) { // Tipo_Id_Madre ?>
	<tr id="r_Tipo_Id_Madre">
		<td><span id="elh_registro_Tipo_Id_Madre"><?php echo $registro->Tipo_Id_Madre->FldCaption() ?></span></td>
		<td data-name="Tipo_Id_Madre"<?php echo $registro->Tipo_Id_Madre->CellAttributes() ?>>
<span id="el_registro_Tipo_Id_Madre" data-page="5">
<span<?php echo $registro->Tipo_Id_Madre->ViewAttributes() ?>>
<?php echo $registro->Tipo_Id_Madre->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Numero_Identificacion_Madre->Visible) { // Numero_Identificacion_Madre ?>
	<tr id="r_Numero_Identificacion_Madre">
		<td><span id="elh_registro_Numero_Identificacion_Madre"><?php echo $registro->Numero_Identificacion_Madre->FldCaption() ?></span></td>
		<td data-name="Numero_Identificacion_Madre"<?php echo $registro->Numero_Identificacion_Madre->CellAttributes() ?>>
<span id="el_registro_Numero_Identificacion_Madre" data-page="5">
<span<?php echo $registro->Numero_Identificacion_Madre->ViewAttributes() ?>>
<?php echo $registro->Numero_Identificacion_Madre->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Indentidad_Genero->Visible) { // Indentidad_Genero ?>
	<tr id="r_Indentidad_Genero">
		<td><span id="elh_registro_Indentidad_Genero"><?php echo $registro->Indentidad_Genero->FldCaption() ?></span></td>
		<td data-name="Indentidad_Genero"<?php echo $registro->Indentidad_Genero->CellAttributes() ?>>
<span id="el_registro_Indentidad_Genero" data-page="5">
<span<?php echo $registro->Indentidad_Genero->ViewAttributes() ?>>
<?php echo $registro->Indentidad_Genero->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Donador_Sangre_Ultimos_12_Meses->Visible) { // Donador_Sangre_Ultimos_12_Meses ?>
	<tr id="r_Donador_Sangre_Ultimos_12_Meses">
		<td><span id="elh_registro_Donador_Sangre_Ultimos_12_Meses"><?php echo $registro->Donador_Sangre_Ultimos_12_Meses->FldCaption() ?></span></td>
		<td data-name="Donador_Sangre_Ultimos_12_Meses"<?php echo $registro->Donador_Sangre_Ultimos_12_Meses->CellAttributes() ?>>
<span id="el_registro_Donador_Sangre_Ultimos_12_Meses" data-page="5">
<span<?php echo $registro->Donador_Sangre_Ultimos_12_Meses->ViewAttributes() ?>>
<?php echo $registro->Donador_Sangre_Ultimos_12_Meses->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_Donacion->Visible) { // Fecha_Donacion ?>
	<tr id="r_Fecha_Donacion">
		<td><span id="elh_registro_Fecha_Donacion"><?php echo $registro->Fecha_Donacion->FldCaption() ?></span></td>
		<td data-name="Fecha_Donacion"<?php echo $registro->Fecha_Donacion->CellAttributes() ?>>
<span id="el_registro_Fecha_Donacion" data-page="5">
<span<?php echo $registro->Fecha_Donacion->ViewAttributes() ?>>
<?php echo $registro->Fecha_Donacion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Nombre_Institucion_Donacion->Visible) { // Nombre_Institucion_Donacion ?>
	<tr id="r_Nombre_Institucion_Donacion">
		<td><span id="elh_registro_Nombre_Institucion_Donacion"><?php echo $registro->Nombre_Institucion_Donacion->FldCaption() ?></span></td>
		<td data-name="Nombre_Institucion_Donacion"<?php echo $registro->Nombre_Institucion_Donacion->CellAttributes() ?>>
<span id="el_registro_Nombre_Institucion_Donacion" data-page="5">
<span<?php echo $registro->Nombre_Institucion_Donacion->ViewAttributes() ?>>
<?php echo $registro->Nombre_Institucion_Donacion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Poblacion_clave->Visible) { // Poblacion_clave ?>
	<tr id="r_Poblacion_clave">
		<td><span id="elh_registro_Poblacion_clave"><?php echo $registro->Poblacion_clave->FldCaption() ?></span></td>
		<td data-name="Poblacion_clave"<?php echo $registro->Poblacion_clave->CellAttributes() ?>>
<span id="el_registro_Poblacion_clave" data-page="5">
<span<?php echo $registro->Poblacion_clave->ViewAttributes() ?>>
<?php echo $registro->Poblacion_clave->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("6") ?>" id="tab_registro6">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->Recibio_Asesoria_Pre_Prueba->Visible) { // Recibio_Asesoria_Pre_Prueba ?>
	<tr id="r_Recibio_Asesoria_Pre_Prueba">
		<td><span id="elh_registro_Recibio_Asesoria_Pre_Prueba"><?php echo $registro->Recibio_Asesoria_Pre_Prueba->FldCaption() ?></span></td>
		<td data-name="Recibio_Asesoria_Pre_Prueba"<?php echo $registro->Recibio_Asesoria_Pre_Prueba->CellAttributes() ?>>
<span id="el_registro_Recibio_Asesoria_Pre_Prueba" data-page="6">
<span<?php echo $registro->Recibio_Asesoria_Pre_Prueba->ViewAttributes() ?>>
<?php echo $registro->Recibio_Asesoria_Pre_Prueba->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Recibio_Asesoria_Post_Prueba->Visible) { // Recibio_Asesoria_Post_Prueba ?>
	<tr id="r_Recibio_Asesoria_Post_Prueba">
		<td><span id="elh_registro_Recibio_Asesoria_Post_Prueba"><?php echo $registro->Recibio_Asesoria_Post_Prueba->FldCaption() ?></span></td>
		<td data-name="Recibio_Asesoria_Post_Prueba"<?php echo $registro->Recibio_Asesoria_Post_Prueba->CellAttributes() ?>>
<span id="el_registro_Recibio_Asesoria_Post_Prueba" data-page="6">
<span<?php echo $registro->Recibio_Asesoria_Post_Prueba->ViewAttributes() ?>>
<?php echo $registro->Recibio_Asesoria_Post_Prueba->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Tipo_Prueba->Visible) { // Tipo_Prueba ?>
	<tr id="r_Tipo_Prueba">
		<td><span id="elh_registro_Tipo_Prueba"><?php echo $registro->Tipo_Prueba->FldCaption() ?></span></td>
		<td data-name="Tipo_Prueba"<?php echo $registro->Tipo_Prueba->CellAttributes() ?>>
<span id="el_registro_Tipo_Prueba" data-page="6">
<span<?php echo $registro->Tipo_Prueba->ViewAttributes() ?>>
<?php echo $registro->Tipo_Prueba->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Fecha_Resultado_Confirmatorio->Visible) { // Fecha_Resultado_Confirmatorio ?>
	<tr id="r_Fecha_Resultado_Confirmatorio">
		<td><span id="elh_registro_Fecha_Resultado_Confirmatorio"><?php echo $registro->Fecha_Resultado_Confirmatorio->FldCaption() ?></span></td>
		<td data-name="Fecha_Resultado_Confirmatorio"<?php echo $registro->Fecha_Resultado_Confirmatorio->CellAttributes() ?>>
<span id="el_registro_Fecha_Resultado_Confirmatorio" data-page="6">
<span<?php echo $registro->Fecha_Resultado_Confirmatorio->ViewAttributes() ?>>
<?php echo $registro->Fecha_Resultado_Confirmatorio->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Estado_Clinico_Notificacion->Visible) { // Estado_Clinico_Notificacion ?>
	<tr id="r_Estado_Clinico_Notificacion">
		<td><span id="elh_registro_Estado_Clinico_Notificacion"><?php echo $registro->Estado_Clinico_Notificacion->FldCaption() ?></span></td>
		<td data-name="Estado_Clinico_Notificacion"<?php echo $registro->Estado_Clinico_Notificacion->CellAttributes() ?>>
<span id="el_registro_Estado_Clinico_Notificacion" data-page="6">
<span<?php echo $registro->Estado_Clinico_Notificacion->ViewAttributes() ?>>
<?php echo $registro->Estado_Clinico_Notificacion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("7") ?>" id="tab_registro7">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->Embarazo_Actual->Visible) { // Embarazo_Actual ?>
	<tr id="r_Embarazo_Actual">
		<td><span id="elh_registro_Embarazo_Actual"><?php echo $registro->Embarazo_Actual->FldCaption() ?></span></td>
		<td data-name="Embarazo_Actual"<?php echo $registro->Embarazo_Actual->CellAttributes() ?>>
<span id="el_registro_Embarazo_Actual" data-page="7">
<span<?php echo $registro->Embarazo_Actual->ViewAttributes() ?>>
<?php echo $registro->Embarazo_Actual->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Hijos_Mujeres_Menores_5->Visible) { // Hijos_Mujeres_Menores_5 ?>
	<tr id="r_Hijos_Mujeres_Menores_5">
		<td><span id="elh_registro_Hijos_Mujeres_Menores_5"><?php echo $registro->Hijos_Mujeres_Menores_5->FldCaption() ?></span></td>
		<td data-name="Hijos_Mujeres_Menores_5"<?php echo $registro->Hijos_Mujeres_Menores_5->CellAttributes() ?>>
<span id="el_registro_Hijos_Mujeres_Menores_5" data-page="7">
<span<?php echo $registro->Hijos_Mujeres_Menores_5->ViewAttributes() ?>>
<?php echo $registro->Hijos_Mujeres_Menores_5->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Hijos_Hombres_Menores_5->Visible) { // Hijos_Hombres_Menores_5 ?>
	<tr id="r_Hijos_Hombres_Menores_5">
		<td><span id="elh_registro_Hijos_Hombres_Menores_5"><?php echo $registro->Hijos_Hombres_Menores_5->FldCaption() ?></span></td>
		<td data-name="Hijos_Hombres_Menores_5"<?php echo $registro->Hijos_Hombres_Menores_5->CellAttributes() ?>>
<span id="el_registro_Hijos_Hombres_Menores_5" data-page="7">
<span<?php echo $registro->Hijos_Hombres_Menores_5->ViewAttributes() ?>>
<?php echo $registro->Hijos_Hombres_Menores_5->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Numero_Semanas_Embarazo->Visible) { // Numero_Semanas_Embarazo ?>
	<tr id="r_Numero_Semanas_Embarazo">
		<td><span id="elh_registro_Numero_Semanas_Embarazo"><?php echo $registro->Numero_Semanas_Embarazo->FldCaption() ?></span></td>
		<td data-name="Numero_Semanas_Embarazo"<?php echo $registro->Numero_Semanas_Embarazo->CellAttributes() ?>>
<span id="el_registro_Numero_Semanas_Embarazo" data-page="7">
<span<?php echo $registro->Numero_Semanas_Embarazo->ViewAttributes() ?>>
<?php echo $registro->Numero_Semanas_Embarazo->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Antecedentes_Embarazo->Visible) { // Antecedentes_Embarazo ?>
	<tr id="r_Antecedentes_Embarazo">
		<td><span id="elh_registro_Antecedentes_Embarazo"><?php echo $registro->Antecedentes_Embarazo->FldCaption() ?></span></td>
		<td data-name="Antecedentes_Embarazo"<?php echo $registro->Antecedentes_Embarazo->CellAttributes() ?>>
<span id="el_registro_Antecedentes_Embarazo" data-page="7">
<span<?php echo $registro->Antecedentes_Embarazo->ViewAttributes() ?>>
<?php echo $registro->Antecedentes_Embarazo->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
		<div class="tab-pane<?php echo $registro_view->MultiPages->PageStyle("8") ?>" id="tab_registro8">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable">
<?php if ($registro->Candidiasis_esofagica->Visible) { // Candidiasis_esofagica ?>
	<tr id="r_Candidiasis_esofagica">
		<td><span id="elh_registro_Candidiasis_esofagica"><?php echo $registro->Candidiasis_esofagica->FldCaption() ?></span></td>
		<td data-name="Candidiasis_esofagica"<?php echo $registro->Candidiasis_esofagica->CellAttributes() ?>>
<span id="el_registro_Candidiasis_esofagica" data-page="8">
<span<?php echo $registro->Candidiasis_esofagica->ViewAttributes() ?>>
<?php echo $registro->Candidiasis_esofagica->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Candidiasis_vias_aereas->Visible) { // Candidiasis_vias_aereas ?>
	<tr id="r_Candidiasis_vias_aereas">
		<td><span id="elh_registro_Candidiasis_vias_aereas"><?php echo $registro->Candidiasis_vias_aereas->FldCaption() ?></span></td>
		<td data-name="Candidiasis_vias_aereas"<?php echo $registro->Candidiasis_vias_aereas->CellAttributes() ?>>
<span id="el_registro_Candidiasis_vias_aereas" data-page="8">
<span<?php echo $registro->Candidiasis_vias_aereas->ViewAttributes() ?>>
<?php echo $registro->Candidiasis_vias_aereas->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Tuberculosis_pulmonar->Visible) { // Tuberculosis_pulmonar ?>
	<tr id="r_Tuberculosis_pulmonar">
		<td><span id="elh_registro_Tuberculosis_pulmonar"><?php echo $registro->Tuberculosis_pulmonar->FldCaption() ?></span></td>
		<td data-name="Tuberculosis_pulmonar"<?php echo $registro->Tuberculosis_pulmonar->CellAttributes() ?>>
<span id="el_registro_Tuberculosis_pulmonar" data-page="8">
<span<?php echo $registro->Tuberculosis_pulmonar->ViewAttributes() ?>>
<?php echo $registro->Tuberculosis_pulmonar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Cancer_cervical->Visible) { // Cancer_cervical ?>
	<tr id="r_Cancer_cervical">
		<td><span id="elh_registro_Cancer_cervical"><?php echo $registro->Cancer_cervical->FldCaption() ?></span></td>
		<td data-name="Cancer_cervical"<?php echo $registro->Cancer_cervical->CellAttributes() ?>>
<span id="el_registro_Cancer_cervical" data-page="8">
<span<?php echo $registro->Cancer_cervical->ViewAttributes() ?>>
<?php echo $registro->Cancer_cervical->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Tuberculosis_extrapulmonar->Visible) { // Tuberculosis_extrapulmonar ?>
	<tr id="r_Tuberculosis_extrapulmonar">
		<td><span id="elh_registro_Tuberculosis_extrapulmonar"><?php echo $registro->Tuberculosis_extrapulmonar->FldCaption() ?></span></td>
		<td data-name="Tuberculosis_extrapulmonar"<?php echo $registro->Tuberculosis_extrapulmonar->CellAttributes() ?>>
<span id="el_registro_Tuberculosis_extrapulmonar" data-page="8">
<span<?php echo $registro->Tuberculosis_extrapulmonar->ViewAttributes() ?>>
<?php echo $registro->Tuberculosis_extrapulmonar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Coccidiomicosis->Visible) { // Coccidiomicosis ?>
	<tr id="r_Coccidiomicosis">
		<td><span id="elh_registro_Coccidiomicosis"><?php echo $registro->Coccidiomicosis->FldCaption() ?></span></td>
		<td data-name="Coccidiomicosis"<?php echo $registro->Coccidiomicosis->CellAttributes() ?>>
<span id="el_registro_Coccidiomicosis" data-page="8">
<span<?php echo $registro->Coccidiomicosis->ViewAttributes() ?>>
<?php echo $registro->Coccidiomicosis->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Citomegalovirosis->Visible) { // Citomegalovirosis ?>
	<tr id="r_Citomegalovirosis">
		<td><span id="elh_registro_Citomegalovirosis"><?php echo $registro->Citomegalovirosis->FldCaption() ?></span></td>
		<td data-name="Citomegalovirosis"<?php echo $registro->Citomegalovirosis->CellAttributes() ?>>
<span id="el_registro_Citomegalovirosis" data-page="8">
<span<?php echo $registro->Citomegalovirosis->ViewAttributes() ?>>
<?php echo $registro->Citomegalovirosis->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Retinitis_citomegalovirosis->Visible) { // Retinitis_citomegalovirosis ?>
	<tr id="r_Retinitis_citomegalovirosis">
		<td><span id="elh_registro_Retinitis_citomegalovirosis"><?php echo $registro->Retinitis_citomegalovirosis->FldCaption() ?></span></td>
		<td data-name="Retinitis_citomegalovirosis"<?php echo $registro->Retinitis_citomegalovirosis->CellAttributes() ?>>
<span id="el_registro_Retinitis_citomegalovirosis" data-page="8">
<span<?php echo $registro->Retinitis_citomegalovirosis->ViewAttributes() ?>>
<?php echo $registro->Retinitis_citomegalovirosis->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Sindrome_Emanciacion->Visible) { // Sindrome_Emanciacion ?>
	<tr id="r_Sindrome_Emanciacion">
		<td><span id="elh_registro_Sindrome_Emanciacion"><?php echo $registro->Sindrome_Emanciacion->FldCaption() ?></span></td>
		<td data-name="Sindrome_Emanciacion"<?php echo $registro->Sindrome_Emanciacion->CellAttributes() ?>>
<span id="el_registro_Sindrome_Emanciacion" data-page="8">
<span<?php echo $registro->Sindrome_Emanciacion->ViewAttributes() ?>>
<?php echo $registro->Sindrome_Emanciacion->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Encefalopatia->Visible) { // Encefalopatia ?>
	<tr id="r_Encefalopatia">
		<td><span id="elh_registro_Encefalopatia"><?php echo $registro->Encefalopatia->FldCaption() ?></span></td>
		<td data-name="Encefalopatia"<?php echo $registro->Encefalopatia->CellAttributes() ?>>
<span id="el_registro_Encefalopatia" data-page="8">
<span<?php echo $registro->Encefalopatia->ViewAttributes() ?>>
<?php echo $registro->Encefalopatia->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Otras_micobacterias->Visible) { // Otras_micobacterias ?>
	<tr id="r_Otras_micobacterias">
		<td><span id="elh_registro_Otras_micobacterias"><?php echo $registro->Otras_micobacterias->FldCaption() ?></span></td>
		<td data-name="Otras_micobacterias"<?php echo $registro->Otras_micobacterias->CellAttributes() ?>>
<span id="el_registro_Otras_micobacterias" data-page="8">
<span<?php echo $registro->Otras_micobacterias->ViewAttributes() ?>>
<?php echo $registro->Otras_micobacterias->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Histoplasmosis_Extrapulmonar->Visible) { // Histoplasmosis_Extrapulmonar ?>
	<tr id="r_Histoplasmosis_Extrapulmonar">
		<td><span id="elh_registro_Histoplasmosis_Extrapulmonar"><?php echo $registro->Histoplasmosis_Extrapulmonar->FldCaption() ?></span></td>
		<td data-name="Histoplasmosis_Extrapulmonar"<?php echo $registro->Histoplasmosis_Extrapulmonar->CellAttributes() ?>>
<span id="el_registro_Histoplasmosis_Extrapulmonar" data-page="8">
<span<?php echo $registro->Histoplasmosis_Extrapulmonar->ViewAttributes() ?>>
<?php echo $registro->Histoplasmosis_Extrapulmonar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->isosporidiasis_cronica->Visible) { // isosporidiasis_cronica ?>
	<tr id="r_isosporidiasis_cronica">
		<td><span id="elh_registro_isosporidiasis_cronica"><?php echo $registro->isosporidiasis_cronica->FldCaption() ?></span></td>
		<td data-name="isosporidiasis_cronica"<?php echo $registro->isosporidiasis_cronica->CellAttributes() ?>>
<span id="el_registro_isosporidiasis_cronica" data-page="8">
<span<?php echo $registro->isosporidiasis_cronica->ViewAttributes() ?>>
<?php echo $registro->isosporidiasis_cronica->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->herpes_zoster->Visible) { // herpes_zoster ?>
	<tr id="r_herpes_zoster">
		<td><span id="elh_registro_herpes_zoster"><?php echo $registro->herpes_zoster->FldCaption() ?></span></td>
		<td data-name="herpes_zoster"<?php echo $registro->herpes_zoster->CellAttributes() ?>>
<span id="el_registro_herpes_zoster" data-page="8">
<span<?php echo $registro->herpes_zoster->ViewAttributes() ?>>
<?php echo $registro->herpes_zoster->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Histoplasmosis_diseminada->Visible) { // Histoplasmosis_diseminada ?>
	<tr id="r_Histoplasmosis_diseminada">
		<td><span id="elh_registro_Histoplasmosis_diseminada"><?php echo $registro->Histoplasmosis_diseminada->FldCaption() ?></span></td>
		<td data-name="Histoplasmosis_diseminada"<?php echo $registro->Histoplasmosis_diseminada->CellAttributes() ?>>
<span id="el_registro_Histoplasmosis_diseminada" data-page="8">
<span<?php echo $registro->Histoplasmosis_diseminada->ViewAttributes() ?>>
<?php echo $registro->Histoplasmosis_diseminada->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Linfoma_Burkitt->Visible) { // Linfoma_Burkitt ?>
	<tr id="r_Linfoma_Burkitt">
		<td><span id="elh_registro_Linfoma_Burkitt"><?php echo $registro->Linfoma_Burkitt->FldCaption() ?></span></td>
		<td data-name="Linfoma_Burkitt"<?php echo $registro->Linfoma_Burkitt->CellAttributes() ?>>
<span id="el_registro_Linfoma_Burkitt" data-page="8">
<span<?php echo $registro->Linfoma_Burkitt->ViewAttributes() ?>>
<?php echo $registro->Linfoma_Burkitt->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Neumonia_Pneumocystis->Visible) { // Neumonia_Pneumocystis ?>
	<tr id="r_Neumonia_Pneumocystis">
		<td><span id="elh_registro_Neumonia_Pneumocystis"><?php echo $registro->Neumonia_Pneumocystis->FldCaption() ?></span></td>
		<td data-name="Neumonia_Pneumocystis"<?php echo $registro->Neumonia_Pneumocystis->CellAttributes() ?>>
<span id="el_registro_Neumonia_Pneumocystis" data-page="8">
<span<?php echo $registro->Neumonia_Pneumocystis->ViewAttributes() ?>>
<?php echo $registro->Neumonia_Pneumocystis->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Neumonia_Recurrente->Visible) { // Neumonia_Recurrente ?>
	<tr id="r_Neumonia_Recurrente">
		<td><span id="elh_registro_Neumonia_Recurrente"><?php echo $registro->Neumonia_Recurrente->FldCaption() ?></span></td>
		<td data-name="Neumonia_Recurrente"<?php echo $registro->Neumonia_Recurrente->CellAttributes() ?>>
<span id="el_registro_Neumonia_Recurrente" data-page="8">
<span<?php echo $registro->Neumonia_Recurrente->ViewAttributes() ?>>
<?php echo $registro->Neumonia_Recurrente->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Linfoma_Inmunoblastico->Visible) { // Linfoma_Inmunoblastico ?>
	<tr id="r_Linfoma_Inmunoblastico">
		<td><span id="elh_registro_Linfoma_Inmunoblastico"><?php echo $registro->Linfoma_Inmunoblastico->FldCaption() ?></span></td>
		<td data-name="Linfoma_Inmunoblastico"<?php echo $registro->Linfoma_Inmunoblastico->CellAttributes() ?>>
<span id="el_registro_Linfoma_Inmunoblastico" data-page="8">
<span<?php echo $registro->Linfoma_Inmunoblastico->ViewAttributes() ?>>
<?php echo $registro->Linfoma_Inmunoblastico->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Criptosporidiasis_cronica->Visible) { // Criptosporidiasis_cronica ?>
	<tr id="r_Criptosporidiasis_cronica">
		<td><span id="elh_registro_Criptosporidiasis_cronica"><?php echo $registro->Criptosporidiasis_cronica->FldCaption() ?></span></td>
		<td data-name="Criptosporidiasis_cronica"<?php echo $registro->Criptosporidiasis_cronica->CellAttributes() ?>>
<span id="el_registro_Criptosporidiasis_cronica" data-page="8">
<span<?php echo $registro->Criptosporidiasis_cronica->ViewAttributes() ?>>
<?php echo $registro->Criptosporidiasis_cronica->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Criptococosis_Extrapulmonar->Visible) { // Criptococosis_Extrapulmonar ?>
	<tr id="r_Criptococosis_Extrapulmonar">
		<td><span id="elh_registro_Criptococosis_Extrapulmonar"><?php echo $registro->Criptococosis_Extrapulmonar->FldCaption() ?></span></td>
		<td data-name="Criptococosis_Extrapulmonar"<?php echo $registro->Criptococosis_Extrapulmonar->CellAttributes() ?>>
<span id="el_registro_Criptococosis_Extrapulmonar" data-page="8">
<span<?php echo $registro->Criptococosis_Extrapulmonar->ViewAttributes() ?>>
<?php echo $registro->Criptococosis_Extrapulmonar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Sarcoma_Kaposi->Visible) { // Sarcoma_Kaposi ?>
	<tr id="r_Sarcoma_Kaposi">
		<td><span id="elh_registro_Sarcoma_Kaposi"><?php echo $registro->Sarcoma_Kaposi->FldCaption() ?></span></td>
		<td data-name="Sarcoma_Kaposi"<?php echo $registro->Sarcoma_Kaposi->CellAttributes() ?>>
<span id="el_registro_Sarcoma_Kaposi" data-page="8">
<span<?php echo $registro->Sarcoma_Kaposi->ViewAttributes() ?>>
<?php echo $registro->Sarcoma_Kaposi->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Leucoencefalopatia_Multifocal->Visible) { // Leucoencefalopatia_Multifocal ?>
	<tr id="r_Leucoencefalopatia_Multifocal">
		<td><span id="elh_registro_Leucoencefalopatia_Multifocal"><?php echo $registro->Leucoencefalopatia_Multifocal->FldCaption() ?></span></td>
		<td data-name="Leucoencefalopatia_Multifocal"<?php echo $registro->Leucoencefalopatia_Multifocal->CellAttributes() ?>>
<span id="el_registro_Leucoencefalopatia_Multifocal" data-page="8">
<span<?php echo $registro->Leucoencefalopatia_Multifocal->ViewAttributes() ?>>
<?php echo $registro->Leucoencefalopatia_Multifocal->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Septicemia_recurrente->Visible) { // Septicemia_recurrente ?>
	<tr id="r_Septicemia_recurrente">
		<td><span id="elh_registro_Septicemia_recurrente"><?php echo $registro->Septicemia_recurrente->FldCaption() ?></span></td>
		<td data-name="Septicemia_recurrente"<?php echo $registro->Septicemia_recurrente->CellAttributes() ?>>
<span id="el_registro_Septicemia_recurrente" data-page="8">
<span<?php echo $registro->Septicemia_recurrente->ViewAttributes() ?>>
<?php echo $registro->Septicemia_recurrente->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Toxoplasmosis_cerebral->Visible) { // Toxoplasmosis_cerebral ?>
	<tr id="r_Toxoplasmosis_cerebral">
		<td><span id="elh_registro_Toxoplasmosis_cerebral"><?php echo $registro->Toxoplasmosis_cerebral->FldCaption() ?></span></td>
		<td data-name="Toxoplasmosis_cerebral"<?php echo $registro->Toxoplasmosis_cerebral->CellAttributes() ?>>
<span id="el_registro_Toxoplasmosis_cerebral" data-page="8">
<span<?php echo $registro->Toxoplasmosis_cerebral->ViewAttributes() ?>>
<?php echo $registro->Toxoplasmosis_cerebral->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->HepatitisB->Visible) { // HepatitisB ?>
	<tr id="r_HepatitisB">
		<td><span id="elh_registro_HepatitisB"><?php echo $registro->HepatitisB->FldCaption() ?></span></td>
		<td data-name="HepatitisB"<?php echo $registro->HepatitisB->CellAttributes() ?>>
<span id="el_registro_HepatitisB" data-page="8">
<span<?php echo $registro->HepatitisB->ViewAttributes() ?>>
<?php echo $registro->HepatitisB->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->HepatitisC->Visible) { // HepatitisC ?>
	<tr id="r_HepatitisC">
		<td><span id="elh_registro_HepatitisC"><?php echo $registro->HepatitisC->FldCaption() ?></span></td>
		<td data-name="HepatitisC"<?php echo $registro->HepatitisC->CellAttributes() ?>>
<span id="el_registro_HepatitisC" data-page="8">
<span<?php echo $registro->HepatitisC->ViewAttributes() ?>>
<?php echo $registro->HepatitisC->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->Meningitis->Visible) { // Meningitis ?>
	<tr id="r_Meningitis">
		<td><span id="elh_registro_Meningitis"><?php echo $registro->Meningitis->FldCaption() ?></span></td>
		<td data-name="Meningitis"<?php echo $registro->Meningitis->CellAttributes() ?>>
<span id="el_registro_Meningitis" data-page="8">
<span<?php echo $registro->Meningitis->ViewAttributes() ?>>
<?php echo $registro->Meningitis->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($registro->RecuentoCD4->Visible) { // RecuentoCD4 ?>
	<tr id="r_RecuentoCD4">
		<td><span id="elh_registro_RecuentoCD4"><?php echo $registro->RecuentoCD4->FldCaption() ?></span></td>
		<td data-name="RecuentoCD4"<?php echo $registro->RecuentoCD4->CellAttributes() ?>>
<span id="el_registro_RecuentoCD4" data-page="8">
<span<?php echo $registro->RecuentoCD4->ViewAttributes() ?>>
<?php echo $registro->RecuentoCD4->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($registro->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($registro->Export == "") { ?>
	</div>
</div>
</div>
<?php } ?>
<?php
	if (in_array("seguimiento_individual3", explode(",", $registro->getCurrentDetailTable())) && $seguimiento_individual3->DetailView) {
?>
<?php if ($registro->getCurrentDetailTable() <> "") { ?>
<h4 class="ewDetailCaption"><?php echo $Language->TablePhrase("seguimiento_individual3", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "seguimiento_individual3grid.php" ?>
<?php } ?>
<?php
	if (in_array("seguimiento_materno", explode(",", $registro->getCurrentDetailTable())) && $seguimiento_materno->DetailView) {
?>
<?php if ($registro->getCurrentDetailTable() <> "") { ?>
<h4 class="ewDetailCaption"><?php echo $Language->TablePhrase("seguimiento_materno", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "seguimiento_maternogrid.php" ?>
<?php } ?>
</form>
<?php if ($registro->Export == "") { ?>
<script type="text/javascript">
fregistroview.Init();
</script>
<?php } ?>
<?php
$registro_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($registro->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$registro_view->Page_Terminate();
?>
