<?php

// Global variable for table object
$Consulta_Entidad_Valora = NULL;

//
// Table class for Consulta_Entidad_Valora
//
class cConsulta_Entidad_Valora extends cTable {
	var $Consecutivo;
	var $Entidad_Valora;
	var $Genero;
	var $Peso;
	var $Talla;
	var $Edad_Anos;
	var $Edad_Meses;
	var $Clasificacion_Talla_Edad;
	var $Clasificacion_Peso_Talla;
	var $Clasificacion_P_Cefalico;
	var $Clasificacion_IMC_Edad;
	var $Clasificacion_Peso_Edad;
	var $Entidad_Educativa;
	var $Escolaridad;
	var $Comuna_Zona;
	var $Zona;
	var $Documento;
	var $Tipo_Entidad;
	var $Tipo_Documento;
	var $Fecha_Nacimiento;
	var $Nombres;
	var $Apellidos;
	var $Fecha_valoracion;
	var $Perimetro_Cefalico;
	var $Perimetro_Abdominal;
	var $DS_TallaEdad;
	var $IMC;
	var $DS_PesoTalla;
	var $DS_IMCEdad;
	var $DS_PesoEdad;
	var $DS_PCEdad;
	var $Superficie_Corporal;
	var $Barrio_Vereda;
	var $Grupo_Etnico;
	var $Tipo_Regimen;
	var $EPS;
	var $Condicion_Discapacidad;
	var $Condicion_Desplazamiento;
	var $Clasificado;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'Consulta_Entidad_Valora';
		$this->TableName = 'Consulta_Entidad_Valora';
		$this->TableType = 'CUSTOMVIEW';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = ew_AllowAddDeleteRow(); // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// Consecutivo
		$this->Consecutivo = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Consecutivo', 'Consecutivo', 'nutricion_valoracion.Consecutivo', 'nutricion_valoracion.Consecutivo', 19, -1, FALSE, 'nutricion_valoracion.Consecutivo', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Consecutivo->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Consecutivo'] = &$this->Consecutivo;

		// Entidad_Valora
		$this->Entidad_Valora = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Entidad_Valora', 'Entidad_Valora', 'nutricion_valoracion.Entidad_Valora', 'nutricion_valoracion.Entidad_Valora', 19, -1, FALSE, 'nutricion_valoracion.Entidad_Valora', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Entidad_Valora->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Entidad_Valora'] = &$this->Entidad_Valora;

		// Genero
		$this->Genero = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Genero', 'Genero', 'nutricion_valoracion.Genero', 'nutricion_valoracion.Genero', 19, -1, FALSE, 'nutricion_valoracion.Genero', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Genero->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Genero'] = &$this->Genero;

		// Peso
		$this->Peso = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Peso', 'Peso', 'nutricion_valoracion.Peso', 'nutricion_valoracion.Peso', 5, -1, FALSE, 'nutricion_valoracion.Peso', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Peso->FldDefaultErrMsg = str_replace(array("%1", "%2"), array("2", "200"), $Language->Phrase("IncorrectRange"));
		$this->fields['Peso'] = &$this->Peso;

		// Talla
		$this->Talla = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Talla', 'Talla', 'nutricion_valoracion.Talla', 'nutricion_valoracion.Talla', 5, -1, FALSE, 'nutricion_valoracion.Talla', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Talla->FldDefaultErrMsg = str_replace(array("%1", "%2"), array("30", "200"), $Language->Phrase("IncorrectRange"));
		$this->fields['Talla'] = &$this->Talla;

		// Edad_Anos
		$this->Edad_Anos = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Edad_Anos', 'Edad_Anos', 'nutricion_valoracion.Edad_Anos', 'nutricion_valoracion.Edad_Anos', 19, -1, FALSE, 'nutricion_valoracion.Edad_Anos', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Edad_Anos->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Edad_Anos'] = &$this->Edad_Anos;

		// Edad_Meses
		$this->Edad_Meses = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Edad_Meses', 'Edad_Meses', 'nutricion_valoracion.Edad_Meses', 'nutricion_valoracion.Edad_Meses', 19, -1, FALSE, 'nutricion_valoracion.Edad_Meses', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Edad_Meses->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Edad_Meses'] = &$this->Edad_Meses;

		// Clasificacion_Talla_Edad
		$this->Clasificacion_Talla_Edad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Clasificacion_Talla_Edad', 'Clasificacion_Talla_Edad', 'nutricion_valoracion.Clasificacion_Talla_Edad', 'nutricion_valoracion.Clasificacion_Talla_Edad', 200, -1, FALSE, 'nutricion_valoracion.Clasificacion_Talla_Edad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_Talla_Edad'] = &$this->Clasificacion_Talla_Edad;

		// Clasificacion_Peso_Talla
		$this->Clasificacion_Peso_Talla = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Clasificacion_Peso_Talla', 'Clasificacion_Peso_Talla', 'nutricion_valoracion.Clasificacion_Peso_Talla', 'nutricion_valoracion.Clasificacion_Peso_Talla', 200, -1, FALSE, 'nutricion_valoracion.Clasificacion_Peso_Talla', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_Peso_Talla'] = &$this->Clasificacion_Peso_Talla;

		// Clasificacion_P_Cefalico
		$this->Clasificacion_P_Cefalico = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Clasificacion_P_Cefalico', 'Clasificacion_P_Cefalico', 'nutricion_valoracion.Clasificacion_P_Cefalico', 'nutricion_valoracion.Clasificacion_P_Cefalico', 200, -1, FALSE, 'nutricion_valoracion.Clasificacion_P_Cefalico', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_P_Cefalico'] = &$this->Clasificacion_P_Cefalico;

		// Clasificacion_IMC_Edad
		$this->Clasificacion_IMC_Edad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Clasificacion_IMC_Edad', 'Clasificacion_IMC_Edad', 'nutricion_valoracion.Clasificacion_IMC_Edad', 'nutricion_valoracion.Clasificacion_IMC_Edad', 200, -1, FALSE, 'nutricion_valoracion.Clasificacion_IMC_Edad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_IMC_Edad'] = &$this->Clasificacion_IMC_Edad;

		// Clasificacion_Peso_Edad
		$this->Clasificacion_Peso_Edad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Clasificacion_Peso_Edad', 'Clasificacion_Peso_Edad', 'nutricion_valoracion.Clasificacion_Peso_Edad', 'nutricion_valoracion.Clasificacion_Peso_Edad', 200, -1, FALSE, 'nutricion_valoracion.Clasificacion_Peso_Edad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_Peso_Edad'] = &$this->Clasificacion_Peso_Edad;

		// Entidad_Educativa
		$this->Entidad_Educativa = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Entidad_Educativa', 'Entidad_Educativa', 'nutricion_valoracion.Entidad_Educativa', 'nutricion_valoracion.Entidad_Educativa', 19, -1, FALSE, 'nutricion_valoracion.Entidad_Educativa', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Entidad_Educativa->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Entidad_Educativa'] = &$this->Entidad_Educativa;

		// Escolaridad
		$this->Escolaridad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Escolaridad', 'Escolaridad', 'nutricion_valoracion.Escolaridad', 'nutricion_valoracion.Escolaridad', 19, -1, FALSE, 'nutricion_valoracion.Escolaridad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Escolaridad->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Escolaridad'] = &$this->Escolaridad;

		// Comuna_Zona
		$this->Comuna_Zona = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Comuna_Zona', 'Comuna_Zona', 'nutricion_valoracion.Comuna_Zona', 'nutricion_valoracion.Comuna_Zona', 19, -1, FALSE, 'nutricion_valoracion.Comuna_Zona', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Comuna_Zona->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Comuna_Zona'] = &$this->Comuna_Zona;

		// Zona
		$this->Zona = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Zona', 'Zona', 'nutricion_valoracion.Zona', 'nutricion_valoracion.Zona', 19, -1, FALSE, 'nutricion_valoracion.Zona', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Zona->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Zona'] = &$this->Zona;

		// Documento
		$this->Documento = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Documento', 'Documento', 'nutricion_valoracion.Documento', 'nutricion_valoracion.Documento', 200, -1, FALSE, 'nutricion_valoracion.Documento', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Documento'] = &$this->Documento;

		// Tipo_Entidad
		$this->Tipo_Entidad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Tipo_Entidad', 'Tipo_Entidad', 'nutricion_valoracion.Tipo_Entidad', 'nutricion_valoracion.Tipo_Entidad', 19, -1, FALSE, 'nutricion_valoracion.Tipo_Entidad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Tipo_Entidad->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Tipo_Entidad'] = &$this->Tipo_Entidad;

		// Tipo_Documento
		$this->Tipo_Documento = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Tipo_Documento', 'Tipo_Documento', 'nutricion_valoracion.Tipo_Documento', 'nutricion_valoracion.Tipo_Documento', 19, -1, FALSE, 'nutricion_valoracion.Tipo_Documento', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Tipo_Documento->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Tipo_Documento'] = &$this->Tipo_Documento;

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Fecha_Nacimiento', 'Fecha_Nacimiento', 'nutricion_valoracion.Fecha_Nacimiento', 'DATE_FORMAT(nutricion_valoracion.Fecha_Nacimiento, \'%d/%m/%Y\')', 133, 7, FALSE, 'nutricion_valoracion.Fecha_Nacimiento', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Fecha_Nacimiento->FldDefaultErrMsg = str_replace("%s", "/", $Language->Phrase("IncorrectDateDMY"));
		$this->fields['Fecha_Nacimiento'] = &$this->Fecha_Nacimiento;

		// Nombres
		$this->Nombres = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Nombres', 'Nombres', 'nutricion_valoracion.Nombres', 'nutricion_valoracion.Nombres', 200, -1, FALSE, 'nutricion_valoracion.Nombres', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Nombres'] = &$this->Nombres;

		// Apellidos
		$this->Apellidos = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Apellidos', 'Apellidos', 'nutricion_valoracion.Apellidos', 'nutricion_valoracion.Apellidos', 200, -1, FALSE, 'nutricion_valoracion.Apellidos', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Apellidos'] = &$this->Apellidos;

		// Fecha_valoracion
		$this->Fecha_valoracion = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Fecha_valoracion', 'Fecha_valoracion', 'nutricion_valoracion.Fecha_valoracion', 'DATE_FORMAT(nutricion_valoracion.Fecha_valoracion, \'%d/%m/%Y\')', 133, 7, FALSE, 'nutricion_valoracion.Fecha_valoracion', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Fecha_valoracion->FldDefaultErrMsg = str_replace("%s", "/", $Language->Phrase("IncorrectDateDMY"));
		$this->fields['Fecha_valoracion'] = &$this->Fecha_valoracion;

		// Perimetro_Cefalico
		$this->Perimetro_Cefalico = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Perimetro_Cefalico', 'Perimetro_Cefalico', 'nutricion_valoracion.Perimetro_Cefalico', 'nutricion_valoracion.Perimetro_Cefalico', 5, -1, FALSE, 'nutricion_valoracion.Perimetro_Cefalico', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Perimetro_Cefalico->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['Perimetro_Cefalico'] = &$this->Perimetro_Cefalico;

		// Perimetro_Abdominal
		$this->Perimetro_Abdominal = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Perimetro_Abdominal', 'Perimetro_Abdominal', 'nutricion_valoracion.Perimetro_Abdominal', 'nutricion_valoracion.Perimetro_Abdominal', 5, -1, FALSE, 'nutricion_valoracion.Perimetro_Abdominal', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Perimetro_Abdominal->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['Perimetro_Abdominal'] = &$this->Perimetro_Abdominal;

		// DS_TallaEdad
		$this->DS_TallaEdad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_DS_TallaEdad', 'DS_TallaEdad', 'nutricion_valoracion.DS_TallaEdad', 'nutricion_valoracion.DS_TallaEdad', 4, -1, FALSE, 'nutricion_valoracion.DS_TallaEdad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_TallaEdad->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_TallaEdad'] = &$this->DS_TallaEdad;

		// IMC
		$this->IMC = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_IMC', 'IMC', 'nutricion_valoracion.IMC', 'nutricion_valoracion.IMC', 4, -1, FALSE, 'nutricion_valoracion.IMC', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->IMC->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['IMC'] = &$this->IMC;

		// DS_PesoTalla
		$this->DS_PesoTalla = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_DS_PesoTalla', 'DS_PesoTalla', 'nutricion_valoracion.DS_PesoTalla', 'nutricion_valoracion.DS_PesoTalla', 4, -1, FALSE, 'nutricion_valoracion.DS_PesoTalla', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_PesoTalla->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_PesoTalla'] = &$this->DS_PesoTalla;

		// DS_IMCEdad
		$this->DS_IMCEdad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_DS_IMCEdad', 'DS_IMCEdad', 'nutricion_valoracion.DS_IMCEdad', 'nutricion_valoracion.DS_IMCEdad', 4, -1, FALSE, 'nutricion_valoracion.DS_IMCEdad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_IMCEdad->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_IMCEdad'] = &$this->DS_IMCEdad;

		// DS_PesoEdad
		$this->DS_PesoEdad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_DS_PesoEdad', 'DS_PesoEdad', 'nutricion_valoracion.DS_PesoEdad', 'nutricion_valoracion.DS_PesoEdad', 4, -1, FALSE, 'nutricion_valoracion.DS_PesoEdad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_PesoEdad->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_PesoEdad'] = &$this->DS_PesoEdad;

		// DS_PCEdad
		$this->DS_PCEdad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_DS_PCEdad', 'DS_PCEdad', 'nutricion_valoracion.DS_PCEdad', 'nutricion_valoracion.DS_PCEdad', 4, -1, FALSE, 'nutricion_valoracion.DS_PCEdad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_PCEdad->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_PCEdad'] = &$this->DS_PCEdad;

		// Superficie_Corporal
		$this->Superficie_Corporal = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Superficie_Corporal', 'Superficie_Corporal', 'nutricion_valoracion.Superficie_Corporal', 'nutricion_valoracion.Superficie_Corporal', 5, -1, FALSE, 'nutricion_valoracion.Superficie_Corporal', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Superficie_Corporal->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['Superficie_Corporal'] = &$this->Superficie_Corporal;

		// Barrio_Vereda
		$this->Barrio_Vereda = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Barrio_Vereda', 'Barrio_Vereda', 'nutricion_valoracion.Barrio_Vereda', 'nutricion_valoracion.Barrio_Vereda', 19, -1, FALSE, 'nutricion_valoracion.Barrio_Vereda', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Barrio_Vereda->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Barrio_Vereda'] = &$this->Barrio_Vereda;

		// Grupo_Etnico
		$this->Grupo_Etnico = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Grupo_Etnico', 'Grupo_Etnico', 'nutricion_valoracion.Grupo_Etnico', 'nutricion_valoracion.Grupo_Etnico', 19, -1, FALSE, 'nutricion_valoracion.Grupo_Etnico', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Grupo_Etnico->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Grupo_Etnico'] = &$this->Grupo_Etnico;

		// Tipo_Regimen
		$this->Tipo_Regimen = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Tipo_Regimen', 'Tipo_Regimen', 'nutricion_valoracion.Tipo_Regimen', 'nutricion_valoracion.Tipo_Regimen', 19, -1, FALSE, 'nutricion_valoracion.Tipo_Regimen', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Tipo_Regimen->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Tipo_Regimen'] = &$this->Tipo_Regimen;

		// EPS
		$this->EPS = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_EPS', 'EPS', 'nutricion_valoracion.EPS', 'nutricion_valoracion.EPS', 19, -1, FALSE, 'nutricion_valoracion.EPS', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->EPS->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['EPS'] = &$this->EPS;

		// Condicion_Discapacidad
		$this->Condicion_Discapacidad = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Condicion_Discapacidad', 'Condicion_Discapacidad', 'nutricion_valoracion.Condicion_Discapacidad', 'nutricion_valoracion.Condicion_Discapacidad', 16, -1, FALSE, 'nutricion_valoracion.Condicion_Discapacidad', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Condicion_Discapacidad->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Condicion_Discapacidad'] = &$this->Condicion_Discapacidad;

		// Condicion_Desplazamiento
		$this->Condicion_Desplazamiento = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Condicion_Desplazamiento', 'Condicion_Desplazamiento', 'nutricion_valoracion.Condicion_Desplazamiento', 'nutricion_valoracion.Condicion_Desplazamiento', 16, -1, FALSE, 'nutricion_valoracion.Condicion_Desplazamiento', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Condicion_Desplazamiento->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Condicion_Desplazamiento'] = &$this->Condicion_Desplazamiento;

		// Clasificado
		$this->Clasificado = new cField('Consulta_Entidad_Valora', 'Consulta_Entidad_Valora', 'x_Clasificado', 'Clasificado', 'nutricion_valoracion.Clasificado', 'nutricion_valoracion.Clasificado', 16, -1, FALSE, 'nutricion_valoracion.Clasificado', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Clasificado->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Clasificado'] = &$this->Clasificado;
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	function SqlFrom() { // From
		return "nutricion_valoracion";
	}

	function SqlSelect() { // Select
		return "SELECT nutricion_valoracion.Genero, nutricion_valoracion.Clasificacion_Talla_Edad, nutricion_valoracion.Clasificacion_Peso_Talla, nutricion_valoracion.Clasificacion_P_Cefalico, nutricion_valoracion.Clasificacion_IMC_Edad, nutricion_valoracion.Clasificacion_Peso_Edad, nutricion_valoracion.Peso, nutricion_valoracion.Talla, nutricion_valoracion.Edad_Anos, nutricion_valoracion.Edad_Meses, nutricion_valoracion.Consecutivo, nutricion_valoracion.Entidad_Valora, nutricion_valoracion.Entidad_Educativa, nutricion_valoracion.Escolaridad, nutricion_valoracion.Comuna_Zona, nutricion_valoracion.Zona, nutricion_valoracion.Documento, nutricion_valoracion.Tipo_Entidad, nutricion_valoracion.Tipo_Documento, nutricion_valoracion.Fecha_Nacimiento, nutricion_valoracion.Nombres, nutricion_valoracion.Apellidos, nutricion_valoracion.Fecha_valoracion, nutricion_valoracion.Perimetro_Cefalico, nutricion_valoracion.Perimetro_Abdominal, nutricion_valoracion.DS_TallaEdad, nutricion_valoracion.IMC, nutricion_valoracion.DS_PesoTalla, nutricion_valoracion.DS_IMCEdad, nutricion_valoracion.DS_PesoEdad, nutricion_valoracion.DS_PCEdad, nutricion_valoracion.Superficie_Corporal, nutricion_valoracion.Barrio_Vereda, nutricion_valoracion.Grupo_Etnico, nutricion_valoracion.Tipo_Regimen, nutricion_valoracion.EPS, nutricion_valoracion.Condicion_Discapacidad, nutricion_valoracion.Condicion_Desplazamiento, nutricion_valoracion.Clasificado FROM " . $this->SqlFrom();
	}

	function SqlWhere() { // Where
		$sWhere = "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlGroupBy() { // Group By
		return "";
	}

	function SqlHaving() { // Having
		return "";
	}

	function SqlOrderBy() { // Order By
		return "";
	}

	// Check if Anonymous User is allowed
	function AllowAnonymousUser() {
		switch (@$this->PageID) {
			case "add":
			case "register":
			case "addopt":
				return FALSE;
			case "edit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return FALSE;
			case "delete":
				return FALSE;
			case "view":
				return FALSE;
			case "search":
				return FALSE;
			default:
				return FALSE;
		}
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(),
			$this->SqlGroupBy(), $this->SqlHaving(), $this->SqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$sFilter = $this->CurrentFilter;
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(),
			$this->SqlGroupBy(), $this->SqlHaving(), $this->SqlOrderBy(),
			$sFilter, $sSort);
	}

	// Table SQL with List page filter
	function SelectSQL() {
		$sFilter = $this->getSessionWhere();
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(), $this->SqlGroupBy(),
			$this->SqlHaving(), $this->SqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->SqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sSql) {
		global $conn;
		$cnt = -1;
		if ($this->TableType == 'TABLE' || $this->TableType == 'VIEW') {
			$sSql = "SELECT COUNT(*) FROM" . preg_replace('/^SELECT\s([\s\S]+)?\*\sFROM/i', "", $sSql);
			$sOrderBy = $this->GetOrderBy();
			if (substr($sSql, strlen($sOrderBy) * -1) == $sOrderBy)
				$sSql = substr($sSql, 0, strlen($sSql) - strlen($sOrderBy)); // Remove ORDER BY clause
		} else {
			$sSql = "SELECT COUNT(*) FROM (" . $sSql . ") EW_COUNT_TABLE";
		}
		if ($rs = $conn->Execute($sSql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($sFilter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $sFilter;
		$this->Recordset_Selecting($this->CurrentFilter);

		//$sSql = $this->SQL();
		$sSql = $this->GetSQL($this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function SelectRecordCount() {
		global $conn;
		$origFilter = $this->CurrentFilter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$sSql = $this->SelectSQL();
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $conn->Execute($sSql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Update Table
	var $UpdateTable = "nutricion_valoracion";

	// INSERT statement
	function InsertSQL(&$rs) {
		global $conn;
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]))
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType) . ",";
		}
		while (substr($names, -1) == ",")
			$names = substr($names, 0, -1);
		while (substr($values, -1) == ",")
			$values = substr($values, 0, -1);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		global $conn;
		return $conn->Execute($this->InsertSQL($rs));
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "") {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]))
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType) . ",";
		}
		while (substr($sql, -1) == ",")
			$sql = substr($sql, 0, -1);
		$filter = $this->CurrentFilter;
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL) {
		global $conn;
		return $conn->Execute($this->UpdateSQL($rs, $where));
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "") {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if ($rs) {
			if (array_key_exists('Consecutivo', $rs))
				ew_AddFilter($where, ew_QuotedName('Consecutivo') . '=' . ew_QuotedValue($rs['Consecutivo'], $this->Consecutivo->FldDataType));
		}
		$filter = $this->CurrentFilter;
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "") {
		global $conn;
		return $conn->Execute($this->DeleteSQL($rs, $where));
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "nutricion_valoracion.Consecutivo = @Consecutivo@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->Consecutivo->CurrentValue))
			$sKeyFilter = "0=1"; // Invalid key
		$sKeyFilter = str_replace("@Consecutivo@", ew_AdjustSql($this->Consecutivo->CurrentValue), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "Consulta_Entidad_Valoralist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// List URL
	function GetListUrl() {
		return "Consulta_Entidad_Valoralist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			return $this->KeyUrl("Consulta_Entidad_Valoraview.php", $this->UrlParm($parm));
		else
			return $this->KeyUrl("Consulta_Entidad_Valoraview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
	}

	// Add URL
	function GetAddUrl() {
		return "Consulta_Entidad_Valoraadd.php";
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		return $this->KeyUrl("Consulta_Entidad_Valoraedit.php", $this->UrlParm($parm));
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		return $this->KeyUrl("Consulta_Entidad_Valoraadd.php", $this->UrlParm($parm));
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("Consulta_Entidad_Valoradelete.php", $this->UrlParm());
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->Consecutivo->CurrentValue)) {
			$sUrl .= "Consecutivo=" . urlencode($this->Consecutivo->CurrentValue);
		} else {
			return "javascript:alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return ew_CurrentPage() . "?" . $sUrlParm;
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = ew_StripSlashes($_POST["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = ew_StripSlashes($_GET["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET)) {
			$arKeys[] = @$_GET["Consecutivo"]; // Consecutivo

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		foreach ($arKeys as $key) {
			if (!is_numeric($key))
				continue;
			$ar[] = $key;
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->Consecutivo->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($sFilter) {
		global $conn;

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $sFilter;
		//$sSql = $this->SQL();

		$sSql = $this->GetSQL($sFilter, "");
		$rs = $conn->Execute($sSql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Entidad_Valora->setDbValue($rs->fields('Entidad_Valora'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->Peso->setDbValue($rs->fields('Peso'));
		$this->Talla->setDbValue($rs->fields('Talla'));
		$this->Edad_Anos->setDbValue($rs->fields('Edad_Anos'));
		$this->Edad_Meses->setDbValue($rs->fields('Edad_Meses'));
		$this->Clasificacion_Talla_Edad->setDbValue($rs->fields('Clasificacion_Talla_Edad'));
		$this->Clasificacion_Peso_Talla->setDbValue($rs->fields('Clasificacion_Peso_Talla'));
		$this->Clasificacion_P_Cefalico->setDbValue($rs->fields('Clasificacion_P_Cefalico'));
		$this->Clasificacion_IMC_Edad->setDbValue($rs->fields('Clasificacion_IMC_Edad'));
		$this->Clasificacion_Peso_Edad->setDbValue($rs->fields('Clasificacion_Peso_Edad'));
		$this->Entidad_Educativa->setDbValue($rs->fields('Entidad_Educativa'));
		$this->Escolaridad->setDbValue($rs->fields('Escolaridad'));
		$this->Comuna_Zona->setDbValue($rs->fields('Comuna_Zona'));
		$this->Zona->setDbValue($rs->fields('Zona'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Tipo_Entidad->setDbValue($rs->fields('Tipo_Entidad'));
		$this->Tipo_Documento->setDbValue($rs->fields('Tipo_Documento'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Fecha_valoracion->setDbValue($rs->fields('Fecha_valoracion'));
		$this->Perimetro_Cefalico->setDbValue($rs->fields('Perimetro_Cefalico'));
		$this->Perimetro_Abdominal->setDbValue($rs->fields('Perimetro_Abdominal'));
		$this->DS_TallaEdad->setDbValue($rs->fields('DS_TallaEdad'));
		$this->IMC->setDbValue($rs->fields('IMC'));
		$this->DS_PesoTalla->setDbValue($rs->fields('DS_PesoTalla'));
		$this->DS_IMCEdad->setDbValue($rs->fields('DS_IMCEdad'));
		$this->DS_PesoEdad->setDbValue($rs->fields('DS_PesoEdad'));
		$this->DS_PCEdad->setDbValue($rs->fields('DS_PCEdad'));
		$this->Superficie_Corporal->setDbValue($rs->fields('Superficie_Corporal'));
		$this->Barrio_Vereda->setDbValue($rs->fields('Barrio_Vereda'));
		$this->Grupo_Etnico->setDbValue($rs->fields('Grupo_Etnico'));
		$this->Tipo_Regimen->setDbValue($rs->fields('Tipo_Regimen'));
		$this->EPS->setDbValue($rs->fields('EPS'));
		$this->Condicion_Discapacidad->setDbValue($rs->fields('Condicion_Discapacidad'));
		$this->Condicion_Desplazamiento->setDbValue($rs->fields('Condicion_Desplazamiento'));
		$this->Clasificado->setDbValue($rs->fields('Clasificado'));
	}

	// Render list row values
	function RenderListRow() {
		global $conn, $Security, $gsLanguage;

		// Call Row Rendering event
		$this->Row_Rendering();

   // Common render codes
		// Consecutivo
		// Entidad_Valora
		// Genero
		// Peso
		// Talla
		// Edad_Anos
		// Edad_Meses
		// Clasificacion_Talla_Edad
		// Clasificacion_Peso_Talla
		// Clasificacion_P_Cefalico
		// Clasificacion_IMC_Edad
		// Clasificacion_Peso_Edad
		// Entidad_Educativa
		// Escolaridad
		// Comuna_Zona
		// Zona
		// Documento
		// Tipo_Entidad
		// Tipo_Documento
		// Fecha_Nacimiento
		// Nombres
		// Apellidos
		// Fecha_valoracion
		// Perimetro_Cefalico
		// Perimetro_Abdominal
		// DS_TallaEdad
		// IMC
		// DS_PesoTalla
		// DS_IMCEdad
		// DS_PesoEdad
		// DS_PCEdad
		// Superficie_Corporal
		// Barrio_Vereda
		// Grupo_Etnico
		// Tipo_Regimen
		// EPS
		// Condicion_Discapacidad
		// Condicion_Desplazamiento
		// Clasificado
		// Consecutivo

		$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
		$this->Consecutivo->ViewCustomAttributes = "";

		// Entidad_Valora
		if (strval($this->Entidad_Valora->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Entidad_Valora->CurrentValue, EW_DATATYPE_NUMBER);
		$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
		$sWhereWrk = "";
		$lookuptblfilter = "`Activa`=1";
		if (strval($lookuptblfilter) <> "") {
			ew_AddFilter($sWhereWrk, $lookuptblfilter);
		}
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Entidad_Valora, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Entidad`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Entidad_Valora->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Entidad_Valora->ViewValue = $this->Entidad_Valora->CurrentValue;
			}
		} else {
			$this->Entidad_Valora->ViewValue = NULL;
		}
		$this->Entidad_Valora->ViewCustomAttributes = "";

		// Genero
		if (strval($this->Genero->CurrentValue) <> "") {
			$sFilterWrk = "`#`" . ew_SearchString("=", $this->Genero->CurrentValue, EW_DATATYPE_NUMBER);
		$sSqlWrk = "SELECT `#`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_genero`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Genero, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Genero`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Genero->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Genero->ViewValue = $this->Genero->CurrentValue;
			}
		} else {
			$this->Genero->ViewValue = NULL;
		}
		$this->Genero->ViewCustomAttributes = "";

		// Peso
		$this->Peso->ViewValue = $this->Peso->CurrentValue;
		$this->Peso->ViewCustomAttributes = "";

		// Talla
		$this->Talla->ViewValue = $this->Talla->CurrentValue;
		$this->Talla->ViewCustomAttributes = "";

		// Edad_Anos
		$this->Edad_Anos->ViewValue = $this->Edad_Anos->CurrentValue;
		$this->Edad_Anos->ViewCustomAttributes = "";

		// Edad_Meses
		$this->Edad_Meses->ViewValue = $this->Edad_Meses->CurrentValue;
		$this->Edad_Meses->ViewCustomAttributes = "";

		// Clasificacion_Talla_Edad
		if (strval($this->Clasificacion_Talla_Edad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Talla_Edad->CurrentValue, EW_DATATYPE_STRING);
		$sSqlWrk = "SELECT `Id`, `Clasificacion_Talla_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_talla_edad`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Clasificacion_Talla_Edad, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Clasificacion_Talla_Edad->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Clasificacion_Talla_Edad->ViewValue = $this->Clasificacion_Talla_Edad->CurrentValue;
			}
		} else {
			$this->Clasificacion_Talla_Edad->ViewValue = NULL;
		}
		$this->Clasificacion_Talla_Edad->ViewCustomAttributes = "";

		// Clasificacion_Peso_Talla
		if (strval($this->Clasificacion_Peso_Talla->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Peso_Talla->CurrentValue, EW_DATATYPE_STRING);
		$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Talla` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_peso_talla`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Clasificacion_Peso_Talla, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Clasificacion_Peso_Talla->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Clasificacion_Peso_Talla->ViewValue = $this->Clasificacion_Peso_Talla->CurrentValue;
			}
		} else {
			$this->Clasificacion_Peso_Talla->ViewValue = NULL;
		}
		$this->Clasificacion_Peso_Talla->ViewCustomAttributes = "";

		// Clasificacion_P_Cefalico
		if (strval($this->Clasificacion_P_Cefalico->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_P_Cefalico->CurrentValue, EW_DATATYPE_STRING);
		$sSqlWrk = "SELECT `Id`, `Clasificacion_Perimetro_Cefalico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_p_cefalico`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Clasificacion_P_Cefalico, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Clasificacion_P_Cefalico->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Clasificacion_P_Cefalico->ViewValue = $this->Clasificacion_P_Cefalico->CurrentValue;
			}
		} else {
			$this->Clasificacion_P_Cefalico->ViewValue = NULL;
		}
		$this->Clasificacion_P_Cefalico->ViewCustomAttributes = "";

		// Clasificacion_IMC_Edad
		if (strval($this->Clasificacion_IMC_Edad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_IMC_Edad->CurrentValue, EW_DATATYPE_STRING);
		$sSqlWrk = "SELECT `Id`, `Clasificacion_IMC_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_imc_edad`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Clasificacion_IMC_Edad, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Clasificacion_IMC_Edad->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Clasificacion_IMC_Edad->ViewValue = $this->Clasificacion_IMC_Edad->CurrentValue;
			}
		} else {
			$this->Clasificacion_IMC_Edad->ViewValue = NULL;
		}
		$this->Clasificacion_IMC_Edad->ViewCustomAttributes = "";

		// Clasificacion_Peso_Edad
		if (strval($this->Clasificacion_Peso_Edad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Peso_Edad->CurrentValue, EW_DATATYPE_STRING);
		$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_peso_edad`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Clasificacion_Peso_Edad, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Clasificacion_Peso_Edad->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Clasificacion_Peso_Edad->ViewValue = $this->Clasificacion_Peso_Edad->CurrentValue;
			}
		} else {
			$this->Clasificacion_Peso_Edad->ViewValue = NULL;
		}
		$this->Clasificacion_Peso_Edad->ViewCustomAttributes = "";

		// Entidad_Educativa
		if (strval($this->Entidad_Educativa->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad_Educativa->CurrentValue, EW_DATATYPE_NUMBER);
		$sSqlWrk = "SELECT `Id`, `Entidad_Educativa` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_educativa`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Entidad_Educativa, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Entidad_Educativa`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Entidad_Educativa->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Entidad_Educativa->ViewValue = $this->Entidad_Educativa->CurrentValue;
			}
		} else {
			$this->Entidad_Educativa->ViewValue = NULL;
		}
		$this->Entidad_Educativa->ViewCustomAttributes = "";

		// Escolaridad
		if (strval($this->Escolaridad->CurrentValue) <> "") {
			$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Escolaridad->CurrentValue, EW_DATATYPE_NUMBER);
		$sSqlWrk = "SELECT `Consecutivo`, `Grado_Escolar` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_grado_escolar`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Escolaridad, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Grado_Escolar`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Escolaridad->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Escolaridad->ViewValue = $this->Escolaridad->CurrentValue;
			}
		} else {
			$this->Escolaridad->ViewValue = NULL;
		}
		$this->Escolaridad->ViewCustomAttributes = "";

		// Comuna_Zona
		$this->Comuna_Zona->ViewValue = $this->Comuna_Zona->CurrentValue;
		if (strval($this->Comuna_Zona->CurrentValue) <> "") {
			$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Comuna_Zona->CurrentValue, EW_DATATYPE_NUMBER);
		$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `comuna_localidad`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Comuna_Zona, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Comuna_Zona->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Comuna_Zona->ViewValue = $this->Comuna_Zona->CurrentValue;
			}
		} else {
			$this->Comuna_Zona->ViewValue = NULL;
		}
		$this->Comuna_Zona->ViewCustomAttributes = "";

		// Zona
		if (strval($this->Zona->CurrentValue) <> "") {
			$sFilterWrk = "`codigo`" . ew_SearchString("=", $this->Zona->CurrentValue, EW_DATATYPE_NUMBER);
		$sSqlWrk = "SELECT `codigo`, `Zona` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `zona`";
		$sWhereWrk = "";
		if ($sFilterWrk <> "") {
			ew_AddFilter($sWhereWrk, $sFilterWrk);
		}

		// Call Lookup selecting
		$this->Lookup_Selecting($this->Zona, $sWhereWrk);
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->Zona->ViewValue = $rswrk->fields('DispFld');
				$rswrk->Close();
			} else {
				$this->Zona->ViewValue = $this->Zona->CurrentValue;
			}
		} else {
			$this->Zona->ViewValue = NULL;
		}
		$this->Zona->ViewCustomAttributes = "";

		// Documento
		$this->Documento->ViewValue = $this->Documento->CurrentValue;
		$this->Documento->ViewCustomAttributes = "";

		// Tipo_Entidad
		$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->CurrentValue;
		$this->Tipo_Entidad->ViewCustomAttributes = "";

		// Tipo_Documento
		$this->Tipo_Documento->ViewValue = $this->Tipo_Documento->CurrentValue;
		$this->Tipo_Documento->ViewCustomAttributes = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
		$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 7);
		$this->Fecha_Nacimiento->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Fecha_valoracion
		$this->Fecha_valoracion->ViewValue = $this->Fecha_valoracion->CurrentValue;
		$this->Fecha_valoracion->ViewValue = ew_FormatDateTime($this->Fecha_valoracion->ViewValue, 7);
		$this->Fecha_valoracion->ViewCustomAttributes = "";

		// Perimetro_Cefalico
		$this->Perimetro_Cefalico->ViewValue = $this->Perimetro_Cefalico->CurrentValue;
		$this->Perimetro_Cefalico->ViewCustomAttributes = "";

		// Perimetro_Abdominal
		$this->Perimetro_Abdominal->ViewValue = $this->Perimetro_Abdominal->CurrentValue;
		$this->Perimetro_Abdominal->ViewCustomAttributes = "";

		// DS_TallaEdad
		$this->DS_TallaEdad->ViewValue = $this->DS_TallaEdad->CurrentValue;
		$this->DS_TallaEdad->ViewCustomAttributes = "";

		// IMC
		$this->IMC->ViewValue = $this->IMC->CurrentValue;
		$this->IMC->ViewCustomAttributes = "";

		// DS_PesoTalla
		$this->DS_PesoTalla->ViewValue = $this->DS_PesoTalla->CurrentValue;
		$this->DS_PesoTalla->ViewCustomAttributes = "";

		// DS_IMCEdad
		$this->DS_IMCEdad->ViewValue = $this->DS_IMCEdad->CurrentValue;
		$this->DS_IMCEdad->ViewCustomAttributes = "";

		// DS_PesoEdad
		$this->DS_PesoEdad->ViewValue = $this->DS_PesoEdad->CurrentValue;
		$this->DS_PesoEdad->ViewCustomAttributes = "";

		// DS_PCEdad
		$this->DS_PCEdad->ViewValue = $this->DS_PCEdad->CurrentValue;
		$this->DS_PCEdad->ViewCustomAttributes = "";

		// Superficie_Corporal
		$this->Superficie_Corporal->ViewValue = $this->Superficie_Corporal->CurrentValue;
		$this->Superficie_Corporal->ViewCustomAttributes = "";

		// Barrio_Vereda
		$this->Barrio_Vereda->ViewValue = $this->Barrio_Vereda->CurrentValue;
		$this->Barrio_Vereda->ViewCustomAttributes = "";

		// Grupo_Etnico
		$this->Grupo_Etnico->ViewValue = $this->Grupo_Etnico->CurrentValue;
		$this->Grupo_Etnico->ViewCustomAttributes = "";

		// Tipo_Regimen
		$this->Tipo_Regimen->ViewValue = $this->Tipo_Regimen->CurrentValue;
		$this->Tipo_Regimen->ViewCustomAttributes = "";

		// EPS
		$this->EPS->ViewValue = $this->EPS->CurrentValue;
		$this->EPS->ViewCustomAttributes = "";

		// Condicion_Discapacidad
		$this->Condicion_Discapacidad->ViewValue = $this->Condicion_Discapacidad->CurrentValue;
		$this->Condicion_Discapacidad->ViewCustomAttributes = "";

		// Condicion_Desplazamiento
		$this->Condicion_Desplazamiento->ViewValue = $this->Condicion_Desplazamiento->CurrentValue;
		$this->Condicion_Desplazamiento->ViewCustomAttributes = "";

		// Clasificado
		$this->Clasificado->ViewValue = $this->Clasificado->CurrentValue;
		$this->Clasificado->ViewCustomAttributes = "";

		// Consecutivo
		$this->Consecutivo->LinkCustomAttributes = "";
		$this->Consecutivo->HrefValue = "";
		$this->Consecutivo->TooltipValue = "";

		// Entidad_Valora
		$this->Entidad_Valora->LinkCustomAttributes = "";
		$this->Entidad_Valora->HrefValue = "";
		$this->Entidad_Valora->TooltipValue = "";

		// Genero
		$this->Genero->LinkCustomAttributes = "";
		$this->Genero->HrefValue = "";
		$this->Genero->TooltipValue = "";

		// Peso
		$this->Peso->LinkCustomAttributes = "";
		$this->Peso->HrefValue = "";
		$this->Peso->TooltipValue = "";

		// Talla
		$this->Talla->LinkCustomAttributes = "";
		$this->Talla->HrefValue = "";
		$this->Talla->TooltipValue = "";

		// Edad_Anos
		$this->Edad_Anos->LinkCustomAttributes = "";
		$this->Edad_Anos->HrefValue = "";
		$this->Edad_Anos->TooltipValue = "";

		// Edad_Meses
		$this->Edad_Meses->LinkCustomAttributes = "";
		$this->Edad_Meses->HrefValue = "";
		$this->Edad_Meses->TooltipValue = "";

		// Clasificacion_Talla_Edad
		$this->Clasificacion_Talla_Edad->LinkCustomAttributes = "";
		$this->Clasificacion_Talla_Edad->HrefValue = "";
		$this->Clasificacion_Talla_Edad->TooltipValue = "";

		// Clasificacion_Peso_Talla
		$this->Clasificacion_Peso_Talla->LinkCustomAttributes = "";
		$this->Clasificacion_Peso_Talla->HrefValue = "";
		$this->Clasificacion_Peso_Talla->TooltipValue = "";

		// Clasificacion_P_Cefalico
		$this->Clasificacion_P_Cefalico->LinkCustomAttributes = "";
		$this->Clasificacion_P_Cefalico->HrefValue = "";
		$this->Clasificacion_P_Cefalico->TooltipValue = "";

		// Clasificacion_IMC_Edad
		$this->Clasificacion_IMC_Edad->LinkCustomAttributes = "";
		$this->Clasificacion_IMC_Edad->HrefValue = "";
		$this->Clasificacion_IMC_Edad->TooltipValue = "";

		// Clasificacion_Peso_Edad
		$this->Clasificacion_Peso_Edad->LinkCustomAttributes = "";
		$this->Clasificacion_Peso_Edad->HrefValue = "";
		$this->Clasificacion_Peso_Edad->TooltipValue = "";

		// Entidad_Educativa
		$this->Entidad_Educativa->LinkCustomAttributes = "";
		$this->Entidad_Educativa->HrefValue = "";
		$this->Entidad_Educativa->TooltipValue = "";

		// Escolaridad
		$this->Escolaridad->LinkCustomAttributes = "";
		$this->Escolaridad->HrefValue = "";
		$this->Escolaridad->TooltipValue = "";

		// Comuna_Zona
		$this->Comuna_Zona->LinkCustomAttributes = "";
		$this->Comuna_Zona->HrefValue = "";
		$this->Comuna_Zona->TooltipValue = "";

		// Zona
		$this->Zona->LinkCustomAttributes = "";
		$this->Zona->HrefValue = "";
		$this->Zona->TooltipValue = "";

		// Documento
		$this->Documento->LinkCustomAttributes = "";
		$this->Documento->HrefValue = "";
		$this->Documento->TooltipValue = "";

		// Tipo_Entidad
		$this->Tipo_Entidad->LinkCustomAttributes = "";
		$this->Tipo_Entidad->HrefValue = "";
		$this->Tipo_Entidad->TooltipValue = "";

		// Tipo_Documento
		$this->Tipo_Documento->LinkCustomAttributes = "";
		$this->Tipo_Documento->HrefValue = "";
		$this->Tipo_Documento->TooltipValue = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->LinkCustomAttributes = "";
		$this->Fecha_Nacimiento->HrefValue = "";
		$this->Fecha_Nacimiento->TooltipValue = "";

		// Nombres
		$this->Nombres->LinkCustomAttributes = "";
		$this->Nombres->HrefValue = "";
		$this->Nombres->TooltipValue = "";

		// Apellidos
		$this->Apellidos->LinkCustomAttributes = "";
		$this->Apellidos->HrefValue = "";
		$this->Apellidos->TooltipValue = "";

		// Fecha_valoracion
		$this->Fecha_valoracion->LinkCustomAttributes = "";
		$this->Fecha_valoracion->HrefValue = "";
		$this->Fecha_valoracion->TooltipValue = "";

		// Perimetro_Cefalico
		$this->Perimetro_Cefalico->LinkCustomAttributes = "";
		$this->Perimetro_Cefalico->HrefValue = "";
		$this->Perimetro_Cefalico->TooltipValue = "";

		// Perimetro_Abdominal
		$this->Perimetro_Abdominal->LinkCustomAttributes = "";
		$this->Perimetro_Abdominal->HrefValue = "";
		$this->Perimetro_Abdominal->TooltipValue = "";

		// DS_TallaEdad
		$this->DS_TallaEdad->LinkCustomAttributes = "";
		$this->DS_TallaEdad->HrefValue = "";
		$this->DS_TallaEdad->TooltipValue = "";

		// IMC
		$this->IMC->LinkCustomAttributes = "";
		$this->IMC->HrefValue = "";
		$this->IMC->TooltipValue = "";

		// DS_PesoTalla
		$this->DS_PesoTalla->LinkCustomAttributes = "";
		$this->DS_PesoTalla->HrefValue = "";
		$this->DS_PesoTalla->TooltipValue = "";

		// DS_IMCEdad
		$this->DS_IMCEdad->LinkCustomAttributes = "";
		$this->DS_IMCEdad->HrefValue = "";
		$this->DS_IMCEdad->TooltipValue = "";

		// DS_PesoEdad
		$this->DS_PesoEdad->LinkCustomAttributes = "";
		$this->DS_PesoEdad->HrefValue = "";
		$this->DS_PesoEdad->TooltipValue = "";

		// DS_PCEdad
		$this->DS_PCEdad->LinkCustomAttributes = "";
		$this->DS_PCEdad->HrefValue = "";
		$this->DS_PCEdad->TooltipValue = "";

		// Superficie_Corporal
		$this->Superficie_Corporal->LinkCustomAttributes = "";
		$this->Superficie_Corporal->HrefValue = "";
		$this->Superficie_Corporal->TooltipValue = "";

		// Barrio_Vereda
		$this->Barrio_Vereda->LinkCustomAttributes = "";
		$this->Barrio_Vereda->HrefValue = "";
		$this->Barrio_Vereda->TooltipValue = "";

		// Grupo_Etnico
		$this->Grupo_Etnico->LinkCustomAttributes = "";
		$this->Grupo_Etnico->HrefValue = "";
		$this->Grupo_Etnico->TooltipValue = "";

		// Tipo_Regimen
		$this->Tipo_Regimen->LinkCustomAttributes = "";
		$this->Tipo_Regimen->HrefValue = "";
		$this->Tipo_Regimen->TooltipValue = "";

		// EPS
		$this->EPS->LinkCustomAttributes = "";
		$this->EPS->HrefValue = "";
		$this->EPS->TooltipValue = "";

		// Condicion_Discapacidad
		$this->Condicion_Discapacidad->LinkCustomAttributes = "";
		$this->Condicion_Discapacidad->HrefValue = "";
		$this->Condicion_Discapacidad->TooltipValue = "";

		// Condicion_Desplazamiento
		$this->Condicion_Desplazamiento->LinkCustomAttributes = "";
		$this->Condicion_Desplazamiento->HrefValue = "";
		$this->Condicion_Desplazamiento->TooltipValue = "";

		// Clasificado
		$this->Clasificado->LinkCustomAttributes = "";
		$this->Clasificado->HrefValue = "";
		$this->Clasificado->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;

		// Write header
		$Doc->ExportTableHeader();
		if ($Doc->Horizontal) { // Horizontal format, write header
			$Doc->BeginExportRow();
			if ($ExportPageType == "view") {
				if ($this->Entidad_Valora->Exportable) $Doc->ExportCaption($this->Entidad_Valora);
				if ($this->Genero->Exportable) $Doc->ExportCaption($this->Genero);
				if ($this->Peso->Exportable) $Doc->ExportCaption($this->Peso);
				if ($this->Talla->Exportable) $Doc->ExportCaption($this->Talla);
				if ($this->Edad_Anos->Exportable) $Doc->ExportCaption($this->Edad_Anos);
				if ($this->Edad_Meses->Exportable) $Doc->ExportCaption($this->Edad_Meses);
				if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Talla_Edad);
				if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Talla);
				if ($this->Clasificacion_P_Cefalico->Exportable) $Doc->ExportCaption($this->Clasificacion_P_Cefalico);
				if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_IMC_Edad);
				if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Edad);
				if ($this->Entidad_Educativa->Exportable) $Doc->ExportCaption($this->Entidad_Educativa);
				if ($this->Escolaridad->Exportable) $Doc->ExportCaption($this->Escolaridad);
				if ($this->Comuna_Zona->Exportable) $Doc->ExportCaption($this->Comuna_Zona);
				if ($this->Zona->Exportable) $Doc->ExportCaption($this->Zona);
				if ($this->Documento->Exportable) $Doc->ExportCaption($this->Documento);
				if ($this->Tipo_Entidad->Exportable) $Doc->ExportCaption($this->Tipo_Entidad);
				if ($this->Tipo_Documento->Exportable) $Doc->ExportCaption($this->Tipo_Documento);
				if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportCaption($this->Fecha_Nacimiento);
				if ($this->Nombres->Exportable) $Doc->ExportCaption($this->Nombres);
				if ($this->Apellidos->Exportable) $Doc->ExportCaption($this->Apellidos);
				if ($this->Fecha_valoracion->Exportable) $Doc->ExportCaption($this->Fecha_valoracion);
				if ($this->Perimetro_Cefalico->Exportable) $Doc->ExportCaption($this->Perimetro_Cefalico);
				if ($this->Perimetro_Abdominal->Exportable) $Doc->ExportCaption($this->Perimetro_Abdominal);
				if ($this->DS_TallaEdad->Exportable) $Doc->ExportCaption($this->DS_TallaEdad);
				if ($this->IMC->Exportable) $Doc->ExportCaption($this->IMC);
				if ($this->DS_PesoTalla->Exportable) $Doc->ExportCaption($this->DS_PesoTalla);
				if ($this->DS_IMCEdad->Exportable) $Doc->ExportCaption($this->DS_IMCEdad);
				if ($this->DS_PesoEdad->Exportable) $Doc->ExportCaption($this->DS_PesoEdad);
				if ($this->DS_PCEdad->Exportable) $Doc->ExportCaption($this->DS_PCEdad);
				if ($this->Superficie_Corporal->Exportable) $Doc->ExportCaption($this->Superficie_Corporal);
				if ($this->Barrio_Vereda->Exportable) $Doc->ExportCaption($this->Barrio_Vereda);
				if ($this->Grupo_Etnico->Exportable) $Doc->ExportCaption($this->Grupo_Etnico);
				if ($this->Tipo_Regimen->Exportable) $Doc->ExportCaption($this->Tipo_Regimen);
				if ($this->EPS->Exportable) $Doc->ExportCaption($this->EPS);
				if ($this->Condicion_Discapacidad->Exportable) $Doc->ExportCaption($this->Condicion_Discapacidad);
				if ($this->Condicion_Desplazamiento->Exportable) $Doc->ExportCaption($this->Condicion_Desplazamiento);
				if ($this->Clasificado->Exportable) $Doc->ExportCaption($this->Clasificado);
			} else {
				if ($this->Consecutivo->Exportable) $Doc->ExportCaption($this->Consecutivo);
				if ($this->Entidad_Valora->Exportable) $Doc->ExportCaption($this->Entidad_Valora);
				if ($this->Genero->Exportable) $Doc->ExportCaption($this->Genero);
				if ($this->Peso->Exportable) $Doc->ExportCaption($this->Peso);
				if ($this->Talla->Exportable) $Doc->ExportCaption($this->Talla);
				if ($this->Edad_Anos->Exportable) $Doc->ExportCaption($this->Edad_Anos);
				if ($this->Edad_Meses->Exportable) $Doc->ExportCaption($this->Edad_Meses);
				if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Talla_Edad);
				if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Talla);
				if ($this->Clasificacion_P_Cefalico->Exportable) $Doc->ExportCaption($this->Clasificacion_P_Cefalico);
				if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_IMC_Edad);
				if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Edad);
				if ($this->Entidad_Educativa->Exportable) $Doc->ExportCaption($this->Entidad_Educativa);
				if ($this->Escolaridad->Exportable) $Doc->ExportCaption($this->Escolaridad);
				if ($this->Comuna_Zona->Exportable) $Doc->ExportCaption($this->Comuna_Zona);
				if ($this->Zona->Exportable) $Doc->ExportCaption($this->Zona);
				if ($this->Documento->Exportable) $Doc->ExportCaption($this->Documento);
				if ($this->Tipo_Entidad->Exportable) $Doc->ExportCaption($this->Tipo_Entidad);
				if ($this->Tipo_Documento->Exportable) $Doc->ExportCaption($this->Tipo_Documento);
				if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportCaption($this->Fecha_Nacimiento);
				if ($this->Nombres->Exportable) $Doc->ExportCaption($this->Nombres);
				if ($this->Apellidos->Exportable) $Doc->ExportCaption($this->Apellidos);
				if ($this->Fecha_valoracion->Exportable) $Doc->ExportCaption($this->Fecha_valoracion);
				if ($this->Perimetro_Cefalico->Exportable) $Doc->ExportCaption($this->Perimetro_Cefalico);
				if ($this->Perimetro_Abdominal->Exportable) $Doc->ExportCaption($this->Perimetro_Abdominal);
				if ($this->DS_TallaEdad->Exportable) $Doc->ExportCaption($this->DS_TallaEdad);
				if ($this->IMC->Exportable) $Doc->ExportCaption($this->IMC);
				if ($this->DS_PesoTalla->Exportable) $Doc->ExportCaption($this->DS_PesoTalla);
				if ($this->DS_IMCEdad->Exportable) $Doc->ExportCaption($this->DS_IMCEdad);
				if ($this->DS_PesoEdad->Exportable) $Doc->ExportCaption($this->DS_PesoEdad);
				if ($this->DS_PCEdad->Exportable) $Doc->ExportCaption($this->DS_PCEdad);
				if ($this->Superficie_Corporal->Exportable) $Doc->ExportCaption($this->Superficie_Corporal);
				if ($this->Barrio_Vereda->Exportable) $Doc->ExportCaption($this->Barrio_Vereda);
				if ($this->Grupo_Etnico->Exportable) $Doc->ExportCaption($this->Grupo_Etnico);
				if ($this->Tipo_Regimen->Exportable) $Doc->ExportCaption($this->Tipo_Regimen);
				if ($this->EPS->Exportable) $Doc->ExportCaption($this->EPS);
				if ($this->Condicion_Discapacidad->Exportable) $Doc->ExportCaption($this->Condicion_Discapacidad);
				if ($this->Condicion_Desplazamiento->Exportable) $Doc->ExportCaption($this->Condicion_Desplazamiento);
				if ($this->Clasificado->Exportable) $Doc->ExportCaption($this->Clasificado);
			}
			$Doc->EndExportRow();
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
				if ($ExportPageType == "view") {
					if ($this->Entidad_Valora->Exportable) $Doc->ExportField($this->Entidad_Valora);
					if ($this->Genero->Exportable) $Doc->ExportField($this->Genero);
					if ($this->Peso->Exportable) $Doc->ExportField($this->Peso);
					if ($this->Talla->Exportable) $Doc->ExportField($this->Talla);
					if ($this->Edad_Anos->Exportable) $Doc->ExportField($this->Edad_Anos);
					if ($this->Edad_Meses->Exportable) $Doc->ExportField($this->Edad_Meses);
					if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Talla_Edad);
					if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Talla);
					if ($this->Clasificacion_P_Cefalico->Exportable) $Doc->ExportField($this->Clasificacion_P_Cefalico);
					if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportField($this->Clasificacion_IMC_Edad);
					if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Edad);
					if ($this->Entidad_Educativa->Exportable) $Doc->ExportField($this->Entidad_Educativa);
					if ($this->Escolaridad->Exportable) $Doc->ExportField($this->Escolaridad);
					if ($this->Comuna_Zona->Exportable) $Doc->ExportField($this->Comuna_Zona);
					if ($this->Zona->Exportable) $Doc->ExportField($this->Zona);
					if ($this->Documento->Exportable) $Doc->ExportField($this->Documento);
					if ($this->Tipo_Entidad->Exportable) $Doc->ExportField($this->Tipo_Entidad);
					if ($this->Tipo_Documento->Exportable) $Doc->ExportField($this->Tipo_Documento);
					if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportField($this->Fecha_Nacimiento);
					if ($this->Nombres->Exportable) $Doc->ExportField($this->Nombres);
					if ($this->Apellidos->Exportable) $Doc->ExportField($this->Apellidos);
					if ($this->Fecha_valoracion->Exportable) $Doc->ExportField($this->Fecha_valoracion);
					if ($this->Perimetro_Cefalico->Exportable) $Doc->ExportField($this->Perimetro_Cefalico);
					if ($this->Perimetro_Abdominal->Exportable) $Doc->ExportField($this->Perimetro_Abdominal);
					if ($this->DS_TallaEdad->Exportable) $Doc->ExportField($this->DS_TallaEdad);
					if ($this->IMC->Exportable) $Doc->ExportField($this->IMC);
					if ($this->DS_PesoTalla->Exportable) $Doc->ExportField($this->DS_PesoTalla);
					if ($this->DS_IMCEdad->Exportable) $Doc->ExportField($this->DS_IMCEdad);
					if ($this->DS_PesoEdad->Exportable) $Doc->ExportField($this->DS_PesoEdad);
					if ($this->DS_PCEdad->Exportable) $Doc->ExportField($this->DS_PCEdad);
					if ($this->Superficie_Corporal->Exportable) $Doc->ExportField($this->Superficie_Corporal);
					if ($this->Barrio_Vereda->Exportable) $Doc->ExportField($this->Barrio_Vereda);
					if ($this->Grupo_Etnico->Exportable) $Doc->ExportField($this->Grupo_Etnico);
					if ($this->Tipo_Regimen->Exportable) $Doc->ExportField($this->Tipo_Regimen);
					if ($this->EPS->Exportable) $Doc->ExportField($this->EPS);
					if ($this->Condicion_Discapacidad->Exportable) $Doc->ExportField($this->Condicion_Discapacidad);
					if ($this->Condicion_Desplazamiento->Exportable) $Doc->ExportField($this->Condicion_Desplazamiento);
					if ($this->Clasificado->Exportable) $Doc->ExportField($this->Clasificado);
				} else {
					if ($this->Consecutivo->Exportable) $Doc->ExportField($this->Consecutivo);
					if ($this->Entidad_Valora->Exportable) $Doc->ExportField($this->Entidad_Valora);
					if ($this->Genero->Exportable) $Doc->ExportField($this->Genero);
					if ($this->Peso->Exportable) $Doc->ExportField($this->Peso);
					if ($this->Talla->Exportable) $Doc->ExportField($this->Talla);
					if ($this->Edad_Anos->Exportable) $Doc->ExportField($this->Edad_Anos);
					if ($this->Edad_Meses->Exportable) $Doc->ExportField($this->Edad_Meses);
					if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Talla_Edad);
					if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Talla);
					if ($this->Clasificacion_P_Cefalico->Exportable) $Doc->ExportField($this->Clasificacion_P_Cefalico);
					if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportField($this->Clasificacion_IMC_Edad);
					if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Edad);
					if ($this->Entidad_Educativa->Exportable) $Doc->ExportField($this->Entidad_Educativa);
					if ($this->Escolaridad->Exportable) $Doc->ExportField($this->Escolaridad);
					if ($this->Comuna_Zona->Exportable) $Doc->ExportField($this->Comuna_Zona);
					if ($this->Zona->Exportable) $Doc->ExportField($this->Zona);
					if ($this->Documento->Exportable) $Doc->ExportField($this->Documento);
					if ($this->Tipo_Entidad->Exportable) $Doc->ExportField($this->Tipo_Entidad);
					if ($this->Tipo_Documento->Exportable) $Doc->ExportField($this->Tipo_Documento);
					if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportField($this->Fecha_Nacimiento);
					if ($this->Nombres->Exportable) $Doc->ExportField($this->Nombres);
					if ($this->Apellidos->Exportable) $Doc->ExportField($this->Apellidos);
					if ($this->Fecha_valoracion->Exportable) $Doc->ExportField($this->Fecha_valoracion);
					if ($this->Perimetro_Cefalico->Exportable) $Doc->ExportField($this->Perimetro_Cefalico);
					if ($this->Perimetro_Abdominal->Exportable) $Doc->ExportField($this->Perimetro_Abdominal);
					if ($this->DS_TallaEdad->Exportable) $Doc->ExportField($this->DS_TallaEdad);
					if ($this->IMC->Exportable) $Doc->ExportField($this->IMC);
					if ($this->DS_PesoTalla->Exportable) $Doc->ExportField($this->DS_PesoTalla);
					if ($this->DS_IMCEdad->Exportable) $Doc->ExportField($this->DS_IMCEdad);
					if ($this->DS_PesoEdad->Exportable) $Doc->ExportField($this->DS_PesoEdad);
					if ($this->DS_PCEdad->Exportable) $Doc->ExportField($this->DS_PCEdad);
					if ($this->Superficie_Corporal->Exportable) $Doc->ExportField($this->Superficie_Corporal);
					if ($this->Barrio_Vereda->Exportable) $Doc->ExportField($this->Barrio_Vereda);
					if ($this->Grupo_Etnico->Exportable) $Doc->ExportField($this->Grupo_Etnico);
					if ($this->Tipo_Regimen->Exportable) $Doc->ExportField($this->Tipo_Regimen);
					if ($this->EPS->Exportable) $Doc->ExportField($this->EPS);
					if ($this->Condicion_Discapacidad->Exportable) $Doc->ExportField($this->Condicion_Discapacidad);
					if ($this->Condicion_Desplazamiento->Exportable) $Doc->ExportField($this->Condicion_Desplazamiento);
					if ($this->Clasificado->Exportable) $Doc->ExportField($this->Clasificado);
				}
				$Doc->EndExportRow();
			}
			$Recordset->MoveNext();
		}
		$Doc->ExportTableFooter();
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here	
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here	
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here	
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		// Enter your code here
	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here	
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>); 

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
