<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "barrio_veredainfo.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$barrio_vereda_list = NULL; // Initialize page object first

class cbarrio_vereda_list extends cbarrio_vereda {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{5B1FB6D8-0E93-4F60-869F-153E389D6FED}";

	// Table name
	var $TableName = 'barrio_vereda';

	// Page object name
	var $PageObjName = 'barrio_vereda_list';

	// Grid form hidden field names
	var $FormName = 'fbarrio_veredalist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (barrio_vereda)
		if (!isset($GLOBALS["barrio_vereda"]) || get_class($GLOBALS["barrio_vereda"]) == "cbarrio_vereda") {
			$GLOBALS["barrio_vereda"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["barrio_vereda"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "barrio_veredaadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "barrio_veredadelete.php";
		$this->MultiUpdateUrl = "barrio_veredaupdate.php";

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS['nutricion_usuario'])) $GLOBALS['nutricion_usuario'] = new cnutricion_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'barrio_vereda', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("login.php");
		}

		// Create form object
		$objForm = new cFormObj();

		// Get export parameters
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->consecutivo->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Setup other options
		$this->SetupOtherOptions();

		// Set "checkbox" visible
		if (count($this->CustomActions) > 0)
			$this->ListOptions->Items["checkbox"]->Visible = TRUE;

		// Update url if printer friendly for Pdf
		if ($this->PrinterFriendlyForPdf)
			$this->ExportOptions->Items["pdf"]->Body = str_replace($this->ExportPdfUrl, $this->ExportPrintUrl . "&pdf=1", $this->ExportOptions->Items["pdf"]->Body);
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();
		if ($this->Export == "print" && @$_GET["pdf"] == "1") { // Printer friendly version and with pdf=1 in URL parameters
			$pdf = new cExportPdf($GLOBALS["Table"]);
			$pdf->Text = ob_get_contents(); // Set the content as the HTML of current page (printer friendly version)
			ob_end_clean();
			$pdf->Export();
		}

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 10;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process custom action first
			$this->ProcessCustomAction();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Check QueryString parameters
			if (@$_GET["a"] <> "") {
				$this->CurrentAction = $_GET["a"];

				// Clear inline mode
				if ($this->CurrentAction == "cancel")
					$this->ClearInlineMode();

				// Switch to grid edit mode
				if ($this->CurrentAction == "gridedit")
					$this->GridEditMode();
			} else {
				if (@$_POST["a_list"] <> "") {
					$this->CurrentAction = $_POST["a_list"]; // Get action

					// Grid Update
					if (($this->CurrentAction == "gridupdate" || $this->CurrentAction == "gridoverwrite") && @$_SESSION[EW_SESSION_INLINE_MODE] == "gridedit") {
						if ($this->ValidateGridForm()) {
							$this->GridUpdate();
						} else {
							$this->setFailureMessage($gsFormError);
							$this->EventCancelled = TRUE;
							$this->CurrentAction = "gridedit"; // Stay in Grid Edit mode
						}
					}
				}
			}

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide export options
			if ($this->Export <> "" || $this->CurrentAction <> "")
				$this->ExportOptions->HideAllOptions();

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Show grid delete link for grid add / grid edit
			if ($this->AllowAddDeleteRow) {
				if ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
					$item = $this->ListOptions->GetItem("griddelete");
					if ($item) $item->Visible = TRUE;
				}
			}

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Restore search parms from Session if not searching / reset
			if ($this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 10; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Export data only
		if (in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}
	}

	//  Exit inline mode
	function ClearInlineMode() {
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[EW_SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Grid Edit mode
	function GridEditMode() {
		$_SESSION[EW_SESSION_INLINE_MODE] = "gridedit"; // Enable grid edit
	}

	// Perform update to grid
	function GridUpdate() {
		global $conn, $Language, $objForm, $gsFormError;
		$bGridUpdate = TRUE;

		// Begin transaction
		$conn->BeginTrans();

		// Get old recordset
		$this->CurrentFilter = $this->BuildKeyFilter();
		$sSql = $this->SQL();
		if ($rs = $conn->Execute($sSql)) {
			$rsold = $rs->GetRows();
			$rs->Close();
		}
		$sKey = "";

		// Update row index and get row key
		$objForm->Index = -1;
		$rowcnt = strval($objForm->GetValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Update all rows based on key
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
			$objForm->Index = $rowindex;
			$rowkey = strval($objForm->GetValue($this->FormKeyName));
			$rowaction = strval($objForm->GetValue($this->FormActionName));

			// Load all values and keys
			if ($rowaction <> "insertdelete") { // Skip insert then deleted rows
				$this->LoadFormValues(); // Get form values
				if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
					$bGridUpdate = $this->SetupKeyValues($rowkey); // Set up key values
				} else {
					$bGridUpdate = TRUE;
				}

				// Skip empty row
				if ($rowaction == "insert" && $this->EmptyRow()) {

					// No action required
				// Validate form and insert/update/delete record

				} elseif ($bGridUpdate) {
					if ($rowaction == "delete") {
						$this->CurrentFilter = $this->KeyFilter();
						$bGridUpdate = $this->DeleteRows(); // Delete this row
					} else if (!$this->ValidateForm()) {
						$bGridUpdate = FALSE; // Form error, reset action
						$this->setFailureMessage($gsFormError);
					} else {
						if ($rowaction == "insert") {
							$bGridUpdate = $this->AddRow(); // Insert this row
						} else {
							if ($rowkey <> "") {
								$this->SendEmail = FALSE; // Do not send email on update success
								$bGridUpdate = $this->EditRow(); // Update this row
							}
						} // End update
					}
				}
				if ($bGridUpdate) {
					if ($sKey <> "") $sKey .= ", ";
					$sKey .= $rowkey;
				} else {
					break;
				}
			}
		}
		if ($bGridUpdate) {
			$conn->CommitTrans(); // Commit transaction

			// Get new recordset
			if ($rs = $conn->Execute($sSql)) {
				$rsnew = $rs->GetRows();
				$rs->Close();
			}
			if ($this->getSuccessMessage() == "")
				$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Set up update success message
			$this->ClearInlineMode(); // Clear inline edit mode
		} else {
			$conn->RollbackTrans(); // Rollback transaction
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->Phrase("UpdateFailed")); // Set update failed message
			$this->EventCancelled = TRUE; // Set event cancelled
			$this->CurrentAction = "gridedit"; // Stay in Grid Edit mode
		}
		return $bGridUpdate;
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->consecutivo->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->consecutivo->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Check if empty row
	function EmptyRow() {
		global $objForm;
		if ($objForm->HasValue("x_Localidad") && $objForm->HasValue("o_Localidad") && $this->Localidad->CurrentValue <> $this->Localidad->OldValue)
			return FALSE;
		if ($objForm->HasValue("x_Barrio_Vereda") && $objForm->HasValue("o_Barrio_Vereda") && $this->Barrio_Vereda->CurrentValue <> $this->Barrio_Vereda->OldValue)
			return FALSE;
		if ($objForm->HasValue("x_Zona") && $objForm->HasValue("o_Zona") && $this->Zona->CurrentValue <> $this->Zona->OldValue)
			return FALSE;
		return TRUE;
	}

	// Validate grid form
	function ValidateGridForm() {
		global $objForm;

		// Get row count
		$objForm->Index = -1;
		$rowcnt = strval($objForm->GetValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Validate all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$objForm->Index = $rowindex;
			$rowaction = strval($objForm->GetValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->LoadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->EmptyRow()) {

					// Ignore
				} else if (!$this->ValidateForm()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	// Restore form values for current row
	function RestoreCurrentRowFormValues($idx) {
		global $objForm;

		// Get row based on current index
		$objForm->Index = $idx;
		$this->LoadFormValues(); // Load form values
	}

	// Return basic search SQL
	function BasicSearchSQL($Keyword) {
		$sKeyword = ew_AdjustSql($Keyword);
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Barrio_Vereda, $Keyword);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $Keyword) {
		if ($Keyword == EW_NULL_VALUE) {
			$sWrk = $Fld->FldExpression . " IS NULL";
		} elseif ($Keyword == EW_NOT_NULL_VALUE) {
			$sWrk = $Fld->FldExpression . " IS NOT NULL";
		} else {
			$sFldExpression = ($Fld->FldVirtualExpression <> $Fld->FldExpression) ? $Fld->FldVirtualExpression : $Fld->FldBasicSearchExpression;
			$sWrk = $sFldExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING));
		}
		if ($Where <> "") $Where .= " OR ";
		$Where .= $sWrk;
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere() {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = $this->BasicSearch->Keyword;
		$sSearchType = $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				while (strpos($sSearch, "  ") !== FALSE)
					$sSearch = str_replace("  ", " ", $sSearch);
				$arKeyword = explode(" ", trim($sSearch));
				foreach ($arKeyword as $sKeyword) {
					if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
					$sSearchStr .= "(" . $this->BasicSearchSQL($sKeyword) . ")";
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($sSearch);
			}
			$this->Command = "search";
		}
		if ($this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->consecutivo); // consecutivo
			$this->UpdateSort($this->Localidad); // Localidad
			$this->UpdateSort($this->Barrio_Vereda); // Barrio_Vereda
			$this->UpdateSort($this->Zona); // Zona
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->SqlOrderBy() <> "") {
				$sOrderBy = $this->SqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->consecutivo->setSort("");
				$this->Localidad->setSort("");
				$this->Barrio_Vereda->setSort("");
				$this->Zona->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// "griddelete"
		if ($this->AllowAddDeleteRow) {
			$item = &$this->ListOptions->Add("griddelete");
			$item->CssStyle = "white-space: nowrap;";
			$item->OnLeft = TRUE;
			$item->Visible = FALSE; // Default hidden
		}

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->Add("delete");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<label class=\"checkbox\"><input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\"></label>";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		$this->ListOptions->ButtonClass = "btn-small"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode <> "view") {
			$objForm->Index = $this->RowIndex;
			$ActionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$OldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$KeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$BlankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $ActionName . "\" id=\"" . $ActionName . "\" value=\"" . $this->RowAction . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $objForm->GetValue($this->FormKeyName);
				$this->SetupKeyValues($rowkey);
			}
			if ($this->RowAction == "insert" && $this->CurrentAction == "F" && $this->EmptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $BlankRowName . "\" id=\"" . $BlankRowName . "\" value=\"1\">";
		}

		// "delete"
		if ($this->AllowAddDeleteRow) {
			if ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$option = &$this->ListOptions;
				$option->UseButtonGroup = TRUE; // Use button group for grid delete button
				$option->UseImageAndText = TRUE; // Use image and text for grid delete button
				$oListOpt = &$option->Items["griddelete"];
				if (!$Security->CanDelete() && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
					$oListOpt->Body = "&nbsp;";
				} else {
					$oListOpt->Body = "<a class=\"ewGridLink ewGridDelete\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteLink")) . "\" href=\"javascript:void(0);\" onclick=\"ew_DeleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->Phrase("DeleteLink") . "</a>";
				}
			}
		}

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		if ($Security->CanView())
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		else
			$oListOpt->Body = "";

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("CopyLink")) . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "delete"
		$oListOpt = &$this->ListOptions->Items["delete"];
		if ($Security->CanDelete())
			$oListOpt->Body = "<a class=\"ewRowLink ewDelete\"" . " onclick=\"ew_ClickDelete(this);return ew_ConfirmDelete(ewLanguage.Phrase('DeleteConfirmMsg'), this);\"" . " data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteLink")) . "\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("DeleteLink") . "</a>";
		else
			$oListOpt->Body = "";

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<label class=\"checkbox\"><input type=\"checkbox\" name=\"key_m[]\" value=\"" . ew_HtmlEncode($this->consecutivo->CurrentValue) . "\" onclick='ew_ClickMultiCheckbox(event, this);'></label>";
		if ($this->CurrentAction == "gridedit" && is_numeric($this->RowIndex)) {
			$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $KeyName . "\" id=\"" . $KeyName . "\" value=\"" . $this->consecutivo->CurrentValue . "\">";
		}
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAddEdit ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Add grid edit
		$option = $options["addedit"];
		$item = &$option->Add("gridedit");
		$item->Body = "<a class=\"ewAddEdit ewGridEdit\" href=\"" . ew_HtmlEncode($this->GridEditUrl) . "\">" . $Language->Phrase("GridEditLink") . "</a>";
		$item->Visible = ($this->GridEditUrl <> "" && $Security->CanEdit());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-small"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		if ($this->CurrentAction <> "gridadd" && $this->CurrentAction <> "gridedit") { // Not grid add/edit mode
			$option = &$options["action"];
			foreach ($this->CustomActions as $action => $name) {

				// Add custom action
				$item = &$option->Add("custom_" . $action);
				$item->Body = "<a class=\"ewAction ewCustomAction\" href=\"\" onclick=\"ew_SubmitSelected(document.fbarrio_veredalist, '" . ew_CurrentUrl() . "', null, '" . $action . "');return false;\">" . $name . "</a>";
			}

			// Hide grid edit, multi-delete and multi-update
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$item = &$option->GetItem("multidelete");
				if ($item) $item->Visible = FALSE;
				$item = &$option->GetItem("multiupdate");
				if ($item) $item->Visible = FALSE;
			}
		} else { // Grid add/edit mode

			// Hide all options first
			foreach ($options as &$option)
				$option->HideAllOptions();
			if ($this->CurrentAction == "gridedit") {
				if ($this->AllowAddDeleteRow) {

					// Add add blank row
					$option = &$options["addedit"];
					$option->UseDropDownButton = FALSE;
					$option->UseImageAndText = TRUE;
					$item = &$option->Add("addblankrow");
					$item->Body = "<a class=\"ewAddEdit ewAddBlankRow\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("AddBlankRow")) . "\" href=\"javascript:void(0);\" onclick=\"ew_AddGridRow(this);\">" . $Language->Phrase("AddBlankRow") . "</a>";
					$item->Visible = $Security->CanAdd();
				}
				$option = &$options["action"];
				$option->UseDropDownButton = FALSE;
				$option->UseImageAndText = TRUE;
					$item = &$option->Add("gridsave");
					$item->Body = "<a class=\"ewAction ewGridSave\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("GridSaveLink")) . "\" href=\"\" onclick=\"return ewForms(this).Submit();\">" . $Language->Phrase("GridSaveLink") . "</a>";
					$item = &$option->Add("gridcancel");
					$item->Body = "<a class=\"ewAction ewGridCancel\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("GridCancelLink")) . "\" href=\"" . $this->PageUrl() . "a=cancel\">" . $Language->Phrase("GridCancelLink") . "</a>";
			}
		}
	}

	// Process custom action
	function ProcessCustomAction() {
		global $conn, $Language, $Security;
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$rsuser = ($rs) ? $rs->GetRows() : array();
			if ($rs)
				$rs->Close();

			// Call row custom action event
			if (count($rsuser) > 0) {
				$conn->BeginTrans();
				foreach ($rsuser as $row) {
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $UserAction, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $UserAction, $Language->Phrase("CustomActionCancelled")));
					}
				}
			}
		}
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load default values
	function LoadDefaultValues() {
		$this->consecutivo->CurrentValue = NULL;
		$this->consecutivo->OldValue = $this->consecutivo->CurrentValue;
		$this->Localidad->CurrentValue = NULL;
		$this->Localidad->OldValue = $this->Localidad->CurrentValue;
		$this->Barrio_Vereda->CurrentValue = NULL;
		$this->Barrio_Vereda->OldValue = $this->Barrio_Vereda->CurrentValue;
		$this->Zona->CurrentValue = NULL;
		$this->Zona->OldValue = $this->Zona->CurrentValue;
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->consecutivo->FldIsDetailKey && $this->CurrentAction <> "gridadd" && $this->CurrentAction <> "add")
			$this->consecutivo->setFormValue($objForm->GetValue("x_consecutivo"));
		if (!$this->Localidad->FldIsDetailKey) {
			$this->Localidad->setFormValue($objForm->GetValue("x_Localidad"));
		}
		if (!$this->Barrio_Vereda->FldIsDetailKey) {
			$this->Barrio_Vereda->setFormValue($objForm->GetValue("x_Barrio_Vereda"));
		}
		if (!$this->Zona->FldIsDetailKey) {
			$this->Zona->setFormValue($objForm->GetValue("x_Zona"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		if ($this->CurrentAction <> "gridadd" && $this->CurrentAction <> "add")
			$this->consecutivo->CurrentValue = $this->consecutivo->FormValue;
		$this->Localidad->CurrentValue = $this->Localidad->FormValue;
		$this->Barrio_Vereda->CurrentValue = $this->Barrio_Vereda->FormValue;
		$this->Zona->CurrentValue = $this->Zona->FormValue;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->consecutivo->setDbValue($rs->fields('consecutivo'));
		$this->Localidad->setDbValue($rs->fields('Localidad'));
		$this->Barrio_Vereda->setDbValue($rs->fields('Barrio_Vereda'));
		$this->Zona->setDbValue($rs->fields('Zona'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->consecutivo->DbValue = $row['consecutivo'];
		$this->Localidad->DbValue = $row['Localidad'];
		$this->Barrio_Vereda->DbValue = $row['Barrio_Vereda'];
		$this->Zona->DbValue = $row['Zona'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("consecutivo")) <> "")
			$this->consecutivo->CurrentValue = $this->getKey("consecutivo"); // consecutivo
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$this->OldRecordset = ew_LoadRecordset($sSql);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// consecutivo
		// Localidad
		// Barrio_Vereda
		// Zona

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// consecutivo
			$this->consecutivo->ViewValue = $this->consecutivo->CurrentValue;
			$this->consecutivo->ViewCustomAttributes = "";

			// Localidad
			if (strval($this->Localidad->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Localidad->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `comuna_localidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Localidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Localidad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Localidad->ViewValue = $this->Localidad->CurrentValue;
				}
			} else {
				$this->Localidad->ViewValue = NULL;
			}
			$this->Localidad->ViewCustomAttributes = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->ViewValue = $this->Barrio_Vereda->CurrentValue;
			$this->Barrio_Vereda->ViewCustomAttributes = "";

			// Zona
			if (strval($this->Zona->CurrentValue) <> "") {
				$sFilterWrk = "`codigo`" . ew_SearchString("=", $this->Zona->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `codigo`, `Zona` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `zona`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Zona->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Zona->ViewValue = $this->Zona->CurrentValue;
				}
			} else {
				$this->Zona->ViewValue = NULL;
			}
			$this->Zona->ViewCustomAttributes = "";

			// consecutivo
			$this->consecutivo->LinkCustomAttributes = "";
			$this->consecutivo->HrefValue = "";
			$this->consecutivo->TooltipValue = "";

			// Localidad
			$this->Localidad->LinkCustomAttributes = "";
			$this->Localidad->HrefValue = "";
			$this->Localidad->TooltipValue = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->LinkCustomAttributes = "";
			$this->Barrio_Vereda->HrefValue = "";
			$this->Barrio_Vereda->TooltipValue = "";

			// Zona
			$this->Zona->LinkCustomAttributes = "";
			$this->Zona->HrefValue = "";
			$this->Zona->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// consecutivo
			// Localidad

			$this->Localidad->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `comuna_localidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Localidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Localidad->EditValue = $arwrk;

			// Barrio_Vereda
			$this->Barrio_Vereda->EditCustomAttributes = "";
			$this->Barrio_Vereda->EditValue = ew_HtmlEncode($this->Barrio_Vereda->CurrentValue);
			$this->Barrio_Vereda->PlaceHolder = ew_RemoveHtml($this->Barrio_Vereda->FldCaption());

			// Zona
			$this->Zona->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `codigo`, `Zona` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `zona`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Zona->EditValue = $arwrk;

			// Edit refer script
			// consecutivo

			$this->consecutivo->HrefValue = "";

			// Localidad
			$this->Localidad->HrefValue = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->HrefValue = "";

			// Zona
			$this->Zona->HrefValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// consecutivo
			$this->consecutivo->EditCustomAttributes = "";
			$this->consecutivo->EditValue = $this->consecutivo->CurrentValue;
			$this->consecutivo->ViewCustomAttributes = "";

			// Localidad
			$this->Localidad->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `comuna_localidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Localidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Localidad->EditValue = $arwrk;

			// Barrio_Vereda
			$this->Barrio_Vereda->EditCustomAttributes = "";
			$this->Barrio_Vereda->EditValue = ew_HtmlEncode($this->Barrio_Vereda->CurrentValue);
			$this->Barrio_Vereda->PlaceHolder = ew_RemoveHtml($this->Barrio_Vereda->FldCaption());

			// Zona
			$this->Zona->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `codigo`, `Zona` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `zona`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Zona->EditValue = $arwrk;

			// Edit refer script
			// consecutivo

			$this->consecutivo->HrefValue = "";

			// Localidad
			$this->Localidad->HrefValue = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->HrefValue = "";

			// Zona
			$this->Zona->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->Localidad->FldIsDetailKey && !is_null($this->Localidad->FormValue) && $this->Localidad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Localidad->FldCaption());
		}
		if (!$this->Barrio_Vereda->FldIsDetailKey && !is_null($this->Barrio_Vereda->FormValue) && $this->Barrio_Vereda->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Barrio_Vereda->FldCaption());
		}
		if (!$this->Zona->FldIsDetailKey && !is_null($this->Zona->FormValue) && $this->Zona->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Zona->FldCaption());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	//
	// Delete records based on current filter
	//
	function DeleteRows() {
		global $conn, $Language, $Security;
		if (!$Security->CanDelete()) {
			$this->setFailureMessage($Language->Phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$DeleteRows = TRUE;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
			$rs->Close();
			return FALSE;

		//} else {
		//	$this->LoadRowValues($rs); // Load row values

		}

		// Clone old rows
		$rsold = ($rs) ? $rs->GetRows() : array();
		if ($rs)
			$rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $this->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= $GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"];
				$sThisKey .= $row['consecutivo'];
				$conn->raiseErrorFn = 'ew_ErrorFn';
				$DeleteRows = $this->Delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		} else {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("DeleteCancelled"));
			}
		}
		if ($DeleteRows) {
		} else {
		}

		// Call Row Deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}
		return $DeleteRows;
	}

	// Update record based on key values
	function EditRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// Localidad
			$this->Localidad->SetDbValueDef($rsnew, $this->Localidad->CurrentValue, 0, $this->Localidad->ReadOnly);

			// Barrio_Vereda
			$this->Barrio_Vereda->SetDbValueDef($rsnew, $this->Barrio_Vereda->CurrentValue, "", $this->Barrio_Vereda->ReadOnly);

			// Zona
			$this->Zona->SetDbValueDef($rsnew, $this->Zona->CurrentValue, 0, $this->Zona->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = 'ew_ErrorFn';
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $conn, $Language, $Security;

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
		}
		$rsnew = array();

		// Localidad
		$this->Localidad->SetDbValueDef($rsnew, $this->Localidad->CurrentValue, 0, FALSE);

		// Barrio_Vereda
		$this->Barrio_Vereda->SetDbValueDef($rsnew, $this->Barrio_Vereda->CurrentValue, "", FALSE);

		// Zona
		$this->Zona->SetDbValueDef($rsnew, $this->Zona->CurrentValue, 0, FALSE);

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}

		// Get insert id if necessary
		if ($AddRow) {
			$this->consecutivo->setDbValue($conn->Insert_ID());
			$rsnew['consecutivo'] = $this->consecutivo->DbValue;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$item->Body = "<a id=\"emf_barrio_vereda\" href=\"javascript:void(0);\" class=\"ewExportLink ewEmail\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_barrio_vereda',hdr:ewLanguage.Phrase('ExportToEmail'),f:document.fbarrio_veredalist,sel:false});\">" . $Language->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = EW_SELECT_LIMIT;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if ($rs = $this->LoadRecordset())
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetUpStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$ExportDoc = ew_ExportDocument($this, "h");
		$ParentTable = "";
		if ($bSelectLimit) {
			$StartRec = 1;
			$StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {
			$StartRec = $this->StartRec;
			$StopRec = $this->StopRec;
		}
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$ExportDoc->Text .= $sHeader;
		$this->ExportDocument($ExportDoc, $rs, $StartRec, $StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$ExportDoc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Export header and footer
		$ExportDoc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED)
			echo ew_DebugMsg();

		// Output data
		$ExportDoc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = ew_CurrentUrl();
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($barrio_vereda_list)) $barrio_vereda_list = new cbarrio_vereda_list();

// Page init
$barrio_vereda_list->Page_Init();

// Page main
$barrio_vereda_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$barrio_vereda_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($barrio_vereda->Export == "") { ?>
<script type="text/javascript">

// Page object
var barrio_vereda_list = new ew_Page("barrio_vereda_list");
barrio_vereda_list.PageID = "list"; // Page ID
var EW_PAGE_ID = barrio_vereda_list.PageID; // For backward compatibility

// Form object
var fbarrio_veredalist = new ew_Form("fbarrio_veredalist");
fbarrio_veredalist.FormKeyCountName = '<?php echo $barrio_vereda_list->FormKeyCountName ?>';

// Validate form
fbarrio_veredalist.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_Localidad");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($barrio_vereda->Localidad->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Barrio_Vereda");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($barrio_vereda->Barrio_Vereda->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Zona");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($barrio_vereda->Zona->FldCaption()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbarrio_veredalist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fbarrio_veredalist.ValidateRequired = true;
<?php } else { ?>
fbarrio_veredalist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fbarrio_veredalist.Lists["x_Localidad"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Localidad_Comuna","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fbarrio_veredalist.Lists["x_Zona"] = {"LinkField":"x_codigo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Zona","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
var fbarrio_veredalistsrch = new ew_Form("fbarrio_veredalistsrch");

// Init search panel as collapsed
if (fbarrio_veredalistsrch) fbarrio_veredalistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($barrio_vereda->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($barrio_vereda_list->ExportOptions->Visible()) { ?>
<div class="ewListExportOptions"><?php $barrio_vereda_list->ExportOptions->Render("body") ?></div>
<?php } ?>
<?php
	$bSelectLimit = EW_SELECT_LIMIT;
	if ($bSelectLimit) {
		$barrio_vereda_list->TotalRecs = $barrio_vereda->SelectRecordCount();
	} else {
		if ($barrio_vereda_list->Recordset = $barrio_vereda_list->LoadRecordset())
			$barrio_vereda_list->TotalRecs = $barrio_vereda_list->Recordset->RecordCount();
	}
	$barrio_vereda_list->StartRec = 1;
	if ($barrio_vereda_list->DisplayRecs <= 0 || ($barrio_vereda->Export <> "" && $barrio_vereda->ExportAll)) // Display all records
		$barrio_vereda_list->DisplayRecs = $barrio_vereda_list->TotalRecs;
	if (!($barrio_vereda->Export <> "" && $barrio_vereda->ExportAll))
		$barrio_vereda_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$barrio_vereda_list->Recordset = $barrio_vereda_list->LoadRecordset($barrio_vereda_list->StartRec-1, $barrio_vereda_list->DisplayRecs);
$barrio_vereda_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($barrio_vereda->Export == "" && $barrio_vereda->CurrentAction == "") { ?>
<form name="fbarrio_veredalistsrch" id="fbarrio_veredalistsrch" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>">
<div class="accordion ewDisplayTable ewSearchTable" id="fbarrio_veredalistsrch_SearchGroup">
	<div class="accordion-group">
		<div class="accordion-heading">
<a class="accordion-toggle" data-toggle="collapse" data-parent="#fbarrio_veredalistsrch_SearchGroup" href="#fbarrio_veredalistsrch_SearchBody"><?php echo $Language->Phrase("Search") ?></a>
		</div>
		<div id="fbarrio_veredalistsrch_SearchBody" class="accordion-body collapse in">
			<div class="accordion-inner">
<div id="fbarrio_veredalistsrch_SearchPanel">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="barrio_vereda">
<div class="ewBasicSearch">
<div id="xsr_1" class="ewRow">
	<div class="btn-group ewButtonGroup">
	<div class="input-append">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="input-large" value="<?php echo ew_HtmlEncode($barrio_vereda_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
	<div class="btn-group ewButtonGroup">
	<a class="btn ewShowAll" href="<?php echo $barrio_vereda_list->PageUrl() ?>cmd=reset"><?php echo $Language->Phrase("ShowAll") ?></a>
	</div>
</div>
<div id="xsr_2" class="ewRow">
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="="<?php if ($barrio_vereda_list->BasicSearch->getType() == "=") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("ExactPhrase") ?></label>
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="AND"<?php if ($barrio_vereda_list->BasicSearch->getType() == "AND") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("AllWord") ?></label>
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="OR"<?php if ($barrio_vereda_list->BasicSearch->getType() == "OR") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("AnyWord") ?></label>
</div>
</div>
</div>
			</div>
		</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $barrio_vereda_list->ShowPageHeader(); ?>
<?php
$barrio_vereda_list->ShowMessage();
?>
<table class="ewGrid"><tr><td class="ewGridContent">
<?php if ($barrio_vereda->Export == "") { ?>
<div class="ewGridUpperPanel">
<?php if ($barrio_vereda->CurrentAction <> "gridadd" && $barrio_vereda->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>">
<table class="ewPager">
<tr><td>
<?php if (!isset($barrio_vereda_list->Pager)) $barrio_vereda_list->Pager = new cPrevNextPager($barrio_vereda_list->StartRec, $barrio_vereda_list->DisplayRecs, $barrio_vereda_list->TotalRecs) ?>
<?php if ($barrio_vereda_list->Pager->RecordCount > 0) { ?>
<table class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($barrio_vereda_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $barrio_vereda_list->PageUrl() ?>start=<?php echo $barrio_vereda_list->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($barrio_vereda_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $barrio_vereda_list->PageUrl() ?>start=<?php echo $barrio_vereda_list->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $barrio_vereda_list->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($barrio_vereda_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $barrio_vereda_list->PageUrl() ?>start=<?php echo $barrio_vereda_list->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($barrio_vereda_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $barrio_vereda_list->PageUrl() ?>start=<?php echo $barrio_vereda_list->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $barrio_vereda_list->Pager->PageCount ?>
</td>
<td>
	&nbsp;&nbsp;&nbsp;&nbsp;
	<?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $barrio_vereda_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $barrio_vereda_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $barrio_vereda_list->Pager->RecordCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<?php if ($Security->CanList()) { ?>
	<?php if ($barrio_vereda_list->SearchWhere == "0=101") { ?>
	<p><?php echo $Language->Phrase("EnterSearchCriteria") ?></p>
	<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
	<?php } ?>
	<?php } else { ?>
	<p><?php echo $Language->Phrase("NoPermission") ?></p>
	<?php } ?>
<?php } ?>
</td>
</tr></table>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($barrio_vereda_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
</div>
<?php } ?>
<form name="fbarrio_veredalist" id="fbarrio_veredalist" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="barrio_vereda">
<div id="gmp_barrio_vereda" class="ewGridMiddlePanel">
<?php if ($barrio_vereda_list->TotalRecs > 0) { ?>
<table id="tbl_barrio_veredalist" class="ewTable ewTableSeparate">
<?php echo $barrio_vereda->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Render list options
$barrio_vereda_list->RenderListOptions();

// Render list options (header, left)
$barrio_vereda_list->ListOptions->Render("header", "left");
?>
<?php if ($barrio_vereda->consecutivo->Visible) { // consecutivo ?>
	<?php if ($barrio_vereda->SortUrl($barrio_vereda->consecutivo) == "") { ?>
		<td><div id="elh_barrio_vereda_consecutivo" class="barrio_vereda_consecutivo"><div class="ewTableHeaderCaption"><?php echo $barrio_vereda->consecutivo->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $barrio_vereda->SortUrl($barrio_vereda->consecutivo) ?>',1);"><div id="elh_barrio_vereda_consecutivo" class="barrio_vereda_consecutivo">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $barrio_vereda->consecutivo->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($barrio_vereda->consecutivo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($barrio_vereda->consecutivo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($barrio_vereda->Localidad->Visible) { // Localidad ?>
	<?php if ($barrio_vereda->SortUrl($barrio_vereda->Localidad) == "") { ?>
		<td><div id="elh_barrio_vereda_Localidad" class="barrio_vereda_Localidad"><div class="ewTableHeaderCaption"><?php echo $barrio_vereda->Localidad->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $barrio_vereda->SortUrl($barrio_vereda->Localidad) ?>',1);"><div id="elh_barrio_vereda_Localidad" class="barrio_vereda_Localidad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $barrio_vereda->Localidad->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($barrio_vereda->Localidad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($barrio_vereda->Localidad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($barrio_vereda->Barrio_Vereda->Visible) { // Barrio_Vereda ?>
	<?php if ($barrio_vereda->SortUrl($barrio_vereda->Barrio_Vereda) == "") { ?>
		<td><div id="elh_barrio_vereda_Barrio_Vereda" class="barrio_vereda_Barrio_Vereda"><div class="ewTableHeaderCaption"><?php echo $barrio_vereda->Barrio_Vereda->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $barrio_vereda->SortUrl($barrio_vereda->Barrio_Vereda) ?>',1);"><div id="elh_barrio_vereda_Barrio_Vereda" class="barrio_vereda_Barrio_Vereda">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $barrio_vereda->Barrio_Vereda->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($barrio_vereda->Barrio_Vereda->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($barrio_vereda->Barrio_Vereda->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($barrio_vereda->Zona->Visible) { // Zona ?>
	<?php if ($barrio_vereda->SortUrl($barrio_vereda->Zona) == "") { ?>
		<td><div id="elh_barrio_vereda_Zona" class="barrio_vereda_Zona"><div class="ewTableHeaderCaption"><?php echo $barrio_vereda->Zona->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $barrio_vereda->SortUrl($barrio_vereda->Zona) ?>',1);"><div id="elh_barrio_vereda_Zona" class="barrio_vereda_Zona">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $barrio_vereda->Zona->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($barrio_vereda->Zona->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($barrio_vereda->Zona->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$barrio_vereda_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($barrio_vereda->ExportAll && $barrio_vereda->Export <> "") {
	$barrio_vereda_list->StopRec = $barrio_vereda_list->TotalRecs;
} else {

	// Set the last record to display
	if ($barrio_vereda_list->TotalRecs > $barrio_vereda_list->StartRec + $barrio_vereda_list->DisplayRecs - 1)
		$barrio_vereda_list->StopRec = $barrio_vereda_list->StartRec + $barrio_vereda_list->DisplayRecs - 1;
	else
		$barrio_vereda_list->StopRec = $barrio_vereda_list->TotalRecs;
}

// Restore number of post back records
if ($objForm) {
	$objForm->Index = -1;
	if ($objForm->HasValue($barrio_vereda_list->FormKeyCountName) && ($barrio_vereda->CurrentAction == "gridadd" || $barrio_vereda->CurrentAction == "gridedit" || $barrio_vereda->CurrentAction == "F")) {
		$barrio_vereda_list->KeyCount = $objForm->GetValue($barrio_vereda_list->FormKeyCountName);
		$barrio_vereda_list->StopRec = $barrio_vereda_list->StartRec + $barrio_vereda_list->KeyCount - 1;
	}
}
$barrio_vereda_list->RecCnt = $barrio_vereda_list->StartRec - 1;
if ($barrio_vereda_list->Recordset && !$barrio_vereda_list->Recordset->EOF) {
	$barrio_vereda_list->Recordset->MoveFirst();
	if (!$bSelectLimit && $barrio_vereda_list->StartRec > 1)
		$barrio_vereda_list->Recordset->Move($barrio_vereda_list->StartRec - 1);
} elseif (!$barrio_vereda->AllowAddDeleteRow && $barrio_vereda_list->StopRec == 0) {
	$barrio_vereda_list->StopRec = $barrio_vereda->GridAddRowCount;
}

// Initialize aggregate
$barrio_vereda->RowType = EW_ROWTYPE_AGGREGATEINIT;
$barrio_vereda->ResetAttrs();
$barrio_vereda_list->RenderRow();
if ($barrio_vereda->CurrentAction == "gridedit")
	$barrio_vereda_list->RowIndex = 0;
while ($barrio_vereda_list->RecCnt < $barrio_vereda_list->StopRec) {
	$barrio_vereda_list->RecCnt++;
	if (intval($barrio_vereda_list->RecCnt) >= intval($barrio_vereda_list->StartRec)) {
		$barrio_vereda_list->RowCnt++;
		if ($barrio_vereda->CurrentAction == "gridadd" || $barrio_vereda->CurrentAction == "gridedit" || $barrio_vereda->CurrentAction == "F") {
			$barrio_vereda_list->RowIndex++;
			$objForm->Index = $barrio_vereda_list->RowIndex;
			if ($objForm->HasValue($barrio_vereda_list->FormActionName))
				$barrio_vereda_list->RowAction = strval($objForm->GetValue($barrio_vereda_list->FormActionName));
			elseif ($barrio_vereda->CurrentAction == "gridadd")
				$barrio_vereda_list->RowAction = "insert";
			else
				$barrio_vereda_list->RowAction = "";
		}

		// Set up key count
		$barrio_vereda_list->KeyCount = $barrio_vereda_list->RowIndex;

		// Init row class and style
		$barrio_vereda->ResetAttrs();
		$barrio_vereda->CssClass = "";
		if ($barrio_vereda->CurrentAction == "gridadd") {
			$barrio_vereda_list->LoadDefaultValues(); // Load default values
		} else {
			$barrio_vereda_list->LoadRowValues($barrio_vereda_list->Recordset); // Load row values
		}
		$barrio_vereda->RowType = EW_ROWTYPE_VIEW; // Render view
		if ($barrio_vereda->CurrentAction == "gridedit") { // Grid edit
			if ($barrio_vereda->EventCancelled) {
				$barrio_vereda_list->RestoreCurrentRowFormValues($barrio_vereda_list->RowIndex); // Restore form values
			}
			if ($barrio_vereda_list->RowAction == "insert")
				$barrio_vereda->RowType = EW_ROWTYPE_ADD; // Render add
			else
				$barrio_vereda->RowType = EW_ROWTYPE_EDIT; // Render edit
		}
		if ($barrio_vereda->CurrentAction == "gridedit" && ($barrio_vereda->RowType == EW_ROWTYPE_EDIT || $barrio_vereda->RowType == EW_ROWTYPE_ADD) && $barrio_vereda->EventCancelled) // Update failed
			$barrio_vereda_list->RestoreCurrentRowFormValues($barrio_vereda_list->RowIndex); // Restore form values
		if ($barrio_vereda->RowType == EW_ROWTYPE_EDIT) // Edit row
			$barrio_vereda_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$barrio_vereda->RowAttrs = array_merge($barrio_vereda->RowAttrs, array('data-rowindex'=>$barrio_vereda_list->RowCnt, 'id'=>'r' . $barrio_vereda_list->RowCnt . '_barrio_vereda', 'data-rowtype'=>$barrio_vereda->RowType));

		// Render row
		$barrio_vereda_list->RenderRow();

		// Render list options
		$barrio_vereda_list->RenderListOptions();

		// Skip delete row / empty row for confirm page
		if ($barrio_vereda_list->RowAction <> "delete" && $barrio_vereda_list->RowAction <> "insertdelete" && !($barrio_vereda_list->RowAction == "insert" && $barrio_vereda->CurrentAction == "F" && $barrio_vereda_list->EmptyRow())) {
?>
	<tr<?php echo $barrio_vereda->RowAttributes() ?>>
<?php

// Render list options (body, left)
$barrio_vereda_list->ListOptions->Render("body", "left", $barrio_vereda_list->RowCnt);
?>
	<?php if ($barrio_vereda->consecutivo->Visible) { // consecutivo ?>
		<td<?php echo $barrio_vereda->consecutivo->CellAttributes() ?>>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-field="x_consecutivo" name="o<?php echo $barrio_vereda_list->RowIndex ?>_consecutivo" id="o<?php echo $barrio_vereda_list->RowIndex ?>_consecutivo" value="<?php echo ew_HtmlEncode($barrio_vereda->consecutivo->OldValue) ?>">
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $barrio_vereda_list->RowCnt ?>_barrio_vereda_consecutivo" class="control-group barrio_vereda_consecutivo">
<span<?php echo $barrio_vereda->consecutivo->ViewAttributes() ?>>
<?php echo $barrio_vereda->consecutivo->EditValue ?></span>
</span>
<input type="hidden" data-field="x_consecutivo" name="x<?php echo $barrio_vereda_list->RowIndex ?>_consecutivo" id="x<?php echo $barrio_vereda_list->RowIndex ?>_consecutivo" value="<?php echo ew_HtmlEncode($barrio_vereda->consecutivo->CurrentValue) ?>">
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_VIEW) { // View record ?>
<span<?php echo $barrio_vereda->consecutivo->ViewAttributes() ?>>
<?php echo $barrio_vereda->consecutivo->ListViewValue() ?></span>
<?php } ?>
<a id="<?php echo $barrio_vereda_list->PageObjName . "_row_" . $barrio_vereda_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($barrio_vereda->Localidad->Visible) { // Localidad ?>
		<td<?php echo $barrio_vereda->Localidad->CellAttributes() ?>>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $barrio_vereda_list->RowCnt ?>_barrio_vereda_Localidad" class="control-group barrio_vereda_Localidad">
<select data-field="x_Localidad" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Localidad" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Localidad"<?php echo $barrio_vereda->Localidad->EditAttributes() ?>>
<?php
if (is_array($barrio_vereda->Localidad->EditValue)) {
	$arwrk = $barrio_vereda->Localidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($barrio_vereda->Localidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fbarrio_veredalist.Lists["x_Localidad"].Options = <?php echo (is_array($barrio_vereda->Localidad->EditValue)) ? ew_ArrayToJson($barrio_vereda->Localidad->EditValue, 1) : "[]" ?>;
</script>
</span>
<input type="hidden" data-field="x_Localidad" name="o<?php echo $barrio_vereda_list->RowIndex ?>_Localidad" id="o<?php echo $barrio_vereda_list->RowIndex ?>_Localidad" value="<?php echo ew_HtmlEncode($barrio_vereda->Localidad->OldValue) ?>">
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $barrio_vereda_list->RowCnt ?>_barrio_vereda_Localidad" class="control-group barrio_vereda_Localidad">
<select data-field="x_Localidad" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Localidad" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Localidad"<?php echo $barrio_vereda->Localidad->EditAttributes() ?>>
<?php
if (is_array($barrio_vereda->Localidad->EditValue)) {
	$arwrk = $barrio_vereda->Localidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($barrio_vereda->Localidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fbarrio_veredalist.Lists["x_Localidad"].Options = <?php echo (is_array($barrio_vereda->Localidad->EditValue)) ? ew_ArrayToJson($barrio_vereda->Localidad->EditValue, 1) : "[]" ?>;
</script>
</span>
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_VIEW) { // View record ?>
<span<?php echo $barrio_vereda->Localidad->ViewAttributes() ?>>
<?php echo $barrio_vereda->Localidad->ListViewValue() ?></span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($barrio_vereda->Barrio_Vereda->Visible) { // Barrio_Vereda ?>
		<td<?php echo $barrio_vereda->Barrio_Vereda->CellAttributes() ?>>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $barrio_vereda_list->RowCnt ?>_barrio_vereda_Barrio_Vereda" class="control-group barrio_vereda_Barrio_Vereda">
<input type="text" data-field="x_Barrio_Vereda" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($barrio_vereda->Barrio_Vereda->PlaceHolder) ?>" value="<?php echo $barrio_vereda->Barrio_Vereda->EditValue ?>"<?php echo $barrio_vereda->Barrio_Vereda->EditAttributes() ?>>
</span>
<input type="hidden" data-field="x_Barrio_Vereda" name="o<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" id="o<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" value="<?php echo ew_HtmlEncode($barrio_vereda->Barrio_Vereda->OldValue) ?>">
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $barrio_vereda_list->RowCnt ?>_barrio_vereda_Barrio_Vereda" class="control-group barrio_vereda_Barrio_Vereda">
<input type="text" data-field="x_Barrio_Vereda" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($barrio_vereda->Barrio_Vereda->PlaceHolder) ?>" value="<?php echo $barrio_vereda->Barrio_Vereda->EditValue ?>"<?php echo $barrio_vereda->Barrio_Vereda->EditAttributes() ?>>
</span>
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_VIEW) { // View record ?>
<span<?php echo $barrio_vereda->Barrio_Vereda->ViewAttributes() ?>>
<?php echo $barrio_vereda->Barrio_Vereda->ListViewValue() ?></span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($barrio_vereda->Zona->Visible) { // Zona ?>
		<td<?php echo $barrio_vereda->Zona->CellAttributes() ?>>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $barrio_vereda_list->RowCnt ?>_barrio_vereda_Zona" class="control-group barrio_vereda_Zona">
<select data-field="x_Zona" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Zona" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Zona"<?php echo $barrio_vereda->Zona->EditAttributes() ?>>
<?php
if (is_array($barrio_vereda->Zona->EditValue)) {
	$arwrk = $barrio_vereda->Zona->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($barrio_vereda->Zona->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fbarrio_veredalist.Lists["x_Zona"].Options = <?php echo (is_array($barrio_vereda->Zona->EditValue)) ? ew_ArrayToJson($barrio_vereda->Zona->EditValue, 1) : "[]" ?>;
</script>
</span>
<input type="hidden" data-field="x_Zona" name="o<?php echo $barrio_vereda_list->RowIndex ?>_Zona" id="o<?php echo $barrio_vereda_list->RowIndex ?>_Zona" value="<?php echo ew_HtmlEncode($barrio_vereda->Zona->OldValue) ?>">
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $barrio_vereda_list->RowCnt ?>_barrio_vereda_Zona" class="control-group barrio_vereda_Zona">
<select data-field="x_Zona" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Zona" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Zona"<?php echo $barrio_vereda->Zona->EditAttributes() ?>>
<?php
if (is_array($barrio_vereda->Zona->EditValue)) {
	$arwrk = $barrio_vereda->Zona->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($barrio_vereda->Zona->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fbarrio_veredalist.Lists["x_Zona"].Options = <?php echo (is_array($barrio_vereda->Zona->EditValue)) ? ew_ArrayToJson($barrio_vereda->Zona->EditValue, 1) : "[]" ?>;
</script>
</span>
<?php } ?>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_VIEW) { // View record ?>
<span<?php echo $barrio_vereda->Zona->ViewAttributes() ?>>
<?php echo $barrio_vereda->Zona->ListViewValue() ?></span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$barrio_vereda_list->ListOptions->Render("body", "right", $barrio_vereda_list->RowCnt);
?>
	</tr>
<?php if ($barrio_vereda->RowType == EW_ROWTYPE_ADD || $barrio_vereda->RowType == EW_ROWTYPE_EDIT) { ?>
<script type="text/javascript">
fbarrio_veredalist.UpdateOpts(<?php echo $barrio_vereda_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if ($barrio_vereda->CurrentAction <> "gridadd")
		if (!$barrio_vereda_list->Recordset->EOF) $barrio_vereda_list->Recordset->MoveNext();
}
?>
<?php
	if ($barrio_vereda->CurrentAction == "gridadd" || $barrio_vereda->CurrentAction == "gridedit") {
		$barrio_vereda_list->RowIndex = '$rowindex$';
		$barrio_vereda_list->LoadDefaultValues();

		// Set row properties
		$barrio_vereda->ResetAttrs();
		$barrio_vereda->RowAttrs = array_merge($barrio_vereda->RowAttrs, array('data-rowindex'=>$barrio_vereda_list->RowIndex, 'id'=>'r0_barrio_vereda', 'data-rowtype'=>EW_ROWTYPE_ADD));
		ew_AppendClass($barrio_vereda->RowAttrs["class"], "ewTemplate");
		$barrio_vereda->RowType = EW_ROWTYPE_ADD;

		// Render row
		$barrio_vereda_list->RenderRow();

		// Render list options
		$barrio_vereda_list->RenderListOptions();
		$barrio_vereda_list->StartRowCnt = 0;
?>
	<tr<?php echo $barrio_vereda->RowAttributes() ?>>
<?php

// Render list options (body, left)
$barrio_vereda_list->ListOptions->Render("body", "left", $barrio_vereda_list->RowIndex);
?>
	<?php if ($barrio_vereda->consecutivo->Visible) { // consecutivo ?>
		<td>
<input type="hidden" data-field="x_consecutivo" name="o<?php echo $barrio_vereda_list->RowIndex ?>_consecutivo" id="o<?php echo $barrio_vereda_list->RowIndex ?>_consecutivo" value="<?php echo ew_HtmlEncode($barrio_vereda->consecutivo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($barrio_vereda->Localidad->Visible) { // Localidad ?>
		<td>
<span id="el$rowindex$_barrio_vereda_Localidad" class="control-group barrio_vereda_Localidad">
<select data-field="x_Localidad" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Localidad" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Localidad"<?php echo $barrio_vereda->Localidad->EditAttributes() ?>>
<?php
if (is_array($barrio_vereda->Localidad->EditValue)) {
	$arwrk = $barrio_vereda->Localidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($barrio_vereda->Localidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fbarrio_veredalist.Lists["x_Localidad"].Options = <?php echo (is_array($barrio_vereda->Localidad->EditValue)) ? ew_ArrayToJson($barrio_vereda->Localidad->EditValue, 1) : "[]" ?>;
</script>
</span>
<input type="hidden" data-field="x_Localidad" name="o<?php echo $barrio_vereda_list->RowIndex ?>_Localidad" id="o<?php echo $barrio_vereda_list->RowIndex ?>_Localidad" value="<?php echo ew_HtmlEncode($barrio_vereda->Localidad->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($barrio_vereda->Barrio_Vereda->Visible) { // Barrio_Vereda ?>
		<td>
<span id="el$rowindex$_barrio_vereda_Barrio_Vereda" class="control-group barrio_vereda_Barrio_Vereda">
<input type="text" data-field="x_Barrio_Vereda" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($barrio_vereda->Barrio_Vereda->PlaceHolder) ?>" value="<?php echo $barrio_vereda->Barrio_Vereda->EditValue ?>"<?php echo $barrio_vereda->Barrio_Vereda->EditAttributes() ?>>
</span>
<input type="hidden" data-field="x_Barrio_Vereda" name="o<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" id="o<?php echo $barrio_vereda_list->RowIndex ?>_Barrio_Vereda" value="<?php echo ew_HtmlEncode($barrio_vereda->Barrio_Vereda->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($barrio_vereda->Zona->Visible) { // Zona ?>
		<td>
<span id="el$rowindex$_barrio_vereda_Zona" class="control-group barrio_vereda_Zona">
<select data-field="x_Zona" id="x<?php echo $barrio_vereda_list->RowIndex ?>_Zona" name="x<?php echo $barrio_vereda_list->RowIndex ?>_Zona"<?php echo $barrio_vereda->Zona->EditAttributes() ?>>
<?php
if (is_array($barrio_vereda->Zona->EditValue)) {
	$arwrk = $barrio_vereda->Zona->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($barrio_vereda->Zona->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fbarrio_veredalist.Lists["x_Zona"].Options = <?php echo (is_array($barrio_vereda->Zona->EditValue)) ? ew_ArrayToJson($barrio_vereda->Zona->EditValue, 1) : "[]" ?>;
</script>
</span>
<input type="hidden" data-field="x_Zona" name="o<?php echo $barrio_vereda_list->RowIndex ?>_Zona" id="o<?php echo $barrio_vereda_list->RowIndex ?>_Zona" value="<?php echo ew_HtmlEncode($barrio_vereda->Zona->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$barrio_vereda_list->ListOptions->Render("body", "right", $barrio_vereda_list->RowCnt);
?>
<script type="text/javascript">
fbarrio_veredalist.UpdateOpts(<?php echo $barrio_vereda_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($barrio_vereda->CurrentAction == "gridedit") { ?>
<input type="hidden" name="a_list" id="a_list" value="gridupdate">
<input type="hidden" name="<?php echo $barrio_vereda_list->FormKeyCountName ?>" id="<?php echo $barrio_vereda_list->FormKeyCountName ?>" value="<?php echo $barrio_vereda_list->KeyCount ?>">
<?php echo $barrio_vereda_list->MultiSelectKey ?>
<?php } ?>
<?php if ($barrio_vereda->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($barrio_vereda_list->Recordset)
	$barrio_vereda_list->Recordset->Close();
?>
</td></tr></table>
<?php if ($barrio_vereda->Export == "") { ?>
<script type="text/javascript">
fbarrio_veredalistsrch.Init();
fbarrio_veredalist.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php } ?>
<?php
$barrio_vereda_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($barrio_vereda->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$barrio_vereda_list->Page_Terminate();
?>
