<?php

// Global variable for table object
$exportacion_nutricion = NULL;

//
// Table class for exportacion_nutricion
//
class cexportacion_nutricion extends cTable {
	var $Consecutivo;
	var $Entidad;
	var $Tipo_Documento;
	var $Documento;
	var $Fecha_Nacimiento;
	var $Genero;
	var $Nombres;
	var $Apellidos;
	var $Fecha_valoracion;
	var $Edad_Anos;
	var $Edad_Meses;
	var $Peso;
	var $Talla;
	var $IMC;
	var $DS_TallaEdad;
	var $DS_PesoTalla;
	var $DS_PesoEdad;
	var $DS_IMCEdad;
	var $Clasificacion_Talla_Edad;
	var $Clasificacion_Peso_Talla;
	var $Clasificacion_Peso_Edad;
	var $Clasificacion_IMC_Edad;
	var $Zona;
	var $Barrio_Vereda;
	var $Localidad_Comuna;
	var $Pertenencia_Etnica;
	var $Tipo_Regimen_Salud;
	var $Administradora_Salud;
	var $Entidad_Educativa;
	var $Grado_Escolar;
	var $Clasificado;
	var $Usuario;
	var $Fecha_edicion;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'exportacion_nutricion';
		$this->TableName = 'exportacion_nutricion';
		$this->TableType = 'VIEW';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = ew_AllowAddDeleteRow(); // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// Consecutivo
		$this->Consecutivo = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Consecutivo', 'Consecutivo', '`Consecutivo`', '`Consecutivo`', 19, -1, FALSE, '`Consecutivo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Consecutivo->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Consecutivo'] = &$this->Consecutivo;

		// Entidad
		$this->Entidad = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Entidad', 'Entidad', '`Entidad`', '`Entidad`', 200, -1, FALSE, '`Entidad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Entidad'] = &$this->Entidad;

		// Tipo_Documento
		$this->Tipo_Documento = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Tipo_Documento', 'Tipo_Documento', '`Tipo_Documento`', '`Tipo_Documento`', 200, -1, FALSE, '`Tipo_Documento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Tipo_Documento'] = &$this->Tipo_Documento;

		// Documento
		$this->Documento = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Documento', 'Documento', '`Documento`', '`Documento`', 200, -1, FALSE, '`Documento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Documento'] = &$this->Documento;

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Fecha_Nacimiento', 'Fecha_Nacimiento', '`Fecha_Nacimiento`', 'DATE_FORMAT(`Fecha_Nacimiento`, \'%d/%m/%Y\')', 133, 7, FALSE, '`Fecha_Nacimiento`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Fecha_Nacimiento->FldDefaultErrMsg = str_replace("%s", "/", $Language->Phrase("IncorrectDateDMY"));
		$this->fields['Fecha_Nacimiento'] = &$this->Fecha_Nacimiento;

		// Genero
		$this->Genero = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Genero', 'Genero', '`Genero`', '`Genero`', 200, -1, FALSE, '`Genero`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Genero'] = &$this->Genero;

		// Nombres
		$this->Nombres = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Nombres', 'Nombres', '`Nombres`', '`Nombres`', 200, -1, FALSE, '`Nombres`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Nombres'] = &$this->Nombres;

		// Apellidos
		$this->Apellidos = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Apellidos', 'Apellidos', '`Apellidos`', '`Apellidos`', 200, -1, FALSE, '`Apellidos`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Apellidos'] = &$this->Apellidos;

		// Fecha_valoracion
		$this->Fecha_valoracion = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Fecha_valoracion', 'Fecha_valoracion', '`Fecha_valoracion`', 'DATE_FORMAT(`Fecha_valoracion`, \'%d/%m/%Y\')', 133, 7, FALSE, '`Fecha_valoracion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Fecha_valoracion->FldDefaultErrMsg = str_replace("%s", "/", $Language->Phrase("IncorrectDateDMY"));
		$this->fields['Fecha_valoracion'] = &$this->Fecha_valoracion;

		// Edad_Anos
		$this->Edad_Anos = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Edad_Anos', 'Edad_Anos', '`Edad_Anos`', '`Edad_Anos`', 19, -1, FALSE, '`Edad_Anos`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Edad_Anos->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Edad_Anos'] = &$this->Edad_Anos;

		// Edad_Meses
		$this->Edad_Meses = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Edad_Meses', 'Edad_Meses', '`Edad_Meses`', '`Edad_Meses`', 19, -1, FALSE, '`Edad_Meses`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Edad_Meses->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Edad_Meses'] = &$this->Edad_Meses;

		// Peso
		$this->Peso = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Peso', 'Peso', '`Peso`', '`Peso`', 5, -1, FALSE, '`Peso`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Peso->FldDefaultErrMsg = str_replace(array("%1", "%2"), array("2", "200"), $Language->Phrase("IncorrectRange"));
		$this->fields['Peso'] = &$this->Peso;

		// Talla
		$this->Talla = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Talla', 'Talla', '`Talla`', '`Talla`', 5, -1, FALSE, '`Talla`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Talla->FldDefaultErrMsg = str_replace(array("%1", "%2"), array("30", "200"), $Language->Phrase("IncorrectRange"));
		$this->fields['Talla'] = &$this->Talla;

		// IMC
		$this->IMC = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_IMC', 'IMC', '`IMC`', '`IMC`', 4, -1, FALSE, '`IMC`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->IMC->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['IMC'] = &$this->IMC;

		// DS_TallaEdad
		$this->DS_TallaEdad = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_DS_TallaEdad', 'DS_TallaEdad', '`DS_TallaEdad`', '`DS_TallaEdad`', 4, -1, FALSE, '`DS_TallaEdad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_TallaEdad->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_TallaEdad'] = &$this->DS_TallaEdad;

		// DS_PesoTalla
		$this->DS_PesoTalla = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_DS_PesoTalla', 'DS_PesoTalla', '`DS_PesoTalla`', '`DS_PesoTalla`', 4, -1, FALSE, '`DS_PesoTalla`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_PesoTalla->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_PesoTalla'] = &$this->DS_PesoTalla;

		// DS_PesoEdad
		$this->DS_PesoEdad = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_DS_PesoEdad', 'DS_PesoEdad', '`DS_PesoEdad`', '`DS_PesoEdad`', 4, -1, FALSE, '`DS_PesoEdad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_PesoEdad->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_PesoEdad'] = &$this->DS_PesoEdad;

		// DS_IMCEdad
		$this->DS_IMCEdad = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_DS_IMCEdad', 'DS_IMCEdad', '`DS_IMCEdad`', '`DS_IMCEdad`', 4, -1, FALSE, '`DS_IMCEdad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->DS_IMCEdad->FldDefaultErrMsg = $Language->Phrase("IncorrectFloat");
		$this->fields['DS_IMCEdad'] = &$this->DS_IMCEdad;

		// Clasificacion_Talla_Edad
		$this->Clasificacion_Talla_Edad = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Clasificacion_Talla_Edad', 'Clasificacion_Talla_Edad', '`Clasificacion_Talla_Edad`', '`Clasificacion_Talla_Edad`', 200, -1, FALSE, '`Clasificacion_Talla_Edad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_Talla_Edad'] = &$this->Clasificacion_Talla_Edad;

		// Clasificacion_Peso_Talla
		$this->Clasificacion_Peso_Talla = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Clasificacion_Peso_Talla', 'Clasificacion_Peso_Talla', '`Clasificacion_Peso_Talla`', '`Clasificacion_Peso_Talla`', 200, -1, FALSE, '`Clasificacion_Peso_Talla`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_Peso_Talla'] = &$this->Clasificacion_Peso_Talla;

		// Clasificacion_Peso_Edad
		$this->Clasificacion_Peso_Edad = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Clasificacion_Peso_Edad', 'Clasificacion_Peso_Edad', '`Clasificacion_Peso_Edad`', '`Clasificacion_Peso_Edad`', 200, -1, FALSE, '`Clasificacion_Peso_Edad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_Peso_Edad'] = &$this->Clasificacion_Peso_Edad;

		// Clasificacion_IMC_Edad
		$this->Clasificacion_IMC_Edad = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Clasificacion_IMC_Edad', 'Clasificacion_IMC_Edad', '`Clasificacion_IMC_Edad`', '`Clasificacion_IMC_Edad`', 200, -1, FALSE, '`Clasificacion_IMC_Edad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Clasificacion_IMC_Edad'] = &$this->Clasificacion_IMC_Edad;

		// Zona
		$this->Zona = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Zona', 'Zona', '`Zona`', '`Zona`', 200, -1, FALSE, '`Zona`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Zona'] = &$this->Zona;

		// Barrio_Vereda
		$this->Barrio_Vereda = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Barrio_Vereda', 'Barrio_Vereda', '`Barrio_Vereda`', '`Barrio_Vereda`', 200, -1, FALSE, '`Barrio_Vereda`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Barrio_Vereda'] = &$this->Barrio_Vereda;

		// Localidad_Comuna
		$this->Localidad_Comuna = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Localidad_Comuna', 'Localidad_Comuna', '`Localidad_Comuna`', '`Localidad_Comuna`', 200, -1, FALSE, '`Localidad_Comuna`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Localidad_Comuna'] = &$this->Localidad_Comuna;

		// Pertenencia_Etnica
		$this->Pertenencia_Etnica = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Pertenencia_Etnica', 'Pertenencia_Etnica', '`Pertenencia_Etnica`', '`Pertenencia_Etnica`', 200, -1, FALSE, '`Pertenencia_Etnica`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Pertenencia_Etnica'] = &$this->Pertenencia_Etnica;

		// Tipo_Regimen_Salud
		$this->Tipo_Regimen_Salud = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Tipo_Regimen_Salud', 'Tipo_Regimen_Salud', '`Tipo_Regimen_Salud`', '`Tipo_Regimen_Salud`', 200, -1, FALSE, '`Tipo_Regimen_Salud`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Tipo_Regimen_Salud'] = &$this->Tipo_Regimen_Salud;

		// Administradora_Salud
		$this->Administradora_Salud = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Administradora_Salud', 'Administradora_Salud', '`Administradora_Salud`', '`Administradora_Salud`', 200, -1, FALSE, '`Administradora_Salud`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Administradora_Salud'] = &$this->Administradora_Salud;

		// Entidad_Educativa
		$this->Entidad_Educativa = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Entidad_Educativa', 'Entidad_Educativa', '`Entidad_Educativa`', '`Entidad_Educativa`', 200, -1, FALSE, '`Entidad_Educativa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Entidad_Educativa'] = &$this->Entidad_Educativa;

		// Grado_Escolar
		$this->Grado_Escolar = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Grado_Escolar', 'Grado_Escolar', '`Grado_Escolar`', '`Grado_Escolar`', 200, -1, FALSE, '`Grado_Escolar`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Grado_Escolar'] = &$this->Grado_Escolar;

		// Clasificado
		$this->Clasificado = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Clasificado', 'Clasificado', '`Clasificado`', '`Clasificado`', 16, -1, FALSE, '`Clasificado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Clasificado->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Clasificado'] = &$this->Clasificado;

		// Usuario
		$this->Usuario = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Usuario', 'Usuario', '`Usuario`', '`Usuario`', 200, -1, FALSE, '`Usuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Usuario'] = &$this->Usuario;

		// Fecha_edicion
		$this->Fecha_edicion = new cField('exportacion_nutricion', 'exportacion_nutricion', 'x_Fecha_edicion', 'Fecha_edicion', '`Fecha_edicion`', 'DATE_FORMAT(`Fecha_edicion`, \'%d/%m/%Y\')', 133, 7, FALSE, '`Fecha_edicion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Fecha_edicion->FldDefaultErrMsg = str_replace("%s", "/", $Language->Phrase("IncorrectDateDMY"));
		$this->fields['Fecha_edicion'] = &$this->Fecha_edicion;
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	function SqlFrom() { // From
		return "`exportacion_nutricion`";
	}

	function SqlSelect() { // Select
		return "SELECT * FROM " . $this->SqlFrom();
	}

	function SqlWhere() { // Where
		$sWhere = "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlGroupBy() { // Group By
		return "";
	}

	function SqlHaving() { // Having
		return "";
	}

	function SqlOrderBy() { // Order By
		return "";
	}

	// Check if Anonymous User is allowed
	function AllowAnonymousUser() {
		switch (@$this->PageID) {
			case "add":
			case "register":
			case "addopt":
				return FALSE;
			case "edit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return FALSE;
			case "delete":
				return FALSE;
			case "view":
				return FALSE;
			case "search":
				return FALSE;
			default:
				return FALSE;
		}
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(),
			$this->SqlGroupBy(), $this->SqlHaving(), $this->SqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$sFilter = $this->CurrentFilter;
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(),
			$this->SqlGroupBy(), $this->SqlHaving(), $this->SqlOrderBy(),
			$sFilter, $sSort);
	}

	// Table SQL with List page filter
	function SelectSQL() {
		$sFilter = $this->getSessionWhere();
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(), $this->SqlGroupBy(),
			$this->SqlHaving(), $this->SqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->SqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sSql) {
		global $conn;
		$cnt = -1;
		if ($this->TableType == 'TABLE' || $this->TableType == 'VIEW') {
			$sSql = "SELECT COUNT(*) FROM" . preg_replace('/^SELECT\s([\s\S]+)?\*\sFROM/i', "", $sSql);
			$sOrderBy = $this->GetOrderBy();
			if (substr($sSql, strlen($sOrderBy) * -1) == $sOrderBy)
				$sSql = substr($sSql, 0, strlen($sSql) - strlen($sOrderBy)); // Remove ORDER BY clause
		} else {
			$sSql = "SELECT COUNT(*) FROM (" . $sSql . ") EW_COUNT_TABLE";
		}
		if ($rs = $conn->Execute($sSql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($sFilter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $sFilter;
		$this->Recordset_Selecting($this->CurrentFilter);

		//$sSql = $this->SQL();
		$sSql = $this->GetSQL($this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function SelectRecordCount() {
		global $conn;
		$origFilter = $this->CurrentFilter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$sSql = $this->SelectSQL();
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $conn->Execute($sSql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Update Table
	var $UpdateTable = "`exportacion_nutricion`";

	// INSERT statement
	function InsertSQL(&$rs) {
		global $conn;
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]))
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType) . ",";
		}
		while (substr($names, -1) == ",")
			$names = substr($names, 0, -1);
		while (substr($values, -1) == ",")
			$values = substr($values, 0, -1);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		global $conn;
		return $conn->Execute($this->InsertSQL($rs));
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "") {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]))
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType) . ",";
		}
		while (substr($sql, -1) == ",")
			$sql = substr($sql, 0, -1);
		$filter = $this->CurrentFilter;
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL) {
		global $conn;
		return $conn->Execute($this->UpdateSQL($rs, $where));
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "") {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if ($rs) {
			if (array_key_exists('Consecutivo', $rs))
				ew_AddFilter($where, ew_QuotedName('Consecutivo') . '=' . ew_QuotedValue($rs['Consecutivo'], $this->Consecutivo->FldDataType));
		}
		$filter = $this->CurrentFilter;
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "") {
		global $conn;
		return $conn->Execute($this->DeleteSQL($rs, $where));
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`Consecutivo` = @Consecutivo@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->Consecutivo->CurrentValue))
			$sKeyFilter = "0=1"; // Invalid key
		$sKeyFilter = str_replace("@Consecutivo@", ew_AdjustSql($this->Consecutivo->CurrentValue), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "exportacion_nutricionlist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// List URL
	function GetListUrl() {
		return "exportacion_nutricionlist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			return $this->KeyUrl("exportacion_nutricionview.php", $this->UrlParm($parm));
		else
			return $this->KeyUrl("exportacion_nutricionview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
	}

	// Add URL
	function GetAddUrl() {
		return "exportacion_nutricionadd.php";
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		return $this->KeyUrl("exportacion_nutricionedit.php", $this->UrlParm($parm));
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		return $this->KeyUrl("exportacion_nutricionadd.php", $this->UrlParm($parm));
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("exportacion_nutriciondelete.php", $this->UrlParm());
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->Consecutivo->CurrentValue)) {
			$sUrl .= "Consecutivo=" . urlencode($this->Consecutivo->CurrentValue);
		} else {
			return "javascript:alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return ew_CurrentPage() . "?" . $sUrlParm;
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = ew_StripSlashes($_POST["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = ew_StripSlashes($_GET["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET)) {
			$arKeys[] = @$_GET["Consecutivo"]; // Consecutivo

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		foreach ($arKeys as $key) {
			if (!is_numeric($key))
				continue;
			$ar[] = $key;
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->Consecutivo->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($sFilter) {
		global $conn;

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $sFilter;
		//$sSql = $this->SQL();

		$sSql = $this->GetSQL($sFilter, "");
		$rs = $conn->Execute($sSql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->Tipo_Documento->setDbValue($rs->fields('Tipo_Documento'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Fecha_valoracion->setDbValue($rs->fields('Fecha_valoracion'));
		$this->Edad_Anos->setDbValue($rs->fields('Edad_Anos'));
		$this->Edad_Meses->setDbValue($rs->fields('Edad_Meses'));
		$this->Peso->setDbValue($rs->fields('Peso'));
		$this->Talla->setDbValue($rs->fields('Talla'));
		$this->IMC->setDbValue($rs->fields('IMC'));
		$this->DS_TallaEdad->setDbValue($rs->fields('DS_TallaEdad'));
		$this->DS_PesoTalla->setDbValue($rs->fields('DS_PesoTalla'));
		$this->DS_PesoEdad->setDbValue($rs->fields('DS_PesoEdad'));
		$this->DS_IMCEdad->setDbValue($rs->fields('DS_IMCEdad'));
		$this->Clasificacion_Talla_Edad->setDbValue($rs->fields('Clasificacion_Talla_Edad'));
		$this->Clasificacion_Peso_Talla->setDbValue($rs->fields('Clasificacion_Peso_Talla'));
		$this->Clasificacion_Peso_Edad->setDbValue($rs->fields('Clasificacion_Peso_Edad'));
		$this->Clasificacion_IMC_Edad->setDbValue($rs->fields('Clasificacion_IMC_Edad'));
		$this->Zona->setDbValue($rs->fields('Zona'));
		$this->Barrio_Vereda->setDbValue($rs->fields('Barrio_Vereda'));
		$this->Localidad_Comuna->setDbValue($rs->fields('Localidad_Comuna'));
		$this->Pertenencia_Etnica->setDbValue($rs->fields('Pertenencia_Etnica'));
		$this->Tipo_Regimen_Salud->setDbValue($rs->fields('Tipo_Regimen_Salud'));
		$this->Administradora_Salud->setDbValue($rs->fields('Administradora_Salud'));
		$this->Entidad_Educativa->setDbValue($rs->fields('Entidad_Educativa'));
		$this->Grado_Escolar->setDbValue($rs->fields('Grado_Escolar'));
		$this->Clasificado->setDbValue($rs->fields('Clasificado'));
		$this->Usuario->setDbValue($rs->fields('Usuario'));
		$this->Fecha_edicion->setDbValue($rs->fields('Fecha_edicion'));
	}

	// Render list row values
	function RenderListRow() {
		global $conn, $Security, $gsLanguage;

		// Call Row Rendering event
		$this->Row_Rendering();

   // Common render codes
		// Consecutivo
		// Entidad
		// Tipo_Documento
		// Documento
		// Fecha_Nacimiento
		// Genero
		// Nombres
		// Apellidos
		// Fecha_valoracion
		// Edad_Anos
		// Edad_Meses
		// Peso
		// Talla
		// IMC
		// DS_TallaEdad
		// DS_PesoTalla
		// DS_PesoEdad
		// DS_IMCEdad
		// Clasificacion_Talla_Edad
		// Clasificacion_Peso_Talla
		// Clasificacion_Peso_Edad
		// Clasificacion_IMC_Edad
		// Zona
		// Barrio_Vereda
		// Localidad_Comuna
		// Pertenencia_Etnica
		// Tipo_Regimen_Salud
		// Administradora_Salud
		// Entidad_Educativa
		// Grado_Escolar
		// Clasificado
		// Usuario
		// Fecha_edicion
		// Consecutivo

		$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
		$this->Consecutivo->ViewCustomAttributes = "";

		// Entidad
		$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
		$this->Entidad->ViewCustomAttributes = "";

		// Tipo_Documento
		$this->Tipo_Documento->ViewValue = $this->Tipo_Documento->CurrentValue;
		$this->Tipo_Documento->ViewCustomAttributes = "";

		// Documento
		$this->Documento->ViewValue = $this->Documento->CurrentValue;
		$this->Documento->ViewCustomAttributes = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
		$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 7);
		$this->Fecha_Nacimiento->ViewCustomAttributes = "";

		// Genero
		$this->Genero->ViewValue = $this->Genero->CurrentValue;
		$this->Genero->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Fecha_valoracion
		$this->Fecha_valoracion->ViewValue = $this->Fecha_valoracion->CurrentValue;
		$this->Fecha_valoracion->ViewValue = ew_FormatDateTime($this->Fecha_valoracion->ViewValue, 7);
		$this->Fecha_valoracion->ViewCustomAttributes = "";

		// Edad_Anos
		$this->Edad_Anos->ViewValue = $this->Edad_Anos->CurrentValue;
		$this->Edad_Anos->ViewCustomAttributes = "";

		// Edad_Meses
		$this->Edad_Meses->ViewValue = $this->Edad_Meses->CurrentValue;
		$this->Edad_Meses->ViewCustomAttributes = "";

		// Peso
		$this->Peso->ViewValue = $this->Peso->CurrentValue;
		$this->Peso->ViewCustomAttributes = "";

		// Talla
		$this->Talla->ViewValue = $this->Talla->CurrentValue;
		$this->Talla->ViewCustomAttributes = "";

		// IMC
		$this->IMC->ViewValue = $this->IMC->CurrentValue;
		$this->IMC->ViewValue = ew_FormatNumber($this->IMC->ViewValue, 2, 0, 0, 0);
		$this->IMC->CellCssStyle .= "text-align: right;";
		$this->IMC->ViewCustomAttributes = "";

		// DS_TallaEdad
		$this->DS_TallaEdad->ViewValue = $this->DS_TallaEdad->CurrentValue;
		$this->DS_TallaEdad->ViewCustomAttributes = "";

		// DS_PesoTalla
		$this->DS_PesoTalla->ViewValue = $this->DS_PesoTalla->CurrentValue;
		$this->DS_PesoTalla->ViewCustomAttributes = "";

		// DS_PesoEdad
		$this->DS_PesoEdad->ViewValue = $this->DS_PesoEdad->CurrentValue;
		$this->DS_PesoEdad->ViewCustomAttributes = "";

		// DS_IMCEdad
		$this->DS_IMCEdad->ViewValue = $this->DS_IMCEdad->CurrentValue;
		$this->DS_IMCEdad->ViewCustomAttributes = "";

		// Clasificacion_Talla_Edad
		$this->Clasificacion_Talla_Edad->ViewValue = $this->Clasificacion_Talla_Edad->CurrentValue;
		$this->Clasificacion_Talla_Edad->ViewCustomAttributes = "";

		// Clasificacion_Peso_Talla
		$this->Clasificacion_Peso_Talla->ViewValue = $this->Clasificacion_Peso_Talla->CurrentValue;
		$this->Clasificacion_Peso_Talla->ViewCustomAttributes = "";

		// Clasificacion_Peso_Edad
		$this->Clasificacion_Peso_Edad->ViewValue = $this->Clasificacion_Peso_Edad->CurrentValue;
		$this->Clasificacion_Peso_Edad->ViewCustomAttributes = "";

		// Clasificacion_IMC_Edad
		$this->Clasificacion_IMC_Edad->ViewValue = $this->Clasificacion_IMC_Edad->CurrentValue;
		$this->Clasificacion_IMC_Edad->ViewCustomAttributes = "";

		// Zona
		$this->Zona->ViewValue = $this->Zona->CurrentValue;
		$this->Zona->ViewCustomAttributes = "";

		// Barrio_Vereda
		$this->Barrio_Vereda->ViewValue = $this->Barrio_Vereda->CurrentValue;
		$this->Barrio_Vereda->ViewCustomAttributes = "";

		// Localidad_Comuna
		$this->Localidad_Comuna->ViewValue = $this->Localidad_Comuna->CurrentValue;
		$this->Localidad_Comuna->ViewCustomAttributes = "";

		// Pertenencia_Etnica
		$this->Pertenencia_Etnica->ViewValue = $this->Pertenencia_Etnica->CurrentValue;
		$this->Pertenencia_Etnica->ViewCustomAttributes = "";

		// Tipo_Regimen_Salud
		$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->CurrentValue;
		$this->Tipo_Regimen_Salud->ViewCustomAttributes = "";

		// Administradora_Salud
		$this->Administradora_Salud->ViewValue = $this->Administradora_Salud->CurrentValue;
		$this->Administradora_Salud->ViewCustomAttributes = "";

		// Entidad_Educativa
		$this->Entidad_Educativa->ViewValue = $this->Entidad_Educativa->CurrentValue;
		$this->Entidad_Educativa->ViewCustomAttributes = "";

		// Grado_Escolar
		$this->Grado_Escolar->ViewValue = $this->Grado_Escolar->CurrentValue;
		$this->Grado_Escolar->ViewCustomAttributes = "";

		// Clasificado
		if (strval($this->Clasificado->CurrentValue) <> "") {
			switch ($this->Clasificado->CurrentValue) {
				case $this->Clasificado->FldTagValue(1):
					$this->Clasificado->ViewValue = $this->Clasificado->FldTagCaption(1) <> "" ? $this->Clasificado->FldTagCaption(1) : $this->Clasificado->CurrentValue;
					break;
				case $this->Clasificado->FldTagValue(2):
					$this->Clasificado->ViewValue = $this->Clasificado->FldTagCaption(2) <> "" ? $this->Clasificado->FldTagCaption(2) : $this->Clasificado->CurrentValue;
					break;
				default:
					$this->Clasificado->ViewValue = $this->Clasificado->CurrentValue;
			}
		} else {
			$this->Clasificado->ViewValue = NULL;
		}
		$this->Clasificado->ViewCustomAttributes = "";

		// Usuario
		$this->Usuario->ViewValue = $this->Usuario->CurrentValue;
		$this->Usuario->ViewCustomAttributes = "";

		// Fecha_edicion
		$this->Fecha_edicion->ViewValue = $this->Fecha_edicion->CurrentValue;
		$this->Fecha_edicion->ViewValue = ew_FormatDateTime($this->Fecha_edicion->ViewValue, 7);
		$this->Fecha_edicion->ViewCustomAttributes = "";

		// Consecutivo
		$this->Consecutivo->LinkCustomAttributes = "";
		$this->Consecutivo->HrefValue = "";
		$this->Consecutivo->TooltipValue = "";

		// Entidad
		$this->Entidad->LinkCustomAttributes = "";
		$this->Entidad->HrefValue = "";
		$this->Entidad->TooltipValue = "";

		// Tipo_Documento
		$this->Tipo_Documento->LinkCustomAttributes = "";
		$this->Tipo_Documento->HrefValue = "";
		$this->Tipo_Documento->TooltipValue = "";

		// Documento
		$this->Documento->LinkCustomAttributes = "";
		$this->Documento->HrefValue = "";
		$this->Documento->TooltipValue = "";

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->LinkCustomAttributes = "";
		$this->Fecha_Nacimiento->HrefValue = "";
		$this->Fecha_Nacimiento->TooltipValue = "";

		// Genero
		$this->Genero->LinkCustomAttributes = "";
		$this->Genero->HrefValue = "";
		$this->Genero->TooltipValue = "";

		// Nombres
		$this->Nombres->LinkCustomAttributes = "";
		$this->Nombres->HrefValue = "";
		$this->Nombres->TooltipValue = "";

		// Apellidos
		$this->Apellidos->LinkCustomAttributes = "";
		$this->Apellidos->HrefValue = "";
		$this->Apellidos->TooltipValue = "";

		// Fecha_valoracion
		$this->Fecha_valoracion->LinkCustomAttributes = "";
		$this->Fecha_valoracion->HrefValue = "";
		$this->Fecha_valoracion->TooltipValue = "";

		// Edad_Anos
		$this->Edad_Anos->LinkCustomAttributes = "";
		$this->Edad_Anos->HrefValue = "";
		$this->Edad_Anos->TooltipValue = "";

		// Edad_Meses
		$this->Edad_Meses->LinkCustomAttributes = "";
		$this->Edad_Meses->HrefValue = "";
		$this->Edad_Meses->TooltipValue = "";

		// Peso
		$this->Peso->LinkCustomAttributes = "";
		$this->Peso->HrefValue = "";
		$this->Peso->TooltipValue = "";

		// Talla
		$this->Talla->LinkCustomAttributes = "";
		$this->Talla->HrefValue = "";
		$this->Talla->TooltipValue = "";

		// IMC
		$this->IMC->LinkCustomAttributes = "";
		$this->IMC->HrefValue = "";
		$this->IMC->TooltipValue = "";

		// DS_TallaEdad
		$this->DS_TallaEdad->LinkCustomAttributes = "";
		$this->DS_TallaEdad->HrefValue = "";
		$this->DS_TallaEdad->TooltipValue = "";

		// DS_PesoTalla
		$this->DS_PesoTalla->LinkCustomAttributes = "";
		$this->DS_PesoTalla->HrefValue = "";
		$this->DS_PesoTalla->TooltipValue = "";

		// DS_PesoEdad
		$this->DS_PesoEdad->LinkCustomAttributes = "";
		$this->DS_PesoEdad->HrefValue = "";
		$this->DS_PesoEdad->TooltipValue = "";

		// DS_IMCEdad
		$this->DS_IMCEdad->LinkCustomAttributes = "";
		$this->DS_IMCEdad->HrefValue = "";
		$this->DS_IMCEdad->TooltipValue = "";

		// Clasificacion_Talla_Edad
		$this->Clasificacion_Talla_Edad->LinkCustomAttributes = "";
		$this->Clasificacion_Talla_Edad->HrefValue = "";
		$this->Clasificacion_Talla_Edad->TooltipValue = "";

		// Clasificacion_Peso_Talla
		$this->Clasificacion_Peso_Talla->LinkCustomAttributes = "";
		$this->Clasificacion_Peso_Talla->HrefValue = "";
		$this->Clasificacion_Peso_Talla->TooltipValue = "";

		// Clasificacion_Peso_Edad
		$this->Clasificacion_Peso_Edad->LinkCustomAttributes = "";
		$this->Clasificacion_Peso_Edad->HrefValue = "";
		$this->Clasificacion_Peso_Edad->TooltipValue = "";

		// Clasificacion_IMC_Edad
		$this->Clasificacion_IMC_Edad->LinkCustomAttributes = "";
		$this->Clasificacion_IMC_Edad->HrefValue = "";
		$this->Clasificacion_IMC_Edad->TooltipValue = "";

		// Zona
		$this->Zona->LinkCustomAttributes = "";
		$this->Zona->HrefValue = "";
		$this->Zona->TooltipValue = "";

		// Barrio_Vereda
		$this->Barrio_Vereda->LinkCustomAttributes = "";
		$this->Barrio_Vereda->HrefValue = "";
		$this->Barrio_Vereda->TooltipValue = "";

		// Localidad_Comuna
		$this->Localidad_Comuna->LinkCustomAttributes = "";
		$this->Localidad_Comuna->HrefValue = "";
		$this->Localidad_Comuna->TooltipValue = "";

		// Pertenencia_Etnica
		$this->Pertenencia_Etnica->LinkCustomAttributes = "";
		$this->Pertenencia_Etnica->HrefValue = "";
		$this->Pertenencia_Etnica->TooltipValue = "";

		// Tipo_Regimen_Salud
		$this->Tipo_Regimen_Salud->LinkCustomAttributes = "";
		$this->Tipo_Regimen_Salud->HrefValue = "";
		$this->Tipo_Regimen_Salud->TooltipValue = "";

		// Administradora_Salud
		$this->Administradora_Salud->LinkCustomAttributes = "";
		$this->Administradora_Salud->HrefValue = "";
		$this->Administradora_Salud->TooltipValue = "";

		// Entidad_Educativa
		$this->Entidad_Educativa->LinkCustomAttributes = "";
		$this->Entidad_Educativa->HrefValue = "";
		$this->Entidad_Educativa->TooltipValue = "";

		// Grado_Escolar
		$this->Grado_Escolar->LinkCustomAttributes = "";
		$this->Grado_Escolar->HrefValue = "";
		$this->Grado_Escolar->TooltipValue = "";

		// Clasificado
		$this->Clasificado->LinkCustomAttributes = "";
		$this->Clasificado->HrefValue = "";
		$this->Clasificado->TooltipValue = "";

		// Usuario
		$this->Usuario->LinkCustomAttributes = "";
		$this->Usuario->HrefValue = "";
		$this->Usuario->TooltipValue = "";

		// Fecha_edicion
		$this->Fecha_edicion->LinkCustomAttributes = "";
		$this->Fecha_edicion->HrefValue = "";
		$this->Fecha_edicion->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;

		// Write header
		$Doc->ExportTableHeader();
		if ($Doc->Horizontal) { // Horizontal format, write header
			$Doc->BeginExportRow();
			if ($ExportPageType == "view") {
				if ($this->Entidad->Exportable) $Doc->ExportCaption($this->Entidad);
				if ($this->Tipo_Documento->Exportable) $Doc->ExportCaption($this->Tipo_Documento);
				if ($this->Documento->Exportable) $Doc->ExportCaption($this->Documento);
				if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportCaption($this->Fecha_Nacimiento);
				if ($this->Genero->Exportable) $Doc->ExportCaption($this->Genero);
				if ($this->Nombres->Exportable) $Doc->ExportCaption($this->Nombres);
				if ($this->Apellidos->Exportable) $Doc->ExportCaption($this->Apellidos);
				if ($this->Fecha_valoracion->Exportable) $Doc->ExportCaption($this->Fecha_valoracion);
				if ($this->Edad_Anos->Exportable) $Doc->ExportCaption($this->Edad_Anos);
				if ($this->Edad_Meses->Exportable) $Doc->ExportCaption($this->Edad_Meses);
				if ($this->Peso->Exportable) $Doc->ExportCaption($this->Peso);
				if ($this->Talla->Exportable) $Doc->ExportCaption($this->Talla);
				if ($this->IMC->Exportable) $Doc->ExportCaption($this->IMC);
				if ($this->DS_TallaEdad->Exportable) $Doc->ExportCaption($this->DS_TallaEdad);
				if ($this->DS_PesoTalla->Exportable) $Doc->ExportCaption($this->DS_PesoTalla);
				if ($this->DS_PesoEdad->Exportable) $Doc->ExportCaption($this->DS_PesoEdad);
				if ($this->DS_IMCEdad->Exportable) $Doc->ExportCaption($this->DS_IMCEdad);
				if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Talla_Edad);
				if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Talla);
				if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Edad);
				if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_IMC_Edad);
				if ($this->Zona->Exportable) $Doc->ExportCaption($this->Zona);
				if ($this->Barrio_Vereda->Exportable) $Doc->ExportCaption($this->Barrio_Vereda);
				if ($this->Localidad_Comuna->Exportable) $Doc->ExportCaption($this->Localidad_Comuna);
				if ($this->Pertenencia_Etnica->Exportable) $Doc->ExportCaption($this->Pertenencia_Etnica);
				if ($this->Tipo_Regimen_Salud->Exportable) $Doc->ExportCaption($this->Tipo_Regimen_Salud);
				if ($this->Administradora_Salud->Exportable) $Doc->ExportCaption($this->Administradora_Salud);
				if ($this->Entidad_Educativa->Exportable) $Doc->ExportCaption($this->Entidad_Educativa);
				if ($this->Grado_Escolar->Exportable) $Doc->ExportCaption($this->Grado_Escolar);
				if ($this->Clasificado->Exportable) $Doc->ExportCaption($this->Clasificado);
				if ($this->Usuario->Exportable) $Doc->ExportCaption($this->Usuario);
				if ($this->Fecha_edicion->Exportable) $Doc->ExportCaption($this->Fecha_edicion);
			} else {
				if ($this->Consecutivo->Exportable) $Doc->ExportCaption($this->Consecutivo);
				if ($this->Entidad->Exportable) $Doc->ExportCaption($this->Entidad);
				if ($this->Documento->Exportable) $Doc->ExportCaption($this->Documento);
				if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportCaption($this->Fecha_Nacimiento);
				if ($this->Genero->Exportable) $Doc->ExportCaption($this->Genero);
				if ($this->Nombres->Exportable) $Doc->ExportCaption($this->Nombres);
				if ($this->Apellidos->Exportable) $Doc->ExportCaption($this->Apellidos);
				if ($this->Fecha_valoracion->Exportable) $Doc->ExportCaption($this->Fecha_valoracion);
				if ($this->Edad_Anos->Exportable) $Doc->ExportCaption($this->Edad_Anos);
				if ($this->Edad_Meses->Exportable) $Doc->ExportCaption($this->Edad_Meses);
				if ($this->Peso->Exportable) $Doc->ExportCaption($this->Peso);
				if ($this->Talla->Exportable) $Doc->ExportCaption($this->Talla);
				if ($this->IMC->Exportable) $Doc->ExportCaption($this->IMC);
				if ($this->DS_TallaEdad->Exportable) $Doc->ExportCaption($this->DS_TallaEdad);
				if ($this->DS_PesoTalla->Exportable) $Doc->ExportCaption($this->DS_PesoTalla);
				if ($this->DS_PesoEdad->Exportable) $Doc->ExportCaption($this->DS_PesoEdad);
				if ($this->DS_IMCEdad->Exportable) $Doc->ExportCaption($this->DS_IMCEdad);
				if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Talla_Edad);
				if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Talla);
				if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_Peso_Edad);
				if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportCaption($this->Clasificacion_IMC_Edad);
				if ($this->Tipo_Regimen_Salud->Exportable) $Doc->ExportCaption($this->Tipo_Regimen_Salud);
				if ($this->Administradora_Salud->Exportable) $Doc->ExportCaption($this->Administradora_Salud);
				if ($this->Entidad_Educativa->Exportable) $Doc->ExportCaption($this->Entidad_Educativa);
				if ($this->Grado_Escolar->Exportable) $Doc->ExportCaption($this->Grado_Escolar);
				if ($this->Clasificado->Exportable) $Doc->ExportCaption($this->Clasificado);
				if ($this->Usuario->Exportable) $Doc->ExportCaption($this->Usuario);
				if ($this->Fecha_edicion->Exportable) $Doc->ExportCaption($this->Fecha_edicion);
			}
			$Doc->EndExportRow();
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
				if ($ExportPageType == "view") {
					if ($this->Entidad->Exportable) $Doc->ExportField($this->Entidad);
					if ($this->Tipo_Documento->Exportable) $Doc->ExportField($this->Tipo_Documento);
					if ($this->Documento->Exportable) $Doc->ExportField($this->Documento);
					if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportField($this->Fecha_Nacimiento);
					if ($this->Genero->Exportable) $Doc->ExportField($this->Genero);
					if ($this->Nombres->Exportable) $Doc->ExportField($this->Nombres);
					if ($this->Apellidos->Exportable) $Doc->ExportField($this->Apellidos);
					if ($this->Fecha_valoracion->Exportable) $Doc->ExportField($this->Fecha_valoracion);
					if ($this->Edad_Anos->Exportable) $Doc->ExportField($this->Edad_Anos);
					if ($this->Edad_Meses->Exportable) $Doc->ExportField($this->Edad_Meses);
					if ($this->Peso->Exportable) $Doc->ExportField($this->Peso);
					if ($this->Talla->Exportable) $Doc->ExportField($this->Talla);
					if ($this->IMC->Exportable) $Doc->ExportField($this->IMC);
					if ($this->DS_TallaEdad->Exportable) $Doc->ExportField($this->DS_TallaEdad);
					if ($this->DS_PesoTalla->Exportable) $Doc->ExportField($this->DS_PesoTalla);
					if ($this->DS_PesoEdad->Exportable) $Doc->ExportField($this->DS_PesoEdad);
					if ($this->DS_IMCEdad->Exportable) $Doc->ExportField($this->DS_IMCEdad);
					if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Talla_Edad);
					if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Talla);
					if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Edad);
					if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportField($this->Clasificacion_IMC_Edad);
					if ($this->Zona->Exportable) $Doc->ExportField($this->Zona);
					if ($this->Barrio_Vereda->Exportable) $Doc->ExportField($this->Barrio_Vereda);
					if ($this->Localidad_Comuna->Exportable) $Doc->ExportField($this->Localidad_Comuna);
					if ($this->Pertenencia_Etnica->Exportable) $Doc->ExportField($this->Pertenencia_Etnica);
					if ($this->Tipo_Regimen_Salud->Exportable) $Doc->ExportField($this->Tipo_Regimen_Salud);
					if ($this->Administradora_Salud->Exportable) $Doc->ExportField($this->Administradora_Salud);
					if ($this->Entidad_Educativa->Exportable) $Doc->ExportField($this->Entidad_Educativa);
					if ($this->Grado_Escolar->Exportable) $Doc->ExportField($this->Grado_Escolar);
					if ($this->Clasificado->Exportable) $Doc->ExportField($this->Clasificado);
					if ($this->Usuario->Exportable) $Doc->ExportField($this->Usuario);
					if ($this->Fecha_edicion->Exportable) $Doc->ExportField($this->Fecha_edicion);
				} else {
					if ($this->Consecutivo->Exportable) $Doc->ExportField($this->Consecutivo);
					if ($this->Entidad->Exportable) $Doc->ExportField($this->Entidad);
					if ($this->Documento->Exportable) $Doc->ExportField($this->Documento);
					if ($this->Fecha_Nacimiento->Exportable) $Doc->ExportField($this->Fecha_Nacimiento);
					if ($this->Genero->Exportable) $Doc->ExportField($this->Genero);
					if ($this->Nombres->Exportable) $Doc->ExportField($this->Nombres);
					if ($this->Apellidos->Exportable) $Doc->ExportField($this->Apellidos);
					if ($this->Fecha_valoracion->Exportable) $Doc->ExportField($this->Fecha_valoracion);
					if ($this->Edad_Anos->Exportable) $Doc->ExportField($this->Edad_Anos);
					if ($this->Edad_Meses->Exportable) $Doc->ExportField($this->Edad_Meses);
					if ($this->Peso->Exportable) $Doc->ExportField($this->Peso);
					if ($this->Talla->Exportable) $Doc->ExportField($this->Talla);
					if ($this->IMC->Exportable) $Doc->ExportField($this->IMC);
					if ($this->DS_TallaEdad->Exportable) $Doc->ExportField($this->DS_TallaEdad);
					if ($this->DS_PesoTalla->Exportable) $Doc->ExportField($this->DS_PesoTalla);
					if ($this->DS_PesoEdad->Exportable) $Doc->ExportField($this->DS_PesoEdad);
					if ($this->DS_IMCEdad->Exportable) $Doc->ExportField($this->DS_IMCEdad);
					if ($this->Clasificacion_Talla_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Talla_Edad);
					if ($this->Clasificacion_Peso_Talla->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Talla);
					if ($this->Clasificacion_Peso_Edad->Exportable) $Doc->ExportField($this->Clasificacion_Peso_Edad);
					if ($this->Clasificacion_IMC_Edad->Exportable) $Doc->ExportField($this->Clasificacion_IMC_Edad);
					if ($this->Tipo_Regimen_Salud->Exportable) $Doc->ExportField($this->Tipo_Regimen_Salud);
					if ($this->Administradora_Salud->Exportable) $Doc->ExportField($this->Administradora_Salud);
					if ($this->Entidad_Educativa->Exportable) $Doc->ExportField($this->Entidad_Educativa);
					if ($this->Grado_Escolar->Exportable) $Doc->ExportField($this->Grado_Escolar);
					if ($this->Clasificado->Exportable) $Doc->ExportField($this->Clasificado);
					if ($this->Usuario->Exportable) $Doc->ExportField($this->Usuario);
					if ($this->Fecha_edicion->Exportable) $Doc->ExportField($this->Fecha_edicion);
				}
				$Doc->EndExportRow();
			}
			$Recordset->MoveNext();
		}
		$Doc->ExportTableFooter();
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here	
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here	
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here	
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		// Enter your code here
	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here	
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>); 

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
