<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "exportacion_nutricioninfo.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$exportacion_nutricion_list = NULL; // Initialize page object first

class cexportacion_nutricion_list extends cexportacion_nutricion {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{5B1FB6D8-0E93-4F60-869F-153E389D6FED}";

	// Table name
	var $TableName = 'exportacion_nutricion';

	// Page object name
	var $PageObjName = 'exportacion_nutricion_list';

	// Grid form hidden field names
	var $FormName = 'fexportacion_nutricionlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (exportacion_nutricion)
		if (!isset($GLOBALS["exportacion_nutricion"]) || get_class($GLOBALS["exportacion_nutricion"]) == "cexportacion_nutricion") {
			$GLOBALS["exportacion_nutricion"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["exportacion_nutricion"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "exportacion_nutricionadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "exportacion_nutriciondelete.php";
		$this->MultiUpdateUrl = "exportacion_nutricionupdate.php";

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS['nutricion_usuario'])) $GLOBALS['nutricion_usuario'] = new cnutricion_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'exportacion_nutricion', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("login.php");
		}

		// Get export parameters
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->Consecutivo->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();
		$this->Usuario->Visible = !$this->IsAddOrEdit();
		$this->Fecha_edicion->Visible = !$this->IsAddOrEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Setup other options
		$this->SetupOtherOptions();

		// Set "checkbox" visible
		if (count($this->CustomActions) > 0)
			$this->ListOptions->Items["checkbox"]->Visible = TRUE;

		// Update url if printer friendly for Pdf
		if ($this->PrinterFriendlyForPdf)
			$this->ExportOptions->Items["pdf"]->Body = str_replace($this->ExportPdfUrl, $this->ExportPrintUrl . "&pdf=1", $this->ExportOptions->Items["pdf"]->Body);
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();
		if ($this->Export == "print" && @$_GET["pdf"] == "1") { // Printer friendly version and with pdf=1 in URL parameters
			$pdf = new cExportPdf($GLOBALS["Table"]);
			$pdf->Text = ob_get_contents(); // Set the content as the HTML of current page (printer friendly version)
			ob_end_clean();
			$pdf->Export();
		}

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 10;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process custom action first
			$this->ProcessCustomAction();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide export options
			if ($this->Export <> "" || $this->CurrentAction <> "")
				$this->ExportOptions->HideAllOptions();

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset
			if ($this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 10; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Export data only
		if (in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->Consecutivo->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->Consecutivo->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere() {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->Consecutivo, FALSE); // Consecutivo
		$this->BuildSearchSql($sWhere, $this->Entidad, FALSE); // Entidad
		$this->BuildSearchSql($sWhere, $this->Tipo_Documento, FALSE); // Tipo_Documento
		$this->BuildSearchSql($sWhere, $this->Documento, FALSE); // Documento
		$this->BuildSearchSql($sWhere, $this->Fecha_Nacimiento, FALSE); // Fecha_Nacimiento
		$this->BuildSearchSql($sWhere, $this->Genero, FALSE); // Genero
		$this->BuildSearchSql($sWhere, $this->Nombres, FALSE); // Nombres
		$this->BuildSearchSql($sWhere, $this->Apellidos, FALSE); // Apellidos
		$this->BuildSearchSql($sWhere, $this->Fecha_valoracion, FALSE); // Fecha_valoracion
		$this->BuildSearchSql($sWhere, $this->Edad_Anos, FALSE); // Edad_Anos
		$this->BuildSearchSql($sWhere, $this->Edad_Meses, FALSE); // Edad_Meses
		$this->BuildSearchSql($sWhere, $this->Peso, FALSE); // Peso
		$this->BuildSearchSql($sWhere, $this->Talla, FALSE); // Talla
		$this->BuildSearchSql($sWhere, $this->IMC, FALSE); // IMC
		$this->BuildSearchSql($sWhere, $this->DS_TallaEdad, FALSE); // DS_TallaEdad
		$this->BuildSearchSql($sWhere, $this->DS_PesoTalla, FALSE); // DS_PesoTalla
		$this->BuildSearchSql($sWhere, $this->DS_PesoEdad, FALSE); // DS_PesoEdad
		$this->BuildSearchSql($sWhere, $this->DS_IMCEdad, FALSE); // DS_IMCEdad
		$this->BuildSearchSql($sWhere, $this->Clasificacion_Talla_Edad, FALSE); // Clasificacion_Talla_Edad
		$this->BuildSearchSql($sWhere, $this->Clasificacion_Peso_Talla, FALSE); // Clasificacion_Peso_Talla
		$this->BuildSearchSql($sWhere, $this->Clasificacion_Peso_Edad, FALSE); // Clasificacion_Peso_Edad
		$this->BuildSearchSql($sWhere, $this->Clasificacion_IMC_Edad, FALSE); // Clasificacion_IMC_Edad
		$this->BuildSearchSql($sWhere, $this->Zona, FALSE); // Zona
		$this->BuildSearchSql($sWhere, $this->Barrio_Vereda, FALSE); // Barrio_Vereda
		$this->BuildSearchSql($sWhere, $this->Localidad_Comuna, FALSE); // Localidad_Comuna
		$this->BuildSearchSql($sWhere, $this->Pertenencia_Etnica, FALSE); // Pertenencia_Etnica
		$this->BuildSearchSql($sWhere, $this->Tipo_Regimen_Salud, FALSE); // Tipo_Regimen_Salud
		$this->BuildSearchSql($sWhere, $this->Administradora_Salud, FALSE); // Administradora_Salud
		$this->BuildSearchSql($sWhere, $this->Entidad_Educativa, FALSE); // Entidad_Educativa
		$this->BuildSearchSql($sWhere, $this->Grado_Escolar, FALSE); // Grado_Escolar
		$this->BuildSearchSql($sWhere, $this->Clasificado, FALSE); // Clasificado
		$this->BuildSearchSql($sWhere, $this->Usuario, FALSE); // Usuario
		$this->BuildSearchSql($sWhere, $this->Fecha_edicion, FALSE); // Fecha_edicion

		// Set up search parm
		if ($sWhere <> "") {
			$this->Command = "search";
		}
		if ($this->Command == "search") {
			$this->Consecutivo->AdvancedSearch->Save(); // Consecutivo
			$this->Entidad->AdvancedSearch->Save(); // Entidad
			$this->Tipo_Documento->AdvancedSearch->Save(); // Tipo_Documento
			$this->Documento->AdvancedSearch->Save(); // Documento
			$this->Fecha_Nacimiento->AdvancedSearch->Save(); // Fecha_Nacimiento
			$this->Genero->AdvancedSearch->Save(); // Genero
			$this->Nombres->AdvancedSearch->Save(); // Nombres
			$this->Apellidos->AdvancedSearch->Save(); // Apellidos
			$this->Fecha_valoracion->AdvancedSearch->Save(); // Fecha_valoracion
			$this->Edad_Anos->AdvancedSearch->Save(); // Edad_Anos
			$this->Edad_Meses->AdvancedSearch->Save(); // Edad_Meses
			$this->Peso->AdvancedSearch->Save(); // Peso
			$this->Talla->AdvancedSearch->Save(); // Talla
			$this->IMC->AdvancedSearch->Save(); // IMC
			$this->DS_TallaEdad->AdvancedSearch->Save(); // DS_TallaEdad
			$this->DS_PesoTalla->AdvancedSearch->Save(); // DS_PesoTalla
			$this->DS_PesoEdad->AdvancedSearch->Save(); // DS_PesoEdad
			$this->DS_IMCEdad->AdvancedSearch->Save(); // DS_IMCEdad
			$this->Clasificacion_Talla_Edad->AdvancedSearch->Save(); // Clasificacion_Talla_Edad
			$this->Clasificacion_Peso_Talla->AdvancedSearch->Save(); // Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Edad->AdvancedSearch->Save(); // Clasificacion_Peso_Edad
			$this->Clasificacion_IMC_Edad->AdvancedSearch->Save(); // Clasificacion_IMC_Edad
			$this->Zona->AdvancedSearch->Save(); // Zona
			$this->Barrio_Vereda->AdvancedSearch->Save(); // Barrio_Vereda
			$this->Localidad_Comuna->AdvancedSearch->Save(); // Localidad_Comuna
			$this->Pertenencia_Etnica->AdvancedSearch->Save(); // Pertenencia_Etnica
			$this->Tipo_Regimen_Salud->AdvancedSearch->Save(); // Tipo_Regimen_Salud
			$this->Administradora_Salud->AdvancedSearch->Save(); // Administradora_Salud
			$this->Entidad_Educativa->AdvancedSearch->Save(); // Entidad_Educativa
			$this->Grado_Escolar->AdvancedSearch->Save(); // Grado_Escolar
			$this->Clasificado->AdvancedSearch->Save(); // Clasificado
			$this->Usuario->AdvancedSearch->Save(); // Usuario
			$this->Fecha_edicion->AdvancedSearch->Save(); // Fecha_edicion
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $MultiValue) {
		$FldParm = substr($Fld->FldVar, 2);
		$FldVal = $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";

		//$FldVal = ew_StripSlashes($FldVal);
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);

		//$FldVal2 = ew_StripSlashes($FldVal2);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1 || $FldOpr <> "LIKE" ||
			($FldOpr2 <> "LIKE" && $FldVal2 <> ""))
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($Keyword) {
		$sKeyword = ew_AdjustSql($Keyword);
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Entidad, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Tipo_Documento, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Genero, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Nombres, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Apellidos, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Fecha_valoracion, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Clasificacion_Talla_Edad, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Clasificacion_Peso_Talla, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Clasificacion_Peso_Edad, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Clasificacion_IMC_Edad, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Zona, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Barrio_Vereda, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Localidad_Comuna, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Pertenencia_Etnica, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Tipo_Regimen_Salud, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Administradora_Salud, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Entidad_Educativa, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Grado_Escolar, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->Usuario, $Keyword);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $Keyword) {
		if ($Keyword == EW_NULL_VALUE) {
			$sWrk = $Fld->FldExpression . " IS NULL";
		} elseif ($Keyword == EW_NOT_NULL_VALUE) {
			$sWrk = $Fld->FldExpression . " IS NOT NULL";
		} else {
			$sFldExpression = ($Fld->FldVirtualExpression <> $Fld->FldExpression) ? $Fld->FldVirtualExpression : $Fld->FldBasicSearchExpression;
			$sWrk = $sFldExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING));
		}
		if ($Where <> "") $Where .= " OR ";
		$Where .= $sWrk;
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere() {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = $this->BasicSearch->Keyword;
		$sSearchType = $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				while (strpos($sSearch, "  ") !== FALSE)
					$sSearch = str_replace("  ", " ", $sSearch);
				$arKeyword = explode(" ", trim($sSearch));
				foreach ($arKeyword as $sKeyword) {
					if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
					$sSearchStr .= "(" . $this->BasicSearchSQL($sKeyword) . ")";
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($sSearch);
			}
			$this->Command = "search";
		}
		if ($this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->Consecutivo->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Entidad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_Documento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Documento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Nacimiento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Genero->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Nombres->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Apellidos->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_valoracion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Edad_Anos->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Edad_Meses->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Peso->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Talla->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->IMC->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->DS_TallaEdad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->DS_PesoTalla->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->DS_PesoEdad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->DS_IMCEdad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Clasificacion_Talla_Edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Clasificacion_Peso_Talla->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Clasificacion_Peso_Edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Clasificacion_IMC_Edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Zona->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Barrio_Vereda->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Localidad_Comuna->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Pertenencia_Etnica->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_Regimen_Salud->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Administradora_Salud->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Entidad_Educativa->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Grado_Escolar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Clasificado->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Usuario->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_edicion->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->Consecutivo->AdvancedSearch->UnsetSession();
		$this->Entidad->AdvancedSearch->UnsetSession();
		$this->Tipo_Documento->AdvancedSearch->UnsetSession();
		$this->Documento->AdvancedSearch->UnsetSession();
		$this->Fecha_Nacimiento->AdvancedSearch->UnsetSession();
		$this->Genero->AdvancedSearch->UnsetSession();
		$this->Nombres->AdvancedSearch->UnsetSession();
		$this->Apellidos->AdvancedSearch->UnsetSession();
		$this->Fecha_valoracion->AdvancedSearch->UnsetSession();
		$this->Edad_Anos->AdvancedSearch->UnsetSession();
		$this->Edad_Meses->AdvancedSearch->UnsetSession();
		$this->Peso->AdvancedSearch->UnsetSession();
		$this->Talla->AdvancedSearch->UnsetSession();
		$this->IMC->AdvancedSearch->UnsetSession();
		$this->DS_TallaEdad->AdvancedSearch->UnsetSession();
		$this->DS_PesoTalla->AdvancedSearch->UnsetSession();
		$this->DS_PesoEdad->AdvancedSearch->UnsetSession();
		$this->DS_IMCEdad->AdvancedSearch->UnsetSession();
		$this->Clasificacion_Talla_Edad->AdvancedSearch->UnsetSession();
		$this->Clasificacion_Peso_Talla->AdvancedSearch->UnsetSession();
		$this->Clasificacion_Peso_Edad->AdvancedSearch->UnsetSession();
		$this->Clasificacion_IMC_Edad->AdvancedSearch->UnsetSession();
		$this->Zona->AdvancedSearch->UnsetSession();
		$this->Barrio_Vereda->AdvancedSearch->UnsetSession();
		$this->Localidad_Comuna->AdvancedSearch->UnsetSession();
		$this->Pertenencia_Etnica->AdvancedSearch->UnsetSession();
		$this->Tipo_Regimen_Salud->AdvancedSearch->UnsetSession();
		$this->Administradora_Salud->AdvancedSearch->UnsetSession();
		$this->Entidad_Educativa->AdvancedSearch->UnsetSession();
		$this->Grado_Escolar->AdvancedSearch->UnsetSession();
		$this->Clasificado->AdvancedSearch->UnsetSession();
		$this->Usuario->AdvancedSearch->UnsetSession();
		$this->Fecha_edicion->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->Consecutivo->AdvancedSearch->Load();
		$this->Entidad->AdvancedSearch->Load();
		$this->Tipo_Documento->AdvancedSearch->Load();
		$this->Documento->AdvancedSearch->Load();
		$this->Fecha_Nacimiento->AdvancedSearch->Load();
		$this->Genero->AdvancedSearch->Load();
		$this->Nombres->AdvancedSearch->Load();
		$this->Apellidos->AdvancedSearch->Load();
		$this->Fecha_valoracion->AdvancedSearch->Load();
		$this->Edad_Anos->AdvancedSearch->Load();
		$this->Edad_Meses->AdvancedSearch->Load();
		$this->Peso->AdvancedSearch->Load();
		$this->Talla->AdvancedSearch->Load();
		$this->IMC->AdvancedSearch->Load();
		$this->DS_TallaEdad->AdvancedSearch->Load();
		$this->DS_PesoTalla->AdvancedSearch->Load();
		$this->DS_PesoEdad->AdvancedSearch->Load();
		$this->DS_IMCEdad->AdvancedSearch->Load();
		$this->Clasificacion_Talla_Edad->AdvancedSearch->Load();
		$this->Clasificacion_Peso_Talla->AdvancedSearch->Load();
		$this->Clasificacion_Peso_Edad->AdvancedSearch->Load();
		$this->Clasificacion_IMC_Edad->AdvancedSearch->Load();
		$this->Zona->AdvancedSearch->Load();
		$this->Barrio_Vereda->AdvancedSearch->Load();
		$this->Localidad_Comuna->AdvancedSearch->Load();
		$this->Pertenencia_Etnica->AdvancedSearch->Load();
		$this->Tipo_Regimen_Salud->AdvancedSearch->Load();
		$this->Administradora_Salud->AdvancedSearch->Load();
		$this->Entidad_Educativa->AdvancedSearch->Load();
		$this->Grado_Escolar->AdvancedSearch->Load();
		$this->Clasificado->AdvancedSearch->Load();
		$this->Usuario->AdvancedSearch->Load();
		$this->Fecha_edicion->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Consecutivo); // Consecutivo
			$this->UpdateSort($this->Entidad); // Entidad
			$this->UpdateSort($this->Tipo_Documento); // Tipo_Documento
			$this->UpdateSort($this->Documento); // Documento
			$this->UpdateSort($this->Genero); // Genero
			$this->UpdateSort($this->Nombres); // Nombres
			$this->UpdateSort($this->Apellidos); // Apellidos
			$this->UpdateSort($this->Fecha_valoracion); // Fecha_valoracion
			$this->UpdateSort($this->Edad_Anos); // Edad_Anos
			$this->UpdateSort($this->Peso); // Peso
			$this->UpdateSort($this->Talla); // Talla
			$this->UpdateSort($this->IMC); // IMC
			$this->UpdateSort($this->DS_PesoTalla); // DS_PesoTalla
			$this->UpdateSort($this->Clasificacion_Talla_Edad); // Clasificacion_Talla_Edad
			$this->UpdateSort($this->Clasificacion_Peso_Talla); // Clasificacion_Peso_Talla
			$this->UpdateSort($this->Clasificacion_Peso_Edad); // Clasificacion_Peso_Edad
			$this->UpdateSort($this->Clasificacion_IMC_Edad); // Clasificacion_IMC_Edad
			$this->UpdateSort($this->Zona); // Zona
			$this->UpdateSort($this->Barrio_Vereda); // Barrio_Vereda
			$this->UpdateSort($this->Localidad_Comuna); // Localidad_Comuna
			$this->UpdateSort($this->Pertenencia_Etnica); // Pertenencia_Etnica
			$this->UpdateSort($this->Tipo_Regimen_Salud); // Tipo_Regimen_Salud
			$this->UpdateSort($this->Administradora_Salud); // Administradora_Salud
			$this->UpdateSort($this->Entidad_Educativa); // Entidad_Educativa
			$this->UpdateSort($this->Grado_Escolar); // Grado_Escolar
			$this->UpdateSort($this->Clasificado); // Clasificado
			$this->UpdateSort($this->Usuario); // Usuario
			$this->UpdateSort($this->Fecha_edicion); // Fecha_edicion
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->SqlOrderBy() <> "") {
				$sOrderBy = $this->SqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Consecutivo->setSort("");
				$this->Entidad->setSort("");
				$this->Tipo_Documento->setSort("");
				$this->Documento->setSort("");
				$this->Genero->setSort("");
				$this->Nombres->setSort("");
				$this->Apellidos->setSort("");
				$this->Fecha_valoracion->setSort("");
				$this->Edad_Anos->setSort("");
				$this->Peso->setSort("");
				$this->Talla->setSort("");
				$this->IMC->setSort("");
				$this->DS_PesoTalla->setSort("");
				$this->Clasificacion_Talla_Edad->setSort("");
				$this->Clasificacion_Peso_Talla->setSort("");
				$this->Clasificacion_Peso_Edad->setSort("");
				$this->Clasificacion_IMC_Edad->setSort("");
				$this->Zona->setSort("");
				$this->Barrio_Vereda->setSort("");
				$this->Localidad_Comuna->setSort("");
				$this->Pertenencia_Etnica->setSort("");
				$this->Tipo_Regimen_Salud->setSort("");
				$this->Administradora_Salud->setSort("");
				$this->Entidad_Educativa->setSort("");
				$this->Grado_Escolar->setSort("");
				$this->Clasificado->setSort("");
				$this->Usuario->setSort("");
				$this->Fecha_edicion->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<label class=\"checkbox\"><input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\"></label>";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		$this->ListOptions->ButtonClass = "btn-small"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<label class=\"checkbox\"><input type=\"checkbox\" name=\"key_m[]\" value=\"" . ew_HtmlEncode($this->Consecutivo->CurrentValue) . "\" onclick='ew_ClickMultiCheckbox(event, this);'></label>";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-small"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];
			foreach ($this->CustomActions as $action => $name) {

				// Add custom action
				$item = &$option->Add("custom_" . $action);
				$item->Body = "<a class=\"ewAction ewCustomAction\" href=\"\" onclick=\"ew_SubmitSelected(document.fexportacion_nutricionlist, '" . ew_CurrentUrl() . "', null, '" . $action . "');return false;\">" . $name . "</a>";
			}

			// Hide grid edit, multi-delete and multi-update
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$item = &$option->GetItem("multidelete");
				if ($item) $item->Visible = FALSE;
				$item = &$option->GetItem("multiupdate");
				if ($item) $item->Visible = FALSE;
			}
	}

	// Process custom action
	function ProcessCustomAction() {
		global $conn, $Language, $Security;
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$rsuser = ($rs) ? $rs->GetRows() : array();
			if ($rs)
				$rs->Close();

			// Call row custom action event
			if (count($rsuser) > 0) {
				$conn->BeginTrans();
				foreach ($rsuser as $row) {
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $UserAction, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $UserAction, $Language->Phrase("CustomActionCancelled")));
					}
				}
			}
		}
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	//  Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// Consecutivo

		$this->Consecutivo->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Consecutivo"]);
		if ($this->Consecutivo->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Consecutivo->AdvancedSearch->SearchOperator = @$_GET["z_Consecutivo"];
		$this->Consecutivo->AdvancedSearch->SearchCondition = @$_GET["v_Consecutivo"];
		$this->Consecutivo->AdvancedSearch->SearchValue2 = ew_StripSlashes(@$_GET["y_Consecutivo"]);
		if ($this->Consecutivo->AdvancedSearch->SearchValue2 <> "") $this->Command = "search";
		$this->Consecutivo->AdvancedSearch->SearchOperator2 = @$_GET["w_Consecutivo"];

		// Entidad
		$this->Entidad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Entidad"]);
		if ($this->Entidad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Entidad->AdvancedSearch->SearchOperator = @$_GET["z_Entidad"];

		// Tipo_Documento
		$this->Tipo_Documento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_Documento"]);
		if ($this->Tipo_Documento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_Documento->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_Documento"];

		// Documento
		$this->Documento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Documento"]);
		if ($this->Documento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Documento->AdvancedSearch->SearchOperator = @$_GET["z_Documento"];

		// Fecha_Nacimiento
		$this->Fecha_Nacimiento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Nacimiento"]);
		if ($this->Fecha_Nacimiento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Nacimiento->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Nacimiento"];

		// Genero
		$this->Genero->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Genero"]);
		if ($this->Genero->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Genero->AdvancedSearch->SearchOperator = @$_GET["z_Genero"];

		// Nombres
		$this->Nombres->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Nombres"]);
		if ($this->Nombres->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Nombres->AdvancedSearch->SearchOperator = @$_GET["z_Nombres"];

		// Apellidos
		$this->Apellidos->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Apellidos"]);
		if ($this->Apellidos->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Apellidos->AdvancedSearch->SearchOperator = @$_GET["z_Apellidos"];

		// Fecha_valoracion
		$this->Fecha_valoracion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_valoracion"]);
		if ($this->Fecha_valoracion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_valoracion->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_valoracion"];
		$this->Fecha_valoracion->AdvancedSearch->SearchCondition = @$_GET["v_Fecha_valoracion"];
		$this->Fecha_valoracion->AdvancedSearch->SearchValue2 = ew_StripSlashes(@$_GET["y_Fecha_valoracion"]);
		if ($this->Fecha_valoracion->AdvancedSearch->SearchValue2 <> "") $this->Command = "search";
		$this->Fecha_valoracion->AdvancedSearch->SearchOperator2 = @$_GET["w_Fecha_valoracion"];

		// Edad_Anos
		$this->Edad_Anos->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Edad_Anos"]);
		if ($this->Edad_Anos->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Edad_Anos->AdvancedSearch->SearchOperator = @$_GET["z_Edad_Anos"];

		// Edad_Meses
		$this->Edad_Meses->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Edad_Meses"]);
		if ($this->Edad_Meses->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Edad_Meses->AdvancedSearch->SearchOperator = @$_GET["z_Edad_Meses"];

		// Peso
		$this->Peso->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Peso"]);
		if ($this->Peso->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Peso->AdvancedSearch->SearchOperator = @$_GET["z_Peso"];

		// Talla
		$this->Talla->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Talla"]);
		if ($this->Talla->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Talla->AdvancedSearch->SearchOperator = @$_GET["z_Talla"];

		// IMC
		$this->IMC->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_IMC"]);
		if ($this->IMC->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->IMC->AdvancedSearch->SearchOperator = @$_GET["z_IMC"];

		// DS_TallaEdad
		$this->DS_TallaEdad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_DS_TallaEdad"]);
		if ($this->DS_TallaEdad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->DS_TallaEdad->AdvancedSearch->SearchOperator = @$_GET["z_DS_TallaEdad"];

		// DS_PesoTalla
		$this->DS_PesoTalla->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_DS_PesoTalla"]);
		if ($this->DS_PesoTalla->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->DS_PesoTalla->AdvancedSearch->SearchOperator = @$_GET["z_DS_PesoTalla"];

		// DS_PesoEdad
		$this->DS_PesoEdad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_DS_PesoEdad"]);
		if ($this->DS_PesoEdad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->DS_PesoEdad->AdvancedSearch->SearchOperator = @$_GET["z_DS_PesoEdad"];

		// DS_IMCEdad
		$this->DS_IMCEdad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_DS_IMCEdad"]);
		if ($this->DS_IMCEdad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->DS_IMCEdad->AdvancedSearch->SearchOperator = @$_GET["z_DS_IMCEdad"];

		// Clasificacion_Talla_Edad
		$this->Clasificacion_Talla_Edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Clasificacion_Talla_Edad"]);
		if ($this->Clasificacion_Talla_Edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Clasificacion_Talla_Edad->AdvancedSearch->SearchOperator = @$_GET["z_Clasificacion_Talla_Edad"];

		// Clasificacion_Peso_Talla
		$this->Clasificacion_Peso_Talla->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Clasificacion_Peso_Talla"]);
		if ($this->Clasificacion_Peso_Talla->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Clasificacion_Peso_Talla->AdvancedSearch->SearchOperator = @$_GET["z_Clasificacion_Peso_Talla"];

		// Clasificacion_Peso_Edad
		$this->Clasificacion_Peso_Edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Clasificacion_Peso_Edad"]);
		if ($this->Clasificacion_Peso_Edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Clasificacion_Peso_Edad->AdvancedSearch->SearchOperator = @$_GET["z_Clasificacion_Peso_Edad"];

		// Clasificacion_IMC_Edad
		$this->Clasificacion_IMC_Edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Clasificacion_IMC_Edad"]);
		if ($this->Clasificacion_IMC_Edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Clasificacion_IMC_Edad->AdvancedSearch->SearchOperator = @$_GET["z_Clasificacion_IMC_Edad"];

		// Zona
		$this->Zona->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Zona"]);
		if ($this->Zona->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Zona->AdvancedSearch->SearchOperator = @$_GET["z_Zona"];

		// Barrio_Vereda
		$this->Barrio_Vereda->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Barrio_Vereda"]);
		if ($this->Barrio_Vereda->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Barrio_Vereda->AdvancedSearch->SearchOperator = @$_GET["z_Barrio_Vereda"];

		// Localidad_Comuna
		$this->Localidad_Comuna->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Localidad_Comuna"]);
		if ($this->Localidad_Comuna->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Localidad_Comuna->AdvancedSearch->SearchOperator = @$_GET["z_Localidad_Comuna"];

		// Pertenencia_Etnica
		$this->Pertenencia_Etnica->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Pertenencia_Etnica"]);
		if ($this->Pertenencia_Etnica->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Pertenencia_Etnica->AdvancedSearch->SearchOperator = @$_GET["z_Pertenencia_Etnica"];

		// Tipo_Regimen_Salud
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_Regimen_Salud"]);
		if ($this->Tipo_Regimen_Salud->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_Regimen_Salud->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_Regimen_Salud"];

		// Administradora_Salud
		$this->Administradora_Salud->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Administradora_Salud"]);
		if ($this->Administradora_Salud->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Administradora_Salud->AdvancedSearch->SearchOperator = @$_GET["z_Administradora_Salud"];

		// Entidad_Educativa
		$this->Entidad_Educativa->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Entidad_Educativa"]);
		if ($this->Entidad_Educativa->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Entidad_Educativa->AdvancedSearch->SearchOperator = @$_GET["z_Entidad_Educativa"];

		// Grado_Escolar
		$this->Grado_Escolar->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Grado_Escolar"]);
		if ($this->Grado_Escolar->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Grado_Escolar->AdvancedSearch->SearchOperator = @$_GET["z_Grado_Escolar"];

		// Clasificado
		$this->Clasificado->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Clasificado"]);
		if ($this->Clasificado->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Clasificado->AdvancedSearch->SearchOperator = @$_GET["z_Clasificado"];

		// Usuario
		$this->Usuario->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Usuario"]);
		if ($this->Usuario->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Usuario->AdvancedSearch->SearchOperator = @$_GET["z_Usuario"];

		// Fecha_edicion
		$this->Fecha_edicion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_edicion"]);
		if ($this->Fecha_edicion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_edicion->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_edicion"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->Tipo_Documento->setDbValue($rs->fields('Tipo_Documento'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Fecha_valoracion->setDbValue($rs->fields('Fecha_valoracion'));
		$this->Edad_Anos->setDbValue($rs->fields('Edad_Anos'));
		$this->Edad_Meses->setDbValue($rs->fields('Edad_Meses'));
		$this->Peso->setDbValue($rs->fields('Peso'));
		$this->Talla->setDbValue($rs->fields('Talla'));
		$this->IMC->setDbValue($rs->fields('IMC'));
		$this->DS_TallaEdad->setDbValue($rs->fields('DS_TallaEdad'));
		$this->DS_PesoTalla->setDbValue($rs->fields('DS_PesoTalla'));
		$this->DS_PesoEdad->setDbValue($rs->fields('DS_PesoEdad'));
		$this->DS_IMCEdad->setDbValue($rs->fields('DS_IMCEdad'));
		$this->Clasificacion_Talla_Edad->setDbValue($rs->fields('Clasificacion_Talla_Edad'));
		$this->Clasificacion_Peso_Talla->setDbValue($rs->fields('Clasificacion_Peso_Talla'));
		$this->Clasificacion_Peso_Edad->setDbValue($rs->fields('Clasificacion_Peso_Edad'));
		$this->Clasificacion_IMC_Edad->setDbValue($rs->fields('Clasificacion_IMC_Edad'));
		$this->Zona->setDbValue($rs->fields('Zona'));
		$this->Barrio_Vereda->setDbValue($rs->fields('Barrio_Vereda'));
		$this->Localidad_Comuna->setDbValue($rs->fields('Localidad_Comuna'));
		$this->Pertenencia_Etnica->setDbValue($rs->fields('Pertenencia_Etnica'));
		$this->Tipo_Regimen_Salud->setDbValue($rs->fields('Tipo_Regimen_Salud'));
		$this->Administradora_Salud->setDbValue($rs->fields('Administradora_Salud'));
		$this->Entidad_Educativa->setDbValue($rs->fields('Entidad_Educativa'));
		$this->Grado_Escolar->setDbValue($rs->fields('Grado_Escolar'));
		$this->Clasificado->setDbValue($rs->fields('Clasificado'));
		$this->Usuario->setDbValue($rs->fields('Usuario'));
		$this->Fecha_edicion->setDbValue($rs->fields('Fecha_edicion'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Consecutivo->DbValue = $row['Consecutivo'];
		$this->Entidad->DbValue = $row['Entidad'];
		$this->Tipo_Documento->DbValue = $row['Tipo_Documento'];
		$this->Documento->DbValue = $row['Documento'];
		$this->Fecha_Nacimiento->DbValue = $row['Fecha_Nacimiento'];
		$this->Genero->DbValue = $row['Genero'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Fecha_valoracion->DbValue = $row['Fecha_valoracion'];
		$this->Edad_Anos->DbValue = $row['Edad_Anos'];
		$this->Edad_Meses->DbValue = $row['Edad_Meses'];
		$this->Peso->DbValue = $row['Peso'];
		$this->Talla->DbValue = $row['Talla'];
		$this->IMC->DbValue = $row['IMC'];
		$this->DS_TallaEdad->DbValue = $row['DS_TallaEdad'];
		$this->DS_PesoTalla->DbValue = $row['DS_PesoTalla'];
		$this->DS_PesoEdad->DbValue = $row['DS_PesoEdad'];
		$this->DS_IMCEdad->DbValue = $row['DS_IMCEdad'];
		$this->Clasificacion_Talla_Edad->DbValue = $row['Clasificacion_Talla_Edad'];
		$this->Clasificacion_Peso_Talla->DbValue = $row['Clasificacion_Peso_Talla'];
		$this->Clasificacion_Peso_Edad->DbValue = $row['Clasificacion_Peso_Edad'];
		$this->Clasificacion_IMC_Edad->DbValue = $row['Clasificacion_IMC_Edad'];
		$this->Zona->DbValue = $row['Zona'];
		$this->Barrio_Vereda->DbValue = $row['Barrio_Vereda'];
		$this->Localidad_Comuna->DbValue = $row['Localidad_Comuna'];
		$this->Pertenencia_Etnica->DbValue = $row['Pertenencia_Etnica'];
		$this->Tipo_Regimen_Salud->DbValue = $row['Tipo_Regimen_Salud'];
		$this->Administradora_Salud->DbValue = $row['Administradora_Salud'];
		$this->Entidad_Educativa->DbValue = $row['Entidad_Educativa'];
		$this->Grado_Escolar->DbValue = $row['Grado_Escolar'];
		$this->Clasificado->DbValue = $row['Clasificado'];
		$this->Usuario->DbValue = $row['Usuario'];
		$this->Fecha_edicion->DbValue = $row['Fecha_edicion'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("Consecutivo")) <> "")
			$this->Consecutivo->CurrentValue = $this->getKey("Consecutivo"); // Consecutivo
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$this->OldRecordset = ew_LoadRecordset($sSql);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Convert decimal values if posted back
		if ($this->Peso->FormValue == $this->Peso->CurrentValue && is_numeric(ew_StrToFloat($this->Peso->CurrentValue)))
			$this->Peso->CurrentValue = ew_StrToFloat($this->Peso->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Talla->FormValue == $this->Talla->CurrentValue && is_numeric(ew_StrToFloat($this->Talla->CurrentValue)))
			$this->Talla->CurrentValue = ew_StrToFloat($this->Talla->CurrentValue);

		// Convert decimal values if posted back
		if ($this->IMC->FormValue == $this->IMC->CurrentValue && is_numeric(ew_StrToFloat($this->IMC->CurrentValue)))
			$this->IMC->CurrentValue = ew_StrToFloat($this->IMC->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_PesoTalla->FormValue == $this->DS_PesoTalla->CurrentValue && is_numeric(ew_StrToFloat($this->DS_PesoTalla->CurrentValue)))
			$this->DS_PesoTalla->CurrentValue = ew_StrToFloat($this->DS_PesoTalla->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Consecutivo
		// Entidad
		// Tipo_Documento
		// Documento
		// Fecha_Nacimiento
		// Genero
		// Nombres
		// Apellidos
		// Fecha_valoracion
		// Edad_Anos
		// Edad_Meses
		// Peso
		// Talla
		// IMC
		// DS_TallaEdad
		// DS_PesoTalla
		// DS_PesoEdad
		// DS_IMCEdad
		// Clasificacion_Talla_Edad
		// Clasificacion_Peso_Talla
		// Clasificacion_Peso_Edad
		// Clasificacion_IMC_Edad
		// Zona
		// Barrio_Vereda
		// Localidad_Comuna
		// Pertenencia_Etnica
		// Tipo_Regimen_Salud
		// Administradora_Salud
		// Entidad_Educativa
		// Grado_Escolar
		// Clasificado
		// Usuario
		// Fecha_edicion

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// Consecutivo
			$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
			$this->Consecutivo->ViewCustomAttributes = "";

			// Entidad
			$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
			$this->Entidad->ViewCustomAttributes = "";

			// Tipo_Documento
			$this->Tipo_Documento->ViewValue = $this->Tipo_Documento->CurrentValue;
			$this->Tipo_Documento->ViewCustomAttributes = "";

			// Documento
			$this->Documento->ViewValue = $this->Documento->CurrentValue;
			$this->Documento->ViewCustomAttributes = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
			$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 7);
			$this->Fecha_Nacimiento->ViewCustomAttributes = "";

			// Genero
			$this->Genero->ViewValue = $this->Genero->CurrentValue;
			$this->Genero->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
			$this->Nombres->ViewCustomAttributes = "";

			// Apellidos
			$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
			$this->Apellidos->ViewCustomAttributes = "";

			// Fecha_valoracion
			$this->Fecha_valoracion->ViewValue = $this->Fecha_valoracion->CurrentValue;
			$this->Fecha_valoracion->ViewValue = ew_FormatDateTime($this->Fecha_valoracion->ViewValue, 7);
			$this->Fecha_valoracion->ViewCustomAttributes = "";

			// Edad_Anos
			$this->Edad_Anos->ViewValue = $this->Edad_Anos->CurrentValue;
			$this->Edad_Anos->ViewCustomAttributes = "";

			// Edad_Meses
			$this->Edad_Meses->ViewValue = $this->Edad_Meses->CurrentValue;
			$this->Edad_Meses->ViewCustomAttributes = "";

			// Peso
			$this->Peso->ViewValue = $this->Peso->CurrentValue;
			$this->Peso->ViewCustomAttributes = "";

			// Talla
			$this->Talla->ViewValue = $this->Talla->CurrentValue;
			$this->Talla->ViewCustomAttributes = "";

			// IMC
			$this->IMC->ViewValue = $this->IMC->CurrentValue;
			$this->IMC->ViewValue = ew_FormatNumber($this->IMC->ViewValue, 2, 0, 0, 0);
			$this->IMC->CellCssStyle .= "text-align: right;";
			$this->IMC->ViewCustomAttributes = "";

			// DS_TallaEdad
			$this->DS_TallaEdad->ViewValue = $this->DS_TallaEdad->CurrentValue;
			$this->DS_TallaEdad->ViewCustomAttributes = "";

			// DS_PesoTalla
			$this->DS_PesoTalla->ViewValue = $this->DS_PesoTalla->CurrentValue;
			$this->DS_PesoTalla->ViewCustomAttributes = "";

			// DS_PesoEdad
			$this->DS_PesoEdad->ViewValue = $this->DS_PesoEdad->CurrentValue;
			$this->DS_PesoEdad->ViewCustomAttributes = "";

			// DS_IMCEdad
			$this->DS_IMCEdad->ViewValue = $this->DS_IMCEdad->CurrentValue;
			$this->DS_IMCEdad->ViewCustomAttributes = "";

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->ViewValue = $this->Clasificacion_Talla_Edad->CurrentValue;
			$this->Clasificacion_Talla_Edad->ViewCustomAttributes = "";

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->ViewValue = $this->Clasificacion_Peso_Talla->CurrentValue;
			$this->Clasificacion_Peso_Talla->ViewCustomAttributes = "";

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->ViewValue = $this->Clasificacion_Peso_Edad->CurrentValue;
			$this->Clasificacion_Peso_Edad->ViewCustomAttributes = "";

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->ViewValue = $this->Clasificacion_IMC_Edad->CurrentValue;
			$this->Clasificacion_IMC_Edad->ViewCustomAttributes = "";

			// Zona
			$this->Zona->ViewValue = $this->Zona->CurrentValue;
			$this->Zona->ViewCustomAttributes = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->ViewValue = $this->Barrio_Vereda->CurrentValue;
			$this->Barrio_Vereda->ViewCustomAttributes = "";

			// Localidad_Comuna
			$this->Localidad_Comuna->ViewValue = $this->Localidad_Comuna->CurrentValue;
			$this->Localidad_Comuna->ViewCustomAttributes = "";

			// Pertenencia_Etnica
			$this->Pertenencia_Etnica->ViewValue = $this->Pertenencia_Etnica->CurrentValue;
			$this->Pertenencia_Etnica->ViewCustomAttributes = "";

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->ViewValue = $this->Tipo_Regimen_Salud->CurrentValue;
			$this->Tipo_Regimen_Salud->ViewCustomAttributes = "";

			// Administradora_Salud
			$this->Administradora_Salud->ViewValue = $this->Administradora_Salud->CurrentValue;
			$this->Administradora_Salud->ViewCustomAttributes = "";

			// Entidad_Educativa
			$this->Entidad_Educativa->ViewValue = $this->Entidad_Educativa->CurrentValue;
			$this->Entidad_Educativa->ViewCustomAttributes = "";

			// Grado_Escolar
			$this->Grado_Escolar->ViewValue = $this->Grado_Escolar->CurrentValue;
			$this->Grado_Escolar->ViewCustomAttributes = "";

			// Clasificado
			if (strval($this->Clasificado->CurrentValue) <> "") {
				switch ($this->Clasificado->CurrentValue) {
					case $this->Clasificado->FldTagValue(1):
						$this->Clasificado->ViewValue = $this->Clasificado->FldTagCaption(1) <> "" ? $this->Clasificado->FldTagCaption(1) : $this->Clasificado->CurrentValue;
						break;
					case $this->Clasificado->FldTagValue(2):
						$this->Clasificado->ViewValue = $this->Clasificado->FldTagCaption(2) <> "" ? $this->Clasificado->FldTagCaption(2) : $this->Clasificado->CurrentValue;
						break;
					default:
						$this->Clasificado->ViewValue = $this->Clasificado->CurrentValue;
				}
			} else {
				$this->Clasificado->ViewValue = NULL;
			}
			$this->Clasificado->ViewCustomAttributes = "";

			// Usuario
			$this->Usuario->ViewValue = $this->Usuario->CurrentValue;
			$this->Usuario->ViewCustomAttributes = "";

			// Fecha_edicion
			$this->Fecha_edicion->ViewValue = $this->Fecha_edicion->CurrentValue;
			$this->Fecha_edicion->ViewValue = ew_FormatDateTime($this->Fecha_edicion->ViewValue, 7);
			$this->Fecha_edicion->ViewCustomAttributes = "";

			// Consecutivo
			$this->Consecutivo->LinkCustomAttributes = "";
			$this->Consecutivo->HrefValue = "";
			$this->Consecutivo->TooltipValue = "";

			// Entidad
			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";
			$this->Entidad->TooltipValue = "";

			// Tipo_Documento
			$this->Tipo_Documento->LinkCustomAttributes = "";
			$this->Tipo_Documento->HrefValue = "";
			$this->Tipo_Documento->TooltipValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";
			$this->Documento->TooltipValue = "";

			// Genero
			$this->Genero->LinkCustomAttributes = "";
			$this->Genero->HrefValue = "";
			$this->Genero->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Fecha_valoracion
			$this->Fecha_valoracion->LinkCustomAttributes = "";
			$this->Fecha_valoracion->HrefValue = "";
			$this->Fecha_valoracion->TooltipValue = "";

			// Edad_Anos
			$this->Edad_Anos->LinkCustomAttributes = "";
			$this->Edad_Anos->HrefValue = "";
			$this->Edad_Anos->TooltipValue = "";

			// Peso
			$this->Peso->LinkCustomAttributes = "";
			$this->Peso->HrefValue = "";
			$this->Peso->TooltipValue = "";

			// Talla
			$this->Talla->LinkCustomAttributes = "";
			$this->Talla->HrefValue = "";
			$this->Talla->TooltipValue = "";

			// IMC
			$this->IMC->LinkCustomAttributes = "";
			$this->IMC->HrefValue = "";
			$this->IMC->TooltipValue = "";

			// DS_PesoTalla
			$this->DS_PesoTalla->LinkCustomAttributes = "";
			$this->DS_PesoTalla->HrefValue = "";
			$this->DS_PesoTalla->TooltipValue = "";

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_Talla_Edad->HrefValue = "";
			$this->Clasificacion_Talla_Edad->TooltipValue = "";

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->LinkCustomAttributes = "";
			$this->Clasificacion_Peso_Talla->HrefValue = "";
			$this->Clasificacion_Peso_Talla->TooltipValue = "";

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_Peso_Edad->HrefValue = "";
			$this->Clasificacion_Peso_Edad->TooltipValue = "";

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_IMC_Edad->HrefValue = "";
			$this->Clasificacion_IMC_Edad->TooltipValue = "";

			// Zona
			$this->Zona->LinkCustomAttributes = "";
			$this->Zona->HrefValue = "";
			$this->Zona->TooltipValue = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->LinkCustomAttributes = "";
			$this->Barrio_Vereda->HrefValue = "";
			$this->Barrio_Vereda->TooltipValue = "";

			// Localidad_Comuna
			$this->Localidad_Comuna->LinkCustomAttributes = "";
			$this->Localidad_Comuna->HrefValue = "";
			$this->Localidad_Comuna->TooltipValue = "";

			// Pertenencia_Etnica
			$this->Pertenencia_Etnica->LinkCustomAttributes = "";
			$this->Pertenencia_Etnica->HrefValue = "";
			$this->Pertenencia_Etnica->TooltipValue = "";

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->LinkCustomAttributes = "";
			$this->Tipo_Regimen_Salud->HrefValue = "";
			$this->Tipo_Regimen_Salud->TooltipValue = "";

			// Administradora_Salud
			$this->Administradora_Salud->LinkCustomAttributes = "";
			$this->Administradora_Salud->HrefValue = "";
			$this->Administradora_Salud->TooltipValue = "";

			// Entidad_Educativa
			$this->Entidad_Educativa->LinkCustomAttributes = "";
			$this->Entidad_Educativa->HrefValue = "";
			$this->Entidad_Educativa->TooltipValue = "";

			// Grado_Escolar
			$this->Grado_Escolar->LinkCustomAttributes = "";
			$this->Grado_Escolar->HrefValue = "";
			$this->Grado_Escolar->TooltipValue = "";

			// Clasificado
			$this->Clasificado->LinkCustomAttributes = "";
			$this->Clasificado->HrefValue = "";
			$this->Clasificado->TooltipValue = "";

			// Usuario
			$this->Usuario->LinkCustomAttributes = "";
			$this->Usuario->HrefValue = "";
			$this->Usuario->TooltipValue = "";

			// Fecha_edicion
			$this->Fecha_edicion->LinkCustomAttributes = "";
			$this->Fecha_edicion->HrefValue = "";
			$this->Fecha_edicion->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// Consecutivo
			$this->Consecutivo->EditCustomAttributes = "";
			$this->Consecutivo->EditValue = ew_HtmlEncode($this->Consecutivo->AdvancedSearch->SearchValue);
			$this->Consecutivo->PlaceHolder = ew_RemoveHtml($this->Consecutivo->FldCaption());
			$this->Consecutivo->EditCustomAttributes = "";
			$this->Consecutivo->EditValue2 = ew_HtmlEncode($this->Consecutivo->AdvancedSearch->SearchValue2);
			$this->Consecutivo->PlaceHolder = ew_RemoveHtml($this->Consecutivo->FldCaption());

			// Entidad
			$this->Entidad->EditCustomAttributes = "";
			$this->Entidad->EditValue = ew_HtmlEncode($this->Entidad->AdvancedSearch->SearchValue);
			$this->Entidad->PlaceHolder = ew_RemoveHtml($this->Entidad->FldCaption());

			// Tipo_Documento
			$this->Tipo_Documento->EditCustomAttributes = "";
			$this->Tipo_Documento->EditValue = ew_HtmlEncode($this->Tipo_Documento->AdvancedSearch->SearchValue);
			$this->Tipo_Documento->PlaceHolder = ew_RemoveHtml($this->Tipo_Documento->FldCaption());

			// Documento
			$this->Documento->EditCustomAttributes = "";
			$this->Documento->EditValue = ew_HtmlEncode($this->Documento->AdvancedSearch->SearchValue);
			$this->Documento->PlaceHolder = ew_RemoveHtml($this->Documento->FldCaption());

			// Genero
			$this->Genero->EditCustomAttributes = "";
			$this->Genero->EditValue = ew_HtmlEncode($this->Genero->AdvancedSearch->SearchValue);
			$this->Genero->PlaceHolder = ew_RemoveHtml($this->Genero->FldCaption());

			// Nombres
			$this->Nombres->EditCustomAttributes = "";
			$this->Nombres->EditValue = ew_HtmlEncode($this->Nombres->AdvancedSearch->SearchValue);
			$this->Nombres->PlaceHolder = ew_RemoveHtml($this->Nombres->FldCaption());

			// Apellidos
			$this->Apellidos->EditCustomAttributes = "";
			$this->Apellidos->EditValue = ew_HtmlEncode($this->Apellidos->AdvancedSearch->SearchValue);
			$this->Apellidos->PlaceHolder = ew_RemoveHtml($this->Apellidos->FldCaption());

			// Fecha_valoracion
			$this->Fecha_valoracion->EditCustomAttributes = "onchange='CalcularEdad();'";
			$this->Fecha_valoracion->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_valoracion->AdvancedSearch->SearchValue, 7), 7));
			$this->Fecha_valoracion->PlaceHolder = ew_RemoveHtml($this->Fecha_valoracion->FldCaption());
			$this->Fecha_valoracion->EditCustomAttributes = "onchange='CalcularEdad();'";
			$this->Fecha_valoracion->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_valoracion->AdvancedSearch->SearchValue2, 7), 7));
			$this->Fecha_valoracion->PlaceHolder = ew_RemoveHtml($this->Fecha_valoracion->FldCaption());

			// Edad_Anos
			$this->Edad_Anos->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->Edad_Anos->EditValue = ew_HtmlEncode($this->Edad_Anos->AdvancedSearch->SearchValue);
			$this->Edad_Anos->PlaceHolder = ew_RemoveHtml($this->Edad_Anos->FldCaption());

			// Peso
			$this->Peso->EditCustomAttributes = "onchange='Calcular_IMC();'";
			$this->Peso->EditValue = ew_HtmlEncode($this->Peso->AdvancedSearch->SearchValue);
			$this->Peso->PlaceHolder = ew_RemoveHtml($this->Peso->FldCaption());

			// Talla
			$this->Talla->EditCustomAttributes = "onchange='Calcular_IMC();'";
			$this->Talla->EditValue = ew_HtmlEncode($this->Talla->AdvancedSearch->SearchValue);
			$this->Talla->PlaceHolder = ew_RemoveHtml($this->Talla->FldCaption());

			// IMC
			$this->IMC->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->IMC->EditValue = ew_HtmlEncode($this->IMC->AdvancedSearch->SearchValue);
			$this->IMC->PlaceHolder = ew_RemoveHtml($this->IMC->FldCaption());

			// DS_PesoTalla
			$this->DS_PesoTalla->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->DS_PesoTalla->EditValue = ew_HtmlEncode($this->DS_PesoTalla->AdvancedSearch->SearchValue);
			$this->DS_PesoTalla->PlaceHolder = ew_RemoveHtml($this->DS_PesoTalla->FldCaption());

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->EditCustomAttributes = "";
			$this->Clasificacion_Talla_Edad->EditValue = ew_HtmlEncode($this->Clasificacion_Talla_Edad->AdvancedSearch->SearchValue);
			$this->Clasificacion_Talla_Edad->PlaceHolder = ew_RemoveHtml($this->Clasificacion_Talla_Edad->FldCaption());

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->EditCustomAttributes = "";
			$this->Clasificacion_Peso_Talla->EditValue = ew_HtmlEncode($this->Clasificacion_Peso_Talla->AdvancedSearch->SearchValue);
			$this->Clasificacion_Peso_Talla->PlaceHolder = ew_RemoveHtml($this->Clasificacion_Peso_Talla->FldCaption());

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->EditCustomAttributes = "";
			$this->Clasificacion_Peso_Edad->EditValue = ew_HtmlEncode($this->Clasificacion_Peso_Edad->AdvancedSearch->SearchValue);
			$this->Clasificacion_Peso_Edad->PlaceHolder = ew_RemoveHtml($this->Clasificacion_Peso_Edad->FldCaption());

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->EditCustomAttributes = "";
			$this->Clasificacion_IMC_Edad->EditValue = ew_HtmlEncode($this->Clasificacion_IMC_Edad->AdvancedSearch->SearchValue);
			$this->Clasificacion_IMC_Edad->PlaceHolder = ew_RemoveHtml($this->Clasificacion_IMC_Edad->FldCaption());

			// Zona
			$this->Zona->EditCustomAttributes = "";
			$this->Zona->EditValue = ew_HtmlEncode($this->Zona->AdvancedSearch->SearchValue);
			$this->Zona->PlaceHolder = ew_RemoveHtml($this->Zona->FldCaption());

			// Barrio_Vereda
			$this->Barrio_Vereda->EditCustomAttributes = "";
			$this->Barrio_Vereda->EditValue = ew_HtmlEncode($this->Barrio_Vereda->AdvancedSearch->SearchValue);
			$this->Barrio_Vereda->PlaceHolder = ew_RemoveHtml($this->Barrio_Vereda->FldCaption());

			// Localidad_Comuna
			$this->Localidad_Comuna->EditCustomAttributes = "";
			$this->Localidad_Comuna->EditValue = ew_HtmlEncode($this->Localidad_Comuna->AdvancedSearch->SearchValue);
			$this->Localidad_Comuna->PlaceHolder = ew_RemoveHtml($this->Localidad_Comuna->FldCaption());

			// Pertenencia_Etnica
			$this->Pertenencia_Etnica->EditCustomAttributes = "";
			$this->Pertenencia_Etnica->EditValue = ew_HtmlEncode($this->Pertenencia_Etnica->AdvancedSearch->SearchValue);
			$this->Pertenencia_Etnica->PlaceHolder = ew_RemoveHtml($this->Pertenencia_Etnica->FldCaption());

			// Tipo_Regimen_Salud
			$this->Tipo_Regimen_Salud->EditCustomAttributes = "";
			$this->Tipo_Regimen_Salud->EditValue = ew_HtmlEncode($this->Tipo_Regimen_Salud->AdvancedSearch->SearchValue);
			$this->Tipo_Regimen_Salud->PlaceHolder = ew_RemoveHtml($this->Tipo_Regimen_Salud->FldCaption());

			// Administradora_Salud
			$this->Administradora_Salud->EditCustomAttributes = "";
			$this->Administradora_Salud->EditValue = ew_HtmlEncode($this->Administradora_Salud->AdvancedSearch->SearchValue);
			$this->Administradora_Salud->PlaceHolder = ew_RemoveHtml($this->Administradora_Salud->FldCaption());

			// Entidad_Educativa
			$this->Entidad_Educativa->EditCustomAttributes = "";
			$this->Entidad_Educativa->EditValue = ew_HtmlEncode($this->Entidad_Educativa->AdvancedSearch->SearchValue);
			$this->Entidad_Educativa->PlaceHolder = ew_RemoveHtml($this->Entidad_Educativa->FldCaption());

			// Grado_Escolar
			$this->Grado_Escolar->EditCustomAttributes = "";
			$this->Grado_Escolar->EditValue = ew_HtmlEncode($this->Grado_Escolar->AdvancedSearch->SearchValue);
			$this->Grado_Escolar->PlaceHolder = ew_RemoveHtml($this->Grado_Escolar->FldCaption());

			// Clasificado
			$this->Clasificado->EditCustomAttributes = "onchange='CalcularClase();'";
			$arwrk = array();
			$arwrk[] = array($this->Clasificado->FldTagValue(1), $this->Clasificado->FldTagCaption(1) <> "" ? $this->Clasificado->FldTagCaption(1) : $this->Clasificado->FldTagValue(1));
			$arwrk[] = array($this->Clasificado->FldTagValue(2), $this->Clasificado->FldTagCaption(2) <> "" ? $this->Clasificado->FldTagCaption(2) : $this->Clasificado->FldTagValue(2));
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect")));
			$this->Clasificado->EditValue = $arwrk;

			// Usuario
			$this->Usuario->EditCustomAttributes = "";
			$this->Usuario->EditValue = ew_HtmlEncode($this->Usuario->AdvancedSearch->SearchValue);
			$this->Usuario->PlaceHolder = ew_RemoveHtml($this->Usuario->FldCaption());

			// Fecha_edicion
			$this->Fecha_edicion->EditCustomAttributes = "";
			$this->Fecha_edicion->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_edicion->AdvancedSearch->SearchValue, 7), 7));
			$this->Fecha_edicion->PlaceHolder = ew_RemoveHtml($this->Fecha_edicion->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckInteger($this->Consecutivo->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->Consecutivo->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Consecutivo->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->Consecutivo->FldErrMsg());
		}
		if (!ew_CheckEuroDate($this->Fecha_valoracion->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->Fecha_valoracion->FldErrMsg());
		}
		if (!ew_CheckEuroDate($this->Fecha_valoracion->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->Fecha_valoracion->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->Consecutivo->AdvancedSearch->Load();
		$this->Entidad->AdvancedSearch->Load();
		$this->Tipo_Documento->AdvancedSearch->Load();
		$this->Documento->AdvancedSearch->Load();
		$this->Fecha_Nacimiento->AdvancedSearch->Load();
		$this->Genero->AdvancedSearch->Load();
		$this->Nombres->AdvancedSearch->Load();
		$this->Apellidos->AdvancedSearch->Load();
		$this->Fecha_valoracion->AdvancedSearch->Load();
		$this->Edad_Anos->AdvancedSearch->Load();
		$this->Edad_Meses->AdvancedSearch->Load();
		$this->Peso->AdvancedSearch->Load();
		$this->Talla->AdvancedSearch->Load();
		$this->IMC->AdvancedSearch->Load();
		$this->DS_TallaEdad->AdvancedSearch->Load();
		$this->DS_PesoTalla->AdvancedSearch->Load();
		$this->DS_PesoEdad->AdvancedSearch->Load();
		$this->DS_IMCEdad->AdvancedSearch->Load();
		$this->Clasificacion_Talla_Edad->AdvancedSearch->Load();
		$this->Clasificacion_Peso_Talla->AdvancedSearch->Load();
		$this->Clasificacion_Peso_Edad->AdvancedSearch->Load();
		$this->Clasificacion_IMC_Edad->AdvancedSearch->Load();
		$this->Zona->AdvancedSearch->Load();
		$this->Barrio_Vereda->AdvancedSearch->Load();
		$this->Localidad_Comuna->AdvancedSearch->Load();
		$this->Pertenencia_Etnica->AdvancedSearch->Load();
		$this->Tipo_Regimen_Salud->AdvancedSearch->Load();
		$this->Administradora_Salud->AdvancedSearch->Load();
		$this->Entidad_Educativa->AdvancedSearch->Load();
		$this->Grado_Escolar->AdvancedSearch->Load();
		$this->Clasificado->AdvancedSearch->Load();
		$this->Usuario->AdvancedSearch->Load();
		$this->Fecha_edicion->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$item->Body = "<a id=\"emf_exportacion_nutricion\" href=\"javascript:void(0);\" class=\"ewExportLink ewEmail\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_exportacion_nutricion',hdr:ewLanguage.Phrase('ExportToEmail'),f:document.fexportacion_nutricionlist,sel:false});\">" . $Language->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = EW_SELECT_LIMIT;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if ($rs = $this->LoadRecordset())
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetUpStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$ExportDoc = ew_ExportDocument($this, "h");
		$ParentTable = "";
		if ($bSelectLimit) {
			$StartRec = 1;
			$StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {
			$StartRec = $this->StartRec;
			$StopRec = $this->StopRec;
		}
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$ExportDoc->Text .= $sHeader;
		$this->ExportDocument($ExportDoc, $rs, $StartRec, $StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$ExportDoc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Export header and footer
		$ExportDoc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED)
			echo ew_DebugMsg();

		// Output data
		$ExportDoc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = ew_CurrentUrl();
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($exportacion_nutricion_list)) $exportacion_nutricion_list = new cexportacion_nutricion_list();

// Page init
$exportacion_nutricion_list->Page_Init();

// Page main
$exportacion_nutricion_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$exportacion_nutricion_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($exportacion_nutricion->Export == "") { ?>
<script type="text/javascript">

// Page object
var exportacion_nutricion_list = new ew_Page("exportacion_nutricion_list");
exportacion_nutricion_list.PageID = "list"; // Page ID
var EW_PAGE_ID = exportacion_nutricion_list.PageID; // For backward compatibility

// Form object
var fexportacion_nutricionlist = new ew_Form("fexportacion_nutricionlist");
fexportacion_nutricionlist.FormKeyCountName = '<?php echo $exportacion_nutricion_list->FormKeyCountName ?>';

// Form_CustomValidate event
fexportacion_nutricionlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fexportacion_nutricionlist.ValidateRequired = true;
<?php } else { ?>
fexportacion_nutricionlist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

var fexportacion_nutricionlistsrch = new ew_Form("fexportacion_nutricionlistsrch");

// Validate function for search
fexportacion_nutricionlistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	this.PostAutoSuggest();
	var infix = "";
	elm = this.GetElements("x" + infix + "_Consecutivo");
	if (elm && !ew_CheckInteger(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($exportacion_nutricion->Consecutivo->FldErrMsg()) ?>");
	elm = this.GetElements("x" + infix + "_Fecha_valoracion");
	if (elm && !ew_CheckEuroDate(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($exportacion_nutricion->Fecha_valoracion->FldErrMsg()) ?>");

	// Set up row object
	ew_ElementsToRow(fobj);

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fexportacion_nutricionlistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fexportacion_nutricionlistsrch.ValidateRequired = true; // Use JavaScript validation
<?php } else { ?>
fexportacion_nutricionlistsrch.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Dynamic selection lists
// Init search panel as collapsed

if (fexportacion_nutricionlistsrch) fexportacion_nutricionlistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($exportacion_nutricion->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($exportacion_nutricion_list->ExportOptions->Visible()) { ?>
<div class="ewListExportOptions"><?php $exportacion_nutricion_list->ExportOptions->Render("body") ?></div>
<?php } ?>
<?php
	$bSelectLimit = EW_SELECT_LIMIT;
	if ($bSelectLimit) {
		$exportacion_nutricion_list->TotalRecs = $exportacion_nutricion->SelectRecordCount();
	} else {
		if ($exportacion_nutricion_list->Recordset = $exportacion_nutricion_list->LoadRecordset())
			$exportacion_nutricion_list->TotalRecs = $exportacion_nutricion_list->Recordset->RecordCount();
	}
	$exportacion_nutricion_list->StartRec = 1;
	if ($exportacion_nutricion_list->DisplayRecs <= 0 || ($exportacion_nutricion->Export <> "" && $exportacion_nutricion->ExportAll)) // Display all records
		$exportacion_nutricion_list->DisplayRecs = $exportacion_nutricion_list->TotalRecs;
	if (!($exportacion_nutricion->Export <> "" && $exportacion_nutricion->ExportAll))
		$exportacion_nutricion_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$exportacion_nutricion_list->Recordset = $exportacion_nutricion_list->LoadRecordset($exportacion_nutricion_list->StartRec-1, $exportacion_nutricion_list->DisplayRecs);
$exportacion_nutricion_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($exportacion_nutricion->Export == "" && $exportacion_nutricion->CurrentAction == "") { ?>
<form name="fexportacion_nutricionlistsrch" id="fexportacion_nutricionlistsrch" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>">
<div class="accordion ewDisplayTable ewSearchTable" id="fexportacion_nutricionlistsrch_SearchGroup">
	<div class="accordion-group">
		<div class="accordion-heading">
<a class="accordion-toggle" data-toggle="collapse" data-parent="#fexportacion_nutricionlistsrch_SearchGroup" href="#fexportacion_nutricionlistsrch_SearchBody"><?php echo $Language->Phrase("Search") ?></a>
		</div>
		<div id="fexportacion_nutricionlistsrch_SearchBody" class="accordion-body collapse in">
			<div class="accordion-inner">
<div id="fexportacion_nutricionlistsrch_SearchPanel">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="exportacion_nutricion">
<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$exportacion_nutricion_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$exportacion_nutricion->RowType = EW_ROWTYPE_SEARCH;

// Render row
$exportacion_nutricion->ResetAttrs();
$exportacion_nutricion_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($exportacion_nutricion->Consecutivo->Visible) { // Consecutivo ?>
	<span id="xsc_Consecutivo" class="ewCell">
		<span class="ewSearchCaption"><?php echo $exportacion_nutricion->Consecutivo->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("BETWEEN") ?><input type="hidden" name="z_Consecutivo" id="z_Consecutivo" value="BETWEEN"></span>
		<span class="control-group ewSearchField">
<input type="text" data-field="x_Consecutivo" name="x_Consecutivo" id="x_Consecutivo" placeholder="<?php echo ew_HtmlEncode($exportacion_nutricion->Consecutivo->PlaceHolder) ?>" value="<?php echo $exportacion_nutricion->Consecutivo->EditValue ?>"<?php echo $exportacion_nutricion->Consecutivo->EditAttributes() ?>>
</span>
		<span class="ewSearchCond btw1_Consecutivo">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="control-group ewSearchField btw1_Consecutivo">
<input type="text" data-field="x_Consecutivo" name="y_Consecutivo" id="y_Consecutivo" placeholder="<?php echo ew_HtmlEncode($exportacion_nutricion->Consecutivo->PlaceHolder) ?>" value="<?php echo $exportacion_nutricion->Consecutivo->EditValue2 ?>"<?php echo $exportacion_nutricion->Consecutivo->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($exportacion_nutricion->Documento->Visible) { // Documento ?>
	<span id="xsc_Documento" class="ewCell">
		<span class="ewSearchCaption"><?php echo $exportacion_nutricion->Documento->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Documento" id="z_Documento" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" data-field="x_Documento" name="x_Documento" id="x_Documento" size="12" maxlength="30" placeholder="<?php echo ew_HtmlEncode($exportacion_nutricion->Documento->PlaceHolder) ?>" value="<?php echo $exportacion_nutricion->Documento->EditValue ?>"<?php echo $exportacion_nutricion->Documento->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($exportacion_nutricion->Nombres->Visible) { // Nombres ?>
	<span id="xsc_Nombres" class="ewCell">
		<span class="ewSearchCaption"><?php echo $exportacion_nutricion->Nombres->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Nombres" id="z_Nombres" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" data-field="x_Nombres" name="x_Nombres" id="x_Nombres" size="20" maxlength="100" placeholder="<?php echo ew_HtmlEncode($exportacion_nutricion->Nombres->PlaceHolder) ?>" value="<?php echo $exportacion_nutricion->Nombres->EditValue ?>"<?php echo $exportacion_nutricion->Nombres->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($exportacion_nutricion->Apellidos->Visible) { // Apellidos ?>
	<span id="xsc_Apellidos" class="ewCell">
		<span class="ewSearchCaption"><?php echo $exportacion_nutricion->Apellidos->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Apellidos" id="z_Apellidos" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" data-field="x_Apellidos" name="x_Apellidos" id="x_Apellidos" size="20" maxlength="100" placeholder="<?php echo ew_HtmlEncode($exportacion_nutricion->Apellidos->PlaceHolder) ?>" value="<?php echo $exportacion_nutricion->Apellidos->EditValue ?>"<?php echo $exportacion_nutricion->Apellidos->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($exportacion_nutricion->Fecha_valoracion->Visible) { // Fecha_valoracion ?>
	<span id="xsc_Fecha_valoracion" class="ewCell">
		<span class="ewSearchCaption"><?php echo $exportacion_nutricion->Fecha_valoracion->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("BETWEEN") ?><input type="hidden" name="z_Fecha_valoracion" id="z_Fecha_valoracion" value="BETWEEN"></span>
		<span class="control-group ewSearchField">
<input type="text" data-field="x_Fecha_valoracion" name="x_Fecha_valoracion" id="x_Fecha_valoracion" size="12" placeholder="<?php echo ew_HtmlEncode($exportacion_nutricion->Fecha_valoracion->PlaceHolder) ?>" value="<?php echo $exportacion_nutricion->Fecha_valoracion->EditValue ?>"<?php echo $exportacion_nutricion->Fecha_valoracion->EditAttributes() ?>>
<?php if (!$exportacion_nutricion->Fecha_valoracion->ReadOnly && !$exportacion_nutricion->Fecha_valoracion->Disabled && @$exportacion_nutricion->Fecha_valoracion->EditAttrs["readonly"] == "" && @$exportacion_nutricion->Fecha_valoracion->EditAttrs["disabled"] == "") { ?>
<button id="cal_x_Fecha_valoracion" name="cal_x_Fecha_valoracion" class="btn" type="button"><img src="phpimages/calendar.png" alt="<?php echo $Language->Phrase("PickDate") ?>" title="<?php echo $Language->Phrase("PickDate") ?>" style="border: 0;"></button><script type="text/javascript">
ew_CreateCalendar("fexportacion_nutricionlistsrch", "x_Fecha_valoracion", "%d/%m/%Y");
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_Fecha_valoracion">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="control-group ewSearchField btw1_Fecha_valoracion">
<input type="text" data-field="x_Fecha_valoracion" name="y_Fecha_valoracion" id="y_Fecha_valoracion" size="12" placeholder="<?php echo ew_HtmlEncode($exportacion_nutricion->Fecha_valoracion->PlaceHolder) ?>" value="<?php echo $exportacion_nutricion->Fecha_valoracion->EditValue2 ?>"<?php echo $exportacion_nutricion->Fecha_valoracion->EditAttributes() ?>>
<?php if (!$exportacion_nutricion->Fecha_valoracion->ReadOnly && !$exportacion_nutricion->Fecha_valoracion->Disabled && @$exportacion_nutricion->Fecha_valoracion->EditAttrs["readonly"] == "" && @$exportacion_nutricion->Fecha_valoracion->EditAttrs["disabled"] == "") { ?>
<button id="cal_y_Fecha_valoracion" name="cal_y_Fecha_valoracion" class="btn" type="button"><img src="phpimages/calendar.png" alt="<?php echo $Language->Phrase("PickDate") ?>" title="<?php echo $Language->Phrase("PickDate") ?>" style="border: 0;"></button><script type="text/javascript">
ew_CreateCalendar("fexportacion_nutricionlistsrch", "y_Fecha_valoracion", "%d/%m/%Y");
</script>
<?php } ?>
</span>
	</span>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
	<div class="btn-group ewButtonGroup">
	<div class="input-append">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="input-large" value="<?php echo ew_HtmlEncode($exportacion_nutricion_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
	<div class="btn-group ewButtonGroup">
	<a class="btn ewShowAll" href="<?php echo $exportacion_nutricion_list->PageUrl() ?>cmd=reset"><?php echo $Language->Phrase("ShowAll") ?></a>
	</div>
</div>
<div id="xsr_7" class="ewRow">
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="="<?php if ($exportacion_nutricion_list->BasicSearch->getType() == "=") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("ExactPhrase") ?></label>
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="AND"<?php if ($exportacion_nutricion_list->BasicSearch->getType() == "AND") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("AllWord") ?></label>
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="OR"<?php if ($exportacion_nutricion_list->BasicSearch->getType() == "OR") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("AnyWord") ?></label>
</div>
</div>
</div>
			</div>
		</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $exportacion_nutricion_list->ShowPageHeader(); ?>
<?php
$exportacion_nutricion_list->ShowMessage();
?>
<table class="ewGrid"><tr><td class="ewGridContent">
<?php if ($exportacion_nutricion->Export == "") { ?>
<div class="ewGridUpperPanel">
<?php if ($exportacion_nutricion->CurrentAction <> "gridadd" && $exportacion_nutricion->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>">
<table class="ewPager">
<tr><td>
<?php if (!isset($exportacion_nutricion_list->Pager)) $exportacion_nutricion_list->Pager = new cPrevNextPager($exportacion_nutricion_list->StartRec, $exportacion_nutricion_list->DisplayRecs, $exportacion_nutricion_list->TotalRecs) ?>
<?php if ($exportacion_nutricion_list->Pager->RecordCount > 0) { ?>
<table class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($exportacion_nutricion_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $exportacion_nutricion_list->PageUrl() ?>start=<?php echo $exportacion_nutricion_list->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($exportacion_nutricion_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $exportacion_nutricion_list->PageUrl() ?>start=<?php echo $exportacion_nutricion_list->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $exportacion_nutricion_list->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($exportacion_nutricion_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $exportacion_nutricion_list->PageUrl() ?>start=<?php echo $exportacion_nutricion_list->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($exportacion_nutricion_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" href="<?php echo $exportacion_nutricion_list->PageUrl() ?>start=<?php echo $exportacion_nutricion_list->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $exportacion_nutricion_list->Pager->PageCount ?>
</td>
<td>
	&nbsp;&nbsp;&nbsp;&nbsp;
	<?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $exportacion_nutricion_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $exportacion_nutricion_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $exportacion_nutricion_list->Pager->RecordCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<?php if ($Security->CanList()) { ?>
	<?php if ($exportacion_nutricion_list->SearchWhere == "0=101") { ?>
	<p><?php echo $Language->Phrase("EnterSearchCriteria") ?></p>
	<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
	<?php } ?>
	<?php } else { ?>
	<p><?php echo $Language->Phrase("NoPermission") ?></p>
	<?php } ?>
<?php } ?>
</td>
</tr></table>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($exportacion_nutricion_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
</div>
<?php } ?>
<form name="fexportacion_nutricionlist" id="fexportacion_nutricionlist" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="exportacion_nutricion">
<div id="gmp_exportacion_nutricion" class="ewGridMiddlePanel">
<?php if ($exportacion_nutricion_list->TotalRecs > 0) { ?>
<table id="tbl_exportacion_nutricionlist" class="ewTable ewTableSeparate">
<?php echo $exportacion_nutricion->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Render list options
$exportacion_nutricion_list->RenderListOptions();

// Render list options (header, left)
$exportacion_nutricion_list->ListOptions->Render("header", "left");
?>
<?php if ($exportacion_nutricion->Consecutivo->Visible) { // Consecutivo ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Consecutivo) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Consecutivo" class="exportacion_nutricion_Consecutivo"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Consecutivo->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Consecutivo) ?>',1);"><div id="elh_exportacion_nutricion_Consecutivo" class="exportacion_nutricion_Consecutivo">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Consecutivo->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Consecutivo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Consecutivo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Entidad->Visible) { // Entidad ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Entidad) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Entidad" class="exportacion_nutricion_Entidad"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Entidad->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Entidad) ?>',1);"><div id="elh_exportacion_nutricion_Entidad" class="exportacion_nutricion_Entidad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Entidad->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Entidad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Entidad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Tipo_Documento->Visible) { // Tipo_Documento ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Tipo_Documento) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Tipo_Documento" class="exportacion_nutricion_Tipo_Documento"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Tipo_Documento->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Tipo_Documento) ?>',1);"><div id="elh_exportacion_nutricion_Tipo_Documento" class="exportacion_nutricion_Tipo_Documento">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Tipo_Documento->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Tipo_Documento->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Tipo_Documento->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Documento->Visible) { // Documento ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Documento) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Documento" class="exportacion_nutricion_Documento"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Documento->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Documento) ?>',1);"><div id="elh_exportacion_nutricion_Documento" class="exportacion_nutricion_Documento">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Documento->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Documento->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Documento->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Genero->Visible) { // Genero ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Genero) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Genero" class="exportacion_nutricion_Genero"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Genero->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Genero) ?>',1);"><div id="elh_exportacion_nutricion_Genero" class="exportacion_nutricion_Genero">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Genero->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Genero->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Genero->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Nombres->Visible) { // Nombres ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Nombres) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Nombres" class="exportacion_nutricion_Nombres"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Nombres->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Nombres) ?>',1);"><div id="elh_exportacion_nutricion_Nombres" class="exportacion_nutricion_Nombres">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Nombres->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Nombres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Nombres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Apellidos->Visible) { // Apellidos ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Apellidos) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Apellidos" class="exportacion_nutricion_Apellidos"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Apellidos->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Apellidos) ?>',1);"><div id="elh_exportacion_nutricion_Apellidos" class="exportacion_nutricion_Apellidos">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Apellidos->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Apellidos->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Apellidos->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Fecha_valoracion->Visible) { // Fecha_valoracion ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Fecha_valoracion) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Fecha_valoracion" class="exportacion_nutricion_Fecha_valoracion"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Fecha_valoracion->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Fecha_valoracion) ?>',1);"><div id="elh_exportacion_nutricion_Fecha_valoracion" class="exportacion_nutricion_Fecha_valoracion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Fecha_valoracion->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Fecha_valoracion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Fecha_valoracion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Edad_Anos->Visible) { // Edad_Anos ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Edad_Anos) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Edad_Anos" class="exportacion_nutricion_Edad_Anos"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Edad_Anos->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Edad_Anos) ?>',1);"><div id="elh_exportacion_nutricion_Edad_Anos" class="exportacion_nutricion_Edad_Anos">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Edad_Anos->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Edad_Anos->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Edad_Anos->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Peso->Visible) { // Peso ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Peso) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Peso" class="exportacion_nutricion_Peso"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Peso->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Peso) ?>',1);"><div id="elh_exportacion_nutricion_Peso" class="exportacion_nutricion_Peso">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Peso->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Peso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Peso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Talla->Visible) { // Talla ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Talla) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Talla" class="exportacion_nutricion_Talla"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Talla->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Talla) ?>',1);"><div id="elh_exportacion_nutricion_Talla" class="exportacion_nutricion_Talla">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Talla->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Talla->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Talla->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->IMC->Visible) { // IMC ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->IMC) == "") { ?>
		<td><div id="elh_exportacion_nutricion_IMC" class="exportacion_nutricion_IMC"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->IMC->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->IMC) ?>',1);"><div id="elh_exportacion_nutricion_IMC" class="exportacion_nutricion_IMC">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->IMC->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->IMC->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->IMC->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->DS_PesoTalla->Visible) { // DS_PesoTalla ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->DS_PesoTalla) == "") { ?>
		<td><div id="elh_exportacion_nutricion_DS_PesoTalla" class="exportacion_nutricion_DS_PesoTalla"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->DS_PesoTalla->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->DS_PesoTalla) ?>',1);"><div id="elh_exportacion_nutricion_DS_PesoTalla" class="exportacion_nutricion_DS_PesoTalla">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->DS_PesoTalla->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->DS_PesoTalla->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->DS_PesoTalla->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Clasificacion_Talla_Edad->Visible) { // Clasificacion_Talla_Edad ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_Talla_Edad) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Clasificacion_Talla_Edad" class="exportacion_nutricion_Clasificacion_Talla_Edad"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_Talla_Edad->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_Talla_Edad) ?>',1);"><div id="elh_exportacion_nutricion_Clasificacion_Talla_Edad" class="exportacion_nutricion_Clasificacion_Talla_Edad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_Talla_Edad->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Clasificacion_Talla_Edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Clasificacion_Talla_Edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Clasificacion_Peso_Talla->Visible) { // Clasificacion_Peso_Talla ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_Peso_Talla) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Clasificacion_Peso_Talla" class="exportacion_nutricion_Clasificacion_Peso_Talla"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_Peso_Talla->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_Peso_Talla) ?>',1);"><div id="elh_exportacion_nutricion_Clasificacion_Peso_Talla" class="exportacion_nutricion_Clasificacion_Peso_Talla">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_Peso_Talla->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Clasificacion_Peso_Talla->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Clasificacion_Peso_Talla->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Clasificacion_Peso_Edad->Visible) { // Clasificacion_Peso_Edad ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_Peso_Edad) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Clasificacion_Peso_Edad" class="exportacion_nutricion_Clasificacion_Peso_Edad"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_Peso_Edad->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_Peso_Edad) ?>',1);"><div id="elh_exportacion_nutricion_Clasificacion_Peso_Edad" class="exportacion_nutricion_Clasificacion_Peso_Edad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_Peso_Edad->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Clasificacion_Peso_Edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Clasificacion_Peso_Edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Clasificacion_IMC_Edad->Visible) { // Clasificacion_IMC_Edad ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_IMC_Edad) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Clasificacion_IMC_Edad" class="exportacion_nutricion_Clasificacion_IMC_Edad"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_IMC_Edad->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificacion_IMC_Edad) ?>',1);"><div id="elh_exportacion_nutricion_Clasificacion_IMC_Edad" class="exportacion_nutricion_Clasificacion_IMC_Edad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificacion_IMC_Edad->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Clasificacion_IMC_Edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Clasificacion_IMC_Edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Zona->Visible) { // Zona ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Zona) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Zona" class="exportacion_nutricion_Zona"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Zona->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Zona) ?>',1);"><div id="elh_exportacion_nutricion_Zona" class="exportacion_nutricion_Zona">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Zona->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Zona->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Zona->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Barrio_Vereda->Visible) { // Barrio_Vereda ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Barrio_Vereda) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Barrio_Vereda" class="exportacion_nutricion_Barrio_Vereda"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Barrio_Vereda->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Barrio_Vereda) ?>',1);"><div id="elh_exportacion_nutricion_Barrio_Vereda" class="exportacion_nutricion_Barrio_Vereda">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Barrio_Vereda->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Barrio_Vereda->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Barrio_Vereda->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Localidad_Comuna->Visible) { // Localidad_Comuna ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Localidad_Comuna) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Localidad_Comuna" class="exportacion_nutricion_Localidad_Comuna"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Localidad_Comuna->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Localidad_Comuna) ?>',1);"><div id="elh_exportacion_nutricion_Localidad_Comuna" class="exportacion_nutricion_Localidad_Comuna">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Localidad_Comuna->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Localidad_Comuna->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Localidad_Comuna->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Pertenencia_Etnica->Visible) { // Pertenencia_Etnica ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Pertenencia_Etnica) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Pertenencia_Etnica" class="exportacion_nutricion_Pertenencia_Etnica"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Pertenencia_Etnica->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Pertenencia_Etnica) ?>',1);"><div id="elh_exportacion_nutricion_Pertenencia_Etnica" class="exportacion_nutricion_Pertenencia_Etnica">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Pertenencia_Etnica->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Pertenencia_Etnica->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Pertenencia_Etnica->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Tipo_Regimen_Salud) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Tipo_Regimen_Salud" class="exportacion_nutricion_Tipo_Regimen_Salud"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Tipo_Regimen_Salud->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Tipo_Regimen_Salud) ?>',1);"><div id="elh_exportacion_nutricion_Tipo_Regimen_Salud" class="exportacion_nutricion_Tipo_Regimen_Salud">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Tipo_Regimen_Salud->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Tipo_Regimen_Salud->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Tipo_Regimen_Salud->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Administradora_Salud->Visible) { // Administradora_Salud ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Administradora_Salud) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Administradora_Salud" class="exportacion_nutricion_Administradora_Salud"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Administradora_Salud->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Administradora_Salud) ?>',1);"><div id="elh_exportacion_nutricion_Administradora_Salud" class="exportacion_nutricion_Administradora_Salud">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Administradora_Salud->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Administradora_Salud->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Administradora_Salud->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Entidad_Educativa->Visible) { // Entidad_Educativa ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Entidad_Educativa) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Entidad_Educativa" class="exportacion_nutricion_Entidad_Educativa"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Entidad_Educativa->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Entidad_Educativa) ?>',1);"><div id="elh_exportacion_nutricion_Entidad_Educativa" class="exportacion_nutricion_Entidad_Educativa">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Entidad_Educativa->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Entidad_Educativa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Entidad_Educativa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Grado_Escolar->Visible) { // Grado_Escolar ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Grado_Escolar) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Grado_Escolar" class="exportacion_nutricion_Grado_Escolar"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Grado_Escolar->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Grado_Escolar) ?>',1);"><div id="elh_exportacion_nutricion_Grado_Escolar" class="exportacion_nutricion_Grado_Escolar">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Grado_Escolar->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Grado_Escolar->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Grado_Escolar->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Clasificado->Visible) { // Clasificado ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificado) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Clasificado" class="exportacion_nutricion_Clasificado"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificado->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Clasificado) ?>',1);"><div id="elh_exportacion_nutricion_Clasificado" class="exportacion_nutricion_Clasificado">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Clasificado->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Clasificado->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Clasificado->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Usuario->Visible) { // Usuario ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Usuario) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Usuario" class="exportacion_nutricion_Usuario"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Usuario->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Usuario) ?>',1);"><div id="elh_exportacion_nutricion_Usuario" class="exportacion_nutricion_Usuario">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Usuario->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($exportacion_nutricion->Fecha_edicion->Visible) { // Fecha_edicion ?>
	<?php if ($exportacion_nutricion->SortUrl($exportacion_nutricion->Fecha_edicion) == "") { ?>
		<td><div id="elh_exportacion_nutricion_Fecha_edicion" class="exportacion_nutricion_Fecha_edicion"><div class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Fecha_edicion->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $exportacion_nutricion->SortUrl($exportacion_nutricion->Fecha_edicion) ?>',1);"><div id="elh_exportacion_nutricion_Fecha_edicion" class="exportacion_nutricion_Fecha_edicion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $exportacion_nutricion->Fecha_edicion->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($exportacion_nutricion->Fecha_edicion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($exportacion_nutricion->Fecha_edicion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$exportacion_nutricion_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($exportacion_nutricion->ExportAll && $exportacion_nutricion->Export <> "") {
	$exportacion_nutricion_list->StopRec = $exportacion_nutricion_list->TotalRecs;
} else {

	// Set the last record to display
	if ($exportacion_nutricion_list->TotalRecs > $exportacion_nutricion_list->StartRec + $exportacion_nutricion_list->DisplayRecs - 1)
		$exportacion_nutricion_list->StopRec = $exportacion_nutricion_list->StartRec + $exportacion_nutricion_list->DisplayRecs - 1;
	else
		$exportacion_nutricion_list->StopRec = $exportacion_nutricion_list->TotalRecs;
}
$exportacion_nutricion_list->RecCnt = $exportacion_nutricion_list->StartRec - 1;
if ($exportacion_nutricion_list->Recordset && !$exportacion_nutricion_list->Recordset->EOF) {
	$exportacion_nutricion_list->Recordset->MoveFirst();
	if (!$bSelectLimit && $exportacion_nutricion_list->StartRec > 1)
		$exportacion_nutricion_list->Recordset->Move($exportacion_nutricion_list->StartRec - 1);
} elseif (!$exportacion_nutricion->AllowAddDeleteRow && $exportacion_nutricion_list->StopRec == 0) {
	$exportacion_nutricion_list->StopRec = $exportacion_nutricion->GridAddRowCount;
}

// Initialize aggregate
$exportacion_nutricion->RowType = EW_ROWTYPE_AGGREGATEINIT;
$exportacion_nutricion->ResetAttrs();
$exportacion_nutricion_list->RenderRow();
while ($exportacion_nutricion_list->RecCnt < $exportacion_nutricion_list->StopRec) {
	$exportacion_nutricion_list->RecCnt++;
	if (intval($exportacion_nutricion_list->RecCnt) >= intval($exportacion_nutricion_list->StartRec)) {
		$exportacion_nutricion_list->RowCnt++;

		// Set up key count
		$exportacion_nutricion_list->KeyCount = $exportacion_nutricion_list->RowIndex;

		// Init row class and style
		$exportacion_nutricion->ResetAttrs();
		$exportacion_nutricion->CssClass = "";
		if ($exportacion_nutricion->CurrentAction == "gridadd") {
		} else {
			$exportacion_nutricion_list->LoadRowValues($exportacion_nutricion_list->Recordset); // Load row values
		}
		$exportacion_nutricion->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$exportacion_nutricion->RowAttrs = array_merge($exportacion_nutricion->RowAttrs, array('data-rowindex'=>$exportacion_nutricion_list->RowCnt, 'id'=>'r' . $exportacion_nutricion_list->RowCnt . '_exportacion_nutricion', 'data-rowtype'=>$exportacion_nutricion->RowType));

		// Render row
		$exportacion_nutricion_list->RenderRow();

		// Render list options
		$exportacion_nutricion_list->RenderListOptions();
?>
	<tr<?php echo $exportacion_nutricion->RowAttributes() ?>>
<?php

// Render list options (body, left)
$exportacion_nutricion_list->ListOptions->Render("body", "left", $exportacion_nutricion_list->RowCnt);
?>
	<?php if ($exportacion_nutricion->Consecutivo->Visible) { // Consecutivo ?>
		<td<?php echo $exportacion_nutricion->Consecutivo->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Consecutivo->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Consecutivo->ListViewValue() ?></span>
<a id="<?php echo $exportacion_nutricion_list->PageObjName . "_row_" . $exportacion_nutricion_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Entidad->Visible) { // Entidad ?>
		<td<?php echo $exportacion_nutricion->Entidad->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Entidad->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Entidad->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Tipo_Documento->Visible) { // Tipo_Documento ?>
		<td<?php echo $exportacion_nutricion->Tipo_Documento->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Tipo_Documento->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Tipo_Documento->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Documento->Visible) { // Documento ?>
		<td<?php echo $exportacion_nutricion->Documento->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Documento->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Documento->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Genero->Visible) { // Genero ?>
		<td<?php echo $exportacion_nutricion->Genero->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Genero->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Genero->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Nombres->Visible) { // Nombres ?>
		<td<?php echo $exportacion_nutricion->Nombres->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Nombres->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Nombres->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Apellidos->Visible) { // Apellidos ?>
		<td<?php echo $exportacion_nutricion->Apellidos->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Apellidos->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Apellidos->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Fecha_valoracion->Visible) { // Fecha_valoracion ?>
		<td<?php echo $exportacion_nutricion->Fecha_valoracion->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Fecha_valoracion->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Fecha_valoracion->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Edad_Anos->Visible) { // Edad_Anos ?>
		<td<?php echo $exportacion_nutricion->Edad_Anos->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Edad_Anos->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Edad_Anos->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Peso->Visible) { // Peso ?>
		<td<?php echo $exportacion_nutricion->Peso->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Peso->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Peso->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Talla->Visible) { // Talla ?>
		<td<?php echo $exportacion_nutricion->Talla->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Talla->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Talla->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->IMC->Visible) { // IMC ?>
		<td<?php echo $exportacion_nutricion->IMC->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->IMC->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->IMC->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->DS_PesoTalla->Visible) { // DS_PesoTalla ?>
		<td<?php echo $exportacion_nutricion->DS_PesoTalla->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->DS_PesoTalla->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->DS_PesoTalla->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Clasificacion_Talla_Edad->Visible) { // Clasificacion_Talla_Edad ?>
		<td<?php echo $exportacion_nutricion->Clasificacion_Talla_Edad->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Clasificacion_Talla_Edad->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Clasificacion_Talla_Edad->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Clasificacion_Peso_Talla->Visible) { // Clasificacion_Peso_Talla ?>
		<td<?php echo $exportacion_nutricion->Clasificacion_Peso_Talla->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Clasificacion_Peso_Talla->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Clasificacion_Peso_Talla->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Clasificacion_Peso_Edad->Visible) { // Clasificacion_Peso_Edad ?>
		<td<?php echo $exportacion_nutricion->Clasificacion_Peso_Edad->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Clasificacion_Peso_Edad->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Clasificacion_Peso_Edad->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Clasificacion_IMC_Edad->Visible) { // Clasificacion_IMC_Edad ?>
		<td<?php echo $exportacion_nutricion->Clasificacion_IMC_Edad->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Clasificacion_IMC_Edad->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Clasificacion_IMC_Edad->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Zona->Visible) { // Zona ?>
		<td<?php echo $exportacion_nutricion->Zona->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Zona->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Zona->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Barrio_Vereda->Visible) { // Barrio_Vereda ?>
		<td<?php echo $exportacion_nutricion->Barrio_Vereda->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Barrio_Vereda->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Barrio_Vereda->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Localidad_Comuna->Visible) { // Localidad_Comuna ?>
		<td<?php echo $exportacion_nutricion->Localidad_Comuna->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Localidad_Comuna->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Localidad_Comuna->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Pertenencia_Etnica->Visible) { // Pertenencia_Etnica ?>
		<td<?php echo $exportacion_nutricion->Pertenencia_Etnica->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Pertenencia_Etnica->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Pertenencia_Etnica->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Tipo_Regimen_Salud->Visible) { // Tipo_Regimen_Salud ?>
		<td<?php echo $exportacion_nutricion->Tipo_Regimen_Salud->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Tipo_Regimen_Salud->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Tipo_Regimen_Salud->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Administradora_Salud->Visible) { // Administradora_Salud ?>
		<td<?php echo $exportacion_nutricion->Administradora_Salud->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Administradora_Salud->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Administradora_Salud->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Entidad_Educativa->Visible) { // Entidad_Educativa ?>
		<td<?php echo $exportacion_nutricion->Entidad_Educativa->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Entidad_Educativa->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Entidad_Educativa->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Grado_Escolar->Visible) { // Grado_Escolar ?>
		<td<?php echo $exportacion_nutricion->Grado_Escolar->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Grado_Escolar->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Grado_Escolar->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Clasificado->Visible) { // Clasificado ?>
		<td<?php echo $exportacion_nutricion->Clasificado->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Clasificado->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Clasificado->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Usuario->Visible) { // Usuario ?>
		<td<?php echo $exportacion_nutricion->Usuario->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Usuario->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Usuario->ListViewValue() ?></span>
</td>
	<?php } ?>
	<?php if ($exportacion_nutricion->Fecha_edicion->Visible) { // Fecha_edicion ?>
		<td<?php echo $exportacion_nutricion->Fecha_edicion->CellAttributes() ?>>
<span<?php echo $exportacion_nutricion->Fecha_edicion->ViewAttributes() ?>>
<?php echo $exportacion_nutricion->Fecha_edicion->ListViewValue() ?></span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$exportacion_nutricion_list->ListOptions->Render("body", "right", $exportacion_nutricion_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($exportacion_nutricion->CurrentAction <> "gridadd")
		$exportacion_nutricion_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($exportacion_nutricion->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($exportacion_nutricion_list->Recordset)
	$exportacion_nutricion_list->Recordset->Close();
?>
</td></tr></table>
<?php if ($exportacion_nutricion->Export == "") { ?>
<script type="text/javascript">
fexportacion_nutricionlistsrch.Init();
fexportacion_nutricionlist.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php } ?>
<?php
$exportacion_nutricion_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($exportacion_nutricion->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$exportacion_nutricion_list->Page_Terminate();
?>
