$(document).ready(function () {
	
	/********************************************************************************
	**      IMPORTANT  -  Configure where is the PROCESSOR FILE LOCATED            **
	**      Remember to set your EXACT URL. If your site is WWW.YOURSITE.COM       **
	**      you cannot set http://YOURSITE.COM Use the www if needed or not!       **
	********************************************************************************/
	
	$_CFG_PROCESSORFILE	= "http://127.0.0.1/IMEXporter/include/IMEXporter_processor.php";
	
	/******************************************************************************/
	
	
	
	
	var CFG_LANG = new Object;
	
	/* Get configurations, and language string for the system */
	$.post($_CFG_PROCESSORFILE, { "task": "getAJAXcfg" }, function(data){
		
		CFG_LANG.TBLVLNB 		= data.JSLANG.TBLVLNB;
		CFG_LANG.CSVVLNB 		= data.JSLANG.CSVVLNB;
		CFG_LANG.ISEMPTY		= data.JSLANG.ISEMPTY;
		CFG_LANG.Table			= data.JSLANG.Table;
		CFG_LANG.selected		= data.JSLANG.selected;
		CFG_LANG.Good			= data.JSLANG.Good;
		CFG_LANG.TabelCreat		= data.JSLANG.TabelCreat;
		CFG_LANG.FileNotAllow	= data.JSLANG.FileNotAllow;
		CFG_LANG.File			= data.JSLANG.File;
		CFG_LANG.uploaded		= data.JSLANG.uploaded;
		CFG_LANG.CSVMatch		= data.JSLANG.CSVMatch;
		CFG_LANG.CSVNOMatch		= data.JSLANG.CSVNOMatch;
		CFG_LANG.ValidSkip		= data.JSLANG.ValidSkip;
		CFG_LANG.SUbmitImp		= data.JSLANG.SUbmitImp;
		CFG_LANG.CSVhasTitle	= data.JSLANG.CSVhasTitle;
		CFG_LANG.ValidSkipTbl	= data.JSLANG.ValidSkipTbl;
		CFG_LANG.ImpoProc		= data.JSLANG.ImpoProc;
		CFG_LANG.STARTED		= data.JSLANG.STARTED;
		CFG_LANG.SuccessCreatTb	= data.JSLANG.SuccessCreatTb;
		CFG_LANG.FullVerifyDone	= data.JSLANG.FullVerifyDone;
		CFG_LANG.ValidSkipOpt	= data.JSLANG.ValidSkipOpt;
		CFG_LANG.DoMatchNow		= data.JSLANG.DoMatchNow;
		CFG_LANG.HeadersMatch	= data.JSLANG.HeadersMatch;
		CFG_LANG.ImportComplet	= data.JSLANG.ImportComplet;
		CFG_LANG.ImportProcess	= data.JSLANG.ImportProcess;
		CFG_LANG.HeadersManual	= data.JSLANG.HeadersManual;
		CFG_LANG.PerforCSV		= data.JSLANG.PerforCSV;
		CFG_LANG.FullChkDone	= data.JSLANG.FullChkDone;
		CFG_LANG.NeedConfirmTbl	= data.JSLANG.NeedConfirmTbl;
		CFG_LANG.SelectFile		= data.JSLANG.SelectFile;
		
	}, "json");
	
	
	
	$("#IMEXp_import_submit-selectTable").live("click", function(e){
		e.preventDefault();
		
		tableValue	= $("#IMEXp_import-selectTable-select").val();
		
		if (tableValue === null) {
			alert("No table selected!");
		} else {
			turnOff("selectTable");
			turnOn("uploadFile");
			
			$("#IMEXp_import_var-selectTable").val(tableValue);
			
			if (tableValue != "NEW")
				$('.IMEXp_import-selectTable .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.Table+" ("+tableValue+") "+CFG_LANG.selected+" "+CFG_LANG.Good);
			else
				$('.IMEXp_import-selectTable .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.TabelCreat+" "+CFG_LANG.Good);
		}
		
	});
	
	
	
	$('#IMEXp_import-uploadFile').fileupload({
        dataType: 'json',
        url: $_CFG_PROCESSORFILE + '?task=fileUpload_ProcessHandler',
        done: function (e, data) {
            $.each(data.result, function (index, file) {
				$('.selectedFileUpload').html(file.name);
				if (file.error) {
					if (file.error == "acceptFileTypes") {
						$("#IMEXp_import_var-uploadFile-status").val("0");
						$("#IMEXp_import_var-uploadFile-statusMsg").val(CFG_LANG.FileNotAllow);
						$("#IMEXp_upload_statusMsg").html($("#IMEXp_import_var-uploadFile-statusMsg").val());
						$("#IMEXp_upload_statusMsg").fadeOut("fast").fadeIn("slow");
					}
				} else {
					$("#IMEXp_upload_statusMsg").hide();
					$("#IMEXp_import_var-uploadFile-status").val("1");
					$("#IMEXp_import_var-uploadFile-file").val(file.fullName);
					$("#IMEXp_import_var-uploadFile-fileName").val(file.name);
				}
            });
        }
    });
	
	
	
	$("#IMEXp_import_submit-uploadFile").live("click", function(e){
		e.preventDefault();
		uploadStatus = $("#IMEXp_import_var-uploadFile-status").val();
		
		if (uploadStatus == "0") {
			$("#IMEXp_upload_statusMsg").fadeOut("fast").fadeIn("slow");
			
		} else if (uploadStatus == "1") {
			turnOff("uploadFile");
			turnOn("csvHeaders");
			fileName = $("#IMEXp_import_var-uploadFile-fileName").val();
			$('.IMEXp_import-uploadFile .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.File + " ("+fileName+") "+CFG_LANG.uploaded+" "+CFG_LANG.Good);
			
		} else {
			alert(CFG_LANG.SelectFile);
		}
		
	});
	
	
	
	$("#IMEXp_import_submit-csvHeaders").live("click", function(e){
		e.preventDefault();
		
		current_table 	= $("#IMEXp_import_var-selectTable").val();
		current_file 	= $("#IMEXp_import_var-uploadFile-file").val();
		current_fileN 	= $("#IMEXp_import_var-uploadFile-fileName").val();
		hasHeaders 		= $(".IMEXp_import-csvHeaders-check:checked").val();
		
		if (current_table != "NEW") {
			$.post($_CFG_PROCESSORFILE, {"task": "IMEXp_import-checkHeaders", "current_table": current_table, "current_file": current_file, "hasHeaders": hasHeaders }, function(data){
				if (data.msg == "HEADERS_MATCH") {
					$('.IMEXp_import-csvHeaders .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.CSVMatch + " "+CFG_LANG.Good);
					$("#IMEXp_import_var-csvHeaders").val(data.msg);
					turnOff("csvHeaders");
					turnOn("csvFullVerify");
					
				} else if ((data.msg == "CSV2TABLE_HEADERS_MATCHER") || (data.msg == "TABLE_HEADERS_MATCHER")) {
					$('.IMEXp_import-csvHeaders .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.CSVNOMatch);
					$.post($_CFG_PROCESSORFILE, {"task": "IMEXp_import-getMatcher", "current_table": current_table, "current_file": current_file, "hasHeaders": hasHeaders }, function(XHTML){
						// I know, terrible using exceptions here, but is there a better way to check if an html datatype ajax request returned a json !??
						try {
							XHTML = $.parseJSON(XHTML);
							$("#IMEXp_import_var-csvHeaders").val(data.msg);
							turnOff("csvHeaders");
							$('.IMEXp_import-csvFullVerify').fadeTo("fast", 1, function () {
								$('.IMEXp_import-csvFullVerify .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_warning").html(CFG_LANG.ValidSkip);
								$('.IMEXp_import-FinalStep').fadeTo("fast", 1, function () {
									$('.IMEXp_import-FinalStep .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_error").html(XHTML.msg);
								});
							});
							
						} catch (e) {
							$(".IMEXp_import_matcherWrapper").html(XHTML)
							$("#IMEXp_import_var-csvHeaders").val(data.msg);
							
							turnOff("csvHeaders");
							turnOn("csvFullVerify");
						}
					}, "html");
				}
			}, "json");
			
		} else {
			timestamp 		= Math.round((new Date()).getTime() / 1000);
			filename 		= current_fileN.substr(0, current_fileN.lastIndexOf('.')) || current_fileN;
			current_table	= filename.toLowerCase().replace(/[^a-zA-Z0-9]+/g, "") + "_" + timestamp;
			
			$.post($_CFG_PROCESSORFILE, {"task": "IMEXp_import-confirmtablecreation", "current_table": current_table, "current_file": current_file, "hasHeaders": hasHeaders }, function(data){
				
				if (data.status == 1) {
					$(".IMEXp_returnMSG").html(data.msg).hide().fadeIn();
					$("#submit_import_imexp_confirmtablecreation").attr("disabled", false).attr("value", CFG_LANG.SUbmitImp);
					$(".acceptCSVrepeat_container").fadeIn();
					
				} else {
					$('.IMEXp_import-csvHeaders .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.CSVhasTitle + " "+CFG_LANG.Good);
					$('.IMEXp_import-csvFullVerify .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.ValidSkipTbl);
					$('.IMEXp_import-csvFullVerify').fadeTo("fast", 1);
					
					$('#IMEXp_import-FinalStep-form').remove();
					
					turnOff("csvHeaders");
					turnOn("FinalStep");
					
					$('.IMEXp_import-FinalStep').addClass("IMEXp_import_step_disabled");
					$('.IMEXp_import-FinalStep .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.ImpoProc + " <strong>"+CFG_LANG.STARTED+"</strong>");
					$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled"><div class="IMEXp_output_msg IMEXp_output_msg_success">'+CFG_LANG.SuccessCreatTb+' ('+current_table+'). <strong>Good!</strong></div></div>');
					$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled"><div class="IMEXp_output_msg IMEXp_output_msg_success">'+data.msg+'</strong></div></div>');
				}
			}, "json");
		}
	});
	
	
	
	$("#IMEXp_import_submit-csvFullVerify").live("click", function(e){
		e.preventDefault();
		csvHeaders 	= $("#IMEXp_import_var-csvHeaders").val();
		fullVerify 	= $(".IMEXp_import-fullV-check:checked").val();
		$("#IMEXp_import_var-csvFullVerify").val(fullVerify);
		if(fullVerify == "1")
			$('.IMEXp_import-csvFullVerify .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.FullVerifyDone + " "+CFG_LANG.Good);
		else
			$('.IMEXp_import-csvFullVerify .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_success").html(CFG_LANG.ValidSkipOpt);
		
		turnOff("csvFullVerify");
		turnOn("FinalStep");
		
		if (csvHeaders == "CSV2TABLE_HEADERS_MATCHER") {
			$('.IMEXp_import-FinalStep .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral").addClass("IMEXp_output_msg_warning").html(CFG_LANG.DoMatchNow);
			
		} else if (csvHeaders == "HEADERS_MATCH") {
			$('.IMEXp_import-FinalStep').addClass("IMEXp_import_step_disabled");
			$("#IMEXp_import-FinalStep-form").remove();
			$('.IMEXp_import-FinalStep .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral IMEXp_output_msg_warning");
			$('.IMEXp_import-FinalStep .IMEXp_output_msg').addClass("IMEXp_output_msg_success");
			$('.IMEXp_import-FinalStep .IMEXp_output_msg').html(CFG_LANG.HeadersMatch + " <strong>"+CFG_LANG.Good+"</strong>");
			
			IMEXp_import = true;
			
			// Start the progress bar only if fullVerify is going to be performed but: If the csv titles (headers) have duplicates, wait for confirmation request (acceptCSVrepeat == "1")
			if (fullVerify == "1") {
				createProgressBar(IMEXp_import, CFG_LANG);
				window.interval = setInterval(function() {
					updateProgressBar(IMEXp_import, CFG_LANG);
				}, 500);
			}
			
			$.post($_CFG_PROCESSORFILE, {"task": "IMEXp_import-processHeadersMatched", "current_table": current_table, "current_file": current_file, 'fullVerify': fullVerify, 'hasHeaders': "1" }, function(data){
				
				if (data.status == 0) {
					destroyProgressBar(IMEXp_import, CFG_LANG);
					$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled"><div class="IMEXp_output_msg IMEXp_output_msg_success">'+data.msg+'</div></div>');
				} else {
					destroyProgressBar(IMEXp_import, CFG_LANG);
					$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled">'+data.msg+'</div>');
				}
			}, "json");
		}
	});
	
	
	
	/* submit_import_imexp_confirmtablecreation action */
	$("#submit_import_imexp_confirmtablecreation").live("click", function(e){
		e.preventDefault();
		
		$(".IMEXp_returnMSG").html("");
		$(".acceptCSVrepeat_container").hide();
		
		errors			= false;
		current_table	= $("#imexp_confirmtablecreation-current_table").val();
		current_file	= $("#imexp_confirmtablecreation-current_file").val();
		hasHeaders		= $("#imexp_confirmtablecreation-hasHeaders").val();
		confirmCreation	= $("#imexp_confirmtablecreation-confirmTableCreation:checked").val();
		
		if (confirmCreation == "1") {
			$("#submit_import_imexp_confirmtablecreation").attr("disabled", true).attr("value", "Processing import...");
			$('.IMEXp_CSVandTableHeaders_Matcher_container select').attr("disabled", true);
			$.post($_CFG_PROCESSORFILE, {"task": "preprocess_confirmtablecreation", "current_table": current_table, "current_file": current_file, "hasHeaders": hasHeaders }, function(data){
				if (data.status == 1) {
					$(".IMEXp_returnMSG").html(data.msg).hide().fadeIn();
					$("#submit_import_imexp_confirmtablecreation").attr("disabled", false).attr("value", CFG_LANG.SUbmitImp);
					$(".acceptCSVrepeat_container").fadeIn();
				} else {
					$('#IMEXp_OutputContainer').append('<div class="IMEXp_output_msg IMEXp_output_msg_success">'+CFG_LANG.SuccessCreatTb+' ('+current_table+'). <strong>'+CFG_LANG.Good+'</strong></div>');
					$('#IMEXp_OutputContainer').append('<div class="IMEXp_output_msg IMEXp_output_msg_success">'+data.msg+'</div>');
					$("#submit_import_imexp_confirmtablecreation").attr("disabled", true).attr("value", CFG_LANG.ImportComplet);
				}
			}, "json");
		} else {
			alert(CFG_LANG.NeedConfirmTbl);
		}
	}); 
	
	
	
	/* submit_import_CSVandTableHeaders_Matcher action */
	$("#submit_import_CSVandTableHeaders_Matcher").live("click", function(e){
		e.preventDefault();
		
		if ($("#IMEXp_import_var_holder").length > 0) {
			IMEXp_import	= true;
			fullverify		= $("#IMEXp_import_var-csvFullVerify").val();
		} else {
			IMEXp_import	= false;
			fullverify		= $("#CSVandTableHeaders_Matcher-fullverify").val();
		}
		
		$(".IMEXp_returnMSG").html("");
		$(".acceptCSVrepeat_container").hide();
		
		errors			= false;
		tblHeaders		= new Array();
		csvHeaders		= new Array();
		numberOption	= $("#CSVandTableHeaders_Matcher-number_options").val();
		current_table	= $("#CSVandTableHeaders_Matcher-current_table").val();
		current_file	= $("#CSVandTableHeaders_Matcher-current_file").val();
		numberRows		= $("#CSVandTableHeaders_Matcher-numberRows").val();
		acceptCSVrepeat	= $("#CSVandTableHeaders_Matcher-acceptCSVrepeat:checked").val();
		
		for (i=0; i<numberOption; i++) {
			if ($("#table_header_"+i+" option:selected").val() == "EMPTY") {
				alert(CFG_LANG.TBLVLNB + " " + (i+1) + " " + CFG_LANG.ISEMPTY);
				errors	= true;
				break;
			}
			if ($("#csv_header_"+i+" option:selected").val() == "EMPTY") {
				alert(CFG_LANG.CSVVLNB + " " + (i+1) + " " + CFG_LANG.ISEMPTY);
				errors	= true;
				break;
			}
			tblHeaders[i] = $("#table_header_"+i+" option:selected").val();
			csvHeaders[i] = $("#csv_header_"+i+" option:selected").val();
		}
		
		if (errors === false) {
			$("#submit_import_CSVandTableHeaders_Matcher").attr("disabled", true).attr("value", CFG_LANG.ImportProcess);
			$('.IMEXp_CSVandTableHeaders_Matcher_container select').attr("disabled", true);
			
			// Start the progress bar only if fullverify is going to be performed but: If the csv titles (headers) have duplicates, wait for confirmation request (acceptCSVrepeat == "1")
			if ((fullverify == "1") && ((checkDuplicates(csvHeaders) == false) || (acceptCSVrepeat == "1"))) {
				createProgressBar(IMEXp_import, CFG_LANG);
				window.interval = setInterval(function() {
					updateProgressBar(IMEXp_import, CFG_LANG);
				}, 500);
			}
			
			$.post($_CFG_PROCESSORFILE, {"task": "preprocess_CSVandTableHeaders_Matcher", "numberOption": numberOption, "acceptCSVrepeat": acceptCSVrepeat, "current_table": current_table, "current_file": current_file, 'tblHeaders': tblHeaders, 'fullverify': fullverify, 'numberRows': numberRows, 'csvHeaders': csvHeaders }, function(data){
				
				if (data.status == 1) {
					$(".IMEXp_returnMSG").html("");
					alert(data.msg);
					$("#submit_import_CSVandTableHeaders_Matcher").attr("disabled", false).attr("value", CFG_LANG.SUbmitImp);
				} else if (data.status == 2) {
					$(".IMEXp_returnMSG").html(data.msg).hide().fadeIn();
					$("#submit_import_CSVandTableHeaders_Matcher").attr("disabled", false).attr("value", CFG_LANG.SUbmitImp);
					$(".acceptCSVrepeat_container").fadeIn();
					
				} else if (data.status == 3) {
					destroyProgressBar(IMEXp_import, CFG_LANG);
					if(IMEXp_import == true) {
						$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled">'+data.msg+'</div>');
					} else {
						$('#IMEXp_OutputContainer').append(''+data.msg+'');
					}
					
				} else if (data.status == 0) {
					destroyProgressBar(IMEXp_import, CFG_LANG);
					
					if(IMEXp_import == true) {
						if (fullverify == "0") {
							$('#IMEXp_import-FinalStep-form').fadeOut();
							$('.IMEXp_import-FinalStep').addClass("IMEXp_import_step_disabled");
							$('.IMEXp_import-FinalStep .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral IMEXp_output_msg_warning");
							$('.IMEXp_import-FinalStep .IMEXp_output_msg').addClass("IMEXp_output_msg_success");
							$('.IMEXp_import-FinalStep .IMEXp_output_msg').html(CFG_LANG.HeadersManual + " <strong>"+CFG_LANG.Good+"</strong>");
							$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled"><div class="IMEXp_output_msg IMEXp_output_msg_success">'+CFG_LANG.ImpoProc + ' <strong>'+CFG_LANG.STARTED+'</strong></div></div>');
						}
						$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled"><div class="IMEXp_output_msg IMEXp_output_msg_success">'+data.msg+'</div></div>');
					} else {
						$('#IMEXp_OutputContainer').append('<div class="IMEXp_output_msg IMEXp_output_msg_success">'+data.msg+'</div>');
					}
					
					$("#submit_import_CSVandTableHeaders_Matcher").attr("disabled", true).attr("value", CFG_LANG.ImportComplet);
				}
			}, "json");
		}
	}); 
	
});






function checkDuplicates(arr) {
	var i,
	len=arr.length,
	out=[],
	obj={};

	for (i=0;i<len;i++) {
		obj[arr[i]]=0;
	}
	
	for (i in obj) {
		out.push(i);
	}

	if (arr.length == out.length)
		return false;
	else
		return true;
}


function createProgressBar(IMEXp_import, CFG_LANG) {
	if (IMEXp_import == true) {
		$('#CSVandTableHeaders_Matcher_warning_msg').fadeOut();
		$('#IMEXp_import-FinalStep-form').fadeOut();
		
		$('.IMEXp_import-FinalStep').addClass("IMEXp_import_step_disabled");
		$('.IMEXp_import-FinalStep .IMEXp_output_msg').removeClass("IMEXp_output_msg_neutral IMEXp_output_msg_warning").addClass("IMEXp_output_msg_success").html(CFG_LANG.HeadersManual + " <strong>"+CFG_LANG.Good+"</strong>");
		
		$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled"><div class="IMEXp_output_msg IMEXp_output_msg_success">'+CFG_LANG.ImpoProc + ' <strong>'+CFG_LANG.STARTED+'</strong></div></div>');
		
		content = '<div id="IMEXp_mainProgressDIV">'
				+ '<p>'+CFG_LANG.PerforCSV+'</p>'
				+ '<div id="pb" class="pb_container">'
				+ '<div id="pb_text" class="pb_text">0.0%</div>'
				+ '<div class="pb_bar">'
				+ '<div id="progress-bar" class="pb_before" style="width: 0%;"></div>'
				+ '<div id="transparent-bar" class="pb_after"></div>'
				+ '</div>'
				+ '<br style="height: 1px; font-size: 1px;">'
				+ '</div>'
				+ '</div>';
		$('#IMEXp_OutputContainer').append(content);
		
	} else {
		$('#CSVandTableHeaders_Matcher_warning_msg').fadeOut();
		$('.IMEXp_CSVandTableHeaders_Matcher_container').fadeOut();
		$('#IMEXp_OutputContainer').append('<div class="IMEXp_output_msg IMEXp_output_msg_success">'+CFG_LANG.HeadersManual+' <strong>'+CFG_LANG.Good+'</strong></div>');
		content = '<div id="IMEXp_mainProgressDIV">'
				+ '<p>'+CFG_LANG.PerforCSV+'</p>'
				+ '<div id="pb" class="pb_container">'
				+ '<div id="pb_text" class="pb_text">0.0%</div>'
				+ '<div class="pb_bar">'
				+ '<div id="progress-bar" class="pb_before" style="width: 0%;"></div>'
				+ '<div id="transparent-bar" class="pb_after"></div>'
				+ '</div>'
				+ '<br style="height: 1px; font-size: 1px;">'
				+ '</div>'
				+ '</div>';
		$('#IMEXp_OutputContainer').append(content);
	}
}


function updateProgressBar(IMEXp_import, CFG_LANG) {
	$.post($_CFG_PROCESSORFILE, {"task": "preprocess_CSVandTableHeaders_Matcher_progress"}, function(value){
		if (value < 100) {
			document.getElementById("progress-bar").style.width = value + "%";
			document.getElementById("pb_text").innerHTML = value + "%";
		} else {
			clearInterval(interval);
			destroyProgressBar(IMEXp_import, CFG_LANG);
		}
	});
}


function destroyProgressBar(IMEXp_import, CFG_LANG) {
	if(document.getElementById("progress-bar")) {
		clearInterval(interval);
		document.getElementById("progress-bar").style.width = "100%";
		document.getElementById("pb_text").innerHTML = "100%";
		$("#IMEXp_mainProgressDIV").remove();
		if(IMEXp_import == true)
			$('#IMEXp_OutputContainer').append('<div class="IMEXp_import_step IMEXp_import_step_disabled"><div class="IMEXp_output_msg IMEXp_output_msg_success">'+CFG_LANG.FullChkDone+' <strong>'+CFG_LANG.Good+'</strong></div></div>');
		else
			$('#IMEXp_OutputContainer').append('<div class="IMEXp_output_msg IMEXp_output_msg_success">'+CFG_LANG.FullChkDone+' <strong>'+CFG_LANG.Good+'</strong></div>');
	}
}


function turnOff(name) {
	$("#IMEXp_import-"+name+"-form").fadeOut(function() {
		$(".IMEXp_import-"+name+"").addClass("IMEXp_import_step_disabled");
	});
}


function turnOn(name) {
	$("#IMEXp_import-"+name+"-form").fadeIn();
	$(".IMEXp_import-"+name+"").removeClass("IMEXp_import_step_disabled");
	$(".IMEXp_import-"+name+"").fadeTo("slow", 1);
}