<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$nutricion_usuario_edit = NULL; // Initialize page object first

class cnutricion_usuario_edit extends cnutricion_usuario {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = "{5B1FB6D8-0E93-4F60-869F-153E389D6FED}";

	// Table name
	var $TableName = 'nutricion_usuario';

	// Page object name
	var $PageObjName = 'nutricion_usuario_edit';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS["nutricion_usuario"]) || get_class($GLOBALS["nutricion_usuario"]) == "cnutricion_usuario") {
			$GLOBALS["nutricion_usuario"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["nutricion_usuario"];
		}

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'nutricion_usuario', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("nutricion_usuariolist.php");
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter;
	var $DbDetailFilter;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Load key from QueryString
		if (@$_GET["Id_Usuario"] <> "") {
			$this->Id_Usuario->setQueryStringValue($_GET["Id_Usuario"]);
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Process form if post back
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			$this->LoadFormValues(); // Get form values
		} else {
			$this->CurrentAction = "I"; // Default action is display
		}

		// Check if valid key
		if ($this->Id_Usuario->CurrentValue == "")
			$this->Page_Terminate("nutricion_usuariolist.php"); // Invalid key, return to list

		// Validate form if post back
		if (@$_POST["a_edit"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("nutricion_usuariolist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$sReturnUrl = $this->getReturnUrl();
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->Id_Usuario->FldIsDetailKey)
			$this->Id_Usuario->setFormValue($objForm->GetValue("x_Id_Usuario"));
		if (!$this->Nombres->FldIsDetailKey) {
			$this->Nombres->setFormValue($objForm->GetValue("x_Nombres"));
		}
		if (!$this->Apellidos->FldIsDetailKey) {
			$this->Apellidos->setFormValue($objForm->GetValue("x_Apellidos"));
		}
		if (!$this->Cedula_Identificacion->FldIsDetailKey) {
			$this->Cedula_Identificacion->setFormValue($objForm->GetValue("x_Cedula_Identificacion"));
		}
		if (!$this->Correo->FldIsDetailKey) {
			$this->Correo->setFormValue($objForm->GetValue("x_Correo"));
		}
		if (!$this->Tipo_Entidad->FldIsDetailKey) {
			$this->Tipo_Entidad->setFormValue($objForm->GetValue("x_Tipo_Entidad"));
		}
		if (!$this->Entidad->FldIsDetailKey) {
			$this->Entidad->setFormValue($objForm->GetValue("x_Entidad"));
		}
		if (!$this->Ingreso->FldIsDetailKey) {
			$this->Ingreso->setFormValue($objForm->GetValue("x_Ingreso"));
		}
		if (!$this->Clave->FldIsDetailKey) {
			$this->Clave->setFormValue($objForm->GetValue("x_Clave"));
		}
		if (!$this->Nivel->FldIsDetailKey) {
			$this->Nivel->setFormValue($objForm->GetValue("x_Nivel"));
		}
		if (!$this->Activo->FldIsDetailKey) {
			$this->Activo->setFormValue($objForm->GetValue("x_Activo"));
		}
		if (!$this->Reporta_a->FldIsDetailKey) {
			$this->Reporta_a->setFormValue($objForm->GetValue("x_Reporta_a"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadRow();
		$this->Id_Usuario->CurrentValue = $this->Id_Usuario->FormValue;
		$this->Nombres->CurrentValue = $this->Nombres->FormValue;
		$this->Apellidos->CurrentValue = $this->Apellidos->FormValue;
		$this->Cedula_Identificacion->CurrentValue = $this->Cedula_Identificacion->FormValue;
		$this->Correo->CurrentValue = $this->Correo->FormValue;
		$this->Tipo_Entidad->CurrentValue = $this->Tipo_Entidad->FormValue;
		$this->Entidad->CurrentValue = $this->Entidad->FormValue;
		$this->Ingreso->CurrentValue = $this->Ingreso->FormValue;
		$this->Clave->CurrentValue = $this->Clave->FormValue;
		$this->Nivel->CurrentValue = $this->Nivel->FormValue;
		$this->Activo->CurrentValue = $this->Activo->FormValue;
		$this->Reporta_a->CurrentValue = $this->Reporta_a->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id_Usuario->setDbValue($rs->fields('Id_Usuario'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Cedula_Identificacion->setDbValue($rs->fields('Cedula_Identificacion'));
		$this->Correo->setDbValue($rs->fields('Correo'));
		$this->Tipo_Entidad->setDbValue($rs->fields('Tipo_Entidad'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->Ingreso->setDbValue($rs->fields('Ingreso'));
		$this->Clave->setDbValue($rs->fields('Clave'));
		$this->Nivel->setDbValue($rs->fields('Nivel'));
		$this->Activo->setDbValue($rs->fields('Activo'));
		$this->Reporta_a->setDbValue($rs->fields('Reporta_a'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id_Usuario->DbValue = $row['Id_Usuario'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Cedula_Identificacion->DbValue = $row['Cedula_Identificacion'];
		$this->Correo->DbValue = $row['Correo'];
		$this->Tipo_Entidad->DbValue = $row['Tipo_Entidad'];
		$this->Entidad->DbValue = $row['Entidad'];
		$this->Ingreso->DbValue = $row['Ingreso'];
		$this->Clave->DbValue = $row['Clave'];
		$this->Nivel->DbValue = $row['Nivel'];
		$this->Activo->DbValue = $row['Activo'];
		$this->Reporta_a->DbValue = $row['Reporta_a'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Id_Usuario
		// Nombres
		// Apellidos
		// Cedula_Identificacion
		// Correo
		// Tipo_Entidad
		// Entidad
		// Ingreso
		// Clave
		// Nivel
		// Activo
		// Reporta_a

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// Id_Usuario
			$this->Id_Usuario->ViewValue = $this->Id_Usuario->CurrentValue;
			$this->Id_Usuario->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
			$this->Nombres->ViewCustomAttributes = "";

			// Apellidos
			$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
			$this->Apellidos->ViewCustomAttributes = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->ViewValue = $this->Cedula_Identificacion->CurrentValue;
			$this->Cedula_Identificacion->ViewCustomAttributes = "";

			// Correo
			$this->Correo->ViewValue = $this->Correo->CurrentValue;
			$this->Correo->ViewCustomAttributes = "";

			// Tipo_Entidad
			if (strval($this->Tipo_Entidad->CurrentValue) <> "") {
				switch ($this->Tipo_Entidad->CurrentValue) {
					case $this->Tipo_Entidad->FldTagValue(1):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(1) <> "" ? $this->Tipo_Entidad->FldTagCaption(1) : $this->Tipo_Entidad->CurrentValue;
						break;
					case $this->Tipo_Entidad->FldTagValue(2):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(2) <> "" ? $this->Tipo_Entidad->FldTagCaption(2) : $this->Tipo_Entidad->CurrentValue;
						break;
					default:
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->CurrentValue;
				}
			} else {
				$this->Tipo_Entidad->ViewValue = NULL;
			}
			$this->Tipo_Entidad->ViewCustomAttributes = "";

			// Entidad
			if (strval($this->Entidad->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, `Codigo` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			$lookuptblfilter = "`Activa`=1";
			if (strval($lookuptblfilter) <> "") {
				ew_AddFilter($sWhereWrk, $lookuptblfilter);
			}
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Entidad->ViewValue = $rswrk->fields('DispFld');
					$this->Entidad->ViewValue .= ew_ValueSeparator(1,$this->Entidad) . $rswrk->fields('Disp2Fld');
					$rswrk->Close();
				} else {
					$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
				}
			} else {
				$this->Entidad->ViewValue = NULL;
			}
			$this->Entidad->ViewCustomAttributes = "";

			// Ingreso
			$this->Ingreso->ViewValue = $this->Ingreso->CurrentValue;
			$this->Ingreso->ViewCustomAttributes = "";

			// Clave
			$this->Clave->ViewValue = $this->Clave->CurrentValue;
			$this->Clave->ViewCustomAttributes = "";

			// Nivel
			if ($Security->CanAdmin()) { // System admin
			if (strval($this->Nivel->CurrentValue) <> "") {
				$sFilterWrk = "`nivelusuario`" . ew_SearchString("=", $this->Nivel->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `nivelusuario`, `nombrenivel` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_niveles`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Nivel, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Nivel->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Nivel->ViewValue = $this->Nivel->CurrentValue;
				}
			} else {
				$this->Nivel->ViewValue = NULL;
			}
			} else {
				$this->Nivel->ViewValue = "********";
			}
			$this->Nivel->ViewCustomAttributes = "";

			// Activo
			if (strval($this->Activo->CurrentValue) <> "") {
				switch ($this->Activo->CurrentValue) {
					case $this->Activo->FldTagValue(1):
						$this->Activo->ViewValue = $this->Activo->FldTagCaption(1) <> "" ? $this->Activo->FldTagCaption(1) : $this->Activo->CurrentValue;
						break;
					case $this->Activo->FldTagValue(2):
						$this->Activo->ViewValue = $this->Activo->FldTagCaption(2) <> "" ? $this->Activo->FldTagCaption(2) : $this->Activo->CurrentValue;
						break;
					default:
						$this->Activo->ViewValue = $this->Activo->CurrentValue;
				}
			} else {
				$this->Activo->ViewValue = NULL;
			}
			$this->Activo->ViewCustomAttributes = "";

			// Reporta_a
			$this->Reporta_a->ViewValue = $this->Reporta_a->CurrentValue;
			$this->Reporta_a->ViewCustomAttributes = "";

			// Id_Usuario
			$this->Id_Usuario->LinkCustomAttributes = "";
			$this->Id_Usuario->HrefValue = "";
			$this->Id_Usuario->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->LinkCustomAttributes = "";
			$this->Cedula_Identificacion->HrefValue = "";
			$this->Cedula_Identificacion->TooltipValue = "";

			// Correo
			$this->Correo->LinkCustomAttributes = "";
			$this->Correo->HrefValue = "";
			$this->Correo->TooltipValue = "";

			// Tipo_Entidad
			$this->Tipo_Entidad->LinkCustomAttributes = "";
			$this->Tipo_Entidad->HrefValue = "";
			$this->Tipo_Entidad->TooltipValue = "";

			// Entidad
			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";
			$this->Entidad->TooltipValue = "";

			// Ingreso
			$this->Ingreso->LinkCustomAttributes = "";
			$this->Ingreso->HrefValue = "";
			$this->Ingreso->TooltipValue = "";

			// Clave
			$this->Clave->LinkCustomAttributes = "";
			$this->Clave->HrefValue = "";
			$this->Clave->TooltipValue = "";

			// Nivel
			$this->Nivel->LinkCustomAttributes = "";
			$this->Nivel->HrefValue = "";
			$this->Nivel->TooltipValue = "";

			// Activo
			$this->Activo->LinkCustomAttributes = "";
			$this->Activo->HrefValue = "";
			$this->Activo->TooltipValue = "";

			// Reporta_a
			$this->Reporta_a->LinkCustomAttributes = "";
			$this->Reporta_a->HrefValue = "";
			$this->Reporta_a->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// Id_Usuario
			$this->Id_Usuario->EditCustomAttributes = "";
			$this->Id_Usuario->EditValue = $this->Id_Usuario->CurrentValue;
			$this->Id_Usuario->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->EditCustomAttributes = "";
			$this->Nombres->EditValue = ew_HtmlEncode($this->Nombres->CurrentValue);
			$this->Nombres->PlaceHolder = ew_RemoveHtml($this->Nombres->FldCaption());

			// Apellidos
			$this->Apellidos->EditCustomAttributes = "";
			$this->Apellidos->EditValue = ew_HtmlEncode($this->Apellidos->CurrentValue);
			$this->Apellidos->PlaceHolder = ew_RemoveHtml($this->Apellidos->FldCaption());

			// Cedula_Identificacion
			$this->Cedula_Identificacion->EditCustomAttributes = "";
			$this->Cedula_Identificacion->EditValue = ew_HtmlEncode($this->Cedula_Identificacion->CurrentValue);
			$this->Cedula_Identificacion->PlaceHolder = ew_RemoveHtml($this->Cedula_Identificacion->FldCaption());

			// Correo
			$this->Correo->EditCustomAttributes = "";
			$this->Correo->EditValue = ew_HtmlEncode($this->Correo->CurrentValue);
			$this->Correo->PlaceHolder = ew_RemoveHtml($this->Correo->FldCaption());

			// Tipo_Entidad
			$this->Tipo_Entidad->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->Tipo_Entidad->FldTagValue(1), $this->Tipo_Entidad->FldTagCaption(1) <> "" ? $this->Tipo_Entidad->FldTagCaption(1) : $this->Tipo_Entidad->FldTagValue(1));
			$arwrk[] = array($this->Tipo_Entidad->FldTagValue(2), $this->Tipo_Entidad->FldTagCaption(2) <> "" ? $this->Tipo_Entidad->FldTagCaption(2) : $this->Tipo_Entidad->FldTagValue(2));
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect")));
			$this->Tipo_Entidad->EditValue = $arwrk;

			// Entidad
			$this->Entidad->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, `Codigo` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `Tipo_Entidad` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `entidad_upgd`";
			$sWhereWrk = "";
			$lookuptblfilter = "`Activa`=1";
			if (strval($lookuptblfilter) <> "") {
				ew_AddFilter($sWhereWrk, $lookuptblfilter);
			}
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Entidad->EditValue = $arwrk;

			// Ingreso
			$this->Ingreso->EditCustomAttributes = "";
			$this->Ingreso->EditValue = ew_HtmlEncode($this->Ingreso->CurrentValue);
			$this->Ingreso->PlaceHolder = ew_RemoveHtml($this->Ingreso->FldCaption());

			// Clave
			$this->Clave->EditCustomAttributes = "";
			$this->Clave->EditValue = ew_HtmlEncode($this->Clave->CurrentValue);
			$this->Clave->PlaceHolder = ew_RemoveHtml($this->Clave->FldCaption());

			// Nivel
			$this->Nivel->EditCustomAttributes = "";
			if (!$Security->CanAdmin()) { // System admin
				$this->Nivel->EditValue = "********";
			} else {
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `nivelusuario`, `nombrenivel` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_niveles`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Nivel, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Nivel->EditValue = $arwrk;
			}

			// Activo
			$this->Activo->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->Activo->FldTagValue(1), $this->Activo->FldTagCaption(1) <> "" ? $this->Activo->FldTagCaption(1) : $this->Activo->FldTagValue(1));
			$arwrk[] = array($this->Activo->FldTagValue(2), $this->Activo->FldTagCaption(2) <> "" ? $this->Activo->FldTagCaption(2) : $this->Activo->FldTagValue(2));
			$this->Activo->EditValue = $arwrk;

			// Reporta_a
			$this->Reporta_a->EditCustomAttributes = "";
			$this->Reporta_a->EditValue = ew_HtmlEncode($this->Reporta_a->CurrentValue);
			$this->Reporta_a->PlaceHolder = ew_RemoveHtml($this->Reporta_a->FldCaption());

			// Edit refer script
			// Id_Usuario

			$this->Id_Usuario->HrefValue = "";

			// Nombres
			$this->Nombres->HrefValue = "";

			// Apellidos
			$this->Apellidos->HrefValue = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->HrefValue = "";

			// Correo
			$this->Correo->HrefValue = "";

			// Tipo_Entidad
			$this->Tipo_Entidad->HrefValue = "";

			// Entidad
			$this->Entidad->HrefValue = "";

			// Ingreso
			$this->Ingreso->HrefValue = "";

			// Clave
			$this->Clave->HrefValue = "";

			// Nivel
			$this->Nivel->HrefValue = "";

			// Activo
			$this->Activo->HrefValue = "";

			// Reporta_a
			$this->Reporta_a->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->Nombres->FldIsDetailKey && !is_null($this->Nombres->FormValue) && $this->Nombres->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Nombres->FldCaption());
		}
		if (!$this->Apellidos->FldIsDetailKey && !is_null($this->Apellidos->FormValue) && $this->Apellidos->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Apellidos->FldCaption());
		}
		if (!$this->Cedula_Identificacion->FldIsDetailKey && !is_null($this->Cedula_Identificacion->FormValue) && $this->Cedula_Identificacion->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Cedula_Identificacion->FldCaption());
		}
		if (!$this->Correo->FldIsDetailKey && !is_null($this->Correo->FormValue) && $this->Correo->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Correo->FldCaption());
		}
		if (!ew_CheckEmail($this->Correo->FormValue)) {
			ew_AddMessage($gsFormError, $this->Correo->FldErrMsg());
		}
		if (!$this->Tipo_Entidad->FldIsDetailKey && !is_null($this->Tipo_Entidad->FormValue) && $this->Tipo_Entidad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Tipo_Entidad->FldCaption());
		}
		if (!$this->Entidad->FldIsDetailKey && !is_null($this->Entidad->FormValue) && $this->Entidad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Entidad->FldCaption());
		}
		if (!$this->Ingreso->FldIsDetailKey && !is_null($this->Ingreso->FormValue) && $this->Ingreso->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Ingreso->FldCaption());
		}
		if (!$this->Clave->FldIsDetailKey && !is_null($this->Clave->FormValue) && $this->Clave->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Clave->FldCaption());
		}
		if (!$this->Nivel->FldIsDetailKey && !is_null($this->Nivel->FormValue) && $this->Nivel->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Nivel->FldCaption());
		}
		if ($this->Activo->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Activo->FldCaption());
		}
		if (!ew_CheckInteger($this->Reporta_a->FormValue)) {
			ew_AddMessage($gsFormError, $this->Reporta_a->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();
		if ($this->Correo->CurrentValue <> "") { // Check field with unique index
			$sFilterChk = "(`Correo` = '" . ew_AdjustSql($this->Correo->CurrentValue) . "')";
			$sFilterChk .= " AND NOT (" . $sFilter . ")";
			$this->CurrentFilter = $sFilterChk;
			$sSqlChk = $this->SQL();
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$rsChk = $conn->Execute($sSqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", $this->Correo->FldCaption(), $Language->Phrase("DupIndex"));
				$sIdxErrMsg = str_replace("%v", $this->Correo->CurrentValue, $sIdxErrMsg);
				$this->setFailureMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
			$rsChk->Close();
		}
		if ($this->Ingreso->CurrentValue <> "") { // Check field with unique index
			$sFilterChk = "(`Ingreso` = '" . ew_AdjustSql($this->Ingreso->CurrentValue) . "')";
			$sFilterChk .= " AND NOT (" . $sFilter . ")";
			$this->CurrentFilter = $sFilterChk;
			$sSqlChk = $this->SQL();
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$rsChk = $conn->Execute($sSqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", $this->Ingreso->FldCaption(), $Language->Phrase("DupIndex"));
				$sIdxErrMsg = str_replace("%v", $this->Ingreso->CurrentValue, $sIdxErrMsg);
				$this->setFailureMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
			$rsChk->Close();
		}
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// Nombres
			$this->Nombres->SetDbValueDef($rsnew, $this->Nombres->CurrentValue, "", $this->Nombres->ReadOnly);

			// Apellidos
			$this->Apellidos->SetDbValueDef($rsnew, $this->Apellidos->CurrentValue, "", $this->Apellidos->ReadOnly);

			// Cedula_Identificacion
			$this->Cedula_Identificacion->SetDbValueDef($rsnew, $this->Cedula_Identificacion->CurrentValue, "", $this->Cedula_Identificacion->ReadOnly);

			// Correo
			$this->Correo->SetDbValueDef($rsnew, $this->Correo->CurrentValue, "", $this->Correo->ReadOnly);

			// Tipo_Entidad
			$this->Tipo_Entidad->SetDbValueDef($rsnew, $this->Tipo_Entidad->CurrentValue, 0, $this->Tipo_Entidad->ReadOnly);

			// Entidad
			$this->Entidad->SetDbValueDef($rsnew, $this->Entidad->CurrentValue, 0, $this->Entidad->ReadOnly);

			// Ingreso
			$this->Ingreso->SetDbValueDef($rsnew, $this->Ingreso->CurrentValue, "", $this->Ingreso->ReadOnly);

			// Clave
			$this->Clave->SetDbValueDef($rsnew, $this->Clave->CurrentValue, "", $this->Clave->ReadOnly || (EW_ENCRYPTED_PASSWORD && $rs->fields('Clave') == $this->Clave->CurrentValue));

			// Nivel
			if ($Security->CanAdmin()) { // System admin
			$this->Nivel->SetDbValueDef($rsnew, $this->Nivel->CurrentValue, 0, $this->Nivel->ReadOnly);
			}

			// Activo
			$this->Activo->SetDbValueDef($rsnew, $this->Activo->CurrentValue, 0, $this->Activo->ReadOnly);

			// Reporta_a
			$this->Reporta_a->SetDbValueDef($rsnew, $this->Reporta_a->CurrentValue, NULL, $this->Reporta_a->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = 'ew_ErrorFn';
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$Breadcrumb->Add("list", $this->TableVar, "nutricion_usuariolist.php", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, ew_CurrentUrl());
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($nutricion_usuario_edit)) $nutricion_usuario_edit = new cnutricion_usuario_edit();

// Page init
$nutricion_usuario_edit->Page_Init();

// Page main
$nutricion_usuario_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$nutricion_usuario_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var nutricion_usuario_edit = new ew_Page("nutricion_usuario_edit");
nutricion_usuario_edit.PageID = "edit"; // Page ID
var EW_PAGE_ID = nutricion_usuario_edit.PageID; // For backward compatibility

// Form object
var fnutricion_usuarioedit = new ew_Form("fnutricion_usuarioedit");

// Validate form
fnutricion_usuarioedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_Nombres");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Nombres->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Apellidos");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Apellidos->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Cedula_Identificacion");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Cedula_Identificacion->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Correo");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Correo->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Correo");
			if (elm && !ew_CheckEmail(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_usuario->Correo->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Tipo_Entidad");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Tipo_Entidad->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Entidad");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Entidad->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Ingreso");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Ingreso->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Clave");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Clave->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Nivel");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Nivel->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Activo");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_usuario->Activo->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_Reporta_a");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_usuario->Reporta_a->FldErrMsg()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnutricion_usuarioedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnutricion_usuarioedit.ValidateRequired = true;
<?php } else { ?>
fnutricion_usuarioedit.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnutricion_usuarioedit.Lists["x_Entidad"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Entidad","x_Codigo","",""],"ParentFields":["x_Tipo_Entidad"],"FilterFields":["x_Tipo_Entidad"],"Options":[]};
fnutricion_usuarioedit.Lists["x_Nivel"] = {"LinkField":"x_nivelusuario","Ajax":null,"AutoFill":false,"DisplayFields":["x_nombrenivel","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<?php $nutricion_usuario_edit->ShowPageHeader(); ?>
<?php
$nutricion_usuario_edit->ShowMessage();
?>
<form name="fnutricion_usuarioedit" id="fnutricion_usuarioedit" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="nutricion_usuario">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<div id="tpd_nutricion_usuarioedit"></div>
<script id="tpm_nutricion_usuarioedit" type="text/html">
<span id="ct_nutricion_usuario_edit"><table class="table table-bordered table-striped">
<tbody>
<tr>
<td><?php echo $nutricion_usuario->Nombres->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Nombres"/}}</td>
<td> <?php echo $nutricion_usuario->Apellidos->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Apellidos"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Cedula_Identificacion->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Cedula_Identificacion"/}}</td>
<td> <?php echo $nutricion_usuario->Correo->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Correo"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Tipo_Entidad->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Tipo_Entidad"/}}</td>
<td> <?php echo $nutricion_usuario->Entidad->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Entidad"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Ingreso->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Ingreso"/}}</td>
<td> <?php echo $nutricion_usuario->Clave->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Clave"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Nivel->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Nivel"/}}</td>
<td> <?php echo $nutricion_usuario->Activo->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Activo"/}}</td>
</tr>
</tbody>
</table>
</span>
</script>
<table class="ewGrid" style="display: none"><tr><td>
<table id="tbl_nutricion_usuarioedit" class="table table-bordered table-striped">
<?php if ($nutricion_usuario->Id_Usuario->Visible) { // Id_Usuario ?>
	<tr id="r_Id_Usuario">
		<td><span id="elh_nutricion_usuario_Id_Usuario"><script id="tpc_nutricion_usuario_Id_Usuario" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Id_Usuario->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Id_Usuario->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Id_Usuario" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Id_Usuario" class="control-group">
<span<?php echo $nutricion_usuario->Id_Usuario->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Id_Usuario->EditValue ?></span>
</span>
</script>
<input type="hidden" data-field="x_Id_Usuario" name="x_Id_Usuario" id="x_Id_Usuario" value="<?php echo ew_HtmlEncode($nutricion_usuario->Id_Usuario->CurrentValue) ?>">
<?php echo $nutricion_usuario->Id_Usuario->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Nombres->Visible) { // Nombres ?>
	<tr id="r_Nombres">
		<td><span id="elh_nutricion_usuario_Nombres"><script id="tpc_nutricion_usuario_Nombres" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Nombres->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Nombres->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Nombres" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Nombres" class="control-group">
<input type="text" data-field="x_Nombres" name="x_Nombres" id="x_Nombres" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($nutricion_usuario->Nombres->PlaceHolder) ?>" value="<?php echo $nutricion_usuario->Nombres->EditValue ?>"<?php echo $nutricion_usuario->Nombres->EditAttributes() ?>>
</span>
</script>
<?php echo $nutricion_usuario->Nombres->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Apellidos->Visible) { // Apellidos ?>
	<tr id="r_Apellidos">
		<td><span id="elh_nutricion_usuario_Apellidos"><script id="tpc_nutricion_usuario_Apellidos" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Apellidos->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Apellidos->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Apellidos" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Apellidos" class="control-group">
<input type="text" data-field="x_Apellidos" name="x_Apellidos" id="x_Apellidos" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($nutricion_usuario->Apellidos->PlaceHolder) ?>" value="<?php echo $nutricion_usuario->Apellidos->EditValue ?>"<?php echo $nutricion_usuario->Apellidos->EditAttributes() ?>>
</span>
</script>
<?php echo $nutricion_usuario->Apellidos->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Cedula_Identificacion->Visible) { // Cedula_Identificacion ?>
	<tr id="r_Cedula_Identificacion">
		<td><span id="elh_nutricion_usuario_Cedula_Identificacion"><script id="tpc_nutricion_usuario_Cedula_Identificacion" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Cedula_Identificacion->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Cedula_Identificacion->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Cedula_Identificacion" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Cedula_Identificacion" class="control-group">
<input type="text" data-field="x_Cedula_Identificacion" name="x_Cedula_Identificacion" id="x_Cedula_Identificacion" size="30" maxlength="30" placeholder="<?php echo ew_HtmlEncode($nutricion_usuario->Cedula_Identificacion->PlaceHolder) ?>" value="<?php echo $nutricion_usuario->Cedula_Identificacion->EditValue ?>"<?php echo $nutricion_usuario->Cedula_Identificacion->EditAttributes() ?>>
</span>
</script>
<?php echo $nutricion_usuario->Cedula_Identificacion->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Correo->Visible) { // Correo ?>
	<tr id="r_Correo">
		<td><span id="elh_nutricion_usuario_Correo"><script id="tpc_nutricion_usuario_Correo" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Correo->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Correo->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Correo" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Correo" class="control-group">
<input type="text" data-field="x_Correo" name="x_Correo" id="x_Correo" size="30" maxlength="120" placeholder="<?php echo ew_HtmlEncode($nutricion_usuario->Correo->PlaceHolder) ?>" value="<?php echo $nutricion_usuario->Correo->EditValue ?>"<?php echo $nutricion_usuario->Correo->EditAttributes() ?>>
</span>
</script>
<?php echo $nutricion_usuario->Correo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Tipo_Entidad->Visible) { // Tipo_Entidad ?>
	<tr id="r_Tipo_Entidad">
		<td><span id="elh_nutricion_usuario_Tipo_Entidad"><script id="tpc_nutricion_usuario_Tipo_Entidad" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Tipo_Entidad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Tipo_Entidad->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Tipo_Entidad" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Tipo_Entidad" class="control-group">
<?php $nutricion_usuario->Tipo_Entidad->EditAttrs["onchange"] = "ew_UpdateOpt.call(this, ['x_Entidad']); " . @$nutricion_usuario->Tipo_Entidad->EditAttrs["onchange"]; ?>
<select data-field="x_Tipo_Entidad" id="x_Tipo_Entidad" name="x_Tipo_Entidad"<?php echo $nutricion_usuario->Tipo_Entidad->EditAttributes() ?>>
<?php
if (is_array($nutricion_usuario->Tipo_Entidad->EditValue)) {
	$arwrk = $nutricion_usuario->Tipo_Entidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_usuario->Tipo_Entidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</span>
</script>
<?php echo $nutricion_usuario->Tipo_Entidad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Entidad->Visible) { // Entidad ?>
	<tr id="r_Entidad">
		<td><span id="elh_nutricion_usuario_Entidad"><script id="tpc_nutricion_usuario_Entidad" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Entidad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Entidad->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Entidad" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Entidad" class="control-group">
<select data-field="x_Entidad" id="x_Entidad" name="x_Entidad"<?php echo $nutricion_usuario->Entidad->EditAttributes() ?>>
<?php
if (is_array($nutricion_usuario->Entidad->EditValue)) {
	$arwrk = $nutricion_usuario->Entidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_usuario->Entidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
<?php if ($arwrk[$rowcntwrk][2] <> "") { ?>
<?php echo ew_ValueSeparator(1,$nutricion_usuario->Entidad) ?><?php echo $arwrk[$rowcntwrk][2] ?>
<?php } ?>
</option>
<?php
	}
}
?>
</select>
</span>
</script>
<script type="text/html" class="nutricion_usuarioedit_js">
fnutricion_usuarioedit.Lists["x_Entidad"].Options = <?php echo (is_array($nutricion_usuario->Entidad->EditValue)) ? ew_ArrayToJson($nutricion_usuario->Entidad->EditValue, 1) : "[]" ?>;
</script>
<?php echo $nutricion_usuario->Entidad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Ingreso->Visible) { // Ingreso ?>
	<tr id="r_Ingreso">
		<td><span id="elh_nutricion_usuario_Ingreso"><script id="tpc_nutricion_usuario_Ingreso" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Ingreso->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Ingreso->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Ingreso" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Ingreso" class="control-group">
<input type="text" data-field="x_Ingreso" name="x_Ingreso" id="x_Ingreso" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($nutricion_usuario->Ingreso->PlaceHolder) ?>" value="<?php echo $nutricion_usuario->Ingreso->EditValue ?>"<?php echo $nutricion_usuario->Ingreso->EditAttributes() ?>>
</span>
</script>
<?php echo $nutricion_usuario->Ingreso->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Clave->Visible) { // Clave ?>
	<tr id="r_Clave">
		<td><span id="elh_nutricion_usuario_Clave"><script id="tpc_nutricion_usuario_Clave" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Clave->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Clave->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Clave" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Clave" class="control-group">
<input type="text" data-field="x_Clave" name="x_Clave" id="x_Clave" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($nutricion_usuario->Clave->PlaceHolder) ?>" value="<?php echo $nutricion_usuario->Clave->EditValue ?>"<?php echo $nutricion_usuario->Clave->EditAttributes() ?>>
</span>
</script>
<?php echo $nutricion_usuario->Clave->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Nivel->Visible) { // Nivel ?>
	<tr id="r_Nivel">
		<td><span id="elh_nutricion_usuario_Nivel"><script id="tpc_nutricion_usuario_Nivel" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Nivel->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Nivel->CellAttributes() ?>>
<?php if (!$Security->IsAdmin() && $Security->IsLoggedIn()) { // Non system admin ?>
<script id="tpx_nutricion_usuario_Nivel" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Nivel" class="control-group">
<?php echo $nutricion_usuario->Nivel->EditValue ?>
</span>
</script>
<?php } else { ?>
<script id="tpx_nutricion_usuario_Nivel" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Nivel" class="control-group">
<select data-field="x_Nivel" id="x_Nivel" name="x_Nivel"<?php echo $nutricion_usuario->Nivel->EditAttributes() ?>>
<?php
if (is_array($nutricion_usuario->Nivel->EditValue)) {
	$arwrk = $nutricion_usuario->Nivel->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_usuario->Nivel->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</span>
</script>
<?php } ?>
<script type="text/html" class="nutricion_usuarioedit_js">
fnutricion_usuarioedit.Lists["x_Nivel"].Options = <?php echo (is_array($nutricion_usuario->Nivel->EditValue)) ? ew_ArrayToJson($nutricion_usuario->Nivel->EditValue, 1) : "[]" ?>;
</script>
<?php echo $nutricion_usuario->Nivel->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Activo->Visible) { // Activo ?>
	<tr id="r_Activo">
		<td><span id="elh_nutricion_usuario_Activo"><script id="tpc_nutricion_usuario_Activo" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Activo->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_usuario->Activo->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Activo" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Activo" class="control-group">
<div id="tp_x_Activo" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_Activo" id="x_Activo" value="{value}"<?php echo $nutricion_usuario->Activo->EditAttributes() ?>></div>
<div id="dsl_x_Activo" data-repeatcolumn="5" class="ewItemList">
<?php
$arwrk = $nutricion_usuario->Activo->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_usuario->Activo->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label class="radio"><input type="radio" data-field="x_Activo" name="x_Activo" id="x_Activo_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $nutricion_usuario->Activo->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
</span>
</script>
<?php echo $nutricion_usuario->Activo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Reporta_a->Visible) { // Reporta_a ?>
	<tr id="r_Reporta_a">
		<td><span id="elh_nutricion_usuario_Reporta_a"><script id="tpc_nutricion_usuario_Reporta_a" class="nutricion_usuarioedit" type="text/html"><span><?php echo $nutricion_usuario->Reporta_a->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Reporta_a->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Reporta_a" class="nutricion_usuarioedit" type="text/html">
<span id="el_nutricion_usuario_Reporta_a" class="control-group">
<input type="text" data-field="x_Reporta_a" name="x_Reporta_a" id="x_Reporta_a" size="30" placeholder="<?php echo ew_HtmlEncode($nutricion_usuario->Reporta_a->PlaceHolder) ?>" value="<?php echo $nutricion_usuario->Reporta_a->EditValue ?>"<?php echo $nutricion_usuario->Reporta_a->EditAttributes() ?>>
</span>
</script>
<?php echo $nutricion_usuario->Reporta_a->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("EditBtn") ?></button>
</form>
<script type="text/javascript">
ew_ApplyTemplate("tpd_nutricion_usuarioedit", "tpm_nutricion_usuarioedit");
jQuery("script.nutricion_usuarioedit_js").each(function(){ew_AddScript(this.text);});
</script>
<script type="text/javascript">
fnutricion_usuarioedit.Init();
</script>
<?php
$nutricion_usuario_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$nutricion_usuario_edit->Page_Terminate();
?>
