<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$nutricion_usuario_view = NULL; // Initialize page object first

class cnutricion_usuario_view extends cnutricion_usuario {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{5B1FB6D8-0E93-4F60-869F-153E389D6FED}";

	// Table name
	var $TableName = 'nutricion_usuario';

	// Page object name
	var $PageObjName = 'nutricion_usuario_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS["nutricion_usuario"]) || get_class($GLOBALS["nutricion_usuario"]) == "cnutricion_usuario") {
			$GLOBALS["nutricion_usuario"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["nutricion_usuario"];
		}
		$KeyUrl = "";
		if (@$_GET["Id_Usuario"] <> "") {
			$this->RecKey["Id_Usuario"] = $_GET["Id_Usuario"];
			$KeyUrl .= "&amp;Id_Usuario=" . urlencode($this->RecKey["Id_Usuario"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'nutricion_usuario', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("nutricion_usuariolist.php");
		}

		// Get export parameters
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		if (@$_GET["Id_Usuario"] <> "") {
			if ($gsExportFile <> "") $gsExportFile .= "_";
			$gsExportFile .= ew_StripSlashes($_GET["Id_Usuario"]);
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Setup export options
		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Update url if printer friendly for Pdf
		if ($this->PrinterFriendlyForPdf)
			$this->ExportOptions->Items["pdf"]->Body = str_replace($this->ExportPdfUrl, $this->ExportPrintUrl . "&pdf=1", $this->ExportOptions->Items["pdf"]->Body);
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();
		if ($this->Export == "print" && @$_GET["pdf"] == "1") { // Printer friendly version and with pdf=1 in URL parameters
			$pdf = new cExportPdf($GLOBALS["Table"]);
			$pdf->Text = ob_get_contents(); // Set the content as the HTML of current page (printer friendly version)
			ob_end_clean();
			$pdf->Export();
		}

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["Id_Usuario"] <> "") {
				$this->Id_Usuario->setQueryStringValue($_GET["Id_Usuario"]);
				$this->RecKey["Id_Usuario"] = $this->Id_Usuario->QueryStringValue;
			} else {
				$sReturnUrl = "nutricion_usuariolist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					if (!$this->LoadRow()) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "nutricion_usuariolist.php"; // No matching record, return to list
					}
			}

			// Export data only
			if (in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "nutricion_usuariolist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Edit
		$item = &$option->Add("edit");
		$item->Body = "<a class=\"ewAction ewEdit\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->CanEdit());

		// Delete
		$item = &$option->Add("delete");
		$item->Body = "<a onclick=\"return ew_Confirm(ewLanguage.Phrase('DeleteConfirmMsg'));\" class=\"ewAction ewDelete\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id_Usuario->setDbValue($rs->fields('Id_Usuario'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Cedula_Identificacion->setDbValue($rs->fields('Cedula_Identificacion'));
		$this->Correo->setDbValue($rs->fields('Correo'));
		$this->Tipo_Entidad->setDbValue($rs->fields('Tipo_Entidad'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->Ingreso->setDbValue($rs->fields('Ingreso'));
		$this->Clave->setDbValue($rs->fields('Clave'));
		$this->Nivel->setDbValue($rs->fields('Nivel'));
		$this->Activo->setDbValue($rs->fields('Activo'));
		$this->Reporta_a->setDbValue($rs->fields('Reporta_a'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id_Usuario->DbValue = $row['Id_Usuario'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Cedula_Identificacion->DbValue = $row['Cedula_Identificacion'];
		$this->Correo->DbValue = $row['Correo'];
		$this->Tipo_Entidad->DbValue = $row['Tipo_Entidad'];
		$this->Entidad->DbValue = $row['Entidad'];
		$this->Ingreso->DbValue = $row['Ingreso'];
		$this->Clave->DbValue = $row['Clave'];
		$this->Nivel->DbValue = $row['Nivel'];
		$this->Activo->DbValue = $row['Activo'];
		$this->Reporta_a->DbValue = $row['Reporta_a'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Id_Usuario
		// Nombres
		// Apellidos
		// Cedula_Identificacion
		// Correo
		// Tipo_Entidad
		// Entidad
		// Ingreso
		// Clave
		// Nivel
		// Activo
		// Reporta_a

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// Id_Usuario
			$this->Id_Usuario->ViewValue = $this->Id_Usuario->CurrentValue;
			$this->Id_Usuario->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
			$this->Nombres->ViewCustomAttributes = "";

			// Apellidos
			$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
			$this->Apellidos->ViewCustomAttributes = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->ViewValue = $this->Cedula_Identificacion->CurrentValue;
			$this->Cedula_Identificacion->ViewCustomAttributes = "";

			// Correo
			$this->Correo->ViewValue = $this->Correo->CurrentValue;
			$this->Correo->ViewCustomAttributes = "";

			// Tipo_Entidad
			if (strval($this->Tipo_Entidad->CurrentValue) <> "") {
				switch ($this->Tipo_Entidad->CurrentValue) {
					case $this->Tipo_Entidad->FldTagValue(1):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(1) <> "" ? $this->Tipo_Entidad->FldTagCaption(1) : $this->Tipo_Entidad->CurrentValue;
						break;
					case $this->Tipo_Entidad->FldTagValue(2):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(2) <> "" ? $this->Tipo_Entidad->FldTagCaption(2) : $this->Tipo_Entidad->CurrentValue;
						break;
					default:
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->CurrentValue;
				}
			} else {
				$this->Tipo_Entidad->ViewValue = NULL;
			}
			$this->Tipo_Entidad->ViewCustomAttributes = "";

			// Entidad
			if (strval($this->Entidad->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, `Codigo` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			$lookuptblfilter = "`Activa`=1";
			if (strval($lookuptblfilter) <> "") {
				ew_AddFilter($sWhereWrk, $lookuptblfilter);
			}
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Entidad->ViewValue = $rswrk->fields('DispFld');
					$this->Entidad->ViewValue .= ew_ValueSeparator(1,$this->Entidad) . $rswrk->fields('Disp2Fld');
					$rswrk->Close();
				} else {
					$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
				}
			} else {
				$this->Entidad->ViewValue = NULL;
			}
			$this->Entidad->ViewCustomAttributes = "";

			// Ingreso
			$this->Ingreso->ViewValue = $this->Ingreso->CurrentValue;
			$this->Ingreso->ViewCustomAttributes = "";

			// Clave
			$this->Clave->ViewValue = $this->Clave->CurrentValue;
			$this->Clave->ViewCustomAttributes = "";

			// Nivel
			if ($Security->CanAdmin()) { // System admin
			if (strval($this->Nivel->CurrentValue) <> "") {
				$sFilterWrk = "`nivelusuario`" . ew_SearchString("=", $this->Nivel->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `nivelusuario`, `nombrenivel` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_niveles`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Nivel, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Nivel->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Nivel->ViewValue = $this->Nivel->CurrentValue;
				}
			} else {
				$this->Nivel->ViewValue = NULL;
			}
			} else {
				$this->Nivel->ViewValue = "********";
			}
			$this->Nivel->ViewCustomAttributes = "";

			// Activo
			if (strval($this->Activo->CurrentValue) <> "") {
				switch ($this->Activo->CurrentValue) {
					case $this->Activo->FldTagValue(1):
						$this->Activo->ViewValue = $this->Activo->FldTagCaption(1) <> "" ? $this->Activo->FldTagCaption(1) : $this->Activo->CurrentValue;
						break;
					case $this->Activo->FldTagValue(2):
						$this->Activo->ViewValue = $this->Activo->FldTagCaption(2) <> "" ? $this->Activo->FldTagCaption(2) : $this->Activo->CurrentValue;
						break;
					default:
						$this->Activo->ViewValue = $this->Activo->CurrentValue;
				}
			} else {
				$this->Activo->ViewValue = NULL;
			}
			$this->Activo->ViewCustomAttributes = "";

			// Reporta_a
			$this->Reporta_a->ViewValue = $this->Reporta_a->CurrentValue;
			$this->Reporta_a->ViewCustomAttributes = "";

			// Id_Usuario
			$this->Id_Usuario->LinkCustomAttributes = "";
			$this->Id_Usuario->HrefValue = "";
			$this->Id_Usuario->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->LinkCustomAttributes = "";
			$this->Cedula_Identificacion->HrefValue = "";
			$this->Cedula_Identificacion->TooltipValue = "";

			// Correo
			$this->Correo->LinkCustomAttributes = "";
			$this->Correo->HrefValue = "";
			$this->Correo->TooltipValue = "";

			// Tipo_Entidad
			$this->Tipo_Entidad->LinkCustomAttributes = "";
			$this->Tipo_Entidad->HrefValue = "";
			$this->Tipo_Entidad->TooltipValue = "";

			// Entidad
			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";
			$this->Entidad->TooltipValue = "";

			// Ingreso
			$this->Ingreso->LinkCustomAttributes = "";
			$this->Ingreso->HrefValue = "";
			$this->Ingreso->TooltipValue = "";

			// Clave
			$this->Clave->LinkCustomAttributes = "";
			$this->Clave->HrefValue = "";
			$this->Clave->TooltipValue = "";

			// Nivel
			$this->Nivel->LinkCustomAttributes = "";
			$this->Nivel->HrefValue = "";
			$this->Nivel->TooltipValue = "";

			// Activo
			$this->Activo->LinkCustomAttributes = "";
			$this->Activo->HrefValue = "";
			$this->Activo->TooltipValue = "";

			// Reporta_a
			$this->Reporta_a->LinkCustomAttributes = "";
			$this->Reporta_a->HrefValue = "";
			$this->Reporta_a->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$item->Body = "<a id=\"emf_nutricion_usuario\" href=\"javascript:void(0);\" class=\"ewExportLink ewEmail\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_nutricion_usuario',hdr:ewLanguage.Phrase('ExportToEmail'),f:document.fnutricion_usuarioview,key:" . ew_ArrayToJsonAttr($this->RecKey) . ",sel:false});\">" . $Language->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = FALSE;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if ($rs = $this->LoadRecordset())
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;
		$this->SetUpStartRec(); // Set up start record position

		// Set the last record to display
		if ($this->DisplayRecs <= 0) {
			$this->StopRec = $this->TotalRecs;
		} else {
			$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
		}
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$ExportDoc = ew_ExportDocument($this, "v");
		$ParentTable = "";
		if ($bSelectLimit) {
			$StartRec = 1;
			$StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {
			$StartRec = $this->StartRec;
			$StopRec = $this->StopRec;
		}
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$ExportDoc->Text .= $sHeader;
		$this->ExportDocument($ExportDoc, $rs, $StartRec, $StopRec, "view");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$ExportDoc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Export header and footer
		$ExportDoc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED)
			echo ew_DebugMsg();

		// Output data
		$ExportDoc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$Breadcrumb->Add("list", $this->TableVar, "nutricion_usuariolist.php", $this->TableVar, TRUE);
		$PageId = "view";
		$Breadcrumb->Add("view", $PageId, ew_CurrentUrl());
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($nutricion_usuario_view)) $nutricion_usuario_view = new cnutricion_usuario_view();

// Page init
$nutricion_usuario_view->Page_Init();

// Page main
$nutricion_usuario_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$nutricion_usuario_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($nutricion_usuario->Export == "") { ?>
<script type="text/javascript">

// Page object
var nutricion_usuario_view = new ew_Page("nutricion_usuario_view");
nutricion_usuario_view.PageID = "view"; // Page ID
var EW_PAGE_ID = nutricion_usuario_view.PageID; // For backward compatibility

// Form object
var fnutricion_usuarioview = new ew_Form("fnutricion_usuarioview");

// Form_CustomValidate event
fnutricion_usuarioview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnutricion_usuarioview.ValidateRequired = true;
<?php } else { ?>
fnutricion_usuarioview.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnutricion_usuarioview.Lists["x_Entidad"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Entidad","x_Codigo","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_usuarioview.Lists["x_Nivel"] = {"LinkField":"x_nivelusuario","Ajax":null,"AutoFill":false,"DisplayFields":["x_nombrenivel","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($nutricion_usuario->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($nutricion_usuario->Export == "") { ?>
<div class="ewViewExportOptions">
<?php $nutricion_usuario_view->ExportOptions->Render("body") ?>
<?php if (!$nutricion_usuario_view->ExportOptions->UseDropDownButton) { ?>
</div>
<div class="ewViewOtherOptions">
<?php } ?>
<?php
	foreach ($nutricion_usuario_view->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<?php } ?>
<?php $nutricion_usuario_view->ShowPageHeader(); ?>
<?php
$nutricion_usuario_view->ShowMessage();
?>
<form name="fnutricion_usuarioview" id="fnutricion_usuarioview" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="nutricion_usuario">
<div id="tpd_nutricion_usuarioview"></div>
<script id="tpm_nutricion_usuarioview" type="text/html">
<span id="ct_nutricion_usuario_view"><table class="table table-bordered table-striped">
<tbody>
<tr>
<td><?php echo $nutricion_usuario->Nombres->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Nombres"/}}</td>
<td> <?php echo $nutricion_usuario->Apellidos->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Apellidos"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Cedula_Identificacion->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Cedula_Identificacion"/}}</td>
<td> <?php echo $nutricion_usuario->Correo->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Correo"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Tipo_Entidad->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Tipo_Entidad"/}}</td>
<td> <?php echo $nutricion_usuario->Entidad->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Entidad"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Ingreso->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Ingreso"/}}</td>
<td> <?php echo $nutricion_usuario->Clave->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Clave"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_usuario->Nivel->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Nivel"/}}</td>
<td> <?php echo $nutricion_usuario->Activo->FldCaption() ?></td>
<td> {{include tmpl="#tpx_nutricion_usuario_Activo"/}}</td>
</tr>
</tbody>
</table>
</span>
</script>
<table class="ewGrid" style="display: none"><tr><td>
<table id="tbl_nutricion_usuarioview" class="table table-bordered table-striped">
<?php if ($nutricion_usuario->Id_Usuario->Visible) { // Id_Usuario ?>
	<tr id="r_Id_Usuario">
		<td><span id="elh_nutricion_usuario_Id_Usuario"><script id="tpc_nutricion_usuario_Id_Usuario" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Id_Usuario->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Id_Usuario->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Id_Usuario" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Id_Usuario" class="control-group">
<span<?php echo $nutricion_usuario->Id_Usuario->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Id_Usuario->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Nombres->Visible) { // Nombres ?>
	<tr id="r_Nombres">
		<td><span id="elh_nutricion_usuario_Nombres"><script id="tpc_nutricion_usuario_Nombres" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Nombres->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Nombres->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Nombres" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Nombres" class="control-group">
<span<?php echo $nutricion_usuario->Nombres->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Nombres->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Apellidos->Visible) { // Apellidos ?>
	<tr id="r_Apellidos">
		<td><span id="elh_nutricion_usuario_Apellidos"><script id="tpc_nutricion_usuario_Apellidos" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Apellidos->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Apellidos->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Apellidos" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Apellidos" class="control-group">
<span<?php echo $nutricion_usuario->Apellidos->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Apellidos->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Cedula_Identificacion->Visible) { // Cedula_Identificacion ?>
	<tr id="r_Cedula_Identificacion">
		<td><span id="elh_nutricion_usuario_Cedula_Identificacion"><script id="tpc_nutricion_usuario_Cedula_Identificacion" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Cedula_Identificacion->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Cedula_Identificacion->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Cedula_Identificacion" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Cedula_Identificacion" class="control-group">
<span<?php echo $nutricion_usuario->Cedula_Identificacion->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Cedula_Identificacion->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Correo->Visible) { // Correo ?>
	<tr id="r_Correo">
		<td><span id="elh_nutricion_usuario_Correo"><script id="tpc_nutricion_usuario_Correo" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Correo->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Correo->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Correo" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Correo" class="control-group">
<span<?php echo $nutricion_usuario->Correo->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Correo->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Tipo_Entidad->Visible) { // Tipo_Entidad ?>
	<tr id="r_Tipo_Entidad">
		<td><span id="elh_nutricion_usuario_Tipo_Entidad"><script id="tpc_nutricion_usuario_Tipo_Entidad" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Tipo_Entidad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Tipo_Entidad->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Tipo_Entidad" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Tipo_Entidad" class="control-group">
<span<?php echo $nutricion_usuario->Tipo_Entidad->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Tipo_Entidad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Entidad->Visible) { // Entidad ?>
	<tr id="r_Entidad">
		<td><span id="elh_nutricion_usuario_Entidad"><script id="tpc_nutricion_usuario_Entidad" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Entidad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Entidad->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Entidad" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Entidad" class="control-group">
<span<?php echo $nutricion_usuario->Entidad->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Entidad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Ingreso->Visible) { // Ingreso ?>
	<tr id="r_Ingreso">
		<td><span id="elh_nutricion_usuario_Ingreso"><script id="tpc_nutricion_usuario_Ingreso" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Ingreso->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Ingreso->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Ingreso" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Ingreso" class="control-group">
<span<?php echo $nutricion_usuario->Ingreso->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Ingreso->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Clave->Visible) { // Clave ?>
	<tr id="r_Clave">
		<td><span id="elh_nutricion_usuario_Clave"><script id="tpc_nutricion_usuario_Clave" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Clave->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Clave->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Clave" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Clave" class="control-group">
<span<?php echo $nutricion_usuario->Clave->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Clave->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Nivel->Visible) { // Nivel ?>
	<tr id="r_Nivel">
		<td><span id="elh_nutricion_usuario_Nivel"><script id="tpc_nutricion_usuario_Nivel" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Nivel->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Nivel->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Nivel" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Nivel" class="control-group">
<span<?php echo $nutricion_usuario->Nivel->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Nivel->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Activo->Visible) { // Activo ?>
	<tr id="r_Activo">
		<td><span id="elh_nutricion_usuario_Activo"><script id="tpc_nutricion_usuario_Activo" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Activo->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Activo->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Activo" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Activo" class="control-group">
<span<?php echo $nutricion_usuario->Activo->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Activo->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_usuario->Reporta_a->Visible) { // Reporta_a ?>
	<tr id="r_Reporta_a">
		<td><span id="elh_nutricion_usuario_Reporta_a"><script id="tpc_nutricion_usuario_Reporta_a" class="nutricion_usuarioview" type="text/html"><span><?php echo $nutricion_usuario->Reporta_a->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_usuario->Reporta_a->CellAttributes() ?>>
<script id="tpx_nutricion_usuario_Reporta_a" class="nutricion_usuarioview" type="text/html">
<span id="el_nutricion_usuario_Reporta_a" class="control-group">
<span<?php echo $nutricion_usuario->Reporta_a->ViewAttributes() ?>>
<?php echo $nutricion_usuario->Reporta_a->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
</form>
<script type="text/javascript">
ew_ApplyTemplate("tpd_nutricion_usuarioview", "tpm_nutricion_usuarioview");
jQuery("script.nutricion_usuarioview_js").each(function(){ew_AddScript(this.text);});
</script>
<script type="text/javascript">
fnutricion_usuarioview.Init();
</script>
<?php
$nutricion_usuario_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($nutricion_usuario->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$nutricion_usuario_view->Page_Terminate();
?>
