<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "nutricion_valoracioninfo.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$nutricion_valoracion_view = NULL; // Initialize page object first

class cnutricion_valoracion_view extends cnutricion_valoracion {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{5B1FB6D8-0E93-4F60-869F-153E389D6FED}";

	// Table name
	var $TableName = 'nutricion_valoracion';

	// Page object name
	var $PageObjName = 'nutricion_valoracion_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (nutricion_valoracion)
		if (!isset($GLOBALS["nutricion_valoracion"]) || get_class($GLOBALS["nutricion_valoracion"]) == "cnutricion_valoracion") {
			$GLOBALS["nutricion_valoracion"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["nutricion_valoracion"];
		}
		$KeyUrl = "";
		if (@$_GET["Consecutivo"] <> "") {
			$this->RecKey["Consecutivo"] = $_GET["Consecutivo"];
			$KeyUrl .= "&amp;Consecutivo=" . urlencode($this->RecKey["Consecutivo"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS['nutricion_usuario'])) $GLOBALS['nutricion_usuario'] = new cnutricion_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'nutricion_valoracion', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("nutricion_valoracionlist.php");
		}

		// Get export parameters
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		if (@$_GET["Consecutivo"] <> "") {
			if ($gsExportFile <> "") $gsExportFile .= "_";
			$gsExportFile .= ew_StripSlashes($_GET["Consecutivo"]);
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Setup export options
		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Update url if printer friendly for Pdf
		if ($this->PrinterFriendlyForPdf)
			$this->ExportOptions->Items["pdf"]->Body = str_replace($this->ExportPdfUrl, $this->ExportPrintUrl . "&pdf=1", $this->ExportOptions->Items["pdf"]->Body);
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();
		if ($this->Export == "print" && @$_GET["pdf"] == "1") { // Printer friendly version and with pdf=1 in URL parameters
			$pdf = new cExportPdf($GLOBALS["Table"]);
			$pdf->Text = ob_get_contents(); // Set the content as the HTML of current page (printer friendly version)
			ob_end_clean();
			$pdf->Export();
		}

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["Consecutivo"] <> "") {
				$this->Consecutivo->setQueryStringValue($_GET["Consecutivo"]);
				$this->RecKey["Consecutivo"] = $this->Consecutivo->QueryStringValue;
			} else {
				$sReturnUrl = "nutricion_valoracionlist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					if (!$this->LoadRow()) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "nutricion_valoracionlist.php"; // No matching record, return to list
					}
			}

			// Export data only
			if (in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "nutricion_valoracionlist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Edit
		$item = &$option->Add("edit");
		$item->Body = "<a class=\"ewAction ewEdit\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->CanEdit());

		// Delete
		$item = &$option->Add("delete");
		$item->Body = "<a onclick=\"return ew_Confirm(ewLanguage.Phrase('DeleteConfirmMsg'));\" class=\"ewAction ewDelete\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Entidad_Valora->setDbValue($rs->fields('Entidad_Valora'));
		$this->Tipo_Entidad->setDbValue($rs->fields('Tipo_Entidad'));
		$this->Tipo_Documento->setDbValue($rs->fields('Tipo_Documento'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Fecha_valoracion->setDbValue($rs->fields('Fecha_valoracion'));
		$this->Edad_Anos->setDbValue($rs->fields('Edad_Anos'));
		$this->Edad_Meses->setDbValue($rs->fields('Edad_Meses'));
		$this->Peso->setDbValue($rs->fields('Peso'));
		$this->Talla->setDbValue($rs->fields('Talla'));
		$this->Perimetro_Cefalico->setDbValue($rs->fields('Perimetro_Cefalico'));
		$this->Perimetro_Abdominal->setDbValue($rs->fields('Perimetro_Abdominal'));
		$this->IMC->setDbValue($rs->fields('IMC'));
		$this->DS_TallaEdad->setDbValue($rs->fields('DS_TallaEdad'));
		$this->DS_PesoTalla->setDbValue($rs->fields('DS_PesoTalla'));
		$this->DS_PesoEdad->setDbValue($rs->fields('DS_PesoEdad'));
		$this->DS_IMCEdad->setDbValue($rs->fields('DS_IMCEdad'));
		$this->DS_PCEdad->setDbValue($rs->fields('DS_PCEdad'));
		$this->Clasificacion_Talla_Edad->setDbValue($rs->fields('Clasificacion_Talla_Edad'));
		$this->Clasificacion_Peso_Talla->setDbValue($rs->fields('Clasificacion_Peso_Talla'));
		$this->Clasificacion_Peso_Edad->setDbValue($rs->fields('Clasificacion_Peso_Edad'));
		$this->Clasificacion_IMC_Edad->setDbValue($rs->fields('Clasificacion_IMC_Edad'));
		$this->Clasificacion_P_Cefalico->setDbValue($rs->fields('Clasificacion_P_Cefalico'));
		$this->Superficie_Corporal->setDbValue($rs->fields('Superficie_Corporal'));
		$this->Zona->setDbValue($rs->fields('Zona'));
		$this->Barrio_Vereda->setDbValue($rs->fields('Barrio_Vereda'));
		$this->Comuna_Zona->setDbValue($rs->fields('Comuna_Zona'));
		$this->Grupo_Etnico->setDbValue($rs->fields('Grupo_Etnico'));
		$this->Tipo_Regimen->setDbValue($rs->fields('Tipo_Regimen'));
		$this->EPS->setDbValue($rs->fields('EPS'));
		$this->Condicion_Discapacidad->setDbValue($rs->fields('Condicion_Discapacidad'));
		$this->Condicion_Desplazamiento->setDbValue($rs->fields('Condicion_Desplazamiento'));
		$this->Entidad_Educativa->setDbValue($rs->fields('Entidad_Educativa'));
		$this->Escolaridad->setDbValue($rs->fields('Escolaridad'));
		$this->Clasificado->setDbValue($rs->fields('Clasificado'));
		$this->Usuario->setDbValue($rs->fields('Usuario'));
		$this->Fecha_edicion->setDbValue($rs->fields('Fecha_edicion'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Consecutivo->DbValue = $row['Consecutivo'];
		$this->Entidad_Valora->DbValue = $row['Entidad_Valora'];
		$this->Tipo_Entidad->DbValue = $row['Tipo_Entidad'];
		$this->Tipo_Documento->DbValue = $row['Tipo_Documento'];
		$this->Documento->DbValue = $row['Documento'];
		$this->Fecha_Nacimiento->DbValue = $row['Fecha_Nacimiento'];
		$this->Genero->DbValue = $row['Genero'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Fecha_valoracion->DbValue = $row['Fecha_valoracion'];
		$this->Edad_Anos->DbValue = $row['Edad_Anos'];
		$this->Edad_Meses->DbValue = $row['Edad_Meses'];
		$this->Peso->DbValue = $row['Peso'];
		$this->Talla->DbValue = $row['Talla'];
		$this->Perimetro_Cefalico->DbValue = $row['Perimetro_Cefalico'];
		$this->Perimetro_Abdominal->DbValue = $row['Perimetro_Abdominal'];
		$this->IMC->DbValue = $row['IMC'];
		$this->DS_TallaEdad->DbValue = $row['DS_TallaEdad'];
		$this->DS_PesoTalla->DbValue = $row['DS_PesoTalla'];
		$this->DS_PesoEdad->DbValue = $row['DS_PesoEdad'];
		$this->DS_IMCEdad->DbValue = $row['DS_IMCEdad'];
		$this->DS_PCEdad->DbValue = $row['DS_PCEdad'];
		$this->Clasificacion_Talla_Edad->DbValue = $row['Clasificacion_Talla_Edad'];
		$this->Clasificacion_Peso_Talla->DbValue = $row['Clasificacion_Peso_Talla'];
		$this->Clasificacion_Peso_Edad->DbValue = $row['Clasificacion_Peso_Edad'];
		$this->Clasificacion_IMC_Edad->DbValue = $row['Clasificacion_IMC_Edad'];
		$this->Clasificacion_P_Cefalico->DbValue = $row['Clasificacion_P_Cefalico'];
		$this->Superficie_Corporal->DbValue = $row['Superficie_Corporal'];
		$this->Zona->DbValue = $row['Zona'];
		$this->Barrio_Vereda->DbValue = $row['Barrio_Vereda'];
		$this->Comuna_Zona->DbValue = $row['Comuna_Zona'];
		$this->Grupo_Etnico->DbValue = $row['Grupo_Etnico'];
		$this->Tipo_Regimen->DbValue = $row['Tipo_Regimen'];
		$this->EPS->DbValue = $row['EPS'];
		$this->Condicion_Discapacidad->DbValue = $row['Condicion_Discapacidad'];
		$this->Condicion_Desplazamiento->DbValue = $row['Condicion_Desplazamiento'];
		$this->Entidad_Educativa->DbValue = $row['Entidad_Educativa'];
		$this->Escolaridad->DbValue = $row['Escolaridad'];
		$this->Clasificado->DbValue = $row['Clasificado'];
		$this->Usuario->DbValue = $row['Usuario'];
		$this->Fecha_edicion->DbValue = $row['Fecha_edicion'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Convert decimal values if posted back
		if ($this->Peso->FormValue == $this->Peso->CurrentValue && is_numeric(ew_StrToFloat($this->Peso->CurrentValue)))
			$this->Peso->CurrentValue = ew_StrToFloat($this->Peso->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Talla->FormValue == $this->Talla->CurrentValue && is_numeric(ew_StrToFloat($this->Talla->CurrentValue)))
			$this->Talla->CurrentValue = ew_StrToFloat($this->Talla->CurrentValue);

		// Convert decimal values if posted back
		if ($this->IMC->FormValue == $this->IMC->CurrentValue && is_numeric(ew_StrToFloat($this->IMC->CurrentValue)))
			$this->IMC->CurrentValue = ew_StrToFloat($this->IMC->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_TallaEdad->FormValue == $this->DS_TallaEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_TallaEdad->CurrentValue)))
			$this->DS_TallaEdad->CurrentValue = ew_StrToFloat($this->DS_TallaEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_PesoTalla->FormValue == $this->DS_PesoTalla->CurrentValue && is_numeric(ew_StrToFloat($this->DS_PesoTalla->CurrentValue)))
			$this->DS_PesoTalla->CurrentValue = ew_StrToFloat($this->DS_PesoTalla->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_PesoEdad->FormValue == $this->DS_PesoEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_PesoEdad->CurrentValue)))
			$this->DS_PesoEdad->CurrentValue = ew_StrToFloat($this->DS_PesoEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_IMCEdad->FormValue == $this->DS_IMCEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_IMCEdad->CurrentValue)))
			$this->DS_IMCEdad->CurrentValue = ew_StrToFloat($this->DS_IMCEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_PCEdad->FormValue == $this->DS_PCEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_PCEdad->CurrentValue)))
			$this->DS_PCEdad->CurrentValue = ew_StrToFloat($this->DS_PCEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Superficie_Corporal->FormValue == $this->Superficie_Corporal->CurrentValue && is_numeric(ew_StrToFloat($this->Superficie_Corporal->CurrentValue)))
			$this->Superficie_Corporal->CurrentValue = ew_StrToFloat($this->Superficie_Corporal->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Consecutivo
		// Entidad_Valora
		// Tipo_Entidad
		// Tipo_Documento
		// Documento
		// Fecha_Nacimiento
		// Genero
		// Nombres
		// Apellidos
		// Fecha_valoracion
		// Edad_Anos
		// Edad_Meses
		// Peso
		// Talla
		// Perimetro_Cefalico
		// Perimetro_Abdominal
		// IMC
		// DS_TallaEdad
		// DS_PesoTalla
		// DS_PesoEdad
		// DS_IMCEdad
		// DS_PCEdad
		// Clasificacion_Talla_Edad
		// Clasificacion_Peso_Talla
		// Clasificacion_Peso_Edad
		// Clasificacion_IMC_Edad
		// Clasificacion_P_Cefalico
		// Superficie_Corporal
		// Zona
		// Barrio_Vereda
		// Comuna_Zona
		// Grupo_Etnico
		// Tipo_Regimen
		// EPS
		// Condicion_Discapacidad
		// Condicion_Desplazamiento
		// Entidad_Educativa
		// Escolaridad
		// Clasificado
		// Usuario
		// Fecha_edicion

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// Consecutivo
			$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
			$this->Consecutivo->ViewCustomAttributes = "";

			// Entidad_Valora
			if (strval($this->Entidad_Valora->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Entidad_Valora->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			$lookuptblfilter = "`Activa`=1";
			if (strval($lookuptblfilter) <> "") {
				ew_AddFilter($sWhereWrk, $lookuptblfilter);
			}
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad_Valora, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Entidad`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Entidad_Valora->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Entidad_Valora->ViewValue = $this->Entidad_Valora->CurrentValue;
				}
			} else {
				$this->Entidad_Valora->ViewValue = NULL;
			}
			$this->Entidad_Valora->ViewCustomAttributes = "";

			// Tipo_Entidad
			if (strval($this->Tipo_Entidad->CurrentValue) <> "") {
				switch ($this->Tipo_Entidad->CurrentValue) {
					case $this->Tipo_Entidad->FldTagValue(1):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(1) <> "" ? $this->Tipo_Entidad->FldTagCaption(1) : $this->Tipo_Entidad->CurrentValue;
						break;
					case $this->Tipo_Entidad->FldTagValue(2):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(2) <> "" ? $this->Tipo_Entidad->FldTagCaption(2) : $this->Tipo_Entidad->CurrentValue;
						break;
					default:
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->CurrentValue;
				}
			} else {
				$this->Tipo_Entidad->ViewValue = NULL;
			}
			$this->Tipo_Entidad->ViewCustomAttributes = "";

			// Tipo_Documento
			if (strval($this->Tipo_Documento->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Tipo_Documento->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Tipo_Documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Tipo_Documento, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Tipo_Documento`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Tipo_Documento->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Tipo_Documento->ViewValue = $this->Tipo_Documento->CurrentValue;
				}
			} else {
				$this->Tipo_Documento->ViewValue = NULL;
			}
			$this->Tipo_Documento->ViewCustomAttributes = "";

			// Documento
			$this->Documento->ViewValue = $this->Documento->CurrentValue;
			$this->Documento->ViewCustomAttributes = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
			$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 7);
			$this->Fecha_Nacimiento->ViewCustomAttributes = "";

			// Genero
			if (strval($this->Genero->CurrentValue) <> "") {
				$sFilterWrk = "`#`" . ew_SearchString("=", $this->Genero->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `#`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_genero`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Genero, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Genero`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Genero->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Genero->ViewValue = $this->Genero->CurrentValue;
				}
			} else {
				$this->Genero->ViewValue = NULL;
			}
			$this->Genero->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
			$this->Nombres->ViewCustomAttributes = "";

			// Apellidos
			$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
			$this->Apellidos->ViewCustomAttributes = "";

			// Fecha_valoracion
			$this->Fecha_valoracion->ViewValue = $this->Fecha_valoracion->CurrentValue;
			$this->Fecha_valoracion->ViewValue = ew_FormatDateTime($this->Fecha_valoracion->ViewValue, 7);
			$this->Fecha_valoracion->ViewCustomAttributes = "";

			// Edad_Anos
			$this->Edad_Anos->ViewValue = $this->Edad_Anos->CurrentValue;
			$this->Edad_Anos->ViewCustomAttributes = "";

			// Edad_Meses
			$this->Edad_Meses->ViewValue = $this->Edad_Meses->CurrentValue;
			$this->Edad_Meses->ViewCustomAttributes = "";

			// Peso
			$this->Peso->ViewValue = $this->Peso->CurrentValue;
			$this->Peso->ViewCustomAttributes = "";

			// Talla
			$this->Talla->ViewValue = $this->Talla->CurrentValue;
			$this->Talla->ViewCustomAttributes = "";

			// Perimetro_Cefalico
			$this->Perimetro_Cefalico->ViewValue = $this->Perimetro_Cefalico->CurrentValue;
			$this->Perimetro_Cefalico->ViewCustomAttributes = "";

			// Perimetro_Abdominal
			$this->Perimetro_Abdominal->ViewValue = $this->Perimetro_Abdominal->CurrentValue;
			$this->Perimetro_Abdominal->ViewCustomAttributes = "";

			// IMC
			$this->IMC->ViewValue = $this->IMC->CurrentValue;
			$this->IMC->ViewValue = ew_FormatNumber($this->IMC->ViewValue, 2, 0, 0, 0);
			$this->IMC->CellCssStyle .= "text-align: right;";
			$this->IMC->ViewCustomAttributes = "";

			// DS_TallaEdad
			$this->DS_TallaEdad->ViewValue = $this->DS_TallaEdad->CurrentValue;
			$this->DS_TallaEdad->ViewCustomAttributes = "";

			// DS_PesoTalla
			$this->DS_PesoTalla->ViewValue = $this->DS_PesoTalla->CurrentValue;
			$this->DS_PesoTalla->ViewCustomAttributes = "";

			// DS_PesoEdad
			$this->DS_PesoEdad->ViewValue = $this->DS_PesoEdad->CurrentValue;
			$this->DS_PesoEdad->ViewCustomAttributes = "";

			// DS_IMCEdad
			$this->DS_IMCEdad->ViewValue = $this->DS_IMCEdad->CurrentValue;
			$this->DS_IMCEdad->ViewCustomAttributes = "";

			// DS_PCEdad
			$this->DS_PCEdad->ViewValue = $this->DS_PCEdad->CurrentValue;
			$this->DS_PCEdad->ViewCustomAttributes = "";

			// Clasificacion_Talla_Edad
			if (strval($this->Clasificacion_Talla_Edad->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Talla_Edad->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Talla_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_talla_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Talla_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_Talla_Edad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_Talla_Edad->ViewValue = $this->Clasificacion_Talla_Edad->CurrentValue;
				}
			} else {
				$this->Clasificacion_Talla_Edad->ViewValue = NULL;
			}
			$this->Clasificacion_Talla_Edad->ViewCustomAttributes = "";

			// Clasificacion_Peso_Talla
			if (strval($this->Clasificacion_Peso_Talla->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Peso_Talla->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Talla` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_peso_talla`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Peso_Talla, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_Peso_Talla->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_Peso_Talla->ViewValue = $this->Clasificacion_Peso_Talla->CurrentValue;
				}
			} else {
				$this->Clasificacion_Peso_Talla->ViewValue = NULL;
			}
			$this->Clasificacion_Peso_Talla->ViewCustomAttributes = "";

			// Clasificacion_Peso_Edad
			if (strval($this->Clasificacion_Peso_Edad->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Peso_Edad->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_peso_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Peso_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_Peso_Edad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_Peso_Edad->ViewValue = $this->Clasificacion_Peso_Edad->CurrentValue;
				}
			} else {
				$this->Clasificacion_Peso_Edad->ViewValue = NULL;
			}
			$this->Clasificacion_Peso_Edad->ViewCustomAttributes = "";

			// Clasificacion_IMC_Edad
			if (strval($this->Clasificacion_IMC_Edad->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_IMC_Edad->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_IMC_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_imc_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_IMC_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_IMC_Edad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_IMC_Edad->ViewValue = $this->Clasificacion_IMC_Edad->CurrentValue;
				}
			} else {
				$this->Clasificacion_IMC_Edad->ViewValue = NULL;
			}
			$this->Clasificacion_IMC_Edad->ViewCustomAttributes = "";

			// Clasificacion_P_Cefalico
			if (strval($this->Clasificacion_P_Cefalico->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_P_Cefalico->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Perimetro_Cefalico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_p_cefalico`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_P_Cefalico, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_P_Cefalico->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_P_Cefalico->ViewValue = $this->Clasificacion_P_Cefalico->CurrentValue;
				}
			} else {
				$this->Clasificacion_P_Cefalico->ViewValue = NULL;
			}
			$this->Clasificacion_P_Cefalico->ViewCustomAttributes = "";

			// Superficie_Corporal
			$this->Superficie_Corporal->ViewValue = $this->Superficie_Corporal->CurrentValue;
			$this->Superficie_Corporal->ViewCustomAttributes = "";

			// Zona
			if (strval($this->Zona->CurrentValue) <> "") {
				$sFilterWrk = "`codigo`" . ew_SearchString("=", $this->Zona->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `codigo`, `Zona` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `zona`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Zona->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Zona->ViewValue = $this->Zona->CurrentValue;
				}
			} else {
				$this->Zona->ViewValue = NULL;
			}
			$this->Zona->ViewCustomAttributes = "";

			// Barrio_Vereda
			if (strval($this->Barrio_Vereda->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Barrio_Vereda->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrio_vereda`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Barrio_Vereda, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Barrio_Vereda`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Barrio_Vereda->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Barrio_Vereda->ViewValue = $this->Barrio_Vereda->CurrentValue;
				}
			} else {
				$this->Barrio_Vereda->ViewValue = NULL;
			}
			$this->Barrio_Vereda->ViewCustomAttributes = "";

			// Comuna_Zona
			$this->Comuna_Zona->ViewValue = $this->Comuna_Zona->CurrentValue;
			if (strval($this->Comuna_Zona->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Comuna_Zona->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `comuna_localidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Comuna_Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Comuna_Zona->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Comuna_Zona->ViewValue = $this->Comuna_Zona->CurrentValue;
				}
			} else {
				$this->Comuna_Zona->ViewValue = NULL;
			}
			$this->Comuna_Zona->ViewCustomAttributes = "";

			// Grupo_Etnico
			if (strval($this->Grupo_Etnico->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Grupo_Etnico->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Pertenencia_Etnica` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `pertenencia_etnica`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Grupo_Etnico, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Pertenencia_Etnica`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Grupo_Etnico->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Grupo_Etnico->ViewValue = $this->Grupo_Etnico->CurrentValue;
				}
			} else {
				$this->Grupo_Etnico->ViewValue = NULL;
			}
			$this->Grupo_Etnico->ViewCustomAttributes = "";

			// Tipo_Regimen
			if (strval($this->Tipo_Regimen->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Tipo_Regimen->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Tipo_Regimen_Salud` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `regimen_salud`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Tipo_Regimen, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Tipo_Regimen_Salud`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Tipo_Regimen->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Tipo_Regimen->ViewValue = $this->Tipo_Regimen->CurrentValue;
				}
			} else {
				$this->Tipo_Regimen->ViewValue = NULL;
			}
			$this->Tipo_Regimen->ViewCustomAttributes = "";

			// EPS
			if (strval($this->EPS->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->EPS->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Administradora_Salud` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->EPS, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Administradora_Salud`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->EPS->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->EPS->ViewValue = $this->EPS->CurrentValue;
				}
			} else {
				$this->EPS->ViewValue = NULL;
			}
			$this->EPS->ViewCustomAttributes = "";

			// Condicion_Discapacidad
			if (strval($this->Condicion_Discapacidad->CurrentValue) <> "") {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Condicion_Discapacidad->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `Consecutivo`, `Condicion_Discapacidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_condicion_discapacidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Condicion_Discapacidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Condicion_Discapacidad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Condicion_Discapacidad->ViewValue = $this->Condicion_Discapacidad->CurrentValue;
				}
			} else {
				$this->Condicion_Discapacidad->ViewValue = NULL;
			}
			$this->Condicion_Discapacidad->ViewCustomAttributes = "";

			// Condicion_Desplazamiento
			if (strval($this->Condicion_Desplazamiento->CurrentValue) <> "") {
				switch ($this->Condicion_Desplazamiento->CurrentValue) {
					case $this->Condicion_Desplazamiento->FldTagValue(1):
						$this->Condicion_Desplazamiento->ViewValue = $this->Condicion_Desplazamiento->FldTagCaption(1) <> "" ? $this->Condicion_Desplazamiento->FldTagCaption(1) : $this->Condicion_Desplazamiento->CurrentValue;
						break;
					case $this->Condicion_Desplazamiento->FldTagValue(2):
						$this->Condicion_Desplazamiento->ViewValue = $this->Condicion_Desplazamiento->FldTagCaption(2) <> "" ? $this->Condicion_Desplazamiento->FldTagCaption(2) : $this->Condicion_Desplazamiento->CurrentValue;
						break;
					default:
						$this->Condicion_Desplazamiento->ViewValue = $this->Condicion_Desplazamiento->CurrentValue;
				}
			} else {
				$this->Condicion_Desplazamiento->ViewValue = NULL;
			}
			$this->Condicion_Desplazamiento->ViewCustomAttributes = "";

			// Entidad_Educativa
			if (strval($this->Entidad_Educativa->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad_Educativa->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `Id`, `Entidad_Educativa` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_educativa`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad_Educativa, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Entidad_Educativa`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Entidad_Educativa->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Entidad_Educativa->ViewValue = $this->Entidad_Educativa->CurrentValue;
				}
			} else {
				$this->Entidad_Educativa->ViewValue = NULL;
			}
			$this->Entidad_Educativa->ViewCustomAttributes = "";

			// Escolaridad
			if (strval($this->Escolaridad->CurrentValue) <> "") {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Escolaridad->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `Consecutivo`, `Grado_Escolar` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_grado_escolar`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Escolaridad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Grado_Escolar`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Escolaridad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Escolaridad->ViewValue = $this->Escolaridad->CurrentValue;
				}
			} else {
				$this->Escolaridad->ViewValue = NULL;
			}
			$this->Escolaridad->ViewCustomAttributes = "";

			// Clasificado
			if (strval($this->Clasificado->CurrentValue) <> "") {
				switch ($this->Clasificado->CurrentValue) {
					case $this->Clasificado->FldTagValue(1):
						$this->Clasificado->ViewValue = $this->Clasificado->FldTagCaption(1) <> "" ? $this->Clasificado->FldTagCaption(1) : $this->Clasificado->CurrentValue;
						break;
					default:
						$this->Clasificado->ViewValue = $this->Clasificado->CurrentValue;
				}
			} else {
				$this->Clasificado->ViewValue = NULL;
			}
			$this->Clasificado->ViewCustomAttributes = "";

			// Usuario
			$this->Usuario->ViewValue = $this->Usuario->CurrentValue;
			$this->Usuario->ViewCustomAttributes = "";

			// Fecha_edicion
			$this->Fecha_edicion->ViewValue = $this->Fecha_edicion->CurrentValue;
			$this->Fecha_edicion->ViewValue = ew_FormatDateTime($this->Fecha_edicion->ViewValue, 7);
			$this->Fecha_edicion->ViewCustomAttributes = "";

			// Entidad_Valora
			$this->Entidad_Valora->LinkCustomAttributes = "";
			$this->Entidad_Valora->HrefValue = "";
			$this->Entidad_Valora->TooltipValue = "";

			// Tipo_Entidad
			$this->Tipo_Entidad->LinkCustomAttributes = "";
			$this->Tipo_Entidad->HrefValue = "";
			$this->Tipo_Entidad->TooltipValue = "";

			// Tipo_Documento
			$this->Tipo_Documento->LinkCustomAttributes = "";
			$this->Tipo_Documento->HrefValue = "";
			$this->Tipo_Documento->TooltipValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";
			$this->Documento->TooltipValue = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->LinkCustomAttributes = "";
			$this->Fecha_Nacimiento->HrefValue = "";
			$this->Fecha_Nacimiento->TooltipValue = "";

			// Genero
			$this->Genero->LinkCustomAttributes = "";
			$this->Genero->HrefValue = "";
			$this->Genero->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Fecha_valoracion
			$this->Fecha_valoracion->LinkCustomAttributes = "";
			$this->Fecha_valoracion->HrefValue = "";
			$this->Fecha_valoracion->TooltipValue = "";

			// Edad_Anos
			$this->Edad_Anos->LinkCustomAttributes = "";
			$this->Edad_Anos->HrefValue = "";
			$this->Edad_Anos->TooltipValue = "";

			// Edad_Meses
			$this->Edad_Meses->LinkCustomAttributes = "";
			$this->Edad_Meses->HrefValue = "";
			$this->Edad_Meses->TooltipValue = "";

			// Peso
			$this->Peso->LinkCustomAttributes = "";
			$this->Peso->HrefValue = "";
			$this->Peso->TooltipValue = "";

			// Talla
			$this->Talla->LinkCustomAttributes = "";
			$this->Talla->HrefValue = "";
			$this->Talla->TooltipValue = "";

			// Perimetro_Cefalico
			$this->Perimetro_Cefalico->LinkCustomAttributes = "";
			$this->Perimetro_Cefalico->HrefValue = "";
			$this->Perimetro_Cefalico->TooltipValue = "";

			// Perimetro_Abdominal
			$this->Perimetro_Abdominal->LinkCustomAttributes = "";
			$this->Perimetro_Abdominal->HrefValue = "";
			$this->Perimetro_Abdominal->TooltipValue = "";

			// IMC
			$this->IMC->LinkCustomAttributes = "";
			$this->IMC->HrefValue = "";
			$this->IMC->TooltipValue = "";

			// DS_TallaEdad
			$this->DS_TallaEdad->LinkCustomAttributes = "";
			$this->DS_TallaEdad->HrefValue = "";
			$this->DS_TallaEdad->TooltipValue = "";

			// DS_PesoTalla
			$this->DS_PesoTalla->LinkCustomAttributes = "";
			$this->DS_PesoTalla->HrefValue = "";
			$this->DS_PesoTalla->TooltipValue = "";

			// DS_PesoEdad
			$this->DS_PesoEdad->LinkCustomAttributes = "";
			$this->DS_PesoEdad->HrefValue = "";
			$this->DS_PesoEdad->TooltipValue = "";

			// DS_IMCEdad
			$this->DS_IMCEdad->LinkCustomAttributes = "";
			$this->DS_IMCEdad->HrefValue = "";
			$this->DS_IMCEdad->TooltipValue = "";

			// DS_PCEdad
			$this->DS_PCEdad->LinkCustomAttributes = "";
			$this->DS_PCEdad->HrefValue = "";
			$this->DS_PCEdad->TooltipValue = "";

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_Talla_Edad->HrefValue = "";
			$this->Clasificacion_Talla_Edad->TooltipValue = "";

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->LinkCustomAttributes = "";
			$this->Clasificacion_Peso_Talla->HrefValue = "";
			$this->Clasificacion_Peso_Talla->TooltipValue = "";

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_Peso_Edad->HrefValue = "";
			$this->Clasificacion_Peso_Edad->TooltipValue = "";

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_IMC_Edad->HrefValue = "";
			$this->Clasificacion_IMC_Edad->TooltipValue = "";

			// Clasificacion_P_Cefalico
			$this->Clasificacion_P_Cefalico->LinkCustomAttributes = "";
			$this->Clasificacion_P_Cefalico->HrefValue = "";
			$this->Clasificacion_P_Cefalico->TooltipValue = "";

			// Superficie_Corporal
			$this->Superficie_Corporal->LinkCustomAttributes = "";
			$this->Superficie_Corporal->HrefValue = "";
			$this->Superficie_Corporal->TooltipValue = "";

			// Zona
			$this->Zona->LinkCustomAttributes = "";
			$this->Zona->HrefValue = "";
			$this->Zona->TooltipValue = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->LinkCustomAttributes = "";
			$this->Barrio_Vereda->HrefValue = "";
			$this->Barrio_Vereda->TooltipValue = "";

			// Comuna_Zona
			$this->Comuna_Zona->LinkCustomAttributes = "";
			$this->Comuna_Zona->HrefValue = "";
			$this->Comuna_Zona->TooltipValue = "";

			// Grupo_Etnico
			$this->Grupo_Etnico->LinkCustomAttributes = "";
			$this->Grupo_Etnico->HrefValue = "";
			$this->Grupo_Etnico->TooltipValue = "";

			// Tipo_Regimen
			$this->Tipo_Regimen->LinkCustomAttributes = "";
			$this->Tipo_Regimen->HrefValue = "";
			$this->Tipo_Regimen->TooltipValue = "";

			// EPS
			$this->EPS->LinkCustomAttributes = "";
			$this->EPS->HrefValue = "";
			$this->EPS->TooltipValue = "";

			// Condicion_Discapacidad
			$this->Condicion_Discapacidad->LinkCustomAttributes = "";
			$this->Condicion_Discapacidad->HrefValue = "";
			$this->Condicion_Discapacidad->TooltipValue = "";

			// Condicion_Desplazamiento
			$this->Condicion_Desplazamiento->LinkCustomAttributes = "";
			$this->Condicion_Desplazamiento->HrefValue = "";
			$this->Condicion_Desplazamiento->TooltipValue = "";

			// Entidad_Educativa
			$this->Entidad_Educativa->LinkCustomAttributes = "";
			$this->Entidad_Educativa->HrefValue = "";
			$this->Entidad_Educativa->TooltipValue = "";

			// Escolaridad
			$this->Escolaridad->LinkCustomAttributes = "";
			$this->Escolaridad->HrefValue = "";
			$this->Escolaridad->TooltipValue = "";

			// Clasificado
			$this->Clasificado->LinkCustomAttributes = "";
			$this->Clasificado->HrefValue = "";
			$this->Clasificado->TooltipValue = "";

			// Usuario
			$this->Usuario->LinkCustomAttributes = "";
			$this->Usuario->HrefValue = "";
			$this->Usuario->TooltipValue = "";

			// Fecha_edicion
			$this->Fecha_edicion->LinkCustomAttributes = "";
			$this->Fecha_edicion->HrefValue = "";
			$this->Fecha_edicion->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$item->Body = "<a id=\"emf_nutricion_valoracion\" href=\"javascript:void(0);\" class=\"ewExportLink ewEmail\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_nutricion_valoracion',hdr:ewLanguage.Phrase('ExportToEmail'),f:document.fnutricion_valoracionview,key:" . ew_ArrayToJsonAttr($this->RecKey) . ",sel:false});\">" . $Language->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = FALSE;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if ($rs = $this->LoadRecordset())
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;
		$this->SetUpStartRec(); // Set up start record position

		// Set the last record to display
		if ($this->DisplayRecs <= 0) {
			$this->StopRec = $this->TotalRecs;
		} else {
			$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
		}
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$ExportDoc = ew_ExportDocument($this, "v");
		$ParentTable = "";
		if ($bSelectLimit) {
			$StartRec = 1;
			$StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {
			$StartRec = $this->StartRec;
			$StopRec = $this->StopRec;
		}
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$ExportDoc->Text .= $sHeader;
		$this->ExportDocument($ExportDoc, $rs, $StartRec, $StopRec, "view");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$ExportDoc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Export header and footer
		$ExportDoc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED)
			echo ew_DebugMsg();

		// Output data
		$ExportDoc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$Breadcrumb->Add("list", $this->TableVar, "nutricion_valoracionlist.php", $this->TableVar, TRUE);
		$PageId = "view";
		$Breadcrumb->Add("view", $PageId, ew_CurrentUrl());
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($nutricion_valoracion_view)) $nutricion_valoracion_view = new cnutricion_valoracion_view();

// Page init
$nutricion_valoracion_view->Page_Init();

// Page main
$nutricion_valoracion_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$nutricion_valoracion_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($nutricion_valoracion->Export == "") { ?>
<script type="text/javascript">

// Page object
var nutricion_valoracion_view = new ew_Page("nutricion_valoracion_view");
nutricion_valoracion_view.PageID = "view"; // Page ID
var EW_PAGE_ID = nutricion_valoracion_view.PageID; // For backward compatibility

// Form object
var fnutricion_valoracionview = new ew_Form("fnutricion_valoracionview");

// Form_CustomValidate event
fnutricion_valoracionview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnutricion_valoracionview.ValidateRequired = true;
<?php } else { ?>
fnutricion_valoracionview.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnutricion_valoracionview.Lists["x_Entidad_Valora"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Entidad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Tipo_Documento"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Tipo_Documento","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Genero"] = {"LinkField":"x__23","Ajax":null,"AutoFill":false,"DisplayFields":["x_Genero","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Clasificacion_Talla_Edad"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Talla_Edad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Clasificacion_Peso_Talla"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Peso_Talla","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Clasificacion_Peso_Edad"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Peso_Edad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Clasificacion_IMC_Edad"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_IMC_Edad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Clasificacion_P_Cefalico"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Perimetro_Cefalico","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Zona"] = {"LinkField":"x_codigo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Zona","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Barrio_Vereda"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Barrio_Vereda","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Comuna_Zona"] = {"LinkField":"x_consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Localidad_Comuna","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Grupo_Etnico"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Pertenencia_Etnica","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Tipo_Regimen"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Tipo_Regimen_Salud","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_EPS"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Administradora_Salud","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Condicion_Discapacidad"] = {"LinkField":"x_Consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Condicion_Discapacidad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Entidad_Educativa"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Entidad_Educativa","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionview.Lists["x_Escolaridad"] = {"LinkField":"x_Consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Grado_Escolar","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($nutricion_valoracion->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($nutricion_valoracion->Export == "") { ?>
<div class="ewViewExportOptions">
<?php $nutricion_valoracion_view->ExportOptions->Render("body") ?>
<?php if (!$nutricion_valoracion_view->ExportOptions->UseDropDownButton) { ?>
</div>
<div class="ewViewOtherOptions">
<?php } ?>
<?php
	foreach ($nutricion_valoracion_view->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<?php } ?>
<?php $nutricion_valoracion_view->ShowPageHeader(); ?>
<?php
$nutricion_valoracion_view->ShowMessage();
?>
<form name="fnutricion_valoracionview" id="fnutricion_valoracionview" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="nutricion_valoracion">
<div id="tpd_nutricion_valoracionview"></div>
<script id="tpm_nutricion_valoracionview" type="text/html">
<span id="ct_nutricion_valoracion_view"><table class="table table-bordered table-striped">
<tbody>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">DATOS
PERSONALES</span> </td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->Tipo_Documento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Documento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Nombres->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Apellidos->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Genero->FldCaption() ?></td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Tipo_Documento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Documento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Nombres"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Apellidos"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Genero"/}}</td>
</tr>
<tr>
<td colspan="2"> <?php echo $nutricion_valoracion->Fecha_valoracion->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Fecha_Nacimiento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Edad_Anos->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Edad_Meses->FldCaption() ?></td>
</tr>
<tr>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Fecha_valoracion"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Fecha_Nacimiento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Edad_Anos"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Edad_Meses"/}}</td>
</tr>
<tr>
<td colspan="1" rowspan="1"><?php echo $nutricion_valoracion->Entidad_Educativa->FldCaption() ?></td>
<td colspan="1" rowspan="1"><?php echo $nutricion_valoracion->Escolaridad->FldCaption() ?></td>
<td style="vertical-align: top;"><?php echo $nutricion_valoracion->Grupo_Etnico->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Condicion_Desplazamiento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Condicion_Discapacidad->FldCaption() ?></td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Entidad_Educativa"/}}</td>
<td colspan="1">{{include tmpl="#tpx_nutricion_valoracion_Escolaridad"/}}</td>
<td style="vertical-align: top;">{{include tmpl="#tpx_nutricion_valoracion_Grupo_Etnico"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Condicion_Desplazamiento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Condicion_Discapacidad"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->Tipo_Regimen->FldCaption() ?></td>
<td colspan="4" rowspan="1"><?php echo $nutricion_valoracion->EPS->FldCaption() ?></td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Tipo_Regimen"/}}</td>
<td colspan="4">{{include tmpl="#tpx_nutricion_valoracion_EPS"/}}</td>
</tr>
<tr>
<td colspan="1" rowspan="1"><?php echo $nutricion_valoracion->Zona->FldCaption() ?></td>
<td colspan="2"><?php echo $nutricion_valoracion->Barrio_Vereda->FldCaption() ?></td>
<td colspan="2"><?php echo $nutricion_valoracion->Comuna_Zona->FldCaption() ?></td>
</tr>
<tr>
<td colspan="1">{{include tmpl="#tpx_nutricion_valoracion_Zona"/}}</td>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Barrio_Vereda"/}}</td>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Comuna_Zona"/}}</td>
</tr>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">MEDICION</span>
</td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->Peso->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->Talla->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->Perimetro_Cefalico->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->Perimetro_Abdominal->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->IMC->FldCaption() ?>&nbsp;{{include tmpl="#tpx_nutricion_valoracion_IMC"/}} </td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Peso"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Talla"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Perimetro_Cefalico"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Perimetro_Abdominal"/}}</td>
<td><?php echo $nutricion_valoracion->Superficie_Corporal->FldCaption() ?>&nbsp;{{include tmpl="#tpx_nutricion_valoracion_Superficie_Corporal"/}}</td>
</tr>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">VALORACION&nbsp;</span>
</td>
</tr>
<tr>
<td colspan="3"><?php echo $nutricion_valoracion->Entidad_Valora->FldCaption() ?></td>
<td colspan="2"><?php echo $nutricion_valoracion->Tipo_Entidad->FldCaption() ?></td>
</tr>
<tr>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Entidad_Valora"/}}</td>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Tipo_Entidad"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->DS_TallaEdad->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->DS_PesoTalla->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->DS_PesoEdad->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->DS_IMCEdad->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->DS_PCEdad->FldCaption() ?>
</td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_TallaEdad"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_PesoTalla"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_PesoEdad"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_IMCEdad"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_PCEdad"/}}
</td>
</tr>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">CLASIFICACION&nbsp;</span>
</td>
</tr>
<tr>
<td>Clasificar
</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Clasificado"/}}</td>
<td colspan="3">
<br>
</td>
</tr>
<tr>
<td colspan="2"><?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->FldCaption() ?></td>
<td colspan="3"><?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->FldCaption() ?></td>
</tr>
<tr>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_Talla_Edad"/}}</td>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_Peso_Talla"/}}</td>
</tr>
<tr>
<td colspan="2"><?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->FldCaption() ?></td>
<td colspan="3"><?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->FldCaption() ?>
</td>
</tr>
<tr>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_Peso_Edad"/}}</td>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_IMC_Edad"/}}</td>
</tr>
<tr>
<td colspan="2"><?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->FldCaption() ?></td>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_P_Cefalico"/}}
</td>
</tr>
</tbody>
</table>   
</span>
</script>
<table class="ewGrid" style="display: none"><tr><td>
<table id="tbl_nutricion_valoracionview" class="table table-bordered table-striped">
<?php if ($nutricion_valoracion->Entidad_Valora->Visible) { // Entidad_Valora ?>
	<tr id="r_Entidad_Valora">
		<td><span id="elh_nutricion_valoracion_Entidad_Valora"><script id="tpc_nutricion_valoracion_Entidad_Valora" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Entidad_Valora->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Entidad_Valora->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Entidad_Valora" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Entidad_Valora" class="control-group">
<span<?php echo $nutricion_valoracion->Entidad_Valora->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Entidad_Valora->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Tipo_Entidad->Visible) { // Tipo_Entidad ?>
	<tr id="r_Tipo_Entidad">
		<td><span id="elh_nutricion_valoracion_Tipo_Entidad"><script id="tpc_nutricion_valoracion_Tipo_Entidad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Tipo_Entidad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Tipo_Entidad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Tipo_Entidad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Tipo_Entidad" class="control-group">
<span<?php echo $nutricion_valoracion->Tipo_Entidad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Tipo_Entidad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Tipo_Documento->Visible) { // Tipo_Documento ?>
	<tr id="r_Tipo_Documento">
		<td><span id="elh_nutricion_valoracion_Tipo_Documento"><script id="tpc_nutricion_valoracion_Tipo_Documento" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Tipo_Documento->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Tipo_Documento->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Tipo_Documento" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Tipo_Documento" class="control-group">
<span<?php echo $nutricion_valoracion->Tipo_Documento->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Tipo_Documento->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Documento->Visible) { // Documento ?>
	<tr id="r_Documento">
		<td><span id="elh_nutricion_valoracion_Documento"><script id="tpc_nutricion_valoracion_Documento" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Documento->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Documento->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Documento" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Documento" class="control-group">
<span<?php echo $nutricion_valoracion->Documento->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Documento->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Fecha_Nacimiento->Visible) { // Fecha_Nacimiento ?>
	<tr id="r_Fecha_Nacimiento">
		<td><span id="elh_nutricion_valoracion_Fecha_Nacimiento"><script id="tpc_nutricion_valoracion_Fecha_Nacimiento" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Fecha_Nacimiento->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Fecha_Nacimiento->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Fecha_Nacimiento" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Fecha_Nacimiento" class="control-group">
<span<?php echo $nutricion_valoracion->Fecha_Nacimiento->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Fecha_Nacimiento->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Genero->Visible) { // Genero ?>
	<tr id="r_Genero">
		<td><span id="elh_nutricion_valoracion_Genero"><script id="tpc_nutricion_valoracion_Genero" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Genero->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Genero->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Genero" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Genero" class="control-group">
<span<?php echo $nutricion_valoracion->Genero->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Genero->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Nombres->Visible) { // Nombres ?>
	<tr id="r_Nombres">
		<td><span id="elh_nutricion_valoracion_Nombres"><script id="tpc_nutricion_valoracion_Nombres" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Nombres->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Nombres->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Nombres" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Nombres" class="control-group">
<span<?php echo $nutricion_valoracion->Nombres->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Nombres->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Apellidos->Visible) { // Apellidos ?>
	<tr id="r_Apellidos">
		<td><span id="elh_nutricion_valoracion_Apellidos"><script id="tpc_nutricion_valoracion_Apellidos" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Apellidos->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Apellidos->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Apellidos" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Apellidos" class="control-group">
<span<?php echo $nutricion_valoracion->Apellidos->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Apellidos->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Fecha_valoracion->Visible) { // Fecha_valoracion ?>
	<tr id="r_Fecha_valoracion">
		<td><span id="elh_nutricion_valoracion_Fecha_valoracion"><script id="tpc_nutricion_valoracion_Fecha_valoracion" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Fecha_valoracion->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Fecha_valoracion->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Fecha_valoracion" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Fecha_valoracion" class="control-group">
<span<?php echo $nutricion_valoracion->Fecha_valoracion->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Fecha_valoracion->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Edad_Anos->Visible) { // Edad_Anos ?>
	<tr id="r_Edad_Anos">
		<td><span id="elh_nutricion_valoracion_Edad_Anos"><script id="tpc_nutricion_valoracion_Edad_Anos" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Edad_Anos->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Edad_Anos->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Edad_Anos" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Edad_Anos" class="control-group">
<span<?php echo $nutricion_valoracion->Edad_Anos->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Edad_Anos->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Edad_Meses->Visible) { // Edad_Meses ?>
	<tr id="r_Edad_Meses">
		<td><span id="elh_nutricion_valoracion_Edad_Meses"><script id="tpc_nutricion_valoracion_Edad_Meses" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Edad_Meses->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Edad_Meses->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Edad_Meses" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Edad_Meses" class="control-group">
<span<?php echo $nutricion_valoracion->Edad_Meses->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Edad_Meses->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Peso->Visible) { // Peso ?>
	<tr id="r_Peso">
		<td><span id="elh_nutricion_valoracion_Peso"><script id="tpc_nutricion_valoracion_Peso" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Peso->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Peso->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Peso" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Peso" class="control-group">
<span<?php echo $nutricion_valoracion->Peso->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Peso->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Talla->Visible) { // Talla ?>
	<tr id="r_Talla">
		<td><span id="elh_nutricion_valoracion_Talla"><script id="tpc_nutricion_valoracion_Talla" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Talla->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Talla->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Talla" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Talla" class="control-group">
<span<?php echo $nutricion_valoracion->Talla->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Talla->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Perimetro_Cefalico->Visible) { // Perimetro_Cefalico ?>
	<tr id="r_Perimetro_Cefalico">
		<td><span id="elh_nutricion_valoracion_Perimetro_Cefalico"><script id="tpc_nutricion_valoracion_Perimetro_Cefalico" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Perimetro_Cefalico->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Perimetro_Cefalico->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Perimetro_Cefalico" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Perimetro_Cefalico" class="control-group">
<span<?php echo $nutricion_valoracion->Perimetro_Cefalico->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Perimetro_Cefalico->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Perimetro_Abdominal->Visible) { // Perimetro_Abdominal ?>
	<tr id="r_Perimetro_Abdominal">
		<td><span id="elh_nutricion_valoracion_Perimetro_Abdominal"><script id="tpc_nutricion_valoracion_Perimetro_Abdominal" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Perimetro_Abdominal->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Perimetro_Abdominal->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Perimetro_Abdominal" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Perimetro_Abdominal" class="control-group">
<span<?php echo $nutricion_valoracion->Perimetro_Abdominal->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Perimetro_Abdominal->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->IMC->Visible) { // IMC ?>
	<tr id="r_IMC">
		<td><span id="elh_nutricion_valoracion_IMC"><script id="tpc_nutricion_valoracion_IMC" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->IMC->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->IMC->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_IMC" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_IMC" class="control-group">
<span<?php echo $nutricion_valoracion->IMC->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->IMC->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_TallaEdad->Visible) { // DS_TallaEdad ?>
	<tr id="r_DS_TallaEdad">
		<td><span id="elh_nutricion_valoracion_DS_TallaEdad"><script id="tpc_nutricion_valoracion_DS_TallaEdad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->DS_TallaEdad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->DS_TallaEdad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_DS_TallaEdad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_DS_TallaEdad" class="control-group">
<span<?php echo $nutricion_valoracion->DS_TallaEdad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->DS_TallaEdad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_PesoTalla->Visible) { // DS_PesoTalla ?>
	<tr id="r_DS_PesoTalla">
		<td><span id="elh_nutricion_valoracion_DS_PesoTalla"><script id="tpc_nutricion_valoracion_DS_PesoTalla" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->DS_PesoTalla->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->DS_PesoTalla->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_DS_PesoTalla" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_DS_PesoTalla" class="control-group">
<span<?php echo $nutricion_valoracion->DS_PesoTalla->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->DS_PesoTalla->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_PesoEdad->Visible) { // DS_PesoEdad ?>
	<tr id="r_DS_PesoEdad">
		<td><span id="elh_nutricion_valoracion_DS_PesoEdad"><script id="tpc_nutricion_valoracion_DS_PesoEdad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->DS_PesoEdad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->DS_PesoEdad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_DS_PesoEdad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_DS_PesoEdad" class="control-group">
<span<?php echo $nutricion_valoracion->DS_PesoEdad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->DS_PesoEdad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_IMCEdad->Visible) { // DS_IMCEdad ?>
	<tr id="r_DS_IMCEdad">
		<td><span id="elh_nutricion_valoracion_DS_IMCEdad"><script id="tpc_nutricion_valoracion_DS_IMCEdad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->DS_IMCEdad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->DS_IMCEdad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_DS_IMCEdad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_DS_IMCEdad" class="control-group">
<span<?php echo $nutricion_valoracion->DS_IMCEdad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->DS_IMCEdad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_PCEdad->Visible) { // DS_PCEdad ?>
	<tr id="r_DS_PCEdad">
		<td><span id="elh_nutricion_valoracion_DS_PCEdad"><script id="tpc_nutricion_valoracion_DS_PCEdad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->DS_PCEdad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->DS_PCEdad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_DS_PCEdad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_DS_PCEdad" class="control-group">
<span<?php echo $nutricion_valoracion->DS_PCEdad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->DS_PCEdad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_Talla_Edad->Visible) { // Clasificacion_Talla_Edad ?>
	<tr id="r_Clasificacion_Talla_Edad">
		<td><span id="elh_nutricion_valoracion_Clasificacion_Talla_Edad"><script id="tpc_nutricion_valoracion_Clasificacion_Talla_Edad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Clasificacion_Talla_Edad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Clasificacion_Talla_Edad" class="control-group">
<span<?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_Peso_Talla->Visible) { // Clasificacion_Peso_Talla ?>
	<tr id="r_Clasificacion_Peso_Talla">
		<td><span id="elh_nutricion_valoracion_Clasificacion_Peso_Talla"><script id="tpc_nutricion_valoracion_Clasificacion_Peso_Talla" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Clasificacion_Peso_Talla" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Clasificacion_Peso_Talla" class="control-group">
<span<?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_Peso_Edad->Visible) { // Clasificacion_Peso_Edad ?>
	<tr id="r_Clasificacion_Peso_Edad">
		<td><span id="elh_nutricion_valoracion_Clasificacion_Peso_Edad"><script id="tpc_nutricion_valoracion_Clasificacion_Peso_Edad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Clasificacion_Peso_Edad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Clasificacion_Peso_Edad" class="control-group">
<span<?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_IMC_Edad->Visible) { // Clasificacion_IMC_Edad ?>
	<tr id="r_Clasificacion_IMC_Edad">
		<td><span id="elh_nutricion_valoracion_Clasificacion_IMC_Edad"><script id="tpc_nutricion_valoracion_Clasificacion_IMC_Edad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Clasificacion_IMC_Edad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Clasificacion_IMC_Edad" class="control-group">
<span<?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_P_Cefalico->Visible) { // Clasificacion_P_Cefalico ?>
	<tr id="r_Clasificacion_P_Cefalico">
		<td><span id="elh_nutricion_valoracion_Clasificacion_P_Cefalico"><script id="tpc_nutricion_valoracion_Clasificacion_P_Cefalico" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Clasificacion_P_Cefalico" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Clasificacion_P_Cefalico" class="control-group">
<span<?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Superficie_Corporal->Visible) { // Superficie_Corporal ?>
	<tr id="r_Superficie_Corporal">
		<td><span id="elh_nutricion_valoracion_Superficie_Corporal"><script id="tpc_nutricion_valoracion_Superficie_Corporal" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Superficie_Corporal->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Superficie_Corporal->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Superficie_Corporal" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Superficie_Corporal" class="control-group">
<span<?php echo $nutricion_valoracion->Superficie_Corporal->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Superficie_Corporal->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Zona->Visible) { // Zona ?>
	<tr id="r_Zona">
		<td><span id="elh_nutricion_valoracion_Zona"><script id="tpc_nutricion_valoracion_Zona" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Zona->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Zona->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Zona" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Zona" class="control-group">
<span<?php echo $nutricion_valoracion->Zona->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Zona->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Barrio_Vereda->Visible) { // Barrio_Vereda ?>
	<tr id="r_Barrio_Vereda">
		<td><span id="elh_nutricion_valoracion_Barrio_Vereda"><script id="tpc_nutricion_valoracion_Barrio_Vereda" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Barrio_Vereda->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Barrio_Vereda->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Barrio_Vereda" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Barrio_Vereda" class="control-group">
<span<?php echo $nutricion_valoracion->Barrio_Vereda->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Barrio_Vereda->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Comuna_Zona->Visible) { // Comuna_Zona ?>
	<tr id="r_Comuna_Zona">
		<td><span id="elh_nutricion_valoracion_Comuna_Zona"><script id="tpc_nutricion_valoracion_Comuna_Zona" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Comuna_Zona->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Comuna_Zona->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Comuna_Zona" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Comuna_Zona" class="control-group">
<span<?php echo $nutricion_valoracion->Comuna_Zona->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Comuna_Zona->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Grupo_Etnico->Visible) { // Grupo_Etnico ?>
	<tr id="r_Grupo_Etnico">
		<td><span id="elh_nutricion_valoracion_Grupo_Etnico"><script id="tpc_nutricion_valoracion_Grupo_Etnico" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Grupo_Etnico->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Grupo_Etnico->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Grupo_Etnico" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Grupo_Etnico" class="control-group">
<span<?php echo $nutricion_valoracion->Grupo_Etnico->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Grupo_Etnico->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Tipo_Regimen->Visible) { // Tipo_Regimen ?>
	<tr id="r_Tipo_Regimen">
		<td><span id="elh_nutricion_valoracion_Tipo_Regimen"><script id="tpc_nutricion_valoracion_Tipo_Regimen" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Tipo_Regimen->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Tipo_Regimen->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Tipo_Regimen" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Tipo_Regimen" class="control-group">
<span<?php echo $nutricion_valoracion->Tipo_Regimen->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Tipo_Regimen->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->EPS->Visible) { // EPS ?>
	<tr id="r_EPS">
		<td><span id="elh_nutricion_valoracion_EPS"><script id="tpc_nutricion_valoracion_EPS" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->EPS->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->EPS->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_EPS" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_EPS" class="control-group">
<span<?php echo $nutricion_valoracion->EPS->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->EPS->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Condicion_Discapacidad->Visible) { // Condicion_Discapacidad ?>
	<tr id="r_Condicion_Discapacidad">
		<td><span id="elh_nutricion_valoracion_Condicion_Discapacidad"><script id="tpc_nutricion_valoracion_Condicion_Discapacidad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Condicion_Discapacidad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Condicion_Discapacidad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Condicion_Discapacidad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Condicion_Discapacidad" class="control-group">
<span<?php echo $nutricion_valoracion->Condicion_Discapacidad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Condicion_Discapacidad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Condicion_Desplazamiento->Visible) { // Condicion_Desplazamiento ?>
	<tr id="r_Condicion_Desplazamiento">
		<td><span id="elh_nutricion_valoracion_Condicion_Desplazamiento"><script id="tpc_nutricion_valoracion_Condicion_Desplazamiento" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Condicion_Desplazamiento->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Condicion_Desplazamiento->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Condicion_Desplazamiento" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Condicion_Desplazamiento" class="control-group">
<span<?php echo $nutricion_valoracion->Condicion_Desplazamiento->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Condicion_Desplazamiento->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Entidad_Educativa->Visible) { // Entidad_Educativa ?>
	<tr id="r_Entidad_Educativa">
		<td><span id="elh_nutricion_valoracion_Entidad_Educativa"><script id="tpc_nutricion_valoracion_Entidad_Educativa" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Entidad_Educativa->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Entidad_Educativa->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Entidad_Educativa" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Entidad_Educativa" class="control-group">
<span<?php echo $nutricion_valoracion->Entidad_Educativa->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Entidad_Educativa->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Escolaridad->Visible) { // Escolaridad ?>
	<tr id="r_Escolaridad">
		<td><span id="elh_nutricion_valoracion_Escolaridad"><script id="tpc_nutricion_valoracion_Escolaridad" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Escolaridad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Escolaridad->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Escolaridad" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Escolaridad" class="control-group">
<span<?php echo $nutricion_valoracion->Escolaridad->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Escolaridad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificado->Visible) { // Clasificado ?>
	<tr id="r_Clasificado">
		<td><span id="elh_nutricion_valoracion_Clasificado"><script id="tpc_nutricion_valoracion_Clasificado" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Clasificado->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Clasificado->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Clasificado" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Clasificado" class="control-group">
<span<?php echo $nutricion_valoracion->Clasificado->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Clasificado->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Usuario->Visible) { // Usuario ?>
	<tr id="r_Usuario">
		<td><span id="elh_nutricion_valoracion_Usuario"><script id="tpc_nutricion_valoracion_Usuario" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Usuario->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Usuario->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Usuario" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Usuario" class="control-group">
<span<?php echo $nutricion_valoracion->Usuario->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Usuario->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Fecha_edicion->Visible) { // Fecha_edicion ?>
	<tr id="r_Fecha_edicion">
		<td><span id="elh_nutricion_valoracion_Fecha_edicion"><script id="tpc_nutricion_valoracion_Fecha_edicion" class="nutricion_valoracionview" type="text/html"><span><?php echo $nutricion_valoracion->Fecha_edicion->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Fecha_edicion->CellAttributes() ?>>
<script id="tpx_nutricion_valoracion_Fecha_edicion" class="nutricion_valoracionview" type="text/html">
<span id="el_nutricion_valoracion_Fecha_edicion" class="control-group">
<span<?php echo $nutricion_valoracion->Fecha_edicion->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Fecha_edicion->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
</form>
<script type="text/javascript">
ew_ApplyTemplate("tpd_nutricion_valoracionview", "tpm_nutricion_valoracionview");
jQuery("script.nutricion_valoracionview_js").each(function(){ew_AddScript(this.text);});
</script>
<script type="text/javascript">
fnutricion_valoracionview.Init();
</script>
<?php
$nutricion_valoracion_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($nutricion_valoracion->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$nutricion_valoracion_view->Page_Terminate();
?>
