<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "assbasaludinfo.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$assbasalud_add = NULL; // Initialize page object first

class cassbasalud_add extends cassbasalud {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{9AEC5002-D3A7-409D-BF52-78D21E1FF26F}";

	// Table name
	var $TableName = 'assbasalud';

	// Page object name
	var $PageObjName = 'assbasalud_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Fotoer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (assbasalud)
		if (!isset($GLOBALS["assbasalud"])) {
			$GLOBALS["assbasalud"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["assbasalud"];
		}

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS['nutricion_usuario'])) $GLOBALS['nutricion_usuario'] = new cnutricion_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'assbasalud', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("assbasaludlist.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["N"] != "") {
				$this->N->setQueryStringValue($_GET["N"]);
				$this->setKey("N", $this->N->CurrentValue); // Set up key
			} else {
				$this->setKey("N", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
				$this->LoadDefaultValues(); // Load default values
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("assbasaludlist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "assbasaludview.php")
						$sReturnUrl = $this->GetViewUrl(); // View paging, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD;  // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
		$index = $objForm->Index; // Save form index
		$objForm->Index = -1;
		$objForm->Index = $index; // Restore form index
	}

	// Load default values
	function LoadDefaultValues() {
		$this->ANO->CurrentValue = NULL;
		$this->ANO->OldValue = $this->ANO->CurrentValue;
		$this->FECHA_VALORACION->CurrentValue = NULL;
		$this->FECHA_VALORACION->OldValue = $this->FECHA_VALORACION->CurrentValue;
		$this->NUMERO_ID->CurrentValue = NULL;
		$this->NUMERO_ID->OldValue = $this->NUMERO_ID->CurrentValue;
		$this->NOMBRES->CurrentValue = NULL;
		$this->NOMBRES->OldValue = $this->NOMBRES->CurrentValue;
		$this->PRIMER_APELLIDO->CurrentValue = NULL;
		$this->PRIMER_APELLIDO->OldValue = $this->PRIMER_APELLIDO->CurrentValue;
		$this->SEGUNDO_APELLIDO->CurrentValue = NULL;
		$this->SEGUNDO_APELLIDO->OldValue = $this->SEGUNDO_APELLIDO->CurrentValue;
		$this->FECHA_NACIMIENTO->CurrentValue = NULL;
		$this->FECHA_NACIMIENTO->OldValue = $this->FECHA_NACIMIENTO->CurrentValue;
		$this->SEXO->CurrentValue = NULL;
		$this->SEXO->OldValue = $this->SEXO->CurrentValue;
		$this->EDAD_EN_MESES->CurrentValue = NULL;
		$this->EDAD_EN_MESES->OldValue = $this->EDAD_EN_MESES->CurrentValue;
		$this->TALLA->CurrentValue = NULL;
		$this->TALLA->OldValue = $this->TALLA->CurrentValue;
		$this->PESO->CurrentValue = NULL;
		$this->PESO->OldValue = $this->PESO->CurrentValue;
		$this->EPS->CurrentValue = NULL;
		$this->EPS->OldValue = $this->EPS->CurrentValue;
		$this->DIRECCION->CurrentValue = NULL;
		$this->DIRECCION->OldValue = $this->DIRECCION->CurrentValue;
		$this->TELEFONO->CurrentValue = NULL;
		$this->TELEFONO->OldValue = $this->TELEFONO->CurrentValue;
		$this->NOMBRE_COMUNA->CurrentValue = NULL;
		$this->NOMBRE_COMUNA->OldValue = $this->NOMBRE_COMUNA->CurrentValue;
		$this->NOMBRE_BARRIO->CurrentValue = NULL;
		$this->NOMBRE_BARRIO->OldValue = $this->NOMBRE_BARRIO->CurrentValue;
		$this->INDICADOR->CurrentValue = NULL;
		$this->INDICADOR->OldValue = $this->INDICADOR->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->ANO->FldIsDetailKey) {
			$this->ANO->setFormValue($objForm->GetValue("x_ANO"));
		}
		if (!$this->FECHA_VALORACION->FldIsDetailKey) {
			$this->FECHA_VALORACION->setFormValue($objForm->GetValue("x_FECHA_VALORACION"));
			$this->FECHA_VALORACION->CurrentValue = ew_UnFormatDateTime($this->FECHA_VALORACION->CurrentValue, 7);
		}
		if (!$this->NUMERO_ID->FldIsDetailKey) {
			$this->NUMERO_ID->setFormValue($objForm->GetValue("x_NUMERO_ID"));
		}
		if (!$this->NOMBRES->FldIsDetailKey) {
			$this->NOMBRES->setFormValue($objForm->GetValue("x_NOMBRES"));
		}
		if (!$this->PRIMER_APELLIDO->FldIsDetailKey) {
			$this->PRIMER_APELLIDO->setFormValue($objForm->GetValue("x_PRIMER_APELLIDO"));
		}
		if (!$this->SEGUNDO_APELLIDO->FldIsDetailKey) {
			$this->SEGUNDO_APELLIDO->setFormValue($objForm->GetValue("x_SEGUNDO_APELLIDO"));
		}
		if (!$this->FECHA_NACIMIENTO->FldIsDetailKey) {
			$this->FECHA_NACIMIENTO->setFormValue($objForm->GetValue("x_FECHA_NACIMIENTO"));
			$this->FECHA_NACIMIENTO->CurrentValue = ew_UnFormatDateTime($this->FECHA_NACIMIENTO->CurrentValue, 7);
		}
		if (!$this->SEXO->FldIsDetailKey) {
			$this->SEXO->setFormValue($objForm->GetValue("x_SEXO"));
		}
		if (!$this->EDAD_EN_MESES->FldIsDetailKey) {
			$this->EDAD_EN_MESES->setFormValue($objForm->GetValue("x_EDAD_EN_MESES"));
		}
		if (!$this->TALLA->FldIsDetailKey) {
			$this->TALLA->setFormValue($objForm->GetValue("x_TALLA"));
		}
		if (!$this->PESO->FldIsDetailKey) {
			$this->PESO->setFormValue($objForm->GetValue("x_PESO"));
		}
		if (!$this->EPS->FldIsDetailKey) {
			$this->EPS->setFormValue($objForm->GetValue("x_EPS"));
		}
		if (!$this->DIRECCION->FldIsDetailKey) {
			$this->DIRECCION->setFormValue($objForm->GetValue("x_DIRECCION"));
		}
		if (!$this->TELEFONO->FldIsDetailKey) {
			$this->TELEFONO->setFormValue($objForm->GetValue("x_TELEFONO"));
		}
		if (!$this->NOMBRE_COMUNA->FldIsDetailKey) {
			$this->NOMBRE_COMUNA->setFormValue($objForm->GetValue("x_NOMBRE_COMUNA"));
		}
		if (!$this->NOMBRE_BARRIO->FldIsDetailKey) {
			$this->NOMBRE_BARRIO->setFormValue($objForm->GetValue("x_NOMBRE_BARRIO"));
		}
		if (!$this->INDICADOR->FldIsDetailKey) {
			$this->INDICADOR->setFormValue($objForm->GetValue("x_INDICADOR"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->ANO->CurrentValue = $this->ANO->FormValue;
		$this->FECHA_VALORACION->CurrentValue = $this->FECHA_VALORACION->FormValue;
		$this->FECHA_VALORACION->CurrentValue = ew_UnFormatDateTime($this->FECHA_VALORACION->CurrentValue, 7);
		$this->NUMERO_ID->CurrentValue = $this->NUMERO_ID->FormValue;
		$this->NOMBRES->CurrentValue = $this->NOMBRES->FormValue;
		$this->PRIMER_APELLIDO->CurrentValue = $this->PRIMER_APELLIDO->FormValue;
		$this->SEGUNDO_APELLIDO->CurrentValue = $this->SEGUNDO_APELLIDO->FormValue;
		$this->FECHA_NACIMIENTO->CurrentValue = $this->FECHA_NACIMIENTO->FormValue;
		$this->FECHA_NACIMIENTO->CurrentValue = ew_UnFormatDateTime($this->FECHA_NACIMIENTO->CurrentValue, 7);
		$this->SEXO->CurrentValue = $this->SEXO->FormValue;
		$this->EDAD_EN_MESES->CurrentValue = $this->EDAD_EN_MESES->FormValue;
		$this->TALLA->CurrentValue = $this->TALLA->FormValue;
		$this->PESO->CurrentValue = $this->PESO->FormValue;
		$this->EPS->CurrentValue = $this->EPS->FormValue;
		$this->DIRECCION->CurrentValue = $this->DIRECCION->FormValue;
		$this->TELEFONO->CurrentValue = $this->TELEFONO->FormValue;
		$this->NOMBRE_COMUNA->CurrentValue = $this->NOMBRE_COMUNA->FormValue;
		$this->NOMBRE_BARRIO->CurrentValue = $this->NOMBRE_BARRIO->FormValue;
		$this->INDICADOR->CurrentValue = $this->INDICADOR->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->N->setDbValue($rs->fields('N'));
		$this->ANO->setDbValue($rs->fields('ANO'));
		$this->FECHA_VALORACION->setDbValue($rs->fields('FECHA_VALORACION'));
		$this->NUMERO_ID->setDbValue($rs->fields('NUMERO_ID'));
		$this->NOMBRES->setDbValue($rs->fields('NOMBRES'));
		$this->PRIMER_APELLIDO->setDbValue($rs->fields('PRIMER_APELLIDO'));
		$this->SEGUNDO_APELLIDO->setDbValue($rs->fields('SEGUNDO_APELLIDO'));
		$this->FECHA_NACIMIENTO->setDbValue($rs->fields('FECHA_NACIMIENTO'));
		$this->SEXO->setDbValue($rs->fields('SEXO'));
		$this->EDAD_EN_MESES->setDbValue($rs->fields('EDAD_EN_MESES'));
		$this->TALLA->setDbValue($rs->fields('TALLA'));
		$this->PESO->setDbValue($rs->fields('PESO'));
		$this->EPS->setDbValue($rs->fields('EPS'));
		$this->DIRECCION->setDbValue($rs->fields('DIRECCION'));
		$this->TELEFONO->setDbValue($rs->fields('TELEFONO'));
		$this->NOMBRE_COMUNA->setDbValue($rs->fields('NOMBRE_COMUNA'));
		$this->NOMBRE_BARRIO->setDbValue($rs->fields('NOMBRE_BARRIO'));
		$this->INDICADOR->setDbValue($rs->fields('INDICADOR'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->N->DbValue = $row['N'];
		$this->ANO->DbValue = $row['ANO'];
		$this->FECHA_VALORACION->DbValue = $row['FECHA_VALORACION'];
		$this->NUMERO_ID->DbValue = $row['NUMERO_ID'];
		$this->NOMBRES->DbValue = $row['NOMBRES'];
		$this->PRIMER_APELLIDO->DbValue = $row['PRIMER_APELLIDO'];
		$this->SEGUNDO_APELLIDO->DbValue = $row['SEGUNDO_APELLIDO'];
		$this->FECHA_NACIMIENTO->DbValue = $row['FECHA_NACIMIENTO'];
		$this->SEXO->DbValue = $row['SEXO'];
		$this->EDAD_EN_MESES->DbValue = $row['EDAD_EN_MESES'];
		$this->TALLA->DbValue = $row['TALLA'];
		$this->PESO->DbValue = $row['PESO'];
		$this->EPS->DbValue = $row['EPS'];
		$this->DIRECCION->DbValue = $row['DIRECCION'];
		$this->TELEFONO->DbValue = $row['TELEFONO'];
		$this->NOMBRE_COMUNA->DbValue = $row['NOMBRE_COMUNA'];
		$this->NOMBRE_BARRIO->DbValue = $row['NOMBRE_BARRIO'];
		$this->INDICADOR->DbValue = $row['INDICADOR'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("N")) <> "")
			$this->N->CurrentValue = $this->getKey("N"); // N
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$this->OldRecordset = ew_LoadRecordset($sSql);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->PESO->FormValue == $this->PESO->CurrentValue && is_numeric(ew_StrToFloat($this->PESO->CurrentValue)))
			$this->PESO->CurrentValue = ew_StrToFloat($this->PESO->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// N
		// ANO
		// FECHA_VALORACION
		// NUMERO_ID
		// NOMBRES
		// PRIMER_APELLIDO
		// SEGUNDO_APELLIDO
		// FECHA_NACIMIENTO
		// SEXO
		// EDAD_EN_MESES
		// TALLA
		// PESO
		// EPS
		// DIRECCION
		// TELEFONO
		// NOMBRE_COMUNA
		// NOMBRE_BARRIO
		// INDICADOR

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// N
			$this->N->ViewValue = $this->N->CurrentValue;
			$this->N->ViewCustomAttributes = "";

			// ANO
			$this->ANO->ViewValue = $this->ANO->CurrentValue;
			$this->ANO->ViewCustomAttributes = "";

			// FECHA_VALORACION
			$this->FECHA_VALORACION->ViewValue = $this->FECHA_VALORACION->CurrentValue;
			$this->FECHA_VALORACION->ViewValue = ew_FormatDateTime($this->FECHA_VALORACION->ViewValue, 7);
			$this->FECHA_VALORACION->ViewCustomAttributes = "";

			// NUMERO_ID
			$this->NUMERO_ID->ViewValue = $this->NUMERO_ID->CurrentValue;
			$this->NUMERO_ID->ViewCustomAttributes = "";

			// NOMBRES
			$this->NOMBRES->ViewValue = $this->NOMBRES->CurrentValue;
			$this->NOMBRES->ViewCustomAttributes = "";

			// PRIMER_APELLIDO
			$this->PRIMER_APELLIDO->ViewValue = $this->PRIMER_APELLIDO->CurrentValue;
			$this->PRIMER_APELLIDO->ViewCustomAttributes = "";

			// SEGUNDO_APELLIDO
			$this->SEGUNDO_APELLIDO->ViewValue = $this->SEGUNDO_APELLIDO->CurrentValue;
			$this->SEGUNDO_APELLIDO->ViewCustomAttributes = "";

			// FECHA_NACIMIENTO
			$this->FECHA_NACIMIENTO->ViewValue = $this->FECHA_NACIMIENTO->CurrentValue;
			$this->FECHA_NACIMIENTO->ViewValue = ew_FormatDateTime($this->FECHA_NACIMIENTO->ViewValue, 7);
			$this->FECHA_NACIMIENTO->ViewCustomAttributes = "";

			// SEXO
			$this->SEXO->ViewValue = $this->SEXO->CurrentValue;
			$this->SEXO->ViewCustomAttributes = "";

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->ViewValue = $this->EDAD_EN_MESES->CurrentValue;
			$this->EDAD_EN_MESES->ViewCustomAttributes = "";

			// TALLA
			$this->TALLA->ViewValue = $this->TALLA->CurrentValue;
			$this->TALLA->CellCssStyle .= "text-align: right;";
			$this->TALLA->ViewCustomAttributes = "";

			// PESO
			$this->PESO->ViewValue = $this->PESO->CurrentValue;
			$this->PESO->CellCssStyle .= "text-align: right;";
			$this->PESO->ViewCustomAttributes = "";

			// EPS
			$this->EPS->ViewValue = $this->EPS->CurrentValue;
			$this->EPS->ViewCustomAttributes = "";

			// DIRECCION
			$this->DIRECCION->ViewValue = $this->DIRECCION->CurrentValue;
			$this->DIRECCION->ViewCustomAttributes = "";

			// TELEFONO
			$this->TELEFONO->ViewValue = $this->TELEFONO->CurrentValue;
			$this->TELEFONO->ViewCustomAttributes = "";

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->ViewValue = $this->NOMBRE_COMUNA->CurrentValue;
			$this->NOMBRE_COMUNA->ViewCustomAttributes = "";

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->ViewValue = $this->NOMBRE_BARRIO->CurrentValue;
			$this->NOMBRE_BARRIO->ViewCustomAttributes = "";

			// INDICADOR
			$this->INDICADOR->ViewValue = $this->INDICADOR->CurrentValue;
			$this->INDICADOR->CellCssStyle .= "text-align: right;";
			$this->INDICADOR->ViewCustomAttributes = "";

			// ANO
			$this->ANO->LinkCustomAttributes = "";
			$this->ANO->HrefValue = "";
			$this->ANO->TooltipValue = "";

			// FECHA_VALORACION
			$this->FECHA_VALORACION->LinkCustomAttributes = "";
			$this->FECHA_VALORACION->HrefValue = "";
			$this->FECHA_VALORACION->TooltipValue = "";

			// NUMERO_ID
			$this->NUMERO_ID->LinkCustomAttributes = "";
			$this->NUMERO_ID->HrefValue = "";
			$this->NUMERO_ID->TooltipValue = "";

			// NOMBRES
			$this->NOMBRES->LinkCustomAttributes = "";
			$this->NOMBRES->HrefValue = "";
			$this->NOMBRES->TooltipValue = "";

			// PRIMER_APELLIDO
			$this->PRIMER_APELLIDO->LinkCustomAttributes = "";
			$this->PRIMER_APELLIDO->HrefValue = "";
			$this->PRIMER_APELLIDO->TooltipValue = "";

			// SEGUNDO_APELLIDO
			$this->SEGUNDO_APELLIDO->LinkCustomAttributes = "";
			$this->SEGUNDO_APELLIDO->HrefValue = "";
			$this->SEGUNDO_APELLIDO->TooltipValue = "";

			// FECHA_NACIMIENTO
			$this->FECHA_NACIMIENTO->LinkCustomAttributes = "";
			$this->FECHA_NACIMIENTO->HrefValue = "";
			$this->FECHA_NACIMIENTO->TooltipValue = "";

			// SEXO
			$this->SEXO->LinkCustomAttributes = "";
			$this->SEXO->HrefValue = "";
			$this->SEXO->TooltipValue = "";

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->LinkCustomAttributes = "";
			$this->EDAD_EN_MESES->HrefValue = "";
			$this->EDAD_EN_MESES->TooltipValue = "";

			// TALLA
			$this->TALLA->LinkCustomAttributes = "";
			$this->TALLA->HrefValue = "";
			$this->TALLA->TooltipValue = "";

			// PESO
			$this->PESO->LinkCustomAttributes = "";
			$this->PESO->HrefValue = "";
			$this->PESO->TooltipValue = "";

			// EPS
			$this->EPS->LinkCustomAttributes = "";
			$this->EPS->HrefValue = "";
			$this->EPS->TooltipValue = "";

			// DIRECCION
			$this->DIRECCION->LinkCustomAttributes = "";
			$this->DIRECCION->HrefValue = "";
			$this->DIRECCION->TooltipValue = "";

			// TELEFONO
			$this->TELEFONO->LinkCustomAttributes = "";
			$this->TELEFONO->HrefValue = "";
			$this->TELEFONO->TooltipValue = "";

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->LinkCustomAttributes = "";
			$this->NOMBRE_COMUNA->HrefValue = "";
			$this->NOMBRE_COMUNA->TooltipValue = "";

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->LinkCustomAttributes = "";
			$this->NOMBRE_BARRIO->HrefValue = "";
			$this->NOMBRE_BARRIO->TooltipValue = "";

			// INDICADOR
			$this->INDICADOR->LinkCustomAttributes = "";
			$this->INDICADOR->HrefValue = "";
			$this->INDICADOR->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// ANO
			$this->ANO->EditCustomAttributes = "";
			$this->ANO->EditValue = ew_HtmlEncode($this->ANO->CurrentValue);
			$this->ANO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->ANO->FldCaption()));

			// FECHA_VALORACION
			$this->FECHA_VALORACION->EditCustomAttributes = "";
			$this->FECHA_VALORACION->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->FECHA_VALORACION->CurrentValue, 7));
			$this->FECHA_VALORACION->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->FECHA_VALORACION->FldCaption()));

			// NUMERO_ID
			$this->NUMERO_ID->EditCustomAttributes = "";
			$this->NUMERO_ID->EditValue = ew_HtmlEncode($this->NUMERO_ID->CurrentValue);
			$this->NUMERO_ID->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->NUMERO_ID->FldCaption()));

			// NOMBRES
			$this->NOMBRES->EditCustomAttributes = "";
			$this->NOMBRES->EditValue = ew_HtmlEncode($this->NOMBRES->CurrentValue);
			$this->NOMBRES->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->NOMBRES->FldCaption()));

			// PRIMER_APELLIDO
			$this->PRIMER_APELLIDO->EditCustomAttributes = "";
			$this->PRIMER_APELLIDO->EditValue = ew_HtmlEncode($this->PRIMER_APELLIDO->CurrentValue);
			$this->PRIMER_APELLIDO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->PRIMER_APELLIDO->FldCaption()));

			// SEGUNDO_APELLIDO
			$this->SEGUNDO_APELLIDO->EditCustomAttributes = "";
			$this->SEGUNDO_APELLIDO->EditValue = ew_HtmlEncode($this->SEGUNDO_APELLIDO->CurrentValue);
			$this->SEGUNDO_APELLIDO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->SEGUNDO_APELLIDO->FldCaption()));

			// FECHA_NACIMIENTO
			$this->FECHA_NACIMIENTO->EditCustomAttributes = "";
			$this->FECHA_NACIMIENTO->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->FECHA_NACIMIENTO->CurrentValue, 7));
			$this->FECHA_NACIMIENTO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->FECHA_NACIMIENTO->FldCaption()));

			// SEXO
			$this->SEXO->EditCustomAttributes = "";
			$this->SEXO->EditValue = ew_HtmlEncode($this->SEXO->CurrentValue);
			$this->SEXO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->SEXO->FldCaption()));

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->EditCustomAttributes = "";
			$this->EDAD_EN_MESES->EditValue = ew_HtmlEncode($this->EDAD_EN_MESES->CurrentValue);
			$this->EDAD_EN_MESES->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->EDAD_EN_MESES->FldCaption()));

			// TALLA
			$this->TALLA->EditCustomAttributes = "";
			$this->TALLA->EditValue = ew_HtmlEncode($this->TALLA->CurrentValue);
			$this->TALLA->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->TALLA->FldCaption()));

			// PESO
			$this->PESO->EditCustomAttributes = "";
			$this->PESO->EditValue = ew_HtmlEncode($this->PESO->CurrentValue);
			$this->PESO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->PESO->FldCaption()));
			if (strval($this->PESO->EditValue) <> "" && is_numeric($this->PESO->EditValue)) $this->PESO->EditValue = ew_FormatNumber($this->PESO->EditValue, -2, -1, -2, 0);

			// EPS
			$this->EPS->EditCustomAttributes = "";
			$this->EPS->EditValue = ew_HtmlEncode($this->EPS->CurrentValue);
			$this->EPS->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->EPS->FldCaption()));

			// DIRECCION
			$this->DIRECCION->EditCustomAttributes = "";
			$this->DIRECCION->EditValue = ew_HtmlEncode($this->DIRECCION->CurrentValue);
			$this->DIRECCION->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->DIRECCION->FldCaption()));

			// TELEFONO
			$this->TELEFONO->EditCustomAttributes = "";
			$this->TELEFONO->EditValue = ew_HtmlEncode($this->TELEFONO->CurrentValue);
			$this->TELEFONO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->TELEFONO->FldCaption()));

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->EditCustomAttributes = "";
			$this->NOMBRE_COMUNA->EditValue = ew_HtmlEncode($this->NOMBRE_COMUNA->CurrentValue);
			$this->NOMBRE_COMUNA->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->NOMBRE_COMUNA->FldCaption()));

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->EditCustomAttributes = "";
			$this->NOMBRE_BARRIO->EditValue = ew_HtmlEncode($this->NOMBRE_BARRIO->CurrentValue);
			$this->NOMBRE_BARRIO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->NOMBRE_BARRIO->FldCaption()));

			// INDICADOR
			$this->INDICADOR->EditCustomAttributes = "";
			$this->INDICADOR->EditValue = ew_HtmlEncode($this->INDICADOR->CurrentValue);
			$this->INDICADOR->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->INDICADOR->FldCaption()));

			// Edit refer script
			// ANO

			$this->ANO->HrefValue = "";

			// FECHA_VALORACION
			$this->FECHA_VALORACION->HrefValue = "";

			// NUMERO_ID
			$this->NUMERO_ID->HrefValue = "";

			// NOMBRES
			$this->NOMBRES->HrefValue = "";

			// PRIMER_APELLIDO
			$this->PRIMER_APELLIDO->HrefValue = "";

			// SEGUNDO_APELLIDO
			$this->SEGUNDO_APELLIDO->HrefValue = "";

			// FECHA_NACIMIENTO
			$this->FECHA_NACIMIENTO->HrefValue = "";

			// SEXO
			$this->SEXO->HrefValue = "";

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->HrefValue = "";

			// TALLA
			$this->TALLA->HrefValue = "";

			// PESO
			$this->PESO->HrefValue = "";

			// EPS
			$this->EPS->HrefValue = "";

			// DIRECCION
			$this->DIRECCION->HrefValue = "";

			// TELEFONO
			$this->TELEFONO->HrefValue = "";

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->HrefValue = "";

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->HrefValue = "";

			// INDICADOR
			$this->INDICADOR->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckInteger($this->ANO->FormValue)) {
			ew_AddMessage($gsFormError, $this->ANO->FldErrMsg());
		}
		if (!ew_CheckEuroDate($this->FECHA_VALORACION->FormValue)) {
			ew_AddMessage($gsFormError, $this->FECHA_VALORACION->FldErrMsg());
		}
		if (!ew_CheckInteger($this->NUMERO_ID->FormValue)) {
			ew_AddMessage($gsFormError, $this->NUMERO_ID->FldErrMsg());
		}
		if (!ew_CheckEuroDate($this->FECHA_NACIMIENTO->FormValue)) {
			ew_AddMessage($gsFormError, $this->FECHA_NACIMIENTO->FldErrMsg());
		}
		if (!ew_CheckInteger($this->EDAD_EN_MESES->FormValue)) {
			ew_AddMessage($gsFormError, $this->EDAD_EN_MESES->FldErrMsg());
		}
		if (!ew_CheckInteger($this->TALLA->FormValue)) {
			ew_AddMessage($gsFormError, $this->TALLA->FldErrMsg());
		}
		if (!ew_CheckNumber($this->PESO->FormValue)) {
			ew_AddMessage($gsFormError, $this->PESO->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $conn, $Language, $Security;

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
		}
		$rsnew = array();

		// ANO
		$this->ANO->SetDbValueDef($rsnew, $this->ANO->CurrentValue, NULL, FALSE);

		// FECHA_VALORACION
		$this->FECHA_VALORACION->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->FECHA_VALORACION->CurrentValue, 7), NULL, FALSE);

		// NUMERO_ID
		$this->NUMERO_ID->SetDbValueDef($rsnew, $this->NUMERO_ID->CurrentValue, NULL, FALSE);

		// NOMBRES
		$this->NOMBRES->SetDbValueDef($rsnew, $this->NOMBRES->CurrentValue, NULL, FALSE);

		// PRIMER_APELLIDO
		$this->PRIMER_APELLIDO->SetDbValueDef($rsnew, $this->PRIMER_APELLIDO->CurrentValue, NULL, FALSE);

		// SEGUNDO_APELLIDO
		$this->SEGUNDO_APELLIDO->SetDbValueDef($rsnew, $this->SEGUNDO_APELLIDO->CurrentValue, NULL, FALSE);

		// FECHA_NACIMIENTO
		$this->FECHA_NACIMIENTO->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->FECHA_NACIMIENTO->CurrentValue, 7), NULL, FALSE);

		// SEXO
		$this->SEXO->SetDbValueDef($rsnew, $this->SEXO->CurrentValue, NULL, FALSE);

		// EDAD_EN_MESES
		$this->EDAD_EN_MESES->SetDbValueDef($rsnew, $this->EDAD_EN_MESES->CurrentValue, NULL, FALSE);

		// TALLA
		$this->TALLA->SetDbValueDef($rsnew, $this->TALLA->CurrentValue, NULL, FALSE);

		// PESO
		$this->PESO->SetDbValueDef($rsnew, $this->PESO->CurrentValue, NULL, FALSE);

		// EPS
		$this->EPS->SetDbValueDef($rsnew, $this->EPS->CurrentValue, NULL, FALSE);

		// DIRECCION
		$this->DIRECCION->SetDbValueDef($rsnew, $this->DIRECCION->CurrentValue, NULL, FALSE);

		// TELEFONO
		$this->TELEFONO->SetDbValueDef($rsnew, $this->TELEFONO->CurrentValue, NULL, FALSE);

		// NOMBRE_COMUNA
		$this->NOMBRE_COMUNA->SetDbValueDef($rsnew, $this->NOMBRE_COMUNA->CurrentValue, NULL, FALSE);

		// NOMBRE_BARRIO
		$this->NOMBRE_BARRIO->SetDbValueDef($rsnew, $this->NOMBRE_BARRIO->CurrentValue, NULL, FALSE);

		// INDICADOR
		$this->INDICADOR->SetDbValueDef($rsnew, $this->INDICADOR->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}

		// Get insert id if necessary
		if ($AddRow) {
			$this->N->setDbValue($conn->Insert_ID());
			$rsnew['N'] = $this->N->DbValue;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "assbasaludlist.php", $this->TableVar);
		$PageCaption = ($this->CurrentAction == "C") ? $Language->Phrase("Copy") : $Language->Phrase("Add");
		$Breadcrumb->Add("add", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($assbasalud_add)) $assbasalud_add = new cassbasalud_add();

// Page init
$assbasalud_add->Page_Init();

// Page main
$assbasalud_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$assbasalud_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var assbasalud_add = new ew_Page("assbasalud_add");
assbasalud_add.PageID = "add"; // Page ID
var EW_PAGE_ID = assbasalud_add.PageID; // For backward compatibility

// Form object
var fassbasaludadd = new ew_Form("fassbasaludadd");

// Validate form
fassbasaludadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, aelm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = fobj.elements["x" + infix + "_ANO"];
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($assbasalud->ANO->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_FECHA_VALORACION"];
			if (elm && !ew_CheckEuroDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($assbasalud->FECHA_VALORACION->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_NUMERO_ID"];
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($assbasalud->NUMERO_ID->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_FECHA_NACIMIENTO"];
			if (elm && !ew_CheckEuroDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($assbasalud->FECHA_NACIMIENTO->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_EDAD_EN_MESES"];
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($assbasalud->EDAD_EN_MESES->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_TALLA"];
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($assbasalud->TALLA->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_PESO"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($assbasalud->PESO->FldErrMsg()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fassbasaludadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fassbasaludadd.ValidateRequired = true;
<?php } else { ?>
fassbasaludadd.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<?php $assbasalud_add->ShowPageHeader(); ?>
<?php
$assbasalud_add->ShowMessage();
?>
<form name="fassbasaludadd" id="fassbasaludadd" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="assbasalud">
<input type="hidden" name="a_add" id="a_add" value="A">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_assbasaludadd" class="table table-bordered table-striped">
<?php if ($assbasalud->ANO->Visible) { // ANO ?>
	<tr id="r_ANO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_ANO"><?php echo $assbasalud->ANO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->ANO->CellAttributes() ?>><span id="el_assbasalud_ANO" class="control-group">
<input type="text" class="x_ANO" name="x_ANO" id="x_ANO" size="30" placeholder="<?php echo $assbasalud->ANO->PlaceHolder ?>" value="<?php echo $assbasalud->ANO->EditValue ?>"<?php echo $assbasalud->ANO->EditAttributes() ?>>
</span><?php echo $assbasalud->ANO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->FECHA_VALORACION->Visible) { // FECHA_VALORACION ?>
	<tr id="r_FECHA_VALORACION"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_FECHA_VALORACION"><?php echo $assbasalud->FECHA_VALORACION->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->FECHA_VALORACION->CellAttributes() ?>><span id="el_assbasalud_FECHA_VALORACION" class="control-group">
<input type="text" class="x_FECHA_VALORACION" name="x_FECHA_VALORACION" id="x_FECHA_VALORACION" size="30" maxlength="10" placeholder="<?php echo $assbasalud->FECHA_VALORACION->PlaceHolder ?>" value="<?php echo $assbasalud->FECHA_VALORACION->EditValue ?>"<?php echo $assbasalud->FECHA_VALORACION->EditAttributes() ?>>
</span><?php echo $assbasalud->FECHA_VALORACION->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NUMERO_ID->Visible) { // NUMERO_ID ?>
	<tr id="r_NUMERO_ID"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NUMERO_ID"><?php echo $assbasalud->NUMERO_ID->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NUMERO_ID->CellAttributes() ?>><span id="el_assbasalud_NUMERO_ID" class="control-group">
<input type="text" class="x_NUMERO_ID" name="x_NUMERO_ID" id="x_NUMERO_ID" size="30" maxlength="13" placeholder="<?php echo $assbasalud->NUMERO_ID->PlaceHolder ?>" value="<?php echo $assbasalud->NUMERO_ID->EditValue ?>"<?php echo $assbasalud->NUMERO_ID->EditAttributes() ?>>
</span><?php echo $assbasalud->NUMERO_ID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NOMBRES->Visible) { // NOMBRES ?>
	<tr id="r_NOMBRES"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NOMBRES"><?php echo $assbasalud->NOMBRES->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NOMBRES->CellAttributes() ?>><span id="el_assbasalud_NOMBRES" class="control-group">
<input type="text" class="x_NOMBRES" name="x_NOMBRES" id="x_NOMBRES" size="30" maxlength="100" placeholder="<?php echo $assbasalud->NOMBRES->PlaceHolder ?>" value="<?php echo $assbasalud->NOMBRES->EditValue ?>"<?php echo $assbasalud->NOMBRES->EditAttributes() ?>>
</span><?php echo $assbasalud->NOMBRES->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->PRIMER_APELLIDO->Visible) { // PRIMER_APELLIDO ?>
	<tr id="r_PRIMER_APELLIDO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_PRIMER_APELLIDO"><?php echo $assbasalud->PRIMER_APELLIDO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->PRIMER_APELLIDO->CellAttributes() ?>><span id="el_assbasalud_PRIMER_APELLIDO" class="control-group">
<input type="text" class="x_PRIMER_APELLIDO" name="x_PRIMER_APELLIDO" id="x_PRIMER_APELLIDO" size="30" maxlength="100" placeholder="<?php echo $assbasalud->PRIMER_APELLIDO->PlaceHolder ?>" value="<?php echo $assbasalud->PRIMER_APELLIDO->EditValue ?>"<?php echo $assbasalud->PRIMER_APELLIDO->EditAttributes() ?>>
</span><?php echo $assbasalud->PRIMER_APELLIDO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->SEGUNDO_APELLIDO->Visible) { // SEGUNDO_APELLIDO ?>
	<tr id="r_SEGUNDO_APELLIDO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_SEGUNDO_APELLIDO"><?php echo $assbasalud->SEGUNDO_APELLIDO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->SEGUNDO_APELLIDO->CellAttributes() ?>><span id="el_assbasalud_SEGUNDO_APELLIDO" class="control-group">
<input type="text" class="x_SEGUNDO_APELLIDO" name="x_SEGUNDO_APELLIDO" id="x_SEGUNDO_APELLIDO" size="30" maxlength="100" placeholder="<?php echo $assbasalud->SEGUNDO_APELLIDO->PlaceHolder ?>" value="<?php echo $assbasalud->SEGUNDO_APELLIDO->EditValue ?>"<?php echo $assbasalud->SEGUNDO_APELLIDO->EditAttributes() ?>>
</span><?php echo $assbasalud->SEGUNDO_APELLIDO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->FECHA_NACIMIENTO->Visible) { // FECHA_NACIMIENTO ?>
	<tr id="r_FECHA_NACIMIENTO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_FECHA_NACIMIENTO"><?php echo $assbasalud->FECHA_NACIMIENTO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->FECHA_NACIMIENTO->CellAttributes() ?>><span id="el_assbasalud_FECHA_NACIMIENTO" class="control-group">
<input type="text" class="x_FECHA_NACIMIENTO" name="x_FECHA_NACIMIENTO" id="x_FECHA_NACIMIENTO" placeholder="<?php echo $assbasalud->FECHA_NACIMIENTO->PlaceHolder ?>" value="<?php echo $assbasalud->FECHA_NACIMIENTO->EditValue ?>"<?php echo $assbasalud->FECHA_NACIMIENTO->EditAttributes() ?>>
</span><?php echo $assbasalud->FECHA_NACIMIENTO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->SEXO->Visible) { // SEXO ?>
	<tr id="r_SEXO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_SEXO"><?php echo $assbasalud->SEXO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->SEXO->CellAttributes() ?>><span id="el_assbasalud_SEXO" class="control-group">
<input type="text" class="x_SEXO" name="x_SEXO" id="x_SEXO" size="30" maxlength="1" placeholder="<?php echo $assbasalud->SEXO->PlaceHolder ?>" value="<?php echo $assbasalud->SEXO->EditValue ?>"<?php echo $assbasalud->SEXO->EditAttributes() ?>>
</span><?php echo $assbasalud->SEXO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->EDAD_EN_MESES->Visible) { // EDAD_EN_MESES ?>
	<tr id="r_EDAD_EN_MESES"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_EDAD_EN_MESES"><?php echo $assbasalud->EDAD_EN_MESES->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->EDAD_EN_MESES->CellAttributes() ?>><span id="el_assbasalud_EDAD_EN_MESES" class="control-group">
<input type="text" class="x_EDAD_EN_MESES" name="x_EDAD_EN_MESES" id="x_EDAD_EN_MESES" size="30" placeholder="<?php echo $assbasalud->EDAD_EN_MESES->PlaceHolder ?>" value="<?php echo $assbasalud->EDAD_EN_MESES->EditValue ?>"<?php echo $assbasalud->EDAD_EN_MESES->EditAttributes() ?>>
</span><?php echo $assbasalud->EDAD_EN_MESES->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->TALLA->Visible) { // TALLA ?>
	<tr id="r_TALLA"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_TALLA"><?php echo $assbasalud->TALLA->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->TALLA->CellAttributes() ?>><span id="el_assbasalud_TALLA" class="control-group">
<input type="text" class="x_TALLA" name="x_TALLA" id="x_TALLA" size="30" placeholder="<?php echo $assbasalud->TALLA->PlaceHolder ?>" value="<?php echo $assbasalud->TALLA->EditValue ?>"<?php echo $assbasalud->TALLA->EditAttributes() ?>>
</span><?php echo $assbasalud->TALLA->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->PESO->Visible) { // PESO ?>
	<tr id="r_PESO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_PESO"><?php echo $assbasalud->PESO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->PESO->CellAttributes() ?>><span id="el_assbasalud_PESO" class="control-group">
<input type="text" class="x_PESO" name="x_PESO" id="x_PESO" size="30" placeholder="<?php echo $assbasalud->PESO->PlaceHolder ?>" value="<?php echo $assbasalud->PESO->EditValue ?>"<?php echo $assbasalud->PESO->EditAttributes() ?>>
</span><?php echo $assbasalud->PESO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->EPS->Visible) { // EPS ?>
	<tr id="r_EPS"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_EPS"><?php echo $assbasalud->EPS->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->EPS->CellAttributes() ?>><span id="el_assbasalud_EPS" class="control-group">
<input type="text" class="x_EPS" name="x_EPS" id="x_EPS" size="30" maxlength="6" placeholder="<?php echo $assbasalud->EPS->PlaceHolder ?>" value="<?php echo $assbasalud->EPS->EditValue ?>"<?php echo $assbasalud->EPS->EditAttributes() ?>>
</span><?php echo $assbasalud->EPS->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->DIRECCION->Visible) { // DIRECCION ?>
	<tr id="r_DIRECCION"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_DIRECCION"><?php echo $assbasalud->DIRECCION->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->DIRECCION->CellAttributes() ?>><span id="el_assbasalud_DIRECCION" class="control-group">
<input type="text" class="x_DIRECCION" name="x_DIRECCION" id="x_DIRECCION" size="30" maxlength="118" placeholder="<?php echo $assbasalud->DIRECCION->PlaceHolder ?>" value="<?php echo $assbasalud->DIRECCION->EditValue ?>"<?php echo $assbasalud->DIRECCION->EditAttributes() ?>>
</span><?php echo $assbasalud->DIRECCION->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->TELEFONO->Visible) { // TELEFONO ?>
	<tr id="r_TELEFONO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_TELEFONO"><?php echo $assbasalud->TELEFONO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->TELEFONO->CellAttributes() ?>><span id="el_assbasalud_TELEFONO" class="control-group">
<input type="text" class="x_TELEFONO" name="x_TELEFONO" id="x_TELEFONO" size="30" maxlength="36" placeholder="<?php echo $assbasalud->TELEFONO->PlaceHolder ?>" value="<?php echo $assbasalud->TELEFONO->EditValue ?>"<?php echo $assbasalud->TELEFONO->EditAttributes() ?>>
</span><?php echo $assbasalud->TELEFONO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NOMBRE_COMUNA->Visible) { // NOMBRE_COMUNA ?>
	<tr id="r_NOMBRE_COMUNA"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NOMBRE_COMUNA"><?php echo $assbasalud->NOMBRE_COMUNA->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NOMBRE_COMUNA->CellAttributes() ?>><span id="el_assbasalud_NOMBRE_COMUNA" class="control-group">
<input type="text" class="x_NOMBRE_COMUNA" name="x_NOMBRE_COMUNA" id="x_NOMBRE_COMUNA" size="30" maxlength="19" placeholder="<?php echo $assbasalud->NOMBRE_COMUNA->PlaceHolder ?>" value="<?php echo $assbasalud->NOMBRE_COMUNA->EditValue ?>"<?php echo $assbasalud->NOMBRE_COMUNA->EditAttributes() ?>>
</span><?php echo $assbasalud->NOMBRE_COMUNA->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NOMBRE_BARRIO->Visible) { // NOMBRE_BARRIO ?>
	<tr id="r_NOMBRE_BARRIO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NOMBRE_BARRIO"><?php echo $assbasalud->NOMBRE_BARRIO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NOMBRE_BARRIO->CellAttributes() ?>><span id="el_assbasalud_NOMBRE_BARRIO" class="control-group">
<input type="text" class="x_NOMBRE_BARRIO" name="x_NOMBRE_BARRIO" id="x_NOMBRE_BARRIO" size="30" maxlength="30" placeholder="<?php echo $assbasalud->NOMBRE_BARRIO->PlaceHolder ?>" value="<?php echo $assbasalud->NOMBRE_BARRIO->EditValue ?>"<?php echo $assbasalud->NOMBRE_BARRIO->EditAttributes() ?>>
</span><?php echo $assbasalud->NOMBRE_BARRIO->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->INDICADOR->Visible) { // INDICADOR ?>
	<tr id="r_INDICADOR"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_INDICADOR"><?php echo $assbasalud->INDICADOR->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->INDICADOR->CellAttributes() ?>><span id="el_assbasalud_INDICADOR" class="control-group">
<input type="text" class="x_INDICADOR" name="x_INDICADOR" id="x_INDICADOR" size="30" maxlength="17" placeholder="<?php echo $assbasalud->INDICADOR->PlaceHolder ?>" value="<?php echo $assbasalud->INDICADOR->EditValue ?>"<?php echo $assbasalud->INDICADOR->EditAttributes() ?>>
</span><?php echo $assbasalud->INDICADOR->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
</form>
<script type="text/javascript">
fassbasaludadd.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php
$assbasalud_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$assbasalud_add->Page_Terminate();
?>
