<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "assbasaludinfo.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$assbasalud_list = NULL; // Initialize page object first

class cassbasalud_list extends cassbasalud {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{9AEC5002-D3A7-409D-BF52-78D21E1FF26F}";

	// Table name
	var $TableName = 'assbasalud';

	// Page object name
	var $PageObjName = 'assbasalud_list';

	// Grid form hidden field names
	var $FormName = 'fassbasaludlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Fotoer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (assbasalud)
		if (!isset($GLOBALS["assbasalud"])) {
			$GLOBALS["assbasalud"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["assbasalud"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "assbasaludadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "assbasaluddelete.php";
		$this->MultiUpdateUrl = "assbasaludupdate.php";

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS['nutricion_usuario'])) $GLOBALS['nutricion_usuario'] = new cnutricion_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'assbasalud', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "span";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "span";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "span";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "span";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("login.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();

		// Get export parameters
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();

		// Setup other options
		$this->SetupOtherOptions();
		$this->N->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Update url if printer friendly for Pdf
		if ($this->PrinterFriendlyForPdf)
			$this->ExportOptions->Items["pdf"]->Body = str_replace($this->ExportPdfUrl, $this->ExportPrintUrl . "&pdf=1", $this->ExportOptions->Items["pdf"]->Body);
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();
		if ($this->Export == "print" && @$_GET["pdf"] == "1") { // Printer friendly version and with pdf=1 in URL parameters
			$pdf = new cExportPdf($GLOBALS["Table"]);
			$pdf->Text = ob_get_contents(); // Set the content as the HTML of current page (printer friendly version)
			ob_end_clean();
			$pdf->Export();
		}

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 10;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process custom action first
			$this->ProcessCustomAction();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "")
				$this->ListOptions->HideAllOptions(array("sequence"));
			elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit")
				$this->ListOptions->HideAllOptions();

			// Hide export options
			if ($this->Export <> "" || $this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit")
				$this->ExportOptions->HideAllOptions();

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset
			if ($this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall")
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 10; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Export data only
		if (in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue("k_key"));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue("k_key"));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->N->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->N->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere() {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->N, FALSE); // N
		$this->BuildSearchSql($sWhere, $this->ANO, FALSE); // ANO
		$this->BuildSearchSql($sWhere, $this->FECHA_VALORACION, FALSE); // FECHA_VALORACION
		$this->BuildSearchSql($sWhere, $this->NUMERO_ID, FALSE); // NUMERO_ID
		$this->BuildSearchSql($sWhere, $this->NOMBRES, FALSE); // NOMBRES
		$this->BuildSearchSql($sWhere, $this->PRIMER_APELLIDO, FALSE); // PRIMER_APELLIDO
		$this->BuildSearchSql($sWhere, $this->SEGUNDO_APELLIDO, FALSE); // SEGUNDO_APELLIDO
		$this->BuildSearchSql($sWhere, $this->FECHA_NACIMIENTO, FALSE); // FECHA_NACIMIENTO
		$this->BuildSearchSql($sWhere, $this->SEXO, FALSE); // SEXO
		$this->BuildSearchSql($sWhere, $this->EDAD_EN_MESES, FALSE); // EDAD_EN_MESES
		$this->BuildSearchSql($sWhere, $this->TALLA, FALSE); // TALLA
		$this->BuildSearchSql($sWhere, $this->PESO, FALSE); // PESO
		$this->BuildSearchSql($sWhere, $this->EPS, FALSE); // EPS
		$this->BuildSearchSql($sWhere, $this->DIRECCION, FALSE); // DIRECCION
		$this->BuildSearchSql($sWhere, $this->TELEFONO, FALSE); // TELEFONO
		$this->BuildSearchSql($sWhere, $this->NOMBRE_COMUNA, FALSE); // NOMBRE_COMUNA
		$this->BuildSearchSql($sWhere, $this->NOMBRE_BARRIO, FALSE); // NOMBRE_BARRIO
		$this->BuildSearchSql($sWhere, $this->INDICADOR, FALSE); // INDICADOR

		// Set up search parm
		if ($sWhere <> "") {
			$this->Command = "search";
		}
		if ($this->Command == "search") {
			$this->N->AdvancedSearch->Save(); // N
			$this->ANO->AdvancedSearch->Save(); // ANO
			$this->FECHA_VALORACION->AdvancedSearch->Save(); // FECHA_VALORACION
			$this->NUMERO_ID->AdvancedSearch->Save(); // NUMERO_ID
			$this->NOMBRES->AdvancedSearch->Save(); // NOMBRES
			$this->PRIMER_APELLIDO->AdvancedSearch->Save(); // PRIMER_APELLIDO
			$this->SEGUNDO_APELLIDO->AdvancedSearch->Save(); // SEGUNDO_APELLIDO
			$this->FECHA_NACIMIENTO->AdvancedSearch->Save(); // FECHA_NACIMIENTO
			$this->SEXO->AdvancedSearch->Save(); // SEXO
			$this->EDAD_EN_MESES->AdvancedSearch->Save(); // EDAD_EN_MESES
			$this->TALLA->AdvancedSearch->Save(); // TALLA
			$this->PESO->AdvancedSearch->Save(); // PESO
			$this->EPS->AdvancedSearch->Save(); // EPS
			$this->DIRECCION->AdvancedSearch->Save(); // DIRECCION
			$this->TELEFONO->AdvancedSearch->Save(); // TELEFONO
			$this->NOMBRE_COMUNA->AdvancedSearch->Save(); // NOMBRE_COMUNA
			$this->NOMBRE_BARRIO->AdvancedSearch->Save(); // NOMBRE_BARRIO
			$this->INDICADOR->AdvancedSearch->Save(); // INDICADOR
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $MultiValue) {
		$FldParm = substr($Fld->FldVar, 2);
		$FldVal = $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";

		//$FldVal = ew_StripSlashes($FldVal);
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);

		//$FldVal2 = ew_StripSlashes($FldVal2);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1 || $FldOpr <> "LIKE" ||
			($FldOpr2 <> "LIKE" && $FldVal2 <> ""))
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($Keyword) {
		$sKeyword = ew_AdjustSql($Keyword);
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->FECHA_VALORACION, $Keyword);
		if (is_numeric($Keyword)) $this->BuildBasicSearchSQL($sWhere, $this->NUMERO_ID, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->NOMBRES, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->PRIMER_APELLIDO, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->SEGUNDO_APELLIDO, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->SEXO, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->EPS, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->DIRECCION, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->TELEFONO, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->NOMBRE_COMUNA, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->NOMBRE_BARRIO, $Keyword);
		$this->BuildBasicSearchSQL($sWhere, $this->INDICADOR, $Keyword);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $Keyword) {
		if ($Keyword == EW_NULL_VALUE) {
			$sWrk = $Fld->FldExpression . " IS NULL";
		} elseif ($Keyword == EW_NOT_NULL_VALUE) {
			$sWrk = $Fld->FldExpression . " IS NOT NULL";
		} else {
			$sFldExpression = ($Fld->FldVirtualExpression <> $Fld->FldExpression) ? $Fld->FldVirtualExpression : $Fld->FldBasicSearchExpression;
			$sWrk = $sFldExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING));
		}
		if ($Where <> "") $Where .= " OR ";
		$Where .= $sWrk;
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere() {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = $this->BasicSearch->Keyword;
		$sSearchType = $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				while (strpos($sSearch, "  ") !== FALSE)
					$sSearch = str_replace("  ", " ", $sSearch);
				$arKeyword = explode(" ", trim($sSearch));
				foreach ($arKeyword as $sKeyword) {
					if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
					$sSearchStr .= "(" . $this->BasicSearchSQL($sKeyword) . ")";
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($sSearch);
			}
			$this->Command = "search";
		}
		if ($this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->N->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ANO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->FECHA_VALORACION->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->NUMERO_ID->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->NOMBRES->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->PRIMER_APELLIDO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->SEGUNDO_APELLIDO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->FECHA_NACIMIENTO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->SEXO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->EDAD_EN_MESES->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->TALLA->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->PESO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->EPS->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->DIRECCION->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->TELEFONO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->NOMBRE_COMUNA->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->NOMBRE_BARRIO->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->INDICADOR->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->N->AdvancedSearch->UnsetSession();
		$this->ANO->AdvancedSearch->UnsetSession();
		$this->FECHA_VALORACION->AdvancedSearch->UnsetSession();
		$this->NUMERO_ID->AdvancedSearch->UnsetSession();
		$this->NOMBRES->AdvancedSearch->UnsetSession();
		$this->PRIMER_APELLIDO->AdvancedSearch->UnsetSession();
		$this->SEGUNDO_APELLIDO->AdvancedSearch->UnsetSession();
		$this->FECHA_NACIMIENTO->AdvancedSearch->UnsetSession();
		$this->SEXO->AdvancedSearch->UnsetSession();
		$this->EDAD_EN_MESES->AdvancedSearch->UnsetSession();
		$this->TALLA->AdvancedSearch->UnsetSession();
		$this->PESO->AdvancedSearch->UnsetSession();
		$this->EPS->AdvancedSearch->UnsetSession();
		$this->DIRECCION->AdvancedSearch->UnsetSession();
		$this->TELEFONO->AdvancedSearch->UnsetSession();
		$this->NOMBRE_COMUNA->AdvancedSearch->UnsetSession();
		$this->NOMBRE_BARRIO->AdvancedSearch->UnsetSession();
		$this->INDICADOR->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->N->AdvancedSearch->Load();
		$this->ANO->AdvancedSearch->Load();
		$this->FECHA_VALORACION->AdvancedSearch->Load();
		$this->NUMERO_ID->AdvancedSearch->Load();
		$this->NOMBRES->AdvancedSearch->Load();
		$this->PRIMER_APELLIDO->AdvancedSearch->Load();
		$this->SEGUNDO_APELLIDO->AdvancedSearch->Load();
		$this->FECHA_NACIMIENTO->AdvancedSearch->Load();
		$this->SEXO->AdvancedSearch->Load();
		$this->EDAD_EN_MESES->AdvancedSearch->Load();
		$this->TALLA->AdvancedSearch->Load();
		$this->PESO->AdvancedSearch->Load();
		$this->EPS->AdvancedSearch->Load();
		$this->DIRECCION->AdvancedSearch->Load();
		$this->TELEFONO->AdvancedSearch->Load();
		$this->NOMBRE_COMUNA->AdvancedSearch->Load();
		$this->NOMBRE_BARRIO->AdvancedSearch->Load();
		$this->INDICADOR->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->N); // N
			$this->UpdateSort($this->ANO); // ANO
			$this->UpdateSort($this->FECHA_VALORACION); // FECHA_VALORACION
			$this->UpdateSort($this->SEXO); // SEXO
			$this->UpdateSort($this->EDAD_EN_MESES); // EDAD_EN_MESES
			$this->UpdateSort($this->TALLA); // TALLA
			$this->UpdateSort($this->PESO); // PESO
			$this->UpdateSort($this->EPS); // EPS
			$this->UpdateSort($this->NOMBRE_COMUNA); // NOMBRE_COMUNA
			$this->UpdateSort($this->NOMBRE_BARRIO); // NOMBRE_BARRIO
			$this->UpdateSort($this->INDICADOR); // INDICADOR
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->SqlOrderBy() <> "") {
				$sOrderBy = $this->SqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->N->setSort("");
				$this->ANO->setSort("");
				$this->FECHA_VALORACION->setSort("");
				$this->SEXO->setSort("");
				$this->EDAD_EN_MESES->setSort("");
				$this->TALLA->setSort("");
				$this->PESO->setSort("");
				$this->EPS->setSort("");
				$this->NOMBRE_COMUNA->setSort("");
				$this->NOMBRE_BARRIO->setSort("");
				$this->INDICADOR->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<label class=\"checkbox inline\"><input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\"></label>";
		$item->MoveTo(0);
		if (count($this->CustomActions) > 0) $item->Visible = TRUE;
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		$this->ListOptions->ButtonClass = "btn-small"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		if ($Security->CanView())
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		else
			$oListOpt->Body = "";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAddEdit ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-small"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];
			foreach ($this->CustomActions as $action => $name) {

				// Add custom action
				$item = &$option->Add("custom_" . $action);
				$item->Body = "<a class=\"ewAction ewCustomAction\" href=\"\" onclick=\"ew_SubmitSelected(document.fassbasaludlist, '" . ew_CurrentUrl() . "', null, '" . $action . "');return false;\">" . $name . "</a>";
			}

			// Hide grid edit, multi-delete and multi-update
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$item = &$option->GetItem("multidelete");
				if ($item) $item->Visible = FALSE;
				$item = &$option->GetItem("multiupdate");
				if ($item) $item->Visible = FALSE;
			}
	}

	// Process custom action
	function ProcessCustomAction() {
		global $conn, $Language, $Security;
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$rsuser = ($rs) ? $rs->GetRows() : array();
			if ($rs)
				$rs->Close();

			// Call row custom action event
			if (count($rsuser) > 0) {
				$conn->BeginTrans();
				foreach ($rsuser as $row) {
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $UserAction, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $UserAction, $Language->Phrase("CustomActionCancelled")));
					}
				}
			}
		}
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	//  Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// N

		$this->N->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_N"]);
		if ($this->N->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->N->AdvancedSearch->SearchOperator = @$_GET["z_N"];

		// ANO
		$this->ANO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_ANO"]);
		if ($this->ANO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->ANO->AdvancedSearch->SearchOperator = @$_GET["z_ANO"];

		// FECHA_VALORACION
		$this->FECHA_VALORACION->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_FECHA_VALORACION"]);
		if ($this->FECHA_VALORACION->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->FECHA_VALORACION->AdvancedSearch->SearchOperator = @$_GET["z_FECHA_VALORACION"];

		// NUMERO_ID
		$this->NUMERO_ID->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_NUMERO_ID"]);
		if ($this->NUMERO_ID->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->NUMERO_ID->AdvancedSearch->SearchOperator = @$_GET["z_NUMERO_ID"];

		// NOMBRES
		$this->NOMBRES->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_NOMBRES"]);
		if ($this->NOMBRES->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->NOMBRES->AdvancedSearch->SearchOperator = @$_GET["z_NOMBRES"];

		// PRIMER_APELLIDO
		$this->PRIMER_APELLIDO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_PRIMER_APELLIDO"]);
		if ($this->PRIMER_APELLIDO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->PRIMER_APELLIDO->AdvancedSearch->SearchOperator = @$_GET["z_PRIMER_APELLIDO"];

		// SEGUNDO_APELLIDO
		$this->SEGUNDO_APELLIDO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_SEGUNDO_APELLIDO"]);
		if ($this->SEGUNDO_APELLIDO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->SEGUNDO_APELLIDO->AdvancedSearch->SearchOperator = @$_GET["z_SEGUNDO_APELLIDO"];

		// FECHA_NACIMIENTO
		$this->FECHA_NACIMIENTO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_FECHA_NACIMIENTO"]);
		if ($this->FECHA_NACIMIENTO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->FECHA_NACIMIENTO->AdvancedSearch->SearchOperator = @$_GET["z_FECHA_NACIMIENTO"];

		// SEXO
		$this->SEXO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_SEXO"]);
		if ($this->SEXO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->SEXO->AdvancedSearch->SearchOperator = @$_GET["z_SEXO"];

		// EDAD_EN_MESES
		$this->EDAD_EN_MESES->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_EDAD_EN_MESES"]);
		if ($this->EDAD_EN_MESES->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->EDAD_EN_MESES->AdvancedSearch->SearchOperator = @$_GET["z_EDAD_EN_MESES"];

		// TALLA
		$this->TALLA->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_TALLA"]);
		if ($this->TALLA->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->TALLA->AdvancedSearch->SearchOperator = @$_GET["z_TALLA"];

		// PESO
		$this->PESO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_PESO"]);
		if ($this->PESO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->PESO->AdvancedSearch->SearchOperator = @$_GET["z_PESO"];

		// EPS
		$this->EPS->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_EPS"]);
		if ($this->EPS->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->EPS->AdvancedSearch->SearchOperator = @$_GET["z_EPS"];

		// DIRECCION
		$this->DIRECCION->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_DIRECCION"]);
		if ($this->DIRECCION->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->DIRECCION->AdvancedSearch->SearchOperator = @$_GET["z_DIRECCION"];

		// TELEFONO
		$this->TELEFONO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_TELEFONO"]);
		if ($this->TELEFONO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->TELEFONO->AdvancedSearch->SearchOperator = @$_GET["z_TELEFONO"];

		// NOMBRE_COMUNA
		$this->NOMBRE_COMUNA->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_NOMBRE_COMUNA"]);
		if ($this->NOMBRE_COMUNA->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->NOMBRE_COMUNA->AdvancedSearch->SearchOperator = @$_GET["z_NOMBRE_COMUNA"];

		// NOMBRE_BARRIO
		$this->NOMBRE_BARRIO->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_NOMBRE_BARRIO"]);
		if ($this->NOMBRE_BARRIO->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->NOMBRE_BARRIO->AdvancedSearch->SearchOperator = @$_GET["z_NOMBRE_BARRIO"];

		// INDICADOR
		$this->INDICADOR->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_INDICADOR"]);
		if ($this->INDICADOR->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->INDICADOR->AdvancedSearch->SearchOperator = @$_GET["z_INDICADOR"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->N->setDbValue($rs->fields('N'));
		$this->ANO->setDbValue($rs->fields('ANO'));
		$this->FECHA_VALORACION->setDbValue($rs->fields('FECHA_VALORACION'));
		$this->NUMERO_ID->setDbValue($rs->fields('NUMERO_ID'));
		$this->NOMBRES->setDbValue($rs->fields('NOMBRES'));
		$this->PRIMER_APELLIDO->setDbValue($rs->fields('PRIMER_APELLIDO'));
		$this->SEGUNDO_APELLIDO->setDbValue($rs->fields('SEGUNDO_APELLIDO'));
		$this->FECHA_NACIMIENTO->setDbValue($rs->fields('FECHA_NACIMIENTO'));
		$this->SEXO->setDbValue($rs->fields('SEXO'));
		$this->EDAD_EN_MESES->setDbValue($rs->fields('EDAD_EN_MESES'));
		$this->TALLA->setDbValue($rs->fields('TALLA'));
		$this->PESO->setDbValue($rs->fields('PESO'));
		$this->EPS->setDbValue($rs->fields('EPS'));
		$this->DIRECCION->setDbValue($rs->fields('DIRECCION'));
		$this->TELEFONO->setDbValue($rs->fields('TELEFONO'));
		$this->NOMBRE_COMUNA->setDbValue($rs->fields('NOMBRE_COMUNA'));
		$this->NOMBRE_BARRIO->setDbValue($rs->fields('NOMBRE_BARRIO'));
		$this->INDICADOR->setDbValue($rs->fields('INDICADOR'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->N->DbValue = $row['N'];
		$this->ANO->DbValue = $row['ANO'];
		$this->FECHA_VALORACION->DbValue = $row['FECHA_VALORACION'];
		$this->NUMERO_ID->DbValue = $row['NUMERO_ID'];
		$this->NOMBRES->DbValue = $row['NOMBRES'];
		$this->PRIMER_APELLIDO->DbValue = $row['PRIMER_APELLIDO'];
		$this->SEGUNDO_APELLIDO->DbValue = $row['SEGUNDO_APELLIDO'];
		$this->FECHA_NACIMIENTO->DbValue = $row['FECHA_NACIMIENTO'];
		$this->SEXO->DbValue = $row['SEXO'];
		$this->EDAD_EN_MESES->DbValue = $row['EDAD_EN_MESES'];
		$this->TALLA->DbValue = $row['TALLA'];
		$this->PESO->DbValue = $row['PESO'];
		$this->EPS->DbValue = $row['EPS'];
		$this->DIRECCION->DbValue = $row['DIRECCION'];
		$this->TELEFONO->DbValue = $row['TELEFONO'];
		$this->NOMBRE_COMUNA->DbValue = $row['NOMBRE_COMUNA'];
		$this->NOMBRE_BARRIO->DbValue = $row['NOMBRE_BARRIO'];
		$this->INDICADOR->DbValue = $row['INDICADOR'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("N")) <> "")
			$this->N->CurrentValue = $this->getKey("N"); // N
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$this->OldRecordset = ew_LoadRecordset($sSql);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Convert decimal values if posted back
		if ($this->PESO->FormValue == $this->PESO->CurrentValue && is_numeric(ew_StrToFloat($this->PESO->CurrentValue)))
			$this->PESO->CurrentValue = ew_StrToFloat($this->PESO->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// N
		// ANO
		// FECHA_VALORACION
		// NUMERO_ID
		// NOMBRES
		// PRIMER_APELLIDO
		// SEGUNDO_APELLIDO
		// FECHA_NACIMIENTO
		// SEXO
		// EDAD_EN_MESES
		// TALLA
		// PESO
		// EPS
		// DIRECCION
		// TELEFONO
		// NOMBRE_COMUNA
		// NOMBRE_BARRIO
		// INDICADOR

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// N
			$this->N->ViewValue = $this->N->CurrentValue;
			$this->N->ViewCustomAttributes = "";

			// ANO
			$this->ANO->ViewValue = $this->ANO->CurrentValue;
			$this->ANO->ViewCustomAttributes = "";

			// FECHA_VALORACION
			$this->FECHA_VALORACION->ViewValue = $this->FECHA_VALORACION->CurrentValue;
			$this->FECHA_VALORACION->ViewValue = ew_FormatDateTime($this->FECHA_VALORACION->ViewValue, 7);
			$this->FECHA_VALORACION->ViewCustomAttributes = "";

			// NUMERO_ID
			$this->NUMERO_ID->ViewValue = $this->NUMERO_ID->CurrentValue;
			$this->NUMERO_ID->ViewCustomAttributes = "";

			// NOMBRES
			$this->NOMBRES->ViewValue = $this->NOMBRES->CurrentValue;
			$this->NOMBRES->ViewCustomAttributes = "";

			// PRIMER_APELLIDO
			$this->PRIMER_APELLIDO->ViewValue = $this->PRIMER_APELLIDO->CurrentValue;
			$this->PRIMER_APELLIDO->ViewCustomAttributes = "";

			// SEGUNDO_APELLIDO
			$this->SEGUNDO_APELLIDO->ViewValue = $this->SEGUNDO_APELLIDO->CurrentValue;
			$this->SEGUNDO_APELLIDO->ViewCustomAttributes = "";

			// FECHA_NACIMIENTO
			$this->FECHA_NACIMIENTO->ViewValue = $this->FECHA_NACIMIENTO->CurrentValue;
			$this->FECHA_NACIMIENTO->ViewValue = ew_FormatDateTime($this->FECHA_NACIMIENTO->ViewValue, 7);
			$this->FECHA_NACIMIENTO->ViewCustomAttributes = "";

			// SEXO
			$this->SEXO->ViewValue = $this->SEXO->CurrentValue;
			$this->SEXO->ViewCustomAttributes = "";

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->ViewValue = $this->EDAD_EN_MESES->CurrentValue;
			$this->EDAD_EN_MESES->ViewCustomAttributes = "";

			// TALLA
			$this->TALLA->ViewValue = $this->TALLA->CurrentValue;
			$this->TALLA->CellCssStyle .= "text-align: right;";
			$this->TALLA->ViewCustomAttributes = "";

			// PESO
			$this->PESO->ViewValue = $this->PESO->CurrentValue;
			$this->PESO->CellCssStyle .= "text-align: right;";
			$this->PESO->ViewCustomAttributes = "";

			// EPS
			$this->EPS->ViewValue = $this->EPS->CurrentValue;
			$this->EPS->ViewCustomAttributes = "";

			// DIRECCION
			$this->DIRECCION->ViewValue = $this->DIRECCION->CurrentValue;
			$this->DIRECCION->ViewCustomAttributes = "";

			// TELEFONO
			$this->TELEFONO->ViewValue = $this->TELEFONO->CurrentValue;
			$this->TELEFONO->ViewCustomAttributes = "";

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->ViewValue = $this->NOMBRE_COMUNA->CurrentValue;
			$this->NOMBRE_COMUNA->ViewCustomAttributes = "";

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->ViewValue = $this->NOMBRE_BARRIO->CurrentValue;
			$this->NOMBRE_BARRIO->ViewCustomAttributes = "";

			// INDICADOR
			$this->INDICADOR->ViewValue = $this->INDICADOR->CurrentValue;
			$this->INDICADOR->CellCssStyle .= "text-align: right;";
			$this->INDICADOR->ViewCustomAttributes = "";

			// N
			$this->N->LinkCustomAttributes = "";
			$this->N->HrefValue = "";
			$this->N->TooltipValue = "";

			// ANO
			$this->ANO->LinkCustomAttributes = "";
			$this->ANO->HrefValue = "";
			$this->ANO->TooltipValue = "";

			// FECHA_VALORACION
			$this->FECHA_VALORACION->LinkCustomAttributes = "";
			$this->FECHA_VALORACION->HrefValue = "";
			$this->FECHA_VALORACION->TooltipValue = "";

			// SEXO
			$this->SEXO->LinkCustomAttributes = "";
			$this->SEXO->HrefValue = "";
			$this->SEXO->TooltipValue = "";

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->LinkCustomAttributes = "";
			$this->EDAD_EN_MESES->HrefValue = "";
			$this->EDAD_EN_MESES->TooltipValue = "";

			// TALLA
			$this->TALLA->LinkCustomAttributes = "";
			$this->TALLA->HrefValue = "";
			$this->TALLA->TooltipValue = "";

			// PESO
			$this->PESO->LinkCustomAttributes = "";
			$this->PESO->HrefValue = "";
			$this->PESO->TooltipValue = "";

			// EPS
			$this->EPS->LinkCustomAttributes = "";
			$this->EPS->HrefValue = "";
			$this->EPS->TooltipValue = "";

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->LinkCustomAttributes = "";
			$this->NOMBRE_COMUNA->HrefValue = "";
			$this->NOMBRE_COMUNA->TooltipValue = "";

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->LinkCustomAttributes = "";
			$this->NOMBRE_BARRIO->HrefValue = "";
			$this->NOMBRE_BARRIO->TooltipValue = "";

			// INDICADOR
			$this->INDICADOR->LinkCustomAttributes = "";
			$this->INDICADOR->HrefValue = "";
			$this->INDICADOR->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// N
			$this->N->EditCustomAttributes = "";
			$this->N->EditValue = ew_HtmlEncode($this->N->AdvancedSearch->SearchValue);
			$this->N->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->N->FldCaption()));

			// ANO
			$this->ANO->EditCustomAttributes = "";
			$this->ANO->EditValue = ew_HtmlEncode($this->ANO->AdvancedSearch->SearchValue);
			$this->ANO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->ANO->FldCaption()));

			// FECHA_VALORACION
			$this->FECHA_VALORACION->EditCustomAttributes = "";
			$this->FECHA_VALORACION->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->FECHA_VALORACION->AdvancedSearch->SearchValue, 7), 7));
			$this->FECHA_VALORACION->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->FECHA_VALORACION->FldCaption()));

			// SEXO
			$this->SEXO->EditCustomAttributes = "";
			$this->SEXO->EditValue = ew_HtmlEncode($this->SEXO->AdvancedSearch->SearchValue);
			$this->SEXO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->SEXO->FldCaption()));

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->EditCustomAttributes = "";
			$this->EDAD_EN_MESES->EditValue = ew_HtmlEncode($this->EDAD_EN_MESES->AdvancedSearch->SearchValue);
			$this->EDAD_EN_MESES->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->EDAD_EN_MESES->FldCaption()));

			// TALLA
			$this->TALLA->EditCustomAttributes = "";
			$this->TALLA->EditValue = ew_HtmlEncode($this->TALLA->AdvancedSearch->SearchValue);
			$this->TALLA->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->TALLA->FldCaption()));

			// PESO
			$this->PESO->EditCustomAttributes = "";
			$this->PESO->EditValue = ew_HtmlEncode($this->PESO->AdvancedSearch->SearchValue);
			$this->PESO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->PESO->FldCaption()));

			// EPS
			$this->EPS->EditCustomAttributes = "";
			$this->EPS->EditValue = ew_HtmlEncode($this->EPS->AdvancedSearch->SearchValue);
			$this->EPS->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->EPS->FldCaption()));

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->EditCustomAttributes = "";
			$this->NOMBRE_COMUNA->EditValue = ew_HtmlEncode($this->NOMBRE_COMUNA->AdvancedSearch->SearchValue);
			$this->NOMBRE_COMUNA->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->NOMBRE_COMUNA->FldCaption()));

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->EditCustomAttributes = "";
			$this->NOMBRE_BARRIO->EditValue = ew_HtmlEncode($this->NOMBRE_BARRIO->AdvancedSearch->SearchValue);
			$this->NOMBRE_BARRIO->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->NOMBRE_BARRIO->FldCaption()));

			// INDICADOR
			$this->INDICADOR->EditCustomAttributes = "";
			$this->INDICADOR->EditValue = ew_HtmlEncode($this->INDICADOR->AdvancedSearch->SearchValue);
			$this->INDICADOR->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->INDICADOR->FldCaption()));
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->N->AdvancedSearch->Load();
		$this->ANO->AdvancedSearch->Load();
		$this->FECHA_VALORACION->AdvancedSearch->Load();
		$this->NUMERO_ID->AdvancedSearch->Load();
		$this->NOMBRES->AdvancedSearch->Load();
		$this->PRIMER_APELLIDO->AdvancedSearch->Load();
		$this->SEGUNDO_APELLIDO->AdvancedSearch->Load();
		$this->FECHA_NACIMIENTO->AdvancedSearch->Load();
		$this->SEXO->AdvancedSearch->Load();
		$this->EDAD_EN_MESES->AdvancedSearch->Load();
		$this->TALLA->AdvancedSearch->Load();
		$this->PESO->AdvancedSearch->Load();
		$this->EPS->AdvancedSearch->Load();
		$this->DIRECCION->AdvancedSearch->Load();
		$this->TELEFONO->AdvancedSearch->Load();
		$this->NOMBRE_COMUNA->AdvancedSearch->Load();
		$this->NOMBRE_BARRIO->AdvancedSearch->Load();
		$this->INDICADOR->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$item->Body = "<a id=\"emf_assbasalud\" href=\"javascript:void(0);\" class=\"ewExportLink ewEmail\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_assbasalud',hdr:ewLanguage.Phrase('ExportToEmail'),f:document.fassbasaludlist,sel:false});\">" . $Language->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = EW_SELECT_LIMIT;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if ($rs = $this->LoadRecordset())
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetUpStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$ExportDoc = ew_ExportDocument($this, "h");
		$ParentTable = "";
		if ($bSelectLimit) {
			$StartRec = 1;
			$StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {
			$StartRec = $this->StartRec;
			$StopRec = $this->StopRec;
		}
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$ExportDoc->Text .= $sHeader;
		$this->ExportDocument($ExportDoc, $rs, $StartRec, $StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$ExportDoc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Export header and footer
		$ExportDoc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED)
			echo ew_DebugMsg();

		// Output data
		$ExportDoc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($assbasalud_list)) $assbasalud_list = new cassbasalud_list();

// Page init
$assbasalud_list->Page_Init();

// Page main
$assbasalud_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$assbasalud_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($assbasalud->Export == "") { ?>
<script type="text/javascript">

// Page object
var assbasalud_list = new ew_Page("assbasalud_list");
assbasalud_list.PageID = "list"; // Page ID
var EW_PAGE_ID = assbasalud_list.PageID; // For backward compatibility

// Form object
var fassbasaludlist = new ew_Form("fassbasaludlist");
fassbasaludlist.FormKeyCountName = '<?php echo $assbasalud_list->FormKeyCountName ?>';

// Form_CustomValidate event
fassbasaludlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fassbasaludlist.ValidateRequired = true;
<?php } else { ?>
fassbasaludlist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

var fassbasaludlistsrch = new ew_Form("fassbasaludlistsrch");

// Validate function for search
fassbasaludlistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	this.PostAutoSuggest();
	var infix = "";

	// Set up row object
	ew_ElementsToRow(fobj);

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fassbasaludlistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fassbasaludlistsrch.ValidateRequired = true; // Use JavaScript validation
<?php } else { ?>
fassbasaludlistsrch.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Dynamic selection lists
// Init search panel as collapsed

if (fassbasaludlistsrch) fassbasaludlistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($assbasalud->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($assbasalud_list->ExportOptions->Visible()) { ?>
<div class="ewListExportOptions"><?php $assbasalud_list->ExportOptions->Render("body") ?></div>
<?php } ?>
<?php
	$bSelectLimit = EW_SELECT_LIMIT;
	if ($bSelectLimit) {
		$assbasalud_list->TotalRecs = $assbasalud->SelectRecordCount();
	} else {
		if ($assbasalud_list->Recordset = $assbasalud_list->LoadRecordset())
			$assbasalud_list->TotalRecs = $assbasalud_list->Recordset->RecordCount();
	}
	$assbasalud_list->StartRec = 1;
	if ($assbasalud_list->DisplayRecs <= 0 || ($assbasalud->Export <> "" && $assbasalud->ExportAll)) // Display all records
		$assbasalud_list->DisplayRecs = $assbasalud_list->TotalRecs;
	if (!($assbasalud->Export <> "" && $assbasalud->ExportAll))
		$assbasalud_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$assbasalud_list->Recordset = $assbasalud_list->LoadRecordset($assbasalud_list->StartRec-1, $assbasalud_list->DisplayRecs);
$assbasalud_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($assbasalud->Export == "" && $assbasalud->CurrentAction == "") { ?>
<form name="fassbasaludlistsrch" id="fassbasaludlistsrch" class="ewForm form-inline" action="<?php echo ew_CurrentPage() ?>">
<table class="ewSearchTable"><tr><td>
<div class="accordion" id="fassbasaludlistsrch_SearchGroup">
	<div class="accordion-group">
		<div class="accordion-heading">
<a class="accordion-toggle" data-toggle="collapse" data-parent="#fassbasaludlistsrch_SearchGroup" href="#fassbasaludlistsrch_SearchBody"><?php echo $Language->Phrase("Search") ?></a>
		</div>
		<div id="fassbasaludlistsrch_SearchBody" class="accordion-body collapse in">
			<div class="accordion-inner">
<div id="fassbasaludlistsrch_SearchPanel">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="assbasalud">
<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$assbasalud_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$assbasalud->RowType = EW_ROWTYPE_SEARCH;

// Render row
$assbasalud->ResetAttrs();
$assbasalud_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($assbasalud->SEXO->Visible) { // SEXO ?>
	<span id="xsc_SEXO" class="ewCell">
		<span class="ewSearchCaption"><?php echo $assbasalud->SEXO->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_SEXO" id="z_SEXO" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" class="x_SEXO" name="x_SEXO" id="x_SEXO" size="30" maxlength="1" placeholder="<?php echo $assbasalud->SEXO->PlaceHolder ?>" value="<?php echo $assbasalud->SEXO->EditValue ?>"<?php echo $assbasalud->SEXO->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
<?php if ($assbasalud->EPS->Visible) { // EPS ?>
	<span id="xsc_EPS" class="ewCell">
		<span class="ewSearchCaption"><?php echo $assbasalud->EPS->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_EPS" id="z_EPS" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" class="x_EPS" name="x_EPS" id="x_EPS" size="30" maxlength="6" placeholder="<?php echo $assbasalud->EPS->PlaceHolder ?>" value="<?php echo $assbasalud->EPS->EditValue ?>"<?php echo $assbasalud->EPS->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
<?php if ($assbasalud->NOMBRE_COMUNA->Visible) { // NOMBRE_COMUNA ?>
	<span id="xsc_NOMBRE_COMUNA" class="ewCell">
		<span class="ewSearchCaption"><?php echo $assbasalud->NOMBRE_COMUNA->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_NOMBRE_COMUNA" id="z_NOMBRE_COMUNA" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" class="x_NOMBRE_COMUNA" name="x_NOMBRE_COMUNA" id="x_NOMBRE_COMUNA" size="30" maxlength="19" placeholder="<?php echo $assbasalud->NOMBRE_COMUNA->PlaceHolder ?>" value="<?php echo $assbasalud->NOMBRE_COMUNA->EditValue ?>"<?php echo $assbasalud->NOMBRE_COMUNA->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($assbasalud->NOMBRE_BARRIO->Visible) { // NOMBRE_BARRIO ?>
	<span id="xsc_NOMBRE_BARRIO" class="ewCell">
		<span class="ewSearchCaption"><?php echo $assbasalud->NOMBRE_BARRIO->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_NOMBRE_BARRIO" id="z_NOMBRE_BARRIO" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" class="x_NOMBRE_BARRIO" name="x_NOMBRE_BARRIO" id="x_NOMBRE_BARRIO" size="30" maxlength="30" placeholder="<?php echo $assbasalud->NOMBRE_BARRIO->PlaceHolder ?>" value="<?php echo $assbasalud->NOMBRE_BARRIO->EditValue ?>"<?php echo $assbasalud->NOMBRE_BARRIO->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
<?php if ($assbasalud->INDICADOR->Visible) { // INDICADOR ?>
	<span id="xsc_INDICADOR" class="ewCell">
		<span class="ewSearchCaption"><?php echo $assbasalud->INDICADOR->FldCaption() ?></span>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_INDICADOR" id="z_INDICADOR" value="LIKE"></span>
		<span class="control-group ewSearchField">
<input type="text" class="x_INDICADOR" name="x_INDICADOR" id="x_INDICADOR" size="30" maxlength="17" placeholder="<?php echo $assbasalud->INDICADOR->PlaceHolder ?>" value="<?php echo $assbasalud->INDICADOR->EditValue ?>"<?php echo $assbasalud->INDICADOR->EditAttributes() ?>>
</span>
	</span>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
	<div class="btn-group ewButtonGroup">
	<div class="input-append">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="input-large" value="<?php echo ew_HtmlEncode($assbasalud_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo $Language->Phrase("Search") ?>">
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
	<div class="btn-group ewButtonGroup">
	<a class="btn ewShowAll" href="<?php echo $assbasalud_list->PageUrl() ?>cmd=reset"><?php echo $Language->Phrase("ShowAll") ?></a>
</div>
<div id="xsr_4" class="ewRow">
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="="<?php if ($assbasalud_list->BasicSearch->getType() == "=") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("ExactPhrase") ?></label>
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="AND"<?php if ($assbasalud_list->BasicSearch->getType() == "AND") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("AllWord") ?></label>
	<label class="inline radio ewRadio" style="white-space: nowrap;"><input type="radio" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="OR"<?php if ($assbasalud_list->BasicSearch->getType() == "OR") { ?> checked="checked"<?php } ?>><?php echo $Language->Phrase("AnyWord") ?></label>
</div>
</div>
</div>
			</div>
		</div>
	</div>
</div>
</td></tr></table>
</form>
<?php } ?>
<?php } ?>
<?php $assbasalud_list->ShowPageHeader(); ?>
<?php
$assbasalud_list->ShowMessage();
?>
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<?php if ($assbasalud->Export == "") { ?>
<div class="ewGridUpperPanel">
<?php if ($assbasalud->CurrentAction <> "gridadd" && $assbasalud->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>">
<table class="ewPager">
<tr><td>
<?php if (!isset($assbasalud_list->Pager)) $assbasalud_list->Pager = new cPrevNextPager($assbasalud_list->StartRec, $assbasalud_list->DisplayRecs, $assbasalud_list->TotalRecs) ?>
<?php if ($assbasalud_list->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($assbasalud_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn" type="button" href="<?php echo $assbasalud_list->PageUrl() ?>start=<?php echo $assbasalud_list->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($assbasalud_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn" type="button" href="<?php echo $assbasalud_list->PageUrl() ?>start=<?php echo $assbasalud_list->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $assbasalud_list->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($assbasalud_list->Pager->NextButton->Enabled) { ?>
	<a class="btn" type="button" href="<?php echo $assbasalud_list->PageUrl() ?>start=<?php echo $assbasalud_list->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($assbasalud_list->Pager->LastButton->Enabled) { ?>
	<a class="btn" type="button" href="<?php echo $assbasalud_list->PageUrl() ?>start=<?php echo $assbasalud_list->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $assbasalud_list->Pager->PageCount ?>
</td>
<td>
	&nbsp;&nbsp;&nbsp;&nbsp;
	<?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $assbasalud_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $assbasalud_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $assbasalud_list->Pager->RecordCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<?php if ($Security->CanList()) { ?>
	<?php if ($assbasalud_list->SearchWhere == "0=101") { ?>
	<p><?php echo $Language->Phrase("EnterSearchCriteria") ?></p>
	<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
	<?php } ?>
	<?php } else { ?>
	<p><?php echo $Language->Phrase("NoPermission") ?></p>
	<?php } ?>
<?php } ?>
</td>
</tr></table>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($assbasalud_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
</div>
<?php } ?>
<form name="fassbasaludlist" id="fassbasaludlist" class="ewForm form-horizontal" action="" method="post">
<input type="hidden" name="t" value="assbasalud">
<div id="gmp_assbasalud" class="ewGridMiddlePanel">
<?php if ($assbasalud_list->TotalRecs > 0) { ?>
<table id="tbl_assbasaludlist" class="ewTable ewTableSeparate">
<?php echo $assbasalud->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Render list options
$assbasalud_list->RenderListOptions();

// Render list options (header, left)
$assbasalud_list->ListOptions->Render("header", "left");
?>
<?php if ($assbasalud->N->Visible) { // N ?>
	<?php if ($assbasalud->SortUrl($assbasalud->N) == "") { ?>
		<td><div id="elh_assbasalud_N" class="assbasalud_N"><div class="ewTableHeaderCaption"><?php echo $assbasalud->N->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->N) ?>',1);"><div id="elh_assbasalud_N" class="assbasalud_N">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->N->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->N->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->N->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->ANO->Visible) { // ANO ?>
	<?php if ($assbasalud->SortUrl($assbasalud->ANO) == "") { ?>
		<td><div id="elh_assbasalud_ANO" class="assbasalud_ANO"><div class="ewTableHeaderCaption"><?php echo $assbasalud->ANO->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->ANO) ?>',1);"><div id="elh_assbasalud_ANO" class="assbasalud_ANO">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->ANO->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->ANO->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->ANO->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->FECHA_VALORACION->Visible) { // FECHA_VALORACION ?>
	<?php if ($assbasalud->SortUrl($assbasalud->FECHA_VALORACION) == "") { ?>
		<td><div id="elh_assbasalud_FECHA_VALORACION" class="assbasalud_FECHA_VALORACION"><div class="ewTableHeaderCaption"><?php echo $assbasalud->FECHA_VALORACION->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->FECHA_VALORACION) ?>',1);"><div id="elh_assbasalud_FECHA_VALORACION" class="assbasalud_FECHA_VALORACION">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->FECHA_VALORACION->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->FECHA_VALORACION->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->FECHA_VALORACION->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->SEXO->Visible) { // SEXO ?>
	<?php if ($assbasalud->SortUrl($assbasalud->SEXO) == "") { ?>
		<td><div id="elh_assbasalud_SEXO" class="assbasalud_SEXO"><div class="ewTableHeaderCaption"><?php echo $assbasalud->SEXO->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->SEXO) ?>',1);"><div id="elh_assbasalud_SEXO" class="assbasalud_SEXO">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->SEXO->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->SEXO->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->SEXO->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->EDAD_EN_MESES->Visible) { // EDAD_EN_MESES ?>
	<?php if ($assbasalud->SortUrl($assbasalud->EDAD_EN_MESES) == "") { ?>
		<td><div id="elh_assbasalud_EDAD_EN_MESES" class="assbasalud_EDAD_EN_MESES"><div class="ewTableHeaderCaption"><?php echo $assbasalud->EDAD_EN_MESES->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->EDAD_EN_MESES) ?>',1);"><div id="elh_assbasalud_EDAD_EN_MESES" class="assbasalud_EDAD_EN_MESES">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->EDAD_EN_MESES->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->EDAD_EN_MESES->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->EDAD_EN_MESES->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->TALLA->Visible) { // TALLA ?>
	<?php if ($assbasalud->SortUrl($assbasalud->TALLA) == "") { ?>
		<td><div id="elh_assbasalud_TALLA" class="assbasalud_TALLA"><div class="ewTableHeaderCaption"><?php echo $assbasalud->TALLA->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->TALLA) ?>',1);"><div id="elh_assbasalud_TALLA" class="assbasalud_TALLA">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->TALLA->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->TALLA->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->TALLA->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->PESO->Visible) { // PESO ?>
	<?php if ($assbasalud->SortUrl($assbasalud->PESO) == "") { ?>
		<td><div id="elh_assbasalud_PESO" class="assbasalud_PESO"><div class="ewTableHeaderCaption"><?php echo $assbasalud->PESO->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->PESO) ?>',1);"><div id="elh_assbasalud_PESO" class="assbasalud_PESO">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->PESO->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->PESO->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->PESO->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->EPS->Visible) { // EPS ?>
	<?php if ($assbasalud->SortUrl($assbasalud->EPS) == "") { ?>
		<td><div id="elh_assbasalud_EPS" class="assbasalud_EPS"><div class="ewTableHeaderCaption"><?php echo $assbasalud->EPS->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->EPS) ?>',1);"><div id="elh_assbasalud_EPS" class="assbasalud_EPS">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->EPS->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->EPS->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->EPS->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->NOMBRE_COMUNA->Visible) { // NOMBRE_COMUNA ?>
	<?php if ($assbasalud->SortUrl($assbasalud->NOMBRE_COMUNA) == "") { ?>
		<td><div id="elh_assbasalud_NOMBRE_COMUNA" class="assbasalud_NOMBRE_COMUNA"><div class="ewTableHeaderCaption"><?php echo $assbasalud->NOMBRE_COMUNA->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->NOMBRE_COMUNA) ?>',1);"><div id="elh_assbasalud_NOMBRE_COMUNA" class="assbasalud_NOMBRE_COMUNA">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->NOMBRE_COMUNA->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->NOMBRE_COMUNA->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->NOMBRE_COMUNA->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->NOMBRE_BARRIO->Visible) { // NOMBRE_BARRIO ?>
	<?php if ($assbasalud->SortUrl($assbasalud->NOMBRE_BARRIO) == "") { ?>
		<td><div id="elh_assbasalud_NOMBRE_BARRIO" class="assbasalud_NOMBRE_BARRIO"><div class="ewTableHeaderCaption"><?php echo $assbasalud->NOMBRE_BARRIO->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->NOMBRE_BARRIO) ?>',1);"><div id="elh_assbasalud_NOMBRE_BARRIO" class="assbasalud_NOMBRE_BARRIO">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->NOMBRE_BARRIO->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->NOMBRE_BARRIO->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->NOMBRE_BARRIO->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php if ($assbasalud->INDICADOR->Visible) { // INDICADOR ?>
	<?php if ($assbasalud->SortUrl($assbasalud->INDICADOR) == "") { ?>
		<td><div id="elh_assbasalud_INDICADOR" class="assbasalud_INDICADOR"><div class="ewTableHeaderCaption"><?php echo $assbasalud->INDICADOR->FldCaption() ?></div></div></td>
	<?php } else { ?>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $assbasalud->SortUrl($assbasalud->INDICADOR) ?>',1);"><div id="elh_assbasalud_INDICADOR" class="assbasalud_INDICADOR">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $assbasalud->INDICADOR->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($assbasalud->INDICADOR->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($assbasalud->INDICADOR->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></td>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$assbasalud_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($assbasalud->ExportAll && $assbasalud->Export <> "") {
	$assbasalud_list->StopRec = $assbasalud_list->TotalRecs;
} else {

	// Set the last record to display
	if ($assbasalud_list->TotalRecs > $assbasalud_list->StartRec + $assbasalud_list->DisplayRecs - 1)
		$assbasalud_list->StopRec = $assbasalud_list->StartRec + $assbasalud_list->DisplayRecs - 1;
	else
		$assbasalud_list->StopRec = $assbasalud_list->TotalRecs;
}
$assbasalud_list->RecCnt = $assbasalud_list->StartRec - 1;
if ($assbasalud_list->Recordset && !$assbasalud_list->Recordset->EOF) {
	$assbasalud_list->Recordset->MoveFirst();
	if (!$bSelectLimit && $assbasalud_list->StartRec > 1)
		$assbasalud_list->Recordset->Move($assbasalud_list->StartRec - 1);
} elseif (!$assbasalud->AllowAddDeleteRow && $assbasalud_list->StopRec == 0) {
	$assbasalud_list->StopRec = $assbasalud->GridAddRowCount;
}

// Initialize aggregate
$assbasalud->RowType = EW_ROWTYPE_AGGREGATEINIT;
$assbasalud->ResetAttrs();
$assbasalud_list->RenderRow();
while ($assbasalud_list->RecCnt < $assbasalud_list->StopRec) {
	$assbasalud_list->RecCnt++;
	if (intval($assbasalud_list->RecCnt) >= intval($assbasalud_list->StartRec)) {
		$assbasalud_list->RowCnt++;

		// Set up key count
		$assbasalud_list->KeyCount = $assbasalud_list->RowIndex;

		// Init row class and style
		$assbasalud->ResetAttrs();
		$assbasalud->CssClass = "";
		if ($assbasalud->CurrentAction == "gridadd") {
		} else {
			$assbasalud_list->LoadRowValues($assbasalud_list->Recordset); // Load row values
		}
		$assbasalud->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$assbasalud->RowAttrs = array_merge($assbasalud->RowAttrs, array('data-rowindex'=>$assbasalud_list->RowCnt, 'id'=>'r' . $assbasalud_list->RowCnt . '_assbasalud', 'data-rowtype'=>$assbasalud->RowType));

		// Render row
		$assbasalud_list->RenderRow();

		// Render list options
		$assbasalud_list->RenderListOptions();
?>
	<tr<?php echo $assbasalud->RowAttributes() ?>>
<?php

// Render list options (body, left)
$assbasalud_list->ListOptions->Render("body", "left", $assbasalud_list->RowCnt);
?>
	<?php if ($assbasalud->N->Visible) { // N ?>
		<td<?php echo $assbasalud->N->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_N" class="control-group assbasalud_N">
<span<?php echo $assbasalud->N->ViewAttributes() ?>>
<?php echo $assbasalud->N->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->ANO->Visible) { // ANO ?>
		<td<?php echo $assbasalud->ANO->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_ANO" class="control-group assbasalud_ANO">
<span<?php echo $assbasalud->ANO->ViewAttributes() ?>>
<?php echo $assbasalud->ANO->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->FECHA_VALORACION->Visible) { // FECHA_VALORACION ?>
		<td<?php echo $assbasalud->FECHA_VALORACION->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_FECHA_VALORACION" class="control-group assbasalud_FECHA_VALORACION">
<span<?php echo $assbasalud->FECHA_VALORACION->ViewAttributes() ?>>
<?php echo $assbasalud->FECHA_VALORACION->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->SEXO->Visible) { // SEXO ?>
		<td<?php echo $assbasalud->SEXO->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_SEXO" class="control-group assbasalud_SEXO">
<span<?php echo $assbasalud->SEXO->ViewAttributes() ?>>
<?php echo $assbasalud->SEXO->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->EDAD_EN_MESES->Visible) { // EDAD_EN_MESES ?>
		<td<?php echo $assbasalud->EDAD_EN_MESES->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_EDAD_EN_MESES" class="control-group assbasalud_EDAD_EN_MESES">
<span<?php echo $assbasalud->EDAD_EN_MESES->ViewAttributes() ?>>
<?php echo $assbasalud->EDAD_EN_MESES->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->TALLA->Visible) { // TALLA ?>
		<td<?php echo $assbasalud->TALLA->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_TALLA" class="control-group assbasalud_TALLA">
<span<?php echo $assbasalud->TALLA->ViewAttributes() ?>>
<?php echo $assbasalud->TALLA->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->PESO->Visible) { // PESO ?>
		<td<?php echo $assbasalud->PESO->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_PESO" class="control-group assbasalud_PESO">
<span<?php echo $assbasalud->PESO->ViewAttributes() ?>>
<?php echo $assbasalud->PESO->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->EPS->Visible) { // EPS ?>
		<td<?php echo $assbasalud->EPS->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_EPS" class="control-group assbasalud_EPS">
<span<?php echo $assbasalud->EPS->ViewAttributes() ?>>
<?php echo $assbasalud->EPS->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->NOMBRE_COMUNA->Visible) { // NOMBRE_COMUNA ?>
		<td<?php echo $assbasalud->NOMBRE_COMUNA->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_NOMBRE_COMUNA" class="control-group assbasalud_NOMBRE_COMUNA">
<span<?php echo $assbasalud->NOMBRE_COMUNA->ViewAttributes() ?>>
<?php echo $assbasalud->NOMBRE_COMUNA->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->NOMBRE_BARRIO->Visible) { // NOMBRE_BARRIO ?>
		<td<?php echo $assbasalud->NOMBRE_BARRIO->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_NOMBRE_BARRIO" class="control-group assbasalud_NOMBRE_BARRIO">
<span<?php echo $assbasalud->NOMBRE_BARRIO->ViewAttributes() ?>>
<?php echo $assbasalud->NOMBRE_BARRIO->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($assbasalud->INDICADOR->Visible) { // INDICADOR ?>
		<td<?php echo $assbasalud->INDICADOR->CellAttributes() ?>><span id="el<?php echo $assbasalud_list->RowCnt ?>_assbasalud_INDICADOR" class="control-group assbasalud_INDICADOR">
<span<?php echo $assbasalud->INDICADOR->ViewAttributes() ?>>
<?php echo $assbasalud->INDICADOR->ListViewValue() ?></span>
</span><a id="<?php echo $assbasalud_list->PageObjName . "_row_" . $assbasalud_list->RowCnt ?>"></a></td>
	<?php } ?>
<?php

// Render list options (body, right)
$assbasalud_list->ListOptions->Render("body", "right", $assbasalud_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($assbasalud->CurrentAction <> "gridadd")
		$assbasalud_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($assbasalud->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($assbasalud_list->Recordset)
	$assbasalud_list->Recordset->Close();
?>
</td></tr></table>
<?php if ($assbasalud->Export == "") { ?>
<script type="text/javascript">
fassbasaludlistsrch.Init();
fassbasaludlist.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php } ?>
<?php
$assbasalud_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($assbasalud->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$assbasalud_list->Page_Terminate();
?>
