<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "assbasaludinfo.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$assbasalud_view = NULL; // Initialize page object first

class cassbasalud_view extends cassbasalud {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{9AEC5002-D3A7-409D-BF52-78D21E1FF26F}";

	// Table name
	var $TableName = 'assbasalud';

	// Page object name
	var $PageObjName = 'assbasalud_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Fotoer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (assbasalud)
		if (!isset($GLOBALS["assbasalud"])) {
			$GLOBALS["assbasalud"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["assbasalud"];
		}
		$KeyUrl = "";
		if (@$_GET["N"] <> "") {
			$this->RecKey["N"] = $_GET["N"];
			$KeyUrl .= "&N=" . urlencode($this->RecKey["N"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS['nutricion_usuario'])) $GLOBALS['nutricion_usuario'] = new cnutricion_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'assbasalud', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "span";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "span";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "span";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("assbasaludlist.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();

		// Get export parameters
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		if (@$_GET["N"] <> "") {
			if ($gsExportFile <> "") $gsExportFile .= "_";
			$gsExportFile .= ew_StripSlashes($_GET["N"]);
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action

		// Setup export options
		$this->SetupExportOptions();
		$this->N->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Update url if printer friendly for Pdf
		if ($this->PrinterFriendlyForPdf)
			$this->ExportOptions->Items["pdf"]->Body = str_replace($this->ExportPdfUrl, $this->ExportPrintUrl . "&pdf=1", $this->ExportOptions->Items["pdf"]->Body);
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();
		if ($this->Export == "print" && @$_GET["pdf"] == "1") { // Printer friendly version and with pdf=1 in URL parameters
			$pdf = new cExportPdf($GLOBALS["Table"]);
			$pdf->Text = ob_get_contents(); // Set the content as the HTML of current page (printer friendly version)
			ob_end_clean();
			$pdf->Export();
		}

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["N"] <> "") {
				$this->N->setQueryStringValue($_GET["N"]);
				$this->RecKey["N"] = $this->N->QueryStringValue;
			} else {
				$sReturnUrl = "assbasaludlist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					if (!$this->LoadRow()) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "assbasaludlist.php"; // No matching record, return to list
					}
			}

			// Export data only
			if (in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "assbasaludlist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->N->setDbValue($rs->fields('N'));
		$this->ANO->setDbValue($rs->fields('ANO'));
		$this->FECHA_VALORACION->setDbValue($rs->fields('FECHA_VALORACION'));
		$this->NUMERO_ID->setDbValue($rs->fields('NUMERO_ID'));
		$this->NOMBRES->setDbValue($rs->fields('NOMBRES'));
		$this->PRIMER_APELLIDO->setDbValue($rs->fields('PRIMER_APELLIDO'));
		$this->SEGUNDO_APELLIDO->setDbValue($rs->fields('SEGUNDO_APELLIDO'));
		$this->FECHA_NACIMIENTO->setDbValue($rs->fields('FECHA_NACIMIENTO'));
		$this->SEXO->setDbValue($rs->fields('SEXO'));
		$this->EDAD_EN_MESES->setDbValue($rs->fields('EDAD_EN_MESES'));
		$this->TALLA->setDbValue($rs->fields('TALLA'));
		$this->PESO->setDbValue($rs->fields('PESO'));
		$this->EPS->setDbValue($rs->fields('EPS'));
		$this->DIRECCION->setDbValue($rs->fields('DIRECCION'));
		$this->TELEFONO->setDbValue($rs->fields('TELEFONO'));
		$this->NOMBRE_COMUNA->setDbValue($rs->fields('NOMBRE_COMUNA'));
		$this->NOMBRE_BARRIO->setDbValue($rs->fields('NOMBRE_BARRIO'));
		$this->INDICADOR->setDbValue($rs->fields('INDICADOR'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->N->DbValue = $row['N'];
		$this->ANO->DbValue = $row['ANO'];
		$this->FECHA_VALORACION->DbValue = $row['FECHA_VALORACION'];
		$this->NUMERO_ID->DbValue = $row['NUMERO_ID'];
		$this->NOMBRES->DbValue = $row['NOMBRES'];
		$this->PRIMER_APELLIDO->DbValue = $row['PRIMER_APELLIDO'];
		$this->SEGUNDO_APELLIDO->DbValue = $row['SEGUNDO_APELLIDO'];
		$this->FECHA_NACIMIENTO->DbValue = $row['FECHA_NACIMIENTO'];
		$this->SEXO->DbValue = $row['SEXO'];
		$this->EDAD_EN_MESES->DbValue = $row['EDAD_EN_MESES'];
		$this->TALLA->DbValue = $row['TALLA'];
		$this->PESO->DbValue = $row['PESO'];
		$this->EPS->DbValue = $row['EPS'];
		$this->DIRECCION->DbValue = $row['DIRECCION'];
		$this->TELEFONO->DbValue = $row['TELEFONO'];
		$this->NOMBRE_COMUNA->DbValue = $row['NOMBRE_COMUNA'];
		$this->NOMBRE_BARRIO->DbValue = $row['NOMBRE_BARRIO'];
		$this->INDICADOR->DbValue = $row['INDICADOR'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Convert decimal values if posted back
		if ($this->PESO->FormValue == $this->PESO->CurrentValue && is_numeric(ew_StrToFloat($this->PESO->CurrentValue)))
			$this->PESO->CurrentValue = ew_StrToFloat($this->PESO->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// N
		// ANO
		// FECHA_VALORACION
		// NUMERO_ID
		// NOMBRES
		// PRIMER_APELLIDO
		// SEGUNDO_APELLIDO
		// FECHA_NACIMIENTO
		// SEXO
		// EDAD_EN_MESES
		// TALLA
		// PESO
		// EPS
		// DIRECCION
		// TELEFONO
		// NOMBRE_COMUNA
		// NOMBRE_BARRIO
		// INDICADOR

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// N
			$this->N->ViewValue = $this->N->CurrentValue;
			$this->N->ViewCustomAttributes = "";

			// ANO
			$this->ANO->ViewValue = $this->ANO->CurrentValue;
			$this->ANO->ViewCustomAttributes = "";

			// FECHA_VALORACION
			$this->FECHA_VALORACION->ViewValue = $this->FECHA_VALORACION->CurrentValue;
			$this->FECHA_VALORACION->ViewValue = ew_FormatDateTime($this->FECHA_VALORACION->ViewValue, 7);
			$this->FECHA_VALORACION->ViewCustomAttributes = "";

			// NUMERO_ID
			$this->NUMERO_ID->ViewValue = $this->NUMERO_ID->CurrentValue;
			$this->NUMERO_ID->ViewCustomAttributes = "";

			// NOMBRES
			$this->NOMBRES->ViewValue = $this->NOMBRES->CurrentValue;
			$this->NOMBRES->ViewCustomAttributes = "";

			// PRIMER_APELLIDO
			$this->PRIMER_APELLIDO->ViewValue = $this->PRIMER_APELLIDO->CurrentValue;
			$this->PRIMER_APELLIDO->ViewCustomAttributes = "";

			// SEGUNDO_APELLIDO
			$this->SEGUNDO_APELLIDO->ViewValue = $this->SEGUNDO_APELLIDO->CurrentValue;
			$this->SEGUNDO_APELLIDO->ViewCustomAttributes = "";

			// FECHA_NACIMIENTO
			$this->FECHA_NACIMIENTO->ViewValue = $this->FECHA_NACIMIENTO->CurrentValue;
			$this->FECHA_NACIMIENTO->ViewValue = ew_FormatDateTime($this->FECHA_NACIMIENTO->ViewValue, 7);
			$this->FECHA_NACIMIENTO->ViewCustomAttributes = "";

			// SEXO
			$this->SEXO->ViewValue = $this->SEXO->CurrentValue;
			$this->SEXO->ViewCustomAttributes = "";

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->ViewValue = $this->EDAD_EN_MESES->CurrentValue;
			$this->EDAD_EN_MESES->ViewCustomAttributes = "";

			// TALLA
			$this->TALLA->ViewValue = $this->TALLA->CurrentValue;
			$this->TALLA->CellCssStyle .= "text-align: right;";
			$this->TALLA->ViewCustomAttributes = "";

			// PESO
			$this->PESO->ViewValue = $this->PESO->CurrentValue;
			$this->PESO->CellCssStyle .= "text-align: right;";
			$this->PESO->ViewCustomAttributes = "";

			// EPS
			$this->EPS->ViewValue = $this->EPS->CurrentValue;
			$this->EPS->ViewCustomAttributes = "";

			// DIRECCION
			$this->DIRECCION->ViewValue = $this->DIRECCION->CurrentValue;
			$this->DIRECCION->ViewCustomAttributes = "";

			// TELEFONO
			$this->TELEFONO->ViewValue = $this->TELEFONO->CurrentValue;
			$this->TELEFONO->ViewCustomAttributes = "";

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->ViewValue = $this->NOMBRE_COMUNA->CurrentValue;
			$this->NOMBRE_COMUNA->ViewCustomAttributes = "";

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->ViewValue = $this->NOMBRE_BARRIO->CurrentValue;
			$this->NOMBRE_BARRIO->ViewCustomAttributes = "";

			// INDICADOR
			$this->INDICADOR->ViewValue = $this->INDICADOR->CurrentValue;
			$this->INDICADOR->CellCssStyle .= "text-align: right;";
			$this->INDICADOR->ViewCustomAttributes = "";

			// N
			$this->N->LinkCustomAttributes = "";
			$this->N->HrefValue = "";
			$this->N->TooltipValue = "";

			// ANO
			$this->ANO->LinkCustomAttributes = "";
			$this->ANO->HrefValue = "";
			$this->ANO->TooltipValue = "";

			// FECHA_VALORACION
			$this->FECHA_VALORACION->LinkCustomAttributes = "";
			$this->FECHA_VALORACION->HrefValue = "";
			$this->FECHA_VALORACION->TooltipValue = "";

			// NUMERO_ID
			$this->NUMERO_ID->LinkCustomAttributes = "";
			$this->NUMERO_ID->HrefValue = "";
			$this->NUMERO_ID->TooltipValue = "";

			// NOMBRES
			$this->NOMBRES->LinkCustomAttributes = "";
			$this->NOMBRES->HrefValue = "";
			$this->NOMBRES->TooltipValue = "";

			// PRIMER_APELLIDO
			$this->PRIMER_APELLIDO->LinkCustomAttributes = "";
			$this->PRIMER_APELLIDO->HrefValue = "";
			$this->PRIMER_APELLIDO->TooltipValue = "";

			// SEGUNDO_APELLIDO
			$this->SEGUNDO_APELLIDO->LinkCustomAttributes = "";
			$this->SEGUNDO_APELLIDO->HrefValue = "";
			$this->SEGUNDO_APELLIDO->TooltipValue = "";

			// FECHA_NACIMIENTO
			$this->FECHA_NACIMIENTO->LinkCustomAttributes = "";
			$this->FECHA_NACIMIENTO->HrefValue = "";
			$this->FECHA_NACIMIENTO->TooltipValue = "";

			// SEXO
			$this->SEXO->LinkCustomAttributes = "";
			$this->SEXO->HrefValue = "";
			$this->SEXO->TooltipValue = "";

			// EDAD_EN_MESES
			$this->EDAD_EN_MESES->LinkCustomAttributes = "";
			$this->EDAD_EN_MESES->HrefValue = "";
			$this->EDAD_EN_MESES->TooltipValue = "";

			// TALLA
			$this->TALLA->LinkCustomAttributes = "";
			$this->TALLA->HrefValue = "";
			$this->TALLA->TooltipValue = "";

			// PESO
			$this->PESO->LinkCustomAttributes = "";
			$this->PESO->HrefValue = "";
			$this->PESO->TooltipValue = "";

			// EPS
			$this->EPS->LinkCustomAttributes = "";
			$this->EPS->HrefValue = "";
			$this->EPS->TooltipValue = "";

			// DIRECCION
			$this->DIRECCION->LinkCustomAttributes = "";
			$this->DIRECCION->HrefValue = "";
			$this->DIRECCION->TooltipValue = "";

			// TELEFONO
			$this->TELEFONO->LinkCustomAttributes = "";
			$this->TELEFONO->HrefValue = "";
			$this->TELEFONO->TooltipValue = "";

			// NOMBRE_COMUNA
			$this->NOMBRE_COMUNA->LinkCustomAttributes = "";
			$this->NOMBRE_COMUNA->HrefValue = "";
			$this->NOMBRE_COMUNA->TooltipValue = "";

			// NOMBRE_BARRIO
			$this->NOMBRE_BARRIO->LinkCustomAttributes = "";
			$this->NOMBRE_BARRIO->HrefValue = "";
			$this->NOMBRE_BARRIO->TooltipValue = "";

			// INDICADOR
			$this->INDICADOR->LinkCustomAttributes = "";
			$this->INDICADOR->HrefValue = "";
			$this->INDICADOR->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$item->Body = "<a id=\"emf_assbasalud\" href=\"javascript:void(0);\" class=\"ewExportLink ewEmail\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_assbasalud',hdr:ewLanguage.Phrase('ExportToEmail'),f:document.fassbasaludview,key:" . ew_ArrayToJsonAttr($this->RecKey) . ",sel:false});\">" . $Language->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = FALSE;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if ($rs = $this->LoadRecordset())
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;
		$this->SetUpStartRec(); // Set up start record position

		// Set the last record to display
		if ($this->DisplayRecs <= 0) {
			$this->StopRec = $this->TotalRecs;
		} else {
			$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
		}
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$ExportDoc = ew_ExportDocument($this, "v");
		$ParentTable = "";
		if ($bSelectLimit) {
			$StartRec = 1;
			$StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {
			$StartRec = $this->StartRec;
			$StopRec = $this->StopRec;
		}
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$ExportDoc->Text .= $sHeader;
		$this->ExportDocument($ExportDoc, $rs, $StartRec, $StopRec, "view");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$ExportDoc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Export header and footer
		$ExportDoc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED)
			echo ew_DebugMsg();

		// Output data
		$ExportDoc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "assbasaludlist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("view");
		$Breadcrumb->Add("view", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($assbasalud_view)) $assbasalud_view = new cassbasalud_view();

// Page init
$assbasalud_view->Page_Init();

// Page main
$assbasalud_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$assbasalud_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($assbasalud->Export == "") { ?>
<script type="text/javascript">

// Page object
var assbasalud_view = new ew_Page("assbasalud_view");
assbasalud_view.PageID = "view"; // Page ID
var EW_PAGE_ID = assbasalud_view.PageID; // For backward compatibility

// Form object
var fassbasaludview = new ew_Form("fassbasaludview");

// Form_CustomValidate event
fassbasaludview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fassbasaludview.ValidateRequired = true;
<?php } else { ?>
fassbasaludview.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($assbasalud->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($assbasalud->Export == "") { ?>
<div class="ewViewExportOptions">
<?php $assbasalud_view->ExportOptions->Render("body") ?>
<?php if (!$assbasalud_view->ExportOptions->UseDropDownButton) { ?>
</div>
<div class="ewViewOtherOptions">
<?php } ?>
<?php
	foreach ($assbasalud_view->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<?php } ?>
<?php $assbasalud_view->ShowPageHeader(); ?>
<?php
$assbasalud_view->ShowMessage();
?>
<form name="fassbasaludview" id="fassbasaludview" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="assbasalud">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_assbasaludview" class="table table-bordered table-striped">
<?php if ($assbasalud->N->Visible) { // N ?>
	<tr id="r_N"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_N"><?php echo $assbasalud->N->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->N->CellAttributes() ?>><span id="el_assbasalud_N" class="control-group">
<span<?php echo $assbasalud->N->ViewAttributes() ?>>
<?php echo $assbasalud->N->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->ANO->Visible) { // ANO ?>
	<tr id="r_ANO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_ANO"><?php echo $assbasalud->ANO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->ANO->CellAttributes() ?>><span id="el_assbasalud_ANO" class="control-group">
<span<?php echo $assbasalud->ANO->ViewAttributes() ?>>
<?php echo $assbasalud->ANO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->FECHA_VALORACION->Visible) { // FECHA_VALORACION ?>
	<tr id="r_FECHA_VALORACION"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_FECHA_VALORACION"><?php echo $assbasalud->FECHA_VALORACION->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->FECHA_VALORACION->CellAttributes() ?>><span id="el_assbasalud_FECHA_VALORACION" class="control-group">
<span<?php echo $assbasalud->FECHA_VALORACION->ViewAttributes() ?>>
<?php echo $assbasalud->FECHA_VALORACION->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NUMERO_ID->Visible) { // NUMERO_ID ?>
	<tr id="r_NUMERO_ID"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NUMERO_ID"><?php echo $assbasalud->NUMERO_ID->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NUMERO_ID->CellAttributes() ?>><span id="el_assbasalud_NUMERO_ID" class="control-group">
<span<?php echo $assbasalud->NUMERO_ID->ViewAttributes() ?>>
<?php echo $assbasalud->NUMERO_ID->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NOMBRES->Visible) { // NOMBRES ?>
	<tr id="r_NOMBRES"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NOMBRES"><?php echo $assbasalud->NOMBRES->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NOMBRES->CellAttributes() ?>><span id="el_assbasalud_NOMBRES" class="control-group">
<span<?php echo $assbasalud->NOMBRES->ViewAttributes() ?>>
<?php echo $assbasalud->NOMBRES->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->PRIMER_APELLIDO->Visible) { // PRIMER_APELLIDO ?>
	<tr id="r_PRIMER_APELLIDO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_PRIMER_APELLIDO"><?php echo $assbasalud->PRIMER_APELLIDO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->PRIMER_APELLIDO->CellAttributes() ?>><span id="el_assbasalud_PRIMER_APELLIDO" class="control-group">
<span<?php echo $assbasalud->PRIMER_APELLIDO->ViewAttributes() ?>>
<?php echo $assbasalud->PRIMER_APELLIDO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->SEGUNDO_APELLIDO->Visible) { // SEGUNDO_APELLIDO ?>
	<tr id="r_SEGUNDO_APELLIDO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_SEGUNDO_APELLIDO"><?php echo $assbasalud->SEGUNDO_APELLIDO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->SEGUNDO_APELLIDO->CellAttributes() ?>><span id="el_assbasalud_SEGUNDO_APELLIDO" class="control-group">
<span<?php echo $assbasalud->SEGUNDO_APELLIDO->ViewAttributes() ?>>
<?php echo $assbasalud->SEGUNDO_APELLIDO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->FECHA_NACIMIENTO->Visible) { // FECHA_NACIMIENTO ?>
	<tr id="r_FECHA_NACIMIENTO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_FECHA_NACIMIENTO"><?php echo $assbasalud->FECHA_NACIMIENTO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->FECHA_NACIMIENTO->CellAttributes() ?>><span id="el_assbasalud_FECHA_NACIMIENTO" class="control-group">
<span<?php echo $assbasalud->FECHA_NACIMIENTO->ViewAttributes() ?>>
<?php echo $assbasalud->FECHA_NACIMIENTO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->SEXO->Visible) { // SEXO ?>
	<tr id="r_SEXO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_SEXO"><?php echo $assbasalud->SEXO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->SEXO->CellAttributes() ?>><span id="el_assbasalud_SEXO" class="control-group">
<span<?php echo $assbasalud->SEXO->ViewAttributes() ?>>
<?php echo $assbasalud->SEXO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->EDAD_EN_MESES->Visible) { // EDAD_EN_MESES ?>
	<tr id="r_EDAD_EN_MESES"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_EDAD_EN_MESES"><?php echo $assbasalud->EDAD_EN_MESES->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->EDAD_EN_MESES->CellAttributes() ?>><span id="el_assbasalud_EDAD_EN_MESES" class="control-group">
<span<?php echo $assbasalud->EDAD_EN_MESES->ViewAttributes() ?>>
<?php echo $assbasalud->EDAD_EN_MESES->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->TALLA->Visible) { // TALLA ?>
	<tr id="r_TALLA"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_TALLA"><?php echo $assbasalud->TALLA->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->TALLA->CellAttributes() ?>><span id="el_assbasalud_TALLA" class="control-group">
<span<?php echo $assbasalud->TALLA->ViewAttributes() ?>>
<?php echo $assbasalud->TALLA->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->PESO->Visible) { // PESO ?>
	<tr id="r_PESO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_PESO"><?php echo $assbasalud->PESO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->PESO->CellAttributes() ?>><span id="el_assbasalud_PESO" class="control-group">
<span<?php echo $assbasalud->PESO->ViewAttributes() ?>>
<?php echo $assbasalud->PESO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->EPS->Visible) { // EPS ?>
	<tr id="r_EPS"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_EPS"><?php echo $assbasalud->EPS->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->EPS->CellAttributes() ?>><span id="el_assbasalud_EPS" class="control-group">
<span<?php echo $assbasalud->EPS->ViewAttributes() ?>>
<?php echo $assbasalud->EPS->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->DIRECCION->Visible) { // DIRECCION ?>
	<tr id="r_DIRECCION"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_DIRECCION"><?php echo $assbasalud->DIRECCION->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->DIRECCION->CellAttributes() ?>><span id="el_assbasalud_DIRECCION" class="control-group">
<span<?php echo $assbasalud->DIRECCION->ViewAttributes() ?>>
<?php echo $assbasalud->DIRECCION->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->TELEFONO->Visible) { // TELEFONO ?>
	<tr id="r_TELEFONO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_TELEFONO"><?php echo $assbasalud->TELEFONO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->TELEFONO->CellAttributes() ?>><span id="el_assbasalud_TELEFONO" class="control-group">
<span<?php echo $assbasalud->TELEFONO->ViewAttributes() ?>>
<?php echo $assbasalud->TELEFONO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NOMBRE_COMUNA->Visible) { // NOMBRE_COMUNA ?>
	<tr id="r_NOMBRE_COMUNA"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NOMBRE_COMUNA"><?php echo $assbasalud->NOMBRE_COMUNA->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NOMBRE_COMUNA->CellAttributes() ?>><span id="el_assbasalud_NOMBRE_COMUNA" class="control-group">
<span<?php echo $assbasalud->NOMBRE_COMUNA->ViewAttributes() ?>>
<?php echo $assbasalud->NOMBRE_COMUNA->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->NOMBRE_BARRIO->Visible) { // NOMBRE_BARRIO ?>
	<tr id="r_NOMBRE_BARRIO"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_NOMBRE_BARRIO"><?php echo $assbasalud->NOMBRE_BARRIO->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->NOMBRE_BARRIO->CellAttributes() ?>><span id="el_assbasalud_NOMBRE_BARRIO" class="control-group">
<span<?php echo $assbasalud->NOMBRE_BARRIO->ViewAttributes() ?>>
<?php echo $assbasalud->NOMBRE_BARRIO->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
<?php if ($assbasalud->INDICADOR->Visible) { // INDICADOR ?>
	<tr id="r_INDICADOR"<?php echo $assbasalud->RowAttributes() ?>>
		<td><span id="elh_assbasalud_INDICADOR"><?php echo $assbasalud->INDICADOR->FldCaption() ?></span></td>
		<td<?php echo $assbasalud->INDICADOR->CellAttributes() ?>><span id="el_assbasalud_INDICADOR" class="control-group">
<span<?php echo $assbasalud->INDICADOR->ViewAttributes() ?>>
<?php echo $assbasalud->INDICADOR->ViewValue ?></span>
</span></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
</form>
<script type="text/javascript">
fassbasaludview.Init();
</script>
<?php
$assbasalud_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($assbasalud->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$assbasalud_view->Page_Terminate();
?>
