<?php

// Global variable for table object
$entidad_upgd = NULL;

//
// Table class for entidad_upgd
//
class centidad_upgd extends cTable {
	var $consecutivo;
	var $Codigo;
	var $Entidad;
	var $Tipo_Entidad;
	var $Activa;
	var $Direccion;
	var $Info;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'entidad_upgd';
		$this->TableName = 'entidad_upgd';
		$this->TableType = 'TABLE';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = ew_AllowAddDeleteRow(); // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// consecutivo
		$this->consecutivo = new cField('entidad_upgd', 'entidad_upgd', 'x_consecutivo', 'consecutivo', '`consecutivo`', '`consecutivo`', 19, -1, FALSE, '`consecutivo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->consecutivo->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['consecutivo'] = &$this->consecutivo;

		// Codigo
		$this->Codigo = new cField('entidad_upgd', 'entidad_upgd', 'x_Codigo', 'Codigo', '`Codigo`', '`Codigo`', 200, -1, FALSE, '`Codigo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Codigo'] = &$this->Codigo;

		// Entidad
		$this->Entidad = new cField('entidad_upgd', 'entidad_upgd', 'x_Entidad', 'Entidad', '`Entidad`', '`Entidad`', 200, -1, FALSE, '`Entidad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Entidad'] = &$this->Entidad;

		// Tipo_Entidad
		$this->Tipo_Entidad = new cField('entidad_upgd', 'entidad_upgd', 'x_Tipo_Entidad', 'Tipo_Entidad', '`Tipo_Entidad`', '`Tipo_Entidad`', 19, -1, FALSE, '`Tipo_Entidad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Tipo_Entidad->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Tipo_Entidad'] = &$this->Tipo_Entidad;

		// Activa
		$this->Activa = new cField('entidad_upgd', 'entidad_upgd', 'x_Activa', 'Activa', '`Activa`', '`Activa`', 16, -1, FALSE, '`Activa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->Activa->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Activa'] = &$this->Activa;

		// Direccion
		$this->Direccion = new cField('entidad_upgd', 'entidad_upgd', 'x_Direccion', 'Direccion', '`Direccion`', '`Direccion`', 200, -1, FALSE, '`Direccion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Direccion'] = &$this->Direccion;

		// Info
		$this->Info = new cField('entidad_upgd', 'entidad_upgd', 'x_Info', 'Info', '`Info`', '`Info`', 201, -1, FALSE, '`Info`', FALSE, FALSE, FALSE, 'FORMATTED TEXT');
		$this->fields['Info'] = &$this->Info;
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	function SqlFrom() { // From
		return "`entidad_upgd`";
	}

	function SqlSelect() { // Select
		return "SELECT * FROM " . $this->SqlFrom();
	}

	function SqlWhere() { // Where
		$sWhere = "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlGroupBy() { // Group By
		return "";
	}

	function SqlHaving() { // Having
		return "";
	}

	function SqlOrderBy() { // Order By
		return "";
	}

	// Check if Anonymous User is allowed
	function AllowAnonymousUser() {
		switch (@$this->PageID) {
			case "add":
			case "register":
			case "addopt":
				return FALSE;
			case "edit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return FALSE;
			case "delete":
				return FALSE;
			case "view":
				return FALSE;
			case "search":
				return FALSE;
			default:
				return FALSE;
		}
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(),
			$this->SqlGroupBy(), $this->SqlHaving(), $this->SqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$sFilter = $this->CurrentFilter;
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(),
			$this->SqlGroupBy(), $this->SqlHaving(), $this->SqlOrderBy(),
			$sFilter, $sSort);
	}

	// Table SQL with List page filter
	function SelectSQL() {
		$sFilter = $this->getSessionWhere();
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->SqlSelect(), $this->SqlWhere(), $this->SqlGroupBy(),
			$this->SqlHaving(), $this->SqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->SqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sSql) {
		global $conn;
		$cnt = -1;
		if ($this->TableType == 'TABLE' || $this->TableType == 'VIEW') {
			$sSql = "SELECT COUNT(*) FROM" . substr($sSql, 13);
			$sOrderBy = $this->GetOrderBy();
			if (substr($sSql, strlen($sOrderBy) * -1) == $sOrderBy)
				$sSql = substr($sSql, 0, strlen($sSql) - strlen($sOrderBy)); // Remove ORDER BY clause
		} else {
			$sSql = "SELECT COUNT(*) FROM (" . $sSql . ") EW_COUNT_TABLE";
		}
		if ($rs = $conn->Execute($sSql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($sFilter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $sFilter;
		$this->Recordset_Selecting($this->CurrentFilter);

		//$sSql = $this->SQL();
		$sSql = $this->GetSQL($this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function SelectRecordCount() {
		global $conn;
		$origFilter = $this->CurrentFilter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$sSql = $this->SelectSQL();
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $conn->Execute($sSql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Update Table
	var $UpdateTable = "`entidad_upgd`";

	// INSERT statement
	function InsertSQL(&$rs) {
		global $conn;
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]))
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType) . ",";
		}
		while (substr($names, -1) == ",")
			$names = substr($names, 0, -1);
		while (substr($values, -1) == ",")
			$values = substr($values, 0, -1);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		global $conn;
		return $conn->Execute($this->InsertSQL($rs));
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "") {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]))
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType) . ",";
		}
		while (substr($sql, -1) == ",")
			$sql = substr($sql, 0, -1);
		$filter = $this->CurrentFilter;
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL) {
		global $conn;
		return $conn->Execute($this->UpdateSQL($rs, $where));
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "") {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if ($rs) {
			if (array_key_exists('consecutivo', $rs))
				ew_AddFilter($where, ew_QuotedName('consecutivo') . '=' . ew_QuotedValue($rs['consecutivo'], $this->consecutivo->FldDataType));
		}
		$filter = $this->CurrentFilter;
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "") {
		global $conn;
		return $conn->Execute($this->DeleteSQL($rs, $where));
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`consecutivo` = @consecutivo@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->consecutivo->CurrentValue))
			$sKeyFilter = "0=1"; // Invalid key
		$sKeyFilter = str_replace("@consecutivo@", ew_AdjustSql($this->consecutivo->CurrentValue), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "entidad_upgdlist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// List URL
	function GetListUrl() {
		return "entidad_upgdlist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			return $this->KeyUrl("entidad_upgdview.php", $this->UrlParm($parm));
		else
			return $this->KeyUrl("entidad_upgdview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
	}

	// Add URL
	function GetAddUrl() {
		return "entidad_upgdadd.php";
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		return $this->KeyUrl("entidad_upgdedit.php", $this->UrlParm($parm));
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		return $this->KeyUrl("entidad_upgdadd.php", $this->UrlParm($parm));
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		return $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("entidad_upgddelete.php", $this->UrlParm());
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->consecutivo->CurrentValue)) {
			$sUrl .= "consecutivo=" . urlencode($this->consecutivo->CurrentValue);
		} else {
			return "javascript:alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&ordertype=" . $fld->ReverseSort());
			return ew_CurrentPage() . "?" . $sUrlParm;
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = ew_StripSlashes($_POST["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = ew_StripSlashes($_GET["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET)) {
			$arKeys[] = @$_GET["consecutivo"]; // consecutivo

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		foreach ($arKeys as $key) {
			if (!is_numeric($key))
				continue;
			$ar[] = $key;
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->consecutivo->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($sFilter) {
		global $conn;

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $sFilter;
		//$sSql = $this->SQL();

		$sSql = $this->GetSQL($sFilter, "");
		$rs = $conn->Execute($sSql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->consecutivo->setDbValue($rs->fields('consecutivo'));
		$this->Codigo->setDbValue($rs->fields('Codigo'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->Tipo_Entidad->setDbValue($rs->fields('Tipo_Entidad'));
		$this->Activa->setDbValue($rs->fields('Activa'));
		$this->Direccion->setDbValue($rs->fields('Direccion'));
		$this->Info->setDbValue($rs->fields('Info'));
	}

	// Render list row values
	function RenderListRow() {
		global $conn, $Security;

		// Call Row Rendering event
		$this->Row_Rendering();

   // Common render codes
		// consecutivo
		// Codigo
		// Entidad
		// Tipo_Entidad
		// Activa
		// Direccion
		// Info
		// consecutivo

		$this->consecutivo->ViewValue = $this->consecutivo->CurrentValue;
		$this->consecutivo->ViewCustomAttributes = "";

		// Codigo
		$this->Codigo->ViewValue = $this->Codigo->CurrentValue;
		$this->Codigo->ViewCustomAttributes = "";

		// Entidad
		$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
		$this->Entidad->ViewCustomAttributes = "";

		// Tipo_Entidad
		if (strval($this->Tipo_Entidad->CurrentValue) <> "") {
			switch ($this->Tipo_Entidad->CurrentValue) {
				case $this->Tipo_Entidad->FldTagValue(1):
					$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(1) <> "" ? $this->Tipo_Entidad->FldTagCaption(1) : $this->Tipo_Entidad->CurrentValue;
					break;
				case $this->Tipo_Entidad->FldTagValue(2):
					$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(2) <> "" ? $this->Tipo_Entidad->FldTagCaption(2) : $this->Tipo_Entidad->CurrentValue;
					break;
				default:
					$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->CurrentValue;
			}
		} else {
			$this->Tipo_Entidad->ViewValue = NULL;
		}
		$this->Tipo_Entidad->ViewCustomAttributes = "";

		// Activa
		if (strval($this->Activa->CurrentValue) <> "") {
			switch ($this->Activa->CurrentValue) {
				case $this->Activa->FldTagValue(1):
					$this->Activa->ViewValue = $this->Activa->FldTagCaption(1) <> "" ? $this->Activa->FldTagCaption(1) : $this->Activa->CurrentValue;
					break;
				case $this->Activa->FldTagValue(2):
					$this->Activa->ViewValue = $this->Activa->FldTagCaption(2) <> "" ? $this->Activa->FldTagCaption(2) : $this->Activa->CurrentValue;
					break;
				default:
					$this->Activa->ViewValue = $this->Activa->CurrentValue;
			}
		} else {
			$this->Activa->ViewValue = NULL;
		}
		$this->Activa->ViewCustomAttributes = "";

		// Direccion
		$this->Direccion->ViewValue = $this->Direccion->CurrentValue;
		$this->Direccion->ViewCustomAttributes = "";

		// Info
		$this->Info->ViewValue = $this->Info->CurrentValue;
		$this->Info->ViewCustomAttributes = "";

		// consecutivo
		$this->consecutivo->LinkCustomAttributes = "";
		$this->consecutivo->HrefValue = "";
		$this->consecutivo->TooltipValue = "";

		// Codigo
		$this->Codigo->LinkCustomAttributes = "";
		$this->Codigo->HrefValue = "";
		$this->Codigo->TooltipValue = "";

		// Entidad
		$this->Entidad->LinkCustomAttributes = "";
		$this->Entidad->HrefValue = "";
		$this->Entidad->TooltipValue = "";

		// Tipo_Entidad
		$this->Tipo_Entidad->LinkCustomAttributes = "";
		$this->Tipo_Entidad->HrefValue = "";
		$this->Tipo_Entidad->TooltipValue = "";

		// Activa
		$this->Activa->LinkCustomAttributes = "";
		$this->Activa->HrefValue = "";
		$this->Activa->TooltipValue = "";

		// Direccion
		$this->Direccion->LinkCustomAttributes = "";
		$this->Direccion->HrefValue = "";
		$this->Direccion->TooltipValue = "";

		// Info
		$this->Info->LinkCustomAttributes = "";
		$this->Info->HrefValue = "";
		$this->Info->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;

		// Write header
		$Doc->ExportTableHeader();
		if ($Doc->Horizontal) { // Horizontal format, write header
			$Doc->BeginExportRow();
			if ($ExportPageType == "view") {
				if ($this->Codigo->Exportable) $Doc->ExportCaption($this->Codigo);
				if ($this->Entidad->Exportable) $Doc->ExportCaption($this->Entidad);
				if ($this->Tipo_Entidad->Exportable) $Doc->ExportCaption($this->Tipo_Entidad);
				if ($this->Activa->Exportable) $Doc->ExportCaption($this->Activa);
				if ($this->Direccion->Exportable) $Doc->ExportCaption($this->Direccion);
				if ($this->Info->Exportable) $Doc->ExportCaption($this->Info);
			} else {
				if ($this->consecutivo->Exportable) $Doc->ExportCaption($this->consecutivo);
				if ($this->Codigo->Exportable) $Doc->ExportCaption($this->Codigo);
				if ($this->Entidad->Exportable) $Doc->ExportCaption($this->Entidad);
				if ($this->Tipo_Entidad->Exportable) $Doc->ExportCaption($this->Tipo_Entidad);
				if ($this->Activa->Exportable) $Doc->ExportCaption($this->Activa);
				if ($this->Direccion->Exportable) $Doc->ExportCaption($this->Direccion);
			}
			$Doc->EndExportRow();
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
				if ($ExportPageType == "view") {
					if ($this->Codigo->Exportable) $Doc->ExportField($this->Codigo);
					if ($this->Entidad->Exportable) $Doc->ExportField($this->Entidad);
					if ($this->Tipo_Entidad->Exportable) $Doc->ExportField($this->Tipo_Entidad);
					if ($this->Activa->Exportable) $Doc->ExportField($this->Activa);
					if ($this->Direccion->Exportable) $Doc->ExportField($this->Direccion);
					if ($this->Info->Exportable) $Doc->ExportField($this->Info);
				} else {
					if ($this->consecutivo->Exportable) $Doc->ExportField($this->consecutivo);
					if ($this->Codigo->Exportable) $Doc->ExportField($this->Codigo);
					if ($this->Entidad->Exportable) $Doc->ExportField($this->Entidad);
					if ($this->Tipo_Entidad->Exportable) $Doc->ExportField($this->Tipo_Entidad);
					if ($this->Activa->Exportable) $Doc->ExportField($this->Activa);
					if ($this->Direccion->Exportable) $Doc->ExportField($this->Direccion);
				}
				$Doc->EndExportRow();
			}
			$Recordset->MoveNext();
		}
		$Doc->ExportTableFooter();
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here	
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here	
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here	
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		// Enter your code here
	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here	
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>); 

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
