<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "nutricion_valoracioninfo.php" ?>
<?php include_once "nutricion_usuarioinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$nutricion_valoracion_edit = NULL; // Initialize page object first

class cnutricion_valoracion_edit extends cnutricion_valoracion {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = "{9AEC5002-D3A7-409D-BF52-78D21E1FF26F}";

	// Table name
	var $TableName = 'nutricion_valoracion';

	// Page object name
	var $PageObjName = 'nutricion_valoracion_edit';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Fotoer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (nutricion_valoracion)
		if (!isset($GLOBALS["nutricion_valoracion"])) {
			$GLOBALS["nutricion_valoracion"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["nutricion_valoracion"];
		}

		// Table object (nutricion_usuario)
		if (!isset($GLOBALS['nutricion_usuario'])) $GLOBALS['nutricion_usuario'] = new cnutricion_usuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'nutricion_valoracion', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		$Security->TablePermission_Loaded();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("nutricion_valoracionlist.php");
		}
		$Security->UserID_Loading();
		if ($Security->IsLoggedIn()) $Security->LoadUserID();
		$Security->UserID_Loaded();
		if ($Security->IsLoggedIn() && strval($Security->CurrentUserID()) == "") {
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate("nutricion_valoracionlist.php");
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter;
	var $DbDetailFilter;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Load key from QueryString
		if (@$_GET["Consecutivo"] <> "") {
			$this->Consecutivo->setQueryStringValue($_GET["Consecutivo"]);
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Process form if post back
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			$this->LoadFormValues(); // Get form values
		} else {
			$this->CurrentAction = "I"; // Default action is display
		}

		// Check if valid key
		if ($this->Consecutivo->CurrentValue == "")
			$this->Page_Terminate("nutricion_valoracionlist.php"); // Invalid key, return to list

		// Validate form if post back
		if (@$_POST["a_edit"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("nutricion_valoracionlist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$sReturnUrl = $this->getReturnUrl();
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
		$index = $objForm->Index; // Save form index
		$objForm->Index = -1;
		$objForm->Index = $index; // Restore form index
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->Entidad_Valora->FldIsDetailKey) {
			$this->Entidad_Valora->setFormValue($objForm->GetValue("x_Entidad_Valora"));
		}
		if (!$this->Tipo_Entidad->FldIsDetailKey) {
			$this->Tipo_Entidad->setFormValue($objForm->GetValue("x_Tipo_Entidad"));
		}
		if (!$this->Tipo_Documento->FldIsDetailKey) {
			$this->Tipo_Documento->setFormValue($objForm->GetValue("x_Tipo_Documento"));
		}
		if (!$this->Documento->FldIsDetailKey) {
			$this->Documento->setFormValue($objForm->GetValue("x_Documento"));
		}
		if (!$this->Fecha_Nacimiento->FldIsDetailKey) {
			$this->Fecha_Nacimiento->setFormValue($objForm->GetValue("x_Fecha_Nacimiento"));
			$this->Fecha_Nacimiento->CurrentValue = ew_UnFormatDateTime($this->Fecha_Nacimiento->CurrentValue, 7);
		}
		if (!$this->Genero->FldIsDetailKey) {
			$this->Genero->setFormValue($objForm->GetValue("x_Genero"));
		}
		if (!$this->Nombres->FldIsDetailKey) {
			$this->Nombres->setFormValue($objForm->GetValue("x_Nombres"));
		}
		if (!$this->Apellidos->FldIsDetailKey) {
			$this->Apellidos->setFormValue($objForm->GetValue("x_Apellidos"));
		}
		if (!$this->Fecha_valoracion->FldIsDetailKey) {
			$this->Fecha_valoracion->setFormValue($objForm->GetValue("x_Fecha_valoracion"));
			$this->Fecha_valoracion->CurrentValue = ew_UnFormatDateTime($this->Fecha_valoracion->CurrentValue, 7);
		}
		if (!$this->Edad_Anos->FldIsDetailKey) {
			$this->Edad_Anos->setFormValue($objForm->GetValue("x_Edad_Anos"));
		}
		if (!$this->Edad_Meses->FldIsDetailKey) {
			$this->Edad_Meses->setFormValue($objForm->GetValue("x_Edad_Meses"));
		}
		if (!$this->Peso->FldIsDetailKey) {
			$this->Peso->setFormValue($objForm->GetValue("x_Peso"));
		}
		if (!$this->Talla->FldIsDetailKey) {
			$this->Talla->setFormValue($objForm->GetValue("x_Talla"));
		}
		if (!$this->Perimetro_Cefalico->FldIsDetailKey) {
			$this->Perimetro_Cefalico->setFormValue($objForm->GetValue("x_Perimetro_Cefalico"));
		}
		if (!$this->Perimetro_Abdominal->FldIsDetailKey) {
			$this->Perimetro_Abdominal->setFormValue($objForm->GetValue("x_Perimetro_Abdominal"));
		}
		if (!$this->IMC->FldIsDetailKey) {
			$this->IMC->setFormValue($objForm->GetValue("x_IMC"));
		}
		if (!$this->DS_TallaEdad->FldIsDetailKey) {
			$this->DS_TallaEdad->setFormValue($objForm->GetValue("x_DS_TallaEdad"));
		}
		if (!$this->DS_PesoTalla->FldIsDetailKey) {
			$this->DS_PesoTalla->setFormValue($objForm->GetValue("x_DS_PesoTalla"));
		}
		if (!$this->DS_PesoEdad->FldIsDetailKey) {
			$this->DS_PesoEdad->setFormValue($objForm->GetValue("x_DS_PesoEdad"));
		}
		if (!$this->DS_IMCEdad->FldIsDetailKey) {
			$this->DS_IMCEdad->setFormValue($objForm->GetValue("x_DS_IMCEdad"));
		}
		if (!$this->DS_PCEdad->FldIsDetailKey) {
			$this->DS_PCEdad->setFormValue($objForm->GetValue("x_DS_PCEdad"));
		}
		if (!$this->Clasificacion_Talla_Edad->FldIsDetailKey) {
			$this->Clasificacion_Talla_Edad->setFormValue($objForm->GetValue("x_Clasificacion_Talla_Edad"));
		}
		if (!$this->Clasificacion_Peso_Talla->FldIsDetailKey) {
			$this->Clasificacion_Peso_Talla->setFormValue($objForm->GetValue("x_Clasificacion_Peso_Talla"));
		}
		if (!$this->Clasificacion_Peso_Edad->FldIsDetailKey) {
			$this->Clasificacion_Peso_Edad->setFormValue($objForm->GetValue("x_Clasificacion_Peso_Edad"));
		}
		if (!$this->Clasificacion_IMC_Edad->FldIsDetailKey) {
			$this->Clasificacion_IMC_Edad->setFormValue($objForm->GetValue("x_Clasificacion_IMC_Edad"));
		}
		if (!$this->Clasificacion_P_Cefalico->FldIsDetailKey) {
			$this->Clasificacion_P_Cefalico->setFormValue($objForm->GetValue("x_Clasificacion_P_Cefalico"));
		}
		if (!$this->Superficie_Corporal->FldIsDetailKey) {
			$this->Superficie_Corporal->setFormValue($objForm->GetValue("x_Superficie_Corporal"));
		}
		if (!$this->Zona->FldIsDetailKey) {
			$this->Zona->setFormValue($objForm->GetValue("x_Zona"));
		}
		if (!$this->Barrio_Vereda->FldIsDetailKey) {
			$this->Barrio_Vereda->setFormValue($objForm->GetValue("x_Barrio_Vereda"));
		}
		if (!$this->Comuna_Zona->FldIsDetailKey) {
			$this->Comuna_Zona->setFormValue($objForm->GetValue("x_Comuna_Zona"));
		}
		if (!$this->Grupo_Etnico->FldIsDetailKey) {
			$this->Grupo_Etnico->setFormValue($objForm->GetValue("x_Grupo_Etnico"));
		}
		if (!$this->Tipo_Regimen->FldIsDetailKey) {
			$this->Tipo_Regimen->setFormValue($objForm->GetValue("x_Tipo_Regimen"));
		}
		if (!$this->EPS->FldIsDetailKey) {
			$this->EPS->setFormValue($objForm->GetValue("x_EPS"));
		}
		if (!$this->Condicion_Discapacidad->FldIsDetailKey) {
			$this->Condicion_Discapacidad->setFormValue($objForm->GetValue("x_Condicion_Discapacidad"));
		}
		if (!$this->Condicion_Desplazamiento->FldIsDetailKey) {
			$this->Condicion_Desplazamiento->setFormValue($objForm->GetValue("x_Condicion_Desplazamiento"));
		}
		if (!$this->Entidad_Educativa->FldIsDetailKey) {
			$this->Entidad_Educativa->setFormValue($objForm->GetValue("x_Entidad_Educativa"));
		}
		if (!$this->Escolaridad->FldIsDetailKey) {
			$this->Escolaridad->setFormValue($objForm->GetValue("x_Escolaridad"));
		}
		if (!$this->Clasificado->FldIsDetailKey) {
			$this->Clasificado->setFormValue($objForm->GetValue("x_Clasificado"));
		}
		if (!$this->Usuario->FldIsDetailKey) {
			$this->Usuario->setFormValue($objForm->GetValue("x_Usuario"));
		}
		if (!$this->Fecha_edicion->FldIsDetailKey) {
			$this->Fecha_edicion->setFormValue($objForm->GetValue("x_Fecha_edicion"));
			$this->Fecha_edicion->CurrentValue = ew_UnFormatDateTime($this->Fecha_edicion->CurrentValue, 7);
		}
		if (!$this->Consecutivo->FldIsDetailKey)
			$this->Consecutivo->setFormValue($objForm->GetValue("x_Consecutivo"));
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadRow();
		$this->Consecutivo->CurrentValue = $this->Consecutivo->FormValue;
		$this->Entidad_Valora->CurrentValue = $this->Entidad_Valora->FormValue;
		$this->Tipo_Entidad->CurrentValue = $this->Tipo_Entidad->FormValue;
		$this->Tipo_Documento->CurrentValue = $this->Tipo_Documento->FormValue;
		$this->Documento->CurrentValue = $this->Documento->FormValue;
		$this->Fecha_Nacimiento->CurrentValue = $this->Fecha_Nacimiento->FormValue;
		$this->Fecha_Nacimiento->CurrentValue = ew_UnFormatDateTime($this->Fecha_Nacimiento->CurrentValue, 7);
		$this->Genero->CurrentValue = $this->Genero->FormValue;
		$this->Nombres->CurrentValue = $this->Nombres->FormValue;
		$this->Apellidos->CurrentValue = $this->Apellidos->FormValue;
		$this->Fecha_valoracion->CurrentValue = $this->Fecha_valoracion->FormValue;
		$this->Fecha_valoracion->CurrentValue = ew_UnFormatDateTime($this->Fecha_valoracion->CurrentValue, 7);
		$this->Edad_Anos->CurrentValue = $this->Edad_Anos->FormValue;
		$this->Edad_Meses->CurrentValue = $this->Edad_Meses->FormValue;
		$this->Peso->CurrentValue = $this->Peso->FormValue;
		$this->Talla->CurrentValue = $this->Talla->FormValue;
		$this->Perimetro_Cefalico->CurrentValue = $this->Perimetro_Cefalico->FormValue;
		$this->Perimetro_Abdominal->CurrentValue = $this->Perimetro_Abdominal->FormValue;
		$this->IMC->CurrentValue = $this->IMC->FormValue;
		$this->DS_TallaEdad->CurrentValue = $this->DS_TallaEdad->FormValue;
		$this->DS_PesoTalla->CurrentValue = $this->DS_PesoTalla->FormValue;
		$this->DS_PesoEdad->CurrentValue = $this->DS_PesoEdad->FormValue;
		$this->DS_IMCEdad->CurrentValue = $this->DS_IMCEdad->FormValue;
		$this->DS_PCEdad->CurrentValue = $this->DS_PCEdad->FormValue;
		$this->Clasificacion_Talla_Edad->CurrentValue = $this->Clasificacion_Talla_Edad->FormValue;
		$this->Clasificacion_Peso_Talla->CurrentValue = $this->Clasificacion_Peso_Talla->FormValue;
		$this->Clasificacion_Peso_Edad->CurrentValue = $this->Clasificacion_Peso_Edad->FormValue;
		$this->Clasificacion_IMC_Edad->CurrentValue = $this->Clasificacion_IMC_Edad->FormValue;
		$this->Clasificacion_P_Cefalico->CurrentValue = $this->Clasificacion_P_Cefalico->FormValue;
		$this->Superficie_Corporal->CurrentValue = $this->Superficie_Corporal->FormValue;
		$this->Zona->CurrentValue = $this->Zona->FormValue;
		$this->Barrio_Vereda->CurrentValue = $this->Barrio_Vereda->FormValue;
		$this->Comuna_Zona->CurrentValue = $this->Comuna_Zona->FormValue;
		$this->Grupo_Etnico->CurrentValue = $this->Grupo_Etnico->FormValue;
		$this->Tipo_Regimen->CurrentValue = $this->Tipo_Regimen->FormValue;
		$this->EPS->CurrentValue = $this->EPS->FormValue;
		$this->Condicion_Discapacidad->CurrentValue = $this->Condicion_Discapacidad->FormValue;
		$this->Condicion_Desplazamiento->CurrentValue = $this->Condicion_Desplazamiento->FormValue;
		$this->Entidad_Educativa->CurrentValue = $this->Entidad_Educativa->FormValue;
		$this->Escolaridad->CurrentValue = $this->Escolaridad->FormValue;
		$this->Clasificado->CurrentValue = $this->Clasificado->FormValue;
		$this->Usuario->CurrentValue = $this->Usuario->FormValue;
		$this->Fecha_edicion->CurrentValue = $this->Fecha_edicion->FormValue;
		$this->Fecha_edicion->CurrentValue = ew_UnFormatDateTime($this->Fecha_edicion->CurrentValue, 7);
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}

		// Check if valid user id
		if ($res) {
			$res = $this->ShowOptionLink('edit');
			if (!$res) {
				$sUserIdMsg = $Language->Phrase("NoPermission");
				$this->setFailureMessage($sUserIdMsg);
			}
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Consecutivo->setDbValue($rs->fields('Consecutivo'));
		$this->Entidad_Valora->setDbValue($rs->fields('Entidad_Valora'));
		$this->Tipo_Entidad->setDbValue($rs->fields('Tipo_Entidad'));
		$this->Tipo_Documento->setDbValue($rs->fields('Tipo_Documento'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Fecha_Nacimiento->setDbValue($rs->fields('Fecha_Nacimiento'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Fecha_valoracion->setDbValue($rs->fields('Fecha_valoracion'));
		$this->Edad_Anos->setDbValue($rs->fields('Edad_Anos'));
		$this->Edad_Meses->setDbValue($rs->fields('Edad_Meses'));
		$this->Peso->setDbValue($rs->fields('Peso'));
		$this->Talla->setDbValue($rs->fields('Talla'));
		$this->Perimetro_Cefalico->setDbValue($rs->fields('Perimetro_Cefalico'));
		$this->Perimetro_Abdominal->setDbValue($rs->fields('Perimetro_Abdominal'));
		$this->IMC->setDbValue($rs->fields('IMC'));
		$this->DS_TallaEdad->setDbValue($rs->fields('DS_TallaEdad'));
		$this->DS_PesoTalla->setDbValue($rs->fields('DS_PesoTalla'));
		$this->DS_PesoEdad->setDbValue($rs->fields('DS_PesoEdad'));
		$this->DS_IMCEdad->setDbValue($rs->fields('DS_IMCEdad'));
		$this->DS_PCEdad->setDbValue($rs->fields('DS_PCEdad'));
		$this->Clasificacion_Talla_Edad->setDbValue($rs->fields('Clasificacion_Talla_Edad'));
		$this->Clasificacion_Peso_Talla->setDbValue($rs->fields('Clasificacion_Peso_Talla'));
		$this->Clasificacion_Peso_Edad->setDbValue($rs->fields('Clasificacion_Peso_Edad'));
		$this->Clasificacion_IMC_Edad->setDbValue($rs->fields('Clasificacion_IMC_Edad'));
		$this->Clasificacion_P_Cefalico->setDbValue($rs->fields('Clasificacion_P_Cefalico'));
		$this->Superficie_Corporal->setDbValue($rs->fields('Superficie_Corporal'));
		$this->Zona->setDbValue($rs->fields('Zona'));
		$this->Barrio_Vereda->setDbValue($rs->fields('Barrio_Vereda'));
		$this->Comuna_Zona->setDbValue($rs->fields('Comuna_Zona'));
		$this->Grupo_Etnico->setDbValue($rs->fields('Grupo_Etnico'));
		$this->Tipo_Regimen->setDbValue($rs->fields('Tipo_Regimen'));
		$this->EPS->setDbValue($rs->fields('EPS'));
		$this->Condicion_Discapacidad->setDbValue($rs->fields('Condicion_Discapacidad'));
		$this->Condicion_Desplazamiento->setDbValue($rs->fields('Condicion_Desplazamiento'));
		$this->Entidad_Educativa->setDbValue($rs->fields('Entidad_Educativa'));
		$this->Escolaridad->setDbValue($rs->fields('Escolaridad'));
		$this->Clasificado->setDbValue($rs->fields('Clasificado'));
		$this->Usuario->setDbValue($rs->fields('Usuario'));
		$this->Fecha_edicion->setDbValue($rs->fields('Fecha_edicion'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Consecutivo->DbValue = $row['Consecutivo'];
		$this->Entidad_Valora->DbValue = $row['Entidad_Valora'];
		$this->Tipo_Entidad->DbValue = $row['Tipo_Entidad'];
		$this->Tipo_Documento->DbValue = $row['Tipo_Documento'];
		$this->Documento->DbValue = $row['Documento'];
		$this->Fecha_Nacimiento->DbValue = $row['Fecha_Nacimiento'];
		$this->Genero->DbValue = $row['Genero'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Fecha_valoracion->DbValue = $row['Fecha_valoracion'];
		$this->Edad_Anos->DbValue = $row['Edad_Anos'];
		$this->Edad_Meses->DbValue = $row['Edad_Meses'];
		$this->Peso->DbValue = $row['Peso'];
		$this->Talla->DbValue = $row['Talla'];
		$this->Perimetro_Cefalico->DbValue = $row['Perimetro_Cefalico'];
		$this->Perimetro_Abdominal->DbValue = $row['Perimetro_Abdominal'];
		$this->IMC->DbValue = $row['IMC'];
		$this->DS_TallaEdad->DbValue = $row['DS_TallaEdad'];
		$this->DS_PesoTalla->DbValue = $row['DS_PesoTalla'];
		$this->DS_PesoEdad->DbValue = $row['DS_PesoEdad'];
		$this->DS_IMCEdad->DbValue = $row['DS_IMCEdad'];
		$this->DS_PCEdad->DbValue = $row['DS_PCEdad'];
		$this->Clasificacion_Talla_Edad->DbValue = $row['Clasificacion_Talla_Edad'];
		$this->Clasificacion_Peso_Talla->DbValue = $row['Clasificacion_Peso_Talla'];
		$this->Clasificacion_Peso_Edad->DbValue = $row['Clasificacion_Peso_Edad'];
		$this->Clasificacion_IMC_Edad->DbValue = $row['Clasificacion_IMC_Edad'];
		$this->Clasificacion_P_Cefalico->DbValue = $row['Clasificacion_P_Cefalico'];
		$this->Superficie_Corporal->DbValue = $row['Superficie_Corporal'];
		$this->Zona->DbValue = $row['Zona'];
		$this->Barrio_Vereda->DbValue = $row['Barrio_Vereda'];
		$this->Comuna_Zona->DbValue = $row['Comuna_Zona'];
		$this->Grupo_Etnico->DbValue = $row['Grupo_Etnico'];
		$this->Tipo_Regimen->DbValue = $row['Tipo_Regimen'];
		$this->EPS->DbValue = $row['EPS'];
		$this->Condicion_Discapacidad->DbValue = $row['Condicion_Discapacidad'];
		$this->Condicion_Desplazamiento->DbValue = $row['Condicion_Desplazamiento'];
		$this->Entidad_Educativa->DbValue = $row['Entidad_Educativa'];
		$this->Escolaridad->DbValue = $row['Escolaridad'];
		$this->Clasificado->DbValue = $row['Clasificado'];
		$this->Usuario->DbValue = $row['Usuario'];
		$this->Fecha_edicion->DbValue = $row['Fecha_edicion'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->Peso->FormValue == $this->Peso->CurrentValue && is_numeric(ew_StrToFloat($this->Peso->CurrentValue)))
			$this->Peso->CurrentValue = ew_StrToFloat($this->Peso->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Talla->FormValue == $this->Talla->CurrentValue && is_numeric(ew_StrToFloat($this->Talla->CurrentValue)))
			$this->Talla->CurrentValue = ew_StrToFloat($this->Talla->CurrentValue);

		// Convert decimal values if posted back
		if ($this->IMC->FormValue == $this->IMC->CurrentValue && is_numeric(ew_StrToFloat($this->IMC->CurrentValue)))
			$this->IMC->CurrentValue = ew_StrToFloat($this->IMC->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_TallaEdad->FormValue == $this->DS_TallaEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_TallaEdad->CurrentValue)))
			$this->DS_TallaEdad->CurrentValue = ew_StrToFloat($this->DS_TallaEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_PesoTalla->FormValue == $this->DS_PesoTalla->CurrentValue && is_numeric(ew_StrToFloat($this->DS_PesoTalla->CurrentValue)))
			$this->DS_PesoTalla->CurrentValue = ew_StrToFloat($this->DS_PesoTalla->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_PesoEdad->FormValue == $this->DS_PesoEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_PesoEdad->CurrentValue)))
			$this->DS_PesoEdad->CurrentValue = ew_StrToFloat($this->DS_PesoEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_IMCEdad->FormValue == $this->DS_IMCEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_IMCEdad->CurrentValue)))
			$this->DS_IMCEdad->CurrentValue = ew_StrToFloat($this->DS_IMCEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DS_PCEdad->FormValue == $this->DS_PCEdad->CurrentValue && is_numeric(ew_StrToFloat($this->DS_PCEdad->CurrentValue)))
			$this->DS_PCEdad->CurrentValue = ew_StrToFloat($this->DS_PCEdad->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Superficie_Corporal->FormValue == $this->Superficie_Corporal->CurrentValue && is_numeric(ew_StrToFloat($this->Superficie_Corporal->CurrentValue)))
			$this->Superficie_Corporal->CurrentValue = ew_StrToFloat($this->Superficie_Corporal->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Consecutivo
		// Entidad_Valora
		// Tipo_Entidad
		// Tipo_Documento
		// Documento
		// Fecha_Nacimiento
		// Genero
		// Nombres
		// Apellidos
		// Fecha_valoracion
		// Edad_Anos
		// Edad_Meses
		// Peso
		// Talla
		// Perimetro_Cefalico
		// Perimetro_Abdominal
		// IMC
		// DS_TallaEdad
		// DS_PesoTalla
		// DS_PesoEdad
		// DS_IMCEdad
		// DS_PCEdad
		// Clasificacion_Talla_Edad
		// Clasificacion_Peso_Talla
		// Clasificacion_Peso_Edad
		// Clasificacion_IMC_Edad
		// Clasificacion_P_Cefalico
		// Superficie_Corporal
		// Zona
		// Barrio_Vereda
		// Comuna_Zona
		// Grupo_Etnico
		// Tipo_Regimen
		// EPS
		// Condicion_Discapacidad
		// Condicion_Desplazamiento
		// Entidad_Educativa
		// Escolaridad
		// Clasificado
		// Usuario
		// Fecha_edicion

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// Consecutivo
			$this->Consecutivo->ViewValue = $this->Consecutivo->CurrentValue;
			$this->Consecutivo->ViewCustomAttributes = "";

			// Entidad_Valora
			if (strval($this->Entidad_Valora->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Entidad_Valora->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			$lookuptblfilter = "`Activa`=1";
			if (strval($lookuptblfilter) <> "") {
				ew_AddFilter($sWhereWrk, $lookuptblfilter);
			}
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad_Valora, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Entidad`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Entidad_Valora->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Entidad_Valora->ViewValue = $this->Entidad_Valora->CurrentValue;
				}
			} else {
				$this->Entidad_Valora->ViewValue = NULL;
			}
			$this->Entidad_Valora->ViewCustomAttributes = "";

			// Tipo_Entidad
			if (strval($this->Tipo_Entidad->CurrentValue) <> "") {
				switch ($this->Tipo_Entidad->CurrentValue) {
					case $this->Tipo_Entidad->FldTagValue(1):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(1) <> "" ? $this->Tipo_Entidad->FldTagCaption(1) : $this->Tipo_Entidad->CurrentValue;
						break;
					case $this->Tipo_Entidad->FldTagValue(2):
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->FldTagCaption(2) <> "" ? $this->Tipo_Entidad->FldTagCaption(2) : $this->Tipo_Entidad->CurrentValue;
						break;
					default:
						$this->Tipo_Entidad->ViewValue = $this->Tipo_Entidad->CurrentValue;
				}
			} else {
				$this->Tipo_Entidad->ViewValue = NULL;
			}
			$this->Tipo_Entidad->ViewCustomAttributes = "";

			// Tipo_Documento
			if (strval($this->Tipo_Documento->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Tipo_Documento->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Tipo_Documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Tipo_Documento, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Tipo_Documento`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Tipo_Documento->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Tipo_Documento->ViewValue = $this->Tipo_Documento->CurrentValue;
				}
			} else {
				$this->Tipo_Documento->ViewValue = NULL;
			}
			$this->Tipo_Documento->ViewCustomAttributes = "";

			// Documento
			$this->Documento->ViewValue = $this->Documento->CurrentValue;
			$this->Documento->ViewCustomAttributes = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->ViewValue = $this->Fecha_Nacimiento->CurrentValue;
			$this->Fecha_Nacimiento->ViewValue = ew_FormatDateTime($this->Fecha_Nacimiento->ViewValue, 7);
			$this->Fecha_Nacimiento->ViewCustomAttributes = "";

			// Genero
			if (strval($this->Genero->CurrentValue) <> "") {
				$sFilterWrk = "`#`" . ew_SearchString("=", $this->Genero->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `#`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_genero`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Genero, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Genero`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Genero->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Genero->ViewValue = $this->Genero->CurrentValue;
				}
			} else {
				$this->Genero->ViewValue = NULL;
			}
			$this->Genero->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
			$this->Nombres->ViewCustomAttributes = "";

			// Apellidos
			$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
			$this->Apellidos->ViewCustomAttributes = "";

			// Fecha_valoracion
			$this->Fecha_valoracion->ViewValue = $this->Fecha_valoracion->CurrentValue;
			$this->Fecha_valoracion->ViewValue = ew_FormatDateTime($this->Fecha_valoracion->ViewValue, 7);
			$this->Fecha_valoracion->ViewCustomAttributes = "";

			// Edad_Anos
			$this->Edad_Anos->ViewValue = $this->Edad_Anos->CurrentValue;
			$this->Edad_Anos->ViewCustomAttributes = "";

			// Edad_Meses
			$this->Edad_Meses->ViewValue = $this->Edad_Meses->CurrentValue;
			$this->Edad_Meses->ViewCustomAttributes = "";

			// Peso
			$this->Peso->ViewValue = $this->Peso->CurrentValue;
			$this->Peso->ViewCustomAttributes = "";

			// Talla
			$this->Talla->ViewValue = $this->Talla->CurrentValue;
			$this->Talla->ViewCustomAttributes = "";

			// Perimetro_Cefalico
			$this->Perimetro_Cefalico->ViewValue = $this->Perimetro_Cefalico->CurrentValue;
			$this->Perimetro_Cefalico->ViewCustomAttributes = "";

			// Perimetro_Abdominal
			$this->Perimetro_Abdominal->ViewValue = $this->Perimetro_Abdominal->CurrentValue;
			$this->Perimetro_Abdominal->ViewCustomAttributes = "";

			// IMC
			$this->IMC->ViewValue = $this->IMC->CurrentValue;
			$this->IMC->ViewValue = ew_FormatNumber($this->IMC->ViewValue, 2, 0, 0, 0);
			$this->IMC->CellCssStyle .= "text-align: right;";
			$this->IMC->ViewCustomAttributes = "";

			// DS_TallaEdad
			$this->DS_TallaEdad->ViewValue = $this->DS_TallaEdad->CurrentValue;
			$this->DS_TallaEdad->ViewCustomAttributes = "";

			// DS_PesoTalla
			$this->DS_PesoTalla->ViewValue = $this->DS_PesoTalla->CurrentValue;
			$this->DS_PesoTalla->ViewCustomAttributes = "";

			// DS_PesoEdad
			$this->DS_PesoEdad->ViewValue = $this->DS_PesoEdad->CurrentValue;
			$this->DS_PesoEdad->ViewCustomAttributes = "";

			// DS_IMCEdad
			$this->DS_IMCEdad->ViewValue = $this->DS_IMCEdad->CurrentValue;
			$this->DS_IMCEdad->ViewCustomAttributes = "";

			// DS_PCEdad
			$this->DS_PCEdad->ViewValue = $this->DS_PCEdad->CurrentValue;
			$this->DS_PCEdad->ViewCustomAttributes = "";

			// Clasificacion_Talla_Edad
			if (strval($this->Clasificacion_Talla_Edad->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Talla_Edad->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Talla_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_talla_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Talla_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_Talla_Edad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_Talla_Edad->ViewValue = $this->Clasificacion_Talla_Edad->CurrentValue;
				}
			} else {
				$this->Clasificacion_Talla_Edad->ViewValue = NULL;
			}
			$this->Clasificacion_Talla_Edad->ViewCustomAttributes = "";

			// Clasificacion_Peso_Talla
			if (strval($this->Clasificacion_Peso_Talla->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Peso_Talla->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Talla` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_peso_talla`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Peso_Talla, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_Peso_Talla->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_Peso_Talla->ViewValue = $this->Clasificacion_Peso_Talla->CurrentValue;
				}
			} else {
				$this->Clasificacion_Peso_Talla->ViewValue = NULL;
			}
			$this->Clasificacion_Peso_Talla->ViewCustomAttributes = "";

			// Clasificacion_Peso_Edad
			if (strval($this->Clasificacion_Peso_Edad->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_Peso_Edad->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_peso_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Peso_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_Peso_Edad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_Peso_Edad->ViewValue = $this->Clasificacion_Peso_Edad->CurrentValue;
				}
			} else {
				$this->Clasificacion_Peso_Edad->ViewValue = NULL;
			}
			$this->Clasificacion_Peso_Edad->ViewCustomAttributes = "";

			// Clasificacion_IMC_Edad
			if (strval($this->Clasificacion_IMC_Edad->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_IMC_Edad->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_IMC_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_imc_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_IMC_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_IMC_Edad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_IMC_Edad->ViewValue = $this->Clasificacion_IMC_Edad->CurrentValue;
				}
			} else {
				$this->Clasificacion_IMC_Edad->ViewValue = NULL;
			}
			$this->Clasificacion_IMC_Edad->ViewCustomAttributes = "";

			// Clasificacion_P_Cefalico
			if (strval($this->Clasificacion_P_Cefalico->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Clasificacion_P_Cefalico->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Perimetro_Cefalico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_clase_p_cefalico`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_P_Cefalico, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Clasificacion_P_Cefalico->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Clasificacion_P_Cefalico->ViewValue = $this->Clasificacion_P_Cefalico->CurrentValue;
				}
			} else {
				$this->Clasificacion_P_Cefalico->ViewValue = NULL;
			}
			$this->Clasificacion_P_Cefalico->ViewCustomAttributes = "";

			// Superficie_Corporal
			$this->Superficie_Corporal->ViewValue = $this->Superficie_Corporal->CurrentValue;
			$this->Superficie_Corporal->ViewCustomAttributes = "";

			// Zona
			if (strval($this->Zona->CurrentValue) <> "") {
				$sFilterWrk = "`codigo`" . ew_SearchString("=", $this->Zona->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `codigo`, `Zona` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `zona`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Zona->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Zona->ViewValue = $this->Zona->CurrentValue;
				}
			} else {
				$this->Zona->ViewValue = NULL;
			}
			$this->Zona->ViewCustomAttributes = "";

			// Barrio_Vereda
			if (strval($this->Barrio_Vereda->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Barrio_Vereda->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `barrio_vereda`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Barrio_Vereda, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Barrio_Vereda`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Barrio_Vereda->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Barrio_Vereda->ViewValue = $this->Barrio_Vereda->CurrentValue;
				}
			} else {
				$this->Barrio_Vereda->ViewValue = NULL;
			}
			$this->Barrio_Vereda->ViewCustomAttributes = "";

			// Comuna_Zona
			$this->Comuna_Zona->ViewValue = $this->Comuna_Zona->CurrentValue;
			if (strval($this->Comuna_Zona->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Comuna_Zona->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `comuna_localidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Comuna_Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Comuna_Zona->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Comuna_Zona->ViewValue = $this->Comuna_Zona->CurrentValue;
				}
			} else {
				$this->Comuna_Zona->ViewValue = NULL;
			}
			$this->Comuna_Zona->ViewCustomAttributes = "";

			// Grupo_Etnico
			if (strval($this->Grupo_Etnico->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Grupo_Etnico->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Pertenencia_Etnica` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `pertenencia_etnica`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Grupo_Etnico, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Pertenencia_Etnica`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Grupo_Etnico->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Grupo_Etnico->ViewValue = $this->Grupo_Etnico->CurrentValue;
				}
			} else {
				$this->Grupo_Etnico->ViewValue = NULL;
			}
			$this->Grupo_Etnico->ViewCustomAttributes = "";

			// Tipo_Regimen
			if (strval($this->Tipo_Regimen->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Tipo_Regimen->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Tipo_Regimen_Salud` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `regimen_salud`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Tipo_Regimen, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Tipo_Regimen_Salud`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Tipo_Regimen->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Tipo_Regimen->ViewValue = $this->Tipo_Regimen->CurrentValue;
				}
			} else {
				$this->Tipo_Regimen->ViewValue = NULL;
			}
			$this->Tipo_Regimen->ViewCustomAttributes = "";

			// EPS
			$this->EPS->ViewValue = $this->EPS->CurrentValue;
			if (strval($this->EPS->CurrentValue) <> "") {
				$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->EPS->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Codigo`, `Administradora_Salud` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->EPS, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Administradora_Salud`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->EPS->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->EPS->ViewValue = $this->EPS->CurrentValue;
				}
			} else {
				$this->EPS->ViewValue = NULL;
			}
			$this->EPS->ViewCustomAttributes = "";

			// Condicion_Discapacidad
			if (strval($this->Condicion_Discapacidad->CurrentValue) <> "") {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Condicion_Discapacidad->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `Consecutivo`, `Condicion_Discapacidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_condicion_discapacidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Condicion_Discapacidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Condicion_Discapacidad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Condicion_Discapacidad->ViewValue = $this->Condicion_Discapacidad->CurrentValue;
				}
			} else {
				$this->Condicion_Discapacidad->ViewValue = NULL;
			}
			$this->Condicion_Discapacidad->ViewCustomAttributes = "";

			// Condicion_Desplazamiento
			if (strval($this->Condicion_Desplazamiento->CurrentValue) <> "") {
				switch ($this->Condicion_Desplazamiento->CurrentValue) {
					case $this->Condicion_Desplazamiento->FldTagValue(1):
						$this->Condicion_Desplazamiento->ViewValue = $this->Condicion_Desplazamiento->FldTagCaption(1) <> "" ? $this->Condicion_Desplazamiento->FldTagCaption(1) : $this->Condicion_Desplazamiento->CurrentValue;
						break;
					case $this->Condicion_Desplazamiento->FldTagValue(2):
						$this->Condicion_Desplazamiento->ViewValue = $this->Condicion_Desplazamiento->FldTagCaption(2) <> "" ? $this->Condicion_Desplazamiento->FldTagCaption(2) : $this->Condicion_Desplazamiento->CurrentValue;
						break;
					default:
						$this->Condicion_Desplazamiento->ViewValue = $this->Condicion_Desplazamiento->CurrentValue;
				}
			} else {
				$this->Condicion_Desplazamiento->ViewValue = NULL;
			}
			$this->Condicion_Desplazamiento->ViewCustomAttributes = "";

			// Entidad_Educativa
			if (strval($this->Entidad_Educativa->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad_Educativa->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `Id`, `Entidad_Educativa` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_educativa`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad_Educativa, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Entidad_Educativa`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Entidad_Educativa->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Entidad_Educativa->ViewValue = $this->Entidad_Educativa->CurrentValue;
				}
			} else {
				$this->Entidad_Educativa->ViewValue = NULL;
			}
			$this->Entidad_Educativa->ViewCustomAttributes = "";

			// Escolaridad
			if (strval($this->Escolaridad->CurrentValue) <> "") {
				$sFilterWrk = "`Consecutivo`" . ew_SearchString("=", $this->Escolaridad->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `Consecutivo`, `Grado_Escolar` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `nutricion_grado_escolar`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Escolaridad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Grado_Escolar`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Escolaridad->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Escolaridad->ViewValue = $this->Escolaridad->CurrentValue;
				}
			} else {
				$this->Escolaridad->ViewValue = NULL;
			}
			$this->Escolaridad->ViewCustomAttributes = "";

			// Clasificado
			if (strval($this->Clasificado->CurrentValue) <> "") {
				switch ($this->Clasificado->CurrentValue) {
					case $this->Clasificado->FldTagValue(1):
						$this->Clasificado->ViewValue = $this->Clasificado->FldTagCaption(1) <> "" ? $this->Clasificado->FldTagCaption(1) : $this->Clasificado->CurrentValue;
						break;
					default:
						$this->Clasificado->ViewValue = $this->Clasificado->CurrentValue;
				}
			} else {
				$this->Clasificado->ViewValue = NULL;
			}
			$this->Clasificado->ViewCustomAttributes = "";

			// Usuario
			$this->Usuario->ViewValue = $this->Usuario->CurrentValue;
			$this->Usuario->ViewCustomAttributes = "";

			// Fecha_edicion
			$this->Fecha_edicion->ViewValue = $this->Fecha_edicion->CurrentValue;
			$this->Fecha_edicion->ViewValue = ew_FormatDateTime($this->Fecha_edicion->ViewValue, 7);
			$this->Fecha_edicion->ViewCustomAttributes = "";

			// Entidad_Valora
			$this->Entidad_Valora->LinkCustomAttributes = "";
			$this->Entidad_Valora->HrefValue = "";
			$this->Entidad_Valora->TooltipValue = "";

			// Tipo_Entidad
			$this->Tipo_Entidad->LinkCustomAttributes = "";
			$this->Tipo_Entidad->HrefValue = "";
			$this->Tipo_Entidad->TooltipValue = "";

			// Tipo_Documento
			$this->Tipo_Documento->LinkCustomAttributes = "";
			$this->Tipo_Documento->HrefValue = "";
			$this->Tipo_Documento->TooltipValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";
			$this->Documento->TooltipValue = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->LinkCustomAttributes = "";
			$this->Fecha_Nacimiento->HrefValue = "";
			$this->Fecha_Nacimiento->TooltipValue = "";

			// Genero
			$this->Genero->LinkCustomAttributes = "";
			$this->Genero->HrefValue = "";
			$this->Genero->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Fecha_valoracion
			$this->Fecha_valoracion->LinkCustomAttributes = "";
			$this->Fecha_valoracion->HrefValue = "";
			$this->Fecha_valoracion->TooltipValue = "";

			// Edad_Anos
			$this->Edad_Anos->LinkCustomAttributes = "";
			$this->Edad_Anos->HrefValue = "";
			$this->Edad_Anos->TooltipValue = "";

			// Edad_Meses
			$this->Edad_Meses->LinkCustomAttributes = "";
			$this->Edad_Meses->HrefValue = "";
			$this->Edad_Meses->TooltipValue = "";

			// Peso
			$this->Peso->LinkCustomAttributes = "";
			$this->Peso->HrefValue = "";
			$this->Peso->TooltipValue = "";

			// Talla
			$this->Talla->LinkCustomAttributes = "";
			$this->Talla->HrefValue = "";
			$this->Talla->TooltipValue = "";

			// Perimetro_Cefalico
			$this->Perimetro_Cefalico->LinkCustomAttributes = "";
			$this->Perimetro_Cefalico->HrefValue = "";
			$this->Perimetro_Cefalico->TooltipValue = "";

			// Perimetro_Abdominal
			$this->Perimetro_Abdominal->LinkCustomAttributes = "";
			$this->Perimetro_Abdominal->HrefValue = "";
			$this->Perimetro_Abdominal->TooltipValue = "";

			// IMC
			$this->IMC->LinkCustomAttributes = "";
			$this->IMC->HrefValue = "";
			$this->IMC->TooltipValue = "";

			// DS_TallaEdad
			$this->DS_TallaEdad->LinkCustomAttributes = "";
			$this->DS_TallaEdad->HrefValue = "";
			$this->DS_TallaEdad->TooltipValue = "";

			// DS_PesoTalla
			$this->DS_PesoTalla->LinkCustomAttributes = "";
			$this->DS_PesoTalla->HrefValue = "";
			$this->DS_PesoTalla->TooltipValue = "";

			// DS_PesoEdad
			$this->DS_PesoEdad->LinkCustomAttributes = "";
			$this->DS_PesoEdad->HrefValue = "";
			$this->DS_PesoEdad->TooltipValue = "";

			// DS_IMCEdad
			$this->DS_IMCEdad->LinkCustomAttributes = "";
			$this->DS_IMCEdad->HrefValue = "";
			$this->DS_IMCEdad->TooltipValue = "";

			// DS_PCEdad
			$this->DS_PCEdad->LinkCustomAttributes = "";
			$this->DS_PCEdad->HrefValue = "";
			$this->DS_PCEdad->TooltipValue = "";

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_Talla_Edad->HrefValue = "";
			$this->Clasificacion_Talla_Edad->TooltipValue = "";

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->LinkCustomAttributes = "";
			$this->Clasificacion_Peso_Talla->HrefValue = "";
			$this->Clasificacion_Peso_Talla->TooltipValue = "";

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_Peso_Edad->HrefValue = "";
			$this->Clasificacion_Peso_Edad->TooltipValue = "";

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->LinkCustomAttributes = "";
			$this->Clasificacion_IMC_Edad->HrefValue = "";
			$this->Clasificacion_IMC_Edad->TooltipValue = "";

			// Clasificacion_P_Cefalico
			$this->Clasificacion_P_Cefalico->LinkCustomAttributes = "";
			$this->Clasificacion_P_Cefalico->HrefValue = "";
			$this->Clasificacion_P_Cefalico->TooltipValue = "";

			// Superficie_Corporal
			$this->Superficie_Corporal->LinkCustomAttributes = "";
			$this->Superficie_Corporal->HrefValue = "";
			$this->Superficie_Corporal->TooltipValue = "";

			// Zona
			$this->Zona->LinkCustomAttributes = "";
			$this->Zona->HrefValue = "";
			$this->Zona->TooltipValue = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->LinkCustomAttributes = "";
			$this->Barrio_Vereda->HrefValue = "";
			$this->Barrio_Vereda->TooltipValue = "";

			// Comuna_Zona
			$this->Comuna_Zona->LinkCustomAttributes = "";
			$this->Comuna_Zona->HrefValue = "";
			$this->Comuna_Zona->TooltipValue = "";

			// Grupo_Etnico
			$this->Grupo_Etnico->LinkCustomAttributes = "";
			$this->Grupo_Etnico->HrefValue = "";
			$this->Grupo_Etnico->TooltipValue = "";

			// Tipo_Regimen
			$this->Tipo_Regimen->LinkCustomAttributes = "";
			$this->Tipo_Regimen->HrefValue = "";
			$this->Tipo_Regimen->TooltipValue = "";

			// EPS
			$this->EPS->LinkCustomAttributes = "";
			$this->EPS->HrefValue = "";
			$this->EPS->TooltipValue = "";

			// Condicion_Discapacidad
			$this->Condicion_Discapacidad->LinkCustomAttributes = "";
			$this->Condicion_Discapacidad->HrefValue = "";
			$this->Condicion_Discapacidad->TooltipValue = "";

			// Condicion_Desplazamiento
			$this->Condicion_Desplazamiento->LinkCustomAttributes = "";
			$this->Condicion_Desplazamiento->HrefValue = "";
			$this->Condicion_Desplazamiento->TooltipValue = "";

			// Entidad_Educativa
			$this->Entidad_Educativa->LinkCustomAttributes = "";
			$this->Entidad_Educativa->HrefValue = "";
			$this->Entidad_Educativa->TooltipValue = "";

			// Escolaridad
			$this->Escolaridad->LinkCustomAttributes = "";
			$this->Escolaridad->HrefValue = "";
			$this->Escolaridad->TooltipValue = "";

			// Clasificado
			$this->Clasificado->LinkCustomAttributes = "";
			$this->Clasificado->HrefValue = "";
			$this->Clasificado->TooltipValue = "";

			// Usuario
			$this->Usuario->LinkCustomAttributes = "";
			$this->Usuario->HrefValue = "";
			$this->Usuario->TooltipValue = "";

			// Fecha_edicion
			$this->Fecha_edicion->LinkCustomAttributes = "";
			$this->Fecha_edicion->HrefValue = "";
			$this->Fecha_edicion->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// Entidad_Valora
			$this->Entidad_Valora->EditCustomAttributes = "";
			if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$this->UserIDAllow("edit")) { // Non system admin
				$this->Entidad_Valora->CurrentValue = CurrentUserID();
			if (strval($this->Entidad_Valora->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Entidad_Valora->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad_upgd`";
			$sWhereWrk = "";
			$lookuptblfilter = "`Activa`=1";
			if (strval($lookuptblfilter) <> "") {
				ew_AddFilter($sWhereWrk, $lookuptblfilter);
			}
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad_Valora, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Entidad`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Entidad_Valora->EditValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Entidad_Valora->EditValue = $this->Entidad_Valora->CurrentValue;
				}
			} else {
				$this->Entidad_Valora->EditValue = NULL;
			}
			$this->Entidad_Valora->ViewCustomAttributes = "";
			} else {
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `entidad_upgd`";
			$sWhereWrk = "";
			$lookuptblfilter = "`Activa`=1";
			if (strval($lookuptblfilter) <> "") {
				ew_AddFilter($sWhereWrk, $lookuptblfilter);
			}
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad_Valora, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Entidad`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Entidad_Valora->EditValue = $arwrk;
			}

			// Tipo_Entidad
			$this->Tipo_Entidad->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->Tipo_Entidad->FldTagValue(1), $this->Tipo_Entidad->FldTagCaption(1) <> "" ? $this->Tipo_Entidad->FldTagCaption(1) : $this->Tipo_Entidad->FldTagValue(1));
			$arwrk[] = array($this->Tipo_Entidad->FldTagValue(2), $this->Tipo_Entidad->FldTagCaption(2) <> "" ? $this->Tipo_Entidad->FldTagCaption(2) : $this->Tipo_Entidad->FldTagValue(2));
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect")));
			$this->Tipo_Entidad->EditValue = $arwrk;

			// Tipo_Documento
			$this->Tipo_Documento->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Tipo_Documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tipo_documento`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Tipo_Documento, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Tipo_Documento`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Tipo_Documento->EditValue = $arwrk;

			// Documento
			$this->Documento->EditCustomAttributes = "";
			$this->Documento->EditValue = ew_HtmlEncode($this->Documento->CurrentValue);
			$this->Documento->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Documento->FldCaption()));

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->EditCustomAttributes = "onchange='CalcularEdad();'";
			$this->Fecha_Nacimiento->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Nacimiento->CurrentValue, 7));
			$this->Fecha_Nacimiento->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Fecha_Nacimiento->FldCaption()));

			// Genero
			$this->Genero->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `#`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_genero`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Genero, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Genero`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Genero->EditValue = $arwrk;

			// Nombres
			$this->Nombres->EditCustomAttributes = "";
			$this->Nombres->EditValue = ew_HtmlEncode($this->Nombres->CurrentValue);
			$this->Nombres->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Nombres->FldCaption()));

			// Apellidos
			$this->Apellidos->EditCustomAttributes = "";
			$this->Apellidos->EditValue = ew_HtmlEncode($this->Apellidos->CurrentValue);
			$this->Apellidos->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Apellidos->FldCaption()));

			// Fecha_valoracion
			$this->Fecha_valoracion->EditCustomAttributes = "onchange='CalcularEdad();'";
			$this->Fecha_valoracion->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_valoracion->CurrentValue, 7));
			$this->Fecha_valoracion->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Fecha_valoracion->FldCaption()));

			// Edad_Anos
			$this->Edad_Anos->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->Edad_Anos->EditValue = ew_HtmlEncode($this->Edad_Anos->CurrentValue);
			$this->Edad_Anos->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Edad_Anos->FldCaption()));

			// Edad_Meses
			$this->Edad_Meses->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->Edad_Meses->EditValue = ew_HtmlEncode($this->Edad_Meses->CurrentValue);
			$this->Edad_Meses->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Edad_Meses->FldCaption()));

			// Peso
			$this->Peso->EditCustomAttributes = "onchange='Calcular_IMC();'";
			$this->Peso->EditValue = ew_HtmlEncode($this->Peso->CurrentValue);
			$this->Peso->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Peso->FldCaption()));
			if (strval($this->Peso->EditValue) <> "" && is_numeric($this->Peso->EditValue)) $this->Peso->EditValue = ew_FormatNumber($this->Peso->EditValue, -2, -1, -2, 0);

			// Talla
			$this->Talla->EditCustomAttributes = "onchange='Calcular_IMC();'";
			$this->Talla->EditValue = ew_HtmlEncode($this->Talla->CurrentValue);
			$this->Talla->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Talla->FldCaption()));
			if (strval($this->Talla->EditValue) <> "" && is_numeric($this->Talla->EditValue)) $this->Talla->EditValue = ew_FormatNumber($this->Talla->EditValue, -2, -1, -2, 0);

			// Perimetro_Cefalico
			$this->Perimetro_Cefalico->EditCustomAttributes = "";
			$this->Perimetro_Cefalico->EditValue = ew_HtmlEncode($this->Perimetro_Cefalico->CurrentValue);
			$this->Perimetro_Cefalico->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Perimetro_Cefalico->FldCaption()));

			// Perimetro_Abdominal
			$this->Perimetro_Abdominal->EditCustomAttributes = "";
			$this->Perimetro_Abdominal->EditValue = ew_HtmlEncode($this->Perimetro_Abdominal->CurrentValue);
			$this->Perimetro_Abdominal->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Perimetro_Abdominal->FldCaption()));

			// IMC
			$this->IMC->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->IMC->EditValue = ew_HtmlEncode($this->IMC->CurrentValue);
			$this->IMC->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->IMC->FldCaption()));
			if (strval($this->IMC->EditValue) <> "" && is_numeric($this->IMC->EditValue)) $this->IMC->EditValue = ew_FormatNumber($this->IMC->EditValue, -2, 0, 0, 0);

			// DS_TallaEdad
			$this->DS_TallaEdad->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->DS_TallaEdad->EditValue = ew_HtmlEncode($this->DS_TallaEdad->CurrentValue);
			$this->DS_TallaEdad->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->DS_TallaEdad->FldCaption()));
			if (strval($this->DS_TallaEdad->EditValue) <> "" && is_numeric($this->DS_TallaEdad->EditValue)) $this->DS_TallaEdad->EditValue = ew_FormatNumber($this->DS_TallaEdad->EditValue, -2, -1, -2, 0);

			// DS_PesoTalla
			$this->DS_PesoTalla->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->DS_PesoTalla->EditValue = ew_HtmlEncode($this->DS_PesoTalla->CurrentValue);
			$this->DS_PesoTalla->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->DS_PesoTalla->FldCaption()));
			if (strval($this->DS_PesoTalla->EditValue) <> "" && is_numeric($this->DS_PesoTalla->EditValue)) $this->DS_PesoTalla->EditValue = ew_FormatNumber($this->DS_PesoTalla->EditValue, -2, -1, -2, 0);

			// DS_PesoEdad
			$this->DS_PesoEdad->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->DS_PesoEdad->EditValue = ew_HtmlEncode($this->DS_PesoEdad->CurrentValue);
			$this->DS_PesoEdad->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->DS_PesoEdad->FldCaption()));
			if (strval($this->DS_PesoEdad->EditValue) <> "" && is_numeric($this->DS_PesoEdad->EditValue)) $this->DS_PesoEdad->EditValue = ew_FormatNumber($this->DS_PesoEdad->EditValue, -2, -1, -2, 0);

			// DS_IMCEdad
			$this->DS_IMCEdad->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->DS_IMCEdad->EditValue = ew_HtmlEncode($this->DS_IMCEdad->CurrentValue);
			$this->DS_IMCEdad->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->DS_IMCEdad->FldCaption()));
			if (strval($this->DS_IMCEdad->EditValue) <> "" && is_numeric($this->DS_IMCEdad->EditValue)) $this->DS_IMCEdad->EditValue = ew_FormatNumber($this->DS_IMCEdad->EditValue, -2, -1, -2, 0);

			// DS_PCEdad
			$this->DS_PCEdad->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->DS_PCEdad->EditValue = ew_HtmlEncode($this->DS_PCEdad->CurrentValue);
			$this->DS_PCEdad->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->DS_PCEdad->FldCaption()));
			if (strval($this->DS_PCEdad->EditValue) <> "" && is_numeric($this->DS_PCEdad->EditValue)) $this->DS_PCEdad->EditValue = ew_FormatNumber($this->DS_PCEdad->EditValue, -2, -1, -2, 0);

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->EditCustomAttributes = "onfocus='this.defaultIndex=this.selectedIndex;' onchange='this.selectedIndex=this.defaultIndex;'";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Talla_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_clase_talla_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Talla_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Clasificacion_Talla_Edad->EditValue = $arwrk;

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->EditCustomAttributes = "onfocus='this.defaultIndex=this.selectedIndex;' onchange='this.selectedIndex=this.defaultIndex;'";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Talla` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_clase_peso_talla`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Peso_Talla, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Clasificacion_Peso_Talla->EditValue = $arwrk;

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->EditCustomAttributes = "onfocus='this.defaultIndex=this.selectedIndex;' onchange='this.selectedIndex=this.defaultIndex;'";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Peso_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_clase_peso_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_Peso_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Clasificacion_Peso_Edad->EditValue = $arwrk;

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->EditCustomAttributes = "onfocus='this.defaultIndex=this.selectedIndex;' onchange='this.selectedIndex=this.defaultIndex;'";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Id`, `Clasificacion_IMC_Edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_clase_imc_edad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_IMC_Edad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Clasificacion_IMC_Edad->EditValue = $arwrk;

			// Clasificacion_P_Cefalico
			$this->Clasificacion_P_Cefalico->EditCustomAttributes = "onfocus='this.defaultIndex=this.selectedIndex;' onchange='this.selectedIndex=this.defaultIndex;'";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Id`, `Clasificacion_Perimetro_Cefalico` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_clase_p_cefalico`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Clasificacion_P_Cefalico, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Id`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Clasificacion_P_Cefalico->EditValue = $arwrk;

			// Superficie_Corporal
			$this->Superficie_Corporal->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->Superficie_Corporal->EditValue = ew_HtmlEncode($this->Superficie_Corporal->CurrentValue);
			$this->Superficie_Corporal->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Superficie_Corporal->FldCaption()));
			if (strval($this->Superficie_Corporal->EditValue) <> "" && is_numeric($this->Superficie_Corporal->EditValue)) $this->Superficie_Corporal->EditValue = ew_FormatNumber($this->Superficie_Corporal->EditValue, -2, -1, -2, 0);

			// Zona
			$this->Zona->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `codigo`, `Zona` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `zona`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Zona->EditValue = $arwrk;

			// Barrio_Vereda
			$this->Barrio_Vereda->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Barrio_Vereda` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `Zona` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `barrio_vereda`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Barrio_Vereda, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Barrio_Vereda`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Barrio_Vereda->EditValue = $arwrk;

			// Comuna_Zona
			$this->Comuna_Zona->EditCustomAttributes = "style='background-color:#CCCCFF;' readonly";
			$this->Comuna_Zona->EditValue = ew_HtmlEncode($this->Comuna_Zona->CurrentValue);
			if (strval($this->Comuna_Zona->CurrentValue) <> "") {
				$sFilterWrk = "`consecutivo`" . ew_SearchString("=", $this->Comuna_Zona->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `comuna_localidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Comuna_Zona, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->Comuna_Zona->EditValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->Comuna_Zona->EditValue = $this->Comuna_Zona->CurrentValue;
				}
			} else {
				$this->Comuna_Zona->EditValue = NULL;
			}
			$this->Comuna_Zona->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->Comuna_Zona->FldCaption()));

			// Grupo_Etnico
			$this->Grupo_Etnico->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Pertenencia_Etnica` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `pertenencia_etnica`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Grupo_Etnico, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Pertenencia_Etnica`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Grupo_Etnico->EditValue = $arwrk;

			// Tipo_Regimen
			$this->Tipo_Regimen->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `consecutivo`, `Tipo_Regimen_Salud` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `regimen_salud`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Tipo_Regimen, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Tipo_Regimen_Salud`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Tipo_Regimen->EditValue = $arwrk;

			// EPS
			$this->EPS->EditCustomAttributes = "";
			$this->EPS->EditValue = ew_HtmlEncode($this->EPS->CurrentValue);
			if (strval($this->EPS->CurrentValue) <> "") {
				$sFilterWrk = "`Codigo`" . ew_SearchString("=", $this->EPS->CurrentValue, EW_DATATYPE_STRING);
			$sSqlWrk = "SELECT `Codigo`, `Administradora_Salud` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `administradora_salud`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->EPS, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Administradora_Salud`";
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->EPS->EditValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->EPS->EditValue = $this->EPS->CurrentValue;
				}
			} else {
				$this->EPS->EditValue = NULL;
			}
			$this->EPS->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->EPS->FldCaption()));

			// Condicion_Discapacidad
			$this->Condicion_Discapacidad->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Consecutivo`, `Condicion_Discapacidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_condicion_discapacidad`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Condicion_Discapacidad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Condicion_Discapacidad->EditValue = $arwrk;

			// Condicion_Desplazamiento
			$this->Condicion_Desplazamiento->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->Condicion_Desplazamiento->FldTagValue(1), $this->Condicion_Desplazamiento->FldTagCaption(1) <> "" ? $this->Condicion_Desplazamiento->FldTagCaption(1) : $this->Condicion_Desplazamiento->FldTagValue(1));
			$arwrk[] = array($this->Condicion_Desplazamiento->FldTagValue(2), $this->Condicion_Desplazamiento->FldTagCaption(2) <> "" ? $this->Condicion_Desplazamiento->FldTagCaption(2) : $this->Condicion_Desplazamiento->FldTagValue(2));
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect")));
			$this->Condicion_Desplazamiento->EditValue = $arwrk;

			// Entidad_Educativa
			$this->Entidad_Educativa->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Id`, `Entidad_Educativa` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `entidad_educativa`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Entidad_Educativa, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Entidad_Educativa`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Entidad_Educativa->EditValue = $arwrk;

			// Escolaridad
			$this->Escolaridad->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `Consecutivo`, `Grado_Escolar` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `nutricion_grado_escolar`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->Escolaridad, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `Grado_Escolar`";
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Escolaridad->EditValue = $arwrk;

			// Clasificado
			$this->Clasificado->EditCustomAttributes = "onchange='CalcularClase();'";
			$arwrk = array();
			$arwrk[] = array($this->Clasificado->FldTagValue(1), $this->Clasificado->FldTagCaption(1) <> "" ? $this->Clasificado->FldTagCaption(1) : $this->Clasificado->FldTagValue(1));
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect")));
			$this->Clasificado->EditValue = $arwrk;

			// Usuario
			// Fecha_edicion
			// Edit refer script
			// Entidad_Valora

			$this->Entidad_Valora->HrefValue = "";

			// Tipo_Entidad
			$this->Tipo_Entidad->HrefValue = "";

			// Tipo_Documento
			$this->Tipo_Documento->HrefValue = "";

			// Documento
			$this->Documento->HrefValue = "";

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->HrefValue = "";

			// Genero
			$this->Genero->HrefValue = "";

			// Nombres
			$this->Nombres->HrefValue = "";

			// Apellidos
			$this->Apellidos->HrefValue = "";

			// Fecha_valoracion
			$this->Fecha_valoracion->HrefValue = "";

			// Edad_Anos
			$this->Edad_Anos->HrefValue = "";

			// Edad_Meses
			$this->Edad_Meses->HrefValue = "";

			// Peso
			$this->Peso->HrefValue = "";

			// Talla
			$this->Talla->HrefValue = "";

			// Perimetro_Cefalico
			$this->Perimetro_Cefalico->HrefValue = "";

			// Perimetro_Abdominal
			$this->Perimetro_Abdominal->HrefValue = "";

			// IMC
			$this->IMC->HrefValue = "";

			// DS_TallaEdad
			$this->DS_TallaEdad->HrefValue = "";

			// DS_PesoTalla
			$this->DS_PesoTalla->HrefValue = "";

			// DS_PesoEdad
			$this->DS_PesoEdad->HrefValue = "";

			// DS_IMCEdad
			$this->DS_IMCEdad->HrefValue = "";

			// DS_PCEdad
			$this->DS_PCEdad->HrefValue = "";

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->HrefValue = "";

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->HrefValue = "";

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->HrefValue = "";

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->HrefValue = "";

			// Clasificacion_P_Cefalico
			$this->Clasificacion_P_Cefalico->HrefValue = "";

			// Superficie_Corporal
			$this->Superficie_Corporal->HrefValue = "";

			// Zona
			$this->Zona->HrefValue = "";

			// Barrio_Vereda
			$this->Barrio_Vereda->HrefValue = "";

			// Comuna_Zona
			$this->Comuna_Zona->HrefValue = "";

			// Grupo_Etnico
			$this->Grupo_Etnico->HrefValue = "";

			// Tipo_Regimen
			$this->Tipo_Regimen->HrefValue = "";

			// EPS
			$this->EPS->HrefValue = "";

			// Condicion_Discapacidad
			$this->Condicion_Discapacidad->HrefValue = "";

			// Condicion_Desplazamiento
			$this->Condicion_Desplazamiento->HrefValue = "";

			// Entidad_Educativa
			$this->Entidad_Educativa->HrefValue = "";

			// Escolaridad
			$this->Escolaridad->HrefValue = "";

			// Clasificado
			$this->Clasificado->HrefValue = "";

			// Usuario
			$this->Usuario->HrefValue = "";

			// Fecha_edicion
			$this->Fecha_edicion->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->Entidad_Valora->FldIsDetailKey && !is_null($this->Entidad_Valora->FormValue) && $this->Entidad_Valora->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Entidad_Valora->FldCaption());
		}
		if (!$this->Tipo_Entidad->FldIsDetailKey && !is_null($this->Tipo_Entidad->FormValue) && $this->Tipo_Entidad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Tipo_Entidad->FldCaption());
		}
		if (!$this->Tipo_Documento->FldIsDetailKey && !is_null($this->Tipo_Documento->FormValue) && $this->Tipo_Documento->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Tipo_Documento->FldCaption());
		}
		if (!$this->Documento->FldIsDetailKey && !is_null($this->Documento->FormValue) && $this->Documento->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Documento->FldCaption());
		}
		if (!$this->Fecha_Nacimiento->FldIsDetailKey && !is_null($this->Fecha_Nacimiento->FormValue) && $this->Fecha_Nacimiento->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Fecha_Nacimiento->FldCaption());
		}
		if (!ew_CheckEuroDate($this->Fecha_Nacimiento->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Nacimiento->FldErrMsg());
		}
		if (!$this->Genero->FldIsDetailKey && !is_null($this->Genero->FormValue) && $this->Genero->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Genero->FldCaption());
		}
		if (!$this->Nombres->FldIsDetailKey && !is_null($this->Nombres->FormValue) && $this->Nombres->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Nombres->FldCaption());
		}
		if (!$this->Apellidos->FldIsDetailKey && !is_null($this->Apellidos->FormValue) && $this->Apellidos->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Apellidos->FldCaption());
		}
		if (!$this->Fecha_valoracion->FldIsDetailKey && !is_null($this->Fecha_valoracion->FormValue) && $this->Fecha_valoracion->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Fecha_valoracion->FldCaption());
		}
		if (!ew_CheckEuroDate($this->Fecha_valoracion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_valoracion->FldErrMsg());
		}
		if (!$this->Edad_Anos->FldIsDetailKey && !is_null($this->Edad_Anos->FormValue) && $this->Edad_Anos->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Edad_Anos->FldCaption());
		}
		if (!ew_CheckInteger($this->Edad_Anos->FormValue)) {
			ew_AddMessage($gsFormError, $this->Edad_Anos->FldErrMsg());
		}
		if (!$this->Edad_Meses->FldIsDetailKey && !is_null($this->Edad_Meses->FormValue) && $this->Edad_Meses->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Edad_Meses->FldCaption());
		}
		if (!ew_CheckInteger($this->Edad_Meses->FormValue)) {
			ew_AddMessage($gsFormError, $this->Edad_Meses->FldErrMsg());
		}
		if (!$this->Peso->FldIsDetailKey && !is_null($this->Peso->FormValue) && $this->Peso->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Peso->FldCaption());
		}
		if (!ew_CheckRange($this->Peso->FormValue, 2, 200)) {
			ew_AddMessage($gsFormError, $this->Peso->FldErrMsg());
		}
		if (!$this->Talla->FldIsDetailKey && !is_null($this->Talla->FormValue) && $this->Talla->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Talla->FldCaption());
		}
		if (!ew_CheckRange($this->Talla->FormValue, 30, 200)) {
			ew_AddMessage($gsFormError, $this->Talla->FldErrMsg());
		}
		if (!ew_CheckRange($this->Perimetro_Cefalico->FormValue, 30, 60)) {
			ew_AddMessage($gsFormError, $this->Perimetro_Cefalico->FldErrMsg());
		}
		if (!ew_CheckRange($this->Perimetro_Abdominal->FormValue, 20, 120)) {
			ew_AddMessage($gsFormError, $this->Perimetro_Abdominal->FldErrMsg());
		}
		if (!$this->IMC->FldIsDetailKey && !is_null($this->IMC->FormValue) && $this->IMC->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->IMC->FldCaption());
		}
		if (!ew_CheckNumber($this->IMC->FormValue)) {
			ew_AddMessage($gsFormError, $this->IMC->FldErrMsg());
		}
		if (!$this->DS_TallaEdad->FldIsDetailKey && !is_null($this->DS_TallaEdad->FormValue) && $this->DS_TallaEdad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->DS_TallaEdad->FldCaption());
		}
		if (!ew_CheckNumber($this->DS_TallaEdad->FormValue)) {
			ew_AddMessage($gsFormError, $this->DS_TallaEdad->FldErrMsg());
		}
		if (!$this->DS_PesoTalla->FldIsDetailKey && !is_null($this->DS_PesoTalla->FormValue) && $this->DS_PesoTalla->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->DS_PesoTalla->FldCaption());
		}
		if (!ew_CheckNumber($this->DS_PesoTalla->FormValue)) {
			ew_AddMessage($gsFormError, $this->DS_PesoTalla->FldErrMsg());
		}
		if (!$this->DS_PesoEdad->FldIsDetailKey && !is_null($this->DS_PesoEdad->FormValue) && $this->DS_PesoEdad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->DS_PesoEdad->FldCaption());
		}
		if (!ew_CheckNumber($this->DS_PesoEdad->FormValue)) {
			ew_AddMessage($gsFormError, $this->DS_PesoEdad->FldErrMsg());
		}
		if (!$this->DS_IMCEdad->FldIsDetailKey && !is_null($this->DS_IMCEdad->FormValue) && $this->DS_IMCEdad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->DS_IMCEdad->FldCaption());
		}
		if (!ew_CheckNumber($this->DS_IMCEdad->FormValue)) {
			ew_AddMessage($gsFormError, $this->DS_IMCEdad->FldErrMsg());
		}
		if (!$this->DS_PCEdad->FldIsDetailKey && !is_null($this->DS_PCEdad->FormValue) && $this->DS_PCEdad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->DS_PCEdad->FldCaption());
		}
		if (!ew_CheckNumber($this->DS_PCEdad->FormValue)) {
			ew_AddMessage($gsFormError, $this->DS_PCEdad->FldErrMsg());
		}
		if (!$this->Clasificacion_Talla_Edad->FldIsDetailKey && !is_null($this->Clasificacion_Talla_Edad->FormValue) && $this->Clasificacion_Talla_Edad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Clasificacion_Talla_Edad->FldCaption());
		}
		if (!$this->Clasificacion_Peso_Talla->FldIsDetailKey && !is_null($this->Clasificacion_Peso_Talla->FormValue) && $this->Clasificacion_Peso_Talla->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Clasificacion_Peso_Talla->FldCaption());
		}
		if (!$this->Clasificacion_Peso_Edad->FldIsDetailKey && !is_null($this->Clasificacion_Peso_Edad->FormValue) && $this->Clasificacion_Peso_Edad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Clasificacion_Peso_Edad->FldCaption());
		}
		if (!$this->Clasificacion_IMC_Edad->FldIsDetailKey && !is_null($this->Clasificacion_IMC_Edad->FormValue) && $this->Clasificacion_IMC_Edad->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Clasificacion_IMC_Edad->FldCaption());
		}
		if (!$this->Clasificacion_P_Cefalico->FldIsDetailKey && !is_null($this->Clasificacion_P_Cefalico->FormValue) && $this->Clasificacion_P_Cefalico->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Clasificacion_P_Cefalico->FldCaption());
		}
		if (!$this->Superficie_Corporal->FldIsDetailKey && !is_null($this->Superficie_Corporal->FormValue) && $this->Superficie_Corporal->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Superficie_Corporal->FldCaption());
		}
		if (!ew_CheckNumber($this->Superficie_Corporal->FormValue)) {
			ew_AddMessage($gsFormError, $this->Superficie_Corporal->FldErrMsg());
		}
		if (!$this->Zona->FldIsDetailKey && !is_null($this->Zona->FormValue) && $this->Zona->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Zona->FldCaption());
		}
		if (!ew_CheckInteger($this->Comuna_Zona->FormValue)) {
			ew_AddMessage($gsFormError, $this->Comuna_Zona->FldErrMsg());
		}
		if (!$this->Entidad_Educativa->FldIsDetailKey && !is_null($this->Entidad_Educativa->FormValue) && $this->Entidad_Educativa->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Entidad_Educativa->FldCaption());
		}
		if (!$this->Clasificado->FldIsDetailKey && !is_null($this->Clasificado->FormValue) && $this->Clasificado->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->Clasificado->FldCaption());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// Entidad_Valora
			$this->Entidad_Valora->SetDbValueDef($rsnew, $this->Entidad_Valora->CurrentValue, 0, $this->Entidad_Valora->ReadOnly);

			// Tipo_Entidad
			$this->Tipo_Entidad->SetDbValueDef($rsnew, $this->Tipo_Entidad->CurrentValue, NULL, $this->Tipo_Entidad->ReadOnly);

			// Tipo_Documento
			$this->Tipo_Documento->SetDbValueDef($rsnew, $this->Tipo_Documento->CurrentValue, NULL, $this->Tipo_Documento->ReadOnly);

			// Documento
			$this->Documento->SetDbValueDef($rsnew, $this->Documento->CurrentValue, "", $this->Documento->ReadOnly);

			// Fecha_Nacimiento
			$this->Fecha_Nacimiento->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Nacimiento->CurrentValue, 7), ew_CurrentDate(), $this->Fecha_Nacimiento->ReadOnly);

			// Genero
			$this->Genero->SetDbValueDef($rsnew, $this->Genero->CurrentValue, 0, $this->Genero->ReadOnly);

			// Nombres
			$this->Nombres->SetDbValueDef($rsnew, $this->Nombres->CurrentValue, "", $this->Nombres->ReadOnly);

			// Apellidos
			$this->Apellidos->SetDbValueDef($rsnew, $this->Apellidos->CurrentValue, "", $this->Apellidos->ReadOnly);

			// Fecha_valoracion
			$this->Fecha_valoracion->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_valoracion->CurrentValue, 7), NULL, $this->Fecha_valoracion->ReadOnly);

			// Edad_Anos
			$this->Edad_Anos->SetDbValueDef($rsnew, $this->Edad_Anos->CurrentValue, NULL, $this->Edad_Anos->ReadOnly);

			// Edad_Meses
			$this->Edad_Meses->SetDbValueDef($rsnew, $this->Edad_Meses->CurrentValue, NULL, $this->Edad_Meses->ReadOnly);

			// Peso
			$this->Peso->SetDbValueDef($rsnew, $this->Peso->CurrentValue, NULL, $this->Peso->ReadOnly);

			// Talla
			$this->Talla->SetDbValueDef($rsnew, $this->Talla->CurrentValue, NULL, $this->Talla->ReadOnly);

			// Perimetro_Cefalico
			$this->Perimetro_Cefalico->SetDbValueDef($rsnew, $this->Perimetro_Cefalico->CurrentValue, NULL, $this->Perimetro_Cefalico->ReadOnly);

			// Perimetro_Abdominal
			$this->Perimetro_Abdominal->SetDbValueDef($rsnew, $this->Perimetro_Abdominal->CurrentValue, NULL, $this->Perimetro_Abdominal->ReadOnly);

			// IMC
			$this->IMC->SetDbValueDef($rsnew, $this->IMC->CurrentValue, NULL, $this->IMC->ReadOnly);

			// DS_TallaEdad
			$this->DS_TallaEdad->SetDbValueDef($rsnew, $this->DS_TallaEdad->CurrentValue, NULL, $this->DS_TallaEdad->ReadOnly);

			// DS_PesoTalla
			$this->DS_PesoTalla->SetDbValueDef($rsnew, $this->DS_PesoTalla->CurrentValue, NULL, $this->DS_PesoTalla->ReadOnly);

			// DS_PesoEdad
			$this->DS_PesoEdad->SetDbValueDef($rsnew, $this->DS_PesoEdad->CurrentValue, NULL, $this->DS_PesoEdad->ReadOnly);

			// DS_IMCEdad
			$this->DS_IMCEdad->SetDbValueDef($rsnew, $this->DS_IMCEdad->CurrentValue, NULL, $this->DS_IMCEdad->ReadOnly);

			// DS_PCEdad
			$this->DS_PCEdad->SetDbValueDef($rsnew, $this->DS_PCEdad->CurrentValue, NULL, $this->DS_PCEdad->ReadOnly);

			// Clasificacion_Talla_Edad
			$this->Clasificacion_Talla_Edad->SetDbValueDef($rsnew, $this->Clasificacion_Talla_Edad->CurrentValue, NULL, $this->Clasificacion_Talla_Edad->ReadOnly);

			// Clasificacion_Peso_Talla
			$this->Clasificacion_Peso_Talla->SetDbValueDef($rsnew, $this->Clasificacion_Peso_Talla->CurrentValue, NULL, $this->Clasificacion_Peso_Talla->ReadOnly);

			// Clasificacion_Peso_Edad
			$this->Clasificacion_Peso_Edad->SetDbValueDef($rsnew, $this->Clasificacion_Peso_Edad->CurrentValue, NULL, $this->Clasificacion_Peso_Edad->ReadOnly);

			// Clasificacion_IMC_Edad
			$this->Clasificacion_IMC_Edad->SetDbValueDef($rsnew, $this->Clasificacion_IMC_Edad->CurrentValue, NULL, $this->Clasificacion_IMC_Edad->ReadOnly);

			// Clasificacion_P_Cefalico
			$this->Clasificacion_P_Cefalico->SetDbValueDef($rsnew, $this->Clasificacion_P_Cefalico->CurrentValue, NULL, $this->Clasificacion_P_Cefalico->ReadOnly);

			// Superficie_Corporal
			$this->Superficie_Corporal->SetDbValueDef($rsnew, $this->Superficie_Corporal->CurrentValue, NULL, $this->Superficie_Corporal->ReadOnly);

			// Zona
			$this->Zona->SetDbValueDef($rsnew, $this->Zona->CurrentValue, 0, $this->Zona->ReadOnly);

			// Barrio_Vereda
			$this->Barrio_Vereda->SetDbValueDef($rsnew, $this->Barrio_Vereda->CurrentValue, NULL, $this->Barrio_Vereda->ReadOnly);

			// Comuna_Zona
			$this->Comuna_Zona->SetDbValueDef($rsnew, $this->Comuna_Zona->CurrentValue, NULL, $this->Comuna_Zona->ReadOnly);

			// Grupo_Etnico
			$this->Grupo_Etnico->SetDbValueDef($rsnew, $this->Grupo_Etnico->CurrentValue, NULL, $this->Grupo_Etnico->ReadOnly);

			// Tipo_Regimen
			$this->Tipo_Regimen->SetDbValueDef($rsnew, $this->Tipo_Regimen->CurrentValue, NULL, $this->Tipo_Regimen->ReadOnly);

			// EPS
			$this->EPS->SetDbValueDef($rsnew, $this->EPS->CurrentValue, NULL, $this->EPS->ReadOnly);

			// Condicion_Discapacidad
			$this->Condicion_Discapacidad->SetDbValueDef($rsnew, $this->Condicion_Discapacidad->CurrentValue, NULL, $this->Condicion_Discapacidad->ReadOnly);

			// Condicion_Desplazamiento
			$this->Condicion_Desplazamiento->SetDbValueDef($rsnew, $this->Condicion_Desplazamiento->CurrentValue, NULL, $this->Condicion_Desplazamiento->ReadOnly);

			// Entidad_Educativa
			$this->Entidad_Educativa->SetDbValueDef($rsnew, $this->Entidad_Educativa->CurrentValue, NULL, $this->Entidad_Educativa->ReadOnly);

			// Escolaridad
			$this->Escolaridad->SetDbValueDef($rsnew, $this->Escolaridad->CurrentValue, NULL, $this->Escolaridad->ReadOnly);

			// Clasificado
			$this->Clasificado->SetDbValueDef($rsnew, $this->Clasificado->CurrentValue, NULL, $this->Clasificado->ReadOnly);

			// Usuario
			$this->Usuario->SetDbValueDef($rsnew, CurrentUserName(), NULL);
			$rsnew['Usuario'] = &$this->Usuario->DbValue;

			// Fecha_edicion
			$this->Fecha_edicion->SetDbValueDef($rsnew, ew_CurrentDate(), NULL);
			$rsnew['Fecha_edicion'] = &$this->Fecha_edicion->DbValue;

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = 'ew_ErrorFn';
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Show link optionally based on User ID
	function ShowOptionLink($id = "") {
		global $Security;
		if ($Security->IsLoggedIn() && !$Security->IsAdmin() && !$this->UserIDAllow($id))
			return $Security->IsValidUserID($this->Entidad_Valora->CurrentValue);
		return TRUE;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "nutricion_valoracionlist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("edit");
		$Breadcrumb->Add("edit", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($nutricion_valoracion_edit)) $nutricion_valoracion_edit = new cnutricion_valoracion_edit();

// Page init
$nutricion_valoracion_edit->Page_Init();

// Page main
$nutricion_valoracion_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$nutricion_valoracion_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var nutricion_valoracion_edit = new ew_Page("nutricion_valoracion_edit");
nutricion_valoracion_edit.PageID = "edit"; // Page ID
var EW_PAGE_ID = nutricion_valoracion_edit.PageID; // For backward compatibility

// Form object
var fnutricion_valoracionedit = new ew_Form("fnutricion_valoracionedit");

// Validate form
fnutricion_valoracionedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, aelm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = fobj.elements["x" + infix + "_Entidad_Valora"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Entidad_Valora->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Tipo_Entidad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Tipo_Entidad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Tipo_Documento"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Tipo_Documento->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Documento"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Documento->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Fecha_Nacimiento"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Fecha_Nacimiento->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Fecha_Nacimiento"];
			if (elm && !ew_CheckEuroDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Fecha_Nacimiento->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Genero"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Genero->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Nombres"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Nombres->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Apellidos"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Apellidos->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Fecha_valoracion"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Fecha_valoracion->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Fecha_valoracion"];
			if (elm && !ew_CheckEuroDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Fecha_valoracion->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Edad_Anos"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Edad_Anos->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Edad_Anos"];
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Edad_Anos->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Edad_Meses"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Edad_Meses->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Edad_Meses"];
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Edad_Meses->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Peso"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Peso->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Peso"];
			if (elm && !ew_CheckRange(elm.value, 2, 200))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Peso->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Talla"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Talla->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Talla"];
			if (elm && !ew_CheckRange(elm.value, 30, 200))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Talla->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Perimetro_Cefalico"];
			if (elm && !ew_CheckRange(elm.value, 30, 60))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Perimetro_Cefalico->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Perimetro_Abdominal"];
			if (elm && !ew_CheckRange(elm.value, 20, 120))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Perimetro_Abdominal->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_IMC"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->IMC->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_IMC"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->IMC->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_DS_TallaEdad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->DS_TallaEdad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_DS_TallaEdad"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->DS_TallaEdad->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_DS_PesoTalla"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->DS_PesoTalla->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_DS_PesoTalla"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->DS_PesoTalla->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_DS_PesoEdad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->DS_PesoEdad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_DS_PesoEdad"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->DS_PesoEdad->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_DS_IMCEdad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->DS_IMCEdad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_DS_IMCEdad"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->DS_IMCEdad->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_DS_PCEdad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->DS_PCEdad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_DS_PCEdad"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->DS_PCEdad->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Clasificacion_Talla_Edad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Clasificacion_Talla_Edad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Clasificacion_Peso_Talla"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Clasificacion_Peso_Talla->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Clasificacion_Peso_Edad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Clasificacion_Peso_Edad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Clasificacion_IMC_Edad"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Clasificacion_IMC_Edad->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Clasificacion_P_Cefalico"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Clasificacion_P_Cefalico->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Superficie_Corporal"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Superficie_Corporal->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Superficie_Corporal"];
			if (elm && !ew_CheckNumber(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Superficie_Corporal->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Zona"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Zona->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Comuna_Zona"];
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($nutricion_valoracion->Comuna_Zona->FldErrMsg()) ?>");
			elm = fobj.elements["x" + infix + "_Entidad_Educativa"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Entidad_Educativa->FldCaption()) ?>");
			elm = fobj.elements["x" + infix + "_Clasificado"];
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($nutricion_valoracion->Clasificado->FldCaption()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnutricion_valoracionedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnutricion_valoracionedit.ValidateRequired = true;
<?php } else { ?>
fnutricion_valoracionedit.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnutricion_valoracionedit.Lists["x_Entidad_Valora"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":true,"DisplayFields":["x_Entidad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Tipo_Documento"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Tipo_Documento","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Genero"] = {"LinkField":"x__23","Ajax":null,"AutoFill":false,"DisplayFields":["x_Genero","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Clasificacion_Talla_Edad"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Talla_Edad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Clasificacion_Peso_Talla"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Peso_Talla","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Clasificacion_Peso_Edad"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Peso_Edad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Clasificacion_IMC_Edad"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_IMC_Edad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Clasificacion_P_Cefalico"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Clasificacion_Perimetro_Cefalico","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Zona"] = {"LinkField":"x_codigo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Zona","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Barrio_Vereda"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":true,"DisplayFields":["x_Barrio_Vereda","","",""],"ParentFields":["x_Zona"],"FilterFields":["x_Zona"],"Options":[]};
fnutricion_valoracionedit.Lists["x_Comuna_Zona"] = {"LinkField":"x_consecutivo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Localidad_Comuna","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Grupo_Etnico"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Pertenencia_Etnica","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Tipo_Regimen"] = {"LinkField":"x_consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Tipo_Regimen_Salud","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_EPS"] = {"LinkField":"x_Codigo","Ajax":true,"AutoFill":false,"DisplayFields":["x_Administradora_Salud","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Condicion_Discapacidad"] = {"LinkField":"x_Consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Condicion_Discapacidad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Entidad_Educativa"] = {"LinkField":"x_Id","Ajax":null,"AutoFill":false,"DisplayFields":["x_Entidad_Educativa","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnutricion_valoracionedit.Lists["x_Escolaridad"] = {"LinkField":"x_Consecutivo","Ajax":null,"AutoFill":false,"DisplayFields":["x_Grado_Escolar","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.     
function Calcular_IMC()   

// calcula IMC /Superficie Corporal
{                                              
var peso  = document.getElementById('x_Peso').value;   
var talla = document.getElementById('x_Talla').value;                                                           
var IMC = peso/(talla*talla);                              
var pesotalla = peso*talla/3600;
var SC  = Math.sqrt(pesotalla);                                                                             

// superficie corporal segun Mosteller           
document.getElementById("x_IMC").value = IMC*10000; 
document.getElementById("x_Superficie_Corporal").value = SC; 
document.getElementById("x_Clasificado").value = "NA"; 
}                                                         

function CalcularEdad()                     
{                                        

//  fecha valoracion                    
var fecha_valoracion         = document.getElementById("x_Fecha_valoracion").value;
var array_fecha_valoracion   = fecha_valoracion.split("/");               
var valoracion_ano = parseInt(array_fecha_valoracion[2]);
var valoracion_mes = parseInt(array_fecha_valoracion[1]);     
var valoracion_dia = parseInt(array_fecha_valoracion[0]);  
var valoracion   =  valoracion_mes+"/"+valoracion_dia+"/"+valoracion_ano;  
var ivaloracion  =  valoracion_dia+"/"+valoracion_mes+"/"+valoracion_ano;  
var fecha_nacimiento  = document.getElementById("x_Fecha_Nacimiento").value;
var array_fecha       = fecha_nacimiento.split("/");    
var ano = parseInt(array_fecha[2]);                   
var mes = parseInt(array_fecha[1]);                           
var dia = parseInt(array_fecha[0]);                
var nacimiento       =  mes+"/"+dia+"/"+ano;                
var inacimiento      =  dia+"/"+mes+"/"+ano;     
valoracion = new Date(valoracion);                 
nacimiento = new Date(nacimiento); 

// Calcular Edad Aos --Meses    
edadanos  =     parseInt((valoracion-nacimiento)/365.4/24/60/60/1000); 
edadmeses =     parseInt((valoracion-nacimiento)/30.45/24/60/60/1000);      

//(24*1000*3600*365.4)
//(24*1000*3600*30.45)     
// Valida fecha actual con fecha de valoracion  y fecha nacimiento

var actual = new Date();
if (valoracion>actual) 
   {           
   vvaloracion = "Fecha Futura!"; 
   vnacimiento =  inacimiento;
   document.getElementById("x_Fecha_valoracion").value = vvaloracion;
   document.getElementById("x_Fecha_Nacimiento").value = vnacimiento; 
   document.getElementById("x_Edad_Anos").value = -1;
   document.getElementById("x_Edad_Meses").value = -1;
   }                                   
   else
	  {
	   vvaloracion = ivaloracion; 
	   vnacimiento = inacimiento;
	   document.getElementById("x_Fecha_valoracion").value = vvaloracion;
	   document.getElementById("x_Fecha_Nacimiento").value = vnacimiento; 
	   document.getElementById("x_Edad_Anos").value = -1;
	   document.getElementById("x_Edad_Meses").value = -1;
	   if (nacimiento>valoracion)
			{
			vnacimiento = "Post Valoracion!";   
			vvaloracion = vvaloracion;
			document.getElementById("x_Fecha_valoracion").value = vvaloracion;
			document.getElementById("x_Fecha_Nacimiento").value = vnacimiento;
			document.getElementById("x_Edad_Anos").value = -1;
			document.getElementById("x_Edad_Meses").value = -1;
			}                                                        
			else
			{
			vnacimiento = inacimiento;
			vvaloracion = vvaloracion;
			document.getElementById("x_Fecha_valoracion").value = vvaloracion;
			document.getElementById("x_Fecha_Nacimiento").value = vnacimiento;  
			document.getElementById("x_Edad_Anos").value = edadanos;
			document.getElementById("x_Edad_Meses").value = edadmeses;
		  }
 }             
}                     

function OpenPop_Up(){
  var linkhref = document.getElementById("dialog-link").href;
  var win=window.open(linkhref, "DESV", "left=100,top=10,width=800,height=450,status=no,toolbar=no,menubar=no,location=no,scrollbars=yes");
  win.focus();    
}     

function CalcularClase(){     
var clasificar = document.getElementById('x_Clasificado').value;    

// talla-edad
var Z_te = document.getElementById('x_DS_TallaEdad').value;    

//var Z_te = 2.1;
if (Z_te<-2)
  {

 // Z es menor o igual que  -6
  clase = 1;
  }
else
  {

 // Z es mayor que -5
		if (Z_te>=-2 && Z_te<-1)
		  {

		 // Z es menor o igual que  -2
		  clase = 2;                
		  }

		 // Z es mayor que -2
		   else
					{

				   // Z es mayor que o igual que 6
				   clase = 3;
					}     
 }                             
document.getElementById("x_Clasificacion_Talla_Edad").value = clase;

// fin talla-edad
// peso-talla

var Z_pt = document.getElementById('x_DS_PesoTalla').value;
var Edadptall  = document.getElementById('x_Edad_Meses').value; 
if (Z_pt<-3 && Edadptall<60)
	{

 // Z es menor o igual que  -6 
  clase = 2;
	}
else
	{ 

 // Z es mayor que -6
		if (Z_pt>=-3 && Z_pt<-2 && Edadptall<60)
		{ 

		 // Z es menor o igual que  -3
		  clase = 1;
		}
		else
		{    

		 // Z es mayor que -3
			if (Z_pt>=-2 && Z_pt<-1 && Edadptall<60)
			{  

			 // Z es menor o igual que  -2
			  clase = 3;
			}  
			else
			{   

			 // Z es mayor que -2
				 if (Z_pt>=-1 && Z_pt<=1 && Edadptall<60)
				 { 

				   // Z es menor o igual que  -1
					clase = 4;
				 } 
				  else
				 {  

				   // Z es mayor que -1
					if (Z_pt>1 && Z_pt<=2 && Edadptall<60)
					 {  

					 // Z es menor o igual que  1
					  clase = 9;
					 } 
					else
					 {

					 // Z es mayor que 1
						if (Z_pt>2 && Z_pt<=3 && Edadptall<60)
						{                                      

						   // Z es menor o igual que  2
							clase = 5;
						} 
						  else   
						{  
						if    (Z_pt>3 && Edadptall<60)
							   {
								 clase = 6;
							   } 
							   else 
							   {
							   clase = 10 ;
							   }
						} 
				   }     
			  }
		 }                 
	 }
   }    
document.getElementById("x_Clasificacion_Peso_Talla").value = clase;

// fin peso-talla
// Peso-Edad

var Z_pe = document.getElementById('x_DS_PesoEdad').value;
var Edadpe  = document.getElementById('x_Edad_Meses').value;  
if (Z_pe<-2 && Edadpe<60)
  {
  clase = 2;
  }
else if (Z_pe>=-2 && Z_pe<-1 && Edadpe<60)
		  {
			  clase = 3;                
		  }
else if (Z_pe>=-1 && Z_pe<=1 && Edadpe<60)
						{  
							clase = 4;
						} 
else if (Z_pe>1 && Edadpe<60)
						{ 
								 clase = 8;
						  }  
else if( Edadpe>=60)   
{ 
								 clase = 9;
}                            
document.getElementById("x_Clasificacion_Peso_Edad").value = clase;

//document.getElementById("pesoedad").innerHTML = clase;
//  fin peso-edad                      

var Z_ie = document.getElementById('x_DS_IMCEdad').value;   
var Edadimc  = document.getElementById('x_Edad_Meses').value;  
if (Z_ie<-2 && Edadimc>60)
  { 
  clase = 1;
  }
else  if (Z_ie>=-2 && Z_ie<-1 && Edadimc>=60)
		  { 
		  clase = 2;                
		  } 
else  if (Z_ie>=-1 && Z_ie<=1 && Edadimc>=60)
		  { 
		  clase = 3;                
		  } 
else  if (Z_ie>1 && Z_ie<=2 && Edadimc>=60)
		  { 
		  clase = 4;                
		  } 
else  if (Z_ie>2 && Edadimc>=60)
		  { 
		  clase = 5;                
		  }
else  if (Z_ie<=1 && Edadimc<60)
		  { 
		  clase = 8;                
		  } 
else  if (Z_ie>1 && Z_ie<=2 && Edadimc<60)
		  { 
		  clase = 9;                
		  } 
else  if (Z_ie>2 && Z_ie<=3 && Edadimc<60)
		  { 
		  clase = 4;                
		  }           
else { 
clase = 5
}     
document.getElementById("x_Clasificacion_IMC_Edad").value = clase; 

//document.getElementById("pesoedad").innerHTML = clase;
//  fin imc-edad    
// p-cefalico

var Z_pc = document.getElementById('x_DS_PCEdad').value;

//var Z_pc = 6.1;
if (Z_pc<=-5)
  {

 // Z es menor o igual que  -5
  clase = 4;
  }
else
  {
	if (Z_pc<=-2)
	  {

	 // Z es menor o igual que  -2
	  clase = 1;
	  }
	else
	  {
		if (Z_pc<=2)
		  {

		 // Z es menor o igual que  2
		  clase = 2;
		  }        
		else
		  {
			  if (Z_pc<=+5)
				{

			   // Z es menor o igual que  +5
				clase = 3;
				}
			  else
				{
				clase = 5;
				}
		  }
	  }
  }                          
document.getElementById("x_Clasificacion_P_Cefalico").value = clase; 
}    
</script>
<?php $Breadcrumb->Render(); ?>
<?php $nutricion_valoracion_edit->ShowPageHeader(); ?>
<?php
$nutricion_valoracion_edit->ShowMessage();
?>
<form name="fnutricion_valoracionedit" id="fnutricion_valoracionedit" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="nutricion_valoracion">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<table cellspacing="0" class="ewGrid" style="display: none"><tr><td>
<table id="tbl_nutricion_valoracionedit" class="table table-bordered table-striped">
<?php if ($nutricion_valoracion->Entidad_Valora->Visible) { // Entidad_Valora ?>
	<tr id="r_Entidad_Valora"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Entidad_Valora"><script id="tpc_nutricion_valoracion_Entidad_Valora" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Entidad_Valora->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Entidad_Valora->CellAttributes() ?>><span id="el_nutricion_valoracion_Entidad_Valora" class="control-group">
<?php if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$nutricion_valoracion->UserIDAllow("edit")) { // Non system admin ?>
<script id="tpx_nutricion_valoracion_Entidad_Valora" class="nutricion_valoracionedit" type="text/html">
<span<?php echo $nutricion_valoracion->Entidad_Valora->ViewAttributes() ?>>
<?php echo $nutricion_valoracion->Entidad_Valora->EditValue ?></span>
</script>
<input type="hidden" class="x_Entidad_Valora" name="x_Entidad_Valora" id="x_Entidad_Valora" value="<?php echo ew_HtmlEncode($nutricion_valoracion->Entidad_Valora->CurrentValue) ?>">
<?php } else { ?>
<script id="tpx_nutricion_valoracion_Entidad_Valora" class="nutricion_valoracionedit" type="text/html">
<?php $nutricion_valoracion->Entidad_Valora->EditAttrs["onchange"] = "ew_AutoFill(this); " . @$nutricion_valoracion->Entidad_Valora->EditAttrs["onchange"]; ?>
<select class="x_Entidad_Valora" id="x_Entidad_Valora" name="x_Entidad_Valora"<?php echo $nutricion_valoracion->Entidad_Valora->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Entidad_Valora->EditValue)) {
	$arwrk = $nutricion_valoracion->Entidad_Valora->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Entidad_Valora->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `Tipo_Entidad` AS FIELD0 FROM `entidad_upgd`";
$sWhereWrk = "(`consecutivo` = {query_value})";
$lookuptblfilter = "`Activa`=1";
if (strval($lookuptblfilter) <> "") {
	ew_AddFilter($sWhereWrk, $lookuptblfilter);
}

// Call Lookup selecting
$nutricion_valoracion->Lookup_Selecting($nutricion_valoracion->Entidad_Valora, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY `Entidad`";
$sSqlWrk = ew_Encrypt($sSqlWrk);
?>
<input type="hidden" name="sf_x_Entidad_Valora" id="sf_x_Entidad_Valora" value="<?php echo $sSqlWrk ?>">
<input type="hidden" name="ln_x_Entidad_Valora" id="ln_x_Entidad_Valora" value="x_Tipo_Entidad">
</script>
<?php } ?>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Entidad_Valora"].Options = <?php echo (is_array($nutricion_valoracion->Entidad_Valora->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Entidad_Valora->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Entidad_Valora->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Tipo_Entidad->Visible) { // Tipo_Entidad ?>
	<tr id="r_Tipo_Entidad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Tipo_Entidad"><script id="tpc_nutricion_valoracion_Tipo_Entidad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Tipo_Entidad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Tipo_Entidad->CellAttributes() ?>><span id="el_nutricion_valoracion_Tipo_Entidad" class="control-group">
<script id="tpx_nutricion_valoracion_Tipo_Entidad" class="nutricion_valoracionedit" type="text/html">
<select class="x_Tipo_Entidad" id="x_Tipo_Entidad" name="x_Tipo_Entidad"<?php echo $nutricion_valoracion->Tipo_Entidad->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Tipo_Entidad->EditValue)) {
	$arwrk = $nutricion_valoracion->Tipo_Entidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Tipo_Entidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
</span><?php echo $nutricion_valoracion->Tipo_Entidad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Tipo_Documento->Visible) { // Tipo_Documento ?>
	<tr id="r_Tipo_Documento"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Tipo_Documento"><script id="tpc_nutricion_valoracion_Tipo_Documento" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Tipo_Documento->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Tipo_Documento->CellAttributes() ?>><span id="el_nutricion_valoracion_Tipo_Documento" class="control-group">
<script id="tpx_nutricion_valoracion_Tipo_Documento" class="nutricion_valoracionedit" type="text/html">
<select class="x_Tipo_Documento" id="x_Tipo_Documento" name="x_Tipo_Documento"<?php echo $nutricion_valoracion->Tipo_Documento->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Tipo_Documento->EditValue)) {
	$arwrk = $nutricion_valoracion->Tipo_Documento->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Tipo_Documento->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Tipo_Documento"].Options = <?php echo (is_array($nutricion_valoracion->Tipo_Documento->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Tipo_Documento->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Tipo_Documento->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Documento->Visible) { // Documento ?>
	<tr id="r_Documento"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Documento"><script id="tpc_nutricion_valoracion_Documento" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Documento->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Documento->CellAttributes() ?>><span id="el_nutricion_valoracion_Documento" class="control-group">
<script id="tpx_nutricion_valoracion_Documento" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Documento" name="x_Documento" id="x_Documento" size="12" maxlength="30" placeholder="<?php echo $nutricion_valoracion->Documento->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Documento->EditValue ?>"<?php echo $nutricion_valoracion->Documento->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Documento->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Fecha_Nacimiento->Visible) { // Fecha_Nacimiento ?>
	<tr id="r_Fecha_Nacimiento"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Fecha_Nacimiento"><script id="tpc_nutricion_valoracion_Fecha_Nacimiento" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Fecha_Nacimiento->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Fecha_Nacimiento->CellAttributes() ?>><span id="el_nutricion_valoracion_Fecha_Nacimiento" class="control-group">
<script id="tpx_nutricion_valoracion_Fecha_Nacimiento" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Fecha_Nacimiento" name="x_Fecha_Nacimiento" id="x_Fecha_Nacimiento" size="12" placeholder="<?php echo $nutricion_valoracion->Fecha_Nacimiento->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Fecha_Nacimiento->EditValue ?>"<?php echo $nutricion_valoracion->Fecha_Nacimiento->EditAttributes() ?>>
<?php if (!$nutricion_valoracion->Fecha_Nacimiento->ReadOnly && !$nutricion_valoracion->Fecha_Nacimiento->Disabled && @$nutricion_valoracion->Fecha_Nacimiento->EditAttrs["readonly"] == "" && @$nutricion_valoracion->Fecha_Nacimiento->EditAttrs["disabled"] == "") { ?>
<button id="cal_x_Fecha_Nacimiento" name="cal_x_Fecha_Nacimiento" class="btn" type="button"><img src="phpimages/calendar.png" alt="<?php echo $Language->Phrase("PickDate") ?>" title="<?php echo $Language->Phrase("PickDate") ?>" style="border: 0;"></button>
<?php } ?>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
ew_CreateCalendar("fnutricion_valoracionedit", "x_Fecha_Nacimiento", "%d/%m/%Y");
</script>
</span><?php echo $nutricion_valoracion->Fecha_Nacimiento->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Genero->Visible) { // Genero ?>
	<tr id="r_Genero"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Genero"><script id="tpc_nutricion_valoracion_Genero" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Genero->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Genero->CellAttributes() ?>><span id="el_nutricion_valoracion_Genero" class="control-group">
<script id="tpx_nutricion_valoracion_Genero" class="nutricion_valoracionedit" type="text/html">
<select class="x_Genero" id="x_Genero" name="x_Genero"<?php echo $nutricion_valoracion->Genero->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Genero->EditValue)) {
	$arwrk = $nutricion_valoracion->Genero->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Genero->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Genero"].Options = <?php echo (is_array($nutricion_valoracion->Genero->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Genero->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Genero->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Nombres->Visible) { // Nombres ?>
	<tr id="r_Nombres"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Nombres"><script id="tpc_nutricion_valoracion_Nombres" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Nombres->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Nombres->CellAttributes() ?>><span id="el_nutricion_valoracion_Nombres" class="control-group">
<script id="tpx_nutricion_valoracion_Nombres" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Nombres" name="x_Nombres" id="x_Nombres" size="20" maxlength="100" placeholder="<?php echo $nutricion_valoracion->Nombres->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Nombres->EditValue ?>"<?php echo $nutricion_valoracion->Nombres->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Nombres->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Apellidos->Visible) { // Apellidos ?>
	<tr id="r_Apellidos"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Apellidos"><script id="tpc_nutricion_valoracion_Apellidos" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Apellidos->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Apellidos->CellAttributes() ?>><span id="el_nutricion_valoracion_Apellidos" class="control-group">
<script id="tpx_nutricion_valoracion_Apellidos" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Apellidos" name="x_Apellidos" id="x_Apellidos" size="20" maxlength="100" placeholder="<?php echo $nutricion_valoracion->Apellidos->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Apellidos->EditValue ?>"<?php echo $nutricion_valoracion->Apellidos->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Apellidos->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Fecha_valoracion->Visible) { // Fecha_valoracion ?>
	<tr id="r_Fecha_valoracion"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Fecha_valoracion"><script id="tpc_nutricion_valoracion_Fecha_valoracion" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Fecha_valoracion->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Fecha_valoracion->CellAttributes() ?>><span id="el_nutricion_valoracion_Fecha_valoracion" class="control-group">
<script id="tpx_nutricion_valoracion_Fecha_valoracion" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Fecha_valoracion" name="x_Fecha_valoracion" id="x_Fecha_valoracion" size="12" placeholder="<?php echo $nutricion_valoracion->Fecha_valoracion->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Fecha_valoracion->EditValue ?>"<?php echo $nutricion_valoracion->Fecha_valoracion->EditAttributes() ?>>
<?php if (!$nutricion_valoracion->Fecha_valoracion->ReadOnly && !$nutricion_valoracion->Fecha_valoracion->Disabled && @$nutricion_valoracion->Fecha_valoracion->EditAttrs["readonly"] == "" && @$nutricion_valoracion->Fecha_valoracion->EditAttrs["disabled"] == "") { ?>
<button id="cal_x_Fecha_valoracion" name="cal_x_Fecha_valoracion" class="btn" type="button"><img src="phpimages/calendar.png" alt="<?php echo $Language->Phrase("PickDate") ?>" title="<?php echo $Language->Phrase("PickDate") ?>" style="border: 0;"></button>
<?php } ?>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
ew_CreateCalendar("fnutricion_valoracionedit", "x_Fecha_valoracion", "%d/%m/%Y");
</script>
</span><?php echo $nutricion_valoracion->Fecha_valoracion->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Edad_Anos->Visible) { // Edad_Anos ?>
	<tr id="r_Edad_Anos"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Edad_Anos"><script id="tpc_nutricion_valoracion_Edad_Anos" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Edad_Anos->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Edad_Anos->CellAttributes() ?>><span id="el_nutricion_valoracion_Edad_Anos" class="control-group">
<script id="tpx_nutricion_valoracion_Edad_Anos" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Edad_Anos" name="x_Edad_Anos" id="x_Edad_Anos" size="4" placeholder="<?php echo $nutricion_valoracion->Edad_Anos->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Edad_Anos->EditValue ?>"<?php echo $nutricion_valoracion->Edad_Anos->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Edad_Anos->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Edad_Meses->Visible) { // Edad_Meses ?>
	<tr id="r_Edad_Meses"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Edad_Meses"><script id="tpc_nutricion_valoracion_Edad_Meses" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Edad_Meses->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Edad_Meses->CellAttributes() ?>><span id="el_nutricion_valoracion_Edad_Meses" class="control-group">
<script id="tpx_nutricion_valoracion_Edad_Meses" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Edad_Meses" name="x_Edad_Meses" id="x_Edad_Meses" size="4" placeholder="<?php echo $nutricion_valoracion->Edad_Meses->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Edad_Meses->EditValue ?>"<?php echo $nutricion_valoracion->Edad_Meses->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Edad_Meses->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Peso->Visible) { // Peso ?>
	<tr id="r_Peso"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Peso"><script id="tpc_nutricion_valoracion_Peso" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Peso->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Peso->CellAttributes() ?>><span id="el_nutricion_valoracion_Peso" class="control-group">
<script id="tpx_nutricion_valoracion_Peso" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Peso" name="x_Peso" id="x_Peso" size="6" placeholder="<?php echo $nutricion_valoracion->Peso->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Peso->EditValue ?>"<?php echo $nutricion_valoracion->Peso->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Peso->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Talla->Visible) { // Talla ?>
	<tr id="r_Talla"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Talla"><script id="tpc_nutricion_valoracion_Talla" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Talla->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Talla->CellAttributes() ?>><span id="el_nutricion_valoracion_Talla" class="control-group">
<script id="tpx_nutricion_valoracion_Talla" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Talla" name="x_Talla" id="x_Talla" size="6" placeholder="<?php echo $nutricion_valoracion->Talla->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Talla->EditValue ?>"<?php echo $nutricion_valoracion->Talla->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Talla->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Perimetro_Cefalico->Visible) { // Perimetro_Cefalico ?>
	<tr id="r_Perimetro_Cefalico"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Perimetro_Cefalico"><script id="tpc_nutricion_valoracion_Perimetro_Cefalico" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Perimetro_Cefalico->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Perimetro_Cefalico->CellAttributes() ?>><span id="el_nutricion_valoracion_Perimetro_Cefalico" class="control-group">
<script id="tpx_nutricion_valoracion_Perimetro_Cefalico" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Perimetro_Cefalico" name="x_Perimetro_Cefalico" id="x_Perimetro_Cefalico" size="6" placeholder="<?php echo $nutricion_valoracion->Perimetro_Cefalico->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Perimetro_Cefalico->EditValue ?>"<?php echo $nutricion_valoracion->Perimetro_Cefalico->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Perimetro_Cefalico->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Perimetro_Abdominal->Visible) { // Perimetro_Abdominal ?>
	<tr id="r_Perimetro_Abdominal"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Perimetro_Abdominal"><script id="tpc_nutricion_valoracion_Perimetro_Abdominal" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Perimetro_Abdominal->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Perimetro_Abdominal->CellAttributes() ?>><span id="el_nutricion_valoracion_Perimetro_Abdominal" class="control-group">
<script id="tpx_nutricion_valoracion_Perimetro_Abdominal" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Perimetro_Abdominal" name="x_Perimetro_Abdominal" id="x_Perimetro_Abdominal" size="6" placeholder="<?php echo $nutricion_valoracion->Perimetro_Abdominal->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Perimetro_Abdominal->EditValue ?>"<?php echo $nutricion_valoracion->Perimetro_Abdominal->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Perimetro_Abdominal->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->IMC->Visible) { // IMC ?>
	<tr id="r_IMC"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_IMC"><script id="tpc_nutricion_valoracion_IMC" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->IMC->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->IMC->CellAttributes() ?>><span id="el_nutricion_valoracion_IMC" class="control-group">
<script id="tpx_nutricion_valoracion_IMC" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_IMC" name="x_IMC" id="x_IMC" size="4" placeholder="<?php echo $nutricion_valoracion->IMC->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->IMC->EditValue ?>"<?php echo $nutricion_valoracion->IMC->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->IMC->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_TallaEdad->Visible) { // DS_TallaEdad ?>
	<tr id="r_DS_TallaEdad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_DS_TallaEdad"><script id="tpc_nutricion_valoracion_DS_TallaEdad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->DS_TallaEdad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->DS_TallaEdad->CellAttributes() ?>><span id="el_nutricion_valoracion_DS_TallaEdad" class="control-group">
<script id="tpx_nutricion_valoracion_DS_TallaEdad" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_DS_TallaEdad" name="x_DS_TallaEdad" id="x_DS_TallaEdad" size="4" placeholder="<?php echo $nutricion_valoracion->DS_TallaEdad->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->DS_TallaEdad->EditValue ?>"<?php echo $nutricion_valoracion->DS_TallaEdad->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->DS_TallaEdad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_PesoTalla->Visible) { // DS_PesoTalla ?>
	<tr id="r_DS_PesoTalla"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_DS_PesoTalla"><script id="tpc_nutricion_valoracion_DS_PesoTalla" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->DS_PesoTalla->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->DS_PesoTalla->CellAttributes() ?>><span id="el_nutricion_valoracion_DS_PesoTalla" class="control-group">
<script id="tpx_nutricion_valoracion_DS_PesoTalla" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_DS_PesoTalla" name="x_DS_PesoTalla" id="x_DS_PesoTalla" size="4" placeholder="<?php echo $nutricion_valoracion->DS_PesoTalla->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->DS_PesoTalla->EditValue ?>"<?php echo $nutricion_valoracion->DS_PesoTalla->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->DS_PesoTalla->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_PesoEdad->Visible) { // DS_PesoEdad ?>
	<tr id="r_DS_PesoEdad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_DS_PesoEdad"><script id="tpc_nutricion_valoracion_DS_PesoEdad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->DS_PesoEdad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->DS_PesoEdad->CellAttributes() ?>><span id="el_nutricion_valoracion_DS_PesoEdad" class="control-group">
<script id="tpx_nutricion_valoracion_DS_PesoEdad" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_DS_PesoEdad" name="x_DS_PesoEdad" id="x_DS_PesoEdad" size="4" placeholder="<?php echo $nutricion_valoracion->DS_PesoEdad->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->DS_PesoEdad->EditValue ?>"<?php echo $nutricion_valoracion->DS_PesoEdad->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->DS_PesoEdad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_IMCEdad->Visible) { // DS_IMCEdad ?>
	<tr id="r_DS_IMCEdad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_DS_IMCEdad"><script id="tpc_nutricion_valoracion_DS_IMCEdad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->DS_IMCEdad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->DS_IMCEdad->CellAttributes() ?>><span id="el_nutricion_valoracion_DS_IMCEdad" class="control-group">
<script id="tpx_nutricion_valoracion_DS_IMCEdad" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_DS_IMCEdad" name="x_DS_IMCEdad" id="x_DS_IMCEdad" size="4" placeholder="<?php echo $nutricion_valoracion->DS_IMCEdad->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->DS_IMCEdad->EditValue ?>"<?php echo $nutricion_valoracion->DS_IMCEdad->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->DS_IMCEdad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->DS_PCEdad->Visible) { // DS_PCEdad ?>
	<tr id="r_DS_PCEdad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_DS_PCEdad"><script id="tpc_nutricion_valoracion_DS_PCEdad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->DS_PCEdad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->DS_PCEdad->CellAttributes() ?>><span id="el_nutricion_valoracion_DS_PCEdad" class="control-group">
<script id="tpx_nutricion_valoracion_DS_PCEdad" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_DS_PCEdad" name="x_DS_PCEdad" id="x_DS_PCEdad" size="4" placeholder="<?php echo $nutricion_valoracion->DS_PCEdad->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->DS_PCEdad->EditValue ?>"<?php echo $nutricion_valoracion->DS_PCEdad->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->DS_PCEdad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_Talla_Edad->Visible) { // Clasificacion_Talla_Edad ?>
	<tr id="r_Clasificacion_Talla_Edad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Clasificacion_Talla_Edad"><script id="tpc_nutricion_valoracion_Clasificacion_Talla_Edad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->CellAttributes() ?>><span id="el_nutricion_valoracion_Clasificacion_Talla_Edad" class="control-group">
<script id="tpx_nutricion_valoracion_Clasificacion_Talla_Edad" class="nutricion_valoracionedit" type="text/html">
<select class="x_Clasificacion_Talla_Edad" id="x_Clasificacion_Talla_Edad" name="x_Clasificacion_Talla_Edad"<?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Clasificacion_Talla_Edad->EditValue)) {
	$arwrk = $nutricion_valoracion->Clasificacion_Talla_Edad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Clasificacion_Talla_Edad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Clasificacion_Talla_Edad"].Options = <?php echo (is_array($nutricion_valoracion->Clasificacion_Talla_Edad->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Clasificacion_Talla_Edad->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_Peso_Talla->Visible) { // Clasificacion_Peso_Talla ?>
	<tr id="r_Clasificacion_Peso_Talla"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Clasificacion_Peso_Talla"><script id="tpc_nutricion_valoracion_Clasificacion_Peso_Talla" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->CellAttributes() ?>><span id="el_nutricion_valoracion_Clasificacion_Peso_Talla" class="control-group">
<script id="tpx_nutricion_valoracion_Clasificacion_Peso_Talla" class="nutricion_valoracionedit" type="text/html">
<select class="x_Clasificacion_Peso_Talla" id="x_Clasificacion_Peso_Talla" name="x_Clasificacion_Peso_Talla"<?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Clasificacion_Peso_Talla->EditValue)) {
	$arwrk = $nutricion_valoracion->Clasificacion_Peso_Talla->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Clasificacion_Peso_Talla->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Clasificacion_Peso_Talla"].Options = <?php echo (is_array($nutricion_valoracion->Clasificacion_Peso_Talla->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Clasificacion_Peso_Talla->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_Peso_Edad->Visible) { // Clasificacion_Peso_Edad ?>
	<tr id="r_Clasificacion_Peso_Edad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Clasificacion_Peso_Edad"><script id="tpc_nutricion_valoracion_Clasificacion_Peso_Edad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->CellAttributes() ?>><span id="el_nutricion_valoracion_Clasificacion_Peso_Edad" class="control-group">
<script id="tpx_nutricion_valoracion_Clasificacion_Peso_Edad" class="nutricion_valoracionedit" type="text/html">
<select class="x_Clasificacion_Peso_Edad" id="x_Clasificacion_Peso_Edad" name="x_Clasificacion_Peso_Edad"<?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Clasificacion_Peso_Edad->EditValue)) {
	$arwrk = $nutricion_valoracion->Clasificacion_Peso_Edad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Clasificacion_Peso_Edad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Clasificacion_Peso_Edad"].Options = <?php echo (is_array($nutricion_valoracion->Clasificacion_Peso_Edad->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Clasificacion_Peso_Edad->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_IMC_Edad->Visible) { // Clasificacion_IMC_Edad ?>
	<tr id="r_Clasificacion_IMC_Edad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Clasificacion_IMC_Edad"><script id="tpc_nutricion_valoracion_Clasificacion_IMC_Edad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->CellAttributes() ?>><span id="el_nutricion_valoracion_Clasificacion_IMC_Edad" class="control-group">
<script id="tpx_nutricion_valoracion_Clasificacion_IMC_Edad" class="nutricion_valoracionedit" type="text/html">
<select class="x_Clasificacion_IMC_Edad" id="x_Clasificacion_IMC_Edad" name="x_Clasificacion_IMC_Edad"<?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Clasificacion_IMC_Edad->EditValue)) {
	$arwrk = $nutricion_valoracion->Clasificacion_IMC_Edad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Clasificacion_IMC_Edad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Clasificacion_IMC_Edad"].Options = <?php echo (is_array($nutricion_valoracion->Clasificacion_IMC_Edad->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Clasificacion_IMC_Edad->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificacion_P_Cefalico->Visible) { // Clasificacion_P_Cefalico ?>
	<tr id="r_Clasificacion_P_Cefalico"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Clasificacion_P_Cefalico"><script id="tpc_nutricion_valoracion_Clasificacion_P_Cefalico" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->CellAttributes() ?>><span id="el_nutricion_valoracion_Clasificacion_P_Cefalico" class="control-group">
<script id="tpx_nutricion_valoracion_Clasificacion_P_Cefalico" class="nutricion_valoracionedit" type="text/html">
<select class="x_Clasificacion_P_Cefalico" id="x_Clasificacion_P_Cefalico" name="x_Clasificacion_P_Cefalico"<?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Clasificacion_P_Cefalico->EditValue)) {
	$arwrk = $nutricion_valoracion->Clasificacion_P_Cefalico->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Clasificacion_P_Cefalico->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Clasificacion_P_Cefalico"].Options = <?php echo (is_array($nutricion_valoracion->Clasificacion_P_Cefalico->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Clasificacion_P_Cefalico->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Superficie_Corporal->Visible) { // Superficie_Corporal ?>
	<tr id="r_Superficie_Corporal"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Superficie_Corporal"><script id="tpc_nutricion_valoracion_Superficie_Corporal" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Superficie_Corporal->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Superficie_Corporal->CellAttributes() ?>><span id="el_nutricion_valoracion_Superficie_Corporal" class="control-group">
<script id="tpx_nutricion_valoracion_Superficie_Corporal" class="nutricion_valoracionedit" type="text/html">
<input type="text" class="x_Superficie_Corporal" name="x_Superficie_Corporal" id="x_Superficie_Corporal" size="4" placeholder="<?php echo $nutricion_valoracion->Superficie_Corporal->PlaceHolder ?>" value="<?php echo $nutricion_valoracion->Superficie_Corporal->EditValue ?>"<?php echo $nutricion_valoracion->Superficie_Corporal->EditAttributes() ?>>
</script>
</span><?php echo $nutricion_valoracion->Superficie_Corporal->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Zona->Visible) { // Zona ?>
	<tr id="r_Zona"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Zona"><script id="tpc_nutricion_valoracion_Zona" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Zona->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Zona->CellAttributes() ?>><span id="el_nutricion_valoracion_Zona" class="control-group">
<script id="tpx_nutricion_valoracion_Zona" class="nutricion_valoracionedit" type="text/html">
<?php $nutricion_valoracion->Zona->EditAttrs["onchange"] = "ew_UpdateOpt.call(this, ['x_Barrio_Vereda']); " . @$nutricion_valoracion->Zona->EditAttrs["onchange"]; ?>
<select class="x_Zona" id="x_Zona" name="x_Zona"<?php echo $nutricion_valoracion->Zona->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Zona->EditValue)) {
	$arwrk = $nutricion_valoracion->Zona->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Zona->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Zona"].Options = <?php echo (is_array($nutricion_valoracion->Zona->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Zona->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Zona->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Barrio_Vereda->Visible) { // Barrio_Vereda ?>
	<tr id="r_Barrio_Vereda"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Barrio_Vereda"><script id="tpc_nutricion_valoracion_Barrio_Vereda" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Barrio_Vereda->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Barrio_Vereda->CellAttributes() ?>><span id="el_nutricion_valoracion_Barrio_Vereda" class="control-group">
<script id="tpx_nutricion_valoracion_Barrio_Vereda" class="nutricion_valoracionedit" type="text/html">
<?php $nutricion_valoracion->Barrio_Vereda->EditAttrs["onchange"] = "ew_AutoFill(this); " . @$nutricion_valoracion->Barrio_Vereda->EditAttrs["onchange"]; ?>
<select class="x_Barrio_Vereda" id="x_Barrio_Vereda" name="x_Barrio_Vereda"<?php echo $nutricion_valoracion->Barrio_Vereda->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Barrio_Vereda->EditValue)) {
	$arwrk = $nutricion_valoracion->Barrio_Vereda->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Barrio_Vereda->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `Localidad` AS FIELD0 FROM `barrio_vereda`";
$sWhereWrk = "(`consecutivo` = {query_value})";

// Call Lookup selecting
$nutricion_valoracion->Lookup_Selecting($nutricion_valoracion->Barrio_Vereda, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY `Barrio_Vereda`";
$sSqlWrk = ew_Encrypt($sSqlWrk);
?>
<input type="hidden" name="sf_x_Barrio_Vereda" id="sf_x_Barrio_Vereda" value="<?php echo $sSqlWrk ?>">
<input type="hidden" name="ln_x_Barrio_Vereda" id="ln_x_Barrio_Vereda" value="x_Comuna_Zona">
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Barrio_Vereda"].Options = <?php echo (is_array($nutricion_valoracion->Barrio_Vereda->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Barrio_Vereda->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Barrio_Vereda->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Comuna_Zona->Visible) { // Comuna_Zona ?>
	<tr id="r_Comuna_Zona"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Comuna_Zona"><script id="tpc_nutricion_valoracion_Comuna_Zona" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Comuna_Zona->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Comuna_Zona->CellAttributes() ?>><span id="el_nutricion_valoracion_Comuna_Zona" class="control-group">
<script id="tpx_nutricion_valoracion_Comuna_Zona" class="nutricion_valoracionedit" type="text/html">
<?php
	$wrkonchange = trim(" " . @$nutricion_valoracion->Comuna_Zona->EditAttrs["onchange"]);
	if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
	$nutricion_valoracion->Comuna_Zona->EditAttrs["onchange"] = "";
?>
<span id="as_x_Comuna_Zona" style="white-space: nowrap; z-index: 8690">
	<input type="text" name="sv_x_Comuna_Zona" id="sv_x_Comuna_Zona" value="<?php echo $nutricion_valoracion->Comuna_Zona->EditValue ?>" size="10" placeholder="<?php echo $nutricion_valoracion->Comuna_Zona->PlaceHolder ?>"<?php echo $nutricion_valoracion->Comuna_Zona->EditAttributes() ?>>&nbsp;<span id="em_x_Comuna_Zona" class="ewMessage" style="display: none"><?php echo str_replace("%f", "phpimages/", $Language->Phrase("UnmatchedValue")) ?></span>
	<div id="sc_x_Comuna_Zona" style="display: inline; z-index: 8690"></div>
</span>
<input type="hidden" class="x_Comuna_Zona" name="x_Comuna_Zona" id="x_Comuna_Zona" value="<?php echo $nutricion_valoracion->Comuna_Zona->CurrentValue ?>"<?php echo $wrkonchange ?>>
<?php
$sSqlWrk = "SELECT `consecutivo`, `Localidad_Comuna` AS `DispFld` FROM `comuna_localidad`";
$sWhereWrk = "`Localidad_Comuna` LIKE '%{query_value}%'";

// Call Lookup selecting
$nutricion_valoracion->Lookup_Selecting($nutricion_valoracion->Comuna_Zona, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY `Localidad_Comuna`";
$sSqlWrk .= " LIMIT " . EW_AUTO_SUGGEST_MAX_ENTRIES;
?>
<input type="hidden" name="q_x_Comuna_Zona" id="q_x_Comuna_Zona" value="s=<?php echo ew_Encrypt($sSqlWrk) ?>">
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
var oas = new ew_AutoSuggest("x_Comuna_Zona", fnutricion_valoracionedit, false, EW_AUTO_SUGGEST_MAX_ENTRIES);
oas.formatResult = function(ar) {
	var dv = ar[1];
	for (var i = 2; i <= 4; i++)
		dv += (ar[i]) ? ew_ValueSeparator(i - 1, "x_Comuna_Zona") + ar[i] : "";
	return dv;
}
fnutricion_valoracionedit.AutoSuggests["x_Comuna_Zona"] = oas;
</script>
</span><?php echo $nutricion_valoracion->Comuna_Zona->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Grupo_Etnico->Visible) { // Grupo_Etnico ?>
	<tr id="r_Grupo_Etnico"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Grupo_Etnico"><script id="tpc_nutricion_valoracion_Grupo_Etnico" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Grupo_Etnico->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Grupo_Etnico->CellAttributes() ?>><span id="el_nutricion_valoracion_Grupo_Etnico" class="control-group">
<script id="tpx_nutricion_valoracion_Grupo_Etnico" class="nutricion_valoracionedit" type="text/html">
<select class="x_Grupo_Etnico" id="x_Grupo_Etnico" name="x_Grupo_Etnico"<?php echo $nutricion_valoracion->Grupo_Etnico->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Grupo_Etnico->EditValue)) {
	$arwrk = $nutricion_valoracion->Grupo_Etnico->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Grupo_Etnico->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Grupo_Etnico"].Options = <?php echo (is_array($nutricion_valoracion->Grupo_Etnico->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Grupo_Etnico->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Grupo_Etnico->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Tipo_Regimen->Visible) { // Tipo_Regimen ?>
	<tr id="r_Tipo_Regimen"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Tipo_Regimen"><script id="tpc_nutricion_valoracion_Tipo_Regimen" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Tipo_Regimen->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Tipo_Regimen->CellAttributes() ?>><span id="el_nutricion_valoracion_Tipo_Regimen" class="control-group">
<script id="tpx_nutricion_valoracion_Tipo_Regimen" class="nutricion_valoracionedit" type="text/html">
<select class="x_Tipo_Regimen" id="x_Tipo_Regimen" name="x_Tipo_Regimen"<?php echo $nutricion_valoracion->Tipo_Regimen->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Tipo_Regimen->EditValue)) {
	$arwrk = $nutricion_valoracion->Tipo_Regimen->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Tipo_Regimen->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Tipo_Regimen"].Options = <?php echo (is_array($nutricion_valoracion->Tipo_Regimen->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Tipo_Regimen->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Tipo_Regimen->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->EPS->Visible) { // EPS ?>
	<tr id="r_EPS"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_EPS"><script id="tpc_nutricion_valoracion_EPS" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->EPS->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->EPS->CellAttributes() ?>><span id="el_nutricion_valoracion_EPS" class="control-group">
<script id="tpx_nutricion_valoracion_EPS" class="nutricion_valoracionedit" type="text/html">
<?php
	$wrkonchange = trim(" " . @$nutricion_valoracion->EPS->EditAttrs["onchange"]);
	if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
	$nutricion_valoracion->EPS->EditAttrs["onchange"] = "";
?>
<span id="as_x_EPS" style="white-space: nowrap; z-index: 8660">
	<input type="text" name="sv_x_EPS" id="sv_x_EPS" value="<?php echo $nutricion_valoracion->EPS->EditValue ?>" size="30" maxlength="10" placeholder="<?php echo $nutricion_valoracion->EPS->PlaceHolder ?>"<?php echo $nutricion_valoracion->EPS->EditAttributes() ?>>&nbsp;<span id="em_x_EPS" class="ewMessage" style="display: none"><?php echo str_replace("%f", "phpimages/", $Language->Phrase("UnmatchedValue")) ?></span>
	<div id="sc_x_EPS" style="display: inline; z-index: 8660"></div>
</span>
<input type="hidden" class="x_EPS" name="x_EPS" id="x_EPS" value="<?php echo $nutricion_valoracion->EPS->CurrentValue ?>"<?php echo $wrkonchange ?>>
<?php
$sSqlWrk = "SELECT `Codigo`, `Administradora_Salud` AS `DispFld` FROM `administradora_salud`";
$sWhereWrk = "`Administradora_Salud` LIKE '%{query_value}%'";

// Call Lookup selecting
$nutricion_valoracion->Lookup_Selecting($nutricion_valoracion->EPS, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY `Administradora_Salud`";
$sSqlWrk .= " LIMIT " . EW_AUTO_SUGGEST_MAX_ENTRIES;
?>
<input type="hidden" name="q_x_EPS" id="q_x_EPS" value="s=<?php echo ew_Encrypt($sSqlWrk) ?>">
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
var oas = new ew_AutoSuggest("x_EPS", fnutricion_valoracionedit, false, EW_AUTO_SUGGEST_MAX_ENTRIES);
oas.formatResult = function(ar) {
	var dv = ar[1];
	for (var i = 2; i <= 4; i++)
		dv += (ar[i]) ? ew_ValueSeparator(i - 1, "x_EPS") + ar[i] : "";
	return dv;
}
fnutricion_valoracionedit.AutoSuggests["x_EPS"] = oas;
</script>
</span><?php echo $nutricion_valoracion->EPS->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Condicion_Discapacidad->Visible) { // Condicion_Discapacidad ?>
	<tr id="r_Condicion_Discapacidad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Condicion_Discapacidad"><script id="tpc_nutricion_valoracion_Condicion_Discapacidad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Condicion_Discapacidad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Condicion_Discapacidad->CellAttributes() ?>><span id="el_nutricion_valoracion_Condicion_Discapacidad" class="control-group">
<script id="tpx_nutricion_valoracion_Condicion_Discapacidad" class="nutricion_valoracionedit" type="text/html">
<select class="x_Condicion_Discapacidad" id="x_Condicion_Discapacidad" name="x_Condicion_Discapacidad"<?php echo $nutricion_valoracion->Condicion_Discapacidad->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Condicion_Discapacidad->EditValue)) {
	$arwrk = $nutricion_valoracion->Condicion_Discapacidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Condicion_Discapacidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Condicion_Discapacidad"].Options = <?php echo (is_array($nutricion_valoracion->Condicion_Discapacidad->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Condicion_Discapacidad->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Condicion_Discapacidad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Condicion_Desplazamiento->Visible) { // Condicion_Desplazamiento ?>
	<tr id="r_Condicion_Desplazamiento"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Condicion_Desplazamiento"><script id="tpc_nutricion_valoracion_Condicion_Desplazamiento" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Condicion_Desplazamiento->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Condicion_Desplazamiento->CellAttributes() ?>><span id="el_nutricion_valoracion_Condicion_Desplazamiento" class="control-group">
<script id="tpx_nutricion_valoracion_Condicion_Desplazamiento" class="nutricion_valoracionedit" type="text/html">
<select class="x_Condicion_Desplazamiento" id="x_Condicion_Desplazamiento" name="x_Condicion_Desplazamiento"<?php echo $nutricion_valoracion->Condicion_Desplazamiento->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Condicion_Desplazamiento->EditValue)) {
	$arwrk = $nutricion_valoracion->Condicion_Desplazamiento->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Condicion_Desplazamiento->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
</span><?php echo $nutricion_valoracion->Condicion_Desplazamiento->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Entidad_Educativa->Visible) { // Entidad_Educativa ?>
	<tr id="r_Entidad_Educativa"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Entidad_Educativa"><script id="tpc_nutricion_valoracion_Entidad_Educativa" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Entidad_Educativa->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Entidad_Educativa->CellAttributes() ?>><span id="el_nutricion_valoracion_Entidad_Educativa" class="control-group">
<script id="tpx_nutricion_valoracion_Entidad_Educativa" class="nutricion_valoracionedit" type="text/html">
<select class="x_Entidad_Educativa" id="x_Entidad_Educativa" name="x_Entidad_Educativa"<?php echo $nutricion_valoracion->Entidad_Educativa->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Entidad_Educativa->EditValue)) {
	$arwrk = $nutricion_valoracion->Entidad_Educativa->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Entidad_Educativa->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Entidad_Educativa"].Options = <?php echo (is_array($nutricion_valoracion->Entidad_Educativa->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Entidad_Educativa->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Entidad_Educativa->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Escolaridad->Visible) { // Escolaridad ?>
	<tr id="r_Escolaridad"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Escolaridad"><script id="tpc_nutricion_valoracion_Escolaridad" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Escolaridad->FldCaption() ?></span></script></span></td>
		<td<?php echo $nutricion_valoracion->Escolaridad->CellAttributes() ?>><span id="el_nutricion_valoracion_Escolaridad" class="control-group">
<script id="tpx_nutricion_valoracion_Escolaridad" class="nutricion_valoracionedit" type="text/html">
<select class="x_Escolaridad" id="x_Escolaridad" name="x_Escolaridad"<?php echo $nutricion_valoracion->Escolaridad->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Escolaridad->EditValue)) {
	$arwrk = $nutricion_valoracion->Escolaridad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Escolaridad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
<script type="text/html" class="nutricion_valoracionedit_js">
fnutricion_valoracionedit.Lists["x_Escolaridad"].Options = <?php echo (is_array($nutricion_valoracion->Escolaridad->EditValue)) ? ew_ArrayToJson($nutricion_valoracion->Escolaridad->EditValue, 1) : "[]" ?>;
</script>
</span><?php echo $nutricion_valoracion->Escolaridad->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($nutricion_valoracion->Clasificado->Visible) { // Clasificado ?>
	<tr id="r_Clasificado"<?php echo $nutricion_valoracion->RowAttributes() ?>>
		<td><span id="elh_nutricion_valoracion_Clasificado"><script id="tpc_nutricion_valoracion_Clasificado" class="nutricion_valoracionedit" type="text/html"><span><?php echo $nutricion_valoracion->Clasificado->FldCaption() ?></span></script><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $nutricion_valoracion->Clasificado->CellAttributes() ?>><span id="el_nutricion_valoracion_Clasificado" class="control-group">
<script id="tpx_nutricion_valoracion_Clasificado" class="nutricion_valoracionedit" type="text/html">
<select class="x_Clasificado" id="x_Clasificado" name="x_Clasificado"<?php echo $nutricion_valoracion->Clasificado->EditAttributes() ?>>
<?php
if (is_array($nutricion_valoracion->Clasificado->EditValue)) {
	$arwrk = $nutricion_valoracion->Clasificado->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($nutricion_valoracion->Clasificado->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
</script>
</span><?php echo $nutricion_valoracion->Clasificado->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<input type="hidden" class="x_Consecutivo" name="x_Consecutivo" id="x_Consecutivo" value="<?php echo ew_HtmlEncode($nutricion_valoracion->Consecutivo->CurrentValue) ?>">
<div id="tpd_nutricion_valoracionedit"></div>
<script id="tpm_nutricion_valoracionedit" type="text/html">
<span id="ct_nutricion_valoracion_edit"><table class="table table-bordered table-striped">
<tbody>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">DATOS
PERSONALES</span> </td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->Tipo_Documento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Documento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Nombres->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Apellidos->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Genero->FldCaption() ?></td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Tipo_Documento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Documento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Nombres"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Apellidos"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Genero"/}}</td>
</tr>
<tr>
<td colspan="2"> <?php echo $nutricion_valoracion->Fecha_valoracion->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Fecha_Nacimiento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Edad_Anos->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Edad_Meses->FldCaption() ?></td>
</tr>
<tr>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Fecha_valoracion"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Fecha_Nacimiento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Edad_Anos"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Edad_Meses"/}}</td> 
</tr>
<tr>
<td colspan="1" rowspan="1"><?php echo $nutricion_valoracion->Entidad_Educativa->FldCaption() ?></td>
<td colspan="1" rowspan="1"><?php echo $nutricion_valoracion->Escolaridad->FldCaption() ?></td>
<td style="vertical-align: top;"><?php echo $nutricion_valoracion->Grupo_Etnico->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Condicion_Desplazamiento->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->Condicion_Discapacidad->FldCaption() ?></td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Entidad_Educativa"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Escolaridad"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Grupo_Etnico"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Condicion_Desplazamiento"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Condicion_Discapacidad"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->Tipo_Regimen->FldCaption() ?></td>
<td colspan="4" rowspan="1"><?php echo $nutricion_valoracion->EPS->FldCaption() ?></td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Tipo_Regimen"/}}</td>
<td colspan="4">{{include tmpl="#tpx_nutricion_valoracion_EPS"/}}</td>
</tr>
<tr>
<td colspan="1" rowspan="1"><?php echo $nutricion_valoracion->Zona->FldCaption() ?></td>
<td colspan="2"><?php echo $nutricion_valoracion->Barrio_Vereda->FldCaption() ?></td>
<td colspan="2"><?php echo $nutricion_valoracion->Comuna_Zona->FldCaption() ?></td>
</tr>
<tr>
<td colspan="1">{{include tmpl="#tpx_nutricion_valoracion_Zona"/}}</td>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Barrio_Vereda"/}}</td>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Comuna_Zona"/}}</td>
</tr>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">MEDICION</span>
</td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->Peso->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->Talla->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->Perimetro_Cefalico->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->Perimetro_Abdominal->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->IMC->FldCaption() ?>&nbsp;{{include tmpl="#tpx_nutricion_valoracion_IMC"/}} </td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_Peso"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Talla"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Perimetro_Cefalico"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Perimetro_Abdominal"/}}</td>
<td><?php echo $nutricion_valoracion->Superficie_Corporal->FldCaption() ?>&nbsp;{{include tmpl="#tpx_nutricion_valoracion_Superficie_Corporal"/}}</td>
</tr>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">VALORACION&nbsp;</span>
<a href="crecimiento.php" id="dialog-link"
class="btn btn-primary ewButton" onclick="OpenPop_Up();return false;">Calcular
Desviaciones</a> </td>
</tr>
<tr>
<td colspan="3"><?php echo $nutricion_valoracion->Entidad_Valora->FldCaption() ?></td>
<td colspan="2"><?php echo $nutricion_valoracion->Tipo_Entidad->FldCaption() ?></td>
</tr>
<tr>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Entidad_Valora"/}}</td>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Tipo_Entidad"/}}</td>
</tr>
<tr>
<td><?php echo $nutricion_valoracion->DS_TallaEdad->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->DS_PesoTalla->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->DS_PesoEdad->FldCaption() ?></td>
<td><?php echo $nutricion_valoracion->DS_IMCEdad->FldCaption() ?> </td>
<td><?php echo $nutricion_valoracion->DS_PCEdad->FldCaption() ?>
</td>
</tr>
<tr>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_TallaEdad"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_PesoTalla"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_PesoEdad"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_IMCEdad"/}}</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_DS_PCEdad"/}}
</td>
</tr>
<tr align="center">
<td colspan="5" rowspan="1"><span style="font-weight: bold;">CLASIFICACION&nbsp;</span>
</td>
</tr>
<tr>
<td>Clasificar
</td>
<td>{{include tmpl="#tpx_nutricion_valoracion_Clasificado"/}}</td>
<td colspan="3">
<br>
</td>
</tr>
<tr>
<td colspan="2"><?php echo $nutricion_valoracion->Clasificacion_Talla_Edad->FldCaption() ?></td>
<td colspan="3"><?php echo $nutricion_valoracion->Clasificacion_Peso_Talla->FldCaption() ?></td>
</tr>
<tr>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_Talla_Edad"/}}</td>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_Peso_Talla"/}}</td>
</tr>         
<tr>
<td colspan="2"><?php echo $nutricion_valoracion->Clasificacion_Peso_Edad->FldCaption() ?></td>
<td colspan="3"><?php echo $nutricion_valoracion->Clasificacion_IMC_Edad->FldCaption() ?>
</td>
</tr>
<tr>
<td colspan="2">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_Peso_Edad"/}}</td>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_IMC_Edad"/}}</td>
</tr>
<tr>
<td colspan="2"><?php echo $nutricion_valoracion->Clasificacion_P_Cefalico->FldCaption() ?></td>
<td colspan="3">{{include tmpl="#tpx_nutricion_valoracion_Clasificacion_P_Cefalico"/}}
</td>
</tr>
</tbody>              
</span>
</script>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("EditBtn") ?></button>
</form>
<script type="text/javascript">
ew_ApplyTemplate("tpd_nutricion_valoracionedit", "tpm_nutricion_valoracionedit");
jQuery("script.nutricion_valoracionedit_js").each(function(){ew_AddScript(this.text);});
</script>
<script type="text/javascript">
fnutricion_valoracionedit.Init();
</script>
<?php
$nutricion_valoracion_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$nutricion_valoracion_edit->Page_Terminate();
?>
