<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "licenciasinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$licencias_list = NULL; // Initialize page object first

class clicencias_list extends clicencias {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{4856FC11-2251-4398-A775-007AE159DC48}";

	// Table name
	var $TableName = 'licencias';

	// Page object name
	var $PageObjName = 'licencias_list';

	// Grid form hidden field names
	var $FormName = 'flicenciaslist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (licencias)
		if (!isset($GLOBALS["licencias"]) || get_class($GLOBALS["licencias"]) == "clicencias") {
			$GLOBALS["licencias"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["licencias"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "licenciasadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "licenciasdelete.php";
		$this->MultiUpdateUrl = "licenciasupdate.php";

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'licencias', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption flicenciaslistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// Get export parameters
		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->Id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();
		$this->Registrado_por->Visible = !$this->IsAddOrEdit();
		$this->Fecha_registro->Visible = !$this->IsAddOrEdit();
		$this->fecha_edicion->Visible = !$this->IsAddOrEdit();
		$this->usuario_edita->Visible = !$this->IsAddOrEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $licencias;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($licencias);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Restore filter list
			$this->RestoreFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->Id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->Id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Id->AdvancedSearch->ToJSON(), ","); // Field Id
		$sFilterList = ew_Concat($sFilterList, $this->Entidad->AdvancedSearch->ToJSON(), ","); // Field Entidad
		$sFilterList = ew_Concat($sFilterList, $this->Logo->AdvancedSearch->ToJSON(), ","); // Field Logo
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_expedicion->AdvancedSearch->ToJSON(), ","); // Field Fecha_expedicion
		$sFilterList = ew_Concat($sFilterList, $this->Dpto_expedicion->AdvancedSearch->ToJSON(), ","); // Field Dpto_expedicion
		$sFilterList = ew_Concat($sFilterList, $this->Mun_expedicion->AdvancedSearch->ToJSON(), ","); // Field Mun_expedicion
		$sFilterList = ew_Concat($sFilterList, $this->tipo_muerte->AdvancedSearch->ToJSON(), ","); // Field tipo_muerte
		$sFilterList = ew_Concat($sFilterList, $this->Documento->AdvancedSearch->ToJSON(), ","); // Field Documento
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_doc->AdvancedSearch->ToJSON(), ","); // Field Tipo_doc
		$sFilterList = ew_Concat($sFilterList, $this->Nombres->AdvancedSearch->ToJSON(), ","); // Field Nombres
		$sFilterList = ew_Concat($sFilterList, $this->Apellidos->AdvancedSearch->ToJSON(), ","); // Field Apellidos
		$sFilterList = ew_Concat($sFilterList, $this->Genero->AdvancedSearch->ToJSON(), ","); // Field Genero
		$sFilterList = ew_Concat($sFilterList, $this->No_certificado->AdvancedSearch->ToJSON(), ","); // Field No_certificado
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_Fallecimiento->AdvancedSearch->ToJSON(), ","); // Field Fecha_Fallecimiento
		$sFilterList = ew_Concat($sFilterList, $this->p_manera_muerte->AdvancedSearch->ToJSON(), ","); // Field p_manera_muerte
		$sFilterList = ew_Concat($sFilterList, $this->Edad->AdvancedSearch->ToJSON(), ","); // Field Edad
		$sFilterList = ew_Concat($sFilterList, $this->Tipo_edad->AdvancedSearch->ToJSON(), ","); // Field Tipo_edad
		$sFilterList = ew_Concat($sFilterList, $this->Nombre_solicitante->AdvancedSearch->ToJSON(), ","); // Field Nombre_solicitante
		$sFilterList = ew_Concat($sFilterList, $this->Funcionario_expide->AdvancedSearch->ToJSON(), ","); // Field Funcionario_expide
		$sFilterList = ew_Concat($sFilterList, $this->Permiso_inhumar->AdvancedSearch->ToJSON(), ","); // Field Permiso_inhumar
		$sFilterList = ew_Concat($sFilterList, $this->Permiso_cremar->AdvancedSearch->ToJSON(), ","); // Field Permiso_cremar
		$sFilterList = ew_Concat($sFilterList, $this->Firma_funcionario->AdvancedSearch->ToJSON(), ","); // Field Firma_funcionario
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_qr->AdvancedSearch->ToJSON(), ","); // Field Codigo_qr
		$sFilterList = ew_Concat($sFilterList, $this->Verificacion_codigo_qr->AdvancedSearch->ToJSON(), ","); // Field Verificacion_codigo_qr
		$sFilterList = ew_Concat($sFilterList, $this->Registrado_por->AdvancedSearch->ToJSON(), ","); // Field Registrado_por
		$sFilterList = ew_Concat($sFilterList, $this->Fecha_registro->AdvancedSearch->ToJSON(), ","); // Field Fecha_registro
		$sFilterList = ew_Concat($sFilterList, $this->estado_licencia->AdvancedSearch->ToJSON(), ","); // Field estado_licencia
		$sFilterList = ew_Concat($sFilterList, $this->Entidad_dirige_licencia->AdvancedSearch->ToJSON(), ","); // Field Entidad_dirige_licencia
		$sFilterList = ew_Concat($sFilterList, $this->observaciones->AdvancedSearch->ToJSON(), ","); // Field observaciones
		$sFilterList = ew_Concat($sFilterList, $this->fecha_edicion->AdvancedSearch->ToJSON(), ","); // Field fecha_edicion
		$sFilterList = ew_Concat($sFilterList, $this->usuario_edita->AdvancedSearch->ToJSON(), ","); // Field usuario_edita
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Id
		$this->Id->AdvancedSearch->SearchValue = @$filter["x_Id"];
		$this->Id->AdvancedSearch->SearchOperator = @$filter["z_Id"];
		$this->Id->AdvancedSearch->SearchCondition = @$filter["v_Id"];
		$this->Id->AdvancedSearch->SearchValue2 = @$filter["y_Id"];
		$this->Id->AdvancedSearch->SearchOperator2 = @$filter["w_Id"];
		$this->Id->AdvancedSearch->Save();

		// Field Entidad
		$this->Entidad->AdvancedSearch->SearchValue = @$filter["x_Entidad"];
		$this->Entidad->AdvancedSearch->SearchOperator = @$filter["z_Entidad"];
		$this->Entidad->AdvancedSearch->SearchCondition = @$filter["v_Entidad"];
		$this->Entidad->AdvancedSearch->SearchValue2 = @$filter["y_Entidad"];
		$this->Entidad->AdvancedSearch->SearchOperator2 = @$filter["w_Entidad"];
		$this->Entidad->AdvancedSearch->Save();

		// Field Logo
		$this->Logo->AdvancedSearch->SearchValue = @$filter["x_Logo"];
		$this->Logo->AdvancedSearch->SearchOperator = @$filter["z_Logo"];
		$this->Logo->AdvancedSearch->SearchCondition = @$filter["v_Logo"];
		$this->Logo->AdvancedSearch->SearchValue2 = @$filter["y_Logo"];
		$this->Logo->AdvancedSearch->SearchOperator2 = @$filter["w_Logo"];
		$this->Logo->AdvancedSearch->Save();

		// Field Fecha_expedicion
		$this->Fecha_expedicion->AdvancedSearch->SearchValue = @$filter["x_Fecha_expedicion"];
		$this->Fecha_expedicion->AdvancedSearch->SearchOperator = @$filter["z_Fecha_expedicion"];
		$this->Fecha_expedicion->AdvancedSearch->SearchCondition = @$filter["v_Fecha_expedicion"];
		$this->Fecha_expedicion->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_expedicion"];
		$this->Fecha_expedicion->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_expedicion"];
		$this->Fecha_expedicion->AdvancedSearch->Save();

		// Field Dpto_expedicion
		$this->Dpto_expedicion->AdvancedSearch->SearchValue = @$filter["x_Dpto_expedicion"];
		$this->Dpto_expedicion->AdvancedSearch->SearchOperator = @$filter["z_Dpto_expedicion"];
		$this->Dpto_expedicion->AdvancedSearch->SearchCondition = @$filter["v_Dpto_expedicion"];
		$this->Dpto_expedicion->AdvancedSearch->SearchValue2 = @$filter["y_Dpto_expedicion"];
		$this->Dpto_expedicion->AdvancedSearch->SearchOperator2 = @$filter["w_Dpto_expedicion"];
		$this->Dpto_expedicion->AdvancedSearch->Save();

		// Field Mun_expedicion
		$this->Mun_expedicion->AdvancedSearch->SearchValue = @$filter["x_Mun_expedicion"];
		$this->Mun_expedicion->AdvancedSearch->SearchOperator = @$filter["z_Mun_expedicion"];
		$this->Mun_expedicion->AdvancedSearch->SearchCondition = @$filter["v_Mun_expedicion"];
		$this->Mun_expedicion->AdvancedSearch->SearchValue2 = @$filter["y_Mun_expedicion"];
		$this->Mun_expedicion->AdvancedSearch->SearchOperator2 = @$filter["w_Mun_expedicion"];
		$this->Mun_expedicion->AdvancedSearch->Save();

		// Field tipo_muerte
		$this->tipo_muerte->AdvancedSearch->SearchValue = @$filter["x_tipo_muerte"];
		$this->tipo_muerte->AdvancedSearch->SearchOperator = @$filter["z_tipo_muerte"];
		$this->tipo_muerte->AdvancedSearch->SearchCondition = @$filter["v_tipo_muerte"];
		$this->tipo_muerte->AdvancedSearch->SearchValue2 = @$filter["y_tipo_muerte"];
		$this->tipo_muerte->AdvancedSearch->SearchOperator2 = @$filter["w_tipo_muerte"];
		$this->tipo_muerte->AdvancedSearch->Save();

		// Field Documento
		$this->Documento->AdvancedSearch->SearchValue = @$filter["x_Documento"];
		$this->Documento->AdvancedSearch->SearchOperator = @$filter["z_Documento"];
		$this->Documento->AdvancedSearch->SearchCondition = @$filter["v_Documento"];
		$this->Documento->AdvancedSearch->SearchValue2 = @$filter["y_Documento"];
		$this->Documento->AdvancedSearch->SearchOperator2 = @$filter["w_Documento"];
		$this->Documento->AdvancedSearch->Save();

		// Field Tipo_doc
		$this->Tipo_doc->AdvancedSearch->SearchValue = @$filter["x_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchOperator = @$filter["z_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchCondition = @$filter["v_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_doc"];
		$this->Tipo_doc->AdvancedSearch->Save();

		// Field Nombres
		$this->Nombres->AdvancedSearch->SearchValue = @$filter["x_Nombres"];
		$this->Nombres->AdvancedSearch->SearchOperator = @$filter["z_Nombres"];
		$this->Nombres->AdvancedSearch->SearchCondition = @$filter["v_Nombres"];
		$this->Nombres->AdvancedSearch->SearchValue2 = @$filter["y_Nombres"];
		$this->Nombres->AdvancedSearch->SearchOperator2 = @$filter["w_Nombres"];
		$this->Nombres->AdvancedSearch->Save();

		// Field Apellidos
		$this->Apellidos->AdvancedSearch->SearchValue = @$filter["x_Apellidos"];
		$this->Apellidos->AdvancedSearch->SearchOperator = @$filter["z_Apellidos"];
		$this->Apellidos->AdvancedSearch->SearchCondition = @$filter["v_Apellidos"];
		$this->Apellidos->AdvancedSearch->SearchValue2 = @$filter["y_Apellidos"];
		$this->Apellidos->AdvancedSearch->SearchOperator2 = @$filter["w_Apellidos"];
		$this->Apellidos->AdvancedSearch->Save();

		// Field Genero
		$this->Genero->AdvancedSearch->SearchValue = @$filter["x_Genero"];
		$this->Genero->AdvancedSearch->SearchOperator = @$filter["z_Genero"];
		$this->Genero->AdvancedSearch->SearchCondition = @$filter["v_Genero"];
		$this->Genero->AdvancedSearch->SearchValue2 = @$filter["y_Genero"];
		$this->Genero->AdvancedSearch->SearchOperator2 = @$filter["w_Genero"];
		$this->Genero->AdvancedSearch->Save();

		// Field No_certificado
		$this->No_certificado->AdvancedSearch->SearchValue = @$filter["x_No_certificado"];
		$this->No_certificado->AdvancedSearch->SearchOperator = @$filter["z_No_certificado"];
		$this->No_certificado->AdvancedSearch->SearchCondition = @$filter["v_No_certificado"];
		$this->No_certificado->AdvancedSearch->SearchValue2 = @$filter["y_No_certificado"];
		$this->No_certificado->AdvancedSearch->SearchOperator2 = @$filter["w_No_certificado"];
		$this->No_certificado->AdvancedSearch->Save();

		// Field Fecha_Fallecimiento
		$this->Fecha_Fallecimiento->AdvancedSearch->SearchValue = @$filter["x_Fecha_Fallecimiento"];
		$this->Fecha_Fallecimiento->AdvancedSearch->SearchOperator = @$filter["z_Fecha_Fallecimiento"];
		$this->Fecha_Fallecimiento->AdvancedSearch->SearchCondition = @$filter["v_Fecha_Fallecimiento"];
		$this->Fecha_Fallecimiento->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_Fallecimiento"];
		$this->Fecha_Fallecimiento->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_Fallecimiento"];
		$this->Fecha_Fallecimiento->AdvancedSearch->Save();

		// Field p_manera_muerte
		$this->p_manera_muerte->AdvancedSearch->SearchValue = @$filter["x_p_manera_muerte"];
		$this->p_manera_muerte->AdvancedSearch->SearchOperator = @$filter["z_p_manera_muerte"];
		$this->p_manera_muerte->AdvancedSearch->SearchCondition = @$filter["v_p_manera_muerte"];
		$this->p_manera_muerte->AdvancedSearch->SearchValue2 = @$filter["y_p_manera_muerte"];
		$this->p_manera_muerte->AdvancedSearch->SearchOperator2 = @$filter["w_p_manera_muerte"];
		$this->p_manera_muerte->AdvancedSearch->Save();

		// Field Edad
		$this->Edad->AdvancedSearch->SearchValue = @$filter["x_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator = @$filter["z_Edad"];
		$this->Edad->AdvancedSearch->SearchCondition = @$filter["v_Edad"];
		$this->Edad->AdvancedSearch->SearchValue2 = @$filter["y_Edad"];
		$this->Edad->AdvancedSearch->SearchOperator2 = @$filter["w_Edad"];
		$this->Edad->AdvancedSearch->Save();

		// Field Tipo_edad
		$this->Tipo_edad->AdvancedSearch->SearchValue = @$filter["x_Tipo_edad"];
		$this->Tipo_edad->AdvancedSearch->SearchOperator = @$filter["z_Tipo_edad"];
		$this->Tipo_edad->AdvancedSearch->SearchCondition = @$filter["v_Tipo_edad"];
		$this->Tipo_edad->AdvancedSearch->SearchValue2 = @$filter["y_Tipo_edad"];
		$this->Tipo_edad->AdvancedSearch->SearchOperator2 = @$filter["w_Tipo_edad"];
		$this->Tipo_edad->AdvancedSearch->Save();

		// Field Nombre_solicitante
		$this->Nombre_solicitante->AdvancedSearch->SearchValue = @$filter["x_Nombre_solicitante"];
		$this->Nombre_solicitante->AdvancedSearch->SearchOperator = @$filter["z_Nombre_solicitante"];
		$this->Nombre_solicitante->AdvancedSearch->SearchCondition = @$filter["v_Nombre_solicitante"];
		$this->Nombre_solicitante->AdvancedSearch->SearchValue2 = @$filter["y_Nombre_solicitante"];
		$this->Nombre_solicitante->AdvancedSearch->SearchOperator2 = @$filter["w_Nombre_solicitante"];
		$this->Nombre_solicitante->AdvancedSearch->Save();

		// Field Funcionario_expide
		$this->Funcionario_expide->AdvancedSearch->SearchValue = @$filter["x_Funcionario_expide"];
		$this->Funcionario_expide->AdvancedSearch->SearchOperator = @$filter["z_Funcionario_expide"];
		$this->Funcionario_expide->AdvancedSearch->SearchCondition = @$filter["v_Funcionario_expide"];
		$this->Funcionario_expide->AdvancedSearch->SearchValue2 = @$filter["y_Funcionario_expide"];
		$this->Funcionario_expide->AdvancedSearch->SearchOperator2 = @$filter["w_Funcionario_expide"];
		$this->Funcionario_expide->AdvancedSearch->Save();

		// Field Permiso_inhumar
		$this->Permiso_inhumar->AdvancedSearch->SearchValue = @$filter["x_Permiso_inhumar"];
		$this->Permiso_inhumar->AdvancedSearch->SearchOperator = @$filter["z_Permiso_inhumar"];
		$this->Permiso_inhumar->AdvancedSearch->SearchCondition = @$filter["v_Permiso_inhumar"];
		$this->Permiso_inhumar->AdvancedSearch->SearchValue2 = @$filter["y_Permiso_inhumar"];
		$this->Permiso_inhumar->AdvancedSearch->SearchOperator2 = @$filter["w_Permiso_inhumar"];
		$this->Permiso_inhumar->AdvancedSearch->Save();

		// Field Permiso_cremar
		$this->Permiso_cremar->AdvancedSearch->SearchValue = @$filter["x_Permiso_cremar"];
		$this->Permiso_cremar->AdvancedSearch->SearchOperator = @$filter["z_Permiso_cremar"];
		$this->Permiso_cremar->AdvancedSearch->SearchCondition = @$filter["v_Permiso_cremar"];
		$this->Permiso_cremar->AdvancedSearch->SearchValue2 = @$filter["y_Permiso_cremar"];
		$this->Permiso_cremar->AdvancedSearch->SearchOperator2 = @$filter["w_Permiso_cremar"];
		$this->Permiso_cremar->AdvancedSearch->Save();

		// Field Firma_funcionario
		$this->Firma_funcionario->AdvancedSearch->SearchValue = @$filter["x_Firma_funcionario"];
		$this->Firma_funcionario->AdvancedSearch->SearchOperator = @$filter["z_Firma_funcionario"];
		$this->Firma_funcionario->AdvancedSearch->SearchCondition = @$filter["v_Firma_funcionario"];
		$this->Firma_funcionario->AdvancedSearch->SearchValue2 = @$filter["y_Firma_funcionario"];
		$this->Firma_funcionario->AdvancedSearch->SearchOperator2 = @$filter["w_Firma_funcionario"];
		$this->Firma_funcionario->AdvancedSearch->Save();

		// Field Codigo_qr
		$this->Codigo_qr->AdvancedSearch->SearchValue = @$filter["x_Codigo_qr"];
		$this->Codigo_qr->AdvancedSearch->SearchOperator = @$filter["z_Codigo_qr"];
		$this->Codigo_qr->AdvancedSearch->SearchCondition = @$filter["v_Codigo_qr"];
		$this->Codigo_qr->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_qr"];
		$this->Codigo_qr->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_qr"];
		$this->Codigo_qr->AdvancedSearch->Save();

		// Field Verificacion_codigo_qr
		$this->Verificacion_codigo_qr->AdvancedSearch->SearchValue = @$filter["x_Verificacion_codigo_qr"];
		$this->Verificacion_codigo_qr->AdvancedSearch->SearchOperator = @$filter["z_Verificacion_codigo_qr"];
		$this->Verificacion_codigo_qr->AdvancedSearch->SearchCondition = @$filter["v_Verificacion_codigo_qr"];
		$this->Verificacion_codigo_qr->AdvancedSearch->SearchValue2 = @$filter["y_Verificacion_codigo_qr"];
		$this->Verificacion_codigo_qr->AdvancedSearch->SearchOperator2 = @$filter["w_Verificacion_codigo_qr"];
		$this->Verificacion_codigo_qr->AdvancedSearch->Save();

		// Field Registrado_por
		$this->Registrado_por->AdvancedSearch->SearchValue = @$filter["x_Registrado_por"];
		$this->Registrado_por->AdvancedSearch->SearchOperator = @$filter["z_Registrado_por"];
		$this->Registrado_por->AdvancedSearch->SearchCondition = @$filter["v_Registrado_por"];
		$this->Registrado_por->AdvancedSearch->SearchValue2 = @$filter["y_Registrado_por"];
		$this->Registrado_por->AdvancedSearch->SearchOperator2 = @$filter["w_Registrado_por"];
		$this->Registrado_por->AdvancedSearch->Save();

		// Field Fecha_registro
		$this->Fecha_registro->AdvancedSearch->SearchValue = @$filter["x_Fecha_registro"];
		$this->Fecha_registro->AdvancedSearch->SearchOperator = @$filter["z_Fecha_registro"];
		$this->Fecha_registro->AdvancedSearch->SearchCondition = @$filter["v_Fecha_registro"];
		$this->Fecha_registro->AdvancedSearch->SearchValue2 = @$filter["y_Fecha_registro"];
		$this->Fecha_registro->AdvancedSearch->SearchOperator2 = @$filter["w_Fecha_registro"];
		$this->Fecha_registro->AdvancedSearch->Save();

		// Field estado_licencia
		$this->estado_licencia->AdvancedSearch->SearchValue = @$filter["x_estado_licencia"];
		$this->estado_licencia->AdvancedSearch->SearchOperator = @$filter["z_estado_licencia"];
		$this->estado_licencia->AdvancedSearch->SearchCondition = @$filter["v_estado_licencia"];
		$this->estado_licencia->AdvancedSearch->SearchValue2 = @$filter["y_estado_licencia"];
		$this->estado_licencia->AdvancedSearch->SearchOperator2 = @$filter["w_estado_licencia"];
		$this->estado_licencia->AdvancedSearch->Save();

		// Field Entidad_dirige_licencia
		$this->Entidad_dirige_licencia->AdvancedSearch->SearchValue = @$filter["x_Entidad_dirige_licencia"];
		$this->Entidad_dirige_licencia->AdvancedSearch->SearchOperator = @$filter["z_Entidad_dirige_licencia"];
		$this->Entidad_dirige_licencia->AdvancedSearch->SearchCondition = @$filter["v_Entidad_dirige_licencia"];
		$this->Entidad_dirige_licencia->AdvancedSearch->SearchValue2 = @$filter["y_Entidad_dirige_licencia"];
		$this->Entidad_dirige_licencia->AdvancedSearch->SearchOperator2 = @$filter["w_Entidad_dirige_licencia"];
		$this->Entidad_dirige_licencia->AdvancedSearch->Save();

		// Field observaciones
		$this->observaciones->AdvancedSearch->SearchValue = @$filter["x_observaciones"];
		$this->observaciones->AdvancedSearch->SearchOperator = @$filter["z_observaciones"];
		$this->observaciones->AdvancedSearch->SearchCondition = @$filter["v_observaciones"];
		$this->observaciones->AdvancedSearch->SearchValue2 = @$filter["y_observaciones"];
		$this->observaciones->AdvancedSearch->SearchOperator2 = @$filter["w_observaciones"];
		$this->observaciones->AdvancedSearch->Save();

		// Field fecha_edicion
		$this->fecha_edicion->AdvancedSearch->SearchValue = @$filter["x_fecha_edicion"];
		$this->fecha_edicion->AdvancedSearch->SearchOperator = @$filter["z_fecha_edicion"];
		$this->fecha_edicion->AdvancedSearch->SearchCondition = @$filter["v_fecha_edicion"];
		$this->fecha_edicion->AdvancedSearch->SearchValue2 = @$filter["y_fecha_edicion"];
		$this->fecha_edicion->AdvancedSearch->SearchOperator2 = @$filter["w_fecha_edicion"];
		$this->fecha_edicion->AdvancedSearch->Save();

		// Field usuario_edita
		$this->usuario_edita->AdvancedSearch->SearchValue = @$filter["x_usuario_edita"];
		$this->usuario_edita->AdvancedSearch->SearchOperator = @$filter["z_usuario_edita"];
		$this->usuario_edita->AdvancedSearch->SearchCondition = @$filter["v_usuario_edita"];
		$this->usuario_edita->AdvancedSearch->SearchValue2 = @$filter["y_usuario_edita"];
		$this->usuario_edita->AdvancedSearch->SearchOperator2 = @$filter["w_usuario_edita"];
		$this->usuario_edita->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		$this->BuildSearchSql($sWhere, $this->Id, $Default, FALSE); // Id
		$this->BuildSearchSql($sWhere, $this->Entidad, $Default, FALSE); // Entidad
		$this->BuildSearchSql($sWhere, $this->Logo, $Default, FALSE); // Logo
		$this->BuildSearchSql($sWhere, $this->Fecha_expedicion, $Default, FALSE); // Fecha_expedicion
		$this->BuildSearchSql($sWhere, $this->Dpto_expedicion, $Default, FALSE); // Dpto_expedicion
		$this->BuildSearchSql($sWhere, $this->Mun_expedicion, $Default, FALSE); // Mun_expedicion
		$this->BuildSearchSql($sWhere, $this->tipo_muerte, $Default, FALSE); // tipo_muerte
		$this->BuildSearchSql($sWhere, $this->Documento, $Default, FALSE); // Documento
		$this->BuildSearchSql($sWhere, $this->Tipo_doc, $Default, FALSE); // Tipo_doc
		$this->BuildSearchSql($sWhere, $this->Nombres, $Default, FALSE); // Nombres
		$this->BuildSearchSql($sWhere, $this->Apellidos, $Default, FALSE); // Apellidos
		$this->BuildSearchSql($sWhere, $this->Genero, $Default, FALSE); // Genero
		$this->BuildSearchSql($sWhere, $this->No_certificado, $Default, FALSE); // No_certificado
		$this->BuildSearchSql($sWhere, $this->Fecha_Fallecimiento, $Default, FALSE); // Fecha_Fallecimiento
		$this->BuildSearchSql($sWhere, $this->p_manera_muerte, $Default, FALSE); // p_manera_muerte
		$this->BuildSearchSql($sWhere, $this->Edad, $Default, FALSE); // Edad
		$this->BuildSearchSql($sWhere, $this->Tipo_edad, $Default, FALSE); // Tipo_edad
		$this->BuildSearchSql($sWhere, $this->Nombre_solicitante, $Default, FALSE); // Nombre_solicitante
		$this->BuildSearchSql($sWhere, $this->Funcionario_expide, $Default, FALSE); // Funcionario_expide
		$this->BuildSearchSql($sWhere, $this->Permiso_inhumar, $Default, FALSE); // Permiso_inhumar
		$this->BuildSearchSql($sWhere, $this->Permiso_cremar, $Default, FALSE); // Permiso_cremar
		$this->BuildSearchSql($sWhere, $this->Firma_funcionario, $Default, FALSE); // Firma_funcionario
		$this->BuildSearchSql($sWhere, $this->Codigo_qr, $Default, FALSE); // Codigo_qr
		$this->BuildSearchSql($sWhere, $this->Verificacion_codigo_qr, $Default, FALSE); // Verificacion_codigo_qr
		$this->BuildSearchSql($sWhere, $this->Registrado_por, $Default, FALSE); // Registrado_por
		$this->BuildSearchSql($sWhere, $this->Fecha_registro, $Default, FALSE); // Fecha_registro
		$this->BuildSearchSql($sWhere, $this->estado_licencia, $Default, FALSE); // estado_licencia
		$this->BuildSearchSql($sWhere, $this->Entidad_dirige_licencia, $Default, FALSE); // Entidad_dirige_licencia
		$this->BuildSearchSql($sWhere, $this->observaciones, $Default, FALSE); // observaciones
		$this->BuildSearchSql($sWhere, $this->fecha_edicion, $Default, FALSE); // fecha_edicion
		$this->BuildSearchSql($sWhere, $this->usuario_edita, $Default, FALSE); // usuario_edita

		// Set up search parm
		if (!$Default && $sWhere <> "") {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->Id->AdvancedSearch->Save(); // Id
			$this->Entidad->AdvancedSearch->Save(); // Entidad
			$this->Logo->AdvancedSearch->Save(); // Logo
			$this->Fecha_expedicion->AdvancedSearch->Save(); // Fecha_expedicion
			$this->Dpto_expedicion->AdvancedSearch->Save(); // Dpto_expedicion
			$this->Mun_expedicion->AdvancedSearch->Save(); // Mun_expedicion
			$this->tipo_muerte->AdvancedSearch->Save(); // tipo_muerte
			$this->Documento->AdvancedSearch->Save(); // Documento
			$this->Tipo_doc->AdvancedSearch->Save(); // Tipo_doc
			$this->Nombres->AdvancedSearch->Save(); // Nombres
			$this->Apellidos->AdvancedSearch->Save(); // Apellidos
			$this->Genero->AdvancedSearch->Save(); // Genero
			$this->No_certificado->AdvancedSearch->Save(); // No_certificado
			$this->Fecha_Fallecimiento->AdvancedSearch->Save(); // Fecha_Fallecimiento
			$this->p_manera_muerte->AdvancedSearch->Save(); // p_manera_muerte
			$this->Edad->AdvancedSearch->Save(); // Edad
			$this->Tipo_edad->AdvancedSearch->Save(); // Tipo_edad
			$this->Nombre_solicitante->AdvancedSearch->Save(); // Nombre_solicitante
			$this->Funcionario_expide->AdvancedSearch->Save(); // Funcionario_expide
			$this->Permiso_inhumar->AdvancedSearch->Save(); // Permiso_inhumar
			$this->Permiso_cremar->AdvancedSearch->Save(); // Permiso_cremar
			$this->Firma_funcionario->AdvancedSearch->Save(); // Firma_funcionario
			$this->Codigo_qr->AdvancedSearch->Save(); // Codigo_qr
			$this->Verificacion_codigo_qr->AdvancedSearch->Save(); // Verificacion_codigo_qr
			$this->Registrado_por->AdvancedSearch->Save(); // Registrado_por
			$this->Fecha_registro->AdvancedSearch->Save(); // Fecha_registro
			$this->estado_licencia->AdvancedSearch->Save(); // estado_licencia
			$this->Entidad_dirige_licencia->AdvancedSearch->Save(); // Entidad_dirige_licencia
			$this->observaciones->AdvancedSearch->Save(); // observaciones
			$this->fecha_edicion->AdvancedSearch->Save(); // fecha_edicion
			$this->usuario_edita->AdvancedSearch->Save(); // usuario_edita
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = substr($Fld->FldVar, 2);
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";

		//$FldVal = ew_StripSlashes($FldVal);
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);

		//$FldVal2 = ew_StripSlashes($FldVal2);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1 || $FldOpr <> "LIKE" ||
			($FldOpr2 <> "LIKE" && $FldVal2 <> ""))
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Dpto_expedicion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Mun_expedicion, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Documento, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Nombres, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Apellidos, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->No_certificado, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Nombre_solicitante, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Funcionario_expide, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Permiso_inhumar, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Permiso_cremar, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Firma_funcionario, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Verificacion_codigo_qr, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Registrado_por, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->observaciones, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->usuario_edita, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->Id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Entidad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Logo->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_expedicion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Dpto_expedicion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Mun_expedicion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->tipo_muerte->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Documento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_doc->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Nombres->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Apellidos->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Genero->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->No_certificado->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_Fallecimiento->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->p_manera_muerte->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Tipo_edad->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Nombre_solicitante->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Funcionario_expide->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Permiso_inhumar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Permiso_cremar->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Firma_funcionario->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Codigo_qr->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Verificacion_codigo_qr->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Registrado_por->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Fecha_registro->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->estado_licencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->Entidad_dirige_licencia->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->observaciones->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->fecha_edicion->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->usuario_edita->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->Id->AdvancedSearch->UnsetSession();
		$this->Entidad->AdvancedSearch->UnsetSession();
		$this->Logo->AdvancedSearch->UnsetSession();
		$this->Fecha_expedicion->AdvancedSearch->UnsetSession();
		$this->Dpto_expedicion->AdvancedSearch->UnsetSession();
		$this->Mun_expedicion->AdvancedSearch->UnsetSession();
		$this->tipo_muerte->AdvancedSearch->UnsetSession();
		$this->Documento->AdvancedSearch->UnsetSession();
		$this->Tipo_doc->AdvancedSearch->UnsetSession();
		$this->Nombres->AdvancedSearch->UnsetSession();
		$this->Apellidos->AdvancedSearch->UnsetSession();
		$this->Genero->AdvancedSearch->UnsetSession();
		$this->No_certificado->AdvancedSearch->UnsetSession();
		$this->Fecha_Fallecimiento->AdvancedSearch->UnsetSession();
		$this->p_manera_muerte->AdvancedSearch->UnsetSession();
		$this->Edad->AdvancedSearch->UnsetSession();
		$this->Tipo_edad->AdvancedSearch->UnsetSession();
		$this->Nombre_solicitante->AdvancedSearch->UnsetSession();
		$this->Funcionario_expide->AdvancedSearch->UnsetSession();
		$this->Permiso_inhumar->AdvancedSearch->UnsetSession();
		$this->Permiso_cremar->AdvancedSearch->UnsetSession();
		$this->Firma_funcionario->AdvancedSearch->UnsetSession();
		$this->Codigo_qr->AdvancedSearch->UnsetSession();
		$this->Verificacion_codigo_qr->AdvancedSearch->UnsetSession();
		$this->Registrado_por->AdvancedSearch->UnsetSession();
		$this->Fecha_registro->AdvancedSearch->UnsetSession();
		$this->estado_licencia->AdvancedSearch->UnsetSession();
		$this->Entidad_dirige_licencia->AdvancedSearch->UnsetSession();
		$this->observaciones->AdvancedSearch->UnsetSession();
		$this->fecha_edicion->AdvancedSearch->UnsetSession();
		$this->usuario_edita->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->Id->AdvancedSearch->Load();
		$this->Entidad->AdvancedSearch->Load();
		$this->Logo->AdvancedSearch->Load();
		$this->Fecha_expedicion->AdvancedSearch->Load();
		$this->Dpto_expedicion->AdvancedSearch->Load();
		$this->Mun_expedicion->AdvancedSearch->Load();
		$this->tipo_muerte->AdvancedSearch->Load();
		$this->Documento->AdvancedSearch->Load();
		$this->Tipo_doc->AdvancedSearch->Load();
		$this->Nombres->AdvancedSearch->Load();
		$this->Apellidos->AdvancedSearch->Load();
		$this->Genero->AdvancedSearch->Load();
		$this->No_certificado->AdvancedSearch->Load();
		$this->Fecha_Fallecimiento->AdvancedSearch->Load();
		$this->p_manera_muerte->AdvancedSearch->Load();
		$this->Edad->AdvancedSearch->Load();
		$this->Tipo_edad->AdvancedSearch->Load();
		$this->Nombre_solicitante->AdvancedSearch->Load();
		$this->Funcionario_expide->AdvancedSearch->Load();
		$this->Permiso_inhumar->AdvancedSearch->Load();
		$this->Permiso_cremar->AdvancedSearch->Load();
		$this->Firma_funcionario->AdvancedSearch->Load();
		$this->Codigo_qr->AdvancedSearch->Load();
		$this->Verificacion_codigo_qr->AdvancedSearch->Load();
		$this->Registrado_por->AdvancedSearch->Load();
		$this->Fecha_registro->AdvancedSearch->Load();
		$this->estado_licencia->AdvancedSearch->Load();
		$this->Entidad_dirige_licencia->AdvancedSearch->Load();
		$this->observaciones->AdvancedSearch->Load();
		$this->fecha_edicion->AdvancedSearch->Load();
		$this->usuario_edita->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Id); // Id
			$this->UpdateSort($this->Entidad); // Entidad
			$this->UpdateSort($this->Fecha_expedicion); // Fecha_expedicion
			$this->UpdateSort($this->tipo_muerte); // tipo_muerte
			$this->UpdateSort($this->Documento); // Documento
			$this->UpdateSort($this->Nombres); // Nombres
			$this->UpdateSort($this->Apellidos); // Apellidos
			$this->UpdateSort($this->No_certificado); // No_certificado
			$this->UpdateSort($this->Fecha_Fallecimiento); // Fecha_Fallecimiento
			$this->UpdateSort($this->p_manera_muerte); // p_manera_muerte
			$this->UpdateSort($this->Registrado_por); // Registrado_por
			$this->UpdateSort($this->Fecha_registro); // Fecha_registro
			$this->UpdateSort($this->fecha_edicion); // fecha_edicion
			$this->UpdateSort($this->usuario_edita); // usuario_edita
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Id->setSort("");
				$this->Entidad->setSort("");
				$this->Fecha_expedicion->setSort("");
				$this->tipo_muerte->setSort("");
				$this->Documento->setSort("");
				$this->Nombres->setSort("");
				$this->Apellidos->setSort("");
				$this->No_certificado->setSort("");
				$this->Fecha_Fallecimiento->setSort("");
				$this->p_manera_muerte->setSort("");
				$this->Registrado_por->setSort("");
				$this->Fecha_registro->setSort("");
				$this->fecha_edicion->setSort("");
				$this->usuario_edita->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->IsLoggedIn();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = $Security->IsLoggedIn();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->IsLoggedIn();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		if ($Security->IsLoggedIn())
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		else
			$oListOpt->Body = "";

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		if ($Security->IsLoggedIn()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" value=\"" . ew_HtmlEncode($this->Id->CurrentValue) . "\" onclick='ew_ClickMultiCheckbox(event);'>";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . ew_HtmlTitle($Language->Phrase("AddLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("AddLink")) . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->IsLoggedIn());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.flicenciaslist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->IsLoggedIn());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"flicenciaslistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"flicenciaslistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.flicenciaslist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"flicenciaslistsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// Id

		$this->Id->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Id"]);
		if ($this->Id->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Id->AdvancedSearch->SearchOperator = @$_GET["z_Id"];

		// Entidad
		$this->Entidad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Entidad"]);
		if ($this->Entidad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Entidad->AdvancedSearch->SearchOperator = @$_GET["z_Entidad"];

		// Logo
		$this->Logo->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Logo"]);
		if ($this->Logo->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Logo->AdvancedSearch->SearchOperator = @$_GET["z_Logo"];

		// Fecha_expedicion
		$this->Fecha_expedicion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_expedicion"]);
		if ($this->Fecha_expedicion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_expedicion->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_expedicion"];
		$this->Fecha_expedicion->AdvancedSearch->SearchCondition = @$_GET["v_Fecha_expedicion"];
		$this->Fecha_expedicion->AdvancedSearch->SearchValue2 = ew_StripSlashes(@$_GET["y_Fecha_expedicion"]);
		if ($this->Fecha_expedicion->AdvancedSearch->SearchValue2 <> "") $this->Command = "search";
		$this->Fecha_expedicion->AdvancedSearch->SearchOperator2 = @$_GET["w_Fecha_expedicion"];

		// Dpto_expedicion
		$this->Dpto_expedicion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Dpto_expedicion"]);
		if ($this->Dpto_expedicion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Dpto_expedicion->AdvancedSearch->SearchOperator = @$_GET["z_Dpto_expedicion"];

		// Mun_expedicion
		$this->Mun_expedicion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Mun_expedicion"]);
		if ($this->Mun_expedicion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Mun_expedicion->AdvancedSearch->SearchOperator = @$_GET["z_Mun_expedicion"];

		// tipo_muerte
		$this->tipo_muerte->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_tipo_muerte"]);
		if ($this->tipo_muerte->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->tipo_muerte->AdvancedSearch->SearchOperator = @$_GET["z_tipo_muerte"];
		if (is_array($this->tipo_muerte->AdvancedSearch->SearchValue)) $this->tipo_muerte->AdvancedSearch->SearchValue = implode(",", $this->tipo_muerte->AdvancedSearch->SearchValue);
		if (is_array($this->tipo_muerte->AdvancedSearch->SearchValue2)) $this->tipo_muerte->AdvancedSearch->SearchValue2 = implode(",", $this->tipo_muerte->AdvancedSearch->SearchValue2);

		// Documento
		$this->Documento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Documento"]);
		if ($this->Documento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Documento->AdvancedSearch->SearchOperator = @$_GET["z_Documento"];

		// Tipo_doc
		$this->Tipo_doc->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_doc"]);
		if ($this->Tipo_doc->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_doc->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_doc"];

		// Nombres
		$this->Nombres->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Nombres"]);
		if ($this->Nombres->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Nombres->AdvancedSearch->SearchOperator = @$_GET["z_Nombres"];

		// Apellidos
		$this->Apellidos->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Apellidos"]);
		if ($this->Apellidos->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Apellidos->AdvancedSearch->SearchOperator = @$_GET["z_Apellidos"];

		// Genero
		$this->Genero->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Genero"]);
		if ($this->Genero->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Genero->AdvancedSearch->SearchOperator = @$_GET["z_Genero"];

		// No_certificado
		$this->No_certificado->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_No_certificado"]);
		if ($this->No_certificado->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->No_certificado->AdvancedSearch->SearchOperator = @$_GET["z_No_certificado"];

		// Fecha_Fallecimiento
		$this->Fecha_Fallecimiento->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_Fallecimiento"]);
		if ($this->Fecha_Fallecimiento->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_Fallecimiento->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_Fallecimiento"];

		// p_manera_muerte
		$this->p_manera_muerte->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_p_manera_muerte"]);
		if ($this->p_manera_muerte->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->p_manera_muerte->AdvancedSearch->SearchOperator = @$_GET["z_p_manera_muerte"];

		// Edad
		$this->Edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Edad"]);
		if ($this->Edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Edad->AdvancedSearch->SearchOperator = @$_GET["z_Edad"];

		// Tipo_edad
		$this->Tipo_edad->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Tipo_edad"]);
		if ($this->Tipo_edad->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Tipo_edad->AdvancedSearch->SearchOperator = @$_GET["z_Tipo_edad"];

		// Nombre_solicitante
		$this->Nombre_solicitante->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Nombre_solicitante"]);
		if ($this->Nombre_solicitante->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Nombre_solicitante->AdvancedSearch->SearchOperator = @$_GET["z_Nombre_solicitante"];

		// Funcionario_expide
		$this->Funcionario_expide->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Funcionario_expide"]);
		if ($this->Funcionario_expide->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Funcionario_expide->AdvancedSearch->SearchOperator = @$_GET["z_Funcionario_expide"];

		// Permiso_inhumar
		$this->Permiso_inhumar->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Permiso_inhumar"]);
		if ($this->Permiso_inhumar->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Permiso_inhumar->AdvancedSearch->SearchOperator = @$_GET["z_Permiso_inhumar"];

		// Permiso_cremar
		$this->Permiso_cremar->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Permiso_cremar"]);
		if ($this->Permiso_cremar->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Permiso_cremar->AdvancedSearch->SearchOperator = @$_GET["z_Permiso_cremar"];

		// Firma_funcionario
		$this->Firma_funcionario->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Firma_funcionario"]);
		if ($this->Firma_funcionario->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Firma_funcionario->AdvancedSearch->SearchOperator = @$_GET["z_Firma_funcionario"];

		// Codigo_qr
		$this->Codigo_qr->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Codigo_qr"]);
		if ($this->Codigo_qr->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Codigo_qr->AdvancedSearch->SearchOperator = @$_GET["z_Codigo_qr"];

		// Verificacion_codigo_qr
		$this->Verificacion_codigo_qr->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Verificacion_codigo_qr"]);
		if ($this->Verificacion_codigo_qr->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Verificacion_codigo_qr->AdvancedSearch->SearchOperator = @$_GET["z_Verificacion_codigo_qr"];

		// Registrado_por
		$this->Registrado_por->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Registrado_por"]);
		if ($this->Registrado_por->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Registrado_por->AdvancedSearch->SearchOperator = @$_GET["z_Registrado_por"];

		// Fecha_registro
		$this->Fecha_registro->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Fecha_registro"]);
		if ($this->Fecha_registro->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Fecha_registro->AdvancedSearch->SearchOperator = @$_GET["z_Fecha_registro"];

		// estado_licencia
		$this->estado_licencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_estado_licencia"]);
		if ($this->estado_licencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->estado_licencia->AdvancedSearch->SearchOperator = @$_GET["z_estado_licencia"];

		// Entidad_dirige_licencia
		$this->Entidad_dirige_licencia->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_Entidad_dirige_licencia"]);
		if ($this->Entidad_dirige_licencia->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->Entidad_dirige_licencia->AdvancedSearch->SearchOperator = @$_GET["z_Entidad_dirige_licencia"];

		// observaciones
		$this->observaciones->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_observaciones"]);
		if ($this->observaciones->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->observaciones->AdvancedSearch->SearchOperator = @$_GET["z_observaciones"];

		// fecha_edicion
		$this->fecha_edicion->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_fecha_edicion"]);
		if ($this->fecha_edicion->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->fecha_edicion->AdvancedSearch->SearchOperator = @$_GET["z_fecha_edicion"];

		// usuario_edita
		$this->usuario_edita->AdvancedSearch->SearchValue = ew_StripSlashes(@$_GET["x_usuario_edita"]);
		if ($this->usuario_edita->AdvancedSearch->SearchValue <> "") $this->Command = "search";
		$this->usuario_edita->AdvancedSearch->SearchOperator = @$_GET["z_usuario_edita"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id->setDbValue($rs->fields('Id'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->Logo->setDbValue($rs->fields('Logo'));
		$this->Fecha_expedicion->setDbValue($rs->fields('Fecha_expedicion'));
		$this->Dpto_expedicion->setDbValue($rs->fields('Dpto_expedicion'));
		$this->Mun_expedicion->setDbValue($rs->fields('Mun_expedicion'));
		$this->tipo_muerte->setDbValue($rs->fields('tipo_muerte'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Tipo_doc->setDbValue($rs->fields('Tipo_doc'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->No_certificado->setDbValue($rs->fields('No_certificado'));
		$this->Fecha_Fallecimiento->setDbValue($rs->fields('Fecha_Fallecimiento'));
		$this->p_manera_muerte->setDbValue($rs->fields('p_manera_muerte'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Tipo_edad->setDbValue($rs->fields('Tipo_edad'));
		$this->Nombre_solicitante->setDbValue($rs->fields('Nombre_solicitante'));
		$this->Funcionario_expide->setDbValue($rs->fields('Funcionario_expide'));
		$this->Permiso_inhumar->setDbValue($rs->fields('Permiso_inhumar'));
		$this->Permiso_cremar->setDbValue($rs->fields('Permiso_cremar'));
		$this->Firma_funcionario->setDbValue($rs->fields('Firma_funcionario'));
		$this->Codigo_qr->setDbValue($rs->fields('Codigo_qr'));
		$this->Verificacion_codigo_qr->setDbValue($rs->fields('Verificacion_codigo_qr'));
		$this->Registrado_por->setDbValue($rs->fields('Registrado_por'));
		$this->Fecha_registro->setDbValue($rs->fields('Fecha_registro'));
		$this->Mensaje_manual->setDbValue($rs->fields('Mensaje_manual'));
		$this->estado_licencia->setDbValue($rs->fields('estado_licencia'));
		$this->Entidad_dirige_licencia->setDbValue($rs->fields('Entidad_dirige_licencia'));
		$this->observaciones->setDbValue($rs->fields('observaciones'));
		$this->fecha_edicion->setDbValue($rs->fields('fecha_edicion'));
		$this->usuario_edita->setDbValue($rs->fields('usuario_edita'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id->DbValue = $row['Id'];
		$this->Entidad->DbValue = $row['Entidad'];
		$this->Logo->DbValue = $row['Logo'];
		$this->Fecha_expedicion->DbValue = $row['Fecha_expedicion'];
		$this->Dpto_expedicion->DbValue = $row['Dpto_expedicion'];
		$this->Mun_expedicion->DbValue = $row['Mun_expedicion'];
		$this->tipo_muerte->DbValue = $row['tipo_muerte'];
		$this->Documento->DbValue = $row['Documento'];
		$this->Tipo_doc->DbValue = $row['Tipo_doc'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Genero->DbValue = $row['Genero'];
		$this->No_certificado->DbValue = $row['No_certificado'];
		$this->Fecha_Fallecimiento->DbValue = $row['Fecha_Fallecimiento'];
		$this->p_manera_muerte->DbValue = $row['p_manera_muerte'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Tipo_edad->DbValue = $row['Tipo_edad'];
		$this->Nombre_solicitante->DbValue = $row['Nombre_solicitante'];
		$this->Funcionario_expide->DbValue = $row['Funcionario_expide'];
		$this->Permiso_inhumar->DbValue = $row['Permiso_inhumar'];
		$this->Permiso_cremar->DbValue = $row['Permiso_cremar'];
		$this->Firma_funcionario->DbValue = $row['Firma_funcionario'];
		$this->Codigo_qr->DbValue = $row['Codigo_qr'];
		$this->Verificacion_codigo_qr->DbValue = $row['Verificacion_codigo_qr'];
		$this->Registrado_por->DbValue = $row['Registrado_por'];
		$this->Fecha_registro->DbValue = $row['Fecha_registro'];
		$this->Mensaje_manual->DbValue = $row['Mensaje_manual'];
		$this->estado_licencia->DbValue = $row['estado_licencia'];
		$this->Entidad_dirige_licencia->DbValue = $row['Entidad_dirige_licencia'];
		$this->observaciones->DbValue = $row['observaciones'];
		$this->fecha_edicion->DbValue = $row['fecha_edicion'];
		$this->usuario_edita->DbValue = $row['usuario_edita'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("Id")) <> "")
			$this->Id->CurrentValue = $this->getKey("Id"); // Id
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Id
		// Entidad
		// Logo

		$this->Logo->CellCssStyle = "white-space: nowrap;";

		// Fecha_expedicion
		// Dpto_expedicion

		$this->Dpto_expedicion->CellCssStyle = "white-space: nowrap;";

		// Mun_expedicion
		$this->Mun_expedicion->CellCssStyle = "white-space: nowrap;";

		// tipo_muerte
		// Documento
		// Tipo_doc
		// Nombres
		// Apellidos
		// Genero
		// No_certificado
		// Fecha_Fallecimiento
		// p_manera_muerte
		// Edad
		// Tipo_edad
		// Nombre_solicitante
		// Funcionario_expide
		// Permiso_inhumar
		// Permiso_cremar
		// Firma_funcionario
		// Codigo_qr
		// Verificacion_codigo_qr

		$this->Verificacion_codigo_qr->CellCssStyle = "white-space: nowrap;";

		// Registrado_por
		$this->Registrado_por->CellCssStyle = "white-space: nowrap;";

		// Fecha_registro
		$this->Fecha_registro->CellCssStyle = "white-space: nowrap;";

		// Mensaje_manual
		$this->Mensaje_manual->CellCssStyle = "white-space: nowrap;";

		// estado_licencia
		$this->estado_licencia->CellCssStyle = "white-space: nowrap;";

		// Entidad_dirige_licencia
		$this->Entidad_dirige_licencia->CellCssStyle = "white-space: nowrap;";

		// observaciones
		// fecha_edicion
		// usuario_edita

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Id
		$this->Id->ViewValue = $this->Id->CurrentValue;
		$this->Id->ViewCustomAttributes = "";

		// Entidad
		if (strval($this->Entidad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Entidad->ViewValue = $this->Entidad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
			}
		} else {
			$this->Entidad->ViewValue = NULL;
		}
		$this->Entidad->ViewCustomAttributes = "";

		// Logo
		$this->Logo->ViewValue = $this->Logo->CurrentValue;
		$this->Logo->ViewCustomAttributes = "";

		// Fecha_expedicion
		$this->Fecha_expedicion->ViewValue = $this->Fecha_expedicion->CurrentValue;
		$this->Fecha_expedicion->ViewValue = ew_FormatDateTime($this->Fecha_expedicion->ViewValue, 5);
		$this->Fecha_expedicion->ViewCustomAttributes = "";

		// Dpto_expedicion
		$this->Dpto_expedicion->ViewValue = $this->Dpto_expedicion->CurrentValue;
		$this->Dpto_expedicion->ViewCustomAttributes = "";

		// Mun_expedicion
		$this->Mun_expedicion->ViewValue = $this->Mun_expedicion->CurrentValue;
		$this->Mun_expedicion->ViewCustomAttributes = "";

		// tipo_muerte
		if (strval($this->tipo_muerte->CurrentValue) <> "") {
			$arwrk = explode(",", $this->tipo_muerte->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`Id`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `Id`, `Tipo_muerte` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_muerte`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->tipo_muerte, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->tipo_muerte->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->tipo_muerte->ViewValue .= $this->tipo_muerte->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->tipo_muerte->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->tipo_muerte->ViewValue = $this->tipo_muerte->CurrentValue;
			}
		} else {
			$this->tipo_muerte->ViewValue = NULL;
		}
		$this->tipo_muerte->ViewCustomAttributes = "";

		// Documento
		$this->Documento->ViewValue = $this->Documento->CurrentValue;
		$this->Documento->ViewCustomAttributes = "";

		// Tipo_doc
		if (strval($this->Tipo_doc->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_doc->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `tipo_documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_doc, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_doc->ViewValue = $this->Tipo_doc->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_doc->ViewValue = $this->Tipo_doc->CurrentValue;
			}
		} else {
			$this->Tipo_doc->ViewValue = NULL;
		}
		$this->Tipo_doc->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Genero
		if (strval($this->Genero->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Genero->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `genero`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Genero, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Genero->ViewValue = $this->Genero->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Genero->ViewValue = $this->Genero->CurrentValue;
			}
		} else {
			$this->Genero->ViewValue = NULL;
		}
		$this->Genero->ViewCustomAttributes = "";

		// No_certificado
		$this->No_certificado->ViewValue = $this->No_certificado->CurrentValue;
		$this->No_certificado->ViewCustomAttributes = "";

		// Fecha_Fallecimiento
		$this->Fecha_Fallecimiento->ViewValue = $this->Fecha_Fallecimiento->CurrentValue;
		$this->Fecha_Fallecimiento->ViewValue = ew_FormatDateTime($this->Fecha_Fallecimiento->ViewValue, 5);
		$this->Fecha_Fallecimiento->ViewCustomAttributes = "";

		// p_manera_muerte
		if (strval($this->p_manera_muerte->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->p_manera_muerte->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `probable_manera` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `p_manera_muerte`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->p_manera_muerte, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->p_manera_muerte->ViewValue = $this->p_manera_muerte->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->p_manera_muerte->ViewValue = $this->p_manera_muerte->CurrentValue;
			}
		} else {
			$this->p_manera_muerte->ViewValue = NULL;
		}
		$this->p_manera_muerte->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Tipo_edad
		if (strval($this->Tipo_edad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_edad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Tipo_edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_edad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_edad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_edad->ViewValue = $this->Tipo_edad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_edad->ViewValue = $this->Tipo_edad->CurrentValue;
			}
		} else {
			$this->Tipo_edad->ViewValue = NULL;
		}
		$this->Tipo_edad->ViewCustomAttributes = "";

		// Nombre_solicitante
		$this->Nombre_solicitante->ViewValue = $this->Nombre_solicitante->CurrentValue;
		$this->Nombre_solicitante->ViewCustomAttributes = "";

		// Funcionario_expide
		$this->Funcionario_expide->ViewValue = $this->Funcionario_expide->CurrentValue;
		$this->Funcionario_expide->ViewCustomAttributes = "";

		// Permiso_inhumar
		$this->Permiso_inhumar->ViewValue = $this->Permiso_inhumar->CurrentValue;
		$this->Permiso_inhumar->ViewCustomAttributes = "";

		// Permiso_cremar
		$this->Permiso_cremar->ViewValue = $this->Permiso_cremar->CurrentValue;
		$this->Permiso_cremar->ViewCustomAttributes = "";

		// Firma_funcionario
		$this->Firma_funcionario->ViewValue = $this->Firma_funcionario->CurrentValue;
		$this->Firma_funcionario->ViewCustomAttributes = "";

		// Codigo_qr
		$this->Codigo_qr->ViewValue = $this->Codigo_qr->CurrentValue;
		$this->Codigo_qr->ViewCustomAttributes = "";

		// Verificacion_codigo_qr
		$this->Verificacion_codigo_qr->ViewValue = $this->Verificacion_codigo_qr->CurrentValue;
		$this->Verificacion_codigo_qr->ViewCustomAttributes = "";

		// Registrado_por
		$this->Registrado_por->ViewValue = $this->Registrado_por->CurrentValue;
		$this->Registrado_por->ViewCustomAttributes = "";

		// Fecha_registro
		$this->Fecha_registro->ViewValue = $this->Fecha_registro->CurrentValue;
		$this->Fecha_registro->ViewValue = ew_FormatDateTime($this->Fecha_registro->ViewValue, 5);
		$this->Fecha_registro->ViewCustomAttributes = "";

		// Mensaje_manual
		$this->Mensaje_manual->ViewValue = $this->Mensaje_manual->CurrentValue;
		$this->Mensaje_manual->ViewCustomAttributes = "";

		// observaciones
		$this->observaciones->ViewValue = $this->observaciones->CurrentValue;
		$this->observaciones->ViewCustomAttributes = "";

		// fecha_edicion
		$this->fecha_edicion->ViewValue = $this->fecha_edicion->CurrentValue;
		$this->fecha_edicion->ViewValue = ew_FormatDateTime($this->fecha_edicion->ViewValue, 5);
		$this->fecha_edicion->ViewCustomAttributes = "";

		// usuario_edita
		$this->usuario_edita->ViewValue = $this->usuario_edita->CurrentValue;
		$this->usuario_edita->ViewCustomAttributes = "";

			// Id
			$this->Id->LinkCustomAttributes = "";
			$this->Id->HrefValue = "";
			$this->Id->TooltipValue = "";

			// Entidad
			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";
			$this->Entidad->TooltipValue = "";

			// Fecha_expedicion
			$this->Fecha_expedicion->LinkCustomAttributes = "";
			$this->Fecha_expedicion->HrefValue = "";
			$this->Fecha_expedicion->TooltipValue = "";

			// tipo_muerte
			$this->tipo_muerte->LinkCustomAttributes = "";
			$this->tipo_muerte->HrefValue = "";
			$this->tipo_muerte->TooltipValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";
			$this->Documento->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// No_certificado
			$this->No_certificado->LinkCustomAttributes = "";
			$this->No_certificado->HrefValue = "";
			$this->No_certificado->TooltipValue = "";

			// Fecha_Fallecimiento
			$this->Fecha_Fallecimiento->LinkCustomAttributes = "";
			$this->Fecha_Fallecimiento->HrefValue = "";
			$this->Fecha_Fallecimiento->TooltipValue = "";

			// p_manera_muerte
			$this->p_manera_muerte->LinkCustomAttributes = "";
			$this->p_manera_muerte->HrefValue = "";
			$this->p_manera_muerte->TooltipValue = "";

			// Registrado_por
			$this->Registrado_por->LinkCustomAttributes = "";
			$this->Registrado_por->HrefValue = "";
			$this->Registrado_por->TooltipValue = "";

			// Fecha_registro
			$this->Fecha_registro->LinkCustomAttributes = "";
			$this->Fecha_registro->HrefValue = "";
			$this->Fecha_registro->TooltipValue = "";

			// fecha_edicion
			$this->fecha_edicion->LinkCustomAttributes = "";
			$this->fecha_edicion->HrefValue = "";
			$this->fecha_edicion->TooltipValue = "";

			// usuario_edita
			$this->usuario_edita->LinkCustomAttributes = "";
			$this->usuario_edita->HrefValue = "";
			$this->usuario_edita->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// Id
			$this->Id->EditAttrs["class"] = "form-control";
			$this->Id->EditCustomAttributes = "";
			$this->Id->EditValue = ew_HtmlEncode($this->Id->AdvancedSearch->SearchValue);
			$this->Id->PlaceHolder = ew_RemoveHtml($this->Id->FldCaption());

			// Entidad
			$this->Entidad->EditCustomAttributes = "";
			if (trim(strval($this->Entidad->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `entidad`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Entidad->EditValue = $arwrk;

			// Fecha_expedicion
			$this->Fecha_expedicion->EditAttrs["class"] = "form-control";
			$this->Fecha_expedicion->EditCustomAttributes = "";
			$this->Fecha_expedicion->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_expedicion->AdvancedSearch->SearchValue, 5), 5));
			$this->Fecha_expedicion->PlaceHolder = ew_RemoveHtml($this->Fecha_expedicion->FldCaption());
			$this->Fecha_expedicion->EditAttrs["class"] = "form-control";
			$this->Fecha_expedicion->EditCustomAttributes = "";
			$this->Fecha_expedicion->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_expedicion->AdvancedSearch->SearchValue2, 5), 5));
			$this->Fecha_expedicion->PlaceHolder = ew_RemoveHtml($this->Fecha_expedicion->FldCaption());

			// tipo_muerte
			$this->tipo_muerte->EditCustomAttributes = "";

			// Documento
			$this->Documento->EditAttrs["class"] = "form-control";
			$this->Documento->EditCustomAttributes = "";
			$this->Documento->EditValue = ew_HtmlEncode($this->Documento->AdvancedSearch->SearchValue);
			$this->Documento->PlaceHolder = ew_RemoveHtml($this->Documento->FldCaption());

			// Nombres
			$this->Nombres->EditAttrs["class"] = "form-control";
			$this->Nombres->EditCustomAttributes = "onkeyup='this.value=this.value.toUpperCase();'";
			$this->Nombres->EditValue = ew_HtmlEncode($this->Nombres->AdvancedSearch->SearchValue);
			$this->Nombres->PlaceHolder = ew_RemoveHtml($this->Nombres->FldCaption());

			// Apellidos
			$this->Apellidos->EditAttrs["class"] = "form-control";
			$this->Apellidos->EditCustomAttributes = "onkeyup='this.value=this.value.toUpperCase();'";
			$this->Apellidos->EditValue = ew_HtmlEncode($this->Apellidos->AdvancedSearch->SearchValue);
			$this->Apellidos->PlaceHolder = ew_RemoveHtml($this->Apellidos->FldCaption());

			// No_certificado
			$this->No_certificado->EditAttrs["class"] = "form-control";
			$this->No_certificado->EditCustomAttributes = "";
			$this->No_certificado->EditValue = ew_HtmlEncode($this->No_certificado->AdvancedSearch->SearchValue);
			$this->No_certificado->PlaceHolder = ew_RemoveHtml($this->No_certificado->FldCaption());

			// Fecha_Fallecimiento
			$this->Fecha_Fallecimiento->EditAttrs["class"] = "form-control";
			$this->Fecha_Fallecimiento->EditCustomAttributes = "";
			$this->Fecha_Fallecimiento->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_Fallecimiento->AdvancedSearch->SearchValue, 5), 5));
			$this->Fecha_Fallecimiento->PlaceHolder = ew_RemoveHtml($this->Fecha_Fallecimiento->FldCaption());

			// p_manera_muerte
			$this->p_manera_muerte->EditCustomAttributes = "";
			if (trim(strval($this->p_manera_muerte->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->p_manera_muerte->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `probable_manera` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `p_manera_muerte`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->p_manera_muerte, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->p_manera_muerte->EditValue = $arwrk;

			// Registrado_por
			$this->Registrado_por->EditAttrs["class"] = "form-control";
			$this->Registrado_por->EditCustomAttributes = "";
			$this->Registrado_por->EditValue = ew_HtmlEncode($this->Registrado_por->AdvancedSearch->SearchValue);
			$this->Registrado_por->PlaceHolder = ew_RemoveHtml($this->Registrado_por->FldCaption());

			// Fecha_registro
			$this->Fecha_registro->EditAttrs["class"] = "form-control";
			$this->Fecha_registro->EditCustomAttributes = "";
			$this->Fecha_registro->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->Fecha_registro->AdvancedSearch->SearchValue, 5), 5));
			$this->Fecha_registro->PlaceHolder = ew_RemoveHtml($this->Fecha_registro->FldCaption());

			// fecha_edicion
			$this->fecha_edicion->EditAttrs["class"] = "form-control";
			$this->fecha_edicion->EditCustomAttributes = "";
			$this->fecha_edicion->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->fecha_edicion->AdvancedSearch->SearchValue, 5), 5));
			$this->fecha_edicion->PlaceHolder = ew_RemoveHtml($this->fecha_edicion->FldCaption());

			// usuario_edita
			$this->usuario_edita->EditAttrs["class"] = "form-control";
			$this->usuario_edita->EditCustomAttributes = "";
			$this->usuario_edita->EditValue = ew_HtmlEncode($this->usuario_edita->AdvancedSearch->SearchValue);
			$this->usuario_edita->PlaceHolder = ew_RemoveHtml($this->usuario_edita->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckInteger($this->Id->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->Id->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_expedicion->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->Fecha_expedicion->FldErrMsg());
		}
		if (!ew_CheckDate($this->Fecha_expedicion->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->Fecha_expedicion->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->Id->AdvancedSearch->Load();
		$this->Entidad->AdvancedSearch->Load();
		$this->Logo->AdvancedSearch->Load();
		$this->Fecha_expedicion->AdvancedSearch->Load();
		$this->Dpto_expedicion->AdvancedSearch->Load();
		$this->Mun_expedicion->AdvancedSearch->Load();
		$this->tipo_muerte->AdvancedSearch->Load();
		$this->Documento->AdvancedSearch->Load();
		$this->Tipo_doc->AdvancedSearch->Load();
		$this->Nombres->AdvancedSearch->Load();
		$this->Apellidos->AdvancedSearch->Load();
		$this->Genero->AdvancedSearch->Load();
		$this->No_certificado->AdvancedSearch->Load();
		$this->Fecha_Fallecimiento->AdvancedSearch->Load();
		$this->p_manera_muerte->AdvancedSearch->Load();
		$this->Edad->AdvancedSearch->Load();
		$this->Tipo_edad->AdvancedSearch->Load();
		$this->Nombre_solicitante->AdvancedSearch->Load();
		$this->Funcionario_expide->AdvancedSearch->Load();
		$this->Permiso_inhumar->AdvancedSearch->Load();
		$this->Permiso_cremar->AdvancedSearch->Load();
		$this->Firma_funcionario->AdvancedSearch->Load();
		$this->Codigo_qr->AdvancedSearch->Load();
		$this->Verificacion_codigo_qr->AdvancedSearch->Load();
		$this->Registrado_por->AdvancedSearch->Load();
		$this->Fecha_registro->AdvancedSearch->Load();
		$this->estado_licencia->AdvancedSearch->Load();
		$this->Entidad_dirige_licencia->AdvancedSearch->Load();
		$this->observaciones->AdvancedSearch->Load();
		$this->fecha_edicion->AdvancedSearch->Load();
		$this->usuario_edita->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_licencias\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_licencias',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.flicenciaslist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetUpStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($licencias_list)) $licencias_list = new clicencias_list();

// Page init
$licencias_list->Page_Init();

// Page main
$licencias_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$licencias_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($licencias->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = flicenciaslist = new ew_Form("flicenciaslist", "list");
flicenciaslist.FormKeyCountName = '<?php echo $licencias_list->FormKeyCountName ?>';

// Form_CustomValidate event
flicenciaslist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
flicenciaslist.ValidateRequired = true;
<?php } else { ?>
flicenciaslist.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
flicenciaslist.Lists["x_Entidad"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Entidad","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciaslist.Lists["x_tipo_muerte[]"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_muerte","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciaslist.Lists["x_p_manera_muerte"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_probable_manera","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
var CurrentSearchForm = flicenciaslistsrch = new ew_Form("flicenciaslistsrch");

// Validate function for search
flicenciaslistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_Id");
	if (elm && !ew_CheckInteger(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($licencias->Id->FldErrMsg()) ?>");
	elm = this.GetElements("x" + infix + "_Fecha_expedicion");
	if (elm && !ew_CheckDate(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($licencias->Fecha_expedicion->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
flicenciaslistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
flicenciaslistsrch.ValidateRequired = true; // Use JavaScript validation
<?php } else { ?>
flicenciaslistsrch.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Dynamic selection lists
flicenciaslistsrch.Lists["x_Entidad"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Entidad","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciaslistsrch.Lists["x_p_manera_muerte"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_probable_manera","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($licencias->Export == "") { ?>
<div class="ewToolbar">
<?php if ($licencias->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if ($licencias_list->TotalRecs > 0 && $licencias_list->ExportOptions->Visible()) { ?>
<?php $licencias_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($licencias_list->SearchOptions->Visible()) { ?>
<?php $licencias_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($licencias_list->FilterOptions->Visible()) { ?>
<?php $licencias_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php if ($licencias->Export == "") { ?>
<?php echo $Language->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $licencias_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($licencias_list->TotalRecs <= 0)
			$licencias_list->TotalRecs = $licencias->SelectRecordCount();
	} else {
		if (!$licencias_list->Recordset && ($licencias_list->Recordset = $licencias_list->LoadRecordset()))
			$licencias_list->TotalRecs = $licencias_list->Recordset->RecordCount();
	}
	$licencias_list->StartRec = 1;
	if ($licencias_list->DisplayRecs <= 0 || ($licencias->Export <> "" && $licencias->ExportAll)) // Display all records
		$licencias_list->DisplayRecs = $licencias_list->TotalRecs;
	if (!($licencias->Export <> "" && $licencias->ExportAll))
		$licencias_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$licencias_list->Recordset = $licencias_list->LoadRecordset($licencias_list->StartRec-1, $licencias_list->DisplayRecs);

	// Set no record found message
	if ($licencias->CurrentAction == "" && $licencias_list->TotalRecs == 0) {
		if ($licencias_list->SearchWhere == "0=101")
			$licencias_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$licencias_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$licencias_list->RenderOtherOptions();
?>
<?php if ($Security->IsLoggedIn()) { ?>
<?php if ($licencias->Export == "" && $licencias->CurrentAction == "") { ?>
<form name="flicenciaslistsrch" id="flicenciaslistsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($licencias_list->SearchWhere <> "") ? " in" : " in"; ?>
<div id="flicenciaslistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="licencias">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$licencias_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$licencias->RowType = EW_ROWTYPE_SEARCH;

// Render row
$licencias->ResetAttrs();
$licencias_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($licencias->Id->Visible) { // Id ?>
	<div id="xsc_Id" class="ewCell form-group">
		<label for="x_Id" class="ewSearchCaption ewLabel"><?php echo $licencias->Id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Id" id="z_Id" value="="></span>
		<span class="ewSearchField">
<input type="text" data-table="licencias" data-field="x_Id" name="x_Id" id="x_Id" placeholder="<?php echo ew_HtmlEncode($licencias->Id->getPlaceHolder()) ?>" value="<?php echo $licencias->Id->EditValue ?>"<?php echo $licencias->Id->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($licencias->Entidad->Visible) { // Entidad ?>
	<div id="xsc_Entidad" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $licencias->Entidad->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_Entidad" id="z_Entidad" value="="></span>
		<span class="ewSearchField">
<div id="tp_x_Entidad" class="ewTemplate"><input type="radio" data-table="licencias" data-field="x_Entidad" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->Entidad->DisplayValueSeparator) ? json_encode($licencias->Entidad->DisplayValueSeparator) : $licencias->Entidad->DisplayValueSeparator) ?>" name="x_Entidad" id="x_Entidad" value="{value}"<?php echo $licencias->Entidad->EditAttributes() ?>></div>
<div id="dsl_x_Entidad" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->Entidad->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($licencias->Entidad->AdvancedSearch->SearchValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Entidad" name="x_Entidad" id="x_Entidad_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->Entidad->EditAttributes() ?>><?php echo $licencias->Entidad->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($licencias->Entidad->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Entidad" name="x_Entidad" id="x_Entidad_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($licencias->Entidad->CurrentValue) ?>" checked<?php echo $licencias->Entidad->EditAttributes() ?>><?php echo $licencias->Entidad->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
$sWhereWrk = "";
$licencias->Entidad->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->Entidad->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->Entidad, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->Entidad->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Entidad" id="s_x_Entidad" value="<?php echo $licencias->Entidad->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($licencias->Fecha_expedicion->Visible) { // Fecha_expedicion ?>
	<div id="xsc_Fecha_expedicion" class="ewCell form-group">
		<label for="x_Fecha_expedicion" class="ewSearchCaption ewLabel"><?php echo $licencias->Fecha_expedicion->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("BETWEEN") ?><input type="hidden" name="z_Fecha_expedicion" id="z_Fecha_expedicion" value="BETWEEN"></span>
		<span class="ewSearchField">
<input type="text" data-table="licencias" data-field="x_Fecha_expedicion" data-format="5" name="x_Fecha_expedicion" id="x_Fecha_expedicion" placeholder="<?php echo ew_HtmlEncode($licencias->Fecha_expedicion->getPlaceHolder()) ?>" value="<?php echo $licencias->Fecha_expedicion->EditValue ?>"<?php echo $licencias->Fecha_expedicion->EditAttributes() ?>>
<?php if (!$licencias->Fecha_expedicion->ReadOnly && !$licencias->Fecha_expedicion->Disabled && !isset($licencias->Fecha_expedicion->EditAttrs["readonly"]) && !isset($licencias->Fecha_expedicion->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateCalendar("flicenciaslistsrch", "x_Fecha_expedicion", "%Y/%m/%d");
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_Fecha_expedicion">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_Fecha_expedicion">
<input type="text" data-table="licencias" data-field="x_Fecha_expedicion" data-format="5" name="y_Fecha_expedicion" id="y_Fecha_expedicion" placeholder="<?php echo ew_HtmlEncode($licencias->Fecha_expedicion->getPlaceHolder()) ?>" value="<?php echo $licencias->Fecha_expedicion->EditValue2 ?>"<?php echo $licencias->Fecha_expedicion->EditAttributes() ?>>
<?php if (!$licencias->Fecha_expedicion->ReadOnly && !$licencias->Fecha_expedicion->Disabled && !isset($licencias->Fecha_expedicion->EditAttrs["readonly"]) && !isset($licencias->Fecha_expedicion->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateCalendar("flicenciaslistsrch", "y_Fecha_expedicion", "%Y/%m/%d");
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($licencias->Documento->Visible) { // Documento ?>
	<div id="xsc_Documento" class="ewCell form-group">
		<label for="x_Documento" class="ewSearchCaption ewLabel"><?php echo $licencias->Documento->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_Documento" id="z_Documento" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="licencias" data-field="x_Documento" name="x_Documento" id="x_Documento" size="30" maxlength="15" placeholder="<?php echo ew_HtmlEncode($licencias->Documento->getPlaceHolder()) ?>" value="<?php echo $licencias->Documento->EditValue ?>"<?php echo $licencias->Documento->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($licencias->No_certificado->Visible) { // No_certificado ?>
	<div id="xsc_No_certificado" class="ewCell form-group">
		<label for="x_No_certificado" class="ewSearchCaption ewLabel"><?php echo $licencias->No_certificado->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_No_certificado" id="z_No_certificado" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="licencias" data-field="x_No_certificado" name="x_No_certificado" id="x_No_certificado" size="30" maxlength="9" placeholder="<?php echo ew_HtmlEncode($licencias->No_certificado->getPlaceHolder()) ?>" value="<?php echo $licencias->No_certificado->EditValue ?>"<?php echo $licencias->No_certificado->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($licencias->p_manera_muerte->Visible) { // p_manera_muerte ?>
	<div id="xsc_p_manera_muerte" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $licencias->p_manera_muerte->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_p_manera_muerte" id="z_p_manera_muerte" value="="></span>
		<span class="ewSearchField">
<div id="tp_x_p_manera_muerte" class="ewTemplate"><input type="radio" data-table="licencias" data-field="x_p_manera_muerte" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->p_manera_muerte->DisplayValueSeparator) ? json_encode($licencias->p_manera_muerte->DisplayValueSeparator) : $licencias->p_manera_muerte->DisplayValueSeparator) ?>" name="x_p_manera_muerte" id="x_p_manera_muerte" value="{value}"<?php echo $licencias->p_manera_muerte->EditAttributes() ?>></div>
<div id="dsl_x_p_manera_muerte" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->p_manera_muerte->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($licencias->p_manera_muerte->AdvancedSearch->SearchValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_p_manera_muerte" name="x_p_manera_muerte" id="x_p_manera_muerte_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->p_manera_muerte->EditAttributes() ?>><?php echo $licencias->p_manera_muerte->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($licencias->p_manera_muerte->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_p_manera_muerte" name="x_p_manera_muerte" id="x_p_manera_muerte_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($licencias->p_manera_muerte->CurrentValue) ?>" checked<?php echo $licencias->p_manera_muerte->EditAttributes() ?>><?php echo $licencias->p_manera_muerte->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `probable_manera` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `p_manera_muerte`";
$sWhereWrk = "";
$licencias->p_manera_muerte->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->p_manera_muerte->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->p_manera_muerte, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->p_manera_muerte->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_p_manera_muerte" id="s_x_p_manera_muerte" value="<?php echo $licencias->p_manera_muerte->LookupFilterQuery() ?>">
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($licencias_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($licencias_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $licencias_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($licencias_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($licencias_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($licencias_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($licencias_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $licencias_list->ShowPageHeader(); ?>
<?php
$licencias_list->ShowMessage();
?>
<?php if ($licencias_list->TotalRecs > 0 || $licencias->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<?php if ($licencias->Export == "") { ?>
<div class="panel-heading ewGridUpperPanel">
<?php if ($licencias->CurrentAction <> "gridadd" && $licencias->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($licencias_list->Pager)) $licencias_list->Pager = new cPrevNextPager($licencias_list->StartRec, $licencias_list->DisplayRecs, $licencias_list->TotalRecs) ?>
<?php if ($licencias_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($licencias_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $licencias_list->PageUrl() ?>start=<?php echo $licencias_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($licencias_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $licencias_list->PageUrl() ?>start=<?php echo $licencias_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $licencias_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($licencias_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $licencias_list->PageUrl() ?>start=<?php echo $licencias_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($licencias_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $licencias_list->PageUrl() ?>start=<?php echo $licencias_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $licencias_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $licencias_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $licencias_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $licencias_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($licencias_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="flicenciaslist" id="flicenciaslist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($licencias_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $licencias_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="licencias">
<div id="gmp_licencias" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($licencias_list->TotalRecs > 0) { ?>
<table id="tbl_licenciaslist" class="table ewTable">
<?php echo $licencias->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$licencias_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$licencias_list->RenderListOptions();

// Render list options (header, left)
$licencias_list->ListOptions->Render("header", "left");
?>
<?php if ($licencias->Id->Visible) { // Id ?>
	<?php if ($licencias->SortUrl($licencias->Id) == "") { ?>
		<th data-name="Id"><div id="elh_licencias_Id" class="licencias_Id"><div class="ewTableHeaderCaption"><?php echo $licencias->Id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Id"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Id) ?>',1);"><div id="elh_licencias_Id" class="licencias_Id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->Id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Entidad->Visible) { // Entidad ?>
	<?php if ($licencias->SortUrl($licencias->Entidad) == "") { ?>
		<th data-name="Entidad"><div id="elh_licencias_Entidad" class="licencias_Entidad"><div class="ewTableHeaderCaption"><?php echo $licencias->Entidad->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Entidad"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Entidad) ?>',1);"><div id="elh_licencias_Entidad" class="licencias_Entidad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->Entidad->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Entidad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Entidad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Fecha_expedicion->Visible) { // Fecha_expedicion ?>
	<?php if ($licencias->SortUrl($licencias->Fecha_expedicion) == "") { ?>
		<th data-name="Fecha_expedicion"><div id="elh_licencias_Fecha_expedicion" class="licencias_Fecha_expedicion"><div class="ewTableHeaderCaption"><?php echo $licencias->Fecha_expedicion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_expedicion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Fecha_expedicion) ?>',1);"><div id="elh_licencias_Fecha_expedicion" class="licencias_Fecha_expedicion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->Fecha_expedicion->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Fecha_expedicion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Fecha_expedicion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->tipo_muerte->Visible) { // tipo_muerte ?>
	<?php if ($licencias->SortUrl($licencias->tipo_muerte) == "") { ?>
		<th data-name="tipo_muerte"><div id="elh_licencias_tipo_muerte" class="licencias_tipo_muerte"><div class="ewTableHeaderCaption"><?php echo $licencias->tipo_muerte->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tipo_muerte"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->tipo_muerte) ?>',1);"><div id="elh_licencias_tipo_muerte" class="licencias_tipo_muerte">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->tipo_muerte->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->tipo_muerte->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->tipo_muerte->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Documento->Visible) { // Documento ?>
	<?php if ($licencias->SortUrl($licencias->Documento) == "") { ?>
		<th data-name="Documento"><div id="elh_licencias_Documento" class="licencias_Documento"><div class="ewTableHeaderCaption"><?php echo $licencias->Documento->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Documento"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Documento) ?>',1);"><div id="elh_licencias_Documento" class="licencias_Documento">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->Documento->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Documento->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Documento->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Nombres->Visible) { // Nombres ?>
	<?php if ($licencias->SortUrl($licencias->Nombres) == "") { ?>
		<th data-name="Nombres"><div id="elh_licencias_Nombres" class="licencias_Nombres"><div class="ewTableHeaderCaption"><?php echo $licencias->Nombres->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nombres"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Nombres) ?>',1);"><div id="elh_licencias_Nombres" class="licencias_Nombres">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->Nombres->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Nombres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Nombres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Apellidos->Visible) { // Apellidos ?>
	<?php if ($licencias->SortUrl($licencias->Apellidos) == "") { ?>
		<th data-name="Apellidos"><div id="elh_licencias_Apellidos" class="licencias_Apellidos"><div class="ewTableHeaderCaption"><?php echo $licencias->Apellidos->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Apellidos"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Apellidos) ?>',1);"><div id="elh_licencias_Apellidos" class="licencias_Apellidos">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->Apellidos->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Apellidos->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Apellidos->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->No_certificado->Visible) { // No_certificado ?>
	<?php if ($licencias->SortUrl($licencias->No_certificado) == "") { ?>
		<th data-name="No_certificado"><div id="elh_licencias_No_certificado" class="licencias_No_certificado"><div class="ewTableHeaderCaption"><?php echo $licencias->No_certificado->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="No_certificado"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->No_certificado) ?>',1);"><div id="elh_licencias_No_certificado" class="licencias_No_certificado">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->No_certificado->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($licencias->No_certificado->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->No_certificado->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Fecha_Fallecimiento->Visible) { // Fecha_Fallecimiento ?>
	<?php if ($licencias->SortUrl($licencias->Fecha_Fallecimiento) == "") { ?>
		<th data-name="Fecha_Fallecimiento"><div id="elh_licencias_Fecha_Fallecimiento" class="licencias_Fecha_Fallecimiento"><div class="ewTableHeaderCaption"><?php echo $licencias->Fecha_Fallecimiento->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_Fallecimiento"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Fecha_Fallecimiento) ?>',1);"><div id="elh_licencias_Fecha_Fallecimiento" class="licencias_Fecha_Fallecimiento">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->Fecha_Fallecimiento->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Fecha_Fallecimiento->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Fecha_Fallecimiento->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->p_manera_muerte->Visible) { // p_manera_muerte ?>
	<?php if ($licencias->SortUrl($licencias->p_manera_muerte) == "") { ?>
		<th data-name="p_manera_muerte"><div id="elh_licencias_p_manera_muerte" class="licencias_p_manera_muerte"><div class="ewTableHeaderCaption"><?php echo $licencias->p_manera_muerte->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="p_manera_muerte"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->p_manera_muerte) ?>',1);"><div id="elh_licencias_p_manera_muerte" class="licencias_p_manera_muerte">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->p_manera_muerte->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->p_manera_muerte->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->p_manera_muerte->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Registrado_por->Visible) { // Registrado_por ?>
	<?php if ($licencias->SortUrl($licencias->Registrado_por) == "") { ?>
		<th data-name="Registrado_por"><div id="elh_licencias_Registrado_por" class="licencias_Registrado_por"><div class="ewTableHeaderCaption" style="white-space: nowrap;"><?php echo $licencias->Registrado_por->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Registrado_por"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Registrado_por) ?>',1);"><div id="elh_licencias_Registrado_por" class="licencias_Registrado_por">
			<div class="ewTableHeaderBtn" style="white-space: nowrap;"><span class="ewTableHeaderCaption"><?php echo $licencias->Registrado_por->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Registrado_por->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Registrado_por->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->Fecha_registro->Visible) { // Fecha_registro ?>
	<?php if ($licencias->SortUrl($licencias->Fecha_registro) == "") { ?>
		<th data-name="Fecha_registro"><div id="elh_licencias_Fecha_registro" class="licencias_Fecha_registro"><div class="ewTableHeaderCaption" style="white-space: nowrap;"><?php echo $licencias->Fecha_registro->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Fecha_registro"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->Fecha_registro) ?>',1);"><div id="elh_licencias_Fecha_registro" class="licencias_Fecha_registro">
			<div class="ewTableHeaderBtn" style="white-space: nowrap;"><span class="ewTableHeaderCaption"><?php echo $licencias->Fecha_registro->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->Fecha_registro->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->Fecha_registro->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->fecha_edicion->Visible) { // fecha_edicion ?>
	<?php if ($licencias->SortUrl($licencias->fecha_edicion) == "") { ?>
		<th data-name="fecha_edicion"><div id="elh_licencias_fecha_edicion" class="licencias_fecha_edicion"><div class="ewTableHeaderCaption"><?php echo $licencias->fecha_edicion->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fecha_edicion"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->fecha_edicion) ?>',1);"><div id="elh_licencias_fecha_edicion" class="licencias_fecha_edicion">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->fecha_edicion->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($licencias->fecha_edicion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->fecha_edicion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($licencias->usuario_edita->Visible) { // usuario_edita ?>
	<?php if ($licencias->SortUrl($licencias->usuario_edita) == "") { ?>
		<th data-name="usuario_edita"><div id="elh_licencias_usuario_edita" class="licencias_usuario_edita"><div class="ewTableHeaderCaption"><?php echo $licencias->usuario_edita->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="usuario_edita"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $licencias->SortUrl($licencias->usuario_edita) ?>',1);"><div id="elh_licencias_usuario_edita" class="licencias_usuario_edita">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $licencias->usuario_edita->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($licencias->usuario_edita->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($licencias->usuario_edita->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$licencias_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($licencias->ExportAll && $licencias->Export <> "") {
	$licencias_list->StopRec = $licencias_list->TotalRecs;
} else {

	// Set the last record to display
	if ($licencias_list->TotalRecs > $licencias_list->StartRec + $licencias_list->DisplayRecs - 1)
		$licencias_list->StopRec = $licencias_list->StartRec + $licencias_list->DisplayRecs - 1;
	else
		$licencias_list->StopRec = $licencias_list->TotalRecs;
}
$licencias_list->RecCnt = $licencias_list->StartRec - 1;
if ($licencias_list->Recordset && !$licencias_list->Recordset->EOF) {
	$licencias_list->Recordset->MoveFirst();
	$bSelectLimit = $licencias_list->UseSelectLimit;
	if (!$bSelectLimit && $licencias_list->StartRec > 1)
		$licencias_list->Recordset->Move($licencias_list->StartRec - 1);
} elseif (!$licencias->AllowAddDeleteRow && $licencias_list->StopRec == 0) {
	$licencias_list->StopRec = $licencias->GridAddRowCount;
}

// Initialize aggregate
$licencias->RowType = EW_ROWTYPE_AGGREGATEINIT;
$licencias->ResetAttrs();
$licencias_list->RenderRow();
while ($licencias_list->RecCnt < $licencias_list->StopRec) {
	$licencias_list->RecCnt++;
	if (intval($licencias_list->RecCnt) >= intval($licencias_list->StartRec)) {
		$licencias_list->RowCnt++;

		// Set up key count
		$licencias_list->KeyCount = $licencias_list->RowIndex;

		// Init row class and style
		$licencias->ResetAttrs();
		$licencias->CssClass = "";
		if ($licencias->CurrentAction == "gridadd") {
		} else {
			$licencias_list->LoadRowValues($licencias_list->Recordset); // Load row values
		}
		$licencias->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$licencias->RowAttrs = array_merge($licencias->RowAttrs, array('data-rowindex'=>$licencias_list->RowCnt, 'id'=>'r' . $licencias_list->RowCnt . '_licencias', 'data-rowtype'=>$licencias->RowType));

		// Render row
		$licencias_list->RenderRow();

		// Render list options
		$licencias_list->RenderListOptions();
?>
	<tr<?php echo $licencias->RowAttributes() ?>>
<?php

// Render list options (body, left)
$licencias_list->ListOptions->Render("body", "left", $licencias_list->RowCnt);
?>
	<?php if ($licencias->Id->Visible) { // Id ?>
		<td data-name="Id"<?php echo $licencias->Id->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Id" class="licencias_Id">
<span<?php echo $licencias->Id->ViewAttributes() ?>>
<?php echo $licencias->Id->ListViewValue() ?></span>
</span>
<a id="<?php echo $licencias_list->PageObjName . "_row_" . $licencias_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($licencias->Entidad->Visible) { // Entidad ?>
		<td data-name="Entidad"<?php echo $licencias->Entidad->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Entidad" class="licencias_Entidad">
<span<?php echo $licencias->Entidad->ViewAttributes() ?>>
<?php echo $licencias->Entidad->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->Fecha_expedicion->Visible) { // Fecha_expedicion ?>
		<td data-name="Fecha_expedicion"<?php echo $licencias->Fecha_expedicion->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Fecha_expedicion" class="licencias_Fecha_expedicion">
<span<?php echo $licencias->Fecha_expedicion->ViewAttributes() ?>>
<?php echo $licencias->Fecha_expedicion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->tipo_muerte->Visible) { // tipo_muerte ?>
		<td data-name="tipo_muerte"<?php echo $licencias->tipo_muerte->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_tipo_muerte" class="licencias_tipo_muerte">
<span<?php echo $licencias->tipo_muerte->ViewAttributes() ?>>
<?php echo $licencias->tipo_muerte->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->Documento->Visible) { // Documento ?>
		<td data-name="Documento"<?php echo $licencias->Documento->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Documento" class="licencias_Documento">
<span<?php echo $licencias->Documento->ViewAttributes() ?>>
<?php echo $licencias->Documento->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->Nombres->Visible) { // Nombres ?>
		<td data-name="Nombres"<?php echo $licencias->Nombres->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Nombres" class="licencias_Nombres">
<span<?php echo $licencias->Nombres->ViewAttributes() ?>>
<?php echo $licencias->Nombres->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->Apellidos->Visible) { // Apellidos ?>
		<td data-name="Apellidos"<?php echo $licencias->Apellidos->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Apellidos" class="licencias_Apellidos">
<span<?php echo $licencias->Apellidos->ViewAttributes() ?>>
<?php echo $licencias->Apellidos->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->No_certificado->Visible) { // No_certificado ?>
		<td data-name="No_certificado"<?php echo $licencias->No_certificado->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_No_certificado" class="licencias_No_certificado">
<span<?php echo $licencias->No_certificado->ViewAttributes() ?>>
<?php echo $licencias->No_certificado->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->Fecha_Fallecimiento->Visible) { // Fecha_Fallecimiento ?>
		<td data-name="Fecha_Fallecimiento"<?php echo $licencias->Fecha_Fallecimiento->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Fecha_Fallecimiento" class="licencias_Fecha_Fallecimiento">
<span<?php echo $licencias->Fecha_Fallecimiento->ViewAttributes() ?>>
<?php echo $licencias->Fecha_Fallecimiento->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->p_manera_muerte->Visible) { // p_manera_muerte ?>
		<td data-name="p_manera_muerte"<?php echo $licencias->p_manera_muerte->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_p_manera_muerte" class="licencias_p_manera_muerte">
<span<?php echo $licencias->p_manera_muerte->ViewAttributes() ?>>
<?php echo $licencias->p_manera_muerte->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->Registrado_por->Visible) { // Registrado_por ?>
		<td data-name="Registrado_por"<?php echo $licencias->Registrado_por->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Registrado_por" class="licencias_Registrado_por">
<span<?php echo $licencias->Registrado_por->ViewAttributes() ?>>
<?php echo $licencias->Registrado_por->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->Fecha_registro->Visible) { // Fecha_registro ?>
		<td data-name="Fecha_registro"<?php echo $licencias->Fecha_registro->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_Fecha_registro" class="licencias_Fecha_registro">
<span<?php echo $licencias->Fecha_registro->ViewAttributes() ?>>
<?php echo $licencias->Fecha_registro->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->fecha_edicion->Visible) { // fecha_edicion ?>
		<td data-name="fecha_edicion"<?php echo $licencias->fecha_edicion->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_fecha_edicion" class="licencias_fecha_edicion">
<span<?php echo $licencias->fecha_edicion->ViewAttributes() ?>>
<?php echo $licencias->fecha_edicion->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($licencias->usuario_edita->Visible) { // usuario_edita ?>
		<td data-name="usuario_edita"<?php echo $licencias->usuario_edita->CellAttributes() ?>>
<span id="el<?php echo $licencias_list->RowCnt ?>_licencias_usuario_edita" class="licencias_usuario_edita">
<span<?php echo $licencias->usuario_edita->ViewAttributes() ?>>
<?php echo $licencias->usuario_edita->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$licencias_list->ListOptions->Render("body", "right", $licencias_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($licencias->CurrentAction <> "gridadd")
		$licencias_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($licencias->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($licencias_list->Recordset)
	$licencias_list->Recordset->Close();
?>
</div>
<?php } ?>
<?php if ($licencias_list->TotalRecs == 0 && $licencias->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($licencias_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($licencias->Export == "") { ?>
<script type="text/javascript">
flicenciaslistsrch.Init();
flicenciaslistsrch.FilterList = <?php echo $licencias_list->GetFilterList() ?>;
flicenciaslist.Init();
</script>
<?php } ?>
<?php
$licencias_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($licencias->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$licencias_list->Page_Terminate();
?>
