<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "licenciasinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$licencias_add = NULL; // Initialize page object first

class clicencias_add extends clicencias {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{2C10691D-1A6E-4ED4-86F3-F3EE71B5418C}";

	// Table name
	var $TableName = 'licencias';

	// Page object name
	var $PageObjName = 'licencias_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (licencias)
		if (!isset($GLOBALS["licencias"]) || get_class($GLOBALS["licencias"]) == "clicencias") {
			$GLOBALS["licencias"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["licencias"];
		}

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'licencias', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("licenciaslist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Set up multi page object
		$this->SetupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $licencias;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($licencias);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;
	var $MultiPages; // Multi pages object

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["Id"] != "") {
				$this->Id->setQueryStringValue($_GET["Id"]);
				$this->setKey("Id", $this->Id->CurrentValue); // Set up key
			} else {
				$this->setKey("Id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		} else {
			if ($this->CurrentAction == "I") // Load default values for blank record
				$this->LoadDefaultValues();
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("licenciaslist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->GetViewUrl();
					if (ew_GetPageName($sReturnUrl) == "licenciaslist.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to list page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "licenciasview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		$this->Entidad->CurrentValue = NULL;
		$this->Entidad->OldValue = $this->Entidad->CurrentValue;
		$this->IPS2FMEDICO->CurrentValue = NULL;
		$this->IPS2FMEDICO->OldValue = $this->IPS2FMEDICO->CurrentValue;
		$this->Logo->CurrentValue = "foto.png";
		$this->Fecha_expedicion->CurrentValue = NULL;
		$this->Fecha_expedicion->OldValue = $this->Fecha_expedicion->CurrentValue;
		$this->Dpto_expedicion->CurrentValue = "CALDAS";
		$this->Mun_expedicion->CurrentValue = "MANIZALES";
		$this->tipo_muerte->CurrentValue = NULL;
		$this->tipo_muerte->OldValue = $this->tipo_muerte->CurrentValue;
		$this->Documento->CurrentValue = NULL;
		$this->Documento->OldValue = $this->Documento->CurrentValue;
		$this->Tipo_doc->CurrentValue = NULL;
		$this->Tipo_doc->OldValue = $this->Tipo_doc->CurrentValue;
		$this->Nombres->CurrentValue = NULL;
		$this->Nombres->OldValue = $this->Nombres->CurrentValue;
		$this->Apellidos->CurrentValue = NULL;
		$this->Apellidos->OldValue = $this->Apellidos->CurrentValue;
		$this->Genero->CurrentValue = NULL;
		$this->Genero->OldValue = $this->Genero->CurrentValue;
		$this->No_certificado->CurrentValue = NULL;
		$this->No_certificado->OldValue = $this->No_certificado->CurrentValue;
		$this->Fecha_Fallecimiento->CurrentValue = NULL;
		$this->Fecha_Fallecimiento->OldValue = $this->Fecha_Fallecimiento->CurrentValue;
		$this->p_manera_muerte->CurrentValue = NULL;
		$this->p_manera_muerte->OldValue = $this->p_manera_muerte->CurrentValue;
		$this->Edad->CurrentValue = NULL;
		$this->Edad->OldValue = $this->Edad->CurrentValue;
		$this->Tipo_edad->CurrentValue = NULL;
		$this->Tipo_edad->OldValue = $this->Tipo_edad->CurrentValue;
		$this->Nombre_solicitante->CurrentValue = NULL;
		$this->Nombre_solicitante->OldValue = $this->Nombre_solicitante->CurrentValue;
		$this->Funcionario_expide->CurrentValue = NULL;
		$this->Funcionario_expide->OldValue = $this->Funcionario_expide->CurrentValue;
		$this->Permiso_inhumar->CurrentValue = NULL;
		$this->Permiso_inhumar->OldValue = $this->Permiso_inhumar->CurrentValue;
		$this->Permiso_cremar->CurrentValue = NULL;
		$this->Permiso_cremar->OldValue = $this->Permiso_cremar->CurrentValue;
		$this->Firma_funcionario->CurrentValue = NULL;
		$this->Firma_funcionario->OldValue = $this->Firma_funcionario->CurrentValue;
		$this->Codigo_qr->CurrentValue = NULL;
		$this->Codigo_qr->OldValue = $this->Codigo_qr->CurrentValue;
		$this->Verificacion_codigo_qr->CurrentValue = "Esta licencia esta avalada por la Secretaria de Salud Publica de Manizales-El codigo QR Corresponde al Consecutivo de la licencia de inhumacion-verificarlo a traves de aplicacion en smartphone";
		$this->Registrado_por->CurrentValue = NULL;
		$this->Registrado_por->OldValue = $this->Registrado_por->CurrentValue;
		$this->Fecha_registro->CurrentValue = NULL;
		$this->Fecha_registro->OldValue = $this->Fecha_registro->CurrentValue;
		$this->Mensaje_manual->CurrentValue = "Esta licencia de inhumacion es una licencia validada por la Secretaria de Salud de Manizales como plan de contingencia";
		$this->observaciones->CurrentValue = NULL;
		$this->observaciones->OldValue = $this->observaciones->CurrentValue;
		$this->fecha_edicion->CurrentValue = NULL;
		$this->fecha_edicion->OldValue = $this->fecha_edicion->CurrentValue;
		$this->usuario_edita->CurrentValue = NULL;
		$this->usuario_edita->OldValue = $this->usuario_edita->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->Entidad->FldIsDetailKey) {
			$this->Entidad->setFormValue($objForm->GetValue("x_Entidad"));
		}
		if (!$this->IPS2FMEDICO->FldIsDetailKey) {
			$this->IPS2FMEDICO->setFormValue($objForm->GetValue("x_IPS2FMEDICO"));
		}
		if (!$this->Logo->FldIsDetailKey) {
			$this->Logo->setFormValue($objForm->GetValue("x_Logo"));
		}
		if (!$this->Fecha_expedicion->FldIsDetailKey) {
			$this->Fecha_expedicion->setFormValue($objForm->GetValue("x_Fecha_expedicion"));
			$this->Fecha_expedicion->CurrentValue = ew_UnFormatDateTime($this->Fecha_expedicion->CurrentValue, 5);
		}
		if (!$this->Dpto_expedicion->FldIsDetailKey) {
			$this->Dpto_expedicion->setFormValue($objForm->GetValue("x_Dpto_expedicion"));
		}
		if (!$this->Mun_expedicion->FldIsDetailKey) {
			$this->Mun_expedicion->setFormValue($objForm->GetValue("x_Mun_expedicion"));
		}
		if (!$this->tipo_muerte->FldIsDetailKey) {
			$this->tipo_muerte->setFormValue($objForm->GetValue("x_tipo_muerte"));
		}
		if (!$this->Documento->FldIsDetailKey) {
			$this->Documento->setFormValue($objForm->GetValue("x_Documento"));
		}
		if (!$this->Tipo_doc->FldIsDetailKey) {
			$this->Tipo_doc->setFormValue($objForm->GetValue("x_Tipo_doc"));
		}
		if (!$this->Nombres->FldIsDetailKey) {
			$this->Nombres->setFormValue($objForm->GetValue("x_Nombres"));
		}
		if (!$this->Apellidos->FldIsDetailKey) {
			$this->Apellidos->setFormValue($objForm->GetValue("x_Apellidos"));
		}
		if (!$this->Genero->FldIsDetailKey) {
			$this->Genero->setFormValue($objForm->GetValue("x_Genero"));
		}
		if (!$this->No_certificado->FldIsDetailKey) {
			$this->No_certificado->setFormValue($objForm->GetValue("x_No_certificado"));
		}
		if (!$this->Fecha_Fallecimiento->FldIsDetailKey) {
			$this->Fecha_Fallecimiento->setFormValue($objForm->GetValue("x_Fecha_Fallecimiento"));
			$this->Fecha_Fallecimiento->CurrentValue = ew_UnFormatDateTime($this->Fecha_Fallecimiento->CurrentValue, 5);
		}
		if (!$this->p_manera_muerte->FldIsDetailKey) {
			$this->p_manera_muerte->setFormValue($objForm->GetValue("x_p_manera_muerte"));
		}
		if (!$this->Edad->FldIsDetailKey) {
			$this->Edad->setFormValue($objForm->GetValue("x_Edad"));
		}
		if (!$this->Tipo_edad->FldIsDetailKey) {
			$this->Tipo_edad->setFormValue($objForm->GetValue("x_Tipo_edad"));
		}
		if (!$this->Nombre_solicitante->FldIsDetailKey) {
			$this->Nombre_solicitante->setFormValue($objForm->GetValue("x_Nombre_solicitante"));
		}
		if (!$this->Funcionario_expide->FldIsDetailKey) {
			$this->Funcionario_expide->setFormValue($objForm->GetValue("x_Funcionario_expide"));
		}
		if (!$this->Permiso_inhumar->FldIsDetailKey) {
			$this->Permiso_inhumar->setFormValue($objForm->GetValue("x_Permiso_inhumar"));
		}
		if (!$this->Permiso_cremar->FldIsDetailKey) {
			$this->Permiso_cremar->setFormValue($objForm->GetValue("x_Permiso_cremar"));
		}
		if (!$this->Firma_funcionario->FldIsDetailKey) {
			$this->Firma_funcionario->setFormValue($objForm->GetValue("x_Firma_funcionario"));
		}
		if (!$this->Codigo_qr->FldIsDetailKey) {
			$this->Codigo_qr->setFormValue($objForm->GetValue("x_Codigo_qr"));
		}
		if (!$this->Verificacion_codigo_qr->FldIsDetailKey) {
			$this->Verificacion_codigo_qr->setFormValue($objForm->GetValue("x_Verificacion_codigo_qr"));
		}
		if (!$this->Registrado_por->FldIsDetailKey) {
			$this->Registrado_por->setFormValue($objForm->GetValue("x_Registrado_por"));
		}
		if (!$this->Fecha_registro->FldIsDetailKey) {
			$this->Fecha_registro->setFormValue($objForm->GetValue("x_Fecha_registro"));
			$this->Fecha_registro->CurrentValue = ew_UnFormatDateTime($this->Fecha_registro->CurrentValue, 5);
		}
		if (!$this->Mensaje_manual->FldIsDetailKey) {
			$this->Mensaje_manual->setFormValue($objForm->GetValue("x_Mensaje_manual"));
		}
		if (!$this->observaciones->FldIsDetailKey) {
			$this->observaciones->setFormValue($objForm->GetValue("x_observaciones"));
		}
		if (!$this->fecha_edicion->FldIsDetailKey) {
			$this->fecha_edicion->setFormValue($objForm->GetValue("x_fecha_edicion"));
			$this->fecha_edicion->CurrentValue = ew_UnFormatDateTime($this->fecha_edicion->CurrentValue, 5);
		}
		if (!$this->usuario_edita->FldIsDetailKey) {
			$this->usuario_edita->setFormValue($objForm->GetValue("x_usuario_edita"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->Entidad->CurrentValue = $this->Entidad->FormValue;
		$this->IPS2FMEDICO->CurrentValue = $this->IPS2FMEDICO->FormValue;
		$this->Logo->CurrentValue = $this->Logo->FormValue;
		$this->Fecha_expedicion->CurrentValue = $this->Fecha_expedicion->FormValue;
		$this->Fecha_expedicion->CurrentValue = ew_UnFormatDateTime($this->Fecha_expedicion->CurrentValue, 5);
		$this->Dpto_expedicion->CurrentValue = $this->Dpto_expedicion->FormValue;
		$this->Mun_expedicion->CurrentValue = $this->Mun_expedicion->FormValue;
		$this->tipo_muerte->CurrentValue = $this->tipo_muerte->FormValue;
		$this->Documento->CurrentValue = $this->Documento->FormValue;
		$this->Tipo_doc->CurrentValue = $this->Tipo_doc->FormValue;
		$this->Nombres->CurrentValue = $this->Nombres->FormValue;
		$this->Apellidos->CurrentValue = $this->Apellidos->FormValue;
		$this->Genero->CurrentValue = $this->Genero->FormValue;
		$this->No_certificado->CurrentValue = $this->No_certificado->FormValue;
		$this->Fecha_Fallecimiento->CurrentValue = $this->Fecha_Fallecimiento->FormValue;
		$this->Fecha_Fallecimiento->CurrentValue = ew_UnFormatDateTime($this->Fecha_Fallecimiento->CurrentValue, 5);
		$this->p_manera_muerte->CurrentValue = $this->p_manera_muerte->FormValue;
		$this->Edad->CurrentValue = $this->Edad->FormValue;
		$this->Tipo_edad->CurrentValue = $this->Tipo_edad->FormValue;
		$this->Nombre_solicitante->CurrentValue = $this->Nombre_solicitante->FormValue;
		$this->Funcionario_expide->CurrentValue = $this->Funcionario_expide->FormValue;
		$this->Permiso_inhumar->CurrentValue = $this->Permiso_inhumar->FormValue;
		$this->Permiso_cremar->CurrentValue = $this->Permiso_cremar->FormValue;
		$this->Firma_funcionario->CurrentValue = $this->Firma_funcionario->FormValue;
		$this->Codigo_qr->CurrentValue = $this->Codigo_qr->FormValue;
		$this->Verificacion_codigo_qr->CurrentValue = $this->Verificacion_codigo_qr->FormValue;
		$this->Registrado_por->CurrentValue = $this->Registrado_por->FormValue;
		$this->Fecha_registro->CurrentValue = $this->Fecha_registro->FormValue;
		$this->Fecha_registro->CurrentValue = ew_UnFormatDateTime($this->Fecha_registro->CurrentValue, 5);
		$this->Mensaje_manual->CurrentValue = $this->Mensaje_manual->FormValue;
		$this->observaciones->CurrentValue = $this->observaciones->FormValue;
		$this->fecha_edicion->CurrentValue = $this->fecha_edicion->FormValue;
		$this->fecha_edicion->CurrentValue = ew_UnFormatDateTime($this->fecha_edicion->CurrentValue, 5);
		$this->usuario_edita->CurrentValue = $this->usuario_edita->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id->setDbValue($rs->fields('Id'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->IPS2FMEDICO->setDbValue($rs->fields('IPS/MEDICO'));
		$this->Logo->setDbValue($rs->fields('Logo'));
		$this->Fecha_expedicion->setDbValue($rs->fields('Fecha_expedicion'));
		$this->Dpto_expedicion->setDbValue($rs->fields('Dpto_expedicion'));
		$this->Mun_expedicion->setDbValue($rs->fields('Mun_expedicion'));
		$this->tipo_muerte->setDbValue($rs->fields('tipo_muerte'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Tipo_doc->setDbValue($rs->fields('Tipo_doc'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->No_certificado->setDbValue($rs->fields('No_certificado'));
		$this->Fecha_Fallecimiento->setDbValue($rs->fields('Fecha_Fallecimiento'));
		$this->p_manera_muerte->setDbValue($rs->fields('p_manera_muerte'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Tipo_edad->setDbValue($rs->fields('Tipo_edad'));
		$this->Nombre_solicitante->setDbValue($rs->fields('Nombre_solicitante'));
		$this->Funcionario_expide->setDbValue($rs->fields('Funcionario_expide'));
		$this->Permiso_inhumar->setDbValue($rs->fields('Permiso_inhumar'));
		$this->Permiso_cremar->setDbValue($rs->fields('Permiso_cremar'));
		$this->Firma_funcionario->setDbValue($rs->fields('Firma_funcionario'));
		$this->Codigo_qr->setDbValue($rs->fields('Codigo_qr'));
		$this->Verificacion_codigo_qr->setDbValue($rs->fields('Verificacion_codigo_qr'));
		$this->Registrado_por->setDbValue($rs->fields('Registrado_por'));
		$this->Fecha_registro->setDbValue($rs->fields('Fecha_registro'));
		$this->Mensaje_manual->setDbValue($rs->fields('Mensaje_manual'));
		$this->estado_licencia->setDbValue($rs->fields('estado_licencia'));
		$this->Entidad_dirige_licencia->setDbValue($rs->fields('Entidad_dirige_licencia'));
		$this->observaciones->setDbValue($rs->fields('observaciones'));
		$this->fecha_edicion->setDbValue($rs->fields('fecha_edicion'));
		$this->usuario_edita->setDbValue($rs->fields('usuario_edita'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id->DbValue = $row['Id'];
		$this->Entidad->DbValue = $row['Entidad'];
		$this->IPS2FMEDICO->DbValue = $row['IPS/MEDICO'];
		$this->Logo->DbValue = $row['Logo'];
		$this->Fecha_expedicion->DbValue = $row['Fecha_expedicion'];
		$this->Dpto_expedicion->DbValue = $row['Dpto_expedicion'];
		$this->Mun_expedicion->DbValue = $row['Mun_expedicion'];
		$this->tipo_muerte->DbValue = $row['tipo_muerte'];
		$this->Documento->DbValue = $row['Documento'];
		$this->Tipo_doc->DbValue = $row['Tipo_doc'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Genero->DbValue = $row['Genero'];
		$this->No_certificado->DbValue = $row['No_certificado'];
		$this->Fecha_Fallecimiento->DbValue = $row['Fecha_Fallecimiento'];
		$this->p_manera_muerte->DbValue = $row['p_manera_muerte'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Tipo_edad->DbValue = $row['Tipo_edad'];
		$this->Nombre_solicitante->DbValue = $row['Nombre_solicitante'];
		$this->Funcionario_expide->DbValue = $row['Funcionario_expide'];
		$this->Permiso_inhumar->DbValue = $row['Permiso_inhumar'];
		$this->Permiso_cremar->DbValue = $row['Permiso_cremar'];
		$this->Firma_funcionario->DbValue = $row['Firma_funcionario'];
		$this->Codigo_qr->DbValue = $row['Codigo_qr'];
		$this->Verificacion_codigo_qr->DbValue = $row['Verificacion_codigo_qr'];
		$this->Registrado_por->DbValue = $row['Registrado_por'];
		$this->Fecha_registro->DbValue = $row['Fecha_registro'];
		$this->Mensaje_manual->DbValue = $row['Mensaje_manual'];
		$this->estado_licencia->DbValue = $row['estado_licencia'];
		$this->Entidad_dirige_licencia->DbValue = $row['Entidad_dirige_licencia'];
		$this->observaciones->DbValue = $row['observaciones'];
		$this->fecha_edicion->DbValue = $row['fecha_edicion'];
		$this->usuario_edita->DbValue = $row['usuario_edita'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("Id")) <> "")
			$this->Id->CurrentValue = $this->getKey("Id"); // Id
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Id
		// Entidad
		// IPS/MEDICO
		// Logo
		// Fecha_expedicion
		// Dpto_expedicion
		// Mun_expedicion
		// tipo_muerte
		// Documento
		// Tipo_doc
		// Nombres
		// Apellidos
		// Genero
		// No_certificado
		// Fecha_Fallecimiento
		// p_manera_muerte
		// Edad
		// Tipo_edad
		// Nombre_solicitante
		// Funcionario_expide
		// Permiso_inhumar
		// Permiso_cremar
		// Firma_funcionario
		// Codigo_qr
		// Verificacion_codigo_qr
		// Registrado_por
		// Fecha_registro
		// Mensaje_manual
		// estado_licencia
		// Entidad_dirige_licencia
		// observaciones
		// fecha_edicion
		// usuario_edita

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Id
		$this->Id->ViewValue = $this->Id->CurrentValue;
		$this->Id->ViewCustomAttributes = "";

		// Entidad
		if (strval($this->Entidad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Entidad->ViewValue = $this->Entidad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
			}
		} else {
			$this->Entidad->ViewValue = NULL;
		}
		$this->Entidad->ViewCustomAttributes = "";

		// IPS/MEDICO
		$this->IPS2FMEDICO->ViewValue = $this->IPS2FMEDICO->CurrentValue;
		$this->IPS2FMEDICO->ViewCustomAttributes = "";

		// Logo
		$this->Logo->ViewValue = $this->Logo->CurrentValue;
		$this->Logo->ViewCustomAttributes = "";

		// Fecha_expedicion
		$this->Fecha_expedicion->ViewValue = $this->Fecha_expedicion->CurrentValue;
		$this->Fecha_expedicion->ViewValue = ew_FormatDateTime($this->Fecha_expedicion->ViewValue, 5);
		$this->Fecha_expedicion->ViewCustomAttributes = "";

		// Dpto_expedicion
		$this->Dpto_expedicion->ViewValue = $this->Dpto_expedicion->CurrentValue;
		$this->Dpto_expedicion->ViewCustomAttributes = "";

		// Mun_expedicion
		$this->Mun_expedicion->ViewValue = $this->Mun_expedicion->CurrentValue;
		$this->Mun_expedicion->ViewCustomAttributes = "";

		// tipo_muerte
		if (strval($this->tipo_muerte->CurrentValue) <> "") {
			$arwrk = explode(",", $this->tipo_muerte->CurrentValue);
			$sFilterWrk = "";
			foreach ($arwrk as $wrk) {
				if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
				$sFilterWrk .= "`Id`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
			}
		$sSqlWrk = "SELECT `Id`, `Tipo_muerte` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_muerte`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->tipo_muerte, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$this->tipo_muerte->ViewValue = "";
				$ari = 0;
				while (!$rswrk->EOF) {
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->tipo_muerte->ViewValue .= $this->tipo_muerte->DisplayValue($arwrk);
					$rswrk->MoveNext();
					if (!$rswrk->EOF) $this->tipo_muerte->ViewValue .= ew_ViewOptionSeparator($ari); // Separate Options
					$ari++;
				}
				$rswrk->Close();
			} else {
				$this->tipo_muerte->ViewValue = $this->tipo_muerte->CurrentValue;
			}
		} else {
			$this->tipo_muerte->ViewValue = NULL;
		}
		$this->tipo_muerte->ViewCustomAttributes = "";

		// Documento
		$this->Documento->ViewValue = $this->Documento->CurrentValue;
		$this->Documento->ViewCustomAttributes = "";

		// Tipo_doc
		if (strval($this->Tipo_doc->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_doc->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `tipo_documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_doc, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_doc->ViewValue = $this->Tipo_doc->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_doc->ViewValue = $this->Tipo_doc->CurrentValue;
			}
		} else {
			$this->Tipo_doc->ViewValue = NULL;
		}
		$this->Tipo_doc->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Genero
		if (strval($this->Genero->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Genero->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `genero`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Genero, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Genero->ViewValue = $this->Genero->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Genero->ViewValue = $this->Genero->CurrentValue;
			}
		} else {
			$this->Genero->ViewValue = NULL;
		}
		$this->Genero->ViewCustomAttributes = "";

		// No_certificado
		$this->No_certificado->ViewValue = $this->No_certificado->CurrentValue;
		$this->No_certificado->ViewCustomAttributes = "";

		// Fecha_Fallecimiento
		$this->Fecha_Fallecimiento->ViewValue = $this->Fecha_Fallecimiento->CurrentValue;
		$this->Fecha_Fallecimiento->ViewValue = ew_FormatDateTime($this->Fecha_Fallecimiento->ViewValue, 5);
		$this->Fecha_Fallecimiento->ViewCustomAttributes = "";

		// p_manera_muerte
		if (strval($this->p_manera_muerte->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->p_manera_muerte->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `probable_manera` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `p_manera_muerte`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->p_manera_muerte, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->p_manera_muerte->ViewValue = $this->p_manera_muerte->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->p_manera_muerte->ViewValue = $this->p_manera_muerte->CurrentValue;
			}
		} else {
			$this->p_manera_muerte->ViewValue = NULL;
		}
		$this->p_manera_muerte->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Tipo_edad
		if (strval($this->Tipo_edad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_edad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Tipo_edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_edad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_edad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_edad->ViewValue = $this->Tipo_edad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_edad->ViewValue = $this->Tipo_edad->CurrentValue;
			}
		} else {
			$this->Tipo_edad->ViewValue = NULL;
		}
		$this->Tipo_edad->ViewCustomAttributes = "";

		// Nombre_solicitante
		$this->Nombre_solicitante->ViewValue = $this->Nombre_solicitante->CurrentValue;
		$this->Nombre_solicitante->ViewCustomAttributes = "";

		// Funcionario_expide
		$this->Funcionario_expide->ViewValue = $this->Funcionario_expide->CurrentValue;
		$this->Funcionario_expide->ViewCustomAttributes = "";

		// Permiso_inhumar
		$this->Permiso_inhumar->ViewValue = $this->Permiso_inhumar->CurrentValue;
		$this->Permiso_inhumar->ViewCustomAttributes = "";

		// Permiso_cremar
		$this->Permiso_cremar->ViewValue = $this->Permiso_cremar->CurrentValue;
		$this->Permiso_cremar->ViewCustomAttributes = "";

		// Firma_funcionario
		$this->Firma_funcionario->ViewValue = $this->Firma_funcionario->CurrentValue;
		$this->Firma_funcionario->ViewCustomAttributes = "";

		// Codigo_qr
		$this->Codigo_qr->ViewValue = $this->Codigo_qr->CurrentValue;
		$this->Codigo_qr->ViewCustomAttributes = "";

		// Verificacion_codigo_qr
		$this->Verificacion_codigo_qr->ViewValue = $this->Verificacion_codigo_qr->CurrentValue;
		$this->Verificacion_codigo_qr->ViewCustomAttributes = "";

		// Registrado_por
		$this->Registrado_por->ViewValue = $this->Registrado_por->CurrentValue;
		$this->Registrado_por->ViewCustomAttributes = "";

		// Fecha_registro
		$this->Fecha_registro->ViewValue = $this->Fecha_registro->CurrentValue;
		$this->Fecha_registro->ViewValue = ew_FormatDateTime($this->Fecha_registro->ViewValue, 5);
		$this->Fecha_registro->ViewCustomAttributes = "";

		// Mensaje_manual
		$this->Mensaje_manual->ViewValue = $this->Mensaje_manual->CurrentValue;
		$this->Mensaje_manual->ViewCustomAttributes = "";

		// observaciones
		$this->observaciones->ViewValue = $this->observaciones->CurrentValue;
		$this->observaciones->ViewCustomAttributes = "";

		// fecha_edicion
		$this->fecha_edicion->ViewValue = $this->fecha_edicion->CurrentValue;
		$this->fecha_edicion->ViewValue = ew_FormatDateTime($this->fecha_edicion->ViewValue, 5);
		$this->fecha_edicion->ViewCustomAttributes = "";

		// usuario_edita
		$this->usuario_edita->ViewValue = $this->usuario_edita->CurrentValue;
		$this->usuario_edita->ViewCustomAttributes = "";

			// Entidad
			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";
			$this->Entidad->TooltipValue = "";

			// IPS/MEDICO
			$this->IPS2FMEDICO->LinkCustomAttributes = "";
			$this->IPS2FMEDICO->HrefValue = "";
			$this->IPS2FMEDICO->TooltipValue = "";

			// Logo
			$this->Logo->LinkCustomAttributes = "";
			$this->Logo->HrefValue = "";
			$this->Logo->TooltipValue = "";

			// Fecha_expedicion
			$this->Fecha_expedicion->LinkCustomAttributes = "";
			$this->Fecha_expedicion->HrefValue = "";
			$this->Fecha_expedicion->TooltipValue = "";

			// Dpto_expedicion
			$this->Dpto_expedicion->LinkCustomAttributes = "";
			$this->Dpto_expedicion->HrefValue = "";
			$this->Dpto_expedicion->TooltipValue = "";

			// Mun_expedicion
			$this->Mun_expedicion->LinkCustomAttributes = "";
			$this->Mun_expedicion->HrefValue = "";
			$this->Mun_expedicion->TooltipValue = "";

			// tipo_muerte
			$this->tipo_muerte->LinkCustomAttributes = "";
			$this->tipo_muerte->HrefValue = "";
			$this->tipo_muerte->TooltipValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";
			$this->Documento->TooltipValue = "";

			// Tipo_doc
			$this->Tipo_doc->LinkCustomAttributes = "";
			$this->Tipo_doc->HrefValue = "";
			$this->Tipo_doc->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Genero
			$this->Genero->LinkCustomAttributes = "";
			$this->Genero->HrefValue = "";
			$this->Genero->TooltipValue = "";

			// No_certificado
			$this->No_certificado->LinkCustomAttributes = "";
			$this->No_certificado->HrefValue = "";
			$this->No_certificado->TooltipValue = "";

			// Fecha_Fallecimiento
			$this->Fecha_Fallecimiento->LinkCustomAttributes = "";
			$this->Fecha_Fallecimiento->HrefValue = "";
			$this->Fecha_Fallecimiento->TooltipValue = "";

			// p_manera_muerte
			$this->p_manera_muerte->LinkCustomAttributes = "";
			$this->p_manera_muerte->HrefValue = "";
			$this->p_manera_muerte->TooltipValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";
			$this->Edad->TooltipValue = "";

			// Tipo_edad
			$this->Tipo_edad->LinkCustomAttributes = "";
			$this->Tipo_edad->HrefValue = "";
			$this->Tipo_edad->TooltipValue = "";

			// Nombre_solicitante
			$this->Nombre_solicitante->LinkCustomAttributes = "";
			$this->Nombre_solicitante->HrefValue = "";
			$this->Nombre_solicitante->TooltipValue = "";

			// Funcionario_expide
			$this->Funcionario_expide->LinkCustomAttributes = "";
			$this->Funcionario_expide->HrefValue = "";
			$this->Funcionario_expide->TooltipValue = "";

			// Permiso_inhumar
			$this->Permiso_inhumar->LinkCustomAttributes = "";
			$this->Permiso_inhumar->HrefValue = "";
			$this->Permiso_inhumar->TooltipValue = "";

			// Permiso_cremar
			$this->Permiso_cremar->LinkCustomAttributes = "";
			$this->Permiso_cremar->HrefValue = "";
			$this->Permiso_cremar->TooltipValue = "";

			// Firma_funcionario
			$this->Firma_funcionario->LinkCustomAttributes = "";
			$this->Firma_funcionario->HrefValue = "";
			$this->Firma_funcionario->TooltipValue = "";

			// Codigo_qr
			$this->Codigo_qr->LinkCustomAttributes = "";
			$this->Codigo_qr->HrefValue = "";
			$this->Codigo_qr->HrefValue2 = array("exportfn" => "ew_BarCodeImageTag", "barcode" => $this->Id->CurrentValue, "encode" => 'QRCODE', "height" => 60);
			$this->Codigo_qr->TooltipValue = "";

			// Verificacion_codigo_qr
			$this->Verificacion_codigo_qr->LinkCustomAttributes = "";
			$this->Verificacion_codigo_qr->HrefValue = "";
			$this->Verificacion_codigo_qr->TooltipValue = "";

			// Registrado_por
			$this->Registrado_por->LinkCustomAttributes = "";
			$this->Registrado_por->HrefValue = "";
			$this->Registrado_por->TooltipValue = "";

			// Fecha_registro
			$this->Fecha_registro->LinkCustomAttributes = "";
			$this->Fecha_registro->HrefValue = "";
			$this->Fecha_registro->TooltipValue = "";

			// Mensaje_manual
			$this->Mensaje_manual->LinkCustomAttributes = "";
			$this->Mensaje_manual->HrefValue = "";
			$this->Mensaje_manual->TooltipValue = "";

			// observaciones
			$this->observaciones->LinkCustomAttributes = "";
			$this->observaciones->HrefValue = "";
			$this->observaciones->TooltipValue = "";

			// fecha_edicion
			$this->fecha_edicion->LinkCustomAttributes = "";
			$this->fecha_edicion->HrefValue = "";
			$this->fecha_edicion->TooltipValue = "";

			// usuario_edita
			$this->usuario_edita->LinkCustomAttributes = "";
			$this->usuario_edita->HrefValue = "";
			$this->usuario_edita->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// Entidad
			$this->Entidad->EditCustomAttributes = "";
			if (trim(strval($this->Entidad->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `entidad`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Entidad->EditValue = $arwrk;

			// IPS/MEDICO
			$this->IPS2FMEDICO->EditAttrs["class"] = "form-control";
			$this->IPS2FMEDICO->EditCustomAttributes = "";
			$this->IPS2FMEDICO->EditValue = ew_HtmlEncode($this->IPS2FMEDICO->CurrentValue);
			$this->IPS2FMEDICO->PlaceHolder = ew_RemoveHtml($this->IPS2FMEDICO->FldCaption());

			// Logo
			$this->Logo->EditAttrs["class"] = "form-control";
			$this->Logo->EditCustomAttributes = "";
			$this->Logo->EditValue = ew_HtmlEncode($this->Logo->CurrentValue);
			$this->Logo->PlaceHolder = ew_RemoveHtml($this->Logo->FldCaption());

			// Fecha_expedicion
			$this->Fecha_expedicion->EditAttrs["class"] = "form-control";
			$this->Fecha_expedicion->EditCustomAttributes = "";
			$this->Fecha_expedicion->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_expedicion->CurrentValue, 5));
			$this->Fecha_expedicion->PlaceHolder = ew_RemoveHtml($this->Fecha_expedicion->FldCaption());

			// Dpto_expedicion
			$this->Dpto_expedicion->EditAttrs["class"] = "form-control";
			$this->Dpto_expedicion->EditCustomAttributes = "style='background-color:#EEE8AA;' readonly";
			$this->Dpto_expedicion->EditValue = ew_HtmlEncode($this->Dpto_expedicion->CurrentValue);
			$this->Dpto_expedicion->PlaceHolder = ew_RemoveHtml($this->Dpto_expedicion->FldCaption());

			// Mun_expedicion
			$this->Mun_expedicion->EditAttrs["class"] = "form-control";
			$this->Mun_expedicion->EditCustomAttributes = "style='background-color:#EEE8AA;' readonly";
			$this->Mun_expedicion->EditValue = ew_HtmlEncode($this->Mun_expedicion->CurrentValue);
			$this->Mun_expedicion->PlaceHolder = ew_RemoveHtml($this->Mun_expedicion->FldCaption());

			// tipo_muerte
			$this->tipo_muerte->EditCustomAttributes = "";
			if (trim(strval($this->tipo_muerte->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$arwrk = explode(",", $this->tipo_muerte->CurrentValue);
				$sFilterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($sFilterWrk <> "") $sFilterWrk .= " OR ";
					$sFilterWrk .= "`Id`" . ew_SearchString("=", trim($wrk), EW_DATATYPE_NUMBER, "");
				}
			}
			$sSqlWrk = "SELECT `Id`, `Tipo_muerte` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tipo_muerte`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->tipo_muerte, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->tipo_muerte->EditValue = $arwrk;

			// Documento
			$this->Documento->EditAttrs["class"] = "form-control";
			$this->Documento->EditCustomAttributes = "";
			$this->Documento->EditValue = ew_HtmlEncode($this->Documento->CurrentValue);
			$this->Documento->PlaceHolder = ew_RemoveHtml($this->Documento->FldCaption());

			// Tipo_doc
			$this->Tipo_doc->EditCustomAttributes = "";
			if (trim(strval($this->Tipo_doc->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_doc->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `tipo_documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tipo_documento`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Tipo_doc, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Tipo_doc->EditValue = $arwrk;

			// Nombres
			$this->Nombres->EditAttrs["class"] = "form-control";
			$this->Nombres->EditCustomAttributes = "onkeyup='this.value=this.value.toUpperCase();'";
			$this->Nombres->EditValue = ew_HtmlEncode($this->Nombres->CurrentValue);
			$this->Nombres->PlaceHolder = ew_RemoveHtml($this->Nombres->FldCaption());

			// Apellidos
			$this->Apellidos->EditAttrs["class"] = "form-control";
			$this->Apellidos->EditCustomAttributes = "onkeyup='this.value=this.value.toUpperCase();'";
			$this->Apellidos->EditValue = ew_HtmlEncode($this->Apellidos->CurrentValue);
			$this->Apellidos->PlaceHolder = ew_RemoveHtml($this->Apellidos->FldCaption());

			// Genero
			$this->Genero->EditCustomAttributes = "";
			if (trim(strval($this->Genero->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Genero->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `genero`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Genero, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Genero->EditValue = $arwrk;

			// No_certificado
			$this->No_certificado->EditAttrs["class"] = "form-control";
			$this->No_certificado->EditCustomAttributes = "";
			$this->No_certificado->EditValue = ew_HtmlEncode($this->No_certificado->CurrentValue);
			$this->No_certificado->PlaceHolder = ew_RemoveHtml($this->No_certificado->FldCaption());

			// Fecha_Fallecimiento
			$this->Fecha_Fallecimiento->EditAttrs["class"] = "form-control";
			$this->Fecha_Fallecimiento->EditCustomAttributes = "";
			$this->Fecha_Fallecimiento->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Fecha_Fallecimiento->CurrentValue, 5));
			$this->Fecha_Fallecimiento->PlaceHolder = ew_RemoveHtml($this->Fecha_Fallecimiento->FldCaption());

			// p_manera_muerte
			$this->p_manera_muerte->EditCustomAttributes = "";
			if (trim(strval($this->p_manera_muerte->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->p_manera_muerte->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `probable_manera` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `p_manera_muerte`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->p_manera_muerte, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->p_manera_muerte->EditValue = $arwrk;

			// Edad
			$this->Edad->EditAttrs["class"] = "form-control";
			$this->Edad->EditCustomAttributes = "";
			$this->Edad->EditValue = ew_HtmlEncode($this->Edad->CurrentValue);
			$this->Edad->PlaceHolder = ew_RemoveHtml($this->Edad->FldCaption());

			// Tipo_edad
			$this->Tipo_edad->EditCustomAttributes = "";
			if (trim(strval($this->Tipo_edad->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_edad->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `Tipo_edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tipo_edad`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Tipo_edad, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->Tipo_edad->EditValue = $arwrk;

			// Nombre_solicitante
			$this->Nombre_solicitante->EditAttrs["class"] = "form-control";
			$this->Nombre_solicitante->EditCustomAttributes = "onkeyup='this.value=this.value.toUpperCase();'";
			$this->Nombre_solicitante->EditValue = ew_HtmlEncode($this->Nombre_solicitante->CurrentValue);
			$this->Nombre_solicitante->PlaceHolder = ew_RemoveHtml($this->Nombre_solicitante->FldCaption());

			// Funcionario_expide
			$this->Funcionario_expide->EditAttrs["class"] = "form-control";
			$this->Funcionario_expide->EditCustomAttributes = "style='background-color:#EEE8AA;' readonly";
			$this->Funcionario_expide->EditValue = ew_HtmlEncode($this->Funcionario_expide->CurrentValue);
			$this->Funcionario_expide->PlaceHolder = ew_RemoveHtml($this->Funcionario_expide->FldCaption());

			// Permiso_inhumar
			$this->Permiso_inhumar->EditAttrs["class"] = "form-control";
			$this->Permiso_inhumar->EditCustomAttributes = "onkeyup='this.value=this.value.toUpperCase();'";
			$this->Permiso_inhumar->EditValue = ew_HtmlEncode($this->Permiso_inhumar->CurrentValue);
			$this->Permiso_inhumar->PlaceHolder = ew_RemoveHtml($this->Permiso_inhumar->FldCaption());

			// Permiso_cremar
			$this->Permiso_cremar->EditAttrs["class"] = "form-control";
			$this->Permiso_cremar->EditCustomAttributes = "onkeyup='this.value=this.value.toUpperCase();'";
			$this->Permiso_cremar->EditValue = ew_HtmlEncode($this->Permiso_cremar->CurrentValue);
			$this->Permiso_cremar->PlaceHolder = ew_RemoveHtml($this->Permiso_cremar->FldCaption());

			// Firma_funcionario
			$this->Firma_funcionario->EditAttrs["class"] = "form-control";
			$this->Firma_funcionario->EditCustomAttributes = "style='background-color:#EEE8AA;' readonly";
			$this->Firma_funcionario->EditValue = ew_HtmlEncode($this->Firma_funcionario->CurrentValue);
			$this->Firma_funcionario->PlaceHolder = ew_RemoveHtml($this->Firma_funcionario->FldCaption());

			// Codigo_qr
			$this->Codigo_qr->EditAttrs["class"] = "form-control";
			$this->Codigo_qr->EditCustomAttributes = "";
			$this->Codigo_qr->EditValue = ew_HtmlEncode($this->Codigo_qr->CurrentValue);
			$this->Codigo_qr->PlaceHolder = ew_RemoveHtml($this->Codigo_qr->FldCaption());

			// Verificacion_codigo_qr
			$this->Verificacion_codigo_qr->EditAttrs["class"] = "form-control";
			$this->Verificacion_codigo_qr->EditCustomAttributes = "style='background-color:#EEE8AA;' readonly";
			$this->Verificacion_codigo_qr->EditValue = ew_HtmlEncode($this->Verificacion_codigo_qr->CurrentValue);
			$this->Verificacion_codigo_qr->PlaceHolder = ew_RemoveHtml($this->Verificacion_codigo_qr->FldCaption());

			// Registrado_por
			// Fecha_registro
			// Mensaje_manual

			$this->Mensaje_manual->EditAttrs["class"] = "form-control";
			$this->Mensaje_manual->EditCustomAttributes = "";
			$this->Mensaje_manual->EditValue = ew_HtmlEncode($this->Mensaje_manual->CurrentValue);
			$this->Mensaje_manual->PlaceHolder = ew_RemoveHtml($this->Mensaje_manual->FldCaption());

			// observaciones
			$this->observaciones->EditAttrs["class"] = "form-control";
			$this->observaciones->EditCustomAttributes = "";
			$this->observaciones->EditValue = ew_HtmlEncode($this->observaciones->CurrentValue);
			$this->observaciones->PlaceHolder = ew_RemoveHtml($this->observaciones->FldCaption());

			// fecha_edicion
			// usuario_edita
			// Add refer script
			// Entidad

			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";

			// IPS/MEDICO
			$this->IPS2FMEDICO->LinkCustomAttributes = "";
			$this->IPS2FMEDICO->HrefValue = "";

			// Logo
			$this->Logo->LinkCustomAttributes = "";
			$this->Logo->HrefValue = "";

			// Fecha_expedicion
			$this->Fecha_expedicion->LinkCustomAttributes = "";
			$this->Fecha_expedicion->HrefValue = "";

			// Dpto_expedicion
			$this->Dpto_expedicion->LinkCustomAttributes = "";
			$this->Dpto_expedicion->HrefValue = "";

			// Mun_expedicion
			$this->Mun_expedicion->LinkCustomAttributes = "";
			$this->Mun_expedicion->HrefValue = "";

			// tipo_muerte
			$this->tipo_muerte->LinkCustomAttributes = "";
			$this->tipo_muerte->HrefValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";

			// Tipo_doc
			$this->Tipo_doc->LinkCustomAttributes = "";
			$this->Tipo_doc->HrefValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";

			// Genero
			$this->Genero->LinkCustomAttributes = "";
			$this->Genero->HrefValue = "";

			// No_certificado
			$this->No_certificado->LinkCustomAttributes = "";
			$this->No_certificado->HrefValue = "";

			// Fecha_Fallecimiento
			$this->Fecha_Fallecimiento->LinkCustomAttributes = "";
			$this->Fecha_Fallecimiento->HrefValue = "";

			// p_manera_muerte
			$this->p_manera_muerte->LinkCustomAttributes = "";
			$this->p_manera_muerte->HrefValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";

			// Tipo_edad
			$this->Tipo_edad->LinkCustomAttributes = "";
			$this->Tipo_edad->HrefValue = "";

			// Nombre_solicitante
			$this->Nombre_solicitante->LinkCustomAttributes = "";
			$this->Nombre_solicitante->HrefValue = "";

			// Funcionario_expide
			$this->Funcionario_expide->LinkCustomAttributes = "";
			$this->Funcionario_expide->HrefValue = "";

			// Permiso_inhumar
			$this->Permiso_inhumar->LinkCustomAttributes = "";
			$this->Permiso_inhumar->HrefValue = "";

			// Permiso_cremar
			$this->Permiso_cremar->LinkCustomAttributes = "";
			$this->Permiso_cremar->HrefValue = "";

			// Firma_funcionario
			$this->Firma_funcionario->LinkCustomAttributes = "";
			$this->Firma_funcionario->HrefValue = "";

			// Codigo_qr
			$this->Codigo_qr->LinkCustomAttributes = "";
			$this->Codigo_qr->HrefValue = "";
			$this->Codigo_qr->HrefValue2 = array("exportfn" => "ew_BarCodeImageTag", "barcode" => $this->Id->CurrentValue, "encode" => 'QRCODE', "height" => 60);

			// Verificacion_codigo_qr
			$this->Verificacion_codigo_qr->LinkCustomAttributes = "";
			$this->Verificacion_codigo_qr->HrefValue = "";

			// Registrado_por
			$this->Registrado_por->LinkCustomAttributes = "";
			$this->Registrado_por->HrefValue = "";

			// Fecha_registro
			$this->Fecha_registro->LinkCustomAttributes = "";
			$this->Fecha_registro->HrefValue = "";

			// Mensaje_manual
			$this->Mensaje_manual->LinkCustomAttributes = "";
			$this->Mensaje_manual->HrefValue = "";

			// observaciones
			$this->observaciones->LinkCustomAttributes = "";
			$this->observaciones->HrefValue = "";

			// fecha_edicion
			$this->fecha_edicion->LinkCustomAttributes = "";
			$this->fecha_edicion->HrefValue = "";

			// usuario_edita
			$this->usuario_edita->LinkCustomAttributes = "";
			$this->usuario_edita->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->IPS2FMEDICO->FldIsDetailKey && !is_null($this->IPS2FMEDICO->FormValue) && $this->IPS2FMEDICO->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->IPS2FMEDICO->FldCaption(), $this->IPS2FMEDICO->ReqErrMsg));
		}
		if (!$this->Logo->FldIsDetailKey && !is_null($this->Logo->FormValue) && $this->Logo->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Logo->FldCaption(), $this->Logo->ReqErrMsg));
		}
		if (!ew_CheckDate($this->Fecha_expedicion->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_expedicion->FldErrMsg());
		}
		if (!$this->Dpto_expedicion->FldIsDetailKey && !is_null($this->Dpto_expedicion->FormValue) && $this->Dpto_expedicion->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Dpto_expedicion->FldCaption(), $this->Dpto_expedicion->ReqErrMsg));
		}
		if (!$this->Mun_expedicion->FldIsDetailKey && !is_null($this->Mun_expedicion->FormValue) && $this->Mun_expedicion->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Mun_expedicion->FldCaption(), $this->Mun_expedicion->ReqErrMsg));
		}
		if (!ew_CheckDate($this->Fecha_Fallecimiento->FormValue)) {
			ew_AddMessage($gsFormError, $this->Fecha_Fallecimiento->FldErrMsg());
		}
		if (!ew_CheckInteger($this->Edad->FormValue)) {
			ew_AddMessage($gsFormError, $this->Edad->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		if ($this->No_certificado->CurrentValue <> "") { // Check field with unique index
			$sFilter = "(No_certificado = " . ew_AdjustSql($this->No_certificado->CurrentValue, $this->DBID) . ")";
			$rsChk = $this->LoadRs($sFilter);
			if ($rsChk && !$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", $this->No_certificado->FldCaption(), $Language->Phrase("DupIndex"));
				$sIdxErrMsg = str_replace("%v", $this->No_certificado->CurrentValue, $sIdxErrMsg);
				$this->setFailureMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
		}
		$conn = &$this->Connection();

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
		}
		$rsnew = array();

		// Entidad
		$this->Entidad->SetDbValueDef($rsnew, $this->Entidad->CurrentValue, NULL, FALSE);

		// IPS/MEDICO
		$this->IPS2FMEDICO->SetDbValueDef($rsnew, $this->IPS2FMEDICO->CurrentValue, "", FALSE);

		// Logo
		$this->Logo->SetDbValueDef($rsnew, $this->Logo->CurrentValue, "", FALSE);

		// Fecha_expedicion
		$this->Fecha_expedicion->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_expedicion->CurrentValue, 5), NULL, FALSE);

		// Dpto_expedicion
		$this->Dpto_expedicion->SetDbValueDef($rsnew, $this->Dpto_expedicion->CurrentValue, NULL, FALSE);

		// Mun_expedicion
		$this->Mun_expedicion->SetDbValueDef($rsnew, $this->Mun_expedicion->CurrentValue, NULL, FALSE);

		// tipo_muerte
		$this->tipo_muerte->SetDbValueDef($rsnew, $this->tipo_muerte->CurrentValue, NULL, FALSE);

		// Documento
		$this->Documento->SetDbValueDef($rsnew, $this->Documento->CurrentValue, NULL, FALSE);

		// Tipo_doc
		$this->Tipo_doc->SetDbValueDef($rsnew, $this->Tipo_doc->CurrentValue, NULL, FALSE);

		// Nombres
		$this->Nombres->SetDbValueDef($rsnew, $this->Nombres->CurrentValue, NULL, FALSE);

		// Apellidos
		$this->Apellidos->SetDbValueDef($rsnew, $this->Apellidos->CurrentValue, NULL, FALSE);

		// Genero
		$this->Genero->SetDbValueDef($rsnew, $this->Genero->CurrentValue, NULL, FALSE);

		// No_certificado
		$this->No_certificado->SetDbValueDef($rsnew, $this->No_certificado->CurrentValue, NULL, FALSE);

		// Fecha_Fallecimiento
		$this->Fecha_Fallecimiento->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Fecha_Fallecimiento->CurrentValue, 5), NULL, FALSE);

		// p_manera_muerte
		$this->p_manera_muerte->SetDbValueDef($rsnew, $this->p_manera_muerte->CurrentValue, NULL, FALSE);

		// Edad
		$this->Edad->SetDbValueDef($rsnew, $this->Edad->CurrentValue, NULL, FALSE);

		// Tipo_edad
		$this->Tipo_edad->SetDbValueDef($rsnew, $this->Tipo_edad->CurrentValue, NULL, FALSE);

		// Nombre_solicitante
		$this->Nombre_solicitante->SetDbValueDef($rsnew, $this->Nombre_solicitante->CurrentValue, NULL, FALSE);

		// Funcionario_expide
		$this->Funcionario_expide->SetDbValueDef($rsnew, $this->Funcionario_expide->CurrentValue, NULL, FALSE);

		// Permiso_inhumar
		$this->Permiso_inhumar->SetDbValueDef($rsnew, $this->Permiso_inhumar->CurrentValue, NULL, FALSE);

		// Permiso_cremar
		$this->Permiso_cremar->SetDbValueDef($rsnew, $this->Permiso_cremar->CurrentValue, NULL, FALSE);

		// Firma_funcionario
		$this->Firma_funcionario->SetDbValueDef($rsnew, $this->Firma_funcionario->CurrentValue, NULL, FALSE);

		// Codigo_qr
		$this->Codigo_qr->SetDbValueDef($rsnew, $this->Codigo_qr->CurrentValue, NULL, FALSE);

		// Verificacion_codigo_qr
		$this->Verificacion_codigo_qr->SetDbValueDef($rsnew, $this->Verificacion_codigo_qr->CurrentValue, NULL, FALSE);

		// Registrado_por
		$this->Registrado_por->SetDbValueDef($rsnew, CurrentUserName(), NULL);
		$rsnew['Registrado_por'] = &$this->Registrado_por->DbValue;

		// Fecha_registro
		$this->Fecha_registro->SetDbValueDef($rsnew, ew_CurrentDate(), NULL);
		$rsnew['Fecha_registro'] = &$this->Fecha_registro->DbValue;

		// Mensaje_manual
		$this->Mensaje_manual->SetDbValueDef($rsnew, $this->Mensaje_manual->CurrentValue, NULL, FALSE);

		// observaciones
		$this->observaciones->SetDbValueDef($rsnew, $this->observaciones->CurrentValue, NULL, FALSE);

		// fecha_edicion
		$this->fecha_edicion->SetDbValueDef($rsnew, ew_CurrentDate(), NULL);
		$rsnew['fecha_edicion'] = &$this->fecha_edicion->DbValue;

		// usuario_edita
		$this->usuario_edita->SetDbValueDef($rsnew, CurrentUserName(), NULL);
		$rsnew['usuario_edita'] = &$this->usuario_edita->DbValue;

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {

				// Get insert id if necessary
				$this->Id->setDbValue($conn->Insert_ID());
				$rsnew['Id'] = $this->Id->DbValue;
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("licenciaslist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Set up multi pages
	function SetupMultiPages() {
		$pages = new cSubPages();
		$pages->Style = "tabs";
		$pages->Add(0);
		$pages->Add(1);
		$pages->Add(2);
		$this->MultiPages = $pages;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($licencias_add)) $licencias_add = new clicencias_add();

// Page init
$licencias_add->Page_Init();

// Page main
$licencias_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$licencias_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = flicenciasadd = new ew_Form("flicenciasadd", "add");

// Validate form
flicenciasadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_IPS2FMEDICO");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $licencias->IPS2FMEDICO->FldCaption(), $licencias->IPS2FMEDICO->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Logo");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $licencias->Logo->FldCaption(), $licencias->Logo->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_expedicion");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($licencias->Fecha_expedicion->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Dpto_expedicion");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $licencias->Dpto_expedicion->FldCaption(), $licencias->Dpto_expedicion->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Mun_expedicion");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $licencias->Mun_expedicion->FldCaption(), $licencias->Mun_expedicion->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Fecha_Fallecimiento");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($licencias->Fecha_Fallecimiento->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Edad");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($licencias->Edad->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
flicenciasadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
flicenciasadd.ValidateRequired = true;
<?php } else { ?>
flicenciasadd.ValidateRequired = false; 
<?php } ?>

// Multi-Page
flicenciasadd.MultiPage = new ew_MultiPage("flicenciasadd");

// Dynamic selection lists
flicenciasadd.Lists["x_Entidad"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":true,"DisplayFields":["x_Entidad","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasadd.Lists["x_tipo_muerte[]"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_muerte","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasadd.Lists["x_Tipo_doc"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_tipo_documento","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasadd.Lists["x_Genero"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Genero","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasadd.Lists["x_p_manera_muerte"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_probable_manera","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasadd.Lists["x_Tipo_edad"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_edad","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php $licencias_add->ShowPageHeader(); ?>
<?php
$licencias_add->ShowMessage();
?>
<form name="flicenciasadd" id="flicenciasadd" class="<?php echo $licencias_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($licencias_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $licencias_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="licencias">
<input type="hidden" name="a_add" id="a_add" value="A">
<div class="ewMultiPage">
<div class="tabbable" id="licencias_add">
	<ul class="nav<?php echo $licencias_add->MultiPages->NavStyle() ?>">
		<li<?php echo $licencias_add->MultiPages->TabStyle("1") ?>><a href="#tab_licencias1" data-toggle="tab"><?php echo $licencias->PageCaption(1) ?></a></li>
		<li<?php echo $licencias_add->MultiPages->TabStyle("2") ?>><a href="#tab_licencias2" data-toggle="tab"><?php echo $licencias->PageCaption(2) ?></a></li>
	</ul>
	<div class="tab-content">
		<div class="tab-pane<?php echo $licencias_add->MultiPages->PageStyle("1") ?>" id="tab_licencias1">
<div>
<?php if ($licencias->Entidad->Visible) { // Entidad ?>
	<div id="r_Entidad" class="form-group">
		<label id="elh_licencias_Entidad" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Entidad->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Entidad->CellAttributes() ?>>
<span id="el_licencias_Entidad">
<?php $licencias->Entidad->EditAttrs["onclick"] = "ew_AutoFill(this); " . @$licencias->Entidad->EditAttrs["onclick"]; ?>
<div id="tp_x_Entidad" class="ewTemplate"><input type="radio" data-table="licencias" data-field="x_Entidad" data-page="1" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->Entidad->DisplayValueSeparator) ? json_encode($licencias->Entidad->DisplayValueSeparator) : $licencias->Entidad->DisplayValueSeparator) ?>" name="x_Entidad" id="x_Entidad" value="{value}"<?php echo $licencias->Entidad->EditAttributes() ?>></div>
<div id="dsl_x_Entidad" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->Entidad->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($licencias->Entidad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Entidad" data-page="1" name="x_Entidad" id="x_Entidad_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->Entidad->EditAttributes() ?>><?php echo $licencias->Entidad->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($licencias->Entidad->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Entidad" data-page="1" name="x_Entidad" id="x_Entidad_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($licencias->Entidad->CurrentValue) ?>" checked<?php echo $licencias->Entidad->EditAttributes() ?>><?php echo $licencias->Entidad->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
$sWhereWrk = "";
$licencias->Entidad->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->Entidad->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->Entidad, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->Entidad->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Entidad" id="s_x_Entidad" value="<?php echo $licencias->Entidad->LookupFilterQuery() ?>">
<input type="hidden" name="ln_x_Entidad" id="ln_x_Entidad" value="x_Funcionario_expide,x_Firma_funcionario">
</span>
<?php echo $licencias->Entidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->IPS2FMEDICO->Visible) { // IPS/MEDICO ?>
	<div id="r_IPS2FMEDICO" class="form-group">
		<label id="elh_licencias_IPS2FMEDICO" for="x_IPS2FMEDICO" class="col-sm-2 control-label ewLabel"><?php echo $licencias->IPS2FMEDICO->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->IPS2FMEDICO->CellAttributes() ?>>
<span id="el_licencias_IPS2FMEDICO">
<input type="text" data-table="licencias" data-field="x_IPS2FMEDICO" data-page="1" name="x_IPS2FMEDICO" id="x_IPS2FMEDICO" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($licencias->IPS2FMEDICO->getPlaceHolder()) ?>" value="<?php echo $licencias->IPS2FMEDICO->EditValue ?>"<?php echo $licencias->IPS2FMEDICO->EditAttributes() ?>>
</span>
<?php echo $licencias->IPS2FMEDICO->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Fecha_expedicion->Visible) { // Fecha_expedicion ?>
	<div id="r_Fecha_expedicion" class="form-group">
		<label id="elh_licencias_Fecha_expedicion" for="x_Fecha_expedicion" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Fecha_expedicion->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Fecha_expedicion->CellAttributes() ?>>
<span id="el_licencias_Fecha_expedicion">
<input type="text" data-table="licencias" data-field="x_Fecha_expedicion" data-page="1" data-format="5" name="x_Fecha_expedicion" id="x_Fecha_expedicion" placeholder="<?php echo ew_HtmlEncode($licencias->Fecha_expedicion->getPlaceHolder()) ?>" value="<?php echo $licencias->Fecha_expedicion->EditValue ?>"<?php echo $licencias->Fecha_expedicion->EditAttributes() ?>>
<?php if (!$licencias->Fecha_expedicion->ReadOnly && !$licencias->Fecha_expedicion->Disabled && !isset($licencias->Fecha_expedicion->EditAttrs["readonly"]) && !isset($licencias->Fecha_expedicion->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateCalendar("flicenciasadd", "x_Fecha_expedicion", "%Y/%m/%d");
</script>
<?php } ?>
</span>
<?php echo $licencias->Fecha_expedicion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->tipo_muerte->Visible) { // tipo_muerte ?>
	<div id="r_tipo_muerte" class="form-group">
		<label id="elh_licencias_tipo_muerte" class="col-sm-2 control-label ewLabel"><?php echo $licencias->tipo_muerte->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->tipo_muerte->CellAttributes() ?>>
<span id="el_licencias_tipo_muerte">
<div id="tp_x_tipo_muerte" class="ewTemplate"><input type="checkbox" data-table="licencias" data-field="x_tipo_muerte" data-page="1" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->tipo_muerte->DisplayValueSeparator) ? json_encode($licencias->tipo_muerte->DisplayValueSeparator) : $licencias->tipo_muerte->DisplayValueSeparator) ?>" name="x_tipo_muerte[]" id="x_tipo_muerte[]" value="{value}"<?php echo $licencias->tipo_muerte->EditAttributes() ?>></div>
<div id="dsl_x_tipo_muerte" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->tipo_muerte->EditValue;
if (is_array($arwrk)) {
	$armultiwrk = (strval($licencias->tipo_muerte->CurrentValue) <> "") ? explode(",", strval($licencias->tipo_muerte->CurrentValue)) : array();
	$cnt = count($armultiwrk);
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = "";
		for ($ari = 0; $ari < $cnt; $ari++) {
			if (ew_SameStr($arwrk[$rowcntwrk][0], $armultiwrk[$ari]) && !is_null($armultiwrk[$ari])) {
				$armultiwrk[$ari] = NULL; // Marked for removal
				$selwrk = " checked";
				if ($selwrk <> "") $emptywrk = FALSE;
				break;
			}
		}
		if ($selwrk <> "") {
?>
<label class="checkbox-inline"><input type="checkbox" data-table="licencias" data-field="x_tipo_muerte" data-page="1" name="x_tipo_muerte[]" id="x_tipo_muerte_<?php echo $rowcntwrk ?>[]" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->tipo_muerte->EditAttributes() ?>><?php echo $licencias->tipo_muerte->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	for ($ari = 0; $ari < $cnt; $ari++) {
		if (!is_null($armultiwrk[$ari])) {
?>
<label class="checkbox-inline"><input type="checkbox" data-table="licencias" data-field="x_tipo_muerte" data-page="1" name="x_tipo_muerte[]" value="<?php echo ew_HtmlEncode($armultiwrk[$ari]) ?>" checked<?php echo $licencias->tipo_muerte->EditAttributes() ?>><?php echo $armultiwrk[$ari] ?></label>
<?php
		}
	}
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `Tipo_muerte` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_muerte`";
$sWhereWrk = "";
$licencias->tipo_muerte->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->tipo_muerte->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->tipo_muerte, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->tipo_muerte->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_tipo_muerte" id="s_x_tipo_muerte" value="<?php echo $licencias->tipo_muerte->LookupFilterQuery() ?>">
</span>
<?php echo $licencias->tipo_muerte->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Documento->Visible) { // Documento ?>
	<div id="r_Documento" class="form-group">
		<label id="elh_licencias_Documento" for="x_Documento" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Documento->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Documento->CellAttributes() ?>>
<span id="el_licencias_Documento">
<input type="text" data-table="licencias" data-field="x_Documento" data-page="1" name="x_Documento" id="x_Documento" size="30" maxlength="15" placeholder="<?php echo ew_HtmlEncode($licencias->Documento->getPlaceHolder()) ?>" value="<?php echo $licencias->Documento->EditValue ?>"<?php echo $licencias->Documento->EditAttributes() ?>>
</span>
<?php echo $licencias->Documento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Tipo_doc->Visible) { // Tipo_doc ?>
	<div id="r_Tipo_doc" class="form-group">
		<label id="elh_licencias_Tipo_doc" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Tipo_doc->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Tipo_doc->CellAttributes() ?>>
<span id="el_licencias_Tipo_doc">
<div id="tp_x_Tipo_doc" class="ewTemplate"><input type="radio" data-table="licencias" data-field="x_Tipo_doc" data-page="1" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->Tipo_doc->DisplayValueSeparator) ? json_encode($licencias->Tipo_doc->DisplayValueSeparator) : $licencias->Tipo_doc->DisplayValueSeparator) ?>" name="x_Tipo_doc" id="x_Tipo_doc" value="{value}"<?php echo $licencias->Tipo_doc->EditAttributes() ?>></div>
<div id="dsl_x_Tipo_doc" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->Tipo_doc->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($licencias->Tipo_doc->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Tipo_doc" data-page="1" name="x_Tipo_doc" id="x_Tipo_doc_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->Tipo_doc->EditAttributes() ?>><?php echo $licencias->Tipo_doc->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($licencias->Tipo_doc->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Tipo_doc" data-page="1" name="x_Tipo_doc" id="x_Tipo_doc_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($licencias->Tipo_doc->CurrentValue) ?>" checked<?php echo $licencias->Tipo_doc->EditAttributes() ?>><?php echo $licencias->Tipo_doc->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `tipo_documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
$sWhereWrk = "";
$licencias->Tipo_doc->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->Tipo_doc->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->Tipo_doc, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->Tipo_doc->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Tipo_doc" id="s_x_Tipo_doc" value="<?php echo $licencias->Tipo_doc->LookupFilterQuery() ?>">
</span>
<?php echo $licencias->Tipo_doc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Nombres->Visible) { // Nombres ?>
	<div id="r_Nombres" class="form-group">
		<label id="elh_licencias_Nombres" for="x_Nombres" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Nombres->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Nombres->CellAttributes() ?>>
<span id="el_licencias_Nombres">
<input type="text" data-table="licencias" data-field="x_Nombres" data-page="1" name="x_Nombres" id="x_Nombres" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($licencias->Nombres->getPlaceHolder()) ?>" value="<?php echo $licencias->Nombres->EditValue ?>"<?php echo $licencias->Nombres->EditAttributes() ?>>
</span>
<?php echo $licencias->Nombres->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Apellidos->Visible) { // Apellidos ?>
	<div id="r_Apellidos" class="form-group">
		<label id="elh_licencias_Apellidos" for="x_Apellidos" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Apellidos->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Apellidos->CellAttributes() ?>>
<span id="el_licencias_Apellidos">
<input type="text" data-table="licencias" data-field="x_Apellidos" data-page="1" name="x_Apellidos" id="x_Apellidos" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($licencias->Apellidos->getPlaceHolder()) ?>" value="<?php echo $licencias->Apellidos->EditValue ?>"<?php echo $licencias->Apellidos->EditAttributes() ?>>
</span>
<?php echo $licencias->Apellidos->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Genero->Visible) { // Genero ?>
	<div id="r_Genero" class="form-group">
		<label id="elh_licencias_Genero" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Genero->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Genero->CellAttributes() ?>>
<span id="el_licencias_Genero">
<div id="tp_x_Genero" class="ewTemplate"><input type="radio" data-table="licencias" data-field="x_Genero" data-page="1" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->Genero->DisplayValueSeparator) ? json_encode($licencias->Genero->DisplayValueSeparator) : $licencias->Genero->DisplayValueSeparator) ?>" name="x_Genero" id="x_Genero" value="{value}"<?php echo $licencias->Genero->EditAttributes() ?>></div>
<div id="dsl_x_Genero" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->Genero->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($licencias->Genero->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Genero" data-page="1" name="x_Genero" id="x_Genero_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->Genero->EditAttributes() ?>><?php echo $licencias->Genero->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($licencias->Genero->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Genero" data-page="1" name="x_Genero" id="x_Genero_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($licencias->Genero->CurrentValue) ?>" checked<?php echo $licencias->Genero->EditAttributes() ?>><?php echo $licencias->Genero->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `genero`";
$sWhereWrk = "";
$licencias->Genero->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->Genero->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->Genero, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->Genero->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Genero" id="s_x_Genero" value="<?php echo $licencias->Genero->LookupFilterQuery() ?>">
</span>
<?php echo $licencias->Genero->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->No_certificado->Visible) { // No_certificado ?>
	<div id="r_No_certificado" class="form-group">
		<label id="elh_licencias_No_certificado" for="x_No_certificado" class="col-sm-2 control-label ewLabel"><?php echo $licencias->No_certificado->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->No_certificado->CellAttributes() ?>>
<span id="el_licencias_No_certificado">
<input type="text" data-table="licencias" data-field="x_No_certificado" data-page="1" name="x_No_certificado" id="x_No_certificado" size="30" maxlength="9" placeholder="<?php echo ew_HtmlEncode($licencias->No_certificado->getPlaceHolder()) ?>" value="<?php echo $licencias->No_certificado->EditValue ?>"<?php echo $licencias->No_certificado->EditAttributes() ?>>
</span>
<?php echo $licencias->No_certificado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Fecha_Fallecimiento->Visible) { // Fecha_Fallecimiento ?>
	<div id="r_Fecha_Fallecimiento" class="form-group">
		<label id="elh_licencias_Fecha_Fallecimiento" for="x_Fecha_Fallecimiento" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Fecha_Fallecimiento->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Fecha_Fallecimiento->CellAttributes() ?>>
<span id="el_licencias_Fecha_Fallecimiento">
<input type="text" data-table="licencias" data-field="x_Fecha_Fallecimiento" data-page="1" data-format="5" name="x_Fecha_Fallecimiento" id="x_Fecha_Fallecimiento" placeholder="<?php echo ew_HtmlEncode($licencias->Fecha_Fallecimiento->getPlaceHolder()) ?>" value="<?php echo $licencias->Fecha_Fallecimiento->EditValue ?>"<?php echo $licencias->Fecha_Fallecimiento->EditAttributes() ?>>
<?php if (!$licencias->Fecha_Fallecimiento->ReadOnly && !$licencias->Fecha_Fallecimiento->Disabled && !isset($licencias->Fecha_Fallecimiento->EditAttrs["readonly"]) && !isset($licencias->Fecha_Fallecimiento->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateCalendar("flicenciasadd", "x_Fecha_Fallecimiento", "%Y/%m/%d");
</script>
<?php } ?>
</span>
<?php echo $licencias->Fecha_Fallecimiento->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->p_manera_muerte->Visible) { // p_manera_muerte ?>
	<div id="r_p_manera_muerte" class="form-group">
		<label id="elh_licencias_p_manera_muerte" class="col-sm-2 control-label ewLabel"><?php echo $licencias->p_manera_muerte->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->p_manera_muerte->CellAttributes() ?>>
<span id="el_licencias_p_manera_muerte">
<div id="tp_x_p_manera_muerte" class="ewTemplate"><input type="radio" data-table="licencias" data-field="x_p_manera_muerte" data-page="1" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->p_manera_muerte->DisplayValueSeparator) ? json_encode($licencias->p_manera_muerte->DisplayValueSeparator) : $licencias->p_manera_muerte->DisplayValueSeparator) ?>" name="x_p_manera_muerte" id="x_p_manera_muerte" value="{value}"<?php echo $licencias->p_manera_muerte->EditAttributes() ?>></div>
<div id="dsl_x_p_manera_muerte" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->p_manera_muerte->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($licencias->p_manera_muerte->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_p_manera_muerte" data-page="1" name="x_p_manera_muerte" id="x_p_manera_muerte_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->p_manera_muerte->EditAttributes() ?>><?php echo $licencias->p_manera_muerte->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($licencias->p_manera_muerte->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_p_manera_muerte" data-page="1" name="x_p_manera_muerte" id="x_p_manera_muerte_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($licencias->p_manera_muerte->CurrentValue) ?>" checked<?php echo $licencias->p_manera_muerte->EditAttributes() ?>><?php echo $licencias->p_manera_muerte->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `probable_manera` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `p_manera_muerte`";
$sWhereWrk = "";
$licencias->p_manera_muerte->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->p_manera_muerte->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->p_manera_muerte, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->p_manera_muerte->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_p_manera_muerte" id="s_x_p_manera_muerte" value="<?php echo $licencias->p_manera_muerte->LookupFilterQuery() ?>">
</span>
<?php echo $licencias->p_manera_muerte->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Edad->Visible) { // Edad ?>
	<div id="r_Edad" class="form-group">
		<label id="elh_licencias_Edad" for="x_Edad" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Edad->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Edad->CellAttributes() ?>>
<span id="el_licencias_Edad">
<input type="text" data-table="licencias" data-field="x_Edad" data-page="1" name="x_Edad" id="x_Edad" size="30" placeholder="<?php echo ew_HtmlEncode($licencias->Edad->getPlaceHolder()) ?>" value="<?php echo $licencias->Edad->EditValue ?>"<?php echo $licencias->Edad->EditAttributes() ?>>
</span>
<?php echo $licencias->Edad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Tipo_edad->Visible) { // Tipo_edad ?>
	<div id="r_Tipo_edad" class="form-group">
		<label id="elh_licencias_Tipo_edad" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Tipo_edad->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Tipo_edad->CellAttributes() ?>>
<span id="el_licencias_Tipo_edad">
<div id="tp_x_Tipo_edad" class="ewTemplate"><input type="radio" data-table="licencias" data-field="x_Tipo_edad" data-page="1" data-value-separator="<?php echo ew_HtmlEncode(is_array($licencias->Tipo_edad->DisplayValueSeparator) ? json_encode($licencias->Tipo_edad->DisplayValueSeparator) : $licencias->Tipo_edad->DisplayValueSeparator) ?>" name="x_Tipo_edad" id="x_Tipo_edad" value="{value}"<?php echo $licencias->Tipo_edad->EditAttributes() ?>></div>
<div id="dsl_x_Tipo_edad" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php
$arwrk = $licencias->Tipo_edad->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($licencias->Tipo_edad->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked" : "";
		if ($selwrk <> "") {
			$emptywrk = FALSE;
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Tipo_edad" data-page="1" name="x_Tipo_edad" id="x_Tipo_edad_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $licencias->Tipo_edad->EditAttributes() ?>><?php echo $licencias->Tipo_edad->DisplayValue($arwrk[$rowcntwrk]) ?></label>
<?php
		}
	}
	if ($emptywrk && strval($licencias->Tipo_edad->CurrentValue) <> "") {
?>
<label class="radio-inline"><input type="radio" data-table="licencias" data-field="x_Tipo_edad" data-page="1" name="x_Tipo_edad" id="x_Tipo_edad_<?php echo $rowswrk ?>" value="<?php echo ew_HtmlEncode($licencias->Tipo_edad->CurrentValue) ?>" checked<?php echo $licencias->Tipo_edad->EditAttributes() ?>><?php echo $licencias->Tipo_edad->CurrentValue ?></label>
<?php
    }
}
?>
</div></div>
<?php
$sSqlWrk = "SELECT `Id`, `Tipo_edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_edad`";
$sWhereWrk = "";
$licencias->Tipo_edad->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$licencias->Tipo_edad->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$licencias->Lookup_Selecting($licencias->Tipo_edad, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $licencias->Tipo_edad->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Tipo_edad" id="s_x_Tipo_edad" value="<?php echo $licencias->Tipo_edad->LookupFilterQuery() ?>">
</span>
<?php echo $licencias->Tipo_edad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Nombre_solicitante->Visible) { // Nombre_solicitante ?>
	<div id="r_Nombre_solicitante" class="form-group">
		<label id="elh_licencias_Nombre_solicitante" for="x_Nombre_solicitante" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Nombre_solicitante->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Nombre_solicitante->CellAttributes() ?>>
<span id="el_licencias_Nombre_solicitante">
<input type="text" data-table="licencias" data-field="x_Nombre_solicitante" data-page="1" name="x_Nombre_solicitante" id="x_Nombre_solicitante" size="30" maxlength="70" placeholder="<?php echo ew_HtmlEncode($licencias->Nombre_solicitante->getPlaceHolder()) ?>" value="<?php echo $licencias->Nombre_solicitante->EditValue ?>"<?php echo $licencias->Nombre_solicitante->EditAttributes() ?>>
</span>
<?php echo $licencias->Nombre_solicitante->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Funcionario_expide->Visible) { // Funcionario_expide ?>
	<div id="r_Funcionario_expide" class="form-group">
		<label id="elh_licencias_Funcionario_expide" for="x_Funcionario_expide" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Funcionario_expide->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Funcionario_expide->CellAttributes() ?>>
<span id="el_licencias_Funcionario_expide">
<input type="text" data-table="licencias" data-field="x_Funcionario_expide" data-page="1" name="x_Funcionario_expide" id="x_Funcionario_expide" size="30" maxlength="70" placeholder="<?php echo ew_HtmlEncode($licencias->Funcionario_expide->getPlaceHolder()) ?>" value="<?php echo $licencias->Funcionario_expide->EditValue ?>"<?php echo $licencias->Funcionario_expide->EditAttributes() ?>>
</span>
<?php echo $licencias->Funcionario_expide->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Permiso_inhumar->Visible) { // Permiso_inhumar ?>
	<div id="r_Permiso_inhumar" class="form-group">
		<label id="elh_licencias_Permiso_inhumar" for="x_Permiso_inhumar" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Permiso_inhumar->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Permiso_inhumar->CellAttributes() ?>>
<span id="el_licencias_Permiso_inhumar">
<input type="text" data-table="licencias" data-field="x_Permiso_inhumar" data-page="1" name="x_Permiso_inhumar" id="x_Permiso_inhumar" size="30" maxlength="30" placeholder="<?php echo ew_HtmlEncode($licencias->Permiso_inhumar->getPlaceHolder()) ?>" value="<?php echo $licencias->Permiso_inhumar->EditValue ?>"<?php echo $licencias->Permiso_inhumar->EditAttributes() ?>>
</span>
<?php echo $licencias->Permiso_inhumar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Permiso_cremar->Visible) { // Permiso_cremar ?>
	<div id="r_Permiso_cremar" class="form-group">
		<label id="elh_licencias_Permiso_cremar" for="x_Permiso_cremar" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Permiso_cremar->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Permiso_cremar->CellAttributes() ?>>
<span id="el_licencias_Permiso_cremar">
<input type="text" data-table="licencias" data-field="x_Permiso_cremar" data-page="1" name="x_Permiso_cremar" id="x_Permiso_cremar" size="30" maxlength="30" placeholder="<?php echo ew_HtmlEncode($licencias->Permiso_cremar->getPlaceHolder()) ?>" value="<?php echo $licencias->Permiso_cremar->EditValue ?>"<?php echo $licencias->Permiso_cremar->EditAttributes() ?>>
</span>
<?php echo $licencias->Permiso_cremar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Firma_funcionario->Visible) { // Firma_funcionario ?>
	<div id="r_Firma_funcionario" class="form-group">
		<label id="elh_licencias_Firma_funcionario" for="x_Firma_funcionario" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Firma_funcionario->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Firma_funcionario->CellAttributes() ?>>
<span id="el_licencias_Firma_funcionario">
<textarea data-table="licencias" data-field="x_Firma_funcionario" data-page="1" name="x_Firma_funcionario" id="x_Firma_funcionario" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($licencias->Firma_funcionario->getPlaceHolder()) ?>"<?php echo $licencias->Firma_funcionario->EditAttributes() ?>><?php echo $licencias->Firma_funcionario->EditValue ?></textarea>
</span>
<?php echo $licencias->Firma_funcionario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Codigo_qr->Visible) { // Codigo_qr ?>
	<div id="r_Codigo_qr" class="form-group">
		<label id="elh_licencias_Codigo_qr" for="x_Codigo_qr" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Codigo_qr->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Codigo_qr->CellAttributes() ?>>
<span id="el_licencias_Codigo_qr">
<input type="text" data-table="licencias" data-field="x_Codigo_qr" data-page="1" name="x_Codigo_qr" id="x_Codigo_qr" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($licencias->Codigo_qr->getPlaceHolder()) ?>" value="<?php echo $licencias->Codigo_qr->EditValue ?>"<?php echo $licencias->Codigo_qr->EditAttributes() ?>>
</span>
<?php echo $licencias->Codigo_qr->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Verificacion_codigo_qr->Visible) { // Verificacion_codigo_qr ?>
	<div id="r_Verificacion_codigo_qr" class="form-group">
		<label id="elh_licencias_Verificacion_codigo_qr" for="x_Verificacion_codigo_qr" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Verificacion_codigo_qr->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Verificacion_codigo_qr->CellAttributes() ?>>
<span id="el_licencias_Verificacion_codigo_qr">
<input type="text" data-table="licencias" data-field="x_Verificacion_codigo_qr" data-page="1" name="x_Verificacion_codigo_qr" id="x_Verificacion_codigo_qr" size="70" maxlength="120" placeholder="<?php echo ew_HtmlEncode($licencias->Verificacion_codigo_qr->getPlaceHolder()) ?>" value="<?php echo $licencias->Verificacion_codigo_qr->EditValue ?>"<?php echo $licencias->Verificacion_codigo_qr->EditAttributes() ?>>
</span>
<?php echo $licencias->Verificacion_codigo_qr->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Mensaje_manual->Visible) { // Mensaje_manual ?>
	<div id="r_Mensaje_manual" class="form-group">
		<label id="elh_licencias_Mensaje_manual" for="x_Mensaje_manual" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Mensaje_manual->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Mensaje_manual->CellAttributes() ?>>
<span id="el_licencias_Mensaje_manual">
<input type="text" data-table="licencias" data-field="x_Mensaje_manual" data-page="1" name="x_Mensaje_manual" id="x_Mensaje_manual" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($licencias->Mensaje_manual->getPlaceHolder()) ?>" value="<?php echo $licencias->Mensaje_manual->EditValue ?>"<?php echo $licencias->Mensaje_manual->EditAttributes() ?>>
</span>
<?php echo $licencias->Mensaje_manual->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->observaciones->Visible) { // observaciones ?>
	<div id="r_observaciones" class="form-group">
		<label id="elh_licencias_observaciones" for="x_observaciones" class="col-sm-2 control-label ewLabel"><?php echo $licencias->observaciones->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->observaciones->CellAttributes() ?>>
<span id="el_licencias_observaciones">
<input type="text" data-table="licencias" data-field="x_observaciones" data-page="1" name="x_observaciones" id="x_observaciones" size="70" maxlength="80" placeholder="<?php echo ew_HtmlEncode($licencias->observaciones->getPlaceHolder()) ?>" value="<?php echo $licencias->observaciones->EditValue ?>"<?php echo $licencias->observaciones->EditAttributes() ?>>
</span>
<?php echo $licencias->observaciones->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div>
		</div>
		<div class="tab-pane<?php echo $licencias_add->MultiPages->PageStyle("2") ?>" id="tab_licencias2">
<div>
<?php if ($licencias->Logo->Visible) { // Logo ?>
	<div id="r_Logo" class="form-group">
		<label id="elh_licencias_Logo" for="x_Logo" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Logo->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Logo->CellAttributes() ?>>
<span id="el_licencias_Logo">
<textarea data-table="licencias" data-field="x_Logo" data-page="2" name="x_Logo" id="x_Logo" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($licencias->Logo->getPlaceHolder()) ?>"<?php echo $licencias->Logo->EditAttributes() ?>><?php echo $licencias->Logo->EditValue ?></textarea>
</span>
<?php echo $licencias->Logo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Dpto_expedicion->Visible) { // Dpto_expedicion ?>
	<div id="r_Dpto_expedicion" class="form-group">
		<label id="elh_licencias_Dpto_expedicion" for="x_Dpto_expedicion" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Dpto_expedicion->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Dpto_expedicion->CellAttributes() ?>>
<span id="el_licencias_Dpto_expedicion">
<input type="text" data-table="licencias" data-field="x_Dpto_expedicion" data-page="2" name="x_Dpto_expedicion" id="x_Dpto_expedicion" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($licencias->Dpto_expedicion->getPlaceHolder()) ?>" value="<?php echo $licencias->Dpto_expedicion->EditValue ?>"<?php echo $licencias->Dpto_expedicion->EditAttributes() ?>>
</span>
<?php echo $licencias->Dpto_expedicion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($licencias->Mun_expedicion->Visible) { // Mun_expedicion ?>
	<div id="r_Mun_expedicion" class="form-group">
		<label id="elh_licencias_Mun_expedicion" for="x_Mun_expedicion" class="col-sm-2 control-label ewLabel"><?php echo $licencias->Mun_expedicion->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $licencias->Mun_expedicion->CellAttributes() ?>>
<span id="el_licencias_Mun_expedicion">
<input type="text" data-table="licencias" data-field="x_Mun_expedicion" data-page="2" name="x_Mun_expedicion" id="x_Mun_expedicion" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($licencias->Mun_expedicion->getPlaceHolder()) ?>" value="<?php echo $licencias->Mun_expedicion->EditValue ?>"<?php echo $licencias->Mun_expedicion->EditAttributes() ?>>
</span>
<?php echo $licencias->Mun_expedicion->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div>
		</div>
	</div>
</div>
</div>
<div class="form-group">
	<div class="col-sm-offset-2 col-sm-10">
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $licencias_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div>
</div>
</form>
<script type="text/javascript">
flicenciasadd.Init();
</script>
<?php
$licencias_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$licencias_add->Page_Terminate();
?>
